import mill.api.BuildCtx
import mill.testkit.UtestIntegrationTestSuite
import utest.*

object BuildClasspathContentsTests extends UtestIntegrationTestSuite {

  val tests: Tests = Tests {
    test("test") - integrationTest { tester =>
      val result1 =
        tester.eval(("--meta-level", "1", "show", "compileClasspath"), stderr = os.Inherit)
      val deserialized = upickle.read[Seq[mill.api.PathRef]](result1.out)
      val millPublishedJars = deserialized
        .map(_.path.last)
        .filter(_.startsWith("mill-"))
        .filter(!_.startsWith("mill-moduledefs")) // external versioned dependency
        .sorted
      val millLocalClasspath = deserialized
        .flatMap { p =>
          lazy val sub = p.path.subRelativeTo(BuildCtx.workspaceRoot)
          Option.when(
            p.path.startsWith(BuildCtx.workspaceRoot) &&
              !sub.startsWith("out/integration") &&
              !sub.startsWith("out/dist/localRepo.dest")
          ) {
            sub.toString()
          }
        }
        .sorted

      if (sys.env("MILL_INTEGRATION_IS_PACKAGED_LAUNCHER") == "true") {
        assertGoldenLiteral(
          millPublishedJars,
          List(
            "mill-core-api-daemon_3-SNAPSHOT.jar",
            "mill-core-api-java11_3-SNAPSHOT.jar",
            "mill-core-api_3-SNAPSHOT.jar",
            "mill-core-constants-SNAPSHOT.jar",
            "mill-libs-androidlib-databinding_3-SNAPSHOT.jar",
            "mill-libs-androidlib_3-SNAPSHOT.jar",
            "mill-libs-daemon-client_3-SNAPSHOT.jar",
            "mill-libs-daemon-server_3-SNAPSHOT.jar",
            "mill-libs-groovylib-api_3-SNAPSHOT.jar",
            "mill-libs-groovylib_3-SNAPSHOT.jar",
            "mill-libs-javalib-api_3-SNAPSHOT.jar",
            "mill-libs-javalib-testrunner-entrypoint-SNAPSHOT.jar",
            "mill-libs-javalib-testrunner_3-SNAPSHOT.jar",
            "mill-libs-javalib_3-SNAPSHOT.jar",
            "mill-libs-javascriptlib_3-SNAPSHOT.jar",
            "mill-libs-kotlinlib-api_3-SNAPSHOT.jar",
            "mill-libs-kotlinlib-ksp2-api_3-SNAPSHOT.jar",
            "mill-libs-kotlinlib_3-SNAPSHOT.jar",
            "mill-libs-pythonlib_3-SNAPSHOT.jar",
            "mill-libs-rpc_3-SNAPSHOT.jar",
            "mill-libs-scalajslib-api_3-SNAPSHOT.jar",
            "mill-libs-scalajslib_3-SNAPSHOT.jar",
            "mill-libs-scalalib_3-SNAPSHOT.jar",
            "mill-libs-scalanativelib-api_3-SNAPSHOT.jar",
            "mill-libs-scalanativelib_3-SNAPSHOT.jar",
            "mill-libs-script_3-SNAPSHOT.jar",
            "mill-libs-util-java11_3-SNAPSHOT.jar",
            "mill-libs-util_3-SNAPSHOT.jar",
            "mill-libs_3-SNAPSHOT.jar",
            "mill-runner-autooverride-api_3-SNAPSHOT.jar"
          )
        )
        assert(millLocalClasspath == Nil)
      } else {
        sys.error("This test must be run in `packaged` mode, not `local`")
      }
    }
  }
}
