#!/bin/bash

# CodeLin UI 功能验证脚本
# 非交互式验证UI改造功能

echo "════════════════════════════════════════════════════════════════"
echo "  CodeLin UI 功能验证 - 非交互式测试"
echo "════════════════════════════════════════════════════════════════"
echo ""

# 检查编译状态
echo "📋 1. 编译状态检查"
if cjpm build > /dev/null 2>&1; then
    echo "   ✅ 编译成功"
else
    echo "   ❌ 编译失败"
    exit 1
fi

# 检查UI相关文件
echo ""
echo "📋 2. UI组件文件检查"
FILES=(
    "src/io/status_bar.cj"
    "src/io/subagent_viewer.cj"
    "src/io/streaming_output.cj"
    "src/io/keyboard_handler.cj"
    "src/telemetry/performance_metrics.cj"
    "src/telemetry/execution_timeline.cj"
    "src/core/context/components/context_engine_v2.cj"
    "src/core/context/components/file_manager.cj"
    "src/core/context/components/token_manager.cj"
    "src/core/context/components/cache_manager.cj"
)

for file in "${FILES[@]}"; do
    if [ -f "$file" ]; then
        lines=$(wc -l < "$file" 2>/dev/null || echo "0")
        echo "   ✅ $file ($lines lines)"
    else
        echo "   ❌ $file (缺失)"
    fi
done

# 检查关键功能实现
echo ""
echo "📋 3. 关键功能实现检查"
grep -q "class StatusBar" src/io/status_bar.cj && echo "   ✅ StatusBar 类存在" || echo "   ❌ StatusBar 类缺失"
grep -q "class SubAgentViewer" src/io/subagent_viewer.cj && echo "   ✅ SubAgentViewer 类存在" || echo "   ❌ SubAgentViewer 类缺失"
grep -q "class PerformanceMetrics" src/telemetry/performance_metrics.cj && echo "   ✅ PerformanceMetrics 类存在" || echo "   ❌ PerformanceMetrics 类缺失"
grep -q "class ExecutionTimeline" src/telemetry/execution_timeline.cj && echo "   ✅ ExecutionTimeline 类存在" || echo "   ❌ ExecutionTimeline 类缺失"
grep -q "class ContextEngineV2" src/core/context/components/context_engine_v2.cj && echo "   ✅ ContextEngineV2 类存在" || echo "   ❌ ContextEngineV2 类缺失"

# 检查UI功能集成
echo ""
echo "📋 4. UI功能集成检查"
grep -q "statusBar" src/app/cli_app.cj && echo "   ✅ StatusBar 已集成到 CliApp" || echo "   ❌ StatusBar 未集成"
grep -q "subAgentViewer" src/app/cli_app.cj && echo "   ✅ SubAgentViewer 已集成到 CliApp" || echo "   ❌ SubAgentViewer 未集成"
grep -q "performanceMetrics" src/app/cli_app.cj && echo "   ✅ PerformanceMetrics 已集成到 CliApp" || echo "   ❌ PerformanceMetrics 未集成"
grep -q "executionTimeline" src/app/cli_app.cj && echo "   ✅ ExecutionTimeline 已集成到 CliApp" || echo "   ❌ ExecutionTimeline 未集成"
grep -q "renderExecutionSnapshot" src/app/cli_app.cj && echo "   ✅ renderExecutionSnapshot 方法存在" || echo "   ❌ renderExecutionSnapshot 方法缺失"

# 检查components模块
echo ""
echo "📋 5. Components模块检查"
grep -q "package codelin.core.context.components" src/core/context/components/context_engine_v2.cj && echo "   ✅ context_engine_v2.cj 包声明正确" || echo "   ❌ context_engine_v2.cj 包声明错误"
grep -q "package codelin.core.context.components" src/core/context/components/file_manager.cj && echo "   ✅ file_manager.cj 包声明正确" || echo "   ❌ file_manager.cj 包声明错误"
grep -q "package codelin.core.context.components" src/core/context/components/token_manager.cj && echo "   ✅ token_manager.cj 包声明正确" || echo "   ❌ token_manager.cj 包声明错误"
grep -q "package codelin.core.context.components" src/core/context/components/cache_manager.cj && echo "   ✅ cache_manager.cj 包声明正确" || echo "   ❌ cache_manager.cj 包声明错误"

# 检查循环依赖修复
echo ""
echo "📋 6. 循环依赖修复检查"
if grep -q "import codelin.core.context.components" src/core/context/components/context_engine_v2.cj; then
    echo "   ⚠️  发现同包导入（可能导致循环依赖）"
else
    echo "   ✅ 无同包导入（循环依赖已修复）"
fi

echo ""
echo "════════════════════════════════════════════════════════════════"
echo "  ✅ UI功能验证完成"
echo "════════════════════════════════════════════════════════════════"

