#!/bin/bash
# Test script for Claude Code -r implementation
# Testing interactive session selector

echo "═══════════════════════════════════════════════════════════"
echo "  🧪 Testing Claude Code -r Implementation"
echo "═══════════════════════════════════════════════════════════"
echo ""

# Ensure we're in the right directory
cd "$(dirname "$0")"

# Check if there are existing sessions
SESSIONS_DIR=".codelin/sessions"
echo "📂 Checking existing sessions..."
if [ -d "$SESSIONS_DIR" ]; then
    SESSION_COUNT=$(ls -1 "$SESSIONS_DIR"/*.json 2>/dev/null | wc -l | tr -d ' ')
    echo "   Found $SESSION_COUNT session(s)"
else
    echo "   No sessions directory found"
    SESSION_COUNT=0
fi
echo ""

# Test Case 1: Run with -r short parameter
echo "═══════════════════════════════════════════════════════════"
echo "  Test Case 1: Short parameter -r"
echo "═══════════════════════════════════════════════════════════"
echo ""
echo "Command: cjpm run --name cli -- -r"
echo ""
echo "Expected behavior:"
if [ "$SESSION_COUNT" -gt 0 ]; then
    echo "  ✓ Display interactive session selector table"
    echo "  ✓ Show $SESSION_COUNT session(s)"
    echo "  ✓ Allow arrow key/jk navigation"
    echo "  ✓ Highlight selected row"
    echo "  ✓ Enter to select, Esc/q to cancel"
else
    echo "  ✓ Display 'No previous sessions found'"
    echo "  ✓ Start new session automatically"
fi
echo ""
echo "Press Enter to run test, or Ctrl+C to cancel..."
read -r

cjpm run --name cli -- -r

echo ""
echo "═══════════════════════════════════════════════════════════"
echo "  Test Case 1 Complete"
echo "═══════════════════════════════════════════════════════════"
echo ""

# Test Case 2: Run with --resume long parameter
echo "═══════════════════════════════════════════════════════════"
echo "  Test Case 2: Long parameter --resume"
echo "═══════════════════════════════════════════════════════════"
echo ""
echo "Command: cjpm run --name cli -- --resume"
echo ""
echo "Expected behavior: Same as Test Case 1"
echo ""
echo "Press Enter to run test, or Ctrl+C to cancel..."
read -r

cjpm run --name cli -- --resume

echo ""
echo "═══════════════════════════════════════════════════════════"
echo "  Test Case 2 Complete"
echo "═══════════════════════════════════════════════════════════"
echo ""

# Summary
echo "═══════════════════════════════════════════════════════════"
echo "  ✅ All Tests Complete"
echo "═══════════════════════════════════════════════════════════"
echo ""
echo "Manual verification checklist:"
echo ""
echo "  UI Display:"
echo "    [ ] Table header displayed correctly"
echo "    [ ] Session rows aligned properly"
echo "    [ ] Footer instructions shown"
echo ""
echo "  Navigation:"
echo "    [ ] ↑ key moves selection up"
echo "    [ ] ↓ key moves selection down"
echo "    [ ] j key moves selection down (vim style)"
echo "    [ ] k key moves selection up (vim style)"
echo "    [ ] Selection wraps around (optional)"
echo ""
echo "  Interaction:"
echo "    [ ] Enter selects the session"
echo "    [ ] Esc cancels and starts new session"
echo "    [ ] q cancels and starts new session"
echo "    [ ] Selected row is highlighted"
echo ""
echo "  Edge Cases:"
echo "    [ ] Works with 0 sessions"
echo "    [ ] Works with 1 session"
echo "    [ ] Works with many sessions"
echo "    [ ] Screen clears properly"
echo "    [ ] Redraws on navigation"
echo ""
echo "═══════════════════════════════════════════════════════════"

