#!/bin/bash

# 测试 Phase 5 命令是否出现在帮助中

echo "========================================="
echo "Testing Phase 5 Commands in Help"
echo "========================================="
echo ""

# 测试 /help 命令输出
echo "/help" | timeout 10 cjpm run --name cli 2>&1 > /tmp/help_output.txt

echo "Checking for Phase 5 commands in help output..."
echo ""

# 检查每个命令
commands=("/new" "/sessions" "/switch" "/rename")

for cmd in "${commands[@]}"; do
    if grep -q "$cmd" /tmp/help_output.txt; then
        echo "✅ Found: $cmd"
    else
        echo "❌ Missing: $cmd"
    fi
done

echo ""
echo "========================================="
echo "Full Help Output:"
echo "========================================="
cat /tmp/help_output.txt | grep -A 50 "Codelin Commands" | head -60

echo ""
echo "========================================="
echo "Testing /new command"
echo "========================================="
echo "/new" | timeout 5 cjpm run --name cli 2>&1 | tail -20

rm -f /tmp/help_output.txt

