#!/bin/bash

# Phase 5 Session System Testing Script
# Tests all P0.1-P0.4 features

set -e

echo "========================================="
echo "Phase 5 Session System Testing"
echo "========================================="
echo ""

# Colors
GREEN='\033[0;32m'
BLUE='\033[0;34m'
YELLOW='\033[1;33m'
RED='\033[0;31m'
NC='\033[0m' # No Color

# Test counter
TESTS_PASSED=0
TESTS_FAILED=0

# Function to run test
run_test() {
    local test_name="$1"
    local commands="$2"
    
    echo -e "${BLUE}Testing: ${test_name}${NC}"
    echo "$commands" | timeout 60 cjpm run --name cli -- --non-interactive > /tmp/phase5_test_output.log 2>&1 || true
    
    # Check if output was generated
    if [ -s /tmp/phase5_test_output.log ]; then
        echo -e "${GREEN}✓ Test completed${NC}"
        TESTS_PASSED=$((TESTS_PASSED + 1))
    else
        echo -e "${RED}✗ Test failed - no output${NC}"
        TESTS_FAILED=$((TESTS_FAILED + 1))
    fi
    echo ""
}

echo "========================================="
echo "Test 1: Check if Session System is integrated"
echo "========================================="

# Check if session files exist
echo "Checking source files..."
if [ -f "src/core/conversation/session_metadata.cj" ]; then
    echo -e "${GREEN}✓ session_metadata.cj exists${NC}"
    TESTS_PASSED=$((TESTS_PASSED + 1))
else
    echo -e "${RED}✗ session_metadata.cj missing${NC}"
    TESTS_FAILED=$((TESTS_FAILED + 1))
fi

if [ -f "src/core/conversation/session_auto_namer.cj" ]; then
    echo -e "${GREEN}✓ session_auto_namer.cj exists${NC}"
    TESTS_PASSED=$((TESTS_PASSED + 1))
else
    echo -e "${RED}✗ session_auto_namer.cj missing${NC}"
    TESTS_FAILED=$((TESTS_FAILED + 1))
fi

echo ""
echo "========================================="
echo "Test 2: Verify Session Metadata Classes"
echo "========================================="

# Check for key classes in session_metadata.cj
if grep -q "class SessionMetadata" src/core/conversation/session_metadata.cj; then
    echo -e "${GREEN}✓ SessionMetadata class found${NC}"
    TESTS_PASSED=$((TESTS_PASSED + 1))
else
    echo -e "${RED}✗ SessionMetadata class not found${NC}"
    TESTS_FAILED=$((TESTS_FAILED + 1))
fi

if grep -q "class SessionMetadataManager" src/core/conversation/session_metadata.cj; then
    echo -e "${GREEN}✓ SessionMetadataManager class found${NC}"
    TESTS_PASSED=$((TESTS_PASSED + 1))
else
    echo -e "${RED}✗ SessionMetadataManager class not found${NC}"
    TESTS_FAILED=$((TESTS_FAILED + 1))
fi

echo ""
echo "========================================="
echo "Test 3: Verify Session Commands"
echo "========================================="

# Check for new session methods in ConversationManager
if grep -q "func newSession" src/core/conversation/conversation_manager.cj; then
    echo -e "${GREEN}✓ newSession() method found${NC}"
    TESTS_PASSED=$((TESTS_PASSED + 1))
else
    echo -e "${RED}✗ newSession() method not found${NC}"
    TESTS_FAILED=$((TESTS_FAILED + 1))
fi

if grep -q "func switchSession" src/core/conversation/conversation_manager.cj; then
    echo -e "${GREEN}✓ switchSession() method found${NC}"
    TESTS_PASSED=$((TESTS_PASSED + 1))
else
    echo -e "${RED}✗ switchSession() method not found${NC}"
    TESTS_FAILED=$((TESTS_FAILED + 1))
fi

if grep -q "func listSessionsDetailed" src/core/conversation/conversation_manager.cj; then
    echo -e "${GREEN}✓ listSessionsDetailed() method found${NC}"
    TESTS_PASSED=$((TESTS_PASSED + 1))
else
    echo -e "${RED}✗ listSessionsDetailed() method not found${NC}"
    TESTS_FAILED=$((TESTS_FAILED + 1))
fi

if grep -q "func renameSession" src/core/conversation/conversation_manager.cj; then
    echo -e "${GREEN}✓ renameSession() method found${NC}"
    TESTS_PASSED=$((TESTS_PASSED + 1))
else
    echo -e "${RED}✗ renameSession() method not found${NC}"
    TESTS_FAILED=$((TESTS_FAILED + 1))
fi

echo ""
echo "========================================="
echo "Test 4: Verify Auto-naming System"
echo "========================================="

if grep -q "class SessionAutoNamer" src/core/conversation/session_auto_namer.cj; then
    echo -e "${GREEN}✓ SessionAutoNamer class found${NC}"
    TESTS_PASSED=$((TESTS_PASSED + 1))
else
    echo -e "${RED}✗ SessionAutoNamer class not found${NC}"
    TESTS_FAILED=$((TESTS_FAILED + 1))
fi

if grep -q "func generateFromFirstExchange" src/core/conversation/session_auto_namer.cj; then
    echo -e "${GREEN}✓ generateFromFirstExchange() method found${NC}"
    TESTS_PASSED=$((TESTS_PASSED + 1))
else
    echo -e "${RED}✗ generateFromFirstExchange() method not found${NC}"
    TESTS_FAILED=$((TESTS_FAILED + 1))
fi

if grep -q "func autoGenerateTitleIfNeeded" src/core/conversation/conversation_manager.cj; then
    echo -e "${GREEN}✓ autoGenerateTitleIfNeeded() integration found${NC}"
    TESTS_PASSED=$((TESTS_PASSED + 1))
else
    echo -e "${RED}✗ autoGenerateTitleIfNeeded() integration not found${NC}"
    TESTS_FAILED=$((TESTS_FAILED + 1))
fi

echo ""
echo "========================================="
echo "Test 5: Verify Session Indicator"
echo "========================================="

if grep -q "func buildPrompt.*sessionTitle" src/io/input_utils.cj; then
    echo -e "${GREEN}✓ buildPrompt with sessionTitle found${NC}"
    TESTS_PASSED=$((TESTS_PASSED + 1))
else
    echo -e "${RED}✗ buildPrompt with sessionTitle not found${NC}"
    TESTS_FAILED=$((TESTS_FAILED + 1))
fi

if grep -q "func getCurrentSessionTitle" src/core/conversation/conversation_manager.cj; then
    echo -e "${GREEN}✓ getCurrentSessionTitle() method found${NC}"
    TESTS_PASSED=$((TESTS_PASSED + 1))
else
    echo -e "${RED}✗ getCurrentSessionTitle() method not found${NC}"
    TESTS_FAILED=$((TESTS_FAILED + 1))
fi

echo ""
echo "========================================="
echo "Test 6: Verify Command Routing"
echo "========================================="

if grep -q '"/new"' src/app/process_input.cj; then
    echo -e "${GREEN}✓ /new command routing found${NC}"
    TESTS_PASSED=$((TESTS_PASSED + 1))
else
    echo -e "${RED}✗ /new command routing not found${NC}"
    TESTS_FAILED=$((TESTS_FAILED + 1))
fi

if grep -q '"/sessions"' src/app/process_input.cj; then
    echo -e "${GREEN}✓ /sessions command routing found${NC}"
    TESTS_PASSED=$((TESTS_PASSED + 1))
else
    echo -e "${RED}✗ /sessions command routing not found${NC}"
    TESTS_FAILED=$((TESTS_FAILED + 1))
fi

if grep -q '"/switch"' src/app/process_input.cj; then
    echo -e "${GREEN}✓ /switch command routing found${NC}"
    TESTS_PASSED=$((TESTS_PASSED + 1))
else
    echo -e "${RED}✗ /switch command routing not found${NC}"
    TESTS_FAILED=$((TESTS_FAILED + 1))
fi

if grep -q '"/rename"' src/app/process_input.cj; then
    echo -e "${GREEN}✓ /rename command routing found${NC}"
    TESTS_PASSED=$((TESTS_PASSED + 1))
else
    echo -e "${RED}✗ /rename command routing not found${NC}"
    TESTS_FAILED=$((TESTS_FAILED + 1))
fi

echo ""
echo "========================================="
echo "Test 7: Check @jsonable Integration"
echo "========================================="

if grep -q "@jsonable" src/core/conversation/session_metadata.cj; then
    echo -e "${GREEN}✓ @jsonable annotation found${NC}"
    TESTS_PASSED=$((TESTS_PASSED + 1))
else
    echo -e "${RED}✗ @jsonable annotation not found${NC}"
    TESTS_FAILED=$((TESTS_FAILED + 1))
fi

echo ""
echo "========================================="
echo "Test 8: Check AI DSL Integration"
echo "========================================="

if grep -q "@ai" src/core/conversation/session_auto_namer.cj; then
    echo -e "${GREEN}✓ @ai annotation found${NC}"
    TESTS_PASSED=$((TESTS_PASSED + 1))
else
    echo -e "${RED}✗ @ai annotation not found${NC}"
    TESTS_FAILED=$((TESTS_FAILED + 1))
fi

echo ""
echo "========================================="
echo "Test 9: Verify CLI App Integration"
echo "========================================="

if grep -q "getCurrentSessionTitle" src/app/cli_app.cj; then
    echo -e "${GREEN}✓ Session title integration in CLI app found${NC}"
    TESTS_PASSED=$((TESTS_PASSED + 1))
else
    echo -e "${RED}✗ Session title integration in CLI app not found${NC}"
    TESTS_FAILED=$((TESTS_FAILED + 1))
fi

echo ""
echo "========================================="
echo "Test 10: Check Help Text"
echo "========================================="

if grep -q "Claude Code Style Commands" src/core/conversation/conversation_manager.cj; then
    echo -e "${GREEN}✓ Phase 5 help text found${NC}"
    TESTS_PASSED=$((TESTS_PASSED + 1))
else
    echo -e "${RED}✗ Phase 5 help text not found${NC}"
    TESTS_FAILED=$((TESTS_FAILED + 1))
fi

echo ""
echo "========================================="
echo "Test Summary"
echo "========================================="
echo -e "${GREEN}Tests Passed: ${TESTS_PASSED}${NC}"
echo -e "${RED}Tests Failed: ${TESTS_FAILED}${NC}"
echo ""

if [ $TESTS_FAILED -eq 0 ]; then
    echo -e "${GREEN}========================================="
    echo "✓ All Phase 5 Features Verified!"
    echo "=========================================${NC}"
    exit 0
else
    echo -e "${RED}========================================="
    echo "✗ Some tests failed"
    echo "=========================================${NC}"
    exit 1
fi

