#!/bin/bash

# Test script for P1-2: Mode System Implementation
# Verifies that Mode system is integrated into agent prompts

# No set -e here to allow all tests to run even if one fails

echo "=========================================="
echo "Testing P1-2: Mode System"
echo "=========================================="
echo ""

# Colors
GREEN='\033[0;32m'
RED='\033[0;31m'
YELLOW='\033[1;33m'
NC='\033[0m'

PASSED=0
FAILED=0

test_check() {
    if [ $? -eq 0 ]; then
        echo -e "${GREEN}✓${NC} $1"
        ((PASSED++))
    else
        echo -e "${RED}✗${NC} $1"
        ((FAILED++))
    fi
}

# Test 1: Check Mode System section in General Agent
echo -e "${YELLOW}Test 1: Mode System section in General Agent...${NC}"
if grep -q "🎭 Agent Execution Modes" src/core/agents/general_code_agent.cj; then
    test_check "Mode System section in General Agent"
else
    echo -e "${RED}✗${NC} Mode System section in General Agent"
    ((FAILED++))
fi

# Test 2: Check Fast Mode in General Agent
echo -e "${YELLOW}Test 2: Fast Mode in General Agent...${NC}"
if grep -q "🚀 Fast Mode" src/core/agents/general_code_agent.cj && \
   grep -q "Speed > Quality" src/core/agents/general_code_agent.cj; then
    test_check "Fast Mode in General Agent"
else
    echo -e "${RED}✗${NC} Fast Mode in General Agent"
    ((FAILED++))
fi

# Test 3: Check Default Mode in General Agent
echo -e "${YELLOW}Test 3: Default Mode in General Agent...${NC}"
if grep -q "⚙️ Default Mode" src/core/agents/general_code_agent.cj && \
   grep -q "Balanced quality and speed" src/core/agents/general_code_agent.cj; then
    test_check "Default Mode in General Agent"
else
    echo -e "${RED}✗${NC} Default Mode in General Agent"
    ((FAILED++))
fi

# Test 4: Check Max Mode in General Agent
echo -e "${YELLOW}Test 4: Max Mode in General Agent...${NC}"
if grep -q "💎 Max Mode" src/core/agents/general_code_agent.cj && \
   grep -q "Maximum Quality > Speed" src/core/agents/general_code_agent.cj; then
    test_check "Max Mode in General Agent"
else
    echo -e "${RED}✗${NC} Max Mode in General Agent"
    ((FAILED++))
fi

# Test 5: Check Mode Selection Guidelines in General Agent
echo -e "${YELLOW}Test 5: Mode Selection Guidelines in General Agent...${NC}"
if grep -q "Mode Selection Guidelines" src/core/agents/general_code_agent.cj; then
    test_check "Mode Selection Guidelines in General Agent"
else
    echo -e "${RED}✗${NC} Mode Selection Guidelines in General Agent"
    ((FAILED++))
fi

# Test 6: Check Mode System in Cangjie Agent
echo -e "${YELLOW}Test 6: Mode System section in Cangjie Agent...${NC}"
if grep -q "🎭 Agent Execution Modes" src/core/agents/cangjie_code_agent.cj; then
    test_check "Mode System section in Cangjie Agent"
else
    echo -e "${RED}✗${NC} Mode System section in Cangjie Agent"
    ((FAILED++))
fi

# Test 7: Check all three modes in Cangjie Agent
echo -e "${YELLOW}Test 7: All three modes in Cangjie Agent...${NC}"
if grep -q "🚀 Fast Mode" src/core/agents/cangjie_code_agent.cj && \
   grep -q "⚙️ Default Mode" src/core/agents/cangjie_code_agent.cj && \
   grep -q "💎 Max Mode" src/core/agents/cangjie_code_agent.cj; then
    test_check "All three modes in Cangjie Agent"
else
    echo -e "${RED}✗${NC} All three modes in Cangjie Agent"
    ((FAILED++))
fi

# Test 8: Check mode characteristics (Fast Mode)
echo -e "${YELLOW}Test 8: Fast Mode characteristics...${NC}"
if grep -q "Skip review SubAgents" src/core/agents/general_code_agent.cj && \
   grep -q "Skip test-generation SubAgents" src/core/agents/general_code_agent.cj; then
    test_check "Fast Mode characteristics"
else
    echo -e "${RED}✗${NC} Fast Mode characteristics"
    ((FAILED++))
fi

# Test 9: Check mode characteristics (Max Mode)
echo -e "${YELLOW}Test 9: Max Mode characteristics...${NC}"
if grep -q "Multiple review passes" src/core/agents/general_code_agent.cj && \
   grep -q "Comprehensive test coverage" src/core/agents/general_code_agent.cj; then
    test_check "Max Mode characteristics"
else
    echo -e "${RED}✗${NC} Max Mode characteristics"
    ((FAILED++))
fi

# Test 10: Check CLI config stores agent mode
echo -e "${YELLOW}Test 10: CliConfig stores agent mode...${NC}"
if grep -q "agentMode: AgentMode" src/core/config/cli_config.cj; then
    test_check "CliConfig stores agent mode"
else
    echo -e "${RED}✗${NC} CliConfig stores agent mode"
    ((FAILED++))
fi

# Test 11: Check parse_args supports --mode parameter
echo -e "${YELLOW}Test 11: parse_args supports --mode...${NC}"
if grep -q -- "--mode" src/parse_args.cj && \
   grep -q "AgentMode.Fast" src/parse_args.cj; then
    test_check "parse_args supports --mode"
else
    echo -e "${RED}✗${NC} parse_args supports --mode"
    ((FAILED++))
fi

# Test 12: Check CliApp and main wire mode through to agents
echo -e "${YELLOW}Test 12: Mode propagated through CLI...${NC}"
if grep -q "CodeLinAgent(agentMode)" src/app/cli_app.cj && \
   grep -q "CliApp(CliConfig.agentMode)" src/main.cj; then
    test_check "Mode propagated through CLI"
else
    echo -e "${RED}✗${NC} Mode propagated through CLI"
    ((FAILED++))
fi

# Test 13: Check shouldUseSubAgent helper exists
echo -e "${YELLOW}Test 13: shouldUseSubAgent helper...${NC}"
if grep -q "shouldUseSubAgent" src/core/agents/general_code_agent.cj; then
    test_check "shouldUseSubAgent helper present"
else
    echo -e "${RED}✗${NC} shouldUseSubAgent helper missing"
    ((FAILED++))
fi

# Test 14: Check mode-aware subagent registration in CliApp
echo -e "${YELLOW}Test 14: Mode-aware subagent registration...${NC}"
if grep -q "registerSubAgent" src/app/cli_app.cj && \
   grep -q "modeConfig.useReviewer" src/app/cli_app.cj; then
    test_check "Mode-aware subagent registration"
else
    echo -e "${RED}✗${NC} Mode-aware subagent registration"
    ((FAILED++))
fi

# Test 15: Mode-specific model & temperature preference hook
echo -e "${YELLOW}Test 15: Mode-specific model/temperature preference...${NC}"
if grep -q "applyModePreferences" src/app/cli_app.cj && \
   grep -q "temperatureOverridden" src/core/config/cli_config.cj; then
    test_check "Mode-specific model/temperature preference"
else
    echo -e "${RED}✗${NC} Mode-specific model/temperature preference"
    ((FAILED++))
fi

# Summary
echo ""
echo -e "${YELLOW}=== Summary ===${NC}"
echo ""
echo "Tests Passed: ${PASSED}"
echo "Tests Failed: ${FAILED}"
echo ""

if [ $FAILED -eq 0 ]; then
    echo -e "${GREEN}=========================================="
    echo "All tests passed! ✓"
    echo "==========================================${NC}"
    exit 0
else
    echo -e "${RED}=========================================="
    echo "Some tests failed! ✗"
    echo "==========================================${NC}"
    exit 1
fi

