#!/bin/bash

# Test script for P1-1: Layers Architecture Implementation
# Verifies that Layers architecture is integrated into agent prompts

# No set -e here to allow all tests to run even if one fails

echo "=========================================="
echo "Testing P1-1: Layers Architecture"
echo "=========================================="
echo ""

# Colors
GREEN='\033[0;32m'
RED='\033[0;31m'
YELLOW='\033[1;33m'
NC='\033[0m'

PASSED=0
FAILED=0

test_check() {
    if [ $? -eq 0 ]; then
        echo -e "${GREEN}✓${NC} $1"
        ((PASSED++))
    else
        echo -e "${RED}✗${NC} $1"
        ((FAILED++))
    fi
}

# Test 1: Check Layers Architecture section in General Agent
echo -e "${YELLOW}Test 1: Layers Architecture section in General Agent...${NC}"
if grep -q "🏗️ Layers Architecture" src/core/agents/general_code_agent.cj; then
    test_check "Layers Architecture section in General Agent"
else
    echo -e "${RED}✗${NC} Layers Architecture section in General Agent"
    ((FAILED++))
fi

# Test 2: Check 5 Layers standard flow
echo -e "${YELLOW}Test 2: 5 Layers standard flow in General Agent...${NC}"
if grep -q "Layer 1: Context Gathering" src/core/agents/general_code_agent.cj && \
   grep -q "Layer 2: You Read and Understand" src/core/agents/general_code_agent.cj && \
   grep -q "Layer 3: Planning" src/core/agents/general_code_agent.cj && \
   grep -q "Layer 4: Execution" src/core/agents/general_code_agent.cj && \
   grep -q "Layer 5: Validation" src/core/agents/general_code_agent.cj; then
    test_check "5 Layers standard flow in General Agent"
else
    echo -e "${RED}✗${NC} 5 Layers standard flow in General Agent"
    ((FAILED++))
fi

# Test 3: Check Layer Guidelines (DO/DON'T)
echo -e "${YELLOW}Test 3: Layer Guidelines in General Agent...${NC}"
if grep -q "✅ DO" src/core/agents/general_code_agent.cj && \
   grep -q "❌ DON'T" src/core/agents/general_code_agent.cj; then
    test_check "Layer Guidelines in General Agent"
else
    echo -e "${RED}✗${NC} Layer Guidelines in General Agent"
    ((FAILED++))
fi

# Test 4: Check Example Workflows
echo -e "${YELLOW}Test 4: Example Workflows in General Agent...${NC}"
if grep -q "Simple Task (3 Layers)" src/core/agents/general_code_agent.cj && \
   grep -q "Complex Task (5 Layers)" src/core/agents/general_code_agent.cj; then
    test_check "Example Workflows in General Agent"
else
    echo -e "${RED}✗${NC} Example Workflows in General Agent"
    ((FAILED++))
fi

# Test 5: Check Layers Architecture in Cangjie Agent
echo -e "${YELLOW}Test 5: Layers Architecture section in Cangjie Agent...${NC}"
if grep -q "🏗️ Layers Architecture" src/core/agents/cangjie_code_agent.cj; then
    test_check "Layers Architecture section in Cangjie Agent"
else
    echo -e "${RED}✗${NC} Layers Architecture section in Cangjie Agent"
    ((FAILED++))
fi

# Test 6: Check 5 Layers in Cangjie Agent
echo -e "${YELLOW}Test 6: 5 Layers standard flow in Cangjie Agent...${NC}"
if grep -q "Layer 1: Context Gathering" src/core/agents/cangjie_code_agent.cj && \
   grep -q "Layer 5: Validation" src/core/agents/cangjie_code_agent.cj; then
    test_check "5 Layers standard flow in Cangjie Agent"
else
    echo -e "${RED}✗${NC} 5 Layers standard flow in Cangjie Agent"
    ((FAILED++))
fi

# Test 7: Check parallel execution guidance
echo -e "${YELLOW}Test 7: Parallel execution guidance...${NC}"
if grep -q "PARALLEL" src/core/agents/general_code_agent.cj && \
   grep -q "Spawn independent agents in parallel" src/core/agents/general_code_agent.cj; then
    test_check "Parallel execution guidance"
else
    echo -e "${RED}✗${NC} Parallel execution guidance"
    ((FAILED++))
fi

# Test 8: Check layer sequencing guidance
echo -e "${YELLOW}Test 8: Layer sequencing guidance...${NC}"
if grep -q "Wait for layer to complete before next" src/core/agents/general_code_agent.cj && \
   grep -q "Don't spawn dependent agents in parallel" src/core/agents/general_code_agent.cj; then
    test_check "Layer sequencing guidance"
else
    echo -e "${RED}✗${NC} Layer sequencing guidance"
    ((FAILED++))
fi

# Test 9: Explorer SubAgent output format optimized
echo -e "${YELLOW}Test 9: Explorer SubAgent output format...${NC}"
if grep -q "## Files Found" src/core/agents/subagents/explorer_agent.cj && \
   grep -q "## Recommendations" src/core/agents/subagents/explorer_agent.cj && \
   grep -q "# File Discovery Report" src/core/agents/subagents/explorer_agent.cj; then
    test_check "Explorer SubAgent output format optimized"
else
    echo -e "${RED}✗${NC} Explorer SubAgent output format optimized"
    ((FAILED++))
fi

# Summary
echo ""
echo -e "${YELLOW}=== Summary ===${NC}"
echo ""
echo "Tests Passed: ${PASSED}"
echo "Tests Failed: ${FAILED}"
echo ""

if [ $FAILED -eq 0 ]; then
    echo -e "${GREEN}=========================================="
    echo "All tests passed! ✓"
    echo "==========================================${NC}"
    exit 0
else
    echo -e "${RED}=========================================="
    echo "Some tests failed! ✗"
    echo "==========================================${NC}"
    exit 1
fi

