#!/bin/bash

# Test script for P0-3: Context Pruner Implementation
# Verifies that the enhanced Compactor has the 4-pass compression strategy

set -e

echo "=========================================="
echo "Testing P0-3: Context Pruner Implementation"
echo "=========================================="
echo ""

# Colors
GREEN='\033[0;32m'
RED='\033[0;31m'
YELLOW='\033[1;33m'
NC='\033[0m'

PASSED=0
FAILED=0

test_check() {
    if [ $? -eq 0 ]; then
        echo -e "${GREEN}✓${NC} $1"
        ((PASSED++))
    else
        echo -e "${RED}✗${NC} $1"
        ((FAILED++))
    fi
}

# Test 1: Check file exists
echo -e "${YELLOW}Test 1: Context Compactor file exists...${NC}"
if [ -f "src/core/agents/context_compactor.cj" ]; then
    test_check "Context Compactor file exists"
else
    echo -e "${RED}✗${NC} Context Compactor file exists"
    ((FAILED++))
fi

# Test 2: Check 4-pass strategy in prompt
echo -e "${YELLOW}Test 2: 4-pass compression strategy in prompt...${NC}"
if grep -q "Pass 1:" src/core/agents/context_compactor.cj; then
    test_check "Pass 1: Terminal Command Results found"
else
    echo -e "${RED}✗${NC} Pass 1: Terminal Command Results found"
    ((FAILED++))
fi

if grep -q "Pass 2:" src/core/agents/context_compactor.cj; then
    test_check "Pass 2: File Reads found"
else
    echo -e "${RED}✗${NC} Pass 2: File Reads found"
    ((FAILED++))
fi

if grep -q "Pass 3:" src/core/agents/context_compactor.cj; then
    test_check "Pass 3: Early Conversation found"
else
    echo -e "${RED}✗${NC} Pass 3: Early Conversation found"
    ((FAILED++))
fi

if grep -q "Pass 4:" src/core/agents/context_compactor.cj; then
    test_check "Pass 4: Remove Duplicates found"
else
    echo -e "${RED}✗${NC} Pass 4: Remove Duplicates found"
    ((FAILED++))
fi

# Test 3: Check compression logging
echo -e "${YELLOW}Test 3: Compression logging implemented...${NC}"
if grep -q "ContextPruner" src/core/agents/context_compactor.cj; then
    test_check "Compression logging implemented"
else
    echo -e "${RED}✗${NC} Compression logging implemented"
    ((FAILED++))
fi

if grep -q "saved.*tokens" src/core/agents/context_compactor.cj; then
    test_check "Token savings logging implemented"
else
    echo -e "${RED}✗${NC} Token savings logging implemented"
    ((FAILED++))
fi

# Test 4: Check preservation rules
echo -e "${YELLOW}Test 4: Key information preservation rules...${NC}"
if grep -q "NEVER remove user messages" src/core/agents/context_compactor.cj; then
    test_check "User message preservation rule found"
else
    echo -e "${RED}✗${NC} User message preservation rule found"
    ((FAILED++))
fi

if grep -q "ALWAYS preserve.*errors.*warnings" src/core/agents/context_compactor.cj; then
    test_check "Error/warning preservation rule found"
else
    echo -e "${RED}✗${NC} Error/warning preservation rule found"
    ((FAILED++))
fi

if grep -q "ALWAYS preserve.*file paths" src/core/agents/context_compactor.cj; then
    test_check "File path preservation rule found"
else
    echo -e "${RED}✗${NC} File path preservation rule found"
    ((FAILED++))
fi

# Test 5: Check MAX_TOKENS_AFTER_COMPACT constant
echo -e "${YELLOW}Test 5: Max tokens constant defined...${NC}"
if grep -q "MAX_TOKENS_AFTER_COMPACT" src/core/agents/context_compactor.cj; then
    test_check "MAX_TOKENS_AFTER_COMPACT constant defined"
else
    echo -e "${RED}✗${NC} MAX_TOKENS_AFTER_COMPACT constant defined"
    ((FAILED++))
fi

# Summary
echo ""
echo -e "${YELLOW}=== Summary ===${NC}"
echo ""
echo "Tests Passed: ${PASSED}"
echo "Tests Failed: ${FAILED}"
echo ""

if [ $FAILED -eq 0 ]; then
    echo -e "${GREEN}=========================================="
    echo "All tests passed! ✓"
    echo "==========================================${NC}"
    exit 0
else
    echo -e "${RED}=========================================="
    echo "Some tests failed! ✗"
    echo "==========================================${NC}"
    exit 1
fi

