#!/bin/bash

# CodeLin UI 交互式验证脚本
# 使用echo输入模拟交互式运行

echo "════════════════════════════════════════════════════════════════"
echo "  CodeLin UI 交互式功能验证"
echo "════════════════════════════════════════════════════════════════"
echo ""
echo "📋 验证计划:"
echo "  1. 启动CLI并显示欢迎界面"
echo "  2. 测试/help命令"
echo "  3. 测试简单问答（触发SubAgent和UI功能）"
echo "  4. 测试/exit命令"
echo ""
echo "🚀 开始验证..."
echo "════════════════════════════════════════════════════════════════"
echo ""

# 创建测试输入
cat > /tmp/codelin_ui_test_input.txt << 'EOF'
/help
你好，请简单介绍一下你的功能
/exit
EOF

# 运行测试（10秒超时，使用expect或直接管道）
(
    cat /tmp/codelin_ui_test_input.txt
    sleep 10
) | timeout 15 bash codelin.sh 2>&1 | tee /tmp/codelin_ui_test_output.log || {
    echo ""
    echo "⚠️  测试超时或中断（这是正常的，因为需要等待AI响应）"
    echo ""
}

echo ""
echo "════════════════════════════════════════════════════════════════"
echo "📊 验证结果分析:"
echo "════════════════════════════════════════════════════════════════"
echo ""

LOG_FILE="/tmp/codelin_ui_test_output.log"

# 分析输出
if [ -f "$LOG_FILE" ]; then
    # 1. CLI启动验证
    echo "1️⃣  CLI启动验证:"
    if grep -qi "Codelin\|Welcome\|欢迎" "$LOG_FILE"; then
        echo "   ✅ CLI启动成功"
    else
        echo "   ⚠️  未检测到欢迎信息（可能需要更长时间）"
    fi
    
    # 2. 帮助命令验证
    echo ""
    echo "2️⃣  帮助命令验证:"
    if grep -qi "/help\|命令\|command" "$LOG_FILE"; then
        echo "   ✅ /help命令响应"
    else
        echo "   ⚠️  未检测到帮助信息"
    fi
    
    # 3. UI功能验证
    echo ""
    echo "3️⃣  UI功能验证:"
    if grep -qi "StatusBar\|status\|状态" "$LOG_FILE"; then
        echo "   ✅ 状态栏功能检测到"
    else
        echo "   ⚠️  状态栏输出未检测到（可能在运行时显示）"
    fi
    
    if grep -qi "SubAgent\|Agent\|代理" "$LOG_FILE"; then
        echo "   ✅ SubAgent功能检测到"
    else
        echo "   ⚠️  SubAgent输出未检测到（可能在运行时显示）"
    fi
    
    # 4. 执行过程验证
    echo ""
    echo "4️⃣  执行过程验证:"
    if grep -qi "Execution\|执行\|Timeline\|时间线" "$LOG_FILE"; then
        echo "   ✅ 执行过程信息检测到"
    else
        echo "   ⚠️  执行过程信息未检测到（可能在运行时显示）"
    fi
    
    echo ""
    echo "📁 完整日志: $LOG_FILE"
    echo "   (可以使用 'cat $LOG_FILE' 查看完整输出)"
else
    echo "   ❌ 日志文件未生成"
fi

echo ""
echo "════════════════════════════════════════════════════════════════"
echo "💡 提示:"
echo "  要完整验证UI功能，请手动运行:"
echo "    ./codelin.sh"
echo ""
echo "  然后尝试以下命令:"
echo "    /help              - 查看帮助"
echo "    你好               - 触发SubAgent和UI显示"
echo "    /exit              - 退出"
echo "════════════════════════════════════════════════════════════════"

