# Codelin 构建和安装完整指南

## 📋 问题修复总结

### 已修复的问题

1. ✅ **构建脚本错误检测**
   - 之前：`cjpm build 2>/dev/null` 隐藏了所有错误
   - 现在：显示完整构建输出，保存到日志文件
   - 现在：检查退出码，正确报告构建失败

2. ✅ **二进制文件查找**
   - 之前：只检查 `target/release/bin/cli`
   - 现在：检查多个位置（release/debug, codelin/cli）
   - 现在：提供详细的调试信息

3. ✅ **安装脚本改进**
   - 之前：构建失败时错误信息不清晰
   - 现在：提供详细的错误信息和排查步骤
   - 现在：自动检测并使用最新编译的二进制文件

## 🚀 完整构建流程

### 前置条件

```bash
# 1. 设置环境变量
export MAGIC_PATH=/path/to/magic
export CANGJIE_HOME=/path/to/cangjie

# 2. 验证环境
echo "MAGIC_PATH: $MAGIC_PATH"
echo "CANGJIE_HOME: $CANGJIE_HOME"
```

### 步骤 1：构建项目

```bash
cd /path/to/codelin
bash scripts/build-codelin.sh
```

**构建脚本功能：**
- ✅ 使用静态配置编译
- ✅ 自动备份和恢复配置文件
- ✅ 检查多个输出位置
- ✅ 统一输出到 `binary/codelin`
- ✅ 创建符号链接保持兼容

**构建输出位置：**
- 主要：`binary/codelin`
- 兼容：`binary/codelin-cli` (符号链接)

### 步骤 2：安装到 codebin

```bash
bash scripts/install-complete.sh
```

**安装脚本功能：**
- ✅ 自动调用构建脚本
- ✅ 创建完整的安装包
- ✅ 复制所有依赖库
- ✅ 生成配置文件
- ✅ 创建启动脚本

**安装输出：**
- `codebin/bin/codelin` - 主程序
- `codebin/lib/` - 依赖库
- `codebin/.codelin/` - 配置文件

## 🔍 故障排查

### 问题 1：找不到二进制文件

**症状：**
```
❌ 未找到可用的二进制文件
```

**排查步骤：**

1. **检查构建是否成功**
   ```bash
   ls -lah binary/
   ls -lah target/release/bin/
   ```

2. **查看构建日志**
   ```bash
   tail -50 /tmp/codelin-build-*.log
   ```

3. **手动编译测试**
   ```bash
   cd /path/to/codelin
   cjpm build
   ```

4. **检查编译输出**
   ```bash
   find target -name "codelin" -o -name "cli"
   ```

### 问题 2：编译失败

**症状：**
```
❌ 编译失败，退出码: 1
```

**排查步骤：**

1. **检查环境变量**
   ```bash
   echo $MAGIC_PATH
   echo $CANGJIE_HOME
   ```

2. **检查依赖库**
   ```bash
   ls -la $MAGIC_PATH/libs/
   ```

3. **查看详细错误**
   ```bash
   tail -100 /tmp/codelin-build-*.log | grep -i error
   ```

4. **检查配置文件**
   ```bash
   cat cjpm.toml
   cat $MAGIC_PATH/cjpm.toml
   ```

### 问题 3：使用旧版本

**症状：**
```
⚠️  使用的是旧版本的二进制文件
```

**解决方案：**

1. **强制重新编译**
   ```bash
   rm -rf binary/ target/
   bash scripts/build-codelin.sh
   ```

2. **验证新版本**
   ```bash
   stat -f "%Sm %N" -t "%Y-%m-%d %H:%M:%S" binary/codelin
   ```

## 📝 构建脚本改进详情

### build-codelin.sh 改进

1. **错误检测增强**
   ```bash
   # 之前：隐藏错误
   cjpm build 2>/dev/null
   
   # 现在：显示并保存日志
   cjpm build 2>&1 | tee "$BUILD_LOG"
   if [ $? -ne 0 ]; then
       error "编译失败"
       # 显示错误信息
   fi
   ```

2. **全面检查输出位置**
   ```bash
   # 检查多个位置
   - target/release/bin/codelin
   - target/release/bin/cli
   - target/debug/bin/codelin
   - target/debug/bin/cli
   ```

3. **详细错误报告**
   - 显示所有检查过的位置
   - 提供调试命令
   - 显示构建日志位置

### install-complete.sh 改进

1. **智能二进制文件检测**
   - 时间戳比较，自动选择最新版本
   - 支持多个源位置
   - 提供文件信息（大小、时间）

2. **改进的错误处理**
   - 清晰的错误信息
   - 详细的排查步骤
   - 调试命令建议

## ✅ 验证清单

构建成功后，验证以下内容：

- [ ] `binary/codelin` 存在且可执行
- [ ] 文件大小合理（通常 > 10MB）
- [ ] 文件时间戳是最近的
- [ ] `codebin/bin/codelin` 可以运行
- [ ] 配置文件已创建
- [ ] 启动脚本已创建

## 🎯 快速开始

```bash
# 1. 设置环境
export MAGIC_PATH=/path/to/magic
export CANGJIE_HOME=/path/to/cangjie

# 2. 构建
bash scripts/build-codelin.sh

# 3. 安装
bash scripts/install-complete.sh

# 4. 运行
cd codebin
./bin/codelin --help
```

## 📚 相关文件

- `scripts/build-codelin.sh` - 构建脚本
- `scripts/install-complete.sh` - 安装脚本
- `scripts/BUILD_PLAN.md` - 构建方案
- `scripts/BUILD_GUIDE.md` - 本指南

