#!/bin/bash
# CodeLin 快速验证脚本

echo "======================================"
echo "  CodeLin 快速功能验证"
echo "======================================"
echo ""

PROJECT_DIR="/Users/louloulin/Documents/linchong/gitcode/magic/codelin"
cd "$PROJECT_DIR"

# 测试 1: 编译验证
echo "📦 测试 1: 编译验证"
echo "执行: cjpm build"
cjpm build > /tmp/codelin_build.log 2>&1
if [ $? -eq 0 ]; then
    echo "✅ 编译成功"
else
    echo "❌ 编译失败，查看日志: /tmp/codelin_build.log"
    tail -20 /tmp/codelin_build.log
    exit 1
fi
echo ""

# 测试 2: 检查 SubAgent 文件
echo "📁 测试 2: 检查 SubAgent 文件"
SUBAGENT_DIR="$PROJECT_DIR/src/core/agents/subagents"
echo "检查目录: $SUBAGENT_DIR"

AGENTS=(
    "planner_agent.cj"
    "explorer_agent.cj"
    "editor_agent.cj"
    "reviewer_agent.cj"
    "test_generator_agent.cj"
    "refactoring_agent.cj"
    "execution_loop_agent.cj"
)

for agent in "${AGENTS[@]}"; do
    if [ -f "$SUBAGENT_DIR/$agent" ]; then
        echo "  ✅ $agent"
    else
        echo "  ❌ $agent 不存在"
    fi
done
echo ""

# 测试 3: 检查 cli_app.cj 集成
echo "🔍 测试 3: 检查 ExecutionLoopAgent 集成"
CLI_APP="$PROJECT_DIR/src/app/cli_app.cj"
if grep -q "ExecutionLoopAgent" "$CLI_APP"; then
    echo "✅ ExecutionLoopAgent 已在 cli_app.cj 中引用"
    echo "   匹配行:"
    grep -n "ExecutionLoopAgent" "$CLI_APP" | head -3
else
    echo "❌ ExecutionLoopAgent 未在 cli_app.cj 中找到"
fi
echo ""

# 测试 4: 统计代码
echo "📊 测试 4: 代码统计"
echo "SubAgent 文件数量: $(ls -1 $SUBAGENT_DIR/*.cj | wc -l)"
echo "总代码行数 (SubAgents):"
wc -l $SUBAGENT_DIR/*.cj | tail -1
echo ""

# 测试 5: 检查配置文件
echo "⚙️  测试 5: 检查配置文件"
if [ -f "$PROJECT_DIR/codelin5.txt" ]; then
    echo "✅ codelin5.txt 存在"
    echo "   最新更新:"
    grep "SubAgent" "$PROJECT_DIR/codelin5.txt" | head -2
else
    echo "❌ codelin5.txt 不存在"
fi
echo ""

# 测试 6: 检查文档
echo "📚 测试 6: 检查文档"
DOCS=(
    "SUBAGENT_INTEGRATION_ANALYSIS.md"
    "EXECUTION_LOOP_AGENT_INTEGRATION.md"
    "VERIFICATION_PLAN_FINAL.md"
    "CANGJIE_CODE_ANALYSIS.md"
)

for doc in "${DOCS[@]}"; do
    if [ -f "$PROJECT_DIR/$doc" ]; then
        size=$(wc -l < "$PROJECT_DIR/$doc")
        echo "  ✅ $doc ($size 行)"
    else
        echo "  ❌ $doc 不存在"
    fi
done
echo ""

# 测试 7: Headless Mode 检查
echo "🤖 测试 7: Headless Mode 检查"
if grep -q "dangerouslySkipPermissions" "$PROJECT_DIR/src/core/config/cli_config.cj"; then
    echo "✅ dangerouslySkipPermissions 配置存在"
else
    echo "❌ dangerouslySkipPermissions 配置不存在"
fi

if grep -q "dangerously-skip-permissions" "$PROJECT_DIR/src/parse_args.cj"; then
    echo "✅ --dangerously-skip-permissions 参数支持存在"
else
    echo "❌ --dangerously-skip-permissions 参数支持不存在"
fi
echo ""

# 总结
echo "======================================"
echo "  验证完成"
echo "======================================"
echo ""
echo "下一步建议:"
echo "1. 启动 CodeLin: cjpm run --name cli"
echo "2. 输入命令验证: /agents"
echo "3. 查看工具列表: /help"
echo ""
echo "完整报告: $PROJECT_DIR/FUNCTIONAL_VERIFICATION_REPORT.md"
