# CodeLin 输入与快捷交互全量改造计划 (ui2)

**版本**: v2.0  
**日期**: 2025-11-27  
**范围**: CLI/TUI 输入框、快捷提示弹层、状态栏提示、键盘快捷键体验  
**目标**: 以 CodeBuff CLI、Cursor、Claude Code 的输入体验为标杆，复用现有 `Readline`/`StatusBar`/`KeyboardHandler` 能力，打造顶级终端 UI。

---

## 1. 现状诊断（基于真实代码）

| 模块 | 发现的问题 | 证据 |
|------|------------|------|
| 输入框主体 | Shell/普通模式仅靠 `AnsiColor.BRIGHT_YELLOW` / `BRIGHT_BLACK` 区分，提示符被强制替换成 `" > "`，无法传达模式、会话、状态 | ```62:67:src/io/input_utils.cj\npublic static func buildPrompt(...){\n    return \" > \".withColor(Theme.MUTED)\n}\n``` |
| 输入缓冲渲染 | `wrapBox` 始终使用 `AnsiColor.BRIGHT_BLACK` 边框，`wrapLineWithVerticalBorder` 也没有根据模式/状态切换色板，Shell/普通、错误/提示全部同色 | ```97:175:src/io/wrap_box.cj\nprotected func wrapBox(... boxColor!: AnsiColor = AnsiColor.BRIGHT_BLACK ...)\n``` |
| 提示脚注 | Footer 仅使用 `Theme.MUTED` 灰色，`[count]  💡 @files • !shell • Esc cancels` 在深色背景里对比度不足，且 Esc 与发送操作没有独立色彩 | ```792:804:src/io/readline.cj\nlet hint = if (isShellMode) {\n    \"🔧 Enter executes • Esc cancels\"\n} else {\n    \"💡 @files • !shell • Esc cancels\"\n}\nreturn \"${countText}  ${hint.withColor(Theme.MUTED)}\"\n``` |
| 快捷弹层 | 自动补全框 `wrapOptionList` 只使用亮蓝/亮黑单色，未突出选中/可执行状态；没有 hover/分类信息，难以区分“命令 vs 路径” | ```217:248:src/io/wrap_box.cj\nif (itemIndex == selectedIndex) {\n    listBuilder.append(\"${AnsiColor.BRIGHT_BLUE}${AnsiColor.BOLD}${currentItem}\")\n} else {\n    listBuilder.append(\"${AnsiColor.BRIGHT_BLACK}${currentItem}\")\n}\n``` |
| 状态栏/快捷提示 | 状态栏仅拼接 `"ESC: Cancel"` 字符串，没有颜色与热键分列，快捷键扩展（Ctrl+V、Ctrl+I）无法感知 | ```276:299:src/io/status_bar.cj\nif (parts.size > 0) { parts.add(\"ESC: Cancel\") }\n...\nPrintUtils.printString(displayLine)\n``` |
| 键盘监听 | `KeyboardHandler` 仅能识别单个字符和 ESC/TAB/ENTER/BACKSPACE，无法捕获 `Ctrl+V` 等组合键，导致快捷提示与实际功能不一致 | ```118:140:src/io/keyboard_handler.cj\nmatch (char) {\n    case '\\u{1B}' => return \"ESC\"\n    ... // Ctrl 组合未实现\n    return \"\"\n}\n``` |

### 1.1 交互链路断点
- **输入→弹窗**：`Readline.handleInput` 直接将 `CompletionState` 的字符串数组丢给 `wrapOptionList`，缺少类型/来源信息，导致“弹出的快捷”既无分类也无色彩。  
- **弹窗→状态栏**：状态栏与 Footer 重复 Esc 提示，并无共享数据源，信息冗余。  
- **键盘→UI**：`KeyboardHandler.runeToKey` 无法输出 `Ctrl+K`、`Alt+Enter` 等组合，用户看到提示却触发不了。  
- **TUI 组件**：`tui/src/renderer.cj` 的 `SimpleRenderer` 只接受 `TextStyle`，目前输入组件没有复用，造成 CLI/TUI 两套样式难以统一。

> 结论：UI 信息存在但表达不清晰，颜色层次与模式状态缺乏区分，“弹出的快捷”提示（completion + footer + status bar）与键盘系统脱节。

---

## 2. 标杆对比：CodeBuff / Cursor / Claude Code

1. **CodeBuff CLI**（弹层 + 状态栏）  
   - SubAgent 视图与 StatusBar 使用“高对比标题 + 灰色说明 + 彩色快捷键”的层次结构。  
   - 状态栏组件示例参考 `ui1.md` 中对 `codebuff/cli/src/components/status-bar.tsx` 的摘录，强调 `<Shortcuts>` 独立区域和语义化颜色。  
     ```161:178:ui1.md\n<StatusBar>\n  <StatusIndicator />\n  <ProgressBar />\n  <Shortcuts>\n    <Shortcut key=\"Ctrl+C\" action=\"Cancel\" />\n  </Shortcuts>\n</StatusBar>\n```
2. **Cursor / Claude Code**（顶级输入体验）  
   - `cangjie.md` 第2章指出 Claude Code 具备清晰分层 UI、统一色板；Cursor 拥有插件化、强上下文和高效并发，输入区域提供模式化反馈。  
   - 这些产品都在输入框标题/脚注中明确“提示、模式、快捷键”，并在光标移动/补全时提供高对比弹窗。

| 能力维度 | CodeBuff CLI | Cursor | Claude Code | CodeLin 现状 |
|----------|--------------|--------|-------------|---------------|
| 色彩层级 | 边框/标题/快捷分别配色，Esc=红，Enter=绿 | Command Palette 背景高斯模糊，Chip 颜色区分动作 | 模式条带+快捷芯片高亮 | 单一灰度，Esc 与 Enter 难以区分 |
| 快捷映射 | `<Shortcuts>` 自动读取注册表 | Palette 顶部展示所有热键 | 状态栏常驻多快捷 | 没有注册表，Footer/StatusBar 重复 Esc |
| 输入模式 | `Agent: Shell` + 字数提示 | 通过 Tab/快捷显式切换命令/聊天 | Shell / Message / Tool 清晰标识 | 仅 `!` 判断，UI 无提示 |
| 完成弹层 | 图标列 + 描述列 + 快捷键 | 模糊搜索 + 来源标签 | 类型图标、上下文说明 | 单列纯文本 |
| 统一色板 | 主题集中在 `theme.ts` | `tokens.scss` 驱动 CLI/GUI | `design_tokens.json` 同步 | `wrap_box` 内硬编码 ANSI |

对标启示：
- **色彩层级**：主操作用亮色 (Cyan / Blue)，提示用柔和灰，危险/取消使用红色或橙色。
- **语义标签**：输入框顶部/底部要标注模式、字符计数、关键快捷键，类似 Claude 的 “Message [count] [Esc]” 与 Cursor 的 command palette。
- **快捷反馈一致性**：状态栏提示与键盘监听映射一致；Completer 使用语义图标 (📁 文件, 🔧 命令) 区分类型。

---

## 3. 设计原则与色板升级

1. **高对比 + 语义色**  
   - 新增 `InputPalette`（基于 `Theme`）并同步到 CLI/TUI：  
     - `BorderDefault = Theme.SUBTLE`、`BorderShell = Theme.WARNING`、`BorderDanger = Theme.ERROR`。  
     - `Highlight = Theme.ACCENT`（选中项反色背景）、`Secondary = Theme.MUTED`、`Action = Theme.PRIMARY`、`Cancel = Theme.ERROR`。  
     - 定义 `ShortcutTone {Primary, Secondary, Danger}` → `ShortcutChip` 根据 tone 决定前景/背景。  
   - Footer 中的 `[count]` 改为 `Theme.WARNING` (>90%)，`Enter` 使用 `Theme.SUCCESS`，`Esc` 使用 `Theme.ERROR`，`Tab` 使用 `Theme.ACCENT`，统一“弹出的快捷”配色。

2. **结构化提示**  
   - 顶部标题：`[模式图标] Label  ┊  [字符数] ┊ [Esc glyph]`  
   - 底部脚注：`Action | Shortcut` 列表，使用“标签 + 描述”形式。
   - 完成列表：左右留白 + 图标列 + 描述列 + 颜色反差（选中项反色背景）。

3. **快捷一致性**  
   - `KeyboardHandler` 扩展支持 `Ctrl+<letter>`、`Alt+<letter>`，并将注册快捷与 UI 渲染统一来源（例如 `ShortcutRegistry` 数据结构）。
   - 状态栏显示 `[Key] Action` 芯片，颜色来自 `InputPalette`.

---

## 4. 分阶段实施路线

### Phase P0（1 天）— 颜色与提示清晰化 ✅（2025-11-27 完成）
1. **Footer/StatusBar 色彩升级**  
   - 修改 `Readline.buildFooter`：输出 `ShortcutHint[]`，默认包含 `[Enter=Send, Esc=Cancel, Tab=Accept completion]`，根据 tone 使用 `Theme.SUCCESS/ERROR/ACCENT`。  
   - 更新 `StatusBar`，为快捷芯片添加 `InputPalette.Action/Cancel` 背景，并允许多个快捷同时展示（Esc、Ctrl+V、Ctrl+I），移除重复的纯文本 `ESC: Cancel`。  
   - ✅ `src/io/colors.cj`, `src/io/shortcut_hints.cj`, `src/io/readline.cj`, `src/io/status_bar.cj` 已落地（`InputPalette` + Shortcut chips）。
2. **Completion 列表配色**  
   - 改写 `wrapOptionList`：选中项使用反色背景（`Theme.ACCENT.withBgColor`），普通项改用浅灰文本，支持类型前缀图标。  
   - ✅ `src/io/wrap_box.cj` 完成：提供 `🔧/📁/⭐` 图标 + 反色背景 + `Ctrl+数字` 快捷提示。  
3. **Prompt 恢复语义**  
   - `InputUtils.buildPrompt` 恢复模式标签（Message/Shell/Context），并将 `sessionTitle` 作为浅灰水印显示在标题栏。
   - ✅ `src/io/input_utils.cj` 已恢复 `prompt` 参数并显示 `[💬 Message] Session >`。

### Phase P1（2~3 天）— 输入框结构升级
1. **标题栏与脚注组件化**  
   - 新增 `InputFrameRenderer`（`src/io/input_frame.cj`）：负责构建 `"╭ title ╮"`、`"╰ footer ╯"`，内部复用 `wrapBox`.
   - 支持模式图标（💬/🔧/📎）、锁定 `[Esc]` 芯片、动态快捷列表（来自 `ShortcutRegistry`）。  
2. **动态快捷数据源**  
   - 定义 `ShortcutDescriptor { key: String, label: String, tone: ShortcutTone }`，由 `KeyboardHandler` 注册时写入全局表，`Readline.buildFooter` 与 `StatusBar` 统一读取。  
3. **Completion Palette**  
   - 新的 `CompletionPalette`：  
     - 命令：蓝色（`Theme.PRIMARY`）  
     - 文件：青色（`Theme.ACCENT`）  
     - 自定义：紫色（`Theme.HIGHLIGHT`）  
   - `wrapOptionList` 根据内容加前缀 `🔧 / 📁 / ⭐`，并在右侧显示 `Ctrl+<index>` 快捷选项提示。

### Phase P2（1 周）— 顶级体验封顶
1. **浮动命令面板**  
   - 引入 `QuickPalette`（类似 Cursor Command Palette）：`Ctrl+K` 弹出全屏模态，支持模糊搜索命令/会话/文件；复用 `SubAgentViewer` 的滚动机制。  
2. **模式自适应主题**  
   - 根据 CLI 模式（Shell/Editor/SubAgent）自动切换 `InputPalette.Border*`，并在状态栏显示“Mode Chip”。  
3. **快捷键录制与帮助**  
   - `KeyboardHandler` 支持 `?` 弹出快捷帮助表，与 Claude 的 `⇧⌘P` 工具提示对齐。  
4. **无障碍 / 高对比模式**  
   - 提供 `CliConfig.highContrastInput`，切换为背景填充 + 双线框，以满足终端可读性需求。

---

## 5. 复用与落地策略

| 现有能力 | 如何复用 |
|---------|---------|
| `wrapBox` / `wrapLineWithVerticalBorder` | 继续作为边框生成器，通过新 `InputFrameRenderer` 聚合标题/正文/脚注 |
| `Theme` (`src/io/colors.cj`) | 增加 `InputPalette` 常量而非硬编码 ANSI，保证全局配色统一 |
| `Readline` 渲染管线 | 只替换 `buildFooter`、`buildPlaceholder`、`wrapBox` 输入，不改变光标/定位逻辑 |
| `StatusBar` | 在 `parts` 构建阶段追加 `ShortcutChip` 集合，引用统一快捷表 |
| `KeyboardHandler` | 扩展 rune 解析 + 派发到 `ShortcutRegistry`，并暴露 API 供 UI 渲染使用 |
| `SubAgentViewer` | 为 P2 QuickPalette 复用滚动/分页框架，避免重复造轮子 |
| `tui/SimpleRenderer` | 以 `InputFrameRenderer` 产出的矩阵驱动 `TextStyle`，复用 CLI 色板 |

---

## 6. 验收标准 & 测试计划

| 级别 | 验收标准 | 测试方法 |
|------|----------|----------|
| P0 | Footer 至少使用 3 种语义色、Esc/Enter/Send 可一眼分辨；状态栏可以同时显示 ≥2 个快捷键 | `test_phase5_help.sh` + 人工截图对比 |
| P1 | 输入框标题包含模式/计数/快捷；Completion 以颜色/图标区分类型；快捷提示与键盘注册一致 | `test_interactive_ui.sh`，断言 `keyboard_handler` 注册表与 UI 输出相符 |
| P2 | `Ctrl+K` Palette / `?` 快捷帮助可交互滚动，`CliConfig.highContrastInput` 生效 | `verify_ui.sh` + 终端录像 |

---

## 7. 下一步

1. **落地 P0**：颜色常量 + Footer/StatusBar/Completion 调整（估 0.5 天开发 + 0.5 天验证）。  
2. **设计评审**：与产品/UI 复盘 P1 线框（可直接在 `InputFrameRenderer` 上使用 ASCII mock）。  
3. **竞品复测**：重新对比 CodeBuff CLI 最新 master、Cursor CLI 最新 nightly，核实 Palette/快捷提示是否有新的交互可借鉴。  
4. **同步 Keyboard 团队**：确认 `KeyboardHandler` 需要的 raw 输入事件解析（ANSI 序列解析 + Ctrl/Alt map）。  

> 交付本计划后，可直接在 `src/io/readline.cj` / `src/io/status_bar.cj` / `src/io/keyboard_handler.cj` 中按阶段推进，实现“顶级 TUI 输入体验”目标。

---

## 8. UI 功能清单补完
- [x] **输入框体验**：支持 `Message/Shell/SubAgent` 三种模式标签、字符计数、会话标题，并允许 `Prompt` 参数决定初始文案（`buildPrompt` 恢复语义）。  
- [x] **快捷弹窗**：Completion 弹层显示类型图标、`Ctrl+数字` 快捷提示，选中项反色背景，普通项柔和灰。  
- [x] **状态栏**：统一读取 `ShortcutHintProvider`，展示 Agent/Git/文件/快捷芯片，多快捷同时展示。  
- [ ] **键盘能力**：捕获 `Ctrl+K`、`Ctrl+Shift+?`、`Alt+Enter`，支持快捷帮助（`?`）与 QuickPalette 触发，确保 UI 提示和真实行为一致。  
- [ ] **高对比模式**：`CliConfig.highContrastInput` 切换为双线框 + 深背景 + 粗体文字，提升暗色终端可读性。  
- [ ] **TUI 复用**：`InputFrameRenderer` 输出结构被 CLI 的 `wrapBox` 和 `tui/SimpleRenderer` 同时消费，保证颜色、提示、快捷布局一致。


