# UI 功能恢复计划

**日期**: 2025-11-18  
**状态**: 🔄 执行中  
**目标**: 恢复 Phase 5 UI 优化功能（Claude Code 风格）

---

## 📋 现状分析

### ✅ 已恢复的功能（刚才完成）
- [x] 默认模型改为智谱 AI
- [x] 华为 MaaS 模型支持
- [x] 环境变量自动加载 (.env)
- [x] 配置文件创建

### ❌ 需要恢复的 UI 功能

根据 Git 历史 (commit 7af03fb9)，以下文件包含 UI 优化：

| 文件 | 状态 | 说明 |
|------|------|------|
| `src/io/input_utils.cj` | ✅ 已存在 | 需要验证功能完整性 |
| `src/io/session_display.cj` | ✅ 已存在 | SessionDisplayInfo 类 |
| `src/io/session_selector.cj` | ❌ 缺失 | 交互式会话选择器 |
| `src/core/conversation/conversation_manager.cj` | ⚠️  需验证 | Session 元数据功能 |
| `src/app/cli_app.cj` | ⚠️  需验证 | Resume 模式集成 |

---

## 🎯 恢复策略：最小改动原则

### Phase 1: 文件恢复 (15分钟)

#### 步骤 1.1: 恢复缺失文件
```bash
# 恢复 session_selector.cj
git show 7af03fb9:src/io/session_selector.cj > src/io/session_selector.cj
```

**验证**:
```bash
ls -la src/io/session_selector.cj
# 应该看到文件存在
```

#### 步骤 1.2: 检查依赖文件
```bash
# 检查 input_utils.cj 是否有 readRune 方法
grep "readRune" src/io/input_utils.cj

# 检查 session_display.cj
cat src/io/session_display.cj

# 检查 conversation_manager.cj 的 getCurrentSessionDisplayInfo 方法
grep "getCurrentSessionDisplayInfo" src/core/conversation/conversation_manager.cj
```

---

### Phase 2: 代码验证与补全 (30分钟)

#### 步骤 2.1: 验证 input_utils.cj

**需要确认的功能**:
- [x] `buildPrompt()` - 支持 session title
- [x] `getUserInput()` - 支持 sessionInfo 参数
- [x] `printSessionInfoBar()` - 显示 session 信息
- [ ] `readRune()` - 供 SessionSelector 使用

**测试代码**:
```bash
# 检查方法是否存在
grep -A 5 "readRune" src/io/input_utils.cj
```

#### 步骤 2.2: 验证 conversation_manager.cj

**需要确认的功能**:
- [ ] `getCurrentSessionDisplayInfo()` - 获取当前 session 信息
- [ ] Session 元数据管理
- [ ] Resume 模式支持

**测试代码**:
```bash
# 检查方法签名
grep -A 10 "getCurrentSessionDisplayInfo" src/core/conversation/conversation_manager.cj
```

---

### Phase 3: 编译测试 (15分钟)

#### 步骤 3.1: 编译验证
```bash
# 清理并重新编译
cjpm clean
cjpm build

# 预期结果：0 errors, 0 warnings
```

#### 步骤 3.2: 功能测试
```bash
# 测试基础功能
./scripts/magic-cli.sh

# 预期行为：
# 1. 显示 session 信息栏
# 2. 简洁的 prompt
# 3. 自动加载 .env 文件
```

---

### Phase 4: 交互测试 (15分钟)

#### 测试用例 1: 基础对话
```bash
./scripts/magic-cli.sh
> 你好
# 预期：正常回复，显示 session 信息
```

#### 测试用例 2: Session 命令（如果已实现）
```bash
> /sessions
# 预期：列出所有 session

> /new
# 预期：创建新 session

> /switch
# 预期：交互式选择器（如果 session_selector.cj 已恢复）
```

---

## 🔧 实施计划

### Step 1: 恢复 session_selector.cj ✅

```bash
cd /Users/louloulin/Documents/linchong/gitcode/magic/codelin
git show 7af03fb9:src/io/session_selector.cj > src/io/session_selector.cj
```

**预期输出**: 文件已创建

---

### Step 2: 检查 input_utils.cj 功能完整性

**检查清单**:
- [ ] `buildPrompt()` 方法存在
- [ ] `getUserInput()` 支持 sessionInfo
- [ ] `printSessionInfoBar()` 方法存在
- [ ] `readRune()` 方法存在

**验证命令**:
```bash
grep -c "buildPrompt" src/io/input_utils.cj
grep -c "getUserInput" src/io/input_utils.cj
grep -c "printSessionInfoBar" src/io/input_utils.cj
grep -c "readRune" src/io/input_utils.cj
```

**预期结果**: 每个方法至少出现 1 次

---

### Step 3: 检查 conversation_manager.cj

**需要添加的方法** (如果缺失):

```cangjie
// src/core/conversation/conversation_manager.cj

/**
 * Get current session display info for UI
 * Phase 5: Claude Code style info bar
 */
public func getCurrentSessionDisplayInfo(): SessionDisplayInfo {
    let sessionName = currentSession ?? "default"
    let metadata = getMetadata(sessionName)
    
    return SessionDisplayInfo(
        sessionName: sessionName,
        title: metadata?.title ?? "New Chat",
        messageCount: metadata?.messageCount ?? Int64(messages.size),
        fileCount: metadata?.fileCount ?? 0,
        isActive: true
    )
}
```

**验证命令**:
```bash
grep -A 20 "getCurrentSessionDisplayInfo" src/core/conversation/conversation_manager.cj
```

---

### Step 4: 编译测试

```bash
# 清理
cjpm clean

# 编译
cjpm build 2>&1 | tee build.log

# 检查错误
grep -i "error" build.log
```

**预期**: 0 errors

---

### Step 5: 运行测试

#### 5.1 基础启动测试
```bash
./scripts/magic-cli.sh --help
```

**预期输出**: 帮助信息

#### 5.2 对话测试
```bash
./scripts/magic-cli.sh << 'EOF'
你好
EOF
```

**预期**: 正常回复

#### 5.3 UI 测试（手动）
```bash
./scripts/magic-cli.sh
# 观察：
# 1. 是否显示 session 信息栏？
# 2. Prompt 是否简洁？
# 3. 是否显示消息数和文件数？
```

---

## 📊 验收标准

### 必须通过的测试

- [ ] **编译测试**: `cjpm build` 成功，0 errors
- [ ] **启动测试**: `./scripts/magic-cli.sh` 正常启动
- [ ] **UI 测试**: 显示 Claude Code 风格的 session 信息栏
- [ ] **交互测试**: 正常对话，API 调用成功
- [ ] **环境变量**: 自动加载 .env 文件

### 可选功能（如果实现了）

- [ ] `/sessions` - 列出所有 session
- [ ] `/new` - 创建新 session
- [ ] `/switch` - 交互式选择器
- [ ] `/rename` - 重命名 session
- [ ] Resume 模式 - 启动时选择 session

---

## 🎯 成功标准

### 视觉效果

**启动时**:
```
┌───────────────────────────────────────────┐
│ Session: default | 5 msgs | 2 files       │
└───────────────────────────────────────────┘

  > 
```

**对话中**:
```
User: 你好
