# LSP 深度集成优化设计文档

## 📋 实施方案

### 目标
在现有 LSP 工具集基础上，添加更多实用的 LSP 功能

### 策略：最小改动
1. **不修改 LSPClient**：直接在工具层使用现有能力
2. **利用现有基础设施**：复用缓存、错误处理等
3. **渐进式添加**：从最简单最实用的功能开始

---

## 🎯 实施优先级

### 第一阶段：添加基于现有 LSP 能力的工具

#### 优先级1：获取悬停信息（最简单）✅
**功能**：`getSymbolHoverInfo`
**基础**：LSPClient 已有 `getHovers` 方法
**用途**：查看符号的类型和文档

#### 优先级2：查找符号定义位置（简单）
**功能**：`findSymbolDefinition`
**实现**：使用 LSP `textDocument/definition`
**用途**：跳转到符号定义

#### 优先级3：查找符号引用（中等）
**功能**：`findSymbolReferences`
**实现**：使用 LSP `textDocument/references`
**用途**：查找符号的所有使用位置

---

## 💡 具体实现

### 工具1：getSymbolHoverInfo（基于现有能力）

```cangjie
@tool[
    description: """
Get hover information (type, documentation) for a symbol at a specific location.
This provides detailed information about what a symbol is without jumping to its definition.

Use this when you want to:
- Check the type of a variable or function
- Read documentation for a symbol
- Understand what a symbol does without navigating away

Returns information including:
- Type signature
- Documentation comments
- Parameter information (for functions)
"""
    parameters: {
        filePath: "Absolute path to the Cangjie file",
        line: "Line number (1-based)",
        character: "Character position in the line (0-based)"
    }
]
public func getSymbolHoverInfo(
    filePath: String,
    line: Int64,
    character: Int64
): String {
    // 1. 验证参数
    // 2. 获取 LSP 客户端
    // 3. 打开文档
    // 4. 获取语义 token
    // 5. 调用 getHovers
    // 6. 格式化返回
}
```

**实现步骤**：
1. 复用 `getOrCreateLSPClient()`
2. 复用 `openDocumentIfNeeded()`
3. 调用 `client.getSemanticTokens()` 
4. 调用 `client.getHovers()`
5. 格式化返回 hover 信息

**优势**：
- ✅ 完全基于现有 LSPClient 方法
- ✅ 不需要添加新的 LSP 请求
- ✅ 实现简单，约 50-80 行

---

### 工具2：getCodeSummary（创新工具）

**创意**：结合现有的符号信息和语义信息，生成代码摘要

```cangjie
@tool[
    description: """
Get a concise summary of a Cangjie file's structure and main components.
This provides a quick overview without reading the entire file.

Returns:
- File statistics (lines, symbols count)
- Main symbols (classes, functions, structs)
- Import statements
- Package declaration
"""
    parameters: {
        filePath: "Absolute path to the Cangjie file"
    }
]
public func getCodeSummary(filePath: String): String {
    // 1. 获取符号信息（使用 getDocumentSymbols）
    // 2. 读取文件开头（package, imports）
    // 3. 统计代码行数
    // 4. 格式化为摘要
}
```

**实现**：
- 复用 `getFileSymbols` 的逻辑
- 添加文件统计信息
- 提取 import 语句（可以复用 DependencyAnalyzer！）

**优势**：
- ✅ 完全基于现有功能组合
- ✅ 不需要新的 LSP 请求
- ✅ 非常实用

---

### 工具3：analyzeSymbolUsage（组合工具）

**功能**：分析符号的使用情况

```cangjie
@tool[
    description: """
Analyze how a symbol is used in a file.
Combines symbol information with semantic analysis to provide usage insights.
"""
    parameters: {
        filePath: "Absolute path to the Cangjie file",
        symbolName: "Name of the symbol to analyze"
    }
]
public func analyzeSymbolUsage(
    filePath: String,
    symbolName: String
): String {
    // 1. 查找符号定义
    // 2. 分析符号类型
    // 3. 查找符号引用（基于语义信息）
    // 4. 返回分析结果
}
```

---

## 📊 实施计划

### 第一步：实现 getSymbolHoverInfo（最简单）
**时间**：0.5 天
**代码量**：约 80 行
**价值**：立即可用，提升代码理解能力

### 第二步：实现 getCodeSummary（最实用）
**时间**：0.3 天
**代码量**：约 60 行
**价值**：快速了解文件结构

### 第三步：实现 analyzeSymbolUsage（可选）
**时间**：0.5 天
**代码量**：约 100 行
**价值**：深度分析工具

### 总计
**时间**：1-1.5 天
**代码量**：约 200-250 行
**新工具**：2-3 个

---

## ✅ 验收标准

1. ✅ 至少实现 2 个新工具
2. ✅ 所有工具编译通过
3. ✅ 工具可被 Agent 正常调用
4. ✅ 提供清晰的错误处理
5. ✅ 复用现有基础设施（缓存、客户端管理）

---

## 🎯 预期成果

### 新增能力
- 📖 **悬停信息**：快速查看符号类型和文档
- 📊 **代码摘要**：快速了解文件结构
- 🔍 **符号分析**：深度理解符号用法

### 用户体验提升
- Agent 可以更准确地理解代码
- Agent 可以快速获取代码概览
- Agent 可以提供更精确的建议

---

## 💡 创新点

1. **组合现有能力**：不添加新的 LSP 请求，而是组合现有功能
2. **实用至上**：选择最实用的功能，而非追求完整性
3. **最小改动**：完全基于现有基础设施

---

**决策**：立即开始实施

**实施者**：AI Assistant  
**设计日期**：2024-10-24  
**版本**：v1.0

