# CodeLin v6.1 交互式验证指南

**验证目标**: 验证 ExecutionLoopAgent 和 BatchEditToolset 是否真实可用

---

## 🚀 启动 CLI

```bash
source $CANGJIE_HOME/envsetup.sh
cjpm run --name cli
```

---

## ✅ 验证步骤

### 1. 基础功能验证

#### 1.1 欢迎界面
```
✅ 检查项:
- Logo 是否完整显示
- 欢迎信息是否正确
- 命令列表是否显示
```

#### 1.2 帮助命令
```
> /help
```
**预期结果**:
- ✅ 显示所有可用命令
- ✅ 命令说明完整
- ✅ 示例清晰

### 2. 项目初始化验证

#### 2.1 生成 CODELIN.md
```
> /init
```
**预期结果**:
- ✅ 自动分析项目结构
- ✅ 生成 CODELIN.md 文件
- ✅ 包含项目元数据

#### 2.2 查看项目记忆
```
> /memory
```
**预期结果**:
- ✅ 显示 CODELIN.md 内容
- ✅ 项目信息完整

### 3. Agent 功能验证

#### 3.1 简单代码问题（测试 EditorAgent）
```
> 创建一个简单的 hello world 函数
```
**预期结果**:
- ✅ Agent 响应
- ✅ 生成正确代码
- ✅ 代码格式规范

#### 3.2 代码审查（测试 ReviewerAgent）
```
> 审查 src/app/cli_app.cj 的代码质量
```
**预期结果**:
- ✅ 提供代码审查意见
- ✅ 指出潜在问题
- ✅ 给出改进建议

#### 3.3 测试生成（测试 TestGeneratorAgent）
```
> 为 src/core/tools/batch_edit_toolset.cj 生成单元测试
```
**预期结果**:
- ✅ 生成测试代码
- ✅ 覆盖主要功能
- ✅ 测试用例合理

### 4. ExecutionLoopAgent 验证（关键）

虽然 ExecutionLoopAgent 不是直接暴露给用户的命令，但它在后台运行时会：

#### 4.1 自动验证执行结果
```
> 修改一个文件并请求编译验证
```
**预期行为**:
- ✅ 执行编辑
- ✅ 自动验证结果
- ✅ 发现错误时自动修复（如果启用）

#### 4.2 错误识别和重试
```
> 创建一个故意包含错误的代码
```
**预期行为**:
- ✅ 识别错误模式
- ✅ 提供修复建议
- ✅ 自动重试（最多5次）

### 5. BatchEditToolset 验证（关键）

BatchEditToolset 作为工具被 Agent 使用：

#### 5.1 批量文件修改
```
> 将项目中所有的 "CangjeMagic" 重命名为 "CangjieFramework"
```
**预期行为**:
- ✅ Agent 调用 BatchEditToolset
- ✅ 批量修改多个文件
- ✅ 原子性保证（全部成功或全部回滚）

#### 5.2 原子性验证
```
> 批量修改，但故意让其中一个失败
```
**预期行为**:
- ✅ 检测到失败
- ✅ 自动回滚所有更改
- ✅ 文件恢复到原始状态

### 6. 会话管理验证

#### 6.1 新建会话
```
> /new
```
**预期结果**:
- ✅ 创建新会话
- ✅ 清空历史

#### 6.2 会话列表
```
> /sessions
```
**预期结果**:
- ✅ 显示所有会话
- ✅ 包含元数据（时间、消息数）

#### 6.3 切换会话
```
> /switch <session-name>
```
**预期结果**:
- ✅ 切换成功
- ✅ 加载历史记录

### 7. MCP 集成验证

#### 7.1 MCP 服务器列表
```
> /mcp list
```
**预期结果**:
- ✅ 显示已配置的 MCP 服务器
- ✅ 显示服务器状态

### 8. 高级功能验证

#### 8.1 文件引用
```
> @src/core/agents/subagents/execution_loop_agent.cj 解释这个文件的功能
```
**预期结果**:
- ✅ 读取文件内容
- ✅ 提供详细解释

#### 8.2 Shell 命令执行
```
> !ls -la src/core/agents/subagents/
```
**预期结果**:
- ✅ 执行 shell 命令
- ✅ 显示命令输出

#### 8.3 路径补全
```
> @src/[按Tab键]
```
**预期结果**:
- ✅ 显示补全选项
- ✅ 可以选择路径

---

## 🔍 深度验证（开发者模式）

### 验证 ExecutionLoopAgent 是否加载

1. 查看编译产物：
```bash
nm target/release/libcli.core.agents.subagents.a | grep -i execution
```

2. 检查符号表：
```bash
strings target/release/bin/cli | grep -i "ExecutionLoop"
```

### 验证 BatchEditToolset 是否加载

1. 查看工具模块：
```bash
nm target/release/libcli.core.tools.a | grep -i batch
```

2. 检查工具注册：
```bash
strings target/release/bin/cli | grep -i "batchEdit"
```

---

## 📊 验证检查表

### ✅ 基础功能
- [ ] CLI 启动成功
- [ ] 欢迎界面显示
- [ ] /help 命令工作
- [ ] /exit 命令工作

### ✅ Agent 功能
- [ ] EditorAgent 响应
- [ ] ReviewerAgent 工作
- [ ] TestGeneratorAgent 工作
- [ ] PlannerAgent 规划任务
- [ ] ExplorerAgent 探索代码
- [ ] RefactoringAgent 提供建议

### ✅ 新增功能（v6.1）
- [ ] ExecutionLoopAgent 后台运行
- [ ] BatchEditToolset 批量编辑
- [ ] 原子性保证验证
- [ ] 自动验证机制
- [ ] 错误识别和重试

### ✅ 集成功能
- [ ] 会话管理
- [ ] MCP 集成
- [ ] 文件引用 (@)
- [ ] Shell 执行 (!)
- [ ] Tab 补全

---

## 🎯 验证成功标准

### 必须通过项（P0）
1. ✅ CLI 可正常启动和退出
2. ✅ 所有基础命令可用
3. ✅ Agent 可正常响应
4. ✅ 文件操作正常
5. ✅ 编译验证成功

### 期望通过项（P1）
1. ✅ ExecutionLoopAgent 自动验证
2. ✅ BatchEditToolset 原子性编辑
3. ✅ 错误自动识别
4. ✅ 智能重试机制
5. ✅ 批量操作回滚

### 加分项（P2）
1. ✅ 性能流畅（<1秒响应）
2. ✅ 错误提示友好
3. ✅ 代码质量高
4. ✅ 用户体验好

---

## 🐛 已知限制

1. **ExecutionLoopAgent**:
   - 不是独立命令，作为后台机制运行
   - 需要通过 Agent 响应观察其工作

2. **BatchEditToolset**:
   - 由 Agent 内部调用
   - 用户不能直接使用 batchEditFiles 命令

3. **符号验证**:
   - 由于编译优化，符号可能被内联
   - 需要通过功能测试验证

---

## 📝 测试记录模板

```
测试日期: 2024-11-19
测试人员: ___________
CLI 版本: v6.1

基础功能:
- [ ] 启动成功
- [ ] 命令可用
- [ ] 退出正常

Agent 功能:
- [ ] 代码生成: ___
- [ ] 代码审查: ___
- [ ] 测试生成: ___

新增功能:
- [ ] 执行循环: ___
- [ ] 批量编辑: ___

问题记录:
1. ___________
2. ___________

总体评价: ___________
```

---

## 🚀 快速验证脚本

```bash
#!/bin/bash
echo "=== CodeLin v6.1 快速验证 ==="

# 1. 启动 CLI（后台）
source $CANGJIE_HOME/envsetup.sh

# 2. 发送测试命令
(
  sleep 1
  echo "/help"
  sleep 1
  echo "/memory"
  sleep 1
  echo "创建一个 hello world 函数"
  sleep 3
  echo "/exit"
) | cjpm run --name cli

echo "✅ 快速验证完成"
```

---

**准备好了吗？让我们开始交互式验证！** 🎉

**启动命令**:
```bash
source $CANGJIE_HOME/envsetup.sh && cjpm run --name cli
```
