# CodeLin 正确启动指南

## 🎯 问题：目录分析错误

**现象**: ExplorerAgent分析了错误的目录（/workspace、/tmp等）

**原因**: CodeLin未在正确的工作目录中启动，或工作目录配置不正确

---

## ✅ 正确的启动方式

### 方式1: 使用magic-cli.sh（推荐）

```bash
# 1. 进入CodeLin项目目录
cd /Users/louloulin/Documents/linchong/cjproject/codelin

# 2. 启动（会自动设置工作目录）
./scripts/magic-cli.sh

# 3. 验证工作目录
# 启动后，第一个命令输入：
pwd
# 或
当前工作目录是什么？
```

### 方式2: 使用cjpm run

```bash
# 1. 进入CodeLin项目目录
cd /Users/louloulin/Documents/linchong/cjproject/codelin

# 2. 设置环境变量
export DYLD_LIBRARY_PATH=/Users/louloulin/Documents/linchong/cjproject/CangjieMagic/libs/cangjie-stdx-mac-aarch64-1.0.0.1/darwin_aarch64_llvm/dynamic/stdx:$DYLD_LIBRARY_PATH

# 3. 运行（指定工作目录）
cjpm run --name cli -- --workspace .

# 或明确指定完整路径
cjpm run --name cli -- --workspace /Users/louloulin/Documents/linchong/cjproject/codelin
```

### 方式3: 在正确目录启动后设置工作目录

如果已经启动但工作目录不对：

```bash
# 在Codelin中输入：
设置工作目录为 /Users/louloulin/Documents/linchong/cjproject/codelin
```

---

## 🧪 测试SubAgent的正确方式

### 准备工作

```bash
# 1. 确保在正确目录
cd /Users/louloulin/Documents/linchong/cjproject/codelin

# 2. 启动CodeLin
./scripts/magic-cli.sh
```

### 测试场景（按顺序）

#### 场景1: 简单的ExplorerAgent测试

```
用户输入: "列出当前目录的文件和子目录"
```

**预期**: 应该看到src/、docs/、scripts/等CodeLin的实际目录

#### 场景2: 分析CodeLin项目结构

```
用户输入: "探索src目录，告诉我主要的模块有哪些"
```

**预期**: ExplorerAgent分析src/目录，列出core、app、io、utils等模块

#### 场景3: 分析特定文件

```
用户输入: "读取并解释src/main.cj的内容"
```

**预期**: 读取并解释main.cj文件

#### 场景4: PlannerAgent测试

```
用户输入: "创建一个计划：为CodeLin添加命令历史保存功能"
```

**预期**: PlannerAgent生成结构化的JSON计划

#### 场景5: ReviewerAgent测试

```
用户输入: "审查src/main.cj的代码质量"
```

**预期**: ReviewerAgent返回详细的审查报告

---

## 🔍 验证工作目录

### 在CodeLin中验证

启动CodeLin后，输入以下命令验证工作目录：

```
当前工作目录在哪里？
```

**期望输出**: 
```
当前工作目录: /Users/louloulin/Documents/linchong/cjproject/codelin
```

如果显示其他目录（如/workspace、/tmp），说明启动方式不对。

### 检查配置

```bash
# 查看CliConfig的工作目录设置
grep -n "workspace\|cwd" src/core/config/cli_config.cj
```

---

## ⚠️ 常见问题

### 问题1: 工作目录显示为/workspace

**原因**: 可能在Docker容器或某个沙箱环境中运行

**解决**: 
- 确保在本机直接运行
- 使用 `--workspace` 参数明确指定路径

### 问题2: SubAgent创建了奇怪的目录

**现象**: 在/workspace、/tmp下创建目录

**原因**: SubAgent的工具调用时路径不正确

**解决**:
1. 停止当前运行（Ctrl+C）
2. 重新按正确方式启动
3. 在提问时明确包含路径，如："分析`/Users/louloulin/Documents/linchong/cjproject/codelin/src`目录"

### 问题3: 找不到CodeLin的源文件

**原因**: 工作目录设置错误

**解决**: 按上面"正确的启动方式"重新启动

---

## 📝 建议的测试流程

### 第1步: 验证环境
```bash
cd /Users/louloulin/Documents/linchong/cjproject/codelin
./scripts/magic-cli.sh
```

在CLI中输入：
```
当前工作目录在哪里？
```

确认显示正确的路径后再继续。

### 第2步: 简单测试
```
列出当前目录的主要文件和文件夹
```

应该看到实际的CodeLin目录结构。

### 第3步: SubAgent测试
只有在前两步都正确后，才进行SubAgent功能测试：

```
探索src/core目录，说明主要的模块组织
```

---

## 🎯 正确的测试命令示例

**❌ 错误的提问**（会导致目录混乱）:
```
"请深入分析这个 Codelin 项目的整个代码库"
```
→ 太模糊，SubAgent可能不知道从哪里开始

**✅ 正确的提问**:
```
"探索当前项目的src目录，说明代码组织结构"
```
→ 明确指定了要分析的目录

**✅ 更精确的提问**:
```
"使用ExplorerAgent分析src/core/agents目录，列出所有Agent实现"
```
→ 指定了SubAgent和具体路径

---

## 🚀 快速修复当前问题

如果CodeLin正在运行且目录不对：

1. **停止**: 按 Ctrl+C 或输入 `exit`

2. **重新启动**:
```bash
cd /Users/louloulin/Documents/linchong/cjproject/codelin
./scripts/magic-cli.sh
```

3. **验证**:
```
pwd
```

4. **开始正确的测试**:
```
列出src目录下的所有子目录
```

---

## 📊 期望的SubAgent行为

### ExplorerAgent应该：
- ✅ 在当前工作目录（codelin项目）下分析
- ✅ 使用`listDirectory`查看src/、docs/等目录
- ✅ 使用`readFile`读取.cj文件
- ✅ 使用`grep`搜索代码模式

### ExplorerAgent不应该：
- ❌ 在/workspace、/tmp等系统目录操作
- ❌ 创建不相关的目录
- ❌ 尝试访问不存在的路径

---

**总结**: 关键是确保CodeLin在正确的工作目录（`/Users/louloulin/Documents/linchong/cjproject/codelin`）中启动。使用`./scripts/magic-cli.sh`是最简单可靠的方式。

