# CodeLin 快速使用指南

**版本**: Phase 5+ (含 UI 优化)  
**状态**: ✅ Production Ready

---

## 🚀 快速开始

### 1. 启动 CLI

```bash
cd /Users/louloulin/Documents/linchong/cjproject/codelin
cjpm run --name cli
```

### 2. 首次使用

启动后会看到：

```
════════════════════════════════════════════════
   ____          _      _     _       
  / ___|___   __| | ___| |   (_)_ __  
 | |   / _ \ / _` |/ _ \ |   | | '_ \ 
 | |__| (_) | (_| |  __/ |___| | | | |
  \____\___/ \__,_|\___|_____|_|_| |_|
                                       
  Cangjie Code Assistant
════════════════════════════════════════════════

Quick Start:
  /help      → View all commands
  /new       → Start new session
  /sessions  → View all sessions
  @file      → Reference files
  !cmd       → Execute shell

 ┌────────────────────────────────────────────────┐
 │ Session: last-conversation                     │
 └────────────────────────────────────────────────┘

 > _
```

---

## 📝 Session 管理命令

### 核心命令

```bash
# 创建新会话
/new

# 查看所有会话
/sessions

# 切换会话
/switch my-project

# 重命名当前会话
/rename Implement User API

# 查看帮助
/help
```

### 会话列表示例

输入 `/sessions` 后：

```
Sessions (3)

  ▶ last-conversation - My Test Session
    project-api - Implement User API
    bug-fix - Fix Authentication Bug

Commands: /new /switch /rename
```

---

## ✨ 核心特性

### 1. 自动恢复 (类似 claude -r)

**特性**: 启动时自动加载上次会话

**体验**:
- 第一次启动 → 新会话
- 第二次启动 → 自动恢复上次会话
- 无需手动输入命令
- 完全透明

### 2. AI 自动命名

**触发**: 第一次对话后自动生成标题

**示例**:
```
用户: 帮我实现用户登录功能
AI: [回复...]

# 会话自动命名为: "Implement User Login"
```

### 3. Session 信息栏

**位置**: 输入框下方

**显示内容**:
- 会话名称
- 会话标题
- 消息数量
- 文件数量

**示例**:
```
 ┌────────────────────────────────────────────────┐
 │ Session: my-project | Implement API           │
 │ 15 msgs | 8 files                             │
 └────────────────────────────────────────────────┘

 > _
```

### 4. 文件自动追踪

**功能**: 自动统计会话中提到的文件

**支持格式**:
- `.cj` - 仓颉源文件
- `.md` - Markdown 文档
- `.txt` - 文本文件
- `.json` - JSON 配置
- `.sh` - Shell 脚本

---

## 🎯 使用场景

### 场景 1: 开发新功能

```bash
# 1. 创建新会话
/new

# 2. 开始对话
> 帮我实现用户注册功能

# 3. 会话自动命名为 "Implement User Registration"

# 4. 继续对话...
> 添加邮箱验证

# 5. 完成后保存（自动保存，无需手动）
```

### 场景 2: 修复 Bug

```bash
# 1. 创建新会话
/new

# 2. 重命名
/rename Fix Login Bug

# 3. 开始调试
> 用户登录时出现 token 过期错误

# 4. 切换到其他任务
/new

# 5. 稍后返回
/switch fix-login-bug
```

### 场景 3: 多项目管理

```bash
# 项目 A
/new
/rename Project A - API Development

# 项目 B
/new
/rename Project B - Frontend

# 查看所有项目
/sessions

# 在项目间切换
/switch project-a-api-development
```

---

## 💡 最佳实践

### 1. 会话命名

**推荐**:
- `Implement User Login`
- `Fix JWT Bug`
- `Refactor Database Layer`

**不推荐**:
- `新功能`
- `bug`
- `代码`

### 2. 会话管理

- ✅ 每个独立任务创建新会话
- ✅ 使用描述性的标题
- ✅ 定期查看 `/sessions` 清理旧会话
- ✅ 长期项目保持一个会话

### 3. 文件引用

使用 `@` 引用文件：

```bash
 > @src/main.cj 这个文件有什么问题？
```

### 4. 命令执行

使用 `!` 执行 shell 命令：

```bash
 > !ls -la src/
```

---

## 🔧 常见问题

### Q: 如何保存当前会话？

**A**: 自动保存，无需手动操作。退出时自动保存为 `last-conversation`。

### Q: 如何删除会话？

**A**: 使用传统命令：
```bash
/conversation remove <session-name>
```

### Q: 会话数据存在哪里？

**A**: 
- 会话内容: `.codelin/conversation-history/`
- 元数据: `.codelin/sessions/metadata/`

### Q: 如何备份会话？

**A**: 复制整个 `.codelin` 目录

### Q: AI 自动命名不工作？

**A**: 检查网络连接和 AI 服务配置。会自动回退到用户消息作为标题。

---

## 📚 完整命令列表

### Session 命令

| 命令 | 说明 | 示例 |
|------|------|------|
| `/new` | 创建新会话 | `/new` |
| `/sessions` | 列出所有会话 | `/sessions` |
| `/switch` | 切换会话 | `/switch my-project` |
| `/rename` | 重命名当前会话 | `/rename Fix Bug` |

### 传统命令 (保持兼容)

| 命令 | 说明 |
|------|------|
| `/conversation list` | 列出会话 |
| `/conversation save <name>` | 保存会话 |
| `/conversation resume <name>` | 恢复会话 |
| `/conversation remove <name>` | 删除会话 |

### 其他命令

| 命令 | 说明 |
|------|------|
| `/help` | 显示帮助 |
| `/clear` | 清空屏幕 |
| `/exit` | 退出 CLI |
| `@file` | 引用文件 |
| `!cmd` | 执行命令 |

---

## 🎯 对比：传统 vs 新方式

### 创建和切换会话

**传统方式**:
```bash
/conversation save my-session
# ... 做其他事
/conversation resume my-session
```

**新方式** (Claude Code 风格):
```bash
/new                    # 创建新会话
# ... 做其他事
/switch my-session      # 快速切换
```

### 查看会话

**传统方式**:
```bash
/conversation list
# 输出：
# • last-conversation (auto-saved)
# • my-session
```

**新方式**:
```bash
/sessions
# 输出：
# Sessions (2)
# 
#   ▶ last-conversation - My Test
#     my-session - Implement API
# 
# Commands: /new /switch /rename
```

---

## 🚀 高级技巧

### 1. 快速切换最近会话

```bash
/sessions              # 查看列表
/switch <按 Tab 补全>  # 自动补全会话名
```

### 2. 批量管理

```bash
# 查看所有会话
/sessions

# 删除旧会话
/conversation remove old-session-1
/conversation remove old-session-2
```

### 3. 搜索会话

目前通过 `/sessions` 手动查找。  
计划中：`/search keyword`

---

## 📊 总结

### ✅ 已实现

- [x] 自动恢复上次会话
- [x] Claude Code 风格命令
- [x] AI 自动命名
- [x] Session 信息栏显示
- [x] 文件自动追踪
- [x] 简洁的 UI

### ⚪ 计划中 (P2)

- [ ] Session 导出/导入
- [ ] 标签管理 UI
- [ ] 搜索功能 UI
- [ ] 统计图表

---

## 🎉 开始使用

现在就启动 CodeLin，体验 Claude Code 级别的 Session 管理！

```bash
cjpm run --name cli
```

**祝你使用愉快！** 🚀✨

---

**文档版本**: v1.0  
**更新日期**: 2024-10-27  
**状态**: ✅ 完整

