# CodeLin MCP 配置指南

**日期**: 2025-01-XX  
**参考**: Claude Code 和 Cursor MCP 配置格式

---

## 📋 配置文件位置

CodeLin 的 MCP 配置文件位于：
```
~/.codelin/codelin.json
```

或者项目级配置：
```
.codelin/codelin.json
```

---

## 🔧 配置格式

### 基本结构

```json
{
  "language": "cangjie",
  "model": "zhipuai:glm-4.6",
  "mcpServers": {
    "server-name": {
      "command": "npx",
      "args": ["-y", "@package/name"],
      "env": {
        "API_KEY": "your-key"
      }
    }
  }
}
```

### Stdio MCP 服务器配置

**格式**：
```json
{
  "mcpServers": {
    "server-name": {
      "command": "command-to-run",
      "args": ["arg1", "arg2"],
      "env": {
        "ENV_VAR": "value"
      }
    }
  }
}
```

**示例**：
```json
{
  "mcpServers": {
    "context7": {
      "command": "npx",
      "args": [
        "-y",
        "@upstash/context7-mcp"
      ],
      "env": {
        "CONTEXT7_API_KEY": "your-api-key"
      }
    }
  }
}
```

### SSE MCP 服务器配置

**格式**：
```json
{
  "mcpServers": {
    "server-name": {
      "url": "https://mcp-server.example.com/sse"
    }
  }
}
```

**示例**：
```json
{
  "mcpServers": {
    "remote-server": {
      "url": "https://mcp.example.com/sse"
    }
  }
}
```

---

## 📝 当前配置的 MCP 服务器

根据 Claude Code 和 Cursor 的配置，已配置以下 MCP 服务器：

### 1. Context7
- **用途**: 文档查询服务
- **命令**: `npx -y @upstash/context7-mcp`
- **环境变量**: `CONTEXT7_API_KEY`

### 2. Sequential Thinking
- **用途**: 顺序思考服务
- **命令**: `npx -y @modelcontextprotocol/server-sequential-thinking`

### 3. Playwright MCP
- **用途**: 浏览器自动化
- **命令**: `uvx playwright-mcp`

### 4. Mastra
- **用途**: Mastra 文档服务
- **命令**: `npx -y @mastra/mcp-docs-server`

### 5. Shadcn UI Server
- **用途**: UI 组件服务
- **命令**: `/Users/louloulin/Desktop/shadcn-ui-server/build/index.js`

---

## 🔍 配置验证

### 方法 1: JSON 格式验证
```bash
python3 -m json.tool ~/.codelin/codelin.json
```

### 方法 2: 启动 CodeLin 验证
```bash
cjpm run --name cli
# 然后输入 /mcp 查看加载的服务器
```

### 方法 3: 检查日志
启动 CodeLin 时，查看日志中是否有：
```
[INFO] Creating Stdio MCP client for context7 with command: ...
[INFO] Successfully loaded MCP server: context7
```

---

## 🛠️ 配置管理

### 添加 MCP 服务器

**方法 1: 使用命令（推荐）**
```bash
# 在 CodeLin 中
/mcp add context7 npx -y @upstash/context7-mcp --env CONTEXT7_API_KEY=your-key
```

**方法 2: 直接编辑配置文件**
编辑 `~/.codelin/codelin.json`，添加服务器配置。

### 移除 MCP 服务器

**方法 1: 使用命令**
```bash
# 在 CodeLin 中
/mcp remove server-name
```

**方法 2: 直接编辑配置文件**
从 `mcpServers` 对象中删除对应的服务器配置。

### 查看已加载的服务器
```bash
# 在 CodeLin 中
/mcp
# 或
/mcp list
```

---

## 📊 配置对比

### Claude Code 格式
```json
{
  "mcpServers": {
    "context7": {
      "command": "npx",
      "args": ["-y", "@upstash/context7-mcp@latest"]
    }
  }
}
```

### Cursor MCP 格式
```json
{
  "mcpServers": {
    "context7": {
      "command": "npx",
      "args": ["-y", "@upstash/context7-mcp"],
      "env": {
        "CONTEXT7_API_KEY": "key"
      }
    }
  }
}
```

### CodeLin 格式（兼容两者）
```json
{
  "mcpServers": {
    "context7": {
      "command": "npx",
      "args": ["-y", "@upstash/context7-mcp"],
      "env": {
        "CONTEXT7_API_KEY": "key"
      }
    }
  }
}
```

**结论**: CodeLin 的配置格式与 Claude Code 和 Cursor 完全兼容！

---

## ⚠️ 注意事项

1. **重启要求**: 修改配置文件后，需要重启 CodeLin 才能生效
2. **JSON 注释**: CodeLin 支持 `//` 注释（会自动过滤）
3. **环境变量**: 敏感信息（如 API Key）建议使用环境变量
4. **路径格式**: 
   - macOS/Linux: 使用绝对路径或 `~` 展开
   - Windows: 使用绝对路径或相对路径

---

## 🔗 相关文档

- [CodeLin MCP 文档](docs/mcp.md)
- [Claude Code MCP 文档](https://docs.claude.com/en/docs/claude-code/mcp)
- [MCP 协议规范](https://modelcontextprotocol.io)

---

**最后更新**: 2025-01-XX

