# CodeLin LLM Provider 配置指南

**日期**: 2025-11-25  
**版本**: CodeLin v11.0+

---

## 📋 概述

CodeLin 使用 **CangjieMagic** 框架来管理 LLM provider 配置。配置分为两部分：

1. **环境变量配置** (`.env` 文件) - 配置 API keys 和 base URLs
2. **模型选择配置** (`codelin.json`) - 选择使用哪个模型

---

## 🔧 配置方式

### 方式 1: 环境变量配置（推荐）

#### 配置文件位置

CodeLin 会按以下顺序查找 `.env` 文件：

1. **项目根目录**: `./.env`
2. **用户配置目录**: `~/.codelin/.env`
3. **工作目录**: `$WORKSPACE/.env`

#### 配置格式

在 `.env` 文件中配置 API keys 和 base URLs：

```bash
# ============================================
# 智谱 AI (ZhipuAI) - 默认推荐
# ============================================
ZHIPU_API_KEY=your_zhipu_api_key_here

# 可选：自定义 API base URL（如果需要）
# ZHIPU_BASE_URL=https://open.bigmodel.cn/api/paas/v4

# ============================================
# 华为 MaaS (ModelArts)
# ============================================
MAAS_BASE_URL=https://api.modelarts-maas.com/v2
MAAS_API_KEY=your_maas_api_key_here

# ============================================
# Moonshot AI
# ============================================
MOONSHOT_API_KEY=your_moonshot_api_key_here
# MOONSHOT_BASE_URL=https://api.moonshot.cn/v1  # 可选

# ============================================
# OpenAI (如果使用)
# ============================================
OPENAI_API_KEY=your_openai_api_key_here
# OPENAI_BASE_URL=https://api.openai.com/v1  # 可选

# ============================================
# Anthropic Claude (如果使用)
# ============================================
ANTHROPIC_API_KEY=your_anthropic_api_key_here
# ANTHROPIC_BASE_URL=https://api.anthropic.com  # 可选

# ============================================
# 其他 Provider
# ============================================
# 根据 CangjieMagic 支持的 provider 添加相应的环境变量
```

#### 环境变量命名规则

CangjieMagic 使用以下命名规则：

- **API Key**: `{PROVIDER}_API_KEY` 或 `{PROVIDER}_KEY`
- **Base URL**: `{PROVIDER}_BASE_URL` 或 `{PROVIDER}_URL`

**支持的 Provider 前缀**:
- `ZHIPU` - 智谱 AI
- `MAAS` - 华为 MaaS
- `MOONSHOT` - Moonshot AI
- `OPENAI` - OpenAI
- `ANTHROPIC` - Anthropic
- `GOOGLE` - Google (Gemini)
- `DEEPSEEK` - DeepSeek
- 其他 CangjieMagic 支持的 provider

---

### 方式 2: 模型选择配置

#### 配置文件位置

1. **项目级配置**: `.codelin/codelin.json` 或 `.codelin/codelin.json`
2. **用户级配置**: `~/.codelin/codelin.json`

#### 配置格式

```json
{
  "language": "general",
  "model": "zhipuai:glm-4.6",
  "fastModel": "zhipuai:glm-4-flash",
  "fallbackModels": ["zhipuai:glm-4"],
  "temperature": 1.0
}
```

#### 模型名称格式

模型名称格式：`{provider}:{model-name}`

**示例**:
- `zhipuai:glm-4.6` - 智谱 AI GLM-4.6
- `zhipuai:glm-4-flash` - 智谱 AI GLM-4 Flash
- `maas:deepseek-v3.2-exp` - 华为 MaaS DeepSeek v3.2
- `moonshot:moonshot-v1-128k` - Moonshot AI
- `openai:gpt-4o` - OpenAI GPT-4o
- `anthropic:claude-3-5-sonnet-20241022` - Anthropic Claude

---

## 📝 完整配置示例

### 示例 1: 使用智谱 AI（默认）

**`.env` 文件**:
```bash
ZHIPU_API_KEY=99a311fa7920a59e9399cf26ecc1e938.ac4w6buZHr2Ggc3k
```

**`codelin.json` 文件**:
```json
{
  "language": "general",
  "model": "zhipuai:glm-4.6",
  "fastModel": "zhipuai:glm-4-flash",
  "fallbackModels": ["zhipuai:glm-4"],
  "temperature": 1.0
}
```

### 示例 2: 使用华为 MaaS

**`.env` 文件**:
```bash
MAAS_BASE_URL=https://api.modelarts-maas.com/v2
MAAS_API_KEY=Mq31xUbZrM1z5qthjWyZTX4Uj-CAlt9Gvy8VmOPx7gw9zASSDHLhN2s46UqQOByuZf8xA4rE057ssY0D78oEmA
```

**`codelin.json` 文件**:
```json
{
  "language": "general",
  "model": "maas:deepseek-v3.2-exp",
  "fastModel": "maas:deepseek-v3",
  "fallbackModels": ["zhipuai:glm-4"],
  "temperature": 1.0
}
```

### 示例 3: 使用自定义 API URL

**`.env` 文件**:
```bash
# 使用自定义的智谱 AI API endpoint
ZHIPU_API_KEY=your_api_key_here
ZHIPU_BASE_URL=https://custom-api.example.com/v4

# 或使用华为 MaaS 自定义 endpoint
MAAS_BASE_URL=https://custom-maas.example.com/v2
MAAS_API_KEY=your_api_key_here
```

**`codelin.json` 文件**:
```json
{
  "language": "general",
  "model": "zhipuai:glm-4.6",
  "temperature": 1.0
}
```

---

## 🔍 配置加载流程

CodeLin 的配置加载流程如下：

```
1. 启动时加载环境变量
   └─> Config.env.load(Path("./.env"))
       └─> 从 .env 文件读取 API keys 和 base URLs

2. 加载模型配置
   └─> CliSettingManager.load()
       └─> 从 codelin.json 读取模型选择

3. 创建模型实例
   └─> ModelManager.createChatModel(model)
       └─> 使用环境变量中的 API key 和 base URL
```

**代码位置**:
- 环境变量加载: `src/parse_args.cj:88`
- 模型配置加载: `src/core/config/cli_setting.cj`
- 模型创建: `src/core/config/cli_config.cj:264`

---

## 🛠️ 高级配置

### 自定义 Provider Base URL

如果某个 provider 需要自定义 base URL，可以在 `.env` 文件中设置：

```bash
# 示例：使用代理或自定义 endpoint
ZHIPU_BASE_URL=https://proxy.example.com/zhipuai/v4
MAAS_BASE_URL=https://internal-maas.company.com/v2
OPENAI_BASE_URL=https://api.openai-proxy.com/v1
```

### 多 Provider 配置

可以同时配置多个 provider，然后在 `codelin.json` 中选择使用：

**`.env` 文件**:
```bash
ZHIPU_API_KEY=key1
MAAS_BASE_URL=https://api.modelarts-maas.com/v2
MAAS_API_KEY=key2
MOONSHOT_API_KEY=key3
```

**`codelin.json` 文件**:
```json
{
  "model": "zhipuai:glm-4.6",
  "fallbackModels": ["maas:deepseek-v3.2-exp", "moonshot:moonshot-v1-128k"]
}
```

### 通过命令行参数覆盖

可以在运行时通过命令行参数覆盖配置：

```bash
# 覆盖模型
codelin --model maas:deepseek-v3.2-exp

# 覆盖 fast model
codelin --fast-model zhipuai:glm-4-flash

# 覆盖 fallback models
codelin --fallback-models "maas:deepseek-v3.2-exp,zhipuai:glm-4"

# 覆盖 temperature
codelin --temperature 0.7
```

---

## 🔐 安全建议

### 1. 不要提交 `.env` 文件到 Git

确保 `.env` 文件在 `.gitignore` 中：

```gitignore
# Environment variables
.env
.codelin/.env
```

### 2. 使用环境变量而不是硬编码

❌ **错误**:
```cangjie
// 不要这样做
let apiKey = "your_api_key_here"
```

✅ **正确**:
```bash
# 在 .env 文件中
ZHIPU_API_KEY=your_api_key_here
```

### 3. 使用 `.env.example` 作为模板

创建 `.env.example` 文件作为模板：

```bash
# .env.example
ZHIPU_API_KEY=your_zhipu_api_key_here
MAAS_BASE_URL=https://api.modelarts-maas.com/v2
MAAS_API_KEY=your_maas_api_key_here
```

---

## 🐛 故障排查

### 问题 1: API Key 未找到

**错误信息**:
```
Error: API key not found for provider: zhipuai
```

**解决方案**:
1. 检查 `.env` 文件是否存在
2. 检查环境变量名称是否正确（如 `ZHIPU_API_KEY`）
3. 检查 `.env` 文件是否在正确的位置
4. 确保环境变量没有多余的空格

### 问题 2: Base URL 无效

**错误信息**:
```
Error: Failed to connect to API endpoint
```

**解决方案**:
1. 检查 `{PROVIDER}_BASE_URL` 环境变量是否正确
2. 确保 URL 格式正确（包含 `https://`）
3. 检查网络连接和防火墙设置
4. 验证 API endpoint 是否可访问

### 问题 3: 模型名称无效

**错误信息**:
```
Error: Unknown model: xxx:yyy
```

**解决方案**:
1. 检查模型名称格式：`{provider}:{model-name}`
2. 确认 provider 名称正确（如 `zhipuai`, `maas`, `moonshot`）
3. 检查 CangjieMagic 是否支持该 provider
4. 查看 `src/core/config/model_token_limits.cj` 中支持的模型列表

### 问题 4: 配置未生效

**解决方案**:
1. 确保 `.env` 文件在正确的位置
2. 重启 CodeLin 应用（环境变量在启动时加载）
3. 检查 `codelin.json` 文件格式是否正确（JSON 格式）
4. 查看日志文件确认配置加载情况

---

## 📚 相关文件

- **环境变量加载**: `src/parse_args.cj:88`
- **模型配置**: `src/core/config/cli_setting.cj`
- **模型创建**: `src/core/config/cli_config.cj:263-267`
- **Token 限制**: `src/core/config/model_token_limits.cj`
- **配置示例**: `.codelin/codelin.json`

---

## 🔗 参考资源

- [CangjieMagic 文档](https://github.com/cangjiepl/CangjieMagic) - CangjieMagic 框架文档
- [智谱 AI 文档](https://open.bigmodel.cn/) - 智谱 AI API 文档
- [华为 MaaS 文档](https://support.huaweicloud.com/maas/) - 华为 MaaS API 文档

---

**最后更新**: 2025-11-25  
**维护者**: CodeLin Team

