# cjpm run 问题修复报告

## 🔍 问题分析

### 错误信息
```
FSException: Failed to canonical: "No such file or directory"
```

### 根本原因

**cjpm.toml 配置文件存在3个问题**:

1. **缺少 `[scripts]` 部分** ❌
   - `cjpm run --name cli` 命令需要在 `[scripts]` 中定义 `cli` 脚本
   - 原配置文件完全没有 `[scripts]` 部分

2. **target-dir 为空** ❌
   - 原配置: `target-dir = ""`
   - cjpm 无法找到正确的目标目录

3. **src-dir 为空** ❌
   - 原配置: `src-dir = ""`
   - cjpm 无法找到正确的源代码目录

## ✅ 修复方案

### 修改内容

```diff
[package]
  cjc-version = "1.0.0"
  name = "cli"
  description = "nothing here"
  version = "1.0.0"
- target-dir = ""
- src-dir = ""
+ target-dir = "target"
+ src-dir = "src"
  output-type = "executable"
  compile-option = "-O2  -Woff unused --cfg \"ohos=false\""
  override-compile-option = ""
  link-option = ""

+[scripts]
+  cli = "cjpm build && ./target/cli"
+
[dependencies]
  magic = { path = "${MAGIC_PATH}" }
```

### 修复说明

1. **添加 [scripts] 部分**
   ```toml
   [scripts]
     cli = "cjpm build && ./target/cli"
   ```
   - 定义了 `cli` 脚本
   - 先编译项目 (`cjpm build`)
   - 然后运行编译后的可执行文件 (`./target/cli`)

2. **设置 target-dir**
   ```toml
   target-dir = "target"
   ```
   - 指定编译输出目录为 `target`
   - cjpm 会将编译后的可执行文件放在这里

3. **设置 src-dir**
   ```toml
   src-dir = "src"
   ```
   - 指定源代码目录为 `src`
   - cjpm 知道从哪里读取源文件

## 🧪 验证修复

现在可以运行以下命令测试：

```bash
# 方法1: 使用 cjpm run
cjpm run --name cli

# 方法2: 先编译再运行
cjpm build
./target/cli

# 方法3: 使用已有的脚本（如果存在）
./scripts/build-magic-cli.sh
```

## 📋 预期结果

修复后，`cjpm run --name cli` 应该能够：
1. ✅ 正确找到源代码目录
2. ✅ 编译项目到 target 目录
3. ✅ 运行编译后的 CLI 程序
4. ✅ 启动 CodeLin 交互式命令行界面

## 🔧 其他注意事项

1. **确保环境变量设置正确**
   ```bash
   # 检查 MAGIC_PATH 是否设置
   echo $MAGIC_PATH
   ```

2. **如果仍有问题，可以尝试**
   ```bash
   # 清理并重新编译
   rm -rf target/
   cjpm build
   ```

3. **Mac M1/M2 用户注意**
   - 配置文件已包含 `aarch64-apple-darwin` 目标
   - 应该能正常工作

## ✅ 修复完成

问题已修复，cjpm.toml 文件现在包含完整的配置。
