# CodeLin 21：仓颉函数式平台化改造蓝图

## 0. 背景与任务
- 全局分析 `codelin/` 主体与 `codebuff/` 对标项目，吸收 Claude Code、Cursor Augment Code、Claude Agent SDK 的长处。
- 彻底拥抱仓颉函数式特性，降低 `reports/jscpd/jscpd-report.json` 中暴露的高重复率，构建可面向开源/闭源与跨领域扩展的平台。
- 交付包含模块化/包级设计、插件模型、阶段性实施路线与质量控制的权威计划。

---

## 1. 现状洞察
### 1.1 核心能力（优势）
- **上下文引擎**：已有按预算分配 token、对话感知合并的逻辑，具备对标 Claude Code / Codebuff 的雏形。  

```872:931:src/core/context/context_engine.cj
    public func buildContextWithBudget(query: String, totalBudget: Int64): String {
        // 1. 分配token预算
        let allocation = this.allocateTokenBudget(query, totalBudget)
        ...
        return String.join(contextParts.toArray(), delimiter: "\n")
    }
```

```932:1031:src/core/context/context_engine.cj
    public func buildContextFromConversation(
        query: String,
        conversation: Conversation,
        budget: Int64
    ): Array<FileContext> {
        ...
        // Claude Code / CodeBuff 风格对话感知上下文
    }
```

- **CLI 多层工作流**：`src/app/cli_app.cj` 已引入 SubAgent Registry、自动上下文、Layer Workflow，对准 Codebuff 的多代理流水线。  

```240:452:src/app/cli_app.cj
        // 🆕 Claude Code style: Set agent name in status bar
        ...
    public func buildAutoContextSection(userInput: String): Option<String> {
        return this.contextOrchestrationService.buildAutoContextSection(...)
    }
```

- **函数式改造已有基础**：`FUNCTIONAL_PROGRAMMING_PLAN.md` 清楚定义了不可变状态、IOEffect、管道/组合等策略，可直接推广到所有核心包。

### 1.2 主要痛点
- **重复率高**：`reports/jscpd/jscpd-report.json` 显示 telemetry exporter 等文件重复率 23%~84%（如 `console_exporter.cj` 80.65%）。必须用函数式抽象+包拆分降低复制。
- **单体耦合**：核心模块紧耦合在 `src/`，难以提供插件或产品化分层。
- **跨项目知识复用不足**：`codebuff/` 中成熟的多代理与 SDK 生态未与仓颉主干对齐。

---

## 2. 对标系统要点
- **Codebuff**：多代理流水线、CLI/SDK 并进、Agent Store/插件化设计（`codebuff/README.md`），是平台化与开放生态的直接模板。
- **Claude Code**：以对话为中心的上下文、面向任务的 UI/状态联动，需要在 CLI/TUI/未来 IDE 插件中复刻体验。
- **Cursor Augment Code**：以“增量、可视”变更著称，强调对现有窗口的补充式交互→指引我们打造多界面 Surface 层（CLI、TUI、未来 GUI/IDE Hook）。
- **Claude Agent SDK**（Anthropic 公布的 Agent SDK 提供 Tool Schema、Memory、Workflow Hooks）：提示我们在仓颉端定义统一的 Agent Schema 与工具注入协议，方便闭源托管与第三方插件共存。

---

## 3. 新架构原则
1. **高内聚 / 低耦合**：每个包聚焦单一领域（上下文、会话、代理、工具、界面、平台服务）。
2. **函数式优先**：不可变状态 + 纯函数 + IOEffect 边界，仓颉特性全局一致。
3. **可插拔平台**：所有扩展点暴露统一的 `Plugin` / `Agent` / `Tool` 接口元数据，支持开源社区与闭源商业套餐。
4. **跨领域扩展**：上下文/任务模型抽象为“知识域”，不限于编程，可接入文案、数据分析等 Agent。

---

## 4. CodeLin 21 平台蓝图

```
┌──────────────────────────────────────────────────┐
│ Experience Surfaces (CLI, TUI, IDE, Web)         │
│  - Layer Workflows · Cursor-style Augment Panel  │
└──────────────────────────────────────────────────┘
┌──────────────────────────────────────────────────┐
│ Agent Orchestration Layer                        │
│  - Multi-Agent Planner · Reviewer/Test Mesh      │
│  - Claude Agent SDK Compatible API               │
└──────────────────────────────────────────────────┘
┌──────────────────────────────────────────────────┐
│ Context & Knowledge Platform                      │
│  - Conversation Fabric · FileGraph · Cache       │
│  - Domain Packs (code, docs, data, creative)     │
└──────────────────────────────────────────────────┘
┌──────────────────────────────────────────────────┐
│ Functional Runtime Core                           │
│  - IOEffect Executor · StateStore · Tool Bus     │
│  - CangjieMagic SDK bindings                     │
└──────────────────────────────────────────────────┘
```

### 4.1 包/模块化设计
| 层 | 新包 (建议路径) | 职责 | 扩展点 |
| --- | --- | --- | --- |
| Functional Core | `src/runtime/` | IOEffect、StateManager、管道工具库 | `RuntimePlugin`（替换调度/日志实现） |
| Context Platform | `src/platform/context/` | `ContextState`, `ConversationState`, FileGraph、Topic/Dependency 分析 | `ContextProvider`, `KnowledgePack` |
| Agent Mesh | `src/platform/agents/` | 多代理调度、策略、工具注册 | `AgentDefinition`（兼容 Claude Agent SDK / Codebuff） |
| Tool Bus | `src/platform/tools/` | FSToolset、LSP、外部 MCP、CangjieMagic Tool | `ToolPlugin`（提供 schema + executor） |
| Experience | `src/surfaces/{cli,tui,ide}` | CLI/TUI/IDE 适配层 | `SurfacePlugin`（Cursor Augment / VSCode） |
| Product Shell | `packages/{oss,enterprise}` | 打包配置、授权、远程服务 | `FeatureFlag`, `LicenseHook` |

### 4.2 面向开源/闭源
- **OSS Base**：核心 runtime + context + CLI/TUI，遵守 Apache/MIT。
- **Enterprise/闭源**：在 `packages/enterprise/` 增加审计、团队协作、云存储模块，通过 `LicenseHook` 启用。

---

## 5. 仓颉函数式策略推广
1. **统一状态容器**：以 `ContextState`/`ConversationState`(见 `FUNCTIONAL_PROGRAMMING_PLAN.md`) 为模板，在 Agent、Tool、Surface 各层创建对应不可变 `State` 结构体。
2. **构建器 -> 纯函数**：大于 50 行的逻辑拆分为 `transformX(state, input) -> (state, effects)`。
3. **副作用隔离**：所有 IO 放入 `IOEffect`，通过 `RuntimeExecutor` 注入，可在 OSS/闭源之间替换。
4. **组合式流程**：定义 `pipe`, `compose`, `foldMap` 等 util，支持 `ContextPipeline`, `AgentPipeline`.
5. **测试矩阵**：纯函数单测 + IOEffect 模拟器，使 `cjpm test` 可快速验证。

---

## 6. 重复率治理与质量体系
- **策略**：
  1. `source/magic-cli/src/telemetry/otel/*` 抽象出 `TelemetryExporter` 接口 + 模板函数，复用序列化、重试逻辑，目标重复率 < 15%。
  2. `fs_utils`、`tool` 系列抽公共 `FileOp` Trait，减少 head/tail/grep 的重复代码。
  3. 在 Runtime 层引入 `Functional Template Library (FTL)`，通过高阶函数封装常见的 try/log 模式。
- **指标**：
  - Jscpd 总重复率下降 50%+；
  - 每个包新增 `dup-baseline.json`，CI 失败门槛设为 +5%；
  - 结合 `reports/jscpd` 生成差异表并推送到 `reports/dedup-history/`.

---

## 7. 插件与平台化设计
- **Plugin 描述文件**：`plugin.toml`（名称、版本、依赖、声明的 `Tool/Agent/Surface`）。
- **运行时加载顺序**：Runtime -> Tool Bus -> Agent Mesh -> Surface；任何插件可声明 Hook，在 `RuntimePluginRegistry` 中注册。
- **第三方模型 & Claude Agent SDK**：通过 `AgentDefinition` JSON Schema 兼容 Claude Agent SDK（Tool schema、Memory、Workflow Hook），并暴露到 `codebuff` SDK 生态，形成跨生态互联。
- **Cursor Augment Code 模式**：Surface 层实现“增强面板”，拦截 IDE 选区->转换为 `TaskUnit` -> 调用 Agent Mesh -> 注入结果，CLI 与 GUI 共享同一状态。

---

## 8. 跨领域知识包
- **Domain Pack**：`KnowledgePack` 接口，包含 `extractContext(state)`, `scoreRelevance`, `renderSummary`。
- **内置包**：`code`, `docs`, `data`, `creative`；允许外部通过插件增加医学、法律等。
- **CangjieMagic 对接**：使用 `cangjiemagic` 的函数式工具链，为不同 Domain 提供特化的解析器/格式化器。

---

## 9. 实施路线（建议 12 周）
| 阶段 | 周期 | 目标 | 关键交付 |
| --- | --- | --- | --- |
| Phase 0 | Week 1 | 建立 Runtime/IOEffect 库，整理重复率基线 | `runtime/` 包 + `dup-baseline` |
| Phase 1 | Week 2-4 | Context & Conversation 平台化（函数式） | `ContextState`、`ConversationState`、对话管道 |
| Phase 2 | Week 5-7 | Agent Mesh & Plugin API，兼容 Codebuff/Claude SDK | `AgentDefinition` Schema、Plugin Loader |
| Phase 3 | Week 8-9 | Experience Surfaces：CLI v2、TUI、Cursor Augment Hook | `surfaces/cli_v2`、`surfaces/tui`、IDE POC |
| Phase 4 | Week 10-11 | Domain Packs + Dup Refactor（Telemetry、Tools） | `knowledge-packs/`、重复率 < 20% |
| Phase 5 | Week 12 | 开源/闭源分层封装、CI Gate、Docs | `packages/oss`、`packages/enterprise`、平台文档 |

---

## 10. 近期行动清单
1. **立刻**：创建 `src/runtime`，实现 `StateManager`, `IOEffect`, `pipe/compose`（直接复用 FUNCTIONAL_PROGRAMMING_PLAN 中设计）。
2. **两天内**：生成 `dup-baseline.json` 并在 CI 中启用 jscpd Diff。
3. **本周**：切分 `ContextEngine` 到 `platform/context`，暴露 `ContextProvider` 接口，同时起草 `AgentDefinition` JSON。
4. **短期**：使 CLI Surface 通过 `SurfacePlugin` 注册，验证 Cursor Augment 面板桥接。
5. **中期**：与 `codebuff/sdk` 互通，允许 Claude Agent SDK/Codebuff Agents 在 CodeLin Runtime 内运行。

---

本计划将 CodeLin 演进为“仓颉函数式多代理平台”，在维持现有 CLI 体验的同时，实现模块化、插件化、平台化的跨越，为未来开源社区与商业化版本奠定一致的技术底座。***
# CodeLin 2.1 平台化重构蓝图（Claude Code / CodeBuff / Cursor / Augment Code / CangjieMagic 综合方案）

> 面向仓颉生态的下一代平台化 Code Agent：以函数式内核为根、工具总线为骨、任务图为筋、体验层为肤，同时兼顾开源开放性与商用闭源扩展性。

---

## 1. 输入来源与关键洞察

- **重复率基线**：`cf.md` 显示 `src/` 与 `source/magic-cli/src/` 有 77 个同路径文件，平均相似度 0.725、加权相似度 0.891，54 个文件 >0.8——说明 IO、LSP、工具仍高度依赖 magic-cli，需要结构性切割。
- **上一版蓝图回顾**：`codelin20.md` 已提出 “Cangjie Kernel → Functional Services → Adapter Shell” 三层，但 Tool ABI、MissionGraph、平台化拆分尚未落地，仍缺乏开放插件策略与企业版隔离面。
- **CodeBuff 参考**：`codebuff/knowledge.md` 强调 WebSocket + Tool Bus、Bun/TypeScript 多代理、`ErrorOr<T>` 显式错误以及 CLI/IDE 双栈，这提示我们在仓颉内核也要维持同样的依赖注入与工具契约。
- **Claude Code 参考**：`CLAUDE_CODE_UI_IMPLEMENTATION.md` 展现 Session-aware 体验；Claude Code 体系强调 Conversation Round、主题演化、用户反馈回路，需要在 `ConversationPipeline` 中加入 Round Snapshot + 反馈消化。
- **Cangjie 函数式能力**：`src/core/utils/functional_utils.cj` 提供 `Result/Option`、`pipe`、`fold` 等组合子，为不可变状态机、MissionGraph fold/MapReduce 提供语言内建支持。
- **CangjieMagic 工具契约**：`CANGJIEMAGIC_TOOL_SYSTEM_ANALYSIS.md` 明确工具只能接受 `String/Int64/Bool` 等基本类型、必须声明 `parameters`，并强调 determinism；Tool ABI 必须原生满足这些约束并可扩展到 Cursor/Augment 风格插件。

---

## 2. 设计原则（高内聚 / 低耦合 / 可平台化）

1. **函数式内核优先**：所有核心模块公开 `Result<Option<T>>` 契约，状态演进使用 `state' = evolve(state, event)`，便于验证与并行化。
2. **工具与服务分层**：Tool ABI 只暴露纯函数描述，服务层通过 ToolBus/CommandBus 统一注入，杜绝 CLI 直接引用具体工具实现。
3. **MissionGraph 驱动的任务图**：把 Claude/Augment 的 Round/Task 模型函数式化，形成可视化的 `MissionGraph`，支持多领域代理协作。
4. **平台化双轨**：开源版（Community Core）暴露 Kernel + Tool ABI；闭源版（Enterprise Platform）叠加策略型插件、Quota、合规审计；两者共享协议，隔离实现。
5. **复用 guardrails**：CI 内置 AST 去重 + 语义 diff（继承 `cf.md` 基线），所有新增模块先跑重复率脚本再合并，防止回退到复制粘贴。

---

## 3. 目标架构拓扑

```
┌────────────────────────────────────────────────────────────────────────┐
│ Experience Plane (CLI / TUI / IDE / API Gateway)                       │
│  - Claude-style Session HUD                                            │
│  - Cursor-like CommandBus                                              │
│  - Platform APIs (multi-domain flows)                                  │
└───────────────┬────────────────────────────────────────────────────────┘
                │ IInteractionPort + ICommandBus + StreamingChannel
┌───────────────▼────────────────────────────────────────────────────────┐
│ Service Plane (Functional)                                             │
│  - ConversationPipelineService (Round + Feedback + Topic Evolution)    │
│  - ContextPipelineService (Claude context + Augment预算管理)           │
│  - MissionGraph Orchestrator (Augment风任务图 + CodeBuff子代理)        │
│  - ToolBusService (CodeBuff Tool Bus + CangjieMagic determinism)       │
│  - Timeline/TelemetryService (事件流)                                  │
└───────────────┬────────────────────────────────────────────────────────┘
                │ Kernel Contracts (Result<Option<T>>)
┌───────────────▼────────────────────────────────────────────────────────┐
│ Cangjie Kernel                                                         │
│  - IO/LSP Ports（事件驱动）                                           │
│  - ContextKernel (Round Snapshot, Memory DAG)                           │
│  - Tool ABI Compiler (CangjieMagic 注解 → ABI JSON)                    │
│  - Functional Primitives (`FunctionalUtils`)                            │
│  - Data Fabric (immutable caches, dedup index)                          │
└───────────────┬────────────────────────────────────────────────────────┘
                │ Plugin ABI (Toolset/SubAgent/MCP/Mission Pack)
┌───────────────▼────────────────────────────────────────────────────────┐
│ Extension Plane                                                        │
│  - Community Tool Packs (FS/LSP/Git)                                   │
│  - Enterprise Packs (Compliance, Analytics, Multi-domain verticals)     │
│  - MCP Bridges / Claude Agent SDK / Cursor Plugins                     │
└────────────────────────────────────────────────────────────────────────┘
```

---

## 4. 内核（Kernel）函数式化策略

- **状态模型**：每个 Kernel 模块暴露 `State` + `Event -> Result<State, Err>` 纯函数，禁止在模块外访问内部缓存。`FunctionalUtils` 已提供组合子，可直接复用：

```12:54:src/core/utils/functional_utils.cj
public enum Result<T, E> {
    | Ok(T)
    | Err(E)
}
```

- **ContextKernel 2.1**：
  - Round Snapshot：整合 Claude Code 的 Session/Topic/Feedback 概念，每轮生成 `RoundContextSnapshot`，供服务层/体验层共享。
  - Memory DAG：将 conversation、文件引用、工具输出组成不可变 DAG，支持时间旅行调试。
  - Token 管控：把 Augment Code 的预算策略函数式化，提供 `budget = fold(events, initialBudget, applyEvent)`。

- **Tool ABI Compiler**：
  - 解析 `@toolset/@tool` 注释（`CANGJIEMAGIC_TOOL_SYSTEM_ANALYSIS.md`）→ 生成 `tool.toml` + ABI JSON，自动验证参数类型、描述、deterministic tags。
  - 输出 deterministic metadata（hash of descriptor + dependency graph），供 ToolBus 复现加载顺序。

- **Data Fabric**：
  - 内置去重索引：利用 AST 指纹（`reports/jscpd/jscpd-report.json`）构建 `DedupIndex`，以函数式 map 形式存储，可在服务层快速查重。
  - Immutable Cache：IO/LSP 结果缓存以 `Result<Option<T>>` 表示，便于复用且不会污染状态。

---

## 5. 服务层：Conversation + MissionGraph + ToolBus

1. **ConversationPipelineService**（Claude Code parity）：
   - Round-aware：继承 `codelin20` 的 round pipeline，增加 `FeedbackDigest` 阶段吸收用户修正。
   - Topic Evolution：内置主题演化器（Claude 参考），通过 `pipe(snapshot, deriveTopics, annotateIntent)` 组合完成。
   - Output 结构：`RoundContextSnapshot + Budget + RecommendedTools`，供 CLI/TUI/IDE 共享。

2. **MissionGraph Orchestrator**（Augment Code + CodeBuff）：
   - 任务图描述：`MissionGraph = fold(commands |> map(toMissionNode))`；节点状态 `Pending/Running/Blocked/Done`。
   - 子代理接口：兼容 CodeBuff 的 generator agents（`handleSteps`），在仓颉中以 iterator/stream 表达，支持多阶段回调。
   - 并发执行：使用 `FunctionalUtils.flatMapResult` 串联可能失败的节点，保障 deterministic。

3. **ToolBusService**（CangjieMagic determinism + Cursor PluginBus）：
   - ABI 校验：加载前执行参数/描述/权限校验；不符合 `String/Int64/Bool` 直接拒绝。
   - Routing：`ToolBus.dispatch(request)` 先在 Kernel 内决策，再桥接 MCP、Claude Agent SDK、Cursor 插件。
   - Streaming/WS：借鉴 CodeBuff WebSocket pipeline，允许 Experience Plane 通过 WebSocket 订阅 ToolBus 事件。

4. **Timeline / Telemetry Service**：
   - 所有事件发布到 `EventStream`，Adapter 只订阅，不直接写状态，确保高内聚。
   - Enterprise Pack 可追加合规审计/指标采样而不修改核心逻辑。

---

## 6. 体验层：多端统一 & 多领域扩展

- **CLI/TUI**：继续沿用 Claude Code 风格 HUD（`CLAUDE_CODE_UI_IMPLEMENTATION.md`），并在 prompt 内嵌 MissionGraph 视图（ASCII DAG）与 ToolBus 事件热力图。
- **IDE/Browser**：抽象 Cursor CommandBus 接口，IDE 插件也只需实现 `IInteractionPort` + streaming renderer。
- **API Gateway**：开放 `POST /mission`、`GET /rounds/{id}` 等 REST/gRPC，供垂直领域（数据分析、DevOps、合规审计）调用，实现 “不止编程” 的多领域场景。
- **多领域 Template**：在 `docs/platform/templates/` 提供 “代码生产 / 数据自动化 / 文档编排 / 运维调度” 任务图模版，搭配 Tool Packs 实现快速垂直扩展。

---

## 7. 平台化与双版本策略

| 维度 | Community Core（开源） | Enterprise Platform（闭源） |
| --- | --- | --- |
| Kernel / Service / Tool ABI | ✅ 完整提供 | ✅ 继承 |
| MissionGraph 模版 | 基础开发/重构套件 | 行业任务包（安全、数据、流程） |
| Tool Packs | FS / Git / LSP / Context | 扩展合规、私有 API、Quota 管理 |
| Observability | 本地日志 + Timeline | 分布式遥测、审计、SLA |
| 插件商店 | 手动注册 | 图形化 Plugin Store + 签名 |
| 部署模式 | CLI/本地 | 平台化（SaaS + On-prem） |

实施方式：
- 核心 repo 暴露 Kernel + Service 接口，Enterprise 版作为私有子仓库或子模块，只添加策略模块/Tool Pack。
- 插件签名：Tool ABI 生成 deterministic hash，Enterprise Store 只接受签名包，保证与 CangjieMagic 的 deterministic 搜索一致。

---

## 8. 重复率治理与代码健康

1. **结构化去重**：在 `tools/dedup_stats.py` 基础上，新增 AST token diff（参考 `reports/jscpd/jscpd-report.json`），并把阈值收紧到：平均相似度 < 0.35，单文件 >0.6 直接阻断。
2. **Kernel 抽离**：`src/core`, `src/io`, `src/lsp` 中来源于 magic-cli 的实现迁入 `legacy/`，逐步用纯函数替换。
3. **CI 规则**：新增 `scripts/check-abi-determinism.cj`、`scripts/check-functional-boundary.cj`，确保 Adapter 不可引用 Kernel 实现、Tool ABI 不可绕过编译器。
4. **知识库更新**：定期同步 `codebuff/`、`Claude`、`Cursor`、`Augment` 新特性，写入 `docs/competitors/*.md`，防止方案老化。

---

## 9. 改造路线（10 周周期，可并行）

### Phase 0（Week 0-1）Guardrail & Baseline
- 启动重复率脚本 + AST diff，并在 CI 中开启阻断阈值。
- 拆分 `kernel/`、`services/`、`adapters/` 目录；把 magic-cli 兼容层放入 `legacy/`.
- 生成 Tool ABI Blueprint（自动扫描 `@toolset` 注释，输出 ABI 清单）。

### Phase 1（Week 2-4）Kernel 函数式化
- 实现 `ContextKernel 2.1`（Round Snapshot + Memory DAG）。
- 重写 IO/LSP Port → 事件驱动 API；提供 `Result<Option<T>>` 输出。
- 构建 Tool ABI Compiler + deterministic 校验，并附自动化测试。

### Phase 2（Week 4-6）Service Plane
- 完成 ConversationPipelineService & MissionGraph Orchestrator，并与 ToolBus 对接。
- 引入 CodeBuff 风格 WebSocket ToolBus，贯通 CLI/TUI/IDE。
- 发布 `mission_graph_playbook.md` + 示例任务（代码、数据、流程）。

### Phase 3（Week 6-8）体验与多领域模板
- 升级 CLI/TUI UI（Session HUD、MissionGraph 视图）。
- 发布 API Gateway + SDK（Cangjie/CJPM 包 + TS SDK）供外部调用。
- 提供多领域模板（数据管道、DevOps、文档生成、治理），验证 “不止编程”。

### Phase 4（Week 8-10）平台化与治理
- 切分 Community vs Enterprise 包装（Tool Pack、合规模块）。
- 插件签名 / Store：实现 deterministic hash + 签名验证。
- 建立月度重复率/健康报告 pipeline，输出 `docs/changelog/dedup-YYYYMM.md`。

---

## 10. 验证矩阵（Claude / CodeBuff / Cursor / Augment / CangjieMagic）

| 验证项 | 目标 | 工具/测试 |
| --- | --- | --- |
| Dedup Baseline | avg <0.35, max <0.6 | `tools/dedup_stats.py` + AST diff |
| Kernel 函数式边界 | Adapter 不依赖实现 | `scripts/check-functional-boundary.cj` |
| Tool ABI Determinism | 任意加载顺序一致 | `tests/tool_abi_determinism.cj` |
| MissionGraph Parity | 多任务调度可重放 | `tests/mission_graph_spec.cj` |
| Conversation Parity | Round Snapshot match Claude | `tests/conversation_round_spec.cj` |
| ToolBus Parity | CodeBuff WebSocket 指令 | `tests/toolbus_ws_bridge.cj` |
| Platform Template | 多领域任务回归 | `tests/platform_templates_spec.cj` |

---

## 11. 下一步行动

1. **创建 Kernel/Service 目录结构**：完成源码迁移脚本，保留 legacy 标签。
2. **实现 Tool ABI Compiler 原型**：扫描 `@toolset` 注释 → 输出 ABI JSON，校验参数类型。
3. **MissionGraph POC**：以现有 ExecutionLoop/Commander Agent 为节点，跑最小任务图，并输出事件流供 UI 使用。
4. **平台化策略评审**：与产品/合规团队确认开源/闭源差异化边界、插件签名策略。

借助仓颉函数式特性与 CangjieMagic 决定性工具契约，结合 Claude Code 的会话体验、CodeBuff 的工具总线、Cursor 的插件沙箱、Augment Code 的任务图调度，CodeLin 2.1 将从单一 CLI 应用升级为多领域可扩展的平台内核。

