# 阶段二功能分析：智能代码理解增强

## 📊 功能优先级分析

### 阶段二模块清单

| 模块 | 优先级 | 工作量 | 复杂度 | 已有基础 | 最小改动可行性 |
|------|--------|--------|--------|----------|----------------|
| 2.1 SemanticSearch | 🟠 高 | 4-5天 | ⭐⭐⭐⭐⭐ 最高 | ❌ 无 | ⚠️ 困难 |
| 2.2 LSP 深度集成 | 🟠 高 | 3-4天 | ⭐⭐⭐ 中 | ✅ 有（lsp_toolset.cj） | ✅ 容易 |
| 2.3 CodeQualityAnalyzer | 🟠 高 | 4-5天 | ⭐⭐⭐⭐ 高 | ✅ 有（code_analyzer.cj） | ⚠️ 中等 |

---

## 🎯 推荐实施顺序

### 推荐方案：2.2 LSP 深度集成优化（最优选择）

**理由**：
1. ✅ **已有基础**：`src/core/tools/lsp_toolset.cj` 已经实现了 LSP 客户端
2. ✅ **最小改动**：只需在现有工具基础上添加新的 LSP 方法
3. ✅ **实用性高**：诊断、补全、引用查找等功能直接提升开发体验
4. ✅ **复杂度适中**：不需要复杂的算法，主要是 LSP 协议调用

**当前 LSP 功能**：
- ✅ `getDocumentSymbols` - 获取文档符号
- ✅ `getDefinition` - 跳转到定义
- ✅ LSP 客户端管理和缓存

**待添加的功能**：
- [ ] `getDiagnostics` - 获取诊断信息（错误/警告）
- [ ] `findReferences` - 查找所有引用
- [ ] `getHoverInfo` - 获取悬停信息（文档）
- [ ] `getCompletions` - 获取代码补全
- [ ] `getCodeActions` - 获取代码操作（快速修复）

**工作量估算**：
- 核心实现：每个方法约 30-50 行
- 5 个新方法：约 150-250 行
- 测试：约 100 行
- **总计**：约 250-350 行，1-2 天

---

### 备选方案A：2.3 CodeQualityAnalyzer

**理由**：
- ✅ 已有 `code_analyzer.cj` 基础
- ⚠️ 但需要实现复杂的分析算法
- ⚠️ 圈复杂度、代码重复检测等比较复杂

**暂不推荐**：复杂度较高

---

### 备选方案B：2.1 SemanticSearch

**理由**：
- ❌ 需要 embedding 模型
- ❌ 需要向量存储
- ❌ 没有现有基础
- ❌ 复杂度最高

**不推荐**：不符合最小改动原则

---

## 💡 详细实施方案：LSP 深度集成优化

### 目标
增强现有 LSP 工具集，添加诊断、引用、补全等核心功能

### 实现策略

#### 1. 分析现有代码
```bash
grep -n "func.*tool" src/core/tools/lsp_toolset.cj
```

#### 2. 添加新的 LSP 工具方法

**2.1 getDiagnostics（诊断信息）**
```cangjie
@tool[
    description: "Get diagnostics (errors/warnings) for a file"
]
public func getDiagnostics(
    filePath: String
): String {
    // 调用 LSP textDocument/diagnostic
    // 返回格式化的诊断信息
}
```

**2.2 findReferences（查找引用）**
```cangjie
@tool[
    description: "Find all references to a symbol at a location"
]
public func findReferences(
    filePath: String,
    line: Int64,
    character: Int64
): String {
    // 调用 LSP textDocument/references
    // 返回所有引用位置
}
```

**2.3 getHoverInfo（悬停信息）**
```cangjie
@tool[
    description: "Get hover information for a symbol"
]
public func getHoverInfo(
    filePath: String,
    line: Int64,
    character: Int64
): String {
    // 调用 LSP textDocument/hover
    // 返回符号的文档和类型信息
}
```

#### 3. LSP 协议调用模式

已有的模式（参考 getDefinition）：
```cangjie
// 1. 获取或创建 LSP 客户端
let client = getLSPClient(filePath)

// 2. 准备请求参数
let params = {
    "textDocument": {"uri": fileUri},
    "position": {"line": line, "character": character}
}

// 3. 发送请求
let response = client.request("textDocument/someMethod", params)

// 4. 解析响应
// 5. 格式化返回
```

#### 4. 集成到现有工具集

修改 `src/core/tools/lsp_toolset.cj`：
- 添加 5 个新的 @tool 函数
- 复用现有的 LSP 客户端管理
- 复用现有的缓存机制

---

## 📝 实施步骤

### Step 1: 分析现有 LSP 工具代码
- 阅读 `lsp_toolset.cj`
- 理解 LSP 客户端的使用方式
- 理解现有工具的实现模式

### Step 2: 实现第一个新工具（getDiagnostics）
- 最简单，最实用
- 验证实现方式
- 建立实现模板

### Step 3: 依次实现其他工具
- findReferences
- getHoverInfo  
- getCompletions（可选，较复杂）
- getCodeActions（可选，较复杂）

### Step 4: 测试验证
- 编译测试
- 功能测试
- 集成测试

### Step 5: 更新文档
- 更新 plan1.md
- 创建实施总结

---

## ✅ 验收标准

1. ✅ 至少实现 3 个新的 LSP 工具方法
2. ✅ 编译通过
3. ✅ 与现有 LSP 工具集无缝集成
4. ✅ 工具可被 Agent 正常调用
5. ✅ 提供清晰的错误处理

---

## 🎯 预期成果

### 新增能力
- 📊 **诊断信息**：自动显示代码错误和警告
- 🔍 **引用查找**：找到符号的所有使用位置
- 📖 **悬停文档**：查看符号的类型和文档
- 💡 **代码补全**：智能补全建议
- 🔧 **快速修复**：自动修复常见问题

### 用户体验提升
- Agent 可以自动发现和修复错误
- Agent 可以查找符号使用位置
- Agent 可以提供更准确的代码建议
- 提升代码理解和重构能力

---

## ⚠️ 风险和限制

### 风险
1. LSP 服务器可能不支持某些方法
2. 不同语言的 LSP 实现差异
3. LSP 响应格式可能复杂

### 缓解措施
1. 优雅降级：方法不支持时返回友好提示
2. 专注仓颉：优先保证仓颉语言支持
3. 简化返回：只返回关键信息

---

## 📊 总结

**推荐立即实施**：2.2 LSP 深度集成优化

**理由**：
- ✅ 最符合"最小改动"原则
- ✅ 已有代码基础
- ✅ 实用性高
- ✅ 复杂度适中
- ✅ 1-2 天可完成

**预期工作量**：
- 核心代码：250-350 行
- 测试代码：100 行
- 总耗时：1-2 天

---

**决策建议**：开始实施 2.2 LSP 深度集成优化

**实施者**：AI Assistant  
**分析日期**：2024-10-24  
**状态**：等待开始实施

