# CODELIN.md 多层级配置使用指南

## 🎯 什么是多层级配置？

CodeLin 支持在不同层级定义 CODELIN.md 配置文件，系统会自动发现、加载并按优先级合并这些配置。这使得你可以在不同范围设置规则：

- **全局配置**: 适用于所有项目的通用规则
- **项目配置**: 特定项目的规则
- **目录配置**: 特定模块或功能的规则
- **本地配置**: 个人开发偏好（不提交到 git）

---

## 📁 配置层级

### 1. Global (全局配置)
**路径**: `~/.codelin/CODELIN.md`  
**优先级**: 10 (最低)  
**用途**: 所有项目共享的通用规则

```bash
mkdir -p ~/.codelin
cat > ~/.codelin/CODELIN.md << 'EOF'
# 全局 CodeLin 配置

## Code Style
- 使用有意义的变量名
- 添加必要的注释
- 遵循语言规范

## Workflow
- 修改前先阅读代码
- 修改后运行测试
EOF
```

### 2. ProjectRoot (项目根配置)
**路径**: `<项目根目录>/CODELIN.md`  
**优先级**: 20  
**用途**: 项目级别的规则和约定

项目根目录标识：
- 包含 `.git` 目录
- 包含 `cjpm.toml`
- 包含 `package.json`
- 包含 `CODELIN.md`

```markdown
# MyProject CODELIN.md

## Commands
- `/build`: 构建整个项目
- `/test`: 运行所有测试
- `/deploy`: 部署到测试环境

## Code Style
- 使用 4 空格缩进
- 函数不超过 50 行
- 类不超过 500 行

## Core Files
- src/main.cj
- src/config.cj
- README.md
```

### 3. Parent (父目录配置)
**路径**: 从当前目录到项目根之间的任意父目录  
**优先级**: 30  
**用途**: 模块或功能特定的规则

```markdown
# src/ 目录配置

## Commands
- `/lint`: 检查代码风格
- `/format`: 格式化代码

## Code Style
- 所有 public 函数必须有文档注释
- 导入语句按字母顺序排列

## Warnings
- 不要修改 auto-generated 文件
```

### 4. Current (当前目录配置)
**路径**: `<当前工作目录>/CODELIN.md`  
**优先级**: 40  
**用途**: 当前工作目录的特定规则

```markdown
# module1 配置

## Commands
- `/build`: 仅构建当前模块

## Core Files
- module1/main.cj
- module1/utils.cj
- module1/tests/
```

### 5. Local (本地配置)
**路径**: `<任意目录>/CODELIN.local.md`  
**优先级**: 50 (最高)  
**用途**: 个人开发偏好，不提交到 git

⚠️ **重要**: 请将 `CODELIN.local.md` 添加到 `.gitignore`

```bash
echo "CODELIN.local.md" >> .gitignore
```

```markdown
# 本地开发配置

## Commands
- `/debug`: 启用调试模式
- `/profile`: 性能分析

## Warnings
- 这是我的本地开发环境
- 不要在生产环境使用
```

---

## 🔄 配置合并规则

### 优先级

```
Local (50) > Current (40) > Parent (30) > ProjectRoot (20) > Global (10)
```

高优先级配置会覆盖低优先级配置。

### HashMap 字段（Commands）

**覆盖规则**: 高优先级完全覆盖低优先级

```markdown
<!-- ProjectRoot -->
## Commands
- `/build`: 构建整个项目
- `/test`: 运行测试

<!-- Current -->
## Commands
- `/build`: 仅构建当前模块  ← 覆盖了 ProjectRoot 的定义

<!-- 合并结果 -->
## Commands
- `/build`: 仅构建当前模块  ← Current 的定义
- `/test`: 运行测试  ← ProjectRoot 的定义
```

### ArrayList 字段（Code Style, Workflow 等）

**合并规则**: 保留所有项 + 自动去重

```markdown
<!-- ProjectRoot -->
## Code Style
- 使用 4 空格缩进
- 遵循 Cangjie 规范

<!-- Current -->
## Code Style
- 使用 4 空格缩进  ← 重复项，会被去重
- 添加单元测试

<!-- 合并结果 -->
## Code Style
- 使用 4 空格缩进  ← 只保留一份
- 遵循 Cangjie 规范
- 添加单元测试
```

---

## 🛠️ 使用方式

### 查看当前配置

```bash
# 进入任意工作目录
cd /path/to/your/project/src/module

# 使用 /memory 命令查看配置
codelin
> /memory
```

输出示例：
```
📊 CODELIN Configuration Summary
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
📦 Loaded 3 configuration file(s)

📁 [ProjectRoot] /project/CODELIN.md
   ├─ Commands: 3
   ├─ Code Styles: 5
   ├─ Workflows: 3
   ├─ Core Files: 3
   └─ Warnings: 0

⬆️ [Parent] /project/src/CODELIN.md
   ├─ Commands: 2
   ├─ Code Styles: 2
   ├─ Workflows: 0
   ├─ Core Files: 0
   └─ Warnings: 1

📍 [Current] /project/src/module/CODELIN.md
   ├─ Commands: 1
   ├─ Code Styles: 1
   ├─ Workflows: 0
   ├─ Core Files: 2
   └─ Warnings: 0

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
💡 Priority: Local > Current > Parent > ProjectRoot > Global

📄 Merged Configuration Content:
...
```

### 创建配置文件

```bash
# 项目根配置
cat > CODELIN.md << 'EOF'
# 项目配置

## Commands
- `/build`: cjpm build
- `/test`: cjpm test

## Code Style
- 使用 Cangjie 命名规范
EOF

# 子目录配置
cd src/
cat > CODELIN.md << 'EOF'
# src 目录配置

## Code Style
- 添加函数文档注释
EOF

# 本地配置（记得加入 .gitignore）
cat > CODELIN.local.md << 'EOF'
# 我的本地配置

## Commands
- `/debug`: 启用调试模式
EOF
```

---

## 📝 配置模板

### 标准项目配置模板

```markdown
# 项目名称 CODELIN.md

## 📋 项目信息
- **语言**: Cangjie
- **框架**: [框架名称]
- **版本**: [版本号]

## 🛠️ Commands

### 构建相关
- `/build`: 构建项目 - `cjpm build`
- `/clean`: 清理构建产物 - `cjpm clean`
- `/test`: 运行测试 - `cjpm test`

### 开发相关
- `/lint`: 代码检查 - `cjpm lint`
- `/format`: 代码格式化 - `cjpm format`
- `/doc`: 生成文档 - `cjpm doc`

## 📝 Code Style

### 通用规范
- 使用 4 空格缩进，不使用 tab
- 行宽不超过 100 字符
- 使用有意义的变量和函数名

### Cangjie 规范
- 遵循 Cangjie 官方命名规范
- 类名使用 PascalCase
- 函数和变量使用 camelCase
- 常量使用 UPPER_SNAKE_CASE

### 注释规范
- 所有 public 函数必须有文档注释
- 复杂逻辑必须有行内注释
- 使用中文或英文，保持一致

## 🔄 Workflow

### 开发流程
- 修改前先运行 `/test` 确保现有功能正常
- 修改后运行 `/test` 验证新功能
- 提交前运行 `/lint` 检查代码风格
- 提交信息使用规范格式：`<type>: <description>`

### 代码审查
- 重要修改需要 Code Review
- 审查重点：逻辑正确性、性能、可维护性
- 审查通过后才能合并

## 📚 Core Files

### 核心文件
- `src/main.cj` - 程序入口
- `src/config.cj` - 配置管理
- `src/utils.cj` - 工具函数

### 关键目录
- `src/` - 源代码
- `tests/` - 测试代码
- `docs/` - 文档

## ⚠️ Warnings

### 禁止操作
- 不要直接修改 `generated/` 目录下的文件
- 不要提交 `CODELIN.local.md`
- 不要在代码中硬编码敏感信息

### 注意事项
- 修改核心文件前请先备份
- 性能敏感操作需要进行基准测试
- 数据库操作需要事务保护
```

### 个人配置模板

```markdown
# 个人 CodeLin 配置

## 🛠️ Commands

### 个人工具
- `/debug`: 启用详细调试 - `DEBUG=1 ./run.sh`
- `/profile`: 性能分析 - `./profile.sh`
- `/clean-all`: 深度清理 - `rm -rf build/ .cache/`

## 📝 Code Style

### 个人偏好
- 我喜欢详细的注释
- 我倾向于小函数（< 20 行）
- 我喜欢显式的类型声明

## ⚠️ Warnings

### 提醒
- 这是我的本地开发环境
- 不要在生产环境使用这些配置
- 记得定期同步主分支代码
```

---

## 💡 最佳实践

### 1. 合理划分配置层级

```
~/.codelin/CODELIN.md          # 通用规则（所有项目）
└── project/
    ├── CODELIN.md             # 项目规则（整个项目）
    └── src/
        ├── CODELIN.md         # 模块规则（src 模块）
        └── feature/
            ├── CODELIN.md     # 功能规则（具体功能）
            └── CODELIN.local.md  # 个人规则（不提交）
```

### 2. 配置粒度建议

- **Global**: 只放最通用的规则（10 条以内）
- **ProjectRoot**: 项目核心规则（20-30 条）
- **Parent/Current**: 模块特定规则（10-15 条）
- **Local**: 个人偏好（5-10 条）

### 3. 命名约定

- 配置文件始终命名为 `CODELIN.md`
- 本地配置使用 `CODELIN.local.md`
- 使用标准的 Markdown 格式
- 使用表情符号增强可读性 ✨

### 4. 版本控制

```bash
# .gitignore
CODELIN.local.md
*.local.md
```

提交到 git 的配置：
- ✅ `CODELIN.md` (项目共享配置)
- ❌ `CODELIN.local.md` (个人配置)

### 5. 团队协作

- 在团队会议中统一 ProjectRoot 配置
- 鼓励成员根据需要添加 Parent/Current 配置
- 定期 Review 和更新配置
- 记录配置变更原因

---

## 🐛 常见问题

### Q1: 配置没有生效？

检查：
1. 配置文件名是否正确（`CODELIN.md`）
2. 配置文件格式是否正确（Markdown）
3. 是否在正确的工作目录
4. 运行 `/memory` 查看是否加载

### Q2: 如何调试配置合并？

```bash
# 查看详细的配置加载信息
codelin
> /memory

# 查看配置摘要
# 会显示加载的所有配置文件及其优先级
```

### Q3: 配置太多了，怎么管理？

建议：
1. 只在必要层级添加配置
2. 避免重复定义相同规则
3. 使用注释说明配置目的
4. 定期清理过时配置

### Q4: 本地配置如何不提交到 git？

```bash
# 方法 1: .gitignore
echo "CODELIN.local.md" >> .gitignore
echo "*.local.md" >> .gitignore

# 方法 2: .git/info/exclude (仅本地生效)
echo "CODELIN.local.md" >> .git/info/exclude
```

---

## 🚀 进阶技巧

### 1. 条件配置

使用不同目录的配置实现环境区分：

```
project/
├── CODELIN.md              # 通用配置
├── dev/
│   └── CODELIN.md          # 开发环境配置
├── staging/
│   └── CODELIN.md          # 预发布配置
└── prod/
    └── CODELIN.md          # 生产环境配置
```

### 2. 配置继承链

充分利用优先级实现配置继承：

```markdown
<!-- Global: 最基础的规则 -->
使用标准缩进

<!-- ProjectRoot: 项目规则 -->
← 继承: 使用标准缩进
+ 添加: 使用项目特定工具

<!-- Current: 当前规则 -->
← 继承: 使用标准缩进 + 使用项目特定工具
+ 添加: 当前模块特殊处理
```

### 3. 配置文档化

在配置中添加详细说明：

```markdown
## Commands

### 构建相关

- `/build`: 构建项目
  * 依赖: cjpm >= 0.5.0
  * 输出: target/release/
  * 时间: ~30s
  
- `/test`: 运行测试
  * 覆盖率要求: > 80%
  * 超时设置: 5min
```

---

## 📚 参考资料

- [CODELIN.md 多层级配置实现报告](./CODELIN_MULTILEVEL_CONFIG_IMPLEMENTATION.md)
- [codelin4.txt - CodeLin 4.0 规划](../codelin4.txt)
- [源代码: codelin_config_manager.cj](../src/core/config/codelin_config_manager.cj)

---

**更新时间**: 2025-11-19  
**版本**: 1.0.0  
**维护者**: @louloulin
