#!/bin/bash

# --------------------------------------------------------------------------------------------------
# Cangjie runtime memory tuning defaults
# Based on Context7 docs:
#   - Heap sizing / GC env vars:   /websites/cangjie-lang_cn_1_0_0 (runtime_env)
#   - Agent executor/tool guidance: /cangjiepl/cangjiemagic (core.agent)
# --------------------------------------------------------------------------------------------------

SCRIPT_DIR="$(cd -- "$(dirname "${BASH_SOURCE[0]}")" >/dev/null 2>&1 && pwd)"
PROJECT_ROOT="${SCRIPT_DIR}"
HEAP_DUMP_DIR="${PROJECT_ROOT}/.heapdumps"
LOG_DIR="${PROJECT_ROOT}/cli_runs"
mkdir -p "${HEAP_DUMP_DIR}" "${LOG_DIR}"

DRY_RUN=0
if [[ "${1:-}" == "--dry-run" ]]; then
  DRY_RUN=1
  shift
fi

CLI_ARGS=("$@")
if ((${#CLI_ARGS[@]} == 0)); then
  CLI_ARG_DESC="<none>"
else
  CLI_ARG_DESC="${CLI_ARGS[*]}"
fi

# Allow overrides while providing safe defaults aligned with official guidance.
: "${CJ_HEAP_SIZE:=4096MB}"           # Recommended by docs for large projects
: "${CJ_CONTEXT_CACHE_LIMIT:=35}"     # Matches MemoryConfig auto tier for >=512MB
: "${CJ_GC_THRESHOLD:=204800KB}"      # 200MB GC watermark to curb thrash
: "${CJ_HEAP_GROWTH:=0.20}"           # Slightly above default 0.15 for fewer GCs
: "${CJ_HEAP_UTILIZATION:=0.80}"      # Suggested default from docs
: "${CJ_HEAP_DUMP_ON_OOM:=on}"        # Enable heap snapshot on crash for diagnostics

export cjHeapSize="${CJ_HEAP_SIZE}"
export cjGCThreshold="${CJ_GC_THRESHOLD}"
export cjHeapGrowth="${CJ_HEAP_GROWTH}"
export cjHeapUtilization="${CJ_HEAP_UTILIZATION}"
export cjHeapDumpOnOOM="${CJ_HEAP_DUMP_ON_OOM}"
export cjHeapDumpLog="${HEAP_DUMP_DIR}"
export CODELIN_CONTEXT_CACHE_LIMIT="${CJ_CONTEXT_CACHE_LIMIT}"
source $CANGJIE_HOME/envsetup.sh
cjpm run --name codelin