#!/bin/bash
# 验证 EOF 修复

cd "$(dirname "$0")"

echo "========================================"
echo "验证 EOF 修复"
echo "========================================"
echo ""

echo "1. 检查源代码修复："
if grep -q "if (len <= 0)" src/io/raw_input_utils_unix.cj; then
    echo "   ✅ 源代码已修复"
else
    echo "   ❌ 源代码未修复"
    exit 1
fi

echo ""
echo "2. 检查 FFI 库时间戳："
ffi_time=$(stat -f "%Sm" -t "%Y-%m-%d %H:%M" ffi/librawinput.dylib)
echo "   FFI dylib: $ffi_time"

echo ""
echo "3. 检查可执行文件时间戳："
bin_time=$(stat -f "%Sm" -t "%Y-%m-%d %H:%M" target/release/bin/cli)
echo "   可执行文件: $bin_time"

echo ""
echo "4. 测试 EOF 处理（3秒超时）："
echo "   提示：会自动输入 Ctrl+D"
echo ""

# 使用 expect 或简单的 EOF 测试
if command -v expect > /dev/null; then
    # 使用 expect
    expect <<'EOF'
set timeout 3
spawn cjpm run --name cli
expect " >"
send "\004"
expect {
    "Exception.*Read bytes 4294967295" {
        puts "\n❌ 测试失败：仍然抛出异常"
        exit 1
    }
    eof {
        puts "\n✅ 测试通过：程序正常退出"
        exit 0
    }
    timeout {
        puts "\n⚠️  超时（可能正常）"
        exit 0
    }
}
EOF
else
    # 简单测试：使用空输入
    echo "   (使用空输入测试)"
    if echo "" | cjpm run --name cli 2>&1 | grep -q "Exception.*Read bytes 4294967295"; then
        echo "   ❌ 测试失败：仍然抛出异常"
        exit 1
    else
        echo "   ✅ 测试通过：无异常"
        exit 0
    fi
fi

