#!/bin/bash
# Git 提交 EOF 修复

cd "$(dirname "$0")"

echo "========================================"
echo "准备提交 EOF 异常修复"
echo "========================================"
echo ""

echo "📝 修改的文件："
echo ""
echo "核心修复："
echo "  - src/io/raw_input_utils_unix.cj"
echo "  - src/io/raw_input_utils_win.cj"
echo ""
echo "文档："
echo "  - EOF_EXCEPTION_FIX.md"
echo "  - EOF_FIX_DIAGNOSTIC.md"
echo "  - EOF_FIX_COMPLETE_SUMMARY.md"
echo "  - EOF_FIX_SUCCESS.md"
echo "  - EOF_FIX_FINAL.md"
echo "  - RUN_CLI_FIXED.md"
echo ""
echo "测试脚本："
echo "  - test_eof_fix.sh"
echo "  - test_eof_simple.sh"
echo "  - test_ctrl_d.sh"
echo "  - SIMPLE_TEST.sh"
echo "  - VERIFY_FIX.sh"
echo "  - COMMIT_EOF_FIX.sh (本文件)"
echo ""

echo "========================================"
echo "Git 操作"
echo "========================================"
echo ""

# 检查 git 状态
echo "当前状态："
git status -s

echo ""
read -p "是否继续提交？(y/n) " -n 1 -r
echo ""

if [[ ! $REPLY =~ ^[Yy]$ ]]; then
    echo "取消提交"
    exit 0
fi

# 添加文件
echo ""
echo "添加修改的文件..."
git add src/io/raw_input_utils_unix.cj
git add src/io/raw_input_utils_win.cj
git add EOF_*.md
git add RUN_CLI_FIXED.md
git add test_*.sh
git add SIMPLE_TEST.sh
git add VERIFY_FIX.sh
git add COMMIT_EOF_FIX.sh

echo ""
echo "准备提交的更改："
git status -s

echo ""
echo "提交消息："
echo "────────────────────────────────────────"
cat <<'EOF'
fix: 修复 EOF 异常，优雅处理 Ctrl+D 退出

问题：
- 用户按 Ctrl+D 时程序抛出异常并崩溃
- 错误信息：Exception: Read bytes 4294967295 != Expected bytes 1
- 影响所有交互式使用场景

根本原因：
- C 层 read() 在 EOF 时返回 -1
- rawGetRune() 未检查负值直接抛出异常
- -1 显示为无符号数 4294967295

修复方案：
- 在 rawGetRune() 中添加 len <= 0 检查
- 遇到 EOF 或错误时返回 None
- 程序优雅退出，不抛出异常

修改文件：
- src/io/raw_input_utils_unix.cj (Unix/macOS/Linux)
- src/io/raw_input_utils_win.cj (Windows)

测试：
- ✅ 用户实测验证通过
- ✅ Ctrl+D 正常退出
- ✅ 所有功能正常

优先级: P0
影响: 所有交互式场景
兼容性: 100% 向后兼容
EOF
echo "────────────────────────────────────────"

echo ""
read -p "确认提交？(y/n) " -n 1 -r
echo ""

if [[ ! $REPLY =~ ^[Yy]$ ]]; then
    echo "取消提交"
    exit 0
fi

# 执行提交
git commit -F - <<'EOF'
fix: 修复 EOF 异常，优雅处理 Ctrl+D 退出

问题：
- 用户按 Ctrl+D 时程序抛出异常并崩溃
- 错误信息：Exception: Read bytes 4294967295 != Expected bytes 1
- 影响所有交互式使用场景

根本原因：
- C 层 read() 在 EOF 时返回 -1
- rawGetRune() 未检查负值直接抛出异常
- -1 显示为无符号数 4294967295

修复方案：
- 在 rawGetRune() 中添加 len <= 0 检查
- 遇到 EOF 或错误时返回 None
- 程序优雅退出，不抛出异常

修改文件：
- src/io/raw_input_utils_unix.cj (Unix/macOS/Linux)
- src/io/raw_input_utils_win.cj (Windows)

测试：
- ✅ 用户实测验证通过
- ✅ Ctrl+D 正常退出
- ✅ 所有功能正常

优先级: P0
影响: 所有交互式场景
兼容性: 100% 向后兼容
EOF

echo ""
echo "========================================"
echo "✅ 提交完成！"
echo "========================================"
echo ""
echo "查看提交："
git log -1 --stat

echo ""
echo "下一步："
echo "  git push origin $(git branch --show-current)"

