/*
 * Decompiled with CFR 0.152.
 */
package COM.rl.obf.classfile;

import COM.rl.obf.classfile.ClassFileException;
import COM.rl.obf.classfile.ConstantPool;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class VerificationTypeInfo {
    private static final int ITEM_Top = 0;
    private static final int ITEM_Integer = 1;
    private static final int ITEM_Float = 2;
    private static final int ITEM_Long = 3;
    private static final int ITEM_Double = 4;
    private static final int ITEM_Null = 5;
    private static final int ITEM_UninitializedThis = 6;
    private static final int ITEM_Object = 7;
    private static final int ITEM_Uninitialized = 8;
    private int u1tag;
    private int u2cpoolIndex;
    private int u2offset;

    public static VerificationTypeInfo create(DataInput din) throws IOException, ClassFileException {
        VerificationTypeInfo vti = new VerificationTypeInfo();
        vti.read(din);
        return vti;
    }

    private VerificationTypeInfo() {
    }

    private void read(DataInput din) throws IOException, ClassFileException {
        this.u1tag = din.readUnsignedByte();
        switch (this.u1tag) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                this.u2cpoolIndex = din.readUnsignedShort();
                break;
            }
            case 8: {
                this.u2offset = din.readUnsignedShort();
                break;
            }
            default: {
                throw new ClassFileException("Illegal Verification Type Info tag: " + this.u1tag);
            }
        }
    }

    protected void markUtf8Refs(ConstantPool pool) throws ClassFileException {
        if (this.u1tag == 7) {
            pool.incRefCount(this.u2cpoolIndex);
        }
    }

    public void write(DataOutput dout) throws IOException, ClassFileException {
        dout.writeByte(this.u1tag);
        switch (this.u1tag) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                dout.writeShort(this.u2cpoolIndex);
                break;
            }
            case 8: {
                dout.writeShort(this.u2offset);
                break;
            }
            default: {
                throw new ClassFileException("Illegal Verification Type Info tag: " + this.u1tag);
            }
        }
    }
}

