/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.java.decompiler.main.ClassWriter;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.TextBuffer;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.LVTVariable;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class VarExprent
extends Exprent {
    public static final int STACK_BASE = 10000;
    public static final String VAR_NAMELESS_ENCLOSURE = "<VAR_NAMELESS_ENCLOSURE>";
    private int index;
    private VarType varType;
    private boolean definition = false;
    private VarProcessor processor;
    private int version = 0;
    private boolean classDef = false;
    private boolean stack = false;
    private LVTVariable lvt = null;

    public VarExprent(int index, VarType varType, VarProcessor processor) {
        super(12);
        this.index = index;
        this.varType = varType;
        this.processor = processor;
    }

    @Override
    public VarType getExprType() {
        return this.getVarType();
    }

    @Override
    public VarType getInferredExprType(VarType upperBound) {
        if (this.lvt != null && this.lvt.getSig() != null) {
            try {
                return GenericType.parse(this.lvt.getSig());
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            }
        } else if (this.lvt != null) {
            return this.lvt.getVarType();
        }
        return this.getVarType();
    }

    @Override
    public int getExprentUse() {
        return 3;
    }

    @Override
    public List<Exprent> getAllExprents() {
        return new ArrayList<Exprent>();
    }

    @Override
    public Exprent copy() {
        VarExprent var = new VarExprent(this.index, this.getVarType(), this.processor);
        var.setDefinition(this.definition);
        var.setVersion(this.version);
        var.setClassDef(this.classDef);
        var.setStack(this.stack);
        var.setLVT(this.lvt);
        return var;
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        TextBuffer buffer = new TextBuffer();
        tracer.addMapping(this.bytecode);
        if (this.classDef) {
            ClassesProcessor.ClassNode child = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.varType.value);
            new ClassWriter().classToJava(child, buffer, indent, tracer);
            tracer.incrementCurrentSourceLine(buffer.countLines());
        } else {
            String name = null;
            if (this.lvt != null) {
                name = this.lvt.name;
            } else if (this.processor != null) {
                name = this.processor.getVarName(new VarVersionPair(this.index, this.version));
            }
            if (this.definition) {
                if (this.processor != null && this.processor.getVarFinal(new VarVersionPair(this.index, this.version)) == 2) {
                    buffer.append("final ");
                }
                if (this.lvt != null && this.lvt.getSig() != null) {
                    buffer.append(ExprProcessor.getCastTypeName(GenericType.parse(this.lvt.getSig()))).append(" ");
                } else if (this.lvt != null) {
                    buffer.append(ExprProcessor.getCastTypeName(this.lvt.getVarType())).append(" ");
                } else {
                    buffer.append(ExprProcessor.getCastTypeName(this.getVarType())).append(" ");
                }
            }
            buffer.append(name == null ? "var" + this.index + (this.version == 0 ? "" : "_" + this.version) : name);
        }
        return buffer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof VarExprent)) {
            return false;
        }
        VarExprent ve = (VarExprent)o;
        return this.index == ve.getIndex() && this.version == ve.getVersion() && InterpreterUtil.equalObjects(this.getVarType(), ve.getVarType());
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        this.measureBytecode(values);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public VarType getVarType() {
        VarType vt = null;
        if (this.processor != null) {
            vt = this.processor.getVarType(new VarVersionPair(this.index, this.version));
        }
        if (vt == null || this.varType != null && this.varType.type != 17) {
            vt = this.varType;
        }
        return vt == null ? VarType.VARTYPE_UNKNOWN : vt;
    }

    public void setVarType(VarType varType) {
        this.varType = varType;
    }

    public boolean isDefinition() {
        return this.definition;
    }

    public void setDefinition(boolean definition) {
        this.definition = definition;
    }

    public VarProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(VarProcessor processor) {
        this.processor = processor;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isClassDef() {
        return this.classDef;
    }

    public void setClassDef(boolean classDef) {
        this.classDef = classDef;
    }

    public boolean isStack() {
        return this.stack;
    }

    public void setStack(boolean stack) {
        this.stack = stack;
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        MatchNode.RuleValue rule = matchNode.getRules().get((Object)IMatchable.MatchProperties.EXPRENT_VAR_INDEX);
        return rule == null || !(rule.isVariable() ? !engine.checkAndSetVariableValue((String)rule.value, this.index) : this.index != Integer.valueOf((String)rule.value));
    }

    public void setLVT(LVTVariable lvt) {
        this.lvt = lvt;
        if (this.processor != null && lvt != null) {
            this.processor.setVarType(new VarVersionPair(this), lvt.getVarType());
        }
    }

    public LVTVariable getLVT() {
        return this.lvt;
    }

    public String toString() {
        return this.lvt != null ? this.lvt.name : "var_" + this.index + "_" + this.version;
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult checkExprTypeBounds = super.checkExprTypeBounds();
        if (this.lvt != null) {
            checkExprTypeBounds.addMinTypeExprent(this, this.lvt.getVarType());
        }
        return checkExprTypeBounds;
    }
}

