/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.rels;

import java.io.IOException;
import java.util.BitSet;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.code.cfg.ControlFlowGraph;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.modules.code.DeadCodeHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ClearStructHelper;
import org.jetbrains.java.decompiler.modules.decompiler.DomHelper;
import org.jetbrains.java.decompiler.modules.decompiler.EliminateLoopsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExitHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.FinallyProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.IdeaNotNullHelper;
import org.jetbrains.java.decompiler.modules.decompiler.IfHelper;
import org.jetbrains.java.decompiler.modules.decompiler.InlineSingleBlockHelper;
import org.jetbrains.java.decompiler.modules.decompiler.LabelHelper;
import org.jetbrains.java.decompiler.modules.decompiler.LoopExtractHelper;
import org.jetbrains.java.decompiler.modules.decompiler.MergeHelper;
import org.jetbrains.java.decompiler.modules.decompiler.PPandMMHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SecondaryFunctionsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StackVarsProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.SynchronizedHelper;
import org.jetbrains.java.decompiler.modules.decompiler.deobfuscator.ExceptionDeobfuscator;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.IfExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;

public class MethodProcessorRunnable
implements Runnable {
    private static RootStatement currentRoot;
    private static VarProcessor vp;
    public final Object lock = new Object();
    private final StructMethod method;
    private final VarProcessor varProc;
    private final DecompilerContext parentContext;
    private volatile RootStatement root;
    private volatile Throwable error;
    private volatile boolean finished = false;

    public MethodProcessorRunnable(StructMethod method, VarProcessor varProc, DecompilerContext parentContext) {
        this.method = method;
        this.varProc = varProc;
        this.parentContext = parentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DecompilerContext.setCurrentContext(this.parentContext);
        this.error = null;
        this.root = null;
        try {
            this.root = MethodProcessorRunnable.codeToJava(this.method, this.varProc);
        }
        catch (ThreadDeath ex) {
            throw ex;
        }
        catch (Throwable ex) {
            this.error = ex;
        }
        finally {
            DecompilerContext.setCurrentContext(null);
        }
        this.finished = true;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public static RootStatement codeToJava(StructMethod mt, VarProcessor varProc) throws IOException {
        StackVarsProcessor stackProc;
        RootStatement root;
        StructClass cl = mt.getClassStruct();
        boolean isInitializer = "<clinit>".equals(mt.getName());
        mt.expandData();
        InstructionSequence seq = mt.getInstructionSequence();
        ControlFlowGraph graph = new ControlFlowGraph(seq);
        DeadCodeHelper.removeDeadBlocks(graph);
        graph.inlineJsr(mt);
        DeadCodeHelper.connectDummyExitBlock(graph);
        DeadCodeHelper.removeGotos(graph);
        ExceptionDeobfuscator.removeCircularRanges(graph);
        ExceptionDeobfuscator.restorePopRanges(graph);
        if (DecompilerContext.getOption("rer")) {
            ExceptionDeobfuscator.removeEmptyRanges(graph);
        }
        if (DecompilerContext.getOption("ner")) {
            DeadCodeHelper.incorporateValueReturns(graph);
        }
        ExceptionDeobfuscator.insertEmptyExceptionHandlerBlocks(graph);
        DeadCodeHelper.mergeBasicBlocks(graph);
        DecompilerContext.getCounterContainer().setCounter(2, mt.getLocalVariables());
        if (ExceptionDeobfuscator.hasObfuscatedExceptions(graph)) {
            DecompilerContext.getLogger().writeMessage("Heavily obfuscated exception ranges found!", IFernflowerLogger.Severity.WARN);
        }
        currentRoot = root = DomHelper.parseGraph(graph, mt);
        vp = varProc;
        FinallyProcessor fProc = new FinallyProcessor(varProc);
        while (fProc.iterateGraph(mt, root, graph)) {
            root = DomHelper.parseGraph(graph, mt);
        }
        DomHelper.removeSynchronizedHandler(root);
        SequenceHelper.condenseSequences(root);
        ClearStructHelper.clearStatements(root);
        ExprProcessor proc = new ExprProcessor();
        proc.processStatement(root, cl);
        SequenceHelper.condenseSequences(root);
        do {
            stackProc = new StackVarsProcessor();
            stackProc.simplifyStackVars(root, mt, cl);
            varProc.setVarVersions(root);
        } while (new PPandMMHelper(varProc).findPPandMM(root));
        do {
            LabelHelper.cleanUpEdges(root);
            while (true) {
                if (EliminateLoopsHelper.eliminateLoops(root, cl) || LoopExtractHelper.extractLoops(root)) {
                    continue;
                }
                MergeHelper.enhanceLoops(root);
                if (!IfHelper.mergeAllIfs(root)) break;
            }
            if (DecompilerContext.getOption("inn") && IdeaNotNullHelper.removeHardcodedChecks(root, mt)) {
                SequenceHelper.condenseSequences(root);
                stackProc = new StackVarsProcessor();
                stackProc.simplifyStackVars(root, mt, cl);
                varProc.setVarVersions(root);
            }
            LabelHelper.identifyLabels(root);
        } while (InlineSingleBlockHelper.inlineSingleBlocks(root) || !isInitializer && ExitHelper.condenseExits(root));
        ExitHelper.removeRedundantReturns(root);
        SecondaryFunctionsHelper.identifySecondaryFunctions(root);
        SynchronizedHelper.cleanSynchronizedVar(root);
        varProc.setVarDefinitions(root);
        LabelHelper.replaceContinueWithBreak(root);
        mt.releaseResources();
        return root;
    }

    public RootStatement getResult() throws Throwable {
        Throwable t = this.error;
        if (t != null) {
            throw t;
        }
        return this.root;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public static void printMethod(String desc) {
        MethodProcessorRunnable.printMethod(currentRoot, desc, vp);
    }

    public static void printMethod(Statement root, String name, VarProcessor varProc) {
        System.out.println(name + " {");
        if (root == null || root.getSequentialObjects() == null) {
            System.out.println("}");
            return;
        }
        for (Object obj : root.getSequentialObjects()) {
            if (obj instanceof Statement) {
                MethodProcessorRunnable.printStatement((Statement)obj, "  ", varProc);
                continue;
            }
            if (obj == null) {
                System.out.println("  null");
                continue;
            }
            System.out.println("  " + obj.getClass().getSimpleName());
        }
        if (root instanceof RootStatement) {
            MethodProcessorRunnable.printStatement(((RootStatement)root).getDummyExit(), "  ", varProc);
        }
        System.out.println("}");
    }

    public static void getOffset(Statement st, BitSet values) {
        if (st instanceof DummyExitStatement && ((DummyExitStatement)st).bytecode != null) {
            values.or(((DummyExitStatement)st).bytecode);
        }
        if (st.getExprents() != null) {
            for (Exprent e : st.getExprents()) {
                e.getBytecodeRange(values);
            }
        } else {
            for (Object obj : st.getSequentialObjects()) {
                if (obj == null) continue;
                if (obj instanceof Statement) {
                    MethodProcessorRunnable.getOffset((Statement)obj, values);
                    continue;
                }
                if (obj instanceof Exprent) {
                    ((Exprent)obj).getBytecodeRange(values);
                    continue;
                }
                System.out.println("WTF?" + obj.getClass());
            }
        }
    }

    private static void printStatement(Statement statement, String indent, VarProcessor varProc) {
        BitSet values = new BitSet();
        MethodProcessorRunnable.getOffset(statement, values);
        int start = values.nextSetBit(0);
        int end = values.length() - 1;
        System.out.print(indent + "{" + statement.getClass().getSimpleName() + "}:" + statement.id + " (" + start + ", " + end + ") " + statement.getClass().getSimpleName());
        if (statement.type == 5) {
            System.out.print(" t:" + ((DoStatement)statement).getLooptype());
        } else if (statement.type == 8) {
            System.out.print(" i:" + ((BasicBlockStatement)statement).getBlock().toStringOldIndices().replaceAll("\n", ";").replaceAll("\r", ""));
        }
        System.out.println();
        for (StatEdge edge : statement.getAllSuccessorEdges()) {
            System.out.println(indent + " Dest: " + edge.getDestination());
        }
        if (statement.getExprents() != null) {
            for (Exprent exp : statement.getExprents()) {
                System.out.println(MethodProcessorRunnable.printExprent(indent + "  ", exp, varProc));
            }
        }
        indent = indent + "  ";
        for (Object obj : statement.getSequentialObjects()) {
            if (obj == null) continue;
            if (obj instanceof Statement) {
                MethodProcessorRunnable.printStatement((Statement)obj, indent, varProc);
                continue;
            }
            if (obj instanceof Exprent) {
                System.out.println(MethodProcessorRunnable.printExprent(indent, (Exprent)obj, varProc));
                continue;
            }
            System.out.println(indent + obj.getClass().getSimpleName());
        }
    }

    private static String printExprent(String indent, Exprent exp, VarProcessor varProc) {
        StringBuffer sb = new StringBuffer();
        sb.append(indent);
        BitSet values = new BitSet();
        exp.getBytecodeRange(values);
        sb.append("(").append(values.nextSetBit(0)).append(", ").append(values.length() - 1).append(") ");
        sb.append(exp.getClass().getSimpleName());
        sb.append(" ").append(exp.id).append(" ");
        if (exp instanceof VarExprent) {
            VarExprent varExprent = (VarExprent)exp;
            int currindex = varExprent.getIndex();
            int origindex = varProc == null ? -2 : varProc.getRemapped(currindex);
            sb.append("[").append(currindex).append(":").append(origindex).append(", ").append(varExprent.isStack()).append("]");
            if (varProc != null && varProc.getLVT() != null) {
                sb.append(varProc.getLVT().getCandidates(origindex));
            }
        } else if (exp instanceof AssignmentExprent) {
            AssignmentExprent assignmentExprent = (AssignmentExprent)exp;
            sb.append("{").append(MethodProcessorRunnable.printExprent(" ", assignmentExprent.getLeft(), varProc)).append(" =").append(MethodProcessorRunnable.printExprent(" ", assignmentExprent.getRight(), varProc)).append("}");
        } else if (exp instanceof IfExprent) {
            sb.append(" ").append(exp.toJava(0, new BytecodeMappingTracer()));
        } else if (exp instanceof FunctionExprent) {
            sb.append(" ").append(exp.toJava(0, new BytecodeMappingTracer()));
        }
        return sb.toString();
    }
}

