/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector.adaptors;

import de.oceanlabs.mcp.mcinjector.JsonStruct;
import de.oceanlabs.mcp.mcinjector.MCInjectorImpl;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class JsonAttribute
extends ClassVisitor {
    private static final Logger log = Logger.getLogger("MCInjector");
    private MCInjectorImpl mci;
    private String className;
    private JsonStruct json;
    private boolean visitedOuter = false;
    private Set<String> visitedInners = new HashSet<String>();
    private Set<String> refedInners = new HashSet<String>();

    public JsonAttribute(ClassVisitor cv, MCInjectorImpl mci) {
        super(327680, cv);
        this.mci = mci;
    }

    private String getAccess(int access) {
        StringBuilder buf = new StringBuilder();
        if ((access & 1) != 0) {
            buf.append("PUBLIC ");
        } else if ((access & 2) != 0) {
            buf.append("PRIVATE ");
        } else if ((access & 4) != 0) {
            buf.append("PROTECTED ");
        } else {
            buf.append("DEFAULT ");
        }
        if ((access & 0x10) != 0) {
            buf.append("FINAL ");
        }
        if ((access & 0x20) != 0) {
            buf.append("SUPER ");
        }
        if ((access & 0x200) != 0) {
            buf.append("INTERFACE ");
        }
        if ((access & 0x400) != 0) {
            buf.append("ABSTRACT ");
        }
        if ((access & 0x1000) != 0) {
            buf.append("SYNTHETIC ");
        }
        if ((access & 0x2000) != 0) {
            buf.append("ANNOTATION ");
        }
        if ((access & 0x4000) != 0) {
            buf.append("ENUM ");
        }
        return buf.toString().trim();
    }

    private boolean isInnerClass(String name) {
        return name.contains("$");
    }

    private void referenced(Type type) {
        String internal;
        if (type.getSort() == 9) {
            type = type.getElementType();
        }
        if (type.getSort() == 10 && this.isInnerClass(internal = type.getInternalName())) {
            this.refedInners.add(internal);
        }
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.json = this.mci.json.get(this.className);
        this.visitedOuter = false;
        this.visitedInners.clear();
        for (String i : interfaces) {
            if (!this.isInnerClass(i)) continue;
            this.refedInners.add(i);
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.referenced(Type.getType(desc));
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (exceptions != null) {
            for (String s : exceptions) {
                if (!this.isInnerClass(s)) continue;
                this.refedInners.add(s);
            }
        }
        this.referenced(Type.getReturnType(desc));
        for (Type t : Type.getArgumentTypes(desc)) {
            this.referenced(t);
        }
        return new MethodVisitor(this.api, super.visitMethod(access, name, desc, signature, exceptions)){

            @Override
            public void visitLdcInsn(Object cst) {
                if (cst instanceof Type) {
                    JsonAttribute.this.referenced((Type)cst);
                }
                super.visitLdcInsn(cst);
            }
        };
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.visitedInners.add(name);
        super.visitInnerClass(name, outerName, innerName, access);
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        this.visitedOuter = true;
        super.visitOuterClass(owner, name, desc);
    }

    @Override
    public void visitEnd() {
        if (this.json != null) {
            JsonStruct.EnclosingMethod enc = this.json.enclosingMethod;
            if (enc != null && !this.visitedOuter && enc.name != null && enc.desc != null) {
                log.fine("  Adding Outer Class:");
                log.fine("    Owner: " + enc.owner);
                log.fine("    Method: " + enc.name + enc.desc);
                super.visitOuterClass(enc.owner, enc.name, enc.desc);
            }
            if (this.json.innerClasses != null) {
                for (JsonStruct.InnerClass inner : this.json.innerClasses) {
                    if (this.visitedInners.contains(inner.inner_class)) continue;
                    this.visitedInners.add(inner.inner_class);
                    log.fine("  Adding Inner Class:");
                    log.fine("    Inner: " + inner.inner_class);
                    log.fine("    Access: " + this.getAccess(inner.getAccess()));
                    if (inner.outer_class != null) {
                        log.fine("    Outer: " + inner.outer_class);
                    }
                    if (inner.inner_name != null) {
                        log.fine("    Name: " + inner.inner_name);
                    }
                    super.visitInnerClass(inner.inner_class, inner.outer_class, inner.inner_name, inner.getAccess());
                }
            }
        }
        this.refedInners.removeAll(this.visitedInners);
        for (String inner : this.refedInners) {
            JsonStruct.InnerClass ic = this.mci.inners.get(inner);
            if (ic == null) {
                log.fine("  Referenced Inner Class: " + inner + " (missing) assuming defaults");
                int idx = inner.lastIndexOf(36);
                String outer = inner.substring(0, idx);
                String name = inner.substring(idx + 1);
                super.visitInnerClass(inner, outer, name, 1);
                continue;
            }
            log.fine("  Referenced Inner Class:");
            log.fine("    Inner: " + ic.inner_class);
            log.fine("    Access: " + this.getAccess(ic.getAccess()));
            if (ic.outer_class != null) {
                log.fine("    Outer: " + ic.outer_class);
            }
            if (ic.inner_name != null) {
                log.fine("    Name: " + ic.inner_name);
            }
            super.visitInnerClass(ic.inner_class, ic.outer_class, ic.inner_name, ic.getAccess());
        }
        super.visitEnd();
    }
}

