const manifest = {"name":"DeckyMusic"};
const API_VERSION = 2;
const internalAPIConnection = window.__DECKY_SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED_deckyLoaderAPIInit;
if (!internalAPIConnection) {
    throw new Error('[@decky/api]: Failed to connect to the loader as as the loader API was not initialized. This is likely a bug in Decky Loader.');
}
let api;
try {
    api = internalAPIConnection.connect(API_VERSION, manifest.name);
}
catch {
    api = internalAPIConnection.connect(1, manifest.name);
    console.warn(`[@decky/api] Requested API version ${API_VERSION} but the running loader only supports version 1. Some features may not work.`);
}
if (api._version != API_VERSION) {
    console.warn(`[@decky/api] Requested API version ${API_VERSION} but the running loader only supports version ${api._version}. Some features may not work.`);
}
const callable = api.callable;
const routerHook = api.routerHook;
const toaster = api.toaster;
const definePlugin = (fn) => {
    return (...args) => {
        return fn(...args);
    };
};

var DefaultContext = {
  color: undefined,
  size: undefined,
  className: undefined,
  style: undefined,
  attr: undefined
};
var IconContext = SP_REACT.createContext && /*#__PURE__*/SP_REACT.createContext(DefaultContext);

var _excluded = ["attr", "size", "title"];
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } } return target; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), true).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function Tree2Element(tree) {
  return tree && tree.map((node, i) => /*#__PURE__*/SP_REACT.createElement(node.tag, _objectSpread({
    key: i
  }, node.attr), Tree2Element(node.child)));
}
function GenIcon(data) {
  return props => /*#__PURE__*/SP_REACT.createElement(IconBase, _extends({
    attr: _objectSpread({}, data.attr)
  }, props), Tree2Element(data.child));
}
function IconBase(props) {
  var elem = conf => {
    var {
        attr,
        size,
        title
      } = props,
      svgProps = _objectWithoutProperties(props, _excluded);
    var computedSize = size || conf.size || "1em";
    var className;
    if (conf.className) className = conf.className;
    if (props.className) className = (className ? className + " " : "") + props.className;
    return /*#__PURE__*/SP_REACT.createElement("svg", _extends({
      stroke: "currentColor",
      fill: "currentColor",
      strokeWidth: "0"
    }, conf.attr, attr, svgProps, {
      className: className,
      style: _objectSpread(_objectSpread({
        color: props.color || conf.color
      }, conf.style), props.style),
      height: computedSize,
      width: computedSize,
      xmlns: "http://www.w3.org/2000/svg"
    }), title && /*#__PURE__*/SP_REACT.createElement("title", null, title), props.children);
  };
  return IconContext !== undefined ? /*#__PURE__*/SP_REACT.createElement(IconContext.Consumer, null, conf => elem(conf)) : elem(DefaultContext);
}

// THIS FILE IS AUTO GENERATED
function FaArrowLeft (props) {
  return GenIcon({"attr":{"viewBox":"0 0 448 512"},"child":[{"tag":"path","attr":{"d":"M257.5 445.1l-22.2 22.2c-9.4 9.4-24.6 9.4-33.9 0L7 273c-9.4-9.4-9.4-24.6 0-33.9L201.4 44.7c9.4-9.4 24.6-9.4 33.9 0l22.2 22.2c9.5 9.5 9.3 25-.4 34.3L136.6 216H424c13.3 0 24 10.7 24 24v32c0 13.3-10.7 24-24 24H136.6l120.5 114.8c9.8 9.3 10 24.8.4 34.3z"},"child":[]}]})(props);
}function FaCog (props) {
  return GenIcon({"attr":{"viewBox":"0 0 512 512"},"child":[{"tag":"path","attr":{"d":"M487.4 315.7l-42.6-24.6c4.3-23.2 4.3-47 0-70.2l42.6-24.6c4.9-2.8 7.1-8.6 5.5-14-11.1-35.6-30-67.8-54.7-94.6-3.8-4.1-10-5.1-14.8-2.3L380.8 110c-17.9-15.4-38.5-27.3-60.8-35.1V25.8c0-5.6-3.9-10.5-9.4-11.7-36.7-8.2-74.3-7.8-109.2 0-5.5 1.2-9.4 6.1-9.4 11.7V75c-22.2 7.9-42.8 19.8-60.8 35.1L88.7 85.5c-4.9-2.8-11-1.9-14.8 2.3-24.7 26.7-43.6 58.9-54.7 94.6-1.7 5.4.6 11.2 5.5 14L67.3 221c-4.3 23.2-4.3 47 0 70.2l-42.6 24.6c-4.9 2.8-7.1 8.6-5.5 14 11.1 35.6 30 67.8 54.7 94.6 3.8 4.1 10 5.1 14.8 2.3l42.6-24.6c17.9 15.4 38.5 27.3 60.8 35.1v49.2c0 5.6 3.9 10.5 9.4 11.7 36.7 8.2 74.3 7.8 109.2 0 5.5-1.2 9.4-6.1 9.4-11.7v-49.2c22.2-7.9 42.8-19.8 60.8-35.1l42.6 24.6c4.9 2.8 11 1.9 14.8-2.3 24.7-26.7 43.6-58.9 54.7-94.6 1.5-5.5-.7-11.3-5.6-14.1zM256 336c-44.1 0-80-35.9-80-80s35.9-80 80-80 80 35.9 80 80-35.9 80-80 80z"},"child":[]}]})(props);
}function FaCompactDisc (props) {
  return GenIcon({"attr":{"viewBox":"0 0 496 512"},"child":[{"tag":"path","attr":{"d":"M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zM88 256H56c0-105.9 86.1-192 192-192v32c-88.2 0-160 71.8-160 160zm160 96c-53 0-96-43-96-96s43-96 96-96 96 43 96 96-43 96-96 96zm0-128c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32z"},"child":[]}]})(props);
}function FaDownload (props) {
  return GenIcon({"attr":{"viewBox":"0 0 512 512"},"child":[{"tag":"path","attr":{"d":"M216 0h80c13.3 0 24 10.7 24 24v168h87.7c17.8 0 26.7 21.5 14.1 34.1L269.7 378.3c-7.5 7.5-19.8 7.5-27.3 0L90.1 226.1c-12.6-12.6-3.7-34.1 14.1-34.1H192V24c0-13.3 10.7-24 24-24zm296 376v112c0 13.3-10.7 24-24 24H24c-13.3 0-24-10.7-24-24V376c0-13.3 10.7-24 24-24h146.7l49 49c20.1 20.1 52.5 20.1 72.6 0l49-49H488c13.3 0 24 10.7 24 24zm-124 88c0-11-9-20-20-20s-20 9-20 20 9 20 20 20 20-9 20-20zm64 0c0-11-9-20-20-20s-20 9-20 20 9 20 20 20 20-9 20-20z"},"child":[]}]})(props);
}function FaExternalLinkAlt (props) {
  return GenIcon({"attr":{"viewBox":"0 0 512 512"},"child":[{"tag":"path","attr":{"d":"M432,320H400a16,16,0,0,0-16,16V448H64V128H208a16,16,0,0,0,16-16V80a16,16,0,0,0-16-16H48A48,48,0,0,0,0,112V464a48,48,0,0,0,48,48H400a48,48,0,0,0,48-48V336A16,16,0,0,0,432,320ZM488,0h-128c-21.37,0-32.05,25.91-17,41l35.73,35.73L135,320.37a24,24,0,0,0,0,34L157.67,377a24,24,0,0,0,34,0L435.28,133.32,471,169c15,15,41,4.5,41-17V24A24,24,0,0,0,488,0Z"},"child":[]}]})(props);
}function FaHeart (props) {
  return GenIcon({"attr":{"viewBox":"0 0 512 512"},"child":[{"tag":"path","attr":{"d":"M462.3 62.6C407.5 15.9 326 24.3 275.7 76.2L256 96.5l-19.7-20.3C186.1 24.3 104.5 15.9 49.7 62.6c-62.8 53.6-66.1 149.8-9.9 207.9l193.5 199.8c12.5 12.9 32.8 12.9 45.3 0l193.5-199.8c56.3-58.1 53-154.3-9.8-207.9z"},"child":[]}]})(props);
}function FaHistory (props) {
  return GenIcon({"attr":{"viewBox":"0 0 512 512"},"child":[{"tag":"path","attr":{"d":"M504 255.531c.253 136.64-111.18 248.372-247.82 248.468-59.015.042-113.223-20.53-155.822-54.911-11.077-8.94-11.905-25.541-1.839-35.607l11.267-11.267c8.609-8.609 22.353-9.551 31.891-1.984C173.062 425.135 212.781 440 256 440c101.705 0 184-82.311 184-184 0-101.705-82.311-184-184-184-48.814 0-93.149 18.969-126.068 49.932l50.754 50.754c10.08 10.08 2.941 27.314-11.313 27.314H24c-8.837 0-16-7.163-16-16V38.627c0-14.254 17.234-21.393 27.314-11.314l49.372 49.372C129.209 34.136 189.552 8 256 8c136.81 0 247.747 110.78 248 247.531zm-180.912 78.784l9.823-12.63c8.138-10.463 6.253-25.542-4.21-33.679L288 256.349V152c0-13.255-10.745-24-24-24h-16c-13.255 0-24 10.745-24 24v135.651l65.409 50.874c10.463 8.137 25.541 6.253 33.679-4.21z"},"child":[]}]})(props);
}function FaInfoCircle (props) {
  return GenIcon({"attr":{"viewBox":"0 0 512 512"},"child":[{"tag":"path","attr":{"d":"M256 8C119.043 8 8 119.083 8 256c0 136.997 111.043 248 248 248s248-111.003 248-248C504 119.083 392.957 8 256 8zm0 110c23.196 0 42 18.804 42 42s-18.804 42-42 42-42-18.804-42-42 18.804-42 42-42zm56 254c0 6.627-5.373 12-12 12h-88c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h12v-64h-12c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h64c6.627 0 12 5.373 12 12v100h12c6.627 0 12 5.373 12 12v24z"},"child":[]}]})(props);
}function FaListOl (props) {
  return GenIcon({"attr":{"viewBox":"0 0 512 512"},"child":[{"tag":"path","attr":{"d":"M61.77 401l17.5-20.15a19.92 19.92 0 0 0 5.07-14.19v-3.31C84.34 356 80.5 352 73 352H16a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h22.83a157.41 157.41 0 0 0-11 12.31l-5.61 7c-4 5.07-5.25 10.13-2.8 14.88l1.05 1.93c3 5.76 6.29 7.88 12.25 7.88h4.73c10.33 0 15.94 2.44 15.94 9.09 0 4.72-4.2 8.22-14.36 8.22a41.54 41.54 0 0 1-15.47-3.12c-6.49-3.88-11.74-3.5-15.6 3.12l-5.59 9.31c-3.72 6.13-3.19 11.72 2.63 15.94 7.71 4.69 20.38 9.44 37 9.44 34.16 0 48.5-22.75 48.5-44.12-.03-14.38-9.12-29.76-28.73-34.88zM496 224H176a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-160H176a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16V80a16 16 0 0 0-16-16zm0 320H176a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM16 160h64a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8H64V40a8 8 0 0 0-8-8H32a8 8 0 0 0-7.14 4.42l-8 16A8 8 0 0 0 24 64h8v64H16a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8zm-3.91 160H80a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8H41.32c3.29-10.29 48.34-18.68 48.34-56.44 0-29.06-25-39.56-44.47-39.56-21.36 0-33.8 10-40.46 18.75-4.37 5.59-3 10.84 2.8 15.37l8.58 6.88c5.61 4.56 11 2.47 16.12-2.44a13.44 13.44 0 0 1 9.46-3.84c3.33 0 9.28 1.56 9.28 8.75C51 248.19 0 257.31 0 304.59v4C0 316 5.08 320 12.09 320z"},"child":[]}]})(props);
}function FaListUl (props) {
  return GenIcon({"attr":{"viewBox":"0 0 512 512"},"child":[{"tag":"path","attr":{"d":"M48 48a48 48 0 1 0 48 48 48 48 0 0 0-48-48zm0 160a48 48 0 1 0 48 48 48 48 0 0 0-48-48zm0 160a48 48 0 1 0 48 48 48 48 0 0 0-48-48zm448 16H176a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-320H176a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16V80a16 16 0 0 0-16-16zm0 160H176a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"},"child":[]}]})(props);
}function FaList (props) {
  return GenIcon({"attr":{"viewBox":"0 0 512 512"},"child":[{"tag":"path","attr":{"d":"M80 368H16a16 16 0 0 0-16 16v64a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16v-64a16 16 0 0 0-16-16zm0-320H16A16 16 0 0 0 0 64v64a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16V64a16 16 0 0 0-16-16zm0 160H16a16 16 0 0 0-16 16v64a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16v-64a16 16 0 0 0-16-16zm416 176H176a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-320H176a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16V80a16 16 0 0 0-16-16zm0 160H176a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"},"child":[]}]})(props);
}function FaMusic (props) {
  return GenIcon({"attr":{"viewBox":"0 0 512 512"},"child":[{"tag":"path","attr":{"d":"M470.38 1.51L150.41 96A32 32 0 0 0 128 126.51v261.41A139 139 0 0 0 96 384c-53 0-96 28.66-96 64s43 64 96 64 96-28.66 96-64V214.32l256-75v184.61a138.4 138.4 0 0 0-32-3.93c-53 0-96 28.66-96 64s43 64 96 64 96-28.65 96-64V32a32 32 0 0 0-41.62-30.49z"},"child":[]}]})(props);
}function FaPause (props) {
  return GenIcon({"attr":{"viewBox":"0 0 448 512"},"child":[{"tag":"path","attr":{"d":"M144 479H48c-26.5 0-48-21.5-48-48V79c0-26.5 21.5-48 48-48h96c26.5 0 48 21.5 48 48v352c0 26.5-21.5 48-48 48zm304-48V79c0-26.5-21.5-48-48-48h-96c-26.5 0-48 21.5-48 48v352c0 26.5 21.5 48 48 48h96c26.5 0 48-21.5 48-48z"},"child":[]}]})(props);
}function FaPlay (props) {
  return GenIcon({"attr":{"viewBox":"0 0 448 512"},"child":[{"tag":"path","attr":{"d":"M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z"},"child":[]}]})(props);
}function FaPlus (props) {
  return GenIcon({"attr":{"viewBox":"0 0 448 512"},"child":[{"tag":"path","attr":{"d":"M416 208H272V64c0-17.67-14.33-32-32-32h-32c-17.67 0-32 14.33-32 32v144H32c-17.67 0-32 14.33-32 32v32c0 17.67 14.33 32 32 32h144v144c0 17.67 14.33 32 32 32h32c17.67 0 32-14.33 32-32V304h144c17.67 0 32-14.33 32-32v-32c0-17.67-14.33-32-32-32z"},"child":[]}]})(props);
}function FaQrcode (props) {
  return GenIcon({"attr":{"viewBox":"0 0 448 512"},"child":[{"tag":"path","attr":{"d":"M0 224h192V32H0v192zM64 96h64v64H64V96zm192-64v192h192V32H256zm128 128h-64V96h64v64zM0 480h192V288H0v192zm64-128h64v64H64v-64zm352-64h32v128h-96v-32h-32v96h-64V288h96v32h64v-32zm0 160h32v32h-32v-32zm-64 0h32v32h-32v-32z"},"child":[]}]})(props);
}function FaRandom (props) {
  return GenIcon({"attr":{"viewBox":"0 0 512 512"},"child":[{"tag":"path","attr":{"d":"M504.971 359.029c9.373 9.373 9.373 24.569 0 33.941l-80 79.984c-15.01 15.01-40.971 4.49-40.971-16.971V416h-58.785a12.004 12.004 0 0 1-8.773-3.812l-70.556-75.596 53.333-57.143L352 336h32v-39.981c0-21.438 25.943-31.998 40.971-16.971l80 79.981zM12 176h84l52.781 56.551 53.333-57.143-70.556-75.596A11.999 11.999 0 0 0 122.785 96H12c-6.627 0-12 5.373-12 12v56c0 6.627 5.373 12 12 12zm372 0v39.984c0 21.46 25.961 31.98 40.971 16.971l80-79.984c9.373-9.373 9.373-24.569 0-33.941l-80-79.981C409.943 24.021 384 34.582 384 56.019V96h-58.785a12.004 12.004 0 0 0-8.773 3.812L96 336H12c-6.627 0-12 5.373-12 12v56c0 6.627 5.373 12 12 12h110.785c3.326 0 6.503-1.381 8.773-3.812L352 176h32z"},"child":[]}]})(props);
}function FaRedo (props) {
  return GenIcon({"attr":{"viewBox":"0 0 512 512"},"child":[{"tag":"path","attr":{"d":"M500.33 0h-47.41a12 12 0 0 0-12 12.57l4 82.76A247.42 247.42 0 0 0 256 8C119.34 8 7.9 119.53 8 256.19 8.1 393.07 119.1 504 256 504a247.1 247.1 0 0 0 166.18-63.91 12 12 0 0 0 .48-17.43l-34-34a12 12 0 0 0-16.38-.55A176 176 0 1 1 402.1 157.8l-101.53-4.87a12 12 0 0 0-12.57 12v47.41a12 12 0 0 0 12 12h200.33a12 12 0 0 0 12-12V12a12 12 0 0 0-12-12z"},"child":[]}]})(props);
}function FaSearch (props) {
  return GenIcon({"attr":{"viewBox":"0 0 512 512"},"child":[{"tag":"path","attr":{"d":"M505 442.7L405.3 343c-4.5-4.5-10.6-7-17-7H372c27.6-35.3 44-79.7 44-128C416 93.1 322.9 0 208 0S0 93.1 0 208s93.1 208 208 208c48.3 0 92.7-16.4 128-44v16.3c0 6.4 2.5 12.5 7 17l99.7 99.7c9.4 9.4 24.6 9.4 33.9 0l28.3-28.3c9.4-9.4 9.4-24.6.1-34zM208 336c-70.7 0-128-57.2-128-128 0-70.7 57.2-128 128-128 70.7 0 128 57.2 128 128 0 70.7-57.2 128-128 128z"},"child":[]}]})(props);
}function FaSignOutAlt (props) {
  return GenIcon({"attr":{"viewBox":"0 0 512 512"},"child":[{"tag":"path","attr":{"d":"M497 273L329 441c-15 15-41 4.5-41-17v-96H152c-13.3 0-24-10.7-24-24v-96c0-13.3 10.7-24 24-24h136V88c0-21.4 25.9-32 41-17l168 168c9.3 9.4 9.3 24.6 0 34zM192 436v-40c0-6.6-5.4-12-12-12H96c-17.7 0-32-14.3-32-32V160c0-17.7 14.3-32 32-32h84c6.6 0 12-5.4 12-12V76c0-6.6-5.4-12-12-12H96c-53 0-96 43-96 96v192c0 53 43 96 96 96h84c6.6 0 12-5.4 12-12z"},"child":[]}]})(props);
}function FaStepBackward (props) {
  return GenIcon({"attr":{"viewBox":"0 0 448 512"},"child":[{"tag":"path","attr":{"d":"M64 468V44c0-6.6 5.4-12 12-12h48c6.6 0 12 5.4 12 12v176.4l195.5-181C352.1 22.3 384 36.6 384 64v384c0 27.4-31.9 41.7-52.5 24.6L136 292.7V468c0 6.6-5.4 12-12 12H76c-6.6 0-12-5.4-12-12z"},"child":[]}]})(props);
}function FaStepForward (props) {
  return GenIcon({"attr":{"viewBox":"0 0 448 512"},"child":[{"tag":"path","attr":{"d":"M384 44v424c0 6.6-5.4 12-12 12h-48c-6.6 0-12-5.4-12-12V291.6l-195.5 181C95.9 489.7 64 475.4 64 448V64c0-27.4 31.9-41.7 52.5-24.6L312 219.3V44c0-6.6 5.4-12 12-12h48c6.6 0 12 5.4 12 12z"},"child":[]}]})(props);
}function FaSyncAlt (props) {
  return GenIcon({"attr":{"viewBox":"0 0 512 512"},"child":[{"tag":"path","attr":{"d":"M370.72 133.28C339.458 104.008 298.888 87.962 255.848 88c-77.458.068-144.328 53.178-162.791 126.85-1.344 5.363-6.122 9.15-11.651 9.15H24.103c-7.498 0-13.194-6.807-11.807-14.176C33.933 94.924 134.813 8 256 8c66.448 0 126.791 26.136 171.315 68.685L463.03 40.97C478.149 25.851 504 36.559 504 57.941V192c0 13.255-10.745 24-24 24H345.941c-21.382 0-32.09-25.851-16.971-40.971l41.75-41.749zM32 296h134.059c21.382 0 32.09 25.851 16.971 40.971l-41.75 41.75c31.262 29.273 71.835 45.319 114.876 45.28 77.418-.07 144.315-53.144 162.787-126.849 1.344-5.363 6.122-9.15 11.651-9.15h57.304c7.498 0 13.194 6.807 11.807 14.176C478.067 417.076 377.187 504 256 504c-66.448 0-126.791-26.136-171.315-68.685L48.97 471.03C33.851 486.149 8 475.441 8 454.059V320c0-13.255 10.745-24 24-24z"},"child":[]}]})(props);
}function FaTimes (props) {
  return GenIcon({"attr":{"viewBox":"0 0 352 512"},"child":[{"tag":"path","attr":{"d":"M242.72 256l100.07-100.07c12.28-12.28 12.28-32.19 0-44.48l-22.24-22.24c-12.28-12.28-32.19-12.28-44.48 0L176 189.28 75.93 89.21c-12.28-12.28-32.19-12.28-44.48 0L9.21 111.45c-12.28 12.28-12.28 32.19 0 44.48L109.28 256 9.21 356.07c-12.28 12.28-12.28 32.19 0 44.48l22.24 22.24c12.28 12.28 32.2 12.28 44.48 0L176 322.72l100.07 100.07c12.28 12.28 32.2 12.28 44.48 0l22.24-22.24c12.28-12.28 12.28-32.19 0-44.48L242.72 256z"},"child":[]}]})(props);
}function FaTrash (props) {
  return GenIcon({"attr":{"viewBox":"0 0 448 512"},"child":[{"tag":"path","attr":{"d":"M432 32H312l-9.4-18.7A24 24 0 0 0 281.1 0H166.8a23.72 23.72 0 0 0-21.4 13.3L136 32H16A16 16 0 0 0 0 48v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zM53.2 467a48 48 0 0 0 47.9 45h245.8a48 48 0 0 0 47.9-45L416 128H32z"},"child":[]}]})(props);
}function FaVolumeUp (props) {
  return GenIcon({"attr":{"viewBox":"0 0 576 512"},"child":[{"tag":"path","attr":{"d":"M215.03 71.05L126.06 160H24c-13.26 0-24 10.74-24 24v144c0 13.25 10.74 24 24 24h102.06l88.97 88.95c15.03 15.03 40.97 4.47 40.97-16.97V88.02c0-21.46-25.96-31.98-40.97-16.97zm233.32-51.08c-11.17-7.33-26.18-4.24-33.51 6.95-7.34 11.17-4.22 26.18 6.95 33.51 66.27 43.49 105.82 116.6 105.82 195.58 0 78.98-39.55 152.09-105.82 195.58-11.17 7.32-14.29 22.34-6.95 33.5 7.04 10.71 21.93 14.56 33.51 6.95C528.27 439.58 576 351.33 576 256S528.27 72.43 448.35 19.97zM480 256c0-63.53-32.06-121.94-85.77-156.24-11.19-7.14-26.03-3.82-33.12 7.46s-3.78 26.21 7.41 33.36C408.27 165.97 432 209.11 432 256s-23.73 90.03-63.48 115.42c-11.19 7.14-14.5 22.07-7.41 33.36 6.51 10.36 21.12 15.14 33.12 7.46C447.94 377.94 480 319.54 480 256zm-141.77-76.87c-11.58-6.33-26.19-2.16-32.61 9.45-6.39 11.61-2.16 26.2 9.45 32.61C327.98 228.28 336 241.63 336 256c0 14.38-8.02 27.72-20.92 34.81-11.61 6.41-15.84 21-9.45 32.61 6.43 11.66 21.05 15.8 32.61 9.45 28.23-15.55 45.77-45 45.77-76.88s-17.54-61.32-45.78-76.86z"},"child":[]}]})(props);
}

/**
 * API 调用模块
 * 封装所有与 Python 后端的通信
 */
// ==================== 登录相关 ====================
/** 获取登录二维码 */
const getQrCode = callable("get_qr_code");
/** 检查二维码扫描状态 */
const checkQrStatus = callable("check_qr_status");
/** 退出登录 */
const logout = callable("logout");
// ==================== 搜索相关 ====================
/** 搜索歌曲 */
const searchSongs = callable("search_songs");
/** 获取热门搜索 */
const getHotSearch = callable("get_hot_search");
/** 获取搜索建议 */
const getSearchSuggest = callable("get_search_suggest");
// ==================== 播放相关 ====================
const getSongUrl = callable("get_song_url");
const getSongLyric = callable("get_song_lyric");
// ==================== 推荐相关 ====================
/** 获取猜你喜欢 */
const getGuessLike = callable("get_guess_like");
/** 获取每日推荐 */
const getDailyRecommend = callable("get_daily_recommend");
/** 获取推荐歌单 */
callable("get_recommend_playlists");
/** 获取收藏歌曲 */
callable("get_fav_songs");
// ==================== 歌单相关 ====================
/** 获取用户歌单（创建的和收藏的） */
const getUserPlaylists = callable("get_user_playlists");
/** 获取歌单中的歌曲 */
const getPlaylistSongs = callable("get_playlist_songs");
// ==================== 设置相关 ====================
/** 获取前端持久化设置 */
const getFrontendSettings = callable("get_frontend_settings");
/** 保存前端持久化设置 */
const saveFrontendSettings = callable("save_frontend_settings");
/** 手动清除插件数据（凭证与前端设置） */
const clearAllData = callable("clear_all_settings");
// ==================== 更新相关 ====================
/** 检查更新 */
const checkUpdate = callable("check_update");
/** 下载更新包到 ~/Download */
const downloadUpdate = callable("download_update");
/** 获取本地插件版本（无网络） */
const getPluginVersion = callable("get_plugin_version");
// ==================== Provider 相关 ====================
const getProviderInfo = callable("get_provider_info");
const listProviders = callable("list_providers");
const switchProvider = callable("switch_provider");
const getProviderSelection = callable("get_provider_selection");
// ==================== 日志相关 ====================
/** 前端日志输出到后端 */
callable("log_from_frontend");

/**
 * 认证状态管理模块
 * 使用全局状态 + 订阅者模式，支持多个组件同步登录状态
 */

// ==================== 全局状态 ====================
/**
 * 当前登录状态
 */
let authLoggedIn = false;
/**
 * 订阅者集合：所有监听登录状态变化的回调函数
 */
const authStateListeners = new Set();
// ==================== 状态更新 ====================
/**
 * 设置登录状态
 * 当状态改变时，会通知所有订阅者
 * @param value 新的登录状态
 */
function setAuthLoggedIn(value) {
    // 如果状态没有变化，直接返回，避免不必要的通知
    if (authLoggedIn === value) {
        return;
    }
    // 更新状态
    authLoggedIn = value;
    // 通知所有订阅者
    authStateListeners.forEach((listener) => {
        try {
            listener(authLoggedIn);
        }
        catch {
            // 忽略单个订阅者的错误
        }
    });
}
// ==================== 订阅者系统 ====================
/**
 * 订阅登录状态变化
 * @param listener 状态变化时的回调函数
 * @returns 取消订阅的函数
 */
function subscribeAuth(listener) {
    authStateListeners.add(listener);
    return () => {
        authStateListeners.delete(listener);
    };
}
// ==================== React Hook ====================
/**
 * 获取当前登录状态的 Hook
 * 组件会自动订阅状态变化，并在状态改变时重新渲染
 * @returns 当前登录状态
 */
function useAuthStatus() {
    // 使用当前全局状态初始化本地状态
    const [loggedIn, setLoggedIn] = SP_REACT.useState(authLoggedIn);
    SP_REACT.useEffect(() => {
        // 确保初始状态与全局状态同步
        setLoggedIn(authLoggedIn);
        // 订阅状态变化
        const unsubscribe = subscribeAuth(setLoggedIn);
        // 组件卸载时取消订阅
        return unsubscribe;
    }, []);
    return loggedIn;
}

/**
 * 歌曲队列管理模块
 * 负责管理播放队列状态，支持按 Provider 隔离存储
 */
// ==================== 全局队列状态 ====================
/** 当前播放列表 */
let globalPlaylist = [];
/** 当前播放索引 */
let globalCurrentIndex = -1;
/** 当前激活的 Provider ID */
let globalCurrentProviderId = "";
// ==================== 队列状态管理 (按 Provider 隔离) ====================
/**
 * 获取当前 provider 的队列状态
 */
function loadQueueStateFromSettings(providerId, frontendSettings) {
    const queues = frontendSettings.providerQueues || {};
    const stored = queues[providerId];
    if (!stored)
        return { playlist: [], currentIndex: -1 };
    const playlist = Array.isArray(stored.playlist) ? stored.playlist : [];
    const currentIndex = typeof stored.currentIndex === "number" ? stored.currentIndex : -1;
    const currentMid = stored.currentMid;
    if (currentMid) {
        const idx = playlist.findIndex((s) => s.mid === currentMid);
        if (idx >= 0) {
            return { playlist, currentIndex: idx, currentMid };
        }
    }
    return {
        playlist,
        currentIndex: Math.min(Math.max(currentIndex, -1), Math.max(playlist.length - 1, -1)),
    };
}
/**
 * 保存当前 provider 的队列状态
 */
function saveQueueState(providerId, playlist, currentIndex, currentQueues, updateSettings) {
    if (!providerId)
        return;
    const newQueue = {
        playlist,
        currentIndex,
        currentMid: playlist[currentIndex]?.mid,
    };
    updateSettings({
        providerQueues: {
            ...(currentQueues || {}),
            [providerId]: newQueue,
        },
    });
}
/**
 * 清空指定 provider 的队列状态
 */
function clearQueueState(providerId, currentQueues, updateSettings) {
    if (!providerId)
        return;
    updateSettings({
        providerQueues: {
            ...(currentQueues || {}),
            [providerId]: { playlist: [], currentIndex: -1 },
        },
    });
}
/**
 * 设置播放列表
 */
function setPlaylist(playlist) {
    globalPlaylist = playlist;
}
/**
 * 设置当前播放索引
 */
function setCurrentIndex(index) {
    globalCurrentIndex = index;
}
/**
 * 设置当前 Provider ID
 */
function setProviderId(providerId) {
    globalCurrentProviderId = providerId;
}
/**
 * 重置队列状态
 */
function resetQueueState() {
    globalPlaylist = [];
    globalCurrentIndex = -1;
    globalCurrentProviderId = "";
}

/**
 * 播放器设置管理模块
 * 负责前端设置的缓存、加载和保存
 */
const DEFAULT_PREFERRED_QUALITY = "auto";
// ==================== 设置缓存 ====================
let frontendSettings = {};
let frontendSettingsLoaded = false;
let frontendSettingsPromise = null;
let frontendSaveEnabled = true;
// ==================== 保存队列管理 ====================
// 使用防抖机制避免频繁保存，确保保存操作的顺序性，避免竞态问题
let saveTimeoutId = null;
let savePromise = null;
let pendingSettings = null;
const SAVE_DEBOUNCE_MS = 300; // 防抖延迟 300ms
/**
 * 确保前端设置已加载
 */
async function ensureFrontendSettingsLoaded() {
    if (frontendSettingsLoaded)
        return;
    if (frontendSettingsPromise) {
        await frontendSettingsPromise;
        return;
    }
    frontendSettingsPromise = getFrontendSettings()
        .then((res) => {
        if (res?.success && res.settings) {
            frontendSettings = { ...res.settings };
        }
        if (!frontendSettings.preferredQuality) {
            frontendSettings.preferredQuality = DEFAULT_PREFERRED_QUALITY;
        }
        frontendSettingsLoaded = true;
    })
        .catch(() => {
        frontendSettingsLoaded = true;
    })
        .finally(() => {
        frontendSettingsPromise = null;
    });
    await frontendSettingsPromise;
}
/**
 * 执行实际的保存操作（异步，确保顺序）
 * 每次只保存一个版本，避免竞态问题
 */
async function performSave() {
    if (!pendingSettings)
        return;
    // 保存当前待保存的设置，并清空 pendingSettings
    // 这样在保存期间如果有新修改，会更新 pendingSettings，保存完成后会继续保存
    const settingsToSave = pendingSettings;
    pendingSettings = null;
    try {
        await saveFrontendSettings(settingsToSave);
    }
    catch (error) {
        // 保存失败时，如果期间没有新修改，将设置重新加入待保存队列
        if (!pendingSettings) {
            pendingSettings = settingsToSave;
        }
        // 不抛出错误，避免影响用户体验，静默重试
    }
}
/**
 * 触发防抖保存
 *
 * 机制说明：
 * 1. 每次调用都会更新 pendingSettings 为最新状态
 * 2. 使用防抖机制，300ms 内的多次修改只会触发一次保存
 * 3. 如果已有正在进行的保存，pendingSettings 会更新为最新状态
 * 4. 保存完成后会自动检查是否有新修改，继续保存
 *
 * 这样可以：
 * - 避免频繁保存（防抖）
 * - 避免重复保存（同一时间只有一个保存操作）
 * - 避免竞态问题（保存操作按顺序执行）
 * - 确保最新状态被保存（pendingSettings 始终是最新的）
 */
function scheduleSave() {
    if (!frontendSaveEnabled)
        return;
    // 更新待保存的设置（始终使用最新状态）
    pendingSettings = { ...frontendSettings };
    // 清除之前的定时器（防抖：重置计时）
    if (saveTimeoutId) {
        clearTimeout(saveTimeoutId);
        saveTimeoutId = null;
    }
    // 如果当前没有正在进行的保存，设置新的定时器
    if (!savePromise) {
        saveTimeoutId = setTimeout(() => {
            saveTimeoutId = null;
            // 再次检查是否有待保存的设置（可能在定时器期间又有新修改）
            if (!pendingSettings)
                return;
            savePromise = performSave()
                .finally(() => {
                savePromise = null;
                // 如果保存期间有新的修改，继续保存（递归调用）
                if (pendingSettings) {
                    scheduleSave();
                }
            });
        }, SAVE_DEBOUNCE_MS);
    }
    // 如果有正在进行的保存，pendingSettings 已经更新为最新状态
    // 保存完成后会自动检查并继续保存（在 performSave 的 finally 中）
}
/**
 * 更新前端设置缓存
 */
function updateFrontendSettingsCache(partial, commit = true) {
    frontendSettings = { ...frontendSettings, ...partial };
    if (commit && frontendSaveEnabled) {
        scheduleSave();
    }
}
/**
 * 获取前端设置缓存
 */
function getFrontendSettingsCache() {
    return frontendSettings;
}
/**
 * 获取首选音质
 */
function getPreferredQuality() {
    const pref = frontendSettings.preferredQuality;
    if (pref === "high" || pref === "balanced" || pref === "compat" || pref === "auto") {
        return pref;
    }
    return DEFAULT_PREFERRED_QUALITY;
}
/**
 * 设置首选音质
 */
function setPreferredQuality(quality) {
    updateFrontendSettingsCache({ preferredQuality: quality }, true);
}
/**
 * 加载播放模式
 */
function loadPlayMode() {
    const raw = frontendSettings.playMode;
    if (raw === "order" || raw === "single" || raw === "shuffle") {
        return raw;
    }
    return "order";
}
/**
 * 保存播放模式
 */
function savePlayMode(mode) {
    updateFrontendSettingsCache({ playMode: mode });
}
/**
 * 加载音量
 */
function loadVolume() {
    const value = frontendSettings.volume;
    if (typeof value === "number") {
        return Math.min(1, Math.max(0, value));
    }
    return 1;
}
/**
 * 保存音量
 */
function saveVolume(volume) {
    updateFrontendSettingsCache({ volume });
}
/**
 * 启用/禁用设置保存
 */
function enableSettingsSave(enabled) {
    frontendSaveEnabled = enabled;
}
/**
 * 重置设置缓存
 */
function resetSettingsCache() {
    frontendSettings = {};
    frontendSettingsLoaded = false;
    frontendSettingsPromise = null;
}

/**
 * 随机播放状态管理模块
 * 负责管理随机播放的历史记录和下一首选择逻辑
 */
// ==================== 随机播放状态 ====================
let shuffleHistory = [];
let shuffleCursor = -1;
let shufflePool = [];
/**
 * 从历史记录构建随机池
 */
function buildShufflePoolFromHistory(currentIndex) {
    const blocked = new Set(shuffleHistory);
    const pool = [];
    for (let i = 0; i < globalPlaylist.length; i += 1) {
        if (i === currentIndex)
            continue;
        if (blocked.has(i))
            continue;
        pool.push(i);
    }
    return pool;
}
/**
 * 重置随机播放状态
 */
function resetShuffleState(currentIndex) {
    if (globalPlaylist.length === 0 || currentIndex < 0) {
        shuffleHistory = [];
        shuffleCursor = -1;
        shufflePool = [];
        return;
    }
    shuffleHistory = [currentIndex];
    shuffleCursor = 0;
    shufflePool = buildShufflePoolFromHistory(currentIndex);
}
/**
 * 同步随机播放状态（播放列表变化后）
 */
function syncShuffleAfterPlaylistChange(currentIndex) {
    if (globalPlaylist.length === 0 || currentIndex < 0) {
        resetShuffleState(currentIndex);
        return;
    }
    // 清理无效索引并去重，保证 currentIndex 在历史中
    shuffleHistory = shuffleHistory.filter((idx) => idx >= 0 && idx < globalPlaylist.length);
    const seen = new Set();
    shuffleHistory = shuffleHistory.filter((idx) => {
        if (seen.has(idx))
            return false;
        seen.add(idx);
        return true;
    });
    const existingPos = shuffleHistory.indexOf(currentIndex);
    if (existingPos === -1) {
        shuffleHistory = [currentIndex];
        shuffleCursor = 0;
    }
    else {
        shuffleHistory = shuffleHistory.slice(0, existingPos + 1);
        shuffleCursor = existingPos;
    }
    shufflePool = buildShufflePoolFromHistory(currentIndex);
}
/**
 * 获取随机播放的下一首索引
 */
function getShuffleNextIndex() {
    if (globalPlaylist.length === 0)
        return null;
    if (shuffleCursor < 0 || shuffleHistory.length === 0) {
        resetShuffleState(globalCurrentIndex >= 0 ? globalCurrentIndex : 0);
    }
    if (shuffleCursor < shuffleHistory.length - 1) {
        shuffleCursor += 1;
        return shuffleHistory[shuffleCursor] ?? null;
    }
    if (shufflePool.length === 0) {
        shufflePool = buildShufflePoolFromHistory(globalCurrentIndex);
    }
    if (shufflePool.length === 0) {
        return globalCurrentIndex >= 0 ? globalCurrentIndex : null;
    }
    const pickedIdx = Math.floor(Math.random() * shufflePool.length);
    const picked = shufflePool.splice(pickedIdx, 1)[0];
    shuffleHistory.push(picked);
    shuffleCursor = shuffleHistory.length - 1;
    return picked ?? null;
}
/**
 * 获取随机播放的上一首索引
 */
function getShufflePrevIndex() {
    if (shuffleCursor > 0) {
        shuffleCursor -= 1;
        return shuffleHistory[shuffleCursor] ?? null;
    }
    return shuffleHistory[0] ?? (globalCurrentIndex >= 0 ? globalCurrentIndex : null);
}
/**
 * 处理从队列中删除歌曲时的随机状态更新
 */
function handleShuffleRemove(index) {
    shuffleHistory = shuffleHistory
        .filter((idx) => idx !== index)
        .map((idx) => (idx > index ? idx - 1 : idx));
    shufflePool = shufflePool
        .filter((idx) => idx !== index)
        .map((idx) => (idx > index ? idx - 1 : idx));
    shuffleCursor = Math.min(shuffleCursor, shuffleHistory.length - 1);
}
/**
 * 处理向队列添加歌曲时的随机状态更新
 */
function handleShuffleAdd(newIndices) {
    const blocked = new Set(shuffleHistory);
    newIndices.forEach((newIndex) => {
        if (!blocked.has(newIndex) &&
            !shufflePool.includes(newIndex) &&
            newIndex !== globalCurrentIndex) {
            shufflePool.push(newIndex);
        }
    });
}
/**
 * 处理跳转到指定索引时的随机状态更新
 */
function handleShuffleJumpTo(index) {
    const existingPos = shuffleHistory.indexOf(index);
    if (existingPos >= 0) {
        shuffleHistory = shuffleHistory.slice(0, existingPos + 1);
        shuffleCursor = existingPos;
    }
    else {
        shuffleHistory = shuffleHistory.slice(0, Math.max(shuffleCursor, 0) + 1);
        shuffleHistory.push(index);
        shuffleCursor = shuffleHistory.length - 1;
    }
    shufflePool = buildShufflePoolFromHistory(index);
}
/**
 * 重置所有随机播放状态
 */
function resetAllShuffleState() {
    shuffleHistory = [];
    shuffleCursor = -1;
    shufflePool = [];
}

let globalAudio = null;
let globalVolume = 1;
let endedHandlerRegistered = false;
let globalEndedHandler = null;
function setGlobalEndedHandler(handler) {
    globalEndedHandler = handler;
}
function handleAudioEnded() {
    if (globalEndedHandler) {
        globalEndedHandler();
    }
}
function getGlobalAudio() {
    if (!globalAudio) {
        globalAudio = new Audio();
        globalAudio.preload = "auto";
        globalAudio.volume = globalVolume;
    }
    if (!endedHandlerRegistered && globalAudio) {
        globalAudio.addEventListener("ended", handleAudioEnded);
        endedHandlerRegistered = true;
    }
    return globalAudio;
}
/**
 * 获取当前音频播放时间（秒）
 * 直接从 Audio 元素获取，用于高频动画更新
 */
function getAudioCurrentTime() {
    return globalAudio?.currentTime || 0;
}
/**
 * 设置全局音量
 */
function setGlobalVolume(volume) {
    const clamped = Math.min(1, Math.max(0, volume));
    globalVolume = clamped;
    const audio = getGlobalAudio();
    if (audio.volume !== clamped) {
        audio.volume = clamped;
    }
}
/**
 * 获取全局音量
 */
function getGlobalVolume() {
    return globalVolume;
}
function cleanupAudio() {
    if (globalAudio) {
        globalAudio.removeEventListener("ended", handleAudioEnded);
        globalAudio.pause();
        globalAudio.src = "";
        globalAudio = null;
    }
    endedHandlerRegistered = false;
    globalEndedHandler = null;
}

/**
 * 播放器全局状态管理模块
 * 负责管理全局播放状态和订阅者系统
 */
// ==================== 全局状态 ====================
/** 当前播放的歌曲 */
let globalCurrentSong = null;
/** 当前歌词 */
let globalLyric = null;
/** 全局播放模式 */
let globalPlayMode = "order";
// ==================== 订阅者系统 ====================
/**
 * 订阅者：用于在多个 usePlayer 实例间同步状态（侧边栏/全屏等）
 */
const playerSubscribers = new Set();
/**
 * 通知所有订阅者
 */
function notifyPlayerSubscribers() {
    playerSubscribers.forEach((fn) => {
        try {
            fn();
        }
        catch {
            // 忽略订阅者错误
        }
    });
}
/**
 * 广播播放器状态变化
 */
function broadcastPlayerState() {
    notifyPlayerSubscribers();
}
/**
 * 订阅播放器状态变化
 */
function subscribePlayerState(callback) {
    playerSubscribers.add(callback);
    return () => {
        playerSubscribers.delete(callback);
    };
}
// ==================== 状态设置函数 ====================
/**
 * 设置当前歌曲
 */
function setGlobalCurrentSong(song) {
    globalCurrentSong = song;
}
/**
 * 获取当前歌曲
 */
function getGlobalCurrentSong() {
    return globalCurrentSong;
}
/**
 * 设置当前歌词
 */
function setGlobalLyric(lyric) {
    globalLyric = lyric;
}
/**
 * 获取当前歌词
 */
function getGlobalLyric() {
    return globalLyric;
}
/**
 * 设置全局播放模式
 */
function setGlobalPlayMode(mode) {
    globalPlayMode = mode;
}
/**
 * 获取全局播放模式
 */
function getGlobalPlayMode() {
    return globalPlayMode;
}
/**
 * 重置所有全局状态
 */
function resetGlobalPlayerState() {
    globalCurrentSong = null;
    globalLyric = null;
    globalPlayMode = "order";
    playerSubscribers.clear();
}

/**
 * 歌词解析器
 * 支持 LRC 和 QRC (卡拉OK) 格式
 */
// 清理非标准时间标记的正则 (支持 (100), (100,200), (100,200,300) 等格式)
const CLEANUP_TIME_MARKER_REGEX = /\(\d+(?:,\d+)*\)/g;
/**
 * 解析时间标签 [mm:ss.xx] 或 [mm:ss:xx] 或 [mm:ss]
 * @returns 毫秒数，解析失败返回 -1
 */
function parseTime(timeStr) {
    const match = timeStr.match(/(\d+):(\d+)(?:[.:](\d+))?/);
    if (!match)
        return -1;
    const minutes = parseInt(match[1], 10);
    const seconds = parseInt(match[2], 10);
    let milliseconds = 0;
    if (match[3]) {
        milliseconds = parseInt(match[3], 10);
        // 如果是两位数，补齐到三位（10 -> 100）
        if (match[3].length === 2) {
            milliseconds *= 10;
        }
    }
    return minutes * 60 * 1000 + seconds * 1000 + milliseconds;
}
/**
 * 检查是否是无效的歌词文本（纯符号、间奏标记等）
 */
function isInvalidLyricText(text) {
    const trimmed = text.trim();
    // 过滤纯符号、空行
    if (!trimmed || /^[/\-*~\s\\：:.。，,]+$/.test(trimmed))
        return true;
    // 过滤纯坐标/时间标记行，如 (1062,531)
    if (/^\(\d+(?:,\d+)*\)$/.test(trimmed))
        return true;
    return false;
}
/**
 * 解析完整 LRC 歌词
 */
function parseLrc(lrc) {
    const map = new Map();
    if (!lrc || typeof lrc !== "string")
        return map;
    const cleaned = lrc.replace(/^\uFEFF/, "").replace(/\r/g, "");
    const timeTagRegex = /\[(\d+:\d+(?:[.:]\d+)?)\]/g;
    for (const line of cleaned.split("\n")) {
        const trimmedLine = line.trimEnd();
        if (!trimmedLine)
            continue;
        const times = [];
        let match;
        while ((match = timeTagRegex.exec(trimmedLine)) !== null) {
            const time = parseTime(match[1]);
            if (time >= 0)
                times.push(time);
        }
        const text = trimmedLine.replace(/\[\d+:\d+(?:[.:]\d+)?\]/g, "").trim();
        if (text && !isInvalidLyricText(text)) {
            for (const time of times) {
                map.set(time, text);
            }
        }
    }
    return map;
}
/**
 * 将 LRC Map 转换为 LyricLine 数组
 */
function buildLrcLines(lyricMap, transMap) {
    const allTimes = new Set([...lyricMap.keys(), ...transMap.keys()]);
    const sortedTimes = Array.from(allTimes).sort((a, b) => a - b);
    const lines = [];
    for (const time of sortedTimes) {
        const text = lyricMap.get(time) || "";
        if (text) {
            lines.push({ time, text, trans: transMap.get(time) });
        }
    }
    return lines;
}
/**
 * 检测是否是 QRC 格式歌词
 * QRC 格式特征：[lineStart,lineDuration]word(start,duration)...
 */
function isQrcFormat(lyric) {
    const trimmed = lyric.trim();
    if (!trimmed)
        return false;
    // 检查前30行是否有 QRC 格式的行首 [数字,数字]
    const lines = trimmed.split("\n").slice(0, 30);
    return lines.some((line) => /^\[\d+,\d+/.test(line.trim()));
}
/**
 * 解析 QRC 格式歌词
 * 支持 QQ 音乐和网易云 YRC 格式
 */
function parseQrc(qrc) {
    const result = [];
    if (!qrc || typeof qrc !== "string")
        return result;
    const cleaned = qrc.replace(/^\uFEFF/, "").replace(/\r/g, "");
    // 支持 QQ 音乐 (数字,数字) 和 网易云 YRC (数字,数字,数字)
    const timeMarkerRegex = /\((\d+),(\d+)(?:,\d+)?\)/g;
    for (const line of cleaned.split("\n")) {
        const trimmedLine = line.trimEnd();
        if (!trimmedLine)
            continue;
        // 匹配行首格式：[数字,数字] 或 [数字,数字,其他]
        const lineMatch = trimmedLine.match(/^\[(\d+),(\d+)(?:,.*?)?\](.+)$/);
        if (!lineMatch)
            continue;
        const lineStart = parseInt(lineMatch[1], 10);
        if (isNaN(lineStart) || lineStart < 0)
            continue;
        const content = lineMatch[3];
        const words = [];
        let fullText = "";
        // 收集所有时间标记
        const allMarkers = [];
        let timeMatch;
        while ((timeMatch = timeMarkerRegex.exec(content)) !== null) {
            const start = parseInt(timeMatch[1], 10);
            const duration = parseInt(timeMatch[2], 10);
            if (!isNaN(start) && !isNaN(duration) && start >= 0) {
                allMarkers.push({
                    index: timeMatch.index,
                    length: timeMatch[0].length,
                    start: start / 1000,
                    duration: duration / 1000,
                    isValid: duration > 0,
                });
            }
        }
        // 提取文本并构建 words 数组
        let lastEnd = 0;
        let lastValidMarker = null;
        for (const marker of allMarkers) {
            const text = content.substring(lastEnd, marker.index);
            if (text) {
                const wordStart = marker.isValid
                    ? marker.start
                    : lastValidMarker
                        ? lastValidMarker.start + lastValidMarker.duration
                        : lineStart / 1000;
                const wordDuration = marker.isValid ? marker.duration : 0.1;
                words.push({ text, start: wordStart, duration: wordDuration });
                fullText += text;
            }
            lastEnd = marker.index + marker.length;
            if (marker.isValid)
                lastValidMarker = marker;
        }
        // 处理最后一个时间标记后的文本
        if (lastEnd < content.length) {
            const remaining = content.substring(lastEnd).replace(CLEANUP_TIME_MARKER_REGEX, "");
            if (remaining.trim()) {
                const startTime = lastValidMarker
                    ? lastValidMarker.start + lastValidMarker.duration
                    : lineStart / 1000;
                words.push({ text: remaining, start: startTime, duration: 0.1 });
                fullText += remaining;
            }
        }
        // 如果没有时间标记但有内容，整行作为一个词
        if (words.length === 0 && content.trim()) {
            const cleanedContent = content.replace(CLEANUP_TIME_MARKER_REGEX, "").trim();
            if (cleanedContent) {
                words.push({ text: cleanedContent, start: lineStart / 1000, duration: 0.1 });
                fullText = cleanedContent;
            }
        }
        // 过滤无效行
        if (words.length > 0) {
            const cleanText = fullText.trim();
            const isInterlude = /^[/\-*~\s\\：:]+$/.test(cleanText) || !cleanText;
            const isMetaInfo = /^(Writtenby|Composedby|Producedby|Arrangedby|词|曲|编曲|制作|演唱|原唱|翻唱)[\s：:]/i.test(cleanText) ||
                /[-–]\s*(Artist|Singer|Band|作词|作曲|编曲)/i.test(cleanText);
            const allSymbols = words.every((w) => /^[/\-*~\s\\：:.。，,()（）]+$/.test(w.text.trim()));
            const isTitleLine = result.length === 0 && cleanText.includes(" - ") && lineStart < 60000;
            if (!isInterlude && !isMetaInfo && !allSymbols && !isTitleLine) {
                result.push({ time: lineStart / 1000, words, text: fullText });
            }
        }
    }
    return result.sort((a, b) => a.time - b.time);
}
/**
 * 解析歌词（原文 + 翻译）
 * 自动检测 QRC 或 LRC 格式
 */
function parseLyric(lyric, trans) {
    if (!lyric || typeof lyric !== "string") {
        return { lines: [], isQrc: false };
    }
    const transMap = trans ? parseLrc(trans) : new Map();
    // 检测并尝试解析 QRC 格式
    if (isQrcFormat(lyric)) {
        const qrcLines = parseQrc(lyric);
        if (qrcLines.length > 0) {
            // 为 QRC 行添加翻译（时间差在 500ms 内匹配）
            for (const line of qrcLines) {
                const lineTimeMs = line.time * 1000;
                for (const [transTime, transText] of transMap) {
                    if (Math.abs(transTime - lineTimeMs) < 500 && !isInvalidLyricText(transText)) {
                        line.trans = transText;
                        break;
                    }
                }
            }
            // 同时生成 LRC 格式的 lines（用于回退）
            const lines = qrcLines.map((qrcLine) => ({
                time: qrcLine.time * 1000,
                text: qrcLine.text,
                trans: qrcLine.trans,
            }));
            return { lines, qrcLines, isQrc: true };
        }
        // QRC 解析失败，回退到 LRC
    }
    // LRC 格式解析
    const lyricMap = parseLrc(lyric);
    return { lines: buildLrcLines(lyricMap, transMap), isQrc: false };
}

/**
 * 歌词管理模块
 * 负责歌词的获取和解析
 * 注意：缓存功能已移除
 */
// ==================== 预取任务管理（已禁用） ====================
/**
 * 获取歌词（不再使用缓存，每次重新获取）
 */
async function fetchLyricWithCache(mid, songName, singer, onResolved) {
    try {
        const res = await getSongLyric(mid, true, songName, singer);
        if (res.success && res.lyric) {
            const parsed = parseLyric(res.lyric, res.trans);
            onResolved?.(parsed);
            if (res.fallback_provider) {
                toaster.toast({
                    title: "歌词来源",
                    body: `已从 ${res.fallback_provider} 获取歌词`,
                });
            }
            return parsed;
        }
        return null;
    }
    catch {
        return null;
    }
}

/**
 * 播放器播放逻辑模块
 * 负责处理单首歌曲的播放流程
 */
// 自动跳过的 timeout ID，用于取消
let skipTimeoutId = null;
/**
 * 清除跳过定时器
 */
function clearSkipTimeout() {
    if (skipTimeoutId) {
        clearTimeout(skipTimeoutId);
        skipTimeoutId = null;
    }
}
/**
 * 设置跳过定时器
 */
function setSkipTimeout(callback) {
    clearSkipTimeout();
    skipTimeoutId = setTimeout(() => {
        skipTimeoutId = null;
        callback();
    }, 2000);
}
/**
 * 播放歌曲的内部实现
 * @param song 要播放的歌曲
 * @param index 在播放列表中的索引（-1 表示不在列表中）
 * @param autoSkipOnError 播放失败时是否自动跳过
 * @param onPlayNext 播放下一首的回调（用于自动跳过）
 * @param setLoading 设置加载状态的函数
 * @param setError 设置错误状态的函数
 * @param setCurrentSong 设置当前歌曲的函数
 * @param setCurrentTime 设置当前时间的函数
 * @param setDuration 设置时长的函数
 * @param setIsPlaying 设置播放状态的函数
 * @param setLyric 设置歌词的函数
 * @returns 是否播放成功
 */
async function playSongInternal(song, index = -1, autoSkipOnError = true, onPlayNext, setLoading, setError, setCurrentSong, setCurrentTime, setDuration, setIsPlaying, setLyric) {
    const audio = getGlobalAudio();
    clearSkipTimeout();
    const wasSameSong = getGlobalCurrentSong()?.mid === song.mid;
    const hasAnyLyric = Boolean(getGlobalLyric());
    setLoading?.(true);
    setError?.("");
    setCurrentSong?.(song);
    setCurrentTime?.(0);
    setDuration?.(song.duration);
    if (!wasSameSong) {
        setLyric?.(null);
        setGlobalLyric(null);
    }
    else if (getGlobalLyric()) {
        setLyric?.(getGlobalLyric());
    }
    setGlobalCurrentSong(song);
    if (index >= 0) {
        setCurrentIndex(index);
    }
    // 保存队列状态
    const frontendSettings = getFrontendSettingsCache();
    saveQueueState(globalCurrentProviderId, globalPlaylist, globalCurrentIndex, frontendSettings.providerQueues, updateFrontendSettingsCache);
    try {
        const urlResult = await getSongUrl(song.mid, getPreferredQuality(), song.name, song.singer);
        if (!urlResult.success || !urlResult.url) {
            const errorMsg = urlResult.error || "该歌曲暂时无法播放";
            setError?.(errorMsg);
            setLoading?.(false);
            toaster.toast({
                title: `⚠️ ${song.name}`,
                body: errorMsg,
            });
            if (autoSkipOnError && globalPlaylist.length > 1 && onPlayNext) {
                setSkipTimeout(onPlayNext);
            }
            return false;
        }
        if (urlResult.fallback_provider) {
            toaster.toast({
                title: "备用音源",
                body: `已从 ${urlResult.fallback_provider} 获取`,
            });
        }
        const playUrl = urlResult.url;
        audio.src = playUrl;
        audio.load();
        try {
            await audio.play();
            setIsPlaying?.(true);
            setLoading?.(false);
        }
        catch (e) {
            const errorMsg = e.message;
            setError?.(errorMsg);
            setLoading?.(false);
            toaster.toast({ title: "播放失败", body: errorMsg });
            if (autoSkipOnError && globalPlaylist.length > 1 && onPlayNext) {
                setSkipTimeout(onPlayNext);
            }
            return false;
        }
        if (!hasAnyLyric) {
            void fetchLyricWithCache(song.mid, song.name, song.singer, (parsed) => {
                setGlobalLyric(parsed);
                setLyric?.(parsed);
                broadcastPlayerState();
            });
        }
        broadcastPlayerState();
        return true;
    }
    catch (e) {
        const errorMsg = e.message;
        setError?.(errorMsg);
        setLoading?.(false);
        toaster.toast({ title: "播放出错", body: errorMsg });
        return false;
    }
}

/**
 * 播放器导航逻辑模块
 * 负责处理播放列表的导航（上一首、下一首、跳转）
 */
// 播放下一首的回调（用于在 ended 事件中调用）
let onPlayNextCallback = null;
// 播放列表结束时获取更多歌曲的回调
let onNeedMoreSongsCallback = null;
/**
 * 设置播放下一首的回调
 */
function setOnPlayNextCallback(callback) {
    onPlayNextCallback = callback;
}
/**
 * 获取播放下一首的回调
 */
function getOnPlayNextCallback() {
    return onPlayNextCallback;
}
/**
 * 设置获取更多歌曲的回调
 */
function setOnNeedMoreSongsCallback(callback) {
    onNeedMoreSongsCallback = callback;
}
/**
 * 创建播放下一首的函数
 */
function createPlayNext(playSongInternalFn, setPlaylist) {
    return async () => {
        if (globalPlaylist.length === 0)
            return;
        // 立即暂停当前播放，提升响应速度
        const audio = getGlobalAudio();
        audio.pause();
        const resolveOrderNext = async () => {
            let nextIndex = globalCurrentIndex + 1;
            if (nextIndex >= globalPlaylist.length) {
                if (onNeedMoreSongsCallback) {
                    try {
                        const moreSongs = await onNeedMoreSongsCallback();
                        if (moreSongs && moreSongs.length > 0) {
                            const insertPos = globalCurrentIndex + 1;
                            globalPlaylist.splice(insertPos, 0, ...moreSongs);
                            setPlaylist?.([...globalPlaylist]);
                            nextIndex = insertPos;
                        }
                        else {
                            return null;
                        }
                    }
                    catch {
                        return null;
                    }
                }
                else {
                    return null;
                }
            }
            return nextIndex;
        };
        let targetIndex = null;
        const currentMode = getGlobalPlayMode();
        if (currentMode === "single") {
            targetIndex = globalCurrentIndex;
        }
        else if (currentMode === "shuffle") {
            targetIndex = getShuffleNextIndex();
        }
        else {
            targetIndex = await resolveOrderNext();
        }
        if (targetIndex === null || targetIndex < 0 || targetIndex >= globalPlaylist.length) {
            return;
        }
        const nextSong = globalPlaylist[targetIndex];
        if (currentMode === "shuffle") {
            syncShuffleAfterPlaylistChange(targetIndex);
        }
        if (nextSong) {
            // playSongInternal 内部已经会调用 saveQueueState，这里不需要重复调用
            await playSongInternalFn(nextSong, targetIndex, true, onPlayNextCallback || undefined);
        }
    };
}
/**
 * 创建播放上一首的函数
 */
function createPlayPrev(playSongInternalFn) {
    return () => {
        if (globalPlaylist.length === 0)
            return;
        // 立即暂停当前播放，提升响应速度
        const audio = getGlobalAudio();
        audio.pause();
        let targetIndex = null;
        const currentMode = getGlobalPlayMode();
        if (currentMode === "single") {
            targetIndex = globalCurrentIndex;
        }
        else if (currentMode === "shuffle") {
            targetIndex = getShufflePrevIndex();
        }
        else {
            const prevIndex = globalCurrentIndex - 1;
            targetIndex = prevIndex >= 0 ? prevIndex : null;
        }
        if (targetIndex === null || targetIndex < 0 || targetIndex >= globalPlaylist.length) {
            return;
        }
        if (currentMode === "shuffle") {
            syncShuffleAfterPlaylistChange(targetIndex);
        }
        const prevSong = globalPlaylist[targetIndex];
        if (prevSong) {
            // playSongInternal 内部已经会调用 saveQueueState，这里不需要重复调用
            void playSongInternalFn(prevSong, targetIndex, true, onPlayNextCallback || undefined);
        }
    };
}
/**
 * 创建按索引播放的函数
 */
function createPlayAtIndex(playSongInternalFn) {
    return async (index) => {
        if (index < 0 || index >= globalPlaylist.length)
            return;
        // 立即暂停当前播放，提升响应速度
        const audio = getGlobalAudio();
        audio.pause();
        if (getGlobalPlayMode() === "shuffle") {
            handleShuffleJumpTo(index);
        }
        setCurrentIndex(index);
        // playSongInternal 内部已经会调用 saveQueueState，这里不需要重复调用
        const song = globalPlaylist[index];
        await playSongInternalFn(song, index, true, onPlayNextCallback || undefined);
    };
}

/**
 * 播放器队列操作模块
 * 负责处理播放列表的增删改查操作
 */
/**
 * 创建播放单曲的函数
 */
function createPlaySong(playSongInternalFn, setPlaylist$1, setCurrentIndex$1) {
    return async (song) => {
        if (!getGlobalCurrentSong() || globalCurrentIndex < 0) {
            setPlaylist([song]);
            setCurrentIndex(0);
            setPlaylist$1([song]);
            setCurrentIndex$1(0);
            syncShuffleAfterPlaylistChange(0);
            // 立即保存队列状态
            const frontendSettings = getFrontendSettingsCache();
            saveQueueState(globalCurrentProviderId, globalPlaylist, globalCurrentIndex, frontendSettings.providerQueues, updateFrontendSettingsCache);
            const callback = getOnPlayNextCallback();
            await playSongInternalFn(song, 0, false, callback || undefined);
            return;
        }
        const filtered = globalPlaylist.filter((s, idx) => s.mid !== song.mid || idx === globalCurrentIndex);
        const past = filtered.slice(0, globalCurrentIndex + 1);
        const future = filtered.slice(globalCurrentIndex + 1);
        const newPlaylist = [...past, song, ...future];
        const newIndex = past.length;
        setPlaylist(newPlaylist);
        setCurrentIndex(newIndex);
        setPlaylist$1([...globalPlaylist]);
        setCurrentIndex$1(newIndex);
        syncShuffleAfterPlaylistChange(newIndex);
        const frontendSettings = getFrontendSettingsCache();
        saveQueueState(globalCurrentProviderId, globalPlaylist, globalCurrentIndex, frontendSettings.providerQueues, updateFrontendSettingsCache);
        const callback = getOnPlayNextCallback();
        await playSongInternalFn(song, newIndex, false, callback || undefined);
    };
}
/**
 * 创建播放播放列表的函数
 */
function createPlayPlaylist(playSongInternalFn, setPlaylist$1, setCurrentIndex$1) {
    return async (songs, startIndex = 0) => {
        if (songs.length === 0)
            return;
        if (!getGlobalCurrentSong() || globalCurrentIndex < 0) {
            setPlaylist(songs);
            setCurrentIndex(startIndex);
            setPlaylist$1([...songs]);
            setCurrentIndex$1(startIndex);
            syncShuffleAfterPlaylistChange(startIndex);
            // 立即保存队列状态
            const frontendSettings = getFrontendSettingsCache();
            saveQueueState(globalCurrentProviderId, globalPlaylist, globalCurrentIndex, frontendSettings.providerQueues, updateFrontendSettingsCache);
            const callback = getOnPlayNextCallback();
            await playSongInternalFn(songs[startIndex], startIndex, false, callback || undefined);
            return;
        }
        const currentMid = globalPlaylist[globalCurrentIndex].mid;
        const seen = new Set([currentMid]);
        const cleaned = globalPlaylist.filter((s, idx) => {
            if (idx === globalCurrentIndex)
                return true;
            if (seen.has(s.mid))
                return false;
            seen.add(s.mid);
            return true;
        });
        const songsToInsert = songs.filter((s) => {
            if (seen.has(s.mid))
                return false;
            seen.add(s.mid);
            return true;
        });
        if (songsToInsert.length === 0) {
            const clampedStartIndex = Math.min(Math.max(startIndex, 0), songs.length - 1);
            const targetMid = songs[clampedStartIndex]?.mid;
            const targetIndex = cleaned.findIndex((s) => s.mid === targetMid);
            if (targetIndex < 0) {
                setPlaylist(cleaned);
                setPlaylist$1([...cleaned]);
                const frontendSettings = getFrontendSettingsCache();
                saveQueueState(globalCurrentProviderId, globalPlaylist, globalCurrentIndex, frontendSettings.providerQueues, updateFrontendSettingsCache);
                return;
            }
            setPlaylist(cleaned);
            setCurrentIndex(targetIndex);
            setPlaylist$1([...cleaned]);
            setCurrentIndex$1(targetIndex);
            syncShuffleAfterPlaylistChange(targetIndex);
            const frontendSettings = getFrontendSettingsCache();
            saveQueueState(globalCurrentProviderId, globalPlaylist, globalCurrentIndex, frontendSettings.providerQueues, updateFrontendSettingsCache);
            const callback = getOnPlayNextCallback();
            await playSongInternalFn(globalPlaylist[targetIndex], targetIndex, false, callback || undefined);
            return;
        }
        const past = cleaned.slice(0, globalCurrentIndex + 1);
        const future = cleaned.slice(globalCurrentIndex + 1);
        const clampedStartIndex = Math.min(Math.max(startIndex, 0), songsToInsert.length - 1);
        const newPlaylist = [...past, ...songsToInsert, ...future];
        const newIndex = past.length + clampedStartIndex;
        setPlaylist(newPlaylist);
        setCurrentIndex(newIndex);
        setPlaylist$1([...globalPlaylist]);
        setCurrentIndex$1(newIndex);
        syncShuffleAfterPlaylistChange(newIndex);
        const frontendSettings = getFrontendSettingsCache();
        saveQueueState(globalCurrentProviderId, globalPlaylist, globalCurrentIndex, frontendSettings.providerQueues, updateFrontendSettingsCache);
        const callback = getOnPlayNextCallback();
        await playSongInternalFn(globalPlaylist[newIndex], newIndex, false, callback || undefined);
    };
}
/**
 * 创建添加到队列的函数
 */
function createAddToQueue(playSongInternalFn, setPlaylist$1, setCurrentIndex$1) {
    return async (songs) => {
        if (songs.length === 0)
            return;
        const existingMids = new Set(globalPlaylist.map((s) => s.mid));
        const songsToAdd = songs.filter((s) => !existingMids.has(s.mid));
        if (songsToAdd.length === 0)
            return;
        const prevLength = globalPlaylist.length;
        const newPlaylist = [...globalPlaylist, ...songsToAdd];
        setPlaylist(newPlaylist);
        setPlaylist$1(newPlaylist);
        if (getGlobalPlayMode() === "shuffle") {
            const newIndices = songsToAdd.map((_, idx) => prevLength + idx);
            handleShuffleAdd(newIndices);
        }
        const frontendSettings = getFrontendSettingsCache();
        saveQueueState(globalCurrentProviderId, globalPlaylist, globalCurrentIndex, frontendSettings.providerQueues, updateFrontendSettingsCache);
        if (!getGlobalCurrentSong() || globalCurrentIndex < 0) {
            setCurrentIndex(0);
            setCurrentIndex$1(0);
            syncShuffleAfterPlaylistChange(0);
            // 更新索引后再次保存
            const frontendSettings2 = getFrontendSettingsCache();
            saveQueueState(globalCurrentProviderId, globalPlaylist, globalCurrentIndex, frontendSettings2.providerQueues, updateFrontendSettingsCache);
            const callback = getOnPlayNextCallback();
            await playSongInternalFn(newPlaylist[0], 0, false, callback || undefined);
        }
    };
}
/**
 * 创建从队列移除的函数
 */
function createRemoveFromQueue(setPlaylist) {
    return (index) => {
        if (index <= globalCurrentIndex)
            return;
        if (index < 0 || index >= globalPlaylist.length)
            return;
        globalPlaylist.splice(index, 1);
        if (getGlobalPlayMode() === "shuffle") {
            handleShuffleRemove(index);
            syncShuffleAfterPlaylistChange(globalCurrentIndex);
        }
        setPlaylist([...globalPlaylist]);
        const frontendSettings = getFrontendSettingsCache();
        saveQueueState(globalCurrentProviderId, globalPlaylist, globalCurrentIndex, frontendSettings.providerQueues, updateFrontendSettingsCache);
    };
}

/**
 * 播放器基础控制模块
 * 负责处理播放/暂停、跳转、停止等基础操作
 */
/**
 * 创建切换播放/暂停的函数
 */
function createTogglePlay(isPlaying, playSongInternalFn) {
    return () => {
        const audio = getGlobalAudio();
        const resumeSong = getGlobalCurrentSong();
        // 如果没有音频源但有歌曲，需要重新加载音频
        // 检查 audio.src 是否为空或无效
        const hasValidSrc = audio.src && audio.src !== "" && audio.readyState !== HTMLMediaElement.HAVE_NOTHING;
        if (hasValidSrc) {
            if (isPlaying) {
                audio.pause();
            }
            else {
                audio.play().catch((e) => {
                    toaster.toast({ title: "播放失败", body: e.message });
                });
            }
        }
        else {
            if (resumeSong) {
                const resumeIndex = globalCurrentIndex >= 0 ? globalCurrentIndex : 0;
                playSongInternalFn(resumeSong, resumeIndex, false);
                return;
            }
            toaster.toast({
                title: "无法播放",
                body: "没有可用的音频源或当前歌曲。",
            });
        }
    };
}
/**
 * 创建跳转时间的函数
 */
function createSeek(setCurrentTime) {
    return (time) => {
        const audio = getGlobalAudio();
        if (audio.duration) {
            const clampedTime = Math.max(0, Math.min(time, audio.duration));
            audio.currentTime = clampedTime;
            setCurrentTime(clampedTime);
        }
    };
}
/**
 * 创建停止播放的函数（只停止播放，不清空队列）
 */
function createStop(setCurrentSong, setIsPlaying, setCurrentTime, setDuration, setError, setLyric) {
    return () => {
        const audio = getGlobalAudio();
        audio.pause();
        audio.src = "";
        clearSkipTimeout();
        setGlobalCurrentSong(null);
        setGlobalLyric(null);
        setOnNeedMoreSongsCallback(null);
        setCurrentSong(null);
        setIsPlaying(false);
        setCurrentTime(0);
        setDuration(0);
        setError("");
        setLyric(null);
        broadcastPlayerState();
    };
}
/**
 * 创建清空队列的函数
 */
function createClearQueue(setPlaylist$1, setCurrentIndex$1) {
    return () => {
        setPlaylist([]);
        setCurrentIndex(-1);
        setPlaylist$1([]);
        setCurrentIndex$1(-1);
        const frontendSettings = getFrontendSettingsCache();
        if (globalCurrentProviderId) {
            clearQueueState(globalCurrentProviderId, frontendSettings.providerQueues, updateFrontendSettingsCache);
        }
        broadcastPlayerState();
    };
}
/**
 * 创建重置所有状态的函数
 */
function createResetAllState(stopFn, clearQueueFn, setPlayModeState, setVolumeState, setSettingsRestored, enableSettingsSave) {
    return () => {
        enableSettingsSave(false);
        stopFn();
        clearQueueFn();
        setGlobalPlayMode("order");
        setGlobalVolume(1);
        resetAllShuffleState();
        resetSettingsCache();
        const audio = getGlobalAudio();
        audio.volume = 1;
        setPlayModeState("order");
        setVolumeState(1);
        setSettingsRestored(false);
    };
}

/**
 * 播放器方法创建模块
 * 负责创建播放器的所有操作方法
 */

/**
 * 创建所有播放器方法
 */
function createPlayerMethods(params) {
    const { playSongInternalWithState, isPlaying, setPlaylist, setCurrentIndex, setCurrentTime, setCurrentSong, setIsPlaying, setDuration, setError, setLyric, setPlayModeState, setVolumeState, setSettingsRestored, enableSettingsSave, } = params;
    const playNext = SP_REACT.useCallback(() => {
        const fn = createPlayNext(playSongInternalWithState, setPlaylist);
        return fn();
    }, [playSongInternalWithState, setPlaylist]);
    const playPrev = SP_REACT.useCallback(() => {
        const fn = createPlayPrev(playSongInternalWithState);
        return fn();
    }, [playSongInternalWithState]);
    const playAtIndex = SP_REACT.useCallback(async (index) => {
        const fn = createPlayAtIndex(playSongInternalWithState);
        await fn(index);
        setCurrentIndex(index);
        broadcastPlayerState();
    }, [playSongInternalWithState, setCurrentIndex]);
    const playSong = SP_REACT.useCallback(async (song) => {
        const fn = createPlaySong(playSongInternalWithState, setPlaylist, setCurrentIndex);
        await fn(song);
        broadcastPlayerState();
    }, [playSongInternalWithState, setPlaylist, setCurrentIndex]);
    const playPlaylist = SP_REACT.useCallback(async (songs, startIndex = 0) => {
        const fn = createPlayPlaylist(playSongInternalWithState, setPlaylist, setCurrentIndex);
        await fn(songs, startIndex);
        broadcastPlayerState();
    }, [playSongInternalWithState, setPlaylist, setCurrentIndex]);
    const addToQueue = SP_REACT.useCallback(async (songs) => {
        const fn = createAddToQueue(playSongInternalWithState, setPlaylist, setCurrentIndex);
        await fn(songs);
        broadcastPlayerState();
    }, [playSongInternalWithState, setPlaylist, setCurrentIndex]);
    const removeFromQueue = SP_REACT.useCallback((index) => {
        const fn = createRemoveFromQueue(setPlaylist);
        fn(index);
        broadcastPlayerState();
    }, [setPlaylist]);
    const togglePlay = SP_REACT.useCallback(() => {
        const fn = createTogglePlay(isPlaying, playSongInternalWithState);
        return fn();
    }, [isPlaying, playSongInternalWithState]);
    const seek = SP_REACT.useCallback((time) => {
        const fn = createSeek(setCurrentTime);
        return fn(time);
    }, [setCurrentTime]);
    const stop = SP_REACT.useCallback(() => {
        const fn = createStop(setCurrentSong, setIsPlaying, setCurrentTime, setDuration, setError, setLyric);
        return fn();
    }, [setCurrentSong, setIsPlaying, setCurrentTime, setDuration, setError, setLyric]);
    const clearQueue = SP_REACT.useCallback(() => {
        const fn = createClearQueue(setPlaylist, setCurrentIndex);
        return fn();
    }, [setPlaylist, setCurrentIndex]);
    const resetAllState = SP_REACT.useCallback(() => {
        const fn = createResetAllState(stop, clearQueue, setPlayModeState, setVolumeState, setSettingsRestored, enableSettingsSave);
        return fn();
    }, [stop, clearQueue, setPlayModeState, setVolumeState, setSettingsRestored, enableSettingsSave]);
    SP_REACT.useEffect(() => {
        setOnPlayNextCallback(playNext);
        const endedHandler = () => {
            const playMode = getGlobalPlayMode();
            const callback = getOnPlayNextCallback();
            const shouldAutoContinue = playMode === "single" ||
                playMode === "shuffle" ||
                globalPlaylist.length > 1;
            if (callback && shouldAutoContinue) {
                void callback();
            }
        };
        setGlobalEndedHandler(endedHandler);
    }, [playNext]);
    return {
        playNext,
        playPrev,
        playAtIndex,
        playSong,
        playPlaylist,
        addToQueue,
        removeFromQueue,
        togglePlay,
        seek,
        stop,
        clearQueue,
        resetAllState,
    };
}

/**
 * 播放器 Hooks 辅助模块
 * 负责处理播放器的副作用和初始化逻辑
 */

/**
 * 创建同步全局状态的函数
 */
function createSyncFromGlobals(setCurrentSong, setLyric, setPlaylist, setCurrentIndex, setPlayModeState, setVolumeState, setIsPlaying, setCurrentTime, setDuration, setCurrentProviderId) {
    return () => {
        const audio = getGlobalAudio();
        setCurrentSong(getGlobalCurrentSong());
        setLyric(getGlobalLyric());
        setPlaylist([...globalPlaylist]);
        setCurrentIndex(globalCurrentIndex);
        setPlayModeState(getGlobalPlayMode());
        setVolumeState(getGlobalVolume());
        setIsPlaying(!audio.paused);
        setCurrentTime(audio.currentTime);
        setDuration(audio.duration || getGlobalCurrentSong()?.duration || 0);
        setCurrentProviderId(globalCurrentProviderId);
    };
}
/**
 * 订阅全局状态变化的 Hook
 */
function usePlayerStateSync(syncFromGlobals) {
    SP_REACT.useEffect(() => {
        const unsubscribe = subscribePlayerState(syncFromGlobals);
        return unsubscribe;
    }, [syncFromGlobals]);
}
/**
 * 初始化播放器设置的 Hook
 */
function usePlayerInitialization(settingsRestored, setSettingsRestored, setCurrentProviderId, setPlaylist$1, setCurrentIndex$1, setCurrentSong, setPlayModeState, setVolumeState) {
    SP_REACT.useEffect(() => {
        if (settingsRestored)
            return;
        let cancelled = false;
        void (async () => {
            await ensureFrontendSettingsLoaded();
            if (cancelled)
                return;
            // 1. 获取当前 Provider
            const providerRes = await getProviderInfo();
            if (!providerRes.success || !providerRes.provider) {
                setSettingsRestored(true);
                return;
            }
            const newProviderId = providerRes.provider.id;
            setProviderId(newProviderId);
            setCurrentProviderId(newProviderId);
            // 2. 检查是否需要恢复队列
            const frontendSettings = getFrontendSettingsCache();
            if (globalPlaylist.length === 0) {
                const stored = loadQueueStateFromSettings(newProviderId, frontendSettings);
                if (stored.playlist.length > 0) {
                    setPlaylist(stored.playlist);
                    const restoredIndex = stored.currentIndex >= 0 ? stored.currentIndex : 0;
                    setCurrentIndex(restoredIndex);
                    const restoredSong = globalPlaylist[restoredIndex] || null;
                    setGlobalCurrentSong(restoredSong);
                    setPlaylist$1([...globalPlaylist]);
                    setCurrentIndex$1(restoredIndex);
                    setCurrentSong(restoredSong);
                }
            }
            // 3. 恢复通用设置
            const restoredPlayMode = loadPlayMode();
            setGlobalPlayMode(restoredPlayMode);
            setPlayModeState(restoredPlayMode);
            const restoredVolume = loadVolume();
            setGlobalVolume(restoredVolume);
            const audio = getGlobalAudio();
            audio.volume = restoredVolume;
            setVolumeState(restoredVolume);
            setSettingsRestored(true);
        })();
        return () => {
            cancelled = true;
        };
    }, [settingsRestored, setSettingsRestored, setCurrentProviderId, setPlaylist$1, setCurrentIndex$1, setCurrentSong, setPlayModeState, setVolumeState]);
}
/**
 * 自动获取歌词的 Hook
 */
function useAutoFetchLyric(settingsRestored, currentSong, lyric, setLyric) {
    SP_REACT.useEffect(() => {
        if (!settingsRestored)
            return;
        if (!currentSong)
            return;
        if (lyric)
            return;
        void fetchLyricWithCache(currentSong.mid, currentSong.name, currentSong.singer, (parsed) => {
            setGlobalLyric(parsed);
            setLyric(parsed);
            broadcastPlayerState();
        });
    }, [settingsRestored, currentSong, lyric, setLyric]);
}
/**
 * 定时更新播放时间的 Hook
 */
function usePlaybackTimeSync(setIsPlaying, setCurrentTime, setDuration) {
    SP_REACT.useEffect(() => {
        const interval = setInterval(() => {
            const audio = getGlobalAudio();
            if (!audio.paused) {
                setCurrentTime(audio.currentTime);
                setDuration(audio.duration || 0);
                setIsPlaying(true);
            }
            else {
                setIsPlaying(false);
            }
        }, 100);
        return () => clearInterval(interval);
    }, [setIsPlaying, setCurrentTime, setDuration]);
}
/**
 * 恢复指定 provider 的队列状态
 */
async function restoreQueueForProvider(providerId) {
    await ensureFrontendSettingsLoaded();
    const frontendSettings = getFrontendSettingsCache();
    const stored = loadQueueStateFromSettings(providerId, frontendSettings);
    if (stored.playlist.length > 0) {
        setPlaylist(stored.playlist);
        const restoredIndex = stored.currentIndex >= 0 ? stored.currentIndex : 0;
        setCurrentIndex(restoredIndex);
        const restoredSong = stored.playlist[restoredIndex] || null;
        setGlobalCurrentSong(restoredSong);
    }
    else {
        // 如果没有存储的队列，清空当前队列
        setPlaylist([]);
        setCurrentIndex(-1);
        setGlobalCurrentSong(null);
    }
    // 广播状态变化，通知所有订阅者（包括 usePlayer hook）
    broadcastPlayerState();
}

/**
 * 播放器状态管理 Hook
 * 使用全局 Audio 单例，确保关闭面板后音乐继续播放
 * 支持播放列表和自动播放下一首
 * 支持播放历史记录
 */

// ==================== 全局清理函数 ====================
/**
 * 全局清理函数 - 用于插件卸载时调用
 */
function cleanupPlayer() {
    // 清理音频实例和全局状态
    cleanupAudio();
    resetGlobalPlayerState();
    resetQueueState();
    resetAllShuffleState();
    clearSkipTimeout();
    setOnPlayNextCallback(null);
    setOnNeedMoreSongsCallback(null);
}
// ==================== Hook 实现 ====================
function usePlayer() {
    // 从全局状态初始化
    const [currentSong, setCurrentSong] = SP_REACT.useState(getGlobalCurrentSong());
    const [isPlaying, setIsPlaying] = SP_REACT.useState(false);
    const [currentTime, setCurrentTime] = SP_REACT.useState(0);
    const [duration, setDuration] = SP_REACT.useState(0);
    const [loading, setLoading] = SP_REACT.useState(false);
    const [error, setError] = SP_REACT.useState("");
    const [lyric, setLyric] = SP_REACT.useState(getGlobalLyric());
    const [playlist, setPlaylist] = SP_REACT.useState(globalPlaylist);
    const [currentIndex, setCurrentIndex] = SP_REACT.useState(globalCurrentIndex);
    const [playMode, setPlayModeState] = SP_REACT.useState(getGlobalPlayMode());
    const [volume, setVolumeState] = SP_REACT.useState(getGlobalVolume());
    const [settingsRestored, setSettingsRestored] = SP_REACT.useState(false);
    const [currentProviderId, setCurrentProviderId] = SP_REACT.useState(globalCurrentProviderId);
    // 监听全局状态变化
    const syncFromGlobals = SP_REACT.useCallback(createSyncFromGlobals(setCurrentSong, setLyric, setPlaylist, setCurrentIndex, setPlayModeState, setVolumeState, setIsPlaying, setCurrentTime, setDuration, setCurrentProviderId), []);
    usePlayerStateSync(syncFromGlobals);
    usePlayerInitialization(settingsRestored, setSettingsRestored, setCurrentProviderId, setPlaylist, setCurrentIndex, setCurrentSong, setPlayModeState, setVolumeState);
    useAutoFetchLyric(settingsRestored, currentSong, lyric, setLyric);
    usePlaybackTimeSync(setIsPlaying, setCurrentTime, setDuration);
    // 创建播放内部函数（带状态更新）
    const playSongInternalWithState = SP_REACT.useCallback(async (song, index = -1, autoSkipOnError = true) => {
        const callback = getOnPlayNextCallback();
        return playSongInternal(song, index, autoSkipOnError, callback || undefined, setLoading, setError, setCurrentSong, setCurrentTime, setDuration, setIsPlaying, setLyric);
    }, []);
    // 创建播放方法
    const { playNext, playPrev, playAtIndex, playSong, playPlaylist, addToQueue, removeFromQueue, togglePlay, seek, stop, clearQueue, resetAllState, } = createPlayerMethods({
        playSongInternalWithState,
        isPlaying,
        setPlaylist,
        setCurrentIndex,
        setCurrentTime,
        setCurrentSong,
        setIsPlaying,
        setDuration,
        setError,
        setLyric,
        setPlayModeState,
        setVolumeState,
        setSettingsRestored,
        enableSettingsSave,
    });
    const updatePlayMode = SP_REACT.useCallback((mode) => {
        setGlobalPlayMode(mode);
        setPlayModeState(mode);
        savePlayMode(mode);
        if (mode === "shuffle") {
            const { syncShuffleAfterPlaylistChange } = require("./playerShuffle");
            syncShuffleAfterPlaylistChange(globalCurrentIndex);
        }
        broadcastPlayerState();
    }, []);
    const cyclePlayMode = SP_REACT.useCallback(() => {
        const currentMode = getGlobalPlayMode();
        const nextMode = currentMode === "order" ? "single" : currentMode === "single" ? "shuffle" : "order";
        updatePlayMode(nextMode);
    }, [updatePlayMode]);
    const setVolume = SP_REACT.useCallback((value, options) => {
        const clamped = Math.min(1, Math.max(0, value));
        setGlobalVolume(clamped);
        setVolumeState(clamped);
        if (options?.commit) {
            saveVolume(clamped);
            broadcastPlayerState();
        }
    }, []);
    const setOnNeedMoreSongs = SP_REACT.useCallback((callback) => {
        setOnNeedMoreSongsCallback(callback);
    }, []);
    const clearCurrentQueue = SP_REACT.useCallback(() => {
        stop();
        clearQueue();
    }, [stop, clearQueue]);
    return {
        currentSong,
        isPlaying,
        currentTime,
        duration,
        loading,
        error,
        lyric,
        playlist,
        currentIndex,
        playMode,
        volume,
        playSong,
        playPlaylist,
        addToQueue,
        playAtIndex,
        togglePlay,
        seek,
        stop,
        playNext,
        playPrev,
        removeFromQueue,
        setOnNeedMoreSongs,
        cyclePlayMode,
        setPlayMode: updatePlayMode,
        setVolume,
        enableSettingsSave,
        resetAllState,
        clearCurrentQueue,
        settingsRestored,
        currentProviderId,
    };
}

/**
 * 全局数据管理器
 * 用于预加载和共享数据（猜你喜欢、每日推荐、歌单等）
 * 在插件初始化时预加载，左侧全屏页面和右侧侧边栏共享
 */
const cache = {
    guessLikeSongs: [],
    guessLoaded: false,
    guessLoading: false,
    dailySongs: [],
    dailyLoaded: false,
    dailyLoading: false,
    createdPlaylists: [],
    collectedPlaylists: [],
    playlistsLoaded: false,
    playlistsLoading: false,
};
// 正在进行的请求（避免并发重复请求）
let guessLikePromise = null;
let dailyRecommendPromise = null;
let playlistsPromise = null;
let guessLikeRawPromise = null;
const listeners = new Set();
// 通知所有监听器
const notifyListeners = () => {
    listeners.forEach(listener => listener());
};
// ==================== 图片预加载 ====================
const MAX_PRELOAD_COVERS = 80;
const PRELOAD_BATCH_SIZE = 5;
const PRELOAD_IDLE_TIMEOUT = 1000;
const preloadedCoverUrls = new Set();
/**
 * 预加载图片
 */
const preloadImage = (url) => {
    return new Promise((resolve) => {
        const img = new window.Image();
        img.onload = () => resolve();
        img.onerror = () => resolve(); // 加载失败也继续
        img.src = url;
    });
};
/**
 * 批量预加载歌曲封面
 */
const schedulePreloadImages = (covers) => {
    const pending = covers.filter((cover) => cover && !preloadedCoverUrls.has(cover));
    if (pending.length === 0)
        return;
    const capped = pending.slice(0, MAX_PRELOAD_COVERS);
    capped.forEach((cover) => preloadedCoverUrls.add(cover));
    let index = 0;
    const runBatch = () => {
        const batch = capped.slice(index, index + PRELOAD_BATCH_SIZE);
        if (batch.length === 0)
            return;
        index += PRELOAD_BATCH_SIZE;
        Promise.all(batch.map(preloadImage)).finally(() => scheduleNext());
    };
    const scheduleNext = () => {
        if (index >= capped.length)
            return;
        if (typeof window.requestIdleCallback === "function") {
            window.requestIdleCallback(runBatch, { timeout: PRELOAD_IDLE_TIMEOUT });
        }
        else {
            setTimeout(runBatch, 0);
        }
    };
    scheduleNext();
};
const preloadSongCovers = (songs) => {
    const covers = songs
        .filter(song => song.cover)
        .map(song => song.cover);
    schedulePreloadImages(covers);
};
/**
 * 批量预加载歌单封面
 */
const preloadPlaylistCovers = (playlists) => {
    const covers = playlists
        .filter(p => p.cover)
        .map(p => p.cover);
    schedulePreloadImages(covers);
};
// ==================== 数据加载函数 ====================
/**
 * 加载猜你喜欢
 */
const loadGuessLike = async (forceRefresh = false) => {
    if (cache.guessLoaded && !forceRefresh) {
        return cache.guessLikeSongs;
    }
    if (guessLikePromise) {
        return guessLikePromise;
    }
    cache.guessLoading = true;
    notifyListeners();
    guessLikePromise = (async () => {
        try {
            const result = await getGuessLike();
            if (result.success && result.songs.length > 0) {
                cache.guessLikeSongs = result.songs;
                cache.guessLoaded = true;
                // 预加载封面图片
                preloadSongCovers(result.songs);
            }
        }
        catch {
            // 忽略错误
        }
        finally {
            cache.guessLoading = false;
            notifyListeners();
            guessLikePromise = null;
        }
        return cache.guessLikeSongs;
    })();
    return guessLikePromise;
};
/**
 * 刷新猜你喜欢（换一批）
 */
const refreshGuessLike = async () => {
    return loadGuessLike(true);
};
/**
 * 获取猜你喜欢但不更新缓存
 * 用于预取，避免影响首页列表
 */
const fetchGuessLikeRaw = async () => {
    if (guessLikeRawPromise) {
        return guessLikeRawPromise;
    }
    guessLikeRawPromise = (async () => {
        try {
            const result = await getGuessLike();
            if (result.success && result.songs.length > 0) {
                return result.songs;
            }
        }
        catch {
            // 忽略错误
        }
        finally {
            guessLikeRawPromise = null;
        }
        return [];
    })();
    return guessLikeRawPromise;
};
/**
 * 加载每日推荐
 */
const loadDailyRecommend = async () => {
    if (cache.dailyLoaded) {
        return cache.dailySongs;
    }
    if (dailyRecommendPromise) {
        return dailyRecommendPromise;
    }
    cache.dailyLoading = true;
    notifyListeners();
    dailyRecommendPromise = (async () => {
        try {
            const result = await getDailyRecommend();
            if (result.success && result.songs.length > 0) {
                cache.dailySongs = result.songs;
                cache.dailyLoaded = true;
                // 预加载封面图片
                preloadSongCovers(result.songs);
            }
        }
        catch {
            // 忽略错误
        }
        finally {
            cache.dailyLoading = false;
            notifyListeners();
            dailyRecommendPromise = null;
        }
        return cache.dailySongs;
    })();
    return dailyRecommendPromise;
};
/**
 * 加载用户歌单
 */
const loadPlaylists = async () => {
    if (cache.playlistsLoaded) {
        return { created: cache.createdPlaylists, collected: cache.collectedPlaylists };
    }
    if (playlistsPromise) {
        return playlistsPromise;
    }
    cache.playlistsLoading = true;
    notifyListeners();
    playlistsPromise = (async () => {
        try {
            const result = await getUserPlaylists();
            if (result.success) {
                cache.createdPlaylists = result.created || [];
                cache.collectedPlaylists = result.collected || [];
                cache.playlistsLoaded = true;
                // 预加载歌单封面
                preloadPlaylistCovers([...cache.createdPlaylists, ...cache.collectedPlaylists]);
            }
        }
        catch {
            // 忽略错误
        }
        finally {
            cache.playlistsLoading = false;
            notifyListeners();
            playlistsPromise = null;
        }
        return { created: cache.createdPlaylists, collected: cache.collectedPlaylists };
    })();
    return playlistsPromise;
};
// ==================== 预加载 ====================
/**
 * 预加载所有数据（在插件初始化时调用）
 * 已弃用，保留为空函数以兼容
 */
const preloadData = async () => { };
// ==================== 清理 ====================
/**
 * 清除所有缓存（退出登录时调用）
 */
const clearDataCache = () => {
    cache.guessLikeSongs = [];
    cache.guessLoaded = false;
    cache.guessLoading = false;
    guessLikePromise = null;
    cache.dailySongs = [];
    cache.dailyLoaded = false;
    cache.dailyLoading = false;
    dailyRecommendPromise = null;
    cache.createdPlaylists = [];
    cache.collectedPlaylists = [];
    cache.playlistsLoaded = false;
    cache.playlistsLoading = false;
    playlistsPromise = null;
    notifyListeners();
};
/**
 * 替换当前的猜你喜欢列表并通知订阅者
 */
const replaceGuessLikeSongs = (songs) => {
    cache.guessLikeSongs = songs;
    cache.guessLoaded = true;
    cache.guessLoading = false;
    notifyListeners();
};
// ==================== Hook ====================

/**
 * 使用数据管理器的 Hook
 * 自动订阅数据变化
 */
function useDataManager() {
    const [version, setVersion] = SP_REACT.useState(0);
    SP_REACT.useEffect(() => {
        const listener = () => setVersion((v) => v + 1);
        listeners.add(listener);
        return () => {
            listeners.delete(listener);
        };
    }, []);
    return SP_REACT.useMemo(() => ({
        // 猜你喜欢
        guessLikeSongs: cache.guessLikeSongs,
        guessLoading: cache.guessLoading,
        guessLoaded: cache.guessLoaded,
        loadGuessLike,
        refreshGuessLike,
        fetchGuessLikeRaw,
        // 每日推荐
        dailySongs: cache.dailySongs,
        dailyLoading: cache.dailyLoading,
        dailyLoaded: cache.dailyLoaded,
        loadDailyRecommend,
        // 歌单
        createdPlaylists: cache.createdPlaylists,
        collectedPlaylists: cache.collectedPlaylists,
        playlistsLoading: cache.playlistsLoading,
        playlistsLoaded: cache.playlistsLoaded,
        loadPlaylists,
        // 其他
        preloadData,
        clearDataCache,
        provider: null, // 占位，需要 useProvider 获取
    }), [version]);
}

/**
 * 组件挂载状态管理 Hook
 * 用于在异步操作中检查组件是否仍然挂载，避免内存泄漏
 */

/**
 * 返回一个 ref，用于检查组件是否仍然挂载
 * 在组件挂载时自动设置为 true，卸载时设置为 false
 *
 * @returns 一个 ref 对象，通过 ref.current 访问挂载状态
 *
 * @example
 * ```tsx
 * const mountedRef = useMountedRef();
 *
 * useEffect(() => {
 *   const fetchData = async () => {
 *     const data = await api.getData();
 *     if (!mountedRef.current) return; // 组件已卸载，不更新状态
 *     setData(data);
 *   };
 *   fetchData();
 * }, []);
 * ```
 */
function useMountedRef() {
    const mountedRef = SP_REACT.useRef(true);
    SP_REACT.useEffect(() => {
        mountedRef.current = true;
        return () => {
            mountedRef.current = false;
        };
    }, []);
    return mountedRef;
}

function useSteamInput({ player, currentPage, setCurrentPage }) {
    // Refs to avoid closures in event listener
    const playerRef = SP_REACT.useRef(player);
    const currentPageRef = SP_REACT.useRef(currentPage);
    SP_REACT.useEffect(() => {
        playerRef.current = player;
        currentPageRef.current = currentPage;
    }, [player, currentPage]);
    SP_REACT.useEffect(() => {
        /* eslint-disable no-undef */
        // @ts-ignore - SteamClient is global
        if (typeof SteamClient === "undefined" ||
            !SteamClient?.Input?.RegisterForControllerInputMessages) {
            return;
        }
        // @ts-ignore
        const unregister = SteamClient.Input.RegisterForControllerInputMessages((_controllerIndex, button, pressed) => {
            // Only handle press events
            if (!pressed)
                return;
            const p = playerRef.current;
            const page = currentPageRef.current;
            // Only respond if song is loaded
            if (!p.currentSong)
                return;
            switch (button) {
                case 2: // X - Play/Pause
                    p.togglePlay();
                    break;
                case 30: // L1 - Prev
                    if (p.playlist.length > 1) {
                        p.playPrev();
                    }
                    break;
                case 31: // R1 - Next
                    if (p.playlist.length > 1) {
                        p.playNext();
                    }
                    break;
                case 3: // Y - Go to detail
                    if (page !== "player" && page !== "login") {
                        setCurrentPage("player");
                    }
                    break;
            }
        });
        /* eslint-enable no-undef */
        return () => {
            unregister?.unregister?.();
        };
    }, []); // Empty dependency array as we use refs
}

/**
 * 格式化工具函数
 */
/**
 * 格式化时长为 mm:ss 格式
 */
function formatDuration(seconds) {
    const mins = Math.floor(seconds / 60);
    const secs = Math.floor(seconds % 60);
    return `${mins}:${secs.toString().padStart(2, '0')}`;
}
/**
 * 格式化播放次数
 */
function formatPlayCount(count) {
    if (count >= 100000000) {
        return `${(count / 100000000).toFixed(1)}亿`;
    }
    if (count >= 10000) {
        return `${(count / 10000).toFixed(1)}万`;
    }
    return count.toString();
}
/**
 * 生成默认封面占位图
 */
function getDefaultCover(size = 48) {
    const svg = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 ${size} ${size}"><rect fill="#2a2a2a" width="${size}" height="${size}" rx="6"/><text x="${size / 2}" y="${size / 2 + 6}" text-anchor="middle" fill="#666" font-size="${size / 3}">♪</text></svg>`;
    return `data:image/svg+xml,${encodeURIComponent(svg)}`;
}

const failedImages = new Set();
const SafeImage = ({ src, alt, size, style, ...otherProps }) => {
    const defaultCover = getDefaultCover(size);
    // 如果已知该图片链接无效，直接使用默认封面
    const isFailed = src && failedImages.has(src);
    const finalSrc = (src && !isFailed) ? src : defaultCover;
    const handleError = (e) => {
        const target = e.target;
        // 记录失败的 URL
        if (src && src !== defaultCover) {
            failedImages.add(src);
        }
        // 避免无限循环：如果已经是默认封面，就不再替换
        if (target.src !== defaultCover) {
            target.src = defaultCover;
        }
    };
    return (SP_JSX.jsx("img", { src: finalSrc, alt: alt, style: style, onError: handleError, ...otherProps }));
};

/**
 * 样式常量
 * 统一管理常用的样式定义，便于主题切换和性能优化
 */
// ==================== 文本样式 ====================
/** 文本溢出省略样式 */
const TEXT_ELLIPSIS = {
    whiteSpace: 'nowrap',
    overflow: 'hidden',
    textOverflow: 'ellipsis',
};
/** 文本溢出省略（多行，最多2行） */
const TEXT_ELLIPSIS_2_LINES = {
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    display: '-webkit-box',
    WebkitLineClamp: 2,
    WebkitBoxOrient: 'vertical',
};
// ==================== 布局样式 ====================
/** 居中布局 */
const FLEX_CENTER = {
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center',
};
/** 居中布局（仅水平） */
const FLEX_CENTER_HORIZONTAL = {
    display: 'flex',
    justifyContent: 'center',
};
// ==================== 颜色常量 ====================
const COLORS = {
    /** 主色调（绿色） */
    primary: '#1db954',
    /** 主色调（亮绿色） */
    primaryLight: '#1ed760',
    /** 主色调（半透明背景） */
    primaryBg: 'rgba(29, 185, 84, 0.15)',
    /** 主色调（阴影） */
    primaryShadow: 'rgba(29, 185, 84, 0.4)',
    /** 主要文本颜色 */
    textPrimary: '#fff',
    /** 次要文本颜色 */
    textSecondary: '#8b929a',
    /** 浅色背景 */
    backgroundLight: 'rgba(255,255,255,0.03)',
    /** 中等背景 */
    backgroundMedium: 'rgba(255,255,255,0.05)',
    /** 较深背景 */
    backgroundDark: 'rgba(255,255,255,0.1)',
    /** 深色背景 */
    backgroundDarker: 'rgba(255,255,255,0.15)',
    /** 深色基础背景 */
    backgroundDarkBase: '#2a2a2a',
    /** 浅色边框 */
    borderLight: 'rgba(255,255,255,0.1)',
    /** 错误颜色 */
    error: '#ff6b6b',
    /** 错误背景 */
    errorBg: 'rgba(255, 107, 107, 0.1)',
    /** 透明 */
    transparent: 'transparent',
};
// ==================== 常用组合样式 ====================
/** 文本容器（带溢出处理） */
const TEXT_CONTAINER = {
    flex: 1,
    overflow: 'hidden',
    minWidth: 0,
};

const SongItemComponent = ({ song, isPlaying = false, onClick, onAddToQueue, onRemoveFromQueue, preferredFocus = false, }) => {
    const handleClick = () => onClick(song);
    const handleAdd = (e) => {
        e.stopPropagation();
        onAddToQueue?.(song);
    };
    const handleRemove = (e) => {
        e.stopPropagation();
        onRemoveFromQueue?.(song);
    };
    return (SP_JSX.jsx("div", { style: {
            background: isPlaying ? COLORS.backgroundLight : COLORS.transparent,
            border: isPlaying ? `1px solid ${COLORS.primary}` : "1px solid rgba(255,255,255,0.05)",
            borderRadius: "10px",
            marginBottom: "6px",
            boxShadow: isPlaying ? `0 2px 10px ${COLORS.primaryShadow}` : "none",
        }, children: SP_JSX.jsx(DFL.Field, { focusable: true, highlightOnFocus: true, preferredFocus: preferredFocus, onActivate: handleClick, onClick: handleClick, bottomSeparator: "none", padding: "none", label: SP_JSX.jsxs("div", { style: {
                    display: 'flex',
                    alignItems: 'center',
                    gap: '10px',
                    padding: '8px 10px',
                    minWidth: 0,
                    width: '100%',
                }, children: [SP_JSX.jsx(SafeImage, { src: song.cover, alt: song.name, size: 40, style: {
                            width: '40px',
                            height: '40px',
                            borderRadius: '6px',
                            objectFit: 'cover',
                            background: COLORS.backgroundDarkBase,
                            flexShrink: 0,
                        } }), SP_JSX.jsxs("div", { style: { ...TEXT_CONTAINER, flex: 1 }, children: [SP_JSX.jsx("div", { style: {
                                    fontSize: '13px',
                                    fontWeight: 600,
                                    color: isPlaying ? COLORS.primary : COLORS.textPrimary,
                                    maxWidth: '100%',
                                    ...TEXT_ELLIPSIS,
                                }, children: song.name }), SP_JSX.jsx("div", { style: {
                                    fontSize: '11px',
                                    color: COLORS.textSecondary,
                                    ...TEXT_ELLIPSIS,
                                    marginTop: '2px',
                                }, children: song.singer })] }), SP_JSX.jsxs("div", { style: {
                            color: COLORS.textSecondary,
                            fontSize: "11px",
                            display: "flex",
                            alignItems: "center",
                            gap: "6px",
                            marginLeft: "auto",
                            flexShrink: 0,
                            whiteSpace: "nowrap",
                            justifyContent: "flex-end",
                        }, children: [isPlaying && (SP_JSX.jsxs("span", { style: {
                                    display: "inline-flex",
                                    alignItems: "center",
                                    gap: "4px",
                                    color: COLORS.primary,
                                    background: COLORS.primaryBg,
                                    padding: "4px 8px",
                                    borderRadius: "999px",
                                    fontSize: "11px",
                                }, children: [SP_JSX.jsx(FaVolumeUp, { size: 10 }), "\u64AD\u653E\u4E2D"] })), formatDuration(song.duration), onAddToQueue && (SP_JSX.jsx("button", { onClick: handleAdd, title: "\u6DFB\u52A0\u5230\u961F\u5217", style: {
                                    border: 'none',
                                    width: '28px',
                                    height: '28px',
                                    borderRadius: '50%',
                                    background: COLORS.backgroundDark,
                                    color: COLORS.textPrimary,
                                    cursor: 'pointer',
                                    display: 'flex',
                                    alignItems: 'center',
                                    justifyContent: 'center',
                                }, children: SP_JSX.jsx(FaPlus, { size: 12 }) })), onRemoveFromQueue && (SP_JSX.jsx("button", { onClick: handleRemove, title: "\u4ECE\u961F\u5217\u79FB\u9664", style: {
                                    border: 'none',
                                    width: '28px',
                                    height: '28px',
                                    borderRadius: '50%',
                                    background: COLORS.errorBg,
                                    color: COLORS.error,
                                    cursor: 'pointer',
                                    display: 'flex',
                                    alignItems: 'center',
                                    justifyContent: 'center',
                                }, children: SP_JSX.jsx(FaTrash, { size: 12 }) }))] })] }) }) }));
};
SongItemComponent.displayName = 'SongItem';
const SongItem = SP_REACT.memo(SongItemComponent);

const STYLE_ID = "music-loading-style";
const ensureStylesInjected = () => {
    if (document.getElementById(STYLE_ID))
        return;
    const styleEl = document.createElement("style");
    styleEl.id = STYLE_ID;
    styleEl.textContent = `
    @keyframes music-loading-bar {
      0% { transform: scaleY(0.4); opacity: 0.5; }
      50% { transform: scaleY(1); opacity: 1; }
      100% { transform: scaleY(0.4); opacity: 0.5; }
    }
  `;
    document.head.appendChild(styleEl);
};
const LoadingSpinner = ({ padding = 30 }) => {
    SP_REACT.useEffect(() => {
        ensureStylesInjected();
    }, []);
    const barBaseStyle = {
        width: 6,
        height: 28,
        borderRadius: 3,
        background: "var(--gpColorGreen)",
        boxShadow: "0 0 10px rgba(46, 204, 113, 0.35)",
    };
    return (SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsx("div", { style: {
                ...FLEX_CENTER_HORIZONTAL,
                gap: 6,
                padding: typeof padding === "number" ? `${padding}px` : padding,
            }, children: [0, 1, 2, 3].map((i) => (SP_JSX.jsx("div", { style: {
                    ...barBaseStyle,
                    animation: `music-loading-bar 0.9s ease-in-out ${i * 0.12}s infinite`,
                } }, `bar-${i}`))) }) }));
};

const EmptyState = ({ message, description, padding = 20, fontSize = 14 }) => {
    return (SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs("div", { style: {
                textAlign: 'center',
                color: COLORS.textSecondary,
                padding: typeof padding === 'number' ? `${padding}px` : padding,
                fontSize: typeof fontSize === 'number' ? `${fontSize}px` : fontSize,
            }, children: [message, description && (SP_JSX.jsxs(SP_JSX.Fragment, { children: [SP_JSX.jsx("br", {}), SP_JSX.jsx("span", { style: {
                                fontSize: typeof fontSize === 'number' ? `${Number(fontSize) - 2}px` : '12px',
                                marginTop: '8px',
                                display: 'block'
                            }, children: description })] }))] }) }));
};

const SongListComponent = ({ title, songs, loading = false, currentPlayingMid, emptyText = "暂无歌曲", onSelectSong, onAddToQueue, onRemoveFromQueue, progressiveRender = false, initialRenderCount = 60, renderChunkSize = 40, renderChunkDelay = 30, }) => {
    const [visibleCount, setVisibleCount] = SP_REACT.useState(songs.length);
    const chunkTimerRef = SP_REACT.useRef(null);
    SP_REACT.useEffect(() => {
        if (!progressiveRender || songs.length <= initialRenderCount) {
            setVisibleCount(songs.length);
            return;
        }
        setVisibleCount(initialRenderCount);
        const scheduleNext = () => {
            chunkTimerRef.current = setTimeout(() => {
                setVisibleCount((prev) => {
                    const next = Math.min(prev + renderChunkSize, songs.length);
                    if (next < songs.length) {
                        scheduleNext();
                    }
                    return next;
                });
            }, renderChunkDelay);
        };
        scheduleNext();
        return () => {
            if (chunkTimerRef.current) {
                clearTimeout(chunkTimerRef.current);
                chunkTimerRef.current = null;
            }
        };
    }, [progressiveRender, songs.length, initialRenderCount, renderChunkSize, renderChunkDelay]);
    if (loading) {
        return (SP_JSX.jsx(DFL.PanelSection, { title: title || undefined, children: SP_JSX.jsx(LoadingSpinner, {}) }));
    }
    if (songs.length === 0) {
        return (SP_JSX.jsx(DFL.PanelSection, { title: title || undefined, children: SP_JSX.jsx(EmptyState, { message: emptyText }) }));
    }
    return (SP_JSX.jsxs(DFL.PanelSection, { title: title || undefined, children: [songs.slice(0, visibleCount).map((song, idx) => (SP_JSX.jsx(SongItem, { song: song, isPlaying: currentPlayingMid === song.mid, onClick: onSelectSong, onAddToQueue: onAddToQueue, onRemoveFromQueue: onRemoveFromQueue }, song.mid || idx))), visibleCount < songs.length && (SP_JSX.jsx("div", { style: { padding: "6px 0", fontSize: "12px", opacity: 0.7 }, children: "\u6B63\u5728\u52A0\u8F7D\u66F4\u591A\u6B4C\u66F2..." }))] }));
};
SongListComponent.displayName = 'SongList';
const SongList = SP_REACT.memo(SongListComponent);

/**
 * 猜你喜欢组件
 * 统一渲染逻辑，panel 和 fullscreen 使用相同的内容，只是容器不同
 */
const GuessLikeSection = ({ songs, loading, onRefresh, onSelectSong, onAddToQueue, disableRefresh = false, variant = "panel", title = "💡 猜你喜欢", }) => {
    // 统一的刷新按钮
    const refreshButton = SP_REACT.useMemo(() => (SP_JSX.jsxs(DFL.ButtonItem, { layout: "below", onClick: onRefresh, disabled: loading || disableRefresh, children: [SP_JSX.jsx(FaSyncAlt, { size: 12, style: {
                    marginRight: "8px",
                    animation: loading ? "spin 1s linear infinite" : "none",
                    opacity: disableRefresh ? 0.4 : 1,
                } }), disableRefresh ? "已是今日推荐" : loading ? "加载中..." : "换一批"] })), [onRefresh, loading, disableRefresh]);
    // 统一的内容渲染
    const content = SP_REACT.useMemo(() => {
        if (loading && songs.length === 0) {
            return SP_JSX.jsx(LoadingSpinner, {});
        }
        if (songs.length === 0) {
            return SP_JSX.jsx(EmptyState, { message: "\u6682\u65E0\u63A8\u8350\uFF0C\u8BF7\u7A0D\u540E\u518D\u8BD5" });
        }
        return songs.map((song, idx) => (SP_JSX.jsx(SongItem, { song: song, onClick: () => onSelectSong(song), onAddToQueue: onAddToQueue }, song.mid || idx)));
    }, [songs, loading, onSelectSong, onAddToQueue]);
    // Panel 版本：使用 PanelSection 容器
    if (variant === "panel") {
        return (SP_JSX.jsxs(DFL.PanelSection, { title: title, children: [SP_JSX.jsx(DFL.PanelSectionRow, { children: refreshButton }), content] }));
    }
    // Fullscreen 版本：使用自定义容器，但内容完全相同
    return (SP_JSX.jsxs("div", { style: { height: "100%", display: "flex", flexDirection: "column", padding: "0 16px" }, children: [SP_JSX.jsxs("div", { style: {
                    display: "flex",
                    justifyContent: "space-between",
                    alignItems: "center",
                    padding: "12px 0",
                    flexShrink: 0,
                }, children: [SP_JSX.jsx("div", { style: { fontSize: "15px", fontWeight: "bold", color: "#fff" }, children: "\u731C\u4F60\u559C\u6B22" }), refreshButton] }), SP_JSX.jsx(DFL.Focusable, { style: { flex: 1, overflow: "auto", display: "flex", flexDirection: "column", gap: "2px" }, children: content })] }));
};

// 全局缓存，避免频繁请求
let globalProviderInfo = null;
let globalCapabilities = [];
let globalAllProviders = [];
function useProvider() {
    const [provider, setProvider] = SP_REACT.useState(globalProviderInfo);
    const [capabilities, setCapabilities] = SP_REACT.useState(globalCapabilities);
    const [allProviders, setAllProviders] = SP_REACT.useState(globalAllProviders);
    const [loading, setLoading] = SP_REACT.useState(!globalProviderInfo);
    const [error, setError] = SP_REACT.useState("");
    const refreshProviderInfo = SP_REACT.useCallback(async () => {
        setLoading(true);
        try {
            const [infoRes, listRes] = await Promise.all([getProviderInfo(), listProviders()]);
            if (infoRes.success && infoRes.provider) {
                globalProviderInfo = infoRes.provider;
                globalCapabilities = infoRes.capabilities;
                setProvider(infoRes.provider);
                setCapabilities(infoRes.capabilities);
            }
            if (listRes.success && listRes.providers) {
                globalAllProviders = listRes.providers;
                setAllProviders(listRes.providers);
            }
            if (!infoRes.success)
                setError(infoRes.error || "获取 Provider 信息失败");
        }
        catch (e) {
            setError(String(e));
        }
        finally {
            setLoading(false);
        }
    }, []);
    // 初始加载
    SP_REACT.useEffect(() => {
        if (!globalProviderInfo || globalAllProviders.length === 0) {
            refreshProviderInfo();
        }
    }, [refreshProviderInfo]);
    const hasCapability = SP_REACT.useCallback((cap) => {
        return capabilities.includes(cap);
    }, [capabilities]);
    const hasAnyCapability = SP_REACT.useCallback((caps) => {
        return caps.some(c => capabilities.includes(c));
    }, [capabilities]);
    const hasAllCapabilities = SP_REACT.useCallback((caps) => {
        return caps.every(c => capabilities.includes(c));
    }, [capabilities]);
    const switchProvider$1 = SP_REACT.useCallback(async (providerId) => {
        setLoading(true);
        try {
            const res = await switchProvider(providerId);
            if (res.success) {
                // 切换成功后刷新信息
                await refreshProviderInfo();
                return true;
            }
            else {
                setError(res.error || "切换失败");
                return false;
            }
        }
        catch (e) {
            setError(String(e));
            return false;
        }
        finally {
            setLoading(false);
        }
    }, [refreshProviderInfo]);
    return {
        provider,
        capabilities,
        allProviders,
        loading,
        error,
        hasCapability,
        hasAnyCapability,
        hasAllCapabilities,
        switchProvider: switchProvider$1,
        refreshProviderInfo,
    };
}

/**
 * 自动加载猜你喜欢的 Hook
 * 按需加载：满足条件时自动加载数据
 *
 * @example
 * // 组件挂载时加载（用于右侧 UI）
 * useAutoLoadGuessLike();
 *
 * @example
 * // 满足条件时加载（用于全屏页面）
 * useAutoLoadGuessLike(currentPage === 'guess-like');
 */

function useAutoLoadGuessLike(enabled = true) {
    const dataManager = useDataManager();
    const { hasCapability } = useProvider();
    const isLoggedIn = useAuthStatus();
    const canRecommendPersonalized = hasCapability("recommend.personalized");
    SP_REACT.useEffect(() => {
        if (!enabled)
            return;
        // 如果数据已存在，不需要加载
        if (dataManager.guessLikeSongs.length > 0)
            return;
        // 如果正在加载，不需要重复加载
        if (dataManager.guessLoading)
            return;
        // 如果已登录且有权限，则加载数据
        if (isLoggedIn && canRecommendPersonalized) {
            void dataManager.loadGuessLike();
        }
    }, [
        enabled,
        isLoggedIn,
        canRecommendPersonalized,
        dataManager.guessLoading,
        dataManager.guessLikeSongs.length,
        dataManager.loadGuessLike,
    ]);
}

const HomePageComponent = ({ onSelectSong, onGoToPlaylists, onGoToHistory, onGoToSettings, onLogout, currentPlayingMid, onAddSongToQueue, }) => {
    const dataManager = useDataManager();
    const { hasCapability, provider } = useProvider();
    const isLoggedIn = useAuthStatus();
    const canViewPlaylists = hasCapability("playlist.user");
    const canRecommendPersonalized = hasCapability("recommend.personalized");
    const canRecommendDaily = hasCapability("recommend.daily");
    const isNetease = provider?.id === "netease";
    // 登录后自动加载每日推荐
    SP_REACT.useEffect(() => {
        if (isLoggedIn &&
            canRecommendDaily &&
            !dataManager.dailyLoaded &&
            !dataManager.dailyLoading &&
            dataManager.dailySongs.length === 0) {
            void dataManager.loadDailyRecommend();
        }
    }, [isLoggedIn, canRecommendDaily, dataManager]);
    // 按需加载猜你喜欢（组件挂载时加载）
    useAutoLoadGuessLike();
    const handleRefreshGuessLike = SP_REACT.useCallback(() => {
        dataManager.refreshGuessLike();
    }, [dataManager]);
    const handleGuessLikeSongClick = SP_REACT.useCallback((song) => {
        onSelectSong(song, dataManager.guessLikeSongs, "guess-like");
    }, [dataManager.guessLikeSongs, onSelectSong]);
    const handleDailySongClick = SP_REACT.useCallback((song) => {
        onSelectSong(song, dataManager.dailySongs);
    }, [dataManager.dailySongs, onSelectSong]);
    return (SP_JSX.jsxs(SP_JSX.Fragment, { children: [SP_JSX.jsxs(DFL.PanelSection, { children: [canViewPlaylists && onGoToPlaylists && (SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs(DFL.ButtonItem, { layout: "below", onClick: onGoToPlaylists, children: [SP_JSX.jsx(FaListUl, { style: { marginRight: "8px" } }), "\u6211\u7684\u6B4C\u5355"] }) })), onGoToHistory && (SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs(DFL.ButtonItem, { layout: "below", onClick: onGoToHistory, children: [SP_JSX.jsx(FaHistory, { style: { marginRight: "8px" } }), "\u64AD\u653E\u961F\u5217"] }) })), onGoToSettings && (SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs(DFL.ButtonItem, { layout: "below", onClick: onGoToSettings, children: [SP_JSX.jsx(FaCog, { style: { marginRight: "8px" } }), "\u8BBE\u7F6E"] }) }))] }), canRecommendPersonalized && (SP_JSX.jsx(GuessLikeSection, { songs: dataManager.guessLikeSongs, loading: dataManager.guessLoading, onRefresh: handleRefreshGuessLike, onSelectSong: handleGuessLikeSongClick, onAddToQueue: onAddSongToQueue, disableRefresh: isNetease, variant: "panel" })), canRecommendDaily && (SP_JSX.jsx(SongList, { title: "\uD83D\uDCC5 \u6BCF\u65E5\u63A8\u8350", songs: dataManager.dailySongs, loading: dataManager.dailyLoading, currentPlayingMid: currentPlayingMid, emptyText: isLoggedIn ? "暂无每日推荐" : "登录后查看每日推荐", onSelectSong: handleDailySongClick, onAddToQueue: onAddSongToQueue })), SP_JSX.jsx(DFL.PanelSection, { children: SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs(DFL.ButtonItem, { layout: "below", onClick: onLogout, children: [SP_JSX.jsx(FaSignOutAlt, { style: { marginRight: "8px" } }), "\u9000\u51FA\u767B\u5F55"] }) }) })] }));
};
HomePageComponent.displayName = "HomePage";
const HomePage = SP_REACT.memo(HomePageComponent);

// 路由路径
const ROUTE_PATH = "/decky-music";
// 获取 React 树
// eslint-disable-next-line no-undef
const getReactTree = () => DFL.getReactRoot(document.getElementById('root'));
// 辅助函数：检查是否为菜单项元素
const isMenuItemElement = (e) => Boolean(e?.props?.label && e?.props?.onFocus && e?.props?.route && e?.type?.toString);
// 辅助函数：检查菜单项是否已存在
const isMenuItemAlreadyAdded = (menuItems) => menuItems.some((item) => item?.props?.route === ROUTE_PATH || item?.key === 'decky-music');
const MenuItemWrapper = ({ MenuItemComponent, label, useIconAsProp, ...props }) => {
    const iconProps = useIconAsProp
        ? { icon: SP_JSX.jsx(FaMusic, {}) }
        : { children: SP_JSX.jsx(FaMusic, {}) };
    return (SP_JSX.jsx(MenuItemComponent, { ...props, ...iconProps, label: label }));
};
// 全局状态
let isPatched = false;
let unpatchFn = null;
// Patch 主菜单
const doPatchMenu = () => {
    try {
        const menuNode = DFL.findInReactTree(getReactTree(), (node) => node?.memoizedProps?.navID === 'MainNavMenuContainer');
        if (!menuNode || !menuNode.return?.type) {
            return () => { };
        }
        const orig = menuNode.return.type;
        let patchedInnerMenu;
        const menuWrapper = (props) => {
            const ret = orig(props);
            if (!ret?.props?.children?.props?.children?.[0]?.type) {
                return ret;
            }
            if (patchedInnerMenu) {
                ret.props.children.props.children[0].type = patchedInnerMenu;
            }
            else {
                DFL.afterPatch(ret.props.children.props.children[0], 'type', (_, innerRet) => {
                    const menuItems = DFL.findInReactTree(innerRet, (node) => Array.isArray(node) && node.some(isMenuItemElement));
                    if (!menuItems) {
                        return innerRet;
                    }
                    // 检查是否已经添加过
                    if (isMenuItemAlreadyAdded(menuItems)) {
                        return innerRet;
                    }
                    // 找到一个现有菜单项作为参考
                    const menuItem = menuItems.find(isMenuItemElement);
                    if (!menuItem) {
                        return innerRet;
                    }
                    // 创建新菜单项
                    const newItem = (SP_JSX.jsx(MenuItemWrapper, { route: ROUTE_PATH, label: "\u97F3\u4E50", onFocus: menuItem.props.onFocus, useIconAsProp: !!menuItem.props.icon, MenuItemComponent: menuItem.type }, "decky-music"));
                    // 获取有效菜单项索引
                    const itemIndexes = menuItems
                        .map((item, index) => (item?.$$typeof && item.type !== 'div' ? index : -1))
                        .filter((idx) => idx >= 0);
                    if (itemIndexes.length === 0) {
                        return innerRet;
                    }
                    // 插入位置：如果菜单项超过4个，插入到第4个位置后，否则插入到最后
                    const insertIndex = itemIndexes.length > 4
                        ? itemIndexes[3] + 1
                        : itemIndexes[itemIndexes.length - 1] + 1;
                    menuItems.splice(insertIndex, 0, newItem);
                    return innerRet;
                });
                patchedInnerMenu = ret.props.children.props.children[0].type;
            }
            return ret;
        };
        // 替换原始组件
        const restoreOriginal = () => {
            menuNode.return.type = orig;
            if (menuNode.return.alternate) {
                menuNode.return.alternate.type = orig;
            }
        };
        menuNode.return.type = menuWrapper;
        if (menuNode.return.alternate) {
            menuNode.return.alternate.type = menuWrapper;
        }
        return restoreOriginal;
    }
    catch {
        return () => { };
    }
};
/**
 * 菜单管理器 - 用于动态控制菜单的显示/隐藏
 */
const menuManager = {
    /**
     * 启用菜单（登录后调用）
     */
    enable: () => {
        if (isPatched)
            return;
        unpatchFn = doPatchMenu();
        isPatched = true;
    },
    /**
     * 禁用菜单（退出登录后调用）
     */
    disable: () => {
        if (!isPatched || !unpatchFn)
            return;
        unpatchFn();
        unpatchFn = null;
        isPatched = false;
    },
    /**
     * 清理（插件卸载时调用）
     */
    cleanup: () => {
        if (unpatchFn) {
            unpatchFn();
            unpatchFn = null;
        }
        isPatched = false;
    },
    /**
     * 检查是否已启用
     */
    isEnabled: () => isPatched
};

function useAppLogic() {
    const [currentPage, setCurrentPage] = SP_REACT.useState("loading");
    const [selectedPlaylist, setSelectedPlaylist] = SP_REACT.useState(null);
    const mountedRef = useMountedRef();
    const player = usePlayer();
    const { playPlaylist, playSong, setOnNeedMoreSongs, addToQueue, enableSettingsSave, resetAllState } = player;
    // Handle controller input
    useSteamInput({
        player,
        currentPage: currentPage === "loading" ? "login" : currentPage,
        setCurrentPage: (page) => setCurrentPage(page),
    });
    const checkLoginStatus = SP_REACT.useCallback(async () => {
        try {
            const result = await getProviderSelection();
            if (!mountedRef.current)
                return;
            // 如果 mainProvider 有值，则认为已登录
            const isLoggedIn = Boolean(result.success && result.mainProvider);
            setCurrentPage(isLoggedIn ? "home" : "login");
            setAuthLoggedIn(isLoggedIn);
            if (isLoggedIn) {
                menuManager.enable();
            }
        }
        catch {
            if (!mountedRef.current)
                return;
            setCurrentPage("login");
            setAuthLoggedIn(false);
        }
    }, [mountedRef]);
    SP_REACT.useEffect(() => {
        checkLoginStatus();
    }, [checkLoginStatus]);
    const handleLoginSuccess = SP_REACT.useCallback(() => {
        enableSettingsSave(true);
        setAuthLoggedIn(true);
        setCurrentPage("home");
        menuManager.enable();
    }, [enableSettingsSave]);
    const handleLogout = SP_REACT.useCallback(async () => {
        enableSettingsSave(false);
        await logout();
        player.clearCurrentQueue(); // 登出时清空队列
        clearDataCache();
        menuManager.disable();
        setCurrentPage("login");
        setAuthLoggedIn(false);
    }, [enableSettingsSave, player]);
    const fetchMoreGuessLikeSongs = SP_REACT.useCallback(async () => {
        const songs = await fetchGuessLikeRaw();
        if (songs.length > 0) {
            replaceGuessLikeSongs(songs);
        }
        return songs;
    }, []);
    const handleSelectSong = SP_REACT.useCallback(async (song, playlist, source) => {
        if (playlist && playlist.length > 0) {
            const index = playlist.findIndex((s) => s.mid === song.mid);
            playPlaylist(playlist, index >= 0 ? index : 0).catch(() => { });
            if (source === "guess-like") {
                setOnNeedMoreSongs(fetchMoreGuessLikeSongs);
            }
            else {
                setOnNeedMoreSongs(null);
            }
        }
        else {
            playSong(song).catch(() => { });
            setOnNeedMoreSongs(null);
        }
    }, [fetchMoreGuessLikeSongs, playPlaylist, playSong, setOnNeedMoreSongs]);
    const handleClearAllData = SP_REACT.useCallback(async () => {
        const res = await clearAllData();
        if (!res.success) {
            throw new Error(res.error || "清除失败");
        }
        enableSettingsSave(false);
        resetAllState();
        clearDataCache();
        menuManager.disable();
        setSelectedPlaylist(null);
        setCurrentPage("login");
        setAuthLoggedIn(false);
        return true;
    }, [enableSettingsSave, resetAllState]);
    const handleSelectPlaylist = SP_REACT.useCallback((playlist) => {
        setSelectedPlaylist(playlist);
        setCurrentPage("playlist-detail");
    }, []);
    const handleAddSongToQueue = SP_REACT.useCallback(async (song) => {
        await addToQueue([song]);
        toaster.toast({
            title: "已添加到播放队列",
            body: song.name,
        });
    }, [addToQueue]);
    const handleAddPlaylistToQueue = SP_REACT.useCallback(async (songs) => {
        if (!songs || songs.length === 0)
            return;
        await addToQueue(songs);
        toaster.toast({
            title: "已添加到播放队列",
            body: `加入 ${songs.length} 首歌曲`,
        });
    }, [addToQueue]);
    // Navigation handlers
    const nav = SP_REACT.useMemo(() => ({
        onLoginSuccess: handleLoginSuccess,
        onLogout: handleLogout,
        onGoToPlaylists: () => setCurrentPage("playlists"),
        onGoToHistory: () => setCurrentPage("history"),
        onGoToSettings: () => setCurrentPage("settings"),
        onGoToProviderSettings: () => setCurrentPage("provider-settings"),
        onBackToHome: () => setCurrentPage("home"),
        onBackToPlaylists: () => setCurrentPage("playlists"),
        onGoToLogin: () => setCurrentPage("login"),
        onGoToPlayer: () => {
            // Only allow navigation if song is playing/loaded
            if (player.currentSong) {
                setCurrentPage("player");
            }
        },
        onClearAllData: handleClearAllData,
    }), [handleLoginSuccess, handleLogout, handleClearAllData, player.currentSong]);
    // Data handlers
    const data = SP_REACT.useMemo(() => ({
        onSelectSong: handleSelectSong,
        onSelectPlaylist: handleSelectPlaylist,
        onAddSongToQueue: handleAddSongToQueue,
        onAddPlaylistToQueue: handleAddPlaylistToQueue,
    }), [handleSelectSong, handleSelectPlaylist, handleAddSongToQueue, handleAddPlaylistToQueue]);
    return {
        state: {
            currentPage,
            selectedPlaylist,
        },
        player,
        nav,
        data,
    };
}

const LoginPage = ({ onLoginSuccess }) => {
    const [qrData, setQrData] = SP_REACT.useState("");
    const [status, setStatus] = SP_REACT.useState("idle");
    const [loginType, setLoginType] = SP_REACT.useState("qq");
    const checkIntervalRef = SP_REACT.useRef(null);
    const qrContainerRef = SP_REACT.useRef(null);
    const mountedRef = useMountedRef();
    const { provider, allProviders, switchProvider, loading: providerLoading } = useProvider();
    const [switchingProvider, setSwitchingProvider] = SP_REACT.useState(false);
    const hasNetease = allProviders.some((p) => p.id === "netease");
    const hasQQ = allProviders.some((p) => p.id === "qqmusic");
    const resetQrState = () => {
        if (checkIntervalRef.current) {
            clearInterval(checkIntervalRef.current);
            checkIntervalRef.current = null;
        }
        setQrData("");
        setStatus("idle");
    };
    SP_REACT.useEffect(() => {
        if (!qrData)
            return;
        window.requestAnimationFrame(() => {
            qrContainerRef.current?.scrollIntoView({ behavior: "smooth", block: "center" });
        });
    }, [qrData, status]);
    const fetchQrCode = async (type, targetProviderId) => {
        if (targetProviderId && targetProviderId !== provider?.id) {
            setSwitchingProvider(true);
            resetQrState();
            const switched = await switchProvider(targetProviderId);
            if (!mountedRef.current)
                return;
            setSwitchingProvider(false);
            if (!switched) {
                toaster.toast({ title: "切换音源失败", body: "请稍后重试" });
                return;
            }
        }
        setLoginType(type);
        setStatus("loading");
        const result = await getQrCode(type);
        if (!mountedRef.current)
            return;
        if (result.success && result.qr_data) {
            setQrData(result.qr_data);
            setStatus("waiting");
            startCheckingStatus();
        }
        else {
            setStatus("error");
            toaster.toast({
                title: "获取二维码失败",
                body: result.error || "未知错误",
            });
        }
    };
    const startCheckingStatus = () => {
        if (checkIntervalRef.current) {
            clearInterval(checkIntervalRef.current);
        }
        checkIntervalRef.current = setInterval(async () => {
            const result = await checkQrStatus();
            if (!mountedRef.current)
                return;
            if (result.success) {
                switch (result.status) {
                    case "success":
                        clearInterval(checkIntervalRef.current);
                        setStatus("success");
                        toaster.toast({
                            title: "登录成功",
                            body: "欢迎回来！",
                        });
                        setTimeout(onLoginSuccess, 800);
                        break;
                    case "scanned":
                        setStatus("scanned");
                        break;
                    case "timeout":
                        clearInterval(checkIntervalRef.current);
                        setStatus("timeout");
                        break;
                    case "refused":
                        clearInterval(checkIntervalRef.current);
                        setStatus("refused");
                        break;
                }
            }
        }, 2000);
    };
    SP_REACT.useEffect(() => {
        return () => {
            if (checkIntervalRef.current) {
                clearInterval(checkIntervalRef.current);
            }
        };
    }, []);
    const getStatusText = () => {
        switch (status) {
            case "loading":
                return "正在获取二维码...";
            case "waiting":
                return "请使用手机扫描二维码";
            case "scanned":
                return "已扫描，请在手机上确认登录";
            case "success":
                return "✓ 登录成功！";
            case "timeout":
                return "二维码已过期，请刷新";
            case "refused":
                return "登录已取消";
            case "error":
                return "获取二维码失败";
            default:
                return "选择登录方式开始";
        }
    };
    const getStatusColor = () => {
        switch (status) {
            case "success":
                return COLORS.primary;
            case "scanned":
                return "#ffc107";
            case "timeout":
            case "refused":
            case "error":
                return COLORS.error;
            default:
                return "#b8bcbf";
        }
    };
    const loginTypeLabel = loginType === "qq" ? "QQ" : loginType === "wx" ? "微信" : "网易云";
    return (SP_JSX.jsxs(DFL.PanelSection, { title: `🎵 ${provider?.name || "音乐"}登录`, children: [SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsx("div", { style: {
                        textAlign: "center",
                        padding: "10px",
                        color: getStatusColor(),
                        fontSize: "14px",
                        fontWeight: status === "success" ? 600 : 400,
                    }, children: getStatusText() }) }), SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs("div", { style: {
                        display: "flex",
                        flexDirection: "column",
                        width: "100%",
                        gap: 10,
                    }, children: [SP_JSX.jsxs("div", { style: { display: "flex", gap: 10, flexWrap: "wrap" }, children: [SP_JSX.jsxs(DFL.ButtonItem, { layout: "below", disabled: switchingProvider || providerLoading || !hasQQ, onClick: () => fetchQrCode("qq", "qqmusic"), children: [SP_JSX.jsx(FaQrcode, { style: { marginRight: "8px" } }), "QQ \u626B\u7801\u767B\u5F55"] }), SP_JSX.jsxs(DFL.ButtonItem, { layout: "below", disabled: switchingProvider || providerLoading || !hasQQ, onClick: () => fetchQrCode("wx", "qqmusic"), children: [SP_JSX.jsx(FaQrcode, { style: { marginRight: "8px" } }), "\u5FAE\u4FE1\u626B\u7801\u767B\u5F55"] }), SP_JSX.jsxs(DFL.ButtonItem, { layout: "below", disabled: switchingProvider || providerLoading || !hasNetease, onClick: () => fetchQrCode("netease", "netease"), children: [SP_JSX.jsx(FaQrcode, { style: { marginRight: "8px" } }), "\u7F51\u6613\u4E91\u626B\u7801\u767B\u5F55"] })] }), !hasNetease && (SP_JSX.jsx("div", { style: { fontSize: 12, color: COLORS.textSecondary }, children: "\u672A\u68C0\u6D4B\u5230\u7F51\u6613\u4E91\u97F3\u6E90\uFF0C\u8BF7\u68C0\u67E5\u540E\u7AEF\u4F9D\u8D56\u6216\u8BBE\u7F6E\u3002" })), !hasQQ && (SP_JSX.jsx("div", { style: { fontSize: 12, color: COLORS.textSecondary }, children: "\u672A\u68C0\u6D4B\u5230 QQ \u97F3\u6E90\uFF0C\u8BF7\u68C0\u67E5\u540E\u7AEF\u4F9D\u8D56\u6216\u8BBE\u7F6E\u3002" }))] }) }), qrData && status !== "success" && (SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsx("div", { ref: qrContainerRef, style: {
                        display: "flex",
                        justifyContent: "center",
                        padding: "15px",
                        background: COLORS.textPrimary,
                        borderRadius: "12px",
                        margin: "0 auto",
                        width: "fit-content",
                        boxShadow: "0 4px 12px rgba(0,0,0,0.3)",
                    }, children: SP_JSX.jsx("img", { src: qrData, alt: "\u767B\u5F55\u4E8C\u7EF4\u7801", style: {
                            width: "180px",
                            height: "180px",
                            imageRendering: "pixelated",
                        } }) }) })), status === "loading" && SP_JSX.jsx(LoadingSpinner, { padding: 20 }), (status === "timeout" || status === "refused" || status === "error") && (SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsx(DFL.ButtonItem, { layout: "below", onClick: () => fetchQrCode(loginType), children: "\uD83D\uDD04 \u5237\u65B0\u4E8C\u7EF4\u7801" }) })), status !== "idle" && status !== "success" && (SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs("div", { style: {
                        textAlign: "center",
                        fontSize: "12px",
                        color: COLORS.textSecondary,
                        marginTop: "10px",
                    }, children: ["\u5F53\u524D\u767B\u5F55\u65B9\u5F0F\uFF1A", loginTypeLabel] }) }))] }));
};

const BackButton = ({ onClick, label = "返回" }) => {
    return (SP_JSX.jsx(DFL.PanelSection, { children: SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsx("div", { style: { marginBottom: "14px" }, children: SP_JSX.jsxs(DFL.ButtonItem, { layout: "below", onClick: onClick, children: [SP_JSX.jsx(FaArrowLeft, { style: { marginRight: "8px" } }), label] }) }) }) }));
};

const FocusableList = ({ children, style, gap = '6px', column = true, wrap = false, }) => {
    const defaultStyle = {
        display: 'flex',
        flexDirection: column ? 'column' : 'row',
        gap: typeof gap === 'number' ? `${gap}px` : gap,
        ...(wrap && { flexWrap: 'wrap' }),
    };
    return (SP_JSX.jsx(DFL.Focusable, { style: { ...defaultStyle, ...style }, children: children }));
};

/**
 * 搜索历史管理 Hook
 * 封装搜索历史的存储和管理逻辑
 */

const SEARCH_HISTORY_KEY = "decky_music_search_history";
const MAX_HISTORY = 10;
/**
 * 加载搜索历史
 */
function loadSearchHistory() {
    try {
        // eslint-disable-next-line no-undef
        const data = localStorage.getItem(SEARCH_HISTORY_KEY);
        return data ? JSON.parse(data) : [];
    }
    catch {
        return [];
    }
}
/**
 * 保存搜索历史
 */
function saveSearchHistory(history) {
    try {
        // eslint-disable-next-line no-undef
        localStorage.setItem(SEARCH_HISTORY_KEY, JSON.stringify(history.slice(0, MAX_HISTORY)));
    }
    catch {
        // ignore
    }
}
/**
 * 搜索历史管理 Hook
 *
 * @returns 搜索历史状态和管理函数
 *
 * @example
 * ```tsx
 * const { searchHistory, addToHistory, clearHistory } = useSearchHistory();
 *
 * const handleSearch = (keyword: string) => {
 *   addToHistory(keyword);
 *   // ... 执行搜索
 * };
 * ```
 */
function useSearchHistory() {
    const [searchHistory, setSearchHistory] = SP_REACT.useState(loadSearchHistory);
    /**
     * 添加搜索关键词到历史记录
     */
    const addToHistory = SP_REACT.useCallback((keyword) => {
        if (!keyword || !keyword.trim())
            return;
        const trimmedKeyword = keyword.trim();
        setSearchHistory(prev => {
            const newHistory = [trimmedKeyword, ...prev.filter(h => h !== trimmedKeyword)].slice(0, MAX_HISTORY);
            saveSearchHistory(newHistory);
            return newHistory;
        });
    }, []);
    /**
     * 清空搜索历史
     */
    const clearHistory = SP_REACT.useCallback(() => {
        setSearchHistory(() => {
            saveSearchHistory([]);
            return [];
        });
    }, []);
    return {
        searchHistory,
        addToHistory,
        clearHistory,
    };
}

/**
 * 防抖 Hook
 * 用于延迟执行函数，避免频繁调用
 */

/**
 * 防抖 Hook
 *
 * @param value 需要防抖的值
 * @param delay 延迟时间（毫秒），默认 300ms
 * @returns 防抖后的值
 *
 * @example
 * ```tsx
 * const [keyword, setKeyword] = useState("");
 * const debouncedKeyword = useDebounce(keyword, 300);
 *
 * useEffect(() => {
 *   if (debouncedKeyword) {
 *     // 执行搜索
 *     fetchSuggestions(debouncedKeyword);
 *   }
 * }, [debouncedKeyword]);
 * ```
 */
function useDebounce(value, delay = 300) {
    const [debouncedValue, setDebouncedValue] = SP_REACT.useState(value);
    SP_REACT.useEffect(() => {
        // 设置定时器
        const handler = setTimeout(() => {
            setDebouncedValue(value);
        }, delay);
        // 清理函数：如果 value 或 delay 变化，清除之前的定时器
        return () => {
            clearTimeout(handler);
        };
    }, [value, delay]);
    return debouncedValue;
}

const SearchPageComponent = ({ onSelectSong, onBack, currentPlayingMid, onAddSongToQueue }) => {
    const [keyword, setKeyword] = SP_REACT.useState("");
    const [songs, setSongs] = SP_REACT.useState([]);
    const [loading, setLoading] = SP_REACT.useState(false);
    const [hotkeys, setHotkeys] = SP_REACT.useState([]);
    const [suggestions, setSuggestions] = SP_REACT.useState([]);
    const [hasSearched, setHasSearched] = SP_REACT.useState(false);
    const [showSuggestions, setShowSuggestions] = SP_REACT.useState(false);
    const mountedRef = useMountedRef();
    const { searchHistory, addToHistory, clearHistory } = useSearchHistory();
    const searchRequestId = SP_REACT.useRef(0);
    const suggestionRequestId = SP_REACT.useRef(0);
    // 防抖处理搜索关键词
    const debouncedKeyword = useDebounce(keyword, 300);
    // 防抖获取搜索建议
    const fetchSuggestions = SP_REACT.useCallback(async (kw) => {
        if (!kw.trim()) {
            setSuggestions([]);
            setShowSuggestions(false);
            return;
        }
        const requestId = ++suggestionRequestId.current;
        const result = await getSearchSuggest(kw);
        if (!mountedRef.current || requestId !== suggestionRequestId.current)
            return;
        if (result.success && result.suggestions.length > 0) {
            setSuggestions(result.suggestions);
            setShowSuggestions(true);
        }
        else {
            setSuggestions([]);
            setShowSuggestions(false);
        }
    }, [mountedRef]);
    const loadHotSearch = SP_REACT.useCallback(async () => {
        const result = await getHotSearch();
        if (!mountedRef.current)
            return;
        if (result.success) {
            setHotkeys(result.hotkeys.map((h) => h.keyword));
        }
    }, [mountedRef]);
    SP_REACT.useEffect(() => {
        loadHotSearch();
    }, [loadHotSearch]);
    // 监听防抖后的关键词，自动获取搜索建议
    SP_REACT.useEffect(() => {
        if (debouncedKeyword.trim()) {
            fetchSuggestions(debouncedKeyword);
        }
        else {
            setSuggestions([]);
            setShowSuggestions(false);
        }
    }, [debouncedKeyword, fetchSuggestions]);
    // 处理输入变化
    const handleInputChange = SP_REACT.useCallback((value) => {
        setKeyword(value);
    }, []);
    const handleSearch = SP_REACT.useCallback(async (searchKeyword) => {
        const kw = searchKeyword || keyword.trim();
        if (!kw)
            return;
        setLoading(true);
        setHasSearched(true);
        setShowSuggestions(false);
        // 保存到搜索历史
        addToHistory(kw);
        const requestId = ++searchRequestId.current;
        const result = await searchSongs(kw, 1, 30);
        if (!mountedRef.current || requestId !== searchRequestId.current)
            return;
        setLoading(false);
        if (result.success) {
            setSongs(result.songs);
            if (result.songs.length === 0) {
                toaster.toast({
                    title: "搜索结果",
                    body: `未找到 "${kw}" 相关歌曲`,
                });
            }
        }
        else {
            toaster.toast({
                title: "搜索失败",
                body: result.error || "未知错误",
            });
        }
    }, [keyword, addToHistory, mountedRef]);
    const handleSuggestionClick = SP_REACT.useCallback((suggestion) => {
        const searchTerm = suggestion.singer
            ? `${suggestion.keyword} ${suggestion.singer}`
            : suggestion.keyword;
        setKeyword(searchTerm);
        handleSearch(searchTerm);
    }, [handleSearch]);
    const handleHotkeyClick = SP_REACT.useCallback((key) => {
        setKeyword(key);
        handleSearch(key);
    }, [handleSearch]);
    const handleHistoryClick = SP_REACT.useCallback((key) => {
        setKeyword(key);
        handleSearch(key);
    }, [handleSearch]);
    const handleHistoryItemClick = SP_REACT.useCallback((key) => {
        handleHistoryClick(key);
    }, [handleHistoryClick]);
    const handleSuggestionItemClick = SP_REACT.useCallback((suggestion) => {
        handleSuggestionClick(suggestion);
    }, [handleSuggestionClick]);
    const handleHotkeyItemClick = SP_REACT.useCallback((key) => {
        handleHotkeyClick(key);
    }, [handleHotkeyClick]);
    const handleSearchButtonClick = SP_REACT.useCallback(() => {
        handleSearch();
    }, [handleSearch]);
    const handleSearchResultSelect = SP_REACT.useCallback((song) => {
        // 搜索结果中选择歌曲时，只播放选中的歌曲，不将整个搜索结果列表加入队列
        onSelectSong(song, undefined, "search");
    }, [onSelectSong]);
    return (SP_JSX.jsxs(SP_JSX.Fragment, { children: [SP_JSX.jsx(BackButton, { onClick: onBack, label: "\u8FD4\u56DE\u9996\u9875" }), SP_JSX.jsxs(DFL.PanelSection, { title: "\uD83D\uDD0D \u641C\u7D22\u97F3\u4E50", children: [SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsx("div", { style: {
                                fontSize: "12px",
                                color: COLORS.textSecondary,
                                marginBottom: "8px",
                                padding: "0 4px",
                            }, children: "\uD83D\uDCA1 \u63D0\u793A\uFF1A\u652F\u6301\u62FC\u97F3\u641C\u7D22\uFF0C\u5982\u8F93\u5165 \"zhoujielun\" \u641C\u7D22\u5468\u6770\u4F26" }) }), SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsx(DFL.TextField, { label: "\u641C\u7D22\u6B4C\u66F2\u3001\u6B4C\u624B\uFF08\u652F\u6301\u62FC\u97F3\uFF09", value: keyword, onChange: (e) => handleInputChange(e.target.value), onKeyDown: (e) => e.key === "Enter" && handleSearch(), onFocus: () => keyword.trim() && suggestions.length > 0 && setShowSuggestions(true) }) }), showSuggestions && suggestions.length > 0 && (SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsx(DFL.Focusable, { style: {
                                display: "flex",
                                flexDirection: "column",
                                gap: "4px",
                                background: "rgba(0,0,0,0.3)",
                                borderRadius: "8px",
                                padding: "8px",
                                marginTop: "-8px",
                            }, children: suggestions.map((s, idx) => (SP_JSX.jsxs(DFL.Focusable, { onActivate: () => handleSuggestionItemClick(s), onClick: () => handleSuggestionItemClick(s), style: {
                                    padding: "10px 12px",
                                    cursor: "pointer",
                                    borderRadius: "6px",
                                    background: COLORS.backgroundMedium,
                                    fontSize: "13px",
                                }, children: [SP_JSX.jsx("span", { style: { color: COLORS.textPrimary }, children: s.keyword }), s.singer && (SP_JSX.jsxs("span", { style: { color: COLORS.textSecondary, marginLeft: "8px" }, children: ["- ", s.singer] })), SP_JSX.jsx("span", { style: {
                                            color: "#666",
                                            fontSize: "11px",
                                            marginLeft: "8px",
                                        }, children: s.type === "song" ? "歌曲" : s.type === "singer" ? "歌手" : "专辑" })] }, idx))) }) })), SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs(DFL.ButtonItem, { layout: "below", onClick: handleSearchButtonClick, disabled: loading || !keyword.trim(), children: [SP_JSX.jsx(FaSearch, { style: { marginRight: "8px" } }), loading ? "搜索中..." : "搜索"] }) })] }), searchHistory.length > 0 && !hasSearched && (SP_JSX.jsxs(DFL.PanelSection, { title: "\uD83D\uDD50 \u641C\u7D22\u5386\u53F2", children: [SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs(DFL.ButtonItem, { layout: "below", onClick: clearHistory, children: [SP_JSX.jsx(FaTimes, { style: { marginRight: "6px", opacity: 0.7 } }), SP_JSX.jsx("span", { style: { opacity: 0.8 }, children: "\u6E05\u7A7A\u5386\u53F2" })] }) }), SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsx(FocusableList, { gap: "8px", column: false, wrap: true, children: searchHistory.map((key, idx) => (SP_JSX.jsx(DFL.Focusable, { onActivate: () => handleHistoryItemClick(key), onClick: () => handleHistoryItemClick(key), style: {
                                    background: COLORS.backgroundDark,
                                    padding: "8px 14px",
                                    borderRadius: "16px",
                                    fontSize: "13px",
                                    cursor: "pointer",
                                    color: "#dcdedf",
                                }, children: key }, idx))) }) })] })), hotkeys.length > 0 && !hasSearched && (SP_JSX.jsx(DFL.PanelSection, { title: "\uD83D\uDD25 \u70ED\u95E8\u641C\u7D22", children: SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsx(FocusableList, { gap: "8px", column: false, wrap: true, children: hotkeys.map((key, idx) => (SP_JSX.jsxs(DFL.Focusable, { onActivate: () => handleHotkeyItemClick(key), onClick: () => handleHotkeyItemClick(key), style: {
                                background: idx < 3
                                    ? "linear-gradient(135deg, rgba(255,100,100,0.2), rgba(255,150,100,0.2))"
                                    : COLORS.backgroundDark,
                                padding: "8px 14px",
                                borderRadius: "16px",
                                fontSize: "13px",
                                cursor: "pointer",
                                color: idx < 3 ? "#ffaa80" : "#dcdedf",
                                border: idx < 3 ? "1px solid rgba(255,150,100,0.3)" : "none",
                            }, children: [idx < 3 && SP_JSX.jsx("span", { style: { marginRight: "4px" }, children: idx + 1 }), key] }, idx))) }) }) })), hasSearched && (SP_JSX.jsx(SongList, { title: `搜索结果${songs.length > 0 ? ` (${songs.length})` : ""}`, songs: songs, loading: loading, currentPlayingMid: currentPlayingMid, emptyText: "\u672A\u627E\u5230\u76F8\u5173\u6B4C\u66F2\uFF0C\u8BD5\u8BD5\u62FC\u97F3\u641C\u7D22\uFF1F", onSelectSong: handleSearchResultSelect, onAddToQueue: onAddSongToQueue }))] }));
};
SearchPageComponent.displayName = 'SearchPage';
const SearchPage = SP_REACT.memo(SearchPageComponent);

const PlayerPage$1 = ({ song, isPlaying, currentTime, duration, loading, error, hasPlaylist = false, playMode, onTogglePlay, onSeek, onNext, onPrev, onTogglePlayMode, onBack, volume, onVolumeChange, }) => {
    const actualDuration = duration > 0 ? duration : song.duration;
    const progressBarRef = SP_REACT.useRef(null);
    const [dragTime, setDragTime] = SP_REACT.useState(null);
    const [isDragging, setIsDragging] = SP_REACT.useState(false);
    const activePointerRef = SP_REACT.useRef(null);
    const pendingDragTimeRef = SP_REACT.useRef(null);
    const rafRef = SP_REACT.useRef(null);
    const volumeBarRef = SP_REACT.useRef(null);
    const [volumeDraft, setVolumeDraft] = SP_REACT.useState(null);
    const [isVolumeDragging, setIsVolumeDragging] = SP_REACT.useState(false);
    const volumePointerRef = SP_REACT.useRef(null);
    const pendingVolumeRef = SP_REACT.useRef(null);
    const volumeRafRef = SP_REACT.useRef(null);
    const getTimeFromClientX = SP_REACT.useCallback((clientX) => {
        if (!actualDuration || !progressBarRef.current)
            return null;
        const rect = progressBarRef.current.getBoundingClientRect();
        const ratio = (clientX - rect.left) / rect.width;
        const clamped = Math.min(1, Math.max(0, ratio));
        return clamped * actualDuration;
    }, [actualDuration]);
    const updateDrag = SP_REACT.useCallback((clientX) => {
        const nextTime = getTimeFromClientX(clientX);
        if (nextTime === null)
            return;
        pendingDragTimeRef.current = nextTime;
        if (rafRef.current === null) {
            rafRef.current = window.requestAnimationFrame(() => {
                rafRef.current = null;
                if (pendingDragTimeRef.current !== null) {
                    setDragTime(pendingDragTimeRef.current);
                }
            });
        }
    }, [getTimeFromClientX]);
    const endDrag = SP_REACT.useCallback((clientX) => {
        if (clientX !== undefined) {
            const finalTime = getTimeFromClientX(clientX);
            if (finalTime !== null) {
                onSeek(finalTime);
            }
        }
        setIsDragging(false);
        setDragTime(null);
        activePointerRef.current = null;
        pendingDragTimeRef.current = null;
        if (rafRef.current !== null) {
            window.cancelAnimationFrame(rafRef.current);
            rafRef.current = null;
        }
    }, [getTimeFromClientX, onSeek]);
    const handlePointerDown = SP_REACT.useCallback((event) => {
        if (!actualDuration)
            return;
        if (event.pointerType === "mouse" && event.button !== 0)
            return;
        if (!progressBarRef.current)
            return;
        activePointerRef.current = event.pointerId;
        progressBarRef.current.setPointerCapture(event.pointerId);
        setIsDragging(true);
        updateDrag(event.clientX);
    }, [actualDuration, updateDrag]);
    const handlePointerMove = SP_REACT.useCallback((event) => {
        if (!isDragging || event.pointerId !== activePointerRef.current)
            return;
        updateDrag(event.clientX);
    }, [isDragging, updateDrag]);
    const handlePointerUp = SP_REACT.useCallback((event) => {
        if (event.pointerId !== activePointerRef.current)
            return;
        if (progressBarRef.current?.hasPointerCapture(event.pointerId)) {
            progressBarRef.current.releasePointerCapture(event.pointerId);
        }
        endDrag(event.clientX);
    }, [endDrag]);
    SP_REACT.useEffect(() => {
        return () => {
            if (rafRef.current !== null) {
                window.cancelAnimationFrame(rafRef.current);
                rafRef.current = null;
            }
            if (volumeRafRef.current !== null) {
                window.cancelAnimationFrame(volumeRafRef.current);
                volumeRafRef.current = null;
            }
        };
    }, []);
    const displayTime = dragTime ?? currentTime;
    const progress = actualDuration > 0 ? Math.min(100, Math.max(0, (displayTime / actualDuration) * 100)) : 0;
    const displayVolume = volumeDraft ?? volume;
    const volumePercent = Math.round(displayVolume * 100);
    const modeConfig = SP_REACT.useMemo(() => {
        switch (playMode) {
            case "shuffle":
                return { icon: SP_JSX.jsx(FaRandom, { size: 18 }), label: "随机播放" };
            case "single":
                return { icon: SP_JSX.jsx(FaRedo, { size: 18 }), label: "单曲循环" };
            default:
                return { icon: SP_JSX.jsx(FaListOl, { size: 18 }), label: "顺序播放" };
        }
    }, [playMode]);
    const getVolumeFromClientX = SP_REACT.useCallback((clientX) => {
        if (!volumeBarRef.current)
            return null;
        const rect = volumeBarRef.current.getBoundingClientRect();
        const ratio = (clientX - rect.left) / rect.width;
        return Math.min(1, Math.max(0, ratio));
    }, []);
    const updateVolumeDrag = SP_REACT.useCallback((clientX, immediate) => {
        const next = getVolumeFromClientX(clientX);
        if (next === null)
            return;
        pendingVolumeRef.current = next;
        if (immediate) {
            setVolumeDraft(next);
            onVolumeChange(next);
            return;
        }
        if (volumeRafRef.current === null) {
            volumeRafRef.current = window.requestAnimationFrame(() => {
                volumeRafRef.current = null;
                if (pendingVolumeRef.current !== null) {
                    const value = pendingVolumeRef.current;
                    setVolumeDraft(value);
                    onVolumeChange(value);
                }
            });
        }
    }, [getVolumeFromClientX, onVolumeChange]);
    const finishVolumeDrag = SP_REACT.useCallback((clientX) => {
        let finalVolume = null;
        if (clientX !== undefined) {
            finalVolume = getVolumeFromClientX(clientX);
        }
        else if (volumeDraft !== null) {
            finalVolume = volumeDraft;
        }
        if (finalVolume !== null) {
            onVolumeChange(finalVolume, { commit: true });
        }
        setIsVolumeDragging(false);
        setVolumeDraft(null);
        volumePointerRef.current = null;
        pendingVolumeRef.current = null;
        if (volumeRafRef.current !== null) {
            window.cancelAnimationFrame(volumeRafRef.current);
            volumeRafRef.current = null;
        }
    }, [getVolumeFromClientX, onVolumeChange, volumeDraft]);
    const handleVolumePointerDown = SP_REACT.useCallback((event) => {
        if (event.pointerType === "mouse" && event.button !== 0)
            return;
        if (!volumeBarRef.current)
            return;
        volumePointerRef.current = event.pointerId;
        volumeBarRef.current.setPointerCapture(event.pointerId);
        setIsVolumeDragging(true);
        updateVolumeDrag(event.clientX, true);
    }, [updateVolumeDrag]);
    const handleVolumePointerMove = SP_REACT.useCallback((event) => {
        if (!isVolumeDragging || event.pointerId !== volumePointerRef.current)
            return;
        updateVolumeDrag(event.clientX);
    }, [isVolumeDragging, updateVolumeDrag]);
    const handleVolumePointerUp = SP_REACT.useCallback((event) => {
        if (event.pointerId !== volumePointerRef.current)
            return;
        if (volumeBarRef.current?.hasPointerCapture(event.pointerId)) {
            volumeBarRef.current.releasePointerCapture(event.pointerId);
        }
        finishVolumeDrag(event.clientX);
    }, [finishVolumeDrag]);
    const handlePrev = () => {
        if (hasPlaylist && onPrev) {
            onPrev();
        }
        else {
            onSeek(Math.max(0, currentTime - 15));
        }
    };
    const handleNext = () => {
        if (hasPlaylist && onNext) {
            onNext();
        }
        else {
            onSeek(Math.min(actualDuration, currentTime + 15));
        }
    };
    return (SP_JSX.jsxs(DFL.PanelSection, { title: "\uD83C\uDFB5 \u6B63\u5728\u64AD\u653E", children: [SP_JSX.jsx(BackButton, { onClick: onBack }), SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsx("div", { style: { textAlign: 'center', padding: '15px' }, children: SP_JSX.jsx(SafeImage, { src: song.cover, alt: song.name, size: 180, style: {
                            width: '180px',
                            height: '180px',
                            borderRadius: '12px',
                            objectFit: 'cover',
                            boxShadow: '0 8px 24px rgba(0,0,0,0.4)',
                            animation: isPlaying ? 'spin 12s linear infinite' : 'none',
                        } }) }) }), SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs("div", { style: { textAlign: 'center', padding: '5px 0' }, children: [SP_JSX.jsx("div", { style: {
                                fontSize: '18px',
                                fontWeight: 600,
                                color: COLORS.textPrimary,
                                marginBottom: '6px',
                            }, children: song.name }), SP_JSX.jsxs("div", { style: {
                                fontSize: '14px',
                                color: COLORS.textSecondary,
                            }, children: [song.singer, song.album ? ` · ${song.album}` : ''] })] }) }), error && (SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs(DFL.Focusable, { noFocusRing: !hasPlaylist, onActivate: hasPlaylist && onNext ? onNext : undefined, onClick: hasPlaylist && onNext ? onNext : undefined, style: {
                        textAlign: 'center',
                        color: COLORS.error,
                        fontSize: '13px',
                        padding: '12px',
                        background: COLORS.errorBg,
                        borderRadius: '8px',
                        cursor: hasPlaylist ? 'pointer' : 'default',
                    }, children: [SP_JSX.jsxs("div", { style: { marginBottom: '6px' }, children: ["\u26A0\uFE0F ", error] }), hasPlaylist && (SP_JSX.jsx("div", { style: { fontSize: '12px', color: COLORS.textSecondary }, children: "\u70B9\u51FB\u8DF3\u8FC7\u6216\u7B49\u5F85\u81EA\u52A8\u64AD\u653E\u4E0B\u4E00\u9996" }))] }) })), loading && SP_JSX.jsx(LoadingSpinner, { padding: 20 }), !loading && !error && (SP_JSX.jsxs(SP_JSX.Fragment, { children: [SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs("div", { style: { padding: '10px 0' }, children: [SP_JSX.jsxs("div", { style: {
                                        display: 'flex',
                                        justifyContent: 'space-between',
                                        fontSize: '12px',
                                        color: COLORS.textSecondary,
                                        marginBottom: '8px',
                                    }, children: [SP_JSX.jsx("span", { children: formatDuration(Math.floor(displayTime)) }), SP_JSX.jsx("span", { children: formatDuration(actualDuration) })] }), SP_JSX.jsx("div", { style: {
                                        height: '12px',
                                        background: COLORS.backgroundDarker,
                                        borderRadius: '6px',
                                        overflow: 'hidden',
                                        position: 'relative',
                                        cursor: actualDuration ? 'pointer' : 'default',
                                        touchAction: 'none',
                                    }, ref: progressBarRef, onPointerDown: handlePointerDown, onPointerMove: handlePointerMove, onPointerUp: handlePointerUp, onPointerCancel: handlePointerUp, children: SP_JSX.jsx("div", { style: {
                                            height: '100%',
                                            width: `${progress}%`,
                                            background: `linear-gradient(90deg, ${COLORS.primary}, ${COLORS.primaryLight})`,
                                            borderRadius: '4px',
                                            transition: isDragging ? 'none' : 'width 0.1s linear',
                                        } }) })] }) }), SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs("div", { style: { padding: '4px 0' }, children: [SP_JSX.jsxs("div", { style: {
                                        display: 'flex',
                                        justifyContent: 'space-between',
                                        fontSize: '12px',
                                        color: COLORS.textSecondary,
                                        marginBottom: '6px',
                                    }, children: [SP_JSX.jsx("span", { children: "\u97F3\u91CF" }), SP_JSX.jsxs("span", { children: [volumePercent, "%"] })] }), SP_JSX.jsx("div", { ref: volumeBarRef, onPointerDown: handleVolumePointerDown, onPointerMove: handleVolumePointerMove, onPointerUp: handleVolumePointerUp, onPointerCancel: handleVolumePointerUp, style: {
                                        height: '12px',
                                        background: COLORS.backgroundDarker,
                                        borderRadius: '6px',
                                        overflow: 'hidden',
                                        position: 'relative',
                                        cursor: 'pointer',
                                        touchAction: 'none',
                                    }, children: SP_JSX.jsx("div", { style: {
                                            height: '100%',
                                            width: `${volumePercent}%`,
                                            background: `linear-gradient(90deg, ${COLORS.primary}, ${COLORS.primaryLight})`,
                                            borderRadius: '6px',
                                            transition: isVolumeDragging ? 'none' : 'width 0.1s linear',
                                        } }) })] }) }), SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs("div", { style: {
                                ...FLEX_CENTER,
                                gap: '16px',
                                padding: '15px 0',
                            }, children: [SP_JSX.jsx("div", { onClick: onTogglePlayMode, title: modeConfig.label, style: {
                                        width: '46px',
                                        height: '46px',
                                        borderRadius: '50%',
                                        background: COLORS.backgroundDark,
                                        display: 'flex',
                                        alignItems: 'center',
                                        justifyContent: 'center',
                                        cursor: 'pointer',
                                        color: COLORS.textSecondary,
                                    }, children: modeConfig.icon }), SP_JSX.jsx("div", { onClick: handlePrev, style: {
                                        width: '52px',
                                        height: '52px',
                                        borderRadius: '50%',
                                        background: COLORS.backgroundDark,
                                        display: 'flex',
                                        alignItems: 'center',
                                        justifyContent: 'center',
                                        cursor: 'pointer',
                                    }, children: SP_JSX.jsx(FaStepBackward, { size: 20 }) }), SP_JSX.jsx("div", { onClick: onTogglePlay, style: {
                                        width: '68px',
                                        height: '68px',
                                        borderRadius: '50%',
                                        background: COLORS.primary,
                                        color: COLORS.textPrimary,
                                        display: 'flex',
                                        alignItems: 'center',
                                        justifyContent: 'center',
                                        boxShadow: `0 4px 16px ${COLORS.primaryShadow}`,
                                        cursor: 'pointer',
                                    }, children: isPlaying ? SP_JSX.jsx(FaPause, { size: 28 }) : SP_JSX.jsx(FaPlay, { size: 28, style: { marginLeft: '4px' } }) }), SP_JSX.jsx("div", { onClick: handleNext, style: {
                                        width: '52px',
                                        height: '52px',
                                        borderRadius: '50%',
                                        background: COLORS.backgroundDark,
                                        display: 'flex',
                                        alignItems: 'center',
                                        justifyContent: 'center',
                                        cursor: 'pointer',
                                    }, children: SP_JSX.jsx(FaStepForward, { size: 20 }) })] }) }), SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs("div", { style: {
                                textAlign: 'center',
                                fontSize: '12px',
                                color: COLORS.textSecondary,
                                padding: '8px 0',
                            }, children: [SP_JSX.jsx("span", { style: { marginRight: '16px' }, children: "L1 \u4E0A\u4E00\u9996" }), SP_JSX.jsx("span", { style: { marginRight: '16px' }, children: "X \u6682\u505C/\u7EE7\u7EED" }), SP_JSX.jsx("span", { children: "R1 \u4E0B\u4E00\u9996" })] }) })] }))] }));
};

const PlayerBar = ({ song, isPlaying, currentTime, duration, loading = false, onTogglePlay, onSeek, onClick, onNext, onPrev, playMode, onTogglePlayMode, }) => {
    const barRef = SP_REACT.useRef(null);
    const [dragTime, setDragTime] = SP_REACT.useState(null);
    const [isDragging, setIsDragging] = SP_REACT.useState(false);
    const draggingIdRef = SP_REACT.useRef(null);
    const pendingDragTimeRef = SP_REACT.useRef(null);
    const rafRef = SP_REACT.useRef(null);
    const getTimeFromClientX = SP_REACT.useCallback((clientX) => {
        if (!duration || !barRef.current)
            return null;
        const rect = barRef.current.getBoundingClientRect();
        const ratio = (clientX - rect.left) / rect.width;
        const clamped = Math.min(1, Math.max(0, ratio));
        return clamped * duration;
    }, [duration]);
    const handleSeek = SP_REACT.useCallback((clientX) => {
        const next = getTimeFromClientX(clientX);
        if (next === null)
            return;
        pendingDragTimeRef.current = next;
        if (rafRef.current === null) {
            rafRef.current = window.requestAnimationFrame(() => {
                rafRef.current = null;
                if (pendingDragTimeRef.current !== null) {
                    setDragTime(pendingDragTimeRef.current);
                }
            });
        }
    }, [getTimeFromClientX]);
    const commitSeek = SP_REACT.useCallback((clientX) => {
        if (clientX !== undefined) {
            const final = getTimeFromClientX(clientX);
            if (final !== null) {
                onSeek(final);
                setDragTime(final);
            }
        }
        setIsDragging(false);
        draggingIdRef.current = null;
        pendingDragTimeRef.current = null;
        if (rafRef.current !== null) {
            window.cancelAnimationFrame(rafRef.current);
            rafRef.current = null;
        }
    }, [getTimeFromClientX, onSeek]);
    const handlePointerDown = SP_REACT.useCallback((event) => {
        if (!duration)
            return;
        if (event.pointerType === "mouse" && event.button !== 0)
            return;
        draggingIdRef.current = event.pointerId;
        barRef.current?.setPointerCapture(event.pointerId);
        setIsDragging(true);
        handleSeek(event.clientX);
    }, [duration, handleSeek]);
    const handlePointerMove = SP_REACT.useCallback((event) => {
        if (!isDragging || event.pointerId !== draggingIdRef.current)
            return;
        handleSeek(event.clientX);
    }, [handleSeek, isDragging]);
    const handlePointerUp = SP_REACT.useCallback((event) => {
        if (event.pointerId !== draggingIdRef.current)
            return;
        if (barRef.current?.hasPointerCapture(event.pointerId)) {
            barRef.current.releasePointerCapture(event.pointerId);
        }
        commitSeek(event.clientX);
    }, [commitSeek]);
    const displayTime = dragTime ?? currentTime;
    const progress = SP_REACT.useMemo(() => (duration > 0 ? Math.min(100, Math.max(0, (displayTime / duration) * 100)) : 0), [displayTime, duration]);
    SP_REACT.useEffect(() => {
        return () => {
            if (rafRef.current !== null) {
                window.cancelAnimationFrame(rafRef.current);
                rafRef.current = null;
            }
        };
    }, []);
    const modeConfig = SP_REACT.useMemo(() => {
        if (!playMode)
            return null;
        switch (playMode) {
            case "shuffle":
                return { icon: SP_JSX.jsx(FaRandom, { size: 14 }), title: "随机播放" };
            case "single":
                return { icon: SP_JSX.jsx(FaRedo, { size: 14 }), title: "单曲循环" };
            default:
                return { icon: SP_JSX.jsx(FaListOl, { size: 14 }), title: "顺序播放" };
        }
    }, [playMode]);
    // 使用 ref 追踪最新值，避免 callback 依赖变化导致子组件重渲染
    const currentTimeRef = SP_REACT.useRef(currentTime);
    const durationRef = SP_REACT.useRef(duration);
    SP_REACT.useEffect(() => {
        currentTimeRef.current = currentTime;
        durationRef.current = duration;
    }, [currentTime, duration]);
    const handlePrevClick = SP_REACT.useCallback((e) => {
        e.stopPropagation();
        onPrev ? onPrev() : onSeek(Math.max(0, currentTimeRef.current - 10));
    }, [onPrev, onSeek]);
    const handlePlayPauseClick = SP_REACT.useCallback((e) => {
        e.stopPropagation();
        onTogglePlay();
    }, [onTogglePlay]);
    const handleNextClick = SP_REACT.useCallback((e) => {
        e.stopPropagation();
        onNext ? onNext() : onSeek(Math.min(durationRef.current, currentTimeRef.current + 10));
    }, [onNext, onSeek]);
    return (SP_JSX.jsxs("div", { style: {
            position: "fixed",
            bottom: 0,
            left: 0,
            right: 0,
            zIndex: 100, // 确保播放器条在其他内容之上
            background: "linear-gradient(to top, rgba(20, 20, 20, 0.98), rgba(30, 30, 30, 0.95))",
            borderTop: `1px solid ${COLORS.borderLight}`,
            padding: "8px 12px",
            backdropFilter: "blur(10px)",
        }, children: [SP_JSX.jsx("div", { ref: barRef, onPointerDown: handlePointerDown, onPointerMove: handlePointerMove, onPointerUp: handlePointerUp, onPointerCancel: handlePointerUp, style: {
                    position: "absolute",
                    top: 0,
                    left: 0,
                    right: 0,
                    height: "10px",
                    background: COLORS.backgroundDark,
                    touchAction: "none",
                    cursor: "pointer",
                }, children: SP_JSX.jsx("div", { style: {
                        height: "100%",
                        width: `${progress}%`,
                        background: COLORS.primary,
                        transition: isDragging ? "none" : "width 0.1s linear",
                    } }) }), SP_JSX.jsxs("div", { style: {
                    display: "flex",
                    alignItems: "center",
                    gap: "10px",
                    marginTop: "2px",
                }, children: [SP_JSX.jsxs("div", { onClick: onClick, style: {
                            display: "flex",
                            alignItems: "center",
                            gap: "10px",
                            flex: 1,
                            overflow: "hidden",
                            cursor: "pointer",
                            padding: "4px",
                            borderRadius: "8px",
                        }, children: [SP_JSX.jsx(SafeImage, { src: song.cover, alt: song.name, size: 44, style: {
                                    width: "44px",
                                    height: "44px",
                                    borderRadius: "6px",
                                    objectFit: "cover",
                                    background: COLORS.backgroundDarkBase,
                                } }), SP_JSX.jsxs("div", { style: TEXT_CONTAINER, children: [SP_JSX.jsx("div", { style: {
                                            fontSize: "14px",
                                            fontWeight: 500,
                                            color: COLORS.textPrimary,
                                            ...TEXT_ELLIPSIS,
                                        }, children: song.name }), SP_JSX.jsxs("div", { style: {
                                            fontSize: "12px",
                                            color: COLORS.textSecondary,
                                            ...TEXT_ELLIPSIS,
                                        }, children: [song.singer, " \u00B7 ", formatDuration(Math.floor(currentTime)), " / ", formatDuration(duration)] })] })] }), SP_JSX.jsx(PlayerControls, { isPlaying: isPlaying, loading: loading, onPrevClick: handlePrevClick, onPlayPauseClick: handlePlayPauseClick, onNextClick: handleNextClick, modeConfig: modeConfig || undefined, onModeClick: onTogglePlayMode })] })] }));
};
// 抽离控制按钮组件并 memo 化
const PlayerControls = SP_REACT.memo(({ isPlaying, loading, onPrevClick, onPlayPauseClick, onNextClick, modeConfig, onModeClick }) => {
    return (SP_JSX.jsxs("div", { style: { display: "flex", alignItems: "center", gap: "6px" }, children: [SP_JSX.jsx("div", { onClick: onModeClick, title: modeConfig?.title, style: {
                    cursor: onModeClick ? "pointer" : "default",
                    width: "30px",
                    height: "30px",
                    borderRadius: "50%",
                    background: COLORS.backgroundDark,
                    ...FLEX_CENTER,
                    flexShrink: 0,
                    opacity: modeConfig ? 1 : 0.6,
                }, children: modeConfig?.icon }), SP_JSX.jsx("div", { onClick: onPrevClick, style: {
                    cursor: "pointer",
                    width: "34px",
                    height: "34px",
                    borderRadius: "50%",
                    background: COLORS.backgroundDark,
                    ...FLEX_CENTER,
                    flexShrink: 0,
                }, children: SP_JSX.jsx(FaStepBackward, { size: 14 }) }), SP_JSX.jsx("div", { onClick: onPlayPauseClick, style: {
                    cursor: loading ? "wait" : "pointer",
                    width: "40px",
                    height: "40px",
                    borderRadius: "50%",
                    background: COLORS.primary,
                    color: COLORS.textPrimary,
                    opacity: loading ? 0.7 : 1,
                    ...FLEX_CENTER,
                    flexShrink: 0,
                }, children: isPlaying ? SP_JSX.jsx(FaPause, { size: 16 }) : SP_JSX.jsx(FaPlay, { size: 16, style: { marginLeft: "2px" } }) }), SP_JSX.jsx("div", { onClick: onNextClick, style: {
                    cursor: "pointer",
                    width: "34px",
                    height: "34px",
                    borderRadius: "50%",
                    background: COLORS.backgroundDark,
                    ...FLEX_CENTER,
                    flexShrink: 0,
                }, children: SP_JSX.jsx(FaStepForward, { size: 14 }) })] }));
});

const PlaylistItemComponent = ({ playlist, onClick }) => (SP_JSX.jsx("div", { style: {
        background: COLORS.backgroundLight,
        borderRadius: "8px",
        marginBottom: "4px",
    }, children: SP_JSX.jsx(DFL.Field, { focusable: true, highlightOnFocus: true, onActivate: onClick, onClick: onClick, bottomSeparator: "none", padding: "none", label: SP_JSX.jsxs("div", { style: {
                display: "flex",
                alignItems: "center",
                gap: "12px",
                padding: "10px 12px",
                width: "100%",
                minWidth: 0,
            }, children: [SP_JSX.jsx(SafeImage, { src: playlist.cover, alt: playlist.name, size: 48, style: {
                        width: "48px",
                        height: "48px",
                        borderRadius: "6px",
                        objectFit: "cover",
                        background: COLORS.backgroundDarkBase,
                        flexShrink: 0,
                    } }), SP_JSX.jsxs("div", { style: { ...TEXT_CONTAINER, maxWidth: "100%" }, children: [SP_JSX.jsx("div", { style: {
                                fontSize: "14px",
                                fontWeight: 500,
                                color: COLORS.textPrimary,
                                ...TEXT_ELLIPSIS,
                            }, children: playlist.name || "未命名歌单" }), SP_JSX.jsxs("div", { style: {
                                fontSize: "12px",
                                color: COLORS.textSecondary,
                                marginTop: "2px",
                            }, children: [playlist.songCount || 0, " \u9996", playlist.creator && ` · ${playlist.creator}`, playlist.playCount &&
                                    playlist.playCount > 0 &&
                                    ` · ${formatPlayCount(playlist.playCount)}次播放`] })] })] }) }) }));
PlaylistItemComponent.displayName = 'PlaylistItem';
const PlaylistItem = SP_REACT.memo(PlaylistItemComponent);
const PlaylistsPageComponent = ({ onSelectPlaylist, onBack }) => {
    const dataManager = useDataManager();
    const { hasCapability } = useProvider();
    const isLoggedIn = useAuthStatus();
    const canViewPlaylists = hasCapability("playlist.user");
    // 登录后自动加载歌单
    SP_REACT.useEffect(() => {
        if (isLoggedIn &&
            canViewPlaylists &&
            !dataManager.playlistsLoaded &&
            !dataManager.playlistsLoading &&
            dataManager.createdPlaylists.length === 0 &&
            dataManager.collectedPlaylists.length === 0) {
            void dataManager.loadPlaylists();
        }
    }, [isLoggedIn, canViewPlaylists, dataManager]);
    const handlePlaylistClick = SP_REACT.useCallback((playlist) => {
        onSelectPlaylist(playlist);
    }, [onSelectPlaylist]);
    // 为每个歌单创建稳定的点击处理函数
    const createdPlaylistHandlers = SP_REACT.useMemo(() => dataManager.createdPlaylists.reduce((acc, playlist) => {
        acc[playlist.id] = () => handlePlaylistClick(playlist);
        return acc;
    }, {}), [dataManager.createdPlaylists, handlePlaylistClick]);
    const collectedPlaylistHandlers = SP_REACT.useMemo(() => dataManager.collectedPlaylists.reduce((acc, playlist) => {
        acc[playlist.id] = () => handlePlaylistClick(playlist);
        return acc;
    }, {}), [dataManager.collectedPlaylists, handlePlaylistClick]);
    if (dataManager.playlistsLoading && dataManager.createdPlaylists.length === 0) {
        return (SP_JSX.jsx(DFL.PanelSection, { title: "\uD83D\uDCC2 \u6211\u7684\u6B4C\u5355", children: SP_JSX.jsx(LoadingSpinner, { padding: 40 }) }));
    }
    return (SP_JSX.jsxs(SP_JSX.Fragment, { children: [SP_JSX.jsx(BackButton, { onClick: onBack, label: "\u8FD4\u56DE\u9996\u9875" }), SP_JSX.jsx(DFL.PanelSection, { title: `💿 创建的歌单 (${dataManager.createdPlaylists.length})`, children: dataManager.createdPlaylists.length === 0 ? (SP_JSX.jsx(EmptyState, { message: "\u6682\u65E0\u521B\u5EFA\u7684\u6B4C\u5355" })) : (SP_JSX.jsx("div", { style: { display: "flex", flexDirection: "column" }, children: dataManager.createdPlaylists.map((playlist) => (SP_JSX.jsx(PlaylistItem, { playlist: playlist, onClick: createdPlaylistHandlers[playlist.id] || (() => handlePlaylistClick(playlist)) }, playlist.id))) })) }), SP_JSX.jsx(DFL.PanelSection, { title: `❤️ 收藏的歌单 (${dataManager.collectedPlaylists.length})`, children: dataManager.collectedPlaylists.length === 0 ? (SP_JSX.jsx(EmptyState, { message: "\u6682\u65E0\u6536\u85CF\u7684\u6B4C\u5355" })) : (SP_JSX.jsx("div", { style: { display: "flex", flexDirection: "column" }, children: dataManager.collectedPlaylists.map((playlist) => (SP_JSX.jsx(PlaylistItem, { playlist: playlist, onClick: collectedPlaylistHandlers[playlist.id] || (() => handlePlaylistClick(playlist)) }, playlist.id))) })) })] }));
};
PlaylistsPageComponent.displayName = 'PlaylistsPage';
const PlaylistsPage = SP_REACT.memo(PlaylistsPageComponent);

const PlayAllButton = ({ onClick, show = true }) => {
    if (!show)
        return null;
    return (SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs(DFL.ButtonItem, { layout: "below", onClick: onClick, children: [SP_JSX.jsx(FaPlay, { style: { marginRight: '8px' } }), "\u64AD\u653E\u5168\u90E8"] }) }));
};

const PlaylistDetailPageComponent = ({ playlist, onSelectSong, onAddPlaylistToQueue, onAddSongToQueue, onBack, currentPlayingMid, }) => {
    const [songs, setSongs] = SP_REACT.useState([]);
    const [loading, setLoading] = SP_REACT.useState(true);
    const mountedRef = useMountedRef();
    const requestIdRef = SP_REACT.useRef(0);
    const loadSongs = SP_REACT.useCallback(async () => {
        setLoading(true);
        const requestId = ++requestIdRef.current;
        const result = await getPlaylistSongs(playlist.id, playlist.dirid || 0);
        if (!mountedRef.current || requestId !== requestIdRef.current)
            return;
        if (result.success) {
            setSongs(result.songs);
        }
        setLoading(false);
    }, [mountedRef, playlist.id, playlist.dirid]);
    SP_REACT.useEffect(() => {
        loadSongs();
    }, [loadSongs]);
    const handlePlayAll = SP_REACT.useCallback(() => {
        if (songs.length > 0) {
            onSelectSong(songs[0], songs);
        }
    }, [songs, onSelectSong]);
    const handleAddToQueue = SP_REACT.useCallback(() => {
        if (!onAddPlaylistToQueue || songs.length === 0)
            return;
        onAddPlaylistToQueue(songs);
    }, [onAddPlaylistToQueue, songs]);
    const handleSongSelect = SP_REACT.useCallback((song) => {
        onSelectSong(song, songs);
    }, [songs, onSelectSong]);
    return (SP_JSX.jsxs(SP_JSX.Fragment, { children: [SP_JSX.jsx(BackButton, { onClick: onBack, label: "\u8FD4\u56DE\u6B4C\u5355\u5217\u8868" }), SP_JSX.jsxs(DFL.PanelSection, { children: [SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs("div", { style: { display: "flex", gap: "16px", padding: "10px 0" }, children: [SP_JSX.jsx(SafeImage, { src: playlist.cover, alt: playlist.name, size: 80, style: {
                                        width: "80px",
                                        height: "80px",
                                        borderRadius: "8px",
                                        objectFit: "cover",
                                        boxShadow: "0 4px 12px rgba(0,0,0,0.3)",
                                    } }), SP_JSX.jsxs("div", { style: { flex: 1, minWidth: 0 }, children: [SP_JSX.jsx("div", { style: {
                                                fontSize: "16px",
                                                fontWeight: 600,
                                                color: COLORS.textPrimary,
                                                marginBottom: "6px",
                                                ...TEXT_ELLIPSIS_2_LINES,
                                            }, children: playlist.name }), SP_JSX.jsxs("div", { style: { fontSize: "13px", color: COLORS.textSecondary }, children: [playlist.songCount, " \u9996\u6B4C\u66F2", playlist.creator && ` · ${playlist.creator}`] })] })] }) }), SP_JSX.jsx(PlayAllButton, { onClick: handlePlayAll, show: !loading && songs.length > 0 }), !loading && songs.length > 0 && onAddPlaylistToQueue && (SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs(DFL.ButtonItem, { layout: "below", onClick: handleAddToQueue, children: [SP_JSX.jsx(FaPlus, { style: { marginRight: "8px" } }), "\u6DFB\u52A0\u5230\u64AD\u653E\u961F\u5217"] }) }))] }), SP_JSX.jsx(SongList, { title: `歌曲列表${songs.length > 0 ? ` (${songs.length})` : ""}`, songs: songs, loading: loading, currentPlayingMid: currentPlayingMid, emptyText: "\u6B4C\u5355\u6682\u65E0\u6B4C\u66F2", onSelectSong: handleSongSelect, onAddToQueue: onAddSongToQueue, progressiveRender: songs.length >= 120, initialRenderCount: 80, renderChunkSize: 50, renderChunkDelay: 30 })] }));
};
PlaylistDetailPageComponent.displayName = 'PlaylistDetailPage';
const PlaylistDetailPage = SP_REACT.memo(PlaylistDetailPageComponent);

const HISTORY_COVER_PRELOAD_RADIUS = 12;
const preloadedHistoryCovers = new Set();
const HISTORY_WINDOW_RADIUS = 35;
const HISTORY_MAX_RENDER = 90;
let lastHistoryScrollTop = 0;
const HistoryPageComponent = ({ playlist, currentIndex, onSelectIndex, onBack, onRemoveFromQueue, }) => {
    const currentRef = SP_REACT.useRef(null);
    const scrollRef = SP_REACT.useRef(null);
    const [renderAll, setRenderAll] = SP_REACT.useState(false);
    const handleSelectFromTimeline = SP_REACT.useCallback((absoluteIndex) => {
        onSelectIndex(absoluteIndex);
    }, [onSelectIndex]);
    const windowedSlice = SP_REACT.useMemo(() => {
        if (renderAll || playlist.length === 0) {
            return { slice: playlist, offset: 0 };
        }
        const start = Math.max(0, currentIndex - HISTORY_WINDOW_RADIUS);
        const end = Math.min(playlist.length, start + HISTORY_MAX_RENDER);
        return { slice: playlist.slice(start, end), offset: start };
    }, [currentIndex, playlist, renderAll]);
    const visiblePlaylist = windowedSlice.slice;
    const sliceOffset = windowedSlice.offset;
    SP_REACT.useEffect(() => {
        if (currentRef.current) {
            currentRef.current.scrollIntoView({ block: "center", behavior: "auto" });
        }
    }, [currentIndex, visiblePlaylist.length]);
    SP_REACT.useEffect(() => {
        if (visiblePlaylist.length === 0)
            return;
        const start = Math.max(0, currentIndex - HISTORY_COVER_PRELOAD_RADIUS);
        const end = Math.min(playlist.length, currentIndex + HISTORY_COVER_PRELOAD_RADIUS + 1);
        const candidates = playlist.slice(start, end);
        candidates.forEach((song) => {
            if (!song.cover || preloadedHistoryCovers.has(song.cover))
                return;
            preloadedHistoryCovers.add(song.cover);
            const img = new window.Image();
            img.src = song.cover;
        });
    }, [currentIndex, playlist, visiblePlaylist.length]);
    SP_REACT.useEffect(() => {
        const el = scrollRef.current;
        if (!el)
            return;
        if (lastHistoryScrollTop > 0) {
            el.scrollTop = lastHistoryScrollTop;
        }
        return () => {
            lastHistoryScrollTop = el.scrollTop;
        };
    }, []);
    return (SP_JSX.jsxs(SP_JSX.Fragment, { children: [SP_JSX.jsx(BackButton, { onClick: onBack, label: "\u8FD4\u56DE\u9996\u9875" }), SP_JSX.jsx(DFL.PanelSection, { title: "\u64AD\u653E\u961F\u5217", children: playlist.length === 0 ? (SP_JSX.jsx(EmptyState, { message: "\u8FD8\u6CA1\u6709\u64AD\u653E\u8FC7\u6B4C\u66F2", padding: "40px 20px" })) : (SP_JSX.jsxs(DFL.Focusable, { ref: scrollRef, navEntryPreferPosition: DFL.NavEntryPositionPreferences.PREFERRED_CHILD, "flow-children": "column", style: { maxHeight: "70vh", overflow: "auto", paddingRight: "6px" }, children: [!renderAll && playlist.length > visiblePlaylist.length && (SP_JSX.jsxs("div", { style: { color: "rgba(255,255,255,0.5)", fontSize: "11px", padding: "4px 8px" }, children: ["\u5DF2\u6298\u53E0\u90E8\u5206\u961F\u5217\u4EE5\u63D0\u5347\u6027\u80FD\uFF08\u663E\u793A\u9644\u8FD1 ", visiblePlaylist.length, " \u9996\uFF09", SP_JSX.jsx("br", {}), SP_JSX.jsx("button", { onClick: () => setRenderAll(true), style: {
                                        marginTop: "6px",
                                        border: "1px solid rgba(255,255,255,0.2)",
                                        background: "transparent",
                                        color: "#fff",
                                        padding: "6px 10px",
                                        borderRadius: "6px",
                                        cursor: "pointer",
                                    }, children: "\u663E\u793A\u5168\u90E8\uFF08\u53EF\u80FD\u5361\u987F\uFF09" })] })), visiblePlaylist.map((song, idx) => {
                            const absoluteIndex = idx + sliceOffset;
                            const isPlaying = absoluteIndex === currentIndex;
                            return (SP_JSX.jsx("div", { ref: isPlaying ? currentRef : undefined, style: { padding: isPlaying ? "2px 0" : "0" }, children: SP_JSX.jsx(SongItem, { song: song, isPlaying: isPlaying, preferredFocus: isPlaying, onClick: () => handleSelectFromTimeline(absoluteIndex), onRemoveFromQueue: onRemoveFromQueue && absoluteIndex > currentIndex
                                        ? () => onRemoveFromQueue(absoluteIndex)
                                        : undefined }) }, song.mid || `${song.name}-${absoluteIndex}`));
                        })] })) })] }));
};
HistoryPageComponent.displayName = 'HistoryPage';
const HistoryPage = SP_REACT.memo(HistoryPageComponent);

const REPO_URL = "https://github.com/jinzhongjia/decky-music";
const QUALITY_OPTIONS = [
    { value: "auto", label: "自动（推荐）", desc: "优先高码率，若不可用自动降级" },
    {
        value: "high",
        label: "高音质优先",
        desc: "320kbps/192kbps 优先，可能需要会员，不可用时自动降级",
    },
    { value: "balanced", label: "均衡", desc: "192kbps / 128kbps 优先，兼顾质量与稳定性" },
    { value: "compat", label: "兼容/低延迟", desc: "128kbps 及以下优先，适合不稳定网络或节省流量" },
];
const SettingsPage = ({ onBack, onClearAllData, onGoToProviderSettings }) => {
    const mountedRef = useMountedRef();
    const { provider, loading: providerLoading } = useProvider();
    const [checking, setChecking] = SP_REACT.useState(false);
    const [downloading, setDownloading] = SP_REACT.useState(false);
    const [updateInfo, setUpdateInfo] = SP_REACT.useState(null);
    const [downloadPath, setDownloadPath] = SP_REACT.useState(null);
    const [localVersion, setLocalVersion] = SP_REACT.useState("");
    const [preferredQuality, setPreferredQualityState] = SP_REACT.useState("auto");
    const [clearing, setClearing] = SP_REACT.useState(false);
    const [focusedQuality, setFocusedQuality] = SP_REACT.useState(null);
    const handleCheckUpdate = SP_REACT.useCallback(async () => {
        setChecking(true);
        setDownloadPath(null);
        try {
            const res = await checkUpdate();
            if (!mountedRef.current)
                return;
            setUpdateInfo(res);
            if (res.currentVersion) {
                setLocalVersion(res.currentVersion);
            }
            if (!res.success) {
                toaster.toast({ title: "检查更新失败", body: res.error || "未知错误" });
            }
        }
        catch (e) {
            if (!mountedRef.current)
                return;
            toaster.toast({ title: "检查更新失败", body: e.message });
        }
        finally {
            if (mountedRef.current) {
                setChecking(false);
            }
        }
    }, [mountedRef]);
    const handleDownload = SP_REACT.useCallback(async () => {
        if (!updateInfo?.downloadUrl) {
            toaster.toast({ title: "无法下载", body: "缺少下载链接" });
            return;
        }
        setDownloading(true);
        setDownloadPath(null);
        try {
            const res = await downloadUpdate(updateInfo.downloadUrl, updateInfo.assetName);
            if (!mountedRef.current)
                return;
            if (res.success) {
                setDownloadPath(res.path || null);
                toaster.toast({ title: "下载完成", body: res.path || "已保存到 ~/Download" });
            }
            else {
                toaster.toast({ title: "下载失败", body: res.error || "请稍后重试" });
            }
        }
        catch (e) {
            if (!mountedRef.current)
                return;
            toaster.toast({ title: "下载失败", body: e.message });
        }
        finally {
            if (mountedRef.current) {
                setDownloading(false);
            }
        }
    }, [mountedRef, updateInfo]);
    const handleOpenRepo = SP_REACT.useCallback(() => {
        DFL.Navigation.CloseSideMenus?.();
        DFL.Navigation.NavigateToExternalWeb(REPO_URL);
    }, []);
    const loadLocalVersion = SP_REACT.useCallback(async () => {
        try {
            const res = await getPluginVersion();
            if (!mountedRef.current)
                return;
            if (res.success && res.version) {
                setLocalVersion(res.version);
            }
        }
        catch {
            // 忽略
        }
    }, [mountedRef]);
    const loadPreferredQuality = SP_REACT.useCallback(async () => {
        try {
            const res = await getFrontendSettings();
            if (!mountedRef.current)
                return;
            const value = res.settings?.preferredQuality;
            if (value === "auto" || value === "high" || value === "balanced" || value === "compat") {
                setPreferredQualityState(value);
            }
        }
        catch {
            // ignore
        }
    }, [mountedRef]);
    const handleQualityChange = SP_REACT.useCallback(async (value) => {
        setPreferredQualityState(value);
        setPreferredQuality(value);
        try {
            await saveFrontendSettings({ preferredQuality: value });
            toaster.toast({
                title: "音质偏好已更新",
                body: QUALITY_OPTIONS.find((o) => o.value === value)?.label,
            });
        }
        catch (e) {
            toaster.toast({ title: "保存失败", body: e.message });
        }
    }, []);
    const handleClearData = SP_REACT.useCallback(async () => {
        if (clearing)
            return;
        setClearing(true);
        try {
            const success = await (onClearAllData ? onClearAllData() : Promise.resolve(false));
            if (!mountedRef.current)
                return;
            toaster.toast({
                title: success ? "已清除数据" : "清除失败",
                body: success ? "请重新登录" : "未知错误",
            });
        }
        catch (e) {
            if (!mountedRef.current)
                return;
            toaster.toast({ title: "清除失败", body: e.message });
        }
        finally {
            if (mountedRef.current) {
                setClearing(false);
            }
        }
    }, [clearing, mountedRef, onClearAllData]);
    //   const handleProviderSwitch = useCallback(
    //     async (providerId: string) => {
    //       // 逻辑已迁移到 ProviderSettingsPage
    //     },
    //     []
    //   );
    SP_REACT.useEffect(() => {
        void loadLocalVersion();
        void loadPreferredQuality();
    }, [loadLocalVersion, loadPreferredQuality]);
    const updateStatus = SP_REACT.useMemo(() => {
        if (!updateInfo)
            return "尚未检查";
        if (!updateInfo.success)
            return "检查失败";
        if (updateInfo.hasUpdate)
            return "发现新版本";
        return "已是最新";
    }, [updateInfo]);
    const currentVersion = SP_REACT.useMemo(() => {
        if (localVersion)
            return `v${localVersion}`;
        if (updateInfo?.currentVersion)
            return `v${updateInfo.currentVersion}`;
        return "未知";
    }, [localVersion, updateInfo]);
    return (SP_JSX.jsxs(SP_JSX.Fragment, { children: [SP_JSX.jsxs(DFL.PanelSection, { title: "\u97F3\u6E90\u8BBE\u7F6E", children: [SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs("div", { style: { display: "flex", alignItems: "center", gap: 8, marginBottom: 8 }, children: [SP_JSX.jsx(FaMusic, {}), SP_JSX.jsxs("span", { children: ["\u5F53\u524D\u97F3\u6E90\uFF1A", providerLoading ? "加载中..." : provider?.name || "未知"] })] }) }), SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsx(DFL.ButtonItem, { layout: "below", onClick: onGoToProviderSettings, children: "\u5207\u6362\u97F3\u6E90 / \u8D26\u53F7\u7BA1\u7406" }) })] }), SP_JSX.jsx(DFL.PanelSection, { title: "\u97F3\u8D28\u504F\u597D", children: SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsx("div", { style: {
                            width: "100%",
                            maxWidth: 520,
                            margin: "0 auto",
                            display: "flex",
                            flexDirection: "column",
                            gap: 12,
                            boxSizing: "border-box",
                        }, children: QUALITY_OPTIONS.map((option) => {
                            const active = preferredQuality === option.value;
                            const focused = focusedQuality === option.value;
                            const borderColor = active || focused ? "#1DB954" : "rgba(255,255,255,0.16)";
                            const background = active
                                ? "rgba(29,185,84,0.16)"
                                : focused
                                    ? "rgba(255,255,255,0.07)"
                                    : "rgba(255,255,255,0.05)";
                            return (SP_JSX.jsx(DFL.Focusable, { onActivate: () => handleQualityChange(option.value), onClick: () => handleQualityChange(option.value), onFocus: () => setFocusedQuality(option.value), onBlur: () => setFocusedQuality(null), style: {
                                    width: "100%",
                                    padding: "0",
                                    border: "none",
                                    background: "transparent",
                                }, children: SP_JSX.jsxs("div", { style: {
                                        width: "100%",
                                        padding: "12px 14px",
                                        borderRadius: 14,
                                        border: `2px solid ${borderColor}`,
                                        background,
                                        color: "inherit",
                                        display: "flex",
                                        alignItems: "center",
                                        gap: 12,
                                        boxShadow: "none",
                                        boxSizing: "border-box",
                                    }, children: [SP_JSX.jsx("div", { style: {
                                                width: 12,
                                                height: 12,
                                                borderRadius: "50%",
                                                border: "2px solid #1DB954",
                                                background: active ? "#1DB954" : "transparent",
                                                flexShrink: 0,
                                            } }), SP_JSX.jsxs("div", { style: { display: "flex", flexDirection: "column", gap: 4, flex: 1 }, children: [SP_JSX.jsx("div", { style: { fontWeight: 700, fontSize: 14 }, children: option.label }), SP_JSX.jsx("div", { style: { fontSize: 12, opacity: 0.9, lineHeight: "18px" }, children: option.desc })] })] }) }, option.value));
                        }) }) }) }), SP_JSX.jsxs(DFL.PanelSection, { title: "\u7248\u672C\u4FE1\u606F", children: [SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs("div", { style: { display: "flex", flexDirection: "column", gap: 4 }, children: [SP_JSX.jsxs("div", { children: ["\u5F53\u524D\u7248\u672C\uFF1A", currentVersion] }), updateInfo?.latestVersion && SP_JSX.jsxs("div", { children: ["\u6700\u65B0\u7248\u672C\uFF1A", updateInfo.latestVersion] }), SP_JSX.jsxs("div", { children: ["\u72B6\u6001\uFF1A", checking ? "检查中..." : updateStatus] })] }) }), SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs(DFL.ButtonItem, { layout: "below", onClick: handleCheckUpdate, disabled: checking, children: [SP_JSX.jsx(FaSyncAlt, { style: {
                                        marginRight: 8,
                                        animation: checking ? "spin 1s linear infinite" : "none",
                                    } }), checking ? "检查中..." : "检查更新"] }) }), updateInfo?.hasUpdate && updateInfo.downloadUrl && (SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs(DFL.ButtonItem, { layout: "below", onClick: handleDownload, disabled: downloading, children: [SP_JSX.jsx(FaDownload, { style: {
                                        marginRight: 8,
                                        animation: downloading ? "spin 1s linear infinite" : "none",
                                    } }), downloading ? "下载中..." : `下载 ${updateInfo.assetName || "更新包"}`] }) })), downloadPath && (SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs("div", { style: { fontSize: 12, lineHeight: "18px" }, children: ["\u5DF2\u4FDD\u5B58\u5230\uFF1A", downloadPath] }) }))] }), SP_JSX.jsxs(DFL.PanelSection, { title: "\u6570\u636E\u7BA1\u7406", children: [SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs(DFL.ButtonItem, { layout: "below", onClick: handleClearData, disabled: clearing, children: [SP_JSX.jsx(FaTrash, { style: { marginRight: 8 } }), clearing ? "清除中..." : "清除所有数据"] }) }), SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsx("div", { style: { fontSize: 12, lineHeight: "18px", opacity: 0.9 }, children: "\u5C06\u6E05\u9664\u767B\u5F55\u51ED\u8BC1\u548C\u524D\u7AEF\u8BBE\u7F6E\uFF0C\u64CD\u4F5C\u4E0D\u53EF\u64A4\u9500\u3002" }) })] }), SP_JSX.jsxs(DFL.PanelSection, { title: "\u9879\u76EE\u8BF4\u660E", children: [SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs("div", { style: { display: "flex", alignItems: "flex-start", gap: 8 }, children: [SP_JSX.jsx(FaInfoCircle, { style: { marginTop: 4 } }), SP_JSX.jsx("div", { style: { lineHeight: "18px" }, children: "Decky Music \u63D2\u4EF6\uFF0C\u63D0\u4F9B\u626B\u7801\u767B\u5F55\u3001\u97F3\u4E50\u64AD\u653E\u3001\u6B4C\u8BCD\u4E0E\u6B4C\u5355\u7B49\u529F\u80FD\u3002\u611F\u8C22\u4F7F\u7528\u5E76\u6B22\u8FCE\u53CD\u9988\u3002" })] }) }), SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs(DFL.ButtonItem, { layout: "below", onClick: handleOpenRepo, children: [SP_JSX.jsx(FaExternalLinkAlt, { style: { marginRight: 8 } }), "\u9879\u76EE\u5730\u5740"] }) }), updateInfo?.releasePage && (SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs(DFL.ButtonItem, { layout: "below", onClick: () => DFL.Navigation.NavigateToExternalWeb(updateInfo.releasePage), children: [SP_JSX.jsx(FaExternalLinkAlt, { style: { marginRight: 8 } }), "\u6253\u5F00\u6700\u65B0 Release"] }) })), updateInfo?.notes && (SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsx("div", { style: {
                                whiteSpace: "pre-wrap",
                                fontSize: 12,
                                lineHeight: "18px",
                                opacity: 0.9,
                            }, children: updateInfo.notes }) }))] }), SP_JSX.jsx(BackButton, { onClick: onBack })] }));
};
SettingsPage.displayName = "SettingsPage";

/**
 * ErrorBoundary - 错误边界组件
 * 捕获子组件渲染错误，防止整个插件崩溃
 */


class ErrorBoundary extends SP_REACT.Component {
    constructor(props) {
        super(props);
        this.state = { hasError: false, error: null };
    }
    static getDerivedStateFromError(error) {
        return { hasError: true, error };
    }
    render() {
        if (!this.state.hasError)
            return this.props.children;
        return (SP_JSX.jsx(DFL.PanelSection, { title: "\u51FA\u9519\u4E86", children: SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs("div", { style: { textAlign: "center", padding: "20px 0" }, children: [SP_JSX.jsx("div", { style: { fontSize: "32px", marginBottom: "12px" }, children: "\uD83D\uDE35" }), SP_JSX.jsx("div", { style: { color: "#b0b0b0", marginBottom: "16px" }, children: "\u63D2\u4EF6\u9047\u5230\u4E86\u4E00\u4E2A\u9519\u8BEF" }), this.state.error && (SP_JSX.jsx("div", { style: {
                                fontSize: "12px",
                                color: "#808080",
                                background: "rgba(0,0,0,0.2)",
                                padding: "8px",
                                borderRadius: "4px",
                                marginBottom: "16px",
                                wordBreak: "break-word",
                                maxHeight: "80px",
                                overflow: "auto",
                            }, children: this.state.error.message }))] }) }) }));
    }
}

const ProviderSettingsPage = ({ onBack, onGoToLogin }) => {
    const mountedRef = useMountedRef();
    const { provider, allProviders, switchProvider, loading: providerLoading } = useProvider();
    const dataManager = useDataManager();
    const player = usePlayer();
    const [switchingProvider, setSwitchingProvider] = SP_REACT.useState(false);
    const [focusedProvider, setFocusedProvider] = SP_REACT.useState(null);
    const handleProviderSwitch = SP_REACT.useCallback(async (providerId) => {
        if (switchingProvider || providerId === provider?.id)
            return;
        setSwitchingProvider(true);
        try {
            // 1. 切换 Provider（队列已在修改时自动保存，无需手动保存）
            const success = await switchProvider(providerId);
            if (!mountedRef.current)
                return;
            if (success) {
                const providerName = allProviders.find((p) => p.id === providerId)?.name || providerId;
                toaster.toast({ title: "音源已切换", body: providerName });
                // 3. 停止当前播放（避免旧 Provider 的音频继续播放）
                // stop() 现在只停止播放，不清空队列
                player.stop();
                // 4. 更新全局 provider ID
                setProviderId(providerId);
                // 5. 恢复新 provider 的队列
                // 使用 getProviderInfo 确保 provider 信息已更新
                await getProviderInfo();
                await restoreQueueForProvider(providerId);
                // 6. 检查登录状态
                const selection = await getProviderSelection();
                if (!mountedRef.current)
                    return;
                const isLoggedIn = Boolean(selection.success && selection.mainProvider);
                setAuthLoggedIn(isLoggedIn);
                // 7. 刷新首页推荐数据
                dataManager.clearDataCache(); // 清空旧数据
                // 8. 如果未登录，跳转登录页
                if (!isLoggedIn) {
                    onGoToLogin();
                }
            }
            else {
                toaster.toast({ title: "切换失败", body: "请稍后重试" });
            }
        }
        catch (e) {
            if (!mountedRef.current)
                return;
            toaster.toast({ title: "切换失败", body: e.message });
        }
        finally {
            if (mountedRef.current) {
                setSwitchingProvider(false);
            }
        }
    }, [switchingProvider, provider?.id, switchProvider, mountedRef, allProviders, player, dataManager, onGoToLogin]);
    return (SP_JSX.jsxs(SP_JSX.Fragment, { children: [SP_JSX.jsxs(DFL.PanelSection, { title: "\u97F3\u6E90\u9009\u62E9", children: [SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsxs("div", { style: { display: "flex", alignItems: "center", gap: 8, marginBottom: 8 }, children: [SP_JSX.jsx(FaMusic, {}), SP_JSX.jsxs("span", { children: ["\u5F53\u524D\u97F3\u6E90\uFF1A", providerLoading ? "加载中..." : provider?.name || "未知"] })] }) }), allProviders.length > 0 && (SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsx("div", { style: {
                                width: "100%",
                                maxWidth: 520,
                                margin: "0 auto",
                                display: "flex",
                                flexDirection: "column",
                                gap: 10,
                            }, children: allProviders.map((p) => {
                                const active = provider?.id === p.id;
                                const focused = focusedProvider === p.id;
                                const borderColor = active || focused ? "#1DB954" : "rgba(255,255,255,0.16)";
                                const background = active
                                    ? "rgba(29,185,84,0.16)"
                                    : focused
                                        ? "rgba(255,255,255,0.07)"
                                        : "rgba(255,255,255,0.05)";
                                return (SP_JSX.jsx(DFL.Focusable, { onActivate: () => handleProviderSwitch(p.id), onClick: () => handleProviderSwitch(p.id), onFocus: () => setFocusedProvider(p.id), onBlur: () => setFocusedProvider(null), style: {
                                        width: "100%",
                                        padding: "0",
                                        border: "none",
                                        background: "transparent",
                                    }, children: SP_JSX.jsxs("div", { style: {
                                            width: "100%",
                                            padding: "10px 14px",
                                            borderRadius: 12,
                                            border: `2px solid ${borderColor}`,
                                            background,
                                            display: "flex",
                                            alignItems: "center",
                                            gap: 10,
                                            boxSizing: "border-box",
                                            opacity: switchingProvider ? 0.6 : 1,
                                        }, children: [SP_JSX.jsx("div", { style: {
                                                    width: 12,
                                                    height: 12,
                                                    borderRadius: "50%",
                                                    border: "2px solid #1DB954",
                                                    background: active ? "#1DB954" : "transparent",
                                                    flexShrink: 0,
                                                } }), SP_JSX.jsxs("div", { style: { display: "flex", flexDirection: "column", gap: 2 }, children: [SP_JSX.jsx("div", { style: { fontWeight: 600, fontSize: 14 }, children: p.name }), SP_JSX.jsx("div", { style: { fontSize: 12, opacity: 0.7 }, children: active ? "当前使用中" : "点击切换" })] })] }) }, p.id));
                            }) }) })), SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsx("div", { style: { fontSize: 12, lineHeight: "18px", opacity: 0.8, marginTop: 8 }, children: "\u6CE8\u610F\uFF1A\u5207\u6362\u97F3\u6E90\u540E\u9700\u8981\u91CD\u65B0\u767B\u5F55\u5BF9\u5E94\u5E73\u53F0\u7684\u8D26\u53F7\u3002\u64AD\u653E\u961F\u5217\u5C06\u81EA\u52A8\u5207\u6362\u3002" }) })] }), SP_JSX.jsx(DFL.PanelSection, { title: "\u8D26\u53F7\u7BA1\u7406", children: SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsx(DFL.ButtonItem, { layout: "below", onClick: onGoToLogin, children: "\u767B\u5F55 / \u5207\u6362\u8D26\u53F7" }) }) }), SP_JSX.jsx(BackButton, { onClick: onBack })] }));
};

const Router = ({ currentPage, player, selectedPlaylist, nav, data, }) => {
    switch (currentPage) {
        case "login":
            return SP_JSX.jsx(LoginPage, { onLoginSuccess: nav.onLoginSuccess });
        case "home":
            return (SP_JSX.jsx(HomePage, { onSelectSong: data.onSelectSong, onGoToPlaylists: nav.onGoToPlaylists, onGoToHistory: nav.onGoToHistory, onGoToSettings: nav.onGoToSettings, onLogout: nav.onLogout, currentPlayingMid: player.currentSong?.mid, onAddSongToQueue: data.onAddSongToQueue }));
        case "playlists":
            return (SP_JSX.jsx(PlaylistsPage, { onSelectPlaylist: data.onSelectPlaylist, onBack: nav.onBackToHome }));
        case "playlist-detail":
            return selectedPlaylist ? (SP_JSX.jsx(PlaylistDetailPage, { playlist: selectedPlaylist, onSelectSong: data.onSelectSong, onAddPlaylistToQueue: data.onAddPlaylistToQueue, onAddSongToQueue: data.onAddSongToQueue, onBack: nav.onBackToPlaylists, currentPlayingMid: player.currentSong?.mid })) : (SP_JSX.jsx(PlaylistsPage, { onSelectPlaylist: data.onSelectPlaylist, onBack: nav.onBackToHome }));
        case "history":
            return (SP_JSX.jsx(HistoryPage, { playlist: player.playlist, currentIndex: player.currentIndex, onSelectIndex: player.playAtIndex, onBack: nav.onBackToHome, currentPlayingMid: player.currentSong?.mid, onRemoveFromQueue: player.removeFromQueue }));
        case "player":
            return player.currentSong ? (SP_JSX.jsx(PlayerPage$1, { song: player.currentSong, isPlaying: player.isPlaying, currentTime: player.currentTime, duration: player.duration, volume: player.volume, loading: player.loading, error: player.error, hasPlaylist: player.playlist.length > 1, playMode: player.playMode, onTogglePlay: player.togglePlay, onTogglePlayMode: player.cyclePlayMode, onSeek: player.seek, onVolumeChange: player.setVolume, onNext: player.playNext, onPrev: player.playPrev, onBack: nav.onBackToHome })) : (SP_JSX.jsx(HomePage, { onSelectSong: data.onSelectSong, onGoToPlaylists: nav.onGoToPlaylists, onGoToHistory: nav.onGoToHistory, onGoToSettings: nav.onGoToSettings, onLogout: nav.onLogout, onAddSongToQueue: data.onAddSongToQueue }));
        case "settings":
            return (SP_JSX.jsx(SettingsPage, { onBack: nav.onBackToHome, onClearAllData: nav.onClearAllData, onGoToProviderSettings: nav.onGoToProviderSettings }));
        case "provider-settings":
            return (SP_JSX.jsx(ProviderSettingsPage, { onBack: nav.onGoToSettings, onGoToLogin: nav.onGoToLogin }));
        default:
            return SP_JSX.jsx(LoginPage, { onLoginSuccess: nav.onLoginSuccess });
    }
};

const NAV_ITEMS = [
    { id: "player", label: "播放", icon: FaCompactDisc },
    { id: "guess-like", label: "推荐", icon: FaHeart },
    { id: "playlists", label: "歌单", icon: FaList },
    { id: "history", label: "队列", icon: FaHistory },
    { id: "search", label: "搜索", icon: FaSearch },
];

const NavBar = SP_REACT.memo(({ currentPage, onNavigate }) => (SP_JSX.jsx(DFL.Focusable, { style: {
        height: "56px",
        flexShrink: 0,
        display: "flex",
        justifyContent: "center",
        alignItems: "center",
        gap: "4px",
        padding: "0 12px",
        background: "rgba(0,0,0,0.6)",
        borderTop: "1px solid rgba(255,255,255,0.1)",
    }, children: NAV_ITEMS.map((item) => {
        const Icon = item.icon;
        const isActive = currentPage === item.id || (item.id === "playlists" && currentPage === "playlist-detail");
        return (SP_JSX.jsxs(DFL.Focusable, { onActivate: () => onNavigate(item.id), onClick: () => onNavigate(item.id), style: {
                padding: "6px 12px",
                borderRadius: "6px",
                background: isActive ? "rgba(29, 185, 84, 0.2)" : "transparent",
                border: isActive ? "1px solid #1db954" : "1px solid transparent",
                cursor: "pointer",
                display: "flex",
                flexDirection: "column",
                alignItems: "center",
                gap: "2px",
                minWidth: "50px",
            }, children: [SP_JSX.jsx(Icon, { size: 16, color: isActive ? "#1db954" : "#8b929a" }), SP_JSX.jsx("span", { style: { fontSize: "10px", color: isActive ? "#1db954" : "#8b929a" }, children: item.label })] }, item.id));
    }) })));
NavBar.displayName = "NavBar";

const COVER_WRAPPER_STYLE = {
    width: "180px",
    height: "180px",
    borderRadius: "8px",
    overflow: "hidden",
    boxShadow: "0 4px 20px rgba(0,0,0,0.5)",
    marginBottom: "16px",
    flexShrink: 0,
};
const EMPTY_COVER_STYLE = {
    width: "100%",
    height: "100%",
    background: "linear-gradient(135deg, #1db954 0%, #191414 100%)",
    display: "flex",
    alignItems: "center",
    justifyContent: "center",
};
const PlayerCover = SP_REACT.memo(({ song }) => (SP_JSX.jsx("div", { style: COVER_WRAPPER_STYLE, children: song?.cover ? (SP_JSX.jsx(SafeImage, { src: song.cover, alt: "\u5C01\u9762", size: 180, style: { width: "100%", height: "100%", objectFit: "cover" } })) : (SP_JSX.jsx("div", { style: EMPTY_COVER_STYLE, children: SP_JSX.jsx(FaMusic, { size: 50, color: "rgba(255,255,255,0.3)" }) })) })));
PlayerCover.displayName = "PlayerCover";

const PLAYER_TITLE_STYLE = {
    fontSize: "16px",
    fontWeight: "bold",
    marginBottom: "4px",
    color: "#fff",
    overflow: "hidden",
    textOverflow: "ellipsis",
    whiteSpace: "nowrap",
};
const PLAYER_SUBTITLE_STYLE = {
    fontSize: "13px",
    color: "#8b929a",
    overflow: "hidden",
    textOverflow: "ellipsis",
    whiteSpace: "nowrap",
};
const PlayerMeta = SP_REACT.memo(({ song }) => (SP_JSX.jsxs("div", { style: { textAlign: "center", marginBottom: "12px", width: "100%" }, children: [SP_JSX.jsx("div", { style: PLAYER_TITLE_STYLE, children: song?.name || "未播放" }), SP_JSX.jsx("div", { style: PLAYER_SUBTITLE_STYLE, children: song?.singer || "选择一首歌曲" })] })));
PlayerMeta.displayName = "PlayerMeta";

const progressContainerStyle = {
    width: "100%",
    maxWidth: "240px",
    marginBottom: "12px",
    padding: "6px 0",
};
const progressBarOuterStyle = {
    width: "100%",
    height: "10px",
    background: "rgba(255,255,255,0.1)",
    borderRadius: "6px",
    overflow: "hidden",
    cursor: "pointer",
    touchAction: "none",
    position: "relative",
};
const progressTimeStyle = {
    display: "flex",
    justifyContent: "space-between",
    fontSize: "10px",
    color: "#666",
    marginTop: "4px",
};
const thumbStyle = {
    position: "absolute",
    top: "50%",
    width: "14px",
    height: "14px",
    borderRadius: "50%",
    background: "#1db954",
    transform: "translate(-50%, -50%)",
    boxShadow: "0 0 10px rgba(29, 185, 84, 0.55)",
    pointerEvents: "none",
};
const PlayerProgress = SP_REACT.memo(({ hasSong, currentTime, duration, onSeek }) => {
    const barRef = SP_REACT.useRef(null);
    const [dragTime, setDragTime] = SP_REACT.useState(null);
    const activePointerRef = SP_REACT.useRef(null);
    const pendingDragTimeRef = SP_REACT.useRef(null);
    const rafRef = SP_REACT.useRef(null);
    const getTimeFromClientX = SP_REACT.useCallback((clientX) => {
        if (!duration || !barRef.current)
            return null;
        const rect = barRef.current.getBoundingClientRect();
        const ratio = (clientX - rect.left) / rect.width;
        const clamped = Math.min(1, Math.max(0, ratio));
        return clamped * duration;
    }, [duration]);
    const updateDrag = SP_REACT.useCallback((clientX) => {
        const nextTime = getTimeFromClientX(clientX);
        if (nextTime === null)
            return;
        pendingDragTimeRef.current = nextTime;
        if (rafRef.current === null) {
            rafRef.current = window.requestAnimationFrame(() => {
                rafRef.current = null;
                if (pendingDragTimeRef.current !== null) {
                    setDragTime(pendingDragTimeRef.current);
                }
            });
        }
    }, [getTimeFromClientX]);
    const endDrag = SP_REACT.useCallback((clientX) => {
        if (clientX !== undefined) {
            const finalTime = getTimeFromClientX(clientX);
            if (finalTime !== null) {
                onSeek(finalTime);
            }
        }
        setDragTime(null);
        activePointerRef.current = null;
        pendingDragTimeRef.current = null;
        if (rafRef.current !== null) {
            window.cancelAnimationFrame(rafRef.current);
            rafRef.current = null;
        }
    }, [getTimeFromClientX, onSeek]);
    const handlePointerDown = SP_REACT.useCallback((event) => {
        if (!duration)
            return;
        if (event.pointerType === "mouse" && event.button !== 0)
            return;
        if (!barRef.current)
            return;
        activePointerRef.current = event.pointerId;
        barRef.current.setPointerCapture(event.pointerId);
        const initialTime = getTimeFromClientX(event.clientX);
        if (initialTime === null)
            return;
        setDragTime(initialTime);
        onSeek(initialTime);
    }, [duration, getTimeFromClientX, onSeek]);
    const handlePointerMove = SP_REACT.useCallback((event) => {
        if (event.pointerId !== activePointerRef.current)
            return;
        updateDrag(event.clientX);
    }, [updateDrag]);
    const handlePointerUp = SP_REACT.useCallback((event) => {
        if (event.pointerId !== activePointerRef.current)
            return;
        if (barRef.current?.hasPointerCapture(event.pointerId)) {
            barRef.current.releasePointerCapture(event.pointerId);
        }
        endDrag(event.clientX);
    }, [endDrag]);
    SP_REACT.useEffect(() => {
        return () => {
            if (rafRef.current !== null) {
                window.cancelAnimationFrame(rafRef.current);
                rafRef.current = null;
            }
        };
    }, []);
    if (!hasSong)
        return null;
    const displayTime = dragTime ?? currentTime;
    const percent = duration ? Math.min(100, Math.max(0, (displayTime / duration) * 100)) : 0;
    return (SP_JSX.jsxs("div", { style: progressContainerStyle, children: [SP_JSX.jsxs("div", { ref: barRef, style: progressBarOuterStyle, onPointerDown: handlePointerDown, onPointerMove: handlePointerMove, onPointerUp: handlePointerUp, onPointerCancel: handlePointerUp, children: [SP_JSX.jsx("div", { style: {
                            width: `${percent}%`,
                            height: "100%",
                            background: "#1db954",
                            borderRadius: "2px",
                        } }), SP_JSX.jsx("div", { style: {
                            ...thumbStyle,
                            left: `${percent}%`,
                            opacity: duration ? 1 : 0,
                        } })] }), SP_JSX.jsxs("div", { style: progressTimeStyle, children: [SP_JSX.jsx("span", { children: formatDuration(currentTime) }), SP_JSX.jsx("span", { children: formatDuration(duration) })] })] }));
});
PlayerProgress.displayName = "PlayerProgress";

const LYRIC_CONTAINER_STYLE = {
    flex: 1,
    overflow: "auto",
    padding: "20px 16px",
    scrollBehavior: "smooth",
    scrollbarWidth: "none",
};
const LYRIC_PADDING_STYLE = {
    paddingTop: "60px",
    paddingBottom: "150px",
};
const NO_LYRIC_STYLE = {
    display: "flex",
    alignItems: "center",
    justifyContent: "center",
    height: "100%",
    color: "rgba(255,255,255,0.4)",
    fontSize: "16px",
    fontWeight: 500,
};
const getWordProgress = (word, timeSec) => {
    if (timeSec >= word.start + word.duration)
        return 100;
    if (timeSec > word.start)
        return ((timeSec - word.start) / word.duration) * 100;
    return 0;
};
const isInterludeLine = (text) => {
    const trimmed = text.trim();
    return /^[-/\\*~\\s]+$/.test(trimmed) || trimmed.length === 0;
};
const QrcLine = SP_REACT.memo(({ line, index, activeIndex, currentTimeSec, activeRef, onSeek }) => {
    const isActive = index === activeIndex;
    const isPast = index < activeIndex;
    const isInterlude = isInterludeLine(line.text);
    const handleActivate = SP_REACT.useCallback(() => onSeek(line.time), [line.time, onSeek]);
    const handleKeyDown = SP_REACT.useCallback((e) => {
        if (e.key === "Enter" || e.key === " ") {
            e.preventDefault();
            handleActivate();
        }
    }, [handleActivate]);
    if (isInterlude) {
        return (SP_JSX.jsx("div", { ref: isActive ? activeRef : null, style: {
                padding: "14px 16px",
                marginBottom: "8px",
                fontSize: isActive ? "20px" : "16px",
                fontWeight: 500,
                lineHeight: 1.4,
                transition: "font-size 0.3s ease, opacity 0.3s ease",
                color: isActive ? "rgba(29, 185, 84, 0.6)" : "rgba(255,255,255,0.25)",
                textAlign: "center",
            }, children: "\u266A \u266A \u266A" }));
    }
    return (SP_JSX.jsxs(DFL.Focusable, { onActivate: handleActivate, onClick: handleActivate, onKeyDown: handleKeyDown, style: {
            padding: "14px 16px",
            marginBottom: "8px",
            fontSize: isActive ? "24px" : "18px",
            fontWeight: 700,
            lineHeight: 1.4,
            transition: "font-size 0.3s ease, transform 0.3s ease, background 0.3s ease",
            borderRadius: "8px",
            background: isActive ? "rgba(255, 255, 255, 0.05)" : "transparent",
            transform: isActive ? "scale(1.02)" : "scale(1)",
            transformOrigin: "left center",
            outline: "none",
        }, ref: isActive ? activeRef : null, children: [SP_JSX.jsx("div", { style: { lineHeight: 1.6 }, children: line.words.map((word, wordIndex) => {
                    const progress = isActive && currentTimeSec !== null
                        ? getWordProgress(word, currentTimeSec)
                        : isPast
                            ? 100
                            : 0;
                    return (SP_JSX.jsxs("span", { style: { position: "relative", display: "inline-block", whiteSpace: "pre" }, children: [SP_JSX.jsx("span", { style: {
                                    color: progress >= 100
                                        ? "#1DB954"
                                        : isPast
                                            ? "rgba(255,255,255,0.5)"
                                            : "rgba(255,255,255,0.4)",
                                }, children: word.text }), progress > 0 && progress < 100 && (SP_JSX.jsx("span", { style: {
                                    position: "absolute",
                                    left: 0,
                                    top: 0,
                                    color: "#1DB954",
                                    clipPath: `inset(0 ${100 - progress}% 0 0)`,
                                    pointerEvents: "none",
                                }, children: word.text }))] }, wordIndex));
                }) }), line.trans && (SP_JSX.jsx("div", { style: {
                    fontSize: isActive ? "14px" : "12px",
                    fontWeight: 500,
                    color: isPast
                        ? "rgba(255,255,255,0.4)"
                        : isActive
                            ? "rgba(29, 185, 84, 0.85)"
                            : "rgba(255,255,255,0.3)",
                    marginTop: "6px",
                    transition: "font-size 0.3s ease, color 0.3s ease",
                }, children: line.trans }))] }));
});
QrcLine.displayName = "QrcLine";
const LrcLine = SP_REACT.memo(({ line, index, activeIndex, activeRef, onSeek }) => {
    const isActive = index === activeIndex;
    const isPast = index < activeIndex;
    const handleActivate = SP_REACT.useCallback(() => onSeek(line.time / 1000), [line.time, onSeek]);
    const handleKeyDown = SP_REACT.useCallback((e) => {
        if (e.key === "Enter" || e.key === " ") {
            e.preventDefault();
            handleActivate();
        }
    }, [handleActivate]);
    return (SP_JSX.jsxs(DFL.Focusable, { onActivate: handleActivate, onClick: handleActivate, onKeyDown: handleKeyDown, ref: isActive ? activeRef : null, style: {
            padding: "14px 16px",
            marginBottom: "8px",
            fontSize: isActive ? "24px" : "18px",
            fontWeight: 700,
            lineHeight: 1.4,
            transition: "all 0.35s cubic-bezier(0.25, 0.1, 0.25, 1)",
            borderRadius: "8px",
            background: isActive ? "rgba(255, 255, 255, 0.05)" : "transparent",
            transform: isActive ? "scale(1.02)" : "scale(1)",
            transformOrigin: "left center",
            color: isActive
                ? "#1DB954"
                : isPast
                    ? "rgba(255,255,255,0.5)"
                    : "rgba(255,255,255,0.35)",
            outline: "none",
        }, children: [SP_JSX.jsx("div", { children: line.text || "♪" }), line.trans && (SP_JSX.jsx("div", { style: {
                    fontSize: isActive ? "15px" : "13px",
                    fontWeight: 500,
                    color: isPast
                        ? "rgba(255,255,255,0.4)"
                        : isActive
                            ? "rgba(29, 185, 84, 0.8)"
                            : "rgba(255,255,255,0.3)",
                    marginTop: "6px",
                    transition: "all 0.35s ease",
                }, children: line.trans }))] }));
});
LrcLine.displayName = "LrcLine";
/**
 * 独立的歌词组件，只有这个组件需要高频刷新
 * 使用 memo 避免父组件重渲染时不必要的更新
 */
const KaraokeLyrics = SP_REACT.memo(({ lyric, isPlaying, hasSong, onSeek }) => {
    const [currentTime, setCurrentTime] = SP_REACT.useState(0);
    const animationFrameRef = SP_REACT.useRef(null);
    const lastUpdateTimeRef = SP_REACT.useRef(0);
    const lastAudioTimeRef = SP_REACT.useRef(0);
    const lyricContainerRef = SP_REACT.useRef(null);
    const currentLyricRef = SP_REACT.useRef(null);
    const lastComputedIndexRef = SP_REACT.useRef(-1);
    const lastComputedTimeRef = SP_REACT.useRef(0);
    const lastScrolledIndexRef = SP_REACT.useRef(-1);
    SP_REACT.useEffect(() => {
        if (!isPlaying || !lyric) {
            if (animationFrameRef.current) {
                cancelAnimationFrame(animationFrameRef.current);
                animationFrameRef.current = null;
            }
            return;
        }
        const isQrc = lyric.isQrc && (lyric.qrcLines || []).length > 0;
        // QRC 格式需要高频更新（16ms）以实现逐字效果
        // LRC 格式只需要较低频率更新（100ms）以实现滚动效果
        const updateInterval = isQrc ? 16 : 100;
        const updateLoop = () => {
            const now = performance.now();
            if (now - lastUpdateTimeRef.current >= updateInterval) {
                lastUpdateTimeRef.current = now;
                const audioTime = getAudioCurrentTime();
                if (audioTime !== lastAudioTimeRef.current) {
                    lastAudioTimeRef.current = audioTime;
                    setCurrentTime(audioTime);
                }
            }
            animationFrameRef.current = requestAnimationFrame(updateLoop);
        };
        const initialTime = getAudioCurrentTime();
        lastAudioTimeRef.current = initialTime;
        setCurrentTime(initialTime);
        animationFrameRef.current = requestAnimationFrame(updateLoop);
        return () => {
            if (animationFrameRef.current) {
                cancelAnimationFrame(animationFrameRef.current);
                animationFrameRef.current = null;
            }
        };
    }, [isPlaying, lyric]);
    SP_REACT.useEffect(() => {
        lastComputedIndexRef.current = -1;
        lastComputedTimeRef.current = 0;
        lastScrolledIndexRef.current = -1;
    }, [lyric]);
    const getCurrentLyricIndex = SP_REACT.useCallback((timeSec) => {
        if (!lyric)
            return -1;
        const isQrc = lyric.isQrc && lyric.qrcLines && lyric.qrcLines.length > 0;
        const lines = isQrc ? lyric.qrcLines || [] : lyric.lines || [];
        if (lines.length === 0)
            return -1;
        const timeValue = isQrc ? timeSec : timeSec * 1000;
        const lastIndex = lastComputedIndexRef.current;
        const lastTime = lastComputedTimeRef.current;
        let index = -1;
        if (timeValue < lastTime || lastIndex < 0) {
            for (let i = lines.length - 1; i >= 0; i--) {
                if (lines[i].time <= timeValue) {
                    index = i;
                    break;
                }
            }
        }
        else {
            let i = Math.min(lastIndex, lines.length - 1);
            while (i + 1 < lines.length && lines[i + 1].time <= timeValue) {
                i++;
            }
            index = i;
        }
        lastComputedIndexRef.current = index;
        lastComputedTimeRef.current = timeValue;
        return index;
    }, [lyric]);
    const isQrc = lyric?.isQrc && (lyric?.qrcLines || []).length > 0;
    // 对于 QRC 和 LRC 格式都使用 currentTime，确保歌词能够滚动
    // currentTime 会在 useEffect 中定期更新
    const effectiveTime = currentTime;
    const currentLyricIndex = SP_REACT.useMemo(() => getCurrentLyricIndex(effectiveTime), [effectiveTime, getCurrentLyricIndex]);
    SP_REACT.useEffect(() => {
        if (currentLyricIndex !== lastScrolledIndexRef.current) {
            lastScrolledIndexRef.current = currentLyricIndex;
            if (currentLyricRef.current && lyricContainerRef.current) {
                const container = lyricContainerRef.current;
                const current = currentLyricRef.current;
                const containerHeight = container.clientHeight;
                const targetScroll = current.offsetTop - containerHeight / 2 + current.clientHeight / 2;
                container.scrollTo({ top: Math.max(0, targetScroll), behavior: "smooth" });
            }
        }
    }, [currentLyricIndex]);
    const lyricLines = lyric?.lines || [];
    const qrcLines = lyric?.qrcLines || [];
    return (SP_JSX.jsx("div", { ref: lyricContainerRef, style: LYRIC_CONTAINER_STYLE, children: isQrc ? (SP_JSX.jsx("div", { style: LYRIC_PADDING_STYLE, children: qrcLines.map((line, index) => (SP_JSX.jsx(QrcLine, { line: line, index: index, activeIndex: currentLyricIndex, currentTimeSec: index === currentLyricIndex ? effectiveTime : null, activeRef: currentLyricRef, onSeek: onSeek }, index))) })) : lyricLines.length > 0 ? (SP_JSX.jsx("div", { style: LYRIC_PADDING_STYLE, children: lyricLines.map((line, index) => (SP_JSX.jsx(LrcLine, { line: line, index: index, activeIndex: currentLyricIndex, activeRef: currentLyricRef, onSeek: onSeek }, index))) })) : (SP_JSX.jsx("div", { style: NO_LYRIC_STYLE, children: hasSong ? "暂无歌词" : "选择一首歌曲开始播放" })) }));
});
KaraokeLyrics.displayName = "KaraokeLyrics";

const PlayerPage = ({ player, playModeConfig, onLyricSeek, }) => {
    const { currentSong: song, isPlaying, currentTime, duration, loading: playerLoading, lyric, playlist, togglePlay, seek, playNext, playPrev, cyclePlayMode, } = player;
    return (SP_JSX.jsxs("div", { tabIndex: -1, style: {
            display: 'flex',
            height: '100%',
            padding: '16px 24px',
            gap: '20px',
            boxSizing: 'border-box'
        }, children: [SP_JSX.jsxs("div", { style: {
                    width: '320px',
                    flexShrink: 0,
                    display: 'flex',
                    flexDirection: 'column',
                    alignItems: 'center',
                    justifyContent: 'center'
                }, children: [SP_JSX.jsx(PlayerCover, { song: song }), SP_JSX.jsx(PlayerMeta, { song: song }), SP_JSX.jsx(PlayerProgress, { hasSong: !!song, currentTime: currentTime, duration: duration || song?.duration || 0, onSeek: seek }), SP_JSX.jsxs("div", { style: {
                            display: 'flex',
                            alignItems: 'center',
                            gap: '16px',
                            marginBottom: '8px'
                        }, children: [SP_JSX.jsx("div", { onClick: cyclePlayMode, title: playModeConfig.title, style: {
                                    width: '32px',
                                    height: '32px',
                                    borderRadius: '50%',
                                    background: 'rgba(255,255,255,0.1)',
                                    display: 'flex',
                                    alignItems: 'center',
                                    justifyContent: 'center',
                                    cursor: 'pointer'
                                }, children: playModeConfig.icon }), SP_JSX.jsx("div", { onClick: () => playlist.length > 1 && playPrev(), style: {
                                    width: '36px',
                                    height: '36px',
                                    borderRadius: '50%',
                                    background: 'rgba(255,255,255,0.1)',
                                    display: 'flex',
                                    alignItems: 'center',
                                    justifyContent: 'center',
                                    cursor: playlist.length > 1 ? 'pointer' : 'not-allowed',
                                    opacity: playlist.length > 1 ? 1 : 0.4
                                }, children: SP_JSX.jsx(FaStepBackward, { size: 14 }) }), SP_JSX.jsx("div", { onClick: () => song && togglePlay(), style: {
                                    width: '50px',
                                    height: '50px',
                                    borderRadius: '50%',
                                    background: song ? '#1db954' : 'rgba(255,255,255,0.1)',
                                    display: 'flex',
                                    alignItems: 'center',
                                    justifyContent: 'center',
                                    cursor: song ? 'pointer' : 'not-allowed',
                                    boxShadow: song ? '0 2px 12px rgba(29, 185, 84, 0.4)' : 'none'
                                }, children: playerLoading ? (SP_JSX.jsx(DFL.Spinner, { style: { width: '20px', height: '20px' } })) : isPlaying ? (SP_JSX.jsx(FaPause, { size: 18 })) : (SP_JSX.jsx(FaPlay, { size: 18, style: { marginLeft: '2px' } })) }), SP_JSX.jsx("div", { onClick: () => playlist.length > 1 && playNext(), style: {
                                    width: '36px',
                                    height: '36px',
                                    borderRadius: '50%',
                                    background: 'rgba(255,255,255,0.1)',
                                    display: 'flex',
                                    alignItems: 'center',
                                    justifyContent: 'center',
                                    cursor: playlist.length > 1 ? 'pointer' : 'not-allowed',
                                    opacity: playlist.length > 1 ? 1 : 0.4
                                }, children: SP_JSX.jsx(FaStepForward, { size: 14 }) })] }), SP_JSX.jsxs("div", { style: {
                            fontSize: '10px',
                            color: '#555',
                            display: 'flex',
                            gap: '10px'
                        }, children: [SP_JSX.jsx("span", { children: "L1 \u4E0A\u4E00\u9996" }), SP_JSX.jsx("span", { children: "X \u6682\u505C" }), SP_JSX.jsx("span", { children: "R1 \u4E0B\u4E00\u9996" })] })] }), SP_JSX.jsx("div", { style: {
                    flex: 1,
                    display: 'flex',
                    flexDirection: 'column',
                    overflow: 'hidden',
                    minWidth: 0,
                    background: 'linear-gradient(180deg, rgba(0,0,0,0.2) 0%, transparent 100%)',
                    borderRadius: '12px',
                }, children: SP_JSX.jsx(KaraokeLyrics, { lyric: lyric, isPlaying: isPlaying, hasSong: !!song, onSeek: onLyricSeek }) })] }));
};

/**
 * 全屏播放器手柄快捷键 Hook
 */

/**
 * 使用手柄快捷键
 */
function useFullscreenGamepad(player, currentPage, navigateToPage) {
    // 保存最新状态到 ref，用于手柄快捷键回调
    const playerRef = SP_REACT.useRef(player);
    const currentPageRef = SP_REACT.useRef(currentPage);
    SP_REACT.useEffect(() => {
        playerRef.current = player;
        currentPageRef.current = currentPage;
    }, [player, currentPage]);
    SP_REACT.useEffect(() => {
        // @ts-ignore
        // eslint-disable-next-line no-undef
        if (typeof SteamClient === 'undefined' || !SteamClient?.Input?.RegisterForControllerInputMessages) {
            return;
        }
        // @ts-ignore
        // eslint-disable-next-line no-undef
        const unregister = SteamClient.Input.RegisterForControllerInputMessages((_controllerIndex, button, pressed) => {
            if (!pressed)
                return;
            const p = playerRef.current;
            const page = currentPageRef.current;
            switch (button) {
                case 2: // X - 播放/暂停
                    if (p.currentSong)
                        p.togglePlay();
                    break;
                case 30: // L1 - 上一曲
                    if (p.playlist.length > 1)
                        p.playPrev();
                    break;
                case 31: // R1 - 下一曲
                    if (p.playlist.length > 1)
                        p.playNext();
                    break;
                case 28: // LT - 底部导航左切换
                case 29: { // RT - 底部导航右切换
                    const activeId = page === 'playlist-detail' ? 'playlists' : page;
                    const currentIndex = NAV_ITEMS.findIndex((item) => item.id === activeId);
                    if (currentIndex === -1)
                        break;
                    const delta = button === 28 ? -1 : 1;
                    const nextIndex = (currentIndex + delta + NAV_ITEMS.length) % NAV_ITEMS.length;
                    navigateToPage(NAV_ITEMS[nextIndex].id);
                    break;
                }
            }
        });
        return () => {
            unregister?.unregister?.();
        };
    }, [navigateToPage]);
}

/**
 * 全屏播放器事件处理 Hook
 */

/**
 * 创建全屏播放器的事件处理函数
 */
function useFullscreenHandlers(player, dataManager, navigateToPage) {
    const { playSong, playPlaylist, addToQueue, setOnNeedMoreSongs, } = player;
    // 猜你喜欢预取相关
    const nextGuessLikeRef = SP_REACT.useRef(null);
    const nextGuessLikePromiseRef = SP_REACT.useRef(null);
    const prefetchNextGuessLikeBatch = SP_REACT.useCallback(() => {
        if (nextGuessLikePromiseRef.current)
            return;
        nextGuessLikePromiseRef.current = fetchGuessLikeRaw()
            .then((songs) => {
            nextGuessLikeRef.current = songs;
        })
            .catch(() => { })
            .finally(() => {
            nextGuessLikePromiseRef.current = null;
        });
    }, []);
    const fetchMoreGuessLikeSongs = SP_REACT.useCallback(async () => {
        let songs;
        if (nextGuessLikeRef.current && nextGuessLikeRef.current.length > 0) {
            songs = nextGuessLikeRef.current;
            nextGuessLikeRef.current = null;
            prefetchNextGuessLikeBatch();
        }
        else {
            songs = await fetchGuessLikeRaw();
            prefetchNextGuessLikeBatch();
        }
        // 获取新数据后，直接替换UI上的猜你喜欢数据
        if (songs.length > 0) {
            replaceGuessLikeSongs(songs);
        }
        return songs;
    }, [prefetchNextGuessLikeBatch]);
    // 选择歌曲
    const handleSelectSong = SP_REACT.useCallback(async (song, songList, source) => {
        if (songList && songList.length > 0) {
            const index = songList.findIndex(s => s.mid === song.mid);
            playPlaylist(songList, index >= 0 ? index : 0).catch(() => { });
            if (source === 'guess-like') {
                setOnNeedMoreSongs(fetchMoreGuessLikeSongs);
            }
            else {
                setOnNeedMoreSongs(null);
            }
        }
        else {
            playSong(song).catch(() => { });
            setOnNeedMoreSongs(null);
        }
        navigateToPage('player');
    }, [fetchMoreGuessLikeSongs, navigateToPage, playPlaylist, playSong, setOnNeedMoreSongs]);
    // 选择歌单
    const handleSelectPlaylist = SP_REACT.useCallback((_playlistInfo) => {
        navigateToPage('playlist-detail');
    }, [navigateToPage]);
    // 添加歌单到队列
    const handleAddPlaylistToQueue = SP_REACT.useCallback(async (songs) => {
        if (!songs || songs.length === 0)
            return;
        await addToQueue(songs);
        toaster.toast({
            title: "已添加到播放队列",
            body: `加入 ${songs.length} 首歌曲`,
        });
    }, [addToQueue]);
    return {
        handleSelectSong,
        handleSelectPlaylist,
        handleAddPlaylistToQueue,
        fetchMoreGuessLikeSongs,
    };
}

const GuessLikePage = SP_REACT.memo(({ songs, loading, onRefresh, onSelectSong, disableRefresh = false }) => (SP_JSX.jsx(GuessLikeSection, { songs: songs, loading: loading, onRefresh: onRefresh, onSelectSong: onSelectSong, disableRefresh: disableRefresh, variant: "fullscreen" })));
GuessLikePage.displayName = "GuessLikePage";

const MemoSearchPage = SP_REACT.memo(SearchPage);
const MemoPlaylistsPage = SP_REACT.memo(PlaylistsPage);
const MemoPlaylistDetailPage = SP_REACT.memo(PlaylistDetailPage);
const MemoHistoryPage = SP_REACT.memo(HistoryPage);
/**
 * 创建页面内容的 ref 和渲染函数
 */
function useFullscreenContent(params) {
    const { player, dataManager, selectedPlaylist, currentPlayingMid, isNetease, onSelectSong, onSelectPlaylist, onAddPlaylistToQueue, onRefreshGuessLike, goBackToPlayer, goBackToPlaylists, } = params;
    const { playlist, currentIndex, playAtIndex, removeFromQueue, } = player;
    const { guessLikeSongs, guessLoading, } = dataManager;
    // 页面 refs
    const guessLikePageRef = SP_REACT.useRef(null);
    const searchPageRef = SP_REACT.useRef(null);
    const playlistsPageRef = SP_REACT.useRef(null);
    const playlistDetailPageRef = SP_REACT.useRef(null);
    const historyPageRef = SP_REACT.useRef(null);
    // 页面内容
    const guessLikeContent = SP_REACT.useMemo(() => (SP_JSX.jsx("div", { ref: guessLikePageRef, tabIndex: -1, style: { height: '100%' }, children: SP_JSX.jsx(GuessLikePage, { songs: guessLikeSongs, loading: guessLoading, onRefresh: onRefreshGuessLike, onSelectSong: (song) => onSelectSong(song, guessLikeSongs, 'guess-like'), disableRefresh: isNetease }) })), [guessLikeSongs, guessLoading, onRefreshGuessLike, onSelectSong, isNetease]);
    const searchPageContent = SP_REACT.useMemo(() => (SP_JSX.jsx("div", { ref: searchPageRef, tabIndex: -1, style: { height: '100%', overflow: 'auto' }, children: SP_JSX.jsx(MemoSearchPage, { onSelectSong: onSelectSong, onBack: goBackToPlayer, currentPlayingMid: currentPlayingMid }) })), [currentPlayingMid, goBackToPlayer, onSelectSong]);
    const playlistsContent = SP_REACT.useMemo(() => (SP_JSX.jsx("div", { ref: playlistsPageRef, tabIndex: -1, style: { height: '100%', overflow: 'auto' }, children: SP_JSX.jsx(MemoPlaylistsPage, { onSelectPlaylist: onSelectPlaylist, onBack: goBackToPlayer }) })), [goBackToPlayer, onSelectPlaylist]);
    const playlistDetailContent = SP_REACT.useMemo(() => {
        if (!selectedPlaylist)
            return null;
        return (SP_JSX.jsx("div", { ref: playlistDetailPageRef, tabIndex: -1, style: { height: '100%', overflow: 'auto' }, children: SP_JSX.jsx(MemoPlaylistDetailPage, { playlist: selectedPlaylist, onSelectSong: onSelectSong, onAddPlaylistToQueue: onAddPlaylistToQueue, onBack: goBackToPlaylists, currentPlayingMid: currentPlayingMid }) }));
    }, [currentPlayingMid, goBackToPlaylists, onAddPlaylistToQueue, onSelectSong, selectedPlaylist]);
    const historyContent = SP_REACT.useMemo(() => (SP_JSX.jsx("div", { ref: historyPageRef, tabIndex: -1, style: { height: '100%', overflow: 'auto' }, children: SP_JSX.jsx(MemoHistoryPage, { playlist: playlist, currentIndex: currentIndex, onSelectIndex: playAtIndex, onBack: goBackToPlayer, currentPlayingMid: currentPlayingMid, onRemoveFromQueue: removeFromQueue }) })), [currentIndex, currentPlayingMid, goBackToPlayer, playAtIndex, playlist, removeFromQueue]);
    const pageRefs = SP_REACT.useMemo(() => ({
        guessLikePageRef,
        searchPageRef,
        playlistsPageRef,
        playlistDetailPageRef,
        historyPageRef,
    }), []);
    // 页面内容
    const content = SP_REACT.useMemo(() => ({
        guessLikeContent,
        searchPageContent,
        playlistsContent,
        playlistDetailContent,
        historyContent,
    }), [guessLikeContent, searchPageContent, playlistsContent, playlistDetailContent, historyContent]);
    return {
        pageRefs,
        content,
    };
}

const SYSTEM_TOP_BAR_HEIGHT = 40;
const SYSTEM_BOTTOM_BAR_HEIGHT = 40;
const FullscreenPlayer = () => {
    const [currentPage, setCurrentPage] = SP_REACT.useState('player');
    const [selectedPlaylist, setSelectedPlaylist] = SP_REACT.useState(null);
    const isLoggedIn = useAuthStatus();
    const mountedRef = useMountedRef();
    const playerPageRef = SP_REACT.useRef(null);
    const player = usePlayer();
    const dataManager = useDataManager();
    const { provider } = useProvider();
    const { currentSong, isPlaying, duration, playMode, seek, togglePlay, } = player;
    const { preloadData } = dataManager;
    const isNetease = provider?.id === "netease";
    const currentPlayingMid = currentSong?.mid;
    // 播放模式配置
    const playModeConfig = SP_REACT.useMemo(() => {
        switch (playMode) {
            case "shuffle":
                return { icon: SP_JSX.jsx(FaRandom, { size: 14 }), title: "随机播放" };
            case "single":
                return { icon: SP_JSX.jsx(FaRedo, { size: 14 }), title: "单曲循环" };
            default:
                return { icon: SP_JSX.jsx(FaListOl, { size: 14 }), title: "顺序播放" };
        }
    }, [playMode]);
    // 歌词跳转处理
    const handleLyricSeek = SP_REACT.useCallback((timeSec) => {
        if (!currentSong)
            return;
        const total = duration || currentSong.duration || 0;
        if (!total || !isFinite(total))
            return;
        const clamped = Math.max(0, Math.min(timeSec, total));
        seek(clamped);
        if (!isPlaying) {
            togglePlay();
        }
    }, [currentSong, duration, isPlaying, seek, togglePlay]);
    // 页面导航（直接使用 setCurrentPage）
    const navigateToPage = setCurrentPage;
    // 检查登录状态
    const checkLoginStatus = SP_REACT.useCallback(async () => {
        try {
            const result = await getProviderSelection();
            if (!mountedRef.current)
                return;
            const isLoggedIn = Boolean(result.success && result.mainProvider);
            setAuthLoggedIn(isLoggedIn);
        }
        catch {
            // 忽略错误
        }
    }, [mountedRef]);
    // 如果首次没有登录状态（初始渲染时 auth 状态未知），进行一次检查
    SP_REACT.useEffect(() => {
        if (isLoggedIn === false || isLoggedIn === true)
            return;
        checkLoginStatus();
    }, [isLoggedIn, checkLoginStatus]);
    // 进入猜你喜欢页面时自动加载数据（按需加载模式）
    useAutoLoadGuessLike(currentPage === 'guess-like');
    // 手柄快捷键
    useFullscreenGamepad(player, currentPage, navigateToPage);
    // 事件处理函数
    const { handleSelectSong, handleSelectPlaylist: handleSelectPlaylistRaw, handleAddPlaylistToQueue, } = useFullscreenHandlers(player, dataManager, navigateToPage);
    // 包装 handleSelectPlaylist 以设置 selectedPlaylist
    const handleSelectPlaylist = SP_REACT.useCallback((playlistInfo) => {
        setSelectedPlaylist(playlistInfo);
        handleSelectPlaylistRaw(playlistInfo);
    }, [handleSelectPlaylistRaw]);
    // 登录成功处理
    const handleLoginSuccess = SP_REACT.useCallback(() => {
        setAuthLoggedIn(true);
        navigateToPage('player');
        preloadData();
    }, [navigateToPage, preloadData]);
    // 导航辅助函数
    const goBackToPlayer = SP_REACT.useCallback(() => navigateToPage('player'), [navigateToPage]);
    const goBackToPlaylists = SP_REACT.useCallback(() => navigateToPage('playlists'), [navigateToPage]);
    // 页面内容
    const { pageRefs, content, } = useFullscreenContent({
        player,
        dataManager,
        selectedPlaylist,
        currentPlayingMid,
        isNetease,
        onSelectSong: handleSelectSong,
        onSelectPlaylist: handleSelectPlaylist,
        onAddPlaylistToQueue: handleAddPlaylistToQueue,
        onRefreshGuessLike: () => dataManager.refreshGuessLike(),
        goBackToPlayer,
        goBackToPlaylists,
    });
    // 页面焦点管理
    const focusCurrentPage = SP_REACT.useCallback((page) => {
        const pageRefMap = {
            'player': playerPageRef.current,
            'guess-like': pageRefs.guessLikePageRef.current,
            'search': pageRefs.searchPageRef.current,
            'playlists': pageRefs.playlistsPageRef.current,
            'playlist-detail': selectedPlaylist ? pageRefs.playlistDetailPageRef.current : null,
            'history': pageRefs.historyPageRef.current,
        };
        const target = pageRefMap[page];
        if (!target)
            return;
        const focusFn = () => target.focus({ preventScroll: true });
        if (typeof requestAnimationFrame === 'function') {
            requestAnimationFrame(focusFn);
        }
        else {
            setTimeout(focusFn, 0);
        }
    }, [pageRefs, selectedPlaylist]);
    SP_REACT.useEffect(() => {
        focusCurrentPage(currentPage);
    }, [currentPage, focusCurrentPage]);
    // 渲染播放器页面
    const renderPlayerPage = () => (SP_JSX.jsx("div", { ref: playerPageRef, tabIndex: -1, style: { height: '100%', overflow: 'hidden' }, children: SP_JSX.jsx(PlayerPage, { player: player, playModeConfig: playModeConfig, onLyricSeek: handleLyricSeek }) }));
    // 渲染非历史页面内容
    const renderNonHistoryContent = () => {
        const contentMap = {
            'player': renderPlayerPage(),
            'guess-like': content.guessLikeContent,
            'search': content.searchPageContent,
            'playlists': content.playlistsContent,
            'playlist-detail': content.playlistDetailContent,
        };
        return contentMap[currentPage] ?? null;
    };
    // 未登录
    if (!isLoggedIn) {
        return (SP_JSX.jsx("div", { style: {
                position: 'fixed',
                top: `${SYSTEM_TOP_BAR_HEIGHT}px`,
                left: 0,
                right: 0,
                bottom: `${SYSTEM_BOTTOM_BAR_HEIGHT}px`,
                background: '#0e1419',
                overflow: 'auto'
            }, children: SP_JSX.jsx(LoginPage, { onLoginSuccess: handleLoginSuccess }) }));
    }
    return (SP_JSX.jsxs("div", { style: {
            position: 'fixed',
            top: `${SYSTEM_TOP_BAR_HEIGHT}px`,
            left: 0,
            right: 0,
            bottom: `${SYSTEM_BOTTOM_BAR_HEIGHT}px`,
            background: '#0e1419',
            display: 'flex',
            flexDirection: 'column',
            overflow: 'hidden'
        }, children: [SP_JSX.jsxs("div", { style: {
                    flex: 1,
                    overflow: 'hidden',
                    display: 'flex',
                    flexDirection: 'column',
                    minHeight: 0,
                    position: 'relative'
                }, children: [SP_JSX.jsx("div", { style: {
                            position: 'absolute',
                            inset: 0,
                            pointerEvents: 'auto',
                            opacity: currentPage === 'history' ? 0 : 1,
                            transition: 'opacity 140ms ease-out',
                            overflow: 'hidden',
                        }, children: renderNonHistoryContent() }), currentPage === 'history' && (SP_JSX.jsx("div", { style: {
                            position: 'absolute',
                            inset: 0,
                            pointerEvents: 'auto',
                            opacity: 1,
                            transition: 'opacity 140ms ease-out',
                            overflow: 'hidden',
                        }, children: content.historyContent }))] }), SP_JSX.jsx(NavBar, { currentPage: currentPage, onNavigate: navigateToPage })] }));
};

// 主内容组件
function Content() {
    const { state, player, nav, data } = useAppLogic();
    const { currentPage, selectedPlaylist } = state;
    const paddingBottom = player.currentSong && currentPage !== "player" ? "70px" : "0";
    const isLoading = currentPage === "loading";
    return (SP_JSX.jsxs("div", { className: "decky-music-container", style: { paddingBottom }, children: [isLoading ? (SP_JSX.jsx(DFL.PanelSection, { title: "Decky Music", children: SP_JSX.jsx(DFL.PanelSectionRow, { children: SP_JSX.jsx(DFL.Spinner, {}) }) })) : (SP_JSX.jsx(Router, { currentPage: currentPage, player: player, selectedPlaylist: selectedPlaylist, nav: nav, data: data })), player.currentSong && currentPage !== "player" && currentPage !== "login" && currentPage !== "loading" && (SP_JSX.jsx(PlayerBar, { song: player.currentSong, isPlaying: player.isPlaying, currentTime: player.currentTime, duration: player.duration || player.currentSong.duration, loading: player.loading, onTogglePlay: player.togglePlay, onSeek: player.seek, onClick: nav.onGoToPlayer, onNext: player.playlist.length > 1 ? player.playNext : undefined, onPrev: player.playlist.length > 1 ? player.playPrev : undefined, playMode: player.playMode, onTogglePlayMode: player.cyclePlayMode }))] }));
}
// 插件导出
var index = definePlugin(() => {
    // TODO: 修复 full screen 的错误
    // 注册全屏路由
    routerHook.addRoute(ROUTE_PATH, FullscreenPlayer);
    // 插件初始化时检查登录状态，已登录则启用左侧菜单并预加载数据
    // 以前是 getLoginStatus()，现在改为 getProviderSelection()
    getProviderSelection()
        .then((result) => {
        // 只要 mainProvider 存在，就视为已登录
        const isLoggedIn = Boolean(result.success && result.mainProvider);
        setAuthLoggedIn(isLoggedIn);
        if (isLoggedIn) {
            menuManager.enable();
        }
    })
        .catch(() => {
        // 忽略错误
    });
    return {
        name: "Decky Music",
        titleView: (SP_JSX.jsxs("div", { className: DFL.staticClasses.Title, children: [SP_JSX.jsx(FaMusic, { style: { marginRight: "8px" } }), "Decky Music"] })),
        content: (SP_JSX.jsx(ErrorBoundary, { children: SP_JSX.jsx(Content, {}) })),
        icon: SP_JSX.jsx(FaMusic, {}),
        onDismount() {
            // some clean
            // 清理菜单 patch
            menuManager.cleanup();
            // 移除路由
            routerHook.removeRoute(ROUTE_PATH);
            // 清理播放器
            cleanupPlayer();
            // 移除全局样式
            const styleEl = document.getElementById("decky-music-styles");
            if (styleEl) {
                styleEl.remove();
            }
        },
    };
});

export { index as default };
//# sourceMappingURL=index.js.map
