# Markdown Sample Document

This is a comprehensive sample document showcasing various Markdown elements.

## Level 2 Heading

### Level 3 Heading

Here's some regular text with **bold text**, *italic text*, and `inline code`.

## Lists

### Unordered List

- First item
- Second item
  - Nested item 1
  - Nested item 2
- Third item

### Ordered List

1. First step
2. Second step
   1. Sub-step A
   2. Sub-step B
3. Third step

### Mixed List

1. First item
   - Sub-item with bullet
   - Another sub-item
2. Second item
   1. Numbered sub-item
   2. Another numbered sub-item

## Links and References

Here's a [link to GitHub](https://github.com) and another [relative link](../README.md).

## Code Blocks

```python
def hello_world():
    """A simple function to demonstrate code blocks."""
    print("Hello, World!")
    return 42

# Call the function
result = hello_world()
```

```bash
# Bash example
echo "This is a bash script"
ls -la /tmp
```

## Blockquotes

> This is a blockquote.
> It can span multiple lines.
>
> > And it can be nested too!

## Tables

| Column 1 | Column 2 | Column 3 |
|----------|----------|----------|
| Cell 1   | Cell 2   | Cell 3   |
| Left     | Center   | Right    |
| Foo      | Bar      | Baz      |

## Horizontal Rules

---

Here's some text after a horizontal rule.

---

## Inline Formatting

You can combine **bold and *italic*** text, or use `code` within paragraphs.

**Important**: Always test your `code` snippets before deployment.

## Advanced Features

### Task Lists

- [x] Completed task
- [ ] Pending task
- [ ] Another pending task

### Definition Lists

Term 1
: Definition of term 1

Term 2
: Definition of term 2
: Another definition for term 2

---

*This document demonstrates comprehensive Markdown formatting capabilities.*
