# 常见使用案例

Kimi Code CLI 可以帮助你完成多种软件开发和通用任务，以下是一些典型场景。

## 实现新功能

当你需要为项目添加新功能时，直接用自然语言描述需求即可。Kimi Code CLI 会自动阅读相关代码、理解项目结构，然后进行修改。

```
给用户列表页面添加分页功能，每页显示 20 条记录
```

Kimi Code CLI 通常会按照「读 → 改 → 验证」的流程工作：

1. **阅读**：搜索和阅读相关代码，理解现有实现
2. **修改**：编写或修改代码，遵循项目的代码风格
3. **验证**：运行测试或构建，确保修改没有引入问题

如果你对修改不满意，可以直接告诉 Kimi Code CLI 调整方向：

```
分页组件的样式和项目其他地方不一致，参考 Button 组件的样式
```

## 修复 bug

描述你遇到的问题，Kimi Code CLI 会帮你定位原因并修复：

```
用户登录后跳转到首页时，偶尔会显示未登录状态，帮我排查一下
```

对于有明确错误信息的问题，可以直接贴上错误日志：

```
运行 npm test 时出现这个错误：

TypeError: Cannot read property 'map' of undefined
    at UserList.render (src/components/UserList.jsx:15:23)

帮我修复
```

你也可以让 Kimi Code CLI 运行命令来复现和验证问题：

```
运行测试，如果有失败的用例就修复它们
```

## 理解项目

Kimi Code CLI 可以帮你探索和理解不熟悉的代码库：

```
这个项目的整体架构是怎样的？入口文件在哪里？
```

```
用户认证的流程是怎么实现的？涉及哪些文件？
```

```
解释一下 src/core/scheduler.py 这个文件的作用
```

如果你在阅读代码时遇到不理解的部分，可以随时提问：

```
useCallback 和 useMemo 有什么区别？这里为什么要用 useCallback？
```

## 自动化小任务

Kimi Code CLI 可以执行各种重复性的小任务：

```
把 src 目录下所有 .js 文件的 var 声明改成 const 或 let
```

```
给所有没有 docstring 的公开函数添加文档注释
```

```
生成这个 API 模块的单元测试
```

```
更新 package.json 中所有依赖到最新版本，然后运行测试确保没有问题
```

## 自动化通用任务

除了代码相关的任务，Kimi Code CLI 也可以处理一些通用场景。

**调研任务**

```
帮我调研一下 Python 的异步 Web 框架，比较 FastAPI、Starlette 和 Sanic 的优缺点
```

**数据分析**

```
分析 logs 目录下的访问日志，统计每个接口的调用次数和平均响应时间
```

**批量文件处理**

```
把 images 目录下的所有 PNG 图片转换为 JPEG 格式，保存到 output 目录
```

