# 会话与上下文

Kimi Code CLI 会自动保存你的对话历史，方便你随时继续之前的工作。

## 会话续接

每次启动 Kimi Code CLI 时，都会创建一个新的会话。如果你想继续之前的对话，有几种方式：

**继续最近的会话**

使用 `--continue` 参数可以继续当前工作目录下最近的会话：

```sh
kimi --continue
```

**切换到指定会话**

使用 `--session` 参数可以切换到指定 ID 的会话：

```sh
kimi --session abc123
```

**在运行中切换会话**

输入 `/sessions`（或 `/resume`）可以查看当前工作目录的所有会话列表，使用方向键选择要切换的会话：

```
/sessions
```

列表会显示每个会话的标题和最后更新时间，帮助你找到想要继续的对话。

**启动回放**

当你继续一个已有会话时，Kimi Code CLI 会回放之前的对话历史，让你快速了解上下文。回放过程中会显示之前的消息和 AI 的回复。

## 清空与压缩

随着对话的进行，上下文会越来越长。Kimi Code CLI 会在需要的时候自动对上下文进行压缩，确保对话能够继续。

你也可以使用斜杠命令手动管理上下文：

**清空上下文**

输入 `/clear` 可以清空当前会话的所有上下文，重新开始对话：

```
/clear
```

清空后，AI 会忘记之前的所有对话内容。通常你不需要使用这个命令，对于新任务，开启新的会话会是更好的选择。

**压缩上下文**

输入 `/compact` 可以让 AI 总结当前的对话，并用总结替换原有的上下文：

```
/compact
```

压缩会保留关键信息，同时减少 token 消耗。这在对话很长但你还想保留一些上下文时很有用。

::: tip 提示
底部状态栏会显示当前的上下文使用率（`context: xx%`），帮助你了解何时需要清空或压缩。
:::
