/**
  ******************************************************************************
  * @file    I2S/I2S_Audio/Src/audio_sample.c
  * @author  MCD Application Team
  * @brief   Audio sample file.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2016 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */ 
  
/* Includes ------------------------------------------------------------------*/
#include "stm32f3xx_hal.h"

/** @addtogroup I2S_Audio
  * @{
  */

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/* This is an Audio file stored in the internal Flash memory as a constant table of 16-bit data.
   The Audio format should be WAV (raw / PCM) 16-bits, Mono or Stereo (sampling rate may be modified) 
 */

/*  
  The provided sample Audio file (stored in internal Flash memory) is extracted from:
  - Title: Partita E major, Gavotte en rondeau  
  - Artist/Composer: J.-S. Bach
*/

const uint16_t AUDIO_SAMPLE[] = {
0x4952, 0x4646, 0x8518, 0x001A, 0x4157, 0x4556, 0x6D66, 0x2074,
0x0010, 0x0000, 0x0001, 0x0002, 0x1F40, 0x0000, 0x7D00, 0x0000,
0x0004, 0x0010, 0x6164, 0x6174, 0x84F4, 0x001A, 0x0000, 0x0000,
0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0001, 0xFFFF,
0x0001, 0x0000, 0x0002, 0x0001, 0x0003, 0x0001, 0x0003, 0x0001,
0x0004, 0x0000, 0x0005, 0x0002, 0x0004, 0x0002, 0x0004, 0x0002,
0x0005, 0x0004, 0x0006, 0x0005, 0x0007, 0x0005, 0x0009, 0x0006,
0x000A, 0x0008, 0x0009, 0x000A, 0x000B, 0x000D, 0x000C, 0x000C,
0x000D, 0x0009, 0x000F, 0x0008, 0x0011, 0x000B, 0x0015, 0x000E,
0x0018, 0x000E, 0x0017, 0x000C, 0x0016, 0x000F, 0x0017, 0x0013,
0x0018, 0x0014, 0x001A, 0x0014, 0x0019, 0x0015, 0x0014, 0x0016,
0x0012, 0x0018, 0x0015, 0x001A, 0x0019, 0x001C, 0x0017, 0x001C,
0x0013, 0x001C, 0x0015, 0x0021, 0x001A, 0x0024, 0x001C, 0x0024,
0x001B, 0x0025, 0x0017, 0x0025, 0x0015, 0x0023, 0x0019, 0x0022,
0x001A, 0x002A, 0x0015, 0x0031, 0x0012, 0x002A, 0x0012, 0x0024,
0x0013, 0x002A, 0x0016, 0x002E, 0x0018, 0x0029, 0x0017, 0x0021,
0x0014, 0x0021, 0x0017, 0x0028, 0x001D, 0x002A, 0x0026, 0x0026,
0x002B, 0x0024, 0x0029, 0x0024, 0x0023, 0x0022, 0x0020, 0x0025,
0x0027, 0x0023, 0x0027, 0x0020, 0x001D, 0x0028, 0x001C, 0x0029,
0x0024, 0x0020, 0x0023, 0x0025, 0x001C, 0x0030, 0x0016, 0x002D,
0x000A, 0x0024, 0x0000, 0x0025, 0xFFFE, 0x002B, 0xFFFD, 0x0027,
0xFFFC, 0x0026, 0xFFFF, 0x002E, 0x0002, 0x002D, 0x0001, 0x0028,
0x0005, 0x002A, 0x0009, 0x0025, 0x0006, 0x0022, 0x0010, 0x0025,
0x001A, 0x0021, 0x0013, 0x0016, 0x000B, 0x0010, 0x0008, 0x000F,
0x0005, 0x0010, 0x000E, 0x0014, 0x0016, 0x0011, 0x000E, 0x000C,
0x000B, 0x0019, 0x0010, 0x001C, 0x0013, 0x000C, 0x0013, 0x000E,
0x000E, 0x001C, 0x0003, 0x0015, 0xFFF4, 0x0007, 0xFFF0, 0x000E,
0xFFFC, 0x0016, 0xFFFC, 0x0010, 0xFFDF, 0x0011, 0xFFD0, 0x0018,
0xFFEC, 0x0016, 0xFFFA, 0x0018, 0xFFF1, 0x0022, 0xFFED, 0x0017,
0xFFE4, 0x000B, 0xFFE1, 0x0021, 0xFFEA, 0x0035, 0xFFFA, 0x002E,
0x0009, 0x0023, 0x0005, 0x002C, 0xFFFF, 0x0033, 0x000B, 0x0027,
0x001A, 0x0029, 0x001E, 0x0034, 0x0017, 0x002B, 0x0012, 0x001C,
0x0020, 0x001A, 0x0027, 0x0022, 0x0013, 0x0018, 0x000E, 0x000A,
0x0028, 0x0018, 0x003A, 0x001A, 0x0038, 0x0009, 0x0028, 0x0003,
0x002E, 0x000E, 0x0042, 0x0025, 0x003C, 0x002E, 0x0041, 0x001D,
0x0042, 0x0017, 0x002B, 0x0027, 0x0021, 0x0032, 0x0019, 0x002D,
0x0019, 0x002E, 0x0014, 0x0034, 0xFFF1, 0x002C, 0xFFED, 0x0016,
0xFFFE, 0x000C, 0xFFF2, 0x0015, 0xFFE6, 0x001E, 0xFFE4, 0x002A,
0xFFEA, 0x0039, 0xFFF2, 0x0031, 0xFFED, 0x0017, 0xFFF7, 0x0012,
0x0005, 0x001F, 0x0005, 0x0021, 0x0000, 0x0017, 0xFFF4, 0x0009,
0xFFEE, 0x0010, 0xFFFA, 0x0020, 0xFFF9, 0x000F, 0xFFDC, 0x0006,
0xFFCE, 0x0011, 0xFFE6, 0x000F, 0xFFFF, 0x0012, 0xFFFC, 0x0015,
0xFFE6, 0x0012, 0xFFD8, 0x001D, 0xFFE4, 0x0022, 0xFFF0, 0x0026,
0xFFF3, 0x003C, 0xFFE9, 0x0042, 0xFFC8, 0x003C, 0xFFBE, 0x003B,
0xFFC6, 0x0030, 0xFFBD, 0x002E, 0xFFB3, 0x0038, 0xFF9E, 0x002F,
0xFFA5, 0x001B, 0xFFD0, 0x0012, 0xFFD5, 0x001F, 0xFFD0, 0x0028,
0xFFD3, 0x0010, 0xFFCD, 0xFFFD, 0xFFE3, 0xFFFC, 0xFFF9, 0xFFFC,
0x0005, 0xFFFC, 0x000B, 0xFFE4, 0xFFF4, 0xFFD0, 0xFFEF, 0xFFE8,
0x0000, 0xFFEA, 0x000B, 0xFFDB, 0x000D, 0xFFE8, 0xFFFA, 0xFFEE,
0xFFF7, 0xFFE9, 0x0017, 0xFFEC, 0x001D, 0xFFFE, 0x0014, 0x0008,
0x001A, 0xFFF2, 0x0015, 0xFFF5, 0x0006, 0x000D, 0xFFFD, 0x0015,
0xFFEF, 0x0017, 0xFFD4, 0x0007, 0xFFCB, 0x0008, 0xFFD0, 0x0020,
0xFFD3, 0x001D, 0xFFE5, 0x001A, 0xFFED, 0x0021, 0xFFE5, 0x001F,
0xFFE1, 0x0026, 0xFFDC, 0x0027, 0xFFCF, 0x002D, 0xFFC3, 0x0038,
0xFFC0, 0x0028, 0xFFBE, 0x001D, 0xFFBB, 0x0039, 0xFFAC, 0x004E,
0xFFAF, 0x0041, 0xFFDA, 0x003B, 0xFFD9, 0x003B, 0xFFC1, 0x002D,
0xFFDE, 0x002D, 0x0001, 0x002F, 0x0003, 0x0030, 0xFFF2, 0x0040,
0xFFEF, 0x0041, 0xFFF3, 0x003A, 0xFFF1, 0x003D, 0x000A, 0x0031,
0x001E, 0x001E, 0xFFFE, 0x0007, 0xFFF1, 0xFFEF, 0x0009, 0x0011,
0xFFFD, 0x003E, 0xFFD6, 0x001C, 0xFFC1, 0xFFEA, 0xFFC1, 0xFFF2,
0xFFD5, 0x0011, 0xFFCF, 0x000A, 0xFFAE, 0xFFF1, 0xFFA1, 0xFFEC,
0xFFA1, 0xFFF4, 0xFFB2, 0xFFED, 0xFFB7, 0xFFE9, 0xFFA1, 0xFFF0,
0xFF9D, 0xFFD9, 0xFFA0, 0xFFBA, 0xFF9A, 0xFFB5, 0xFF88, 0xFFB4,
0xFF87, 0xFFAC, 0xFF9B, 0xFFAC, 0xFF8B, 0xFFA0, 0xFF77, 0xFF83,
0xFF75, 0xFF86, 0xFF64, 0xFF91, 0xFF4E, 0xFF90, 0xFF3B, 0xFF8C,
0xFF3B, 0xFF82, 0xFF34, 0xFF92, 0xFF0A, 0xFF86, 0xFF00, 0xFF5A,
0xFF2B, 0xFF6C, 0xFF3B, 0xFFA1, 0xFF21, 0xFFAC, 0xFF1B, 0xFF71,
0xFF1C, 0xFF62, 0xFF07, 0xFFB9, 0xFEFC, 0xFFC9, 0xFEF5, 0xFF81,
0xFEFE, 0xFF79, 0xFF2B, 0xFFAB, 0xFF26, 0xFFAF, 0xFEF0, 0xFF96,
0xFEF3, 0xFFAD, 0xFF19, 0xFFB8, 0xFF10, 0xFF8B, 0xFF00, 0xFF56,
0xFEF8, 0xFF53, 0xFEE9, 0xFF78, 0xFEFD, 0xFF80, 0xFF0A, 0xFF88,
0xFEFA, 0xFFAE, 0xFEEA, 0xFFB3, 0xFEDC, 0xFFA4, 0xFEE3, 0xFFA5,
0xFED5, 0xFFB5, 0xFEAF, 0xFFB2, 0xFEAE, 0xFF78, 0xFEC2, 0xFF4F,
0xFECD, 0xFF6F, 0xFED7, 0xFF8D, 0xFEEB, 0xFF6F, 0xFEE1, 0xFF44,
0xFEC2, 0xFF41, 0xFEC5, 0xFF57, 0xFEB4, 0xFF5B, 0xFEA9, 0xFF54,
0xFED2, 0xFF5D, 0xFED6, 0xFF6C, 0xFED3, 0xFF6D, 0xFEFD, 0xFF62,
0xFF20, 0xFF53, 0xFF28, 0xFF52, 0xFF30, 0xFF59, 0xFF46, 0xFF30,
0xFF55, 0xFF03, 0xFF52, 0xFF16, 0xFF38, 0xFF34, 0xFF30, 0xFF45,
0xFF42, 0xFF4D, 0xFF2E, 0xFF4E, 0xFF2E, 0xFF64, 0xFF51, 0xFF91,
0xFF45, 0xFFB2, 0xFF49, 0xFFA0, 0xFF70, 0xFF9D, 0xFF73, 0xFFCF,
0xFF7C, 0xFFD4, 0xFF8A, 0xFFCA, 0xFF62, 0xFFC6, 0xFF79, 0xFFB1,
0xFFE0, 0xFFC0, 0xFFBB, 0xFFCB, 0xFF46, 0xFFC8, 0xFF46, 0xFFC9,
0xFF60, 0xFF98, 0xFF76, 0xFF7D, 0xFF9B, 0xFFB6, 0xFF95, 0xFFE3,
0xFFA6, 0xFFDA, 0xFFAE, 0xFFD4, 0xFFA2, 0xFFD8, 0xFFC1, 0xFFDB,
0xFFB7, 0xFFF8, 0xFFB2, 0x001A, 0xFFC3, 0x001C, 0xFF9D, 0x0018,
0xFFCA, 0x0027, 0x001D, 0x0038, 0x0009, 0x002F, 0xFFE9, 0x0026,
0xFFD4, 0x0037, 0xFFD8, 0x0034, 0xFFD8, 0x0026, 0xFFB1, 0x003A,
0xFFBD, 0x005C, 0xFFE4, 0x0067, 0xFFF9, 0x004D, 0x0003, 0x0042,
0xFFF5, 0x0044, 0x0017, 0x0031, 0x0060, 0x0051, 0x0063, 0x0074,
0x003B, 0x0056, 0x005E, 0x001E, 0x0097, 0x0007, 0x0076, 0x0059,
0x006C, 0x0099, 0x009E, 0x0062, 0x00AF, 0x0050, 0x009B, 0x0077,
0x005E, 0x0060, 0x0048, 0x0037, 0x0088, 0x0043, 0x0098, 0x0067,
0x0080, 0x0060, 0x00A2, 0x0035, 0x00BC, 0x0049, 0x00A4, 0x007D,
0x006D, 0x0061, 0x0029, 0x004C, 0x0041, 0x006C, 0x006A, 0x0064,
0x0048, 0x003F, 0x003F, 0x0045, 0x002B, 0x0077, 0x0006, 0x0081,
0x000D, 0x0063, 0x0021, 0x0058, 0x004D, 0x0042, 0x0051, 0x003E,
0x001B, 0x0054, 0x000E, 0x0053, 0x0031, 0x005C, 0x004D, 0x0055,
0x004D, 0x0037, 0x002C, 0x0042, 0x0022, 0x0068, 0x0046, 0x008F,
0x0047, 0x0094, 0x0046, 0x006C, 0x0070, 0x0088, 0x0092, 0x00DD,
0x00BC, 0x00DC, 0x00CE, 0x00CA, 0x00AC, 0x00E7, 0x00B1, 0x00E7,
0x00E6, 0x00EF, 0x00FC, 0x0108, 0x00DE, 0x0115, 0x00BC, 0x0130,
0x00BE, 0x011F, 0x00D4, 0x00E9, 0x00D8, 0x00D2, 0x00B9, 0x00DC,
0x009D, 0x010F, 0x00B0, 0x0136, 0x00C7, 0x0127, 0x00AA, 0x0110,
0x008A, 0x00FE, 0x00A0, 0x0108, 0x00C4, 0x00FA, 0x00DA, 0x00B0,
0x00E9, 0x009B, 0x00ED, 0x00B3, 0x00F2, 0x00AB, 0x00FD, 0x008B,
0x00F7, 0x0061, 0x00F8, 0x0054, 0x0108, 0x005D, 0x0118, 0x0052,
0x012D, 0x0033, 0x0113, 0x0045, 0x010F, 0x0089, 0x014E, 0x0072,
0x013A, 0x001B, 0x00ED, 0x0004, 0x00B1, 0x0038, 0x0085, 0x005E,
0x0099, 0x003E, 0x009F, 0x0047, 0x007D, 0x0063, 0x0078, 0x0047,
0x0055, 0x0054, 0x002F, 0x005D, 0x0029, 0x0027, 0x0010, 0xFFEE,
0xFFFA, 0xFFDF, 0xFFE3, 0x001C, 0xFFD6, 0x002D, 0x000A, 0xFFDA,
0x0013, 0xFFBC, 0xFFAB, 0xFFF3, 0xFF79, 0xFFF9, 0xFFA4, 0xFFC2,
0xFFC4, 0xFFD1, 0xFFE4, 0xFFF9, 0xFFC3, 0xFFF3, 0xFF8E, 0x0001,
0xFFD7, 0xFFE5, 0x0017, 0xFFBB, 0x001D, 0xFFE4, 0x0022, 0x000B,
0xFFFE, 0xFFF9, 0xFFFB, 0xFFC7, 0xFFE1, 0xFFAC, 0xFF85, 0xFFA1,
0xFF9B, 0xFF76, 0xFFF2, 0xFF5E, 0xFFFC, 0xFF7C, 0xFFCB, 0xFFA6,
0xFFBB, 0xFFB5, 0x0024, 0xFFA7, 0x0073, 0xFFB1, 0x0025, 0xFFF2,
0x000F, 0x0000, 0x006B, 0xFFC7, 0x0078, 0xFFBC, 0x0059, 0xFFD9,
0x0063, 0xFFDD, 0x005F, 0xFFB0, 0x0050, 0xFF75, 0x0042, 0xFF79,
0x003D, 0xFF9F, 0x0054, 0xFF8D, 0x0075, 0xFF6A, 0x0077, 0xFF66,
0x0074, 0xFF45, 0x0096, 0xFF3A, 0x0098, 0xFF76, 0x0083, 0xFF96,
0x0096, 0xFF82, 0x00A7, 0xFF69, 0x0097, 0xFF67, 0x004A, 0xFF89,
0x0014, 0xFF9E, 0x0067, 0xFFA4, 0x00BA, 0xFFC4, 0x00AC, 0xFFDA,
0x0093, 0xFFC9, 0x00C3, 0xFFA7, 0x011E, 0xFFA5, 0x0102, 0xFFC3,
0x00C3, 0xFFC7, 0x0100, 0xFFC9, 0x013F, 0xFFDE, 0x0111, 0xFFE8,
0x00A9, 0xFFFE, 0x0088, 0x0030, 0x0092, 0x004A, 0x0067, 0x003A,
0x0041, 0x0029, 0x0034, 0x0026, 0x0042, 0x003A, 0x002C, 0x001C,
0xFFEB, 0xFFC9, 0x0024, 0xFFC8, 0x008A, 0xFFF3, 0x008E, 0xFFEE,
0x0069, 0xFFDE, 0x0052, 0xFFCE, 0x0079, 0xFFB8, 0x008A, 0xFFBB,
0x0042, 0xFFB5, 0x003F, 0xFF9B, 0x006F, 0xFFA3, 0x0064, 0xFFA2,
0x004D, 0xFF76, 0x0044, 0xFF61, 0x005F, 0xFF7A, 0x0072, 0xFF97,
0x004B, 0xFF7F, 0x0066, 0xFF45, 0x0099, 0xFF2B, 0x0072, 0xFF4B,
0x0066, 0xFF6A, 0x0067, 0xFF5C, 0x003D, 0xFF45, 0x0059, 0xFF53,
0x006B, 0xFF77, 0x0019, 0xFF66, 0xFFFE, 0xFF57, 0x0021, 0xFF85,
0x0025, 0xFF8D, 0x0021, 0xFF5E, 0x0017, 0xFF55, 0x0011, 0xFF7D,
0x0017, 0xFF95, 0x0023, 0xFF91, 0x0047, 0xFF85, 0x0049, 0xFF80,
0x000A, 0xFF84, 0xFFF5, 0xFF56, 0x0041, 0xFF13, 0x0063, 0xFEFE,
0x000D, 0xFEF4, 0xFFD7, 0xFF0A, 0xFFEC, 0xFF4A, 0xFFDC, 0xFF53,
0xFFB3, 0xFF21, 0xFF8C, 0xFF1D, 0xFF82, 0xFF5A, 0xFFA2, 0xFF60,
0xFF9C, 0xFF26, 0xFF9D, 0xFF25, 0xFFBD, 0xFF3D, 0xFFB8, 0xFF1A,
0xFFB6, 0xFF20, 0xFFA9, 0xFF60, 0xFF8A, 0xFF45, 0xFF95, 0xFF0F,
0xFF8A, 0xFF1E, 0xFF54, 0xFF2B, 0xFF57, 0xFF11, 0xFF65, 0xFF22,
0xFF2F, 0xFF65, 0xFF2B, 0xFF26, 0xFF54, 0xFEB3, 0xFF3A, 0xFEE6,
0xFF0D, 0xFF1D, 0xFF0B, 0xFED4, 0xFEFA, 0xFE75, 0xFEAA, 0xFE62,
0xFE8E, 0xFE98, 0xFE8D, 0xFE63, 0xFE2E, 0xFE11, 0xFE46, 0xFE4E,
0xFED0, 0xFE59, 0xFECE, 0xFE5B, 0xFE9D, 0xFE90, 0xFE7E, 0xFE7E,
0xFE8C, 0xFE9A, 0xFECA, 0xFE80, 0xFED8, 0xFE37, 0xFF2B, 0xFE57,
0xFF58, 0xFE46, 0xFF18, 0xFE90, 0xFF48, 0xFEFC, 0xFF71, 0xFED5,
0xFF7F, 0xFF05, 0xFFA5, 0xFF0D, 0xFF7D, 0xFEDE, 0xFF6C, 0xFF11,
0xFF7B, 0xFF0E, 0xFF89, 0xFF17, 0xFF70, 0xFF3C, 0xFF28, 0xFF20,
0xFF08, 0xFEED, 0xFEAD, 0xFEAA, 0xFE68, 0xFEAD, 0xFECE, 0xFEC8,
0xFF0B, 0xFEB1, 0xFEFF, 0xFEFD, 0xFF0E, 0xFEEC, 0xFF0B, 0xFEB1,
0xFF1B, 0xFF53, 0xFEE5, 0xFF2C, 0xFE63, 0xFE77, 0xFE36, 0xFE73,
0xFE1C, 0xFE86, 0xFE05, 0xFEAC, 0xFDE8, 0xFE91, 0xFDF1, 0xFE81,
0xFE77, 0xFEC9, 0xFE97, 0xFE98, 0xFE63, 0xFEBF, 0xFEA3, 0xFF75,
0xFF23, 0xFFAE, 0xFF7E, 0xFFDD, 0xFF8B, 0xFFFE, 0xFF52, 0xFF84,
0xFEBF, 0xFEF1, 0xFE37, 0xFE83, 0xFE12, 0xFEC1, 0xFE33, 0xFED8,
0xFE8B, 0xFE2A, 0xFEE5, 0xFEFE, 0xFF53, 0xFFDF, 0xFF74, 0xFF57,
0xFF7C, 0xFF81, 0xFF78, 0xFF6D, 0xFE8B, 0xFF09, 0xFE00, 0xFEB5,
0xFE16, 0xFEE6, 0xFE62, 0x0018, 0xFF09, 0xFF46, 0xFEF3, 0xFEEA,
0xFF26, 0xFFE1, 0xFF30, 0xFF04, 0xFEDB, 0xFF04, 0xFF35, 0xFFD5,
0xFEF5, 0x0000, 0xFF23, 0xFFB5, 0xFFA8, 0xFF52, 0x0000, 0x0049,
0x0013, 0xFFF9, 0xFE36, 0xFDF7, 0xFDFA, 0xFEE3, 0xFFAF, 0xFFD6,
0xFF5F, 0xFE24, 0xFF4A, 0xFE9E, 0xFFA7, 0xFFDF, 0xFFDC, 0x0049,
0x0116, 0x00D1, 0x0199, 0x0105, 0x0159, 0x0157, 0xFF51, 0xFEF0,
0xFCFF, 0xFD90, 0xFDC5, 0xFF2E, 0xFE2E, 0xFDB1, 0xFE5B, 0xFD6A,
0x002F, 0xFFDC, 0x0132, 0x00EF, 0x01E2, 0x00DE, 0x022B, 0xFFFE,
0x022E, 0x0194, 0x0141, 0x01F2, 0xFF9C, 0xFF9B, 0x0121, 0xFFE9,
0x009F, 0x0021, 0xFE03, 0xFFE5, 0xFFCA, 0xFFF9, 0x017C, 0x0006,
0x01BA, 0x00B3, 0x0066, 0xFF5D, 0xFEFD, 0xFE7E, 0x005A, 0xFFEC,
0xFF51, 0x0108, 0x00B9, 0x024C, 0x0455, 0x03AB, 0x0345, 0x02FD,
0x01F5, 0x0042, 0xFED4, 0xFF60, 0xFE5C, 0x0047, 0x0116, 0xFFC6,
0xFF5C, 0xFFF3, 0xFFFF, 0x0116, 0x00E5, 0x00E6, 0x0190, 0x0170,
0x041F, 0x0333, 0x022C, 0x0434, 0x0325, 0x03A5, 0x03EB, 0x01C5,
0xFFDE, 0x0183, 0xFE80, 0x01D6, 0xFE2D, 0x0025, 0x0188, 0xFFBC,
0x0393, 0x01FC, 0x010B, 0x0249, 0x0140, 0xFFDC, 0x00D5, 0xFE38,
0xFFCE, 0x0034, 0xFF1A, 0x028F, 0xFF2B, 0x0037, 0x0206, 0x01EE,
0x0229, 0x0382, 0xFFE3, 0xFFF9, 0x013A, 0x00E8, 0x02BD, 0x0104,
0x0211, 0x0274, 0x0189, 0x0287, 0xFFDD, 0xFF79, 0x00A7, 0x01C5,
0x0213, 0x0252, 0x01D8, 0x0407, 0x02FC, 0x0460, 0x014D, 0x0013,
0xFF74, 0xFFE6, 0xFDD3, 0xFF8D, 0xFBC0, 0xFDAE, 0xFDBA, 0xFE08,
0x0013, 0x015A, 0x0405, 0x050F, 0x0638, 0x040B, 0x02B3, 0x00CC,
0x01B2, 0x0106, 0x01D7, 0x0190, 0x01BF, 0x00BD, 0x019D, 0x020C,
0xFEEC, 0x026B, 0x0153, 0x0304, 0x0417, 0x02DB, 0xFF63, 0xFD35,
0xFC40, 0xFC9F, 0xFEA8, 0xFFDB, 0x0172, 0xFEF7, 0xFEDC, 0x00E2,
0xFD83, 0x0120, 0x02E6, 0x014F, 0x0608, 0x0525, 0x05AE, 0x0496,
0x032D, 0x02AF, 0x01CC, 0x0189, 0x032E, 0x027D, 0xFEFC, 0x006D,
0xFBAA, 0xFC4D, 0xFF1D, 0x0030, 0x0017, 0x019B, 0xFCD0, 0xFDC3,
0xFA1F, 0xFA99, 0xFCE6, 0xFB7C, 0x019A, 0xFF0B, 0xFDEE, 0xFD61,
0xFADA, 0xFF11, 0x0257, 0x0442, 0x07D7, 0x0467, 0x0899, 0x050A,
0x0772, 0x083C, 0x0611, 0x0801, 0x0965, 0x0564, 0x072A, 0x05B5,
0x012C, 0x0368, 0xFDC0, 0xFF55, 0xFB47, 0xFDAA, 0xFC77, 0xFDBC,
0xF92A, 0xFE65, 0xF73B, 0xF948, 0xFBA2, 0xF82C, 0xFAF6, 0xFCF0,
0xF98D, 0xFCB0, 0xFDA7, 0xFD15, 0x050A, 0x0289, 0x082C, 0x07ED,
0x05EC, 0x04E9, 0x0359, 0x00C6, 0x0043, 0x02FB, 0x012E, 0x0582,
0x0402, 0x0275, 0x0271, 0xFF56, 0x00AC, 0x04AB, 0xFC03, 0xFF34,
0xF6A1, 0xF8A7, 0xFC6B, 0x00A0, 0x008C, 0xFFDF, 0xFE73, 0xFC86,
0x0190, 0x0173, 0x0473, 0x0863, 0x06B6, 0x0581, 0x053F, 0xFCED,
0x0357, 0x052B, 0x03C0, 0x09DF, 0xFA8E, 0xFB49, 0xF776, 0xF6ED,
0xFDB6, 0x0176, 0xFCCB, 0x0238, 0xFD07, 0xF9FD, 0xFF19, 0xFA4F,
0xFC56, 0x002F, 0xF66C, 0xF9C7, 0xF471, 0xF18E, 0xFC47, 0xFCDF,
0xFFEF, 0x02C7, 0xFF09, 0xFCF7, 0x05A5, 0x0266, 0x0AB9, 0x06C0,
0x0B1B, 0x0751, 0x09A3, 0x0814, 0x0967, 0x07BF, 0x093C, 0x0B53,
0x0382, 0x06D8, 0x02DF, 0x0418, 0x0348, 0x06C9, 0xFB8C, 0xFB76,
0xF510, 0xF599, 0xF5B1, 0xFB4A, 0xF907, 0xF8C0, 0xF5CC, 0xF367,
0xF43C, 0xF6C7, 0xFACF, 0x00DA, 0xFE02, 0xFDB2, 0x00D4, 0xF6D7,
0x0899, 0x0453, 0x0829, 0x0CB3, 0xFF7F, 0xFF8C, 0xFBDF, 0xF855,
0xFE5C, 0x028E, 0x017E, 0x049F, 0xFD7D, 0xFD3E, 0xFD49, 0xFE62,
0x02E7, 0x0298, 0x0159, 0xFF77, 0x0352, 0xF9B5, 0x0448, 0x02AD,
0x0608, 0x0D69, 0x0E89, 0x0C3D, 0x0AA4, 0x07CE, 0x04B2, 0x0420,
0x0445, 0x033C, 0x00CD, 0xFFF1, 0xFDB8, 0xFF51, 0xF6D9, 0xFC8B,
0xF5A2, 0xF5AA, 0xFB11, 0xF7D7, 0xF79C, 0xFA95, 0xF485, 0xF74E,
0xF6A2, 0xF5AD, 0xF79B, 0xFB10, 0xF663, 0xF80D, 0xF3D2, 0xEF7F,
0xFB48, 0xFA49, 0x0732, 0x07D3, 0x088D, 0x0913, 0x0ADC, 0x05C8,
0x1019, 0x0616, 0x1051, 0x0E69, 0x0C77, 0x0D86, 0x0474, 0x0683,
0x044D, 0x080A, 0x0A2B, 0x0886, 0x0730, 0x0617, 0xFFB1, 0x0209,
0xF678, 0xFB78, 0xF0C2, 0xF558, 0xF32B, 0xF119, 0xF314, 0xF287,
0xF4DA, 0xF63D, 0xFD37, 0xFAE9, 0x0266, 0xFFD0, 0x01BE, 0xFEA0,
0x02A7, 0xFE29, 0x0743, 0x0414, 0xFFCC, 0x03E6, 0xF3D8, 0xF8DD,
0xF728, 0xF783, 0xFD0E, 0xFBCB, 0xFB18, 0xFB2E, 0xFD45, 0xFF6D,
0x0746, 0xFFC9, 0x06E9, 0x0246, 0x009B, 0x032F, 0x0348, 0x004F,
0x04B3, 0x088E, 0x0A15, 0x0E75, 0x1299, 0x0FFF, 0x0DDE, 0x09DE,
0x0553, 0x0224, 0xFF6D, 0x0271, 0xFC10, 0xFF14, 0xFC7A, 0xFC7D,
0xF8BD, 0xF8EB, 0xF2A5, 0xF48D, 0xEFE0, 0xF3E1, 0xF179, 0xF2CE,
0xF625, 0xF3C4, 0xF669, 0xF693, 0xF2E4, 0xF681, 0xF2EC, 0xF345,
0xF566, 0xF7B6, 0xFDDF, 0xFFBC, 0x0723, 0x04E3, 0x0A91, 0x0A5F,
0x146E, 0x0911, 0x1987, 0x0D4B, 0x1230, 0x130B, 0x0B98, 0x0C2F,
0x05CF, 0x0A2D, 0x071E, 0x0A8F, 0x08FD, 0x073C, 0xFEE7, 0x01FF,
0xF3E5, 0xF8D6, 0xEC4F, 0xF2AF, 0xED4E, 0xEDDA, 0xF683, 0xF058,
0xF818, 0xF93B, 0xF87E, 0xFBF0, 0xFFCD, 0xFF2E, 0x02FD, 0xFFB8,
0x0195, 0xFE06, 0x0488, 0x0293, 0x02BC, 0x02E1, 0xF81A, 0xFB1D,
0xF5E1, 0xF9C5, 0xFB10, 0xFDBE, 0xFBD1, 0xFB18, 0xFD10, 0x00A2,
0x04DA, 0x044F, 0x06B1, 0xFE07, 0x00CC, 0xFF43, 0x020A, 0x007D,
0x040A, 0x060D, 0x083D, 0x0C4F, 0x12CC, 0x0EF3, 0x1191, 0x0F8D,
0x0936, 0x0790, 0x0196, 0x025F, 0xF8E9, 0xFD82, 0xF834, 0xF833,
0xF888, 0xF812, 0xF4D8, 0xF739, 0xF2BF, 0xF56A, 0xF276, 0xF4AF,
0xF422, 0xF618, 0xF3C0, 0xF6AB, 0xEEAD, 0xF222, 0xED77, 0xEBCB,
0xF32C, 0xF324, 0xF98B, 0x0167, 0x01D0, 0x0378, 0x096D, 0x0847,
0x14A5, 0x0E27, 0x1D24, 0x0FA8, 0x120D, 0x130D, 0x07C3, 0x0D33,
0x06E3, 0x0987, 0x054F, 0x08D3, 0x04CD, 0x0408, 0xFF4C, 0x0308,
0xF8D2, 0xFD49, 0xF0D7, 0xF53B, 0xE75F, 0xEEB0, 0xEE79, 0xEBA5,
0xF8FB, 0xF1B9, 0xF748, 0xF781, 0xF9B9, 0xFDB6, 0x02B5, 0xFF9D,
0x06C9, 0xFC11, 0x0824, 0x02D6, 0x043C, 0x0765, 0xF944, 0xFC81,
0xF46F, 0xF605, 0xF620, 0xFC3B, 0xF982, 0xFAE2, 0xFB1C, 0xFB80,
0xFED7, 0x0144, 0x06E0, 0x0134, 0x0437, 0x0589, 0x00A4, 0x0018,
0x027C, 0xFF6B, 0x0367, 0x0B99, 0x0E81, 0x1033, 0x1448, 0x103D,
0x0BED, 0x072B, 0x0582, 0x021B, 0xFDED, 0x00B0, 0xF9BF, 0xFAF7,
0xFA9E, 0xFA24, 0xF751, 0xF736, 0xF390, 0xF5E4, 0xF1DB, 0xF6E8,
0xF20C, 0xF3CF, 0xF327, 0xF328, 0xEFC8, 0xF555, 0xEC41, 0xEEC7,
0xF1CA, 0xEC85, 0xF929, 0xFCFB, 0x01C8, 0x05BD, 0x0C61, 0x0859,
0x1383, 0x0BE6, 0x1B60, 0x0BB9, 0x1B15, 0x165F, 0x1180, 0x152A,
0x0882, 0x0A3A, 0x04E2, 0x0C47, 0x08D1, 0x0C1F, 0x048F, 0x07B2,
0xFA22, 0xFED0, 0xF4C3, 0xF71F, 0xEC1C, 0xF1BB, 0xEAE2, 0xE7F9,
0xF454, 0xEC2D, 0xF8A9, 0xF7DD, 0xFB5F, 0xFD53, 0x01AF, 0x01F8,
0x05D4, 0xFF86, 0x07BF, 0x0072, 0x06EC, 0x0887, 0xFBF6, 0x01B1,
0xF37A, 0xF53B, 0xF712, 0xFB09, 0xFA16, 0xFEAA, 0xFAC1, 0xFD42,
0x00B2, 0x04FA, 0x0A26, 0x0205, 0x08E1, 0x028D, 0x0395, 0x0535,
0x0561, 0x0246, 0x0540, 0x0B4A, 0x0EA1, 0x12BC, 0x1ADF, 0x15E9,
0x1365, 0x0DF5, 0x08EB, 0x040D, 0x027A, 0x03EE, 0xFBA8, 0xFD4A,
0xF944, 0xF8BB, 0xF694, 0xF5C5, 0xF247, 0xF1CC, 0xEFA1, 0xF460,
0xF034, 0xF4A9, 0xF283, 0xF1F0, 0xF18F, 0xF37B, 0xECBB, 0xEF86,
0xEDD1, 0xE97B, 0xF489, 0xF89B, 0xFF3D, 0x0785, 0x0F09, 0x0962,
0x1795, 0x1028, 0x1E37, 0x1115, 0x20AE, 0x160A, 0x16C3, 0x1B6E,
0x0D30, 0x12B3, 0x06C8, 0x0EC7, 0x0769, 0x0A56, 0x075E, 0x0744,
0xFBAC, 0x032D, 0xF159, 0xF5C0, 0xE9E9, 0xEE40, 0xE9AE, 0xE6D3,
0xF4A7, 0xE8C0, 0xF851, 0xF5CB, 0xF97B, 0xFD1E, 0x052A, 0x044F,
0x0C31, 0x01E7, 0x0A58, 0xFF71, 0x0858, 0x07C6, 0xFDEF, 0x03D5,
0xF1B0, 0xF657, 0xF254, 0xF93B, 0xF7B0, 0xFFB3, 0xF9C2, 0xFA8D,
0xFB15, 0x00CD, 0x0402, 0x0209, 0x0996, 0xFEB6, 0x041D, 0x0436,
0x0523, 0x02C9, 0x06C1, 0x09CD, 0x0BE2, 0x14EA, 0x1C95, 0x1B9F,
0x1B40, 0x14D9, 0x0C4A, 0x0674, 0x0408, 0x0666, 0xFB19, 0xFE98,
0xF6AC, 0xF5EB, 0xF5E0, 0xF6B2, 0xF1D0, 0xF24C, 0xEED2, 0xF397,
0xED62, 0xF3EA, 0xEED0, 0xEEF6, 0xF277, 0xF25F, 0xECC5, 0xEDAB,
0xE61F, 0xE22A, 0xEE48, 0xF0E1, 0xFDB0, 0x0887, 0x0E03, 0x0C05,
0x16B4, 0x0ED8, 0x1EDA, 0x12C7, 0x261A, 0x1696, 0x1963, 0x1B9A,
0x0BDA, 0x129B, 0x06B3, 0x0DA0, 0x0452, 0x0C1C, 0x06BD, 0x07D5,
0xFDE9, 0x03DA, 0xEFAE, 0xF700, 0xE920, 0xEF99, 0xE6BD, 0xE5BD,
0xEE59, 0xE15B, 0xF703, 0xF1D9, 0xF9A0, 0xFCCB, 0x03BC, 0x034E,
0x0E58, 0x03AC, 0x0E57, 0x0041, 0x0C7A, 0x08FA, 0x03A7, 0x07B7,
0xF1A0, 0xF59F, 0xEB94, 0xF2B8, 0xF0E9, 0xFD84, 0xF3F5, 0xF922,
0xF6E5, 0xFB8A, 0x00D0, 0x02A1, 0x09AC, 0xFEEB, 0x0557, 0x010E,
0x02FF, 0xFFBC, 0x060B, 0x07AF, 0x0AF4, 0x159D, 0x1BD8, 0x1A55,
0x20F4, 0x167E, 0x12C6, 0x0A28, 0x063E, 0x07C7, 0xFAD2, 0x005F,
0xF62C, 0xF44F, 0xF6C5, 0xF5D3, 0xF19F, 0xF368, 0xEA29, 0xF055,
0xE819, 0xF1A5, 0xEB4B, 0xEDCF, 0xEE82, 0xEF2D, 0xEDB0, 0xEDEF,
0xE8A3, 0xE140, 0xEC16, 0xEA14, 0xFA88, 0x0720, 0x0C2D, 0x0E3F,
0x180E, 0x0D66, 0x20FF, 0x1353, 0x29C5, 0x14BD, 0x1EF9, 0x1B8E,
0x0D0B, 0x1649, 0x06C4, 0x0C43, 0x0636, 0x0C5A, 0x080B, 0x08C2,
0x0073, 0x043C, 0xF200, 0xF77B, 0xE7F1, 0xEE8A, 0xE162, 0xE636,
0xE8B4, 0xDD74, 0xF67C, 0xED30, 0xFA66, 0xFE3C, 0x023F, 0x0639,
0x0CF1, 0x06CE, 0x0DC6, 0x0098, 0x0D5E, 0x06D3, 0x0712, 0x091E,
0xF31E, 0xF6B2, 0xE8B9, 0xEC0F, 0xEF68, 0xF980, 0xF485, 0xFC45,
0xF68B, 0xF9C0, 0xFEE4, 0x01A8, 0x0956, 0xFEFB, 0x07F3, 0x0002,
0x0314, 0x027C, 0x04CA, 0x07C0, 0x0A4E, 0x1681, 0x1E26, 0x1E94,
0x2A63, 0x1C78, 0x1B56, 0x0F17, 0x0C0A, 0x08D9, 0xFE34, 0x0125,
0xF233, 0xF058, 0xF340, 0xF021, 0xF33E, 0xF267, 0xEB2F, 0xEF81,
0xE657, 0xF109, 0xE96C, 0xEE4C, 0xED13, 0xEE9E, 0xEBE0, 0xEE2E,
0xE57C, 0xE199, 0xE675, 0xE378, 0xF433, 0x013D, 0x0860, 0x10F5,
0x19A9, 0x0CDA, 0x2444, 0x15CA, 0x2F31, 0x1A59, 0x288D, 0x1A15,
0x1275, 0x1788, 0x0752, 0x0E36, 0x0531, 0x0CCC, 0x06CB, 0x08AB,
0x0457, 0x0518, 0xF7A3, 0xFD04, 0xE91E, 0xF053, 0xDE4B, 0xE414,
0xE1B5, 0xD8B8, 0xF21E, 0xE884, 0xFA92, 0xFDB9, 0xFF3D, 0x032A,
0x093C, 0x054A, 0x0F23, 0x027F, 0x106C, 0x0603, 0x0AC2, 0x0AB1,
0xF696, 0xFB64, 0xE678, 0xE8CB, 0xEA10, 0xF184, 0xF0BA, 0xFAF7,
0xF283, 0xF772, 0xFA01, 0x00E5, 0x07CC, 0x0098, 0x0AD2, 0xFBFA,
0x0440, 0x00EC, 0x039A, 0x07DA, 0x073B, 0x17C0, 0x1880, 0x1FDB,
0x2AC2, 0x1E7A, 0x21B8, 0x14FF, 0x11B5, 0x0B4D, 0x0183, 0x03D2,
0xEFE5, 0xF0E0, 0xF0E6, 0xECCD, 0xF4F3, 0xF2EF, 0xEBAB, 0xECA7,
0xE373, 0xEBE8, 0xE48B, 0xECE3, 0xE8B5, 0xEC7F, 0xE9F5, 0xEC8F,
0xE43E, 0xE1C1, 0xE214, 0xE01C, 0xEE72, 0xFBAC, 0x035D, 0x1390,
0x16BD, 0x0FC6, 0x2149, 0x14E5, 0x2CBC, 0x1B46, 0x2C53, 0x15E0,
0x155D, 0x16EF, 0x05D9, 0x10A0, 0x01FA, 0x0B72, 0x02BE, 0x0942,
0x057B, 0x05E2, 0xF9A3, 0xFE8C, 0xE7CF, 0xF16B, 0xDCE5, 0xE53E,
0xDBDF, 0xD595, 0xEB16, 0xE07D, 0xF9A6, 0xFD51, 0x014C, 0x0617,
0x0B4A, 0x0646, 0x10D1, 0x0485, 0x11C1, 0x05EC, 0x0C90, 0x094D,
0xF66D, 0xFC35, 0xE195, 0xE68A, 0xE422, 0xEAD4, 0xEBF0, 0xFBEA,
0xEDAD, 0xF66C, 0xF44F, 0xF99A, 0x01ED, 0x0117, 0x0874, 0xF90C,
0x0289, 0xFB28, 0x002E, 0x0371, 0x052E, 0x12CF, 0x15FD, 0x2180,
0x2BBF, 0x20F1, 0x295F, 0x1876, 0x18B4, 0x10C8, 0x07B3, 0x07A1,
0xF2B3, 0xF03A, 0xEC1B, 0xE5E6, 0xF12B, 0xF127, 0xEBAC, 0xF008,
0xE1AA, 0xEAE5, 0xE1E0, 0xEB5F, 0xE668, 0xEBA2, 0xE73E, 0xEB5D,
0xE1AB, 0xE1D8, 0xDB8B, 0xDC8D, 0xE7D3, 0xF45F, 0x0142, 0x12F7,
0x1469, 0x0F8D, 0x1FA2, 0x1126, 0x2C17, 0x2077, 0x2F47, 0x1859,
0x1C08, 0x138E, 0x0943, 0x0FFF, 0x0271, 0x0B6D, 0xFFBA, 0x0B43,
0x01D5, 0x0833, 0xFD41, 0x0383, 0xEDCD, 0xF57A, 0xDEF2, 0xE7A1,
0xD843, 0xD6AE, 0xE2E0, 0xD9A4, 0xF61D, 0xFAE9, 0x0338, 0x0AC4,
0x0BD5, 0x06E0, 0x12CD, 0x04E0, 0x1541, 0x0752, 0x0E39, 0x0A13,
0xFBA1, 0xFF19, 0xE572, 0xE73A, 0xE119, 0xE479, 0xE97A, 0xF969,
0xEBE6, 0xF8D0, 0xF16B, 0xF8F3, 0x0063, 0x0633, 0x0A0A, 0xFCBB,
0x045B, 0xF8E9, 0xFFB7, 0x042B, 0x0583, 0x1457, 0x143F, 0x2353,
0x2BD4, 0x231E, 0x334F, 0x1E5D, 0x23AE, 0x1593, 0x0DAD, 0x09FC,
0xF4EF, 0xF484, 0xEB8D, 0xE388, 0xF218, 0xEEB3, 0xEDE6, 0xF1B1,
0xE23C, 0xEABC, 0xE0ED, 0xEE2E, 0xE617, 0xEDA2, 0xE7C0, 0xEBEC,
0xE434, 0xE582, 0xDC90, 0xDD70, 0xE2C1, 0xED07, 0xFE01, 0x10C0,
0x15EB, 0x1757, 0x2115, 0x0F50, 0x2E61, 0x1EDD, 0x35DC, 0x1C99,
0x233E, 0x13D6, 0x0B2F, 0x10A9, 0x019A, 0x09A9, 0xFF89, 0x0B83,
0x02CB, 0x098E, 0x007C, 0x0565, 0xF49C, 0xFAA4, 0xE571, 0xEBFA,
0xD6B0, 0xDA33, 0xDE40, 0xD633, 0xF743, 0xF69F, 0x06CC, 0x0ED1,
0x0D86, 0x0AE6, 0x1363, 0x0673, 0x17F8, 0x0977, 0x12B2, 0x0AAF,
0x00E8, 0xFFFD, 0xE8B4, 0xE9D0, 0xDCF5, 0xE025, 0xE3D4, 0xF4C1,
0xEA15, 0xFD2F, 0xEFC9, 0xF640, 0xFE95, 0x0438, 0x0BFB, 0x024F,
0x07A7, 0xF778, 0xFFCB, 0x0288, 0x0514, 0x1465, 0x13A7, 0x2601,
0x2ADD, 0x2749, 0x36EE, 0x1FE3, 0x2AFB, 0x1A70, 0x1479, 0x0ED2,
0xF84B, 0xF67A, 0xE940, 0xDF92, 0xF11E, 0xE9BE, 0xF0DE, 0xF58F,
0xE280, 0xECD3, 0xDFDD, 0xECCF, 0xE844, 0xF078, 0xE9BD, 0xEEF6,
0xE40E, 0xE67D, 0xDD8D, 0xDE08, 0xE06B, 0xE972, 0xF6AC, 0x0C10,
0x130E, 0x1D0D, 0x2461, 0x100F, 0x2F09, 0x1D1D, 0x35C6, 0x2481,
0x2855, 0x1322, 0x0E9A, 0x0ECB, 0x023A, 0x0C9D, 0xFF34, 0x0EB9,
0x0067, 0x0C2B, 0x02B5, 0x0667, 0xFA22, 0x007C, 0xEA69, 0xF0B7,
0xD989, 0xDB03, 0xDA2E, 0xD02A, 0xF2D6, 0xEE80, 0x06C1, 0x1046,
0x0EB3, 0x0D08, 0x1579, 0x05AB, 0x1CBE, 0x0AF6, 0x17C6, 0x0DE2,
0x038A, 0x03CB, 0xEC57, 0xEE47, 0xDE11, 0xDF4D, 0xDFC3, 0xEE14,
0xE4FA, 0xFEBB, 0xEB65, 0xF714, 0xFA7E, 0x0278, 0x0AD3, 0x0863,
0x0C00, 0xF60D, 0x01E0, 0xFDAC, 0x02BB, 0x131C, 0x1097, 0x258B,
0x2813, 0x2AF9, 0x39E8, 0x23B3, 0x328E, 0x1E7F, 0x1C74, 0x1301,
0xFE24, 0xFBA2, 0xE69C, 0xDF18, 0xEBFA, 0xE202, 0xF2BF, 0xF6A3,
0xE514, 0xF01D, 0xDD09, 0xEA64, 0xE582, 0xF0FD, 0xEA36, 0xF09A,
0xE4EF, 0xE6CA, 0xDE98, 0xDCEA, 0xDF3E, 0xE440, 0xF111, 0x0356,
0x0C80, 0x1CF9, 0x2028, 0x11FD, 0x2D4D, 0x169A, 0x3692, 0x25D9,
0x2C8A, 0x1532, 0x1338, 0x0C8A, 0x04D3, 0x0C2E, 0xFF65, 0x0E0A,
0xFD71, 0x0FE1, 0x0385, 0x0A03, 0x0111, 0x038F, 0xF063, 0xF509,
0xDAEA, 0xDD99, 0xD39F, 0xCC74, 0xEB9F, 0xE3AE, 0x0759, 0x0C98,
0x10A1, 0x11AD, 0x142D, 0x05CF, 0x1BAE, 0x086D, 0x1A22, 0x0DD3,
0x06D5, 0x04C7, 0xEFCA, 0xF080, 0xDDCF, 0xDE56, 0xDA64, 0xE5FC,
0xE12E, 0xFD94, 0xE815, 0xF90A, 0xF67E, 0xFC5B, 0x079A, 0x0A15,
0x0B0F, 0xF64E, 0x0205, 0xF676, 0xFFF3, 0x0E44, 0x0C38, 0x2105,
0x22DC, 0x2D96, 0x387C, 0x27DA, 0x3998, 0x213E, 0x2584, 0x17BA,
0x04CC, 0x0097, 0xE6FE, 0xE12E, 0xE5E8, 0xD980, 0xF235, 0xF29F,
0xE962, 0xF527, 0xDB89, 0xE853, 0xE350, 0xEEA1, 0xECC3, 0xF17C,
0xE5CE, 0xE4B9, 0xDC9F, 0xDA36, 0xDB5A, 0xDF56, 0xEAAE, 0xF95F,
0x0673, 0x1AC2, 0x1BDB, 0x157B, 0x2B21, 0x1225, 0x35C7, 0x2835,
0x3016, 0x17F1, 0x187B, 0x0754, 0x0354, 0x0A85, 0xFD0F, 0x0C82,
0xFCBC, 0x104A, 0x00A2, 0x0B90, 0x022B, 0x0788, 0xF655, 0xFB65,
0xE082, 0xE27B, 0xD05C, 0xCC21, 0xE05F, 0xD7C5, 0x02E9, 0x071E,
0x11E1, 0x184F, 0x1349, 0x0702, 0x1C15, 0x079B, 0x1F5C, 0x0FF8,
0x0DC4, 0x070A, 0xF4F2, 0xF34A, 0xE081, 0xDE92, 0xDA5A, 0xDF29,
0xE086, 0xF8AC, 0xE5CF, 0xFB4F, 0xF0A3, 0xF6F0, 0x0352, 0x08DA,
0x0BEF, 0xFBB7, 0x0314, 0xEF5B, 0xFE15, 0x0705, 0x084B, 0x1F0E,
0x1C33, 0x2D6C, 0x3451, 0x281F, 0x3C9D, 0x21A2, 0x2CF5, 0x1D0F,
0x0F3B, 0x07CA, 0xEC93, 0xE68E, 0xE282, 0xD70F, 0xF1B3, 0xEF75,
0xEFA1, 0xFA98, 0xDFCF, 0xEA78, 0xE05D, 0xEC67, 0xE934, 0xF36E,
0xE5E8, 0xE706, 0xDCEF, 0xD932, 0xDA29, 0xDD39, 0xE327, 0xF192,
0xFE3D, 0x1556, 0x195F, 0x1C83, 0x2676, 0x0F34, 0x3183, 0x225B,
0x331C, 0x1C47, 0x1E89, 0x05E5, 0x082E, 0x0984, 0xFEB2, 0x0BE1,
0xFA45, 0x0FEA, 0xFE1F, 0x0EEA, 0x0420, 0x0908, 0xFBAB, 0xFE22,
0xE548, 0xE5CE, 0xCF91, 0xCDA7, 0xD83F, 0xD04E, 0xFA9A, 0xFBAF,
0x114C, 0x1C62, 0x15AC, 0x0E16, 0x1A44, 0x0405, 0x1FF4, 0x0FC7,
0x1234, 0x0A43, 0xF9BB, 0xF555, 0xE532, 0xE25E, 0xD8AA, 0xDB7F,
0xDA24, 0xF313, 0xE0B9, 0x00EF, 0xED08, 0xF591, 0xFED7, 0x04FA,
0x08B4, 0xFF8D, 0x0533, 0xE955, 0xFEB9, 0xFFE4, 0x0480, 0x1AF5,
0x17FD, 0x2D4F, 0x311C, 0x2E1F, 0x4007, 0x249E, 0x3452, 0x207B,
0x14D8, 0x0AFE, 0xF160, 0xEBFB, 0xDFD2, 0xD483, 0xECD1, 0xE1B8,
0xF172, 0xFABF, 0xDF4B, 0xEFA8, 0xDCE0, 0xE7B2, 0xE8B6, 0xF0E1,
0xE6C1, 0xE89A, 0xDCF3, 0xD86D, 0xD8D5, 0xD9E1, 0xDF57, 0xEADD,
0xF66C, 0x0EA5, 0x1273, 0x20C0, 0x257B, 0x0F39, 0x3102, 0x1D0D,
0x3341, 0x238D, 0x2300, 0x078F, 0x0A9C, 0x0486, 0xFF30, 0x0A57,
0xFA00, 0x0F96, 0xF9A6, 0x0FF3, 0x0286, 0x098A, 0xFFD9, 0x03CD,
0xEA13, 0xEB74, 0xCF62, 0xCF02, 0xCF9B, 0xCC07, 0xF38B, 0xF04E,
0x10BD, 0x1AB2, 0x14D6, 0x1361, 0x173D, 0x01C8, 0x1F83, 0x0DD4,
0x15C9, 0x0AD8, 0xFB1F, 0xF448, 0xE541, 0xE3D8, 0xD7F7, 0xDA5C,
0xD62E, 0xE958, 0xDB8F, 0xFE85, 0xE623, 0xF590, 0xF8D4, 0xFF5B,
0x0708, 0x051F, 0x04BC, 0xEA92, 0xFD93, 0xF9CE, 0x03D5, 0x1A1C,
0x16BB, 0x2CD0, 0x2DAD, 0x304A, 0x3EE9, 0x26B5, 0x3C1C, 0x263B,
0x2109, 0x119D, 0xF876, 0xEECF, 0xDD79, 0xD4A1, 0xE5DC, 0xDAA1,
0xF1E1, 0xFA27, 0xE3C6, 0xF52E, 0xD9BC, 0xE512, 0xE4B1, 0xEF32,
0xE776, 0xEBA7, 0xDBB2, 0xD89C, 0xD6AE, 0xD9DB, 0xDC1B, 0xE93F,
0xF094, 0x0707, 0x0E76, 0x2119, 0x22C3, 0x11A2, 0x3018, 0x181B,
0x36E6, 0x279A, 0x29F7, 0x0947, 0x0ED8, 0x0003, 0xFEC0, 0x0A6B,
0xFA72, 0x10CB, 0xF8EC, 0x137C, 0x01B7, 0x0C8F, 0x057F, 0x091B,
0xF377, 0xF1A1, 0xD605, 0xD263, 0xCA84, 0xCAE6, 0xE8BF, 0xE5FA,
0x1030, 0x17D9, 0x18AA, 0x1A8F, 0x1596, 0x0122, 0x1F2F, 0x0BF2,
0x1CD1, 0x0E74, 0x026B, 0xF6CE, 0xE870, 0xE577, 0xD9B0, 0xDAD1,
0xD3CA, 0xE33F, 0xD5A0, 0xFC7B, 0xE2F9, 0xFA07, 0xF684, 0xFBA4,
0x0545, 0x0799, 0x088F, 0xEE1B, 0x0203, 0xF2D3, 0x04B9, 0x198D,
0x14C4, 0x2EAF, 0x29DB, 0x3230, 0x3FB2, 0x29FE, 0x4200, 0x2C16,
0x2A17, 0x1A8D, 0x0401, 0xF571, 0xE00C, 0xD825, 0xDFFF, 0xD39C,
0xF124, 0xF516, 0xE72A, 0xFB42, 0xDAB3, 0xE6D3, 0xE362, 0xEF5F,
0xE90B, 0xF054, 0xDEF4, 0xDAB9, 0xD8BF, 0xD807, 0xE055, 0xEA79,
0xF17C, 0x0519, 0x0989, 0x1D64, 0x1F7C, 0x157F, 0x2E2C, 0x1558,
0x35E0, 0x28C8, 0x2E51, 0x1045, 0x15AE, 0xFB2D, 0x0386, 0x0A3B,
0xFC7F, 0x14B2, 0xF845, 0x12D5, 0x034E, 0x0EE3, 0x0B12, 0x119C,
0xFA48, 0xFC1D, 0xDE90, 0xD705, 0xCD05, 0xCD4B, 0xE283, 0xE40E,
0x0E55, 0x13D3, 0x1F0C, 0x2128, 0x19D3, 0x0635, 0x1D0C, 0x096F,
0x1CB3, 0x0FED, 0x0591, 0xF8E0, 0xEA3A, 0xE581, 0xD9D8, 0xDD95,
0xD211, 0xE0A3, 0xD383, 0xF746, 0xE112, 0xFFF2, 0xF41B, 0xFBA7,
0x0328, 0x0768, 0x0924, 0xF625, 0x0434, 0xECA7, 0x0683, 0x14BC,
0x172E, 0x33C9, 0x2916, 0x34D2, 0x3D31, 0x2920, 0x47C4, 0x2EDE,
0x35F1, 0x265C, 0x0E27, 0xFBBE, 0xE3C5, 0xD98C, 0xDA1E, 0xD245,
0xECB1, 0xEFE3, 0xEBCF, 0xFFD9, 0xDF88, 0xEC24, 0xE4C5, 0xEF7E,
0xEBE3, 0xF59A, 0xE118, 0xDD6F, 0xD708, 0xD4E7, 0xDE69, 0xEA4E,
0xEDB3, 0x0146, 0x0353, 0x173F, 0x1BD7, 0x19F5, 0x2DE8, 0x154E,
0x35C0, 0x27A0, 0x2F48, 0x1794, 0x1A12, 0xF7DA, 0x060D, 0x04AF,
0xFD07, 0x1471, 0xF60F, 0x13A6, 0xFCD2, 0x0FD9, 0x0EB0, 0x146A,
0x08E8, 0x092F, 0xE9AF, 0xDF54, 0xCF44, 0xCB06, 0xDA9E, 0xDDCE,
0x06D4, 0x0C23, 0x21A8, 0x2565, 0x1DBF, 0x0A89, 0x1D8A, 0x0506,
0x1F9C, 0x13E4, 0x098D, 0xFDE2, 0xEC65, 0xE296, 0xDBDC, 0xDDB8,
0xD0D9, 0xE049, 0xCCB2, 0xEFA5, 0xD8ED, 0xFDCB, 0xF139, 0xFB53,
0x024A, 0x0694, 0x079F, 0xFCC4, 0x0775, 0xE92A, 0x0852, 0x0C38,
0x14EA, 0x322C, 0x261B, 0x33CC, 0x37A5, 0x2826, 0x4820, 0x2EF5,
0x3D97, 0x2D96, 0x162E, 0x0210, 0xEA46, 0xDC6A, 0xD706, 0xD2EC,
0xE543, 0xE717, 0xEA7F, 0xFE82, 0xDEFF, 0xF0DA, 0xE2F0, 0xEAB5,
0xEC0F, 0xF4FF, 0xE335, 0xE080, 0xD878, 0xD1FC, 0xDE9A, 0xEA35,
0xEBDB, 0x0125, 0xFD9B, 0x0FED, 0x1413, 0x183E, 0x2880, 0x147C,
0x330F, 0x20A4, 0x2D5D, 0x1A35, 0x1BC1, 0xF83B, 0x08B3, 0xFD40,
0xFDFB, 0x13B7, 0xF5E0, 0x145B, 0xF7F7, 0x0E3F, 0x0BF8, 0x144E,
0x0F80, 0x1019, 0xF543, 0xE746, 0xD5C0, 0xCCB6, 0xD3F6, 0xDB9D,
0xFDF7, 0x0324, 0x21F1, 0x2282, 0x2065, 0x1168, 0x1BE4, 0x03EB,
0x1E2E, 0x1195, 0x0BE8, 0xFFF1, 0xED32, 0xDFC2, 0xDC19, 0xDC9D,
0xD297, 0xE206, 0xC9E6, 0xE823, 0xD1BC, 0xFB8B, 0xEBF5, 0x0057,
0x012B, 0x00FC, 0x0745, 0xFDAD, 0x0637, 0xEA45, 0x07A2, 0x010F,
0x162D, 0x2E95, 0x2782, 0x3793, 0x33BE, 0x2953, 0x4526, 0x2BF9,
0x4407, 0x32C3, 0x20C2, 0x0E0C, 0xF371, 0xDF33, 0xD72A, 0xCE2C,
0xDE95, 0xDCEC, 0xEBC0, 0xFB37, 0xE4F9, 0xF948, 0xE3B7, 0xEBC7,
0xEC35, 0xF3E3, 0xE720, 0xE6B4, 0xD8CA, 0xD042, 0xDC0F, 0xE37C,
0xECE5, 0x0143, 0xFA95, 0x0A55, 0x0B65, 0x12BC, 0x244E, 0x185A,
0x31E5, 0x1CB6, 0x2894, 0x19B0, 0x1A38, 0xFCA9, 0x0C37, 0xF5B1,
0xFF47, 0x0CCB, 0xF616, 0x129E, 0xF4CC, 0x0D79, 0x07A4, 0x1398,
0x139E, 0x162A, 0xFFBA, 0xF26B, 0xE002, 0xCE61, 0xD3B6, 0xD98E,
0xF353, 0xFCB4, 0x1EA0, 0x1B40, 0x24D8, 0x1564, 0x1DFD, 0x0609,
0x1FFA, 0x1082, 0x0F26, 0x050F, 0xEE8C, 0xE289, 0xDCF8, 0xDA83,
0xD63D, 0xE321, 0xC9B8, 0xE3A2, 0xC8BE, 0xF08D, 0xE45B, 0xFFDB,
0x00EE, 0xFFB7, 0x05BE, 0xFA27, 0x0340, 0xEB89, 0x07CC, 0xFA72,
0x15FF, 0x2924, 0x26DA, 0x37BA, 0x2E58, 0x27CF, 0x3F63, 0x2A71,
0x4AC1, 0x35D2, 0x2BF4, 0x170B, 0xFD32, 0xE5F7, 0xDB78, 0xD250,
0xD7C6, 0xDAC0, 0xE701, 0xF2F4, 0xE70D, 0xFAB5, 0xE5AA, 0xEF15,
0xEE1C, 0xF12A, 0xEB19, 0xE9F8, 0xD96B, 0xD16E, 0xD760, 0xDCF7,
0xECE0, 0x0108, 0xFB8A, 0x0A93, 0x02C2, 0x0BDD, 0x17CB, 0x1657,
0x2D85, 0x1B00, 0x2947, 0x15FC, 0x183E, 0xFD79, 0x0DAC, 0xF16A,
0x039D, 0x08F7, 0xF79F, 0x15BE, 0xF037, 0x0F31, 0xFF6A, 0x11DB,
0x160B, 0x18D7, 0x0B01, 0xFEA2, 0xE98E, 0xD536, 0xD74A, 0xD7F5,
0xEC39, 0xF8EA, 0x1711, 0x151A, 0x2752, 0x1966, 0x217A, 0x0B8B,
0x1F4A, 0x0C3C, 0x0FD9, 0x06CD, 0xEFAB, 0xE60F, 0xDDDE, 0xD695,
0xDA5A, 0xE35F, 0xCCAE, 0xE5EF, 0xC404, 0xEC33, 0xD896, 0xFEA4,
0xF992, 0x01F7, 0x0494, 0xFA12, 0xFE00, 0xEBA9, 0x04B3, 0xF548,
0x172E, 0x218D, 0x2699, 0x36F8, 0x2C12, 0x2AEB, 0x3844, 0x282F,
0x4A0F, 0x3589, 0x340E, 0x222F, 0x04E4, 0xED4F, 0xE52A, 0xD459,
0xD946, 0xDB29, 0xE05E, 0xECDA, 0xE7DD, 0xFCB7, 0xE9CC, 0xF736,
0xEFB2, 0xF19A, 0xEC5E, 0xED15, 0xDB8A, 0xD717, 0xD76F, 0xDAD4,
0xEA57, 0xFD90, 0xFB4A, 0x0948, 0xFFD8, 0x06F3, 0x0DC3, 0x1285,
0x263F, 0x1A59, 0x26CF, 0x1313, 0x12F0, 0xFD39, 0x0B0E, 0xEFCC,
0x0507, 0x00CE, 0xF765, 0x1138, 0xEF0C, 0x1104, 0xFA1C, 0x1261,
0x135C, 0x182E, 0x11B7, 0x0693, 0xF310, 0xDF1A, 0xDD03, 0xD9D2,
0xE721, 0xF750, 0x0DCE, 0x0FF5, 0x249B, 0x1773, 0x22C9, 0x1069,
0x217E, 0x0C4F, 0x124C, 0x05C4, 0xF37D, 0xE91D, 0xDFC2, 0xD5A5,
0xDA8B, 0xE1A0, 0xD026, 0xE5F8, 0xC3A7, 0xE78D, 0xCFD9, 0xFBE5,
0xF06B, 0x0277, 0x01AB, 0xF67D, 0xFBDF, 0xE9C1, 0xFEA6, 0xF131,
0x140B, 0x1892, 0x2878, 0x32EB, 0x2BB4, 0x2A58, 0x2FBE, 0x26AC,
0x439B, 0x331B, 0x3A58, 0x271D, 0x0F54, 0xF73F, 0xED85, 0xD808,
0xDD26, 0xDCB6, 0xDDCC, 0xE970, 0xE580, 0xF8C9, 0xEAA6, 0xFD66,
0xF1D4, 0xF4B3, 0xEFDC, 0xEC71, 0xDE81, 0xDA8A, 0xD5C7, 0xD882,
0xE850, 0xFAA3, 0xFEA0, 0x0C1F, 0x0063, 0x03CF, 0x0616, 0x0D5B,
0x1DE6, 0x1B39, 0x2558, 0x1475, 0x12E0, 0xFCF9, 0x0886, 0xECA9,
0x0899, 0xFC5F, 0xFD73, 0x0E9C, 0xF019, 0x0F30, 0xF4E0, 0x107E,
0x0DBE, 0x1728, 0x15B1, 0x0DED, 0xFB0A, 0xE722, 0xE4E1, 0xD94A,
0xEB58, 0xF848, 0x0997, 0x0E35, 0x21E2, 0x136B, 0x252C, 0x13E5,
0x2551, 0x0F58, 0x1708, 0x0823, 0xF764, 0xEEBA, 0xE239, 0xD6EB,
0xDDD3, 0xE157, 0xD6A7, 0xE9F2, 0xC851, 0xE800, 0xCC3C, 0xF770,
0xE940, 0x02FD, 0x008B, 0xF9DC, 0xFBEC, 0xE81A, 0xF9FB, 0xECC4,
0x118E, 0x13DB, 0x286D, 0x303F, 0x2C45, 0x2B2F, 0x2BDC, 0x2498,
0x3BD1, 0x2EAE, 0x3B9D, 0x2BF3, 0x175C, 0x0172, 0xF68F, 0xDC7E,
0xE538, 0xE122, 0xE00E, 0xEC69, 0xE5CF, 0xF766, 0xED90, 0x0238,
0xF7F1, 0xFBF1, 0xF741, 0xEEC8, 0xE383, 0xDCD9, 0xD8B7, 0xDA01,
0xE9EC, 0xF9FC, 0x0200, 0x0E27, 0x04BD, 0x058F, 0x03A1, 0x0AE0,
0x15F6, 0x1A48, 0x2071, 0x14AB, 0x12F5, 0xFC09, 0x0851, 0xEC95,
0x0878, 0xF954, 0x00FD, 0x0A8A, 0xF4D0, 0x0F75, 0xF4B2, 0x131F,
0x090C, 0x16E2, 0x1825, 0x0F7E, 0x0606, 0xF16C, 0xEE48, 0xDF7A,
0xEEDD, 0xF7F7, 0x08C2, 0x0FA8, 0x2158, 0x12DA, 0x25E1, 0x16DF,
0x2735, 0x1761, 0x1C03, 0x0C45, 0xFDE9, 0xF2D8, 0xE734, 0xDBCC,
0xE127, 0xE332, 0xDC13, 0xED33, 0xCD78, 0xE8FD, 0xCBBF, 0xF4B7,
0xE3F9, 0x03EA, 0xFC82, 0xFC41, 0xFD2D, 0xE8DF, 0xF978, 0xEA9D,
0x0E95, 0x0E1D, 0x288C, 0x2BC4, 0x2DE0, 0x28CF, 0x29C9, 0x22E2,
0x33BD, 0x2BB8, 0x3932, 0x2B84, 0x1EC3, 0x094E, 0xFF28, 0xE1A2,
0xED19, 0xE151, 0xE3AA, 0xEE3A, 0xE471, 0xF4C0, 0xED20, 0x01B3,
0xFA3D, 0x033B, 0xFC9E, 0xF31D, 0xEA2C, 0xDFB8, 0xDB48, 0xDCE1,
0xE8FF, 0xF993, 0x0491, 0x113E, 0x08D8, 0x0848, 0x013F, 0x0847,
0x0DF3, 0x192B, 0x194F, 0x1582, 0x0F03, 0xFBD6, 0x03AA, 0xE9D7,
0x071C, 0xF587, 0x0440, 0x0855, 0xF491, 0x0C32, 0xF245, 0x0FD5,
0x04C5, 0x14C1, 0x1465, 0x0E97, 0x0834, 0xF591, 0xF494, 0xE1D1,
0xF522, 0xF74F, 0x0966, 0x121C, 0x1E56, 0x1220, 0x22A6, 0x1582,
0x25C4, 0x1A94, 0x2044, 0x0DFF, 0x029C, 0xF354, 0xE926, 0xDC14,
0xE44A, 0xE2BE, 0xE233, 0xF077, 0xD276, 0xEA89, 0xCA1A, 0xF0DB,
0xDE1A, 0x0408, 0xF617, 0xFEF4, 0xF8CD, 0xE72F, 0xF3A2, 0xE60B,
0x0687, 0x096F, 0x2784, 0x2843, 0x303C, 0x2623, 0x2661, 0x229B,
0x2AFE, 0x2AE4, 0x338F, 0x27CD, 0x20DB, 0x0C75, 0x043A, 0xE66F,
0xF3A6, 0xDFAA, 0xE7F2, 0xEE92, 0xE31E, 0xF3AD, 0xEA83, 0xFF0A,
0xFA19, 0x06F9, 0x0084, 0xF793, 0xEF53, 0xE218, 0xDCCC, 0xDDB1,
0xE552, 0xF6D0, 0x02AC, 0x1104, 0x0CE2, 0x0A33, 0xFFC4, 0x04D5,
0x04C3, 0x14DD, 0x1219, 0x15BD, 0x0D14, 0xFDA1, 0x0217, 0xE842,
0x031E, 0xF02D, 0x0555, 0x045C, 0xF9A7, 0x08A1, 0xF381, 0x0DC7,
0x00A5, 0x1775, 0x1181, 0x1029, 0x0C22, 0xF9F2, 0xF8EF, 0xE8D4,
0xF786, 0xF7BA, 0x0AAE, 0x11FD, 0x1C3E, 0x11D5, 0x1E7C, 0x12E6,
0x21C4, 0x1BEA, 0x1F7F, 0x0FDD, 0x056B, 0xF523, 0xEC59, 0xDF38,
0xE62C, 0xE257, 0xE4AE, 0xF1B8, 0xD836, 0xEE59, 0xCD97, 0xEF88,
0xDC63, 0x0205, 0xF41F, 0x026F, 0xF81B, 0xEBE5, 0xF248, 0xE5DF,
0x0216, 0x05DC, 0x2352, 0x262B, 0x30FF, 0x247A, 0x2742, 0x1F5C,
0x24B5, 0x28D9, 0x2BD6, 0x25B9, 0x1FC8, 0x0BE1, 0x086C, 0xE9EF,
0xFADA, 0xE104, 0xED66, 0xEFD9, 0xE52E, 0xF4AC, 0xEB1E, 0xFCAA,
0xFA28, 0x0957, 0x046B, 0xFD6B, 0xF58B, 0xE52D, 0xDFE8, 0xDF8F,
0xE588, 0xF679, 0x0292, 0x1109, 0x0EEF, 0x0D9C, 0xFE9D, 0x036D,
0xFDBE, 0x0F36, 0x0B6A, 0x141E, 0x0744, 0xFDAF, 0xFE3A, 0xE5B4,
0x013D, 0xEBA1, 0x040C, 0x01D1, 0xFAB6, 0x07EA, 0xF493, 0x0B99,
0xFEE4, 0x1705, 0x0EEF, 0x1188, 0x0C30, 0xFBC1, 0xFB54, 0xEC0F,
0xFBEA, 0xF74E, 0x0D81, 0x1030, 0x198B, 0x1201, 0x19C7, 0x0FEF,
0x1DA7, 0x1AFF, 0x1E64, 0x132A, 0x06CE, 0xF5A5, 0xEC97, 0xDE31,
0xE616, 0xE092, 0xE5E0, 0xF190, 0xDBD1, 0xF1CC, 0xCF84, 0xEFE0,
0xDA5B, 0xFF3D, 0xF1C7, 0x027F, 0xF5D2, 0xEEF1, 0xEFAE, 0xE5C1,
0xFDD7, 0xFFDA, 0x1F4B, 0x200B, 0x2E52, 0x20AB, 0x2370, 0x1A7E,
0x1F05, 0x24BE, 0x2524, 0x2389, 0x1C84, 0x0C99, 0x0906, 0xEF29,
0xFED3, 0xE24B, 0xF2F4, 0xEE39, 0xE60C, 0xF5F6, 0xE9A0, 0xFC44,
0xFB63, 0x0AF3, 0x0819, 0x044B, 0xF94A, 0xE9DD, 0xE129, 0xDFE1,
0xE463, 0xF4EF, 0xFFCC, 0x0FDD, 0x0DBE, 0x0E5A, 0xFDAC, 0x0185,
0xF6D1, 0x09AC, 0x0320, 0x1009, 0x02EE, 0xFDE0, 0xFBD7, 0xE6E0,
0xFF82, 0xE87B, 0x0506, 0xFE9F, 0xFD6B, 0x05F9, 0xF58B, 0x07A6,
0xFF91, 0x1696, 0x0EB1, 0x1442, 0x0B67, 0xFE59, 0xFBE2, 0xF176,
0xFDEA, 0xF957, 0x0F28, 0x0C6F, 0x1664, 0x0F76, 0x131F, 0x0C76,
0x16C6, 0x16A5, 0x1AEF, 0x1150, 0x07E6, 0xF509, 0xEE55, 0xDF79,
0xE80A, 0xE13D, 0xE7D3, 0xF280, 0xDFFC, 0xF690, 0xD47E, 0xF300,
0xD8EB, 0xFED7, 0xEDC5, 0x0414, 0xF405, 0xF3C1, 0xED6B, 0xE71C,
0xF8B7, 0xFA64, 0x196C, 0x1ABB, 0x2B79, 0x1E5F, 0x2150, 0x1547,
0x199E, 0x1F0A, 0x1C6F, 0x20DF, 0x16B5, 0x093C, 0x0944, 0xF050,
0x02BD, 0xE715, 0xF923, 0xF06C, 0xE9A3, 0xF74B, 0xE97A, 0xFBDE,
0xFA21, 0x0B8B, 0x0868, 0x090E, 0xFDDD, 0xEE9E, 0xE458, 0xE070,
0xE1DC, 0xF0CF, 0xFAAC, 0x0A3F, 0x0BC8, 0x0CD1, 0xFE2A, 0x019B,
0xF10F, 0x0543, 0xFA1A, 0x0B07, 0xFC80, 0xFC38, 0xF7FD, 0xE738,
0xFD46, 0xE7F3, 0x02A9, 0xFD89, 0xFF43, 0x0732, 0xFA6E, 0x0754,
0x012C, 0x1550, 0x0D2A, 0x17A0, 0x09EE, 0x02A6, 0xFB85, 0xF4D3,
0xFE28, 0xFB0D, 0x0FDD, 0x0970, 0x14E3, 0x0B86, 0x0EA5, 0x0723,
0x108D, 0x1068, 0x1655, 0x115C, 0x08D8, 0xF67F, 0xF161, 0xDDB5,
0xEACA, 0xE046, 0xEA3D, 0xF288, 0xE2EF, 0xF91F, 0xDA25, 0xF63A,
0xDC31, 0xFEAF, 0xED9F, 0x035F, 0xF45B, 0xF71D, 0xEB9E, 0xEBF9,
0xF32D, 0xF834, 0x1323, 0x13C9, 0x27FB, 0x1B65, 0x2076, 0x1201,
0x1742, 0x1752, 0x168D, 0x1CCB, 0x1194, 0x093B, 0x0885, 0xF2EE,
0x0807, 0xECEF, 0x03A6, 0xF3D4, 0xF0DA, 0xF9EB, 0xEB24, 0xFE01,
0xFBA9, 0x0C49, 0x0C77, 0x0D8A, 0x04DE, 0xF4F4, 0xEAA3, 0xE425,
0xE520, 0xF0D6, 0xFA2D, 0x07EF, 0x093D, 0x0D0C, 0x001A, 0x0304,
0xF275, 0x0228, 0xF4A2, 0x05EA, 0xF70D, 0xFA85, 0xF6B3, 0xE9A1,
0xFECB, 0xE908, 0x057F, 0xFBDC, 0x02FA, 0x098D, 0xFF99, 0x0A62,
0x05BD, 0x1449, 0x0F30, 0x199B, 0x0CBF, 0x06EF, 0xFF13, 0xF7B1,
0xFFDA, 0xFDD7, 0x1297, 0x0A7C, 0x168E, 0x0BF9, 0x0D60, 0x0650,
0x0E18, 0x0E6A, 0x12C6, 0x129F, 0x08C8, 0xF95E, 0xF5A7, 0xE063,
0xF06F, 0xE2E0, 0xEFB3, 0xF413, 0xE86D, 0xFCB4, 0xE377, 0xFBF8,
0xE30C, 0x0283, 0xED0D, 0x0554, 0xF48A, 0xF9F2, 0xEEB1, 0xEFC5,
0xF306, 0xF7ED, 0x0DCE, 0x0FAA, 0x248E, 0x19B4, 0x219B, 0x10C9,
0x17C0, 0x12EC, 0x1445, 0x1B59, 0x0EEB, 0x0BA1, 0x0806, 0xF532,
0x097C, 0xF194, 0x0A26, 0xF91D, 0xFB06, 0xFE97, 0xF165, 0x01D9,
0xFCC8, 0x0D06, 0x0D61, 0x10D1, 0x0A85, 0xFC8C, 0xF0A3, 0xE86A,
0xE6B7, 0xEF3D, 0xF997, 0x04D7, 0x08D6, 0x0C5D, 0x030A, 0x0349,
0xF44A, 0x00D9, 0xF1BE, 0x055A, 0xF4F3, 0xFB7F, 0xF58A, 0xEBAF,
0xFDAF, 0xEC3D, 0x05C5, 0xFCEF, 0x0536, 0x0A10, 0x0371, 0x0D00,
0x0916, 0x14BB, 0x117E, 0x1A52, 0x0F0C, 0x0B19, 0x01B8, 0xFB89,
0xFFE8, 0x0119, 0x130E, 0x0CB8, 0x1B02, 0x0D5B, 0x0ECF, 0x060E,
0x0AA6, 0x0A7C, 0x1085, 0x1226, 0x0AD5, 0xFF45, 0xF85B, 0xE3E3,
0xF287, 0xE314, 0xF46B, 0xF550, 0xECC5, 0xFFA6, 0xE7A8, 0x0006,
0xE748, 0x04EB, 0xED11, 0x06EE, 0xF33D, 0xFBD2, 0xEE51, 0xF121,
0xF144, 0xF7C7, 0x097C, 0x0CD8, 0x206A, 0x17FC, 0x1FCC, 0x1074,
0x16EB, 0x0EB9, 0x128F, 0x17E5, 0x0C84, 0x0CD2, 0x0817, 0xF621,
0x0AC3, 0xF4AE, 0x0E12, 0xFE5B, 0x02C6, 0x01E2, 0xF603, 0x038A,
0xFDB9, 0x0D20, 0x0D3E, 0x11EE, 0x0C34, 0x000B, 0xF4C5, 0xEB14,
0xE7A7, 0xEE86, 0xF8AD, 0x01C5, 0x07B7, 0x0AB2, 0x0367, 0x04B3,
0xF793, 0x0170, 0xEFA2, 0x03AC, 0xEF0B, 0xFAC4, 0xF2B6, 0xEC9C,
0xFC62, 0xECD2, 0x05D1, 0xFB99, 0x074A, 0x0A33, 0x06C5, 0x0FBE,
0x0BB4, 0x1378, 0x125B, 0x176B, 0x0EF8, 0x0D4F, 0x0155, 0xFD95,
0xFCE2, 0x00DC, 0x0F36, 0x0D06, 0x1C10, 0x0D06, 0x100D, 0x047A,
0x0774, 0x066D, 0x0C33, 0x0EBC, 0x0AEC, 0x001B, 0xFC79, 0xE502,
0xF3A5, 0xE258, 0xF5F1, 0xF32F, 0xF12C, 0xFE35, 0xED09, 0x02A4,
0xEECE, 0x0879, 0xEFE7, 0x07C6, 0xF18E, 0xFBF6, 0xEDC6, 0xF32D,
0xEDF2, 0xF83E, 0x0255, 0x084E, 0x1B4B, 0x1360, 0x1E5C, 0x0F6C,
0x15B1, 0x0B5D, 0x117E, 0x113F, 0x0B65, 0x0BB2, 0x05F0, 0xF7F0,
0x0931, 0xF557, 0x0F9C, 0x005E, 0x0800, 0x03B1, 0xF9FE, 0x04D7,
0xFD55, 0x0CB6, 0x0B00, 0x1207, 0x0D8B, 0x04C6, 0xFAC6, 0xEFA6,
0xE98A, 0xEE1A, 0xF4E3, 0xFEA2, 0x0593, 0x082E, 0x02DA, 0x02F3,
0xF70A, 0xFEA5, 0xEE89, 0x0066, 0xEC66, 0xF8B4, 0xF048, 0xEB52,
0xFA94, 0xEC7C, 0x04A4, 0xFB01, 0x06E1, 0x07E9, 0x0775, 0x0EFE,
0x0E9C, 0x13E2, 0x14BE, 0x15F9, 0x0E22, 0x0D41, 0x0199, 0xFE97,
0xFE1E, 0x00CD, 0x0D32, 0x0D3B, 0x1C04, 0x0CF4, 0x11A0, 0x03B8,
0x04A5, 0x02C1, 0x0770, 0x0A4D, 0x0940, 0x0185, 0xFF96, 0xE988,
0xF5DD, 0xE3C1, 0xF751, 0xF2A8, 0xF4D8, 0xFF4C, 0xEFD0, 0x04B6,
0xF363, 0x0918, 0xF31F, 0x07B0, 0xEFBA, 0xFBED, 0xED62, 0xF270,
0xEDEA, 0xF69C, 0xFE6C, 0x050E, 0x16DC, 0x0F3F, 0x1C46, 0x0C64,
0x14C2, 0x088E, 0x1161, 0x0CB2, 0x09C2, 0x08A2, 0x03B5, 0xF7B3,
0x093B, 0xF5D5, 0x10C6, 0x0281, 0x0CB1, 0x062D, 0x0110, 0x05EB,
0x02A5, 0x0CF4, 0x0BA0, 0x125E, 0x0BB2, 0x067C, 0xFE34, 0xF206,
0xECB9, 0xEE5D, 0xF290, 0xFCD2, 0x03FE, 0x067F, 0x0394, 0x01E0,
0xF8E5, 0xFD9C, 0xEF98, 0xFF95, 0xEAF5, 0xF7FC, 0xED5A, 0xEA3F,
0xF7CC, 0xEC47, 0x0315, 0xFB8A, 0x062C, 0x07C6, 0x08A1, 0x0EDF,
0x113C, 0x1518, 0x17C5, 0x16DA, 0x1022, 0x0E39, 0x0107, 0x0043,
0xFD7D, 0x00D1, 0x0BBF, 0x0D00, 0x1AF5, 0x0CAD, 0x13F6, 0x02E6,
0x0578, 0x00E5, 0x04EF, 0x06D4, 0x075E, 0x0100, 0x0139, 0xEC82,
0xF8CC, 0xE562, 0xF8D5, 0xF222, 0xF6EA, 0xFEC3, 0xF202, 0x0500,
0xF706, 0x0961, 0xF7E7, 0x0899, 0xF00E, 0xFE1B, 0xEAF7, 0xF401,
0xEC88, 0xF6BB, 0xFB5F, 0x031D, 0x11BB, 0x0C03, 0x1953, 0x09ED,
0x11EF, 0x05F2, 0x0F25, 0x09AF, 0x0B22, 0x0895, 0x0218, 0xF974,
0x05D8, 0xF530, 0x116E, 0x0325, 0x0F9D, 0x0A8C, 0x0436, 0x0911,
0x0479, 0x0C37, 0x0C02, 0x10B9, 0x0B9D, 0x073E, 0x006E, 0xF52A,
0xEF97, 0xF0E0, 0xF14F, 0xFB3F, 0x01CB, 0x02BC, 0x01D6, 0x0005,
0xF6D9, 0xFBF9, 0xEE58, 0xFC97, 0xE7F1, 0xF6E8, 0xE7A9, 0xEB39,
0xF23E, 0xEC59, 0x0084, 0xFA41, 0x0572, 0x06D3, 0x079A, 0x0E75,
0x10B9, 0x138B, 0x17E1, 0x133C, 0x10D7, 0x0B62, 0x00DE, 0x001E,
0xFAB1, 0xFEB4, 0x0760, 0x0A26, 0x17FE, 0x0E2C, 0x13C6, 0x0451,
0x047E, 0xFD1C, 0x014B, 0x0199, 0x0387, 0x002F, 0x0033, 0xEF3B,
0xF8E5, 0xE5CA, 0xF757, 0xEF4C, 0xF785, 0xFDC6, 0xF3E5, 0x0627,
0xF910, 0x0A2B, 0xFB50, 0x0944, 0xEFD2, 0xFDEF, 0xE7CC, 0xF31B,
0xE9CD, 0xF601, 0xF6D0, 0x00A6, 0x0A72, 0x0840, 0x133B, 0x0792,
0x0EE0, 0x0452, 0x0C35, 0x052B, 0x0935, 0x02D1, 0xFFAA, 0xF8A2,
0x004D, 0xF594, 0x0CD6, 0x017E, 0x0EF7, 0x0B5C, 0x060A, 0x0B2E,
0x05BD, 0x0C7B, 0x0BF7, 0x0FCD, 0x09C0, 0x0812, 0x00BC, 0xF8A2,
0xF3F9, 0xF23D, 0xF0C6, 0xF861, 0xFE0F, 0xFF79, 0x01BF, 0xFF1B,
0xF6C5, 0xFBDD, 0xED42, 0xFAFD, 0xE714, 0xF530, 0xE54D, 0xEA9C,
0xEDF2, 0xEC80, 0xFC69, 0xFA16, 0x02BB, 0x0547, 0x0615, 0x0CB1,
0x10DE, 0x1384, 0x19B1, 0x140D, 0x1370, 0x0A79, 0x02DB, 0x00F4,
0xFB9C, 0x0130, 0x0672, 0x0959, 0x1622, 0x0CB3, 0x142B, 0x04B1,
0x04ED, 0xFD2D, 0xFE62, 0x0009, 0xFEE1, 0xFEAD, 0xFE6A, 0xF0ED,
0xFBAF, 0xEA32, 0xF967, 0xF1C8, 0xF857, 0xFD1F, 0xF61F, 0x0593,
0xFBB1, 0x0AC1, 0x0026, 0x0A24, 0xF3E7, 0xFEFE, 0xE81D, 0xF401,
0xE9FC, 0xF6C9, 0xF5FF, 0x0078, 0x0770, 0x0674, 0x113D, 0x059D,
0x0E73, 0x0248, 0x0B0E, 0x0335, 0x096E, 0x0163, 0x0208, 0xF839,
0x0028, 0xF64E, 0x0BF8, 0x023A, 0x121A, 0x0D91, 0x0B8E, 0x0EE3,
0x0A67, 0x0E10, 0x0FC8, 0x0F83, 0x0C13, 0x08DC, 0x034C, 0xFB9A,
0xFAD6, 0xF5D9, 0xF5CC, 0xF9B9, 0xFD62, 0xFEFE, 0x0175, 0xFE99,
0xF8F4, 0xFBF8, 0xEF9E, 0xFB75, 0xE7F3, 0xF670, 0xE51B, 0xEC75,
0xEBE3, 0xECB9, 0xFA9C, 0xFA32, 0x044C, 0x07B3, 0x073B, 0x0F11,
0x10EE, 0x1350, 0x1BD5, 0x13C6, 0x18B1, 0x0BDF, 0x0863, 0x0214,
0xFD4F, 0x0145, 0x05F7, 0x091F, 0x16AF, 0x0DA2, 0x165D, 0x0724,
0x06F1, 0xFEB1, 0xFEB8, 0xFF62, 0xFDC5, 0xFF66, 0xFD80, 0xF500,
0xFD80, 0xEECC, 0xFC6C, 0xF4F8, 0xFB2F, 0xFF2C, 0xF8F8, 0x0777,
0xFE26, 0x0D3A, 0x04BC, 0x0C8B, 0xF9C9, 0x0143, 0xEB33, 0xF600,
0xEABA, 0xF7A4, 0xF5EA, 0x009B, 0x05BA, 0x05D6, 0x0E0F, 0x0519,
0x0B6A, 0x022F, 0x089E, 0x026D, 0x0999, 0x019D, 0x042E, 0xFAD9,
0xFE3D, 0xF8A9, 0x0902, 0x02F2, 0x149E, 0x0EA6, 0x1005, 0x1124,
0x0D3F, 0x0FBA, 0x1309, 0x0F16, 0x0FBE, 0x084E, 0x04F4, 0xFD13,
0xFDCB, 0xF8B2, 0xFA08, 0xFAC9, 0xFDA6, 0xFD41, 0x0099, 0xFD3B,
0xF98F, 0xFBA3, 0xF089, 0xFA63, 0xE83F, 0xF5AE, 0xE3D7, 0xEE65,
0xE9A9, 0xEF5B, 0xF7B9, 0xFA11, 0x027E, 0x0651, 0x0711, 0x0F7A,
0x10F1, 0x142A, 0x1BA9, 0x12D9, 0x1BAD, 0x0A8C, 0x0F7F, 0x028E,
0x00A0, 0x01D9, 0x03CD, 0x06E8, 0x1482, 0x0B9C, 0x163F, 0x0829,
0x06DE, 0xFE3C, 0xFC6D, 0xFAF1, 0xFB6A, 0xFC53, 0xFB8C, 0xF5E4,
0xFC49, 0xF0F1, 0xFCC2, 0xF65B, 0xFC7B, 0xFF94, 0xFB3C, 0x07E2,
0xFE90, 0x0E22, 0x0577, 0x0D7B, 0xFED1, 0x025E, 0xEFDA, 0xF7AD,
0xEB7B, 0xF7F6, 0xF436, 0xFED5, 0x022C, 0x0435, 0x0A4B, 0x0486,
0x08CA, 0x010F, 0x0477, 0xFFFC, 0x0589, 0x0000, 0x060E, 0xFB21,
0x008E, 0xF91B, 0x04A1, 0x016D, 0x1157, 0x0D03, 0x135D, 0x1315,
0x1064, 0x1230, 0x12EB, 0x0E45, 0x1178, 0x07C0, 0x0903, 0xFEEF,
0x0188, 0xFA5B, 0xFD44, 0xFAA4, 0xFE26, 0xFCAD, 0xFEC6, 0xFD20,
0xF81D, 0xFAC2, 0xEFFF, 0xF9E8, 0xE833, 0xF72F, 0xE3B4, 0xF01C,
0xE8BD, 0xF008, 0xF522, 0xFA42, 0x00E9, 0x062B, 0x0749, 0x0F40,
0x103C, 0x13A0, 0x1A9C, 0x128B, 0x1BE9, 0x0B0D, 0x136B, 0x0317,
0x05C1, 0x021D, 0x03B3, 0x0522, 0x1172, 0x0856, 0x161F, 0x0773,
0x0851, 0xFF87, 0xFAE1, 0xFA53, 0xF819, 0xFB69, 0xF8FF, 0xF76E,
0xFB07, 0xF3F9, 0xFD3C, 0xF88C, 0xFD43, 0xFEFB, 0xFC19, 0x06DB,
0xFF5E, 0x0E81, 0x07CC, 0x0EDD, 0x0443, 0x040B, 0xF367, 0xF93D,
0xEC33, 0xF9EB, 0xF56A, 0xFEED, 0x0144, 0x01DB, 0x062B, 0x0244,
0x05AD, 0xFF68, 0x02D2, 0xFDAD, 0x025A, 0xFD71, 0x03CA, 0xFADC,
0x0079, 0xFAA8, 0x0251, 0x01A1, 0x0DE2, 0x0B60, 0x12FC, 0x120C,
0x11E8, 0x12BB, 0x1323, 0x0DA9, 0x118F, 0x062B, 0x0A4C, 0xFF4A,
0x037B, 0xFC4D, 0x0026, 0xFC11, 0xFF0C, 0xFC04, 0xFD43, 0xFAFB,
0xF68A, 0xF8AA, 0xEF4A, 0xF91B, 0xE9D9, 0xF765, 0xE4BA, 0xF073,
0xE5FA, 0xF102, 0xF15A, 0xFB61, 0xFECB, 0x05F4, 0x05B5, 0x0E55,
0x0E3E, 0x1326, 0x19DE, 0x1130, 0x1D78, 0x088E, 0x17CC, 0x0164,
0x0B38, 0x01AB, 0x05AF, 0x0467, 0x0F2F, 0x067B, 0x1359, 0x05A9,
0x083C, 0xFF91, 0xFAE8, 0xF9E2, 0xF602, 0xF98F, 0xF7F8, 0xF794,
0xFB72, 0xF553, 0xFE6C, 0xFA14, 0xFF7C, 0x00A2, 0xFE6E, 0x0754,
0xFFFC, 0x0D96, 0x069A, 0x0E49, 0x06CC, 0x0570, 0xFA17, 0xF9CD,
0xEEE2, 0xF8E0, 0xF243, 0xFE58, 0xFDD1, 0x0144, 0x0381, 0x0153,
0x0191, 0xFE50, 0xFE49, 0xFCF0, 0xFF2A, 0xFDA0, 0x050E, 0xFBDB,
0x04AC, 0xFBF3, 0x026F, 0x0229, 0x0CF4, 0x0B3A, 0x1519, 0x118B,
0x13D6, 0x1312, 0x13A3, 0x0EEE, 0x11F6, 0x0664, 0x0C37, 0xFF51,
0x05BA, 0xFCBE, 0x02B4, 0xFC3E, 0x014C, 0xFBD6, 0xFCC0, 0xFAA2,
0xF51D, 0xF7BF, 0xEE3B, 0xF885, 0xEA10, 0xF9CC, 0xE6B3, 0xF451,
0xE657, 0xF32F, 0xEF3C, 0xFC1B, 0xFD82, 0x061D, 0x0601, 0x0D66,
0x0CF9, 0x11AA, 0x1667, 0x1117, 0x1BA9, 0x0954, 0x1B15, 0x0138,
0x105C, 0x012E, 0x057F, 0x041B, 0x0BFF, 0x05C8, 0x126E, 0x0417,
0x0860, 0xFE87, 0xFA87, 0xFA06, 0xF41F, 0xF89F, 0xF666, 0xF79B,
0xFB1F, 0xF6E3, 0xFF0A, 0xFAC7, 0x0166, 0x0144, 0xFF89, 0x0664,
0x0040, 0x0AC6, 0x066F, 0x0CEC, 0x0782, 0x0694, 0xFCBF, 0xFBA2,
0xF03E, 0xF8D6, 0xF17C, 0xFCDE, 0xFB65, 0xFFA9, 0xFF01, 0xFF1C,
0xFD80, 0xFC6D, 0xFB72, 0xFB98, 0xFB4D, 0xFC88, 0x0320, 0xFC00,
0x0752, 0xFCEB, 0x0396, 0x022D, 0x0AC3, 0x0A64, 0x143A, 0x104E,
0x1414, 0x1168, 0x1316, 0x0E44, 0x1149, 0x051A, 0x0C3E, 0xFCED,
0x04C2, 0xFB52, 0x00BC, 0xFBAA, 0xFFF8, 0xFB3B, 0xFA8E, 0xF905,
0xF271, 0xF5A3, 0xEC15, 0xF6A9, 0xE7F7, 0xF9A9, 0xE620, 0xF64B,
0xE611, 0xF4C0, 0xECDF, 0xFBC7, 0xFA85, 0x0396, 0x0224, 0x0A20,
0x0752, 0x0F26, 0x1111, 0x0F07, 0x1720, 0x0807, 0x1842, 0x0070,
0x11EF, 0x00B8, 0x0689, 0x031A, 0x071F, 0x0340, 0x0CB7, 0x01D1,
0x05D9, 0xFD48, 0xF997, 0xF96D, 0xF239, 0xF7EA, 0xF459, 0xF760,
0xFA0B, 0xF849, 0xFDC7, 0xFB9A, 0x01DE, 0x00CE, 0xFFED, 0x058C,
0xFD3B, 0x077C, 0x01F9, 0x0860, 0x0554, 0x0586, 0xFE55, 0xFC10,
0xF1D8, 0xF7AF, 0xEFBE, 0xFB60, 0xF6F5, 0xFD3E, 0xF98C, 0xFBD0,
0xF7D6, 0xF994, 0xF625, 0xF93A, 0xF647, 0xFA8E, 0xFECC, 0xFA8F,
0x0767, 0xFD84, 0x05C9, 0x0343, 0x09B2, 0x08F0, 0x1213, 0x0E8F,
0x125B, 0x1025, 0x1220, 0x0D20, 0x115F, 0x04DE, 0x0C46, 0xFCDC,
0x0563, 0xFBD0, 0x0245, 0xFC5D, 0x0246, 0xFB62, 0xFB4E, 0xF975,
0xF042, 0xF59B, 0xE9CD, 0xF461, 0xE73A, 0xF7F0, 0xE6B8, 0xF7A6,
0xE669, 0xF5D1, 0xEB44, 0xFB17, 0xF8A0, 0x02DF, 0x00F8, 0x0960,
0x04EE, 0x0D8D, 0x0D7E, 0x0DC3, 0x1416, 0x08ED, 0x16CD, 0x013F,
0x1411, 0xFFB8, 0x0A6A, 0x034E, 0x072C, 0x0467, 0x0AE3, 0x0120,
0x05B0, 0xFBAC, 0xFA54, 0xF9A4, 0xF321, 0xF95D, 0xF4CB, 0xF762,
0xFAF8, 0xF82A, 0xFF26, 0xFCC6, 0x04A1, 0x0154, 0x0466, 0x05DE,
0xFF66, 0x08A2, 0x016D, 0x084B, 0x0661, 0x0688, 0x02EE, 0x0020,
0xF586, 0xF9C4, 0xEF5C, 0xFB2F, 0xF642, 0xFDEE, 0xF9B7, 0xFC21,
0xF689, 0xF8FE, 0xF46E, 0xF84C, 0xF583, 0xF9E9, 0xFE18, 0xFA5B,
0x08F6, 0xFD26, 0x09C5, 0x041E, 0x0B39, 0x0997, 0x1293, 0x0D73,
0x135D, 0x0E93, 0x11FB, 0x0D16, 0x127C, 0x084B, 0x0F38, 0x001B,
0x0815, 0xFCC2, 0x03C1, 0xFDEB, 0x043A, 0xFCFC, 0xFE76, 0xF99F,
0xF1EF, 0xF585, 0xE978, 0xF300, 0xE80A, 0xF4CA, 0xEB0C, 0xF6ED,
0xEB2E, 0xF7B4, 0xEC11, 0xFC01, 0xF7C1, 0x029E, 0x013B, 0x092E,
0x02F7, 0x0CD9, 0x09CC, 0x0C12, 0x12E2, 0x099B, 0x1711, 0x0470,
0x16A5, 0x019E, 0x1008, 0x04CF, 0x098D, 0x0646, 0x0A1A, 0x02DF,
0x0570, 0xFCD4, 0xF9FC, 0xF9B8, 0xF434, 0xF9FB, 0xF693, 0xF88F,
0xFC42, 0xF96B, 0x0032, 0xFE1D, 0x0653, 0x02D4, 0x07B2, 0x07AE,
0x00B2, 0x09D1, 0x0020, 0x07C8, 0x0502, 0x05A5, 0x04B3, 0x0239,
0xFB5F, 0xFD12, 0xF2BB, 0xFC50, 0xF536, 0xFED2, 0xF84E, 0xFD55,
0xF576, 0xF946, 0xF224, 0xF812, 0xF207, 0xFA05, 0xFC18, 0xFB8A,
0x0ADB, 0xFDA4, 0x0E20, 0x03BC, 0x0D3D, 0x0A87, 0x1315, 0x0FA8,
0x149F, 0x0FC6, 0x1178, 0x0D07, 0x11E1, 0x0B30, 0x105E, 0x04B9,
0x0A42, 0xFECB, 0x0595, 0xFEEB, 0x05D8, 0xFEB9, 0x01E4, 0xFBC8,
0xF4DA, 0xF782, 0xEA8F, 0xF439, 0xE86D, 0xF544, 0xECA1, 0xF868,
0xEF5C, 0xFA60, 0xEEFF, 0xFD44, 0xF780, 0x02CE, 0x0038, 0x08E4,
0x01F4, 0x0B3C, 0x07B0, 0x0AC9, 0x0F2C, 0x0A3E, 0x1380, 0x065B,
0x1670, 0x0268, 0x146E, 0x048D, 0x0C9B, 0x06E0, 0x0891, 0x03A4,
0x0538, 0xFCF8, 0xFAEB, 0xF909, 0xF44D, 0xFA01, 0xF853, 0xFA02,
0xFE8E, 0xFAA3, 0x012B, 0xFF76, 0x07C8, 0x042A, 0x0B76, 0x07D4,
0x033F, 0x0976, 0xFFBA, 0x0741, 0x04A4, 0x0516, 0x05D5, 0x0336,
0xFE6F, 0xFFD1, 0xF4FE, 0xFE50, 0xF495, 0xFEF6, 0xF62D, 0xFCE1,
0xF1CD, 0xF879, 0xEE98, 0xF678, 0xEFE2, 0xF7F8, 0xF943, 0xFA87,
0x08D6, 0xFD86, 0x10E7, 0x038B, 0x107C, 0x0B2B, 0x1148, 0x1065,
0x1231, 0x0F6D, 0x1081, 0x0BDC, 0x10C5, 0x0B0A, 0x1027, 0x060B,
0x0AFC, 0xFFBB, 0x0591, 0x0032, 0x04E0, 0xFFF3, 0x030E, 0xFBC1,
0xF65C, 0xF845, 0xE8D0, 0xF4F8, 0xE652, 0xF343, 0xEE08, 0xF635,
0xF3B1, 0xFAA3, 0xF172, 0xFD77, 0xF7D4, 0x01D6, 0x00C3, 0x08AD,
0x0060, 0x0AE9, 0x0414, 0x0896, 0x0BE8, 0x0848, 0x10A8, 0x0690,
0x13E6, 0x0203, 0x14AE, 0x02A8, 0x0F19, 0x05E2, 0x07D8, 0x032F,
0x02BF, 0xFC20, 0xF9DA, 0xF765, 0xF34B, 0xF8FF, 0xF806, 0xFAD0,
0xFFA1, 0xFA98, 0x0249, 0xFED4, 0x07E6, 0x04BD, 0x0D1F, 0x0880,
0x0600, 0x09FD, 0xFEAB, 0x082E, 0x019D, 0x05AD, 0x065E, 0x02EE,
0x024B, 0xFF96, 0xF6D8, 0xFE72, 0xF349, 0xFE6D, 0xF593, 0xFBCC,
0xF0D2, 0xF762, 0xEB39, 0xF517, 0xECAF, 0xF665, 0xF73D, 0xF9DD,
0x067F, 0xFD65, 0x106B, 0x027C, 0x1432, 0x0A1F, 0x1456, 0x109F,
0x1245, 0x1007, 0x0FB4, 0x0AA9, 0x0FE2, 0x0A49, 0x1119, 0x08D4,
0x0D6F, 0x01AF, 0x07C1, 0xFFF7, 0x0582, 0x0102, 0x0394, 0xFC35,
0xF7F6, 0xF719, 0xE896, 0xF545, 0xE4AB, 0xF43C, 0xED82, 0xF5AC,
0xF6AD, 0xFA41, 0xF51F, 0xFEFB, 0xF6C6, 0x03E2, 0xFF0E, 0x09AA,
0xFFD1, 0x0ABB, 0x00E0, 0x077F, 0x076A, 0x0730, 0x0DA0, 0x067D,
0x12AC, 0x02AA, 0x14F6, 0x02D0, 0x110D, 0x05E9, 0x09FA, 0x0332,
0x0385, 0xFBB7, 0xF950, 0xF6E9, 0xF2ED, 0xF7DA, 0xF9A7, 0xFA9C,
0x02AB, 0xFBA6, 0x0494, 0xFEBB, 0x0848, 0x0567, 0x0EEC, 0x0A96,
0x08DE, 0x0A68, 0xFE8D, 0x07B9, 0xFFE6, 0x05CD, 0x047F, 0x01EC,
0x0409, 0xFE54, 0xFBC9, 0xFF0C, 0xF3DE, 0xFF9E, 0xF40F, 0xFC86,
0xF0EB, 0xF74C, 0xEB01, 0xF419, 0xEC1B, 0xF58E, 0xF522, 0xF998,
0x0452, 0xFCFD, 0x110B, 0x0109, 0x161B, 0x0940, 0x1547, 0x1141,
0x11A4, 0x10D0, 0x0E39, 0x0ACD, 0x0D87, 0x09AD, 0x0EE6, 0x088C,
0x0D50, 0x011E, 0x0846, 0xFF33, 0x043A, 0x01FD, 0x0312, 0xFD15,
0xFA87, 0xF69B, 0xEA5F, 0xF561, 0xE45B, 0xF478, 0xED42, 0xF455,
0xF964, 0xF87E, 0xFA3A, 0xFE15, 0xF808, 0x02B0, 0xFD52, 0x0884,
0xFE06, 0x0AA0, 0xFD4D, 0x0753, 0x02F7, 0x06BE, 0x08BB, 0x05C3,
0x0DFA, 0x01B2, 0x1310, 0x01B4, 0x12A9, 0x04F4, 0x0B1A, 0x0395,
0x01DA, 0xFC83, 0xF901, 0xF64F, 0xF356, 0xF6B1, 0xF8A0, 0xFB48,
0x0330, 0xFCEB, 0x078D, 0xFE2E, 0x09A5, 0x04F9, 0x0DAD, 0x0AB5,
0x0978, 0x092F, 0xFE90, 0x077B, 0xFC8C, 0x07D2, 0x015C, 0x023B,
0x0337, 0xFC7D, 0xFE14, 0xFED5, 0xF554, 0x0001, 0xF258, 0xFB11,
0xEEB9, 0xF592, 0xE7B0, 0xF2BF, 0xE848, 0xF2D6, 0xF1D7, 0xF60F,
0x0080, 0xFB70, 0x0EB2, 0x0041, 0x1717, 0x06EF, 0x160E, 0x0F01,
0x0F9D, 0x0F6C, 0x0B69, 0x08F1, 0x0A02, 0x06C0, 0x0B2B, 0x0755,
0x0ACD, 0x01D3, 0x0708, 0xFD8F, 0x033F, 0x0098, 0x01BE, 0xFEE3,
0xFB36, 0xF6B7, 0xEBC6, 0xF397, 0xE425, 0xF4AE, 0xEBDA, 0xF511,
0xF819, 0xF74D, 0xFC4F, 0xFCFB, 0xFB02, 0x035B, 0xFCA8, 0x0839,
0xFB3F, 0x08C1, 0xF9BC, 0x0563, 0xFED5, 0x0398, 0x0455, 0x0146,
0x0826, 0xFE34, 0x0CE3, 0xFFA5, 0x100A, 0x02D5, 0x0BC4, 0x01AE,
0x014D, 0xFC40, 0xF6E8, 0xF6A3, 0xF151, 0xF4E7, 0xF6E2, 0xF998,
0x022F, 0xFDAD, 0x06EC, 0xFE4B, 0x087E, 0x048F, 0x0B84, 0x0B7F,
0x08E3, 0x09A1, 0xFF97, 0x06BF, 0xFB76, 0x0735, 0xFF04, 0x025D,
0x0235, 0xFACF, 0xFF38, 0xFBD4, 0xF6AF, 0xFF75, 0xF271, 0xFC18,
0xEE65, 0xF5BF, 0xE60A, 0xF1D1, 0xE60A, 0xF1CB, 0xF036, 0xF4D1,
0xFE14, 0xF937, 0x0B8E, 0xFE8F, 0x16D1, 0x05F5, 0x187D, 0x0D8B,
0x0EF9, 0x0EF3, 0x08A4, 0x09FA, 0x08C6, 0x0669, 0x0B45, 0x05F5,
0x0BB7, 0x02FA, 0x079E, 0xFF62, 0x0437, 0x0086, 0x02E4, 0xFFF0,
0xFCFD, 0xF90C, 0xEEBE, 0xF4C8, 0xE566, 0xF603, 0xEAED, 0xF695,
0xF7A4, 0xF71C, 0xFF46, 0xFC64, 0xFEA3, 0x041A, 0xFD12, 0x08D9,
0xFAC8, 0x088E, 0xF810, 0x0544, 0xFB8B, 0x03F8, 0x02E2, 0x018E,
0x07D5, 0xFD9F, 0x0B87, 0xFF00, 0x0FDC, 0x02E8, 0x0F2C, 0x035B,
0x0550, 0xFE93, 0xF898, 0xF7D0, 0xF24F, 0xF51C, 0xF798, 0xF964,
0x025A, 0xFF9A, 0x081C, 0x0148, 0x0AFD, 0x053F, 0x0DB0, 0x0CF9,
0x0A99, 0x0C8C, 0x00D5, 0x0812, 0xFB37, 0x088F, 0xFE6C, 0x04F6,
0x021E, 0xFC84, 0x01D0, 0xFC11, 0xFB6B, 0x00DF, 0xF430, 0xFF8D,
0xEF2D, 0xF831, 0xE845, 0xF26A, 0xE709, 0xF22A, 0xEF26, 0xF417,
0xFB6D, 0xF735, 0x095D, 0xFD6A, 0x167A, 0x05E2, 0x1A09, 0x0DE5,
0x11B8, 0x0F8E, 0x09FE, 0x0B25, 0x0759, 0x07EE, 0x0927, 0x0699,
0x0C90, 0x0406, 0x0B29, 0x00D8, 0x07AA, 0x00D5, 0x05A8, 0x01FE,
0x008E, 0xFD05, 0xF342, 0xF670, 0xE901, 0xF5F2, 0xEC99, 0xF783,
0xF731, 0xF77B, 0x00B6, 0xFA8B, 0x0390, 0x02D3, 0xFFFD, 0x09B2,
0xFAAC, 0x09BD, 0xF790, 0x05B9, 0xFAE4, 0x03F0, 0x0153, 0x016C,
0x053C, 0xFC9A, 0x0962, 0xFD85, 0x1007, 0x01C5, 0x11DC, 0x02F3,
0x07D6, 0xFFDC, 0xF99E, 0xFA20, 0xF2DC, 0xF664, 0xF70A, 0xF7E7,
0x01C3, 0xFE6F, 0x0932, 0x02D6, 0x0CA1, 0x0540, 0x0DEC, 0x0BA0,
0x0A93, 0x0D67, 0x0304, 0x08D4, 0xFC96, 0x0816, 0xFDBF, 0x063A,
0x018D, 0xFE71, 0x0249, 0xFBC5, 0xFF17, 0x0059, 0xF891, 0x0184,
0xF07E, 0xFB78, 0xE78F, 0xF391, 0xE57F, 0xF0F2, 0xEDA0, 0xF372,
0xF94C, 0xF715, 0x05BF, 0xFCC6, 0x1410, 0x048F, 0x1AED, 0x0C60,
0x12CA, 0x0F9A, 0x0975, 0x0C59, 0x06AD, 0x08B9, 0x084A, 0x0661,
0x0CD5, 0x04A7, 0x0BFB, 0x0380, 0x0771, 0x02AB, 0x0621, 0x03F2,
0x0222, 0x00A8, 0xF4F4, 0xF879, 0xE905, 0xF60D, 0xEB8A, 0xF7A6,
0xF611, 0xF783, 0xFF02, 0xFA05, 0x0404, 0x026F, 0x0201, 0x09CB,
0xFAFF, 0x09E0, 0xF63E, 0x054E, 0xF7A1, 0x02EA, 0xFD81, 0x0151,
0x0321, 0xFC51, 0x069D, 0xFB74, 0x0CAA, 0xFFE9, 0x1268, 0x032D,
0x0A2A, 0x01B0, 0xF995, 0xFB31, 0xF2D4, 0xF678, 0xF745, 0xF739,
0x0086, 0xFD34, 0x08A6, 0x0315, 0x0DBF, 0x05D2, 0x0F62, 0x0BF4,
0x0BC3, 0x0F81, 0x046D, 0x0AA5, 0xFD5D, 0x0829, 0xFD35, 0x076C,
0x0137, 0xFF99, 0x0254, 0xF959, 0x0028, 0xFDB4, 0xFB20, 0x0239,
0xF20F, 0xFCD7, 0xE6AA, 0xF369, 0xE337, 0xEFAF, 0xEAA1, 0xF22B,
0xF584, 0xF555, 0x0190, 0xF9BB, 0x1057, 0x0260, 0x19FA, 0x0C37,
0x13F8, 0x0FF2, 0x09C9, 0x0BC6, 0x06B3, 0x07CA, 0x06FB, 0x0627,
0x0AC9, 0x0488, 0x0C6B, 0x03A5, 0x0967, 0x0303, 0x07F6, 0x0491,
0x029E, 0x0304, 0xF5F2, 0xFAA3, 0xEBB2, 0xF61E, 0xEC8B, 0xF849,
0xF54E, 0xF965, 0xFED7, 0xF9C5, 0x0612, 0x00AC, 0x04EA, 0x09FF,
0xFC30, 0x0BEB, 0xF6AD, 0x06C5, 0xF730, 0x0124, 0xFA8B, 0xFEDD,
0xFFBD, 0xFBD7, 0x0486, 0xFA2A, 0x09EC, 0xFE88, 0x107D, 0x0303,
0x0BCF, 0x0209, 0xFBBC, 0xFB89, 0xF239, 0xF55A, 0xF395, 0xF4B5,
0xFC9B, 0xFAB9, 0x0796, 0x02D2, 0x0DED, 0x0655, 0x0EB3, 0x0B50,
0x0A73, 0x10F6, 0x04C5, 0x0D06, 0xFEDD, 0x07D8, 0xFCD7, 0x0714,
0x002C, 0x00DE, 0x0230, 0xF8EA, 0x016F, 0xFBCB, 0xFDDF, 0x02A4,
0xF487, 0xFEF3, 0xE7DE, 0xF4BB, 0xE33B, 0xEF2D, 0xE9BF, 0xEFDF,
0xF389, 0xF282, 0xFDBB, 0xF6D0, 0x0B9B, 0xFF28, 0x185F, 0x08E6,
0x15B7, 0x0E5C, 0x09FD, 0x0BD9, 0x04FC, 0x06F5, 0x047D, 0x041D,
0x07B0, 0x0214, 0x0B7D, 0x029A, 0x0A22, 0x0330, 0x0845, 0x0443,
0x0369, 0x0499, 0xF797, 0xFE1D, 0xED1B, 0xF80D, 0xED3E, 0xF8E4,
0xF573, 0xFA88, 0xFE11, 0xF9A5, 0x062C, 0xFDFC, 0x07C5, 0x0908,
0xFE98, 0x0DCC, 0xF5C8, 0x080F, 0xF58A, 0x0108, 0xF9B3, 0xFE5C,
0xFDB5, 0xFB75, 0x0143, 0xF7F8, 0x068A, 0xFBB9, 0x0F45, 0x0322,
0x0E57, 0x0334, 0xFDFE, 0xFBD1, 0xF2BB, 0xF5EE, 0xF452, 0xF553,
0xFC5F, 0xF964, 0x06B1, 0x0171, 0x0ECA, 0x074B, 0x1179, 0x0BE2,
0x0C8A, 0x11B0, 0x05E2, 0x0EEB, 0x0015, 0x078E, 0xFC88, 0x0681,
0xFF40, 0x0371, 0x0287, 0xFB09, 0x0314, 0xFADD, 0x0092, 0x0347,
0xF738, 0x032E, 0xE975, 0xF86F, 0xE327, 0xEFEE, 0xE88A, 0xEF3D,
0xF1BB, 0xF296, 0xFB9A, 0xF611, 0x088A, 0xFD53, 0x150A, 0x08BD,
0x1562, 0x0FCF, 0x0B62, 0x0C4B, 0x055C, 0x0547, 0x036B, 0x0383,
0x0472, 0x01CF, 0x0950, 0x007E, 0x0AB7, 0x0318, 0x0927, 0x0622,
0x0523, 0x06D2, 0xFA55, 0x0074, 0xEE9F, 0xF88B, 0xEC8E, 0xF8CE,
0xF478, 0xFB7D, 0xFE02, 0xFA53, 0x0658, 0xFCC2, 0x08AF, 0x0762,
0x009E, 0x0E7F, 0xF7A9, 0x09B6, 0xF539, 0x00E7, 0xF741, 0xFCDF,
0xFB3D, 0xFA58, 0xFFA3, 0xF65E, 0x03FB, 0xF937, 0x0B2C, 0x01C8,
0x0D57, 0x03C0, 0x005B, 0xFD0A, 0xF38C, 0xF61F, 0xF312, 0xF484,
0xF99C, 0xF6C4, 0x036B, 0xFDA2, 0x0CBB, 0x05F1, 0x10BB, 0x0B50,
0x0CEF, 0x1114, 0x0732, 0x1052, 0x0147, 0x082E, 0xFB83, 0x0658,
0xFD8E, 0x05A5, 0x025B, 0xFCF8, 0x0305, 0xF90D, 0x0133, 0x0114,
0xF988, 0x03F6, 0xEB8D, 0xFA78, 0xE332, 0xF102, 0xE706, 0xEDC3,
0xEFF0, 0xEFBE, 0xF91A, 0xF311, 0x03FD, 0xF8F3, 0x0FEB, 0x0471,
0x1340, 0x0DEA, 0x0B3E, 0x0C28, 0x049D, 0x03A2, 0x028F, 0x0099,
0x029F, 0xFFD9, 0x06A1, 0xFE7B, 0x0998, 0x021B, 0x098D, 0x05EA,
0x0599, 0x0648, 0xFB5C, 0x01AE, 0xF037, 0xF953, 0xEB97, 0xF716,
0xF199, 0xFAC7, 0xFC34, 0xFAEF, 0x04C7, 0xFADC, 0x07AB, 0x042C,
0x00A2, 0x0DA3, 0xF710, 0x09CE, 0xF331, 0x0006, 0xF47D, 0xFB29,
0xF8B0, 0xF910, 0xFD46, 0xF514, 0x00D9, 0xF5DF, 0x06D8, 0xFF12,
0x0A90, 0x03EA, 0xFFC0, 0xFE1C, 0xF218, 0xF593, 0xF0BD, 0xF206,
0xF66B, 0xF36D, 0xFF0A, 0xF90B, 0x08FC, 0x028F, 0x0EDD, 0x0A69,
0x0C32, 0x10A4, 0x06AB, 0x10D9, 0x01E4, 0x0818, 0xFB86, 0x04D2,
0xFB7A, 0x0623, 0x0165, 0xFF85, 0x04A2, 0xF97F, 0x0452, 0xFFB3,
0xFD0E, 0x056B, 0xEE3B, 0xFD53, 0xE3D8, 0xF22E, 0xE5D1, 0xEDC8,
0xEE03, 0xEE4C, 0xF6DB, 0xF0D1, 0x009B, 0xF5FD, 0x0B2B, 0x0104,
0x10AA, 0x0CB6, 0x0BA9, 0x0D4C, 0x0425, 0x03D5, 0x00B2, 0xFF47,
0x0063, 0xFEE7, 0x043A, 0xFC70, 0x07D1, 0xFF87, 0x094D, 0x05A3,
0x0732, 0x0742, 0xFD33, 0x0351, 0xF1B5, 0xFAD6, 0xECDB, 0xF717,
0xF282, 0xFB2C, 0xFCDA, 0xFCE1, 0x04C8, 0xFB40, 0x09A1, 0x022C,
0x054E, 0x0E7E, 0xFAA1, 0x0D83, 0xF51E, 0x01BF, 0xF624, 0xFBB1,
0xF95C, 0xFA57, 0xFD9A, 0xF60C, 0x0144, 0xF476, 0x068E, 0xFCDB,
0x0BE1, 0x04A7, 0x0311, 0x008F, 0xF41A, 0xF662, 0xF149, 0xF1D1,
0xF695, 0xF3A8, 0xFE88, 0xF6D6, 0x0779, 0xFF29, 0x0DE7, 0x09B5,
0x0DD3, 0x1057, 0x090A, 0x1170, 0x045E, 0x0A4D, 0xFE15, 0x0581,
0xFCC0, 0x0712, 0x02D9, 0x02E6, 0x05D0, 0xFBEC, 0x063D, 0xFF6E,
0x0299, 0x06B9, 0xF374, 0x0124, 0xE511, 0xF474, 0xE5EA, 0xEEA2,
0xEEF3, 0xEFAF, 0xF6B0, 0xF142, 0xFEF1, 0xF415, 0x0924, 0xFEAB,
0x1012, 0x0C00, 0x0D39, 0x0EA8, 0x0558, 0x0524, 0x01A0, 0xFF1C,
0x0178, 0xFFF6, 0x0438, 0xFCF5, 0x076D, 0xFDBC, 0x091B, 0x058F,
0x08CB, 0x08DB, 0x008C, 0x04FD, 0xF47F, 0xFC28, 0xEE34, 0xF6EB,
0xF21A, 0xFA9B, 0xFC3B, 0xFD52, 0x04D0, 0xFC7E, 0x0A41, 0x0247,
0x0856, 0x0E2E, 0xFF5B, 0x0F96, 0xF7FC, 0x041B, 0xF732, 0xFCDD,
0xFAB6, 0xFBEE, 0xFECA, 0xF7F2, 0x018F, 0xF544, 0x05C8, 0xFC54,
0x0C1C, 0x04F7, 0x0533, 0x025B, 0xF495, 0xF796, 0xF070, 0xF1D3,
0xF57C, 0xF3C6, 0xFBBF, 0xF535, 0x0490, 0xFAD2, 0x0C07, 0x078D,
0x0D26, 0x1121, 0x0997, 0x12C7, 0x05D9, 0x0B6E, 0x0000, 0x0509,
0xFCB0, 0x06ED, 0x0202, 0x04F6, 0x069A, 0xFDB4, 0x07DE, 0xFF34,
0x069F, 0x07D5, 0xF95C, 0x0588, 0xE8B5, 0xF888, 0xE765, 0xF177,
0xEFEF, 0xF20F, 0xF705, 0xF297, 0xFE68, 0xF3E6, 0x0719, 0xFD00,
0x0E8B, 0x0AEF, 0x0E5E, 0x1005, 0x064E, 0x0777, 0x0181, 0xFF63,
0x0144, 0xFFFC, 0x02CA, 0xFD42, 0x0515, 0xFAE7, 0x06C4, 0x02C6,
0x0829, 0x08D1, 0x016B, 0x0575, 0xF4D2, 0xFC9F, 0xEE66, 0xF6D4,
0xF0EE, 0xFA27, 0xFA25, 0xFDA1, 0x0457, 0xFC31, 0x0B68, 0xFFF8,
0x0B6F, 0x0CCF, 0x0416, 0x123D, 0xFC63, 0x07A3, 0xFA23, 0xFED5,
0xFD5E, 0xFEA5, 0x0140, 0xFB44, 0x0279, 0xF614, 0x0417, 0xFACA,
0x09A3, 0x044D, 0x0641, 0x038E, 0xF5B2, 0xF949, 0xEE50, 0xF210,
0xF3C6, 0xF3B7, 0xF999, 0xF5A9, 0x005B, 0xF855, 0x0844, 0x03EF,
0x0B6E, 0x0F13, 0x08BB, 0x10E7, 0x049E, 0x0A11, 0xFF4C, 0x0325,
0xFBE0, 0x04A7, 0x00A0, 0x046A, 0x05D3, 0xFDEF, 0x0781, 0xFE06,
0x0866, 0x06B7, 0xFDD2, 0x07BE, 0xEAB6, 0xFB27, 0xE659, 0xF1FB,
0xF0D0, 0xF363, 0xF85C, 0xF507, 0xFE43, 0xF4D9, 0x07B4, 0xFBDE,
0x0FED, 0x0A06, 0x116E, 0x10CB, 0x0929, 0x08FC, 0x017B, 0xFF0E,
0x012F, 0xFECA, 0x021F, 0xFDE3, 0x02FF, 0xF99D, 0x05CB, 0x0013,
0x08C0, 0x08DE, 0x023D, 0x064B, 0xF3DC, 0xFD37, 0xEC68, 0xF6B7,
0xEDEA, 0xF87B, 0xF4C7, 0xFC11, 0xFF70, 0xFACC, 0x0957, 0xFD23,
0x0CAD, 0x093B, 0x07A5, 0x11A1, 0xFED4, 0x0987, 0xFA8F, 0xFF14,
0xFE56, 0xFE63, 0x0288, 0xFC4A, 0x02A9, 0xF6A0, 0x048B, 0xFA53,
0x0BCD, 0x04C3, 0x0B3C, 0x065D, 0xFAE7, 0xFDEC, 0xF0E1, 0xF65D,
0xF567, 0xF68B, 0xF982, 0xF798, 0xFE56, 0xF760, 0x06A6, 0x007F,
0x0A92, 0x0C8C, 0x0921, 0x0F80, 0x05E7, 0x09CB, 0x009A, 0x02B5,
0xFBE0, 0x02DF, 0xFE09, 0x0360, 0x02CC, 0xFD99, 0x053E, 0xFBEF,
0x07B3, 0x0318, 0x0092, 0x0632, 0xEDAD, 0xFBC2, 0xE5F8, 0xF20D,
0xF039, 0xF3C6, 0xF9B0, 0xF5F8, 0xFF09, 0xF48E, 0x0708, 0xF9E5,
0x0EE1, 0x07CC, 0x12A7, 0x102C, 0x0DA7, 0x0A86, 0x05D0, 0x0144,
0x04B4, 0x00FA, 0x0561, 0x012B, 0x04F9, 0xFBE4, 0x0744, 0x00DD,
0x0A4E, 0x0B26, 0x04B1, 0x0924, 0xF706, 0xFF56, 0xEE87, 0xF83D,
0xEDD2, 0xF8D8, 0xF212, 0xFBC1, 0xFC8A, 0xFA66, 0x07AA, 0xFB6A,
0x0AE2, 0x0529, 0x0635, 0x0E1A, 0xFDFB, 0x077D, 0xF7EC, 0xFBBF,
0xFA8F, 0xFB3B, 0x0063, 0xFB11, 0x01CF, 0xF50C, 0x0468, 0xF826,
0x0BB2, 0x04A5, 0x0CDB, 0x0808, 0xFF56, 0x0020, 0xF37D, 0xF935,
0xF627, 0xF904, 0xFA80, 0xF9BA, 0xFE94, 0xF7FF, 0x0853, 0xFFAC,
0x0E30, 0x0DBE, 0x0C82, 0x1229, 0x08F2, 0x0C78, 0x0334, 0x0496,
0xFCA5, 0x02C3, 0xFB2E, 0x030B, 0xFE5A, 0xFD6D, 0x02D9, 0xFA68,
0x06E3, 0x00A0, 0x01C1, 0x059B, 0xF00C, 0xFD8A, 0xE420, 0xF22E,
0xEAAB, 0xF1BB, 0xF45D, 0xF3B7, 0xF91B, 0xF0B7, 0x00DA, 0xF321,
0x09E3, 0x00F3, 0x1032, 0x0C8C, 0x0E10, 0x09D9, 0x0516, 0x0198,
0x02ED, 0x00A5, 0x04AE, 0x01EE, 0x0310, 0xFCC6, 0x04DC, 0xFEF5,
0x09ED, 0x0AE4, 0x06A5, 0x0BED, 0xFAC9, 0x02F8, 0xF304, 0xFD7F,
0xF228, 0xFDB1, 0xF38A, 0xFEED, 0xFA25, 0xFCD7, 0x053B, 0xFBA1,
0x0A5D, 0x0197, 0x0708, 0x0A25, 0xFF3C, 0x071C, 0xF719, 0xFB73,
0xF782, 0xF8DA, 0xFD82, 0xFA7B, 0xFEB2, 0xF562, 0xFF7E, 0xF440,
0x04C8, 0xFE88, 0x0754, 0x0503, 0xFDAB, 0xFEFA, 0xF12B, 0xF784,
0xF2FC, 0xF71E, 0xF9EB, 0xF9C4, 0xFD8C, 0xF893, 0x0627, 0xFD37,
0x0DEB, 0x0BC9, 0x0D86, 0x1273, 0x0A2E, 0x0C7B, 0x05B4, 0x0510,
0x0070, 0x03FF, 0xFDF5, 0x051E, 0xFFDD, 0x0120, 0x0538, 0xFE78,
0x09F2, 0x02AD, 0x05AC, 0x0647, 0xF4F5, 0x002C, 0xE5D4, 0xF4E9,
0xE829, 0xF174, 0xF261, 0xF2D6, 0xF83F, 0xF0B5, 0xFF5A, 0xF160,
0x071E, 0xFCC2, 0x0C84, 0x0963, 0x0C3F, 0x081D, 0x0307, 0xFEAB,
0xFE31, 0xFBF6, 0x0060, 0xFDF6, 0xFF6E, 0xFA68, 0x012E, 0xFAC0,
0x07AD, 0x0749, 0x070D, 0x0C45, 0xFCF1, 0x03E2, 0xF3D2, 0xFDCD,
0xF21B, 0xFD93, 0xF35A, 0xFE11, 0xF816, 0xFC4B, 0x0456, 0xFBF8,
0x0CFA, 0x019D, 0x0AEB, 0x0A29, 0x03DD, 0x0A13, 0xFAB8, 0xFF16,
0xF79B, 0xF99E, 0xFBCC, 0xF9BF, 0xFC2D, 0xF40C, 0xFC20, 0xF10F,
0x0155, 0xF9AC, 0x04AF, 0x01A7, 0xFE36, 0xFDD7, 0xF1E7, 0xF734,
0xEF6B, 0xF636, 0xF4FF, 0xF77D, 0xF876, 0xF54B, 0xFF8A, 0xF6D6,
0x07FE, 0x0465, 0x0991, 0x0E9E, 0x07AB, 0x0AA4, 0x045C, 0x03A6,
0x0019, 0x0350, 0xFD7D, 0x049B, 0xFDAE, 0x0080, 0x02E9, 0xFDFD,
0x093A, 0x01D5, 0x070F, 0x04C6, 0xFA04, 0x0112, 0xEB3D, 0xF8D7,
0xE975, 0xF50D, 0xF2B7, 0xF5FB, 0xF971, 0xF3BD, 0xFF29, 0xF252,
0x052F, 0xFA7B, 0x093F, 0x063B, 0x0A85, 0x0713, 0x0270, 0xFEE1,
0xFB28, 0xFB58, 0xFDAA, 0xFCCF, 0xFE0A, 0xF9C2, 0xFE42, 0xF85E,
0x04C9, 0x02E9, 0x05D4, 0x09B3, 0xFC61, 0x028D, 0xF322, 0xFBF5,
0xF1A8, 0xFC22, 0xF401, 0xFD84, 0xF7B2, 0xFC90, 0x0275, 0xFC4D,
0x0DBA, 0x0108, 0x0E6B, 0x08BF, 0x077A, 0x0AD5, 0xFD24, 0x01E3,
0xF7CF, 0xFADD, 0xFC45, 0xFBBE, 0xFF0A, 0xF895, 0xFF93, 0xF500,
0x04BE, 0xFBE9, 0x082A, 0x0491, 0x0375, 0x0289, 0xF80A, 0xFBC7,
0xF19C, 0xF909, 0xF589, 0xF945, 0xF9E8, 0xF73B, 0xFF5B, 0xF5F9,
0x0801, 0x00B9, 0x0BBD, 0x0DB2, 0x09CB, 0x0BFD, 0x04CB, 0x0360,
0xFEF8, 0x012F, 0xFC01, 0x0250, 0xFBCD, 0xFEE6, 0x00DD, 0xFC3E,
0x0958, 0xFFDB, 0x0A48, 0x03B4, 0x008C, 0x030E, 0xF32F, 0xFD1A,
0xEE5F, 0xF7C1, 0xF516, 0xF838, 0xFBD2, 0xF785, 0x0175, 0xF54D,
0x07F3, 0xFAA6, 0x0BDB, 0x0655, 0x0E3E, 0x0AF0, 0x093B, 0x0489,
0x006C, 0xFFB1, 0xFF0B, 0x0064, 0xFF09, 0xFD86, 0xFF69, 0xF976,
0x0569, 0x006F, 0x0753, 0x09BB, 0xFF80, 0x05E5, 0xF7A2, 0xFE90,
0xF561, 0xFE40, 0xF588, 0xFF10, 0xF76D, 0xFD06, 0x007D, 0xFC36,
0x0B7B, 0xFF30, 0x0CAA, 0x047B, 0x0789, 0x07B7, 0xFFEE, 0x0252,
0xF96E, 0xFB53, 0xFB8A, 0xFB76, 0xFFB9, 0xFA7C, 0x01EF, 0xF7CD,
0x05F9, 0xFC3E, 0x07DF, 0x0432, 0x04C6, 0x0532, 0xFC23, 0x00A7,
0xF4CD, 0xFE4C, 0xF787, 0xFE16, 0xFC68, 0xFC87, 0x0077, 0xFB07,
0x0856, 0x0249, 0x0C76, 0x0E8B, 0x0976, 0x0EB3, 0x0495, 0x0522,
0xFFF5, 0x0164, 0xFCBB, 0x0298, 0xFB02, 0xFFCB, 0xFEE6, 0xFD07,
0x088E, 0xFFE1, 0x0A9A, 0x02CA, 0x009A, 0x01E3, 0xF359, 0xFD57,
0xECDF, 0xF83A, 0xF1AF, 0xF723, 0xF922, 0xF636, 0xFFEE, 0xF4D1,
0x07F4, 0xF987, 0x0BA2, 0x0406, 0x0CDC, 0x0A37, 0x09BA, 0x065D,
0x00CB, 0x0169, 0xFDE1, 0x0090, 0xFF5A, 0xFEBC, 0x0022, 0xFC3F,
0x05C6, 0x0165, 0x0A34, 0x0B45, 0x03F3, 0x0B85, 0xFA0B, 0x04E2,
0xF5E9, 0x02F0, 0xF63B, 0x02FD, 0xF70F, 0xFF3B, 0xFCE5, 0xFBEC,
0x08E7, 0xFE4F, 0x0DDA, 0x0301, 0x08BB, 0x0561, 0x0058, 0x01F3,
0xF8BF, 0xFB07, 0xF8A2, 0xF895, 0xFC03, 0xF708, 0xFE14, 0xF3A0,
0x0393, 0xF657, 0x073B, 0xFEB1, 0x045E, 0x0316, 0xFDA2, 0x014F,
0xF671, 0x0007, 0xF684, 0x009C, 0xFB59, 0xFEEF, 0xFF60, 0xFBB8,
0x0608, 0xFF37, 0x0B88, 0x0B3F, 0x0AD7, 0x101C, 0x068B, 0x0870,
0x016F, 0x0450, 0xFE5C, 0x0645, 0xFD25, 0x035D, 0xFED8, 0xFEA1,
0x067A, 0xFF3D, 0x0AD0, 0x0145, 0x037A, 0x00EC, 0xF676, 0xFE1F,
0xEDAC, 0xF954, 0xEFD0, 0xF770, 0xF742, 0xF722, 0xFD00, 0xF499,
0x0372, 0xF57D, 0x0768, 0xFD26, 0x087C, 0x03FB, 0x072C, 0x01E5,
0x0024, 0xFDDA, 0xFCB2, 0xFECD, 0xFEDD, 0xFEE9, 0x0043, 0xFC7D,
0x04E8, 0xFED4, 0x0A1C, 0x084A, 0x062D, 0x0CCE, 0xFCE5, 0x06BE,
0xF851, 0x0316, 0xF8F1, 0x05DB, 0xFADE, 0x04CA, 0xFF82, 0x0066,
0x095B, 0x012B, 0x0FF9, 0x0581, 0x0C32, 0x06FA, 0x0289, 0x0256,
0xF94B, 0xFA83, 0xF7AA, 0xF732, 0xFB30, 0xF665, 0xFDB6, 0xF386,
0x02D7, 0xF43D, 0x0676, 0xFB00, 0x037C, 0x009C, 0xFD42, 0xFFCF,
0xF5F1, 0xFDBA, 0xF46A, 0xFE42, 0xF970, 0xFD1B, 0xFE14, 0xFA1A,
0x03F2, 0xFC8C, 0x0A7F, 0x0791, 0x0BA8, 0x0F5E, 0x0790, 0x0A66,
0x029F, 0x0482, 0xFF7E, 0x05A6, 0xFE29, 0x04A9, 0x0028, 0x0088,
0x0849, 0x00C6, 0x0EA9, 0x03CD, 0x08DF, 0x0518, 0xFBCF, 0x037A,
0xF236, 0xFE62, 0xF1D3, 0xFAE1, 0xF776, 0xF94A, 0xFC5F, 0xF560,
0x0264, 0xF502, 0x077F, 0xFB90, 0x080F, 0x01F2, 0x06BE, 0x0147,
0x00EF, 0xFE1E, 0xFB55, 0xFDB6, 0xFC07, 0xFBF1, 0xFE32, 0xF8D2,
0x0238, 0xF996, 0x0791, 0x0123, 0x05B7, 0x0900, 0xFD5E, 0x07F4,
0xF84A, 0x04A7, 0xF8AC, 0x0711, 0xFB1F, 0x06BF, 0xFF02, 0x01FC,
0x0707, 0x0226, 0x0F29, 0x05BF, 0x0E77, 0x0751, 0x0645, 0x0524,
0xFD06, 0xFF6D, 0xF9BE, 0xFB86, 0xFCA8, 0xFA19, 0xFEF0, 0xF755,
0x02CF, 0xF5A7, 0x06C7, 0xF8E9, 0x034B, 0xFEAF, 0xFC06, 0xFFA8,
0xF5D7, 0xFDA9, 0xF40E, 0xFF37, 0xF817, 0xFE7E, 0xFBF7, 0xF930,
0xFFDC, 0xF8C7, 0x0628, 0x016B, 0x08B8, 0x0A08, 0x056B, 0x0713,
0x0150, 0x00E0, 0xFE88, 0x030A, 0xFD24, 0x0413, 0xFF07, 0x0021,
0x061A, 0xFFD2, 0x0D3C, 0x02CC, 0x0A41, 0x0492, 0xFDED, 0x042A,
0xF2B9, 0x00E0, 0xF150, 0xFDCC, 0xF845, 0xFC90, 0xFDD3, 0xF9EC,
0x01F9, 0xF869, 0x06EB, 0xFC26, 0x0816, 0x0256, 0x05E5, 0x02CE,
0x0061, 0xFEA2, 0xFAB3, 0xFDA4, 0xFA36, 0xFC8A, 0xFBAE, 0xF8EF,
0xFEEF, 0xF7F2, 0x0519, 0xFDA3, 0x051F, 0x066A, 0xFBBA, 0x06CD,
0xF54B, 0x015D, 0xF66B, 0x0355, 0xF88D, 0x056B, 0xFB4C, 0xFF67,
0x027F, 0xFD3B, 0x0B89, 0x021E, 0x0D63, 0x058C, 0x06CC, 0x0408,
0xFDED, 0xFF11, 0xF8D1, 0xFB6A, 0xFABC, 0xFA1A, 0xFE31, 0xF80C,
0x00FC, 0xF632, 0x0568, 0xF875, 0x04BB, 0xFF77, 0xFDC5, 0x0399,
0xF733, 0x017B, 0xF48D, 0x0134, 0xF786, 0x0141, 0xFB35, 0xFBFD,
0xFD71, 0xF853, 0x026C, 0xFD44, 0x06E9, 0x067D, 0x04FB, 0x06D5,
0xFFEE, 0xFFC2, 0xFD02, 0x0006, 0xFB7A, 0x02B9, 0xFC37, 0xFE7A,
0x01D7, 0xFB3B, 0x08F3, 0xFDDB, 0x0837, 0x0150, 0xFDD7, 0x0243,
0xF35C, 0x0000, 0xF058, 0xFD68, 0xF57C, 0xFC15, 0xFBC5, 0xF8CB,
0xFFA9, 0xF6B0, 0x0473, 0xF9A6, 0x06B0, 0xFF5A, 0x04BA, 0x01CF,
0x00C5, 0xFF49, 0xFC76, 0xFF2D, 0xFB86, 0x0050, 0xFCD8, 0xFD8B,
0xFEF6, 0xFA90, 0x02F3, 0xFC56, 0x03BE, 0x0437, 0xFC65, 0x082E,
0xF4E5, 0x02DE, 0xF51E, 0x0221, 0xF829, 0x056A, 0xFA89, 0x00A0,
0xFFBE, 0xFB9B, 0x077B, 0xFE63, 0x0A93, 0x0243, 0x05C2, 0x00FA,
0xFD4F, 0xFC8F, 0xF75E, 0xF942, 0xF821, 0xF7B2, 0xFCC0, 0xF6D7,
0x00BF, 0xF635, 0x0445, 0xF7A2, 0x03E6, 0xFDA1, 0xFD69, 0x0374,
0xF696, 0x0383, 0xF47A, 0x036B, 0xF7E6, 0x0418, 0xFBBA, 0xFFDE,
0xFDFD, 0xFB8D, 0x032A, 0xFE7A, 0x0858, 0x0707, 0x06C0, 0x0975,
0x01A2, 0x0259, 0xFF4E, 0xFFC1, 0xFD4B, 0x02BC, 0xFC90, 0x0034,
0x01B3, 0xFBE2, 0x0890, 0xFD13, 0x08EC, 0x00DB, 0xFFE0, 0x02AA,
0xF53E, 0x0125, 0xF0F5, 0xFE6A, 0xF36A, 0xFBF7, 0xF937, 0xF7E6,
0xFE7F, 0xF51A, 0x0369, 0xF774, 0x062D, 0xFD32, 0x04CA, 0x00A7,
0x01E1, 0xFF0D, 0xFE04, 0xFECB, 0xFB3F, 0x003A, 0xFC40, 0xFE00,
0xFEF2, 0xFB28, 0x024C, 0xFCCA, 0x0476, 0x044B, 0xFF89, 0x0A85,
0xF85B, 0x0868, 0xF897, 0x0726, 0xFB86, 0x09A5, 0xFCE4, 0x0513,
0x00C0, 0xFE17, 0x079D, 0xFF19, 0x0B83, 0x035F, 0x07D9, 0x0260,
0x0092, 0xFD79, 0xFA59, 0xFA36, 0xF7D1, 0xF840, 0xFACE, 0xF5D5,
0xFF84, 0xF477, 0x02BB, 0xF57E, 0x023F, 0xF9F5, 0xFC55, 0xFFD4,
0xF6CE, 0x01BF, 0xF5C3, 0x0304, 0xF826, 0x04F6, 0xFBDE, 0x00EA,
0xFEA6, 0xFBED, 0x0204, 0xFE16, 0x063D, 0x0594, 0x06A6, 0x09E5,
0x0324, 0x0552, 0x0153, 0x0214, 0xFFFA, 0x05A9, 0xFEC1, 0x0535,
0x02B5, 0x008C, 0x094F, 0x005A, 0x0A9E, 0x03CB, 0x0284, 0x0549,
0xF7B7, 0x034B, 0xF30C, 0x009E, 0xF50D, 0xFDD1, 0xFA25, 0xF8EA,
0xFF0A, 0xF53F, 0x0410, 0xF658, 0x06B9, 0xFA87, 0x0498, 0xFE34,
0x01FF, 0xFDF4, 0xFF4D, 0xFD68, 0xFC37, 0xFEE6, 0xFC4F, 0xFD83,
0xFF37, 0xFABA, 0x025B, 0xFBA8, 0x03F6, 0x0241, 0x0072, 0x09FA,
0xF979, 0x09B7, 0xF8C4, 0x0745, 0xFD7B, 0x0A0B, 0xFFC8, 0x087C,
0x026C, 0x01D6, 0x0908, 0x0081, 0x0E14, 0x04D0, 0x0BA9, 0x05E7,
0x04F5, 0x0182, 0xFEF4, 0xFDE1, 0xFAC8, 0xFB80, 0xFB27, 0xF84C,
0xFF41, 0xF5F8, 0x0276, 0xF5CF, 0x01E9, 0xF969, 0xFC43, 0xFFAD,
0xF6A6, 0x021B, 0xF592, 0x0224, 0xF751, 0x0395, 0xF9F3, 0x0032,
0xFC97, 0xF9F8, 0x0074, 0xF9AF, 0x04D5, 0x0066, 0x05FE, 0x06DE,
0x0372, 0x04F3, 0x0222, 0x0182, 0x016E, 0x0476, 0xFF98, 0x0635,
0x02C0, 0x02A2, 0x08A9, 0x0146, 0x09C3, 0x0556, 0x03F2, 0x085E,
0xFB86, 0x06EF, 0xF739, 0x04CF, 0xF754, 0x0324, 0xFACE, 0xFE4D,
0xFFAC, 0xF89C, 0x03CC, 0xF82D, 0x0634, 0xFB9E, 0x0448, 0xFE7C,
0x01AB, 0xFE73, 0x0073, 0xFE1B, 0xFCBE, 0xFF5B, 0xFA9C, 0xFE05,
0xFD9E, 0xFAAC, 0x0027, 0xF9C0, 0x0021, 0xFE93, 0xFDEC, 0x06A5,
0xF8C3, 0x0813, 0xF7DC, 0x0563, 0xFCF1, 0x075F, 0xFFF1, 0x072C,
0x0230, 0x0143, 0x07D4, 0xFFAD, 0x0CE2, 0x03E0, 0x0B81, 0x04F7,
0x05CC, 0x0210, 0x00DF, 0x0040, 0xFC03, 0xFE8B, 0xFB6F, 0xFB99,
0x015E, 0xF9C3, 0x04B1, 0xF97A, 0x021D, 0xFBFB, 0xFD12, 0x01F0,
0xF846, 0x03D6, 0xF6F5, 0x02EB, 0xF8D1, 0x0510, 0xFA8D, 0x023F,
0xFCB0, 0xFB45, 0x00B2, 0xF9CA, 0x0437, 0xFE1C, 0x044B, 0x02AC,
0x0111, 0x02D4, 0x0082, 0x008E, 0x0157, 0xFFE2, 0xFEF9, 0x010C,
0x003A, 0x003D, 0x0573, 0xFE94, 0x084B, 0x02A1, 0x05FE, 0x0765,
0xFEBB, 0x05E1, 0xF7DF, 0x0421, 0xF6CC, 0x046C, 0xFC58, 0xFFD3,
0x0281, 0xF8AF, 0x0437, 0xF7DB, 0x03A0, 0xFB76, 0x0265, 0xFEA9,
0x0294, 0x0039, 0x041F, 0x00C4, 0xFFCC, 0x0034, 0xF90B, 0xFF1A,
0xFC25, 0xFF73, 0x0200, 0xFC64, 0x0058, 0xFC8A, 0xFC95, 0x03EA,
0xF780, 0x06A7, 0xF67A, 0x0631, 0xFF59, 0x0771, 0x049C, 0x05D1,
0x0283, 0xFEFD, 0x0515, 0xFE53, 0x0CC7, 0x04DB, 0x0DE8, 0x0369,
0x0730, 0xFDC8, 0x009C, 0xFC81, 0xF9E2, 0xFBEB, 0xF894, 0xFAE7,
0x0279, 0xFB3F, 0x084A, 0xFA45, 0x02D1, 0xFB6B, 0xFDBF, 0x04AA,
0xFBBF, 0x0864, 0xFA4D, 0x03D4, 0xFB93, 0x0547, 0xFC11, 0x048F,
0xFB08, 0xFD55, 0x0068, 0xFC61, 0x07D2, 0x0230, 0x0860, 0x04D8,
0x04E8, 0x0418, 0x037A, 0x0589, 0x02D3, 0x0152, 0xFE25, 0xFC68,
0xFDB4, 0xFE37, 0x01F4, 0xFC9B, 0x0391, 0xFF17, 0x05A2, 0x077E,
0x03E5, 0x0810, 0xFE55, 0x0395, 0xFC85, 0x05A9, 0xFEE6, 0x039A,
0x009E, 0xF53C, 0x009D, 0xF2E0, 0x0116, 0xF9BD, 0xFF09, 0xFB08,
0xFFE5, 0xFD66, 0x05BE, 0x01BD, 0x066B, 0x046E, 0x019F, 0x0329,
0x0080, 0x0516, 0x0272, 0x00E0, 0xFD5C, 0xF9DB, 0xF6E7, 0x029C,
0xF420, 0x0802, 0xF568, 0x0717, 0x0139, 0x0A7A, 0x0ADB, 0x0B12,
0x0B16, 0x0537, 0x0ADE, 0x01E7, 0x0C4F, 0x06BD, 0x0AB2, 0x011F,
0x0195, 0xF792, 0xF8BA, 0xF7C3, 0xF432, 0xF81F, 0xF71B, 0xF884,
0x0392, 0xF8A8, 0x0C7F, 0xFAD8, 0x0A42, 0xFDAD, 0xFEFE, 0x0359,
0xF583, 0x0534, 0xF3FB, 0xFD79, 0xF3E6, 0xFD51, 0xF28A, 0xFDCF,
0xF7BC, 0xFF4C, 0x0645, 0x037D, 0x10FE, 0x0608, 0x14E5, 0x0BAE,
0x0E93, 0x0AED, 0x0103, 0x06A9, 0xFB4F, 0xFE33, 0xF77C, 0xF915,
0xF389, 0xF7D2, 0xF6FA, 0xF5E4, 0x049E, 0x0412, 0x10BB, 0x0E15,
0x104F, 0x0CD6, 0x0AA9, 0x0C4F, 0xFF52, 0x0875, 0xF330, 0xFC79,
0xEE19, 0xEA1E, 0xEEEC, 0xE8A9, 0xF17D, 0xED13, 0xF812, 0xF3A7,
0x077B, 0x045E, 0x1344, 0x0833, 0x1478, 0x06FD, 0x0A4A, 0x096E,
0xFBA1, 0x0567, 0xF1F4, 0xF669, 0xEBF9, 0xF1C2, 0xEA70, 0xFBD5,
0xEC4F, 0xFF14, 0xF9F0, 0x0A32, 0x10CD, 0x1539, 0x1C0F, 0x12C7,
0x165A, 0x0BFF, 0x0B2F, 0x0723, 0x00F4, 0x01D6, 0xF65B, 0xF31D,
0xF13D, 0xF0D6, 0xEFF6, 0xF31C, 0xF56C, 0xF3E7, 0x042A, 0x005F,
0x1170, 0x020C, 0x1601, 0xFE33, 0x0B2C, 0xFFB3, 0xF9A7, 0x0210,
0xE6D5, 0xF966, 0xDD71, 0xEEA2, 0xE70A, 0xF6A0, 0xF085, 0xFAC2,
0xFF69, 0xFF76, 0x1362, 0x0A1B, 0x19BC, 0x0BAD, 0x13D7, 0x0A32,
0x0698, 0x097B, 0xF676, 0x01A0, 0xE8A2, 0xEE72, 0xE72A, 0xECDF,
0xEECC, 0xF5C2, 0xFEB9, 0xFA5B, 0x1592, 0x0A32, 0x1F02, 0x160B,
0x18DC, 0x16D7, 0x0975, 0x104F, 0xF981, 0x0905, 0xE8FE, 0xF4E4,
0xDDA4, 0xDE27, 0xE341, 0xE25E, 0xEF0E, 0xEA03, 0x0563, 0xF7E0,
0x1836, 0x0844, 0x1945, 0x0A6A, 0x135F, 0x09C2, 0x00F8, 0x06D2,
0xEDA3, 0xFD3F, 0xE303, 0xE86E, 0xDEAF, 0xE4E6, 0xE190, 0xF267,
0xF010, 0xFE77, 0x0A33, 0x1155, 0x1C51, 0x1993, 0x1E44, 0x158C,
0x119C, 0x0DAE, 0xFFC4, 0x06B5, 0xF24F, 0xF7D0, 0xEC8D, 0xE988,
0xEBEF, 0xEE92, 0xF006, 0xF16A, 0x0483, 0xFDBE, 0x144F, 0x0AD6,
0x1751, 0x06F8, 0x1612, 0x033A, 0x04AE, 0xFFD5, 0xED97, 0xFC46,
0xDE7C, 0xEF44, 0xDD80, 0xECE2, 0xE50B, 0xF65E, 0xF54B, 0xFB6D,
0x0D15, 0x0924, 0x1731, 0x0D22, 0x1658, 0x089A, 0x0BE1, 0x05DC,
0xF866, 0x000B, 0xE879, 0xF2C1, 0xE4FB, 0xE6F3, 0xEA32, 0xEDF5,
0xF265, 0xF64C, 0x0BB8, 0x0535, 0x21C7, 0x149C, 0x206E, 0x1619,
0x1529, 0x154F, 0x0257, 0x0DA9, 0xEE45, 0xFFF7, 0xE266, 0xEBF7,
0xE43C, 0xE58C, 0xECA7, 0xEB57, 0xFE2E, 0xF449, 0x17DB, 0x0940,
0x1FA1, 0x0F5D, 0x182D, 0x0A78, 0x09EB, 0x068C, 0xF3BC, 0xFF4D,
0xE166, 0xEF18, 0xDFD8, 0xE1A3, 0xE473, 0xEB19, 0xE7A2, 0xF59A,
0xFDCD, 0x080C, 0x1595, 0x19BC, 0x1B91, 0x15D8, 0x1673, 0x0F5C,
0x04F1, 0x07DB, 0xF1F0, 0xFC1D, 0xEAB8, 0xEA54, 0xF0FA, 0xE993,
0xF3D3, 0xF36B, 0xFDEF, 0xF9BD, 0x16CB, 0x0C46, 0x1DBB, 0x0FB7,
0x1765, 0x0670, 0x0DB9, 0x0147, 0xFA84, 0xFD80, 0xE5E7, 0xF41E,
0xE182, 0xEC1F, 0xE623, 0xF5F4, 0xEA74, 0xFA49, 0x02CF, 0x060B,
0x172F, 0x1379, 0x175C, 0x0B31, 0x101A, 0x0518, 0xFF3A, 0x0234,
0xEE4F, 0xF9B6, 0xE607, 0xE985, 0xEBCA, 0xE98D, 0xEFA3, 0xF3CC,
0xFBAB, 0xFA9F, 0x1840, 0x0E04, 0x2197, 0x1311, 0x1B7D, 0x0ED5,
0x0C55, 0x0FBD, 0xF59B, 0x08C4, 0xE6A3, 0xF682, 0xE766, 0xE99E,
0xED45, 0xEED8, 0xF1C7, 0xEF4F, 0x09A3, 0xFD52, 0x1DF2, 0x0FEA,
0x1E5C, 0x0B77, 0x1599, 0x0854, 0x00C5, 0x0603, 0xEB8A, 0xFA96,
0xE29E, 0xE817, 0xEA4A, 0xE91A, 0xEC86, 0xF4FE, 0xF37D, 0xFD5E,
0x0BA8, 0x13A8, 0x1528, 0x193E, 0x15D1, 0x1213, 0x0F6D, 0x0F84,
0xFBC2, 0x063E, 0xEA7F, 0xF269, 0xED40, 0xE519, 0xF7A0, 0xEFEA,
0xF90D, 0xF566, 0x0BF7, 0x01A4, 0x1D91, 0x117B, 0x195A, 0x0A2A,
0x116C, 0x0554, 0x0416, 0x0297, 0xF170, 0xF844, 0xE49C, 0xE993,
0xE863, 0xED18, 0xE81A, 0xF8A9, 0xF078, 0xFD83, 0x0E2A, 0x105B,
0x1731, 0x1308, 0x129C, 0x09BF, 0x0B25, 0x0B52, 0xFA6E, 0x072A,
0xEC42, 0xF58B, 0xED7F, 0xE896, 0xF35C, 0xF1DA, 0xF362, 0xF729,
0x0857, 0x036E, 0x1B86, 0x1486, 0x19F2, 0x1025, 0x14E7, 0x0EF9,
0x03D2, 0x1090, 0xEDB7, 0x03D9, 0xE654, 0xEE43, 0xEF21, 0xEB37,
0xEDE1, 0xEEE1, 0xF5D3, 0xEF0B, 0x12DD, 0x03F2, 0x1B15, 0x0C21,
0x1946, 0x05A3, 0x106E, 0x084E, 0xF8C6, 0x0477, 0xE6AF, 0xF152,
0xE7D1, 0xE4C2, 0xEEC6, 0xEE4A, 0xEDD1, 0xF507, 0xFE4E, 0x05E4,
0x0EA5, 0x1A58, 0x1012, 0x16B6, 0x1254, 0x1375, 0x080D, 0x1275,
0xF45D, 0x01DC, 0xEBFE, 0xE947, 0xF582, 0xE9E5, 0xF7CB, 0xF3A8,
0xFFF0, 0xF75E, 0x179E, 0x0B21, 0x1B7A, 0x1185, 0x18B1, 0x0A70,
0x0FD7, 0x0847, 0xF9E6, 0xFF30, 0xE95E, 0xEC26, 0xE7BE, 0xE310,
0xE919, 0xEEAA, 0xE4EB, 0xF352, 0xF86A, 0x010C, 0x0E8A, 0x142F,
0x11AA, 0x0E63, 0x1349, 0x099B, 0x07A2, 0x0B4B, 0xF353, 0x002D,
0xED75, 0xEADD, 0xF596, 0xEA0D, 0xF1F5, 0xF322, 0xF73E, 0xF7B5,
0x114F, 0x0C73, 0x1873, 0x154C, 0x199C, 0x1129, 0x16AA, 0x1463,
0xFFFA, 0x1140, 0xEB9F, 0xFCD3, 0xED2C, 0xEC45, 0xF14A, 0xF12C,
0xEAC0, 0xEF30, 0xFDB6, 0xF5E7, 0x142D, 0x0872, 0x166A, 0x08D3,
0x1A48, 0x0738, 0x0DDA, 0x0885, 0xF306, 0xFE14, 0xE83A, 0xE822,
0xEDD4, 0xE57A, 0xE93E, 0xEE4F, 0xEDEA, 0xF54B, 0x06BD, 0x0DA6,
0x0CA6, 0x18CC, 0x0F2D, 0x151E, 0x12CD, 0x1769, 0x030D, 0x1156,
0xF0F7, 0xF92B, 0xF166, 0xE875, 0xF64D, 0xF0B0, 0xF4C2, 0xF3C6,
0x0B52, 0x0090, 0x20A7, 0x14B9, 0x1F9E, 0x1292, 0x1F4B, 0x102C,
0x0F31, 0x0E49, 0xF39B, 0xFBEE, 0xE88F, 0xE49A, 0xEABE, 0xE6FF,
0xE1C4, 0xEFC8, 0xE667, 0xF41F, 0x0527, 0x0B90, 0x122C, 0x14A9,
0x160A, 0x0D9C, 0x14C9, 0x0DDC, 0x0029, 0x08B5, 0xED42, 0xF426,
0xED97, 0xE643, 0xEF98, 0xED34, 0xEBD6, 0xEF4F, 0x0300, 0xFDC9,
0x1A67, 0x13B1, 0x1CC0, 0x13F1, 0x20E1, 0x1629, 0x13E7, 0x18EB,
0xF6D1, 0x0936, 0xE968, 0xF2C1, 0xEF21, 0xF182, 0xEC66, 0xF49A,
0xF1E1, 0xF3CF, 0x0D91, 0x055A, 0x18CF, 0x0D13, 0x1D5B, 0x0A42,
0x1D08, 0x0D97, 0x0430, 0x067D, 0xEAD2, 0xEF4B, 0xE73E, 0xE20A,
0xE711, 0xE97B, 0xE339, 0xEC1B, 0xFA52, 0xFC38, 0x0E83, 0x1389,
0x0C27, 0x13FB, 0x1104, 0x1469, 0x0A64, 0x159C, 0xF3BD, 0x032B,
0xEADC, 0xE89C, 0xF055, 0xE7EA, 0xEDAA, 0xF153, 0xFA41, 0xF7DA,
0x1BF1, 0x0D82, 0x23E8, 0x150A, 0x21A5, 0x100C, 0x1E35, 0x1319,
0x030D, 0x0AC7, 0xE7BD, 0xEDE4, 0xE5E5, 0xDF6E, 0xE6AE, 0xEC5E,
0xE1AB, 0xF148, 0xF9E5, 0xFFD7, 0x11E8, 0x1512, 0x12FA, 0x11ED,
0x1720, 0x0DE4, 0x0BC8, 0x0CEA, 0xEFA2, 0xFC29, 0xE40F, 0xE584,
0xEB0F, 0xE6EE, 0xE9BD, 0xEE3F, 0xF4BD, 0xF2A3, 0x13FB, 0x086C,
0x1BF1, 0x1097, 0x1BED, 0x0DBB, 0x19DF, 0x14D7, 0x005A, 0x1010,
0xE71B, 0xF7AA, 0xE733, 0xEC7B, 0xECCE, 0xF632, 0xEDC4, 0xF706,
0x05A8, 0x0126, 0x1948, 0x0ECF, 0x1984, 0x0947, 0x1D41, 0x0A8F,
0x107E, 0x0C52, 0xF34A, 0xF97C, 0xE57C, 0xE4C5, 0xE9B0, 0xE8E8,
0xE5CD, 0xEF9D, 0xEEBC, 0xF4E7, 0x0BD1, 0x0C1A, 0x10D3, 0x13F8,
0x0C7D, 0x0FCD, 0x0A0D, 0x145C, 0xF7C9, 0x0C08, 0xE6A0, 0xF182,
0xEAA3, 0xE4FD, 0xF0D1, 0xEE05, 0xF1B6, 0xF3DE, 0x0B0C, 0x04DB,
0x214E, 0x138B, 0x20CF, 0x0CD5, 0x203E, 0x0EE1, 0x10CE, 0x104A,
0xF29A, 0xFA7B, 0xE427, 0xE3DE, 0xE8CA, 0xE8A6, 0xE67F, 0xF1A6,
0xEEC6, 0xF936, 0x0938, 0x0E6D, 0x10B9, 0x11CB, 0x11EE, 0x0BB9,
0x0F66, 0x0F62, 0xF989, 0x04F4, 0xE6D1, 0xEC6F, 0xE887, 0xE6AA,
0xEB98, 0xF0FA, 0xED14, 0xF1F2, 0x070B, 0x00A5, 0x1954, 0x0F63,
0x16BB, 0x06AB, 0x1905, 0x093A, 0x0B71, 0x11B7, 0xEF99, 0x0245,
0xE59D, 0xEDAE, 0xEBFE, 0xF3E7, 0xEB65, 0xFA9C, 0xF892, 0xFB15,
0x13D6, 0x0AA4, 0x14ED, 0x089A, 0x1335, 0xFF59, 0x1439, 0x07DE,
0xFEEF, 0x02FF, 0xEA9A, 0xEB9D, 0xEC07, 0xE74F, 0xEC3C, 0xF39C,
0xE87E, 0xF333, 0xFE7D, 0xFFE5, 0x0F49, 0x1086, 0x0A24, 0x09D4,
0x0840, 0x0B95, 0xFD20, 0x122A, 0xEAEF, 0x01D7, 0xE90C, 0xECDB,
0xF234, 0xEF26, 0xF09D, 0xF2B2, 0xFB39, 0xF77E, 0x1663, 0x0CBE,
0x1BDF, 0x0B9E, 0x1B36, 0x0225, 0x18AA, 0x0C0A, 0x037A, 0x0849,
0xEFB2, 0xEFCD, 0xEC95, 0xE7D9, 0xEA17, 0xF1D8, 0xE7FE, 0xF2F6,
0xFB8F, 0x007A, 0x09FC, 0x0E9D, 0x0A44, 0x05E5, 0x0EE0, 0x08D4,
0x04A3, 0x0EB5, 0xF031, 0xFC0B, 0xEB8A, 0xEA24, 0xEF64, 0xF15F,
0xEB25, 0xF5FA, 0xF630, 0xF75D, 0x0F13, 0x098E, 0x1453, 0x0976,
0x160A, 0x015A, 0x1561, 0x0D6F, 0x01B2, 0x0FA8, 0xEFC9, 0xFD31,
0xEE0A, 0xF4B0, 0xEC21, 0xFB3B, 0xEDD6, 0xFAA5, 0x04F2, 0x036A,
0x12BA, 0x0AA3, 0x10E4, 0xFE3A, 0x1435, 0x020F, 0x0AE2, 0x0BA0,
0xF864, 0xFC29, 0xF25F, 0xE986, 0xF1F4, 0xEE7C, 0xEBAE, 0xF40F,
0xF30F, 0xF49F, 0x0560, 0x0488, 0x0867, 0x07F9, 0x0B3F, 0x0546,
0x08F1, 0x12C6, 0xF59D, 0x1262, 0xEC1D, 0xFDE9, 0xF1AB, 0xF419,
0xF1EC, 0xF6D2, 0xF3EB, 0xF475, 0x0793, 0x0000, 0x1376, 0x0E2F,
0x1776, 0x062C, 0x2023, 0x089A, 0x1493, 0x12F2, 0xFF2E, 0x05AE,
0xF7B4, 0xF230, 0xF1FB, 0xF169, 0xE6E4, 0xF36B, 0xEE92, 0xF663,
0x00A5, 0x04F4, 0x03C2, 0x050F, 0x0CE1, 0x01CF, 0x114F, 0x0ED0,
0xFE45, 0x0B84, 0xF0D5, 0xF510, 0xF0E1, 0xEE53, 0xEB95, 0xF4CD,
0xEB95, 0xF3E3, 0xFF7B, 0xFD64, 0x0CAA, 0x0937, 0x12E7, 0x0273,
0x1CFC, 0x0757, 0x12C3, 0x1312, 0xFCC1, 0x08A8, 0xF31B, 0xFBCD,
0xED65, 0xFC56, 0xE713, 0xFB4E, 0xF4C6, 0xFEB8, 0x0A43, 0x0BF0,
0x100F, 0x07E5, 0x177B, 0x0113, 0x17B3, 0x0CF0, 0x036D, 0x0A59,
0xF5F2, 0xF48A, 0xF461, 0xEC6E, 0xEC3A, 0xEFF3, 0xEB28, 0xF067,
0xFBA7, 0xFB91, 0x034F, 0x0626, 0x0855, 0x02A2, 0x11CA, 0x0BBC,
0x043B, 0x1581, 0xEED0, 0x067D, 0xECE6, 0xF71C, 0xEE60, 0xF57E,
0xEAEF, 0xF1D8, 0xF96E, 0xF4A9, 0x0CF9, 0x059C, 0x111F, 0x09DF,
0x1C27, 0x0779, 0x2094, 0x11D7, 0x0CE3, 0x1026, 0xFEB0, 0xFE08,
0xF9EB, 0xF58D, 0xECD9, 0xF45E, 0xE8A6, 0xF3F7, 0xF80F, 0xFFFE,
0xFF59, 0x08B2, 0x0451, 0x0202, 0x115B, 0x075E, 0x0AA5, 0x1090,
0xF78D, 0x0185, 0xF09B, 0xF07F, 0xEC1B, 0xF063, 0xE677, 0xF107,
0xF260, 0xF4FF, 0x027C, 0x020F, 0x0988, 0x03AF, 0x17F0, 0x0125,
0x1A73, 0x0B3C, 0x0789, 0x0BA3, 0xFA7F, 0xFEF4, 0xF2D2, 0xFBD6,
0xE6A2, 0xFB9B, 0xE8D9, 0xF992, 0xFDD6, 0x0495, 0x0ACB, 0x0C67,
0x146E, 0x0410, 0x1D78, 0x05C8, 0x0FAB, 0x0D77, 0xFCAF, 0x0228,
0xF769, 0xF358, 0xEF8B, 0xEF15, 0xE8A2, 0xED46, 0xF5B9, 0xF4BB,
0x01A5, 0x0214, 0x02D0, 0x0186, 0x0DB2, 0x02C3, 0x0E02, 0x1181,
0xF99D, 0x0FEF, 0xEC6E, 0xFF0C, 0xE996, 0xF845, 0xE602, 0xF3C2,
0xEDDD, 0xEFFB, 0x0184, 0xFA01, 0x0A7F, 0x0299, 0x133B, 0x025B,
0x1EED, 0x0B29, 0x159D, 0x119F, 0x05CF, 0x0587, 0x004C, 0xFAD0,
0xF5B1, 0xF6BB, 0xEB6C, 0xF129, 0xF30F, 0xF870, 0xFB22, 0x064F,
0xFDBA, 0x03C3, 0x0A59, 0x0203, 0x0E7E, 0x0EF4, 0x01B2, 0x0DEA,
0xF871, 0xFD8C, 0xF023, 0xF487, 0xE554, 0xEF60, 0xEB86, 0xF0E1,
0xFC23, 0xFC4F, 0x018B, 0x0021, 0x0BDB, 0xFD9D, 0x1A8A, 0x0654,
0x1223, 0x0CE6, 0x021A, 0x027D, 0xFB76, 0xFBCF, 0xEE06, 0xFBBB,
0xE477, 0xF78C, 0xF1CC, 0xFC01, 0x00A1, 0x05BC, 0x0ACD, 0x04B9,
0x1B27, 0x04F4, 0x1B8E, 0x0DE7, 0x086B, 0x0A12, 0xFC6E, 0xFD36,
0xF538, 0xF6D9, 0xEAA7, 0xEDA0, 0xEF5E, 0xECCD, 0xFEEF, 0xFB4F,
0x038E, 0x0141, 0x095F, 0xFFA4, 0x1102, 0x0BF1, 0x0694, 0x1730,
0xF66D, 0x0BB3, 0xED1E, 0xFFAB, 0xE407, 0xF9D7, 0xE5CF, 0xF0D0,
0xF753, 0xF31C, 0x0371, 0xFB86, 0x0C00, 0xFC12, 0x1A49, 0x02DE,
0x1A58, 0x11F8, 0x0D23, 0x0D8C, 0x065E, 0xFF31, 0xFF10, 0xFD03,
0xF3D2, 0xF50C, 0xF553, 0xF0AB, 0xFC3D, 0xFDD9, 0xFBF9, 0x047A,
0x03DD, 0x0169, 0x0CB4, 0x0915, 0x05E7, 0x112F, 0xFF57, 0x0660,
0xFA49, 0xFD0D, 0xEC87, 0xF7BF, 0xE943, 0xEEC7, 0xF6E6, 0xF613,
0xFF0E, 0x009E, 0x054F, 0xFD95, 0x137B, 0x0122, 0x15C0, 0x0E87,
0x0A68, 0x0A53, 0x0257, 0xFDED, 0xF737, 0xFF92, 0xE9AF, 0xFBC0,
0xEC6D, 0xF87D, 0xF696, 0x00E8, 0xFE0A, 0x029A, 0x0FC8, 0x0179,
0x1C11, 0x0A1B, 0x117B, 0x0DD3, 0x0550, 0x0196, 0xFC14, 0xFBC1,
0xED9E, 0xF7B2, 0xEC6C, 0xEBB5, 0xFA6A, 0xF099, 0x025D, 0xFC4F,
0x07EA, 0xFD09, 0x1048, 0x0267, 0x0AD9, 0x113A, 0xFCB3, 0x1249,
0xF480, 0x060A, 0xE7BB, 0x0058, 0xDF1B, 0xF745, 0xED99, 0xF221,
0xFD31, 0xF92A, 0x02F0, 0xFA3B, 0x1135, 0xFB60, 0x1AC0, 0x097A,
0x0FF9, 0x12B4, 0x0672, 0x0616, 0x0234, 0xFC73, 0xF7B2, 0xFA6F,
0xF69C, 0xF1E5, 0xFF1B, 0xF570, 0xFE32, 0xFFB5, 0xFE2A, 0x0165,
0x05E9, 0x04DD, 0x0327, 0x0D0B, 0xFAFF, 0x09C5, 0xFB55, 0xFDA8,
0xF35E, 0xF9FB, 0xE7BE, 0xF1C5, 0xEF81, 0xECFD, 0xFA18, 0xF96D,
0xFDF6, 0xFE7B, 0x0884, 0xFC1A, 0x1021, 0x05CC, 0x0B8C, 0x0EB6,
0x05ED, 0x036A, 0xFE28, 0xFB19, 0xF080, 0xFD40, 0xEE9F, 0xF903,
0xF586, 0xFD13, 0xF70C, 0x0356, 0x010A, 0xFFC0, 0x12AB, 0x036F,
0x14D1, 0x0E46, 0x0B0A, 0x0927, 0x0462, 0xFA4B, 0xF6C4, 0xF924,
0xEB1B, 0xF429, 0xF406, 0xEC7D, 0xFD3A, 0xF43E, 0x0245, 0xF99C,
0x0D12, 0xFB30, 0x0D78, 0x06F7, 0x00A4, 0x10C4, 0xF7EC, 0x08F7,
0xEEFE, 0x00E3, 0xDF76, 0xFDFF, 0xE1C8, 0xF544, 0xF3DB, 0xF680,
0xFCC3, 0xFB90, 0x06F3, 0xF834, 0x1558, 0xFE3B, 0x1413, 0x0D09,
0x096D, 0x0CA3, 0x04C4, 0xFF5B, 0xFB5D, 0xFAD0, 0xF53F, 0xF764,
0x0006, 0xF560, 0x02F8, 0xFD54, 0xFF46, 0x00B6, 0x0597, 0x02B7,
0x0549, 0x0BC5, 0xF9D8, 0x0D61, 0xF719, 0x0060, 0xF898, 0xF86F,
0xEEE0, 0xF67E, 0xED9E, 0xEEE6, 0xF736, 0xF1E5, 0xF8F2, 0xFB4A,
0x001D, 0xFBFA, 0x0C30, 0x006D, 0x09B9, 0x0B78, 0x03D3, 0x09A5,
0x0329, 0xFD6F, 0xF7A0, 0xFB25, 0xEDD8, 0xFB01, 0xF59A, 0xFBAE,
0xF7E4, 0x0357, 0xF645, 0x0336, 0x04BB, 0xFFE8, 0x1256, 0x088B,
0x0EAC, 0x0E83, 0x09AE, 0x01EA, 0x0448, 0xF8BA, 0xF46C, 0xFA29,
0xF0D5, 0xF546, 0xFA57, 0xF405, 0xFD20, 0xF7DA, 0x0631, 0xF84C,
0x1255, 0xFE8E, 0x0AF4, 0x0A72, 0xFCF5, 0x0AD5, 0xF71A, 0x0307,
0xEA22, 0x0139, 0xDF82, 0xFB79, 0xEA1B, 0xF732, 0xF6F6, 0xFC3F,
0xFF51, 0xFAEC, 0x0D4A, 0xF7B2, 0x1515, 0x0165, 0x0E55, 0x0B95,
0x083B, 0x055A, 0x026F, 0xFE1E, 0xF66B, 0xFC1E, 0xFA2A, 0xF7FD,
0x06A8, 0xFC47, 0x05C0, 0x0198, 0x07DB, 0x016C, 0x0D2A, 0x07E4,
0x030D, 0x0FF2, 0xF731, 0x095B, 0xF722, 0xFC0E, 0xF369, 0xF911,
0xF08A, 0xF62D, 0xF80C, 0xF39C, 0xFA2C, 0xF8C6, 0xFC70, 0xFBA4,
0x08A8, 0xFE36, 0x0CEF, 0x0630, 0x049C, 0x0A3D, 0x0377, 0x024A,
0x0103, 0xFBF8, 0xF29F, 0xFA62, 0xF305, 0xF953, 0xFB31, 0x0104,
0xF84E, 0x04E7, 0xFDDB, 0x017E, 0x0B9D, 0x0461, 0x0D89, 0x0AB0,
0x0B64, 0x0861, 0x0BC8, 0xFE97, 0xFF42, 0xFA9A, 0xF4CD, 0xF90C,
0xFA12, 0xF99A, 0xFB34, 0xFC3A, 0xFECC, 0xF8D0, 0x1015, 0xFA75,
0x16F1, 0x055B, 0x08FB, 0x0BE8, 0xFEB7, 0x0725, 0xF575, 0x033A,
0xE3EA, 0x0214, 0xE418, 0xFCBD, 0xEF1B, 0xFD90, 0xF531, 0xFDC4,
0x0496, 0xF981, 0x1410, 0xFCCC, 0x119B, 0x0478, 0x0AE6, 0x0625,
0x0889, 0x0130, 0xFA9B, 0xFE8E, 0xF24F, 0xFA27, 0xFF76, 0xF8D1,
0x065D, 0xFF71, 0x071B, 0x002E, 0x113C, 0x02AC, 0x111B, 0x0CCF,
0xFF7C, 0x0F5A, 0xF742, 0x047B, 0xF538, 0xFB25, 0xEE36, 0xF8D1,
0xF547, 0xF5D8, 0xFDE3, 0xF87B, 0xFBF0, 0xFB18, 0x0433, 0xFBD9,
0x1025, 0x04B3, 0x0B03, 0x0B80, 0x0239, 0x075A, 0x030C, 0xFFD2,
0xFA50, 0xFD5E, 0xF13B, 0xFA68, 0xF8FC, 0xFBA9, 0xFC08, 0x03EB,
0xFB0A, 0x045A, 0x053A, 0x0445, 0x0C71, 0x098B, 0x08B9, 0x08E8,
0x09C6, 0x01AC, 0x0649, 0xFD0F, 0xF81A, 0xFAC6, 0xF8EA, 0xF97E,
0xFE39, 0xFE96, 0xFBFD, 0xFE3D, 0x05E9, 0xF96F, 0x15CA, 0xFF57,
0x1397, 0x06DE, 0x06F2, 0x05B1, 0xFF6E, 0x02CC, 0xEF55, 0x040F,
0xE2D6, 0x0235, 0xEA65, 0x00A7, 0xF16C, 0x0285, 0xFB6A, 0xFE90,
0x0FE0, 0xFDD6, 0x16D2, 0x02C1, 0x0CAD, 0x024B, 0x08CA, 0xFF89,
0x01CA, 0x005C, 0xF1E0, 0xFFB5, 0xF5D3, 0xFC93, 0x02C6, 0xFF3E,
0x06E9, 0x00FE, 0x1076, 0x0059, 0x195C, 0x0734, 0x0EAD, 0x0DE7,
0xFCB0, 0x09D0, 0xF48D, 0x0073, 0xEA3E, 0xFB67, 0xE92B, 0xF7E4,
0xFA3B, 0xF85B, 0x0071, 0xFC43, 0x01FC, 0xFAE1, 0x0F4F, 0xFEC5,
0x11EA, 0x08AC, 0x04BA, 0x0891, 0xFFC2, 0x011D, 0xFBDE, 0xFEEA,
0xF0E7, 0xFE7F, 0xF493, 0xFCA4, 0xFDA5, 0x00F9, 0xFD79, 0x0501,
0x02C5, 0x052F, 0x0BDB, 0x080A, 0x088F, 0x0977, 0x0304, 0x0383,
0x051F, 0xFCA3, 0xFC27, 0xFBDA, 0xF4E7, 0xFAB0, 0xFEE9, 0xFCF9,
0x00A5, 0x016F, 0x002A, 0xFD4B, 0x0E46, 0xFB43, 0x15F5, 0x000D,
0x0DC5, 0x0257, 0x05D3, 0x000F, 0xFA1C, 0x00A8, 0xE7E2, 0x0354,
0xE690, 0x0414, 0xEF68, 0x05C3, 0xF39B, 0x0262, 0x0236, 0xFE7E,
0x149F, 0x00EE, 0x1295, 0x01A6, 0x0870, 0xFD6F, 0x05AD, 0xFC1F,
0xF963, 0x00D2, 0xEFE9, 0x0176, 0xFB3A, 0x0127, 0x04D4, 0x0179,
0x0B64, 0xFE47, 0x186F, 0x019E, 0x19DF, 0x089A, 0x09B7, 0x0A51,
0xFA6C, 0x0612, 0xEE62, 0x004B, 0xE4A9, 0xFBB9, 0xEDDE, 0xF941,
0xFF03, 0xFB85, 0x04F2, 0xFA3C, 0x0BE6, 0xF93B, 0x1501, 0x0079,
0x0E3A, 0x067F, 0x0166, 0x0419, 0xFC9F, 0xFE55, 0xF448, 0xFD89,
0xF22B, 0xFE09, 0xFD7C, 0x0047, 0x025B, 0x0294, 0x045F, 0x01E8,
0x0C2C, 0x0733, 0x0C28, 0x0BCA, 0x02EE, 0x0818, 0x0080, 0x0072,
0xFE1F, 0xFC4A, 0xF621, 0xFCA5, 0xFB93, 0xFCC1, 0x050A, 0xFFDC,
0x0382, 0x00FC, 0x0824, 0xFFC9, 0x124D, 0x00C0, 0x1011, 0x0051,
0x0927, 0xFDF6, 0x0342, 0xFC13, 0xF3B6, 0xFEFA, 0xE90C, 0x0240,
0xEE74, 0x05C0, 0xF27A, 0x05C2, 0xF831, 0xFFFC, 0x09AB, 0x017E,
0x13A1, 0x041C, 0x0D35, 0x00A3, 0x0815, 0xFA87, 0x01D4, 0xF98D,
0xF4F4, 0xFFAF, 0xF5A0, 0x0354, 0x0088, 0x04CB, 0x06B3, 0x01E8,
0x11D4, 0x012E, 0x1C93, 0x07C7, 0x15F0, 0x0AC2, 0x0837, 0x0864,
0xFB4C, 0x0446, 0xE98B, 0x00CE, 0xE468, 0xFCCA, 0xF3BE, 0xFC17,
0x005E, 0xFC17, 0x074A, 0xF9FF, 0x1278, 0xFEBB, 0x14B0, 0x0383,
0x08C0, 0x045A, 0xFFDA, 0x01D6, 0xF7EF, 0xFCBA, 0xEEA1, 0xFB7F,
0xF59C, 0xFE77, 0x0220, 0x02FF, 0x0457, 0x0200, 0x09D5, 0x0406,
0x1055, 0x0C1A, 0x089C, 0x0B35, 0xFF9F, 0x038A, 0xFE6B, 0xFCD9,
0xF795, 0xFA0B, 0xF538, 0xFAC9, 0x011F, 0xFF15, 0x07DB, 0x01FC,
0x07E3, 0x02D6, 0x0E53, 0x07B6, 0x11DE, 0x0693, 0x0BC7, 0xFF22,
0x07AC, 0xF9FE, 0xFF53, 0xF910, 0xEF95, 0xFC6B, 0xECB7, 0x01E7,
0xF1DD, 0x079E, 0xF2E2, 0x056B, 0xFCC1, 0x02DB, 0x0BDB, 0x05B5,
0x0D94, 0x02B8, 0x087C, 0xFB99, 0x0433, 0xF548, 0xF932, 0xF4F1,
0xF1D9, 0xFBC3, 0xF8A5, 0x03A6, 0x0033, 0x04AA, 0x06D7, 0x0130,
0x1544, 0x0535, 0x1B6E, 0x08DD, 0x10C9, 0x0637, 0x0589, 0x02DB,
0xF5B3, 0x00D0, 0xE2FD, 0xFF2B, 0xE627, 0xFDCB, 0xF68D, 0xFE5A,
0x0035, 0xFB75, 0x0B58, 0xFBBA, 0x1667, 0x00E4, 0x110E, 0x0076,
0x03C2, 0xFEF9, 0xFADA, 0xFD40, 0xEF09, 0xF987, 0xEA64, 0xF9CE,
0xF809, 0x0088, 0x0356, 0x0351, 0x05EC, 0x005C, 0x0D0E, 0x0460,
0x0DFD, 0x0832, 0x01BA, 0x03D0, 0xF9B9, 0xFD24, 0xF545, 0xF897,
0xEEFF, 0xF7B7, 0xF5CA, 0xFBD5, 0x0461, 0x019E, 0x09E2, 0x004B,
0x0CF9, 0x0213, 0x10E3, 0x07CC, 0x0C7A, 0x01FB, 0x04E5, 0xF8D7,
0x0072, 0xF5B3, 0xF6C5, 0xF771, 0xEDED, 0xFD1F, 0xF127, 0x05AF,
0xF41C, 0x0908, 0xF59D, 0x0487, 0x0098, 0x035B, 0x0835, 0x022A,
0x0566, 0xFC74, 0x02CB, 0xF6DE, 0xFC76, 0xF34E, 0xF1DD, 0xF52A,
0xF28A, 0xFE58, 0xFB8D, 0x06B5, 0x0042, 0x02F8, 0x095E, 0xFF2F,
0x169B, 0x024A, 0x156F, 0x01A1, 0x0B1D, 0xFFCA, 0x0116, 0xFE69,
0xEF28, 0xFF11, 0xE15D, 0x01F9, 0xE936, 0x0249, 0xF7CF, 0xFDC7,
0x0156, 0xF8A6, 0x0E8F, 0xFAE5, 0x15A0, 0xFC2E, 0x0BF0, 0xFA67,
0x0005, 0xFC5A, 0xF542, 0xFDFD, 0xE9E6, 0xFD80, 0xEBB1, 0xFFBC,
0xFA2F, 0x03D8, 0x043F, 0x00D8, 0x09A5, 0xFF24, 0x0F80, 0x02D2,
0x097D, 0x025A, 0xFC73, 0x00BD, 0xF5A1, 0xFD5F, 0xEDF2, 0xFA73,
0xEC1C, 0xFCFD, 0xF96B, 0x0190, 0x06D2, 0x0100, 0x0CFC, 0xFC8F,
0x1312, 0x0092, 0x121B, 0x04AD, 0x0769, 0xFF36, 0x016A, 0xF912,
0xFC04, 0xF706, 0xF1CB, 0xFA0F, 0xF129, 0x0170, 0xF840, 0x0693,
0xF8D5, 0x03E7, 0xFB72, 0x023A, 0x060D, 0x021D, 0x0674, 0xFD2D,
0x007F, 0xFAB1, 0xFFC6, 0xF989, 0xF821, 0xF7D8, 0xF132, 0xFA90,
0xF89E, 0x02A7, 0x01E4, 0x0695, 0x067E, 0x016D, 0x0F98, 0x0038,
0x1704, 0x015D, 0x10B2, 0xFFC1, 0x068A, 0xFFCA, 0xFB72, 0x0059,
0xEBB6, 0x02A5, 0xE568, 0x0601, 0xEE9A, 0x04C5, 0xFB8C, 0xFC85,
0x0742, 0xF886, 0x12B7, 0xFB55, 0x12B7, 0xFA8D, 0x0795, 0xF9D3,
0xFBEE, 0xFB94, 0xEEEC, 0xFED9, 0xEA1D, 0x0152, 0xF3DC, 0x01F2,
0x014F, 0x0232, 0x0B79, 0x00BD, 0x1273, 0x022C, 0x123E, 0x02BD,
0x05E7, 0x0170, 0xF834, 0x008B, 0xEF23, 0xFCE7, 0xE8DB, 0xFC5C,
0xEF4F, 0xFFF7, 0x003B, 0x0298, 0x0CC5, 0x000D, 0x1476, 0xFE36,
0x192E, 0x01CC, 0x1097, 0x0314, 0x010A, 0xFF5A, 0xF9D1, 0xF819,
0xF445, 0xF5DC, 0xF0EF, 0xFBD1, 0xF797, 0x02AF, 0xFE5A, 0x0542,
0xFF62, 0x041B, 0x02C7, 0x0519, 0x063F, 0x02C4, 0x00BB, 0xFD09,
0xFA79, 0xF9D5, 0xF7A8, 0xF818, 0xF2EC, 0xFA16, 0xF57F, 0xFE10,
0x002B, 0x036E, 0x0675, 0x05F0, 0x0BE2, 0x03B6, 0x13CA, 0x0212,
0x1313, 0x00AB, 0x0A80, 0xFFC8, 0x0107, 0xFD99, 0xF4B5, 0xFE6C,
0xEC1D, 0x04BA, 0xEE40, 0x08C0, 0xF538, 0x057E, 0xFE8C, 0xFDCD,
0x0C37, 0xFB1E, 0x13C3, 0xFB01, 0x0D4D, 0xF9CB, 0x0344, 0xF8B0,
0xF80E, 0xF952, 0xEC0D, 0x002D, 0xED9E, 0x04E4, 0xFA29, 0x0364,
0x0434, 0x00F7, 0x0E57, 0x011E, 0x154D, 0x0294, 0x0D46, 0x0097,
0xFE44, 0xFF73, 0xF35F, 0xFE1B, 0xE9E0, 0xFCAE, 0xE800, 0xFF5A,
0xF531, 0x029D, 0x058C, 0x03C9, 0x0F71, 0x0197, 0x17D2, 0x00EE,
0x19D9, 0x02D4, 0x0C68, 0x03DE, 0xFC03, 0xFFDD, 0xF436, 0xF88D,
0xF11C, 0xFA1B, 0xF4F1, 0xFFDB, 0xFEFD, 0x0288, 0x042E, 0x039A,
0x0462, 0x040E, 0x0525, 0x0482, 0x01BD, 0x011A, 0xF97F, 0xFBAF,
0xF36C, 0xF7A1, 0xF0F9, 0xF949, 0xF327, 0xFE8F, 0xFC32, 0x0005,
0x063B, 0x01A8, 0x0B0B, 0x0430, 0x0F4A, 0x03BA, 0x11A0, 0xFFFE,
0x0C0C, 0xFE2B, 0x03E3, 0xFDFA, 0xFA4A, 0xFCDE, 0xF144, 0x01C4,
0xF1AE, 0x083D, 0xF7CA, 0x09E9, 0xFB8D, 0x0603, 0x0219, 0xFF7F,
0x0D33, 0xFCBB, 0x0F0E, 0xFB4A, 0x066A, 0xF9B3, 0xFD03, 0xF76E,
0xF262, 0xFAC1, 0xECBB, 0x0443, 0xF45E, 0x0706, 0x000E, 0x033B,
0x07F0, 0xFFAD, 0x10C4, 0x006E, 0x1367, 0x010D, 0x07F9, 0xFE60,
0xF996, 0xFC88, 0xEDA5, 0xFC38, 0xE702, 0xFF40, 0xED39, 0x0160,
0xFBF2, 0x02DC, 0x0960, 0x04CD, 0x135F, 0x02D3, 0x19CE, 0x0112,
0x1645, 0x01AB, 0x0868, 0x028C, 0xF8B8, 0xFE5A, 0xEF42, 0xFAB7,
0xF1C5, 0xFE8F, 0xFC8E, 0x0215, 0x051C, 0x03B1, 0x07ED, 0x0420,
0x0869, 0x04E3, 0x049E, 0x0503, 0xFC9F, 0x01D5, 0xF5CB, 0xFB7B,
0xEF7D, 0xF6F3, 0xEF0C, 0xFC9B, 0xF906, 0x0227, 0x0458, 0x01F2,
0x0A7A, 0x0284, 0x0DC9, 0x038D, 0x10E1, 0x0231, 0x0F12, 0xFE1F,
0x0791, 0xFCBA, 0xFF7B, 0xFBC9, 0xF802, 0xFE06, 0xF546, 0x0540,
0xFA33, 0x0956, 0xFF77, 0x0AA6, 0x0048, 0x0681, 0x04D3, 0xFFA1,
0x0C47, 0xFC4D, 0x0B82, 0xFC26, 0x038C, 0xFA9A, 0xFA64, 0xF872,
0xF472, 0x0072, 0xF466, 0x097D, 0xFB01, 0x09F9, 0x0427, 0x058D,
0x0AD3, 0x002E, 0x10CE, 0xFEEF, 0x102D, 0xFEB8, 0x04E0, 0xFDD8,
0xF68F, 0xFB95, 0xEBFA, 0xFD9C, 0xEA71, 0x031E, 0xF2FE, 0x02B6,
0xFFDA, 0x02FA, 0x0A62, 0x036B, 0x1377, 0x00B7, 0x1872, 0xFE9B,
0x12D1, 0xFFAD, 0x0593, 0x0105, 0xF664, 0xFE29, 0xEF7E, 0xFF01,
0xF5E9, 0x028E, 0x00F8, 0x042B, 0x07C7, 0x03D8, 0x09A3, 0x0175,
0x09B6, 0x01C8, 0x0440, 0x0303, 0xFA29, 0x0165, 0xF217, 0xFB52,
0xEE64, 0xFA6D, 0xF204, 0x021B, 0xFC87, 0x05A2, 0x0797, 0x0457,
0x0D19, 0x0162, 0x0ECA, 0x00A0, 0x0EA8, 0x0026, 0x0AA7, 0xFC6C,
0x033B, 0xF9DA, 0xFA84, 0xFA9C, 0xF6D1, 0x00EF, 0xF8F3, 0x069A,
0xFD84, 0x09C8, 0x0245, 0x0A7E, 0x02F7, 0x043F, 0x03DF, 0xFD20,
0x079D, 0xFABC, 0x0796, 0xFBA1, 0xFFC7, 0xF8FC, 0xF7EE, 0xF991,
0xF7D4, 0x0314, 0xFA18, 0x0AB4, 0xFE67, 0x0BCB, 0x0643, 0x0494,
0x0D0B, 0xFDEC, 0x0F9B, 0xFDDA, 0x0C66, 0xFE9D, 0x02AE, 0xFD48,
0xF42E, 0xFC1B, 0xEBEE, 0x0204, 0xEE74, 0x064B, 0xF726, 0x04C8,
0x026C, 0x0320, 0x0B7C, 0x0062, 0x12BD, 0xFE62, 0x14A7, 0xFD1F,
0x0DBB, 0xFE22, 0x010B, 0xFED6, 0xF400, 0xFFA9, 0xF084, 0x0194,
0xF8A6, 0x0279, 0x04A8, 0x04F0, 0x0AFE, 0x022F, 0x0BA5, 0xFDA1,
0x09DD, 0xFF01, 0x0158, 0x01DB, 0xF50C, 0xFFEA, 0xECC2, 0xFB28,
0xECDE, 0xFE94, 0xF488, 0x044B, 0x008F, 0x06BB, 0x0B75, 0x0568,
0x0F29, 0xFF97, 0x0ED9, 0xFE89, 0x0B15, 0xFEB6, 0x03C6, 0xFAAA,
0xFB72, 0xF724, 0xF4E9, 0xFBC4, 0xF62B, 0x03F7, 0xFC95, 0x0775,
0x0352, 0x0AE2, 0x070E, 0x08E3, 0x056B, 0x00F5, 0x0230, 0xFAD8,
0x0088, 0xF8A7, 0xFE1E, 0xF7C5, 0xF7EC, 0xF678, 0xF595, 0xFBA9,
0xFA6B, 0x0329, 0xFF62, 0x09F4, 0x03AE, 0x0B13, 0x0855, 0x015A,
0x0C24, 0xFAE4, 0x0B1F, 0xFB1F, 0x0421, 0xFBAD, 0xF9A4, 0xF9A1,
0xEFF3, 0xFC17, 0xEE5C, 0x0467, 0xF38A, 0x072D, 0xFCD2, 0x065B,
0x0749, 0x01F0, 0x0CDE, 0xFD5A, 0x0EFF, 0xFCF6, 0x0DB6, 0xFC35,
0x0501, 0xFB4B, 0xF849, 0xFCAE, 0xF18C, 0x0264, 0xF38A, 0x037A,
0xFB9E, 0x0247, 0x070B, 0x0336, 0x0CD8, 0xFE1A, 0x0AC8, 0xFA0D,
0x0598, 0xFBAE, 0xFBB7, 0xFE8D, 0xEDAA, 0xFCF2, 0xE6FF, 0xFBD0,
0xEE55, 0x00D0, 0xF99D, 0x047C, 0x0486, 0x0650, 0x0F28, 0x023D,
0x11A7, 0xFC3E, 0x0C28, 0xFC9F, 0x04C0, 0xFD11, 0xFCC6, 0xF940,
0xF589, 0xF6ED, 0xF478, 0xFE21, 0xFA2E, 0x04BC, 0x011D, 0x073F,
0x0697, 0x090D, 0x08DE, 0x0497, 0x05A4, 0xFF9A, 0xFE6C, 0xFB8B,
0xF941, 0xF868, 0xF66E, 0xF7C1, 0xF43F, 0xFA0A, 0xF7A0, 0xFE89,
0xFEE1, 0x0216, 0x03DE, 0x0819, 0x05A9, 0x06FA, 0x064A, 0xFDB7,
0x06F4, 0xFA27, 0x04CC, 0xFB99, 0xFE4E, 0xFBBD, 0xF67A, 0xFBAE,
0xF2AB, 0x0109, 0xF462, 0x050D, 0xF92F, 0x0608, 0x00D6, 0x049C,
0x07D0, 0xFD81, 0x0A64, 0xFBC3, 0x0AC0, 0xFE6E, 0x098B, 0xFDDD,
0x02C8, 0xFD03, 0xFA0B, 0x01AD, 0xF8BE, 0x067E, 0xFB8D, 0x034C,
0x0039, 0x0222, 0x08D5, 0x0168, 0x0C21, 0xFCC5, 0x07D6, 0xFC56,
0x02B9, 0xFEFE, 0xFA44, 0xFFEE, 0xEDA6, 0xFFD3, 0xEA0F, 0x01A9,
0xF3A8, 0x0143, 0xFE9A, 0x0269, 0x07EA, 0x0514, 0x0F4F, 0xFF9B,
0x0EFE, 0xFBB3, 0x092A, 0xFEB5, 0x02B1, 0xFF55, 0xFA80, 0xF9FA,
0xF567, 0xF936, 0xF9D5, 0xFF32, 0x0076, 0x025E, 0x05EC, 0x05FE,
0x0B63, 0x066F, 0x0A68, 0x0304, 0x0438, 0x0299, 0xFE25, 0x0089,
0xF8CB, 0xFB7D, 0xF5AD, 0xFA09, 0xF7E9, 0xFE26, 0xFE7F, 0xFEDE,
0x0478, 0x00A2, 0x081E, 0x06F2, 0x074A, 0x05BA, 0x0322, 0x0095,
0x0269, 0xFEC1, 0x0286, 0xFE93, 0xFC40, 0xFD03, 0xF5DC, 0xFD96,
0xF745, 0x0005, 0xFA2C, 0x00D8, 0xFC8C, 0x0492, 0x01E1, 0x0266,
0x05B9, 0xFBCF, 0x06FF, 0xFDB9, 0x07F5, 0x0155, 0x070A, 0xFEB7,
0x01F3, 0xFCCC, 0xFD28, 0x01F3, 0xFDA7, 0x03A6, 0xFF1B, 0x0227,
0x02B8, 0x02A3, 0x088C, 0xFFAC, 0x08DA, 0xFED2, 0x058A, 0x0114,
0x01A6, 0x00F1, 0xF94B, 0xFF73, 0xEF4A, 0x0174, 0xEDDF, 0x0234,
0xF5B0, 0xFF5F, 0x0020, 0x03F9, 0x08DE, 0x05DD, 0x0C62, 0x0031,
0x0BDE, 0x002C, 0x0889, 0x021F, 0x0071, 0xFEAB, 0xF727, 0xFA0F,
0xF65B, 0xFAE0, 0xFCDD, 0xFC7D, 0x0133, 0x00C6, 0x06D5, 0x0799,
0x0C00, 0x05F3, 0x0839, 0x03D4, 0x027E, 0x0559, 0xFE01, 0x0088,
0xF6B3, 0xF7FF, 0xF419, 0xF90C, 0xFAA3, 0xFDD1, 0x0114, 0xFCE2,
0x060D, 0x026F, 0x0B2C, 0x0825, 0x0796, 0x05B6, 0x0033, 0x0425,
0x0047, 0x0277, 0xFFD0, 0xFDBE, 0xF8FE, 0xFB34, 0xF6AC, 0xFEEE,
0xFAB9, 0x0029, 0xFC67, 0x01BB, 0xFE84, 0x06D7, 0x0207, 0x02BE,
0x0253, 0xFD72, 0x0397, 0xFFE2, 0x053E, 0x0026, 0x02BA, 0xFAC2,
0xFFE4, 0xFB2E, 0xFF8A, 0x0005, 0xFF94, 0x0011, 0x0126, 0x024A,
0x0534, 0x014D, 0x06B3, 0xFC97, 0x0525, 0xFEF1, 0x03D9, 0x00E0,
0xFFC3, 0xFCF1, 0xF81C, 0xFBF4, 0xF1D4, 0x00EA, 0xF00B, 0x0001,
0xF554, 0xFF73, 0x0164, 0x05AD, 0x09F1, 0x043C, 0x0A24, 0x0092,
0x09B6, 0x0239, 0x0799, 0x0133, 0xFE7E, 0xFC60, 0xF661, 0xFB52,
0xF6E8, 0xFBAA, 0xFAF8, 0xFB0B, 0xFFCB, 0x02A2, 0x06CA, 0x073E,
0x090F, 0x03C3, 0x04E4, 0x057E, 0x0170, 0x05A3, 0xFCC8, 0xFCC3,
0xF5B1, 0xF6B3, 0xF579, 0xFA8C, 0xFB48, 0xFBE3, 0x0033, 0xFCEA,
0x0745, 0x03EC, 0x0BB7, 0x04C2, 0x05F8, 0x042A, 0xFF99, 0x05E2,
0xFEFD, 0x00BB, 0xFD43, 0xFA2B, 0xFA05, 0xFCFC, 0xFA56, 0x0048,
0xFBAA, 0xFE5E, 0xFE00, 0x046C, 0x021E, 0x0808, 0x011B, 0x0107,
0xFF4B, 0xFEF5, 0x0371, 0x00EF, 0x042E, 0xFD9F, 0x0052, 0xFAB6,
0x0155, 0xFEBE, 0x01A2, 0xFFC7, 0xFE7D, 0x0101, 0x01E8, 0x05AD,
0x059D, 0x00D1, 0x0273, 0xFCF3, 0x020D, 0x00EC, 0x039D, 0xFF96,
0xFE9E, 0xFA2B, 0xF8A7, 0xFD27, 0xF64A, 0x016F, 0xF31D, 0xFE1D,
0xF703, 0x0113, 0x043D, 0x0548, 0x0994, 0x0277, 0x08DB, 0x031E,
0x0D0B, 0x0404, 0x0B47, 0xFECF, 0xFFA4, 0xFBBD, 0xF8C7, 0xFE67,
0xF97D, 0xFBA1, 0xFC2C, 0xFBF8, 0x029E, 0x0524, 0x07CC, 0x0567,
0x0716, 0x03A7, 0x05DE, 0x07B5, 0x03AC, 0x050A, 0xFCFA, 0xFB8C,
0xF738, 0xF8FC, 0xF899, 0xFBC4, 0xFC5F, 0xFBBE, 0x01E2, 0x00D9,
0x0A92, 0x0499, 0x0B6D, 0x0272, 0x04F1, 0x057D, 0x0195, 0x0630,
0xFF44, 0xFDC6, 0xFBB2, 0xF987, 0xFB2A, 0xFEAD, 0xFC63, 0xFF76,
0xFDEC, 0x00DA, 0x0309, 0x07DF, 0x04E4, 0x056E, 0xFF76, 0x012A,
0xFF49, 0x0229, 0x051D, 0xFF22, 0x0442, 0xFA43, 0x014B, 0xFC8B,
0x054D, 0x008A, 0x0634, 0x00C6, 0x032B, 0x06F7, 0x060F, 0x088B,
0x05D0, 0x0077, 0x00C7, 0x003B, 0x01CB, 0x02F6, 0x0253, 0xFD6E,
0xFCDF, 0xF990, 0xF9D5, 0xFED4, 0xF882, 0x0068, 0xF56F, 0x00C8,
0xFA21, 0x05D4, 0x0431, 0x03B5, 0x06BD, 0x0210, 0x0817, 0x05C0,
0x0D15, 0x0313, 0x09CB, 0xFC27, 0xFFB9, 0xFCAE, 0xFB42, 0xFE8E,
0xFAC8, 0xFB25, 0xFD93, 0x0056, 0x04AD, 0x05D5, 0x063C, 0x030E,
0x04C4, 0x05E9, 0x0681, 0x08EE, 0x02D8, 0x0213, 0xFAE3, 0xFB33,
0xF8C8, 0xFBC4, 0xFA88, 0xFB12, 0xFC25, 0xFD9D, 0x0338, 0x051A,
0x0AC0, 0x02DC, 0x0824, 0x0154, 0x037F, 0x0750, 0x01AE, 0x0473,
0xFCD5, 0xFA77, 0xF960, 0xFA8A, 0xFAD1, 0xFF7C, 0xFBA4, 0xFF78,
0xFE41, 0x04EE, 0x0413, 0x083C, 0x0250, 0x0200, 0xFC0A, 0x00C8,
0xFE90, 0x0113, 0x043E, 0xFAA9, 0x03BA, 0xF8D3, 0x0327, 0xFE85,
0x0665, 0xFF3E, 0x06C7, 0x021D, 0x0545, 0x09F2, 0x050E, 0x05E1,
0x009E, 0xFED1, 0xFCCA, 0x0028, 0xFF9A, 0xFF69, 0x0035, 0xFA02,
0xFCED, 0xFAF2, 0xFB16, 0xFFB0, 0xF845, 0x0072, 0xF648, 0x04FA,
0xFA99, 0x062B, 0xFF0F, 0x00A2, 0xFF77, 0x028E, 0x040B, 0x0519,
0x0A61, 0xFF58, 0x0807, 0xFC01, 0x0105, 0xFF46, 0xFBF5, 0xFD9A,
0xF9C0, 0xFC4E, 0xFDE5, 0x0228, 0x0363, 0x023A, 0x0127, 0x00A3,
0x005D, 0x0432, 0x05C4, 0x0429, 0x034E, 0xFEF0, 0xFB8A, 0xFC5A,
0xFA5D, 0xFB04, 0xFB89, 0xF8E8, 0xFDBD, 0xFF84, 0x04C6, 0x03CB,
0x07A9, 0xFF34, 0x026B, 0x0182, 0x00F8, 0x0601, 0x01B4, 0x0196,
0xFC16, 0xFB94, 0xF7EE, 0xFC75, 0xF8D5, 0xFD8B, 0xFA93, 0x001D,
0xFF67, 0x0657, 0x0334, 0x0469, 0xFD76, 0x00FD, 0xF7F8, 0x01FE,
0xFDA2, 0xFE26, 0x03F6, 0xF87F, 0x039E, 0xFAB4, 0x02F7, 0xFDD6,
0x052F, 0xFC94, 0x07E1, 0x032A, 0x0783, 0x0848, 0x0282, 0x022D,
0xFCB9, 0xFEEE, 0xFD22, 0xFEF7, 0x0125, 0xFBF1, 0x00E1, 0xFA30,
0xFE09, 0xFC2B, 0xFB64, 0xFC02, 0xF955, 0xFF48, 0xF9E9, 0x06C7,
0xFB4A, 0x03D1, 0xFA9F, 0x006B, 0xFCF5, 0x04A6, 0x05C5, 0x03C8,
0x0B80, 0xFE6D, 0x0859, 0xFE24, 0x00E0, 0xFEB9, 0xFA53, 0xFB4E,
0xF991, 0xFE65, 0xFD2C, 0x01FF, 0xFE42, 0xFFAB, 0xFC24, 0x02FA,
0xFFA8, 0x05E2, 0x06D1, 0x01A0, 0x0389, 0xFE1E, 0xFB99, 0xFCF9,
0xFA3A, 0xF849, 0xFBE8, 0xF800, 0x000D, 0x006F, 0x055B, 0x0181,
0x058D, 0xFFF3, 0x0382, 0x04A2, 0x0541, 0x0528, 0x04C0, 0x0012,
0xFDD5, 0xFC4F, 0xF7F6, 0xFA98, 0xF6F1, 0xFA96, 0xFAD0, 0x019A,
0x0158, 0x0663, 0x01DD, 0x03D0, 0xFB5E, 0x057E, 0xFA60, 0x0576,
0x00A4, 0xFDC3, 0x02E8, 0xF87F, 0x01BB, 0xFA00, 0x017F, 0xFA96,
0x031D, 0xFCE5, 0x0847, 0x0506, 0x0869, 0x061C, 0xFF7F, 0x02D9,
0xFB3D, 0x022A, 0x0025, 0xFE1D, 0x0246, 0xF973, 0xFF69, 0xF93E,
0xFCF9, 0xF973, 0xF9ED, 0xF8D7, 0xF917, 0x0024, 0xFC92, 0x06B1,
0xFCDF, 0x030A, 0xFA39, 0x02C3, 0xFF98, 0x0594, 0x09D6, 0x0189,
0x0C05, 0xFC52, 0x075D, 0xFD11, 0x0080, 0xFD80, 0xFA48, 0xFD6B,
0xFAEC, 0x0147, 0xFE31, 0x016C, 0xFCBE, 0x020D, 0xFCA5, 0x0629,
0x03CE, 0x046A, 0x08C5, 0xFF61, 0x02D0, 0xFD6F, 0xF9C3, 0xFBDA,
0xF714, 0xF88E, 0xFAEC, 0xFBF8, 0x013C, 0x01C6, 0x049F, 0x01D4,
0x041B, 0x03FB, 0x05DC, 0x058C, 0x092B, 0x01C3, 0x0531, 0xFD81,
0xFC78, 0xFA8A, 0xF63C, 0xF849, 0xF517, 0xFBFC, 0xFB8A, 0x0458,
0x02FE, 0x0588, 0x023C, 0x060F, 0xFE38, 0x0917, 0x00BE, 0x03FC,
0x04B3, 0xFB6B, 0x025C, 0xF83A, 0xFF2D, 0xF906, 0xFEDC, 0xFA2C,
0x02A2, 0x007D, 0x0A37, 0x0719, 0x09DD, 0x0786, 0xFFC5, 0x07F6,
0xFE01, 0x040B, 0x0473, 0xFC20, 0x0237, 0xF8B8, 0xFBC6, 0xF8FF,
0xF994, 0xF861, 0xF82A, 0xFB00, 0xF97E, 0x0350, 0xFD8E, 0x061C,
0xFCE3, 0x05BD, 0xFB90, 0x06E7, 0x03D4, 0x0457, 0x0C19, 0xFFC1,
0x0A71, 0xFCC9, 0x0544, 0xFCEC, 0xFF10, 0xFDCA, 0xFB45, 0x00CD,
0xFE2E, 0x0282, 0xFF8E, 0x0116, 0xFC12, 0x04AF, 0xFF60, 0x064D,
0x086F, 0x01A6, 0x091A, 0xFDFA, 0x00F5, 0xFD4D, 0xF768, 0xFBF9,
0xF4BD, 0xFA65, 0xFC2A, 0xFE20, 0x0338, 0x0182, 0x02CF, 0x0372,
0x0378, 0x05E2, 0x09E9, 0x03B0, 0x0A2E, 0xFFA8, 0x0198, 0xFCF8,
0xF8FF, 0xFA50, 0xF29B, 0xF830, 0xF35E, 0xFD50, 0xFCB2, 0x0494,
0x027C, 0x0546, 0xFFFA, 0x0798, 0x0053, 0x08CD, 0x04E4, 0x0330,
0x040B, 0xFC1A, 0xFF66, 0xF84A, 0xFC6D, 0xF875, 0xFD9E, 0xFB24,
0x04BA, 0x0182, 0x0C30, 0x05CE, 0x08F2, 0x0812, 0xFFE5, 0x0999,
0x0160, 0x034C, 0x054B, 0xFB02, 0xFF18, 0xF820, 0xF7E4, 0xF853,
0xF683, 0xF850, 0xF8C0, 0xFC22, 0xFC99, 0x0279, 0xFD9D, 0x0533,
0xFA38, 0x07F9, 0xFD1A, 0x075B, 0x0687, 0x02B4, 0x08F3, 0xFF11,
0x059C, 0xFC27, 0x0252, 0xFB8C, 0xFED6, 0xFDF3, 0xFEBC, 0x01C8,
0x01FE, 0x016E, 0xFF36, 0x0105, 0xFB14, 0x04B4, 0x033A, 0x045E,
0x0AC5, 0x0078, 0x067E, 0xFD56, 0xFF51, 0xFC75, 0xF86D, 0xFC63,
0xF7A8, 0xFD09, 0x0112, 0xFEEB, 0x064F, 0x013B, 0x01C9, 0x05C2,
0x04D6, 0x0679, 0x0DD4, 0x02BF, 0x0922, 0xFF51, 0xFCAB, 0xFC22,
0xF578, 0xFA7D, 0xF26A, 0xFAB8, 0xF4FA, 0xFF0A, 0xFD93, 0x03BA,
0x00DF, 0x0658, 0xFE86, 0x0893, 0x02AD, 0x06B8, 0x05AB, 0x017E,
0x0020, 0xFB18, 0xFB7A, 0xF764, 0xFA41, 0xF863, 0xFDB3, 0xFC8C,
0x07AB, 0x01E6, 0x0DFE, 0x0587, 0x08A5, 0x095A, 0x02FC, 0x08E8,
0x0543, 0x0155, 0x03FE, 0xF97F, 0xFBB3, 0xF661, 0xF5FB, 0xF7EC,
0xF6EE, 0xF9F2, 0xFC16, 0xFDD7, 0x0003, 0x02CA, 0xFDA9, 0x067C,
0xFA82, 0x091F, 0x0064, 0x06A7, 0x06E0, 0x0189, 0x0459, 0xFDF3,
0x008F, 0xFC77, 0xFFB0, 0xFCE6, 0xFF82, 0xFFD5, 0x0172, 0x0330,
0x02A1, 0x02F0, 0xFD60, 0x02E0, 0xFB07, 0x0370, 0x034E, 0x01A7,
0x07A8, 0xFDDD, 0x01F6, 0xFB3D, 0xFC29, 0xFC5D, 0xF8A4, 0xFD8E,
0xFA21, 0xFE7B, 0x02AB, 0xFF94, 0x0568, 0x025E, 0x018F, 0x05A6,
0x074F, 0x03AA, 0x0E8A, 0x0027, 0x0719, 0xFDDD, 0xFB15, 0xFC20,
0xF5F4, 0xFB25, 0xF5AA, 0xFC4C, 0xF98E, 0x00D8, 0xFEEB, 0x057E,
0xFF0F, 0x0843, 0xFFAC, 0x079A, 0x0511, 0x053E, 0x042E, 0x0172,
0xFCD5, 0xFC14, 0xF8C7, 0xF9A9, 0xF92B, 0xFA6E, 0xFF6F, 0xFDFD,
0x09F7, 0x025F, 0x0C65, 0x0667, 0x0706, 0x08DA, 0x063A, 0x065D,
0x0675, 0xFFAB, 0x0096, 0xF7E8, 0xF8E0, 0xF619, 0xF4E1, 0xF908,
0xF812, 0xFB5C, 0x0020, 0xFEE7, 0x0261, 0x0320, 0xFBBF, 0x0656,
0xFAF4, 0x06DE, 0x037A, 0x0488, 0x057E, 0x0012, 0x006A, 0xFCC7,
0xFE9D, 0xFCA2, 0xFFC9, 0xFD29, 0x020A, 0x00C5, 0x04D7, 0x0458,
0x020F, 0x0397, 0xFB79, 0x01DC, 0xFC6F, 0x015C, 0x024B, 0x002C,
0x02CE, 0xFC41, 0xFEA8, 0xFB0C, 0xFB3F, 0xFCBB, 0xFA5B, 0xFE1E,
0xFDA6, 0x0045, 0x0380, 0x0172, 0x02E8, 0x02AA, 0x0175, 0x03FF,
0x0947, 0x032C, 0x0D1B, 0xFF4D, 0x03C5, 0xFBE3, 0xF8AA, 0xFAC9,
0xF59D, 0xF94C, 0xF8BC, 0xFB48, 0xFC77, 0x0031, 0xFD45, 0x0430,
0xFCD2, 0x0668, 0x01A9, 0x05EF, 0x063D, 0x03C1, 0x0126, 0xFF44,
0xF9AB, 0xFB8C, 0xF806, 0xF995, 0xFAB8, 0xFA19, 0x018C, 0xFE9A,
0x0950, 0x02BC, 0x08DE, 0x064E, 0x065F, 0x0867, 0x08CB, 0x05DC,
0x0505, 0xFD61, 0xFB36, 0xF569, 0xF4E2, 0xF4FF, 0xF3E5, 0xF75A,
0xF993, 0xFAE5, 0x01E7, 0xFF67, 0x0152, 0x03BC, 0xFA0A, 0x06C9,
0xFCED, 0x0691, 0x053B, 0x03A3, 0x02C5, 0xFDD4, 0xFC7C, 0xFAB1,
0xFD00, 0xFAA7, 0x0162, 0xFBCA, 0x057A, 0x00E6, 0x05CD, 0x04F6,
0xFFAB, 0x049D, 0xFBF8, 0x0249, 0xFF2C, 0x0080, 0xFF8C, 0xFCDE,
0xFCCA, 0xF888, 0xFB38, 0xF87E, 0xFB06, 0xFA1D, 0xFD82, 0xFDB3,
0x00C1, 0x01C9, 0x010B, 0x0323, 0xFF6D, 0x0416, 0x0250, 0x0508,
0x0759, 0x01B8, 0x0646, 0xFA56, 0xFF36, 0xF83E, 0xF729, 0xF84E,
0xF5D3, 0xF659, 0xFBB4, 0xFA4F, 0xFDE9, 0x0192, 0xFA43, 0x063B,
0xFC2D, 0x07FB, 0x03A6, 0x0647, 0x0384, 0x0030, 0xFC76, 0xFAD2,
0xF7F1, 0xF959, 0xF8B7, 0xF703, 0xFE40, 0xF8B2, 0x057D, 0xFF9C,
0x08D9, 0x040C, 0x07AD, 0x0728, 0x0926, 0x09DB, 0x09DB, 0x0526,
0x012A, 0xF994, 0xF734, 0xF37F, 0xF334, 0xF348, 0xF44A, 0xF551,
0xFBD5, 0xFBE7, 0x02E5, 0x0201, 0xFF90, 0x059E, 0xFA5E, 0x0792,
0xFE2C, 0x05AF, 0x016B, 0xFEEE, 0xFD54, 0xF98E, 0xF9D9, 0xF99F,
0xFBEF, 0xF985, 0x02BD, 0xFC79, 0x0909, 0x0404, 0x06CE, 0x0803,
0xFFFB, 0x06C1, 0x001D, 0x0414, 0x0180, 0xFF91, 0xFCC6, 0xF8CA,
0xFADC, 0xF66F, 0xFC4D, 0xF796, 0xFD5D, 0xFA27, 0x0250, 0x00B7,
0x055D, 0x05CA, 0x014A, 0x0637, 0x00EA, 0x05A1, 0x066C, 0x04AA,
0x06CF, 0xFE36, 0x033E, 0xF7B2, 0xFFB9, 0xF877, 0xF9D1, 0xF8E7,
0xF91D, 0xF98F, 0xFFF9, 0xFF7E, 0xFFC8, 0x0609, 0xF9D5, 0x0938,
0xFE2F, 0x094F, 0x051D, 0x048B, 0x0131, 0xFC60, 0xFA8F, 0xF9BA,
0xF8AA, 0xF9C3, 0xFBF1, 0xF921, 0x042E, 0xFE02, 0x0A17, 0x0467,
0x0911, 0x06C3, 0x0950, 0x08B8, 0x0D64, 0x0999, 0x0AED, 0x01A4,
0x015D, 0xF720, 0xF979, 0xF399, 0xF643, 0xF391, 0xFA15, 0xF8B2,
0x0372, 0x0164, 0x0696, 0x05B5, 0x0139, 0x07A4, 0xFEB1, 0x09B9,
0xFFAD, 0x059D, 0xFE80, 0xFCB7, 0xFC3F, 0xFA6A, 0xFA89, 0xFB64,
0xFDD4, 0xFBE7, 0x0855, 0x01FD, 0x0E14, 0x08EC, 0x06B1, 0x0A5D,
0x0040, 0x08AC, 0x030F, 0x0502, 0x0167, 0xFCEA, 0xFA7C, 0xF720,
0xFA61, 0xF79A, 0xFE25, 0xF860, 0x0268, 0xFD82, 0x0900, 0x0605,
0x08B4, 0x08B5, 0x01FB, 0x0745, 0x0335, 0x065D, 0x07B1, 0x01FC,
0x053E, 0xF9B9, 0x02A1, 0xF752, 0x0186, 0xF94B, 0xFD92, 0xFB4E,
0xFE6C, 0xFF9E, 0x037E, 0x03E7, 0xFF2F, 0x0773, 0xF92B, 0x0A7E,
0xFE71, 0x0965, 0x0313, 0x00B6, 0xFF3D, 0xFA0C, 0xFAF8, 0xFB59,
0xFA03, 0xFB92, 0xFEEB, 0xFDF6, 0x0841, 0x04F5, 0x0A0B, 0x084B,
0x061E, 0x0811, 0x09A1, 0x0913, 0x0D94, 0x0676, 0x089B, 0xFD12,
0x0160, 0xF73B, 0xFB91, 0xF543, 0xF8CC, 0xF56E, 0xFDFC, 0xFCA9,
0x053C, 0x03EF, 0x0406, 0x05A3, 0x0065, 0x06ED, 0x0077, 0x078C,
0xFDE4, 0xFFED, 0xFB91, 0xF8C5, 0xFC9D, 0xFB17, 0xFB66, 0xFCD5,
0xFE69, 0xFF58, 0x0987, 0x06A5, 0x0BF1, 0x0A8F, 0x025D, 0x0A0A,
0xFEF3, 0x08B5, 0x01B4, 0x0284, 0xFEA3, 0xF906, 0xF98C, 0xF773,
0xF981, 0xF94C, 0xFDB6, 0xF9EE, 0x04BE, 0x00B5, 0x098C, 0x07DE,
0x0523, 0x07C8, 0xFFFE, 0x05A2, 0x0350, 0x03CA, 0x05F7, 0xFC94,
0x0433, 0xF67A, 0x03DD, 0xF88E, 0x02DA, 0xFA6B, 0x0076, 0xFD1D,
0x01DA, 0x026E, 0x01FE, 0x03F6, 0xFBB0, 0x04D1, 0xF8DF, 0x07EB,
0xFD28, 0x0534, 0xFFDA, 0xFC4D, 0xFE47, 0xF9D9, 0xFA63, 0xFC4C,
0xF808, 0xFDC0, 0xFE67, 0x02AC, 0x0737, 0x07B4, 0x0504, 0x07D0,
0x015C, 0x06CD, 0x073F, 0x0667, 0x0A8B, 0x0160, 0x0599, 0xFB41,
0x003E, 0xF93B, 0xFBC7, 0xF6B9, 0xFA53, 0xF858, 0x0019, 0x0055,
0x046D, 0x0488, 0x01CF, 0x043B, 0x00F0, 0x05BD, 0x014E, 0x0417,
0xFD3A, 0xFC5D, 0xFAEC, 0xF957, 0xFC70, 0xFB9B, 0xFD01, 0xFDC7,
0x0248, 0x02C2, 0x0BE6, 0x086D, 0x0B89, 0x099D, 0x0335, 0x0927,
0x003F, 0x07DA, 0x0109, 0xFFE7, 0xFE53, 0xF8CA, 0xF983, 0xF95D,
0xF882, 0xF9AC, 0xFED0, 0xFBC3, 0x07E1, 0x0387, 0x08E7, 0x07DB,
0x026C, 0x06AB, 0xFF84, 0x0704, 0x0104, 0x03E8, 0x01D3, 0xFAF6,
0x0220, 0xF7B3, 0x0262, 0xF94C, 0x0310, 0xFAAD, 0x058D, 0xFF39,
0x05CD, 0x0303, 0x0096, 0x01AF, 0xFBC7, 0x0387, 0xFAC4, 0x07E6,
0xFBC2, 0x0254, 0xFE22, 0xFAE5, 0xFEB7, 0xFB45, 0xFB8E, 0xFBF6,
0xFB91, 0xFDD8, 0x03AC, 0x0424, 0x0887, 0x07AD, 0x0333, 0x0674,
0x009D, 0x06F4, 0x0584, 0x053E, 0x07AD, 0xFE9C, 0x046A, 0xFB91,
0x0053, 0xF9C6, 0xFDCF, 0xF748, 0xFF70, 0xFAC6, 0x02FB, 0x0111,
0x01E9, 0x0289, 0xFEFD, 0x0371, 0xFEBA, 0x05EF, 0xFD72, 0x0138,
0xF9DE, 0xFAA6, 0xF8A7, 0xF9E1, 0xFB7E, 0xFAEE, 0x00AD, 0xFE4D,
0x07CE, 0x03C0, 0x0C7A, 0x0700, 0x09BE, 0x0797, 0x0316, 0x08E2,
0xFE1D, 0x0576, 0xFD2D, 0xFBF6, 0xFD1B, 0xF848, 0xF9DE, 0xF918,
0xF9D8, 0xF935, 0x035D, 0xFC86, 0x0BA7, 0x02FA, 0x0766, 0x06A0,
0xFF7B, 0x07F5, 0xFD55, 0x08A9, 0xFD1D, 0x021B, 0xFD49, 0xFA66,
0xFF35, 0xF886, 0x0221, 0xF860, 0x0716, 0xFB45, 0x0B7F, 0x00CC,
0x080A, 0x0340, 0xFEE5, 0x0208, 0xF9BB, 0x04DF, 0xF87D, 0x06D3,
0xF8BE, 0x0040, 0xFBE1, 0xFB83, 0xFE14, 0xFAF6, 0xFE2B, 0xFB64,
0x0190, 0xFF8A, 0x0732, 0x0561, 0x0721, 0x07BE, 0x020E, 0x088A,
0x0009, 0x0863, 0x0307, 0x0190, 0x0672, 0xFC2D, 0x04C1, 0xFBAB,
0x00ED, 0xF8A9, 0x0246, 0xF7BF, 0x05B7, 0xFCB9, 0x03A0, 0x01D7,
0xFE40, 0x02E7, 0xFCE5, 0x04C9, 0xFD25, 0x043B, 0xFB1B, 0xFD7E,
0xF8BB, 0xFA39, 0xF719, 0xF99B, 0xFA46, 0xFA1D, 0x031B, 0xFFB4,
0x096D, 0x05B6, 0x08C8, 0x0792, 0x05D9, 0x0916, 0x02A5, 0x09F1,
0xFDAA, 0x023D, 0xFC09, 0xF99E, 0xFCD0, 0xF852, 0xFAB6, 0xF8A2,
0xFD11, 0xF9BB, 0x06D6, 0xFDB6, 0x0AD4, 0x0280, 0x0378, 0x0594,
0xFCA3, 0x089F, 0xFB1D, 0x0679, 0xFADD, 0xFDC7, 0xFBE8, 0xF8FF,
0xFD86, 0xF6FF, 0x0219, 0xF6D9, 0x0A77, 0xFBFD, 0x0D09, 0x01C1,
0x0455, 0x0330, 0xFA09, 0x0362, 0xF649, 0x053D, 0xF566, 0x0257,
0xF670, 0xFD3B, 0xF971, 0xFAF4, 0xFBD9, 0xF981, 0xFF85, 0xFB71,
0x03EC, 0x0101, 0x0426, 0x05F4, 0x005E, 0x0845, 0xFD9B, 0x0A19,
0xFCDB, 0x0680, 0xFFEE, 0xFD7A, 0x0579, 0xFA19, 0x0442, 0xF94F,
0x015D, 0xF777, 0x05EE, 0xF913, 0x0788, 0xFE08, 0xFEBC, 0x019A,
0xF7C6, 0x0312, 0xF960, 0x03D5, 0xFB33, 0xFEC7, 0xFA86, 0xF935,
0xF878, 0xF87C, 0xF6C7, 0xF811, 0xFBE1, 0xFA83, 0x049F, 0x0162,
0x0607, 0x06D5, 0x018A, 0x0831, 0x00A4, 0x0A0F, 0x0048, 0x078F,
0xFCC2, 0xFDCA, 0xFC1E, 0xF7DE, 0xFC7F, 0xF726, 0xFB92, 0xF8E7,
0xFF4A, 0xFCD2, 0x05C2, 0x00D5, 0x052F, 0x03D7, 0xFE8A, 0x06EB,
0xFB2F, 0x0853, 0xFBC5, 0x0221, 0xFD3F, 0xFAC9, 0xFDFB, 0xF79B,
0xFF00, 0xF55E, 0x0566, 0xF762, 0x0D5B, 0xFE61, 0x0B7E, 0x03D5,
0x0031, 0x049B, 0xF86A, 0x04FE, 0xF6EB, 0x02B9, 0xF678, 0xFD74,
0xF826, 0xFB6C, 0xFA58, 0xF97D, 0xFCEE, 0xF908, 0x01D8, 0xFDCA,
0x0309, 0x0421, 0xFE05, 0x0814, 0xFAAB, 0x0A64, 0xFBC1, 0x0ACF,
0xFCEC, 0x0327, 0x00B2, 0xFA82, 0x0590, 0xF888, 0x04A9, 0xF85B,
0x03E2, 0xF97A, 0x0781, 0xFD0B, 0x0560, 0x013D, 0xFB1F, 0x03B3,
0xF65A, 0x04F2, 0xFA14, 0x018D, 0xFDCE, 0xF9A0, 0xFE35, 0xF649,
0xFA4E, 0xF67A, 0xF873, 0xF7E8, 0xFDFB, 0xFCDE, 0x0322, 0x03C8,
0x0183, 0x0813, 0xFEAC, 0x0976, 0x0012, 0x0985, 0x00DB, 0x02FA,
0xFF06, 0xFA64, 0xFCD2, 0xF6D4, 0xFB04, 0xF6E0, 0xFC09, 0xFB3A,
0xFF3D, 0x013C, 0x00BB, 0x0465, 0xFEB7, 0x052E, 0xFBD3, 0x06FC,
0xFA56, 0x04ED, 0xFBC2, 0xFD86, 0xFE3F, 0xF937, 0xFC94, 0xF6ED,
0xFCF3, 0xF641, 0x0513, 0xFAA1, 0x0B99, 0x016C, 0x07B4, 0x0514,
0xFEA3, 0x0543, 0xFA13, 0x036E, 0xF8E1, 0xFCC8, 0xF87A, 0xF825,
0xF8E9, 0xF897, 0xF9D2, 0xF886, 0xFE60, 0xFADD, 0x03CA, 0x010F,
0x023F, 0x065A, 0xFBC4, 0x08CB, 0xFA4E, 0x0AE9, 0xFD5F, 0x0836,
0xFF2A, 0xFF7F, 0x01A5, 0xFA06, 0x03E7, 0xF8E4, 0x0486, 0xFA48,
0x0616, 0xFDC1, 0x0778, 0x016A, 0x0339, 0x03B4, 0xFA74, 0x0526,
0xF6EE, 0x0452, 0xFA54, 0xFD3C, 0xFECB, 0xF73C, 0xFE2D, 0xF699,
0xF95E, 0xF7E1, 0xFA5F, 0xFBED, 0x00ED, 0x017A, 0x032E, 0x0659,
0xFFF5, 0x0899, 0xFF26, 0x0915, 0x01EC, 0x067E, 0x034E, 0xFF95,
0x0172, 0xFA1E, 0xFCB7, 0xF79A, 0xFBB9, 0xF8CC, 0xFFC5, 0xFE83,
0x01B8, 0x0473, 0x008D, 0x05EA, 0xFF3C, 0x0581, 0xFE3B, 0x05A7,
0xFCEF, 0x0143, 0xFE03, 0xFC4B, 0xFE52, 0xFACE, 0xFB63, 0xF9FF,
0xFE0C, 0xFAB8, 0x0655, 0xFE31, 0x0A26, 0x035E, 0x05D6, 0x05F0,
0xFEE8, 0x05DE, 0xFB3C, 0x0209, 0xFB03, 0xFAF9, 0xF9E1, 0xF878,
0xF69B, 0xF951, 0xF995, 0xFA45, 0x0228, 0xFCD0, 0x052A, 0x01B2,
0x0102, 0x0630, 0xFBBC, 0x08B3, 0xFAD6, 0x0997, 0xFDE6, 0x0567,
0x0089, 0xFF72, 0x001F, 0xFBA1, 0x00C3, 0xF9F3, 0x05D6, 0xFB89,
0x087C, 0xFEFC, 0x063D, 0x0243, 0x0164, 0x0378, 0xFA63, 0x0495,
0xF64B, 0x02D9, 0xF969, 0xFC59, 0xFDC1, 0xF804, 0xFB75, 0xF6D5,
0xF927, 0xF887, 0xFD47, 0xFCC2, 0x00EB, 0x019B, 0xFF84, 0x05F3,
0xFD42, 0x0831, 0xFE3B, 0x083B, 0x00B6, 0x04B6, 0x021F, 0xFFBA,
0xFF56, 0xFB50, 0xFB7F, 0xF841, 0xFEBD, 0xF938, 0x0375, 0xFDE8,
0x021C, 0x0377, 0xFEB8, 0x052F, 0xFDCE, 0x043C, 0xFD88, 0x02CC,
0xFCC2, 0xFFD7, 0xFCA6, 0xFD4C, 0xFB51, 0xFB30, 0xFC24, 0xFA65,
0x01E6, 0xFB8C, 0x06F8, 0xFEBC, 0x0769, 0x0330, 0x0399, 0x05D5,
0xFE14, 0x059F, 0xFACC, 0x011C, 0xFAC7, 0xFB69, 0xF7B0, 0xF883,
0xF4E8, 0xF871, 0xFC71, 0xF9F2, 0x0511, 0xFC9B, 0x0495, 0x01EE,
0xFF57, 0x0656, 0xFAF7, 0x0850, 0xF9F5, 0x07DA, 0xFCE1, 0x0408,
0xFF53, 0xFF81, 0xFE9C, 0xFAF8, 0x02CD, 0xF90C, 0x0A7B, 0xFAF2,
0x0AE1, 0xFEDC, 0x0684, 0x0258, 0x021C, 0x03E3, 0xFC00, 0x046D,
0xF76C, 0x0154, 0xF97B, 0xFBA9, 0xFBD1, 0xF700, 0xFB78, 0xF524,
0xFEA9, 0xF757, 0x0135, 0xFC93, 0x0039, 0x02FA, 0xFE7C, 0x06A8,
0xFBEB, 0x085C, 0xFBBD, 0x07F9, 0xFF05, 0x03E7, 0xFFE2, 0xFF74,
0xFC9E, 0xFB3C, 0xFDF3, 0xF890, 0x03FB, 0xF973, 0x0532, 0xFECD,
0x01F9, 0x04DD, 0xFECA, 0x062F, 0xFCF9, 0x04C4, 0xFCEE, 0x01F7,
0xFD2F, 0xFECC, 0xFB48, 0xFC6E, 0xFBDE, 0xFAF6, 0x023A, 0xFB3A,
0x0621, 0xFD46, 0x066E, 0x01A2, 0x066C, 0x054A, 0x02F8, 0x067C,
0xFDA3, 0x054F, 0xFBD5, 0x0085, 0xFB40, 0xFA82, 0xF7B1, 0xF723,
0xF924, 0xF7C7, 0x018B, 0xFA2B, 0x05AD, 0xFE95, 0x0350, 0x0469,
0xFE2D, 0x07FD, 0xF8D3, 0x09AF, 0xF84C, 0x0860, 0xFCB2, 0x03E3,
0xFE2C, 0xFF05, 0xFF38, 0xFB8A, 0x0763, 0xFA45, 0x0D80, 0xFC8E,
0x0A82, 0x025F, 0x0536, 0x05CB, 0x00CE, 0x05D5, 0xFB65, 0x04A6,
0xF893, 0x0021, 0xFA53, 0xF97E, 0xFC2B, 0xF4B2, 0x008D, 0xF441,
0x05F8, 0xF784, 0x04A8, 0xFEDC, 0x009C, 0x06E8, 0xFD85, 0x09F3,
0xFA5A, 0x0A0F, 0xFB76, 0x078E, 0x0030, 0x0275, 0x00A5, 0xFDFD,
0x0029, 0xFB08, 0x0555, 0xF958, 0x08C2, 0xFB4F, 0x05D7, 0x029F,
0x00EA, 0x08B2, 0xFC76, 0x0958, 0xFAEF, 0x05F0, 0xFD5A, 0x00BE,
0xFDBF, 0xFD33, 0xFB83, 0xFB9C, 0x0058, 0xFB8D, 0x080D, 0xFCEF,
0x0825, 0x00D9, 0x053F, 0x056F, 0x034D, 0x074E, 0x000E, 0x0745,
0xFDE8, 0x0411, 0xFE02, 0xFDD4, 0xFC1C, 0xF845, 0xFB7E, 0xF62C,
0x0093, 0xF74F, 0x0576, 0xFB5A, 0x0608, 0x022D, 0x020A, 0x0741,
0xFB72, 0x093D, 0xF7C5, 0x090D, 0xF995, 0x05CF, 0xFC73, 0x0109,
0xFD89, 0xFD51, 0x02C6, 0xFB42, 0x0AA8, 0xFB13, 0x0CCD, 0x004E,
0x08AF, 0x06DE, 0x0203, 0x0826, 0xFDCF, 0x06E3, 0xFC70, 0x032E,
0xFA5C, 0xFCC7, 0xF901, 0xF6CB, 0xFCD8, 0xF32D, 0x042E, 0xF2E2,
0x0695, 0xF872, 0x029C, 0x034D, 0xFD2B, 0x09E7, 0xF954, 0x0A96,
0xF915, 0x0906, 0xFC5F, 0x03BA, 0xFEFE, 0xFE00, 0xFFB0, 0xFB58,
0x03AE, 0xF99E, 0x083E, 0xF89E, 0x078F, 0xFD97, 0x038A, 0x05F6,
0xFDD3, 0x0900, 0xF9E4, 0x0841, 0xFB91, 0x045A, 0xFDBF, 0xFD0B,
0xFC0E, 0xF9A9, 0xFD12, 0xF9F5, 0x0379, 0xFA02, 0x06E4, 0xFCFA,
0x0450, 0x0393, 0x00C7, 0x0743, 0xFE74, 0x066C, 0xFE1A, 0x04DC,
0x0021, 0x0064, 0xFDFA, 0xF933, 0xFA11, 0xF548, 0xFE75, 0xF475,
0x02BC, 0xF535, 0x0248, 0xFBDC, 0x01E0, 0x0365, 0xFDC6, 0x0545,
0xF89F, 0x069B, 0xF8B7, 0x0770, 0xFBE3, 0x03E8, 0xFBDE, 0xFF38,
0xFE87, 0xFCD2, 0x06BE, 0xFBAF, 0x098A, 0xFD18, 0x0940, 0x02FF,
0x0715, 0x090C, 0xFF25, 0x07EF, 0xFB5F, 0x03D6, 0xFE88, 0x00AF,
0xFB36, 0xF8F0, 0xF517, 0xF3A8, 0xFAF1, 0xF17A, 0x02E0, 0xF19B,
0x0359, 0xFB2E, 0xFF5F, 0x03DF, 0xF9BD, 0x087A, 0xF799, 0x0A2F,
0xFA0F, 0x06A1, 0xFF6E, 0x034B, 0x0147, 0xFDA6, 0x0160, 0xF95A,
0x0519, 0xF8E9, 0x05B7, 0xF961, 0x053F, 0x009E, 0x031D, 0x06C9,
0xFC1D, 0x072E, 0xF949, 0x06E1, 0xFC9D, 0x01AD, 0xFE7E, 0xF9FA,
0xFB00, 0xF64D, 0xFA59, 0xF5C5, 0xFF03, 0xF8A7, 0x0189, 0xFEC1,
0x0131, 0x0311, 0xFE36, 0x05D1, 0xFC9F, 0x06A7, 0x00EC, 0x052D,
0x0528, 0x032F, 0x03E7, 0xFCDA, 0xFFB3, 0xF690, 0xFD62, 0xF337,
0xFD94, 0xF46A, 0xFEA2, 0xFDF5, 0xFEE6, 0x020C, 0xFB56, 0x021E,
0xF8A3, 0x05AE, 0xFAF0, 0x02D2, 0xFB4F, 0x0001, 0xFAFA, 0xFE2E,
0xFD5B, 0xF81C, 0xFFFE, 0xF838, 0x04AE, 0xFD37, 0x0733, 0x00DC,
0x04BD, 0x0432, 0x024E, 0x0708, 0x0478, 0x0834, 0x0786, 0x0450,
0x03AD, 0xFE4A, 0xFEBB, 0xF854, 0xFCA4, 0xF132, 0xFC7E, 0xF2FA,
0xFFBF, 0xFE84, 0xFF1F, 0x0540, 0xF7E7, 0x0705, 0xF616, 0x083E,
0xFA87, 0x02C3, 0xFAB0, 0xFE0B, 0xFDC1, 0xFCF2, 0x0302, 0xF76D,
0xFFF5, 0xF57D, 0xFEAF, 0xF950, 0x0305, 0xFFB0, 0x0296, 0x050D,
0xFE7F, 0x075A, 0x02AB, 0x0C0B, 0x076C, 0x0706, 0x01D5, 0xFD86,
0x009B, 0xFBD1, 0x009E, 0xF5A6, 0xFA7E, 0xF8EE, 0xFC2C, 0x0301,
0xFFE8, 0x037F, 0xFD03, 0x0607, 0xFC82, 0x04AF, 0x012D, 0x0166,
0x0156, 0xFF95, 0xFE4D, 0xFA84, 0x0280, 0xF90F, 0x0195, 0xF2AD,
0xF9BF, 0xF1E1, 0xFB2F, 0xFEB6, 0xFE88, 0x0335, 0x00DF, 0x06C4,
0x061B, 0x0D4E, 0x05A8, 0x0A79, 0xFDFD, 0x05FB, 0xFA38, 0x00E5,
0x0303, 0xFC06, 0x0497, 0xFBAF, 0xFD2F, 0xFC68, 0x0155, 0x015A,
0x01F9, 0x0408, 0xFF3D, 0x0060, 0x0321, 0x0270, 0x0213, 0xFF82,
0xFE32, 0xF937, 0xFCE4, 0xF9FB, 0x00BA, 0xF174, 0x039A, 0xF1A5,
0xFE14, 0xFDEC, 0xFD95, 0x05F8, 0x04B8, 0x1265, 0x0723, 0x1188,
0x0467, 0x08ED, 0xFE00, 0x037B, 0xFD06, 0xFB30, 0x058D, 0xFD8E,
0x0680, 0xFAF7, 0x0130, 0xF7B4, 0xFD2A, 0x00D0, 0xF8D5, 0xFF5C,
0xFAB3, 0x0009, 0xFD37, 0x046A, 0xFCCE, 0xFFB4, 0xFEB2, 0xFE25,
0xFFE6, 0xF784, 0x0438, 0xF6EE, 0x06B9, 0xFF6B, 0x00D5, 0x0063,
0x0122, 0x0AAF, 0x06B4, 0x1162, 0x089D, 0x0941, 0x04E8, 0x045C,
0xFE1C, 0xFDBA, 0x012B, 0xFA13, 0x044C, 0xFAA2, 0x04AF, 0xF79C,
0x0556, 0xFAA6, 0xF6DF, 0xFBAE, 0xEF50, 0xFAEC, 0xF7F0, 0x0304,
0xF9D3, 0x01F3, 0xF947, 0x00E6, 0xFB96, 0x0644, 0xFF55, 0xFD2C,
0x0431, 0xFBE9, 0x0AAE, 0x034E, 0x0FEA, 0x057A, 0x0AA9, 0x0DE4,
0x0585, 0x0DAB, 0x065A, 0x09B5, 0xFEB7, 0x0283, 0xF901, 0xF713,
0xFFFA, 0xF9F0, 0x00BF, 0xF5B9, 0xFF10, 0xF3A1, 0x04FB, 0xFBA6,
0x00C8, 0xF61F, 0xF311, 0xFB87, 0xED75, 0x069B, 0xF3A9, 0x0385,
0xF898, 0x025E, 0xF883, 0xFC3C, 0x04FD, 0xF869, 0x0EDC, 0xFC89,
0x0E75, 0x02D3, 0x1815, 0x0EF8, 0x14D9, 0x0D8C, 0x015F, 0x081C,
0xF508, 0x074D, 0xF20B, 0xFC6E, 0xF868, 0xFB80, 0xFE6D, 0xFEA3,
0x03AE, 0xF64E, 0x06DB, 0xFBA8, 0x05DB, 0x04EF, 0x044B, 0x0221,
0xF4E0, 0x001E, 0xE7B6, 0xFD80, 0xEFA9, 0x00A0, 0xF528, 0xFC6C,
0xFB40, 0xF0D2, 0x0B32, 0xF8A0, 0x102C, 0xFCD7, 0x1175, 0x013C,
0x1995, 0x10B7, 0x1548, 0x0D24, 0xF986, 0x02BD, 0xE2EB, 0xFB7E,
0xEB37, 0xF8EF, 0xF5CB, 0xFFC1, 0xF9FB, 0xFB24, 0x0878, 0xFDC8,
0x0CB3, 0x058A, 0x06C0, 0xFF60, 0x0A05, 0x052B, 0x021D, 0x0518,
0xEFBF, 0xFEB0, 0xEC92, 0x0213, 0xF3A1, 0xF978, 0x00EB, 0xF53D,
0x09E2, 0xF830, 0x0EE8, 0xFCA6, 0x1C43, 0x0B9B, 0x1E69, 0x1205,
0x114B, 0x0D41, 0xF797, 0x01F5, 0xDF14, 0xFA08, 0xE0EF, 0x0049,
0xEDBE, 0xFC03, 0xFCAE, 0xF20D, 0x09CF, 0xFAF1, 0x0C36, 0xFC44,
0x0F54, 0xF945, 0x0F96, 0x0853, 0x0432, 0x08B3, 0xF2C9, 0xFEBD,
0xE4E7, 0xF988, 0xEB3B, 0xF501, 0x0073, 0xFA7E, 0x0DAF, 0xFA6F,
0x1BAA, 0x0640, 0x290E, 0x1878, 0x206B, 0x14AB, 0x0A44, 0x12A0,
0xF4BA, 0x06C8, 0xE5AF, 0xFAA0, 0xDF5A, 0xFAFB, 0xE916, 0xF125,
0x0378, 0xF4C8, 0x0F5D, 0xF92A, 0x1031, 0xF664, 0x14F0, 0x0186,
0x088A, 0x04CB, 0xFA3D, 0x0548, 0xF088, 0x01FA, 0xE339, 0xF428,
0xE7AC, 0xF3AD, 0xF8D5, 0xFBBE, 0x0F55, 0x0439, 0x2459, 0x1319,
0x2A93, 0x17E6, 0x1EB2, 0x1025, 0x0130, 0x0A52, 0xF011, 0x0177,
0xEE3B, 0xFE0B, 0xE560, 0xF642, 0xEC1A, 0xEF8F, 0x0308, 0xF9F8,
0x0BE2, 0xF2EA, 0x0FC9, 0xF598, 0x114C, 0x03AA, 0x0614, 0x01ED,
0xFA71, 0x0A72, 0xEEEA, 0x02B4, 0xE7E7, 0xFA31, 0xE7CF, 0xFEB9,
0xF496, 0xFC25, 0x1979, 0x0AE9, 0x2E37, 0x117B, 0x2540, 0x0D98,
0x140D, 0x0A6F, 0xFE0B, 0xFF13, 0xF5F3, 0x0461, 0xF035, 0x0154,
0xE4A0, 0xF06F, 0xEA4A, 0xF3ED, 0xF897, 0xF4FA, 0x0A6B, 0xF0DD,
0x14E5, 0xFABF, 0x0E63, 0x03A8, 0x0540, 0x0BD9, 0xF4DD, 0x0A52,
0xEF60, 0xFE40, 0xF323, 0x0079, 0xEC4C, 0xFD3A, 0x0165, 0xFFF1,
0x25B4, 0x0FF7, 0x2C84, 0x0AA3, 0x1D90, 0x0610, 0x0847, 0x00C3,
0xFCD1, 0x00D1, 0xF344, 0x081E, 0xE648, 0xF3B7, 0xE7A4, 0xF32E,
0xEAAA, 0xFA03, 0xF3C9, 0xEDDC, 0x08E4, 0xF94E, 0x0DDA, 0x0385,
0x0ACA, 0x087C, 0x02BD, 0x08C3, 0xF85F, 0xFF99, 0xFC15, 0x04DF,
0xF64E, 0x0149, 0xF9A9, 0xFE34, 0x16D0, 0x0C7E, 0x2468, 0x0BD6,
0x1C9B, 0x01AC, 0x0A9F, 0xFB47, 0xFDA8, 0xFC12, 0xF9E7, 0x0751,
0xEF14, 0xFCB5, 0xEBA3, 0xF417, 0xE7C6, 0x01E0, 0xE156, 0xF6B3,
0xF4D0, 0xEE9D, 0x047A, 0xF79C, 0x07FA, 0xFF44, 0x0ABC, 0x0763,
0x0313, 0xFECE, 0x0529, 0x05E1, 0x011C, 0x0B2B, 0xFC67, 0x001F,
0x0CFB, 0x0F03, 0x1555, 0x0FB0, 0x121C, 0xFF1C, 0x04B4, 0xF587,
0xFDD3, 0xF644, 0x04F4, 0x086E, 0xFAF7, 0x03AB, 0xF3C7, 0xFD0A,
0xF36F, 0x052E, 0xE52D, 0xF5F5, 0xE7B1, 0xEB8C, 0xF9DD, 0xF275,
0x01EB, 0xF5B1, 0x039A, 0xF9D8, 0x05A5, 0xFCA9, 0x0CDE, 0x0270,
0x08C4, 0x0B72, 0x0127, 0x07C0, 0x0D4A, 0x0CD9, 0x1164, 0x134B,
0x07CC, 0x024E, 0xFCE7, 0xF645, 0xF28D, 0xF3D3, 0xFAE5, 0x04B8,
0x0033, 0x09CA, 0xFB71, 0xF796, 0x0086, 0x08D5, 0xF67C, 0x0400,
0xEC00, 0xEA85, 0xF3D8, 0xF28E, 0xFBC9, 0xF5FA, 0xFE5F, 0xF5FB,
0xFA56, 0xF358, 0x07EE, 0xFD44, 0x0FF1, 0x0CE1, 0x0612, 0x0850,
0x1552, 0x1489, 0x1AD6, 0x1A92, 0x0443, 0x0972, 0xEEF6, 0xF9D0,
0xE5DF, 0xECCE, 0xF047, 0xF4F2, 0xF77D, 0xFD8E, 0xFCEC, 0xF665,
0x08F1, 0x0195, 0x0361, 0x0AAD, 0xF9E2, 0xF946, 0xF4BF, 0xF14F,
0xEDF1, 0xF3C6, 0xEE62, 0xF115, 0xEDDB, 0xF020, 0xFC04, 0xF470,
0x0FD4, 0x063E, 0x0F2D, 0x0DC0, 0x1BF5, 0x186A, 0x2AB0, 0x2CA2,
0x16AB, 0x16AE, 0xF236, 0xF7CB, 0xDC45, 0xE8E9, 0xE4FD, 0xEA28,
0xEF43, 0xF38D, 0xF572, 0xEA85, 0x0B49, 0xFA20, 0x0C06, 0x090C,
0x00FD, 0xFD78, 0x020D, 0xFB6A, 0xF2E9, 0xF68A, 0xE2B5, 0xF07B,
0xDFCA, 0xE96F, 0xEDE7, 0xECCC, 0x028D, 0x0235, 0x07BA, 0x0DA7,
0x1CE0, 0x1848, 0x3497, 0x2B5E, 0x2C66, 0x2876, 0x0CDB, 0x06BB,
0xE453, 0xEB24, 0xDB74, 0xEAA9, 0xE957, 0xEE8D, 0xEDB5, 0xE550,
0xFEB4, 0xEE72, 0x0A99, 0x062C, 0x04D1, 0x017A, 0x0827, 0x0042,
0x0551, 0x05C7, 0xF00D, 0xF7ED, 0xD6CB, 0xEE89, 0xDAA6, 0xEC47,
0xF586, 0xF4BF, 0xFF28, 0xFFB5, 0x16DE, 0x0E9C, 0x39F1, 0x2855,
0x39A0, 0x2AA4, 0x2030, 0x176C, 0xFA9A, 0xF9A7, 0xDE6A, 0xEBF2,
0xD82C, 0xEE7A, 0xDB96, 0xDC84, 0xEF42, 0xE026, 0x0041, 0xFB5F,
0x05C8, 0x02E5, 0x109B, 0x03F5, 0x11C6, 0x111A, 0x03D3, 0x12BC,
0xE5A0, 0xF75D, 0xD342, 0xEAC0, 0xE664, 0xF2DC, 0xF700, 0xF528,
0x0C38, 0xFF67, 0x3319, 0x1D39, 0x4264, 0x2F9B, 0x2F26, 0x1D87,
0x0AC8, 0x047E, 0xECF1, 0xF7D6, 0xD8D5, 0xEF9F, 0xCB71, 0xDCAA,
0xDC12, 0xD661, 0xF4AD, 0xED58, 0xFAE6, 0xFBE9, 0x0824, 0x05E1,
0x14A6, 0x121F, 0x11E4, 0x1558, 0xFC1D, 0x0711, 0xE2AF, 0xF16F,
0xE4A1, 0xF0BB, 0xEEA0, 0xF2AF, 0x0403, 0xF914, 0x2AAD, 0x114A,
0x3ECF, 0x273B, 0x3249, 0x258B, 0x11D1, 0x089F, 0xFA6B, 0xFF1B,
0xE7C5, 0xFF33, 0xCC65, 0xE13A, 0xCBFA, 0xD646, 0xE1E5, 0xE9A6,
0xEAB3, 0xF16C, 0xFBF2, 0xF433, 0x1375, 0x0A46, 0x1918, 0x1B81,
0x0B72, 0x0A46, 0xF452, 0xF844, 0xEE96, 0xFA20, 0xEACB, 0xF665,
0xF477, 0xF295, 0x1AC2, 0x0668, 0x30C0, 0x1E95, 0x3177, 0x20BD,
0x1BBA, 0x0DEC, 0x0537, 0x0558, 0xFA1A, 0x0E2D, 0xDAF1, 0xF457,
0xCC04, 0xD9CB, 0xD947, 0xE698, 0xE304, 0xE991, 0xEF4B, 0xE9B6,
0x07FE, 0xFCAB, 0x1E8C, 0x147E, 0x14ED, 0x1199, 0xFF38, 0xFD00,
0xF787, 0x0017, 0xEA4F, 0xFBBA, 0xE9EA, 0xF39A, 0x0CCB, 0x036F,
0x28FC, 0x129E, 0x2650, 0x1A45, 0x1888, 0x0F2D, 0x0B75, 0x085A,
0x01E4, 0x13E4, 0xE8A7, 0xFAF2, 0xD2DC, 0xDC2F, 0xDA7F, 0xE615,
0xE1A5, 0xEBAC, 0xEEBC, 0xE44B, 0x035C, 0xF273, 0x17F0, 0x0FBD,
0x1CB3, 0x11FD, 0x073C, 0xFEDB, 0xFE77, 0x0317, 0xF0CD, 0x054E,
0xE737, 0xF56F, 0x0423, 0x02E7, 0x21E7, 0x1B81, 0x2256, 0x1BF1,
0x0E1C, 0x09CA, 0x0867, 0x01D0, 0x096F, 0x119F, 0xF185, 0xFD51,
0xDB44, 0xDD95, 0xDB5E, 0xE5F5, 0xDFA3, 0xE9E1, 0xE9F6, 0xE6C5,
0xFC12, 0xF1A9, 0x0DC7, 0x05D2, 0x16DB, 0x0CFC, 0x0B4E, 0x01B0,
0x0210, 0xFFDA, 0xF968, 0x04E3, 0xEE29, 0x0367, 0xFFC8, 0x0948,
0x1D72, 0x1767, 0x2458, 0x1D1A, 0x0F36, 0x0B24, 0x05EF, 0xF7E5,
0x0FC2, 0x0AC7, 0xF98C, 0x026A, 0xDE96, 0xDA3B, 0xDEB2, 0xE54F,
0xDB4B, 0xF2B7, 0xDFDD, 0xE47C, 0xF293, 0xECC4, 0x0496, 0x0991,
0x1082, 0x0B5A, 0x0E75, 0xF9AC, 0x05EB, 0x02BA, 0xF419, 0x0987,
0xECA4, 0x0185, 0xFF4D, 0x0C5D, 0x18AB, 0x19DE, 0x26FD, 0x1AC3,
0x1602, 0x0E62, 0x08D9, 0xFA96, 0x1928, 0x0599, 0x0AFB, 0x042E,
0xE0E3, 0xDCBF, 0xD8FF, 0xDC2D, 0xDC66, 0xF153, 0xDB5E, 0xEC18,
0xEBB3, 0xE9B4, 0x00C6, 0x0511, 0x0D09, 0x145D, 0x0CAF, 0x0260,
0x0B16, 0xFEB8, 0xF5EE, 0x0170, 0xE3F4, 0xFB3D, 0xFC64, 0x0779,
0x16EC, 0x19BA, 0x2763, 0x1CE9, 0x1CC6, 0x1263, 0x07AE, 0x0054,
0x183A, 0x08EB, 0x144A, 0x07CE, 0xE61F, 0xDBDA, 0xCF89, 0xD414,
0xD61E, 0xEB91, 0xDF1F, 0xEDDB, 0xEBD8, 0xEE14, 0x0243, 0x0ADA,
0x1195, 0x1DCA, 0x0EE8, 0x060A, 0x1496, 0xFE43, 0x05CF, 0x0172,
0xE471, 0xF248, 0xF082, 0xF931, 0x13DA, 0x1535, 0x29F3, 0x2026,
0x2032, 0x14CF, 0x0882, 0x04E7, 0x1098, 0x0BD4, 0x1536, 0x0BBA,
0xF411, 0xE30E, 0xD24E, 0xCE9E, 0xC730, 0xDE9C, 0xD0FE, 0xED00,
0xE585, 0xF14F, 0xFC38, 0x0531, 0x14FB, 0x210E, 0x173A, 0x148B,
0x1775, 0x0203, 0x14A9, 0x0142, 0xF68F, 0xF606, 0xEF99, 0xF3A8,
0x0615, 0x087E, 0x22CC, 0x1C4D, 0x217E, 0x17D5, 0x07E8, 0x0594,
0x150E, 0x11D3, 0x1B2E, 0x1804, 0xF7B4, 0xEBD2, 0xDBB9, 0xD354,
0xC942, 0xDB87, 0xC235, 0xDF45, 0xD764, 0xE275, 0xF7E3, 0xFE17,
0x12C4, 0x1EEA, 0x1C0E, 0x163F, 0x2296, 0x0EDA, 0x1A03, 0x0DDF,
0xFA5E, 0xF8B6, 0xF3D9, 0xF2C9, 0xFB74, 0x01D1, 0x0DBC, 0x117C,
0x1C63, 0x124C, 0x0C83, 0x0606, 0x1598, 0x14EF, 0x26E0, 0x283A,
0x079C, 0x0201, 0xDFC4, 0xD7B5, 0xCF02, 0xD6C4, 0xC6F8, 0xDCE0,
0xCB4E, 0xD822, 0xE9C9, 0xEA75, 0x12DA, 0x172C, 0x1EC7, 0x1C09,
0x2330, 0x1255, 0x2294, 0x1887, 0xFDD9, 0x0412, 0xED25, 0xF090,
0xF9A3, 0xFAE3, 0x07D1, 0x0844, 0x0EBC, 0x085D, 0x04F7, 0xFFB3,
0x1211, 0x1474, 0x2490, 0x2B9F, 0x1186, 0x0A36, 0xEF8F, 0xE6EB,
0xD328, 0xDCEF, 0xC8D2, 0xD958, 0xD11E, 0xD42C, 0xE448, 0xDF57,
0x0790, 0x0AE1, 0x1BA2, 0x17B3, 0x1F60, 0x14E0, 0x2150, 0x1EBF,
0x077A, 0x0DA9, 0xF27C, 0xFA2E, 0xF4D4, 0xFE8F, 0x01F2, 0x097C,
0x0A61, 0x03D4, 0xFD6C, 0xF10E, 0x0A6F, 0x0410, 0x2450, 0x26AE,
0x1504, 0x0F01, 0xF75F, 0xEA20, 0xDE54, 0xE278, 0xCC7E, 0xE0D2,
0xCD8D, 0xD7D6, 0xDD1F, 0xD8C4, 0xFCAA, 0xFCD5, 0x1226, 0x0F06,
0x1AE3, 0x0E5A, 0x22E4, 0x1FDD, 0x0EA0, 0x1886, 0xFB80, 0x0494,
0xFA64, 0x08F9, 0x00D0, 0x101C, 0x0817, 0x0639, 0xFC77, 0xEB66,
0x06AA, 0xF668, 0x20EA, 0x1F48, 0x171A, 0x0F4D, 0xFD31, 0xF021,
0xE375, 0xE8F1, 0xCD9E, 0xE403, 0xC90A, 0xDE07, 0xD429, 0xDCCB,
0xF3AD, 0xF6E6, 0x0D74, 0x02EE, 0x17B1, 0x05DA, 0x1FD8, 0x1F9B,
0x0E07, 0x1CFB, 0xFBFF, 0x0748, 0xFE22, 0x0890, 0x0489, 0x11DF,
0x0A62, 0x0D16, 0x006B, 0xEF2F, 0x0857, 0xEBCE, 0x243A, 0x1651,
0x1CE7, 0x118D, 0x0114, 0xEF99, 0xE443, 0xEA37, 0xCBF0, 0xE83C,
0xC964, 0xDFE7, 0xD13C, 0xDDE4, 0xED99, 0xFAC8, 0x097F, 0x0830,
0x1296, 0xFF9E, 0x1D05, 0x17DE, 0x0EBB, 0x1C88, 0xFC36, 0x0437,
0xFC4D, 0x068B, 0x03E4, 0x112C, 0x0CCF, 0x0E0D, 0x00B8, 0xF506,
0x05FE, 0xED84, 0x203F, 0x10AF, 0x18C6, 0x0C66, 0x024D, 0xEE1A,
0xEAB2, 0xE742, 0xCF79, 0xE3A9, 0xCB33, 0xE1B8, 0xD634, 0xE568,
0xEE69, 0xFF94, 0x0783, 0x0C2B, 0x10FF, 0x016F, 0x1BF1, 0x13B2,
0x11E4, 0x1B72, 0x008E, 0x023B, 0x0147, 0x00A3, 0x03A5, 0x102B,
0x0A3A, 0x11C7, 0x0320, 0xFBA2, 0x007C, 0xEDD4, 0x15A6, 0x0F30,
0x151F, 0x112C, 0x03F5, 0xEC2D, 0xEF6E, 0xE3DE, 0xD569, 0xE5C1,
0xCCDD, 0xE0DA, 0xCFE1, 0xE0DF, 0xEBDC, 0xFF4D, 0x0C19, 0x12A1,
0x0EF6, 0x0202, 0x1A63, 0x11BB, 0x1BD6, 0x205C, 0x0B2C, 0x04A8,
0x09F0, 0xFEEC, 0x0C5B, 0x0C95, 0x0930, 0x0DFE, 0xFDCC, 0xFD5A,
0xFFDE, 0xEEBC, 0x125A, 0x0AED, 0x0DFD, 0x128A, 0x0340, 0xF548,
0xF69F, 0xE9E0, 0xD89A, 0xE40C, 0xCE94, 0xDBF3, 0xD1ED, 0xDBB8,
0xE459, 0xFA91, 0x08BF, 0x13FF, 0x134F, 0x05C4, 0x155B, 0x103B,
0x1537, 0x2537, 0x0EDC, 0x0EAE, 0x0E6C, 0x002B, 0x0CAA, 0x0AA7,
0x0CD7, 0x0B96, 0x013B, 0xFA8A, 0xFE27, 0xEEAB, 0x1444, 0x0F9B,
0x1155, 0x1AC1, 0xFD82, 0xF63D, 0xF461, 0xEAA4, 0xE2F9, 0xE8C5,
0xD660, 0xD9C5, 0xD442, 0xD428, 0xE699, 0xF286, 0x07E7, 0x13F5,
0x0FBE, 0x0A98, 0x12E6, 0x10DC, 0x0E78, 0x26A4, 0x0088, 0x10CD,
0x0A97, 0xFF83, 0x1571, 0x07A3, 0x11DA, 0x08C4, 0x03AE, 0xFB3E,
0xFDED, 0xEF6C, 0x0E88, 0x0DB0, 0x0D84, 0x1CA6, 0xFCE9, 0xFC95,
0xF0FE, 0xECFC, 0xE271, 0xE8DD, 0xE38E, 0xDBCE, 0xE3FD, 0xD424,
0xEC80, 0xEF9C, 0x0AFA, 0x1163, 0x0F9A, 0x0BAD, 0x0CCE, 0x10C1,
0x08B0, 0x2592, 0xF9E2, 0x13C2, 0x0298, 0xFF18, 0x149A, 0x0818,
0x18F4, 0x0CAF, 0x09E3, 0xF9E7, 0xFDE2, 0xE8B4, 0x0ACB, 0x0732,
0x0A97, 0x1C8A, 0xFA41, 0xFBF3, 0xEF8C, 0xEC5A, 0xE0D3, 0xEE48,
0xE1B7, 0xDFBD, 0xE8B3, 0xD4D5, 0xF048, 0xEEB1, 0x0A6F, 0x10B5,
0x1003, 0x0B96, 0x0C01, 0x0F9A, 0x09E5, 0x2493, 0xFA14, 0x1820,
0xFEAB, 0x084B, 0x112E, 0x090D, 0x1B02, 0x09BE, 0x1295, 0xFE61,
0x01E9, 0xE7FC, 0x0BE0, 0xFCBC, 0x0DE3, 0x1941, 0xF99A, 0xFF8A,
0xEF24, 0xEA98, 0xDDF3, 0xECF7, 0xD7FA, 0xE122, 0xE248, 0xD053,
0xEFA2, 0xE7B5, 0x0A53, 0x0D30, 0x1210, 0x07B9, 0x0FE4, 0x0CC4,
0x0851, 0x2A40, 0xF48F, 0x1D4E, 0xFA41, 0x06EB, 0x0ADA, 0x0B7C,
0x1610, 0x0C91, 0x189E, 0xFF34, 0x0CA9, 0xE9D2, 0x1270, 0xFC92,
0x1880, 0x1910, 0x01CA, 0x01D0, 0xEC48, 0xEF7C, 0xDA49, 0xEEC9,
0xD34E, 0xE1E2, 0xDB54, 0xD10D, 0xEAFC, 0xE26E, 0x0ACD, 0x0E20,
0x13D8, 0x106B, 0x10E1, 0x0BAA, 0x0CD6, 0x217A, 0xF0E8, 0x1C5B,
0xF149, 0x08A7, 0x09D4, 0x05FA, 0x13A2, 0x0796, 0x160F, 0xFF55,
0x1052, 0xEAD6, 0x160E, 0xFC63, 0x1A26, 0x1B08, 0x03A2, 0x0138,
0xEDBE, 0xEA87, 0xD977, 0xEEF1, 0xD2AA, 0xE33F, 0xDE22, 0xD2D1,
0xEA6B, 0xE56F, 0x062B, 0x0E3B, 0x1644, 0x1310, 0x15AA, 0x0F56,
0x11C1, 0x2411, 0xF7FC, 0x1ABE, 0xF061, 0x0421, 0x06C0, 0x0853,
0x13DA, 0x08E2, 0x14C3, 0xFF30, 0x0A83, 0xEACB, 0x0D35, 0xF723,
0x19CD, 0x19A2, 0x0770, 0x010F, 0xF1B9, 0xE692, 0xDE3B, 0xEC15,
0xCFBE, 0xE625, 0xDA8C, 0xD749, 0xE729, 0xE277, 0xFF14, 0x0AD7,
0x1244, 0x14F9, 0x1913, 0x10D4, 0x1B84, 0x2308, 0x0423, 0x1E07,
0xFAFC, 0x079F, 0x0A5A, 0x0738, 0x133E, 0x0B63, 0x11C4, 0x03FC,
0x035D, 0xEC0F, 0x066E, 0xF15B, 0x1886, 0x1894, 0x0B2F, 0x08B6,
0xF46E, 0xEAE1, 0xE352, 0xEEC8, 0xD201, 0xE54A, 0xD5A8, 0xD49F,
0xE3C4, 0xE176, 0xF8E9, 0x0818, 0x0B77, 0x1294, 0x1873, 0x0FF3,
0x1FEA, 0x2569, 0x08F1, 0x21A0, 0xFCCE, 0x08A6, 0x0B17, 0x0675,
0x10C9, 0x07A5, 0x1187, 0x0004, 0x0691, 0xEC0C, 0x0402, 0xF145,
0x1836, 0x1AD8, 0x11AE, 0x1004, 0xF989, 0xEF19, 0xE774, 0xEFB0,
0xD809, 0xE7E9, 0xDAE0, 0xD45F, 0xE387, 0xDA8B, 0xF626, 0x03D3,
0x096C, 0x1522, 0x1458, 0x11D4, 0x1D06, 0x253C, 0x07AA, 0x23F4,
0xF9DC, 0x0A22, 0x0903, 0x03FA, 0x1414, 0x0584, 0x1557, 0x0048,
0x02CC, 0xEEB3, 0xFD2F, 0xEE59, 0x1530, 0x1862, 0x1219, 0x1521,
0xFA90, 0xEF0C, 0xEC02, 0xEE4A, 0xDDC2, 0xEA4B, 0xE24F, 0xD76F,
0xEFB2, 0xDB57, 0xF861, 0x0207, 0x021E, 0x133B, 0x0F3E, 0x0FC1,
0x1B54, 0x2773, 0x0694, 0x2456, 0xF8B1, 0x0613, 0x08A5, 0x05B0,
0x1128, 0x0C6F, 0x1742, 0x02E6, 0x0440, 0xEDB2, 0xF0D4, 0xE99F,
0x0B91, 0x0F25, 0x1697, 0x1755, 0xFFCA, 0xF431, 0xED53, 0xE8DB,
0xE0EE, 0xEA87, 0xE306, 0xE005, 0xEEC7, 0xDDB0, 0xF914, 0xFD2D,
0xFAF6, 0x10BE, 0x04BB, 0x09C8, 0x1FCD, 0x2212, 0x1356, 0x2D43,
0xFD61, 0x0EEA, 0x0A78, 0x055F, 0x10D0, 0x0DEC, 0x16A7, 0x07E9,
0x0926, 0xEF64, 0xEDE3, 0xE447, 0x019D, 0x03D8, 0x196E, 0x127C,
0x0CFE, 0xFB98, 0xF236, 0xEDC3, 0xDCC7, 0xE803, 0xDBE6, 0xDF5A,
0xE5EE, 0xDD5B, 0xF549, 0xF848, 0xF8E2, 0x0C46, 0xFA00, 0x043A,
0x19AA, 0x1EBD, 0x1E09, 0x3356, 0x037A, 0x1530, 0x06B0, 0x06D0,
0x0CD1, 0x0C9C, 0x113D, 0x0771, 0x0D80, 0xEFAE, 0xF3B5, 0xE2A0,
0xFC6D, 0x004D, 0x187E, 0x0F83, 0x1A12, 0x01B3, 0x00D3, 0xF48B,
0xDBFB, 0xE7E9, 0xD4B3, 0xDEAF, 0xDDFE, 0xD7EB, 0xEC7D, 0xF0F5,
0xF8AC, 0x0D1C, 0xF369, 0x0557, 0x0A97, 0x169E, 0x2052, 0x3248,
0x151D, 0x1DF6, 0x0F87, 0x09A4, 0x092C, 0x0C43, 0x09A0, 0x052C,
0x080F, 0xECB7, 0xF20F, 0xDDCC, 0xF2C2, 0xFA4C, 0x0B2F, 0x0C80,
0x18FB, 0xFFA3, 0x1266, 0xFBF7, 0xF552, 0xEE6B, 0xDCB4, 0xE138,
0xD72D, 0xDEE7, 0xE1E9, 0xEEC9, 0xF104, 0x06C4, 0xEDC8, 0xFEDB,
0x003B, 0x0F90, 0x1C4A, 0x2FDB, 0x1CAD, 0x20A8, 0x27A5, 0x13F7,
0x1F7D, 0x151A, 0x047B, 0x094E, 0xF79D, 0xEAC8, 0xE331, 0xD38D,
0xE113, 0xEC81, 0xF7F1, 0xFFF6, 0x153A, 0xFBA2, 0x1E12, 0x00FA,
0x0644, 0xFC93, 0xF620, 0xF010, 0xE2CB, 0xE696, 0xD252, 0xEC9E,
0xDDB7, 0xFD7E, 0xE2DB, 0xF8B7, 0xF2F9, 0x00B1, 0x1989, 0x276B,
0x2B13, 0x2A57, 0x3413, 0x1C17, 0x3605, 0x22D7, 0x1BBA, 0x1751,
0xF4D7, 0xF130, 0xD04C, 0xC99A, 0xCE73, 0xD8D6, 0xE562, 0xF340,
0x01B0, 0xECBE, 0x22EB, 0x03FE, 0x1781, 0x09E7, 0x00B6, 0xF859,
0xF901, 0xF453, 0xDFB2, 0xF2E6, 0xD145, 0xF7F0, 0xCFF8, 0xEB41,
0xE281, 0xF578, 0x0715, 0x18C8, 0x25DE, 0x21FD, 0x4071, 0x270E,
0x3F10, 0x2CBD, 0x2C70, 0x24D0, 0x1048, 0x0131, 0xDC30, 0xD132,
0xC0C9, 0xD0C7, 0xD06E, 0xE861, 0xEE2A, 0xE377, 0x12E7, 0xEE89,
0x219E, 0x0C80, 0x135B, 0x07FA, 0x061A, 0xFCF5, 0xF6C0, 0x03A0,
0xE22C, 0x0018, 0xCC82, 0xEAF2, 0xCB74, 0xE830, 0xE8AF, 0x0865,
0x0BE0, 0x119A, 0x38A3, 0x160A, 0x4F96, 0x329F, 0x3C17, 0x2FE7,
0x1F9C, 0x1318, 0xF21F, 0xE547, 0xC7AA, 0xD2DC, 0xBF7B, 0xE2FA,
0xD268, 0xD8DD, 0xFA64, 0xDFB5, 0x17B0, 0xFAB4, 0x223F, 0x0940,
0x1C9E, 0x0AE7, 0x085C, 0x11B4, 0xF969, 0x17D4, 0xDD93, 0xF3D5,
0xC60A, 0xE6A1, 0xD298, 0xFF5C, 0xF2FD, 0x030C, 0x2560, 0x0770,
0x4FDE, 0x26CE, 0x4DD0, 0x3E2B, 0x2BCC, 0x226B, 0xFF7E, 0xF37D,
0xD995, 0xDF62, 0xC393, 0xDF8D, 0xC3DD, 0xD345, 0xE266, 0xD008,
0x02B8, 0xEBB1, 0x188A, 0xFAD1, 0x2593, 0x0631, 0x139E, 0x1B4D,
0xFD5D, 0x2143, 0xED08, 0x0648, 0xD850, 0xEA7C, 0xD394, 0xFB83,
0xE34B, 0x035D, 0x1070, 0x0156, 0x3FBB, 0x1C28, 0x4F1F, 0x32BA,
0x3B22, 0x2EBB, 0x07C9, 0x022F, 0xE62A, 0xEAF9, 0xD95E, 0xF02E,
0xCBBA, 0xD4EE, 0xD7E6, 0xCEF4, 0xEE8D, 0xE52B, 0x02B9, 0xEFAD,
0x177C, 0xF320, 0x170E, 0x0DB0, 0x07DA, 0x2891, 0xF1EF, 0x0C40,
0xE3A8, 0xF7B3, 0xE2EB, 0x03DE, 0xE1DA, 0x03E4, 0xFD3A, 0x00BE,
0x2A46, 0x0FE1, 0x3FBE, 0x2406, 0x3CD8, 0x2018, 0x192D, 0x057E,
0xF2A6, 0xF41D, 0xE8C0, 0xFE2D, 0xE30E, 0xEAF8, 0xE2EC, 0xD1ED,
0xE601, 0xE9B4, 0xEED6, 0xF0C5, 0x06C7, 0xE5E2, 0x0DB6, 0xF7B1,
0x0A11, 0x1EFC, 0xFAAE, 0x1AFE, 0xE623, 0xFB66, 0xEBD7, 0x0D3D,
0xECCB, 0x0E18, 0xFB80, 0x0154, 0x1F76, 0x1365, 0x2E30, 0x17A3,
0x2F4C, 0x1028, 0x1778, 0xF5A2, 0xF7D6, 0xEF18, 0xECB4, 0x0432,
0xE83D, 0xF353, 0xF15D, 0xE0EE, 0xF422, 0xEB74, 0xEFA1, 0xF7F7,
0xFB69, 0xEC75, 0xFFEA, 0xEC56, 0x010B, 0x0EF9, 0xFA28, 0x1056,
0xE792, 0x00D8, 0xEC4B, 0x0F82, 0xF6B5, 0x18E8, 0x07DB, 0x0DC9,
0x2872, 0x16F2, 0x2E9A, 0x244A, 0x1E71, 0x0AAE, 0x06A9, 0xE48C,
0xEE0D, 0xDB6B, 0xE758, 0xF91C, 0xE8AD, 0xF665, 0xF620, 0xE2CA,
0x0370, 0xFD20, 0xFFBC, 0x0656, 0x0042, 0xF640, 0xF501, 0xEDDA,
0xEC17, 0xFD20, 0xF23A, 0x01F3, 0xE9FA, 0xF1A1, 0xEF30, 0x0C1F,
0x000E, 0x1D27, 0x1501, 0x1A73, 0x385E, 0x2CB4, 0x3FED, 0x2F1A,
0x22D3, 0x1982, 0xF7DF, 0xE276, 0xDDCC, 0xC30F, 0xE0A6, 0xE349,
0xE32F, 0xEE1B, 0xF305, 0xE65A, 0x07D5, 0x017B, 0x0629, 0x1A16,
0x0B5D, 0x0877, 0x0117, 0xF5F6, 0xE2EC, 0xFD3A, 0xDDB7, 0xF12E,
0xE22B, 0xDFAB, 0xED22, 0xF9E5, 0xFDDE, 0x17D6, 0x15CA, 0x1D56,
0x3D75, 0x37F4, 0x4BEC, 0x45CE, 0x3719, 0x2555, 0x060B, 0xF10B,
0xD387, 0xC089, 0xD248, 0xD077, 0xE02B, 0xE13C, 0xEA98, 0xD762,
0x033B, 0x0051, 0x0DA3, 0x210D, 0x13CC, 0x1C5A, 0x1333, 0x08C7,
0xF6DB, 0x0116, 0xD979, 0xF573, 0xCD4B, 0xD171, 0xDE4A, 0xE3F4,
0xF159, 0x041A, 0x054A, 0x0F8D, 0x3A59, 0x361D, 0x5613, 0x500F,
0x4567, 0x401B, 0x1EAA, 0x04BC, 0xE171, 0xC94F, 0xC238, 0xC80A,
0xCCD4, 0xD19C, 0xE21A, 0xC78B, 0xF86F, 0xE91B, 0x0B12, 0x1FC1,
0x2144, 0x2616, 0x23D9, 0x1E43, 0x0DA4, 0x199A, 0xF29B, 0xFE91,
0xCE18, 0xD817, 0xC892, 0xD38D, 0xE44B, 0xEEA8, 0xF9E2, 0xFA6E,
0x26B2, 0x236D, 0x540A, 0x553E, 0x504B, 0x4E6C, 0x2C4B, 0x2211,
0xF78E, 0xDB1E, 0xCE2A, 0xC79A, 0xC080, 0xCECE, 0xCF48, 0xB5BF,
0xEED4, 0xD168, 0xFCE1, 0x09BB, 0x1692, 0x257C, 0x2BE4, 0x2974,
0x14D9, 0x2A68, 0x00A5, 0x1825, 0xE937, 0xE1A7, 0xCFC7, 0xD441,
0xD54D, 0xE437, 0xEDDF, 0xEC3D, 0x19E8, 0x105A, 0x44A3, 0x4294,
0x5341, 0x578C, 0x3A4C, 0x366E, 0x07DD, 0xF73E, 0xE97C, 0xD7A9,
0xD5BE, 0xD309, 0xC948, 0xB7B5, 0xDB85, 0xBD59, 0xED60, 0xF439,
0xFE02, 0x0FEB, 0x1B77, 0x200E, 0x1CEB, 0x3124, 0x0691, 0x25A7,
0xF714, 0xF9F3, 0xEA15, 0xDD3D, 0xDBCA, 0xE75E, 0xDACF, 0xE509,
0x01E1, 0xF92F, 0x3090, 0x2C28, 0x414C, 0x45A3, 0x3E3D, 0x3DBE,
0x1B5A, 0x09F8, 0xFB5D, 0xEF8B, 0xF433, 0xECC1, 0xE1F5, 0xC40E,
0xD614, 0xBEBE, 0xD934, 0xE5E3, 0xEB8F, 0xFD72, 0x075D, 0x0847,
0x124C, 0x26A7, 0x0F17, 0x35D4, 0xFD36, 0x0E23, 0xF6EB, 0xF03A,
0xF668, 0xEE80, 0xE18C, 0xE8F8, 0xEF1F, 0xF053, 0x1C30, 0x1204,
0x3136, 0x2F36, 0x2F2A, 0x2B36, 0x1CA7, 0x0B21, 0x04E9, 0xFBA8,
0xFBA6, 0x0217, 0xFB42, 0xDA8F, 0xEFE9, 0xC07B, 0xD76C, 0xE2E8,
0xD97B, 0xF1EA, 0xF8A5, 0xF806, 0x02E7, 0x13AC, 0x03EA, 0x2BFA,
0x053D, 0x1B67, 0xFE33, 0x0115, 0x055F, 0x058C, 0x01BF, 0xF715,
0xFAD7, 0xF0F9, 0x0E3D, 0x0ABA, 0x1C4D, 0x1BDC, 0x1AD7, 0x19D4,
0x0898, 0xF8D5, 0xFBE9, 0xF476, 0x0172, 0x08DE, 0x02A1, 0xEA3C,
0x075D, 0xD2E0, 0xF253, 0xE800, 0xD4D6, 0xF2E2, 0xE0A2, 0xEC81,
0xED45, 0xFFDB, 0xF09A, 0x1958, 0xF86A, 0x0EFB, 0x0477, 0x0671,
0x117A, 0x0F5A, 0x144A, 0x0CF8, 0x1BED, 0x04F9, 0x1DDD, 0x0F21,
0x10CA, 0x1BAE, 0x0622, 0x0F7E, 0xF61F, 0xE9BB, 0xEB48, 0xDD90,
0xF997, 0x0135, 0x0A60, 0xF8CE, 0x0FBF, 0xE2C9, 0x0603, 0xFB0D,
0xED5D, 0xFB3C, 0xE002, 0xEC09, 0xDA81, 0xF539, 0xDA83, 0x0753,
0xE6AC, 0xFAE7, 0xF881, 0xF1F4, 0x12B4, 0x10B7, 0x1B8E, 0x15A2,
0x2207, 0x13BC, 0x33E6, 0x20C6, 0x2428, 0x1EBD, 0x02D2, 0x0F4B,
0xE6E1, 0xE24A, 0xDB51, 0xCE1B, 0xEB08, 0xECB5, 0x016F, 0xF2ED,
0x175F, 0xEDD5, 0x1133, 0x06E8, 0xFDA6, 0x134B, 0xFBB9, 0xFC87,
0xE7CD, 0xF6A8, 0xD0B1, 0x0569, 0xD155, 0xF35E, 0xE423, 0xE09E,
0x0260, 0xFB1D, 0x155F, 0x141D, 0x26D0, 0x182B, 0x3BDC, 0x299E,
0x3AA1, 0x3120, 0x1B98, 0x190F, 0xE77E, 0xE8AF, 0xC62D, 0xC728,
0xD310, 0xDBA4, 0xED52, 0xDE4C, 0x0938, 0xDEC1, 0x181E, 0x0A00,
0x0AD9, 0x1A02, 0x0C2B, 0x1040, 0x094B, 0x08E3, 0xE435, 0x0AFC,
0xC616, 0xF857, 0xCC02, 0xD90F, 0xEEC9, 0xE8B9, 0x077F, 0xFDB7,
0x202F, 0x1031, 0x423A, 0x2E7C, 0x4395, 0x3CF5, 0x30F6, 0x31ED,
0x0568, 0xF97B, 0xC9C1, 0xCACE, 0xBE36, 0xD498, 0xD79C, 0xD183,
0xF856, 0xC82F, 0x0C1E, 0xF37D, 0x0CA6, 0x1A6E, 0x1433, 0x17B4,
0x142E, 0x1A0A, 0x00F5, 0x1ECB, 0xDD90, 0x014E, 0xC4D2, 0xDAD6,
0xD9BD, 0xDD41, 0xF743, 0xEECF, 0x10F3, 0xFBCD, 0x37D2, 0x227A,
0x4933, 0x3F7E, 0x3BBA, 0x3CEE, 0x1E31, 0x190E, 0xEF22, 0xE008,
0xCA5C, 0xD73F, 0xC649, 0xCFC5, 0xE15C, 0xBD91, 0xFC86, 0xE01E,
0xFBA6, 0x04D9, 0x0A2F, 0x1285, 0x1ADA, 0x1A98, 0x0D1B, 0x2A47,
0xFA97, 0x1C57, 0xE196, 0xE9E1, 0xD5FF, 0xE0BA, 0xDDA8, 0xE7A5,
0xF864, 0xED8C, 0x2593, 0x0DAF, 0x3A47, 0x2E21, 0x3E1B, 0x3C65,
0x2DE4, 0x241C, 0x083C, 0xFB81, 0xF0EF, 0xEEFA, 0xD9EB, 0xDB94,
0xD0BC, 0xBF10, 0xE1A3, 0xD48B, 0xEBE0, 0xF5F7, 0xFB11, 0xFB7F,
0x1201, 0x0DE3, 0x14F4, 0x2C56, 0x066F, 0x2D46, 0xF9E9, 0x067C,
0xF003, 0xEB70, 0xDC70, 0xE8F5, 0xDE3E, 0xE53E, 0x0D15, 0xFA62,
0x2E55, 0x164A, 0x3168, 0x26AA, 0x2F10, 0x2326, 0x15F1, 0x05B8,
0x0123, 0x07A7, 0xF7F4, 0xF6CD, 0xE444, 0xC6C8, 0xD74B, 0xCE8E,
0xD380, 0xE997, 0xEA6B, 0xF0A8, 0x05D8, 0xF962, 0x0BEC, 0x1E6C,
0x0F6E, 0x34B5, 0x087E, 0x1AA3, 0x083A, 0x09DA, 0xFBE1, 0xFAF0,
0xE4E3, 0xE875, 0xF927, 0xF177, 0x1600, 0x05D4, 0x20AC, 0x11DE,
0x1D8A, 0x0D0F, 0x0FA9, 0x00B8, 0x0C52, 0x0BDE, 0x080E, 0x0B4F,
0xFEBE, 0xDF8C, 0xEC64, 0xD538, 0xCC55, 0xE8C6, 0xCEDD, 0xE7CD,
0xF011, 0xEA41, 0xFBFA, 0x04AD, 0x0323, 0x260D, 0x1194, 0x2047,
0x1B33, 0x16C1, 0x1876, 0x1823, 0x057F, 0xFD56, 0x02A9, 0xF7AD,
0x0757, 0x043E, 0x0A3E, 0x06FF, 0x1039, 0xFD5A, 0x024B, 0xEA95,
0x06DF, 0x03F1, 0x1478, 0x14AF, 0x0B5D, 0xF792, 0x016D, 0xEDB2,
0xDFB6, 0xEDE2, 0xC491, 0xE515, 0xD36F, 0xE12D, 0xE7AF, 0xF4BD,
0xF56A, 0x0C83, 0x067D, 0x0EF2, 0x20F4, 0x178C, 0x262D, 0x229C,
0x1515, 0x18FF, 0x168B, 0x08B2, 0x0FA9, 0x03BE, 0xFB31, 0x00D6,
0xFA77, 0xF26C, 0xF7B0, 0xDBCD, 0xF9C3, 0xEF83, 0x121D, 0x147C,
0x1D1B, 0x0245, 0x1007, 0x0080, 0xF3CF, 0x0AD9, 0xDB3A, 0xEEEF,
0xD17E, 0xDF94, 0xCF16, 0xEB58, 0xE2E1, 0xFEEE, 0xF9D3, 0xFD1B,
0x106C, 0x0762, 0x29D3, 0x20F1, 0x2306, 0x1E34, 0x1FE3, 0x1C3D,
0x22D3, 0x1023, 0x0716, 0xFE06, 0xE87B, 0xEFFE, 0xDCF6, 0xD2C3,
0xEBCE, 0xDC9E, 0x0095, 0xFF77, 0x1580, 0xFF92, 0x23A9, 0x03AF,
0x068D, 0x17D6, 0xECE0, 0x09C5, 0xEB42, 0xE74C, 0xD4AB, 0xEA3B,
0xCB53, 0xFE5C, 0xE82A, 0xF8A8, 0x0901, 0xF93B, 0x2109, 0x13A9,
0x2C1A, 0x1EE4, 0x3095, 0x2232, 0x2CAB, 0x2961, 0x16B2, 0x1177,
0xF617, 0xEE92, 0xCE85, 0xD00E, 0xCEA5, 0xD388, 0xF554, 0xF398,
0x0BF0, 0xEFA1, 0x2003, 0xFB3A, 0x1A06, 0x1885, 0xF9F9, 0x16E1,
0xF0A1, 0xFFFA, 0xE4E6, 0xED68, 0xCEC0, 0xF9D0, 0xCF98, 0xF56E,
0xF4E1, 0xEEAD, 0x1B62, 0x06BC, 0x2862, 0x165C, 0x377D, 0x22D2,
0x3DFD, 0x2D85, 0x252E, 0x27F8, 0x0445, 0x06A6, 0xE0D8, 0xD4A7,
0xC837, 0xCFDF, 0xDCF6, 0xEDC3, 0x0266, 0xEA8F, 0x183D, 0xEE76,
0x1A8E, 0x114A, 0x09C4, 0x18E1, 0xFBE6, 0x0937, 0xE99C, 0xFCA3,
0xD99A, 0xFB63, 0xD421, 0xF57E, 0xDDFC, 0xECC0, 0x04F7, 0xFE22,
0x1E7D, 0x0AFE, 0x318C, 0x1574, 0x43E6, 0x2A66, 0x349C, 0x29F6,
0x12CF, 0x14AA, 0xEA69, 0xE512, 0xD6DA, 0xD123, 0xDAB8, 0xEE03,
0xED6F, 0xE8F8, 0x0DA4, 0xE711, 0x166C, 0x072B, 0x11A8, 0x14D5,
0x0CB4, 0x0B49, 0xF401, 0x01EE, 0xDA27, 0x0A1B, 0xD742, 0xFEFD,
0xDFBD, 0xEDAF, 0xF293, 0xFB95, 0x0CD0, 0x045C, 0x2851, 0x0AF8,
0x4541, 0x1FCB, 0x42E6, 0x2A07, 0x1FD9, 0x17CA, 0xEFD6, 0xEF22,
0xD465, 0xDB3B, 0xDD7D, 0xEE71, 0xE6DF, 0xEB2F, 0xFC3C, 0xDFDB,
0x0E62, 0xFACD, 0x1094, 0x0D00, 0x1925, 0x0E67, 0x0402, 0x083C,
0xDE7D, 0x09A5, 0xD3BC, 0x0AD3, 0xE062, 0xF611, 0xF4FE, 0xFC6B,
0x0367, 0x0561, 0x1CF7, 0x01FF, 0x4237, 0x141C, 0x4C4A, 0x26EA,
0x2EBC, 0x210E, 0xF787, 0xF05D, 0xD0BF, 0xD9EF, 0xD5A9, 0xF45B,
0xE737, 0xEBEE, 0xF75D, 0xDDFE, 0x0008, 0xF4DD, 0x0621, 0x05B7,
0x1C28, 0x0851, 0x12A4, 0x0CF8, 0xE555, 0x0EF8, 0xD30A, 0x08CE,
0xDAC8, 0xFDDE, 0xF01D, 0xFF2F, 0x07B9, 0x05B2, 0x1757, 0x0516,
0x348D, 0x0CCE, 0x4DE0, 0x1D02, 0x3FF9, 0x2516, 0x0389, 0xFEC9,
0xD278, 0xD75A, 0xD0E1, 0xF2D8, 0xDA9E, 0xF8E0, 0xF513, 0xE10F,
0xFFDF, 0xF2DD, 0xF5EE, 0xFFBD, 0x1314, 0xFE28, 0x2358, 0x0965,
0xF7C3, 0x1557, 0xD4C6, 0x0C5A, 0xDB32, 0xF90F, 0xE7D9, 0x03D2,
0xFDE4, 0x0926, 0x1B83, 0x022F, 0x2CA4, 0x0B21, 0x4057, 0x115E,
0x4B86, 0x1AFD, 0x1ADE, 0x06E2, 0xD654, 0xE28F, 0xCDA8, 0xEF9C,
0xD834, 0xFAA1, 0xE7F7, 0xE82F, 0x00C7, 0xF007, 0xFC01, 0x0260,
0x064F, 0xFCCC, 0x2243, 0xFF41, 0x0F34, 0x155F, 0xE23A, 0x18FD,
0xD5AF, 0xFF4F, 0xE336, 0xFE16, 0xF247, 0x0BBD, 0x0F9C, 0xFF3A,
0x30FC, 0x0273, 0x3B12, 0x107B, 0x3E52, 0x1313, 0x25E4, 0x03B8,
0xE8C6, 0xE99E, 0xCC21, 0xF442, 0xD1A1, 0xFA9E, 0xE392, 0xE85E,
0xF73D, 0xEFD8, 0xFDAE, 0xFD4C, 0x0D3A, 0xFE03, 0x1A0A, 0xFC95,
0x0E1C, 0x0C58, 0xF393, 0x1EC0, 0xDF5B, 0x0BE9, 0xDF91, 0x0119,
0xEEA0, 0x06E1, 0x04FF, 0xFFBB, 0x259D, 0x02E6, 0x3DE8, 0x0EDF,
0x39B1, 0x1294, 0x1A46, 0xFB1C, 0xEE54, 0xE5A9, 0xD7E7, 0xF965,
0xD103, 0x0032, 0xDDA4, 0xE5E3, 0xF44A, 0xE869, 0xF5F8, 0xFC68,
0x0AFD, 0xFDE3, 0x1DDA, 0xFE26, 0x06F8, 0x0819, 0xF0E6, 0x175C,
0xE9D0, 0x0EF6, 0xE6F1, 0x093D, 0xEEAB, 0x0EB1, 0x0353, 0xFD6C,
0x1E4E, 0xFE78, 0x38AC, 0x0FAF, 0x4434, 0x15CF, 0x211B, 0x025A,
0xE9FB, 0xE217, 0xDB8F, 0xF3A0, 0xDB72, 0x091A, 0xE0F8, 0xEFDA,
0xF3F2, 0xE49E, 0xF32B, 0xF21F, 0xFF0D, 0xFA8A, 0x1B57, 0xF9FD,
0x0E66, 0x03AE, 0xEC12, 0x1472, 0xE23C, 0x0A55, 0xE931, 0x0C77,
0xF202, 0x171C, 0x02C0, 0x01ED, 0x1FE6, 0xF8A4, 0x3472, 0x0B17,
0x3D06, 0x17A5, 0x2D3D, 0x05F7, 0xF632, 0xE95B, 0xD655, 0xEF5C,
0xDB95, 0x08CD, 0xE895, 0xFD4B, 0xF8E7, 0xEB5E, 0xFB94, 0xF07F,
0x032E, 0xF3F8, 0x10D1, 0xF63C, 0x0CD6, 0x0262, 0xF7B8, 0x1ADF,
0xDB46, 0x0E5D, 0xDA95, 0x02D4, 0xF2EE, 0x189F, 0x03FF, 0x08C3,
0x201B, 0xF714, 0x3BDC, 0x03EB, 0x385B, 0x0F74, 0x237D, 0x054E,
0x028E, 0xEDAB, 0xDCA2, 0xF3E3, 0xCC57, 0x052A, 0xE21B, 0xFB73,
0xFC90, 0xF11A, 0xFFDC, 0xF24F, 0x0CD1, 0xF72D, 0x1519, 0xF6A1,
0x012A, 0xFD7C, 0xF8DE, 0x1B4E, 0xEBAF, 0x191F, 0xD65B, 0x0AA2,
0xE7E1, 0x15EA, 0x039D, 0x0B68, 0x210C, 0xF99C, 0x4289, 0x039A,
0x3F87, 0x0E4B, 0x1CE1, 0x00C7, 0xFC08, 0xEA1C, 0xE58B, 0xEE71,
0xCFD2, 0x0707, 0xD544, 0xFB02, 0xF1AD, 0xEA41, 0xFF08, 0xF42D,
0x10F5, 0xF99A, 0x1BEA, 0xF6B5, 0x0224, 0xF808, 0xF0BD, 0x14F3,
0xEF4F, 0x1A51, 0xE328, 0x0EAC, 0xE6E5, 0x1C41, 0xFA63, 0x0C59,
0x1D27, 0xF819, 0x46E0, 0x06E8, 0x46B3, 0x10BF, 0x22C3, 0x01E5,
0xFDDB, 0xE8E3, 0xE3A6, 0xE97E, 0xD4D6, 0x0789, 0xD6ED, 0x075E,
0xE5C9, 0xEF07, 0xF516, 0xEC29, 0x0E18, 0xF6CC, 0x1DF2, 0xF9D1,
0x08E1, 0xF97A, 0xF398, 0x0C51, 0xEB98, 0x1313, 0xE5BE, 0x0BEC,
0xEE0F, 0x1AFA, 0xF40F, 0x15DF, 0x0EDA, 0xF77A, 0x3F2D, 0xFC83,
0x44BE, 0x0D7D, 0x2770, 0x075B, 0x0576, 0xEEAF, 0xE2DC, 0xE2AC,
0xD511, 0x038B, 0xDE80, 0x0AFC, 0xE62B, 0xF6C9, 0xF087, 0xF5B4,
0x0918, 0xF51E, 0x1725, 0xF46D, 0x0BF8, 0xFC6D, 0xFDAC, 0x125F,
0xEE71, 0x1310, 0xE3AF, 0x0857, 0xF098, 0x159B, 0xF5C3, 0x14A9,
0x08B2, 0x0010, 0x377F, 0xFA6F, 0x3858, 0x00B1, 0x1F8B, 0x07BF,
0x0DB6, 0xF77F, 0xE847, 0xE049, 0xD42F, 0xFA9A, 0xE12C, 0x0865,
0xEA17, 0xF37C, 0xF275, 0xF98F, 0x06CC, 0xFD92, 0x0E5C, 0xEE52,
0x04AA, 0xF6B1, 0x04C1, 0x163C, 0xFB72, 0x1B7F, 0xEAF1, 0x09FD,
0xF459, 0x0DCD, 0xF8AF, 0x11B4, 0x0768, 0x0596, 0x3224, 0x062E,
0x308A, 0x0120, 0x1319, 0xFFA3, 0x09F3, 0xFAEA, 0xF128, 0xE552,
0xDDEC, 0xF99F, 0xE66A, 0x041B, 0xE8EE, 0xEC6F, 0xF3AD, 0xF5C2,
0x064E, 0x03FD, 0x05E8, 0xF6B1, 0xFABA, 0xEF68, 0xF90C, 0x0B72,
0xFBF1, 0x1EB9, 0xF8CF, 0x0D77, 0xFCF2, 0x0B2C, 0xF91B, 0x100D,
0x04E2, 0x04B1, 0x3008, 0x0759, 0x2B6B, 0x0A00, 0x0FB0, 0x0551,
0x06DE, 0xF625, 0xEEF4, 0xE544, 0xEA9D, 0xFEAE, 0xF628, 0x073E,
0xEF7E, 0xEB00, 0xF4C5, 0xF230, 0x016F, 0xFFEE, 0xFCC5, 0xF84E,
0xF629, 0xF5BE, 0xF35F, 0x00D9, 0xF077, 0x1726, 0xFBD9, 0x1661,
0x0AFC, 0x0B9D, 0x0116, 0x0BD6, 0x03B9, 0x045E, 0x2695, 0x02ED,
0x2386, 0x067B, 0x0D97, 0x0E69, 0x0600, 0xFB36, 0xEA38, 0xDB8E,
0xED54, 0xFECE, 0x0695, 0x1264, 0xFDBD, 0xED58, 0xFD52, 0xEFE7,
0xFEE8, 0xFC2B, 0xF000, 0xF35E, 0xEF3E, 0xF997, 0xEFDB, 0x0755,
0xE9CB, 0x1344, 0xF6CA, 0x10A0, 0x11C6, 0x0DE5, 0x11AD, 0x1011,
0x0EF0, 0x067E, 0x243A, 0xFDCB, 0x1694, 0xFDEB, 0x052C, 0x0E25,
0x0696, 0x0522, 0xE8CD, 0xDFD5, 0xE90D, 0xF45F, 0x0B00, 0x1299,
0x0E20, 0xF7B0, 0x0CF3, 0xF27E, 0x0184, 0xFB2E, 0xE4CB, 0xF29C,
0xE271, 0xF6E1, 0xE979, 0x05AA, 0xE9BD, 0x1C66, 0xF862, 0x1279,
0x11D3, 0x0439, 0x1EFA, 0x14FF, 0x2284, 0x1010, 0x2802, 0xFB95,
0x12A6, 0xF9B3, 0xFDB5, 0x0BB1, 0xFB23, 0x027F, 0xE6F8, 0xE1AD,
0xEC6B, 0xF32D, 0x07E4, 0x07A5, 0x12AB, 0xF5DC, 0x1E81, 0xFE0B,
0x08F6, 0x00A3, 0xE030, 0xF062, 0xDC41, 0xF20D, 0xDC2D, 0xFEF8,
0xE193, 0x1D39, 0xFDE2, 0x1B90, 0x1274, 0x0107, 0x1FD5, 0x0BFF,
0x3217, 0x1A0A, 0x32A1, 0x05B7, 0x10CC, 0xF99A, 0xFCA6, 0x0AA4,
0xF397, 0xFE86, 0xDBB6, 0xDE20, 0xEC2F, 0xF2C6, 0x09C0, 0x0C60,
0x1149, 0xF341, 0x25A7, 0xF7E9, 0x140E, 0x089F, 0xE172, 0xF645,
0xDAB1, 0xEDBA, 0xD810, 0xF650, 0xD497, 0x13E4, 0xF8D0, 0x1931,
0x18A2, 0x0538, 0x24C1, 0x0F7F, 0x344B, 0x152B, 0x3650, 0x0539,
0x17BC, 0x028E, 0xFD58, 0x0BA7, 0xEED3, 0xFD2D, 0xD5D2, 0xDFA4,
0xE300, 0xEEB7, 0x09C4, 0x0C85, 0x1A75, 0xFDB4, 0x2A90, 0xF810,
0x17A0, 0x043F, 0xE962, 0x0068, 0xDE74, 0xF0E1, 0xD512, 0xF14A,
0xD255, 0x12E1, 0xF0A4, 0x13F7, 0x0F85, 0xFFF0, 0x29ED, 0x13B8,
0x392B, 0x17F3, 0x2F42, 0xF894, 0x16E8, 0xFEAA, 0x0219, 0x1316,
0xEA2C, 0xFCFA, 0xD3E9, 0xE194, 0xDEB7, 0xE9E8, 0xFCDA, 0x0366,
0x1D7A, 0x047D, 0x3558, 0x0258, 0x15C9, 0x026F, 0xE78D, 0xFCF1,
0xE63F, 0xF68B, 0xD9B4, 0xF5A1, 0xD2F8, 0x14BA, 0xF304, 0x1545,
0x098E, 0xFAC5, 0x254A, 0x132C, 0x3E22, 0x21F0, 0x2EE2, 0x00CE,
0x127A, 0xFAB2, 0x0298, 0x0D95, 0xEC76, 0x00B8, 0xD715, 0xE4FF,
0xE302, 0xE71A, 0xF8C9, 0xFBC0, 0x1431, 0xFDD1, 0x348D, 0x008B,
0x19A1, 0x08A6, 0xE4BA, 0xFF48, 0xDEB1, 0xEB0B, 0xD87A, 0xF078,
0xD5FA, 0x1455, 0xF60C, 0x138C, 0x0C01, 0xFC94, 0x1E9F, 0x121E,
0x34B9, 0x2141, 0x3007, 0x0877, 0x174D, 0x04A1, 0xFE9A, 0x0759,
0xEB8B, 0xF92C, 0xE25F, 0xEC75, 0xE982, 0xE967, 0xFDAC, 0xFB3F,
0x19CD, 0x0193, 0x2B0A, 0xFE5F, 0x114C, 0x0672, 0xE953, 0x0412,
0xDAF7, 0xE80D, 0xCFE6, 0xE0D1, 0xD75C, 0x0ACE, 0xF597, 0x12C9,
0x0CA7, 0xFF4C, 0x266F, 0x1684, 0x2CB2, 0x1F8F, 0x1D75, 0x0680,
0x1655, 0x098B, 0xFFF2, 0x09D3, 0xE0BB, 0xF000, 0xE31F, 0xE3AA,
0xF22C, 0xEA53, 0x008B, 0xFF97, 0x2428, 0x0AC5, 0x2FA7, 0x03B9,
0x033A, 0x03BF, 0xE0AD, 0x0238, 0xDCA7, 0xEA3A, 0xCB67, 0xE2E3,
0xD336, 0x005B, 0xFA91, 0x091E, 0x112F, 0x030E, 0x2ECA, 0x1DF4,
0x383B, 0x2785, 0x1709, 0x08C5, 0x063D, 0x04E1, 0xFB54, 0x050B,
0xE196, 0xF02B, 0xE0CE, 0xE10A, 0xF271, 0xDDBD, 0x04F7, 0xF981,
0x2937, 0x1037, 0x38ED, 0x0B8E, 0x05B8, 0x0A94, 0xCE66, 0x01B7,
0xC99C, 0xE59E, 0xCBED, 0xE4EA, 0xD60F, 0x0119, 0xF75A, 0xFE4F,
0x18DE, 0xFE35, 0x39A7, 0x25E6, 0x3FFA, 0x2FCA, 0x22BB, 0x1519,
0x0585, 0x0E25, 0xE946, 0x01BC, 0xD85D, 0xEB43, 0xE729, 0xE0F2,
0xF565, 0xD86C, 0x0865, 0xEABA, 0x3117, 0x0CB9, 0x3B52, 0x15BB,
0x0D58, 0x143F, 0xD375, 0x0793, 0xB599, 0xE34B, 0xB81D, 0xDDC9,
0xDA1B, 0xFC95, 0xFC31, 0xFE08, 0x19F1, 0xF840, 0x4372, 0x1D03,
0x4804, 0x34D3, 0x2B8C, 0x247D, 0x11DE, 0x1BAB, 0xE08A, 0x0588,
0xBE9F, 0xE672, 0xDFA9, 0xDADC, 0xFB5D, 0xD916, 0x076F, 0xEB26,
0x359B, 0x02F1, 0x442E, 0x14C0, 0x11B4, 0x1F9D, 0xDDE4, 0x0F2C,
0xB9BD, 0xE86D, 0xA5FD, 0xDE18, 0xC70A, 0xEFED, 0xFC6D, 0xF471,
0x21C5, 0xFF74, 0x4925, 0x1B96, 0x4FAF, 0x29DD, 0x30C4, 0x2A7F,
0x1859, 0x2690, 0xE97B, 0x09DE, 0xB452, 0xE925, 0xC5A2, 0xD78A,
0xF275, 0xD25E, 0x0EF6, 0xEC6D, 0x396B, 0x060C, 0x4B31, 0x0E42,
0x1BDD, 0x1F5E, 0xE158, 0x1692, 0xC000, 0xED92, 0xAB95, 0xE54F,
0xB8E7, 0xEE8A, 0xE9A7, 0xEA98, 0x266F, 0xFEF0, 0x5401, 0x2304,
0x536C, 0x251D, 0x3B1C, 0x2068, 0x1C1D, 0x2A58, 0xE3FD, 0x0EDD,
0xB653, 0xEAC5, 0xBEF3, 0xD991, 0xDBBC, 0xCE04, 0x0616, 0xE401,
0x44B3, 0x0610, 0x53C3, 0x1489, 0x22D8, 0x1B30, 0xE9EA, 0x10F7,
0xBF56, 0xF31F, 0xAED6, 0xECFE, 0xBD9B, 0xF099, 0xD883, 0xE7DF,
0x145B, 0xF9E3, 0x59CB, 0x1F93, 0x5DE3, 0x2C30, 0x3FA4, 0x25D7,
0x24D0, 0x24FD, 0xE63F, 0x0FC7, 0xB13D, 0xEE26, 0xC222, 0xDA61,
0xD961, 0xD0ED, 0xF409, 0xDE0E, 0x3962, 0xFA48, 0x5B60, 0x151D,
0x2D72, 0x2303, 0xF002, 0x0C5B, 0xC377, 0xEEB8, 0xACD3, 0xF2E0,
0xBDD3, 0xEF4C, 0xDBE8, 0xE6D2, 0x09BC, 0xFF58, 0x46E3, 0x1C34,
0x5CE8, 0x2851, 0x4F44, 0x31C5, 0x2D92, 0x2DDD, 0xE88B, 0x0A07,
0xB316, 0xEB5B, 0xC04B, 0xDB2E, 0xD9FE, 0xD2CB, 0xF22A, 0xE026,
0x2A91, 0xF615, 0x5152, 0x1045, 0x383A, 0x268B, 0xFCFC, 0x1324,
0xC635, 0xEB01, 0xADC9, 0xEB57, 0xBAE0, 0xE9C8, 0xD60F, 0xE213,
0x09BC, 0x02D6, 0x418F, 0x1F08, 0x4F1D, 0x2429, 0x520F, 0x3129,
0x40F5, 0x38D7, 0xF27E, 0x136A, 0xB238, 0xE3BC, 0xBE71, 0xD4D5,
0xD6FE, 0xD686, 0xF2A3, 0xE137, 0x2994, 0xF643, 0x435C, 0x103C,
0x2F64, 0x209D, 0x0757, 0x1167, 0xD0C5, 0xF68C, 0xAF50, 0xF190,
0xB98E, 0xE222, 0xD337, 0xDE51, 0x08CC, 0x0627, 0x4482, 0x21BB,
0x4C44, 0x248E, 0x47D2, 0x2BEE, 0x3FBC, 0x3311, 0xFC10, 0x19E1,
0xB7E0, 0xEA66, 0xBE79, 0xD041, 0xD67C, 0xD596, 0xF016, 0xE14E,
0x29D9, 0xF352, 0x44E4, 0x1288, 0x24C7, 0x1EE3, 0xFC83, 0x0848,
0xD582, 0xF840, 0xB91C, 0xFFDA, 0xBC48, 0xE43E, 0xD313, 0xD66B,
0x0BB8, 0x077D, 0x45EE, 0x253D, 0x5028, 0x2591, 0x4904, 0x2DC6,
0x35CA, 0x30F0, 0xF949, 0x16AA, 0xBF73, 0xEE78, 0xC122, 0xD5EA,
0xD60F, 0xD253, 0xF0EE, 0xD845, 0x24D8, 0xEE08, 0x3EF0, 0x1273,
0x25B8, 0x1DB6, 0xF652, 0x0381, 0xCBA5, 0xF403, 0xBCD0, 0x00E1,
0xC344, 0xE9E0, 0xD4A9, 0xDA00, 0x0DFA, 0x055B, 0x445D, 0x2174,
0x4D2D, 0x2695, 0x5067, 0x31C4, 0x383F, 0x339A, 0xED92, 0x1573,
0xBA1A, 0xE6CD, 0xC6AC, 0xD60B, 0xDA3B, 0xDE17, 0xF254, 0xD943,
0x275A, 0xE7AF, 0x3E15, 0x161E, 0x261A, 0x20B8, 0xFDBA, 0xFFD0,
0xCC06, 0xF4A7, 0xB5C0, 0xFED5, 0xC20D, 0xE088, 0xD90C, 0xDBF3,
0x11DD, 0x0E84, 0x4798, 0x2043, 0x5082, 0x247E, 0x50EA, 0x356F,
0x39F6, 0x343F, 0xEE06, 0x1305, 0xAE22, 0xE478, 0xB742, 0xD1CD,
0xD73D, 0xDDC9, 0xF77D, 0xE066, 0x2B88, 0xEB75, 0x42E6, 0x150A,
0x2ACA, 0x21FC, 0x00FB, 0x0293, 0xD2F4, 0xF817, 0xB750, 0x0293,
0xB64B, 0xDDA5, 0xD44C, 0xD790, 0x1A02, 0x15E9, 0x4C5D, 0x298D,
0x569E, 0x2248, 0x5966, 0x2EC4, 0x3783, 0x33EC, 0xEA80, 0x11DB,
0xAEB2, 0xDE39, 0xAB2E, 0xD13B, 0xC77C, 0xDA7F, 0xF863, 0xD96A,
0x340C, 0xEF6B, 0x47BD, 0x198E, 0x3046, 0x1AE3, 0x030E, 0xFE00,
0xD213, 0xFE5C, 0xBCD4, 0x054C, 0xB40A, 0xDCF5, 0xC517, 0xD7E5,
0x1330, 0x1156, 0x50AF, 0x2A91, 0x5DC3, 0x2CAA, 0x606B, 0x310D,
0x3963, 0x304A, 0xEA30, 0x14E8, 0xB285, 0xE008, 0xAE3C, 0xD23E,
0xBE37, 0xDB24, 0xEADC, 0xD075, 0x325F, 0xEA4A, 0x4C1F, 0x2082,
0x3610, 0x1CD3, 0x09CE, 0xF8E5, 0xD68A, 0x010C, 0xBEA0, 0x09AA,
0xB3D4, 0xD8FD, 0xC1D2, 0xD526, 0x04EF, 0x0ED4, 0x41D0, 0x22F7,
0x5F17, 0x2F35, 0x6975, 0x3CDD, 0x3EA3, 0x31A3, 0xEED5, 0x0F02,
0xB614, 0xE0C1, 0xADC1, 0xD678, 0xBDCD, 0xD93C, 0xE142, 0xCB66,
0x21F4, 0xE5AA, 0x4905, 0x1FD9, 0x3F0C, 0x23F6, 0x1338, 0xFFE3,
0xE063, 0xFFDB, 0xC792, 0x0492, 0xB3A5, 0xDA08, 0xC0A9, 0xD616,
0x004A, 0x0B85, 0x2F6F, 0x1F35, 0x54FB, 0x2BB6, 0x6DE0, 0x41F3,
0x41E5, 0x3A6D, 0xF404, 0x0D01, 0xBC21, 0xDA4D, 0xAAA4, 0xD95E,
0xB8E3, 0xDAA7, 0xDFB0, 0xC5A7, 0x1687, 0xE3AB, 0x37D1, 0x1B99,
0x394D, 0x1C8B, 0x17B8, 0x04EE, 0xE8D8, 0x0985, 0xCD38, 0xFEC9,
0xB4AB, 0xD715, 0xC3CB, 0xDDC5, 0x029F, 0x0A1E, 0x2DA7, 0x1BA2,
0x5064, 0x2C05, 0x66E7, 0x400B, 0x3D35, 0x39E0, 0xF7FF, 0x104A,
0xC401, 0xDA02, 0xADD6, 0xD577, 0xBA9D, 0xDC0F, 0xDF6F, 0xC5A4,
0x129A, 0xDCE3, 0x331F, 0x1694, 0x30BA, 0x171E, 0x0E50, 0x02AD,
0xEA89, 0x1343, 0xD4D8, 0x053D, 0xB82A, 0xD43D, 0xCA67, 0xDE77,
0x05CC, 0x0D2D, 0x2A13, 0x1669, 0x51A6, 0x26BF, 0x620F, 0x435C,
0x2DDD, 0x35A2, 0xF2E1, 0x0C1F, 0xCD0F, 0xE6AF, 0xB2EA, 0xDA65,
0xBD1D, 0xD0EC, 0xE5F2, 0xC485, 0x0F01, 0xDDDF, 0x2C2F, 0x0A5E,
0x31DE, 0x1217, 0x0B51, 0x085D, 0xE65B, 0x12C5, 0xD93F, 0x0628,
0xC269, 0xDFE7, 0xD38E, 0xDF77, 0x0834, 0x0618, 0x2968, 0x19DA,
0x4FBB, 0x256D, 0x60AC, 0x42A6, 0x2AE9, 0x39FB, 0xE958, 0x0703,
0xC906, 0xE89E, 0xB83E, 0xE431, 0xC0CC, 0xCCE9, 0xE497, 0xBD24,
0x0C04, 0xE1DD, 0x27AE, 0x0827, 0x2FA5, 0x0A7C, 0x144F, 0x1214,
0xEB7A, 0x17D6, 0xD1BF, 0xFBB0, 0xC43D, 0xE700, 0xDC86, 0xE9CD,
0x0603, 0xFC1F, 0x2786, 0x1534, 0x52FF, 0x2A62, 0x5BC8, 0x41F1,
0x292B, 0x357E, 0xEE1D, 0x0509, 0xC330, 0xE9CA, 0xAEE2, 0xE410,
0xC435, 0xCFFB, 0xE935, 0xC0A5, 0x06EA, 0xDF61, 0x2727, 0x03A1,
0x31C8, 0x0942, 0x19EF, 0x1986, 0xF701, 0x1BD6, 0xCF43, 0xF604,
0xBE4B, 0xE98C, 0xE2F6, 0xF39A, 0x0DC8, 0xFDD2, 0x2933, 0x10DD,
0x5218, 0x26C5, 0x5AD0, 0x3FD6, 0x25D2, 0x2EAF, 0xEE86, 0x00BE,
0xC49C, 0xEE3D, 0xA570, 0xDE21, 0xBDBD, 0xCAC5, 0xEF40, 0xCA6C,
0x0873, 0xDFBB, 0x21C6, 0xF4D9, 0x316E, 0x0818, 0x2019, 0x2674,
0xF929, 0x1BD0, 0xCE8B, 0xF52D, 0xC163, 0xF2C9, 0xDF57, 0xF6DD,
0x0BE8, 0xFB8F, 0x30BA, 0x124D, 0x4E49, 0x26A9, 0x4F09, 0x3AF2,
0x2506, 0x2ECF, 0xF181, 0x0629, 0xC6D1, 0xF41B, 0xAB36, 0xDDC1,
0xBC36, 0xC513, 0xEA03, 0xCACD, 0x0A38, 0xDEAD, 0x1DC9, 0xE899,
0x290F, 0x0194, 0x2762, 0x2F14, 0x0280, 0x203F, 0xCBDE, 0xF36A,
0xC706, 0xF7DB, 0xE3D8, 0xF895, 0x03BF, 0xF152, 0x2F07, 0x0F2E,
0x4B67, 0x2D18, 0x43A9, 0x32B4, 0x2588, 0x2992, 0xFD5E, 0x1576,
0xCA4F, 0xFB29, 0xADFB, 0xDA5E, 0xBF84, 0xC78B, 0xE0E5, 0xCCE9,
0x02D5, 0xD790, 0x1B64, 0xE2FF, 0x2703, 0x05CF, 0x2DDB, 0x3152,
0x0F8D, 0x231C, 0xD6B6, 0xFA14, 0xCB7F, 0xFB1A, 0xE3E5, 0xFB6D,
0x004E, 0xEEAD, 0x28FB, 0x08B1, 0x43BB, 0x2F9A, 0x3CFE, 0x2D66,
0x27AD, 0x1FE6, 0x089D, 0x1FBA, 0xD561, 0x00D5, 0xB326, 0xD36F,
0xBB55, 0xCB86, 0xD7AC, 0xD3E7, 0xFB79, 0xCE63, 0x1213, 0xD96C,
0x2250, 0x0A46, 0x319E, 0x2E68, 0x17D5, 0x2223, 0xE522, 0x06D5,
0xD51C, 0x014F, 0xE34C, 0xFE78, 0xFE19, 0xF3DF, 0x2780, 0x08EE,
0x3C0F, 0x2D13, 0x31FA, 0x24FF, 0x2802, 0x185F, 0x1153, 0x27B7,
0xE0EA, 0x0745, 0xC23B, 0xD06F, 0xBD57, 0xD07B, 0xCA3C, 0xD9F1,
0xF2E2, 0xC4B2, 0x0BA9, 0xCDD6, 0x1634, 0x0861, 0x292D, 0x248E,
0x1ABF, 0x1F08, 0xF502, 0x18F1, 0xE5D9, 0x0A08, 0xEB55, 0xFDE8,
0xFAE8, 0xF8F5, 0x1985, 0x0A76, 0x2F92, 0x2571, 0x224C, 0x17DD,
0x18EE, 0x10C9, 0x14A5, 0x2AA0, 0xF246, 0x1215, 0xD8B1, 0xD969,
0xCC16, 0xD49D, 0xC9EB, 0xDD8D, 0xE476, 0xBFE9, 0xFD2D, 0xC8A4,
0x0DA1, 0x0545, 0x1784, 0x175D, 0x153D, 0x1702, 0x098B, 0x2828,
0xFF0F, 0x1B63, 0x014E, 0xFD7D, 0x04D6, 0xFC1A, 0x08A5, 0x105F,
0x1550, 0x1A43, 0x15B9, 0x0ABF, 0x08F0, 0x0CF8, 0x06CD, 0x21F1,
0xFE01, 0x0C5E, 0xEF26, 0xE94C, 0xDF9E, 0xE227, 0xD596, 0xDA10,
0xDC88, 0xBFE1, 0xE7A9, 0xCB5D, 0x0183, 0xFFE6, 0x0EB3, 0x0C80,
0x0B7A, 0x0C95, 0x1302, 0x2633, 0x149E, 0x27C0, 0x1993, 0x0B01,
0x163E, 0x0046, 0x04D2, 0x15B4, 0xFFD1, 0x14EA, 0xFF9D, 0xFB41,
0xFB27, 0x07AF, 0xF691, 0x14AA, 0xFE45, 0xFA0B, 0x0109, 0xF0FF,
0xEFAD, 0xFA29, 0xEB13, 0xE24F, 0xE903, 0xC49A, 0xE1B7, 0xD905,
0xEFFF, 0xF81B, 0xFC8D, 0xFED5, 0xFE98, 0x0A92, 0x0D22, 0x1BDF,
0x1E11, 0x2253, 0x2E1B, 0x1C19, 0x2F6A, 0x18FC, 0x1229, 0x1D7B,
0xFD0F, 0x0F8E, 0xF212, 0xF343, 0xE4CC, 0xFAE2, 0xE3DB, 0x05DB,
0xF2C3, 0xE9D1, 0x0530, 0xEBBE, 0x02AE, 0x085E, 0x0269, 0xF5EF,
0x00E7, 0xD3E4, 0xF0BA, 0xE2FB, 0xE8F8, 0xF3E0, 0xE243, 0xEEB2,
0xE83B, 0x0576, 0xFE8A, 0x1760, 0x1D58, 0x1548, 0x3DC2, 0x2118,
0x3E69, 0x3231, 0x232D, 0x311E, 0x0A50, 0x0EEF, 0xF019, 0xF2E1,
0xCEEE, 0xF55A, 0xC8C7, 0xEF7D, 0xE4FD, 0xDE7F, 0xFF20, 0xE6D5,
0x11F3, 0x0352, 0x1C9E, 0x003B, 0x15B1, 0xF1DF, 0x0913, 0xF767,
0xF301, 0xEBB7, 0xD6A3, 0xE6AB, 0xD217, 0xFF4F, 0xE966, 0x0D30,
0x1339, 0x09EC, 0x457C, 0x17D5, 0x4E78, 0x3926, 0x2B4D, 0x41E8,
0x158E, 0x1E6E, 0xFC6D, 0xFA66, 0xCBA6, 0xF21D, 0xB5C9, 0xE046,
0xCC7E, 0xD00F, 0xEB2F, 0xE37B, 0x0C8D, 0xF7D0, 0x2963, 0xF89C,
0x2387, 0x0676, 0x166A, 0x14AE, 0x055E, 0xF3AB, 0xE1B9, 0xE1E5,
0xCD15, 0xFC0D, 0xD527, 0xFCDA, 0x00DA, 0xFC20, 0x3C8D, 0x14A8,
0x5275, 0x334F, 0x396A, 0x449A, 0x1E48, 0x30DE, 0x0C2C, 0x12A6,
0xDEA2, 0xF1A0, 0xBA13, 0xCF8D, 0xBEEF, 0xC715, 0xCF80, 0xD9C4,
0xF7E8, 0xEBFF, 0x25A9, 0xEDB8, 0x309D, 0x0F61, 0x22DA, 0x280C,
0x0B14, 0x0240, 0xF3C8, 0xEEBC, 0xDA37, 0xF79A, 0xCA6F, 0xEE7D,
0xE80A, 0xEF56, 0x2320, 0x134E, 0x44AC, 0x32A3, 0x422E, 0x3A85,
0x2F54, 0x3A90, 0x149C, 0x2C02, 0xEF77, 0xFE5C, 0xCE56, 0xC740,
0xC234, 0xBF0E, 0xC1B1, 0xD4BA, 0xE0BF, 0xDDD1, 0x1344, 0xE8E9,
0x31A3, 0x0F1F, 0x3449, 0x251C, 0x120B, 0x082E, 0xF7BC, 0x00E8,
0xEC1D, 0x010D, 0xD616, 0xE248, 0xE3D5, 0xE80F, 0x0D65, 0x130E,
0x2A77, 0x2F1C, 0x3555, 0x2D6C, 0x31F2, 0x325E, 0x1CF2, 0x3720,
0xF0BF, 0x04EE, 0xD985, 0xD074, 0xD43C, 0xC72B, 0xC7B8, 0xCEDA,
0xD972, 0xD530, 0xFFC1, 0xE71B, 0x2173, 0x124D, 0x2F87, 0x1638,
0x19BE, 0x023C, 0xFD71, 0x0F8D, 0xECE5, 0x08D3, 0xE6CE, 0xE887,
0xF6CF, 0xE881, 0x0C8D, 0x1147, 0x1476, 0x29CE, 0x1B4E, 0x2131,
0x20B5, 0x2943, 0x192D, 0x305D, 0xF89F, 0x036F, 0xDC8D, 0xD4A3,
0xDEB7, 0xD838, 0xDDEE, 0xD6BD, 0xE59B, 0xC8F7, 0xF928, 0xEA1B,
0x0BB5, 0x1858, 0x19FD, 0x0B8F, 0x12D1, 0xF9F2, 0x0956, 0x167A,
0xF611, 0x0CD9, 0xEF31, 0xEA68, 0x0C95, 0xF8B5, 0x1920, 0x1548,
0x1581, 0x20BF, 0x0D4D, 0x1BD0, 0x0588, 0x23BD, 0x0578, 0x2381,
0xF535, 0xF38B, 0xE5AF, 0xD34F, 0xE172, 0xDC26, 0xE66C, 0xDFA2,
0xF8F7, 0xD0FC, 0x0725, 0xED61, 0x0B3B, 0x1EFF, 0x048E, 0x06A2,
0x00EB, 0xF43B, 0x05B8, 0x117F, 0xF8B2, 0x066C, 0xF0D9, 0xE938,
0x0FB8, 0x00CA, 0x2614, 0x2953, 0x20B1, 0x224E, 0x14B6, 0x1951,
0xFD8C, 0x29C1, 0xEEDB, 0x1602, 0xE770, 0xDE09, 0xE357, 0xCA31,
0xE420, 0xDC3E, 0xE615, 0xDAED, 0x014F, 0xDD1A, 0x1DDB, 0x0682,
0x1F35, 0x2104, 0x06C5, 0x0373, 0xF04E, 0xF39B, 0xF1E5, 0x06FA,
0xECA9, 0xF66C, 0xF3F3, 0xE3FC, 0x0F7A, 0x05C3, 0x2198, 0x3260,
0x2F93, 0x326E, 0x2577, 0x1DD9, 0x052E, 0x2A7B, 0xE69B, 0x148B,
0xCF87, 0xCDD6, 0xCF35, 0xBBD5, 0xDC83, 0xD7CC, 0xEB2A, 0xDA45,
0x0619, 0xDE2B, 0x2C96, 0x1DB4, 0x3887, 0x3494, 0x182B, 0xFD32,
0xF624, 0xF60D, 0xE039, 0x0158, 0xD50B, 0xE31C, 0xEC23, 0xDBCD,
0x0EC6, 0x064E, 0x1E03, 0x3073, 0x2F9A, 0x32BD, 0x3726, 0x3189,
0x191A, 0x33F4, 0xEF2C, 0x0B1C, 0xC8BB, 0xCA86, 0xBB64, 0xB54F,
0xCE06, 0xCB11, 0xE55A, 0xD07F, 0x060C, 0xE037, 0x2ED1, 0x251A,
0x4090, 0x40A8, 0x2B15, 0x0F19, 0x0AD8, 0xFB4C, 0xE502, 0xFD69,
0xC4DA, 0xDB72, 0xDE4E, 0xD31E, 0x04F6, 0xFE76, 0x14EB, 0x292D,
0x2D5D, 0x2F7C, 0x38E7, 0x38F6, 0x2916, 0x4B24, 0x05E7, 0x135D,
0xD948, 0xC4B8, 0xB88E, 0xB6A5, 0xB9FA, 0xC31C, 0xD5C8, 0xBF9F,
0xF925, 0xD780, 0x2B0C, 0x27C6, 0x4021, 0x40F7, 0x3069, 0x1CC7,
0x2065, 0x139A, 0xF53B, 0xFA0B, 0xC995, 0xD17E, 0xD046, 0xD340,
0xEBDB, 0xF76C, 0x00D3, 0x1886, 0x20A8, 0x26E7, 0x39ED, 0x3F06,
0x328F, 0x5239, 0x1BEE, 0x236B, 0xF475, 0xD113, 0xCAFC, 0xB468,
0xBABB, 0xBE2F, 0xC3D6, 0xB741, 0xE94A, 0xD250, 0x20FC, 0x212A,
0x3E91, 0x3C08, 0x3621, 0x223E, 0x2B3D, 0x23C3, 0x082D, 0x0803,
0xDB43, 0xCC61, 0xD673, 0xD29F, 0xD827, 0xF8D6, 0xE5D4, 0x0B47,
0x0FB7, 0x1A6F, 0x2F95, 0x3C9E, 0x33BE, 0x5256, 0x20C7, 0x24BC,
0x02EC, 0xE63A, 0xDF76, 0xC413, 0xC87D, 0xB916, 0xC356, 0xB9FD,
0xD666, 0xD528, 0x0F85, 0x14B4, 0x344E, 0x2BAE, 0x3766, 0x23EA,
0x30A4, 0x27C9, 0x0D19, 0x0AFE, 0xEF97, 0xDDC4, 0xEAB5, 0xD964,
0xDE48, 0xF9C2, 0xD8C4, 0x080A, 0xF8C9, 0x0ACD, 0x1FF8, 0x2E71,
0x2B9E, 0x4535, 0x21BE, 0x1DEC, 0x0820, 0xEBEC, 0xEE08, 0xD96F,
0xDEB6, 0xC450, 0xD45E, 0xB760, 0xD7FC, 0xE09B, 0xFA65, 0x0FEB,
0x1D01, 0x15C3, 0x2BE4, 0x1E98, 0x2DF2, 0x28D5, 0x0EDD, 0x0723,
0xFA72, 0xE950, 0xFF19, 0xF20D, 0xEDE7, 0xFC17, 0xE039, 0x03F3,
0xEB43, 0x0B8C, 0x06D0, 0x1F53, 0x1CB6, 0x3135, 0x1997, 0x15C5,
0x0A42, 0xEEF4, 0xF5C6, 0xDCF4, 0xEB03, 0xCECC, 0xE87F, 0xC365,
0xEA49, 0xE53A, 0xF8D6, 0x11B4, 0x0589, 0x0B36, 0x1BB9, 0x15E2,
0x273A, 0x2581, 0x0E47, 0x0259, 0x0209, 0xEDE2, 0x0347, 0x00A0,
0xF694, 0x0B3C, 0xED92, 0x0443, 0xF077, 0x0F6F, 0xF969, 0x22D9,
0x077F, 0x1C6E, 0x0E5F, 0x05EF, 0x05A9, 0xEDD0, 0xFB85, 0xDB97,
0xF400, 0xCDD9, 0xF08F, 0xD28C, 0xFAC0, 0xF761, 0x0866, 0x0EC2,
0x0623, 0x0BC2, 0x0D9A, 0x160C, 0x1A4F, 0x16ED, 0x0704, 0xF63D,
0x012E, 0xEB56, 0x04CF, 0x0378, 0xF734, 0x121B, 0xF831, 0x1077,
0xFA63, 0x135E, 0xFD34, 0x2365, 0x0136, 0x1793, 0xFDB0, 0xF509,
0xF968, 0xE567, 0xF177, 0xD7DD, 0xF3C7, 0xCC48, 0xF9B4, 0xDCAE,
0x04FF, 0x0B1C, 0x158E, 0x1552, 0x1400, 0x0738, 0x132F, 0x1DD6,
0x0DBF, 0x0EA7, 0xFAD2, 0xE458, 0xFB0D, 0xEADE, 0xFED0, 0x0468,
0xF73A, 0x12F5, 0xFCBC, 0x16F0, 0x0348, 0x1C99, 0x0303, 0x1FF0,
0x060B, 0x0F20, 0xFCA4, 0xF2EE, 0xEC22, 0xDD63, 0xE5F7, 0xD070,
0xEE22, 0xC7B4, 0xFE23, 0xE365, 0x0E3D, 0x1A21, 0x19A8, 0x1A17,
0x15E5, 0x07EC, 0x18D1, 0x1FD3, 0x1219, 0x0F7E, 0xF444, 0xDF60,
0xEFAB, 0xE956, 0xF35C, 0x03F4, 0xF5D6, 0x0CFF, 0x03B8, 0x1C18,
0x0868, 0x2524, 0x07A7, 0x1E38, 0x0755, 0x091E, 0x0691, 0xF53C,
0xF665, 0xE2A2, 0xDF3B, 0xCB7B, 0xE366, 0xC1D2, 0xFC02, 0xE1AE,
0x1443, 0x1EB6, 0x1C31, 0x209B, 0x162C, 0x0977, 0x18C8, 0x1F9B,
0x155A, 0x0DE3, 0xFFC6, 0xE1F5, 0xF172, 0xECA5, 0xE560, 0x01C7,
0xE79E, 0x04FB, 0x038E, 0x1749, 0x0C29, 0x2FED, 0x0778, 0x21E3,
0x0B11, 0x0111, 0x0C71, 0xF795, 0x037F, 0xEBB2, 0xECA2, 0xCF8D,
0xE0C4, 0xBF58, 0xEF3D, 0xE056, 0x1193, 0x1BF9, 0x2343, 0x255C,
0x15B4, 0x14F7, 0x1509, 0x1A36, 0x1434, 0x050A, 0x0674, 0xE360,
0xFDC6, 0xF0A6, 0xE5A5, 0x025E, 0xD907, 0xFFEF, 0xF67A, 0x0F70,
0x110E, 0x3121, 0x0CA3, 0x2C4F, 0x0625, 0xFC22, 0x0B9A, 0xEEC5,
0x039E, 0xF01B, 0xF38B, 0xD3DF, 0xEC4E, 0xC4A2, 0xEB01, 0xE72C,
0x0421, 0x1857, 0x24AF, 0x206C, 0x2078, 0x21C1, 0x1356, 0x1D86,
0x0F91, 0xF46A, 0x06B2, 0xE299, 0x01DC, 0xF861, 0xF1DF, 0x0480,
0xDD79, 0x0488, 0xEB08, 0x0C5A, 0x099F, 0x27BB, 0x12FF, 0x2D22,
0x06AF, 0xFDF2, 0x0448, 0xE2F6, 0xFF64, 0xE9E0, 0xF0BE, 0xDB6B,
0xF62F, 0xCA91, 0xF8BF, 0xEF10, 0x004A, 0x1A9C, 0x1978, 0x177D,
0x2108, 0x2273, 0x1646, 0x246C, 0x06E1, 0xEF9A, 0x023B, 0xDC6F,
0x017F, 0xFF17, 0xF63F, 0x0B99, 0xEDFC, 0x096C, 0xEF55, 0x10C6,
0xFEF9, 0x1F7F, 0x0F52, 0x2405, 0x0B5D, 0x00B9, 0x0136, 0xE4AA,
0xF72D, 0xE176, 0xEDE6, 0xD90E, 0xF399, 0xD24B, 0x0145, 0xF347,
0x0DD0, 0x1CE2, 0x14F1, 0x14FE, 0x1651, 0x1CFA, 0x15C6, 0x235F,
0x0922, 0xF1FB, 0xFE27, 0xDCA1, 0xFF11, 0xFACD, 0xF2EE, 0x0C5B,
0xEC8A, 0x0A5A, 0xF962, 0x11C8, 0xFF29, 0x229C, 0x0549, 0x1D5F,
0x0861, 0xFC09, 0x0362, 0xE77E, 0xF69D, 0xDF14, 0xEB57, 0xD30D,
0xF2AC, 0xD1B1, 0xFE2F, 0xF4A3, 0x15DE, 0x1C1D, 0x2043, 0x1B3B,
0x15F3, 0x2002, 0x1376, 0x1D94, 0x07AD, 0xF364, 0x018A, 0xE0E9,
0xFE3A, 0xF72A, 0xEF45, 0x0749, 0xE922, 0x0A1F, 0xF5B9, 0x1029,
0x076E, 0x2470, 0x0A33, 0x2154, 0x044B, 0xF5F1, 0xFCF5, 0xE276,
0xF384, 0xDECC, 0xECB3, 0xD310, 0xEDD6, 0xD3CE, 0xF8C7, 0xF449,
0x129D, 0x19F8, 0x2528, 0x1F62, 0x2160, 0x2910, 0x1780, 0x1B5A,
0x0207, 0xEC11, 0xFB5C, 0xE320, 0x0184, 0xF974, 0xEF93, 0x07DF,
0xE653, 0x09D1, 0xF194, 0x0B3F, 0x0318, 0x20AE, 0x13E0, 0x24CF,
0x0C90, 0xF879, 0xF845, 0xD9D0, 0xE8BF, 0xD814, 0xE9F7, 0xD816,
0xF420, 0xDCAC, 0xFA4E, 0xF5CF, 0x1079, 0x1480, 0x1C48, 0x1E01,
0x2141, 0x29B6, 0x2385, 0x1C9F, 0x00B9, 0xEBA1, 0xF006, 0xDE6B,
0xFA49, 0xF983, 0xF45E, 0x0D6B, 0xEEC3, 0x0CFF, 0xF2BF, 0x0487,
0xFF3A, 0x1610, 0x118F, 0x2254, 0x16B3, 0xFE8F, 0x03D6, 0xDD93,
0xE88F, 0xD184, 0xE2E5, 0xD85E, 0xF348, 0xE8F0, 0x059A, 0xFA08,
0x167B, 0x11AB, 0x15AD, 0x1B72, 0x180C, 0x2363, 0x254B, 0x1CE0,
0x0A0A, 0xF5F4, 0xEFCB, 0xDE19, 0xF1F0, 0xF277, 0xECC5, 0x108D,
0xF2F0, 0x12E7, 0xF87E, 0x05CD, 0xFA21, 0x0F7D, 0x0A41, 0x1B2C,
0x10C5, 0x00B9, 0x0AE3, 0xE58F, 0xF50C, 0xD666, 0xE235, 0xD3CA,
0xEB3F, 0xEAA3, 0x0607, 0xFF76, 0x2143, 0x131E, 0x176C, 0x2167,
0x1075, 0x1CCC, 0x1F1C, 0x12A3, 0x0AEF, 0xFAA6, 0xF6A2, 0xE0D2,
0xF2A5, 0xEA42, 0xE68C, 0x0AAD, 0xEC9E, 0x16BC, 0xFD80, 0x0957,
0x04D5, 0x1139, 0x09C6, 0x1B2C, 0x08AE, 0xFCE6, 0x0747, 0xE2C3,
0xFBCC, 0xD9FE, 0xE668, 0xD79C, 0xE673, 0xE7B8, 0xFDD2, 0x00F3,
0x1C6E, 0x1A45, 0x2142, 0x2985, 0x17CB, 0x1D98, 0x19FE, 0x09DA,
0x0855, 0xF67A, 0xF697, 0xDE8E, 0xF554, 0xE760, 0xEA89, 0x0743,
0xEA3E, 0x16C4, 0xF751, 0x1009, 0x0AA4, 0x1293, 0x1586, 0x1DB2,
0x04AF, 0xFD59, 0x007B, 0xD81D, 0xFAD7, 0xD461, 0xE55F, 0xDB96,
0xEA1C, 0xEA4A, 0xFF54, 0xFCC4, 0x129A, 0x1CC1, 0x1C4D, 0x3188,
0x21C1, 0x1DBC, 0x1B82, 0x0A10, 0x0098, 0xF4D6, 0xF0D8, 0xD7D9,
0xF04D, 0xE4F9, 0xEEA4, 0x08DE, 0xF028, 0x15F1, 0xF5C7, 0x1205,
0x058C, 0x1533, 0x1836, 0x1D26, 0x0D3D, 0x03BB, 0xFF30, 0xD8BC,
0xF6F3, 0xCCE4, 0xE06A, 0xD90A, 0xE773, 0xE9EE, 0x05C9, 0xFACE,
0x1354, 0x1B31, 0x1544, 0x34F0, 0x1E13, 0x1D67, 0x225F, 0x0E9F,
0x0819, 0x002C, 0xEF7B, 0xD5A2, 0xED1F, 0xDD3D, 0xEC09, 0x044C,
0xF1BF, 0x14A1, 0xFA4A, 0x127A, 0x025B, 0x14B2, 0x0D4C, 0x1F11,
0x0C12, 0x0976, 0x0946, 0xE0BC, 0xFBA1, 0xCE51, 0xE08D, 0xD32C,
0xE51E, 0xE1DD, 0x02E4, 0xF4FB, 0x160E, 0x1C7B, 0x18CA, 0x376F,
0x17B7, 0x1E1C, 0x1B4D, 0x12C3, 0x11D4, 0x0B3F, 0xF795, 0xDC6F,
0xEBCE, 0xD73F, 0xEC92, 0xFADE, 0xEDD1, 0x0D93, 0xFBD9, 0x12B9,
0x0907, 0x157E, 0x0700, 0x1C32, 0x0204, 0x0D3D, 0x0CAB, 0xE656,
0x06C8, 0xD354, 0xE33C, 0xD598, 0xE256, 0xDC40, 0xFC01, 0xEDA4,
0x0D30, 0x1AFA, 0x1E42, 0x3B37, 0x1C6C, 0x1EE8, 0x11DB, 0x136F,
0x0FB0, 0x10AD, 0x00CC, 0xE488, 0xF365, 0xDCED, 0xF0CC, 0xF89C,
0xED29, 0x089F, 0xF66A, 0x0FC6, 0x09F4, 0x14CA, 0x0AA7, 0x1878,
0xFAA0, 0x0842, 0x01E0, 0xE6AE, 0x08A7, 0xD72E, 0xEE7F, 0xDD3B,
0xE7DC, 0xE002, 0xFBB4, 0xEB47, 0x07EF, 0x16BE, 0x18A5, 0x370A,
0x1EC5, 0x1DFF, 0x0E50, 0x0EB0, 0x0344, 0x0D49, 0xF8CF, 0xEA0D,
0xF75F, 0xE38B, 0xFBC1, 0xFDB2, 0xF455, 0x0ADC, 0xFA16, 0x0D12,
0x0609, 0x0DA6, 0x0692, 0x124B, 0xFEEF, 0x0548, 0xFCE6, 0xE2F6,
0xFDDA, 0xD8B0, 0xF353, 0xE5DA, 0xF542, 0xE919, 0x024E, 0xF2E1,
0x09F4, 0x1600, 0x15D3, 0x2DF0, 0x1760, 0x1A6E, 0x0C77, 0x0D10,
0x012F, 0x07C6, 0xECF0, 0xEB60, 0xF04C, 0xE6F5, 0x0502, 0xFFD0,
0xFFCD, 0x123B, 0xFFD5, 0x11DE, 0x05DD, 0x09D3, 0xFC2B, 0x0AC3,
0xF9F3, 0x02E5, 0x0131, 0xE1B7, 0xFAA6, 0xD66F, 0xEF6A, 0xEA9A,
0xFA6F, 0xEE40, 0x0C82, 0xFAD9, 0x13C0, 0x1E4A, 0x1A54, 0x2B8D,
0x133D, 0x17C3, 0x031E, 0x08F8, 0xFF67, 0xFDEB, 0xEDF5, 0xE677,
0xE8EB, 0xE6CA, 0x00D4, 0xFD60, 0x06AD, 0x13F2, 0x0B84, 0x1E53,
0x0DA7, 0x1101, 0xFAD4, 0x041D, 0xF293, 0xFD73, 0xFAAA, 0xDE33,
0xFA11, 0xCE8A, 0xEEA2, 0xE787, 0xF1E9, 0xF0C1, 0x0805, 0xFFF8,
0x1B58, 0x2766, 0x20FE, 0x32D0, 0x15DF, 0x1A4E, 0x02DF, 0x0370,
0xF71B, 0xF4E2, 0xE9CA, 0xDFFE, 0xEB95, 0xDFCE, 0xFCDC, 0xFB5F,
0x02D9, 0x16C3, 0x12C2, 0x276B, 0x1937, 0x2024, 0x027E, 0x087A,
0xF670, 0xF8F5, 0xF5BF, 0xDBB2, 0xF0CD, 0xC800, 0xF063, 0xDF46,
0xF196, 0xF2B2, 0xFD1A, 0x050F, 0x1A1B, 0x26C2, 0x29F4, 0x3A13,
0x1D5C, 0x26CD, 0x0755, 0x001D, 0xF455, 0xEC94, 0xE0AB, 0xDFDC,
0xE8BE, 0xD9F2, 0x0072, 0xF4F4, 0x0063, 0x1B96, 0x1080, 0x2C5D,
0x1FEA, 0x25EB, 0x0B90, 0x1098, 0xFD66, 0xFAAE, 0xF7E4, 0xDA9F,
0xEBB4, 0xC4CD, 0xEBA9, 0xD723, 0xF4A8, 0xED54, 0xFD7D, 0x074F,
0x136B, 0x2437, 0x29E1, 0x39A0, 0x261D, 0x345C, 0x0D83, 0x0770,
0xF6E2, 0xEC4B, 0xE3AF, 0xE261, 0xE531, 0xD836, 0xFC8F, 0xEBA3,
0x0436, 0x159A, 0x0D45, 0x2F82, 0x1862, 0x2A39, 0x0E0A, 0x1488,
0x015E, 0x0048, 0xF819, 0xE119, 0xEEE6, 0xC4D0, 0xEBDB, 0xD05C,
0xED36, 0xE5FE, 0xFA61, 0xFFCF, 0x1196, 0x1DB2, 0x2152, 0x3867,
0x2692, 0x3AE9, 0x13A7, 0x0C1F, 0xF72F, 0xF1B3, 0xEBA8, 0xEBB2,
0xECA3, 0xD8EB, 0xF6C3, 0xE355, 0x00B7, 0x0D27, 0x0E7F, 0x2CA7,
0x124F, 0x2A67, 0x0A08, 0x16A7, 0x0688, 0x02C8, 0xF811, 0xE416,
0xEEF7, 0xC9D1, 0xF224, 0xD142, 0xEB48, 0xE3B6, 0xF13F, 0xFAEB,
0x0C57, 0x156F, 0x1C79, 0x3435, 0x2141, 0x4020, 0x1664, 0x10A9,
0xF8C9, 0xF0D4, 0xEBBF, 0xF11C, 0xF2E5, 0xE0E5, 0xFA9E, 0xE15B,
0xFEB7, 0x04AB, 0x08F7, 0x27D6, 0x0F47, 0x23CB, 0x0933, 0x11E5,
0x08EB, 0x08B6, 0xFAE5, 0xE6FD, 0xEAAC, 0xC95B, 0xF146, 0xD6A3,
0xF084, 0xEA39, 0xF1CD, 0xF806, 0x02EE, 0x0BFA, 0x14B9, 0x2BAB,
0x222F, 0x3D51, 0x190D, 0x1900, 0xFD3E, 0xF6B9, 0xEC41, 0xF38E,
0xECAF, 0xE85A, 0xFA81, 0xE70D, 0x06A9, 0x02E0, 0x051F, 0x1FDB,
0x03CD, 0x18F3, 0x0A69, 0x04E4, 0x0ECE, 0x0AB5, 0x0327, 0xF528,
0xF333, 0xCAF1, 0xEE85, 0xD6D8, 0xEC16, 0xF52E, 0xF557, 0xFE52,
0x00A8, 0x0123, 0x0388, 0x1A96, 0x182B, 0x30DB, 0x1B3D, 0x1595,
0x01FA, 0x036B, 0xF80F, 0xFD28, 0xEED4, 0xE818, 0xEFBB, 0xEA6F,
0x0555, 0x0592, 0x09DA, 0x1D59, 0xF7E3, 0x0D04, 0xFA06, 0xF674,
0x119F, 0x0412, 0x0B17, 0xFF9F, 0x01CF, 0xDE55, 0x016E, 0xDB3D,
0xEB66, 0xF910, 0xEBD7, 0x04E6, 0x01F4, 0xFFF1, 0x00A7, 0x10C6,
0x02CA, 0x1C23, 0x11F0, 0x0624, 0x093D, 0x01DA, 0x0107, 0x0D20,
0x0133, 0xF569, 0xF723, 0xE984, 0xFB19, 0x0801, 0x0337, 0x1ECD,
0xF772, 0x0C2C, 0xECE9, 0xE6CD, 0x0206, 0xEFE4, 0x1141, 0xFE8D,
0x0AC1, 0xE8A6, 0x0F09, 0xEE72, 0xFED5, 0x04E6, 0xEB4E, 0x0ABC,
0xF5E5, 0x060D, 0xF8D7, 0x10E8, 0xF6E4, 0x133E, 0xFFB7, 0xEE6C,
0x0774, 0xF2EB, 0x094C, 0x0E9C, 0x0959, 0x044C, 0x0CD6, 0xFC0B,
0x0A1F, 0x0F4E, 0x0020, 0x2577, 0xF22A, 0x0E9C, 0xE65E, 0xE382,
0xF07D, 0xDBD7, 0x03D4, 0xE6AF, 0x1106, 0xE6C9, 0x18D1, 0xF6CB,
0x0D96, 0x18F1, 0xFF3A, 0x18F0, 0xFEC7, 0x0A2A, 0xF2D2, 0x1357,
0xE807, 0x0E7A, 0xEE99, 0xE3CD, 0xF52B, 0xD828, 0x0492, 0x0032,
0x110E, 0x0C7C, 0x175F, 0x0C0F, 0x1F4D, 0x2478, 0x12BA, 0x2F18,
0xF5DF, 0x14CF, 0xDDDB, 0xE451, 0xDFDA, 0xD17B, 0xF19C, 0xD203,
0x04D2, 0xD1B3, 0x1C1B, 0xF617, 0x19C8, 0x22E1, 0x1045, 0x2B82,
0x141F, 0x18F3, 0xFC40, 0x15AB, 0xDED7, 0x0F56, 0xDC0E, 0xE0F9,
0xE2E3, 0xCDAB, 0xF2A5, 0xE8D1, 0x0A7E, 0x00E7, 0x2067, 0x1249,
0x2B78, 0x31FD, 0x25EC, 0x42F2, 0x07C3, 0x1E30, 0xDFCD, 0xEA8B,
0xD12D, 0xD0E0, 0xDDA5, 0xCA05, 0xF6B2, 0xC258, 0x11AD, 0xDF31,
0x1BD1, 0x1F39, 0x1C38, 0x32B3, 0x2466, 0x2955, 0x1181, 0x2422,
0xEB03, 0x11F4, 0xD94E, 0xE9BC, 0xD418, 0xCE1F, 0xE4B5, 0xDFD0,
0x0141, 0xEFDB, 0x1BD0, 0x058A, 0x329D, 0x34D3, 0x31A0, 0x4AFD,
0x1A8C, 0x3179, 0xF309, 0xF512, 0xD51C, 0xCF31, 0xD206, 0xCA4E,
0xE42E, 0xBC92, 0x035B, 0xCDCC, 0x105D, 0x0ABD, 0x19E9, 0x3030,
0x2A45, 0x2F84, 0x1BFC, 0x2F9E, 0xFD5A, 0x211D, 0xE344, 0xEF6B,
0xCEEB, 0xD1F0, 0xD580, 0xDC67, 0xF319, 0xE56F, 0x0FFD, 0xF3DB,
0x2929, 0x2705, 0x3617, 0x4A9E, 0x291B, 0x3970, 0x0AFE, 0x0D15,
0xE727, 0xD9D6, 0xD411, 0xC9FB, 0xDC73, 0xC41D, 0xF191, 0xC910,
0x0310, 0xFAB2, 0x10FB, 0x1F36, 0x2541, 0x2C91, 0x2114, 0x3096,
0x0C58, 0x2ABD, 0xF642, 0x076A, 0xD3ED, 0xD859, 0xD021, 0xDDFF,
0xE458, 0xE7C8, 0xFB74, 0xEAA4, 0x1A50, 0x122E, 0x2980, 0x3541,
0x28C9, 0x351D, 0x1A41, 0x13BB, 0xFD75, 0xED70, 0xE435, 0xD71D,
0xE15B, 0xC5E2, 0xEDB4, 0xD0C6, 0xF584, 0xF771, 0x078B, 0x10AF,
0x1B9A, 0x19AC, 0x191B, 0x23CC, 0x12FB, 0x280A, 0x0641, 0x141A,
0xE601, 0xF17D, 0xD882, 0xE349, 0xE596, 0xEA7D, 0xF190, 0xF0A9,
0x096E, 0x0533, 0x1D5B, 0x1D6E, 0x1B86, 0x232F, 0x183C, 0x0FF1,
0x0873, 0xF1AE, 0xF62B, 0xEEC9, 0xF1CF, 0xDB81, 0xF374, 0xD1B6,
0xF309, 0xFB6D, 0xF9D2, 0x0E55, 0x0DAF, 0x09AE, 0x0BD8, 0x0BBD,
0x0760, 0x1839, 0x0978, 0x1400, 0xF528, 0x000E, 0xEAAB, 0xFC56,
0xEF8F, 0xF245, 0xF2A4, 0xF57E, 0xFDE5, 0x079F, 0x0A59, 0x0D2C,
0x0E85, 0x0F87, 0x0CD9, 0x0019, 0x05BC, 0xEC7A, 0x025C, 0xF52A,
0x068C, 0xF8E3, 0x05DC, 0xEB73, 0xFE0B, 0xFC0D, 0xF8CA, 0x1535,
0xF9BB, 0x08E2, 0xF9D2, 0xF7AC, 0xFB70, 0xFF16, 0xFC24, 0x0693,
0xF61E, 0x008F, 0xFA63, 0x084B, 0x0253, 0x0EAD, 0x00B7, 0x028A,
0x035C, 0x0814, 0x00A6, 0x0D31, 0xFE2C, 0x01D5, 0x03CF, 0xEBA8,
0xFB07, 0xD97E, 0xFCB5, 0xECAC, 0x107A, 0xFEC6, 0x1850, 0x070D,
0x12B1, 0x1365, 0x06F4, 0x17B0, 0xF714, 0x0E83, 0xE8E6, 0xF209,
0xEEA0, 0xEA74, 0xF1FE, 0xF30E, 0xEAF3, 0xF61F, 0xF872, 0x0670,
0x0C03, 0x1D97, 0x1542, 0x2527, 0x1372, 0x152D, 0x037E, 0x0B82,
0xF5DB, 0x0351, 0xF863, 0xE06E, 0xF33A, 0xC4F5, 0xF03D, 0xD86A,
0x09FC, 0xF942, 0x203E, 0x0C36, 0x2775, 0x297D, 0x1F58, 0x2FB8,
0x029B, 0x0F00, 0xE65A, 0xF18E, 0xDF62, 0xE2BB, 0xE3D0, 0xE075,
0xDF3E, 0xE26A, 0xEBB7, 0xF850, 0x0950, 0x1C47, 0x20D8, 0x331F,
0x2BDD, 0x34D7, 0x159E, 0x177F, 0xFA12, 0x0128, 0xEF01, 0xE4BC,
0xE37F, 0xBAE0, 0xE3E9, 0xC2FF, 0xF89C, 0xE78C, 0x1725, 0x0816,
0x2F70, 0x2BF1, 0x3477, 0x4651, 0x1C60, 0x2B7D, 0xF5E8, 0xF429,
0xDDF3, 0xE44E, 0xD3F7, 0xDF93, 0xD2DB, 0xD546, 0xDCE6, 0xE1C3,
0xF953, 0x0B3F, 0x1EF8, 0x3084, 0x35E1, 0x3CD1, 0x2CB7, 0x341F,
0x0EE3, 0x0F98, 0xF614, 0xE51C, 0xDC5F, 0xBF1A, 0xD78A, 0xB7D8,
0xEB15, 0xD309, 0x041F, 0xF1F7, 0x290E, 0x237B, 0x391F, 0x4A5F,
0x2B2C, 0x4170, 0x0D8E, 0x11A3, 0xEC04, 0xE9AE, 0xD392, 0xE476,
0xC691, 0xD870, 0xD01F, 0xD3D5, 0xE8BC, 0xF1FA, 0x122E, 0x1DF2,
0x3473, 0x3A0A, 0x3447, 0x3AA4, 0x283F, 0x2C46, 0x0BD3, 0xF91D,
0xE620, 0xC083, 0xD483, 0xBAA6, 0xDA86, 0xCB10, 0xF271, 0xDBFC,
0x1843, 0x07E3, 0x3456, 0x40E5, 0x2F2E, 0x45A3, 0x1DDB, 0x25BF,
0x03D7, 0x0514, 0xE178, 0xE8E1, 0xC94A, 0xDE67, 0xC034, 0xD61B,
0xD2E5, 0xE130, 0xFC73, 0x0267, 0x25F7, 0x240C, 0x32AF, 0x3783,
0x2EE2, 0x3464, 0x24E6, 0x1734, 0xFE5F, 0xD6AE, 0xE00E, 0xBDE4,
0xD649, 0xD2CC, 0xDFA0, 0xD6E3, 0x044F, 0xF133, 0x22E1, 0x246A,
0x2C93, 0x3C8E, 0x20B2, 0x2C60, 0x1116, 0x17B9, 0xFBB5, 0x04BC,
0xD9DB, 0xE6C2, 0xC3D0, 0xDB92, 0xC3A7, 0xE036, 0xE64E, 0xEF79,
0x11F3, 0x06AD, 0x2883, 0x1EAE, 0x2EFE, 0x3179, 0x26F2, 0x210F,
0x1679, 0xF552, 0xFA0E, 0xD416, 0xDF7C, 0xD6C6, 0xDB20, 0xDE18,
0xEE7F, 0xE5AB, 0x0CBB, 0x0A9B, 0x1FDE, 0x2165, 0x1FBD, 0x21A4,
0x1019, 0x1C0A, 0x067E, 0x158F, 0xF5FB, 0x03BC, 0xD425, 0xE3DF,
0xC73C, 0xE2BE, 0xD7CA, 0xED71, 0xF88E, 0xF3D2, 0x1670, 0x03F8,
0x294A, 0x1BB7, 0x27FF, 0x2335, 0x19C0, 0x04E1, 0x1390, 0xF1CA,
0xFB15, 0xEB82, 0xE5A3, 0xE2A0, 0xE9A5, 0xEB3E, 0xF423, 0xFD16,
0x0802, 0x0A69, 0x11C7, 0x0A16, 0x0B86, 0x1052, 0x025A, 0x1985,
0xFF7B, 0x1434, 0xF26B, 0xFFA0, 0xD9F8, 0xE990, 0xDA59, 0xEE37,
0xE6F1, 0xF169, 0xFCC0, 0xF0FF, 0x1A90, 0x0309, 0x22A2, 0x1003,
0x1855, 0x07BC, 0x162B, 0xFD8E, 0x1785, 0x04F9, 0x0243, 0xF9E2,
0xF1E2, 0xEDF5, 0xEFAF, 0xFE7B, 0xF039, 0x01D9, 0xFA96, 0xF73D,
0xFEFF, 0xF66C, 0xFECC, 0x0D0D, 0xFDBA, 0x1BE8, 0x000A, 0x1113,
0xF963, 0x03CF, 0xE79C, 0xF66F, 0xE6D8, 0xF2FE, 0xED02, 0xEFD0,
0xFF9D, 0xF19A, 0x148B, 0xF87E, 0x14A5, 0xF6B3, 0x1537, 0xFEFB,
0x1D0A, 0x0DC2, 0x1E46, 0x1141, 0x0B26, 0x0264, 0xF8D0, 0xFDA0,
0xEDD5, 0x01D8, 0xE16D, 0xF074, 0xE7F3, 0xE3D3, 0xF547, 0xF3C3,
0xFB12, 0x11F7, 0x00A8, 0x18FD, 0x0B7F, 0x117E, 0x05FD, 0x0E95,
0xF28F, 0xFD65, 0xF1DB, 0xF16F, 0xF216, 0xF1D9, 0xF807, 0xEEAB,
0x0561, 0xE624, 0x0D92, 0xEDBA, 0x19DA, 0x0E02, 0x23B9, 0x1BF3,
0x2573, 0x1553, 0x0F1B, 0x0E08, 0xF5C5, 0x053D, 0xE0FE, 0xF5D4,
0xCDCB, 0xE075, 0xDBE0, 0xE27F, 0xF1A9, 0xFC2A, 0x002E, 0x1056,
0x0FA2, 0x13BE, 0x17B4, 0x15B8, 0x0FAB, 0x120B, 0x0055, 0xFCD9,
0xF9A9, 0xF41D, 0xEB67, 0xF0A0, 0xE94A, 0xDEA6, 0xFF02, 0xD98C,
0x1443, 0xFA2D, 0x23D5, 0x1BD8, 0x2C25, 0x1B3B, 0x271A, 0x1D3F,
0x0ACA, 0x19C5, 0xEA82, 0xFEF0, 0xCC66, 0xE871, 0xBE9A, 0xE113,
0xD781, 0xEBFA, 0xF7D0, 0xFA70, 0x1209, 0x0AB3, 0x1D0D, 0x1737,
0x1D98, 0x16AA, 0x199E, 0x0FA7, 0x0780, 0xFFF6, 0xF3B5, 0xF65B,
0xDC7E, 0xE63E, 0xE0F8, 0xD0DE, 0x0269, 0xE1AC, 0x1F13, 0x09BF,
0x3157, 0x1C26, 0x2D3E, 0x1EC0, 0x2020, 0x25FB, 0x02CF, 0x1493,
0xD967, 0xF027, 0xBD6F, 0xE6FC, 0xBC1B, 0xEE1D, 0xE0DC, 0xED09,
0x0974, 0xF34E, 0x1E6B, 0x0EF4, 0x1FDB, 0x19F2, 0x20FD, 0x11F4,
0x1FF8, 0x122C, 0x04E3, 0x060F, 0xE626, 0xEED4, 0xD579, 0xDA37,
0xE400, 0xDB4E, 0x0BEB, 0xF29D, 0x2EFF, 0x09B3, 0x33AC, 0x1F90,
0x2259, 0x257A, 0x1761, 0x1CFB, 0xF4B6, 0x05C3, 0xCA9E, 0xEEEF,
0xBA63, 0xF339, 0xC500, 0xEF60, 0xEF97, 0xE2FC, 0x1430, 0xF391,
0x2315, 0x0EDF, 0x2311, 0x10AA, 0x256E, 0x0FCD, 0x1F96, 0x18F5,
0xF9E9, 0x032F, 0xDD0A, 0xE420, 0xD4C2, 0xE611, 0xEAEC, 0xEF35,
0x199F, 0xF11E, 0x2FEC, 0x0B6B, 0x2A7F, 0x26DE, 0x1B2A, 0x1D8B,
0x08A1, 0x0EE0, 0xE4DC, 0x03E0, 0xC566, 0xFBDF, 0xC24B, 0xF712,
0xD409, 0xE726, 0xFA2E, 0xE2AE, 0x1810, 0xF264, 0x2613, 0x0572,
0x28D3, 0x0FE1, 0x2644, 0x193F, 0x16A2, 0x160F, 0xF12B, 0xF6C8,
0xDB72, 0xEDFD, 0xDD3D, 0xF7B4, 0xFB3A, 0xED9F, 0x1B7A, 0xF28E,
0x2494, 0x108C, 0x212A, 0x1D66, 0x09DD, 0x0EBB, 0xF665, 0x09DF,
0xDF1A, 0x0CE5, 0xCB98, 0xFE9F, 0xD0A2, 0xEEA2, 0xE00B, 0xE7EC,
0xFF14, 0xE45A, 0x1A86, 0xE9C7, 0x2BD9, 0x04CD, 0x2CB3, 0x1C27,
0x1F62, 0x17F1, 0x0D9D, 0x078F, 0xEEC7, 0xFCAB, 0xE0C9, 0xFD19,
0xE9AE, 0xF79B, 0xFAFF, 0xEF66, 0x0F0F, 0xF5A0, 0x1B33, 0x077F,
0x129F, 0x103A, 0xFC42, 0x08E5, 0xF2F2, 0x10DB, 0xE54B, 0x0FB4,
0xD680, 0xF760, 0xD7DB, 0xEFE6, 0xE25F, 0xEA93, 0xFCCB, 0xDB35,
0x1BEE, 0xE6FD, 0x315D, 0x128F, 0x2ACF, 0x1E3C, 0x18CF, 0x0C8D,
0x0B04, 0x0C90, 0xF1A6, 0x0880, 0xE864, 0xFF53, 0xE985, 0xFA1C,
0xF039, 0xF047, 0x03E2, 0xEC07, 0x0F07, 0xFC45, 0x0D08, 0x0FBB,
0xFEF0, 0x12DE, 0xFA76, 0x13DA, 0xF096, 0x07B0, 0xDD55, 0xF805,
0xDAEE, 0xF27F, 0xE3B7, 0xDFF5, 0x00B3, 0xD664, 0x2385, 0xF518,
0x32CC, 0x1A56, 0x2585, 0x1849, 0x146C, 0x0EDC, 0x0BA6, 0x1420,
0xF57D, 0x0B5F, 0xE6D4, 0xFF34, 0xE123, 0xF70E, 0xE620, 0xE9A1,
0xFA37, 0xE32E, 0x0CAF, 0xFB0E, 0x1116, 0x1BC9, 0x066D, 0x1931,
0x0452, 0x0A52, 0xF546, 0x0423, 0xDF7D, 0xF9DB, 0xDD28, 0xE78E,
0xE73C, 0xDA15, 0x0786, 0xE438, 0x2671, 0xFDD8, 0x30AE, 0x173C,
0x2466, 0x1A21, 0x1725, 0x13C4, 0x0E8C, 0x170B, 0xF395, 0x0BAC,
0xDFB3, 0xFCB2, 0xD40B, 0xF183, 0xD95E, 0xE1F9, 0xF82E, 0xE305,
0x1149, 0x0609, 0x1868, 0x21CD, 0x119D, 0x1231, 0x0B3C, 0x080D,
0xF5E9, 0x061F, 0xDF6B, 0xEF68, 0xDEE7, 0xE073, 0xE9D3, 0xE547,
0x08F6, 0xED82, 0x266A, 0xFC96, 0x3028, 0x154F, 0x282A, 0x1E61,
0x1BB6, 0x1C51, 0x0D3A, 0x16AF, 0xEC5B, 0x067B, 0xD1E4, 0xF968,
0xC837, 0xE8A8, 0xD9DE, 0xDB9B, 0x0011, 0xED4C, 0x1A4F, 0x0FEA,
0x226A, 0x1B3D, 0x1837, 0x10AD, 0x0A6B, 0x0C9D, 0xF1DF, 0xFC9B,
0xDE53, 0xE7FE, 0xE047, 0xEA5F, 0xEC6C, 0xEE71, 0x0ACE, 0xEF0F,
0x2618, 0xFBA6, 0x315C, 0x191B, 0x2942, 0x28B3, 0x1B30, 0x1D01,
0x04BD, 0x110E, 0xD96C, 0x0144, 0xC687, 0xEE90, 0xCC23, 0xE17C,
0xE150, 0xE4A2, 0x0640, 0xF77E, 0x21A8, 0x09B9, 0x25F8, 0x16C6,
0x16DE, 0x132E, 0x092B, 0x0511, 0xF04D, 0xF580, 0xDDC2, 0xEFDF,
0xE64C, 0xF691, 0xF227, 0xF3B8, 0x0929, 0xEB88, 0x22AC, 0xFE00,
0x2C9D, 0x236B, 0x26B0, 0x24F3, 0x153C, 0x159A, 0xF383, 0x0F69,
0xCE28, 0xF7BC, 0xCAB2, 0xE593, 0xD462, 0xEAEB, 0xE776, 0xEF75,
0x0D33, 0xEF08, 0x2310, 0x01E2, 0x21FA, 0x157F, 0x17A7, 0x0B9D,
0x08D0, 0xFFDC, 0xEEAE, 0xFCF4, 0xE5A6, 0xFD82, 0xF04C, 0xFE8B,
0xF43D, 0xEFC1, 0x05CA, 0xEB27, 0x1E8D, 0x0747, 0x2C7D, 0x2055,
0x21C5, 0x1FB7, 0x0472, 0x16C5, 0xE77D, 0x0733, 0xD289, 0xF076,
0xD3C3, 0xF020, 0xDB7F, 0xF71E, 0xF008, 0xE8AD, 0x0D90, 0xE740,
0x1E3F, 0x017D, 0x22AA, 0x0FBA, 0x144A, 0x070E, 0x0389, 0x06F5,
0xF569, 0x0BE8, 0xF1EE, 0x0521, 0xF59D, 0xF847, 0xF1B8, 0xEF9E,
0x018D, 0xF443, 0x1DA1, 0x027B, 0x2450, 0x185C, 0x0FC7, 0x1F09,
0xF9E1, 0x0E67, 0xEBDB, 0xFDCE, 0xDDBC, 0xF7BC, 0xDFBD, 0xFCA5,
0xE815, 0xF427, 0xF19F, 0xE139, 0x0793, 0xE60A, 0x1BB8, 0xFE68,
0x19D1, 0x09D8, 0x0CB8, 0x0A85, 0x08BE, 0x16AB, 0x0297, 0x148D,
0xFC98, 0xFEDD, 0xF1D7, 0xF890, 0xEB09, 0xF78B, 0x021D, 0xEEE1,
0x13C9, 0xFBA5, 0x0E7F, 0x1596, 0x04CC, 0x136B, 0xFDD4, 0x0480,
0xF414, 0x048F, 0xECBC, 0x0386, 0xF03D, 0xFA25, 0xE84F, 0xEC12,
0xED46, 0xDC48, 0x08AB, 0xE181, 0x12EF, 0xF923, 0x12F3, 0x0B8A,
0x12E9, 0x1B5C, 0x1389, 0x22A4, 0x0C5F, 0x0FA4, 0xFA60, 0xFFA9,
0xEBF5, 0x019C, 0xEB22, 0xF1C8, 0xF90E, 0xE6C4, 0x00D1, 0xFCC0,
0x04BF, 0x0DFA, 0x068A, 0x0944, 0x01E4, 0x0BF4, 0x0128, 0x13E4,
0xFE00, 0x02F8, 0xF1B0, 0xEFD3, 0xE4CA, 0xE596, 0xEE1A, 0xDA04,
0xFF38, 0xDF14, 0x0A19, 0xFA13, 0x14BC, 0x1B20, 0x1B08, 0x2746,
0x1DB2, 0x1C96, 0x0A3D, 0x0C8E, 0xF87A, 0x032C, 0xF144, 0xFB4C,
0xE305, 0xEAAD, 0xE931, 0xE843, 0xF95F, 0xF946, 0x012B, 0x06CB,
0x039E, 0x0F56, 0x0DC7, 0x19AE, 0x13D7, 0x1342, 0x01CE, 0xF756,
0xF22C, 0xE932, 0xE5F5, 0xE6D2, 0xE5EB, 0xD9EB, 0xF98C, 0xE021,
0x090E, 0x0BD1, 0x17E4, 0x2946, 0x23A5, 0x1FB9, 0x1CFB, 0x17CB,
0x0B92, 0x0E95, 0xFF2C, 0xFB00, 0xE741, 0xF4B5, 0xD5D6, 0xEEC6,
0xE83F, 0xE782, 0xF521, 0xF188, 0xFB1A, 0x091E, 0x1168, 0x1B69,
0x21E4, 0x1A3E, 0x16F7, 0x071F, 0x01EE, 0xEE21, 0xF017, 0xEA5D,
0xDA0E, 0xE7F1, 0xE270, 0xD94E, 0xFA5E, 0xF24F, 0x085F, 0x1D13,
0x1E92, 0x225B, 0x2556, 0x1984, 0x1E5B, 0x1868, 0x10C5, 0x071D,
0xF585, 0xF39B, 0xDB38, 0xF77C, 0xD7DE, 0xEF7E, 0xE6C8, 0xE0BF,
0xED0B, 0xF523, 0x03B2, 0x1749, 0x2457, 0x1C6B, 0x2653, 0x0B12,
0x1594, 0xFA9F, 0x0038, 0xEDE2, 0xE928, 0xEB5D, 0xDBEB, 0xE801,
0xE6D2, 0xEC84, 0xFB4A, 0x078D, 0x0ACF, 0x1990, 0x1D41, 0x1B72,
0x28AE, 0x1722, 0x2019, 0x0EB9, 0x0565, 0xFDE8, 0xEFB7, 0xF5D4,
0xE1FC, 0xFE2E, 0xD564, 0xECD7, 0xDE49, 0xE3C1, 0xF4AC, 0x068F,
0x1133, 0x19F9, 0x29DC, 0x08B9, 0x26BB, 0xFAD8, 0x0FBE, 0xFB37,
0xF9D9, 0xEFA6, 0xEE05, 0xED96, 0xE0F0, 0xFFB3, 0xE5D9, 0x02EF,
0xFBDA, 0x0606, 0x09D6, 0x11B0, 0x21D0, 0x12A6, 0x2B6F, 0x0AE0,
0x1342, 0x0588, 0xFF5C, 0x0232, 0xF793, 0xFF17, 0xDDAD, 0xFE14,
0xC9D9, 0xEFFB, 0xE1F8, 0xF123, 0xFF97, 0x08A5, 0x17EA, 0x032F,
0x2C3A, 0xF44A, 0x1FB7, 0xF900, 0x06AD, 0xFC72, 0x0069, 0xF64F,
0xF7F6, 0x04D0, 0xE05B, 0x1660, 0xE294, 0x0130, 0xFC1F, 0xF9DA,
0x10C9, 0x06B3, 0x20B7, 0x0299, 0x1BF8, 0xFFA5, 0x0B82, 0x066E,
0x041E, 0x0CB8, 0xF856, 0x0606, 0xDDE2, 0x0148, 0xCFFC, 0xFDBD,
0xE7C7, 0xF835, 0x0A5C, 0xF6C5, 0x1D04, 0xEB0C, 0x1D5A, 0xEEF3,
0x0DB4, 0xFC86, 0x01F9, 0xFF42, 0x0713, 0x0EE4, 0x010E, 0x227C,
0xE702, 0x1A45, 0xE6CD, 0xF8D9, 0xFDF7, 0xF4D6, 0x0D23, 0xFEFB,
0x14C6, 0xEDF4, 0x1045, 0xF5B1, 0x0335, 0x0EEA, 0xF6A5, 0x0B94,
0xF64A, 0x0713, 0xEFAD, 0x137F, 0xE2C0, 0x07BE, 0xF958, 0xE8D6,
0x1071, 0xE7EB, 0x109F, 0xEC37, 0x1122, 0xE785, 0x0877, 0xF7AE,
0xFF59, 0x1314, 0x009A, 0x2096, 0xF9E6, 0x230B, 0xEC33, 0x11CB,
0xF488, 0xF131, 0x0403, 0xEEF1, 0x04E9, 0xF500, 0x0F19, 0xF276,
0x0FEA, 0x0303, 0xF949, 0x0EA4, 0xF24D, 0x0B3F, 0xF639, 0x100F,
0xEC06, 0x1717, 0xF350, 0xF9B5, 0x0D7F, 0xD519, 0x0C3E, 0xE0CA,
0x0311, 0xEDDD, 0x09B6, 0xED99, 0x0A7E, 0x0B20, 0x00E7, 0x290E,
0xFBA0, 0x215D, 0xF43F, 0x121A, 0xEA68, 0x081F, 0xFCDE, 0xEE4B,
0x0D28, 0xE273, 0x0714, 0xF164, 0x05BA, 0xFF75, 0xFD7E, 0x095E,
0xFBCF, 0x12AB, 0xFFE6, 0x17C5, 0xF7F3, 0x128C, 0xF5EA, 0x05EA,
0xFD27, 0xEB33, 0x09B2, 0xD9A4, 0x075B, 0xE802, 0xFB67, 0xED3E,
0xFF10, 0xF83B, 0xFD75, 0x1BFD, 0xF963, 0x24E4, 0x016D, 0x1115,
0xFE08, 0x074E, 0xF59A, 0xFFDC, 0x04B9, 0xE909, 0x0FD3, 0xEBCE,
0x028F, 0x05D9, 0xF885, 0x0482, 0xF647, 0x01EB, 0xF536, 0x10CC,
0xFC68, 0x1318, 0x0AAD, 0x0667, 0x0618, 0xF81E, 0xFECE, 0xE9B9,
0x0C7F, 0xE6B7, 0x049A, 0xF497, 0xF909, 0x0299, 0x0044, 0x11ED,
0xF91F, 0x1BBB, 0xF441, 0x10F9, 0xFEF9, 0x01F6, 0x02A9, 0xFF13,
0xFDBA, 0xF5C1, 0x08FB, 0xE7A8, 0x0AB9, 0xFBB0, 0xF3B3, 0x0DC1,
0xF5D7, 0x01A2, 0xFC9A, 0x06AE, 0xF80D, 0x115C, 0x05CE, 0x050B,
0x0B5C, 0xF440, 0xFED4, 0xF227, 0xFFF7, 0xEE92, 0x0800, 0xE975,
0xFD26, 0xFFB9, 0xF930, 0x15D1, 0x052A, 0x1785, 0x0291, 0x13F5,
0xFF8A, 0x0B05, 0x0980, 0xFFCD, 0x080F, 0xFB2F, 0xFDE5, 0xFB59,
0x02B5, 0xFBD1, 0xFAE7, 0x0403, 0xE95C, 0x0391, 0xF477, 0xFBD8,
0xFE95, 0x03EB, 0x0438, 0x061A, 0x0F5B, 0xF7F9, 0x10B5, 0xF397,
0x06BE, 0xFD45, 0xFB57, 0xF912, 0xFEC2, 0xFA22, 0xF7AE, 0x12E3,
0xF342, 0x100E, 0xFDDC, 0xFD4A, 0xFC36, 0xFE2E, 0x0684, 0xFE37,
0x174D, 0xFE07, 0x12AB, 0x03ED, 0xFD2A, 0x0C4F, 0xF4B0, 0x0ECC,
0xF5E7, 0x09ED, 0xEC3F, 0x0239, 0xF8D0, 0xF7BF, 0x0790, 0xF5F4,
0x0490, 0xF295, 0x0F22, 0xF1B7, 0x17E2, 0x0157, 0x0741, 0x07B1,
0xF489, 0x0549, 0xF88C, 0x1245, 0xF782, 0x167F, 0xF7E2, 0x0069,
0x056E, 0xF1C9, 0x0171, 0xF1EF, 0x0515, 0xF808, 0x15A5, 0x022F,
0x0C1F, 0x1055, 0xF048, 0x1A17, 0xEA7A, 0x0A04, 0xEFC8, 0xFC69,
0xEF78, 0xFAD3, 0x04FB, 0xF057, 0x0D06, 0xE82E, 0x0394, 0xEE07,
0x108D, 0xFF89, 0x1188, 0x09D0, 0xFBF3, 0x11BC, 0xF130, 0x1862,
0xF540, 0x1121, 0xF2B3, 0x0463, 0xFD1F, 0xF108, 0x10E0, 0xE92C,
0x0691, 0xF4DA, 0x06C7, 0xFF40, 0x11F1, 0x0D4C, 0xFE85, 0x2068,
0xEB11, 0x1C58, 0xEFC5, 0xFF91, 0xF65E, 0xF91F, 0xF855, 0xF786,
0x085A, 0xE040, 0x0EE7, 0xE33E, 0x0673, 0xF733, 0x09B4, 0x01C0,
0x05E1, 0x1081, 0xF487, 0x2096, 0xED06, 0x1C92, 0xF5B0, 0x0483,
0xFC00, 0xF3D7, 0x0132, 0xEA1A, 0x0B53, 0xED03, 0x08C2, 0xF953,
0x067B, 0x03C6, 0x03BF, 0x196F, 0xF035, 0x1DCD, 0xE292, 0x0688,
0xEF5B, 0xF8F1, 0x00D2, 0xF8AC, 0x067C, 0xEAE2, 0x12CC, 0xE11E,
0x13D2, 0xF3B3, 0x07B5, 0x01F9, 0x0995, 0x0C76, 0x0241, 0x1AB2,
0xE8D6, 0x1B41, 0xE284, 0x0BD9, 0xF8AA, 0xF1F9, 0x02BF, 0xEA78,
0x08CD, 0xF1D8, 0x190A, 0xF6D0, 0x0CBE, 0x05B6, 0xFF77, 0x1D39,
0x0040, 0x205D, 0xED41, 0x0517, 0xE0BA, 0xF675, 0xEB98, 0xF61B,
0xF773, 0xE781, 0x050A, 0xE10B, 0x1877, 0xF18D, 0x14FC, 0x00DB,
0x0535, 0x0753, 0x06B1, 0x1AFA, 0xFE5C, 0x263B, 0xEB55, 0x0CB4,
0xEA09, 0xEBCA, 0xF53F, 0xE6DB, 0xFD27, 0xF5F1, 0x0C00, 0xF670,
0x1293, 0xFBE7, 0xFF0F, 0x14E6, 0xFE7D, 0x1B4B, 0x051A, 0x0C9E,
0xF4F2, 0x04DF, 0xEEB8, 0x0088, 0xF74F, 0xEA31, 0x0035, 0xE2E2,
0x0523, 0xF425, 0x0A0E, 0xFC3F, 0x075A, 0x0025, 0xFD0E, 0x0A9C,
0xFDE9, 0x1C5F, 0xFD42, 0x1125, 0xF567, 0xF31C, 0xF56F, 0xF4AB,
0xFF0E, 0xFA11, 0x060E, 0xF3E0, 0x08F6, 0xF7BB, 0x0364, 0x0ED3,
0xF283, 0x147B, 0xF5DE, 0xFF1E, 0x0046, 0xFFC3, 0xF67C, 0xFF90,
0xF429, 0xEF54, 0x02E9, 0xEFCE, 0x0B4F, 0xFE7B, 0x0AC4, 0x0556,
0x107F, 0xFEB5, 0x0847, 0x02C5, 0xF370, 0x1541, 0xF62F, 0x1252,
0xFD15, 0xF3CA, 0xF12F, 0xEE8D, 0xF0FE, 0xFAEE, 0x04B9, 0xF404,
0x092A, 0x054A, 0x08EB, 0x1F47, 0x089F, 0x1237, 0xF8D6, 0xF858,
0xF96B, 0xF612, 0xFAC2, 0x008C, 0xEF9F, 0xF1E1, 0xF668, 0xE8D6,
0x006C, 0xF717, 0x0365, 0xFE84, 0x0FDB, 0x03E1, 0x188F, 0x0EFD,
0x06A1, 0x1681, 0xF8D5, 0x046B, 0x01E4, 0xEE76, 0xFBE5, 0xF422,
0xEC0D, 0xFD8E, 0xF13D, 0xF715, 0xFB13, 0xFC3C, 0xFC2F, 0x1A42,
0x085D, 0x1AE5, 0x0ED0, 0x01AF, 0x003F, 0xFD0A, 0x010B, 0xFABF,
0x049F, 0xF25C, 0xFCD2, 0xEEAC, 0xF892, 0xF95D, 0xF367, 0x04C7,
0xFBFD, 0x013C, 0x0C14, 0x0A71, 0x0DDA, 0x177C, 0x0503, 0x02CA,
0x011C, 0xEA17, 0x05F0, 0xF9C8, 0x0317, 0x038B, 0xF6D8, 0xF456,
0xF123, 0xFCCB, 0xF1B6, 0x15AA, 0xF4A8, 0x1B3D, 0x09BC, 0x0754,
0x113C, 0xF982, 0xFA00, 0xF31D, 0x01B9, 0xEA4C, 0x10B5, 0xF801,
0xFFCC, 0x06DD, 0xF7D0, 0x046E, 0xFB85, 0xFC67, 0xFBDB, 0x00F7,
0xFFC3, 0x1B66, 0x0C76, 0x13C7, 0x0AC3, 0xED01, 0xFD3B, 0xEC68,
0x02C7, 0xFD18, 0xFFEE, 0xF8D4, 0xEE63, 0x0492, 0xF1C1, 0x1B42,
0xFC44, 0x1134, 0x02BF, 0xFFF7, 0x0EEF, 0xFCAE, 0x06FD, 0xFDE1,
0xFBBB, 0xF287, 0x0E16, 0xEBE0, 0x0952, 0x009C, 0xF031, 0x013F,
0xF5A1, 0xF831, 0xFCDF, 0x0AEC, 0xFF9A, 0x194D, 0x0BC5, 0x0A24,
0x1039, 0xEF81, 0x03D6, 0xEEE7, 0xF9EC, 0xFC48, 0x0036, 0xFCEA,
0xF7AB, 0x048F, 0xE87B, 0x12FF, 0xF3D1, 0x0D7B, 0x05C2, 0x0444,
0x097D, 0x0939, 0x0D66, 0x012B, 0x1016, 0xEEC9, 0x0960, 0xE6FA,
0x03F3, 0xF9E6, 0xFA8F, 0x0FE8, 0xF1A8, 0xFE10, 0xF27F, 0xFDB0,
0xF91C, 0x1499, 0x03BF, 0x076B, 0x0AE8, 0xF9E9, 0x1126, 0xFED4,
0x0DC6, 0xF771, 0x000B, 0xECF8, 0xF9F2, 0xFFFB, 0xEC7D, 0x1C76,
0xE578, 0x147D, 0xFD3E, 0x00B8, 0x0643, 0x002F, 0xF9EF, 0xFFD4,
0x0CB9, 0xF469, 0x1B1C, 0xF65C, 0x0A03, 0x02FE, 0x06B1, 0xFEE2,
0xFCC9, 0xF7AB, 0xE6CB, 0xFDAD, 0xEA23, 0x0E0A, 0xF9CC, 0x0859,
0x012E, 0xF52D, 0x0661, 0xFA88, 0x10A8, 0xF9EC, 0x0CC8, 0xF63A,
0xFED3, 0x0A5C, 0xFEBC, 0x1960, 0xF5D1, 0x0DE5, 0xF14D, 0xF96A,
0xFBC9, 0xF6BC, 0xF249, 0x0180, 0xF95B, 0xFAEC, 0x1865, 0xF41B,
0x151F, 0x0681, 0x05FF, 0x052A, 0x0474, 0xF880, 0xF7DC, 0x0C2B,
0xF331, 0x0F67, 0xF99D, 0xF702, 0xF8FF, 0xECF4, 0xF54C, 0xF612,
0xF94C, 0xFDCE, 0x0C67, 0xF9FD, 0x0C82, 0x0A04, 0xFADE, 0x1773,
0xFB53, 0x083B, 0xFE49, 0x043A, 0xF912, 0x0312, 0xF8D6, 0xF55A,
0xFAF2, 0xEC23, 0xFE1A, 0xEE73, 0x07B6, 0x03A3, 0x0EC1, 0x0EBB,
0x0A4B, 0xFFFA, 0x0132, 0x05CD, 0xFAA2, 0x0DA5, 0xF7DC, 0xF99F,
0xF757, 0xF860, 0xFAAE, 0xFBAC, 0xFAEB, 0xEED9, 0xFD70, 0xF0C5,
0x080E, 0x0572, 0xFEE1, 0x1F0A, 0xFA6D, 0x17D5, 0x0D6C, 0x04A1,
0x0066, 0x039E, 0xE7D6, 0xF1C1, 0xF563, 0xE479, 0x002D, 0xF70B,
0x03A7, 0x0832, 0x14FA, 0x02C0, 0x0F88, 0xFB99, 0xFD5B, 0x07ED,
0xFD06, 0x1271, 0xFE54, 0x048F, 0xF9BE, 0xF624, 0xEF18, 0xEE9F,
0xEB73, 0xE1AA, 0xF940, 0xF152, 0x079B, 0x17D8, 0x0FB3, 0x212F,
0x0ACD, 0x12A0, 0x0A33, 0x030F, 0x073A, 0x048C, 0xEDFE, 0x03B7,
0xEE4D, 0xE8A9, 0xFBD0, 0xE6E2, 0xF7C5, 0xFD5C, 0x058B, 0xFFC6,
0x1381, 0x07CD, 0x0C00, 0x1D25, 0x0922, 0x105B, 0x07CA, 0xF68F,
0xFF55, 0xF6FF, 0xED1A, 0xF450, 0xDFA9, 0xE77B, 0xF236, 0xE8FF,
0x00D9, 0x09D4, 0xFF5C, 0x1F53, 0x0FF9, 0x123E, 0x1578, 0x158A,
0x0CF4, 0x128C, 0x0966, 0xF71B, 0xF921, 0xE3EC, 0xEDA0, 0xE273,
0xEE7C, 0xF8AF, 0xF970, 0x0318, 0x09F9, 0x0416, 0x0C5F, 0x16E5,
0x07D0, 0x1031, 0x08DC, 0xFE71, 0x0D3D, 0x0AB7, 0x02EB, 0x004F,
0xEBC2, 0xDBB6, 0xE838, 0xDA76, 0xF342, 0xFD51, 0xF5FC, 0x231C,
0x0670, 0x2029, 0x1DBE, 0x0F7A, 0x1132, 0x13D9, 0x0528, 0xFB43,
0x0BC3, 0xE942, 0xFA93, 0xF9E5, 0xF065, 0xF29D, 0xFA8F, 0xE72E,
0xFBFE, 0xF782, 0xFBD1, 0x15F1, 0xFF05, 0x1DF6, 0x0BF4, 0x0AEF,
0x16BE, 0x09FC, 0x060F, 0xFF62, 0xF1FE, 0xDEF6, 0xF029, 0xE43D,
0xF141, 0x0447, 0xF88E, 0x0F77, 0x03DD, 0x0C67, 0x0AFC, 0x0D20,
0x09A9, 0x1758, 0x0333, 0x0E87, 0x0DC6, 0xEF0D, 0x0D1E, 0xF372,
0xF677, 0xF5CD, 0xF64A, 0xE152, 0xFBA1, 0xFBBC, 0xF900, 0x1A89,
0xFCC6, 0x0BB5, 0x0253, 0xFE60, 0x0B7C, 0x08A6, 0x0210, 0x08E6,
0xF713, 0xEDE0, 0x0358, 0xE63D, 0xFD03, 0x00CD, 0xEEEF, 0x0A18,
0xFC97, 0x0572, 0x0555, 0x1909, 0x0447, 0x1CE9, 0x0964, 0xFADE,
0x0665, 0xEA08, 0x0298, 0xF6D4, 0xFE95, 0x01D9, 0xFFF3, 0xF5C0,
0x07D0, 0xF7A6, 0xF972, 0x1058, 0xEBD4, 0x041E, 0xF9E5, 0xFF2F,
0x0A1C, 0x1811, 0x0947, 0x05B5, 0xFEE9, 0xE124, 0xFFB1, 0xE12F,
0xFE59, 0x0392, 0xF4AB, 0x19C6, 0x0162, 0x077C, 0x09FA, 0x097B,
0xF758, 0x15B6, 0xF7D5, 0xF637, 0x0808, 0xEEB7, 0x0840, 0x0AE4,
0x08B2, 0xFC09, 0x0961, 0xE707, 0x0512, 0xF987, 0xF6BE, 0x10BE,
0xE617, 0x0CE6, 0xF6E4, 0xFF05, 0x07F4, 0x0EA6, 0xFB33, 0x03CA,
0xFC2A, 0xDDFD, 0x067A, 0xEFB0, 0x0743, 0x103E, 0x091C, 0x0ED5,
0x06C3, 0xFD16, 0xFC58, 0xFE18, 0xEBB1, 0x1473, 0xEC18, 0x03F8,
0x033A, 0xEF02, 0x09E0, 0x03B8, 0xFFDA, 0xF89C, 0x0995, 0xE514,
0x1570, 0x0D0C, 0x0BB1, 0x1E51, 0xF711, 0xF9AA, 0xECED, 0xEDD5,
0xF2F4, 0x0628, 0xEBDD, 0x0EFB, 0xF582, 0xEF20, 0x11DD, 0xEA13,
0x081B, 0x0B74, 0x02BC, 0x08C5, 0x14C4, 0x05EC, 0x0B5D, 0x1B41,
0xF55B, 0x0EFD, 0xEAAD, 0xE98E, 0xEAF4, 0xE1E2, 0xF39B, 0x010F,
0xFA07, 0x0813, 0x0CD3, 0xEF16, 0x202F, 0x024C, 0x0F3C, 0x1C98,
0xFAFF, 0xFE3F, 0xFBB2, 0xF5A2, 0xF569, 0x11CD, 0xECDC, 0xFF8B,
0xEEF8, 0xDCDB, 0xFCEF, 0xE44F, 0x04B6, 0x0B83, 0x0579, 0x19C4,
0x1C40, 0x06F3, 0x1D2D, 0x16E2, 0xF802, 0x10F5, 0xEA2A, 0xE047,
0xEE3D, 0xEEB1, 0xF26D, 0x0FB1, 0xFA7A, 0xF965, 0x05D8, 0xE4EF,
0x15B2, 0xFEB8, 0x0C6E, 0x1EFD, 0xFD4C, 0x0F4B, 0x09A1, 0xF848,
0xFF79, 0x0672, 0xE00C, 0xF8A8, 0xEA3B, 0xDC96, 0xFE6F, 0xFCCC,
0x03B4, 0x1697, 0x0E28, 0x029D, 0x1627, 0xF86F, 0x137D, 0x0D9B,
0xFB55, 0x1C1C, 0xF154, 0xF155, 0xF988, 0xE384, 0xEDB5, 0x08CE,
0xEB6B, 0xF880, 0x04CE, 0xEFB6, 0x1AC6, 0x18B6, 0x17B1, 0x1AD7,
0x06FE, 0xF615, 0x009C, 0xEB3E, 0xF703, 0x0552, 0xE189, 0x08F5,
0xE8B7, 0xE801, 0xFFE9, 0xF511, 0xFBDD, 0x1705, 0x04D3, 0x0236,
0x2191, 0x01AF, 0x1FDE, 0x2076, 0x07C2, 0x0875, 0xF41E, 0xD9F9,
0xEDED, 0xDB39, 0xE406, 0x0693, 0xDF29, 0x0C98, 0x00A8, 0xF6BE,
0x1C73, 0x14E5, 0x1293, 0x1B52, 0x0E7D, 0xF367, 0x1112, 0xFA94,
0x0047, 0x0E16, 0xEC58, 0xF217, 0xE950, 0xD48D, 0xEE2D, 0xEEB8,
0xEC13, 0x1FAC, 0xFD2A, 0x1B3E, 0x28FD, 0x07D7, 0x2E82, 0x1CD2,
0x0AAF, 0x0796, 0xFCAE, 0xD5CA, 0xF563, 0xEE71, 0xE8FF, 0x07AF,
0xE66A, 0xEE50, 0xEF6B, 0xEA80, 0x02A4, 0x1344, 0x042E, 0x3002,
0x1084, 0x0A52, 0x25D3, 0xF55B, 0x0B4A, 0x0864, 0xEB8B, 0xEA07,
0xF23F, 0xD78B, 0xF98C, 0x03F8, 0xF1E3, 0x1834, 0xF51F, 0x0033,
0x0F02, 0xFE9F, 0x1D14, 0x1F94, 0x0BC1, 0x182C, 0x09D3, 0xE085,
0x09C2, 0xE37B, 0xE7A8, 0x026F, 0xE296, 0xEB04, 0xFB98, 0xF890,
0x0142, 0x2B15, 0x0049, 0x1F10, 0x0672, 0xF6A4, 0x1585, 0xEDA6,
0x0A29, 0x04E3, 0xF0F5, 0xFA8E, 0xFCE2, 0xD975, 0x036D, 0xFD92,
0xEEF1, 0x17E4, 0xF2E4, 0xFE7B, 0x0DF7, 0x118C, 0x1770, 0x2D47,
0x1041, 0x03E9, 0x09B5, 0xCC8F, 0xFF1E, 0xD926, 0xE565, 0x0493,
0xE1A7, 0xFEF6, 0x04C5, 0xFC04, 0x07F5, 0x29E5, 0xF147, 0x230B,
0x039C, 0xF7AA, 0x1AFD, 0x09C4, 0x1404, 0x0DCC, 0x01F9, 0xDE57,
0xFA4F, 0xC7DB, 0xF6B1, 0xF1F4, 0xE628, 0x2099, 0xF1A9, 0x0CE7,
0x12BF, 0x0F0C, 0x0E0B, 0x2C3A, 0x0318, 0x0045, 0x1428, 0xDA6B,
0x0F80, 0xF5C2, 0xF3A2, 0xF9DB, 0xEB5B, 0xDE21, 0xF599, 0xEC6E,
0xF941, 0x22F6, 0xECCF, 0x30F4, 0xFAD2, 0x05DD, 0x188E, 0x0284,
0x0E3E, 0x103A, 0x05D9, 0xDFDC, 0x0F65, 0xD6E7, 0x055B, 0x0933,
0xF1BD, 0x0B8B, 0xED72, 0xF290, 0xFFFC, 0x0239, 0xFC2F, 0x2A76,
0xEFA0, 0x14B2, 0x0E96, 0xE19E, 0x183E, 0xF2D1, 0xF5A4, 0xF6F7,
0xF57B, 0xDB48, 0x0867, 0x0205, 0xFE36, 0x32DB, 0xF2EC, 0x1AA2,
0xF444, 0xF00A, 0xFADA, 0xF644, 0xF8D9, 0x103C, 0x0024, 0xF550,
0x1EFA, 0xD89B, 0x1632, 0x0132, 0xF516, 0x0890, 0xFB38, 0xF33C,
0x0728, 0x200A, 0xFFBD, 0x3054, 0xF303, 0xF6F6, 0xF729, 0xCED9,
0xFE16, 0xE626, 0xF12C, 0x021B, 0xFEB0, 0xED31, 0x1715, 0xFE08,
0x034D, 0x2E7D, 0xEC36, 0x174D, 0xF977, 0xFB73, 0x018A, 0x12AB,
0xF6F4, 0x08FF, 0xF90E, 0xD71B, 0x0B92, 0xCCC7, 0x112C, 0xFBCC,
0xFD65, 0x1708, 0x03E7, 0xFFE5, 0x1335, 0x14A0, 0xF6DA, 0x2BD8,
0xEE8A, 0xF200, 0x0163, 0xDEDB, 0xFA09, 0xFEE8, 0xF1BC, 0xEEA0,
0xFFF5, 0xD511, 0x1019, 0xF121, 0x03DA, 0x2D30, 0xF08E, 0x2BF4,
0xFA68, 0x0051, 0x026A, 0x0C6A, 0xF07C, 0x066D, 0xF2E4, 0xD52F,
0x0DCB, 0xE6F1, 0x131C, 0x11B2, 0x0B8E, 0xFCE9, 0x0BD3, 0xE7A9,
0x0B93, 0x0D3E, 0xF398, 0x2E9A, 0xE6DC, 0x07E8, 0x02B6, 0xE2CC,
0xFB19, 0xF660, 0xDFA2, 0xE76D, 0xFCD9, 0xD6CA, 0x1B2F, 0x10EF,
0x1221, 0x31F0, 0x01A3, 0x0F95, 0xF905, 0xF229, 0xF139, 0x0404,
0xE7AA, 0x1372, 0xF565, 0xE933, 0x0DC5, 0xE0B0, 0x0964, 0x088D,
0x068C, 0xF91B, 0x1F44, 0xF280, 0x20AC, 0x2B76, 0x036C, 0x2E55,
0xEDE8, 0xEED2, 0xED43, 0xD835, 0xECCB, 0xF340, 0xDD2C, 0xF549,
0xF082, 0xDF7C, 0x1831, 0x068E, 0x1353, 0x2F22, 0x08E1, 0x0D4C,
0x0CCD, 0x0994, 0xFEDE, 0x2334, 0xECF5, 0x01FE, 0xF085, 0xD136,
0x0274, 0xD5E9, 0xFC4C, 0x01E3, 0xF887, 0x0433, 0x2005, 0xF826,
0x2E16, 0x256B, 0x0505, 0x29E2, 0xF42E, 0xF2D4, 0xFC50, 0xF449,
0xEDC9, 0x044B, 0xE476, 0xDF04, 0xEE4B, 0xCA49, 0xFC37, 0xF718,
0x02BE, 0x2EB7, 0x0D38, 0x2251, 0x1D1D, 0x0C57, 0x088B, 0x2311,
0xEA2E, 0x0375, 0xF5A1, 0xD4B4, 0x0B00, 0xF720, 0x07D7, 0x0988,
0xFAF0, 0xE377, 0x0741, 0xE212, 0x19A4, 0x173C, 0x082C, 0x2F3C,
0xFC12, 0x074F, 0x0619, 0xF85A, 0xEF71, 0x01BE, 0xD8A6, 0xDACC,
0xF700, 0xD834, 0x0A42, 0x157D, 0xFFAA, 0x21CF, 0x05BB, 0x012B,
0x1189, 0xFB81, 0x04FE, 0x195B, 0xEE92, 0x17D1, 0xFB2F, 0xE757,
0x0D5D, 0xF0FE, 0xFDE5, 0x0611, 0xFB7A, 0xDEB0, 0x0FD4, 0xF00D,
0x1535, 0x2B49, 0x0976, 0x1CC0, 0xFEA3, 0xEDF0, 0xFAB9, 0xEC66,
0xE930, 0x0197, 0xD89B, 0xED52, 0xF265, 0xDD9D, 0x0DA7, 0x0E0D,
0xFDC4, 0x1ACC, 0xFEAF, 0xF8CC, 0x167A, 0x15FA, 0x0D5B, 0x3134,
0xF9B9, 0x025B, 0xF9AB, 0xD92C, 0x00C4, 0xE6FB, 0xF6A8, 0x019B,
0xF823, 0xEEA8, 0x18F6, 0xEEA4, 0x14B1, 0x1E0B, 0xF6FA, 0x11A4,
0x01AF, 0xF7AB, 0x0ADB, 0x14BA, 0xF2C3, 0x0E29, 0xDFBA, 0xD6B0,
0xE928, 0xC835, 0xF9BE, 0xFB67, 0xFB8C, 0x1F06, 0x0615, 0x04FF,
0x1415, 0x0A2E, 0x01C7, 0x2A54, 0xF44D, 0x037F, 0x088D, 0xECD6,
0x0F63, 0x1271, 0x014C, 0xFF99, 0xF988, 0xCD36, 0x06C1, 0xDAFC,
0x0C7D, 0x1127, 0xF691, 0x187F, 0xFB8B, 0xFB6A, 0x0B53, 0x0EDE,
0xF18F, 0x0F67, 0xE2A8, 0xDA61, 0xF9DA, 0xE76D, 0x0394, 0x18DE,
0xFAF3, 0x0A88, 0x01CB, 0xE83E, 0x0A5D, 0xF778, 0xF60B, 0x1E88,
0xEC86, 0x1187, 0x0BED, 0xF5B0, 0x183E, 0x0F41, 0x0015, 0x041F,
0xFFD5, 0xD3F7, 0x1157, 0xF64D, 0x0C62, 0x1ED7, 0xFC0B, 0xFAE3,
0xF537, 0xDE14, 0xF4C5, 0xF9B1, 0xE67E, 0x13DB, 0xE5E8, 0xF12E,
0x0203, 0xE9D8, 0x06E0, 0x1637, 0xF731, 0x02D1, 0x0397, 0xED35,
0x14B8, 0x1A08, 0x025B, 0x21A0, 0xEE75, 0xF003, 0xF95E, 0xE420,
0x0608, 0x0D01, 0x017C, 0x113F, 0x0890, 0xE745, 0x1B26, 0xF310,
0x0939, 0x1366, 0xF23A, 0xF30E, 0x02D1, 0xED0C, 0x018D, 0x17C6,
0xE45C, 0x086F, 0xDDA4, 0xDAA2, 0xF2C0, 0xE0CE, 0xFCA3, 0x10C4,
0xF931, 0x138E, 0x0ABD, 0xEFBF, 0x141E, 0x0C37, 0xFB69, 0x1B93,
0xF2B3, 0xEB49, 0x048B, 0xF97E, 0x061A, 0x26C0, 0x0318, 0x0635,
0x0B4C, 0xD509, 0x109D, 0xE918, 0x0595, 0x1057, 0xF3ED, 0xFCDD,
0x0152, 0xEBC3, 0x0780, 0x0FE6, 0xE2BE, 0x013A, 0xDB8C, 0xD7CD,
0xF8CB, 0x0417, 0x062E, 0x27A2, 0x03FE, 0xFFE3, 0x063B, 0xE2E9,
0x07D8, 0xFEEA, 0xF456, 0x1A41, 0xF55E, 0xF920, 0x10EF, 0xF5BA,
0x07EE, 0x1C8A, 0xF615, 0xFC93, 0x0F72, 0xE366, 0x22BF, 0x12E6,
0x0D5A, 0x1A4F, 0xF5BA, 0xE698, 0xF331, 0xD5F4, 0xF207, 0xFE6F,
0xE379, 0x093F, 0xE608, 0xE37B, 0xF9AB, 0xF99B, 0xFA6C, 0x2264,
0x011B, 0xFEE9, 0x169C, 0xFB06, 0x13D7, 0x2798, 0xFBEB, 0x1114,
0xEF56, 0xDBA6, 0xFE60, 0xE37C, 0x0550, 0x1308, 0xFC6E, 0x08C4,
0x0DA2, 0xE8BA, 0x212D, 0x0E38, 0x0D73, 0x1761, 0xF918, 0xE985,
0x0185, 0xF448, 0xF81D, 0x1322, 0xDE2A, 0xF3D8, 0xE1C4, 0xCE22,
0xF156, 0xEA89, 0xF10A, 0x1AE3, 0xFE28, 0x0FF0, 0x1EFD, 0x0070,
0x1C56, 0x24E5, 0xFBDB, 0x12F2, 0xF97F, 0xDF1C, 0x0460, 0x0138,
0x01FB, 0x1E5C, 0x0047, 0xF224, 0x03C2, 0xD3D1, 0x0836, 0xF8AC,
0x0571, 0x1CDA, 0x03BE, 0xFC92, 0x0874, 0xF510, 0xFAAE, 0x119B,
0xDB64, 0xEBCB, 0xE012, 0xD678, 0xFABF, 0x0ED0, 0xF9E6, 0x1C06,
0xF7F7, 0xEEC4, 0x0B32, 0xED4C, 0x12EE, 0x1BE3, 0x0117, 0x20C2,
0x02FD, 0xF359, 0x1066, 0xFC19, 0xFC1B, 0x14FD, 0xF901, 0xEC3E,
0x14AF, 0xEAC0, 0x1203, 0x16B9, 0xFF09, 0x0AED, 0xFB9E, 0xE437,
0xFD6D, 0xE7EF, 0xF23E, 0x0E61, 0xE34E, 0xFF2C, 0xE852, 0xD8DD,
0xF5B4, 0x01DF, 0xF97E, 0x17F9, 0x015E, 0xEFAF, 0x1079, 0x0443,
0x1046, 0x3102, 0x019B, 0x1083, 0xFAA0, 0xE219, 0x0209, 0xF202,
0xFCC1, 0x0F7A, 0xF7D7, 0xF7C3, 0x1523, 0xEB97, 0x1CD1, 0x138F,
0xFDD1, 0x05EC, 0xF9DB, 0xE437, 0x0545, 0x0A03, 0xF9A5, 0x1C8E,
0xE6C4, 0xED23, 0xE55D, 0xCB08, 0xEA81, 0xEE0B, 0xEC71, 0x1642,
0x05C9, 0x00A4, 0x1DC6, 0x0516, 0x0E0C, 0x2898, 0xF9BF, 0x09DA,
0x0366, 0xF117, 0x0EAD, 0x1892, 0x0546, 0x1718, 0xFBEF, 0xE01B,
0x017F, 0xD60F, 0x06F4, 0x0551, 0x01D2, 0x1413, 0x0259, 0xEE15,
0x03F0, 0xFCD0, 0xF4D0, 0x17D5, 0xEAE8, 0xEC4D, 0xF4DB, 0xE8AE,
0xF7E3, 0x11C1, 0xEE16, 0x048F, 0xF39F, 0xE40D, 0x0AD2, 0xF59E,
0x0A3B, 0x20E1, 0xF964, 0x1153, 0x05B7, 0xF316, 0x159D, 0x13F1,
0x089E, 0x1732, 0x06FC, 0xEB8F, 0x1381, 0xF71C, 0x0580, 0x15B1,
0xF8C6, 0xFE3E, 0xFCA3, 0xDB66, 0xF55F, 0xE910, 0xE771, 0x0CAB,
0xEAA1, 0xFC15, 0xFE90, 0xEC22, 0x00F5, 0x1340, 0xF2F9, 0x0622,
0xF8A7, 0xE5C1, 0x083A, 0x1413, 0x09BF, 0x2BF4, 0xFB24, 0xFA9F,
0xF37E, 0xDAC4, 0xFEF7, 0xFEA2, 0x0647, 0x1AF6, 0x1239, 0xFC47,
0x2402, 0xFBDC, 0x112A, 0x137B, 0xF2C3, 0xF517, 0xFB54, 0xE9B8,
0xFF3A, 0x0DAD, 0xE867, 0x05CE, 0xDDA7, 0xDCC6, 0xEA8B, 0xDB04,
0xF7AA, 0x05EB, 0xF962, 0x14A8, 0x0973, 0xF612, 0x145D, 0x0B70,
0x0164, 0x268B, 0xFAF9, 0xFD05, 0x03F0, 0xF33F, 0x013A, 0x1210,
0x00D5, 0x090D, 0x0AE9, 0xE7EC, 0x16E1, 0xEDE3, 0x1083, 0x1396,
0xFF32, 0x0549, 0xFE3E, 0xE808, 0xFC30, 0x075C, 0xEC10, 0x05E4,
0xE66D, 0xD849, 0xF195, 0xEF69, 0xF9AC, 0x18B4, 0xF8AA, 0x0234,
0x0005, 0xEB05, 0x0D09, 0x051D, 0x007F, 0x20F2, 0xF4F1, 0x089D,
0x0973, 0xF630, 0x0F64, 0x0D55, 0x0254, 0xFC8C, 0x111C, 0xEA92,
0x1FD7, 0x10BE, 0x0F52, 0x1F68, 0xFF52, 0xFB5C, 0xF6F9, 0xDCE2,
0xE87E, 0xF33A, 0xE09C, 0x0A95, 0xEDFB, 0xEAA3, 0xFFFE, 0xE7FC,
0xFCC7, 0x0C76, 0xF8FB, 0xFE0E, 0x0C3F, 0xF947, 0x16C6, 0x2A10,
0x08A3, 0x272C, 0xF43B, 0xF215, 0xF1C5, 0xE4C9, 0x00FB, 0x03DB,
0x08B5, 0x0893, 0x1698, 0xED91, 0x2489, 0x06C6, 0x10B3, 0x1BA5,
0x01E5, 0xF80A, 0x0755, 0xFA62, 0xF3EE, 0x109E, 0xD9C9, 0xFB1B,
0xDCA4, 0xDB08, 0xF25E, 0xE023, 0xF8B0, 0x0272, 0xF793, 0x0318,
0x10A3, 0xFB8B, 0x1DF7, 0x229C, 0x0BA2, 0x2752, 0x0379, 0xFA3A,
0x006A, 0xFD75, 0xF928, 0x1464, 0x0222, 0xFDA7, 0x1133, 0xE13B,
0x1437, 0xF129, 0x089C, 0x126A, 0x0462, 0x0361, 0x0C56, 0xF9AD,
0xFDE6, 0x14EE, 0xE152, 0xF8F9, 0xE09A, 0xDA94, 0xF455, 0xFEDE,
0xFC87, 0x0EC9, 0xF732, 0xEE54, 0xFE23, 0xE605, 0x0E60, 0x0F58,
0x08A6, 0x268B, 0x054F, 0x0CF9, 0x0E96, 0x037A, 0x0074, 0x0C5C,
0xFBE1, 0xF630, 0x1B2B, 0xF1D3, 0x20FC, 0x1021, 0x03AC, 0x09E0,
0xF765, 0xEA5C, 0xFB04, 0xE78C, 0xF22C, 0x0635, 0xE684, 0x0AB1,
0xEE2D, 0xE6F0, 0xFB13, 0xF52E, 0xFA30, 0x0DEC, 0x0058, 0xF06B,
0x0D3C, 0xF651, 0x0783, 0x1FC2, 0xFD75, 0x17AC, 0xFA58, 0xF57B,
0xFF6B, 0xF7E2, 0x049B, 0x0C7C, 0x04D5, 0xFFCD, 0x1969, 0xF609,
0x27EE, 0x1307, 0x0E01, 0x0B97, 0xF972, 0xE6C0, 0xF960, 0xF9A3,
0xECC3, 0x1147, 0xDEAE, 0xFA08, 0xE664, 0xE0C0, 0xF68A, 0xE95F,
0xF4E7, 0x05E1, 0xFA86, 0x0252, 0x16DF, 0xFE8D, 0x12A3, 0x191E,
0xF5E0, 0x0D5B, 0xFB95, 0xF6A5, 0x06BC, 0x0C46, 0x0159, 0x169E,
0x0728, 0xF731, 0x1158, 0xE6B8, 0x1667, 0x0675, 0x0FFD, 0x1511,
0x057D, 0xF38F, 0x00B6, 0xF14C, 0xECF1, 0x091E, 0xDD96, 0xF38C,
0xEEB0, 0xEB1E, 0xFE76, 0x0A2D, 0xF7BC, 0x05B4, 0xF168, 0xED3B,
0x0281, 0xF46A, 0x0F5D, 0x0F28, 0xFC5D, 0x0EAA, 0xF9F5, 0xF812,
0x0A6D, 0x05D3, 0x03D9, 0x1234, 0x0AAA, 0xF9F6, 0x2456, 0xFD47,
0x1B69, 0x169B, 0x01C7, 0x0C83, 0xF9C9, 0xEA28, 0xF651, 0xE178,
0xE6B0, 0xF8B9, 0xD8FA, 0xF962, 0xEC9D, 0xECC7, 0x066A, 0x072D,
0x01CB, 0x0BDC, 0x004B, 0xEF93, 0x0A71, 0x0519, 0x0377, 0x2006,
0xF55A, 0x0547, 0xF0DF, 0xE6E4, 0xF7AE, 0xF28D, 0xFEE5, 0x0B25,
0x0A6E, 0x00CB, 0x297C, 0x01A5, 0x308B, 0x1AA0, 0x0CFF, 0x0724,
0xFA2B, 0xEDC3, 0xF6B2, 0xFB3B, 0xE057, 0xFEC2, 0xCD85, 0xE76D,
0xD9D5, 0xDDA0, 0xF906, 0xF629, 0x036B, 0x0A3D, 0x090C, 0x0047,
0x1BBE, 0x062E, 0x0BA3, 0x1B36, 0xEF10, 0x05FD, 0xF894, 0xF15E,
0xFD56, 0x047D, 0xF1EE, 0x08F6, 0xFC34, 0xF4B0, 0x17F0, 0xF35C,
0x2AE7, 0x0F4B, 0x1D67, 0x12E1, 0x0575, 0xF4F6, 0xFAE7, 0xF872,
0xE5A9, 0x0072, 0xD496, 0xE426, 0xE36F, 0xE798, 0xF301, 0x0877,
0xF4EF, 0x0699, 0xFF41, 0xF51D, 0x16A4, 0xFE10, 0x17D0, 0x11F3,
0xF9B2, 0x0978, 0xF93E, 0xF78A, 0x0BEC, 0x0369, 0xFF65, 0x02F4,
0xFF06, 0xF253, 0x1944, 0x068F, 0x1E11, 0x1CA3, 0x10D6, 0x0DE5,
0x0553, 0xF030, 0xF85C, 0xE901, 0xE4C3, 0xF946, 0xD838, 0xF110,
0xEB61, 0xEA42, 0xFF27, 0x04F9, 0xF72B, 0x0622, 0xFDF5, 0xF9D0,
0x157A, 0x1000, 0x1096, 0x1D49, 0xF974, 0x0232, 0xF0FB, 0xEB14,
0xFD2D, 0xF85C, 0x06C3, 0x0431, 0x08F1, 0xF8E6, 0x1DC2, 0x04CA,
0x27A8, 0x1CB0, 0x1244, 0x0B51, 0x09A9, 0xF8A0, 0x001C, 0xFE89,
0xDAC7, 0xFA11, 0xC5AF, 0xE9A9, 0xDCEF, 0xE52E, 0xFF6A, 0xF7E2,
0x0399, 0x03F1, 0x0588, 0x006E, 0x1D5A, 0x10EA, 0x19B2, 0x1BF5,
0x0130, 0x029E, 0xFC97, 0xF531, 0xF43B, 0x0513, 0xEC57, 0x0629,
0xFE01, 0xF333, 0x185A, 0xF757, 0x27C4, 0x0F33, 0x1CCA, 0x0EF0,
0x0D70, 0xFFCB, 0x0B27, 0x0346, 0xF043, 0xFC6C, 0xCB69, 0xE640,
0xD3E4, 0xF1A8, 0xF005, 0x047F, 0xF618, 0xFDA4, 0xFE03, 0xF5E0,
0x15E9, 0x0223, 0x1CAA, 0x136C, 0x0C26, 0x0AB2, 0x09E5, 0xFF04,
0x0A17, 0x0739, 0xF393, 0x01B8, 0xF3AA, 0xF582, 0x1413, 0x0299,
0x1989, 0x1059, 0x082C, 0x0698, 0x0329, 0xF74F, 0x03F7, 0xF8CA,
0xFCD0, 0xFC24, 0xE66D, 0xF15D, 0xE093, 0xF79D, 0xF368, 0x081E,
0xF860, 0xFB76, 0xFC2F, 0xF46B, 0x09B2, 0x08E5, 0x0405, 0x118A,
0xF942, 0x0215, 0x03BA, 0xF7EB, 0x0FDB, 0x010D, 0x08F5, 0x018F,
0x01D8, 0xFE98, 0x1573, 0x0CF6, 0x25AA, 0x0FD4, 0x10DF, 0xFE6D,
0xFC8C, 0xF8EC, 0xF773, 0xFF8F, 0xE628, 0xFA4D, 0xDAEE, 0xEED3,
0xE7F4, 0xF317, 0xF735, 0x010F, 0xFDF7, 0x0060, 0x0887, 0xFCCB,
0x145D, 0x096C, 0x0B80, 0x0A23, 0xF923, 0xFBC3, 0xF8FC, 0xFE50,
0xFC60, 0x0868, 0xF581, 0x02FA, 0xFB33, 0xF872, 0x11DA, 0x0303,
0x21B4, 0x0DD0, 0x1FEB, 0xFF65, 0x1277, 0xFB05, 0x0307, 0x031D,
0xEE8C, 0xF7F2, 0xD8A0, 0xF1A5, 0xDC27, 0x003C, 0xE825, 0x056F,
0xE7E1, 0xFCE1, 0xFAFF, 0xF819, 0x151F, 0xFE1F, 0x1331, 0xFFC5,
0x089E, 0xF65A, 0x0B39, 0x008D, 0x0998, 0x115B, 0xFCDE, 0x078A,
0xFC63, 0x0065, 0x083F, 0x0A1C, 0x0928, 0x0C45, 0x0513, 0xFE18,
0x0C44, 0xF0F0, 0x088E, 0xF1DA, 0xF255, 0xEF31, 0xE5A3, 0xF19C,
0xEDDE, 0x0A84, 0xFAC8, 0x1470, 0xF96A, 0x01C9, 0xF805, 0xFBFB,
0xFE86, 0x068D, 0xFB2C, 0x0105, 0xF950, 0xEF1C, 0x0636, 0xF07F,
0x0C4B, 0x004A, 0x02D8, 0x025F, 0x0806, 0x0735, 0x1EB2, 0x17F2,
0x1F04, 0x12A1, 0x0976, 0x0129, 0xFC76, 0xFC92, 0xF393, 0xF598,
0xDF84, 0xE88E, 0xD600, 0xE79E, 0xE86E, 0xFBDD, 0xF810, 0x0C43,
0xFE8D, 0x0468, 0x0D58, 0x000A, 0x12AD, 0x0C80, 0x07F4, 0x092B,
0x00D0, 0xF6A4, 0x0251, 0xF683, 0xFB57, 0xFFD4, 0xEE03, 0xFD48,
0xF823, 0x0045, 0x1512, 0x11AF, 0x2009, 0x0EF9, 0x1337, 0xFA2A,
0x0A02, 0xFC4C, 0x0681, 0x0064, 0xF540, 0xEDAB, 0xE228, 0xEA44,
0xDD13, 0xFFB0, 0xDD13, 0x0DD8, 0xE5E3, 0x08D5, 0xFFEF, 0x0065,
0x119B, 0x00AC, 0x0AF5, 0xFCE3, 0x06CA, 0xF3A7, 0x12BF, 0xF86F,
0x1793, 0x024F, 0x0667, 0xFEFB, 0xF79E, 0x051B, 0xFD0D, 0x1A76,
0x0234, 0x1726, 0x01B5, 0xFB04, 0x05D5, 0xF3CF, 0x0437, 0xF898,
0xFAAC, 0xE9EC, 0xF6A9, 0xE7AA, 0xFA6F, 0xFF1F, 0xF80D, 0x0CFD,
0xF0A6, 0x0BEB, 0xF397, 0x0C4B, 0xF6A2, 0x0D57, 0xF326, 0xFED3,
0xF9B2, 0xEE6B, 0x0BBC, 0xF66E, 0x1631, 0xFD88, 0x1322, 0xF56C,
0x0F05, 0xFE86, 0x116D, 0x1877, 0x0FD3, 0x191D, 0x0301, 0x056E,
0xF60C, 0xFFFC, 0xE76A, 0xFD4A, 0xDEA9, 0xED3F, 0xED92, 0xE69B,
0x0000, 0xF827, 0x02FF, 0x0575, 0x0255, 0x0306, 0x075D, 0x0973,
0x0A54, 0x11E8, 0x0073, 0x05FF, 0xF8A9, 0xF824, 0xFA7E, 0xFD3A,
0xF836, 0x02B9, 0xFE0F, 0xF4EA, 0x1165, 0xF53B, 0x1A10, 0x0FBD,
0x11B0, 0x117B, 0x0A74, 0x00A8, 0x081E, 0x04B9, 0xFBE5, 0x0462,
0xE963, 0xF163, 0xE64F, 0xEEBD, 0xEB72, 0xFD71, 0xEA46, 0x035B,
0xF3AB, 0xFD35, 0x0549, 0xFEB6, 0x0790, 0x09AD, 0x0031, 0x04B7,
0x0208, 0xF903, 0x0E4D, 0xFF63, 0x1291, 0x064B, 0x0881, 0xFC4C,
0x090E, 0xFB15, 0x0A05, 0x1025, 0xF979, 0x1026, 0xF6C2, 0xF8D0,
0x021C, 0xFCEC, 0xFC63, 0x0303, 0xEF90, 0xF265, 0xF755, 0xF17E,
0x07B4, 0x0149, 0x0853, 0x0736, 0x00E8, 0x02D2, 0xFD4F, 0x0311,
0xF131, 0x084D, 0xE018, 0xFE57, 0xE904, 0xF215, 0x049C, 0xFD4A,
0x1127, 0x018B, 0x0DFD, 0xF8DD, 0x13C1, 0x002D, 0x2575, 0x0F55,
0x20F2, 0x11C4, 0x0638, 0x03BC, 0xF188, 0xFE4C, 0xDDA9, 0x0461,
0xD3DF, 0xF554, 0xE2B2, 0xEC0D, 0xF964, 0xFC23, 0x0753, 0xFEC5,
0x08F9, 0xFAED, 0x0A8A, 0xFF7C, 0x0F92, 0x0521, 0x069A, 0x03E1,
0xF508, 0xFE6C, 0xF234, 0x0C6D, 0xF560, 0x1077, 0xF83E, 0xF767,
0x079D, 0xF71C, 0x146C, 0x0BE1, 0x18D2, 0x065D, 0x17DD, 0xF5CD,
0x0572, 0xF601, 0xF023, 0xFB2A, 0xE677, 0xFD60, 0xEA23, 0x03E4,
0xF14C, 0x0BEF, 0xF24B, 0x0A89, 0xFAE3, 0xFDE7, 0x03CA, 0xF7C1,
0x02D8, 0xF924, 0xFFC5, 0xF64C, 0xFCB0, 0xF472, 0xFF1A, 0xFA2F,
0x02DB, 0x03B9, 0x01DF, 0x0295, 0x0B37, 0x07AC, 0x12E5, 0x1A99,
0x0B3D, 0x112D, 0x0D83, 0xFD61, 0x09AA, 0xFD74, 0xEF90, 0xF595,
0xDF72, 0xEA6F, 0xE2AA, 0xF542, 0xF3F6, 0x04D1, 0x0137, 0xFDA6,
0xFD76, 0xF591, 0xFB8A, 0x009F, 0xFCD4, 0x0BB7, 0xFE91, 0x051B,
0x0603, 0xF949, 0x0A42, 0x029C, 0x0576, 0x0864, 0x0108, 0xFDC4,
0x0298, 0xFA72, 0x055F, 0xFDEB, 0x0B29, 0x0265, 0x0A24, 0xF85C,
0xF5A7, 0xF17B, 0xE2BB, 0xFC10, 0xE930, 0xFFE4, 0xFCFC, 0x0658,
0x0296, 0x0A73, 0x0060, 0x07AE, 0x031C, 0x050F, 0xFEB7, 0xFC4B,
0xF3E7, 0xF038, 0xEB94, 0xE44F, 0xF3FD, 0xF018, 0x0198, 0x05B1,
0xFB46, 0x0315, 0xFDD3, 0x0240, 0x17DD, 0x154C, 0x231E, 0x1AFD,
0x1682, 0x06AD, 0x0A07, 0xFF22, 0xFDE9, 0xFDE5, 0xEA17, 0xED79,
0xD5BF, 0xE2AA, 0xD419, 0xE7BA, 0xEAB5, 0x04C2, 0xFF82, 0x1139,
0x04C6, 0x0172, 0x079B, 0x00F5, 0x0E67, 0x03B2, 0x0FE8, 0x0201,
0x0920, 0xFB3A, 0x04A8, 0xFDEF, 0x01DA, 0x062E, 0xF9F8, 0xFA3B,
0xEF4E, 0xF8BB, 0xEBF5, 0x0063, 0x020D, 0x0553, 0x1ABB, 0x07FA,
0x0BE9, 0xF8FC, 0xF142, 0xECA3, 0xF4D4, 0xF8C8, 0x084B, 0x0FDE,
0x0C63, 0x0E4E, 0xFD85, 0x00B0, 0xF360, 0x0324, 0xF13B, 0x0490,
0xE600, 0xF4DA, 0xE056, 0xE08B, 0xF9C0, 0xF1BD, 0x17E4, 0x0359,
0x15AF, 0xFA0F, 0x0E9D, 0x068E, 0x1EC9, 0x1627, 0x2732, 0x1BE7,
0x11F7, 0x12C2, 0xF74A, 0x006E, 0xE4E5, 0xFF7C, 0xD675, 0xF3D3,
0xD226, 0xE11B, 0xDF1D, 0xE22F, 0x0081, 0xF915, 0x1F3E, 0x0857,
0x1B73, 0x030D, 0x0C04, 0x0C09, 0x0BF8, 0x124B, 0x04FB, 0x07EB,
0xF1F2, 0xFE6F, 0xE4D4, 0xFB6D, 0xEA07, 0xFAA1, 0x0015, 0xFD91,
0x0AFA, 0x0086, 0x0694, 0xED94, 0x0F92, 0xF9C5, 0x21BD, 0x1ACE,
0x1686, 0x0989, 0xF035, 0xF7EE, 0xE190, 0xFC06, 0xF063, 0x0726,
0xF42F, 0x0BDE, 0xF2D5, 0xFAF5, 0x02EB, 0xFCE3, 0x0B28, 0x03D1,
0xFC34, 0xF401, 0xED74, 0xE87B, 0xF7E3, 0xF67F, 0x1248, 0x093D,
0x0E6E, 0x016E, 0xFAA5, 0xFF72, 0x0488, 0x1319, 0x13F8, 0x187C,
0x12D0, 0x07B4, 0x09B7, 0x0265, 0xFE19, 0x0615, 0xF2C0, 0xF6F3,
0xE2C1, 0xEA88, 0xDBE2, 0xE720, 0xF2ED, 0xF532, 0x0DEE, 0x07A3,
0x1086, 0x00A4, 0x0422, 0x05DD, 0xFD9F, 0x0B17, 0x07A6, 0x0A9F,
0x0CBF, 0x1131, 0x023F, 0xFDE0, 0xFA3B, 0xF753, 0xFA7F, 0x0696,
0x0089, 0xFEF3, 0x0094, 0xEBD7, 0x0097, 0xF229, 0x1227, 0x0BC4,
0x0E78, 0x0D84, 0xEDD2, 0x024A, 0xEDCB, 0x055C, 0x0769, 0x118A,
0x0870, 0x0DDC, 0xFC81, 0xF70A, 0xFC5E, 0xF476, 0x0341, 0xFBCA,
0xFEE7, 0xEF55, 0xE5D8, 0xDF77, 0xE18A, 0xF1E1, 0x00C3, 0x1299,
0x1001, 0x0B84, 0x093F, 0x0D00, 0x0EAB, 0x196C, 0x2165, 0x0971,
0x1E6B, 0x0505, 0x05D6, 0xFF4E, 0xFAD5, 0xF44B, 0xED5D, 0xF649,
0xD97A, 0xF3A0, 0xD66C, 0xF1C2, 0xE123, 0xFE49, 0x0022, 0x0EE1,
0x1F83, 0x0AB4, 0x19E0, 0xFECF, 0x0B41, 0xFB64, 0x110F, 0x01AB,
0x0C9E, 0x07E2, 0xFBB9, 0xFB62, 0xF400, 0xFB5A, 0xF2D1, 0x0C02,
0xF172, 0x0EC1, 0xE91D, 0xF65C, 0xF4A7, 0xE9B5, 0x17D6, 0x08D0,
0x2185, 0x0530, 0x0B84, 0xED67, 0xF8BB, 0xFC5D, 0x0321, 0x0E87,
0x0B87, 0x16B1, 0xF0FE, 0x05F7, 0xE4D5, 0xFBD9, 0xF01A, 0x039D,
0xEB8B, 0xEFF4, 0xE621, 0xE052, 0xF818, 0xEB50, 0x1B9D, 0xFFA3,
0x2BB8, 0x0A60, 0x1A07, 0x11AD, 0x0DBC, 0x1B47, 0x0DDA, 0x17AD,
0x007F, 0x0F48, 0xEE30, 0xFC03, 0xE3CF, 0xEFAF, 0xE433, 0xF027,
0xF07A, 0xEE31, 0xF55C, 0xEC95, 0xFDA5, 0xF212, 0x17DB, 0x12FC,
0x227B, 0x196B, 0x111A, 0x021F, 0xF621, 0xFB41, 0xEC91, 0xF895,
0xF3B9, 0x04DF, 0xF3EB, 0xFC29, 0xF997, 0xF091, 0x0880, 0x0ED8,
0x0F1B, 0x16F3, 0x0741, 0xFCC1, 0xFD8B, 0xF329, 0x07F7, 0x05BC,
0x1106, 0x000A, 0xF4D5, 0xE907, 0xDBF4, 0xEF08, 0xF4D0, 0x02D2,
0x0B72, 0x1719, 0x0213, 0x1312, 0x05C6, 0x0BC4, 0x0FBA, 0x0BDD,
0x0410, 0xFB44, 0xECB6, 0xE777, 0xE35B, 0xD953, 0xFC42, 0xF0E8,
0x13AF, 0x0262, 0x0BAC, 0xFD97, 0xFF5F, 0x17A6, 0x08D1, 0x224B,
0x18AC, 0x1FF2, 0x0B9B, 0x138A, 0xF755, 0xF385, 0xF58D, 0xEBBA,
0xED23, 0xEAB2, 0xE79B, 0xDEFF, 0xF315, 0xDE00, 0xFEE1, 0x001D,
0x0EE0, 0x19EB, 0x102E, 0x0EC4, 0xF9B3, 0x0A3F, 0xFD94, 0x1026,
0x0E9D, 0x109B, 0x0528, 0xF8BE, 0x02BF, 0xEBE3, 0x101B, 0xFBE2,
0x10F1, 0x02CE, 0xF768, 0xFE63, 0xDF80, 0xEFEB, 0xF2BB, 0x0244,
0x073C, 0x152B, 0xFB46, 0xFD85, 0xF431, 0xFBDF, 0x0807, 0x0271,
0x2644, 0x07D9, 0x233E, 0x0AE7, 0x0AA7, 0xFED9, 0x040D, 0x00A0,
0xF297, 0xFCB3, 0xD301, 0xEE1C, 0xCB64, 0xE719, 0xE502, 0xF732,
0x0E38, 0x08DF, 0x24BF, 0x06C8, 0x248E, 0x0E48, 0x2924, 0x1753,
0x265A, 0x1D8A, 0x09D6, 0x0EE3, 0xF14D, 0xF3DA, 0xDFB7, 0xF4E9,
0xCEAD, 0xF523, 0xCFF1, 0xE7FE, 0xDF06, 0xDD0D, 0x0764, 0xFAA5,
0x3713, 0x1C83, 0x3518, 0x0968, 0x1644, 0x0520, 0x0D51, 0x0E52,
0x0E9A, 0x0EC2, 0xF58A, 0x0AA9, 0xD9AA, 0xF29F, 0xE474, 0xF2D0,
0xF7DC, 0x04D0, 0xF80E, 0xFF94, 0xF75E, 0xF1AF, 0x09D4, 0x011A,
0x2479, 0x11A3, 0x203C, 0x005C, 0xFDB5, 0x00D5, 0xF58C, 0x0706,
0x0746, 0x029B, 0xFA7B, 0x023A, 0xF0FF, 0xF9A9, 0x00CB, 0xFB9C,
0xFADB, 0x0013, 0xEF9E, 0xFC58, 0xEF0E, 0xEDA5, 0xFDB8, 0xF882,
0x1B03, 0x1677, 0x1E17, 0x0331, 0x0CC7, 0xFBF4, 0x0670, 0x0D06,
0x09DF, 0x0DC6, 0xFD38, 0x0C96, 0xE998, 0xFC17, 0xEFEF, 0xF9D3,
0xF780, 0x06AB, 0xEF3F, 0xFCD9, 0xEF3E, 0xE71A, 0x0830, 0xEE66,
0x28C9, 0x06FE, 0x282D, 0xFBFB, 0x0319, 0xF5C7, 0xECD0, 0x050F,
0xFA13, 0x1297, 0xF7E0, 0x171D, 0xEEF8, 0x09C5, 0x0329, 0x09B0,
0x0C78, 0x066E, 0x0319, 0xF666, 0xF781, 0xE319, 0xFD58, 0xE3B2,
0x1380, 0x00ED, 0x05F8, 0xF9B3, 0xE85E, 0xF9A5, 0xEA45, 0x1100,
0x0402, 0x180E, 0x114E, 0x1F69, 0x0C10, 0x041D, 0x0FA6, 0xED8F,
0x0C7C, 0xF6AB, 0xFA3D, 0xED93, 0xE851, 0xDE4C, 0xE56D, 0xEBED,
0xFC78, 0x0CF0, 0x0AC5, 0x0F6F, 0xFD19, 0x0DFD, 0xFCA3, 0x15CC,
0x16BE, 0x1323, 0x1783, 0x0EF8, 0x03A9, 0xF69F, 0x0401, 0xED26,
0xFD5B, 0xF76A, 0xEA62, 0xF3A2, 0xD973, 0xE5BD, 0xDF94, 0xED71,
0x071C, 0x0F38, 0x148E, 0x02B3, 0x04B5, 0xF837, 0x0915, 0x1017,
0x1E8C, 0x1298, 0x1A82, 0x1672, 0xFFDC, 0x09B1, 0x00EC, 0xFCB6,
0x0162, 0x034F, 0xE21A, 0xF784, 0xCA43, 0xDC07, 0xD6AD, 0xD9FB,
0xFD37, 0x0022, 0x173A, 0x0625, 0x167F, 0x0288, 0x0F93, 0x1563,
0x1D2B, 0x1B5C, 0x223F, 0x1D97, 0x0827, 0x02E7, 0xF8F2, 0xEC7B,
0xE981, 0xEA5D, 0xD40F, 0xE347, 0xCF28, 0xE12A, 0xE0C0, 0xEA1B,
0x1049, 0x168F, 0x2E43, 0x21C1, 0x2417, 0x0F84, 0x189F, 0x18D6,
0x15EE, 0x10D4, 0x0763, 0x03A8, 0xE745, 0xEDBC, 0xD8EA, 0xE082,
0xE3D0, 0xEFDA, 0xE531, 0xF338, 0xDF24, 0xF164, 0xF91A, 0xFD77,
0x2952, 0x1648, 0x35D9, 0x0DA3, 0x1D08, 0xF9FD, 0x039A, 0xFF4C,
0x018F, 0x03ED, 0xFCD8, 0x0B1F, 0xE621, 0xFCC0, 0xEB29, 0xFAF2,
0xF665, 0x0B27, 0xF244, 0x0300, 0xEE5D, 0xF256, 0xEF29, 0xE61E,
0x0D4B, 0xFDD8, 0x20D6, 0x02D6, 0x0FC7, 0xF219, 0x046E, 0x02F9,
0x0963, 0x0DFE, 0x08C8, 0x194D, 0xF60B, 0x0C85, 0xF29E, 0xF358,
0xFCDD, 0xFA77, 0xF367, 0xF9D8, 0xE332, 0xEA6E, 0xEB35, 0xE6CE,
0x1212, 0x046E, 0x293B, 0x0F2C, 0x1674, 0x03D2, 0xFA43, 0x0D1C,
0xFA99, 0x0B6E, 0xFDD8, 0x0B3C, 0xE334, 0x002F, 0xE5F5, 0xF419,
0x0290, 0xFC51, 0x0172, 0xF8EA, 0xFAFA, 0xF025, 0x0335, 0xE916,
0x1743, 0x01F0, 0x1EFB, 0x0869, 0x0860, 0xECEB, 0xEF59, 0xFE01,
0xED83, 0x1151, 0xF9F1, 0x1868, 0xFBD7, 0x12F3, 0x03F9, 0x004B,
0x1542, 0x03F0, 0x0BE3, 0x01DC, 0xED3D, 0xEA6D, 0xE21B, 0xD4D0,
0xF39D, 0xED55, 0xFCA5, 0x04DB, 0xF744, 0xFB51, 0xF3DA, 0x0942,
0x0778, 0x198C, 0x2A19, 0x2197, 0x1F87, 0x10EE, 0x0C69, 0xF737,
0x1117, 0xF6DC, 0xFAB6, 0xEE79, 0xD52B, 0xE67C, 0xC54F, 0xE165,
0xE47F, 0xFA63, 0x0D5A, 0x14C7, 0x0DE5, 0x0387, 0x0DE4, 0x0C85,
0x1F7C, 0x18BC, 0x2175, 0x10D8, 0x07DA, 0x02C2, 0xF56E, 0xF000,
0xF38B, 0xF76F, 0xE5A9, 0xFABE, 0xD51D, 0xEB66, 0xDC4F, 0xE09F,
0x0390, 0xF8FA, 0x230A, 0x0DB7, 0x22BC, 0x006C, 0x1875, 0x0B91,
0x138F, 0x16D2, 0x14FE, 0x1B89, 0xFCE6, 0x16A2, 0xEA71, 0xFE13,
0xF510, 0xF895, 0xE976, 0xEF58, 0xD84E, 0xE15D, 0xD7AE, 0xD75E,
0xF2A9, 0xEF37, 0x1F2C, 0x132C, 0x2233, 0x08D5, 0x0D71, 0x1238,
0x1694, 0x207A, 0x2609, 0x1705, 0x0A99, 0x09C5, 0xF01F, 0xEC10,
0xF7AD, 0xE5B4, 0xED89, 0xF101, 0xD603, 0xEEDD, 0xD6B9, 0xEB0E,
0xFE2A, 0x0A5F, 0x2498, 0x270E, 0x2233, 0x0C8E, 0x15A0, 0x01F4,
0x1141, 0x0538, 0x0DF8, 0xFFB4, 0xF0B6, 0xFB27, 0xDB4F, 0xEDE9,
0xEDFF, 0xF809, 0xEC20, 0x040A, 0xE225, 0x03C4, 0xF149, 0xF867,
0x1189, 0xFA64, 0x3363, 0x0A66, 0x31BB, 0xF310, 0x130D, 0xF665,
0xFD7B, 0x0EB6, 0xFE30, 0x1075, 0xF014, 0x1746, 0xDC4E, 0x0CBA,
0xEAD3, 0x0471, 0xF885, 0x00C1, 0xF178, 0xED5D, 0xE7DC, 0xD3D0,
0x017A, 0xDDA3, 0x279E, 0x00D6, 0x1A1E, 0xFCFD, 0xFBB8, 0x07C7,
0xF917, 0x1BBE, 0x090C, 0x1E23, 0xFFDE, 0x1CA8, 0xF0FD, 0xFB10,
0x0C82, 0xF07F, 0x12A7, 0xF711, 0xF300, 0xEC33, 0xE40C, 0xE2A5,
0xFABE, 0xF336, 0x15EE, 0x18E8, 0x0480, 0x0A46, 0xEDCE, 0xFEBF,
0xF54B, 0x0FCB, 0x0341, 0x0739, 0xFE55, 0x0219, 0xFB4E, 0xF777,
0x0AF4, 0xF5BE, 0x0667, 0x007C, 0xF5CE, 0xFAB7, 0xE914, 0xEC06,
0xF0AE, 0xF47C, 0x1073, 0x0BA5, 0x1522, 0xF7BF, 0x0223, 0xF899,
0xFE2A, 0x1169, 0x1278, 0x15C3, 0x1301, 0x2045, 0xFC0D, 0x0CB6,
0xFFC2, 0xFC1F, 0xFBEA, 0xFABB, 0xDFC7, 0xEB7E, 0xC890, 0xD6BE,
0xD71D, 0xD2B5, 0x0BE6, 0xF8CA, 0x17F4, 0x0087, 0x0376, 0x04D7,
0x108A, 0x2468, 0x2D9F, 0x2762, 0x1F4B, 0x21D7, 0xFD7A, 0x057D,
0x056F, 0xF06D, 0xFFCD, 0xF350, 0xD940, 0xE6A3, 0xC990, 0xD772,
0xE2F9, 0xE7AF, 0x0D1C, 0x13AB, 0x15A6, 0x0D22, 0x0A36, 0x04FF,
0x0A1F, 0x1BFD, 0x1316, 0x13B1, 0x0C6D, 0x0886, 0xF651, 0xF290,
0xF941, 0xEBEA, 0xF610, 0xF833, 0xE0BE, 0xEF1F, 0xDB36, 0xE8D7,
0xEE44, 0xF10B, 0x19F5, 0x1061, 0x2D75, 0x112B, 0x1B67, 0x078B,
0x11DF, 0x16DC, 0x1DBE, 0x11EC, 0x1550, 0x1219, 0xEC2E, 0x02C8,
0xDF8F, 0xEE6A, 0xE8EC, 0xF1CC, 0xD93A, 0xEE88, 0xC2F7, 0xE16A,
0xDCA8, 0xE30B, 0x211A, 0x0A6E, 0x34CC, 0x0D01, 0x1D41, 0x01A8,
0x1A05, 0x162A, 0x21A8, 0x1546, 0x10A8, 0x16E1, 0xEABA, 0x01C4,
0xEBAF, 0xF08E, 0xF5F6, 0x0181, 0xE1DA, 0xF967, 0xDC9F, 0xE836,
0xF6BB, 0xE9F7, 0x22D3, 0x09A2, 0x28A3, 0x0620, 0x092B, 0xF283,
0xFF52, 0x0C7B, 0xFE1A, 0x0F49, 0xF088, 0x09A7, 0xE3E2, 0x031B,
0xEECD, 0xF8F3, 0x0189, 0x0035, 0x0447, 0xFACA, 0xFAEA, 0xE9DF,
0xFD93, 0xE4D2, 0x2405, 0x05F7, 0x2F27, 0x0B48, 0x087E, 0xFEC2,
0xF38D, 0x186D, 0x0138, 0x1AA0, 0x07CD, 0x1814, 0xEE71, 0x06FA,
0xF00D, 0xEF57, 0x070C, 0xF613, 0xF60E, 0xEF4F, 0xDA1B, 0xDE00,
0xDC48, 0xD7BD, 0x07BB, 0xFE0B, 0x1BFF, 0x128B, 0x029B, 0xFF93,
0x0518, 0x10F1, 0x1E53, 0x1B71, 0x1D60, 0x17A0, 0x02D6, 0x0A9C,
0x0592, 0xFDA2, 0x1215, 0x0325, 0xF508, 0xF8F9, 0xD87E, 0xE947,
0xDC1D, 0xE320, 0x0049, 0xFE61, 0x1222, 0x0110, 0x0077, 0xEBAC,
0xFA7C, 0x097A, 0x02A5, 0x1582, 0x0F33, 0x15D3, 0x0490, 0x10DC,
0xFC55, 0xFD5D, 0x0AEA, 0x02E0, 0xFE89, 0xF7F6, 0xE3FB, 0xE0AE,
0xE1BD, 0xD7F6, 0x08AE, 0xF5FE, 0x2302, 0x0FB8, 0x0E0D, 0x080F,
0x076F, 0x1CB0, 0x1986, 0x28BF, 0x1F55, 0x2503, 0x0240, 0x0EC7,
0xEF61, 0xE897, 0xF7AD, 0xE324, 0xE413, 0xE10F, 0xC14E, 0xD50E,
0xC3B4, 0xD1E1, 0x005D, 0xFF70, 0x24BF, 0x1DF8, 0x1363, 0x0E47,
0x1BA1, 0x23C8, 0x2F5C, 0x25B0, 0x2CB7, 0x12A2, 0x0C26, 0x0118,
0xF4DC, 0xEB1B, 0xF9E3, 0xF7F5, 0xE822, 0xF864, 0xD2C4, 0xE892,
0xD4BC, 0xE5F5, 0xFAB2, 0x03A1, 0x2087, 0x14E1, 0x168A, 0xF965,
0x0AD5, 0x014C, 0x1010, 0x0A5F, 0x0EE5, 0x05AE, 0xF44C, 0x052D,
0xE44F, 0xF5B7, 0xF380, 0xF88B, 0xF0E3, 0xFD9B, 0xE10B, 0xF4E1,
0xE1B6, 0xE4D7, 0x1075, 0xFC09, 0x3BCC, 0x18D6, 0x273A, 0x0402,
0x122F, 0x0EA3, 0x181C, 0x1A6F, 0x149D, 0x12FA, 0xE99A, 0x083A,
0xCFB4, 0xEA5B, 0xE8D5, 0xEBA6, 0xE301, 0xED93, 0xCA74, 0xDE9A,
0xD7A6, 0xDAA7, 0x0DE5, 0xFA48, 0x36E3, 0x17B6, 0x282F, 0x03FC,
0x1679, 0x0DE7, 0x15C3, 0x1F5B, 0x11A4, 0x163B, 0xF43C, 0x07C3,
0xE31A, 0xF324, 0xFB3F, 0xFA07, 0xFBCF, 0xFF54, 0xECEF, 0xF55D,
0xF085, 0xE74C, 0x0DB1, 0xF2EC, 0x2399, 0x099F, 0x06C7, 0xF70D,
0xEB54, 0xFE3B, 0xEB55, 0x0809, 0xF838, 0x0219, 0xF1E4, 0x0A70,
0xE83F, 0xFAF3, 0x0BDD, 0xFD6E, 0x1D44, 0x07F0, 0x0320, 0xF91D,
0xF09C, 0xE63F, 0x06FE, 0xF447, 0x2085, 0x11EB, 0x0878, 0x01B2,
0xF6D7, 0x03F2, 0x0933, 0x157C, 0x166E, 0x123A, 0xFFFC, 0x0C6E,
0xEEC6, 0xF5CD, 0x03A5, 0xF471, 0xFA2E, 0xF7B0, 0xD5D2, 0xE5D1,
0xC8D6, 0xD3D9, 0xE825, 0xE8AF, 0x15B7, 0x0E89, 0x14C4, 0xFE22,
0x1001, 0x07DF, 0x2035, 0x2252, 0x2885, 0x1B6F, 0x14D2, 0x1D6D,
0xFB24, 0x09C8, 0x0665, 0xFD08, 0x00CC, 0xFC06, 0xE020, 0xEA6E,
0xD233, 0xD98F, 0xE891, 0xE0D5, 0x1200, 0xFF0A, 0x0E56, 0xFBCD,
0xF7B4, 0x033D, 0xFFF4, 0x1A47, 0x1400, 0x18CB, 0x0791, 0x15A0,
0xF07D, 0xFCC8, 0x0893, 0xEFE4, 0x0D23, 0xF55D, 0xEA2F, 0xF00F,
0xDC4C, 0xE1DB, 0xF935, 0xEDD7, 0x218F, 0x1A6D, 0x1735, 0x1432,
0x091F, 0x1259, 0x1A55, 0x2576, 0x24A8, 0x13E7, 0x0DFA, 0x037C,
0xE91E, 0xE861, 0xEEAA, 0xE373, 0xEBEC, 0xF22C, 0xC7CE, 0xE66D,
0xBEB4, 0xDD95, 0xE2EB, 0xF173, 0x182C, 0x1465, 0x2613, 0x0DDD,
0x252E, 0x0D55, 0x2F7E, 0x1E3C, 0x31BB, 0x13AA, 0x1A01, 0x10DC,
0xEE82, 0x024A, 0xEC29, 0xFB57, 0xF03A, 0x018C, 0xD9E8, 0xF919,
0xD2B2, 0xE7BA, 0xEF8E, 0xE1E6, 0x238B, 0x023A, 0x2523, 0x020C,
0x0BA7, 0xFDC6, 0x0DC4, 0x10BB, 0x0C01, 0x08DE, 0xF1A3, 0x0F2A,
0xD56D, 0x0427, 0xEC1F, 0xF4D4, 0x0581, 0xFF5C, 0xF54C, 0xF6D1,
0xEDA4, 0xE778, 0x0B9F, 0xF448, 0x38ED, 0x192A, 0x2F7D, 0x126C,
0x0D6A, 0x0ACB, 0x0948, 0x1EE5, 0x073F, 0x151E, 0xF203, 0x067B,
0xD66F, 0xEC33, 0xE6A6, 0xE1EF, 0xF7D5, 0xF06A, 0xE658, 0xEEB4,
0xE1D0, 0xE65F, 0xF4E9, 0xECEB, 0x1D0A, 0x12E0, 0x22B0, 0x1365,
0x0AB7, 0x0965, 0x0E68, 0x1B12, 0x1721, 0x0D73, 0x0BAE, 0x0C0F,
0xF441, 0x06FD, 0x01CA, 0xF82A, 0x1391, 0x0310, 0xF7CD, 0x0397,
0xE077, 0xF2A2, 0xEC8F, 0xE804, 0x0CD1, 0xFBA5, 0x07E0, 0xF915,
0xEF30, 0xF086, 0xF756, 0x0549, 0x08DA, 0x0678, 0x03B0, 0x09C7,
0xE9CF, 0x051F, 0xFCFE, 0x03E6, 0x18A4, 0x1135, 0xFE57, 0x048E,
0xEC2C, 0xECFE, 0xF9DC, 0xE722, 0x1821, 0x05DB, 0x1BB2, 0x076C,
0x0894, 0xFB0C, 0x0B98, 0x148B, 0x0E26, 0x17DC, 0x00F5, 0x1586,
0xEAB6, 0x0768, 0xF146, 0xF1F3, 0x00BB, 0xF2B8, 0xE904, 0xE7D9,
0xD269, 0xD946, 0xE106, 0xDA74, 0x0A8B, 0xF8E8, 0x134C, 0x0A50,
0x05FD, 0x1157, 0x142D, 0x287B, 0x2339, 0x23DF, 0x1F7D, 0x1F08,
0x0408, 0x0D6F, 0x0475, 0xF152, 0x16E7, 0xF0F5, 0xF54D, 0xECB7,
0xCEBA, 0xE392, 0xD16B, 0xE2C7, 0xF6EF, 0x006F, 0x0576, 0x0CA6,
0xF664, 0x0153, 0x06BB, 0x1236, 0x1B16, 0x0E34, 0x1453, 0x0404,
0xFD24, 0xF959, 0xFBD2, 0xECBA, 0x0498, 0xFF8D, 0xEA37, 0x0718,
0xD5E6, 0xFA01, 0xE746, 0xF5F2, 0x1276, 0x0C58, 0x261D, 0x0F2A,
0x1E96, 0x0047, 0x285B, 0x0F9D, 0x27E2, 0x0C26, 0x0A2C, 0x028F,
0xDCC2, 0xFE70, 0xD245, 0xF37D, 0xE55A, 0xF66D, 0xD5BD, 0xF325,
0xCB1F, 0xE7A9, 0xE580, 0xDCC5, 0x1757, 0xF42C, 0x343B, 0x0C6E,
0x2401, 0x0B14, 0x1DA3, 0x20DD, 0x20CD, 0x2376, 0x0C89, 0x1B3A,
0xE63F, 0x131F, 0xE652, 0xF854, 0x0643, 0xF11C, 0xFBB8, 0xED8A,
0xE615, 0xE415, 0xED5A, 0xE08A, 0x0A8E, 0xF8FF, 0x1333, 0x1053,
0xFCE0, 0x0827, 0xFD3A, 0x1087, 0x02F1, 0x1022, 0xFB46, 0x0045,
0xE80A, 0xF27A, 0xEE3C, 0xE96D, 0x13AC, 0xF6F3, 0x070A, 0xFF74,
0xED62, 0x026E, 0xFA6C, 0x03A7, 0x1674, 0x11D7, 0x231B, 0x1860,
0x1348, 0x02CD, 0x0FC2, 0x0701, 0x1221, 0x025A, 0x000A, 0xF4FE,
0xE074, 0xF805, 0xDA83, 0xF154, 0xF3F1, 0xF950, 0xEF1A, 0x0229,
0xDD7B, 0xFBD0, 0xEA0C, 0xED25, 0x10BE, 0xEF85, 0x21AD, 0xFF10,
0x10B5, 0x0129, 0x1582, 0x10EC, 0x192B, 0x1469, 0x0898, 0x12AE,
0xEF5C, 0x15D4, 0xEEFB, 0x061E, 0x155B, 0x0240, 0x0F44, 0xFBAD,
0xF003, 0xEB84, 0xEF08, 0xDC84, 0xFF3C, 0xE821, 0x060A, 0x01E9,
0xEEBF, 0xFBEC, 0xEC1F, 0x0990, 0xFF80, 0x149C, 0xFF9F, 0x066C,
0xF371, 0x03AB, 0xFFF0, 0xFA00, 0x203E, 0xFA24, 0x15EA, 0xFEB6,
0xFA65, 0xF96D, 0xF0B2, 0xF618, 0xFC05, 0x0123, 0x0C8B, 0x0E45,
0x035C, 0x0A05, 0x0B3E, 0x1452, 0x1B47, 0x107B, 0x1280, 0xFD43,
0xF9CF, 0xFCA3, 0xEE50, 0xF5A3, 0x00CD, 0xF0B2, 0xEE92, 0xEE9A,
0xCB28, 0xF124, 0xD373, 0xEE36, 0xF36C, 0xF008, 0x0F99, 0x0626,
0x1303, 0x0A0F, 0x1C7E, 0x16B5, 0x3264, 0x1CD1, 0x2AB0, 0x0EE8,
0x0091, 0x0DEE, 0xEEB7, 0x0039, 0x0720, 0xF930, 0xFB0A, 0xFBF1,
0xDBF9, 0xF4B2, 0xDCCD, 0xEA45, 0xF51E, 0xEEBD, 0x0BB8, 0xFF73,
0x0544, 0xFF57, 0x0B02, 0x0D61, 0x1530, 0x1246, 0x068D, 0xFE1C,
0xEFB4, 0xFC6C, 0xE747, 0xFB32, 0x02D0, 0xFD9F, 0x0447, 0xFEDA,
0xEC8C, 0xFAA8, 0xF727, 0xFAF4, 0x0FB6, 0xFEC7, 0x1E17, 0x0B2A,
0x1998, 0x0B1D, 0x1828, 0x1399, 0x1BE7, 0x1311, 0x08A8, 0xFA57,
0xE119, 0xFAA3, 0xD284, 0xF6B7, 0xEC81, 0xE899, 0xEE5B, 0xEDA2,
0xDE33, 0xF4DD, 0xE266, 0xF139, 0xFFA3, 0xF433, 0x2280, 0x050B,
0x1ADE, 0x10ED, 0x18D3, 0x213C, 0x26C8, 0x1CA4, 0x1440, 0x0255,
0xF335, 0xFCCD, 0xE1CB, 0xF7DB, 0xF9E2, 0xF531, 0x043F, 0xF5EC,
0xEAF8, 0xF52B, 0xEFB0, 0xFC2D, 0x0A2F, 0xFEB3, 0x0FA9, 0x00A7,
0xFC9C, 0xFF12, 0xF952, 0x0888, 0x0A55, 0x09DB, 0x0154, 0xF290,
0xDC70, 0xF262, 0xD977, 0xF681, 0x053E, 0xF858, 0x0E4A, 0x0745,
0x01C3, 0x0DA3, 0x0F57, 0x0AFC, 0x1935, 0xFF88, 0x17B3, 0xF8B4,
0x0535, 0x0392, 0x036A, 0x1250, 0x1358, 0x087D, 0xFD2A, 0xF304,
0xDB4B, 0xF53A, 0xD7E6, 0xFCC3, 0xF22C, 0xFA58, 0xFD43, 0xF29F,
0xF126, 0xF352, 0xF93B, 0xFAD5, 0x074E, 0xF84C, 0x03CF, 0xF9A2,
0xFF56, 0xFFAB, 0x1133, 0x1452, 0x2123, 0x233A, 0x1118, 0x06EC,
0xF45A, 0xF6FA, 0xECEC, 0x006D, 0x0B75, 0xFDC7, 0x13B5, 0xF8A4,
0xF99C, 0xF988, 0xF7FF, 0xFCC8, 0xFB1A, 0xFA62, 0xF1BF, 0xF1DC,
0xE481, 0xF327, 0xEE58, 0x0A1E, 0x0A0D, 0x0D97, 0xFE5A, 0xF35F,
0xE876, 0xF236, 0xF1DE, 0xFEC7, 0x0F00, 0x017A, 0x1B9C, 0x005C,
0x082E, 0x047E, 0x03DA, 0x0DBD, 0x0FBE, 0x05A7, 0x0617, 0xFC07,
0xF555, 0xFBB3, 0x0339, 0x09B3, 0x1BC7, 0x18F9, 0x0F65, 0x0125,
0xEDA2, 0xEC24, 0xDF52, 0xF655, 0xF412, 0xFBFF, 0xFA97, 0xF241,
0xDE9C, 0xEA0C, 0xDD79, 0xF372, 0xF4A9, 0xFB23, 0x02BE, 0xF59E,
0x009B, 0xFB5E, 0x109C, 0x1621, 0x3724, 0x2092, 0x2A8D, 0x06D5,
0xFC9B, 0xF791, 0xED0D, 0x02D3, 0xFF83, 0x07A2, 0x02BD, 0xF5D9,
0xE69A, 0xED82, 0xED32, 0x03B7, 0x096B, 0x06F1, 0x05F4, 0xF65F,
0xF2D1, 0xF727, 0xFA8D, 0x0702, 0x12DC, 0x100B, 0x004E, 0xFAB4,
0xD94E, 0xECD6, 0xD6F8, 0xF8BF, 0xFB94, 0xFBBF, 0x0F7C, 0xF6A6,
0x022F, 0xF8EA, 0x1027, 0x05A2, 0x2227, 0x0C22, 0x155D, 0x060D,
0x0137, 0x0496, 0xFD5D, 0x111F, 0x0C8A, 0x14B7, 0xFE92, 0xF971,
0xDDD7, 0xE5CF, 0xD6CB, 0xED95, 0xEBDE, 0xF4B0, 0x02AF, 0xEC2D,
0xF8EF, 0xEB83, 0xF6C3, 0x0C52, 0x0B81, 0x1C10, 0x09C3, 0x07B5,
0xFA52, 0xFCB8, 0x03AD, 0x0664, 0x1AE7, 0x1007, 0x130B, 0xF659,
0xF411, 0xE08E, 0xE961, 0xFA03, 0x0A3B, 0x0F54, 0x1BED, 0x0A34,
0xF970, 0x075D, 0xF64A, 0x11AA, 0x0C41, 0x0BB9, 0x0130, 0xF28C,
0xE7F4, 0xE99D, 0xE425, 0xF2F7, 0xFC0A, 0xFA58, 0xF646, 0xF084,
0xDD5E, 0xEE91, 0xE7A7, 0x0504, 0x0876, 0x15F4, 0x220A, 0x0D07,
0x1B65, 0xFDD3, 0x14A6, 0x0543, 0x1945, 0x04DF, 0x08B9, 0xF3E2,
0xF0E3, 0xF3A3, 0xECDC, 0x08F9, 0x002A, 0x1E54, 0x02CF, 0x0983,
0xED8B, 0xEBD8, 0xE76F, 0xF577, 0x00A0, 0x0339, 0x1539, 0xF78D,
0xFA37, 0xE7F4, 0xEB06, 0xF97F, 0xF978, 0x0C34, 0xF5DA, 0x0430,
0xEF39, 0x027F, 0xF3B3, 0x0CC0, 0x1205, 0x0E75, 0x25D6, 0xF550,
0x0B42, 0xE795, 0xFFF7, 0xFB60, 0x1473, 0x0BA2, 0x16B7, 0x0EBD,
0xFC13, 0x07EA, 0xEEF4, 0x0D89, 0xF23C, 0x0ED3, 0xE7FC, 0xF2BC,
0xDD0B, 0xE439, 0xE664, 0xEE83, 0x02AF, 0xFB63, 0x0CD9, 0xF709,
0xFC08, 0xEE85, 0xF5DB, 0x03CB, 0x0BD8, 0x1EB6, 0x1EC5, 0x193D,
0x0B69, 0x0148, 0xFFCD, 0xFD05, 0x0973, 0xFFE3, 0x024B, 0xF5B4,
0xF8DD, 0xF12B, 0xF7D5, 0xFF13, 0x09DC, 0x1AD2, 0x1836, 0x15C1,
0xFF36, 0xF967, 0xE8F2, 0xFA4E, 0xF0E7, 0x0028, 0xFDD3, 0xF353,
0xED5D, 0xE64F, 0xDDB5, 0xF4C7, 0xF376, 0x07FB, 0x013E, 0x011E,
0xFD87, 0xFBCA, 0x02AE, 0x0900, 0x1CBF, 0x15EC, 0x2A42, 0x031C,
0x0B0E, 0xE5E3, 0xF5EA, 0xEFE2, 0x04CD, 0x0BA3, 0x0EA4, 0x13AD,
0xFC06, 0x0BA2, 0xEE90, 0x0C87, 0xFD94, 0x0F40, 0xFDAF, 0xFE7D,
0xEA6A, 0xEB19, 0xE6BE, 0xE6C2, 0xFAF6, 0xF957, 0x0A3B, 0xFE37,
0xF671, 0xEE67, 0xEA60, 0xFE17, 0x015C, 0x178C, 0x195E, 0x1659,
0x1242, 0x061D, 0x0146, 0xFCB3, 0x0785, 0xFCF3, 0x081A, 0xF180,
0xF70E, 0xE768, 0xEF89, 0xFA9C, 0x05E7, 0x183D, 0x17B5, 0x167B,
0x01FD, 0xFD74, 0xEF35, 0xFB48, 0xF516, 0x0991, 0xFC80, 0x007C,
0xECE7, 0xE706, 0xE1FB, 0xEB9E, 0xF88E, 0x02AC, 0xFE66, 0x0419,
0xFAD8, 0xFAE1, 0x05E2, 0xFD0E, 0x191A, 0x133C, 0x2B32, 0x1036,
0x11BF, 0xEF90, 0xF5C2, 0xF41C, 0xFD9B, 0x0A3F, 0x072B, 0x0B4A,
0x02D0, 0x050C, 0xF60C, 0x07E5, 0xF885, 0x0FB2, 0xFE77, 0xFD7E,
0xF21D, 0xE330, 0xE704, 0xEC52, 0xF259, 0x00EC, 0x0266, 0xFFF6,
0xFA8D, 0xFAA2, 0xF45E, 0x0178, 0x0532, 0x0F28, 0x1B8D, 0x116F,
0x156F, 0xFF4D, 0x0226, 0xF86E, 0x0E4C, 0xFA4E, 0x0A30, 0xF3C2,
0xF107, 0xF430, 0xED13, 0xFBEB, 0xFF27, 0x1A2B, 0x1B2C, 0x28E3,
0x0F8E, 0x06E4, 0xF7BE, 0xF769, 0xFED0, 0xFD99, 0xFD5D, 0xFBA0,
0xED6D, 0xEF30, 0xE29A, 0xE3BF, 0xE805, 0xFECE, 0xF7B3, 0x0C70,
0xFF4E, 0xF61F, 0x0408, 0x0871, 0x1CAE, 0x2415, 0x34F2, 0x0BA6,
0x2530, 0xE8AC, 0x0916, 0xEFD2, 0xF75D, 0x1093, 0xF7B3, 0x0D3C,
0xF910, 0xF825, 0xE78D, 0x0916, 0xF36E, 0x0F32, 0x0247, 0xFB88,
0xF962, 0xFB54, 0xF941, 0xF6A1, 0x0004, 0xF6F2, 0x1351, 0xFD18,
0x05E9, 0xFA8C, 0xE4C7, 0x09A3, 0xF7C8, 0x0646, 0x1138, 0x0405,
0x0AD2, 0x0C4A, 0x01CA, 0xF085, 0x0BFD, 0xF308, 0x1714, 0x0988,
0x0A8A, 0xFBDE, 0xFB5E, 0xFC97, 0x078C, 0x1396, 0x13DF, 0x259C,
0xFE7E, 0x10BA, 0xF381, 0xECC8, 0xF7D8, 0xFDF2, 0xF174, 0xFFBD,
0xEDC8, 0xD644, 0xE8E7, 0xE7C5, 0xFA6D, 0x159F, 0x0B38, 0x0E1A,
0x00D5, 0xF47E, 0x05E3, 0xFC41, 0x0F7A, 0x2456, 0x1E05, 0x192A,
0x240A, 0xE406, 0x04E2, 0xED9E, 0xF3EE, 0xFBCB, 0xFF09, 0xF680,
0xFE2A, 0x1285, 0xF561, 0x1ACF, 0xFBC5, 0x0B81, 0x0727, 0xFA10,
0xFF8A, 0xF7B8, 0xE97C, 0x0ADF, 0xF2F0, 0xF7D0, 0x156A, 0xED0D,
0x0678, 0x0157, 0xE9A5, 0xF44C, 0xF44D, 0xF9EB, 0x0505, 0x1D58,
0x112C, 0x11EC, 0x099D, 0xEF2E, 0x0E97, 0xEE6A, 0x1C0E, 0x0A4B,
0x029E, 0x0906, 0xFEB9, 0xEB9C, 0x0C62, 0x0E30, 0x05C5, 0x3009,
0xFC23, 0xFA9D, 0xE972, 0xEB2C, 0xEAF7, 0x11C8, 0xFD10, 0x0737,
0xF7EC, 0xDE23, 0xF326, 0xDACC, 0xFB71, 0x0F50, 0x0652, 0x16A2,
0x0D3E, 0xECF5, 0x01AE, 0x073B, 0xFA36, 0x1BBD, 0x0FAF, 0xF604,
0x1420, 0xF2FF, 0x07DF, 0x0659, 0x08D3, 0xFBE7, 0x0A1A, 0xEB37,
0x0DDF, 0xFE1F, 0xFAAE, 0x2530, 0xF4B9, 0x196E, 0x0B0F, 0xFB46,
0xF2F3, 0x064E, 0xD8A7, 0xF82B, 0xE756, 0xE51A, 0x00B5, 0x08E2,
0x1215, 0x0A01, 0x05F7, 0xE1F7, 0x02DE, 0xE2F2, 0x0ED3, 0x105F,
0x045D, 0x22DA, 0x0003, 0xF298, 0x0B57, 0xF3A0, 0x08C3, 0x198C,
0xFBFC, 0xEF77, 0xF799, 0xE2A2, 0x025E, 0x1E91, 0x199F, 0x2638,
0x1305, 0xF444, 0xF7A9, 0xE368, 0xEA79, 0x0F0D, 0xE2CC, 0x14B2,
0xF23F, 0xE055, 0xF6A7, 0xF18D, 0xEFBD, 0x1701, 0x0783, 0xF045,
0x092C, 0xEB96, 0x02D4, 0x15D5, 0x0EC8, 0x10C6, 0x1429, 0xF233,
0x169D, 0xEE00, 0xFC8F, 0x0C55, 0xF21A, 0x06E6, 0x12AC, 0xF005,
0x12B3, 0x136A, 0xF776, 0x102C, 0xF7F5, 0xF01D, 0xFFB1, 0x0DCE,
0xF3F5, 0x134F, 0xE333, 0xE901, 0xE30A, 0xDAB5, 0xFC40, 0x0182,
0x05AC, 0x1B42, 0x04DE, 0xED26, 0x1589, 0xEA0D, 0x0F80, 0x1E80,
0x04CD, 0xFDFF, 0xFE5B, 0xDCE0, 0xF65E, 0x1255, 0x087A, 0x1B5A,
0x01E2, 0xE5D8, 0xF94E, 0xE077, 0x0AC9, 0x1FFE, 0x0E48, 0x35B8,
0x1BA1, 0xF3AA, 0x113D, 0xEE72, 0xEAB1, 0x1485, 0xE330, 0xEC93,
0xE434, 0xDFC7, 0xE0B7, 0x0B81, 0xF196, 0x0E0D, 0x09C8, 0xED11,
0x11C1, 0xE8C5, 0x0A9D, 0x171D, 0x0BEF, 0x171D, 0x21DE, 0xEBCB,
0x1B96, 0x0156, 0xF359, 0x05DC, 0xECE0, 0xDF14, 0xF6A0, 0xFFAA,
0xFF25, 0x25D5, 0x0739, 0x05FF, 0x033B, 0xEDBE, 0x0D6A, 0x06CD,
0xFBF9, 0x1CB9, 0xE6E2, 0xF321, 0xF8E6, 0xE4BD, 0xF738, 0x1ACA,
0xF208, 0xFF95, 0xF8D7, 0xD082, 0xFF8C, 0x07B6, 0x139D, 0x22AF,
0x18B6, 0xEDC0, 0x0C15, 0xD31E, 0x03FF, 0x07C4, 0x008B, 0x2AB3,
0x036E, 0xF2F2, 0x050B, 0xF255, 0xFA4C, 0x2AB6, 0xFDF1, 0x0A47,
0x1032, 0xED34, 0x071F, 0x110F, 0xF83E, 0x07A8, 0xF09E, 0xD7FE,
0xEF79, 0xD8E9, 0xEC8B, 0x118A, 0xE596, 0x1F3D, 0x0816, 0xF29A,
0x1765, 0x040C, 0xFD0E, 0x16CD, 0x04E9, 0xE684, 0x129F, 0xF206,
0x12BB, 0x1568, 0x07FB, 0xEF32, 0xF717, 0xD134, 0x0127, 0xFC94,
0x03DB, 0x34A7, 0xFCCC, 0x187F, 0x0FAA, 0xFA0F, 0x15B2, 0x2724,
0xF502, 0x0B25, 0xE202, 0xC482, 0xE779, 0xEF3F, 0xF26E, 0x1DD0,
0xFF9C, 0xEF67, 0xFFC5, 0xCFEA, 0x05A5, 0x0582, 0x0B6F, 0x3242,
0x15B6, 0xFFC1, 0x2321, 0xEA4D, 0x06BF, 0x1BC3, 0xF481, 0xFCDE,
0xF9CE, 0xD0AB, 0xF05A, 0x08D3, 0xF90D, 0x26EB, 0x04DD, 0xFC6E,
0x0F7D, 0xED6D, 0x10D1, 0x158C, 0xFA89, 0x1BD0, 0x0032, 0xE81E,
0x0757, 0xF202, 0xE83F, 0x0F7A, 0xDD42, 0xE6EE, 0xF641, 0xEE0A,
0x00A2, 0x22C1, 0xFEEF, 0x0988, 0x06E8, 0xD936, 0x17D7, 0xF1CA,
0x1C99, 0x21AC, 0x0C7F, 0x0311, 0x1127, 0xDA61, 0x11CF, 0x1159,
0xF412, 0x238D, 0xEE74, 0xE9B0, 0xF77C, 0x0827, 0x0178, 0x3957,
0x00C8, 0xFA26, 0xEC75, 0xC295, 0xF065, 0xF2AB, 0xF6D5, 0x2631,
0x01CB, 0xF8FA, 0x18EC, 0xDEED, 0x0B2F, 0x1F35, 0xF6DD, 0x149E,
0x007E, 0xD885, 0x047B, 0xFDC8, 0xFDE2, 0x1FC8, 0x0165, 0xEF31,
0x0599, 0xD026, 0xFE45, 0x01C1, 0xF71B, 0x2B66, 0x0DF1, 0x0851,
0x29CC, 0x0916, 0x0F8A, 0x291E, 0xED62, 0xF3D6, 0xEF2D, 0xD671,
0xECEE, 0x0C18, 0xE9F8, 0x08AA, 0xEB0E, 0xD6D8, 0xF9E9, 0xE44F,
0x07B2, 0x1CDE, 0xFDEA, 0x1958, 0x1266, 0xECF0, 0x272B, 0x0C8A,
0x0DCC, 0x1A19, 0xFC61, 0xD386, 0x003E, 0xE081, 0x023C, 0x2417,
0xFB8A, 0x097B, 0xF52A, 0xD7CB, 0xFD3A, 0x00AD, 0x001B, 0x4114,
0xFF77, 0x126D, 0x07FB, 0xD7EC, 0xFE41, 0x0A68, 0xE8ED, 0x0FFD,
0xF435, 0xD2BD, 0x0539, 0xEF08, 0x0317, 0x1FEB, 0x003B, 0xF9F4,
0x0082, 0xD510, 0x0668, 0xFEC3, 0xFB9C, 0x2988, 0x0349, 0xFF19,
0x2561, 0xE9C7, 0x0D78, 0x1990, 0xEA3B, 0x04AC, 0xFB07, 0xE521,
0x0AD4, 0x19D3, 0x07E3, 0x232D, 0xFA6F, 0xE691, 0xF421, 0xD7C4,
0xF113, 0x0B27, 0xE65D, 0x172F, 0xF97C, 0xE93B, 0x1871, 0x0167,
0x0DBA, 0x238E, 0xF354, 0xE437, 0xFA04, 0xD756, 0x0B26, 0x2092,
0x0CCB, 0x1867, 0x051B, 0xD20C, 0x066B, 0xDC18, 0x0685, 0x2306,
0xFB07, 0x224A, 0x0DA4, 0xEF34, 0x1671, 0x1183, 0xF626, 0x2A67,
0xF3A9, 0xE215, 0xF65D, 0xE07D, 0xE8AE, 0x1D21, 0xEF38, 0x05C5,
0xFBCE, 0xD62E, 0x0B20, 0xF042, 0x0B04, 0x25A2, 0x0888, 0x0C01,
0x1BFD, 0xE4CF, 0x1466, 0x09A0, 0xF130, 0x047B, 0xF213, 0xD9C1,
0x061D, 0xFFCF, 0xFE49, 0x2131, 0xF5A7, 0xF863, 0x0222, 0xEA43,
0x115F, 0x18B6, 0x0BF7, 0x2940, 0x07FF, 0xF5E0, 0x1536, 0xEA3E,
0xF9CC, 0x145E, 0xD75A, 0xEF42, 0xE978, 0xCDF7, 0xFCB9, 0x1810,
0x074A, 0x2B2B, 0x0425, 0xE3F5, 0x0019, 0xD779, 0x0C19, 0x150B,
0x06E3, 0x20A8, 0x1442, 0xE496, 0x2545, 0xF16C, 0x00D1, 0x1EE5,
0xE760, 0xF07E, 0xFD1C, 0xE358, 0x02EB, 0x28B3, 0xFC7B, 0x2863,
0xFFCF, 0xE2EC, 0xFAC6, 0xDBF2, 0xF1FD, 0x11AA, 0xEEEB, 0x14CF,
0x09A2, 0xEEE2, 0x1FB2, 0x05AF, 0xFFD6, 0x13C7, 0xF4FF, 0xDF1B,
0x0583, 0xE9B6, 0x000D, 0x19B8, 0xF850, 0xF907, 0xF6B5, 0xD762,
0x0AE5, 0xF9AC, 0x0837, 0x2309, 0xF69B, 0x11D6, 0x183F, 0xFF3B,
0x2022, 0x25EA, 0xFA8D, 0x1130, 0xFBC1, 0xD157, 0x058D, 0xF3DB,
0xF1B0, 0x193D, 0xE6CC, 0xE45E, 0xEDD1, 0xD004, 0xFD90, 0x108C,
0x0424, 0x34E9, 0x05D9, 0x031E, 0x1B7F, 0xEFE6, 0x110C, 0x1ABF,
0xF1F7, 0xFAFC, 0x0578, 0xC9BE, 0x1275, 0xFD49, 0x0501, 0x1ADA,
0xF777, 0xEDB6, 0xF57D, 0xE45D, 0x04DD, 0x1776, 0xFC07, 0x34C6,
0x04BA, 0x088B, 0x1B2C, 0xF6C1, 0xF466, 0x0BE4, 0xD96E, 0xE53D,
0xFAAC, 0xDC2C, 0x0E95, 0x18E6, 0x09CF, 0x15F6, 0x0078, 0xE123,
0xFF3F, 0xE437, 0x05AD, 0x1189, 0xF8FB, 0x149A, 0x0680, 0xF50F,
0x2281, 0x0942, 0xFC5A, 0x111B, 0xEA72, 0xDE78, 0x0B9C, 0xF5D7,
0x0A6C, 0x3597, 0x0459, 0x1151, 0x0016, 0xD6F6, 0xFEA7, 0xE968,
0xFA09, 0x159D, 0xE47F, 0x064E, 0xFE15, 0xE545, 0x1112, 0x0FE6,
0xEFA1, 0x198D, 0xF4C4, 0xDF92, 0x0B36, 0xF429, 0x0428, 0x2276,
0xFD39, 0xFFDC, 0xFCB1, 0xD402, 0x102C, 0xE910, 0x1006, 0x195A,
0xF8CB, 0x0CB4, 0x117E, 0xF5F6, 0x1013, 0x1A72, 0xDFE2, 0x1271,
0xF44D, 0xE9FD, 0x0BAD, 0x08D6, 0xF421, 0x1A0F, 0xEB10, 0xEB03,
0xF146, 0xD8E3, 0x0F09, 0xFA2D, 0x12A5, 0x170E, 0x058C, 0xFF85,
0x1792, 0xF3C1, 0xF9F1, 0x0EA0, 0xD735, 0xEFA9, 0xFA7A, 0xDF95,
0x1030, 0x19A8, 0x0649, 0x1B87, 0xFAF1, 0xE7E8, 0xFF62, 0xE282,
0x16B9, 0x1270, 0x0A7F, 0x28DA, 0x0539, 0xFB0E, 0x1793, 0xF782,
0xE90A, 0x12F6, 0xC9A8, 0xE7C5, 0xF6E3, 0xDE8D, 0x069C, 0x1B84,
0x02E6, 0x1A0A, 0x01DD, 0xE3D2, 0x0313, 0xDB1F, 0x1123, 0x08C6,
0xFAA4, 0x1D28, 0x0214, 0xF516, 0x1E7A, 0xF839, 0xF2CC, 0x0B68,
0xE4F5, 0xE5F1, 0x0967, 0xF234, 0x0B49, 0x2086, 0x004F, 0x118B,
0xF691, 0xEE82, 0x0280, 0xED75, 0x06E3, 0x11D0, 0xE84F, 0x12D7,
0xFA59, 0xF23B, 0x1176, 0x0389, 0xEE1F, 0xFDF5, 0xF496, 0xD68A,
0x11F9, 0xF1A7, 0x021F, 0x187F, 0xF581, 0x0269, 0xEF3C, 0xE57F,
0x075B, 0xFAF8, 0x15FA, 0x2353, 0xF6AF, 0x0D87, 0x0B2B, 0xEEDD,
0x0F8D, 0x0D8E, 0xE2DD, 0xFD7E, 0xF93D, 0xD76F, 0x1365, 0x00B4,
0xFC4D, 0x208F, 0xE5AF, 0x03A4, 0xE630, 0xE5A2, 0x0B36, 0xFDB6,
0x1018, 0x2688, 0xFE26, 0x046A, 0x1182, 0xE410, 0xFD5A, 0xFA3E,
0xD6A4, 0xEF17, 0xF7CE, 0xE487, 0x15B9, 0x0A12, 0x0CE4, 0x20B3,
0xFE0D, 0x03A3, 0xF997, 0xE658, 0x19A6, 0x01E8, 0x0DC6, 0x204B,
0xF504, 0xFF85, 0x0E6B, 0xF12D, 0xECE5, 0x0530, 0xC795, 0xEF36,
0xF2CE, 0xEE09, 0x1030, 0x162C, 0x0D66, 0x18D9, 0x03A4, 0xF2BB,
0x067E, 0xDC73, 0x1718, 0xFC5F, 0xFFA6, 0x1155, 0xF61D, 0xF7A3,
0x0C72, 0x02F7, 0xEFE7, 0x10C2, 0xDC2B, 0xEFE2, 0x075D, 0xEFFB,
0x1790, 0x15F6, 0x07E6, 0x180D, 0xFEDD, 0xEC53, 0x0C6E, 0xDDC8,
0x197F, 0x08B7, 0xEFD6, 0x1AB8, 0xE8DA, 0xFF6C, 0x011D, 0x04AD,
0xE328, 0x0B86, 0xE5DC, 0xEB63, 0x0EA9, 0xE717, 0x0DCB, 0x0482,
0xFE0B, 0x0878, 0xF9AB, 0xE8D4, 0x1605, 0xEBD9, 0x29C7, 0x1CFB,
0x0349, 0x1F26, 0xF8F3, 0x0171, 0x04AD, 0x0588, 0xE335, 0xFDCE,
0xE356, 0xE9B4, 0x0B68, 0xF321, 0x0528, 0x0A38, 0xF0B2, 0x0804,
0xF22A, 0xF217, 0x0E14, 0xFF8E, 0x1C3A, 0x1B0D, 0x05E4, 0x0E0D,
0x06D3, 0xF548, 0xF9A5, 0xF3AE, 0xD563, 0xEC8C, 0xE880, 0xE1C4,
0x119F, 0xFA0C, 0x1407, 0x2042, 0x01D5, 0x1440, 0xFF98, 0xF120,
0x1BFA, 0x01B5, 0x1B07, 0x1A83, 0xFDB3, 0x076F, 0x0454, 0xF5AF,
0xF673, 0xF6D5, 0xC810, 0xEFB9, 0xE03B, 0xEE47, 0x10B5, 0x073B,
0x0786, 0x2220, 0xFFB8, 0x0A0C, 0x087F, 0xE51C, 0x1540, 0xF0CC,
0x0CF8, 0x0715, 0xF32B, 0x0616, 0xFDA2, 0xFB00, 0x02D6, 0xFBB5,
0xE971, 0xFD21, 0xF3EA, 0xF9F9, 0x106A, 0x0AE2, 0x0AEE, 0x18AD,
0x0439, 0x0097, 0x0BD8, 0xEC35, 0x0F71, 0xF5DB, 0xFA97, 0x05EE,
0xE884, 0x0CB4, 0xF69C, 0x06A7, 0xF26C, 0xFFD0, 0xE402, 0xF80D,
0x030D, 0xEF42, 0x0F46, 0xFD12, 0xFEC9, 0x0AA6, 0x05BF, 0xF1FA,
0x0C4E, 0xEA1B, 0x186B, 0x0104, 0x0DFD, 0x118E, 0xF4B3, 0x1669,
0xFB5B, 0x09D5, 0xECF4, 0x017C, 0xDCF0, 0xF934, 0x0799, 0xECEB,
0x14AF, 0xFDA0, 0xF5DF, 0x0B89, 0xF8D9, 0xF97F, 0x088C, 0xF156,
0x128B, 0x0007, 0x093D, 0x18D6, 0xF14A, 0x1540, 0xF1A6, 0xF3B2,
0xE975, 0xEFAD, 0xDE2F, 0xF4E4, 0x0129, 0xEE10, 0x16FA, 0x00C7,
0x152C, 0x0D70, 0x128E, 0xFDD9, 0x0B18, 0xF6DA, 0x1258, 0xFEDA,
0x03DD, 0x19ED, 0xF1F7, 0x1771, 0xF4B1, 0xF271, 0xDC3D, 0xEFFA,
0xD3DF, 0xF694, 0xF6D4, 0xF7E6, 0x02BB, 0x0864, 0x13E6, 0x09C4,
0x22AB, 0xFA62, 0x0A75, 0xEDC8, 0x08EC, 0xF559, 0x06C7, 0x1556,
0xF52B, 0x1024, 0xF9FA, 0xF60F, 0xE5C1, 0xFBF2, 0xDCE1, 0xF99A,
0x02C9, 0xF533, 0x08BB, 0x0A8A, 0x0F21, 0x121E, 0x1C95, 0xFCFB,
0x13B1, 0xE5B3, 0x0B38, 0xF56E, 0xF374, 0x1E21, 0xEB08, 0x0E46,
0xEFC9, 0xF208, 0xDC4B, 0xFB3F, 0xE337, 0xF6C3, 0xFF8C, 0xF091,
0x073D, 0x01D8, 0x176D, 0x1010, 0x188B, 0xFEDF, 0x1645, 0xE2E8,
0x203C, 0xFC03, 0xFE15, 0x2601, 0xE7C2, 0x0958, 0xF2EA, 0xEBF4,
0xDFF8, 0xFF4A, 0xE651, 0x0165, 0x00E7, 0xF5AA, 0x0555, 0x0225,
0x1771, 0x10CD, 0x0BDE, 0xFF1F, 0xFF3B, 0xE6E8, 0x102E, 0x0217,
0x011D, 0x1D70, 0xEF1B, 0xF962, 0xEC73, 0xE95C, 0xE15E, 0xFEDB,
0xEFD4, 0xFB25, 0x0D77, 0xF55D, 0x1AA4, 0x0D98, 0x1F50, 0x1874,
0x092D, 0xF4EB, 0xFE06, 0xE16B, 0x084B, 0x0D7E, 0xFDE3, 0x21B3,
0xFD61, 0xF6B0, 0xF4A9, 0xEF31, 0xD806, 0x074D, 0xEA0F, 0xFCE1,
0x05F4, 0xF2EE, 0x115F, 0x107D, 0x15B8, 0x17AB, 0xFDD9, 0xE687,
0x047A, 0xDA44, 0x0F83, 0x1689, 0xF689, 0x24BD, 0xFDE9, 0xF373,
0x0892, 0xF311, 0xEA27, 0x0B26, 0xE7FF, 0xF7E1, 0x035F, 0xEE21,
0x16D9, 0x12B9, 0x1A91, 0x15CC, 0x0311, 0xE717, 0x034C, 0xEA94,
0x09C9, 0x2200, 0xEF9E, 0x1FCC, 0xECE1, 0xF371, 0xF212, 0xF70D,
0xE5B2, 0x03A6, 0xEEEE, 0xE760, 0x0496, 0xE2F0, 0x21A4, 0x12ED,
0x24D9, 0x1226, 0x0B91, 0xE629, 0x1249, 0xFDDE, 0x0E32, 0x2EEA,
0xF271, 0x1513, 0xED58, 0xEAE2, 0xE176, 0xFB64, 0xD902, 0x034E,
0xFF1B, 0xDF1F, 0x1B34, 0xEC72, 0x1AAA, 0x248B, 0x1124, 0x11DB,
0x04E9, 0xE596, 0x0EB9, 0x0579, 0x02BF, 0x2E6C, 0xE61D, 0x083B,
0xEC66, 0xDEBE, 0xE781, 0xF77F, 0xDED8, 0xFFD8, 0x0580, 0xDE72,
0x2D36, 0xF915, 0x2E0B, 0x2C14, 0x0B98, 0x05A2, 0xFDE7, 0xE075,
0x1071, 0x0CEF, 0xFF3D, 0x2B1C, 0xE824, 0x02A9, 0xF150, 0xE3CD,
0xE70D, 0xFF43, 0xDAA2, 0x0234, 0xF8E4, 0xE230, 0x1B9A, 0x03CB,
0x29AD, 0x25ED, 0x0F5E, 0xF20F, 0xF747, 0xD9E3, 0x0AEC, 0x0DA4,
0x066E, 0x22FF, 0xF926, 0xFA1B, 0xFF5D, 0xF31B, 0xE799, 0x1355,
0xDDE3, 0xFD9C, 0xFD24, 0xDD01, 0x1245, 0x0A4F, 0x18D6, 0x1F93,
0x0E7D, 0xE79E, 0x085D, 0xE1E0, 0x09E4, 0x16EF, 0xF9C7, 0x22E7,
0xF57C, 0xFE5C, 0xF681, 0xFBFE, 0xDE66, 0x1469, 0xE0A0, 0xEE92,
0x04A2, 0xD30E, 0x1647, 0x0BBD, 0x1178, 0x1436, 0x0709, 0xDEF4,
0x1B63, 0xED4E, 0x2053, 0x24B1, 0xF45A, 0x2385, 0xED1F, 0xFBB7,
0xF6C3, 0xFE04, 0xE212, 0x0B98, 0xEA65, 0xE512, 0x054E, 0xDDAB,
0x0EF6, 0x130A, 0x0A01, 0x0B5E, 0xFBC9, 0xE3C0, 0x087D, 0x0114,
0x149B, 0x2BAC, 0x0068, 0x1802, 0xF2F2, 0xED81, 0xEF75, 0xF9F2,
0xE738, 0x043D, 0xF690, 0xDBDA, 0x131D, 0xE8CF, 0x1BDE, 0x1CAB,
0x0CA6, 0x088B, 0xFC88, 0xEBA8, 0x06C7, 0x0AB9, 0x08B2, 0x2553,
0x025E, 0x0A19, 0x0033, 0xED54, 0xE1CD, 0xFF75, 0xD497, 0xFC43,
0xF86E, 0xD80A, 0x12E4, 0xF446, 0x14B7, 0x238B, 0x06D9, 0x03C5,
0x036C, 0xE766, 0x116D, 0x0A55, 0x03BE, 0x2245, 0xF751, 0x041A,
0x0134, 0xEEF2, 0xF3DA, 0x021A, 0xE0F1, 0xF599, 0xF5FD, 0xDDFF,
0x12ED, 0x01D1, 0x1846, 0x1C9E, 0x0C0E, 0xFD11, 0x07EF, 0xF048,
0x0AE8, 0x11CB, 0xF577, 0x200E, 0xE7AF, 0x005E, 0xECA6, 0xF497,
0xEB0E, 0x02F9, 0xF154, 0xECC0, 0xFFB9, 0xDB4C, 0x127B, 0xFFAD,
0x1FC3, 0x11D4, 0x13FD, 0xF695, 0x0F34, 0xF8B5, 0x084C, 0x1967,
0xF2C1, 0x19EB, 0xEDE4, 0xFD70, 0xE52E, 0xFBDA, 0xDCDA, 0x0228,
0xF769, 0xE73B, 0x13A6, 0xE233, 0x128E, 0x0666, 0x0B2C, 0x0E91,
0x0562, 0xF927, 0x08A5, 0x00CE, 0x06C7, 0x1DE9, 0xF817, 0x17D6,
0xF52D, 0xF9C4, 0xEE0F, 0xFA54, 0xE3B5, 0xF8EE, 0xF449, 0xE1F7,
0x127B, 0xE83C, 0x1C23, 0x0533, 0x0742, 0x0668, 0xFD53, 0xF62E,
0x0EC4, 0x0289, 0x0AFB, 0x1C21, 0x0023, 0x1594, 0xFB28, 0x0252,
0xE966, 0x0095, 0xE27C, 0xF50A, 0xEC6C, 0xE6CE, 0xF8D3, 0xF3F1,
0x0CC3, 0x036B, 0x1777, 0xFC6C, 0x0E3D, 0xF38F, 0x0FD6, 0x03A5,
0x11C0, 0x1B9F, 0x0D1B, 0x1213, 0x0322, 0x03E7, 0xE8FD, 0x0553,
0xE077, 0xF0C2, 0xECF5, 0xE423, 0xF3BD, 0xF31F, 0x011F, 0xFF7E,
0x1275, 0xFE1E, 0x1C6C, 0xF970, 0x149B, 0x0BE8, 0x02A2, 0x1F0D,
0x0440, 0x10A6, 0xFB40, 0x05DD, 0xE237, 0x00F8, 0xE314, 0xEBF5,
0xF690, 0xE620, 0x0389, 0xF01B, 0x096C, 0xFB5C, 0x0C36, 0x0363,
0x1BC9, 0x017C, 0x20F0, 0x0E18, 0x0471, 0x1B3E, 0xF6C9, 0x0A85,
0xEFF0, 0x0024, 0xE45E, 0xF676, 0xF263, 0xE965, 0xFCB1, 0xF3E3,
0x0069, 0xFA41, 0x08B8, 0x0104, 0x0141, 0x093F, 0x04EC, 0x056E,
0x0FDE, 0x0EBD, 0x0D4C, 0x101F, 0x02A5, 0x009F, 0xF06F, 0xFC3D,
0xF2BC, 0xF001, 0x03E7, 0xEBE8, 0x058A, 0xFF89, 0x04B3, 0x0416,
0x0581, 0x0314, 0xFEAB, 0x03D6, 0xFD09, 0xFEF6, 0xF9BD, 0x0A61,
0x0557, 0x0C00, 0x1443, 0xFFBA, 0xF6BD, 0xFE51, 0xE800, 0xF2F6,
0xFE20, 0xF7A0, 0x03DA, 0x0569, 0x06BC, 0xFEA4, 0x05C0, 0x045F,
0x004C, 0x0171, 0x06AF, 0xF8D6, 0x01D3, 0x0A8E, 0x06A1, 0x0E07,
0x0F45, 0x060D, 0xFD67, 0x01B1, 0xF299, 0xF232, 0xF5E4, 0xF5CA,
0xFB3E, 0xFBD7, 0x060C, 0xF2AD, 0x04E6, 0x006A, 0x01AA, 0x080B,
0x07B7, 0x036C, 0x008E, 0x113F, 0xFFBD, 0x1472, 0xFD5A, 0x0FD5,
0xF23E, 0xFCEF, 0x00AB, 0xE30D, 0x0206, 0xF1C8, 0xF846, 0xF74C,
0x0ACD, 0xF0BA, 0x1280, 0x0551, 0x0EF8, 0x0C1B, 0x05A0, 0x11F3,
0xF7FA, 0x1B68, 0x02BC, 0x0D3A, 0xF770, 0x00AD, 0xE1B1, 0xEDA8,
0xF779, 0xDF3B, 0x067F, 0xF0F2, 0x01B9, 0xF617, 0x067E, 0xF9D9,
0x0865, 0x109C, 0x0DCB, 0x12EC, 0x08FE, 0x16B4, 0xFE0E, 0x19D8,
0x09BF, 0x0762, 0xFC73, 0xFA13, 0xE4F6, 0xE45C, 0xF219, 0xE15C,
0x01FB, 0xF9AA, 0x0FF3, 0xF5DE, 0x0C1B, 0xFD48, 0xF9A4, 0x12C7,
0x0614, 0x0DA6, 0x09B6, 0x0DC9, 0x0416, 0x0FC1, 0x0939, 0x0B93,
0xF366, 0xFE6F, 0xE892, 0xE377, 0xF3E7, 0xEE19, 0xF3FF, 0x0460,
0x0580, 0xF61A, 0x167B, 0xF9EC, 0x0C67, 0x09FC, 0x079D, 0x0AB1,
0x0412, 0x123A, 0x0AA4, 0x0DF4, 0x1183, 0x097D, 0xF313, 0x029A,
0xE7BF, 0xE767, 0xF37B, 0xEEC8, 0xEEC8, 0xFD2D, 0xFC3E, 0xED31,
0x0AD4, 0xF485, 0x0F21, 0x0509, 0x0CB6, 0x0D64, 0xF6FD, 0x16E2,
0x0518, 0x1512, 0x16A2, 0x13EF, 0xF9BA, 0x00CF, 0xF000, 0xE8FD,
0xFB13, 0xF6BB, 0x01D5, 0xF606, 0x08E6, 0xE75D, 0xFEEC, 0xFAD9,
0x0186, 0x080E, 0x0DEE, 0x0DD4, 0xFEEF, 0x17DD, 0x0239, 0x12C8,
0x098A, 0x0D0C, 0xF68B, 0xF436, 0xFC53, 0xE355, 0x0165, 0xFCA2,
0xFDE4, 0xF964, 0x0696, 0xE92D, 0xF776, 0xFED2, 0xF53A, 0x1107,
0x0263, 0x15BA, 0x0790, 0x106C, 0x19D9, 0x0DB5, 0x0D54, 0x0F3A,
0xF8C7, 0xF2FA, 0x04F7, 0xE78B, 0x043C, 0xFEB8, 0xFE33, 0xF807,
0xFDFB, 0xEC53, 0xF5C1, 0xFC35, 0xF404, 0x0A58, 0xEECB, 0x1162,
0xFA9A, 0x0DCA, 0x2141, 0x0EB5, 0x15A0, 0x0C67, 0xF14A, 0xF0EC,
0xF923, 0xF32B, 0x02A1, 0x0474, 0x096A, 0xF21C, 0x0AC0, 0xF09D,
0xFCBE, 0x0209, 0x0021, 0x0A7B, 0xF963, 0x1360, 0xFDBA, 0x1055,
0x174F, 0x1082, 0x0A45, 0x04F1, 0xF6E8, 0xE82C, 0xF534, 0xF439,
0xF949, 0x0202, 0x0A92, 0xE86E, 0x0DE8, 0xEBA1, 0x0096, 0x0D84,
0xFAB5, 0x19D3, 0xF832, 0x1239, 0x0101, 0x0E80, 0x0935, 0x1581,
0xF9D3, 0x005A, 0xFE4E, 0xE21C, 0x0ECB, 0xF709, 0x06E3, 0x031C,
0x0CCE, 0xEC37, 0x1254, 0xF43A, 0x0653, 0x0CE9, 0xF77D, 0x1A23,
0xEA4D, 0x13AE, 0xFED9, 0x0602, 0x082F, 0x0BA5, 0xEE25, 0xF87A,
0xF475, 0xE398, 0x0EA3, 0xFD40, 0x12E4, 0x013B, 0x0C6F, 0xEDA5,
0x0654, 0xFD44, 0xFFEE, 0x12F1, 0xF82A, 0x14C6, 0xF7B6, 0x0E7E,
0x0C4E, 0x0CF8, 0x13F3, 0x0B1E, 0xF94E, 0xF2EA, 0xF2CC, 0xEE96,
0x0137, 0x0830, 0x090A, 0xF8FA, 0x0D4A, 0xE119, 0xFBAE, 0xF87D,
0xEC6E, 0x0FA7, 0xF138, 0x0B2C, 0x00F9, 0x03DE, 0x17E7, 0x1410,
0x0E81, 0x1619, 0xF6F8, 0xF2AD, 0xF86F, 0xF438, 0xFC7A, 0x0B33,
0x0052, 0xF123, 0x0E86, 0xDB68, 0x0D9A, 0xF713, 0xF870, 0x13EE,
0xF417, 0x1427, 0x08AB, 0x0D03, 0x1A1A, 0x171B, 0x077D, 0x141B,
0xEAE8, 0xF375, 0xF3FB, 0xF02C, 0xFB36, 0xFC1F, 0xF75D, 0xDF6E,
0x05A1, 0xD734, 0x0AF2, 0x0077, 0xFE2D, 0x1873, 0xF1ED, 0x136D,
0xFED7, 0x1605, 0x14BC, 0x1EA4, 0x0929, 0x0641, 0xF93F, 0xEBE5,
0xFFEB, 0xFAE9, 0x061D, 0xFA2A, 0x065F, 0xDB97, 0x06A3, 0xE483,
0xF86E, 0x0D20, 0xE8C4, 0x16E7, 0xEF7C, 0x0A09, 0xFCC1, 0x0F60,
0x05D6, 0x1666, 0x01F2, 0xF8AC, 0x012D, 0xE363, 0x0F97, 0x00DC,
0x0A2A, 0x03D2, 0x04AD, 0xDDCE, 0x04C3, 0xEB9F, 0xE956, 0x16BE,
0xDC75, 0x1597, 0xF656, 0x03DC, 0x1372, 0x0C24, 0x1553, 0x11B5,
0x0579, 0xF884, 0x08FD, 0xF0C4, 0x1404, 0x0649, 0x05FF, 0xFC80,
0xF731, 0xDF6E, 0xF664, 0xF022, 0xE179, 0x1012, 0xD452, 0x068A,
0xF135, 0xFB41, 0x12CE, 0x0C2C, 0x1A73, 0x0CB8, 0x073B, 0xF971,
0x0157, 0x027F, 0x0BDE, 0x120E, 0x0407, 0xF40C, 0x0597, 0xDDBB,
0x0366, 0xFDDA, 0xE8DD, 0x1073, 0xE5D8, 0xFE42, 0xF9DC, 0xFEEB,
0x099F, 0x13F3, 0x0B5F, 0x0B8C, 0x009F, 0xF459, 0xFBBD, 0x0221,
0xFCF9, 0x0D6A, 0xFE04, 0xE64D, 0x0B19, 0xD265, 0x0A71, 0xFE6E,
0xE998, 0x163D, 0xE6A7, 0x002D, 0xFF39, 0x04CD, 0x01E6, 0x1970,
0xFE5E, 0x088F, 0x0288, 0xF58D, 0x11EB, 0x05D4, 0x12B1, 0x06A1,
0x02D2, 0xDFFE, 0x0BB0, 0xDAA0, 0x034E, 0x0408, 0xE1A6, 0x1374,
0xE11D, 0x073B, 0xF485, 0x0B3C, 0xFB8E, 0x1164, 0xF8EA, 0xFDC0,
0x0152, 0xF2F1, 0x157E, 0x03C2, 0x16C6, 0xF920, 0x0631, 0xD880,
0x035B, 0xE8C6, 0xF642, 0x1275, 0xDF28, 0x11EC, 0xF0BC, 0x0852,
0x07D0, 0x193C, 0x0B09, 0x142F, 0x0BD3, 0xF48A, 0x0550, 0xF39D,
0x09D9, 0x0586, 0x0747, 0xF00F, 0xFC6F, 0xD314, 0xFB55, 0xEF48,
0xE1EA, 0x1746, 0xD77D, 0x0F05, 0xFB92, 0x03B2, 0x1507, 0x15BE,
0x1236, 0x1190, 0x0BA5, 0xF2AD, 0x099B, 0xF562, 0x04FF, 0x04B3,
0xFA8D, 0xEC18, 0xFC13, 0xDB2D, 0x06BE, 0xFD28, 0xEFCE, 0x1B89,
0xE100, 0x1044, 0x0286, 0x08B6, 0x10C5, 0x1325, 0x0C0D, 0x0744,
0x08FF, 0xF625, 0x01A4, 0xFEEA, 0x02C4, 0xFD6C, 0xF447, 0xE023,
0xF387, 0xDAC6, 0x0324, 0xFFC5, 0xF247, 0x135E, 0xEB29, 0x0756,
0xFE0F, 0x0DE1, 0x09EB, 0x1911, 0x1140, 0x04C3, 0x15A3, 0xFB22,
0x150C, 0x0F05, 0x116F, 0x01A3, 0x031D, 0xD96C, 0xF97F, 0xDDB6,
0xF2B6, 0x01F7, 0xDB72, 0x0C9C, 0xE360, 0x0306, 0xFE5B, 0x0D93,
0xFCFE, 0x1934, 0x08B5, 0x069A, 0x18F5, 0xFC92, 0x1BB3, 0x092F,
0x168D, 0xFAE4, 0x0171, 0xD8BE, 0xFA2C, 0xDECE, 0xEBC3, 0x0395,
0xD6CC, 0x0C69, 0xED9A, 0x07CE, 0x0BC1, 0x18C9, 0x103C, 0x1CDD,
0x1354, 0x0A12, 0x1796, 0x06ED, 0x1667, 0x0532, 0x0D2B, 0xEA79,
0xF93B, 0xDA7E, 0xF15F, 0xE9C6, 0xE986, 0xFF90, 0xD77A, 0x0571,
0xEB72, 0x078D, 0x0804, 0x1686, 0x0EC5, 0x1447, 0x17CB, 0x0462,
0x122D, 0x09F3, 0x0DEC, 0x0587, 0x0C3A, 0xE6B3, 0x0486, 0xDE56,
0x04B3, 0xFA76, 0xF26F, 0x0E2B, 0xE665, 0x06CD, 0xF4ED, 0x090D,
0xF833, 0x1424, 0xFBD2, 0x09B8, 0x09EF, 0xFFD2, 0x0B6E, 0x077C,
0x08E9, 0x00EA, 0x08E8, 0xE8D2, 0x06E4, 0xE3A1, 0x07A3, 0xF947,
0xF72C, 0x0BD6, 0xE703, 0x0761, 0xF470, 0x0689, 0xF80C, 0x0EFD,
0xFB2B, 0x0763, 0x0D79, 0x06AC, 0x1672, 0x0F02, 0x19E6, 0xFE5A,
0x0C8F, 0xEB65, 0x01D6, 0xEF47, 0xFF4E, 0xF9E8, 0xEC1F, 0x0031,
0xE722, 0x05D5, 0xF0A9, 0x0BE7, 0xF632, 0x08D9, 0x039A, 0x01D2,
0x0D7C, 0x068B, 0x0FBB, 0x0937, 0x13D0, 0xF6E4, 0x0BA4, 0xE713,
0xFBA0, 0xF0B9, 0xF502, 0x0372, 0xEF78, 0x07E5, 0xF6AD, 0x0727,
0x0577, 0x12E3, 0x0742, 0x117A, 0x103C, 0x0388, 0x0F94, 0x074E,
0x02F2, 0x0185, 0x00F6, 0xEB36, 0xFB09, 0xE69F, 0xF729, 0xF2FB,
0xF017, 0x034F, 0xEBD0, 0x0A4A, 0xFD2A, 0x07F5, 0x0AA6, 0x0AE4,
0x0DBE, 0x0C6F, 0x0E83, 0x08A8, 0x096D, 0x0436, 0x01C4, 0xF7C1,
0xFD8E, 0xEB7F, 0xFF53, 0xF06F, 0xFF55, 0xFDF8, 0xFB0B, 0x07A9,
0xF734, 0x0C88, 0xFB4F, 0x0F5E, 0x0127, 0x0B1A, 0x0771, 0x0088,
0x0F3A, 0x0599, 0x05F1, 0x095A, 0xFE1E, 0xF47E, 0xFF2B, 0xE816,
0xFAD2, 0xEF9C, 0xF7D5, 0xFC0D, 0xF5BE, 0x0702, 0xF779, 0x08A1,
0xF880, 0x0A60, 0xFE92, 0x0B9D, 0x1071, 0x06F3, 0x1C8A, 0x0C6D,
0x19D6, 0x0E14, 0x0A65, 0xF9BA, 0x01B2, 0xEBAF, 0xFBB7, 0xF01C,
0xE93D, 0xF75E, 0xE34C, 0x00DF, 0xEBF9, 0x07D9, 0xF62E, 0x075D,
0x0232, 0x07C7, 0x11E0, 0x0CF2, 0x1CCE, 0x0EC6, 0x1542, 0x008A,
0x0B0D, 0xF1B5, 0x037E, 0xF001, 0xF742, 0xEE0D, 0xEAC3, 0xF3AA,
0xE91A, 0x026E, 0xF2DC, 0x0D96, 0x0050, 0x138A, 0x12EB, 0x0DFC,
0x1868, 0x0D53, 0x112D, 0x1139, 0x0876, 0xFB65, 0xFF1E, 0xE6EB,
0x004A, 0xEE55, 0xF5F6, 0xF5D1, 0xE9AB, 0xF882, 0xF13A, 0x041A,
0xF304, 0x0C5F, 0xF9EE, 0x0A74, 0x0A9F, 0x08F5, 0x14B3, 0x0B1B,
0x11DC, 0x05B9, 0x03CA, 0xF616, 0x04E5, 0xF026, 0x0E73, 0xF592,
0x04BA, 0xFD65, 0xF7FF, 0x0936, 0xF952, 0x0D87, 0xF194, 0x09A0,
0xEC08, 0x049C, 0xFC17, 0x02B6, 0x0A08, 0x08E2, 0x0E4F, 0x0117,
0x0660, 0xF0C9, 0x05E9, 0xF59E, 0x0FE6, 0xFC2E, 0x0307, 0xF9D9,
0xF9BD, 0x03CB, 0xF746, 0x0E92, 0xED1A, 0x0662, 0xF5BE, 0xFBE0,
0x0455, 0x00FB, 0x0F8A, 0x0D65, 0x12A6, 0x07DA, 0x0A5C, 0xF6D7,
0x0CA1, 0xFA8F, 0x09B0, 0x0219, 0xF4D6, 0xFD1F, 0xEF48, 0xFF83,
0xF6A7, 0x06F6, 0xF2A9, 0x0716, 0xFC79, 0x0118, 0x0DD3, 0x0458,
0x0FE0, 0x0A02, 0x0A54, 0xFCC9, 0x00B5, 0xF510, 0x06BB, 0xF923,
0x0553, 0xF7B4, 0xF369, 0xFC76, 0xFAA0, 0x06B7, 0x01B6, 0x0AFA,
0x0283, 0x0CF3, 0x0E38, 0x0FDD, 0x10D8, 0x103D, 0x0D3F, 0x075A,
0xFCB1, 0xF4F4, 0xEE3A, 0xEDB6, 0xFA0E, 0xF487, 0x00F1, 0xF31F,
0xFB15, 0xF754, 0xFFC4, 0x0CBE, 0x02B1, 0x13A7, 0x038A, 0x0871,
0x106A, 0x08FC, 0x1272, 0x125B, 0x08DC, 0x033B, 0xFA45, 0xEAFB,
0xF2B8, 0xEDDD, 0x020A, 0xF828, 0x0463, 0xFBC4, 0x003E, 0x0614,
0x0440, 0x1325, 0xFA18, 0x13BF, 0xFBC4, 0x0B4B, 0x0827, 0x083D,
0x0B74, 0x0717, 0x07A9, 0xFA50, 0xF928, 0xE8A3, 0xF936, 0xED3B,
0x0325, 0xFAA9, 0xFE53, 0xF9ED, 0xFB4C, 0x0494, 0xFE6D, 0x1106,
0xFA43, 0x0B0D, 0xFEF5, 0x0A75, 0x0E05, 0x0F93, 0x133F, 0x09C1,
0x11BB, 0xF8ED, 0x04D7, 0xF509, 0xFC98, 0xFFCA, 0x0035, 0xFB2B,
0xF5BE, 0xF3EC, 0xF023, 0x0091, 0xF388, 0x0B12, 0xF53B, 0x02EF,
0x023A, 0x0125, 0x0E0D, 0x0F84, 0x13F5, 0x0D8F, 0x0D1C, 0xF613,
0xFE92, 0xF385, 0x0017, 0x0445, 0x0215, 0xFB1E, 0xFC09, 0xEFCF,
0xF67B, 0x0146, 0xF3E2, 0x0A11, 0xF9F9, 0x0649, 0x0A99, 0x0B4F,
0x1435, 0x138E, 0x0CFE, 0x0FD3, 0x0054, 0xF972, 0xF674, 0xF15C,
0xFEA0, 0xFB50, 0x08C9, 0xF657, 0xFE9D, 0xF1EC, 0xF4C5, 0xFE98,
0xF26F, 0x02AB, 0xF897, 0xFF77, 0x0635, 0x0D85, 0x0DFE, 0x15CA,
0x0B4D, 0x016E, 0x0024, 0xF1EE, 0xFE2A, 0xFD47, 0x04CA, 0x00B0,
0x0A4B, 0xF3F9, 0x0715, 0xFF4A, 0xF7DF, 0x0E24, 0xF22B, 0x0286,
0xF4AC, 0xFFE8, 0xFBE8, 0x0B89, 0x06AA, 0x0D28, 0x0856, 0xF8FA,
0x0186, 0xE7CE, 0xF98A, 0xFE33, 0xFF26, 0x080C, 0x07ED, 0xF073,
0x03B3, 0xFA30, 0xFCA4, 0x1185, 0xF870, 0x0538, 0xFD28, 0xF9B5,
0x07CD, 0x0660, 0x0B59, 0x0CE9, 0x0424, 0xFC6D, 0xFAB1, 0xF312,
0xF80E, 0x0552, 0xFCC0, 0x07E3, 0x045F, 0xF7EE, 0xFBE2, 0xFFFC,
0xF674, 0x060B, 0x0385, 0xFCA8, 0x086D, 0xFE63, 0x0ADB, 0x05B7,
0x0571, 0x0408, 0xF6E4, 0xF215, 0xF156, 0xF3FD, 0xF376, 0x0AD3,
0x0273, 0xFD9E, 0x0B4C, 0xF607, 0x00ED, 0x0CDA, 0xFDF3, 0x0826,
0x0894, 0xFDC7, 0x0FED, 0x0CFC, 0x0946, 0x150E, 0xFC63, 0x020C,
0xF1DF, 0xE76E, 0xEA54, 0xF11F, 0xED94, 0x0A05, 0x036A, 0xF7C1,
0x1307, 0xEDA2, 0x05AE, 0x0BAE, 0xFD24, 0x0E4D, 0x0164, 0xFED6,
0x07A5, 0x074E, 0x0EA5, 0x1231, 0x02FD, 0xFFD9, 0xF752, 0xE16A,
0xF277, 0xF35C, 0xF338, 0x0C19, 0x0926, 0xFA34, 0x0FCD, 0x0047,
0xFE5B, 0x145A, 0xF749, 0x0C70, 0xFBC2, 0x05FA, 0x02E4, 0x04F2,
0x08BD, 0x02D7, 0x0882, 0xF56F, 0x008D, 0xE43E, 0xF7A8, 0xF72D,
0xF874, 0x061A, 0x02F8, 0xF666, 0xFFC6, 0x05D2, 0xF345, 0x1703,
0xFA6B, 0x021B, 0x04FC, 0xFEEF, 0x0B95, 0x0D56, 0x0C9C, 0x092B,
0x07E3, 0xF13F, 0x084D, 0xED4D, 0xF953, 0x0ED9, 0xF1D3, 0x08D9,
0xFD93, 0xEEC9, 0xF434, 0x03F1, 0xEC07, 0x0B9F, 0xFB25, 0xF9AF,
0x0C99, 0xFB1B, 0x13F9, 0x0A99, 0x0D81, 0x0C0D, 0x03DD, 0xF068,
0xFD10, 0xEE73, 0xF672, 0x11EA, 0xFA0D, 0x089C, 0x031D, 0xECE5,
0xF9E4, 0xFF0F, 0xF2BC, 0x0C0D, 0x00A1, 0x05E3, 0x0ED3, 0x0B0C,
0x148C, 0x0FEF, 0x09BE, 0x0AAC, 0xFB85, 0xF486, 0xF186, 0xF1A8,
0xEB9E, 0x042B, 0x00B6, 0xF49E, 0x0E4B, 0xEF9D, 0xFF96, 0x0568,
0xFA24, 0x0476, 0xFF97, 0x02EC, 0x08A0, 0x0E49, 0x0C5D, 0x130F,
0x03D4, 0xFF55, 0xFCB9, 0xE7FC, 0xF43E, 0xFB55, 0xF0EB, 0x0AF8,
0x04DB, 0xF58D, 0x12D5, 0xFEF6, 0x038F, 0x1956, 0xFA91, 0x0C14,
0xFE8B, 0x0099, 0xFE5B, 0x0822, 0xFC8B, 0x06BD, 0xFB21, 0xF330,
0xFEE0, 0xDE56, 0xFA88, 0xF621, 0xF847, 0x0DAD, 0x06DA, 0xFB06,
0x08FE, 0x00EA, 0x03D9, 0x16CC, 0x02B2, 0x100F, 0xFFB4, 0x016F,
0x013D, 0x0133, 0xFCD3, 0x054F, 0xFBDA, 0xF439, 0x019B, 0xED60,
0xFAC7, 0x066F, 0xFA50, 0x0B4C, 0x0640, 0xFF23, 0x019E, 0x0613,
0xF6CC, 0x0719, 0xFDB3, 0xFEA7, 0x07B7, 0x025F, 0x09A3, 0x0227,
0x02D7, 0xF9BC, 0xFBEC, 0xF196, 0xFAEC, 0xF6AB, 0xF63C, 0x0B15,
0xFC40, 0x0505, 0x05E9, 0xF7EE, 0xFE2C, 0x087C, 0xF889, 0x0E77,
0xFF89, 0x02E7, 0x1093, 0x0602, 0x1509, 0x12BC, 0x031C, 0x0613,
0xFAD0, 0xEC0A, 0xF46C, 0xF2A6, 0xE9F6, 0x006F, 0xF2AD, 0xF5C8,
0x00B6, 0xF22D, 0x0218, 0x0311, 0x01E8, 0x0D2B, 0x06C4, 0x08D7,
0x0EAF, 0x09CC, 0x1358, 0x10AF, 0x0956, 0x0700, 0xFC57, 0xEEBE,
0xF160, 0xEC72, 0xE7A8, 0xFB94, 0xF17F, 0xFC89, 0x017F, 0xFF9A,
0x0693, 0x0AD6, 0x06B7, 0x1075, 0x06E3, 0x1171, 0x0AD4, 0x0C4A,
0x05AE, 0x01CC, 0xFE6E, 0xF361, 0xFD8B, 0xEDC8, 0xF2AA, 0xF1A6,
0xED04, 0xF23E, 0xF73C, 0xF799, 0x010E, 0x0259, 0x0530, 0x0E51,
0x068F, 0x11FA, 0x08CF, 0x0A96, 0x0AC4, 0x0B27, 0x0284, 0x05B2,
0xF8B3, 0xF429, 0xFE4B, 0xF5D6, 0xFE58, 0x01FF, 0xF4F9, 0xFD40,
0xF7C0, 0xF7E5, 0xFAEC, 0xFFB6, 0xF99A, 0x05A0, 0xFCE3, 0x05A8,
0x0590, 0x0285, 0x0CBE, 0x02DC, 0x06A8, 0x035F, 0x006B, 0xFA64,
0x0102, 0xF5D0, 0xFFC0, 0xFBBE, 0xFE21, 0x0568, 0xFAD3, 0x0360,
0xF957, 0xF929, 0xF80B, 0x0302, 0xF8CE, 0x0C8F, 0x04F9, 0x09D1,
0x0F8E, 0x0C1D, 0x0B49, 0x04EC, 0x03E9, 0xFCF0, 0xFF7C, 0xFB5E,
0xF3C0, 0xF2CF, 0xF005, 0xF633, 0xFC02, 0x00E0, 0x0016, 0xFAB1,
0xFDAE, 0xFA2A, 0xFFCD, 0x07CC, 0x08A0, 0x0C53, 0x114D, 0x09A1,
0x0BEB, 0x027C, 0x03D9, 0xFE7F, 0xFCD7, 0xFF2C, 0xF094, 0xF852,
0xEC65, 0xFB82, 0xFAC4, 0x03D4, 0x0B2C, 0x0670, 0x07F3, 0x0C18,
0x022D, 0x06B2, 0x06F1, 0x01D2, 0x068A, 0x01F3, 0xFDB1, 0xF8A0,
0xFB99, 0xF6D5, 0xFE3E, 0xF61A, 0xF7CB, 0xF532, 0xF61A, 0x01C3,
0xFE83, 0x04EB, 0x0821, 0x03BA, 0x0ECA, 0x101B, 0x0A50, 0x0E99,
0x05E0, 0x01AB, 0x00BB, 0xFFE0, 0xF6B4, 0xFE9C, 0xFC25, 0xFEDA,
0x0350, 0xFB61, 0xFAED, 0xFA40, 0xF53D, 0x0996, 0xFD88, 0x05FD,
0x030F, 0xF927, 0x01FC, 0x03B3, 0x08A4, 0x0A61, 0x0C2B, 0x02CD,
0x051A, 0xF80E, 0xFD73, 0xF755, 0xFF46, 0xFEA0, 0x0153, 0xF96A,
0xF8FB, 0xFBA7, 0xF784, 0x09F9, 0x00B4, 0x08A7, 0x048E, 0x053D,
0xFE4B, 0x0B66, 0x02F8, 0x0BCC, 0x15D3, 0x09C7, 0x1196, 0x0226,
0xFEE0, 0xF78A, 0xFA2B, 0xF726, 0xF57B, 0xEFE2, 0xEE77, 0xF258,
0xF271, 0x0342, 0xFF66, 0x0082, 0x06A6, 0x049D, 0x0872, 0x1091,
0x0CCC, 0x07DD, 0x126C, 0x0156, 0x10C7, 0x0365, 0x03F9, 0x0324,
0xFCD4, 0xF669, 0xF4B6, 0xEB00, 0xE73E, 0xFE48, 0xEF38, 0x0DA1,
0x0479, 0x0574, 0x0B91, 0x0968, 0x07DB, 0x11AC, 0x099D, 0x0798,
0x0967, 0xFA10, 0x00FF, 0xF5BF, 0x0250, 0xFB4A, 0x0426, 0xF6B5,
0xF714, 0xE977, 0xEB4B, 0xFBD3, 0xF359, 0x0E25, 0x0699, 0x04C4,
0x0AA8, 0x092B, 0x0587, 0x1234, 0x097C, 0x0BC1, 0x0E13, 0x000F,
0x0427, 0xF968, 0xFE49, 0xFE33, 0x0777, 0xFAE7, 0xFCDA, 0xF60D,
0xE9E7, 0x0048, 0xEEAF, 0x01E5, 0xF903, 0xFC9A, 0xFCC2, 0x03F5,
0x0253, 0x07F5, 0x0D5F, 0x000C, 0x127B, 0xFD05, 0x0AC8, 0x0106,
0x045B, 0xFFAC, 0x025D, 0xF2DE, 0xFAF6, 0xF566, 0xF021, 0x0B3C,
0xF1FA, 0x06DA, 0xFB0E, 0xFBBB, 0xFC6F, 0x08C9, 0x036A, 0x0D1C,
0x106D, 0x03B4, 0x1059, 0xFF8F, 0x0374, 0x03C6, 0xFDDB, 0xFEB6,
0xF8E3, 0xE9FC, 0xEA19, 0xED15, 0xEC80, 0x04F2, 0xFCE6, 0x0479,
0x040B, 0xF974, 0x033F, 0x03F0, 0x040B, 0x0D2C, 0x0C46, 0x0281,
0x0D1D, 0xFDE5, 0x0485, 0x0572, 0x0185, 0x0130, 0xFB97, 0xF2C3,
0xEEA4, 0xF779, 0xEFFE, 0x0666, 0x046A, 0x070F, 0x0B48, 0x0854,
0xFF35, 0x09FE, 0xFB0D, 0x01F0, 0xFD71, 0xF90E, 0xFD6F, 0xF643,
0xFDEC, 0xFAAE, 0x021C, 0xF4D0, 0x018C, 0xEC73, 0xF938, 0xFAC5,
0xF80F, 0x07DB, 0x008E, 0x0409, 0x05CD, 0x0918, 0x0166, 0x15A4,
0xFF9C, 0x09D1, 0x027C, 0xF6EC, 0xFDE9, 0xFD0B, 0xFE79, 0x00AA,
0x085A, 0xF1E0, 0x04C9, 0xEEF7, 0xF4D8, 0x00B3, 0xEF9D, 0x093A,
0xF537, 0x00DB, 0xF59A, 0x0186, 0xFC15, 0x09DB, 0x0A75, 0x039A,
0x0D74, 0xF4D7, 0x0869, 0xF593, 0x03DC, 0xFB03, 0x032E, 0xF1BD,
0xFD97, 0xF3D9, 0xF19D, 0x0831, 0xF25F, 0x1080, 0xFC94, 0x0A6A,
0xFDB1, 0x0A1A, 0xFED3, 0x0C45, 0x0E60, 0x01B4, 0x155E, 0xFA8E,
0x0617, 0xFB84, 0xF8A0, 0xF2BE, 0xF1E3, 0xEB5E, 0xEB0A, 0xF294,
0xEBA0, 0xFF7B, 0xF911, 0x04B9, 0x0848, 0x046A, 0x0954, 0x0A25,
0x0963, 0x094D, 0x0E7D, 0xFB97, 0x0DA5, 0xFC89, 0x05E6, 0x0852,
0xFB37, 0xFCBC, 0xF511, 0xEDCF, 0xF02D, 0xF8A3, 0xEF60, 0x0448,
0xFD6F, 0x0318, 0x0BB2, 0x0351, 0x096D, 0x09EA, 0x0422, 0x08B3,
0x03BA, 0xFB54, 0xFD41, 0xF9EE, 0xF9E8, 0x0097, 0x002C, 0xF893,
0x0087, 0xECCC, 0xF947, 0xF046, 0xF405, 0xFEB7, 0xFC7C, 0x03B1,
0x0761, 0x0461, 0x05CC, 0x1047, 0x0780, 0x127E, 0x0870, 0x073D,
0x0119, 0x05F4, 0xFD33, 0x0188, 0x0266, 0xF2E0, 0x076D, 0xF0C7,
0xFD15, 0xF434, 0xF016, 0xF666, 0xF0BA, 0xFE38, 0xF583, 0x04F2,
0xFB79, 0x0AEB, 0x0829, 0x08CA, 0x1139, 0x01F3, 0x0C26, 0x035B,
0x0450, 0xFAE3, 0x01D7, 0xEDAC, 0x023F, 0xF27D, 0xFE06, 0xFFE7,
0xF320, 0x0654, 0xF43D, 0x05B5, 0xF9A4, 0x0DAF, 0xFDC7, 0x142C,
0x0D5F, 0x0542, 0x13DC, 0xFBFB, 0x09EC, 0x01AB, 0xFF5D, 0xF967,
0xF7AE, 0xEC1B, 0xF1F9, 0xEE5E, 0xF014, 0xF9D6, 0xF4FA, 0x05AC,
0xFC51, 0x0689, 0x00F1, 0x0557, 0x0773, 0x0868, 0x0F9D, 0x002D,
0x0FA3, 0xFE53, 0x08AC, 0x053C, 0x02F3, 0xFF8D, 0xFDA9, 0xFB51,
0xF92D, 0xFCEE, 0xF2DE, 0xFFDA, 0xF49E, 0x058D, 0x02F5, 0x0654,
0x03B7, 0x03FA, 0x0082, 0xFDC6, 0x04E5, 0xF873, 0xFFBA, 0xFDAA,
0xFB9F, 0xFE84, 0x0067, 0xF754, 0x03F8, 0xFA11, 0xFFEA, 0xFFB4,
0xF74C, 0xFE0D, 0xF65A, 0xFD49, 0xFF1A, 0x02F5, 0x083C, 0x0DA8,
0x0B16, 0x09ED, 0x0980, 0xFF1E, 0x0463, 0x0867, 0xFE2D, 0x0997,
0xFE5A, 0xFA21, 0x0236, 0xF6B0, 0xFFD6, 0xF820, 0xF3E0, 0xF999,
0xED2A, 0xFAB9, 0xF227, 0xFBD5, 0xFCC0, 0x03E3, 0x0CCC, 0x065C,
0x11A7, 0x047D, 0x07D2, 0x0660, 0x00F8, 0x017E, 0x00A9, 0xF92F,
0x032A, 0xF678, 0x006A, 0xF78B, 0xF835, 0xFFFD, 0xF561, 0x087D,
0xF8DD, 0x096F, 0xFFFB, 0x0978, 0x0BCF, 0x06E0, 0x1275, 0x0905,
0x0903, 0x08EA, 0xFD28, 0xF630, 0xF943, 0xEC6F, 0xF63E, 0xF1CC,
0xF4DE, 0xF324, 0xF501, 0xF90D, 0xF8FB, 0x0427, 0x00CF, 0x0D8C,
0x073A, 0x0C07, 0x0DDE, 0x0219, 0x10AE, 0x0628, 0x0D87, 0x0B25,
0x062F, 0xFE63, 0x0027, 0xF4E2, 0xFD97, 0xF8E2, 0xF6F3, 0xFE58,
0xF18A, 0x0183, 0xF64B, 0x0401, 0xFFD3, 0x08EB, 0x0623, 0x0889,
0x079A, 0xFCE0, 0x0265, 0xF8C1, 0xFD1F, 0xFB37, 0x0401, 0xF824,
0x0894, 0xF741, 0x00CB, 0xF876, 0xF97A, 0xFD3C, 0xF21F, 0x059D,
0xF3FF, 0x0954, 0x04A7, 0x086D, 0x0FF6, 0x059A, 0x0F22, 0x071E,
0x0898, 0x0864, 0x01D6, 0x0007, 0x0172, 0xF959, 0x064E, 0xFD49,
0x0174, 0x0068, 0xF15F, 0xFB4D, 0xE724, 0xFB45, 0xEAD4, 0x0012,
0xF9BB, 0xFCA3, 0x0AC7, 0xF981, 0x12D3, 0x00B3, 0x0B97, 0x0882,
0x00B8, 0x03BF, 0x02C2, 0xFA9E, 0x0631, 0xFD70, 0x03F4, 0x0659,
0xFCEE, 0x0578, 0xF04D, 0x0057, 0xF290, 0x0311, 0x0100, 0x041F,
0x0993, 0x0086, 0x0BF3, 0x016F, 0x06CA, 0x03E1, 0xFF27, 0x022C,
0xFCE7, 0xF9DC, 0xFC2E, 0xF407, 0xF955, 0xF601, 0xF664, 0xFB23,
0xF3E1, 0x03B2, 0xF858, 0x031F, 0x0467, 0xFE4D, 0x0B91, 0x05AB,
0x0BB5, 0x0AAE, 0x0847, 0x060B, 0x07F6, 0x01F7, 0x0AFC, 0xFF47,
0x048C, 0xFD39, 0xFB2B, 0xFB8B, 0xF386, 0xFC7F, 0xF146, 0x05AA,
0xFB6F, 0x0758, 0x0353, 0xFCE5, 0x056A, 0xFEA4, 0x0157, 0x056F,
0xFB12, 0xFFE2, 0x02D8, 0xF695, 0x0D02, 0xF40F, 0x0836, 0xFDAD,
0xFCA9, 0x0194, 0xF28B, 0xFDF1, 0xF10E, 0x05FA, 0x01FA, 0x0ACF,
0x117F, 0x0A94, 0x0F1A, 0x0CD1, 0x0756, 0x07B2, 0xFF90, 0x02F9,
0x0274, 0xFE70, 0x0B3D, 0xF4E7, 0x0549, 0xF6C1, 0xF839, 0xFD75,
0xEB25, 0xFDD1, 0xE9C3, 0x000F, 0xFB75, 0xFE15, 0x0DBF, 0x0200,
0x128D, 0x0CE8, 0x07AD, 0x0726, 0x003B, 0xFFB4, 0x06DE, 0xFD3D,
0x0864, 0xF795, 0x02E7, 0xF9E4, 0xFEFB, 0xFE21, 0xF586, 0x07AC,
0xF338, 0x0EAC, 0x0438, 0x043A, 0x0FEC, 0x058C, 0x0F28, 0x0FA4,
0x0836, 0x09CE, 0xFDBF, 0xFD70, 0xFE2A, 0xF088, 0xFD81, 0xEE2F,
0xF6D7, 0xF76F, 0xF5DE, 0xF907, 0xF48B, 0x0027, 0xFAF0, 0x0B2F,
0x09B3, 0x0806, 0x12A6, 0x0AC3, 0x1098, 0x0C7F, 0x07C5, 0x0585,
0x0706, 0x05C3, 0x0A7B, 0xFD18, 0x04B8, 0xF807, 0xF9C5, 0x01A1,
0xF126, 0x01BE, 0xEFD9, 0x02E7, 0xFB9B, 0x0217, 0x0B17, 0xFD4A,
0x0BDC, 0x0444, 0x0272, 0x00CF, 0xFB9E, 0xF888, 0x0045, 0xFE3F,
0x0974, 0x000B, 0x04B7, 0x009D, 0xFB81, 0x02A0, 0xF3EE, 0x0202,
0xF1D9, 0x0570, 0x02D6, 0xFCAE, 0x1543, 0xF97C, 0x154B, 0x0C54,
0x085F, 0x0DD9, 0xFE5B, 0x0678, 0xFFE3, 0x0566, 0x0565, 0xFF15,
0x0334, 0x0278, 0xF759, 0xFF2C, 0xED11, 0xF2F1, 0xEA7B, 0xF44F,
0xF4C9, 0xF166, 0x087A, 0xF66D, 0x102D, 0x0937, 0x07B0, 0x0FEB,
0x0013, 0x118B, 0x0532, 0x0A2F, 0x0A0D, 0xFCEF, 0x0635, 0xFDD2,
0xFF76, 0xFE7A, 0xF30D, 0xFB7E, 0xEFFE, 0xFA66, 0xFCE6, 0xF884,
0x06F3, 0x0692, 0x08DB, 0x1162, 0x04F9, 0x0981, 0x0225, 0x075A,
0x02CD, 0xFD71, 0x01B1, 0xED35, 0xFB62, 0xEC25, 0xF1B3, 0xF118,
0xEE53, 0xFDB0, 0xF337, 0x0370, 0x0145, 0x0085, 0x0EA5, 0x0EB5,
0x0B94, 0x12CE, 0x0537, 0x05F6, 0x0A60, 0x00EE, 0x0F15, 0xFB69,
0x0725, 0xF916, 0xFAB0, 0xFB32, 0xF05D, 0xFD56, 0xEB20, 0x06C9,
0xF30C, 0x07A4, 0x01D8, 0x0158, 0x0A6A, 0x035D, 0x04EE, 0xFD79,
0xFB63, 0xF58B, 0xFE78, 0xF420, 0x04B3, 0xF189, 0x0499, 0xFB6D,
0xFC16, 0x0817, 0xF142, 0x0A88, 0xF164, 0x08A1, 0xFBD9, 0xFEFD,
0x0DFE, 0x0048, 0x168C, 0x07EB, 0x0B3A, 0xFFCC, 0xFFA1, 0xFD83,
0xFC42, 0xFF84, 0xFE79, 0xFBDA, 0x00C9, 0xFFCF, 0xFAE8, 0x04AB,
0xF093, 0x03D5, 0xEDBF, 0xF9BA, 0xF7EB, 0xEAD9, 0x07AB, 0xF17E,
0x0DC2, 0x02BA, 0x039E, 0x05E4, 0xFD2F, 0x0873, 0x00D0, 0x09B9,
0x0103, 0x0506, 0x01F9, 0x01F2, 0x00B0, 0xFF96, 0xFB5C, 0x021E,
0xF934, 0xFD82, 0xFD43, 0xF31E, 0x0774, 0xFC2D, 0x07E9, 0x070F,
0x0017, 0x09FE, 0xFF12, 0x0CB8, 0xFF9D, 0x0175, 0xFE02, 0xF567,
0xF8E1, 0xF212, 0xF240, 0xF152, 0xF296, 0xF63A, 0xF851, 0xF835,
0xFFB6, 0xFCBB, 0x0A29, 0x0937, 0x0D97, 0x0CC0, 0x06CE, 0x0CDD,
0x0811, 0x0E47, 0x093E, 0x04E3, 0x0323, 0xFAEF, 0xFE7F, 0xF80C,
0xF3A5, 0xFB03, 0xECFD, 0xFEFD, 0xF465, 0xF8A9, 0x02B7, 0xFAC8,
0x0C58, 0x073C, 0x05E3, 0x03EA, 0xFEB2, 0xFEFC, 0xFFAC, 0xFE4C,
0x0065, 0xF989, 0x00E5, 0xFB0B, 0xFC2A, 0xFF3F, 0xF300, 0x03D8,
0xF00F, 0x0349, 0xF8E2, 0xFBC6, 0x0BB9, 0xFF6F, 0x18A9, 0x086F,
0x0EAF, 0x0924, 0x0253, 0x0777, 0x03A0, 0x018E, 0xFE11, 0xFA5D,
0xF941, 0xFC34, 0xF7B1, 0xFF69, 0xEFD0, 0xFF87, 0xF00A, 0xFB2D,
0xF582, 0xF2FE, 0x01A6, 0xF55B, 0x0F0F, 0xFBDC, 0x0BE5, 0x0193,
0x05CD, 0x0B63, 0x0251, 0x0836, 0xFDDA, 0xFE24, 0xFE76, 0xFDCD,
0xFEFF, 0x04EB, 0xFBCD, 0x0BA2, 0xFA70, 0x0445, 0xFEFD, 0xFB63,
0x06FB, 0xFDF8, 0x09CF, 0xFDB0, 0x0405, 0xFDCE, 0x0269, 0x0443,
0xFF32, 0x00DA, 0xF5FF, 0xF67B, 0xF820, 0xF623, 0xF6B5, 0xFC90,
0xF229, 0x01B0, 0xF817, 0x0176, 0x007A, 0xFF08, 0x0DBB, 0xFFC3,
0x0D9C, 0xFFBF, 0x025B, 0x0221, 0x0713, 0x055B, 0x0A39, 0x055B,
0x02E2, 0x0677, 0xFDDF, 0x0370, 0xF80C, 0x0100, 0xF294, 0x00D8,
0xF6A9, 0xFC75, 0x01B1, 0xFAEF, 0x099F, 0xF964, 0x0660, 0xF6DB,
0xFB32, 0xFBCD, 0xF92C, 0x011E, 0xFB63, 0xFEB7, 0xFDAF, 0xFF65,
0x00D8, 0x05D2, 0xFA31, 0x0472, 0xF915, 0xFDF2, 0xFF46, 0xFBD9,
0x0729, 0xFE2D, 0x1175, 0x02CD, 0x0CEB, 0x0827, 0x049D, 0x0C8E,
0xFFA6, 0x0959, 0xF554, 0xFF76, 0xF630, 0xF870, 0xFF45, 0xF8DA,
0xFC66, 0xFB1A, 0xF384, 0xF67A, 0xF476, 0xF3AB, 0xFF7D, 0xF8BB,
0x09E4, 0x0174, 0x090A, 0x0BFB, 0x0307, 0x0F6F, 0x00A9, 0x0947,
0xFAFE, 0xFEDE, 0xFBF5, 0xF7A6, 0x02B7, 0xF953, 0x0202, 0xFED0,
0x005E, 0x0500, 0xFFA1, 0x07B3, 0x062C, 0x043F, 0x0A0A, 0x0362,
0x00E5, 0x06D5, 0xFE0F, 0x06A1, 0xFE2B, 0xFE0B, 0xF9DC, 0xF358,
0xF72F, 0xF14C, 0xF421, 0xF5FB, 0xF569, 0xF9FC, 0xFCF8, 0x0330,
0x04E1, 0x0BFD, 0x0A5E, 0x04E8, 0x0B0C, 0xFEAE, 0x0730, 0x0215,
0x0649, 0x041B, 0x04A5, 0x0631, 0xFF24, 0x0380, 0xFFF9, 0x00CF,
0xFC46, 0x03E2, 0xF484, 0x0156, 0xF632, 0xFD4F, 0xFE75, 0xFB2E,
0x0A84, 0xF6D0, 0x0A38, 0xF5A4, 0xFFB5, 0xF85C, 0xFAF9, 0xFE33,
0xF6E0, 0x048F, 0xF7D4, 0x0707, 0xFE58, 0x0985, 0xFFDE, 0x077D,
0xFAD0, 0xFF42, 0xF7EA, 0xFBCC, 0x041A, 0xF6CD, 0x13D4, 0xF55D,
0x126A, 0x02DE, 0x0589, 0x0920, 0xFC5D, 0x0777, 0xF5B5, 0x093C,
0xF455, 0x04DD, 0xFA8D, 0x00BC, 0xFB10, 0xFAAB, 0xF9BD, 0xF23F,
0xFA5C, 0xF374, 0xFE05, 0xF12C, 0x04EB, 0xF166, 0x04E3, 0x00C7,
0x03A5, 0x0C50, 0xFF74, 0x0EBD, 0xF8B8, 0x099C, 0xFA89, 0xFF93,
0xFE8A, 0xFEFC, 0x02B2, 0x00BB, 0x0454, 0x0019, 0x0335, 0x00F7,
0x0602, 0xFA17, 0x0422, 0xF86F, 0xFE6F, 0xFF2F, 0xFD97, 0xFFE9,
0xFBE2, 0x037D, 0xF5A0, 0x00AD, 0xF634, 0xF66B, 0xFBC5, 0xF89F,
0xFB3B, 0xFC89, 0xFA61, 0x01C7, 0xFEF7, 0x05C2, 0x0966, 0xFD16,
0x0B00, 0xFD15, 0x0266, 0x012F, 0x0007, 0xFE16, 0xFF6B, 0x0532,
0x01DE, 0x0A7D, 0x045C, 0x052B, 0xFFEC, 0x0279, 0xFC79, 0x0041,
0xF91E, 0x01E2, 0xFE80, 0x01B9, 0x09B9, 0xF7BE, 0x07FE, 0xF6AD,
0x000A, 0xFA60, 0xF94A, 0xFBB2, 0xF5B5, 0x021E, 0xF9C2, 0x0224,
0x00D7, 0x02F3, 0x010D, 0x05E5, 0xFD88, 0x01D2, 0xFE8E, 0x03D9,
0x05F0, 0x019D, 0x0F66, 0xFCDF, 0x0F33, 0x0475, 0x0B59, 0x04B1,
0x0308, 0x0295, 0xF3F2, 0x055B, 0xF373, 0xFB3F, 0xFB66, 0xF695,
0xFE9C, 0xFE97, 0xFD2B, 0xFEF2, 0xFA79, 0xFE03, 0x02CF, 0xFB7C,
0x099F, 0xFB3E, 0x08A3, 0x0412, 0x069D, 0x0266, 0xFE65, 0x0256,
0xF84D, 0x07FB, 0xFA07, 0xFF58, 0xFED5, 0xFB88, 0x0420, 0x0239,
0x06C3, 0x0A4F, 0x06A0, 0x0DC4, 0x0B59, 0x0146, 0x0BF4, 0xFAB6,
0x0310, 0xFD28, 0xFF50, 0xF99B, 0xF8B2, 0xFFDB, 0xF4F6, 0x02D1,
0xFAA7, 0xF9A9, 0xF806, 0xFBE0, 0xF7E5, 0xFFFF, 0xFEE6, 0x023E,
0x06CC, 0x0628, 0x0D98, 0xFDC1, 0x09CA, 0xF990, 0x05DF, 0xFCCB,
0x02E4, 0xFE21, 0xFC0A, 0x0BCB, 0xFDB8, 0x10F7, 0x0348, 0x0703,
0x01A9, 0x05EF, 0xFD03, 0x0301, 0xFA69, 0xFA45, 0xFF34, 0xF33D,
0x0881, 0xF2ED, 0x05C2, 0xFA2E, 0xFF83, 0xF90A, 0xFCD6, 0xFDD9,
0xF5D8, 0x0F27, 0xFA87, 0x0EC3, 0x04B1, 0x054E, 0x052E, 0x0388,
0x0364, 0xFFF6, 0xFDA5, 0xFC4B, 0xFF51, 0xF77C, 0x0893, 0xF6B5,
0x0A5D, 0x0406, 0x0978, 0x08DF, 0x017F, 0x073F, 0xF9D2, 0x0E17,
0xFEB2, 0x0524, 0x00F0, 0xF752, 0xFDE2, 0xF889, 0xFC36, 0xFA33,
0xF8C4, 0xF968, 0xF979, 0xF737, 0xFF15, 0xF91C, 0x0258, 0xFF7D,
0x066C, 0x034D, 0x044A, 0x0B6A, 0xFFB7, 0x0C05, 0x04A0, 0xFDF8,
0x02AF, 0xFACE, 0xFE7E, 0x01B4, 0x008D, 0x0612, 0x024D, 0x087F,
0x07C3, 0x0205, 0x05B9, 0xFD33, 0x0193, 0xFC04, 0x023F, 0xF696,
0xFD33, 0xFEA5, 0xFC77, 0x05FC, 0xFDA3, 0xFA8E, 0xF926, 0xF8FB,
0xF944, 0x030A, 0xFC03, 0x069D, 0xFF4F, 0x0486, 0x06C8, 0xFE75,
0x0992, 0xFBDC, 0x060C, 0xF87A, 0x0036, 0xF6A3, 0xF87B, 0x0280,
0xFBB6, 0x0A65, 0x054B, 0x0969, 0x040A, 0x0845, 0x01FD, 0x049A,
0x0156, 0x01E4, 0xFF73, 0xFC9D, 0x0328, 0xF47F, 0x0560, 0xF3F5,
0xFFDC, 0xF5C2, 0xF2D4, 0xF991, 0xEE23, 0x05C3, 0xF981, 0x084A,
0x025F, 0x051A, 0x05D4, 0x0893, 0x0665, 0x05AE, 0x03C4, 0xFE6D,
0x0363, 0xF746, 0x02E2, 0xF59E, 0x0083, 0xFB90, 0xFF0F, 0xFFE7,
0xFBFC, 0x0776, 0xF929, 0x0D31, 0xFEE4, 0x04F3, 0x01C4, 0xFC13,
0x0030, 0xFC2B, 0x02FC, 0xFD55, 0xFE5A, 0xF840, 0xF7A0, 0xF01E,
0xFA38, 0xF377, 0x0062, 0xFD4E, 0x00D7, 0x024A, 0xFEDE, 0x08E9,
0x02C5, 0x0D4E, 0x0397, 0x0796, 0x011B, 0xFEE9, 0x0166, 0xFA00,
0xFEA7, 0xFC16, 0xFD93, 0x0052, 0x00CA, 0xFBBA, 0x047E, 0xF8AF,
0x088D, 0xFB2F, 0x019A, 0xFDC3, 0xF7CC, 0x0545, 0xFC43, 0x07ED,
0xFF48, 0x028C, 0xF74C, 0xFBD3, 0xF539, 0xF8F6, 0xFAEE, 0xFB49,
0xFF0D, 0xFC17, 0x0577, 0xFC6E, 0x0AC0, 0xFCAC, 0x08EA, 0xFCE4,
0xFFF9, 0x0144, 0xFA8E, 0x07BB, 0xFDFA, 0x08A8, 0xFED1, 0x0664,
0x00A1, 0x04E5, 0x01B9, 0x0251, 0x00B7, 0xFE2E, 0x0022, 0xF4A0,
0xFCD0, 0xF0AD, 0x0147, 0xF8C7, 0x009C, 0xFB84, 0xF4C4, 0xFA44,
0xF6BB, 0x00F2, 0xFFFC, 0x071D, 0x01BE, 0x07D9, 0x06D7, 0x06E7,
0x0B96, 0x072A, 0x048D, 0x037E, 0xFC5D, 0xF897, 0xFAF6, 0xF3B4,
0xFF29, 0xF603, 0xFFC3, 0xFC7B, 0xFB73, 0x02E0, 0x02EB, 0x0553,
0x0B73, 0x084C, 0x0658, 0x0679, 0x025C, 0x033E, 0x0154, 0x0493,
0xFB25, 0x00B9, 0xF105, 0xF445, 0xF1A0, 0xEED8, 0xFFFD, 0xF194,
0x009A, 0xF748, 0x0116, 0x038E, 0x0E5D, 0x0B26, 0x0D16, 0x0B9D,
0x05A3, 0x08CB, 0x0243, 0x06B7, 0xFBB6, 0x06C7, 0xF8DA, 0x000D,
0xFA6E, 0xF7BE, 0xFFCC, 0xF631, 0x07F0, 0xF68C, 0x016C, 0xF5DF,
0xFB28, 0xFBEC, 0x0516, 0x08AF, 0x01AA, 0x0B72, 0xF7B7, 0x02AC,
0xFB91, 0x01DB, 0x011D, 0x0319, 0x00E8, 0xFB74, 0xFFFD, 0xF812,
0x089A, 0xFBB5, 0x09CE, 0xFE3E, 0xF9B5, 0xFE41, 0xF6EE, 0xFF91,
0xFD2F, 0x03E4, 0xFCFB, 0x0A07, 0x041F, 0x08AA, 0x0BFF, 0x0441,
0x0D0D, 0x0185, 0x047F, 0xF721, 0xF798, 0xF410, 0xFB35, 0xFC33,
0xFB02, 0xFE4E, 0xEB17, 0xF9C6, 0xF130, 0xFCFE, 0x03D4, 0x0389,
0x0740, 0x02E1, 0x0F0D, 0x0709, 0x146C, 0x0AFB, 0x0B7B, 0x0424,
0xFE0F, 0xFC74, 0xF0FC, 0xFAB1, 0xF32F, 0xFBC1, 0xF631, 0xFEF1,
0xF6DB, 0x00C7, 0x083F, 0x0269, 0x1219, 0x0517, 0x0A84, 0xFFBD,
0x05F7, 0xFD88, 0x0545, 0x064F, 0xFCC0, 0x036B, 0xEB45, 0xF442,
0xEA0C, 0xF49A, 0xFCA7, 0xFD1A, 0x00F4, 0xFF1D, 0x0547, 0x0313,
0x154B, 0x0892, 0x108E, 0x0996, 0x0375, 0x06F4, 0xFEBA, 0x057A,
0xF7EC, 0xFF58, 0xF599, 0xF98E, 0xF4E0, 0xF956, 0xFC0C, 0xFC27,
0x0DAB, 0xFFFC, 0x074C, 0xFB9A, 0xFE73, 0xFC96, 0x082F, 0x0814,
0x0005, 0x0934, 0xF11F, 0x00A4, 0xF4DE, 0x0092, 0xFF45, 0xFEE7,
0x005E, 0xF4B4, 0xFF94, 0xF78C, 0x09AF, 0x023E, 0x0BFC, 0x0327,
0xFDD5, 0x004A, 0xF886, 0x027D, 0xFAE4, 0x0541, 0xF815, 0x0568,
0xFEE5, 0x04E1, 0x0AB4, 0x06F7, 0x10D3, 0x03C5, 0x0954, 0xF549,
0xF683, 0xF05F, 0xF74A, 0xFD35, 0xF825, 0x0325, 0xE869, 0xFA48,
0xF2FA, 0xFD6C, 0x0827, 0x053C, 0x0938, 0x04F8, 0x1083, 0x0B1D,
0x180A, 0x0D65, 0x0F51, 0x02E2, 0xFB45, 0xF7F5, 0xE673, 0xF6EE,
0xE466, 0xF6B4, 0xEB5A, 0xF73C, 0xF627, 0xFD0F, 0x0D6F, 0x05BB,
0x1C32, 0x0BC9, 0x1495, 0x06C0, 0x0B8F, 0x072B, 0x0805, 0x0B66,
0xF9C0, 0xFEA9, 0xE0C4, 0xEDA6, 0xDB6A, 0xF0D2, 0xF193, 0xF923,
0xFDBC, 0xF748, 0x0921, 0xFE6C, 0x1CF0, 0x0CD2, 0x1B16, 0x1037,
0x0DD0, 0x0D8D, 0x0096, 0x0B74, 0xF2E4, 0x007A, 0xEE23, 0xF3F9,
0xEC77, 0xF0A1, 0xF452, 0xF853, 0x0768, 0x007C, 0x076D, 0xFD04,
0x0293, 0xFE6B, 0x0BDF, 0x0951, 0x0541, 0x0A0C, 0xF3E0, 0x012B,
0xF636, 0x0230, 0x014A, 0xFD70, 0x0109, 0xF1D7, 0xFF98, 0xF7E0,
0x048D, 0x0302, 0x0654, 0x06B6, 0xFF87, 0x0650, 0xF9CC, 0x064B,
0xF74A, 0x00EA, 0xF69D, 0xFC1C, 0xFFF9, 0x01DF, 0x0DDC, 0x082A,
0x185C, 0x031B, 0x0DBC, 0xF635, 0xF6CB, 0xF896, 0xF38C, 0x06EA,
0xF0FC, 0x04EC, 0xE5F9, 0xF80A, 0xEF14, 0xFC01, 0x0320, 0x0100,
0x0AF2, 0xFCF8, 0x15C7, 0x05BF, 0x1F64, 0x0DA2, 0x17D6, 0x064E,
0x04FB, 0x009C, 0xECFA, 0x0004, 0xE078, 0xFB1B, 0xE458, 0xF9AF,
0xF0DC, 0xFA6C, 0x0610, 0x0003, 0x19D4, 0x0681, 0x18B7, 0x0474,
0x0F53, 0x08EF, 0x0BD1, 0x0C1D, 0xFE5D, 0x0046, 0xE8D5, 0xF20E,
0xE376, 0xF475, 0xEEC2, 0xF92E, 0xF926, 0xF8BC, 0x0A0D, 0x02C9,
0x1A5C, 0x0C27, 0x1B48, 0x0CED, 0x1227, 0x1022, 0x03A3, 0x1377,
0xF5EE, 0x01F1, 0xEF35, 0xEE2D, 0xEFD7, 0xEEE5, 0xF6AF, 0xF7C0,
0x05F1, 0xFE93, 0x09F8, 0xFE95, 0x05C3, 0x0443, 0x0AC4, 0x10E9,
0x04D7, 0x0EDA, 0xF79F, 0x04B1, 0xFBDB, 0x05D3, 0x03CC, 0xFCED,
0x0060, 0xEDE4, 0x01EB, 0xF200, 0x04A2, 0xFCBC, 0x0393, 0x0521,
0x0308, 0x0B8F, 0xFB20, 0x0CD1, 0xF46D, 0x04A8, 0xF995, 0x0143,
0x044F, 0x05E8, 0x0DB5, 0x0593, 0x1405, 0xFC97, 0x0A02, 0xF3F3,
0xF888, 0xF6EB, 0xF24E, 0xFDB2, 0xED77, 0x02B6, 0xE9EE, 0xFFD0,
0xF543, 0xFF93, 0x08B6, 0x00DA, 0x11C8, 0x00F9, 0x1964, 0x0D95,
0x1ABE, 0x0F5C, 0x0D92, 0x023F, 0x0004, 0xFEA4, 0xEC88, 0xFE96,
0xDAB6, 0xF495, 0xE0DC, 0xF2D1, 0xF77A, 0xFAC6, 0x0C1E, 0x0100,
0x1E69, 0x0540, 0x1F5C, 0x079C, 0x1307, 0x1120, 0x0AB6, 0x12E9,
0xF7D0, 0x0256, 0xE420, 0xF17D, 0xE1A3, 0xEF2E, 0xEACF, 0xF32E,
0xF8FF, 0xF7FF, 0x0B14, 0xFE28, 0x1611, 0x03F3, 0x198D, 0x0CED,
0x1725, 0x15F0, 0x0808, 0x1716, 0xF3AE, 0x024F, 0xE891, 0xF1E5,
0xEEDE, 0xF2EC, 0xF726, 0xF27A, 0x0058, 0xF710, 0x058A, 0xFE53,
0x01A1, 0x049A, 0x046B, 0x0861, 0x04ED, 0x0957, 0xFDFB, 0x07BD,
0xFE70, 0x069D, 0x031C, 0xFD78, 0x0152, 0xF400, 0x054D, 0xF915,
0x0278, 0xFA41, 0xF893, 0xFE92, 0xFA96, 0x0964, 0xF546, 0x09F2,
0xEF36, 0xFB8D, 0xF87D, 0xF3FF, 0x0806, 0x0058, 0x1514, 0x0906,
0x18BB, 0x014A, 0x0C3E, 0xF7E6, 0xF9AF, 0xF9FA, 0xEBDA, 0xFF1D,
0xE2C0, 0x03CC, 0xE225, 0xFDCF, 0xEB1B, 0xF62B, 0x017E, 0xF98C,
0x1564, 0xFFBB, 0x1FDC, 0x0859, 0x1EC6, 0x09B2, 0x0CC4, 0x0578,
0xFDF1, 0x03D0, 0xEC9E, 0x0034, 0xD612, 0xF17E, 0xD6F4, 0xEDEF,
0xEDB5, 0xF8FA, 0x0326, 0xFB3C, 0x1B52, 0xFEED, 0x236F, 0x07D4,
0x1362, 0x0F7D, 0x03F5, 0x097E, 0xEFF3, 0xFE8A, 0xE2AC, 0xF500,
0xE218, 0xEA69, 0xE831, 0xEC49, 0xF845, 0xF89C, 0x0A75, 0x04E8,
0x14EA, 0x07B3, 0x1823, 0x0AE3, 0x1540, 0x115E, 0x047D, 0x11BA,
0xEC3A, 0xFF69, 0xDE11, 0xE7A9, 0xE99C, 0xE5C7, 0xF9AA, 0xEE68,
0x02D3, 0xF8A4, 0x09E6, 0x04C1, 0x031A, 0x0CCE, 0x0079, 0x0A11,
0x0294, 0x0A46, 0xFA66, 0x06AE, 0xF468, 0xF882, 0xF857, 0xF370,
0xFD28, 0xF230, 0x0571, 0xF2A9, 0x078A, 0xF71B, 0xFF2D, 0x0401,
0xFDC0, 0x0FFA, 0xF5D0, 0x0D18, 0xEC17, 0xFBBC, 0xF0A9, 0xF345,
0x0021, 0xFCF0, 0x0DBA, 0xFD83, 0x10D8, 0xFB2C, 0x0D9E, 0xFCF7,
0x00E1, 0x0073, 0xF117, 0xFE29, 0xE65D, 0xFCE1, 0xE208, 0xFFFE,
0xE543, 0xF594, 0xFB94, 0xF265, 0x15D8, 0xFEB9, 0x2027, 0x0A52,
0x1FA0, 0x0ED4, 0x0E97, 0x0E2B, 0xFE8E, 0x0649, 0xF10C, 0x0037,
0xD991, 0xF4FA, 0xCD54, 0xE461, 0xDF80, 0xED3A, 0x00F0, 0xF7C2,
0x1E51, 0xFCB2, 0x2C30, 0x0C0D, 0x1DB5, 0x1660, 0x07D7, 0x140E,
0xF50A, 0x0BBE, 0xE359, 0xF8FA, 0xD825, 0xE34F, 0xDC6A, 0xE44B,
0xF0CE, 0xF2B9, 0x047F, 0xFF8A, 0x16AA, 0x02DD, 0x20D5, 0x0F80,
0x1F68, 0x1EF6, 0x1033, 0x1857, 0xF3EE, 0x06B1, 0xDB24, 0xEBD1,
0xDD33, 0xE1A6, 0xF0AB, 0xE8FE, 0xFC46, 0xED8D, 0x07B3, 0xFD10,
0x07D4, 0x10EF, 0x03EF, 0x0D6E, 0x09A7, 0x0B36, 0x062F, 0x1008,
0xF6E5, 0xFB46, 0xF0C9, 0xF0AE, 0xF8F6, 0xF1D1, 0x0130, 0xF232,
0x0992, 0xFC38, 0x0447, 0x04FF, 0xFA27, 0x0FF6, 0xFAA2, 0x12BA,
0xF7C0, 0x03E4, 0xF054, 0xF12E, 0xF44D, 0xEDE6, 0x0649, 0xF59B,
0x0FEB, 0xFD72, 0x12D5, 0xFD5C, 0x0B06, 0x0101, 0xF7BA, 0x0843,
0xEC69, 0x0730, 0xE6E2, 0x0A86, 0xE212, 0xF806, 0xEE67, 0xE7FF,
0x0B8D, 0xF8CE, 0x17D2, 0x02B3, 0x1C27, 0x0455, 0x1A83, 0x0DF1,
0x09D3, 0x0ECF, 0xFBC8, 0x06CC, 0xE936, 0xFF21, 0xD1B2, 0xEC6E,
0xD342, 0xEB03, 0xF55C, 0xF1AC, 0x1197, 0xF42A, 0x2385, 0x0738,
0x258A, 0x1320, 0x0F22, 0x1484, 0xFD80, 0x0E64, 0xF21A, 0x03D1,
0xE2BD, 0xF316, 0xD986, 0xE362, 0xE82C, 0xE9DB, 0xFC60, 0xFC5E,
0x12E9, 0x0451, 0x265E, 0x0C5F, 0x1F55, 0x1B45, 0x11D5, 0x1752,
0xFFB6, 0x104D, 0xE14B, 0xF95E, 0xD288, 0xDCF9, 0xE95A, 0xE336,
0xFDBC, 0xED24, 0x051D, 0xF9CB, 0x1196, 0x0C67, 0x11C1, 0x10ED,
0x1043, 0x1341, 0x0B57, 0x1819, 0xF509, 0x04C0, 0xE477, 0xF140,
0xF061, 0xF0F5, 0xFC66, 0xEFC5, 0x02DD, 0xF46A, 0x0F05, 0xFD48,
0x0BC3, 0x1117, 0x0969, 0x184B, 0x08CC, 0x0C57, 0xF6D4, 0x02BF,
0xE69D, 0xF692, 0xF4BF, 0xF422, 0x0528, 0xF92D, 0x083B, 0xFAF6,
0x1053, 0xFE3F, 0x0404, 0x04C3, 0xF443, 0x0189, 0xF620, 0x079F,
0xF3CE, 0x0732, 0xEC90, 0xF097, 0xFA38, 0xF5D2, 0x0DD8, 0x043E,
0x1440, 0x0890, 0x1CD8, 0x0BA2, 0x1093, 0x0C71, 0x011B, 0x09D1,
0xF93E, 0x00AA, 0xDE60, 0xF412, 0xCA95, 0xE713, 0xE528, 0xE95E,
0x0EC3, 0xF7A2, 0x1BF6, 0x07CA, 0x25B0, 0x0CC6, 0x1D44, 0x11A3,
0x065B, 0x13FE, 0xFD2B, 0x06B6, 0xEA84, 0xF97F, 0xCF63, 0xE436,
0xD29C, 0xE159, 0xF18C, 0xF710, 0x0B59, 0x0111, 0x28E1, 0x0660,
0x2F23, 0x1805, 0x1D67, 0x1CEE, 0x1147, 0x0FB8, 0xF4AB, 0x022F,
0xCFB1, 0xE925, 0xCC8A, 0xDCB6, 0xE502, 0xE533, 0xF5ED, 0xF619,
0x126B, 0x04BC, 0x23BB, 0x0ADE, 0x179A, 0x1326, 0x1449, 0x1420,
0x0CC9, 0x0E14, 0xED40, 0xF990, 0xD948, 0xE7F8, 0xE933, 0xEE67,
0xF55C, 0xF9EA, 0x051B, 0xFBC6, 0x1317, 0x0497, 0x1148, 0x1535,
0x1907, 0x0FA9, 0x0B50, 0x07AD, 0xE76D, 0xF7C9, 0xDE30, 0xE4ED,
0xF604, 0xF023, 0x017A, 0xFF10, 0x0C4B, 0xFE8C, 0x138C, 0xFDA1,
0xFF8F, 0x088C, 0xFEBD, 0x0CAB, 0x0491, 0x0986, 0xF44B, 0xFC2D,
0xE444, 0xED3D, 0xF1EB, 0xF672, 0x0557, 0x034E, 0x154F, 0x0704,
0x2543, 0x0AF9, 0x1799, 0x1193, 0x0602, 0x077A, 0xF5B8, 0xFBB4,
0xDC5F, 0xF485, 0xD340, 0xE355, 0xEC31, 0xE790, 0x03AF, 0x00BC,
0x16A4, 0x0C7A, 0x2BF1, 0x0AD1, 0x1B39, 0x1359, 0x0D60, 0x12D2,
0x097D, 0x0638, 0xE7B3, 0xF5F0, 0xC787, 0xDD30, 0xD70B, 0xE17C,
0xF919, 0xFD9D, 0x12A0, 0x0BE7, 0x2CD1, 0x0F17, 0x2BC7, 0x1CE2,
0x20E5, 0x1D90, 0x1084, 0x0BF9, 0xEB98, 0xFA20, 0xC9D0, 0xDA07,
0xCA89, 0xD265, 0xE477, 0xEC81, 0x0055, 0xFE71, 0x267E, 0x05B2,
0x2BCF, 0x1919, 0x1CE7, 0x2604, 0x1AFD, 0x18F7, 0x0381, 0x0A82,
0xDAAD, 0xF094, 0xD00A, 0xDD45, 0xE0EE, 0xE75F, 0xEEC5, 0xF456,
0x1455, 0xFB78, 0x2D4A, 0x0F20, 0x27C5, 0x20CD, 0x2158, 0x177C,
0x0496, 0x0D0F, 0xDC45, 0xF47D, 0xCF60, 0xDBEB, 0xE43C, 0xEC35,
0xF967, 0xFBCD, 0x0EC0, 0xF55D, 0x1522, 0xFE8A, 0x126B, 0x14D3,
0x2091, 0x1829, 0x1790, 0x13CD, 0xED4C, 0xFD37, 0xD2D3, 0xE4D8,
0xE4BD, 0xF0C1, 0xF85C, 0x01A5, 0x1159, 0x0147, 0x2914, 0x0531,
0x1BC7, 0x1442, 0x0D4B, 0x0EA0, 0x01F1, 0xFFEA, 0xE651, 0xF113,
0xD468, 0xDF55, 0xE6BC, 0xEA13, 0xFA82, 0xFF2E, 0x12F0, 0x01A1,
0x2974, 0x0985, 0x1EE5, 0x215F, 0x1853, 0x1B5F, 0x08FA, 0x0821,
0xE29E, 0xF760, 0xC8AC, 0xD8A5, 0xD67F, 0xDF07, 0xF533, 0xFB93,
0x165C, 0x0417, 0x35EE, 0x0D9E, 0x31D6, 0x2210, 0x2189, 0x2458,
0x0EE3, 0x1287, 0xE65D, 0xF7AB, 0xB7DB, 0xD16C, 0xBCCB, 0xCD66,
0xE93A, 0xE968, 0x0ACC, 0xFB91, 0x2CF3, 0x0508, 0x3494, 0x1CD7,
0x2CB8, 0x2F84, 0x2586, 0x229B, 0xFDA1, 0x0BE3, 0xC972, 0xE469,
0xBB6C, 0xCF25, 0xCCC7, 0xE353, 0xEF84, 0xEEC2, 0x27D3, 0xF78F,
0x3D30, 0x1B93, 0x3474, 0x309C, 0x26EA, 0x1F32, 0x01B1, 0x0B7C,
0xD430, 0xEA7F, 0xC0E3, 0xD525, 0xD21C, 0xE1F3, 0xEA21, 0xE978,
0x0B3E, 0xF007, 0x26BB, 0x0A09, 0x2BE9, 0x2788, 0x2BF8, 0x2A95,
0x19CD, 0x1B39, 0xE4C5, 0xF8F2, 0xBE9D, 0xDA48, 0xCEFD, 0xE21D,
0xEB21, 0xF2C6, 0x1558, 0xF58B, 0x2E9D, 0x028C, 0x1F70, 0x1CF8,
0x1D97, 0x195A, 0x0EF8, 0x0DF8, 0xE129, 0xFAC6, 0xC7E8, 0xD7D1,
0xD580, 0xDF86, 0xEAEE, 0xF438, 0x0D7A, 0xF56C, 0x2C20, 0x0521,
0x2B4D, 0x23A7, 0x218B, 0x23D0, 0x0BF8, 0x0DD0, 0xE69A, 0xF377,
0xC0CE, 0xD906, 0xC6D2, 0xE13A, 0xEA93, 0xF144, 0x0F6A, 0xF95E,
0x3A29, 0x0C31, 0x3A9C, 0x27B4, 0x1FF9, 0x28A4, 0x0B3C, 0x0C04,
0xDEFE, 0xF177, 0xB374, 0xCD5E, 0xBF88, 0xC576, 0xDF08, 0xE558,
0x0448, 0xF9D2, 0x388A, 0x0860, 0x3F98, 0x2CD3, 0x30D8, 0x3BF2,
0x22CF, 0x2325, 0xF399, 0x0598, 0xB834, 0xD789, 0xA629, 0xC038,
0xC964, 0xD412, 0xFF28, 0xE9CB, 0x3563, 0x0274, 0x4D65, 0x25A7,
0x3C91, 0x376A, 0x209E, 0x2843, 0xFC55, 0x0CDF, 0xC3CA, 0xDFA2,
0xAB99, 0xC3B7, 0xC4BD, 0xD0C8, 0xDFCD, 0xDF0B, 0x186F, 0xEC27,
0x4834, 0x1705, 0x41B7, 0x438E, 0x36C4, 0x34B7, 0x1590, 0x15F6,
0xD091, 0xF6E0, 0xACEF, 0xD284, 0xBDF5, 0xD3B3, 0xDEAE, 0xE309,
0x1534, 0xEDE2, 0x3C81, 0x09C6, 0x36EB, 0x28E9, 0x2947, 0x24B9,
0x1248, 0x1568, 0xE500, 0xF864, 0xB9A8, 0xD124, 0xBFEC, 0xD5FF,
0xE154, 0xE861, 0x0A32, 0xF284, 0x36A7, 0x0B8B, 0x3661, 0x2D0B,
0x25D4, 0x2AD3, 0x1977, 0x11B1, 0xE5E5, 0xFAFA, 0xB2E4, 0xD633,
0xC3A2, 0xCFBE, 0xE795, 0xEC20, 0x125A, 0xFCA5, 0x45C6, 0x0928,
0x3C43, 0x28C4, 0x1DC9, 0x2CFD, 0x08E5, 0x0D08, 0xDB32, 0xEE86,
0xB335, 0xC9EA, 0xB923, 0xC885, 0xDCE0, 0xE693, 0x0DB3, 0xF5FD,
0x436D, 0x0F8D, 0x4F74, 0x3B44, 0x3747, 0x3F11, 0x18EB, 0x1A8D,
0xE4DC, 0xFC74, 0xA52E, 0xD0EC, 0x9F23, 0xB8CD, 0xCF63, 0xD343,
0x03AF, 0xF4FE, 0x47AF, 0x0C61, 0x5CA6, 0x2DD5, 0x3758, 0x422D,
0x20D0, 0x2528, 0xF895, 0x01AE, 0xB20F, 0xD6C3, 0x9AA1, 0xB59C,
0xBA5D, 0xC75A, 0xEA57, 0xE5D3, 0x32D9, 0x01AD, 0x5935, 0x2DA6,
0x4AA0, 0x4AD6, 0x371E, 0x3467, 0x08A0, 0x173D, 0xC1DC, 0xE970,
0x9D48, 0xB88E, 0xB51B, 0xC577, 0xE2D8, 0xE3A2, 0x22CE, 0xF3E0,
0x510D, 0x1459, 0x40AF, 0x3CD3, 0x29D8, 0x33F9, 0x1269, 0x11EC,
0xD709, 0xF0E9, 0xA761, 0xCC0D, 0xB80B, 0xCA99, 0xDD0B, 0xDEE0,
0x1407, 0xF4D5, 0x4B2D, 0x1687, 0x4310, 0x3919, 0x2DCB, 0x30B0,
0x1542, 0x1545, 0xD95E, 0xFA9B, 0xAA15, 0xCD5D, 0xB639, 0xC950,
0xE23B, 0xEBDA, 0x1CA1, 0xFE97, 0x4BE3, 0x0E0F, 0x3E80, 0x2DD6,
0x2133, 0x2BBA, 0x0B2D, 0x0A1D, 0xDD57, 0xEE79, 0xAB76, 0xC922,
0xAFD6, 0xC38F, 0xDC93, 0xE4A8, 0x136A, 0x058D, 0x50CB, 0x1EA3,
0x545C, 0x3A38, 0x2E49, 0x3B9D, 0x0D99, 0x1731, 0xDA85, 0xEF92,
0xA22E, 0xC0AA, 0xA270, 0xB6B0, 0xD392, 0xDAB4, 0x1234, 0xFCF6,
0x557F, 0x1775, 0x59FC, 0x3B48, 0x32CF, 0x45D9, 0x14A0, 0x1A6C,
0xE39B, 0xF242, 0xA5C3, 0xC991, 0x946E, 0xAF0B, 0xBD42, 0xC5C4,
0xFC49, 0xEFBC, 0x4A50, 0x15E8, 0x69B2, 0x3BA0, 0x4B16, 0x5013,
0x2698, 0x3501, 0xF349, 0x0A8D, 0xAD78, 0xD319, 0x8CF6, 0xAD24,
0xB0FB, 0xC130, 0xEDAD, 0xE5AE, 0x3726, 0x0396, 0x5E84, 0x25A2,
0x476E, 0x4254, 0x2D84, 0x32AE, 0x083B, 0x0E29, 0xC515, 0xE347,
0x9963, 0xBB65, 0xAA5E, 0xBED3, 0xD82D, 0xE170, 0x217F, 0x028B,
0x590D, 0x21DF, 0x4B61, 0x4430, 0x2F7C, 0x3939, 0x0EC4, 0x107C,
0xD372, 0xE5F1, 0xA44D, 0xC200, 0xB1A7, 0xC9B6, 0xDF4A, 0xE5B3,
0x1CAD, 0xFC59, 0x4B48, 0x17CC, 0x3B29, 0x3831, 0x1F63, 0x2EF1,
0x0997, 0x09F6, 0xD9F8, 0xE705, 0xA9FC, 0xC0F6, 0xB328, 0xC036,
0xDFBE, 0xE4CD, 0x1CFF, 0x0CC3, 0x5761, 0x24B1, 0x4D1B, 0x3B99,
0x24E3, 0x3986, 0x027E, 0x11CB, 0xCF08, 0xE69F, 0x9F48, 0xBBC2,
0xAACB, 0xB683, 0xE019, 0xDC9B, 0x1E1F, 0x04EC, 0x592F, 0x1F50,
0x5665, 0x3DAF, 0x3002, 0x412F, 0x0D2B, 0x15C0, 0xD7AD, 0xE80F,
0x9E77, 0xBB55, 0x97A5, 0xAE27, 0xC4CB, 0xD0C5, 0x0B88, 0xFC66,
0x5BD1, 0x1EE4, 0x6C4D, 0x45C5, 0x445E, 0x5505, 0x1C96, 0x2DDE,
0xE7B9, 0xF5F6, 0xA672, 0xC142, 0x90CE, 0xABBE, 0xB68F, 0xC293,
0xF592, 0xECDA, 0x4175, 0x10C3, 0x5ED6, 0x33C5, 0x47D4, 0x4AD6,
0x2DB6, 0x3249, 0xFEFB, 0x08A0, 0xBA24, 0xD71A, 0x9A04, 0xAF51,
0xAFEA, 0xB937, 0xE307, 0xE6A6, 0x30A6, 0x0F66, 0x57ED, 0x3080,
0x468A, 0x4950, 0x2E8B, 0x3720, 0x060F, 0x0EFB, 0xC85B, 0xDE76,
0xA4D4, 0xBAF9, 0xB7C3, 0xC44E, 0xE4AB, 0xE2F1, 0x2343, 0xFFD2,
0x49B6, 0x1ED6, 0x3B8C, 0x3E10, 0x255E, 0x34D6, 0x09DC, 0x0C19,
0xD6E3, 0xDED5, 0xAFC5, 0xBDB6, 0xB82C, 0xC496, 0xDDB0, 0xE8A2,
0x2311, 0x0BFA, 0x54E8, 0x2723, 0x405A, 0x4026, 0x2203, 0x3781,
0x036B, 0x0FFD, 0xCEDF, 0xE32A, 0xAD00, 0xBD5E, 0xBCC0, 0xBC45,
0xE656, 0xDDEB, 0x1FDB, 0x0586, 0x4B8D, 0x2810, 0x4447, 0x40D7,
0x2A23, 0x3418, 0x096E, 0x10EA, 0xD4C5, 0xE97C, 0xA7A1, 0xBF3B,
0xAC9C, 0xB522, 0xD8FF, 0xD42A, 0x1C43, 0x024E, 0x5802, 0x2842,
0x5496, 0x4612, 0x301E, 0x4749, 0x0E57, 0x2256, 0xD914, 0xED08,
0xA7DC, 0xBE8C, 0xA99E, 0xB55C, 0xC9DB, 0xCF24, 0x0482, 0xF30E,
0x4A89, 0x1688, 0x5962, 0x3BE1, 0x403E, 0x4579, 0x1DCD, 0x284E,
0xE9C9, 0xFDE4, 0xB6C3, 0xCD33, 0xA537, 0xB32C, 0xBA75, 0xC562,
0xF49B, 0xEE2A, 0x3947, 0x1846, 0x520B, 0x3DB0, 0x455C, 0x4782,
0x2B1C, 0x2DF5, 0xFB48, 0x055A, 0xC160, 0xD9C7, 0xAC8C, 0xBF33,
0xC01E, 0xC312, 0xE619, 0xDE6C, 0x1FC3, 0x068A, 0x3EBC, 0x2F9E,
0x364A, 0x3F43, 0x2995, 0x2D72, 0x09D0, 0x0B18, 0xD901, 0xE083,
0xBE6D, 0xC114, 0xBFA1, 0xC7B1, 0xE3C7, 0xE968, 0x212E, 0x08A0,
0x3CB8, 0x2878, 0x3326, 0x3E45, 0x1BAE, 0x330C, 0xF690, 0x0E32,
0xD6E5, 0xE22D, 0xCC3B, 0xC4AF, 0xD192, 0xC5DD, 0xE91E, 0xDFC0,
0x169B, 0x022E, 0x395A, 0x26E0, 0x360A, 0x3763, 0x1C9C, 0x2834,
0xFC80, 0x0A7E, 0xD25D, 0xE6B6, 0xB981, 0xC760, 0xC72B, 0xC340,
0xECA8, 0xDF78, 0x23D3, 0x061D, 0x451A, 0x2C99, 0x3AF6, 0x43D2,
0x22A1, 0x3777, 0xFDB8, 0x108E, 0xD124, 0xE64A, 0xBAFF, 0xC4D8,
0xBBC3, 0xBBFB, 0xD3F7, 0xD335, 0x0E7A, 0xF7BE, 0x40D0, 0x2180,
0x49F1, 0x3BCB, 0x330C, 0x3704, 0x0A8C, 0x1E76, 0xE0C0, 0xF692,
0xBFA2, 0xC83D, 0xB62F, 0xB548, 0xCAA7, 0xCD4D, 0xF77C, 0xF362,
0x2E21, 0x1D00, 0x4AAC, 0x3BE2, 0x39CC, 0x3C53, 0x14FF, 0x235B,
0xEE4A, 0xFFA7, 0xCDF4, 0xDAB9, 0xC10B, 0xC042, 0xC59E, 0xC4FC,
0xE82E, 0xE05E, 0x1B24, 0x0C32, 0x3395, 0x3272, 0x307D, 0x34AB,
0x20AE, 0x20B9, 0x03A3, 0x04BC, 0xDF6A, 0xDFB8, 0xC6A1, 0xC695,
0xC9F5, 0xCF7F, 0xE9F4, 0xE8DD, 0x11D2, 0x0D38, 0x2D50, 0x2EBA,
0x2737, 0x3282, 0x09F9, 0x2102, 0xFB00, 0x0773, 0xEDE9, 0xE48A,
0xDC74, 0xC42E, 0xD878, 0xC4FD, 0xE51A, 0xE1ED, 0x07CE, 0x0B4E,
0x2A61, 0x2CCB, 0x27C1, 0x2E6D, 0x0CD2, 0x1CDD, 0xF5D8, 0x07A7,
0xE104, 0xE853, 0xD91E, 0xC7E2, 0xE02F, 0xC740, 0xF036, 0xDEB6,
0x128F, 0x05BF, 0x3087, 0x32DC, 0x296F, 0x3DC7, 0x07F2, 0x26C0,
0xF21E, 0x0888, 0xE57D, 0xE9F2, 0xD21A, 0xCCD6, 0xCE51, 0xC33E,
0xE7F4, 0xD269, 0x115A, 0xFA63, 0x344D, 0x2712, 0x35DB, 0x34A4,
0x1764, 0x29C9, 0xFC71, 0x1490, 0xE440, 0xF4B4, 0xCDE7, 0xD070,
0xCBB8, 0xC16A, 0xD741, 0xD35D, 0xFC4A, 0xFBF1, 0x316A, 0x27EE,
0x3ECB, 0x37A9, 0x21DA, 0x2977, 0x0860, 0x151E, 0xF124, 0xFDB3,
0xD85E, 0xDC28, 0xCC31, 0xC2FB, 0xCC39, 0xC5BC, 0xE84D, 0xEB19,
0x15FE, 0x1DED, 0x3151, 0x32D7, 0x2C1E, 0x2B58, 0x18D7, 0x1901,
0x042A, 0xFC7E, 0xEB1F, 0xE00C, 0xD756, 0xCDCA, 0xCDBC, 0xCCBC,
0xE207, 0xEA24, 0x0F2F, 0x17DB, 0x228B, 0x310C, 0x12A4, 0x2F42,
0x0CE4, 0x1C85, 0x0E6E, 0x0291, 0xFA89, 0xE72A, 0xE72D, 0xCAF4,
0xDADB, 0xC324, 0xE1D8, 0xE347, 0x0502, 0x13CC, 0x1C1F, 0x2A1D,
0x1625, 0x2637, 0x0895, 0x1BD4, 0xFCC7, 0x08CC, 0xF3E5, 0xEDA2,
0xEECE, 0xD1B3, 0xE533, 0xC623, 0xEDC8, 0xE12B, 0x0D87, 0x1378,
0x1D7E, 0x2FD3, 0x1287, 0x2EAC, 0x0449, 0x1FBF, 0xFC10, 0x073C,
0xEECA, 0xEFC7, 0xE2AF, 0xD5C8, 0xDD8A, 0xC277, 0xE90D, 0xD749,
0x0B29, 0x055D, 0x2953, 0x2361, 0x2592, 0x2CF6, 0x0D18, 0x2562,
0xFDF0, 0x0E59, 0xF369, 0xF5D8, 0xE435, 0xD9F0, 0xD143, 0xC52B,
0xD93C, 0xD844, 0x05F6, 0x077C, 0x250B, 0x26CD, 0x2559, 0x2B64,
0x1B27, 0x2176, 0x0C76, 0x1221, 0xF8D1, 0x011B, 0xE5A3, 0xE28A,
0xD36C, 0xC1F0, 0xD2A0, 0xCC63, 0xEE83, 0xFC43, 0x1180, 0x1DE5,
0x288D, 0x268B, 0x2579, 0x2152, 0x14EB, 0x0F23, 0x0847, 0xFE34,
0xF1F5, 0xEA19, 0xD55B, 0xCE6C, 0xD141, 0xD33B, 0xEB77, 0xFB63,
0x0727, 0x1B60, 0x1534, 0x292E, 0x1905, 0x2690, 0x1583, 0x135E,
0x0E65, 0xFFC1, 0x01C8, 0xE6AC, 0xE6A5, 0xC6E4, 0xD046, 0xC9B3,
0xDE1E, 0xF34A, 0x01A2, 0x1792, 0x197F, 0x273C, 0x1897, 0x24C6,
0x0DC7, 0x159E, 0x0DAD, 0x07BA, 0x06FB, 0xF3B7, 0xEADF, 0xCFDE,
0xDE65, 0xC376, 0xED42, 0xE944, 0xFBAA, 0x1641, 0x0997, 0x2A2D,
0x1254, 0x27DA, 0x0E5C, 0x196E, 0x08C4, 0x0B98, 0xFDE3, 0xF7F3,
0xEB1E, 0xD485, 0xDF05, 0xC394, 0xE6BC, 0xE105, 0x00EC, 0x05C5,
0x17A9, 0x1B63, 0x1777, 0x248B, 0x0CDB, 0x1C9F, 0x0887, 0x0EFC,
0xFD92, 0xFD1B, 0xE5E1, 0xDFD9, 0xD9B1, 0xCEA6, 0xE611, 0xE3AF,
0xFE9E, 0x0758, 0x1787, 0x1D2F, 0x22D8, 0x2004, 0x15DA, 0x17B9,
0x07F5, 0x0DD8, 0x00B5, 0xFD19, 0xE93D, 0xE116, 0xD14E, 0xCA9D,
0xD12B, 0xD9C5, 0xEFA7, 0x029D, 0x1A55, 0x1F38, 0x27E9, 0x23DC,
0x2128, 0x17FD, 0x1DBC, 0x09C4, 0x0A7B, 0xFF89, 0xE6AF, 0xEC77,
0xD307, 0xD1B8, 0xD3DF, 0xD88A, 0xE3F6, 0xFF19, 0x0127, 0x1D97,
0x17DF, 0x263F, 0x2229, 0x1FCF, 0x22AD, 0x13DF, 0x18C0, 0xFEC3,
0xFDF1, 0xE2F7, 0xDACB, 0xCD27, 0xCB7D, 0xD478, 0xDC77, 0xF61B,
0xFFCA, 0x13D3, 0x15F6, 0x202C, 0x195D, 0x1FDE, 0x1CB5, 0x1803,
0x19E7, 0x06FE, 0x0470, 0xF366, 0xEE70, 0xD8CB, 0xDE37, 0xCEF7,
0xDBD4, 0xEFA9, 0xF77C, 0x15BC, 0x1090, 0x2401, 0x1493, 0x21D3,
0x1423, 0x1602, 0x124A, 0x040A, 0x0637, 0xF3FB, 0xED1D, 0xDC65,
0xD83B, 0xCD93, 0xE495, 0xE4E2, 0x05C0, 0x0ABA, 0x1315, 0x20E7,
0x170B, 0x23DA, 0x1AD9, 0x1B7F, 0x12F1, 0x0C6F, 0xFDB4, 0xFB49,
0xE47A, 0xE180, 0xDA01, 0xCF4E, 0xE0D7, 0xE65C, 0xFAAD, 0x0B88,
0x13E1, 0x1A2F, 0x1B5A, 0x1EBD, 0x1BA1, 0x211B, 0x1675, 0x1167,
0x05CB, 0xFCA3, 0xE9B0, 0xE6CC, 0xD072, 0xCF69, 0xD290, 0xDAEB,
0xF767, 0x001B, 0x15DD, 0x18B3, 0x2218, 0x1F94, 0x2805, 0x1930,
0x19BF, 0x0B61, 0x0703, 0x05FC, 0xF3C1, 0xF87F, 0xD85F, 0xDA42,
0xD167, 0xDCC0, 0xEADB, 0xFFEB, 0x08D0, 0x1831, 0x1BB4, 0x1E91,
0x22F2, 0x1918, 0x2281, 0x0865, 0x18C8, 0xFA5B, 0xF604, 0xEF18,
0xD27B, 0xD9A4, 0xD0DE, 0xDAEC, 0xEDF3, 0xFF4E, 0x087B, 0x1C04,
0x13FE, 0x2059, 0x21D4, 0x1A0D, 0x2503, 0x0DD9, 0x154D, 0x02A0,
0xFD77, 0xF33F, 0xE2B6, 0xD499, 0xD3C2, 0xD349, 0xE31E, 0xFD25,
0xFCF8, 0x1D5B, 0x0F27, 0x274D, 0x1F56, 0x2536, 0x1FA0, 0x11AC,
0x17C6, 0xFE16, 0x0478, 0xF354, 0xE3C6, 0xDA11, 0xD7E9, 0xCABA,
0xE63B, 0xE521, 0xFE12, 0x0EC7, 0x12C1, 0x2858, 0x1C83, 0x2844,
0x1995, 0x1900, 0x1364, 0x0D18, 0x0506, 0x01AD, 0xEB1C, 0xE2E8,
0xD9FB, 0xCD51, 0xE30C, 0xE46C, 0xFEDB, 0x08F4, 0x0DDA, 0x1BB1,
0x1334, 0x1ED6, 0x1AB7, 0x1629, 0x17C2, 0x0AEA, 0x01EA, 0x03F9,
0xDFF0, 0xEAD1, 0xD3E0, 0xCF73, 0xEA0B, 0xE0B8, 0x02FC, 0x06F8,
0x1183, 0x1AC6, 0x1ED6, 0x19E5, 0x1F31, 0x0F1B, 0x1447, 0x0B23,
0x02C1, 0x081D, 0xE709, 0xEF56, 0xD762, 0xD852, 0xDB31, 0xE609,
0xF15E, 0x0596, 0x0F01, 0x1C33, 0x1F61, 0x201C, 0x2303, 0x11DC,
0x1D10, 0x00B6, 0x0882, 0xF9FE, 0xEA57, 0xEFEF, 0xD636, 0xDB34,
0xD849, 0xDF5B, 0xF197, 0x03FD, 0x0BB9, 0x2066, 0x1A65, 0x207C,
0x2162, 0x12A0, 0x1CAD, 0x07F6, 0x11BA, 0x0336, 0xF7B4, 0xEF21,
0xDAE4, 0xD32D, 0xD8CC, 0xDDB7, 0xEBFC, 0x0558, 0x0110, 0x21CA,
0x0E6F, 0x2565, 0x1925, 0x13D5, 0x1E3C, 0x02E8, 0x1181, 0xFDD4,
0xF469, 0xEF70, 0xDFB4, 0xD532, 0xE0D3, 0xD51F, 0xF09F, 0xF9DC,
0x052B, 0x1F75, 0x11B4, 0x263A, 0x18DE, 0x19D0, 0x1692, 0x0FD5,
0x0A00, 0x033A, 0xFB1E, 0xEDC2, 0xE857, 0xD606, 0xDDA6, 0xD5AE,
0xE867, 0xF609, 0xFF67, 0x178E, 0x125D, 0x24CA, 0x1C6E, 0x1EC6,
0x1843, 0x0DBD, 0x0AD1, 0x032A, 0xF8D1, 0xF855, 0xE51C, 0xDBCF,
0xDE80, 0xCE26, 0xEC42, 0xEB08, 0x04D9, 0x1377, 0x1275, 0x2159,
0x16D1, 0x1601, 0x177D, 0x0DCC, 0x0F68, 0x0D2C, 0xFEE4, 0xFF45,
0xE82E, 0xE4B4, 0xDC1D, 0xD991, 0xE776, 0xEDB8, 0xFE1B, 0x0F5D,
0x0BED, 0x1CC0, 0x15C8, 0x11DF, 0x1973, 0x0502, 0x0DF7, 0xFDC7,
0xFD15, 0xF838, 0xE9E7, 0xE8DE, 0xE206, 0xDE75, 0xEBB5, 0xF5CB,
0xFE1E, 0x16C1, 0x1015, 0x1DD7, 0x19CE, 0x12A4, 0x187E, 0x06A6,
0x0A91, 0xFCF0, 0xFC4D, 0xF120, 0xF073, 0xDFD5, 0xE33A, 0xDC56,
0xE20E, 0xF4F4, 0xF576, 0x18B8, 0x0C03, 0x2DE8, 0x18EE, 0x21F4,
0x1AA7, 0x0595, 0x0EFD, 0xF500, 0x0224, 0xECC3, 0xF0D0, 0xDE9B,
0xE01F, 0xD352, 0xE7B9, 0xE6B4, 0xFD41, 0x12A3, 0x0BE0, 0x2C4A,
0x1372, 0x2798, 0x1616, 0x187E, 0x1305, 0x0647, 0x0977, 0xF2D8,
0xF63B, 0xDE09, 0xE587, 0xD14D, 0xE3C2, 0xE3BD, 0xF1E2, 0x096A,
0x049E, 0x2219, 0x0E2D, 0x2345, 0x13C2, 0x159F, 0x0FDD, 0x07E8,
0x034A, 0xFB90, 0xF93B, 0xE620, 0xEF44, 0xD603, 0xEDD3, 0xE47D,
0xF838, 0x0550, 0x0348, 0x1D11, 0x0E96, 0x1F75, 0x14FA, 0x1458,
0x0A65, 0x069E, 0x0090, 0xF9E4, 0xFCA9, 0xEDEE, 0xF0A8, 0xE1C0,
0xEB7B, 0xE6ED, 0xF43F, 0x0377, 0x0509, 0x1E16, 0x0FD1, 0x20CD,
0x0D0C, 0x0F7A, 0x0AC5, 0xFCB3, 0x0676, 0xF2E4, 0xFACC, 0xEAAC,
0xEF20, 0xE1F6, 0xED4A, 0xED21, 0xFBDA, 0x09E7, 0x0C43, 0x1ED2,
0x0DB5, 0x20FE, 0x0D49, 0x13BA, 0x0C22, 0x0276, 0x0256, 0xF496,
0xFD49, 0xE7EA, 0xF45B, 0xDE44, 0xEAF3, 0xE8FB, 0xF412, 0x0B87,
0x02BF, 0x27FB, 0x0CC1, 0x26DA, 0x1218, 0x1317, 0x0D10, 0xFE60,
0x0249, 0xEE7D, 0xFA63, 0xE49A, 0xF5EF, 0xDE9A, 0xF67E, 0xE84D,
0xF898, 0x0465, 0x01ED, 0x2067, 0x0E2F, 0x2EE1, 0x0F77, 0x246A,
0x0CBD, 0x06DA, 0x04BA, 0xED76, 0xFF78, 0xE203, 0xFBCA, 0xDBD8,
0xEDDC, 0xE0FC, 0xEEEF, 0xFDAE, 0x0310, 0x1F65, 0x0A77, 0x2B8A,
0x078E, 0x20F9, 0x095B, 0x0DF7, 0x06BD, 0xF85A, 0x0493, 0xE709,
0xFF53, 0xDC99, 0xF57A, 0xDD02, 0xF85F, 0xF4C7, 0xFF0F, 0x1574,
0x040A, 0x2733, 0x07CA, 0x22C5, 0x062B, 0x0E3F, 0x0399, 0xFCC8,
0x0301, 0xF4F7, 0x0323, 0xE961, 0xFF06, 0xE1A0, 0xF946, 0xF3B4,
0xFAF8, 0x1075, 0xFE8D, 0x1CBC, 0xFEB6, 0x1863, 0x0410, 0x0A19,
0x029F, 0xF603, 0xFD45, 0xEB5E, 0x0450, 0xF0EC, 0x0649, 0xF669,
0x03CD, 0xFCD1, 0x06D3, 0x0EBD, 0x04F7, 0x1DE1, 0xFFA9, 0x1A6B,
0xFB3B, 0x054E, 0xF6EC, 0xEEC1, 0xFEA3, 0xE900, 0x0703, 0xEB37,
0xFF72, 0xEB8A, 0xFCAD, 0x001A, 0x03C6, 0x1F6D, 0x0806, 0x2733,
0x033F, 0x1B92, 0xFC69, 0x05DB, 0xFACC, 0xEC00, 0xF9A7, 0xE070,
0xFEE9, 0xE6FB, 0x05CE, 0xECEE, 0x0666, 0xF4BD, 0x06DD, 0x104F,
0x0516, 0x2CFE, 0xFF8C, 0x2BE6, 0xFF3D, 0x108D, 0xFFBC, 0xF4DD,
0xFCC3, 0xE613, 0xFFD8, 0xE307, 0x0146, 0xE471, 0x019E, 0xF1EB,
0x0482, 0x0DB1, 0xFFD9, 0x1C90, 0xFBC2, 0x1F21, 0xFC33, 0x1949,
0xFC32, 0xFE6B, 0xFFC9, 0xE796, 0x078F, 0xEB41, 0x0C4D, 0xF12B,
0x08C6, 0xEFF3, 0x027A, 0x017A, 0x01F7, 0x1D45, 0xFF0B, 0x2265,
0xF5A2, 0x0D7E, 0xF501, 0xF970, 0xFE8F, 0xF4DB, 0x0A06, 0xF30C,
0x0F85, 0xEF74, 0x0BDB, 0xF3AD, 0x057D, 0x0736, 0xFD7A, 0x1879,
0xF465, 0x19BF, 0xF0F8, 0x0E50, 0xF694, 0xF6F8, 0xFF0C, 0xE7C2,
0x0768, 0xF302, 0x0F7C, 0xFFDE, 0x1660, 0xF9C2, 0x14D7, 0x0287,
0x05AD, 0x1B27, 0xF516, 0x1DE7, 0xE971, 0x0A68, 0xEC96, 0xF715,
0xFCB2, 0xEFA3, 0x0760, 0xED60, 0x1032, 0xF21C, 0x1720, 0xFEDE,
0x11BC, 0x0EC6, 0x0560, 0x19AA, 0xFB69, 0x194E, 0xEF44, 0x0C94,
0xE7B2, 0xF34A, 0xF068, 0xE41A, 0x021C, 0xEE79, 0x1487, 0xFEB6,
0x1CEF, 0xFBA6, 0x1826, 0x0121, 0x0D48, 0x214C, 0xFFF6, 0x2A79,
0xF130, 0x0E90, 0xEA40, 0xF2A3, 0xF411, 0xE957, 0xFF54, 0xE8D6,
0x06C1, 0xF051, 0x12CB, 0xFB86, 0x176D, 0x0643, 0x0D6F, 0x1885,
0xFF8F, 0x2424, 0xF0A6, 0x19C8, 0xEC00, 0xFE14, 0xFA91, 0xE9A4,
0x06B9, 0xEADF, 0x0C3E, 0xF5A6, 0x132C, 0xF4B8, 0x142B, 0xF795,
0x0BE1, 0x1611, 0xFEEC, 0x25CC, 0xF111, 0x12E9, 0xEC04, 0x00BE,
0xF7E2, 0xFC19, 0x0691, 0xF42E, 0x12D2, 0xF232, 0x1AD2, 0xFAE3,
0x1443, 0xFB9C, 0x0259, 0x05BC, 0xF513, 0x184A, 0xEED9, 0x1449,
0xE923, 0xFAAA, 0xF3FD, 0xEE1A, 0x090E, 0xF86D, 0x1760, 0x0776,
0x20FB, 0x078E, 0x200A, 0xFABE, 0x10BB, 0x0A74, 0xF9A4, 0x1EAB,
0xE44F, 0x0C3C, 0xDC72, 0xF4AC, 0xEF01, 0xEFEE, 0x07F8, 0xEE5C,
0x140F, 0xF653, 0x1C5D, 0x09BA, 0x1E04, 0x0BF6, 0x1496, 0x0FF6,
0x013A, 0x1EEF, 0xEA38, 0x153B, 0xDC7D, 0xF686, 0xE69B, 0xE6BC,
0x00A6, 0xECBB, 0x13FE, 0xF5A2, 0x1F9A, 0xFCD1, 0x24B6, 0xFFA0,
0x18A4, 0x10A2, 0x0022, 0x28F6, 0xEECE, 0x1D7D, 0xE4CD, 0x00B9,
0xE7BC, 0xF4F2, 0xF920, 0xEBC5, 0x0A33, 0xE9CC, 0x19D9, 0xFCF7,
0x20EF, 0xFE6C, 0x16D3, 0xFDE2, 0x01D5, 0x19B5, 0xF060, 0x20D9,
0xE4B9, 0x08CD, 0xE94A, 0xF6EA, 0x000A, 0xF618, 0x109A, 0xFA3E,
0x168A, 0xFCEF, 0x1902, 0xF792, 0x1749, 0xFCFA, 0x06E4, 0x1449,
0xF1CC, 0x14C2, 0xE4AE, 0x02E7, 0xE62E, 0xFCC2, 0xFF26, 0xFB99,
0x14C9, 0xF75B, 0x176D, 0xFFEC, 0x150F, 0x01FA, 0x0F85, 0xFA93,
0xFDF5, 0x0F11, 0xED38, 0x1620, 0xE72D, 0xFBC8, 0xEAC4, 0xF2BD,
0x00BA, 0xFAED, 0x1587, 0xFD5E, 0x1CD8, 0x0313, 0x2053, 0x0258,
0x16FD, 0xFEB4, 0xFB48, 0x1001, 0xE45F, 0x13D7, 0xDFE7, 0x03CB,
0xE692, 0xFB03, 0xFD12, 0xF3A5, 0x16DE, 0xF2BB, 0x203A, 0x00AB,
0x1DA6, 0x060C, 0x162A, 0xFDDA, 0x0131, 0x0B11, 0xE78E, 0x182B,
0xDB41, 0x051F, 0xDA1A, 0xF3FC, 0xF36C, 0xF8DA, 0x190D, 0xFBB7,
0x26FB, 0xFB4A, 0x23E1, 0xFE54, 0x1BB9, 0xFB31, 0x07F1, 0x0A85,
0xEFC8, 0x1974, 0xDFD4, 0x0982, 0xD742, 0xFC0C, 0xEA47, 0xF87F,
0x0C9E, 0xF65C, 0x1CF0, 0xFC59, 0x2132, 0xFD63, 0x1DFE, 0xF529,
0x0C5D, 0x03EB, 0xF1B7, 0x151E, 0xE341, 0x09B5, 0xE0FF, 0xFF21,
0xEE47, 0xFFD5, 0x091E, 0xFFE9, 0x1753, 0xFAFA, 0x1C05, 0xFA1C,
0x1C3D, 0xF84A, 0x0D14, 0xFA85, 0xF577, 0x09D9, 0xE737, 0x0D29,
0xE080, 0x04E2, 0xEC21, 0x019D, 0x0B7F, 0x0232, 0x1A1C, 0x02A7,
0x17D0, 0x0092, 0x1178, 0xF3C9, 0x036E, 0xF379, 0xF45E, 0x05D3,
0xEAEC, 0x03FF, 0xE40C, 0xFBA4, 0xED72, 0x007F, 0x0C71, 0x075A,
0x20E0, 0x0ABD, 0x202E, 0x083E, 0x1439, 0xFD0E, 0x035E, 0xF689,
0xF048, 0xFF3B, 0xE304, 0x032E, 0xDFD1, 0xFC5E, 0xEC4B, 0xF7C3,
0x0B99, 0x0013, 0x1E20, 0x06D0, 0x1E48, 0x0526, 0x1832, 0x0384,
0x07E8, 0x001E, 0xF0B8, 0x043B, 0xDFC5, 0x0306, 0xDB47, 0xF9F3,
0xE7CF, 0xFA91, 0x093E, 0xFDF0, 0x2181, 0xFCA1, 0x2606, 0x0022,
0x1D9F, 0x011E, 0x0AFC, 0xF9B3, 0xF7B8, 0x02AA, 0xE464, 0x0E66,
0xD9E6, 0x0911, 0xE026, 0xFE6E, 0xFC1B, 0xFB44, 0x1B14, 0xFF5B,
0x269E, 0xFCE8, 0x2018, 0xF7D2, 0x0DD3, 0xF437, 0xFB03, 0xF889,
0xEA63, 0x049D, 0xDE27, 0x096F, 0xDF0D, 0x0853, 0xF789, 0x095E,
0x154B, 0x0705, 0x211D, 0xFFB2, 0x1EEE, 0xFADE, 0x1385, 0xF142,
0x0516, 0xF1A2, 0xF1C9, 0x006C, 0xE0C3, 0x029B, 0xE1C6, 0x01E3,
0xF669, 0x0CC2, 0x0DFA, 0x10DC, 0x18D0, 0x06DE, 0x15B9, 0xFF65,
0x0B6C, 0xF896, 0x0416, 0xF285, 0xF744, 0xF61E, 0xE930, 0xFCB4,
0xE891, 0x01B3, 0xF96D, 0x058E, 0x10DD, 0x0AE5, 0x19D8, 0x0D72,
0x13FF, 0x0A7B, 0x06F7, 0xFD5A, 0xFC5A, 0xF238, 0xF221, 0xFBAB,
0xEA8E, 0x0267, 0xED52, 0xFD25, 0xFB68, 0xFFF2, 0x1288, 0x0845,
0x1F02, 0x071A, 0x17BC, 0x05EE, 0x040E, 0x042F, 0xF724, 0xFA1A,
0xEEC8, 0xFAC4, 0xE2AA, 0x0009, 0xE5B1, 0xFF8A, 0xFAD7, 0x0206,
0x16D7, 0x06D2, 0x2659, 0x07E9, 0x1FA8, 0x0259, 0x0E10, 0xFAAD,
0xFEDE, 0xF9CB, 0xEF7A, 0x046C, 0xDF6B, 0x08AB, 0xDF26, 0x0181,
0xEFE8, 0x00D0, 0x0C29, 0x0483, 0x22AA, 0x0213, 0x2222, 0xFE85,
0x1365, 0xFD9B, 0x06BF, 0xF5D7, 0xF9D0, 0xF528, 0xE5C0, 0x0595,
0xDEA9, 0x0EFD, 0xECAC, 0x0986, 0x039A, 0x03D0, 0x18E7, 0x01F3,
0x204D, 0xFD44, 0x166A, 0xF518, 0x09C9, 0xEEE0, 0xFF08, 0xF728,
0xEF93, 0x064A, 0xE76C, 0x0B13, 0xEB0B, 0x0D54, 0xFC94, 0x0F85,
0x135E, 0x0A5D, 0x1775, 0xFF80, 0x0C89, 0xF562, 0x05A3, 0xEB58,
0x0227, 0xEBDF, 0xF3A2, 0xFC82, 0xE979, 0x0833, 0xF1E0, 0x09D9,
0x0287, 0x0D9F, 0x11A0, 0x1472, 0x1512, 0x0DA8, 0x0C33, 0xFBFA,
0x0220, 0xF00D, 0xFE4C, 0xED95, 0xF55A, 0xF77D, 0xED17, 0x01D2,
0xF2C3, 0x0612, 0x0248, 0x0851, 0x14BC, 0x0833, 0x1615, 0x0938,
0x07CB, 0x0A56, 0xFF5B, 0xFF8A, 0xFC0B, 0xEFD3, 0xF1DC, 0xF63B,
0xEB30, 0x0330, 0xF55A, 0x01E4, 0x0572, 0x0076, 0x14CB, 0x04AA,
0x1BB9, 0x0483, 0x1148, 0xFD07, 0x0002, 0xFABD, 0xF67B, 0xFF93,
0xF0A2, 0x087F, 0xE9D7, 0x0E75, 0xEE5B, 0x08A0, 0x0052, 0x007F,
0x15F9, 0xFE42, 0x1ED2, 0xFC80, 0x134A, 0xF7C3, 0x0558, 0xF293,
0xFE20, 0xF03F, 0xF01A, 0x00E6, 0xE314, 0x17AB, 0xEB1E, 0x1752,
0xFD5B, 0x0E22, 0x11BF, 0x0880, 0x2035, 0xFCCF, 0x1AFC, 0xEFEC,
0x0D36, 0xEDD8, 0x0494, 0xEEA2, 0xFA9F, 0xF6DE, 0xE984, 0x0B6C,
0xE403, 0x1971, 0xF215, 0x19E3, 0x0804, 0x0FF6, 0x1684, 0x04B2,
0x15A1, 0xF96F, 0x1015, 0xED4A, 0x0AA5, 0xE582, 0xFFE8, 0xEE8D,
0xF152, 0x0695, 0xEF4A, 0x1087, 0xF61F, 0x10B6, 0xFD8C, 0x159A,
0x0C8D, 0x129E, 0x1176, 0x0182, 0x08F9, 0xF24C, 0x04FD, 0xEBA8,
0x03B1, 0xEF7C, 0xFBEE, 0x035B, 0xF584, 0x0E08, 0xFAFB, 0x0B52,
0x066E, 0x0A59, 0x0D56, 0x0987, 0x0798, 0x05F7, 0xFF58, 0xFBC6,
0xFEF4, 0xF0A8, 0xFD9F, 0xF23B, 0xF6CF, 0x00FC, 0xF702, 0x0967,
0x029E, 0x0C63, 0x0DCA, 0x0E97, 0x1654, 0x0682, 0x131F, 0xFAB5,
0x02AD, 0xF6C4, 0xF8D4, 0xF8BF, 0xF7AA, 0xFC27, 0xF247, 0x0894,
0xF060, 0x1140, 0xFCC9, 0x0BF3, 0x0C54, 0x05A1, 0x17D2, 0x02EA,
0x184D, 0xFE26, 0x0E3D, 0xF381, 0x02A0, 0xEC72, 0xF667, 0xF49C,
0xEBC8, 0x0CD3, 0xEBBD, 0x1A1B, 0xF8BC, 0x142C, 0x0563, 0x0D0F,
0x1333, 0x02D2, 0x1C31, 0xF735, 0x1456, 0xEE89, 0x0955, 0xEB31,
0x02D9, 0xF21C, 0xF8B4, 0x07F8, 0xEBEF, 0x1BAD, 0xEEDD, 0x1CC6,
0xFE43, 0x166B, 0x0D17, 0x0B09, 0x14E1, 0xFB29, 0x0EDB, 0xE9D8,
0x08D0, 0xE1FD, 0x06C6, 0xEA27, 0xFE84, 0xFD05, 0xF513, 0x1112,
0xF544, 0x1B6B, 0xFBEA, 0x1FC3, 0x05FE, 0x1919, 0x104A, 0x0725,
0x0D73, 0xF3D0, 0x05CD, 0xE608, 0x04BC, 0xE577, 0x019D, 0xF696,
0xFB1D, 0x0D57, 0xFBFF, 0x14EA, 0x01D6, 0x142A, 0x0533, 0x13A1,
0x082A, 0x1015, 0x06A5, 0x0297, 0x0283, 0xEFE5, 0x0090, 0xE905,
0xFDCC, 0xF133, 0xFC2E, 0x01E0, 0x0161, 0x0DE7, 0x078C, 0x1161,
0x0C24, 0x0DB2, 0x116C, 0x0756, 0x0938, 0xFFCA, 0xF9D9, 0xF8A6,
0xF7EA, 0xF9CA, 0xFDEF, 0x017B, 0xFD2E, 0x0ACE, 0xFC77, 0x0BFD,
0x0499, 0x0949, 0x0EBC, 0x0772, 0x165C, 0x017C, 0x0E86, 0xF6F5,
0xFE0C, 0xEEAA, 0xF665, 0xF49B, 0xF1C7, 0x021D, 0xF1DD, 0x1125,
0xFAA4, 0x19D5, 0x056E, 0x156F, 0x0D2B, 0x096A, 0x15DA, 0xFCAD,
0x1640, 0xF2FE, 0x0954, 0xE9B5, 0xFF52, 0xEB55, 0xF7CD, 0xFB28,
0xEFB0, 0x105B, 0xEFBE, 0x1D77, 0xFA12, 0x1B6C, 0x0615, 0x1290,
0x1153, 0x0522, 0x14FC, 0xF40F, 0x0B5E, 0xE557, 0x03DC, 0xE42B,
0xFEE1, 0xEF7F, 0xF8BE, 0x01E2, 0xF71E, 0x1516, 0xF572, 0x1DD1,
0xF7B9, 0x1BF1, 0x07E3, 0x1137, 0x1290, 0xFE56, 0x08C0, 0xEAE8,
0x008F, 0xE69D, 0x0304, 0xF065, 0x039D, 0xFE3C, 0xFEA8, 0x0A5F,
0xFB92, 0x108D, 0xFC32, 0x1439, 0x0081, 0x119E, 0x03E7, 0x0551,
0xFF58, 0xF50F, 0xFE41, 0xEC35, 0x0032, 0xECC5, 0xFE87, 0xF72B,
0x01D9, 0x0894, 0x0880, 0x0F39, 0x07B1, 0x0D77, 0x071C, 0x0BE5,
0x07E1, 0x05CA, 0xFC30, 0xFA34, 0xF4DD, 0xF439, 0xF873, 0xF87F,
0xFB51, 0xFF7C, 0xFFAF, 0x063A, 0x0346, 0x07E7, 0x067A, 0x07D2,
0x0C19, 0x0705, 0x0F45, 0xFFBC, 0x0594, 0xF637, 0xF5A3, 0xF337,
0xEECD, 0xF94E, 0xF339, 0x0313, 0xFD40, 0x0C51, 0x0285, 0x0CA2,
0x02F0, 0x06D8, 0x097B, 0x03F8, 0x13A7, 0xFD8E, 0x0C79, 0xF279,
0xFD2F, 0xEFF2, 0xFA86, 0xFAA0, 0xF820, 0x0820, 0xF4A1, 0x1175,
0xF83B, 0x1242, 0xFF56, 0x0C56, 0x08C8, 0x047F, 0x0D20, 0xFA3E,
0x06F0, 0xEFF0, 0x02DB, 0xE9E6, 0x0102, 0xED3E, 0xFC6A, 0xFCD1,
0xFB7C, 0x1046, 0xFAA8, 0x17CE, 0xFAF4, 0x14C3, 0x00CF, 0x0ED4,
0x09D4, 0x0322, 0x0B3A, 0xF39D, 0x020A, 0xE8E2, 0xFE28, 0xEC2C,
0x015F, 0xF938, 0x02FD, 0x04FD, 0x00D2, 0x0C6A, 0xFB7D, 0x1117,
0xF9D1, 0x125A, 0x02DF, 0x0B5D, 0x0693, 0xFEA9, 0xFF74, 0xF15D,
0xFEC9, 0xEAA9, 0x011C, 0xF1EE, 0x05B6, 0xFFFD, 0x0742, 0x06F1,
0xFFD2, 0x08A4, 0xFFF4, 0x0CDF, 0x0489, 0x0C14, 0xFF77, 0x0502,
0xF7CD, 0xFD90, 0xFA41, 0xF950, 0x042A, 0xFCBD, 0x0870, 0x010A,
0x034B, 0x0109, 0x01BD, 0x0137, 0x05A7, 0x0165, 0x060B, 0x00B1,
0x019B, 0x004F, 0xF770, 0xFCB2, 0xF3BD, 0xF91D, 0xFAE0, 0xFF71,
0x0176, 0x09C2, 0x07BF, 0x0A17, 0x093C, 0x0383, 0x0468, 0x00F0,
0x0773, 0xFF5F, 0x0A23, 0xF93D, 0x001C, 0xF4A4, 0xF6FE, 0xF88C,
0xF645, 0x03C7, 0xFD5A, 0x0CF1, 0x0248, 0x0CAA, 0xFFEE, 0x08AC,
0x0244, 0x05CA, 0x07D6, 0x0052, 0x0A09, 0xF96A, 0x0408, 0xF248,
0xFA65, 0xEDC3, 0xFC28, 0xF718, 0x0301, 0x07B8, 0xFF50, 0x0F2F,
0xFA2D, 0x0EC5, 0xFCF8, 0x0BCE, 0x03E1, 0x07AB, 0x0B98, 0x0094,
0x0554, 0xF644, 0xFC66, 0xF15D, 0x0482, 0xF745, 0x0943, 0x007F,
0x0224, 0x064A, 0xFAB4, 0x094F, 0xF80E, 0x09AA, 0xFA77, 0x09AD,
0xFD63, 0x06C0, 0xFEC8, 0xFC33, 0x005C, 0xF0FC, 0x030A, 0xF188,
0x07A2, 0xFE07, 0x0A78, 0x0520, 0x0744, 0x0479, 0x006B, 0x0727,
0xF90C, 0x0C07, 0xF9F5, 0x0C25, 0xFDB6, 0x02D2, 0xF80F, 0xF8DA,
0xFC23, 0xF9C8, 0x0B72, 0xFF1E, 0x0C1C, 0xFEFC, 0x046D, 0xFDB0,
0x00F5, 0xFFB1, 0xFED2, 0x0466, 0x00DC, 0x0983, 0xFBFA, 0x069E,
0xF1AA, 0xFD2C, 0xF811, 0xF914, 0x05F9, 0xFE95, 0x0ADE, 0x0411,
0x07B5, 0x00B7, 0x02C4, 0xFC84, 0x022B, 0x0052, 0x04AC, 0x0573,
0x00DC, 0x04B6, 0xF70E, 0x01E2, 0xF884, 0x019E, 0x030E, 0x05DA,
0x0348, 0x07BF, 0xFDB0, 0x01F6, 0x01DE, 0xFBD1, 0x043A, 0xFBAF,
0xFFAA, 0x0050, 0x0063, 0x00CB, 0xFEEB, 0xFA8E, 0xFF2C, 0xF7B2,
0x04CF, 0x020E, 0x03AE, 0x0E14, 0x01D3, 0x0AEA, 0x0053, 0x02AF,
0xFB97, 0x02AF, 0x00A0, 0x04D9, 0x0740, 0xFE79, 0xFE68, 0xF705,
0xFBB2, 0xF6A3, 0x0886, 0xFB05, 0x0C4C, 0x0322, 0x0147, 0x076D,
0xF7AA, 0x0688, 0xF817, 0x0726, 0xFDCF, 0x0965, 0x019F, 0x06B9,
0xFE81, 0xFD18, 0xFDB4, 0xF1BF, 0x0829, 0xF01D, 0x0DFB, 0xFC72,
0x04DE, 0x03A4, 0xFCEE, 0x01B7, 0xFB48, 0x071C, 0xFA47, 0x105C,
0xFC62, 0x0F8B, 0xF9F6, 0x06FA, 0xFCC4, 0xFD24, 0x0C8B, 0xF5E4,
0x0EC5, 0xF6DB, 0x0266, 0xF934, 0xFE2B, 0xF877, 0xFE3E, 0xFCC4,
0xFA7B, 0x08C4, 0xFAFA, 0x110C, 0xFB88, 0x0C89, 0xFC5B, 0x0147,
0x04A6, 0xFB65, 0x0C59, 0xFF15, 0x0CFD, 0xFE7E, 0x0465, 0xF7BF,
0xFA6D, 0xF9B9, 0xFA40, 0x0420, 0x0063, 0x0977, 0xFF1F, 0x08CA,
0xF819, 0x075B, 0xFFA3, 0x0241, 0x0D41, 0x0012, 0x0879, 0x0037,
0xFD33, 0xFC9D, 0xFCA0, 0xFAD5, 0xFEB3, 0xFF39, 0x0073, 0x06C9,
0xFF24, 0x079C, 0xFB36, 0xFF63, 0x0383, 0xF9C8, 0x0CC7, 0x005E,
0x05DA, 0x05D7, 0xFD83, 0x0139, 0xFD53, 0xFEE9, 0xFF8D, 0x03A9,
0x02C3, 0x0873, 0x01CE, 0x0619, 0xFFA6, 0xFEE9, 0x05E4, 0xF8D8,
0x0AE6, 0xF9D0, 0x04B3, 0xFF47, 0xFB7E, 0xFF89, 0xF93A, 0xFEDF,
0xF95D, 0x0581, 0xFBE9, 0x0D48, 0x0520, 0x0AE2, 0x0788, 0xFEB6,
0x055B, 0xF441, 0x0B1E, 0xF6BC, 0x0BAD, 0xFD9C, 0x00E6, 0xFE3A,
0xF813, 0x0133, 0xF51B, 0x0908, 0xFB08, 0x0F30, 0x049F, 0x0F69,
0x01DA, 0x07E1, 0x03B0, 0xFAB5, 0x1187, 0xF2D6, 0x0E2A, 0xF554,
0xFD16, 0xF9B5, 0xF554, 0xFC51, 0xF741, 0x030E, 0xFB80, 0x10EC,
0xFDE6, 0x1669, 0xFF78, 0x0B18, 0x060F, 0xFB36, 0x1035, 0xF407,
0x0F5A, 0xF7F6, 0x0337, 0xFA0C, 0xFC8C, 0xF836, 0xFB5B, 0xFF11,
0xF9B2, 0x0DC0, 0xFDF9, 0x163C, 0x0316, 0x11EE, 0x03FF, 0x049F,
0x0B04, 0xF96B, 0x0C9B, 0xF7ED, 0x0218, 0xF7A9, 0xFD6B, 0xF4B5,
0xFB1B, 0xF8AB, 0xF9A2, 0x06A2, 0x023F, 0x1131, 0x06E8, 0x0E0D,
0x0429, 0x049C, 0x08BD, 0xFD73, 0x0CB6, 0xFCB8, 0x063F, 0x00AD,
0xFBFA, 0xFF0B, 0xF6BD, 0xFBB2, 0xFCD3, 0x02C5, 0x06ED, 0x0B92,
0x0729, 0x0B83, 0x0251, 0x03A2, 0x08D6, 0xF90B, 0x0E1F, 0xF869,
0x0029, 0x0021, 0xF30F, 0x0153, 0xF68F, 0xFFB1, 0xFD19, 0x0637,
0x01F1, 0x0E3D, 0x084C, 0x0A7F, 0x0A56, 0xFC79, 0x0DF4, 0xF0F4,
0x0E03, 0xF34C, 0x01C8, 0xFE9E, 0xF98B, 0x036D, 0xF626, 0x0352,
0xF5F8, 0x0B51, 0x0023, 0x15B4, 0x09BB, 0x11E6, 0x0A27, 0x0338,
0x0BE7, 0xF3DF, 0x0E37, 0xEC6E, 0x05A5, 0xF1AA, 0xF9E4, 0xF894,
0xF2D5, 0xFEC9, 0xF393, 0x0A95, 0xFD5D, 0x15E7, 0x07C6, 0x177B,
0x096A, 0x0C7F, 0x0867, 0xF989, 0x0E33, 0xEE81, 0x0CD2, 0xF326,
0xFE36, 0xF7FA, 0xF24B, 0xF859, 0xF428, 0x00BD, 0xFF30, 0x0FE5,
0x0621, 0x1801, 0x033B, 0x1195, 0x050E, 0x015E, 0x0EBB, 0xF47D,
0x08E3, 0xF3FF, 0xF9D0, 0xF71B, 0xF622, 0xF68B, 0xF9F3, 0xFBC2,
0xFDEE, 0x091E, 0x0393, 0x1233, 0x0878, 0x0DA4, 0x0869, 0xFF8F,
0x080D, 0xF86F, 0x060C, 0xFE76, 0x001A, 0xFFA7, 0xF763, 0xF8CC,
0xF508, 0xFC11, 0xFE06, 0x07EC, 0x085A, 0x0D1C, 0x0B63, 0x08EB,
0x04E6, 0xFEEC, 0x0363, 0xF644, 0x05A5, 0xF7D4, 0xFD16, 0xFD82,
0xF33A, 0xFFAA, 0xF393, 0x00C3, 0xFB9B, 0x0557, 0x084B, 0x0B9A,
0x0FDE, 0x0889, 0x08A9, 0xFA7B, 0x05B1, 0xF101, 0x08BA, 0xF7A7,
0xFED8, 0x017F, 0xF072, 0x011D, 0xEF2B, 0x00EB, 0xFC54, 0x08FA,
0x078C, 0x0EA3, 0x08F6, 0x0967, 0x0859, 0xFBD8, 0x0AD9, 0xEEFE,
0x090A, 0xEF18, 0xFD51, 0xF993, 0xF28C, 0xFF73, 0xF2BD, 0x00F4,
0xF752, 0x090F, 0xFDC3, 0x13B9, 0x0BB0, 0x0FE5, 0x0EA3, 0xFBF7,
0x05F0, 0xEEC8, 0x0672, 0xF3AD, 0x0511, 0xFB20, 0xFA5D, 0xFB29,
0xF2F6, 0xFD42, 0xF481, 0x0807, 0xFF1A, 0x120A, 0x0A81, 0x11EA,
0x07B6, 0x0767, 0x02E1, 0xF7E9, 0x06F4, 0xEDFE, 0x0479, 0xF263,
0xFB00, 0xFC15, 0xF3B2, 0xFCB4, 0xF695, 0xFE0A, 0x01ED, 0x0A1E,
0x0A05, 0x1134, 0x07A3, 0x074E, 0x01D7, 0xFA52, 0x06CD, 0xF9AC,
0x0860, 0xFF5A, 0xFA7A, 0xFE6A, 0xF369, 0xF923, 0xFC5D, 0xFB74,
0x0320, 0x04E9, 0x06C2, 0x09F6, 0x0864, 0x0418, 0x03CD, 0xF928,
0x0339, 0xF5CA, 0x0023, 0xFF71, 0xFA42, 0x0900, 0xFAC6, 0x032A,
0xF960, 0xFBF0, 0xFC6A, 0x0287, 0x0A40, 0x0672, 0x0EBB, 0xFBD0,
0x04BF, 0xF2E5, 0x0002, 0xF691, 0x0257, 0xFFF8, 0xFEEF, 0x0879,
0xF54C, 0x0AFC, 0xF4BD, 0x09FB, 0x0033, 0x0801, 0x0A15, 0x0331,
0x0C21, 0xFD6C, 0x045E, 0xF417, 0x007E, 0xEA1E, 0x0490, 0xEFE7,
0xFE59, 0x03C4, 0xF32E, 0x0BE0, 0xF3F3, 0x08D3, 0xFDDD, 0x0CF6,
0x097E, 0x0FC7, 0x0CB6, 0x0428, 0x03DD, 0xF395, 0x03F9, 0xECB0,
0x0892, 0xF265, 0xFF86, 0xFE58, 0xF600, 0x03E2, 0xF642, 0x03C7,
0xFCBF, 0x08B7, 0x02DE, 0x0E52, 0x075A, 0x0BC2, 0x085B, 0x0017,
0x0342, 0xF10C, 0x00BD, 0xEEFA, 0x02FA, 0xFD41, 0xFF6F, 0x03BB,
0xF81C, 0x0039, 0xF8C2, 0x0439, 0x00F4, 0x0850, 0x09CB, 0x0401,
0x05FF, 0xFF7D, 0xFCB2, 0xFCC2, 0x0360, 0xFAE2, 0x08A3, 0xFEBF,
0xFF25, 0x03DA, 0xF933, 0x03D0, 0xFD1B, 0x0129, 0x0517, 0xFFBD,
0x08AC, 0x00EC, 0x0012, 0xFE5D, 0xF8F9, 0xF54E, 0xFFAA, 0xF4FD,
0x0551, 0x057A, 0xFF3C, 0x0FB9, 0xF84F, 0x073E, 0xFE1F, 0x0081,
0x086F, 0x01DC, 0x0926, 0xFFF6, 0x036F, 0xF9F1, 0xFDF6, 0xF424,
0xFE2E, 0xF530, 0x004D, 0x01FC, 0xFBB8, 0x0E8A, 0xF973, 0x0E4C,
0xFE33, 0x074C, 0x00BF, 0x013F, 0x06B9, 0xFDE1, 0x0B4F, 0xF9F4,
0x0136, 0xF16B, 0xFB6F, 0xEF9B, 0x0064, 0xFD30, 0xFF2A, 0x0A8D,
0xF910, 0x0D52, 0xF70E, 0x0C5A, 0xFDE4, 0x08D0, 0x08D4, 0x013D,
0x09B0, 0xF9F1, 0x010B, 0xF443, 0x0058, 0xF230, 0x0771, 0xF9E2,
0x0446, 0x072C, 0xF741, 0x0D63, 0xF37B, 0x088E, 0xFCCA, 0x035D,
0x041D, 0x060A, 0x034B, 0x05AF, 0xFD77, 0xF837, 0xFE98, 0xEC5F,
0x09AE, 0xF511, 0x079A, 0x06C3, 0xFB29, 0x0B39, 0xFA52, 0x0499,
0xFD26, 0x0098, 0xFD5B, 0x0259, 0x0006, 0x0458, 0xFF6C, 0x0030,
0xFF37, 0xF9C9, 0x03C3, 0xFB2C, 0x04DF, 0x0284, 0x034C, 0x060F,
0x0020, 0x01A7, 0xFC16, 0xFC95, 0xFDEA, 0xFDCA, 0x010E, 0x0013,
0xFDB4, 0xFD4C, 0xFA4C, 0xFB98, 0x007D, 0x01FC, 0x0831, 0x0ADE,
0x0391, 0x0C52, 0xFBC3, 0x02C4, 0xFDF3, 0xF80D, 0x036E, 0xF6A3,
0x04B3, 0xFB57, 0xFE54, 0xFD95, 0xF7CF, 0xFB65, 0x00F4, 0xFE2C,
0x09BC, 0x0BEB, 0x0163, 0x16D5, 0xFA16, 0x0CC3, 0xFD5E, 0xF864,
0x0329, 0xF272, 0x0410, 0xF8D5, 0xFE4C, 0xFA42, 0xFCF6, 0xF59B,
0x02D5, 0xF8A3, 0x02E8, 0x0761, 0xFE9A, 0x13E2, 0xFD5B, 0x103F,
0xFCF5, 0x02DE, 0xFCE7, 0xFC22, 0xFEB1, 0xFADE, 0x034C, 0xF78B,
0x04F6, 0xF695, 0x02C4, 0xFB67, 0x0421, 0x03EB, 0x0271, 0x0C9B,
0xFAEB, 0x0AB4, 0xF791, 0x0021, 0xF976, 0xFD85, 0xFE2D, 0x00AC,
0x00DF, 0xFF9C, 0xFEE1, 0xFB24, 0x03C4, 0xF836, 0x0D01, 0xFF14,
0x0916, 0x0CEE, 0xFBFF, 0x0CBE, 0xF3D3, 0xFC87, 0xF6A4, 0xF360,
0xFEDE, 0xF9D4, 0xFEB8, 0x0475, 0xFB78, 0x06D1, 0x02A8, 0x01D7,
0x0CCF, 0x019B, 0x0BCB, 0x0A30, 0x0189, 0x0B4F, 0xFB31, 0xFBDB,
0xF9FB, 0xEFC5, 0xF672, 0xF3A3, 0xF709, 0xFC5B, 0xFEFC, 0x019F,
0x0492, 0x048D, 0x076B, 0x0963, 0x07E8, 0x1120, 0x0526, 0x0D2E,
0x02D3, 0xFAFC, 0xFE20, 0xF148, 0xFA54, 0xF468, 0xFC35, 0xF8CC,
0xFD15, 0xFE5F, 0xFEC4, 0x04AA, 0x0621, 0x0A89, 0x092C, 0x1237,
0x038B, 0x1159, 0xFCC3, 0x01BF, 0xFA95, 0xF188, 0xFF18, 0xED7F,
0x02CA, 0xF65D, 0x0061, 0x0146, 0xFE3F, 0x0319, 0x02D6, 0x02FE,
0x0911, 0x0D6D, 0x034A, 0x161C, 0xF7A4, 0x0A69, 0xF6F7, 0xF671,
0xFD0B, 0xEEFD, 0x0099, 0xF472, 0x036D, 0xFEAE, 0x0769, 0x0549,
0x0AF1, 0x0638, 0x0812, 0x0B9D, 0xFEBF, 0x106E, 0xFB5B, 0x0673,
0xFB78, 0xF865, 0xF74C, 0xF433, 0xF8AD, 0xF8A1, 0x02C3, 0xFEB7,
0x0C0C, 0xFFDB, 0x0F85, 0x0287, 0x0CE5, 0x0DF1, 0x0504, 0x12A4,
0xFBC6, 0x05D4, 0xF4FA, 0xF6AE, 0xF52D, 0xF321, 0xFB6E, 0xF9B0,
0x0133, 0x02BE, 0x060E, 0x0861, 0x0A6B, 0x0711, 0x0E77, 0x05CC,
0x0CDD, 0x0AF4, 0x0128, 0x090C, 0xF4C3, 0xF8F9, 0xF1E5, 0xEC6F,
0xF857, 0xF2BC, 0x00BD, 0x0430, 0x05ED, 0x0E44, 0x0A37, 0x0B6D,
0x0EBA, 0x0AE9, 0x09EE, 0x0F06, 0xFFCD, 0x07FD, 0xFBDE, 0xF746,
0xF97C, 0xEC18, 0xF774, 0xF05A, 0xF9CA, 0xFEE9, 0x0372, 0x0A00,
0x0ED7, 0x0D97, 0x0DC6, 0x0FF8, 0x03CB, 0x1275, 0xFF4E, 0x0B72,
0xFD20, 0xF6F9, 0xF8D9, 0xE768, 0xF8FE, 0xED4E, 0xFDA3, 0xFBDB,
0x0503, 0x034B, 0x09A9, 0x068F, 0x08BB, 0x0D24, 0x0622, 0x1478,
0xFF86, 0x118B, 0xF7AA, 0x0182, 0xF49B, 0xEFED, 0xF81A, 0xEB13,
0x01AF, 0xF66B, 0x098D, 0x05F9, 0x09D9, 0x0A3E, 0x083A, 0x0597,
0x0428, 0x0734, 0xFC4B, 0x0E43, 0xF683, 0x0811, 0xF288, 0xF428,
0xF5E0, 0xED92, 0xFF6A, 0xFA17, 0x0817, 0x04EC, 0x1250, 0x06CC,
0x145F, 0x0579, 0x065B, 0x07A7, 0xF6D5, 0x0A44, 0xF114, 0x00E8,
0xF26E, 0xF199, 0xF588, 0xF073, 0xF85C, 0xFD98, 0x0453, 0x0984,
0x1390, 0x0A6B, 0x1473, 0x051A, 0x0BF7, 0x066E, 0x00F5, 0x0A1B,
0xF5D4, 0x004B, 0xEDE5, 0xEE02, 0xEB4C, 0xEA40, 0xF4E4, 0xF8CC,
0x05C1, 0x078C, 0x0F9B, 0x0E12, 0x10B5, 0x0D29, 0x0B49, 0x080C,
0x030A, 0x0798, 0xFC45, 0x0535, 0xF25E, 0xF599, 0xED4C, 0xE89C,
0xF436, 0xEE5E, 0xFE69, 0x0172, 0x0AD6, 0x10B3, 0x11C5, 0x0D6A,
0x0BED, 0x04EC, 0x027D, 0x0853, 0xF927, 0x06AC, 0xF42B, 0xF539,
0xF73A, 0xE93C, 0xF8E0, 0xEF36, 0xFC46, 0xFDC6, 0x08C2, 0x0896,
0x1056, 0x09CF, 0x0A06, 0x0886, 0xFCB3, 0x0BDC, 0xF470, 0x092B,
0xF45E, 0xF7FB, 0xF3ED, 0xEA1C, 0xF6E0, 0xF0BE, 0x024C, 0x004E,
0x0DF5, 0x0905, 0x111B, 0x0727, 0x073F, 0x02D1, 0xFAFA, 0x07A4,
0xF7D5, 0x098A, 0xF327, 0xFBD9, 0xED72, 0xEED4, 0xF3E3, 0xEEED,
0x0221, 0xF8C6, 0x118E, 0x07F4, 0x16F1, 0x0D7B, 0x0AD6, 0x04DB,
0xFCC8, 0x018A, 0xF3AE, 0x0538, 0xECC6, 0x0056, 0xED28, 0xF405,
0xF3D6, 0xEF5A, 0xFE3D, 0xF9FF, 0x0BB4, 0x083C, 0x14F6, 0x099D,
0x13FC, 0x0237, 0x0674, 0x01CB, 0xF4CC, 0x0545, 0xED7A, 0xFCFD,
0xECE5, 0xEFC9, 0xF005, 0xEFFF, 0xFB42, 0xFC76, 0x0ABE, 0x09CF,
0x1783, 0x0B31, 0x14B4, 0x0259, 0x0354, 0x027B, 0xF802, 0x076F,
0xF481, 0xFE6F, 0xEEFD, 0xEFB6, 0xEC9F, 0xED89, 0xF434, 0xF91C,
0x0721, 0x089E, 0x178D, 0x0D6D, 0x1350, 0x0683, 0x05BD, 0x029A,
0xFCFB, 0x02C2, 0xF743, 0xFF2E, 0xF310, 0xF63A, 0xF0B6, 0xED1B,
0xF724, 0xEFCA, 0x068F, 0x0124, 0x100A, 0x0F22, 0x0EF2, 0x0BDF,
0x0706, 0x056C, 0xFA96, 0x065B, 0xF3A1, 0x0346, 0xF2E2, 0xF75E,
0xF4AD, 0xEE24, 0xFBC4, 0xF215, 0x04C1, 0xFFE0, 0x0DF5, 0x086D,
0x109D, 0x04D8, 0x04A4, 0x035B, 0xF688, 0x0940, 0xF2B8, 0x0886,
0xF3ED, 0xFBB5, 0xF64D, 0xEDD5, 0xFB99, 0xEFB2, 0x077A, 0x00E8,
0x1661, 0x0A35, 0x160C, 0x03FF, 0x04BF, 0x0115, 0xF369, 0x0685,
0xED99, 0x0835, 0xF11E, 0x0067, 0xF2D1, 0xF5D1, 0xF760, 0xF2D8,
0x07DF, 0xFA28, 0x177C, 0x054B, 0x1818, 0x086B, 0x0B6E, 0x02F0,
0xFA87, 0xFEF2, 0xF124, 0x013C, 0xED16, 0x018C, 0xEAB4, 0xF821,
0xF564, 0xF1AE, 0x0731, 0xFA6B, 0x1307, 0x0729, 0x17B1, 0x07C8,
0x1040, 0x029F, 0xFF31, 0x031E, 0xF2D5, 0x053A, 0xEE6E, 0x011B,
0xEE3B, 0xF5C5, 0xF2E2, 0xF0ED, 0xFCD2, 0xFB0F, 0x0BC9, 0x077A,
0x15BB, 0x0813, 0x1186, 0x008B, 0x02A1, 0xFFC7, 0xF545, 0x066C,
0xF338, 0x04B6, 0xF448, 0xF5BC, 0xF541, 0xECFD, 0xFDCC, 0xF673,
0x09BA, 0x0470, 0x1058, 0x096C, 0x0C66, 0x0826, 0xFCAC, 0x05BC,
0xF2C4, 0x0307, 0xF5E2, 0x01D3, 0xF438, 0xFCCA, 0xF3F9, 0xF35F,
0x004F, 0xF063, 0x0C92, 0xF9E7, 0x0F9B, 0x06C5, 0x087D, 0x09EE,
0xFC49, 0x0633, 0xF49B, 0x063B, 0xF1D3, 0x06CD, 0xF242, 0xFB2F,
0xF985, 0xEEB9, 0x044B, 0xF103, 0x0C9C, 0xFB89, 0x0F9E, 0x03B5,
0x0BAA, 0x04D7, 0xFE5A, 0x05D1, 0xEE3D, 0x0AD2, 0xEB7F, 0x0C4E,
0xF1DB, 0x0168, 0xF835, 0xF0D3, 0x0391, 0xEBE9, 0x0E3A, 0xF6DC,
0x11FB, 0x0318, 0x109C, 0x0319, 0x02FD, 0x01A7, 0xF0B5, 0x078F,
0xEC70, 0x0B84, 0xEFB7, 0x03DF, 0xF505, 0xF69A, 0x0023, 0xF164,
0x0CB3, 0xF3E9, 0x1675, 0xFBC5, 0x13CE, 0x056C, 0x0161, 0x08FB,
0xF1A1, 0x07AA, 0xEF49, 0x07BD, 0xEFA5, 0x054B, 0xF0C4, 0xFC32,
0xFB95, 0xF2D1, 0x0B2E, 0xF2BC, 0x1278, 0xFE07, 0x115F, 0x03FB,
0x0A1C, 0x0272, 0xFB54, 0x0768, 0xF012, 0x0C80, 0xEEFD, 0x05A7,
0xF433, 0xF76F, 0xFEBC, 0xEED1, 0x0746, 0xF2ED, 0x0A87, 0xFFBE,
0x0DA2, 0x064E, 0x07A9, 0x055F, 0xF918, 0x06F5, 0xF2DE, 0x0CA7,
0xF326, 0x0B94, 0xF5D5, 0xFAF7, 0xFE9D, 0xEC1D, 0x068E, 0xECA6,
0x0A71, 0xF8BD, 0x0C5B, 0x0443, 0x04E2, 0x084A, 0xF62F, 0x0BE9,
0xEFC5, 0x0DC7, 0xF585, 0x07A4, 0xFDDF, 0xFCFE, 0x0306, 0xF2FD,
0x097F, 0xEB1C, 0x0FC4, 0xF0D3, 0x0E39, 0x010F, 0x028B, 0x0A67,
0xF34A, 0x0ED3, 0xED07, 0x1103, 0xEF2C, 0x0EBD, 0xF4C2, 0x0232,
0x0288, 0xEE8F, 0x1150, 0xE72F, 0x1312, 0xF0E0, 0x0E8D, 0xFD57,
0x083D, 0x0449, 0xF9FF, 0x0A15, 0xEC9F, 0x1171, 0xEA0C, 0x13E1,
0xF23F, 0x06C4, 0x0030, 0xF1D7, 0x0CAF, 0xE683, 0x1399, 0xECA6,
0x149C, 0xFD08, 0x0C77, 0x05EF, 0xFC16, 0x0A12, 0xEE8F, 0x11F6,
0xEA13, 0x1517, 0xF003, 0x0A92, 0xFBF7, 0xF822, 0x073E, 0xE9F4,
0x0F36, 0xE91B, 0x140A, 0xF3F9, 0x12A8, 0x0083, 0x0441, 0x0C51,
0xF329, 0x1082, 0xEE58, 0x0EC6, 0xF3BC, 0x0ABC, 0xFB52, 0xFC70,
0x0567, 0xECF8, 0x0F2C, 0xEAB9, 0x109F, 0xF6E4, 0x0B06, 0x039D,
0x024A, 0x0956, 0xF9D4, 0x0EF2, 0xF210, 0x14B7, 0xEFF3, 0x0F2C,
0xF930, 0xFB9A, 0x0685, 0xEAA6, 0x0DEB, 0xE94E, 0x0E8A, 0xF7E6,
0x0C28, 0x050C, 0x0421, 0x08FA, 0xF84E, 0x0E3C, 0xF1D5, 0x12D8,
0xF70B, 0x0F23, 0x010C, 0xFE7D, 0x07BA, 0xEAEB, 0x0D2E, 0xE780,
0x0EE4, 0xF50C, 0x0BB7, 0x0422, 0x040B, 0x0F3B, 0xF7B5, 0x16C8,
0xEE47, 0x1723, 0xF2BC, 0x0EF2, 0x002A, 0xFE8F, 0x0AA3, 0xEE98,
0x10FC, 0xE588, 0x1242, 0xEADC, 0x0ED4, 0xFE35, 0x0493, 0x0E15,
0xF6F0, 0x1551, 0xEFBE, 0x1895, 0xF1C0, 0x14F3, 0xFA54, 0x044B,
0x05C1, 0xEE2D, 0x12D3, 0xE272, 0x1838, 0xEBC9, 0x10BE, 0xFEA4,
0x04F4, 0x096A, 0xF9A1, 0x127A, 0xEDF1, 0x1AD0, 0xEABF, 0x1A4F,
0xF4D4, 0x0A93, 0x00FF, 0xF18E, 0x0CA1, 0xE280, 0x14BC, 0xE70D,
0x1574, 0xF881, 0x10B0, 0x0636, 0x0285, 0x0DB6, 0xF0D1, 0x156E,
0xEC1F, 0x182F, 0xF4B3, 0x0AD7, 0xFEE1, 0xF59C, 0x0821, 0xE992,
0x0D9F, 0xEA0E, 0x0FA8, 0xF612, 0x0F8D, 0x04B1, 0x0682, 0x1087,
0xF733, 0x1787, 0xF001, 0x1481, 0xF4CE, 0x0939, 0xFA8B, 0xF96D,
0x01BD, 0xE9CC, 0x0C37, 0xE720, 0x0F83, 0xF65D, 0x0A87, 0x05A7,
0x0322, 0x0BEB, 0xFA69, 0x1098, 0xF657, 0x14D7, 0xFABB, 0x0D89,
0xFEBB, 0xF79C, 0x03D6, 0xE619, 0x09B4, 0xE858, 0x0932, 0xF95C,
0x086A, 0x07B8, 0x034C, 0x0EC5, 0xF531, 0x140B, 0xEE7E, 0x15A8,
0xF68A, 0x0D4D, 0x00FF, 0xF919, 0x07D0, 0xE62C, 0x0BA9, 0xE388,
0x0B7C, 0xF2E6, 0x094C, 0x0411, 0x0416, 0x0D9B, 0xF8C7, 0x158F,
0xEEC2, 0x1780, 0xF31A, 0x0C85, 0xFEF0, 0xF835, 0x062E, 0xE83E,
0x0C48, 0xE54C, 0x0F1B, 0xEEF0, 0x0C40, 0x0056, 0x046B, 0x1090,
0xF57E, 0x19C1, 0xEC5E, 0x18D0, 0xF207, 0x108E, 0xF8EE, 0x003B,
0xFF77, 0xE983, 0x0B43, 0xDDC2, 0x11BD, 0xE8FC, 0x107C, 0xFE97,
0x0AC8, 0x0B02, 0xFD7F, 0x111F, 0xEF8E, 0x1881, 0xEDB7, 0x1708,
0xF753, 0x040F, 0x0060, 0xEC2F, 0x0556, 0xE210, 0x0A8E, 0xE950,
0x0E9B, 0xF938, 0x0CFB, 0x0744, 0x025B, 0x1077, 0xF2C6, 0x1616,
0xECCC, 0x14DF, 0xF2CE, 0x06B0, 0xFAA9, 0xF162, 0x03EE, 0xE58F,
0x0ACB, 0xE9E2, 0x0C5A, 0xF660, 0x0D71, 0x0191, 0x0631, 0x0BFF,
0xF786, 0x13DD, 0xF305, 0x111E, 0xF7F3, 0x02DE, 0xFA0A, 0xF3C5,
0xFB95, 0xED10, 0x02CA, 0xECBE, 0x0AEC, 0xF65C, 0x0A66, 0x06D4,
0x00E8, 0x0F4C, 0xF706, 0x0F1E, 0xF2F7, 0x0D20, 0xF6B3, 0x0537,
0xFD66, 0xF2CE, 0x022B, 0xE479, 0x0544, 0xE850, 0x0631, 0xF998,
0x0708, 0x0771, 0x04C6, 0x0C11, 0xF897, 0x117B, 0xF00C, 0x123C,
0xF781, 0x04CD, 0x001F, 0xF11F, 0x036B, 0xE617, 0x0808, 0xE829,
0x0AD9, 0xF3F6, 0x08A9, 0x0512, 0x0092, 0x1120, 0xF403, 0x164D,
0xEBEE, 0x1650, 0xEF8C, 0x0A62, 0xFA6F, 0xF45B, 0x0445, 0xE503,
0x0AF3, 0xE4E6, 0x1078, 0xEDE9, 0x1279, 0xFAFF, 0x09DD, 0x0960,
0xF7E6, 0x1693, 0xEAE6, 0x192D, 0xEEC0, 0x0C4C, 0xF79F, 0xFC08,
0xFA8F, 0xEFF1, 0x03C2, 0xE694, 0x10DD, 0xE8B2, 0x12FB, 0xFA2E,
0x0C95, 0x0873, 0x003E, 0x0E0E, 0xEF95, 0x13A4, 0xE8D3, 0x1350,
0xF011, 0x0414, 0xFB0E, 0xEF93, 0x0399, 0xE820, 0x0AC8, 0xEE9C,
0x1221, 0xF8CE, 0x1299, 0xFFDF, 0x0607, 0x08C6, 0xF553, 0x11A2,
0xF021, 0x0E59, 0xF4AB, 0x0260, 0xF6F2, 0xF6B9, 0xFB8A, 0xEF8F,
0x06EE, 0xF024, 0x0E0D, 0xFA41, 0x0CE5, 0x036F, 0x054F, 0x08B6,
0xF5A3, 0x0FDB, 0xEC6E, 0x0D56, 0xF3F9, 0xFF0D, 0xFCBC, 0xF2BF,
0x0012, 0xEFC5, 0x06AC, 0xF231, 0x0F78, 0xF79C, 0x1064, 0x01C4,
0x053F, 0x0CF0, 0xF5D5, 0x10FC, 0xF056, 0x0A03, 0xF4BB, 0x00E8,
0xF88D, 0xF7BB, 0xFEA7, 0xEC6E, 0x08FE, 0xEAEE, 0x0E8F, 0xF915,
0x0D2A, 0x06E9, 0x0685, 0x0AAA, 0xF66A, 0x0EF4, 0xE79D, 0x11E4,
0xECA7, 0x07AB, 0xFB25, 0xF4B1, 0x02A0, 0xE8DD, 0x0884, 0xE995,
0x110D, 0xF1CB, 0x13E1, 0xFD1D, 0x0A4F, 0x08A9, 0xF727, 0x1263,
0xE979, 0x1357, 0xEBCF, 0x0B75, 0xF451, 0xFE77, 0xFC96, 0xF083,
0x0845, 0xEAA4, 0x120F, 0xEE7E, 0x1408, 0xF73E, 0x0D4B, 0x0235,
0xF980, 0x104C, 0xE50B, 0x1650, 0xE57F, 0x0D71, 0xF1CB, 0x0016,
0xFA4D, 0xF5F0, 0x0583, 0xEF22, 0x14DC, 0xEAD7, 0x1BD6, 0xF110,
0x13AB, 0xFEC3, 0xFF5C, 0x0854, 0xEBC0, 0x0D68, 0xE567, 0x1068,
0xE9AE, 0x0B78, 0xF32B, 0xFB0E, 0x0040, 0xEEF9, 0x0CFB, 0xF0F7,
0x15EA, 0xF818, 0x16F6, 0xFC4B, 0x07A3, 0x01FE, 0xEDAF, 0x0B1B,
0xE2D9, 0x0D1A, 0xEB92, 0x0568, 0xF4B6, 0xFBB5, 0xFCBE, 0xF588,
0x09D6, 0xF267, 0x14B6, 0xF450, 0x160A, 0xFC65, 0x09C9, 0x057B,
0xF5D2, 0x0B61, 0xEB73, 0x0BE7, 0xED59, 0x04F1, 0xF2DA, 0xFA0C,
0xFB3A, 0xF5AD, 0x069C, 0xF52D, 0x1169, 0xF498, 0x13F5, 0xFABA,
0x0588, 0x06B8, 0xEF97, 0x0F75, 0xE7D6, 0x0D7B, 0xF041, 0x047C,
0xF922, 0xFB29, 0xFED8, 0xF25E, 0x09A4, 0xEB50, 0x14F8, 0xEF6C,
0x1555, 0xFCBB, 0x0845, 0x04F0, 0xF2D8, 0x0B8E, 0xE3A4, 0x1319,
0xE5F3, 0x11DE, 0xF2AF, 0x0329, 0x0012, 0xF240, 0x0BBC, 0xEBB5,
0x145A, 0xED65, 0x178A, 0xF497, 0x0CD7, 0xFF81, 0xF44B, 0x0C12,
0xE258, 0x143A, 0xE34A, 0x10FB, 0xEEA9, 0x060A, 0xFB71, 0xFB1E,
0x09BB, 0xF07B, 0x18B6, 0xE8FE, 0x1F01, 0xEC4A, 0x132B, 0xF6EE,
0xFB2B, 0x0734, 0xE836, 0x1675, 0xE467, 0x1517, 0xEB91, 0x095A,
0xF45D, 0x0089, 0x00A0, 0xF755, 0x11DE, 0xEE75, 0x1C9C, 0xEDBB,
0x1586, 0xF507, 0xFEAE, 0x0105, 0xE9A8, 0x0BB5, 0xE4FA, 0x1138,
0xECEB, 0x0FDF, 0xF7CE, 0x0494, 0x0337, 0xF50A, 0x0EDB, 0xED35,
0x17D2, 0xF18B, 0x15E6, 0xF80C, 0x0566, 0xFD94, 0xF149, 0x088B,
0xE5BF, 0x10A2, 0xE84E, 0x0CA2, 0xF44A, 0x033F, 0x00CE, 0xFA47,
0x0D57, 0xF245, 0x1703, 0xF10F, 0x138B, 0xF5BC, 0x0294, 0xFF95,
0xF04E, 0x0D86, 0xE8DF, 0x10DA, 0xEEF4, 0x0954, 0xF87A, 0x0037,
0x0033, 0xF7DE, 0x0BCB, 0xF2B3, 0x1845, 0xF052, 0x1773, 0xF332,
0x0571, 0x0015, 0xF0CA, 0x1059, 0xE706, 0x160C, 0xEB09, 0x101F,
0xF64C, 0x0565, 0x00FD, 0xF7E9, 0x0BAB, 0xEC32, 0x153C, 0xEBBC,
0x14C0, 0xF5DD, 0x06D0, 0x002B, 0xF3D7, 0x09EC, 0xE6BA, 0x139E,
0xE898, 0x1644, 0xF67D, 0x0E02, 0x04D7, 0xFB6F, 0x1056, 0xE9AC,
0x1823, 0xE64B, 0x16D2, 0xEC7F, 0x0974, 0xF87D, 0xF737, 0x0B26,
0xE8A3, 0x17A8, 0xE4B2, 0x1779, 0xEE57, 0x0EDD, 0xFD33, 0x01C6,
0x0B51, 0xF553, 0x1799, 0xEC77, 0x1A25, 0xE86D, 0x0D4A, 0xEEDE,
0xF83D, 0x021F, 0xE7A6, 0x1460, 0xE684, 0x185A, 0xF208, 0x102F,
0xFD1F, 0x043C, 0x0719, 0xF82F, 0x1338, 0xEEA7, 0x198B, 0xED22,
0x1216, 0xF32E, 0x00BB, 0xFFA7, 0xEEE4, 0x0C80, 0xE5A8, 0x123C,
0xEAD1, 0x12D0, 0xF9C5, 0x09E3, 0x07D1, 0xF82B, 0x1030, 0xEDAE,
0x12B0, 0xEFC4, 0x0CCC, 0xF756, 0x00CA, 0x0198, 0xF369, 0x0BE3,
0xEAE0, 0x1110, 0xEFC9, 0x0EA1, 0xFD01, 0x0512, 0x08DC, 0xF866,
0x121C, 0xEF83, 0x1570, 0xEE05, 0x0F1E, 0xF3BE, 0x01DA, 0x017E,
0xF231, 0x123E, 0xE8A0, 0x197F, 0xECAC, 0x10FD, 0xF956, 0x01E5,
0x05F1, 0xF603, 0x0E52, 0xEFA9, 0x12F6, 0xEE1B, 0x10A9, 0xF063,
0x02BB, 0xFCD6, 0xF1EE, 0x0FD2, 0xE964, 0x1A1F, 0xED54, 0x16EC,
0xFB2C, 0x0AB5, 0x07DC, 0xF8ED, 0x0ED5, 0xE8AA, 0x1338, 0xE5E8,
0x108D, 0xF024, 0x064D, 0xFEDF, 0xF981, 0x0C86, 0xEB49, 0x15A0,
0xE6E2, 0x17DF, 0xF2F4, 0x1054, 0x03F7, 0xFF91, 0x0F14, 0xEE0F,
0x10FB, 0xE664, 0x0C9B, 0xE960, 0x0464, 0xF54B, 0xF867, 0x0890,
0xEE40, 0x17F1, 0xED77, 0x191F, 0xF734, 0x0E82, 0x0487, 0xFF08,
0x0C6B, 0xF240, 0x105F, 0xED26, 0x1172, 0xEC91, 0x082F, 0xF25D,
0xF8D2, 0x0284, 0xEB51, 0x1524, 0xE647, 0x1B67, 0xF1CD, 0x11B5,
0x02CB, 0x013F, 0x0B58, 0xF2A0, 0x0F21, 0xEC1C, 0x0F9C, 0xEC90,
0x0966, 0xF41A, 0xFDC2, 0x02B7, 0xEF9C, 0x0F15, 0xE906, 0x1377,
0xF176, 0x10C2, 0xFFFA, 0x0585, 0x0A92, 0xF34A, 0x0F18, 0xE868,
0x0F7A, 0xEB31, 0x0B23, 0xF650, 0x0118, 0x04DB, 0xF427, 0x10F0,
0xE8E4, 0x15EB, 0xEA74, 0x0F8D, 0xFA13, 0x0105, 0x0682, 0xF31B,
0x0A14, 0xEBF8, 0x0C6E, 0xEB65, 0x0A71, 0xF0C7, 0x0181, 0xFF37,
0xF629, 0x11C4, 0xEE48, 0x1B19, 0xF342, 0x13CC, 0xFF45, 0x0123,
0x0507, 0xEE9F, 0x075F, 0xE766, 0x0B4F, 0xEA4D, 0x0C1A, 0xF1EE,
0x04C1, 0xFF58, 0xF6D7, 0x0F93, 0xEB13, 0x1A0A, 0xED19, 0x173B,
0xFBC8, 0x08AC, 0x07F7, 0xF587, 0x0968, 0xE68D, 0x0848, 0xE183,
0x091C, 0xEA72, 0x0455, 0xFE6E, 0xFA59, 0x0FB7, 0xF129, 0x1860,
0xEF34, 0x1737, 0xF8D9, 0x0BD4, 0x04D9, 0xFA0F, 0x0A34, 0xEACB,
0x0B2D, 0xE547, 0x0A2D, 0xE91F, 0x05E4, 0xF63C, 0xFCA1, 0x08FF,
0xEFCD, 0x1988, 0xEBB6, 0x1BA4, 0xF6AA, 0x0C30, 0x02B7, 0xF95C,
0x0591, 0xEDC7, 0x05AC, 0xE91A, 0x09C1, 0xEAC0, 0x08AE, 0xF500,
0xFCCE, 0x0443, 0xF1E7, 0x12DE, 0xF15D, 0x18D4, 0xF98D, 0x0F7C,
0x031C, 0xFD52, 0x0706, 0xEDDC, 0x06E2, 0xE7A8, 0x0930, 0xEBCB,
0x0945, 0xF8A9, 0x00A1, 0x089B, 0xF355, 0x14EA, 0xEB5B, 0x167B,
0xF1B5, 0x0C02, 0xFFE5, 0xFE44, 0x077A, 0xF1B6, 0x0860, 0xE6DE,
0x0A3F, 0xE61A, 0x09EE, 0xF494, 0x0348, 0x0714, 0xFA2F, 0x156E,
0xF2F6, 0x1AB6, 0xF2C4, 0x1023, 0xFA99, 0xFCF7, 0x02F1, 0xED65,
0x0664, 0xE78F, 0x0A41, 0xEA91, 0x0E98, 0xF391, 0x0910, 0x017B,
0xFA96, 0x1368, 0xF03A, 0x1EC2, 0xF22D, 0x15B8, 0xFA6D, 0x0184,
0xFD78, 0xF042, 0xFC88, 0xE550, 0x0343, 0xE50D, 0x0C5F, 0xF153,
0x0A4F, 0x028A, 0x020D, 0x1158, 0xFB07, 0x1ABE, 0xF817, 0x1628,
0xFBDA, 0x0626, 0x004E, 0xF619, 0xFFAA, 0xE8EC, 0x0096, 0xE42E,
0x05C8, 0xEC66, 0x0624, 0xFD88, 0xFF8B, 0x113E, 0xF8D2, 0x1C92,
0xF7A3, 0x15D5, 0xFC42, 0x0612, 0x0129, 0xF7F2, 0x0205, 0xEB39,
0x0316, 0xE669, 0x0622, 0xEE0C, 0x0491, 0xFAF6, 0xFED4, 0x09B6,
0xFA40, 0x1846, 0xF821, 0x1A2D, 0xFB9B, 0x0B3A, 0x021F, 0xF788,
0x027D, 0xEA95, 0x02C5, 0xE862, 0x0A6F, 0xEF39, 0x0C3C, 0xFB01,
0x004A, 0x0902, 0xF384, 0x15E1, 0xF0EF, 0x164D, 0xF688, 0x0A54,
0xFC8A, 0xFCC8, 0xFE2D, 0xEE38, 0x00E2, 0xE584, 0x087B, 0xEB31,
0x0CEF, 0xF9AF, 0x08CB, 0x096F, 0x0010, 0x164D, 0xF77A, 0x170D,
0xF40A, 0x0A80, 0xF7C5, 0xFC27, 0xFBDB, 0xEFD9, 0xFF4F, 0xE968,
0x071D, 0xEC3D, 0x0CEF, 0xF6E4, 0x08C4, 0x0728, 0x0046, 0x14E1,
0xFA4C, 0x177C, 0xF692, 0x0DB6, 0xF633, 0xFE49, 0xF733, 0xEE6E,
0xF8DC, 0xE5DE, 0x004E, 0xEBF9, 0x0A58, 0xF8BE, 0x0CAA, 0x0478,
0x05F0, 0x10DA, 0xFE00, 0x17F3, 0xFAC2, 0x10CA, 0xFBC9, 0x00F7,
0xF9DB, 0xF1BB, 0xF6F6, 0xE86D, 0xFD62, 0xE951, 0x087D, 0xF3D0,
0x0A99, 0x04A4, 0x0395, 0x1396, 0xFD53, 0x1619, 0xFA2B, 0x0DAB,
0xF9B1, 0x02C5, 0xFA76, 0xF5FA, 0xFA5E, 0xEAAE, 0xFCD1, 0xE902,
0x0447, 0xF18C, 0x0986, 0x0053, 0x072E, 0x0FA1, 0x02A1, 0x17D3,
0xFDA8, 0x12CD, 0xFA42, 0x04A5, 0xFA93, 0xF5F4, 0xFC1D, 0xEC15,
0x0019, 0xEB6A, 0x0697, 0xF355, 0x0823, 0xFFF3, 0x0270, 0x0B78,
0xFCB1, 0x11D4, 0xF89D, 0x114C, 0xF805, 0x0874, 0xFABF, 0xF9B7,
0xFB91, 0xEC8F, 0xFDAC, 0xEAAF, 0x069D, 0xF2F1, 0x0F64, 0xFEF4,
0x0B77, 0x0BEE, 0x004E, 0x13E5, 0xF89F, 0x1169, 0xF573, 0x0635,
0xF5DF, 0xFA6F, 0xF848, 0xF227, 0xFD95, 0xEDF4, 0x0782, 0xF13C,
0x0F76, 0xFCB6, 0x0C21, 0x0B05, 0x03BC, 0x12F1, 0xFBA2, 0x10C9,
0xF357, 0x0753, 0xF0B0, 0xFA71, 0xF33D, 0xF012, 0xF8C3, 0xED3D,
0x0337, 0xF26F, 0x0E96, 0xFD53, 0x1157, 0x0977, 0x0C92, 0x1120,
0x04E9, 0x11D8, 0xFA50, 0x0A61, 0xF2A8, 0xFCE4, 0xF249, 0xF076,
0xF64D, 0xEB47, 0xFE09, 0xF137, 0x096A, 0xFDFD, 0x0DEB, 0x08F6,
0x08BF, 0x0F96, 0x01E4, 0x11CA, 0xFBFA, 0x0BF4, 0xF94A, 0xFF1B,
0xF7FD, 0xF26C, 0xF60F, 0xEC9C, 0xFB56, 0xF003, 0x08B7, 0xF909,
0x0E66, 0x060F, 0x09A7, 0x116A, 0x03A1, 0x1411, 0xFC65, 0x0CF0,
0xF747, 0xFF98, 0xF80A, 0xF49B, 0xFCCB, 0xEF3E, 0x0368, 0xF0DD,
0x0A0E, 0xF95A, 0x0BD3, 0x0407, 0x0766, 0x0C11, 0x010B, 0x106E,
0xF910, 0x0E9D, 0xF319, 0x03C3, 0xF3D5, 0xF736, 0xF982, 0xEE71,
0x02A7, 0xEF36, 0x0ED4, 0xFA2C, 0x14FC, 0x0544, 0x0F74, 0x0C62,
0x05AC, 0x0EFF, 0xFA1A, 0x0CD9, 0xF110, 0x0557, 0xF0ED, 0xFA21,
0xF572, 0xF181, 0xFD7F, 0xF1F3, 0x0B01, 0xF991, 0x1500, 0x0227,
0x12BA, 0x09A9, 0x07C8, 0x0E6D, 0xFB18, 0x0D75, 0xF2E1, 0x0420,
0xF04E, 0xF91C, 0xF10E, 0xF2BC, 0xF84C, 0xF256, 0x06DE, 0xF9EE,
0x1332, 0x0434, 0x1508, 0x0AA9, 0x0F92, 0x0E0F, 0x046D, 0x0D59,
0xF60A, 0x0551, 0xEF54, 0xFB90, 0xF2C0, 0xF2ED, 0xFA8F, 0xF0DE,
0x0459, 0xF996, 0x0C44, 0x039E, 0x0E57, 0x0AF7, 0x0B11, 0x0DCC,
0x0223, 0x0BD6, 0xF7F2, 0x0669, 0xF295, 0xFD4B, 0xF129, 0xF33E,
0xF64D, 0xEF67, 0x02DC, 0xF704, 0x0F20, 0x0360, 0x144F, 0x0BA9,
0x0F5F, 0x0DE4, 0x02E3, 0x0DEF, 0xF752, 0x0874, 0xF372, 0xFCF4,
0xF5F9, 0xF3FC, 0xFA1E, 0xF041, 0xFFE2, 0xF511, 0x098A, 0xFE9F,
0x100E, 0x063D, 0x0BA9, 0x0C46, 0x012E, 0x0E17, 0xF6E6, 0x095E,
0xF0C3, 0x00FC, 0xF0BE, 0xF684, 0xF778, 0xEFC4, 0x0429, 0xF50F,
0x0E41, 0xFED4, 0x1123, 0x05C8, 0x0F09, 0x0A54, 0x05FA, 0x0B1B,
0xF7CD, 0x08E0, 0xEE65, 0x02F9, 0xEF03, 0xFA41, 0xF7B4, 0xF42C,
0x01F3, 0xF562, 0x0AC3, 0xFC6F, 0x127C, 0x0487, 0x1066, 0x0866,
0x03E1, 0x082D, 0xF768, 0x068E, 0xEEDF, 0x01DB, 0xECD6, 0xFA67,
0xF2E2, 0xF3C9, 0xFD2A, 0xF6E0, 0x0950, 0x0081, 0x1500, 0x0529,
0x1887, 0x070F, 0x0EC1, 0x081E, 0xFBDE, 0x05E9, 0xEE59, 0x00A1,
0xEDF8, 0xF9AC, 0xF2E1, 0xF439, 0xF934, 0xF6A6, 0x021E, 0xFE95,
0x0C23, 0x0523, 0x10D0, 0x0956, 0x0C12, 0x0898, 0x0282, 0x05BC,
0xF692, 0x01D1, 0xED01, 0xFA10, 0xEF27, 0xF322, 0xF977, 0xF447,
0x01D6, 0xFD60, 0x09B7, 0x055A, 0x0FB0, 0x0903, 0x0CA4, 0x09AC,
0x0141, 0x0746, 0xF580, 0x02BF, 0xF3ED, 0xFC35, 0xF89C, 0xF41F,
0xFA22, 0xF194, 0xFDC2, 0xF92C, 0x05D9, 0x01C1, 0x0AA4, 0x0601,
0x07D3, 0x06FA, 0xFDBB, 0x06EB, 0xF221, 0x061A, 0xEF26, 0xFF4F,
0xF673, 0xF555, 0xFF35, 0xF300, 0x0394, 0xF9BC, 0x08AB, 0x0032,
0x0F62, 0x03A8, 0x0D2E, 0x0507, 0xFF44, 0x0546, 0xF0DE, 0x050E,
0xED55, 0x012D, 0xF35A, 0xFA83, 0xFA35, 0xF621, 0x015C, 0xF8B6,
0x0A85, 0xFE78, 0x0DB1, 0x01A9, 0x09EB, 0x01CB, 0x030C, 0x01FB,
0xF55F, 0x039A, 0xEB09, 0x0136, 0xEE8C, 0xFB1A, 0xF6D5, 0xF7FD,
0xFDE5, 0xFC39, 0x0659, 0x028A, 0x0FF3, 0x03F1, 0x139B, 0x00D2,
0x08B1, 0xFDA9, 0xF659, 0xFF90, 0xEF3E, 0x00E6, 0xF3E3, 0xFBD9,
0xF79B, 0xF723, 0xF980, 0xFA51, 0xFEC8, 0x021B, 0x06E1, 0x0639,
0x0CC2, 0x0399, 0x0A2D, 0xFF41, 0xFD00, 0xFF5B, 0xF16E, 0xFE80,
0xF3F8, 0xF9DB, 0xFA51, 0xF7AD, 0xFC2E, 0xFAE5, 0x010E, 0x0135,
0x083F, 0x05C2, 0x0C22, 0x056A, 0x07D8, 0x0244, 0xFBD4, 0x0171,
0xF665, 0x003C, 0xFA4B, 0xFB3E, 0xFBAC, 0xF66E, 0xFC9D, 0xF706,
0x0075, 0xFDCC, 0x02A9, 0x03D6, 0x065D, 0x0393, 0x0680, 0x0099,
0xFAD5, 0x01EC, 0xF178, 0x03EB, 0xF61B, 0xFFCE, 0xFE6E, 0xF8E7,
0x012A, 0xF6C3, 0x0201, 0xFBF9, 0x0588, 0x0254, 0x0A32, 0x02B9,
0x0857, 0xFE95, 0xFB59, 0xFF21, 0xF113, 0x02F9, 0xF559, 0x022D,
0xFCEF, 0xFE18, 0x0000, 0xFA76, 0x01C8, 0xFBC4, 0x0295, 0xFFD9,
0x0673, 0xFF97, 0x08A7, 0xFD46, 0xFCAA, 0xFE45, 0xEFA1, 0x005B,
0xF27F, 0x0016, 0xF99A, 0xFE9F, 0xFC48, 0xFDAF, 0x0116, 0xFFC5,
0x0741, 0x02C6, 0x0C07, 0x00D3, 0x0B55, 0xFC0B, 0x0053, 0xFB8D,
0xF503, 0xFF74, 0xF45F, 0x00EA, 0xF86E, 0xFE26, 0xFA74, 0xFB6C,
0xFC17, 0xFD47, 0xFD5E, 0x036D, 0x02F3, 0x045F, 0x0AEA, 0xFD7E,
0x0579, 0xF9FA, 0xF771, 0xFC80, 0xF44B, 0xFEFD, 0xF96E, 0xFF65,
0xFBF9, 0xFD57, 0xFD4B, 0xFDA8, 0xFEA9, 0x02BB, 0x0266, 0x0455,
0x08BB, 0x004D, 0x0637, 0xFD46, 0xFC00, 0xFD08, 0xF987, 0xFDC2,
0xFE1D, 0xFD21, 0xFF72, 0xFAFE, 0xFC3C, 0xFCE5, 0xF8A6, 0x01CD,
0xFB82, 0x02BB, 0x0295, 0xFF8E, 0x00D0, 0xFD97, 0xF87C, 0x0027,
0xF840, 0x015C, 0xFE1A, 0xFD95, 0x009E, 0xFA7E, 0x0183, 0xFB10,
0x00C0, 0xFFDC, 0xFF51, 0x03B8, 0x01DD, 0x0104, 0x010C, 0xFD6E,
0xF937, 0xFE50, 0xF5DD, 0x0237, 0xFAE1, 0x036A, 0xFFF7, 0xFD8D,
0x00D7, 0xF7DE, 0xFDF4, 0xFB23, 0xFD04, 0xFFFE, 0x0246, 0xFF39,
0x0324, 0xFD36, 0xFAF8, 0xFE17, 0xF534, 0x025B, 0xF789, 0x03B1,
0xFCE6, 0x0002, 0x00C1, 0xFDA4, 0x0145, 0xFE00, 0x00B5, 0xFE62,
0x0592, 0xFCC4, 0x096A, 0xFA20, 0x01A1, 0xFBA5, 0xF90F, 0x014C,
0xFA45, 0x034A, 0xFD2F, 0xFFC6, 0xFB42, 0xFC55, 0xF878, 0xFF20,
0xFA8C, 0x0323, 0x01A2, 0xFFAF, 0x066E, 0xFA18, 0x03B1, 0xF9B7,
0xFE82, 0xFE4D, 0xFBD2, 0x01F3, 0xFB32, 0x0086, 0xFBC1, 0xFD48,
0xFB6E, 0xFE57, 0xFA23, 0x02AE, 0xFE51, 0x0521, 0x058C, 0x0111,
0x0465, 0xF9DC, 0xFE9E, 0xFBCF, 0xFDDF, 0x00F5, 0xFF54, 0xFE99,
0xFC64, 0xFA25, 0xF6DC, 0xFADC, 0xF3CF, 0xFFEB, 0xF845, 0x02FB,
0x00E6, 0x00DF, 0x0446, 0xFF8E, 0x01C2, 0x021E, 0xFC19, 0x00EE,
0xFC70, 0xFD04, 0x0206, 0xF9B9, 0xFF78, 0xF9B3, 0xF7B3, 0xFE64,
0xF964, 0x022C, 0x023C, 0x014B, 0x0485, 0xFDDA, 0x012C, 0x0087,
0xFE8B, 0x052E, 0xFF5B, 0x010A, 0xFE87, 0xF8AD, 0xFA5D, 0xF75E,
0xF7D9, 0xFB0B, 0xF95D, 0xFF38, 0xFEA2, 0x0138, 0x0247, 0xFF0D,
0x0260, 0x00E3, 0xFDBB, 0x02CE, 0xFBD1, 0x0154, 0xFF53, 0xFE5A,
0xFEA4, 0xF9AE, 0xF9D0, 0xF9C7, 0xFB93, 0xFFB9, 0x04F6, 0x015B,
0x0817, 0xFDA2, 0x03DE, 0xFFA3, 0xFD15, 0x036C, 0xFA3B, 0x02DD,
0xFC28, 0xFD5F, 0xFBBE, 0xFA3E, 0xF6B0, 0xFD5D, 0xF4EF, 0xFFDE,
0xFF6B, 0x0080, 0x0A2C, 0xFF7B, 0x0B6B, 0x009E, 0x0100, 0x023C,
0xF94E, 0x0263, 0xFCC9, 0xFFF9, 0xFD2C, 0xFC54, 0xF8DD, 0xFCCD,
0xF976, 0x02E0, 0x02F2, 0x0568, 0x0863, 0xFE73, 0x08E3, 0xFD29,
0x076C, 0x0111, 0x02B0, 0x01F9, 0xFE11, 0xFEDF, 0xF9B0, 0xFBEE,
0xF5BC, 0xFE53, 0xF35B, 0x02C4, 0xFA47, 0x0531, 0x05A7, 0x0373,
0x0C22, 0x01EC, 0x0614, 0xFF62, 0xFEEB, 0xFEBA, 0x0316, 0xFD9E,
0x0459, 0xF98C, 0xFF4A, 0xFBE5, 0xF904, 0x04F2, 0xF9FC, 0x0974,
0x02A3, 0x03FB, 0x09AA, 0x0202, 0x072D, 0x0438, 0x01A6, 0x036F,
0x00A2, 0xFC8C, 0xFFFF, 0xF619, 0xFE49, 0xF7AA, 0xF9FC, 0xFE90,
0xFA8F, 0x0610, 0x0016, 0x0675, 0x083D, 0x072E, 0x06A5, 0x070B,
0xFD95, 0x04B5, 0x01CD, 0x01C3, 0x0526, 0xFA3C, 0xFF41, 0xF63B,
0xFC21, 0xFC5E, 0x003C, 0x0350, 0x049E, 0x0167, 0x0A01, 0x0364,
0x07BF, 0x07A9, 0xFD62, 0x0741, 0xFBAD, 0x0178, 0xFD46, 0xFAEB,
0xFD14, 0xFA8B, 0xF8B9, 0xFC0B, 0xF97A, 0x0236, 0x0250, 0x0539,
0x0C3C, 0x028C, 0x0D73, 0x023A, 0x0223, 0x0503, 0xFBED, 0x03AE,
0xFC11, 0xFCE1, 0xFD42, 0xF8B2, 0xFD5B, 0xFE7B, 0xFE13, 0x0857,
0x022B, 0x070F, 0x0A5A, 0x03B6, 0x0BAB, 0x017A, 0x02F3, 0x00F7,
0xFEAE, 0xFF51, 0xFB4A, 0xF821, 0xFA02, 0xF841, 0xF999, 0xFFC0,
0xF8FA, 0x06B8, 0x00A0, 0x09F3, 0x0D04, 0x0A59, 0x0D0A, 0x04F4,
0xFFE1, 0x020D, 0xFC20, 0xFEB1, 0x00CF, 0xF62F, 0x012A, 0xF457,
0xFF6E, 0xFBC6, 0xFE82, 0x0746, 0xFD0B, 0x089A, 0x04AA, 0x06D4,
0x0B10, 0x0649, 0x0258, 0x0328, 0xFC48, 0x00ED, 0xFDAC, 0xFCAD,
0xFEB2, 0xF657, 0xFEB8, 0xF618, 0x0090, 0x00DA, 0xFEE3, 0x09B7,
0xFF36, 0x0A57, 0x03F6, 0x0495, 0xFFFD, 0x0236, 0xFA82, 0x0122,
0xFF4E, 0xFCBC, 0x05E7, 0xF99B, 0x0424, 0xF8BC, 0x01BC, 0xFF62,
0x001E, 0x046D, 0x01A8, 0x046D, 0x03B6, 0x03B7, 0xFFF4, 0x06D5,
0xFAA8, 0x0562, 0xF8B1, 0xFBE7, 0x015C, 0xF6B4, 0x05B3, 0xF792,
0xFE4E, 0xFE1F, 0xFBDE, 0x0572, 0x039A, 0x0719, 0x0648, 0xFFF9,
0x00B6, 0x0185, 0xFB56, 0x0613, 0xF941, 0xFF08, 0xFEED, 0xF803,
0x04A3, 0xF6C5, 0x03BF, 0xFCC5, 0xFE66, 0x03B0, 0x0446, 0x0A62,
0x0AC1, 0x085B, 0x02AE, 0x0226, 0xFE0B, 0x0137, 0xF958, 0xFECB,
0xF461, 0xF7F3, 0xFB1B, 0xF58B, 0xFFD7, 0xFD26, 0xF8D0, 0x0295,
0xFE17, 0x082E, 0x0ADD, 0x077D, 0x072F, 0x03DB, 0xFC38, 0x0108,
0xF7FE, 0xF877, 0xFB9B, 0xF35D, 0x0050, 0xF4F3, 0x053A, 0x005B,
0x023D, 0x0C1B, 0x0018, 0x0DA4, 0x0821, 0x06EA, 0x07EA, 0x0453,
0xFAC1, 0x01F7, 0xF372, 0xFAD1, 0xF883, 0xF23D, 0xFC80, 0xEC2C,
0xFF4D, 0xF6F3, 0x0160, 0x0867, 0x039A, 0x10F2, 0x03F4, 0x0A00,
0x0250, 0x0297, 0xFB48, 0xFFB9, 0xF2F3, 0xF98D, 0xFCBD, 0xF731,
0x095D, 0xF7A1, 0x0AF4, 0xFA09, 0x0856, 0x0202, 0x0517, 0x0C0E,
0xFDC3, 0x06F8, 0xFC2B, 0x0241, 0xFADE, 0x0352, 0xED8B, 0xFA92,
0xEFBF, 0xF369, 0x047B, 0xF4D6, 0x0E3A, 0xFB16, 0x0555, 0x0210,
0x0225, 0x0802, 0x0222, 0x0237, 0xFCE4, 0xFD87, 0xFA8E, 0x0200,
0xF69B, 0x02B5, 0xFAFE, 0xFD84, 0x09F2, 0xF992, 0x10E4, 0xFDA4,
0x073D, 0x045A, 0x0135, 0x0AA8, 0xFE7C, 0x0311, 0xF922, 0xF8B8,
0xF68D, 0xFABA, 0xF315, 0xFE29, 0xF771, 0xFA84, 0x021D, 0xF631,
0x0A45, 0xFAE8, 0x06FC, 0x0261, 0x018F, 0x0B09, 0x0081, 0x0A8E,
0x0318, 0x0578, 0x02FC, 0x00CD, 0xF981, 0xFBFD, 0xFAE6, 0xFA8C,
0x03C1, 0xF75E, 0x06DD, 0xF864, 0x0335, 0xFE9C, 0xFE16, 0x0723,
0xF7F5, 0x0657, 0xFC7F, 0x0375, 0x04A8, 0x0317, 0xF860, 0xFC86,
0xF58E, 0xF5A1, 0x0359, 0xF1DE, 0x06E9, 0xF4EC, 0x02EF, 0x010C,
0x063C, 0x110B, 0x0319, 0x100F, 0x008F, 0x0724, 0x0505, 0x034F,
0xF866, 0xFD95, 0xF366, 0xF7E9, 0x01AB, 0xF285, 0x0869, 0xF0E0,
0x0224, 0xF9C5, 0x02A4, 0x0B63, 0x01DD, 0x0D88, 0xFAA1, 0x0414,
0xFCDE, 0xFFDF, 0xF741, 0xFBC6, 0xEFEB, 0xF514, 0xFD8F, 0xF49E,
0x1028, 0xFC22, 0x10A2, 0x0297, 0x0CB5, 0x0CF0, 0x0574, 0x0FC0,
0xFAA1, 0x07F2, 0xF6E3, 0xFE35, 0xEE24, 0xF554, 0xECAE, 0xF22C,
0xF841, 0xF3DA, 0x0895, 0xF911, 0x1476, 0x012F, 0x0F48, 0x0A18,
0x0145, 0x0953, 0xFBB4, 0x0379, 0xF836, 0xFC12, 0xEF8E, 0xF9AC,
0xF3A3, 0xFD77, 0x0176, 0xFB6C, 0x0C6D, 0xFBAD, 0x1330, 0x057C,
0x0F8D, 0x0F1F, 0xFCC1, 0x0B63, 0xF3ED, 0x0048, 0xF549, 0xF497,
0xEA7B, 0xF0A5, 0xEEC6, 0xF695, 0x0398, 0xFB7C, 0x0C0B, 0xFA65,
0x0FA7, 0xFFCF, 0x1123, 0x0C04, 0xFCA5, 0x09A4, 0xF04D, 0x05BB,
0xFCBC, 0x0368, 0xFBEF, 0xFBBF, 0xF7A8, 0xF6D3, 0x03B1, 0xF91E,
0x0BEC, 0xFCA0, 0x09BB, 0xFF7A, 0x06F7, 0x054F, 0xF7C3, 0x048B,
0xEB26, 0x03C8, 0xF1BA, 0xFFB5, 0xF726, 0xF961, 0xF9DE, 0xF671,
0x032F, 0xF6B2, 0x0F11, 0xF813, 0x1018, 0xF9D8, 0x09E1, 0x0608,
0x0056, 0x0F71, 0xF8C0, 0x0DEF, 0xF889, 0x0347, 0xF9F4, 0xFF68,
0xF8AB, 0xFE79, 0xF8D2, 0xF724, 0x0314, 0xF426, 0x0B85, 0xF629,
0x0855, 0xFF84, 0xFA43, 0x0715, 0xF67C, 0x0B00, 0xF7BB, 0x0148,
0xF27E, 0xF66E, 0xF86D, 0xF830, 0xFD05, 0xF81A, 0x0250, 0xF9FE,
0x1459, 0x0419, 0x1C2E, 0x0C3C, 0x091D, 0x098C, 0xFCFC, 0x0C41,
0xF7A2, 0x054C, 0xE9F4, 0xF6B8, 0xEBE0, 0xF16E, 0xF3CC, 0xEEEC,
0xF98A, 0xF3F1, 0x076A, 0xFE10, 0x15F8, 0x0978, 0x0AD3, 0x0B15,
0xFC45, 0x09CD, 0xF92C, 0x021A, 0xED3F, 0xF2AF, 0xEE21, 0xF0A0,
0xFCD2, 0xFCB7, 0x0846, 0x022D, 0x1575, 0x0142, 0x2075, 0x0C54,
0x0D2F, 0x0F3F, 0xF2DB, 0x0879, 0xEC2E, 0xFCC5, 0xE87F, 0xF05B,
0xEB0B, 0xEEAA, 0xF2F2, 0xF33C, 0x021D, 0xFC12, 0x128A, 0x01ED,
0x193A, 0x0681, 0x0C60, 0x09C1, 0xF818, 0x07AC, 0xED42, 0xFE20,
0xEB35, 0xFA4E, 0xF96D, 0xFAD2, 0x0613, 0xFA3C, 0x0CED, 0x011B,
0x1726, 0x05DE, 0x16D4, 0x0623, 0x023D, 0x0313, 0xF0D5, 0x00E6,
0xE667, 0xFA9E, 0xDFCD, 0xF520, 0xF209, 0xF7EC, 0x0163, 0xF90B,
0x06BC, 0xFBE2, 0x1633, 0x02C0, 0x1B3F, 0x0480, 0x07CC, 0x0304,
0xF9C1, 0x0B20, 0xF627, 0x08B4, 0xEEF1, 0xFAD7, 0xFA00, 0xFA7A,
0x05C1, 0xFF7C, 0x01A1, 0xFE65, 0x093A, 0xFCE9, 0x1672, 0xFEA6,
0x074C, 0xFF65, 0xF1E9, 0x02FF, 0xEE5A, 0x01C3, 0xEC0D, 0xF995,
0xF475, 0xF67E, 0xFFAA, 0xF9BB, 0x0271, 0xFBB3, 0x0B8B, 0x00C4,
0x18B5, 0x0C06, 0x157B, 0x0E76, 0x07A8, 0x0B72, 0xFB63, 0x0593,
0xEF23, 0xFCD5, 0xEF30, 0xF5F3, 0xF44F, 0xF3C6, 0xFAFE, 0xF659,
0x06E0, 0xFD35, 0x1142, 0x07C7, 0x1177, 0x0C3E, 0x0663, 0x0A68,
0xF707, 0x0148, 0xEC5B, 0xF928, 0xF073, 0xF333, 0xF52E, 0xF08D,
0xFD5C, 0xFBCB, 0x11AD, 0x09C0, 0x1F5B, 0x0F42, 0x1B3D, 0x108D,
0x0D24, 0x126B, 0xF42B, 0x0488, 0xDF5E, 0xF1FA, 0xE8C2, 0xEC3C,
0xF469, 0xEE00, 0xF785, 0xF856, 0x09AD, 0x04B2, 0x1E97, 0x0AAE,
0x1A20, 0x0B12, 0x09AD, 0x0C40, 0xF6C5, 0x0216, 0xE404, 0xF5E4,
0xED0B, 0xF81E, 0xFF45, 0xFCD2, 0x095B, 0x0044, 0x177C, 0x099B,
0x21A2, 0x12E1, 0x14BE, 0x0DC5, 0xFE06, 0x04BB, 0xEC13, 0xF75C,
0xDCD3, 0xED45, 0xE1CB, 0xF221, 0xF51D, 0xF8F6, 0x0719, 0xFE96,
0x1440, 0x05F1, 0x206B, 0x0DC9, 0x1BF5, 0x0BC5, 0x039E, 0x0588,
0xF0A7, 0x0040, 0xE801, 0xFC45, 0xF003, 0xF95F, 0xFF01, 0xFA3A,
0x0A22, 0x035D, 0x0E06, 0x091C, 0x113B, 0x0981, 0x11E1, 0x043E,
0x0224, 0x00D5, 0xEB3C, 0xFC8F, 0xE00A, 0xF711, 0xEBC9, 0xF4EB,
0xF943, 0xF379, 0x05BA, 0xFD46, 0x10CD, 0x0570, 0x14EE, 0x0897,
0x1664, 0x0ED7, 0x0EC9, 0x10B7, 0xFE95, 0x066B, 0xEF6D, 0xFC8E,
0xF151, 0xFC23, 0xF2FC, 0xF7CD, 0xF615, 0xF59C, 0x0363, 0xF854,
0x0CBB, 0x0020, 0x0CA7, 0x0B3D, 0x04BE, 0x0E7F, 0xFA35, 0x02F9,
0xEB70, 0xF61F, 0xED65, 0xF4EB, 0xF696, 0xF228, 0xFB87, 0xF506,
0x08AF, 0x026E, 0x19A4, 0x0ED7, 0x1F0E, 0x128D, 0x13C4, 0x11A2,
0x01DE, 0x0C51, 0xE64E, 0xFDEA, 0xDD5C, 0xF0D5, 0xE944, 0xE82E,
0xF4F0, 0xEB83, 0x00D9, 0xF9F2, 0x0F60, 0x0A28, 0x1A47, 0x10E0,
0x1039, 0x0B2E, 0xFFE5, 0x03A4, 0xECD7, 0xF88E, 0xE229, 0xEF6F,
0xEBE1, 0xF1E7, 0x00CC, 0xFE3E, 0x135D, 0x05B6, 0x1FB9, 0x0D98,
0x2471, 0x17E8, 0x0DD9, 0x12A9, 0xF10C, 0x010A, 0xDEED, 0xEDC8,
0xDA15, 0xE62B, 0xE152, 0xEB5D, 0xF332, 0xF801, 0x0AE9, 0x0165,
0x193B, 0x0707, 0x1FD3, 0x1163, 0x11B3, 0x0EA7, 0xF7AB, 0xFDF8,
0xE508, 0xF601, 0xE517, 0xF6F4, 0xF0CF, 0xF424, 0x01B7, 0xFAFE,
0x1638, 0x09BF, 0x1944, 0x0FE3, 0x1296, 0x0EAE, 0x0611, 0x043C,
0xF2B1, 0xF83C, 0xDD89, 0xF2C9, 0xD9D0, 0xF35D, 0xE853, 0xF14B,
0xF845, 0xF1A3, 0x0D8C, 0xFDE5, 0x1ACF, 0x08EE, 0x17DE, 0x0B9C,
0x0A0A, 0x0C02, 0xFE76, 0x0AC8, 0xF2EA, 0x0087, 0xECE7, 0xF896,
0xF3B0, 0xF8D3, 0xF9DD, 0xFAD5, 0x00FF, 0xFD16, 0x0C50, 0xFCB2,
0x13D3, 0xFEEA, 0x05D6, 0x04B7, 0xF538, 0x07EE, 0xED16, 0xFFF6,
0xE808, 0xF3FC, 0xEFA9, 0xF1D5, 0xFB0B, 0xF54F, 0x0412, 0xF717,
0x1014, 0x01C6, 0x1CF8, 0x1321, 0x1573, 0x1144, 0x05DB, 0x08EA,
0xFB7C, 0x077F, 0xEBC7, 0xFE19, 0xE25D, 0xEFFF, 0xEB7E, 0xEA31,
0xFE54, 0xEF45, 0x0A3F, 0xFDCC, 0x1419, 0x0EB1, 0x1169, 0x1012,
0x00D9, 0x0522, 0xF455, 0xFF4E, 0xEC5A, 0xF927, 0xE8F3, 0xEB85,
0xEFDE, 0xED72, 0x03AD, 0xFF96, 0x183E, 0x09A2, 0x258C, 0x12CE,
0x1EA9, 0x191C, 0x0594, 0x102E, 0xEB1C, 0xFFB6, 0xDDA0, 0xEEF7,
0xE19F, 0xE042, 0xE8D9, 0xE421, 0xF8A3, 0xF9AA, 0x11D6, 0x07E8,
0x208D, 0x0D8E, 0x1987, 0x1042, 0x0858, 0x0D13, 0xF16C, 0xFF42,
0xE278, 0xF48C, 0xEAFF, 0xF473, 0xF686, 0xF38D, 0x04EC, 0xF88E,
0x1C4C, 0x0985, 0x2638, 0x184E, 0x1059, 0x12B1, 0xF7B4, 0x01DE,
0xEC99, 0xF509, 0xDFD6, 0xF0DF, 0xDF90, 0xF190, 0xEF77, 0xF179,
0x00DA, 0xF507, 0x12B1, 0x0079, 0x2458, 0x0F20, 0x1A74, 0x0CF6,
0x006A, 0x0597, 0xF52D, 0x08D3, 0xEF96, 0x0444, 0xF23D, 0xF65C,
0xFC65, 0xF533, 0x0330, 0xFDD6, 0x0667, 0x005D, 0x10FE, 0x051A,
0x112C, 0x0296, 0xFBA2, 0xFB7F, 0xECED, 0x019D, 0xEB72, 0x04C1,
0xEFBE, 0xF54F, 0xF6BD, 0xEC5B, 0x0274, 0xF781, 0x0B96, 0xFD36,
0x1520, 0x06A9, 0x195D, 0x1377, 0x0BBC, 0x1118, 0xFD5D, 0x090D,
0xF805, 0x0627, 0xF7EA, 0xFEBF, 0xEFE5, 0xEEA2, 0xEEA9, 0xEACE,
0xFFC2, 0xEF9E, 0x0F7C, 0xFE27, 0x0D6E, 0x10AB, 0x01B9, 0x1128,
0xFAB4, 0x076D, 0xF06E, 0x0073, 0xF133, 0xF654, 0xF657, 0xE6F1,
0xF6D3, 0xE9F4, 0x062E, 0xFE1A, 0x1E47, 0x11A7, 0x23A6, 0x16E6,
0x1365, 0x1421, 0x02A9, 0x14FE, 0xEAC4, 0x08BA, 0xDF45, 0xF01F,
0xE86B, 0xDBA9, 0xEC96, 0xDC44, 0xF5CA, 0xF0FB, 0x1244, 0x0CC3,
0x22DE, 0x1770, 0x0F84, 0x0E09, 0xFFB3, 0x0C27, 0xF2AD, 0x068E,
0xE5D8, 0xF2C1, 0xEDE6, 0xE8C4, 0xF903, 0xF271, 0x03B6, 0xFA10,
0x1B3F, 0x07FF, 0x2B90, 0x1B80, 0x1088, 0x1574, 0xF191, 0x052F,
0xE87E, 0xF9B5, 0xE1B4, 0xEC6B, 0xE289, 0xE42F, 0xEC17, 0xECAE,
0xFC73, 0xF6AF, 0x10E0, 0x01FB, 0x20C9, 0x134E, 0x12FB, 0x0EDD,
0xFAAD, 0x02BF, 0xF1B8, 0x066D, 0xF152, 0x0445, 0xF7DD, 0xF123,
0xFD33, 0xEDB7, 0x06F0, 0xFF32, 0x1023, 0x0A67, 0x1356, 0x0C6D,
0x0826, 0x04D4, 0xF460, 0xFB45, 0xE64A, 0xFDBF, 0xE477, 0x00EF,
0xF3DF, 0xF16E, 0xF947, 0xE5E2, 0xFC28, 0xF20F, 0x0D1A, 0x01FB,
0x19B4, 0x0B96, 0x0FF5, 0x0FF4, 0x0159, 0x11D6, 0xF9B0, 0x0D85,
0xF328, 0x0144, 0xFBB1, 0xF3E9, 0xFAA6, 0xED39, 0xF094, 0xED9C,
0xFF18, 0xF2AC, 0x14DD, 0x0081, 0x09C9, 0x0D0D, 0xF632, 0x116C,
0xF634, 0x0EE0, 0xEF01, 0x01E5, 0xF075, 0xEFE5, 0xF6BC, 0xE4EA,
0xF3F2, 0xE525, 0x01CD, 0xF78C, 0x1DB2, 0x14F5, 0x20F0, 0x1CED,
0x0C25, 0x1495, 0x0287, 0x142D, 0xF4E8, 0x0C87, 0xE78F, 0xEFB1,
0xE82C, 0xD9D6, 0xEAB0, 0xDCAC, 0xF419, 0xED54, 0x0E25, 0x0972,
0x1E3D, 0x1C29, 0x0D2E, 0x1407, 0xFB88, 0x0C17, 0xF00E, 0x0783,
0xECF2, 0xEF7D, 0xF000, 0xE098, 0xF033, 0xEE83, 0x017E, 0xFE29,
0x1DC3, 0x0B5E, 0x2908, 0x1ACB, 0x15B9, 0x1C09, 0xFA55, 0x0C2F,
0xE944, 0xFB95, 0xE69F, 0xE91F, 0xE6C3, 0xDDFE, 0xE568, 0xEACF,
0xF96A, 0xFC72, 0x1728, 0x09A3, 0x20D5, 0x16B7, 0x11C0, 0x1500,
0x0051, 0x0590, 0xF108, 0xFF2B, 0xEE9F, 0xFC0B, 0xFAF2, 0xF0D1,
0xF99F, 0xED0B, 0x0022, 0xF99D, 0x19B4, 0x0EAF, 0x1E88, 0x1788,
0x0743, 0x0C36, 0xF625, 0xFDCA, 0xE89E, 0xF939, 0xE150, 0xF65E,
0xF09C, 0xEEDD, 0xF8FC, 0xED89, 0xFA88, 0xF453, 0x0EAA, 0x0308,
0x21F0, 0x121F, 0x1375, 0x121A, 0xFE3C, 0x0F16, 0xF729, 0x10C2,
0xF316, 0x0197, 0xF9B2, 0xEC1C, 0xFD50, 0xED7E, 0xF92E, 0xF461,
0x03B5, 0xF758, 0x1863, 0x04C7, 0x0ED3, 0x0F0C, 0xF688, 0x0DAF,
0xF270, 0x0E96, 0xF13C, 0x06EF, 0xF024, 0xEF80, 0xF0F3, 0xE734,
0xF5A2, 0xEC62, 0x05F6, 0xF3D0, 0x1E89, 0x0E72, 0x227A, 0x2398,
0x0F8D, 0x18E9, 0x0043, 0x0DC9, 0xF739, 0x0B63, 0xF3D1, 0xF508,
0xE7C0, 0xDEAB, 0xE239, 0xDF66, 0xF568, 0xEBBC, 0x1121, 0x062E,
0x1B87, 0x1E83, 0x105D, 0x1B7D, 0x02FC, 0x0CAE, 0xF33F, 0x04E1,
0xEFE5, 0xF459, 0xF0D3, 0xE249, 0xEC80, 0xE96E, 0xFD7D, 0xFE78,
0x208C, 0x12A8, 0x2A04, 0x1E36, 0x16CD, 0x1C4E, 0x06E3, 0x113D,
0xEF91, 0x00BF, 0xE417, 0xEACB, 0xE5B0, 0xDC80, 0xDFBC, 0xE551,
0xF039, 0xF842, 0x1969, 0x0F83, 0x288E, 0x1E82, 0x0F9E, 0x1652,
0x011C, 0x08B7, 0xF7FA, 0xFF85, 0xECF4, 0xF528, 0xF187, 0xF024,
0xF573, 0xF365, 0xFD26, 0xF68F, 0x1BD6, 0x0AFC, 0x30C6, 0x225F,
0x12EC, 0x1583, 0xF470, 0xFF44, 0xE7C8, 0xFA69, 0xDF12, 0xF3C6,
0xE5F4, 0xEA6F, 0xEED5, 0xF035, 0xFA20, 0xF603, 0x121D, 0x01DF,
0x28FB, 0x1AEC, 0x1CD6, 0x17D7, 0x0414, 0x069F, 0xF571, 0x0BDD,
0xEE07, 0x09E3, 0xF0F6, 0xF02D, 0xF24A, 0xE9A3, 0xFCAA, 0xF570,
0x101F, 0xFC26, 0x1E64, 0x0BA9, 0x1198, 0x1122, 0xFA58, 0x07B0,
0xEE4A, 0x08D6, 0xE990, 0x07EA, 0xEF6C, 0xF29E, 0xE857, 0xE39A,
0xE94C, 0xE943, 0x0BAA, 0xF448, 0x2906, 0x0BE8, 0x1F78, 0x1ED8,
0x0E99, 0x19CD, 0x033B, 0x0FAB, 0xF133, 0x08A4, 0xF2F6, 0xF847,
0xED5B, 0xE46B, 0xDE15, 0xDFA1, 0xF28F, 0xEA67, 0x1710, 0x0614,
0x19CE, 0x1B29, 0x0BE8, 0x185C, 0x063F, 0x1099, 0xF1A6, 0x0534,
0xE747, 0xF280, 0xEBC1, 0xE276, 0xE8B6, 0xDEAF, 0xF894, 0xF087,
0x20E2, 0x1601, 0x2BB4, 0x2524, 0x159C, 0x1513, 0x0D94, 0x0EFC,
0xFB75, 0x0952, 0xE091, 0xEDEC, 0xD8DC, 0xD874, 0xDA15, 0xDD08,
0xED6E, 0xEE56, 0x170C, 0x0DC5, 0x2D29, 0x25CE, 0x1665, 0x17DE,
0xFDC6, 0x0742, 0xF505, 0x039C, 0xEBBB, 0xF078, 0xE172, 0xDE1D,
0xE325, 0xE823, 0xFBA3, 0xF7DB, 0x1DF6, 0x09C3, 0x3471, 0x22D9,
0x2816, 0x1E6F, 0x037A, 0x070D, 0xE33F, 0xFE02, 0xD578, 0xF20C,
0xD5D1, 0xDFCA, 0xDC35, 0xE37E, 0xF56C, 0xF4B9, 0x1807, 0x04B3,
0x29FF, 0x1AB0, 0x2530, 0x1D31, 0x1149, 0x07D6, 0xF3C3, 0x0074,
0xE16E, 0x0242, 0xE294, 0xF038, 0xE0AB, 0xDDAA, 0xF2AF, 0xE914,
0x2042, 0x04F3, 0x2F79, 0x18B2, 0x168B, 0x15D9, 0x02A4, 0x093A,
0xF28B, 0x0799, 0xDE14, 0x023A, 0xDDD1, 0xEF7F, 0xE1C3, 0xE005,
0xE370, 0xE137, 0x0835, 0xF5D9, 0x3571, 0x12E6, 0x2AA8, 0x1BEE,
0x0C29, 0x1499, 0x049E, 0x16C4, 0xF1FD, 0x0C13, 0xE34B, 0xEC88,
0xECBA, 0xDD90, 0xEE5F, 0xE289, 0xF4EC, 0xEF83, 0x17E7, 0x0AA9,
0x23CA, 0x1C50, 0x0D5F, 0x16AD, 0x0290, 0x162B, 0xF2F6, 0x0E47,
0xDAF5, 0xEC2A, 0xDCC4, 0xD733, 0xEF17, 0xDD84, 0xFE76, 0xEAD2,
0x1D5F, 0x0D10, 0x32D0, 0x2DAF, 0x1BA4, 0x1F31, 0x0619, 0x0C05,
0x0069, 0x0CAA, 0xEB04, 0xF3D3, 0xCE82, 0xD1D8, 0xD050, 0xD59F,
0xF136, 0xECBB, 0x19F8, 0x0A19, 0x314E, 0x29CA, 0x2329, 0x2748,
0x071C, 0x0F31, 0xEEFA, 0x03C9, 0xE46E, 0xF1A0, 0xDDFA, 0xD368,
0xD7B0, 0xD2D8, 0xF0E4, 0xF364, 0x215D, 0x139D, 0x3B26, 0x2594,
0x319C, 0x2305, 0x1E92, 0x15A4, 0xF480, 0x0963, 0xC918, 0xF0D2,
0xC78B, 0xD088, 0xD39B, 0xCFD1, 0xE82E, 0xEC8E, 0x189F, 0x0BC0,
0x398E, 0x2356, 0x2783, 0x21E9, 0x1A39, 0x1499, 0x0734, 0x0926,
0xD847, 0xF4B1, 0xCCE0, 0xDFF4, 0xDB89, 0xDC47, 0xE928, 0xE54C,
0x16AA, 0xFDF1, 0x4B0F, 0x2397, 0x320A, 0x285F, 0x0079, 0x1224,
0xF5CC, 0x08AB, 0xDC60, 0xFB76, 0xC7C4, 0xDD91, 0xD6CD, 0xD622,
0xE968, 0xE62A, 0x03F4, 0xF504, 0x3779, 0x1768, 0x429B, 0x295C,
0x1930, 0x1576, 0xFCD9, 0x0F69, 0xE630, 0x0E08, 0xD425, 0xE8ED,
0xDBDB, 0xCA96, 0xF751, 0xDF9F, 0x0D97, 0xFCD9, 0x1E66, 0x1496,
0x276F, 0x23C4, 0x169B, 0x1950, 0x0024, 0x1044, 0xE590, 0x0A82,
0xCF81, 0xE907, 0xCE04, 0xC758, 0xE32F, 0xD5E0, 0x0BEE, 0xF1EA,
0x2D7D, 0x0C35, 0x3184, 0x2A4F, 0x21CA, 0x2D1C, 0x0EBB, 0x1A24,
0xED79, 0x0314, 0xDDE0, 0xE8A6, 0xDE67, 0xD29C, 0xCFD8, 0xD5A0,
0xE6C9, 0xEABF, 0x210B, 0x0A2F, 0x3541, 0x27E3, 0x222C, 0x28E3,
0x12E1, 0x1A5A, 0xEFE2, 0x04F8, 0xCA42, 0xE481, 0xD4F0, 0xC9EF,
0xE0AA, 0xCDDF, 0xEA36, 0xE7FC, 0x1C53, 0x1272, 0x4397, 0x3882,
0x328B, 0x2A12, 0x2145, 0x122A, 0x081E, 0x0F90, 0xC8D6, 0xF2A3,
0xB218, 0xC6F4, 0xCA82, 0xC61A, 0xE474, 0xE570, 0x1189, 0x07EB,
0x3F47, 0x2DDF, 0x3552, 0x3026, 0x1790, 0x1581, 0x070B, 0x07D0,
0xDB9F, 0xEE24, 0xBC4B, 0xC7CF, 0xCB90, 0xCC64, 0xE9FB, 0xF008,
0x1552, 0x03E3, 0x477A, 0x2140, 0x4F80, 0x3915, 0x215A, 0x26B8,
0xEDA0, 0x0A65, 0xC9A9, 0xF079, 0xBA52, 0xCF82, 0xC55B, 0xC474,
0xE360, 0xE173, 0x0D1C, 0x01A5, 0x375E, 0x1CBE, 0x445A, 0x2EAD,
0x2CFB, 0x1F0F, 0x03DA, 0x076B, 0xD083, 0xF800, 0xBD6C, 0xE247,
0xD22F, 0xCD9F, 0xED9B, 0xD62D, 0x1B56, 0xFF27, 0x4422, 0x2BE0,
0x349C, 0x3518, 0x1251, 0x1BC0, 0xFD45, 0x08F4, 0xD1FB, 0xF612,
0xB4D1, 0xD832, 0xC680, 0xC910, 0xE20D, 0xD76B, 0x081E, 0xF5C1,
0x3EFE, 0x1980, 0x4A58, 0x3035, 0x214C, 0x243F, 0x062C, 0x168B,
0xE5EE, 0x049E, 0xC2DF, 0xD710, 0xD359, 0xC230, 0xF1E6, 0xE152,
0xFB49, 0x00F2, 0x1C7F, 0x160A, 0x4044, 0x30F5, 0x28DD, 0x2B72,
0x0570, 0x0F3E, 0xE584, 0xFD09, 0xC05C, 0xE11F, 0xC0EF, 0xC190,
0xE2D3, 0xC95C, 0x013F, 0xEED9, 0x1F59, 0x10F5, 0x3FD1, 0x366F,
0x38A4, 0x3D30, 0x1C30, 0x170D, 0xFC14, 0xF82D, 0xD5D1, 0xEC01,
0xC4D9, 0xD637, 0xC841, 0xC954, 0xE7CD, 0xE75B, 0x1924, 0x116C,
0x3A65, 0x2C13, 0x33AB, 0x313B, 0x1A14, 0x1F32, 0xF8D7, 0x0004,
0xCB4E, 0xE039, 0xC24E, 0xC823, 0xD519, 0xC51C, 0xEA55, 0xE8BB,
0x1765, 0x174E, 0x497E, 0x338A, 0x4B44, 0x322F, 0x3037, 0x2396,
0x0C06, 0x15D2, 0xC62B, 0xEF77, 0xA948, 0xC637, 0xC9C6, 0xC487,
0xE6DD, 0xE1E1, 0x0D38, 0x04B2, 0x4109, 0x2C9B, 0x4838, 0x3CF1,
0x2330, 0x20AB, 0x045E, 0x0015, 0xD765, 0xEB0F, 0xB29D, 0xD147,
0xC60C, 0xC747, 0xEEEB, 0xE5CE, 0x1B10, 0x06AA, 0x4BDB, 0x282F,
0x5A4A, 0x49E7, 0x2F37, 0x36F1, 0xF58D, 0x0499, 0xC57A, 0xE7E6,
0xAE0A, 0xD32D, 0xC00A, 0xBCF6, 0xE62D, 0xD665, 0x144A, 0x09DA,
0x39CD, 0x2791, 0x4519, 0x34F6, 0x357A, 0x2BB1, 0x0F04, 0x0F9E,
0xD2A7, 0xF0D7, 0xB1A4, 0xD9BF, 0xCE56, 0xC5A0, 0xF194, 0xD4D0,
0x18DB, 0x0E1E, 0x465D, 0x3719, 0x45D9, 0x3D30, 0x2021, 0x2A15,
0x0002, 0x0F12, 0xD784, 0xED64, 0xB1EB, 0xCBF3, 0xC60E, 0xC16E,
0xE5D9, 0xD63A, 0xF8A2, 0xF872, 0x2EC0, 0x17A7, 0x5595, 0x3AD7,
0x3448, 0x3C26, 0x0AA6, 0x1800, 0xF069, 0xF9E3, 0xC873, 0xDC26,
0xCBDC, 0xC85D, 0xF4D9, 0xDFBF, 0x0437, 0x031B, 0x1878, 0x16E4,
0x3918, 0x32AE, 0x2D82, 0x3579, 0x0A48, 0x0E9C, 0xF183, 0xF29F,
0xC99B, 0xE56E, 0xB702, 0xC828, 0xD569, 0xC005, 0x021C, 0xED37,
0x2752, 0x1C3B, 0x3EFB, 0x38FF, 0x3E35, 0x400A, 0x222E, 0x1FAC,
0xFCC5, 0xFD85, 0xD655, 0xF22E, 0xC688, 0xD737, 0xD09D, 0xC3DE,
0xE8BC, 0xE977, 0x10B6, 0x1211, 0x3516, 0x23C6, 0x3BC5, 0x2DB0,
0x227E, 0x223C, 0xF4AD, 0x03F8, 0xBB94, 0xDB1B, 0xB3D0, 0xBBFD,
0xDCA4, 0xC44D, 0xF91C, 0xF098, 0x1A78, 0x1712, 0x45C2, 0x2DB2,
0x4CD2, 0x3CDE, 0x2FBE, 0x363A, 0x0BA4, 0x1744, 0xCDA0, 0xEBC3,
0xA8A6, 0xC88A, 0xC553, 0xC21C, 0xE44A, 0xDAD6, 0x093E, 0xFAEA,
0x3E80, 0x21D0, 0x442D, 0x4022, 0x13DF, 0x26FD, 0xF2D1, 0xF8FC,
0xD82E, 0xE4A4, 0xC271, 0xD855, 0xD7A8, 0xD045, 0xF681, 0xDF2E,
0x13E6, 0xFECB, 0x3DF3, 0x2AED, 0x5060, 0x4CFF, 0x2522, 0x3669,
0xF2AB, 0x071D, 0xD1FB, 0xEF7B, 0xB179, 0xD247, 0xBF6A, 0xB1A7,
0xF0A5, 0xCC41, 0x102A, 0x036A, 0x20EB, 0x1A8B, 0x2CCA, 0x25D7,
0x1E16, 0x24BA, 0x07CD, 0x145C, 0xF1D2, 0x03F6, 0xD3B9, 0xE512,
0xD802, 0xC469, 0xF9BF, 0xD7A1, 0x1902, 0x0C3C, 0x2A2B, 0x2611,
0x2E9C, 0x32F2, 0x1F3F, 0x36BC, 0xFB96, 0x1985, 0xD927, 0xEC17,
0xC40D, 0xCD04, 0xCB12, 0xC186, 0xDFF2, 0xC8B8, 0xF09A, 0xE0BB,
0x0D6D, 0xFF53, 0x30AE, 0x289C, 0x317C, 0x417F, 0x1D15, 0x2E77,
0x00DE, 0x0361, 0xDCE8, 0xE091, 0xDEB8, 0xD6F0, 0xEC21, 0xD95B,
0xF396, 0xE856, 0x163E, 0x10A8, 0x3278, 0x3878, 0x2108, 0x3663,
0x0950, 0x196D, 0xF9B4, 0x027F, 0xCE76, 0xE324, 0xB560, 0xB6C4,
0xCAE7, 0xAF65, 0xEBED, 0xDBF3, 0x1699, 0x0DD9, 0x4691, 0x3975,
0x45B3, 0x44BF, 0x1F07, 0x28D8, 0x0C23, 0x14DA, 0xE4BE, 0xF56B,
0xBB56, 0xC494, 0xCEC0, 0xBF16, 0xF316, 0xE800, 0x07C3, 0x08DB,
0x2888, 0x20AC, 0x3782, 0x38AA, 0x1415, 0x2EAF, 0xEEF4, 0x0140,
0xCB08, 0xD3B8, 0xB358, 0xB935, 0xD294, 0xBF69, 0x04C1, 0xEB28,
0x252D, 0x10DE, 0x4124, 0x2A9E, 0x49E3, 0x49FF, 0x260A, 0x4408,
0xF552, 0x0F1C, 0xD285, 0xE0FC, 0xC680, 0xD12C, 0xCF46, 0xC709,
0xE90E, 0xD00E, 0x110C, 0xFAC0, 0x2B9B, 0x251F, 0x2686, 0x3233,
0x0642, 0x20C0, 0xEBCB, 0x04D9, 0xD8AC, 0xE73A, 0xD0C7, 0xD3BC,
0xEB29, 0xCE4A, 0x084A, 0xD917, 0x2265, 0x0502, 0x4077, 0x36F5,
0x336C, 0x3E08, 0x039F, 0x2640, 0xF618, 0x195F, 0xE836, 0xFE82,
0xC4E2, 0xCC6B, 0xCDE4, 0xB9AB, 0xED9B, 0xD029, 0xFE02, 0xEDEF,
0x13F2, 0x08FB, 0x22EF, 0x2553, 0x0F04, 0x2F4B, 0x0388, 0x2348,
0x0521, 0x0844, 0xEA3C, 0xDBCE, 0xE4B4, 0xC75F, 0x0144, 0xE2F8,
0x06C1, 0xF96A, 0x0A76, 0x0524, 0x2528, 0x2D42, 0x1C2E, 0x4360,
0xFC9F, 0x22E2, 0xF30F, 0xF8DF, 0xDCAB, 0xDC37, 0xC962, 0xC0F1,
0xD832, 0xB91F, 0xF0A2, 0xD8E5, 0x0ACA, 0x0756, 0x2851, 0x2FE5,
0x2D15, 0x4578, 0x1B77, 0x3032, 0x0C7A, 0x07C0, 0xF4F8, 0xF0A6,
0xD95E, 0xD409, 0xD19C, 0xB8F8, 0xEB21, 0xD6B1, 0x1434, 0x1533,
0x285D, 0x3241, 0x1BAB, 0x3183, 0x0610, 0x2A8C, 0xF6CA, 0x0A34,
0xDA56, 0xD457, 0xC47D, 0xB645, 0xD587, 0xC056, 0xFA70, 0xE319,
0x20D4, 0x1492, 0x3E8D, 0x38A1, 0x3632, 0x3E3D, 0x1B23, 0x3D3C,
0x0522, 0x20AB, 0xD857, 0xDBF8, 0xBBCF, 0xB0C4, 0xD317, 0xC1B2,
0xF24C, 0xE270, 0x0E8A, 0xFE04, 0x2AEF, 0x2726, 0x218A, 0x3C22,
0xFF64, 0x241B, 0xF00D, 0xFF4E, 0xE1DA, 0xE207, 0xD71F, 0xCDAF,
0xEAA3, 0xCDF5, 0x0A9A, 0xE2D5, 0x222E, 0x04B0, 0x35FF, 0x341B,
0x2DAF, 0x4CF9, 0x00E2, 0x3335, 0xE484, 0x03CE, 0xDDB2, 0xE60D,
0xD27A, 0xD09D, 0xD472, 0xBB77, 0xEF2A, 0xCD72, 0x0A92, 0xFCC4,
0x1C89, 0x18AB, 0x1727, 0x1FE7, 0xFD89, 0x298A, 0xFEC1, 0x2460,
0x059C, 0x039F, 0xF578, 0xDCC1, 0xF13D, 0xC942, 0x00AA, 0xDC6B,
0x0F15, 0x07BF, 0x1712, 0x2401, 0x0CDF, 0x2024, 0xF80A, 0x235B,
0xF611, 0x2391, 0xF1B1, 0xF6D8, 0xDFDD, 0xCB07, 0xD9FE, 0xC481,
0xE5B8, 0xC8A9, 0xF694, 0xD6BF, 0x0C71, 0x0795, 0x1E91, 0x355C,
0x1A46, 0x421D, 0x1896, 0x323C, 0x15BB, 0x07A7, 0xFDFE, 0xE28A,
0xE9A6, 0xD6C3, 0xE6DC, 0xD8E3, 0xF001, 0xE15F, 0x05C9, 0x05AD,
0x14AC, 0x2EEA, 0x0466, 0x30E0, 0xF843, 0x1BB3, 0xF798, 0x0415,
0xE7C5, 0xDCBF, 0xD676, 0xAFCA, 0xDB59, 0xB2F1, 0xFCF9, 0xE705,
0x27CB, 0x218C, 0x3A5F, 0x3C0D, 0x2870, 0x3A7D, 0x163E, 0x3391,
0x0785, 0x1997, 0xE755, 0xEC11, 0xCF56, 0xBF60, 0xD5FE, 0xB896,
0xF106, 0xDFB7, 0x0BCE, 0x0CBD, 0x185A, 0x202A, 0x0A95, 0x2D4A,
0xFC64, 0x2E36, 0xF699, 0xFE19, 0xE21D, 0xCBE8, 0xDA8D, 0xC674,
0xF275, 0xD88C, 0x1470, 0xED6B, 0x30A2, 0x1240, 0x3A5D, 0x3492,
0x211B, 0x3FC0, 0xFE6B, 0x3BFF, 0xF0FF, 0x14E4, 0xE883, 0xDF0A,
0xDC59, 0xC7DF, 0xDC91, 0xC8E3, 0xEFB8, 0xD110, 0x057F, 0xF953,
0x12CC, 0x2712, 0x089C, 0x2275, 0xF081, 0x10D6, 0xF25F, 0x10E1,
0x0393, 0x04A4, 0x05F6, 0xE1E8, 0x0649, 0xD067, 0x1851, 0xE48C,
0x250E, 0x0E34, 0x18C6, 0x2D30, 0x0264, 0x2EC2, 0xF203, 0x24E2,
0xEF78, 0x185F, 0xF1E3, 0xFD45, 0xE766, 0xCE22, 0xDC8C, 0xBBB5,
0xEF19, 0xD6AF, 0x0A79, 0xF142, 0x0B4E, 0x0341, 0x0221, 0x1F70,
0x0902, 0x3B64, 0x13BC, 0x3024, 0x153A, 0x0495, 0x119C, 0xE37B,
0x023C, 0xD806, 0xF80E, 0xDDB9, 0x05C2, 0xFA89, 0x0E59, 0x150E,
0x043A, 0x2330, 0xFB9A, 0x333B, 0xF6E1, 0x21CB, 0xEEB1, 0xF471,
0xE7A7, 0xD661, 0xE5ED, 0xC30B, 0xE929, 0xB926, 0xFB2E, 0xDFAE,
0x1B9A, 0x24D4, 0x28C1, 0x4016, 0x1C5B, 0x346E, 0x17AC, 0x2CDE,
0x14E5, 0x18D5, 0xF9CE, 0xE698, 0xE128, 0xC7D4, 0xEA2C, 0xCB05,
0x01B1, 0xE65C, 0x100D, 0x1736, 0x0E3F, 0x2CFA, 0xFB0C, 0x23C3,
0xECC4, 0x2029, 0xF766, 0x0AAB, 0xF36E, 0xD115, 0xDDB3, 0xB56E,
0xF68E, 0xD73D, 0x22B9, 0xFFEB, 0x2A67, 0x160F, 0x2950, 0x30AF,
0x1FD1, 0x3ED7, 0xFE4E, 0x2C09, 0xEEAF, 0x101F, 0xF116, 0xE717,
0xE75B, 0xC388, 0xEC24, 0xCD6C, 0x079C, 0xED9D, 0x0B9A, 0x03EA,
0xF93B, 0x1A78, 0xF948, 0x2779, 0xF4C5, 0x15C2, 0xEB78, 0xFF37,
0x007A, 0xF4AE, 0x1044, 0xE786, 0x1189, 0xD764, 0x227B, 0xEC20,
0x29BD, 0x1A74, 0x104E, 0x2AD7, 0xF1F0, 0x2523, 0xE6BB, 0x1F56,
0xECDC, 0x10A9, 0xF4AD, 0xF14A, 0xF658, 0xD715, 0xF79D, 0xCC17,
0xFB93, 0xD7F5, 0x059C, 0xFCB5, 0x0602, 0x12C9, 0xF505, 0x1274,
0xF204, 0x22F9, 0x0C08, 0x2F72, 0x1C43, 0x0339, 0x1165, 0xDB23,
0x1186, 0xE327, 0x138F, 0xECF2, 0x0030, 0xF941, 0xF6C4, 0x1692,
0xF72C, 0x2118, 0xEBC5, 0x1AEB, 0xF154, 0x1EC8, 0xFF9C, 0xFF37,
0xED3F, 0xCC96, 0xE80A, 0xC5C9, 0x0364, 0xD390, 0x048A, 0xE6C8,
0xFF4E, 0x160B, 0x1467, 0x3AD0, 0x180A, 0x2DF7, 0x12D7, 0x201B,
0x1E34, 0x1617, 0x0F7B, 0xEDCD, 0xEF39, 0xCA8C, 0xEFAE, 0xD3CA,
0xFAD7, 0xF22A, 0xF443, 0x0EE1, 0xF460, 0x241E, 0xF6DF, 0x2307,
0xED00, 0x16A5, 0xF101, 0xFD63, 0xFD06, 0xD57B, 0xFA71, 0xBEC3,
0x0272, 0xD4C8, 0x19A3, 0x020E, 0x1F5C, 0x1D6A, 0x15F4, 0x26A2,
0x0EBC, 0x2FF6, 0x08E8, 0x3103, 0xFB51, 0x0B9E, 0xEF16, 0xDDD5,
0xF450, 0xCF52, 0xF970, 0xD364, 0xFAEB, 0xE91C, 0x00F8, 0x0D2D,
0xF50E, 0x1998, 0xE1D6, 0x1009, 0xEC5A, 0x113A, 0xFE4E, 0x01BC,
0x01BF, 0xE72C, 0x1266, 0xE5E8, 0x273F, 0xE99D, 0x23A9, 0xF04A,
0x18C4, 0x1555, 0x0CBD, 0x3136, 0xF18E, 0x1E62, 0xE32E, 0x1270,
0xF100, 0x0D87, 0xF652, 0xEB11, 0xF446, 0xD091, 0x0219, 0xD7BF,
0xFE95, 0xE66C, 0xE832, 0xF8DA, 0xE8DA, 0x0D01, 0xEF95, 0x0E26,
0xF5D5, 0x165F, 0x10C3, 0x221C, 0x2563, 0x0652, 0x2650, 0xE107,
0x2554, 0xE30D, 0x19C3, 0xF7A3, 0xFE91, 0x06A5, 0xE6D9, 0x12A2,
0xE1A9, 0x17BE, 0xE929, 0x18C1, 0xF1C4, 0x0EDC, 0xFECC, 0xF5E2,
0x02CC, 0xD95E, 0xF504, 0xC9E6, 0xED92, 0xD423, 0xF3EE, 0xF27D,
0xF81E, 0x12EB, 0xFFE2, 0x289C, 0x15F2, 0x2E25, 0x258C, 0x2104,
0x2666, 0x094B, 0x2108, 0xF0CE, 0x11B2, 0xDEB1, 0xF87A, 0xDA47,
0xE91A, 0xF456, 0xE69B, 0x13F7, 0xE22F, 0x1671, 0xEB7B, 0x1740,
0xFCA1, 0x144F, 0xFA92, 0xF4C8, 0xF677, 0xD388, 0x000B, 0xCC4F,
0x0398, 0xDC13, 0x05F2, 0x022A, 0x0ED5, 0x236C, 0x100E, 0x274E,
0x130E, 0x2555, 0x16C2, 0x234E, 0x12B3, 0x0BCF, 0x0AE1, 0xE3AC,
0x02DC, 0xD30B, 0xF8DD, 0xDEA9, 0xED21, 0xF2E6, 0xE970, 0x0A4C,
0xE7F4, 0x176F, 0xE51B, 0x101A, 0xE751, 0x03D6, 0xF791, 0xFCCB,
0x10DC, 0xECC7, 0x1BCD, 0xE513, 0x190F, 0xEDD7, 0x1A3E, 0x01D3,
0x1472, 0x1A56, 0x0286, 0x227E, 0xFD2D, 0x1D61, 0xFD86, 0x0F4B,
0xFF08, 0x0168, 0x0750, 0xF3DC, 0x030E, 0xDEF5, 0xF57A, 0xD8AB,
0xF0BA, 0xEF55, 0xE855, 0xFFF6, 0xD6BB, 0x01CB, 0xDF91, 0x0C9A,
0x027B, 0x1563, 0x1D60, 0x1437, 0x2C61, 0x044D, 0x2FD9, 0xF1EB,
0x1EC9, 0xEF2C, 0x07CB, 0xF8F2, 0xF709, 0x07CA, 0xE763, 0x0F08,
0xE87F, 0x0F03, 0xF724, 0x111A, 0x0331, 0x0DC8, 0x0E80, 0xF8BB,
0x0E19, 0xE174, 0xF8BA, 0xD41E, 0xDF1E, 0xD87A, 0xD4A1, 0xF19F,
0xE2CD, 0x132F, 0xFFC8, 0x2728, 0x14DD, 0x2014, 0x2C30, 0x1D0D,
0x3BC6, 0x17B9, 0x289E, 0xF4DF, 0x0931, 0xDB4B, 0xF3CA, 0xE306,
0xE485, 0xF33B, 0xDE63, 0x097D, 0xE7F3, 0x1912, 0xF4FA, 0x1137,
0x0465, 0x0D49, 0x12C2, 0x0051, 0x03A4, 0xD91E, 0xE660, 0xC89A,
0xEBCF, 0xE7D0, 0xFC30, 0x07D4, 0xFC6F, 0x13A9, 0x0EA5, 0x2455,
0x21D4, 0x2BAD, 0x2297, 0x1C43, 0x22A3, 0x0830, 0x1454, 0xED24,
0xF6A2, 0xD43C, 0xE634, 0xDDB7, 0xE2B8, 0xF577, 0xE0F4, 0x0682,
0xEA9B, 0x1427, 0xF85E, 0x0D42, 0xFEC9, 0xFC87, 0x030B, 0xF6E4,
0x0B2D, 0xF47E, 0x0C8A, 0xEEB0, 0x0618, 0xEF0A, 0x0569, 0xFF6D,
0x0803, 0x1D1E, 0x0815, 0x2526, 0x048E, 0x112B, 0x0E3E, 0x0905,
0x19C5, 0x0723, 0x0A9F, 0xF301, 0xF38F, 0xDD48, 0xE9C7, 0xE07C,
0xE120, 0xF0D2, 0xDD72, 0xFF88, 0xE652, 0x0299, 0xE6A2, 0xFB44,
0xFC9D, 0x0BB1, 0x2C05, 0x21C7, 0x3119, 0x08E2, 0x17FA, 0xEADB,
0x113E, 0xFA97, 0x01CA, 0x0124, 0xE99E, 0xFCDA, 0xF1A3, 0x0C4B,
0xFC1D, 0x0CF5, 0x0143, 0x089A, 0x14EC, 0x0F14, 0x14C0, 0x001C,
0xF6D0, 0xE4BA, 0xE563, 0xDDEA, 0xDF2B, 0xDC06, 0xCF31, 0xE756,
0xDDF9, 0x0B63, 0x0772, 0x2254, 0x254E, 0x1D0D, 0x3B6C, 0x1C9D,
0x3D3C, 0x1F39, 0x1B8D, 0xFE4F, 0xF7F0, 0xDD85, 0xEB31, 0xDE35,
0xE66B, 0xF367, 0xE722, 0x09FE, 0xF0AE, 0x0E2D, 0x08C0, 0x0E84,
0x1AA5, 0x170F, 0x0DA6, 0x0960, 0xF2FB, 0xDEFF, 0xDAF4, 0xCA93,
0xD3A0, 0xDCDA, 0xE9FB, 0x045F, 0x0B6F, 0x18EC, 0x1B38, 0x147A,
0x2DB5, 0x25E9, 0x3EBF, 0x3338, 0x26BE, 0x1142, 0xFEFE, 0xE637,
0xEC71, 0xDCB4, 0xE041, 0xE0E3, 0xD77F, 0xF081, 0xEB11, 0x086E,
0xFD20, 0x0E55, 0x0455, 0x0B6F, 0x1792, 0x0ACD, 0x0D2A, 0xFF6D,
0xEA0B, 0xED55, 0xEA61, 0xF14E, 0xF967, 0xF21F, 0xFE03, 0xF4BE,
0x10CB, 0x1852, 0x1B97, 0x2706, 0x1C23, 0x11B3, 0x28CA, 0x0D2C,
0x21B0, 0x0FB7, 0xFCD5, 0xF7E6, 0xE17F, 0xE271, 0xDEA7, 0xDF77,
0xE03B, 0xF001, 0xE711, 0x0338, 0xF238, 0xFF93, 0xFD69, 0xFBE4,
0x1011, 0x1111, 0x1B97, 0x2787, 0x1419, 0x0F52, 0x0853, 0xE926,
0x036A, 0xEC60, 0x00FE, 0x03C8, 0x02EF, 0x04CC, 0x05CF, 0xFB1E,
0x1029, 0x084F, 0x1F18, 0x1E16, 0x14E3, 0x1D48, 0xFA6E, 0x02DE,
0xE75A, 0xEADD, 0xDC92, 0xDAD7, 0xDC1D, 0xD905, 0xE4DB, 0xEAA9,
0xEFB8, 0xFFC0, 0x0C65, 0x1B37, 0x353F, 0x2FE2, 0x39B7, 0x2726,
0x1E68, 0x1417, 0x0484, 0x03DF, 0xEDE2, 0xE04D, 0xE9C1, 0xD0DB,
0xF82D, 0xEDA0, 0xFDD6, 0x063A, 0x0649, 0x10D3, 0x1E69, 0x1EF8,
0x1D82, 0x28F0, 0xF9F5, 0x1095, 0xE0D8, 0xE16D, 0xD318, 0xC558,
0xD1A0, 0xD5C0, 0xF1AE, 0x032D, 0x137E, 0x1B1A, 0x2B85, 0x188B,
0x43EB, 0x2AB4, 0x3AED, 0x4097, 0x10E0, 0x1AF7, 0xF142, 0xDE02,
0xE1DD, 0xC855, 0xDE5C, 0xDBA9, 0xE976, 0xF378, 0xFB13, 0xFF5C,
0x0D28, 0x13BB, 0x1A46, 0x2513, 0x1844, 0x1DBF, 0xF88B, 0x01AD,
0xD8CF, 0xE6ED, 0xDA82, 0xE108, 0xF366, 0xF06C, 0x115E, 0xFC62,
0x20A5, 0x0C5A, 0x28C1, 0x297E, 0x319A, 0x2D9B, 0x2824, 0x1A59,
0x0705, 0x0444, 0xE5F0, 0xEFB7, 0xD345, 0xDB17, 0xDA82, 0xD764,
0xF3C3, 0xEF74, 0xFB23, 0x04DB, 0x055A, 0x08D5, 0x176D, 0x0CE8,
0x0FBD, 0x1CC8, 0xFD67, 0x22DB, 0xF903, 0x0C9B, 0xFA31, 0xE50D,
0x01D1, 0xDE2D, 0x0ECF, 0xFEF8, 0x0EE5, 0x0C0C, 0x16E8, 0x0397,
0x2686, 0x0B89, 0x1C40, 0x22FD, 0xF7DD, 0x2078, 0xDE02, 0xF970,
0xD998, 0xDB10, 0xDBE6, 0xDD15, 0xEF1C, 0xE214, 0xFCAB, 0xE61D,
0x01A6, 0x00B5, 0x1931, 0x2619, 0x2BC1, 0x3DE5, 0x1F30, 0x30CA,
0x073D, 0x09A6, 0xF316, 0xEBC8, 0xEBA5, 0xE070, 0xFC46, 0xD9FD,
0x0815, 0xDF7D, 0x0DC7, 0x0195, 0x16AC, 0x2217, 0x1529, 0x2888,
0x018E, 0x21CB, 0xE24E, 0x0A2A, 0xD201, 0xDB43, 0xD71E, 0xC03C,
0xE942, 0xD269, 0xFE0E, 0xF906, 0x19A7, 0x1CD0, 0x3809, 0x2FE2,
0x40B6, 0x3709, 0x22B8, 0x34CB, 0xF47D, 0x1362, 0xE004, 0xD65E,
0xE668, 0xB85A, 0xF529, 0xCE46, 0xF898, 0xF2DF, 0x03B7, 0x0BA9,
0x1A4B, 0x1F5A, 0x17B4, 0x33AD, 0xFD97, 0x281C, 0xDFE9, 0xF86D,
0xCC35, 0xD041, 0xD6A1, 0xD270, 0x018C, 0xEBC9, 0x2055, 0xFE6B,
0x3196, 0x15C9, 0x3D17, 0x32B3, 0x2B31, 0x3C5E, 0x0B36, 0x252B,
0xEE9C, 0xF802, 0xDA28, 0xD0D5, 0xD4AB, 0xCCED, 0xEB6F, 0xD91C,
0x0448, 0xE92E, 0x0A66, 0x0C47, 0x147A, 0x219E, 0x1576, 0x1B39,
0xF779, 0x1576, 0xD974, 0x10CA, 0xDC87, 0xF7C3, 0xF1FC, 0xDDC4,
0x1526, 0xE109, 0x2A42, 0xFB2F, 0x217E, 0x1453, 0x22F4, 0x1DA3,
0x2709, 0x1C0A, 0x0CBA, 0x171B, 0xDFD2, 0x0D5E, 0xCD43, 0xECD3,
0xDA0A, 0xCF0C, 0xEE5C, 0xD7BC, 0xFFA6, 0xEC36, 0x09D7, 0xF6B4,
0x0ED3, 0x0978, 0x0FD7, 0x2A1B, 0x0B6B, 0x38B8, 0xFCFC, 0x2367,
0xF3B6, 0xF806, 0xF9D9, 0xDD9C, 0x0681, 0xDDEE, 0x0FF7, 0xE3B3,
0x17D7, 0xF0BC, 0x1FC0, 0x0AE1, 0x16CF, 0x2955, 0xFE3C, 0x2E91,
0xE6AB, 0x169D, 0xD3E8, 0xF48B, 0xD145, 0xD4F6, 0xEAEB, 0xC18A,
0x00AD, 0xCC8A, 0x0626, 0xFAB8, 0x19F3, 0x29A9, 0x2F29, 0x3E54,
0x260B, 0x379D, 0x0885, 0x28FA, 0xED3A, 0x0773, 0xE2BD, 0xD43E,
0xF7EC, 0xBC48, 0x1101, 0xCD33, 0x0FC8, 0xF624, 0x0DFD, 0x1A67,
0x17F3, 0x2E5C, 0x0791, 0x30C1, 0xDEDB, 0x1D94, 0xCE4F, 0xEE9A,
0xD20E, 0xC13E, 0xE578, 0xC255, 0x0C05, 0xE849, 0x27F1, 0x0F29,
0x348C, 0x25A7, 0x39A0, 0x3A85, 0x21E8, 0x3D3C, 0xF426, 0x1E1C,
0xDBE2, 0xEEE2, 0xDCC8, 0xC6E9, 0xEB8B, 0xC339, 0x0277, 0xDABF,
0x14A5, 0xF963, 0x17DA, 0x1955, 0x1008, 0x3070, 0x0067, 0x2656,
0xE12F, 0x06D5, 0xCACA, 0xF0CB, 0xD45B, 0xE1CA, 0xFAAC, 0xDB0E,
0x2465, 0xE625, 0x34B9, 0x08D6, 0x30C3, 0x2885, 0x27EB, 0x30C1,
0x12BF, 0x2232, 0xEEBA, 0x0AEB, 0xD4A6, 0xFA42, 0xCF66, 0xE066,
0xE84E, 0xCB0D, 0x09F6, 0xD61E, 0x0F13, 0xF817, 0x0B49, 0x0E17,
0x0D75, 0x16C2, 0xFFE7, 0x1F79, 0xE6C6, 0x1F23, 0xE3FE, 0x1106,
0xF043, 0xEF4A, 0x031D, 0xD5EA, 0x1FEC, 0xE1A4, 0x290F, 0xFCF3,
0x1D30, 0x0A42, 0x188E, 0x15E5, 0x0A57, 0x255D, 0xE3B2, 0x1F69,
0xD500, 0x0887, 0xDDF1, 0xE958, 0xE5BD, 0xCEC4, 0xFD3D, 0xCBFA,
0x0EB0, 0xE03B, 0x0A2D, 0xFF3E, 0x0E12, 0x24B0, 0x14F8, 0x3C1C,
0x01DC, 0x2CF6, 0xF0DE, 0x1367, 0xF28D, 0xF87A, 0xFA29, 0xD534,
0x0D03, 0xC75A, 0x1BC4, 0xDFFD, 0x15D7, 0x05D9, 0x0ADB, 0x21A8,
0x07D1, 0x2EDC, 0xF422, 0x243C, 0xD8A2, 0x0CF3, 0xD2E6, 0xEC01,
0xDBDB, 0xC43C, 0xF512, 0xBD0C, 0x121E, 0xE90F, 0x1F02, 0x18E6,
0x233D, 0x2C90, 0x1F72, 0x35C4, 0x0925, 0x2D62, 0xF291, 0x1328,
0xE768, 0xEB0F, 0xE843, 0xC2FC, 0x001B, 0xC47A, 0x1170, 0xEC7A,
0x0FEE, 0x1063, 0x147A, 0x233D, 0x0FAA, 0x2EC0, 0xEC0B, 0x2009,
0xCEB1, 0xFEAD, 0xCE8C, 0xE2AB, 0xDE16, 0xCF2C, 0x060C, 0xD669,
0x28EF, 0xF783, 0x28CC, 0x134E, 0x258A, 0x26CE, 0x2445, 0x34D1,
0x0497, 0x1E92, 0xE07A, 0xFBAA, 0xDB7D, 0xE9F4, 0xDF08, 0xD68C,
0xF4CE, 0xCF96, 0x196B, 0xEAA4, 0x1C94, 0x0D58, 0x0AD2, 0x1946,
0x012A, 0x1E71, 0xE908, 0x15CE, 0xD323, 0x020F, 0xE2F8, 0xFDB3,
0xF5C8, 0xEDA9, 0x0839, 0xD73C, 0x282D, 0xEB26, 0x3485, 0x1200,
0x243D, 0x180E, 0x0EE1, 0x1718, 0xF7F4, 0x1991, 0xDEC1, 0x0D53,
0xDA15, 0xFD4E, 0xE65B, 0xE781, 0xFE37, 0xD6BD, 0x13D8, 0xE2DE,
0x0E03, 0xFE95, 0x0057, 0x085A, 0xFDF1, 0x12A4, 0xF91F, 0x2348,
0xEE6A, 0x1DD3, 0xED78, 0x06E6, 0xF3A4, 0xE9F9, 0x1084, 0xDB96,
0x2E7C, 0xE469, 0x1FFA, 0xF640, 0x0BFB, 0x071C, 0x075C, 0x1C4A,
0xF565, 0x259F, 0xE354, 0x173A, 0xEA24, 0x03C2, 0xEA25, 0xE8ED,
0xEC85, 0xD44D, 0x05DA, 0xDB18, 0x0EBB, 0xF3AB, 0x0DA1, 0x0B70,
0x1335, 0x2741, 0x05BF, 0x2FE2, 0xEC39, 0x15CE, 0xF975, 0x063D,
0x071F, 0xF25E, 0xFBDA, 0xD050, 0x0B1A, 0xD365, 0x1789, 0xF9C0,
0x0AD7, 0x110D, 0x0285, 0x1CCB, 0x0282, 0x2799, 0xF06F, 0x158B,
0xDE31, 0xFD68, 0xDD80, 0xEBC4, 0xE7CC, 0xD347, 0x0CF6, 0xD6D8,
0x2512, 0x04C9, 0x18BF, 0x1DFA, 0x090C, 0x17E6, 0x0E84, 0x2179,
0x0E16, 0x1FF7, 0xF6AD, 0x02F7, 0xE720, 0xE671, 0xEE7D, 0xDA01,
0x0A4F, 0xE2E0, 0x1694, 0xFCF2, 0x13C9, 0x0F67, 0x0E53, 0x12F3,
0xFB16, 0x1CE2, 0xE238, 0x19C1, 0xDAEE, 0xFEB3, 0xEAFA, 0xE80E,
0xFB20, 0xE8E5, 0x1265, 0xF566, 0x1C2E, 0xFD10, 0x1ADB, 0x0512,
0x2683, 0x1478, 0x18B9, 0x1F95, 0xEF6B, 0x1255, 0xE10C, 0x02B0,
0xEF9F, 0xFC14, 0xF204, 0xEFAC, 0x0642, 0xE8DE, 0x2087, 0xF220,
0x0FF2, 0x00C0, 0xF439, 0x0ACE, 0xED72, 0x11CA, 0xF0E4, 0x0B57,
0xF3E3, 0x06AB, 0xFAB0, 0x0C77, 0xF863, 0xF990, 0x0B3D, 0xE196,
0x3532, 0xF3EE, 0x3103, 0x0BF3, 0x044A, 0x0547, 0xEF18, 0x0A81,
0xF49C, 0x1CA4, 0xEFEE, 0x1821, 0xF2D7, 0x047C, 0x01A0, 0xF1A8,
0x0BA9, 0xE94A, 0x0CD3, 0xF325, 0xFFDD, 0xFCB7, 0xF64B, 0xF57B,
0xFA75, 0x03A7, 0xFE2C, 0x2656, 0xF263, 0x1F92, 0xF445, 0xF971,
0x0FA7, 0xEE2F, 0x2724, 0xF605, 0x21B5, 0xF2E1, 0x04E5, 0xF303,
0xF8C7, 0xFFEA, 0xFC4D, 0x14AD, 0xFA34, 0x21C9, 0xF81C, 0x1557,
0xFFE0, 0x028F, 0xF963, 0xFD30, 0xEF5F, 0xF438, 0x02E7, 0xE134,
0x0F76, 0xE3F7, 0x02D4, 0x01CC, 0xF4EC, 0x178C, 0xF960, 0x15E1,
0x0A31, 0x0CF7, 0x1DDD, 0x0C40, 0x15F5, 0x081D, 0xF534, 0xF2D5,
0xFD7E, 0xE791, 0x0FED, 0xFC0F, 0xFF12, 0x07E8, 0xF3C7, 0x0031,
0x0511, 0x1019, 0x03F6, 0x2291, 0xEE2C, 0x10B9, 0xEF67, 0xF41C,
0xFAE2, 0xE4D3, 0x0BA6, 0xE98B, 0x0BB3, 0xFC11, 0xF5D8, 0xFB09,
0xFA01, 0xF2A2, 0x1C86, 0x0ED8, 0x2462, 0x2B55, 0x0219, 0x144E,
0xF0C0, 0xF74A, 0xFCAB, 0xFFA6, 0x0D7E, 0x035C, 0x0B68, 0xEFB5,
0xFEDA, 0xED96, 0xFBA4, 0x0427, 0xF671, 0x1972, 0xEEA1, 0x1822,
0xF236, 0xFD17, 0x02D4, 0xF483, 0xFD68, 0x0483, 0xFA43, 0xF83C,
0x0D66, 0xE03D, 0x13D3, 0xE8D2, 0x14CE, 0x04DD, 0x0C01, 0x18CC,
0xF606, 0x16AC, 0xF6A9, 0x0FF5, 0x0B9E, 0x154C, 0x021D, 0x08D1,
0xFC46, 0xEABB, 0x1418, 0xECEE, 0x06AF, 0x0119, 0xDF3D, 0xF6BF,
0xE1FC, 0xF05C, 0xFEC2, 0x09F8, 0xFD70, 0x159C, 0xF7C6, 0x09B0,
0xFED3, 0xFD39, 0x0E4F, 0xED97, 0x2903, 0xECD3, 0x1E03, 0xFFDE,
0xEECC, 0xFA63, 0xE5C8, 0xF94D, 0x0A88, 0x22DE, 0x0EBE, 0x2AE0,
0xFCD2, 0x0637, 0x041F, 0x0268, 0x0F13, 0x0D51, 0x0442, 0xF40F,
0xE7C4, 0xD958, 0xDDF2, 0xDAFC, 0xE9E0, 0xF010, 0xFA81, 0x11E4,
0x0311, 0x19F3, 0x0CF2, 0x0561, 0x1C3A, 0x0554, 0x20F1, 0x0EE4,
0x14AE, 0xF9C5, 0xF34F, 0xE19E, 0xE862, 0xED6F, 0xF95A, 0x0506,
0x02BE, 0x1303, 0x090F, 0x1AEB, 0x18E4, 0x20FC, 0x1631, 0x1D5F,
0xF5AC, 0xFC7B, 0xED39, 0xD9E5, 0xF06C, 0xD6D9, 0xE09D, 0xDDA1,
0xDFD6, 0xE884, 0x001A, 0x088F, 0x1C78, 0x1FA7, 0x286F, 0x2099,
0x2B64, 0x224E, 0x0B08, 0x0E9F, 0xF7A4, 0xEB51, 0x0308, 0xE673,
0xEE4D, 0xED9E, 0xDA02, 0xEE46, 0xFF78, 0x0F41, 0x24E7, 0x364A,
0x114C, 0x2375, 0xF706, 0x032F, 0xF389, 0xFBF3, 0xF3E7, 0xE340,
0xF1A8, 0xCB0C, 0xE8F9, 0xD84B, 0xE697, 0xEBCD, 0x0589, 0x07A5,
0x2FC6, 0x31CA, 0x2BC5, 0x355D, 0x0E99, 0x1AD4, 0x06DF, 0x0B8B,
0x0318, 0xF5C7, 0xF16C, 0xDD85, 0xE5EE, 0xE346, 0xEE94, 0xF780,
0x02DA, 0x096B, 0x0D8E, 0x1CC2, 0x030A, 0x1E14, 0xFE36, 0x0BD6,
0x0128, 0xF872, 0xFB33, 0xE851, 0xF4EA, 0xDCAC, 0xEAD3, 0xDD49,
0xEDF6, 0xED1C, 0x0F8E, 0x0C04, 0x26FF, 0x2F3F, 0x1E1F, 0x2FED,
0x169D, 0x1B04, 0x0D09, 0x1054, 0xF551, 0xFDC4, 0xF198, 0xE5BC,
0xF280, 0xDDC8, 0xDE28, 0xE437, 0xDB69, 0xF0D9, 0xFD5B, 0x0E74,
0x1739, 0x1C0F, 0x17BC, 0x0AA6, 0x1166, 0x0A83, 0xFB81, 0x0333,
0xEFA5, 0xE121, 0xFB7D, 0xD97E, 0xFA80, 0xF3CD, 0xF6B6, 0x055D,
0x0F83, 0x15C6, 0x2763, 0x2F4A, 0x1F04, 0x3139, 0x116D, 0x1E34,
0x011C, 0x0081, 0xEE8A, 0xE019, 0xDD32, 0xCF5F, 0xC3AE, 0xD19C,
0xCF71, 0xDCF0, 0x0CD0, 0xF9A2, 0x31D7, 0x26B3, 0x1E6F, 0x33E3,
0x09EC, 0x1C9E, 0x05AA, 0x010F, 0x049B, 0xEDAE, 0xFD6A, 0xE46D,
0xDEF1, 0xDF67, 0xDB22, 0xE769, 0x0DB4, 0x1112, 0x30A3, 0x3FC9,
0x2329, 0x3A71, 0x16AD, 0x1807, 0x0527, 0x01BA, 0xDAF4, 0xE3D6,
0xC7B7, 0xBD72, 0xD21C, 0xB969, 0xE722, 0xD858, 0x09E7, 0x07D7,
0x225B, 0x388B, 0x1CA7, 0x396D, 0x2226, 0x20CB, 0x272B, 0x17A0,
0xFD76, 0xFB47, 0xD703, 0xCDE6, 0xD858, 0xCCF1, 0xE976, 0xF2B4,
0x03D7, 0x0EFB, 0x23FA, 0x2BFE, 0x2911, 0x3AD1, 0x14DA, 0x25B8,
0xF815, 0xFE05, 0xD9C0, 0xD46F, 0xDBFF, 0xBB93, 0xE776, 0xC4C1,
0xDE51, 0xE89F, 0xED67, 0x0480, 0x24BA, 0x2606, 0x4730, 0x4738,
0x3904, 0x3DD1, 0x114A, 0x15DC, 0xE56E, 0xEB83, 0xD9DB, 0xD21D,
0xDF38, 0xD070, 0xDB23, 0xE217, 0xEF54, 0xFACF, 0x1EF2, 0x2308,
0x2E9D, 0x3F9B, 0x1742, 0x2187, 0x0AAC, 0xF820, 0xF93F, 0xE5E0,
0xDC38, 0xD3ED, 0xCD40, 0xCA89, 0xCEB3, 0xDAA7, 0xF6C2, 0xFA74,
0x3703, 0x2C20, 0x49ED, 0x545E, 0x29EE, 0x40E3, 0x119B, 0x11F3,
0xFAE0, 0xF1B9, 0xD6AD, 0xD580, 0xCA0B, 0xC2E8, 0xD3D0, 0xD2E6,
0xEA3C, 0xF3C1, 0x116C, 0x1398, 0x2EF0, 0x331A, 0x2F0A, 0x31CB,
0x1DF3, 0x1206, 0xF7A7, 0xF5CE, 0xC9D6, 0xD755, 0xCB72, 0xBF75,
0xE8E5, 0xD562, 0xFFDD, 0x0336, 0x23A3, 0x2ADD, 0x3A3B, 0x4AB4,
0x2FFD, 0x40BD, 0x1B4F, 0x1716, 0xF5CA, 0xF4BF, 0xC9E0, 0xD6EF,
0xC693, 0xBD07, 0xDBDE, 0xC419, 0xE789, 0xE6D6, 0x095C, 0x09A0,
0x3A62, 0x35C8, 0x3C57, 0x4500, 0x1604, 0x1D8E, 0xF308, 0xF35F,
0xD72F, 0xDA50, 0xD57D, 0xCC3E, 0xEE39, 0xDD8D, 0xFA74, 0x0288,
0x096C, 0x165F, 0x2EBC, 0x2EF0, 0x3A2C, 0x4175, 0x1A12, 0x24EC,
0xFA20, 0xF58E, 0xDFC9, 0xD4F3, 0xCF45, 0xC461, 0xD706, 0xC524,
0xE787, 0xE2F3, 0x03BB, 0x0C0F, 0x2AB8, 0x3082, 0x37E4, 0x42D3,
0x1E63, 0x262A, 0x03BA, 0xFCD3, 0xEE46, 0xEC60, 0xE0D8, 0xE1DC,
0xE327, 0xD831, 0xE32A, 0xE23D, 0xF776, 0xFF7B, 0x1FF5, 0x2881,
0x354E, 0x4425, 0x2D36, 0x2B53, 0x163D, 0xFD38, 0xECDE, 0xE499,
0xC7F5, 0xCECB, 0xD178, 0xC2FE, 0xE42D, 0xDC58, 0xF3F8, 0x011A,
0x1911, 0x22FB, 0x372D, 0x4260, 0x3500, 0x3D27, 0x2372, 0x19F8,
0x00FB, 0xFC23, 0xCE41, 0xDB0B, 0xC3F7, 0xBC1E, 0xD9CF, 0xCD38,
0xEBCF, 0xFD63, 0x178A, 0x1EB5, 0x4B99, 0x3BD0, 0x4813, 0x420D,
0x1D23, 0x1732, 0xEFF3, 0xE734, 0xC638, 0xD1A3, 0xC6D1, 0xC503,
0xDE62, 0xCDBE, 0xE698, 0xF62E, 0x0B16, 0x2226, 0x495F, 0x488A,
0x5731, 0x51DC, 0x2BD9, 0x29D3, 0xEF9D, 0xEC45, 0xBC16, 0xC277,
0xB940, 0xBC0B, 0xDBE1, 0xCD4E, 0xFB28, 0xF1CA, 0x1E8E, 0x1EA6,
0x48E5, 0x449B, 0x4B33, 0x46A8, 0x19D3, 0x194B, 0xEC30, 0xEA28,
0xCB31, 0xD04B, 0xBC2B, 0xC26B, 0xCFE5, 0xCFBE, 0xF098, 0xFD6A,
0x1BE7, 0x2690, 0x51BF, 0x4715, 0x57F8, 0x50E5, 0x19C4, 0x19CA,
0xE22C, 0xDB58, 0xC8DE, 0xCB8F, 0xC916, 0xC7EB, 0xE3FF, 0xCF25,
0xFC04, 0xF963, 0x1606, 0x2162, 0x358A, 0x3176, 0x3FA5, 0x3DCA,
0x22CC, 0x2388, 0xF577, 0xE873, 0xCA53, 0xD381, 0xB8F5, 0xD759,
0xD6B0, 0xD4BC, 0xFC92, 0xF65E, 0x1BBE, 0x2A90, 0x3356, 0x348D,
0x326B, 0x2C97, 0x1DDE, 0x1AD1, 0x0568, 0xF2BD, 0xE4E1, 0xDA8B,
0xCC63, 0xD911, 0xE1E5, 0xD8CD, 0xF804, 0xE8BC, 0xF9BA, 0x0BC3,
0x1A27, 0x2539, 0x4144, 0x3168, 0x2F04, 0x298A, 0xF9A9, 0x063B,
0xD38E, 0xE31A, 0xC693, 0xD64A, 0xE38B, 0xDF5A, 0xFF84, 0xF522,
0xF564, 0x0469, 0x09DE, 0x0CF6, 0x442B, 0x276B, 0x4839, 0x3327,
0x11C1, 0x105E, 0xEBC6, 0xED24, 0xD7D9, 0xDD26, 0xCDF8, 0xD091,
0xD95D, 0xDB47, 0xF0CC, 0xFC0B, 0x19DD, 0x143F, 0x4176, 0x330C,
0x35F0, 0x3CDA, 0x0307, 0x0D45, 0xEA61, 0xEAD2, 0xE3C0, 0xECDF,
0xD172, 0xDD64, 0xCCA3, 0xCE6F, 0xEB9D, 0xEC0A, 0x229D, 0x1539,
0x48FF, 0x34BA, 0x490A, 0x422D, 0x257F, 0x1A50, 0xF270, 0xE784,
0xC4E6, 0xD7A3, 0xB9FC, 0xCFD2, 0xDB12, 0xD26D, 0xFBA3, 0xF987,
0x114C, 0x1EE2, 0x2A92, 0x2C6D, 0x383C, 0x35BD, 0x28DD, 0x2348,
0x01E1, 0xFB83, 0xC99D, 0xD8DB, 0xB2F2, 0xC089, 0xDF50, 0xCB43,
0x02DF, 0xFA75, 0x1756, 0x1FDE, 0x4426, 0x2D94, 0x52D9, 0x35B5,
0x1C4A, 0x1CBA, 0xDCE4, 0xEB76, 0xC5BF, 0xD218, 0xC9D2, 0xD286,
0xDFFA, 0xE0CD, 0xEA64, 0xF81D, 0xF738, 0x0E80, 0x31B1, 0x25F6,
0x5B2F, 0x3FE2, 0x2CF5, 0x2DAB, 0xE68C, 0xF03F, 0xCF65, 0xCB9E,
0xCE8B, 0xD0A0, 0xDE2D, 0xE587, 0xFCDA, 0xF998, 0x17FA, 0x09E5,
0x3277, 0x1B0C, 0x37F7, 0x2BFC, 0x13F8, 0x1D95, 0xEFEA, 0xF560,
0xE307, 0xE15F, 0xC995, 0xE097, 0xBFD7, 0xE1DE, 0xE2A4, 0xEDB1,
0x1348, 0x0916, 0x3B0B, 0x2520, 0x437C, 0x3438, 0x249F, 0x1EB5,
0xFC5F, 0xF5B1, 0xE451, 0xE820, 0xD49B, 0xE628, 0xDDCA, 0xE00A,
0xF971, 0xE8C1, 0x0444, 0xFCC6, 0x1306, 0x0B64, 0x30EB, 0x1FC1,
0x2FD9, 0x2602, 0x0163, 0x082E, 0xD18B, 0xEE58, 0xB9C5, 0xE382,
0xD01D, 0xDD3E, 0xFE46, 0xED39, 0x133C, 0x0D1F, 0x2519, 0x15ED,
0x3BEE, 0x173E, 0x32E6, 0x23D5, 0x0B8F, 0x1643, 0xED59, 0xF29F,
0xD90C, 0xDC80, 0xD49F, 0xDCC5, 0xE422, 0xE581, 0xF28F, 0xF47A,
0x147D, 0x0645, 0x3AA7, 0x1ADC, 0x287E, 0x2D9C, 0xEE79, 0x1AA5,
0xD954, 0xEF31, 0xDEA3, 0xDB92, 0xE563, 0xEB4B, 0xFC31, 0xFB77,
0x07FE, 0xF943, 0x16BB, 0xFF3F, 0x3932, 0x1C3F, 0x3B2F, 0x314C,
0x0C77, 0x190E, 0xEB71, 0xF289, 0xDACF, 0xE00C, 0xC930, 0xDEE7,
0xDE37, 0xE5D6, 0x007C, 0xEDC6, 0x1088, 0xFF40, 0x1BC5, 0x1CDA,
0x1D54, 0x2D37, 0x0484, 0x143B, 0xF343, 0xFA13, 0xF4BD, 0xFC00,
0xE696, 0xF281, 0xE722, 0xDF9F, 0xFF90, 0xE9A9, 0x1B38, 0x02F1,
0x3003, 0x113C, 0x2FAA, 0x1EE8, 0x1262, 0x1E27, 0xE9D7, 0x028F,
0xD3D3, 0xE945, 0xCFF7, 0xE1FE, 0xE1A2, 0xE395, 0xF201, 0xF144,
0xFBDF, 0x01BF, 0x18CF, 0x05BD, 0x2FCE, 0x17D7, 0x25F3, 0x2F60,
0x0A91, 0x2098, 0xEBFF, 0xF3D4, 0xD62C, 0xDBB4, 0xEA32, 0xE593,
0x04CC, 0xEFCC, 0x080B, 0xF193, 0x1EFC, 0xFF16, 0x3150, 0x1E14,
0x0DEE, 0x2671, 0xE4F7, 0x0833, 0xDD7F, 0xEA9A, 0xD06D, 0xE681,
0xD23D, 0xEFFB, 0xF02E, 0xEED6, 0x027F, 0xEAB0, 0x23D1, 0x01BA,
0x4A3F, 0x32BF, 0x2B09, 0x3C6D, 0xEEAB, 0x0D62, 0xE5E3, 0xEB85,
0xE827, 0xE776, 0xE1D4, 0xE31C, 0xF5C5, 0xE232, 0x109A, 0xF0F8,
0x1970, 0x004E, 0x1D19, 0x1272, 0x0F5C, 0x2282, 0xE724, 0x12E0,
0xD348, 0xF972, 0xD2D1, 0xEFBF, 0xD822, 0xE40C, 0xF750, 0xE1A0,
0x20C6, 0xFD5D, 0x34AE, 0x1510, 0x2D98, 0x1A64, 0x1688, 0x1F02,
0xFC0C, 0x1634, 0xEA8F, 0xF9D2, 0xDC2D, 0xE3A3, 0xE696, 0xE40D,
0x0229, 0xEA7E, 0x0342, 0xEA78, 0x0566, 0xEEF2, 0x163D, 0x074F,
0x0A33, 0x2616, 0xE8EB, 0x2701, 0xDF5D, 0x05A9, 0xDD22, 0xE90E,
0xEE86, 0xECD4, 0x1A3D, 0xFD2A, 0x1BAB, 0xFBE7, 0x0C37, 0xEF40,
0x22EC, 0xFE3A, 0x2380, 0x1DE5, 0xF218, 0x1D83, 0xE48E, 0x061A,
0xF696, 0xF69B, 0xEB9E, 0xEB9D, 0xEBD4, 0xE120, 0xFCF8, 0xE1AB,
0xFF85, 0xEB25, 0x0BEC, 0x04E7, 0x135B, 0x274E, 0xF2C5, 0x287C,
0xE5F8, 0x0DA7, 0x014F, 0x02E2, 0x05FD, 0x00BB, 0xF9C7, 0xEC51,
0x03DF, 0xDD37, 0x1560, 0xE376, 0x158B, 0xF5A1, 0x0F20, 0x1477,
0x055B, 0x2B8A, 0xF4DD, 0x1870, 0xE360, 0xF29A, 0xDDC3, 0xE428,
0xED6B, 0xE372, 0xFC9A, 0xE657, 0x0463, 0xF23D, 0x0ED0, 0x0653,
0x0FED, 0x1D2E, 0x0B1F, 0x3202, 0x09D6, 0x2D43, 0xF4D1, 0x05C8,
0xE6EB, 0xE414, 0xFFD0, 0xD9E3, 0x0B05, 0xD922, 0x00A4, 0xDFEF,
0x12EB, 0xFBCF, 0x251E, 0x1E15, 0xFF3A, 0x2A06, 0xD9CC, 0x1812,
0xDED0, 0xF761, 0xE76E, 0xE7AB, 0xF5C1, 0xEAE4, 0x05E7, 0xF074,
0x055E, 0xEE79, 0x1419, 0xFDD7, 0x2E3C, 0x2731, 0x1512, 0x3DA8,
0xE8F5, 0x267D, 0xEAED, 0xF950, 0xF9BB, 0xE169, 0xF749, 0xDA0C,
0xFE77, 0xDB7B, 0x1748, 0xE863, 0x1896, 0xF63A, 0x00B1, 0x0957,
0xEDF1, 0x2098, 0xE767, 0x2213, 0xEB4E, 0x08C8, 0xF436, 0xFD6C,
0xFE55, 0xF6DE, 0x0846, 0xE5CE, 0x1C14, 0xEB01, 0x23CB, 0x0584,
0x0CA9, 0x16AD, 0xF997, 0x1EB6, 0xF772, 0x2060, 0xEC82, 0x0404,
0xE853, 0xE898, 0x07D2, 0xE8BF, 0x1738, 0xE59E, 0x0192, 0xDBEE,
0xF826, 0xE6E5, 0xFD75, 0x033E, 0xFAB1, 0x20F6, 0xF41E, 0x3817,
0xF025, 0x2696, 0xF5EF, 0xFBAD, 0x113C, 0xEB69, 0x2063, 0xF15D,
0x0FE6, 0xEEBE, 0x0502, 0xECD6, 0x0A81, 0x0197, 0x039B, 0x1BFD,
0xEC25, 0x25F1, 0xEBC2, 0x1574, 0x0361, 0xFA67, 0x08DD, 0xE548,
0xF9A5, 0xD776, 0xF7DA, 0xD574, 0x0699, 0xE745, 0x094F, 0x0FE7,
0xFF06, 0x3926, 0xF5E2, 0x40C1, 0xFA1C, 0x1E6D, 0x0B72, 0xFF68,
0x102B, 0xF208, 0x0291, 0xDD37, 0x01E3, 0xD37C, 0x0E60, 0xE7D0,
0x007F, 0x01E4, 0xF108, 0x1A18, 0xFD0B, 0x33D3, 0xF990, 0x24E7,
0xEE32, 0xF530, 0xFADE, 0xDA17, 0x05EF, 0xD614, 0x0C16, 0xDF15,
0x14E0, 0xFEDA, 0x06FB, 0x1DAC, 0xFBB8, 0x26B5, 0x08EB, 0x361B,
0xFFB5, 0x3119, 0xEF73, 0x00F1, 0xFFE3, 0xD9DE, 0x0F6F, 0xD5C6,
0x07B4, 0xD93D, 0x0142, 0xE1AA, 0x0201, 0xFFEA, 0xFA6B, 0x1DFF,
0xF09E, 0x2C54, 0xE6F7, 0x1D9E, 0xEA33, 0xF82E, 0x080A, 0xE517,
0x1BC7, 0xEE4C, 0x13B6, 0xF58E, 0x0FDF, 0xF63F, 0x113F, 0x0A07,
0x02FB, 0x23A4, 0xF0FB, 0x2E10, 0xE6F3, 0x1E98, 0xF2C4, 0xFEA1,
0x0AF5, 0xE607, 0x0B0F, 0xD7A6, 0x073B, 0xD5CE, 0x0D6D, 0xE760,
0xFEA2, 0x02F5, 0xEA5E, 0x11D2, 0xE9AF, 0x1C33, 0xEBC5, 0x22BF,
0xFC60, 0x16AA, 0x17C3, 0xFFB0, 0x1A5F, 0xE9D3, 0x18F8, 0xE338,
0x1C79, 0xF09B, 0x0160, 0x0395, 0xDEDC, 0x0DF9, 0xE777, 0x1CD4,
0xF54A, 0x2754, 0xEFF2, 0x0EBC, 0x01A6, 0xE483, 0x142E, 0xD1C9,
0x0C57, 0xD914, 0x0775, 0xE4C3, 0xFC35, 0xF5C6, 0xE633, 0x0F92,
0xF172, 0x3065, 0x03D1, 0x4105, 0x01D1, 0x2484, 0x118E, 0xF6FF,
0x2310, 0xE056, 0x16A4, 0xD964, 0xFD52, 0xDA72, 0xEDE2, 0xF110,
0xEA1C, 0x110D, 0xEC15, 0x276E, 0xEDDE, 0x2A84, 0xF446, 0x1254,
0x0689, 0xEDCC, 0x1300, 0xD616, 0x119F, 0xD0BF, 0x09B8, 0xDD32,
0xFDD6, 0x02B8, 0xF6E4, 0x2A17, 0xFBCD, 0x37B6, 0xFEE6, 0x356A,
0x02D9, 0x244B, 0x104B, 0xF7FF, 0x0BB2, 0xCBC1, 0xFDF7, 0xC3FB,
0x0427, 0xD97D, 0xFE4D, 0xF99D, 0xE4B4, 0x1482, 0xE48F, 0x1E93,
0xEDFA, 0x2209, 0xF09D, 0x19BA, 0x072B, 0xF564, 0x171B, 0xD37F,
0x147A, 0xD8DB, 0x18EC, 0xF69B, 0x1303, 0x0D52, 0xFBC4, 0x1E32,
0xF64C, 0x303F, 0xF96F, 0x2F5E, 0xEFF7, 0x122C, 0xF1C3, 0xE6E5,
0x0164, 0xC95C, 0x0E3A, 0xCE24, 0x0D02, 0xE376, 0xFB65, 0xF4E1,
0xE6C5, 0x0AD4, 0xE234, 0x1DC8, 0xECEA, 0x1FB6, 0xF77C, 0x196F,
0x09C4, 0x04C4, 0x1BFA, 0xE991, 0x228E, 0xE055, 0x2453, 0xED73,
0x1367, 0x0796, 0xF49E, 0x1B52, 0xE390, 0x1F6E, 0xDD68, 0x1663,
0xE229, 0x09BE, 0xFA5A, 0xF879, 0x0E7F, 0xDB9C, 0x1251, 0xC8BC,
0x0E06, 0xD52C, 0xFD7C, 0xF190, 0xE7F3, 0x0BEA, 0xE348, 0x1F54,
0xEFE2, 0x2C89, 0x0090, 0x32CC, 0x137E, 0x16B2, 0x2552, 0xE791,
0x2C61, 0xD968, 0x21ED, 0xE811, 0x01AE, 0xF682, 0xDC05, 0x01DF,
0xD07C, 0x0F78, 0xD947, 0x1AB8, 0xE8D5, 0x1D8F, 0xFFB3, 0x0410,
0x0E1E, 0xD743, 0x14AF, 0xC38D, 0x16F5, 0xD460, 0x040D, 0xF1FA,
0xEDEE, 0x1421, 0xF104, 0x3661, 0xF6CE, 0x388A, 0x00A3, 0x2701,
0x1BED, 0x1468, 0x25A7, 0xEECD, 0x19A4, 0xCE8A, 0x0AB6, 0xD396,
0xF588, 0xE881, 0xDDE1, 0xFEFE, 0xD457, 0x1CFD, 0xDBE5, 0x245E,
0xEC0B, 0x12F7, 0x0197, 0xFD25, 0x1297, 0xDD97, 0x170E, 0xC7F9,
0x18E4, 0xDC17, 0x158F, 0x0D0A, 0x00E6, 0x2A52, 0xF1B1, 0x2D05,
0xF656, 0x2D7C, 0x0369, 0x26D4, 0x0B54, 0x090B, 0x0472, 0xDE17,
0x049D, 0xC2EE, 0x0B0B, 0xCAC4, 0xF88F, 0xEB08, 0xDDE4, 0x0976,
0xDA43, 0x1B62, 0xE25C, 0x1A61, 0xF00E, 0x0EA8, 0x0286, 0x0226,
0x1090, 0xED4B, 0x2539, 0xE356, 0x30C2, 0xF3C2, 0x1AE3, 0x04F8,
0xFFB5, 0x1596, 0xF692, 0x2BF2, 0xEBC0, 0x2994, 0xE395, 0x1273,
0xF05C, 0xFE59, 0x034E, 0xE477, 0x0DAE, 0xCAA3, 0x09B3, 0xCE80,
0xF963, 0xE9BD, 0xEB3B, 0x0140, 0xE6A9, 0x108D, 0xDE29, 0x165A,
0xE3D1, 0x18CB, 0x0AEA, 0x1C30, 0x2915, 0x0FC2, 0x2FBC, 0xEDC8,
0x303C, 0xE160, 0x1E5B, 0xFAA4, 0xFCCA, 0x0F1C, 0xE132, 0x15B1,
0xCC06, 0x1569, 0xD3C9, 0x0FA1, 0xF618, 0x03B3, 0x026E, 0xE919,
0x0441, 0xCFD5, 0x12CA, 0xCFED, 0x1418, 0xE0F0, 0xF5DF, 0xF8C2,
0xDC34, 0x17D3, 0xE2C2, 0x2F07, 0xFB6C, 0x34A8, 0x1550, 0x2233,
0x24B5, 0x02A8, 0x2D92, 0xE6A5, 0x298F, 0xDCA0, 0x0DDF, 0xEAB4,
0xE758, 0xF9FB, 0xD371, 0x0DE6, 0xD26A, 0x1FA2, 0xD883, 0x13ED,
0xE8D6, 0xFBBF, 0xFCB9, 0xEB41, 0x1AE5, 0xD439, 0x26A4, 0xC78D,
0x08A7, 0xE2EF, 0xF376, 0x110B, 0xF8F5, 0x34D6, 0xF65A, 0x3ACF,
0xF7DC, 0x2BC2, 0x0FD7, 0x1527, 0x1B58, 0xF82B, 0x18E0, 0xDF2D,
0x1590, 0xCF90, 0x01BD, 0xD990, 0xE62A, 0xFC9B, 0xDA56, 0x169A,
0xCEE5, 0x16DE, 0xCB4A, 0x0E85, 0xF421, 0x00D7, 0x1963, 0xEA82,
0x18ED, 0xD9DE, 0x1CC6, 0xE1DF, 0x2214, 0x008B, 0x0FAB, 0x191C,
0xFC63, 0x2A6A, 0xF21F, 0x2DDD, 0xED3C, 0x1A0B, 0xF580, 0x0542,
0x01EE, 0xF1C2, 0x10BD, 0xDB52, 0x137C, 0xD549, 0x0390, 0xE521,
0xEC93, 0xF71F, 0xD49B, 0x0746, 0xD042, 0x1126, 0xE3A4, 0x0C11,
0xF8AE, 0x010D, 0x0913, 0xFCF7, 0x260C, 0xFE9E, 0x3B68, 0xFB90,
0x2E2A, 0xFF17, 0x11BD, 0x0D81, 0xF99E, 0x16DD, 0xE048, 0x1787,
0xD34A, 0x1001, 0xE95F, 0xFFCA, 0x0037, 0xF060, 0x0B29, 0xE70B,
0x147E, 0xE021, 0x0640, 0xDEEA, 0xF0C4, 0xEBFE, 0xE9C2, 0x0237,
0xDF8B, 0x11DC, 0xDD29, 0x1A3C, 0xF95B, 0x1A59, 0x1B8A, 0x0FE8,
0x3251, 0x043E, 0x3999, 0xFB70, 0x2658, 0xF127, 0x0404, 0xF114,
0xE647, 0x066A, 0xD7DA, 0x16E4, 0xDADB, 0x1251, 0xE773, 0x038E,
0xF57E, 0xF5BA, 0x07DA, 0xE99F, 0x17B4, 0xDC0E, 0x1482, 0xD81E,
0x000F, 0xEBCA, 0xEE9A, 0x0F47, 0xE8F3, 0x2642, 0xF0DD, 0x29D6,
0x0868, 0x2082, 0x1DA6, 0x1200, 0x2801, 0xFF8F, 0x25B1, 0xE7F2,
0x11B2, 0xE06B, 0xF8F5, 0xEFBF, 0xEAE5, 0x06A8, 0xDE60, 0x12C1,
0xD23B, 0x109E, 0xDCC4, 0x0659, 0xF7B1, 0xF4C1, 0x1277, 0xE395,
0x1F1D, 0xE1AD, 0x176C, 0xF069, 0x0D3B, 0x0305, 0x040E, 0x154F,
0xF770, 0x2408, 0xF5C0, 0x2B23, 0xFEBB, 0x1A5E, 0x02E7, 0xF94E,
0x0BDC, 0xEB4F, 0x1847, 0xEE1B, 0x1597, 0xF021, 0x05AB, 0xF137,
0xF082, 0xFCDC, 0xD8A6, 0x0D1C, 0xD2BE, 0x0E88, 0xEA1D, 0xFD24,
0xFC5E, 0xEEC9, 0x0907, 0xF714, 0x2546, 0x06C9, 0x2FE0, 0x058C,
0x1D8B, 0x0084, 0x0ECE, 0x153D, 0xFD3C, 0x235D, 0xE705, 0x1319,
0xE4A5, 0xFCDC, 0xF1DF, 0xF3AE, 0x069D, 0xFBF7, 0x17DA, 0xFB37,
0x17B3, 0xEE09, 0x00EE, 0xED3F, 0xE952, 0xF8B0, 0xE59B, 0xFFE6,
0xE357, 0x03D4, 0xE672, 0x086E, 0xFDEF, 0x0CF5, 0x1EBA, 0x10A4,
0x31E6, 0x0AAF, 0x2FE0, 0x0674, 0x1F9E, 0x051D, 0x03B2, 0x00BC,
0xE3D7, 0xFD95, 0xD609, 0x0195, 0xE46F, 0x0B0F, 0xF66B, 0x0514,
0x097D, 0xFB9B, 0x1876, 0xFBBC, 0x0FC7, 0xF454, 0x0453, 0xE820,
0xFDAC, 0xEB5C, 0xEB08, 0xFE18, 0xE0A3, 0x15E2, 0xF7B0, 0x2034,
0x1299, 0x121E, 0x1FB0, 0x0DC8, 0x2B59, 0x14CE, 0x271A, 0x05BB,
0x0970, 0xEAB6, 0xEDFF, 0xE5C0, 0xE4A4, 0xFC46, 0xDF42, 0x0EBF,
0xE4D0, 0x0984, 0xF678, 0xFE7C, 0x01D9, 0xFDA6, 0x0D5A, 0xFB51,
0x19F5, 0xF5F2, 0x1179, 0xF449, 0xFDCA, 0xF9DE, 0xF8C1, 0x0A5B,
0xFC21, 0x18C9, 0x01C4, 0x1870, 0x0B99, 0x0D87, 0x1351, 0x092D,
0x1210, 0x0594, 0x0BC8, 0xF58C, 0x0368, 0xED27, 0xF952, 0xF454,
0xEF3D, 0xFAB9, 0xE620, 0x0268, 0xE77F, 0x062E, 0xF1B4, 0xF8A8,
0x022A, 0xF799, 0x150A, 0x09DD, 0x1BBA, 0x0DC0, 0x1511, 0x0424,
0x0FE0, 0xFFCE, 0x0C12, 0x0679, 0xFC9E, 0x0DD3, 0xF2AD, 0x0946,
0xF532, 0xFC1E, 0xF72A, 0xF799, 0xFF65, 0x0366, 0x0B97, 0x071E,
0x08FD, 0xF6EB, 0xFBB6, 0xEF21, 0xF26D, 0xF562, 0xE8BE, 0xF69C,
0xE5ED, 0xFA99, 0xF599, 0x05AF, 0x0CD9, 0x1025, 0x1AC5, 0x1980,
0x226F, 0x1782, 0x24F3, 0x0C05, 0x1831, 0xFF48, 0x0386, 0xF1E5,
0xEC25, 0xF19F, 0xDD9B, 0xF8FB, 0xE46F, 0xFC08, 0xF688, 0x0389,
0x0652, 0x0B8C, 0x0EBE, 0x0BED, 0x0B91, 0x005F, 0xFE3A, 0xE8A3,
0xF348, 0xDDAD, 0xED50, 0xF385, 0xF10D, 0x0EFC, 0x00BB, 0x1435,
0x11F0, 0x11C4, 0x1FDF, 0x1E24, 0x2804, 0x2707, 0x1F52, 0x09BE,
0x0546, 0xE2CD, 0xEE3E, 0xDBBC, 0xE09F, 0xECF2, 0xDE4B, 0xFD45,
0xEAC9, 0xFE01, 0xFC6C, 0x0229, 0x07DA, 0x13E2, 0x0C16, 0x1472,
0x09BF, 0xFA28, 0x00A1, 0xE983, 0xFF61, 0xF213, 0x0282, 0x00D8,
0xFEBA, 0x067D, 0x03A2, 0x0AE7, 0x150F, 0x197B, 0x1D36, 0x1D98,
0x13C4, 0x0E3F, 0x009A, 0xF622, 0xF099, 0xE5B2, 0xED20, 0xE72A,
0xEA9A, 0xEBB7, 0xEA38, 0xF179, 0xF2C1, 0x0048, 0xFB95, 0x0AA0,
0x02BA, 0x09A1, 0x0A1C, 0x10C5, 0x0EF8, 0x13F2, 0x0F00, 0x023A,
0x0E1E, 0xF12E, 0x0852, 0xF304, 0x020A, 0x0454, 0x05F8, 0x1054,
0x08FB, 0x0B71, 0x0155, 0x0039, 0xFC41, 0x08B0, 0xFC08, 0x0F6D,
0xF612, 0xF1AD, 0xF5DE, 0xD741, 0xF78A, 0xE270, 0xF1BD, 0xF712,
0xEF8B, 0xFE52, 0xF7E2, 0x08C3, 0x0A00, 0x1A23, 0x1A97, 0x2BDF,
0x1DD2, 0x2458, 0x1588, 0xFC3C, 0x10D5, 0xE740, 0x0AFF, 0xEF9E,
0xFC77, 0xF442, 0xF04C, 0xF003, 0xED8C, 0xFBB0, 0xF4BB, 0x1359,
0xFBF7, 0x1E23, 0xFF0D, 0x0E64, 0xFE99, 0xED1D, 0xFE23, 0xDAC7,
0xF8F6, 0xDE03, 0xEFA1, 0xED47, 0xF7D6, 0x01E8, 0x0B2C, 0x1E1A,
0x1759, 0x2D82, 0x1D53, 0x299D, 0x1CBF, 0x20C2, 0x12E3, 0x02F8,
0x08FE, 0xE2E7, 0xFC5A, 0xD62C, 0xEC38, 0xD936, 0xEA38, 0xF15C,
0xEFA6, 0x124C, 0xF685, 0x1750, 0x0283, 0x1067, 0x0558, 0x1297,
0xFADD, 0xF918, 0xF58C, 0xDB57, 0xFA52, 0xDFCB, 0x0518, 0xF7C8,
0x112E, 0x0EFE, 0x1378, 0x201E, 0x158F, 0x23DF, 0x1A3E, 0x212E,
0x10AC, 0x1E1B, 0xFB49, 0xF964, 0xF1E8, 0xCE6B, 0xF1F5, 0xCEFC,
0xED2F, 0xE975, 0xF0F4, 0xFDC4, 0xF8ED, 0x0C73, 0xFB27, 0x1248,
0xFE52, 0x1156, 0xFC4C, 0x18AA, 0xF5DF, 0x0590, 0x03D0, 0xE611,
0x16B5, 0xE9CD, 0x1480, 0xFC28, 0x150A, 0x0660, 0x175B, 0x16DA,
0x0C97, 0x2200, 0xFFDE, 0x172D, 0xF7A6, 0x0C44, 0xEF30, 0xF475,
0xEEB0, 0xD87D, 0xF5EC, 0xD951, 0xF7F4, 0xE692, 0xFCB8, 0xF0D5,
0xFA82, 0x068F, 0xF143, 0x1B91, 0xF607, 0x1C66, 0x0455, 0x223B,
0x0D2D, 0x179E, 0x1464, 0xF236, 0x1A76, 0xE0A4, 0x17CF, 0xE9E3,
0x14B2, 0xF90F, 0x034C, 0x0A37, 0xED39, 0x1458, 0xEF04, 0x0E45,
0xF47F, 0x1061, 0xEE24, 0x08B0, 0xF555, 0xE834, 0x04B7, 0xD263,
0xFCE2, 0xD7D8, 0xF83C, 0xEFAC, 0xFAF3, 0x0D09, 0xF958, 0x2304,
0x0804, 0x27F6, 0x1738, 0x2BED, 0x11D1, 0x1A43, 0x13DE, 0xEED9,
0x1EDB, 0xD952, 0x0977, 0xDE4F, 0xF5E9, 0xE9D9, 0xF6B3, 0xFBC7,
0xEBC2, 0x11EF, 0xE5EC, 0x15D6, 0xF37F, 0x1727, 0xFA18, 0x0EC0,
0xF3BA, 0xE6B6, 0xF8A8, 0xCE84, 0xF899, 0xDE7E, 0xFFC3, 0xF8C1,
0x1399, 0x14B7, 0x101E, 0x2F96, 0x084E, 0x2859, 0x11A2, 0x1A5E,
0x170A, 0x13A8, 0x0658, 0xF012, 0xF7D5, 0xCE08, 0xF469, 0xD0C2,
0xF9E9, 0xE8D4, 0xFBBA, 0x01B6, 0xEFBD, 0x1A08, 0xEFDC, 0x1DEE,
0xF50A, 0x12F7, 0xF292, 0x0A6B, 0xEE6A, 0xF0A8, 0xFB9A, 0xD7C8,
0x0EF4, 0xE2A1, 0x1A4E, 0x0328, 0x1E6E, 0x165B, 0x118E, 0x1F36,
0x0E8D, 0x1FB3, 0x0C54, 0x177C, 0xF4D2, 0x0B26, 0xE763, 0xEC63,
0xF904, 0xCF20, 0x000C, 0xD2EF, 0xFB02, 0xED45, 0x0604, 0x043B,
0xF9CC, 0x17D3, 0xE5AD, 0x1C06, 0xE906, 0x1209, 0xF200, 0x0E74,
0xFF0A, 0x000B, 0x1858, 0xEC14, 0x208B, 0xE8A9, 0x18D3, 0xF239,
0x25D2, 0x0399, 0x1AA7, 0x19B0, 0xF007, 0x1BBF, 0xDE34, 0x0B1C,
0xED02, 0x0600, 0xF7ED, 0xFAF3, 0xFD12, 0xE041, 0x086C, 0xD72A,
0x04C7, 0xEC34, 0x0219, 0x0580, 0xF87E, 0x1456, 0xE443, 0x16B1,
0xEB29, 0x138D, 0x07F6, 0x1D5A, 0x14AE, 0x14A5, 0x1575, 0xE9AC,
0x2309, 0xD6E4, 0x2533, 0xEE59, 0x13D7, 0x023B, 0xF374, 0x0A36,
0xDD0B, 0x1001, 0xE38E, 0x0C69, 0xF111, 0x0C71, 0xFCC0, 0x054B,
0xFFCA, 0xE7E7, 0x023E, 0xDC4E, 0x02D8, 0xF1EB, 0x035D, 0x0198,
0x0176, 0x0C7D, 0xFA60, 0x2338, 0xFEAB, 0x25D8, 0x093A, 0x1266,
0x163A, 0x031E, 0x2128, 0xEF68, 0x1BAD, 0xDD6C, 0x00ED, 0xE501,
0xF774, 0xF79A, 0xFB4E, 0x07BD, 0xEA67, 0x1689, 0xE52F, 0x119C,
0xF0E8, 0x06A8, 0xF678, 0x08E2, 0xF9C4, 0xF82F, 0x05AE, 0xDB0B,
0x0B1F, 0xE217, 0x1097, 0x0693, 0x1892, 0x2087, 0x0731, 0x1F95,
0xFB29, 0x0ED3, 0x0BA7, 0x0A44, 0x1578, 0x0E10, 0x0315, 0xF601,
0xFD24, 0xD5AF, 0x06A1, 0xDF7C, 0x0469, 0x002A, 0x04FC, 0x0C89,
0xF427, 0x0E02, 0xD655, 0x106E, 0xDB15, 0x1036, 0xFA1C, 0x0E07,
0x0572, 0xF5ED, 0x0F64, 0xDFEC, 0x2218, 0xF839, 0x21D0, 0x0FE1,
0x1D7B, 0x07B1, 0x1081, 0x0B9E, 0xF7F2, 0x15E4, 0xE6B0, 0x0B87,
0xEF26, 0x019B, 0xFFFE, 0xF670, 0x0697, 0xE75E, 0x12CC, 0xECAB,
0x12CB, 0xFD41, 0xFE52, 0x07F5, 0xE39F, 0x127C, 0xD559, 0x121D,
0xDEF2, 0x0176, 0xFDD4, 0x03EF, 0x1575, 0x0D8E, 0x1DB0, 0xF97B,
0x2B3C, 0xEA80, 0x2CCE, 0xFB36, 0x20FB, 0x0CD9, 0xFC28, 0x0F59,
0xD1CC, 0x0729, 0xD627, 0xF9F9, 0xF6BF, 0x0303, 0x0A5A, 0x09CF,
0x119A, 0xEF1B, 0x13AA, 0xE9D2, 0x0137, 0x05ED, 0xF6B5, 0x0FD3,
0xF242, 0x050D, 0xE113, 0x0289, 0xE3BB, 0x08C0, 0x0469, 0x1156,
0x2183, 0x0931, 0x2A07, 0xEDD6, 0x34FD, 0xEE00, 0x20B3, 0x05F5,
0xF698, 0x0736, 0xE869, 0xF975, 0xDCF5, 0xFE08, 0xD78C, 0x0449,
0xF5C9, 0x0352, 0x1126, 0x076F, 0x04FF, 0xFE0D, 0x056D, 0xF50E,
0x0DF9, 0xFD70, 0x059C, 0x03F6, 0xFE3C, 0x082E, 0xEC03, 0x0D3D,
0xE68D, 0x0227, 0x0632, 0xFBB6, 0x2E72, 0x0A96, 0x2C14, 0x059E,
0x10B1, 0xF375, 0x062F, 0xF38D, 0x01DB, 0xFCCC, 0xF5D1, 0x00E1,
0xE026, 0x003F, 0xD71C, 0x001B, 0xE4B4, 0x059D, 0xFDE3, 0x11AA,
0x093D, 0x0472, 0x1206, 0xED43, 0x1F0A, 0xFE75, 0x1240, 0x1357,
0x01BA, 0x017E, 0xF258, 0xF0B3, 0xED9E, 0xFA84, 0x0499, 0x0924,
0x10FB, 0x1113, 0x07DF, 0x0302, 0x10CB, 0xF0C6, 0x1F50, 0xFB5C,
0x0A15, 0x072C, 0xF224, 0xFF8C, 0xDDE9, 0xFBD6, 0xC5FB, 0x012A,
0xD3EF, 0xFF70, 0x0165, 0x0176, 0x1D65, 0x0A4C, 0x22DE, 0x0ACA,
0x27C3, 0x054F, 0x1A59, 0xFD88, 0x0826, 0xF85B, 0xFFAA, 0xFC2E,
0xE2CC, 0x00D6, 0xD370, 0xFB53, 0xFA3E, 0xFED1, 0x22A4, 0x0C40,
0x216B, 0x05B0, 0x1AF5, 0xFF0A, 0x0EDB, 0x0B4E, 0xECEF, 0x099C,
0xD1F1, 0xF54D, 0xC65E, 0xEC71, 0xD8A0, 0xF440, 0x0A81, 0x0BFA,
0x2A67, 0x1A99, 0x2729, 0x0108, 0x2835, 0xF11F, 0x2A11, 0x0786,
0x0BAF, 0x0C6E, 0xDCF7, 0xF046, 0xC48A, 0xE609, 0xDB21, 0xF9D3,
0x0775, 0x08FB, 0x2058, 0x1142, 0x22CB, 0x14F9, 0x1C4E, 0x0D9D,
0x096D, 0x07B5, 0xE98A, 0xFABB, 0xD88D, 0xE46B, 0xD8C4, 0xEC9E,
0xE34A, 0x06AE, 0x0461, 0x059A, 0x268A, 0x01DD, 0x33CD, 0x0DF3,
0x3743, 0x13F5, 0x1C4F, 0x0878, 0xE978, 0xF1C0, 0xDAAA, 0xE47D,
0xDAA4, 0xE9ED, 0xD2E4, 0xF86C, 0xF1FD, 0x08D1, 0x20EE, 0x1D90,
0x2057, 0x21B0, 0x100E, 0x074E, 0x109E, 0xF4CC, 0xFECF, 0xF90D,
0xE930, 0xF688, 0xE08A, 0xECA8, 0xD9B4, 0xEA77, 0xF64A, 0xF5AC,
0x30E8, 0x1AD3, 0x380B, 0x2BF7, 0x15F9, 0x07AC, 0x13FA, 0xF3B4,
0x0871, 0xFCD7, 0xDD27, 0xEE65, 0xCC3B, 0xE1FB, 0xD81D, 0xFB5E,
0xE845, 0x0F31, 0x06E7, 0x100C, 0x2111, 0x13B2, 0x2221, 0x09BD,
0x2657, 0x0381, 0x1595, 0x0853, 0xE83D, 0xEC9F, 0xD336, 0xCDE1,
0xE168, 0xED70, 0xF98B, 0x15F9, 0x0C55, 0x1155, 0x2186, 0x0FCC,
0x2F89, 0x138E, 0x224E, 0x0683, 0xFCA3, 0xFB52, 0xE10F, 0xF351,
0xD41F, 0xEA1D, 0xC409, 0xEFA2, 0xD0F2, 0xFA0E, 0x0434, 0x00B2,
0x3326, 0x1ACB, 0x3C76, 0x25C0, 0x2FE1, 0x0A60, 0x105A, 0xEDF0,
0xE9AA, 0xE422, 0xE135, 0xEB6B, 0xD3ED, 0xF438, 0xCEB8, 0xF6F4,
0x0778, 0x0351, 0x3728, 0x221E, 0x25C1, 0x253D, 0x1DAE, 0x094D,
0x1B04, 0x0149, 0xE1C8, 0xF6A6, 0xB81B, 0xD996, 0xC044, 0xD706,
0xD9CE, 0xF543, 0x0C6F, 0x110F, 0x3BC1, 0x29C4, 0x3AB3, 0x248A,
0x2A71, 0xFDEB, 0x25D3, 0xFC5E, 0xF6B0, 0xFF9C, 0xBAFA, 0xD98A,
0xC203, 0xD033, 0xE2E0, 0xFA68, 0xF458, 0x1469, 0x198F, 0x1FA2,
0x3EED, 0x2EED, 0x30FC, 0x1B4C, 0x0ABA, 0xF9EF, 0xE0FC, 0xE4D5,
0xC3A5, 0xD22D, 0xD051, 0xD913, 0xE831, 0x0040, 0xFF3B, 0x13F7,
0x2575, 0x132E, 0x47BE, 0x2617, 0x451A, 0x245E, 0x178A, 0xFE5E,
0xE3AA, 0xDF9B, 0xCD36, 0xD6BF, 0xC696, 0xDE44, 0xC46B, 0xF4B5,
0xEC00, 0x0EB6, 0x2606, 0x2294, 0x34EC, 0x2D88, 0x248C, 0x1579,
0x13CC, 0xEF42, 0xFAD6, 0xE3D8, 0xD99F, 0xE617, 0xCF16, 0xE549,
0xD70A, 0xEBEF, 0xF5E6, 0x0599, 0x2ECF, 0x24C0, 0x40F6, 0x3068,
0x27D8, 0x1501, 0x1BC1, 0xF3CB, 0xFFC2, 0xEC3E, 0xBFD1, 0xE2F4,
0xB144, 0xD96D, 0xD41A, 0xED4F, 0xE81F, 0x0C96, 0x058A, 0x16FB,
0x2C98, 0x1CBC, 0x39B6, 0x1770, 0x313A, 0x003C, 0x10AA, 0xF521,
0xD781, 0xE71C, 0xC226, 0xD667, 0xE2B2, 0xEB18, 0xF7F8, 0x10FA,
0x0392, 0x18F7, 0x2B24, 0x1B6C, 0x43B3, 0x2259, 0x255A, 0x09FC,
0xF651, 0xEA54, 0xD105, 0xE1C3, 0xB9CB, 0xDE2A, 0xBEE3, 0xDFF1,
0xD588, 0xFA58, 0xFDFB, 0x1217, 0x3656, 0x1E62, 0x500F, 0x2BBC,
0x380F, 0x145F, 0x101E, 0xEA00, 0xEB7E, 0xE255, 0xD031, 0xE5B3,
0xC55E, 0xDFA7, 0xD244, 0xF54B, 0xFF65, 0x1AE5, 0x2C09, 0x2714,
0x37F8, 0x23A1, 0x2DAD, 0x10F8, 0x0E9F, 0xF10A, 0xD80A, 0xDC93,
0xAFE7, 0xD658, 0xB8AA, 0xD766, 0xDE07, 0xF16F, 0x077D, 0x1CDF,
0x31D3, 0x2E91, 0x4B66, 0x2932, 0x4825, 0x17A0, 0x2DE1, 0xFA66,
0xEE9A, 0xE1E6, 0xAEF3, 0xD5DF, 0xB4D6, 0xDBBE, 0xDA79, 0xF912,
0xF117, 0x16DF, 0x1926, 0x1F2B, 0x43B0, 0x255E, 0x3A01, 0x1793,
0x0F85, 0xECD7, 0xE307, 0xD8B1, 0xBD60, 0xDB5F, 0xBFF2, 0xE025,
0xE0E8, 0xFAE1, 0x0061, 0x1E22, 0x2A77, 0x25EC, 0x5A4A, 0x29E5,
0x56F0, 0x2054, 0x191E, 0xF05D, 0xE0D0, 0xD9ED, 0xBEBE, 0xE7F5,
0xB076, 0xE421, 0xC7C9, 0xE9E7, 0xF256, 0x147C, 0x1595, 0x22B0,
0x352C, 0x1594, 0x4166, 0x1375, 0x2485, 0xF95D, 0xF6C3, 0xE00E,
0xCC8E, 0xEB64, 0xBDD9, 0xF00E, 0xD9DC, 0xF21E, 0x068B, 0x17EC,
0x2C80, 0x2D07, 0x3CC0, 0x192F, 0x3A28, 0x112F, 0x24D3, 0x0608,
0xF3DB, 0xE7F5, 0xBC9A, 0xDC4D, 0xAEB8, 0xE46F, 0xC93D, 0xEE00,
0xE46E, 0x02FE, 0x0A20, 0x15A8, 0x38EB, 0x1782, 0x4D48, 0x1A8C,
0x3673, 0x0DA8, 0x070B, 0xF31B, 0xDA3E, 0xEACB, 0xC7E8, 0xEED8,
0xDF19, 0xF72D, 0xF5AC, 0x084E, 0x02E4, 0x1415, 0x27E0, 0x1A9B,
0x44DF, 0x2199, 0x2B2C, 0x07F5, 0xFA98, 0xE4CC, 0xD37B, 0xE51F,
0xAEFF, 0xE517, 0xB7D2, 0xDE45, 0xE911, 0xFA04, 0x11E7, 0x1A3F,
0x33A8, 0x1F1F, 0x4C91, 0x25BA, 0x430E, 0x184B, 0x19C4, 0xF4A0,
0xEF0A, 0xF098, 0xC4D3, 0xF21C, 0xB7D4, 0xE211, 0xD8D1, 0xF647,
0x0299, 0x1D1F, 0x206B, 0x1833, 0x3A44, 0x0EA6, 0x3ED6, 0x1093,
0x0BB6, 0xF3D4, 0xCF6A, 0xDB7E, 0xB5E0, 0xE237, 0xC209, 0xEA84,
0xE866, 0xFF2F, 0x0B72, 0x1FDD, 0x2DDB, 0x217C, 0x51B7, 0x199B,
0x58C6, 0x1C9A, 0x266A, 0x05E1, 0xDE37, 0xE668, 0xAF63, 0xE340,
0xAF4F, 0xEFD9, 0xD043, 0xFC04, 0xF2F5, 0x09CC, 0x1E71, 0x1150,
0x3F5A, 0x11E6, 0x3954, 0x0ABF, 0x120C, 0xF1DB, 0xEA27, 0xE3EA,
0xCCD0, 0xF173, 0xC08A, 0xFDFF, 0xDD90, 0x03B9, 0x0BFF, 0x11D3,
0x34ED, 0x1CE2, 0x4E11, 0x1E11, 0x4331, 0x1419, 0x129B, 0xF740,
0xE1BB, 0xE899, 0xBC45, 0xED60, 0xA87A, 0xEA8C, 0xCBE6, 0xF142,
0xFD2B, 0x07A3, 0x1494, 0x0CD1, 0x2CA8, 0x0405, 0x420B, 0x09CC,
0x2C72, 0x07CD, 0xFB21, 0xFD24, 0xD556, 0xFD83, 0xC4DA, 0xF84B,
0xE291, 0xFB79, 0x1051, 0x1277, 0x1F8D, 0x1742, 0x2786, 0x0884,
0x35B7, 0x0BE5, 0x1BFE, 0x0810, 0xE232, 0xEF4B, 0xC42D, 0xE8D1,
0xBADF, 0xEF6B, 0xC580, 0xF113, 0xEBB0, 0xF762, 0x13F7, 0x01B8,
0x341C, 0x0724, 0x4950, 0x17B0, 0x3712, 0x1CF0, 0x03B5, 0x00AE,
0xE38F, 0xF4D2, 0xD546, 0x0006, 0xD3A9, 0x005D, 0xE91E, 0xFD28,
0x0950, 0x046A, 0x2313, 0x0646, 0x2A8D, 0x03E1, 0x1D4A, 0x03C7,
0xFB95, 0xFAF0, 0xD3CB, 0xF11B, 0xB790, 0xECA0, 0xC1D3, 0xEF3F,
0xEE22, 0xF980, 0x1767, 0x0B8D, 0x36A2, 0x174F, 0x4844, 0x131A,
0x3B4C, 0x0D2F, 0x15DF, 0x08F1, 0xECEE, 0x0344, 0xC1EA, 0xF83E,
0xB8CE, 0xF512, 0xDE74, 0xFCFC, 0xFCE6, 0xFC60, 0x12F0, 0xF601,
0x3115, 0xFF44, 0x2DE9, 0x0AA1, 0xFF43, 0xFC1B, 0xDDE5, 0xEDD5,
0xCC78, 0xF05A, 0xC712, 0xFAAB, 0xEEE1, 0x0B62, 0x1D03, 0x0F6A,
0x2FF4, 0x0157, 0x4136, 0x065A, 0x3EF6, 0x1973, 0x0C67, 0x0C2B,
0xDC53, 0xF939, 0xC487, 0xFA7B, 0xB631, 0xF59F, 0xCE6F, 0xECD4,
0xFE61, 0xF563, 0x1C66, 0xFD81, 0x286E, 0xFA29, 0x288E, 0x03AC,
0x0EFF, 0x0767, 0xECC4, 0xFFC3, 0xDADA, 0x0779, 0xD922, 0x0AC5,
0xF1E0, 0xFC14, 0x1350, 0xFB11, 0x29FB, 0x0537, 0x33B9, 0x0341,
0x26C9, 0x0844, 0x0406, 0x1066, 0xE07A, 0x0631, 0xC68A, 0xF2BE,
0xBAA1, 0xEC9D, 0xD5FB, 0xF46D, 0xFD1D, 0xF518, 0x13B8, 0xEEA8,
0x2C43, 0xF22C, 0x3316, 0x08D4, 0x1640, 0x1D13, 0xFFD6, 0x1AB3,
0xF54E, 0x0889, 0xDB3D, 0xFB3C, 0xE218, 0xFEA0, 0x0503, 0xFFC8,
0x110F, 0xF3DC, 0x1CE6, 0xF36E, 0x21F6, 0x0993, 0x0418, 0x0E38,
0xE6FB, 0xFEAF, 0xDDCB, 0xFC7F, 0xCA52, 0xFB2E, 0xCD6D, 0xF18C,
0xFA4B, 0xEEF7, 0x1B1A, 0xF1B6, 0x27F0, 0xFA9E, 0x3465, 0x15AE,
0x2CA4, 0x2174, 0x0DA6, 0x1032, 0xF5AD, 0x08CC, 0xDA1E, 0x071C,
0xCFC2, 0xF7F1, 0xEE91, 0xEEF0, 0x0588, 0xF45C, 0x0D1A, 0xF00B,
0x1774, 0xF2F2, 0x0F66, 0x0B67, 0xF4CC, 0x1090, 0xE3E4, 0x00ED,
0xD5FB, 0xF84F, 0xDA98, 0xF4D1, 0xFCAE, 0xF7B2, 0x17C2, 0x016D,
0x2ED2, 0xFE10, 0x3CA5, 0x006A, 0x2858, 0x18D6, 0x0226, 0x2123,
0xE954, 0x0E3F, 0xD4CE, 0xFA64, 0xCAD9, 0xF545, 0xE0AF, 0xF1BC,
0xF98C, 0xE5C4, 0x0F7B, 0xE283, 0x2017, 0xF4FA, 0x10F1, 0x0E52,
0xF5E9, 0x14F9, 0xF3B5, 0x0AB2, 0xEC1E, 0x0470, 0xDF53, 0x0647,
0xFC91, 0xFF0D, 0x1F2C, 0xF08F, 0x2A97, 0xECF2, 0x2B20, 0xFE33,
0x1489, 0x185B, 0xF392, 0x1A8A, 0xE859, 0x0DCC, 0xD7F2, 0x0455,
0xC2A8, 0xF240, 0xDC30, 0xE4C4, 0x015D, 0xE4A4, 0x0EA5, 0xE1AC,
0x16F4, 0xEC6A, 0x1796, 0x0E76, 0x08C3, 0x2357, 0xFF94, 0x22BA,
0xFBD0, 0x182F, 0xF0E4, 0x00FC, 0xFCB0, 0xEF81, 0x11CD, 0xF005,
0x115A, 0xEF1C, 0x0F53, 0xEED5, 0x0E72, 0x0644, 0xF88C, 0x1F56,
0xE2E7, 0x16B5, 0xDB3A, 0xFFDA, 0xD5FE, 0xF3A6, 0xE48B, 0xE8B1,
0xF7AA, 0xDFEE, 0x08CE, 0xE1AC, 0x1ED9, 0xF1D0, 0x2163, 0x16BE,
0x1418, 0x31C4, 0x0D79, 0x2572, 0x0621, 0x0D27, 0xF35C, 0xFFA0,
0xEBDD, 0xF51B, 0xF074, 0xE78A, 0xFC39, 0xDE51, 0x0CA9, 0xE9FB,
0x069E, 0x053E, 0xEEFC, 0x1937, 0xEC9B, 0x1A68, 0xF3A5, 0x0924,
0xE163, 0xF2FF, 0xE0F8, 0xE76D, 0xFE95, 0xE6B8, 0x133A, 0xED3D,
0x236A, 0xFCBA, 0x2A83, 0x1141, 0x196A, 0x236F, 0x0B2D, 0x2756,
0x0261, 0x18C2, 0xE319, 0xFF82, 0xD7A1, 0xE4DC, 0xED82, 0xDCBA,
0xF982, 0xDF63, 0xFDA6, 0xE2BC, 0x0421, 0xFBB9, 0x0228, 0x1C3C,
0xF8B9, 0x1FE4, 0xF2AC, 0x0C11, 0xECBC, 0xFC4C, 0xF296, 0xF73E,
0x0628, 0xF482, 0x18D7, 0xEA70, 0x244D, 0xEC25, 0x239A, 0x05A7,
0x145E, 0x21A6, 0xFB59, 0x2CAC, 0xEB4A, 0x1492, 0xE233, 0xF72E,
0xE00B, 0xEC64, 0xE376, 0xDE55, 0xEB56, 0xD60E, 0x0350, 0xE3F0,
0x11D9, 0xFA5A, 0x039E, 0x10B2, 0xF9FA, 0x239B, 0x04BE, 0x22B3,
0x0489, 0x1459, 0x0311, 0xFD70, 0x0A5A, 0xE861, 0x0DAA, 0xE313,
0x1607, 0xEB9B, 0x1276, 0x0433, 0xFB04, 0x1441, 0xEE39, 0x1B56,
0xF358, 0x1C5E, 0xE9B8, 0x0441, 0xDB99, 0xE6A1, 0xE590, 0xDD28,
0xF94C, 0xDC53, 0x05F3, 0xDF30, 0x0AA2, 0xF732, 0x0D24, 0x1A16,
0x0F06, 0x3797, 0x15A5, 0x3151, 0x1182, 0x0D85, 0x05FD, 0xF566,
0x0255, 0xE683, 0xFAA5, 0xE1E5, 0xF8E6, 0xE5AB, 0xFEBE, 0xF13E,
0xFD96, 0x0CC8, 0xF646, 0x2812, 0xF1B7, 0x2095, 0xEDE6, 0x03DD,
0xF1A1, 0xF000, 0xF5D7, 0xDD89, 0xF234, 0xD4DF, 0x026B, 0xE41F,
0x196E, 0x0AD1, 0x1CF1, 0x2407, 0x1817, 0x2C9D, 0x176A, 0x2EF5,
0x0FAF, 0x1475, 0xFF56, 0xF86E, 0xEEB7, 0xE5A4, 0xE3E6, 0xD08C,
0xEF60, 0xD601, 0xFDED, 0xFA9A, 0xF94B, 0x0DE6, 0xF165, 0x197F,
0xFC88, 0x25EF, 0x0348, 0x0EC3, 0xF908, 0xEFA1, 0xFB09, 0xE35B,
0x01FB, 0xE81D, 0x0D12, 0xF1E7, 0x1D13, 0x024F, 0x1ED7, 0x17F8,
0x1674, 0x26CE, 0x0D5A, 0x2E64, 0xFC9C, 0x198E, 0xEF1D, 0xEFDF,
0xEC92, 0xD681, 0xE5A0, 0xD8E8, 0xE831, 0xE088, 0xF47E, 0xF15F,
0xFEF5, 0x0A51, 0x0554, 0x1A7F, 0x0343, 0x2281, 0x04ED, 0x1458,
0x0D38, 0x03BF, 0x0F1C, 0xF5CF, 0x060F, 0xE34D, 0x07C1, 0xE66A,
0x1547, 0x007A, 0x13C9, 0x13D6, 0x02B8, 0x1F21, 0xF85D, 0x2374,
0xF887, 0x0B98, 0xF76F, 0xF4CB, 0xEF5C, 0xE52C, 0xDEAF, 0xD2AB,
0xE3B4, 0xD72A, 0xFF16, 0xF3DB, 0x04B9, 0x0A6E, 0x0224, 0x16A0,
0x1330, 0x2E98, 0x1DF4, 0x2CF5, 0x1883, 0x0645, 0x13D9, 0xEB8B,
0x0886, 0xE3B3, 0xFD78, 0xE2BC, 0xFC5E, 0xF7F9, 0xF9A1, 0x0C5A,
0xF81B, 0x0D41, 0xFC64, 0x1EEE, 0xFB51, 0x1FA3, 0xF124, 0xFAFD,
0xEF60, 0xDFE8, 0xF35E, 0xD6EB, 0xEE0C, 0xD731, 0xF37D, 0xEE15,
0x0D83, 0x1512, 0x1DB8, 0x29E0, 0x1BF2, 0x2CCD, 0x19FD, 0x2489,
0x1B61, 0x0D56, 0x1317, 0xEF9A, 0xF691, 0xDDAE, 0xE15F, 0xD9ED,
0xE9D2, 0xE690, 0xF899, 0x059F, 0xFC7D, 0x18E8, 0xF637, 0x1DE8,
0xF271, 0x17B8, 0x0184, 0x00DE, 0x0659, 0xE693, 0xEF52, 0xD623,
0xEDF3, 0xDE79, 0x0ACC, 0x00C3, 0x182B, 0x19C0, 0x1687, 0x1D88,
0x1DC1, 0x2859, 0x1E28, 0x267A, 0x0D71, 0x0B88, 0xFBC7, 0xEA30,
0xEAF1, 0xCFE3, 0xE00E, 0xD20B, 0xE88E, 0xF011, 0xF0A2, 0x0BB4,
0xEB8C, 0x1164, 0xFA56, 0x1616, 0x0CD7, 0x16EF, 0x03E0, 0x02D4,
0x0361, 0xEDE5, 0x0D09, 0xE7CB, 0x043C, 0xE533, 0xFF18, 0xF2C6,
0x104E, 0x1500, 0x1CDC, 0x2276, 0x13BF, 0x22E5, 0x0314, 0x1D7E,
0xFDA3, 0x01A0, 0xFD0A, 0xE51C, 0xF180, 0xDB0F, 0xE149, 0xDC79,
0xD6BA, 0xE94C, 0xE646, 0x0473, 0x0281, 0x1484, 0x06F5, 0x1516,
0x062B, 0x172D, 0x18E6, 0x174F, 0x2425, 0xFE36, 0x0F47, 0xE01B,
0xFCAE, 0xE168, 0x0343, 0xF4B5, 0x0792, 0x1085, 0xFE0F, 0x1D42,
0xFCD6, 0x134F, 0x0234, 0x0D52, 0x0331, 0x0AB1, 0x00FB, 0xF72A,
0xEA5C, 0xDBEB, 0xD628, 0xD4C7, 0xE40D, 0xE540, 0xF6DF, 0x0299,
0xFC1D, 0x1705, 0x0F46, 0x21EE, 0x2573, 0x1FD0, 0x1F9D, 0x0EC3,
0x18C1, 0xFCA5, 0x1622, 0xE8CF, 0x00F6, 0xE272, 0xEA0E, 0xEF81,
0xEB39, 0x02A5, 0xF821, 0x0FD4, 0x0160, 0x164E, 0x0678, 0x15C3,
0xFC6D, 0x0C1B, 0xF395, 0xF5A8, 0xF54C, 0xDBE7, 0xED39, 0xD62F,
0xE595, 0xE63B, 0xF925, 0x0D22, 0x1418, 0x267D, 0x1B07, 0x1BD7,
0x1D04, 0x1393, 0x21EE, 0x126C, 0x1EFD, 0x00DF, 0x06D7, 0xE6F6,
0xE965, 0xDA77, 0xE0D8, 0xE132, 0xE95E, 0xFD9E, 0xF53E, 0x17DF,
0xF91E, 0x1C4C, 0xF999, 0x0F00, 0xFE55, 0x00CB, 0x0632, 0xF6FB,
0x0447, 0xE325, 0xFA6B, 0xE1CC, 0xFBD5, 0xF5F1, 0x0405, 0x06A4,
0x0B7D, 0x18CC, 0x18EA, 0x22C9, 0x217B, 0x17C6, 0x139B, 0x0A30,
0x05E7, 0xFC4B, 0xFFCB, 0xE3A6, 0xEF4C, 0xDA02, 0xE2AE, 0xE64F,
0xE312, 0x01AC, 0xE843, 0x1874, 0xF354, 0x14F0, 0x01FF, 0x07E2,
0x09B6, 0x011B, 0x12D2, 0x01CC, 0x19AC, 0xF874, 0x0970, 0xE565,
0xF7B6, 0xE739, 0x0078, 0x0448, 0x0E3C, 0x1D02, 0x0A9B, 0x1EEB,
0x0797, 0x0F03, 0x0A21, 0xFF86, 0x07A4, 0xFB73, 0x000B, 0xEC8A,
0xED4D, 0xE1BD, 0xDA76, 0xEB82, 0xDC26, 0xFAB6, 0xEA0A, 0x0EA4,
0xF9D4, 0x1732, 0x104A, 0x0EE2, 0x20E6, 0x0B1E, 0x20A3, 0x0509,
0x1741, 0xF0C1, 0x0C6D, 0xE592, 0x02AB, 0xEE45, 0xF55D, 0x0279,
0xEEBF, 0x12B5, 0xFAE6, 0x15A5, 0x0864, 0x0F3D, 0x07F1, 0x0103,
0x0127, 0xFA2A, 0xFA49, 0xF482, 0xEE8A, 0xE464, 0xE0DE, 0xE1E9,
0xE0D5, 0xF87C, 0xF3E5, 0x13B9, 0x0E62, 0x1F6B, 0x1D92, 0x13CA,
0x1A51, 0x00CD, 0x1B45, 0xFB8E, 0x227D, 0xF5F6, 0x0C18, 0xEAA6,
0xE9B7, 0xE985, 0xE683, 0xF85D, 0xF0F7, 0x101C, 0xF834, 0x1AA7,
0xFE5B, 0x1009, 0xFD71, 0x01D7, 0xFF3D, 0xF8C5, 0x0183, 0xEFA3,
0xF757, 0xE804, 0xEF53, 0xEB46, 0xF7A6, 0xFF60, 0x03AE, 0x13E3,
0x090C, 0x194C, 0x111A, 0x0FAA, 0x1ECD, 0x0028, 0x1DCE, 0xFA13,
0x09DC, 0xF458, 0xF921, 0xE93F, 0xEFC4, 0xEB1F, 0xE8BD, 0xFBC4,
0xE35D, 0x0E14, 0xE646, 0x18F6, 0xF4F2, 0x0E0C, 0xFF0D, 0xF953,
0x03D9, 0xF534, 0x0BAE, 0xF838, 0x0CA7, 0xF4AB, 0x063C, 0xF092,
0xFE8B, 0xFA39, 0xF6E0, 0x0C2B, 0x041E, 0x1540, 0x16F7, 0x0D93,
0x0D2F, 0xFB8A, 0x0390, 0xF3AD, 0x087E, 0xF5D4, 0x028D, 0xF30F,
0xEE71, 0xF1A2, 0xDD95, 0xFE49, 0xDA28, 0x09F6, 0xE503, 0x0D92,
0xF8A3, 0x0AAE, 0x09E1, 0xFF31, 0x14C9, 0xF8FD, 0x1BE1, 0xF82C,
0x19C2, 0xF33F, 0x04DD, 0xEDCA, 0xF684, 0xF81C, 0xF92B, 0x09E0,
0xF908, 0x0EE7, 0xFB95, 0x09A0, 0x0231, 0xFF54, 0x0912, 0xF613,
0x08B1, 0xF544, 0xFA05, 0xF86F, 0xE904, 0xF1D5, 0xDF27, 0xF2BE,
0xDF19, 0x04D0, 0xF148, 0x13E0, 0x07A1, 0x1221, 0x10CA, 0x0137,
0x1D40, 0xF65D, 0x1FD8, 0xF353, 0x10F8, 0xF149, 0x06FD, 0xF16C,
0xFB8D, 0xF682, 0xEB9C, 0x02FC, 0xEA4F, 0x110A, 0xFA9C, 0x1137,
0x0271, 0x023D, 0xFF0F, 0xFBB6, 0xFE76, 0xF904, 0xF69C, 0xF073,
0xEBA7, 0xEE02, 0xF2F7, 0xFBEE, 0xF91A, 0x0C42, 0xF6F7, 0x1061,
0x093A, 0x0F0B, 0x17A3, 0xFF5F, 0x13B8, 0xEDF6, 0x13B2, 0xF0F5,
0x106F, 0xF49A, 0x0133, 0xEF9F, 0xF148, 0xFA8B, 0xE8EF, 0x0BE5,
0xE958, 0x10B7, 0xF1C4, 0x1300, 0xF7B8, 0x06D2, 0xF8D4, 0xF187,
0xFBC6, 0xEE72, 0x07AC, 0xF8A7, 0x0EE7, 0xFC0A, 0x0300, 0xFE69,
0xFB2D, 0x0ADC, 0x0182, 0x1143, 0x0643, 0x0899, 0x0773, 0xFA2C,
0x0F49, 0xF089, 0x12A6, 0xEE5B, 0x0A80, 0xF3E6, 0x016A, 0xFACD,
0xF648, 0x01CD, 0xE7B3, 0x0DFA, 0xE13C, 0x13F4, 0xE771, 0x0C3C,
0xEBCF, 0xFC16, 0xFE4E, 0xF34A, 0x1B95, 0xF731, 0x1B07, 0xF8A4,
0x0EFD, 0xF91B, 0x0F37, 0x030E, 0x03BC, 0x070D, 0xF31B, 0x050B,
0xF8E2, 0x08A6, 0x0262, 0xFE44, 0x067E, 0xEF9E, 0x0CB6, 0xF47F,
0x0AE3, 0xFC2F, 0xFF8C, 0xFE5C, 0xF2C6, 0x0688, 0xE7B1, 0x0B3F,
0xDC47, 0x0887, 0xE594, 0x0B4C, 0x03FD, 0x05DC, 0x1552, 0xF32D,
0x195A, 0xF11D, 0x1FBF, 0xFE27, 0x1B4D, 0xFB22, 0x06EB, 0xF8C8,
0xF8CA, 0x04FC, 0xF3C4, 0x08E6, 0xF224, 0x07DB, 0xF809, 0x02A1,
0x0422, 0xF5DC, 0x07EF, 0xF677, 0x010E, 0x00F0, 0xFC7E, 0xFE04,
0xF28C, 0xFF73, 0xE903, 0x0E3E, 0xF2AF, 0x10E8, 0xFF1A, 0x07B3,
0x0209, 0xFCE1, 0x122C, 0xF3D4, 0x21B8, 0xF0E1, 0x166C, 0xF331,
0x0B07, 0xF644, 0x08B6, 0xFEC9, 0xFB9F, 0x0AE5, 0xEE49, 0x0EBF,
0xEFFF, 0x0C63, 0xF38E, 0x04FC, 0xF81B, 0xF8BD, 0x015F, 0xF248,
0x01A7, 0xF765, 0xFE9F, 0xFFBF, 0x0643, 0x0AD0, 0x08F4, 0x0F6D,
0xFD8E, 0x0821, 0xFE21, 0x0799, 0x0708, 0x00D5, 0x07AA, 0xEB0A,
0x0B67, 0xE5D3, 0x1316, 0xF486, 0x10BB, 0xFBA0, 0x04AA, 0x0421,
0xFC0D, 0x1238, 0xF367, 0x11FD, 0xE76E, 0x0CED, 0xE232, 0x0420,
0xEDD1, 0xF369, 0x00E4, 0xF11F, 0x1072, 0x01F1, 0x199D, 0x04E9,
0x13D9, 0x0008, 0x0DCF, 0x0B3C, 0x0B31, 0x0CE8, 0xFC0B, 0x00A6,
0xEC76, 0xF7DE, 0xF97B, 0xEF7D, 0x1021, 0xEB57, 0x0E26, 0xF88A,
0x09C0, 0x0633, 0x0B8D, 0x0ABF, 0xFF63, 0x1256, 0xE9EF, 0x1083,
0xDD70, 0x059C, 0xDE71, 0xFFA9, 0xF5DF, 0xFDE9, 0x158A, 0xF7B0,
0x1ADE, 0xF603, 0x1A2C, 0xFDB4, 0x20A0, 0x0439, 0x147B, 0x07DB,
0xF80A, 0x043D, 0xEC47, 0x01FE, 0xF003, 0xFE08, 0xF2D6, 0xF268,
0x00C6, 0xF0FC, 0x0ECC, 0xFF59, 0x0EC9, 0x06C5, 0x04AE, 0x050B,
0xF5DB, 0x0D0E, 0xEA8C, 0x1002, 0xEBE4, 0x0E3B, 0xF513, 0x0905,
0xFB4C, 0xF5F3, 0x0D2C, 0xEA1F, 0x2584, 0xF33B, 0x2543, 0xFAD0,
0x1072, 0xF9B1, 0x051C, 0x079F, 0x00A2, 0x1100, 0xF32B, 0x0747,
0xE5A3, 0x007D, 0xE9B8, 0xFCE9, 0x00F5, 0xF500, 0x0BF9, 0xF375,
0x019C, 0xFB8A, 0xFB70, 0x036A, 0x025A, 0x140E, 0x07F0, 0x1CC4,
0xFDA1, 0x0CC2, 0xF01D, 0xFC01, 0xFA43, 0xF3C2, 0x1390, 0xE810,
0x181C, 0xE372, 0x0DDB, 0xF4D9, 0x0ED1, 0x066E, 0x0EF6, 0x0E2B,
0xFDC8, 0x10F1, 0xEE2B, 0x110A, 0xE9FB, 0x0AC6, 0xE7ED, 0xF8C5,
0xF0C0, 0xEB0C, 0xFE7E, 0xEF39, 0x06E3, 0x01A9, 0x13C6, 0x102B,
0x1AFB, 0x13E3, 0x0B6A, 0x103F, 0xFF38, 0x09A0, 0xFF5F, 0xFC73,
0xF395, 0xE8FD, 0xF48A, 0xE262, 0x0D3C, 0xEEC5, 0x16BD, 0x00C6,
0x0BAA, 0x0654, 0x07A4, 0x0EC5, 0x0414, 0x1A6E, 0xF3B9, 0x0F75,
0xE394, 0xFA52, 0xD7BF, 0xF019, 0xE401, 0xF1BD, 0x0B4E, 0xFA1A,
0x21B8, 0x0436, 0x19C2, 0x0638, 0x17AF, 0x0C91, 0x1BFD, 0x1083,
0x0722, 0xFFE2, 0xECE1, 0xF0BE, 0xE6A8, 0xF073, 0xF3BD, 0xF430,
0x06B5, 0xF20A, 0x0E44, 0xFC6A, 0x0D33, 0x0EE0, 0x0CFE, 0x1446,
0x0632, 0x0FEF, 0xEEDE, 0x061E, 0xDE8C, 0xFF7D, 0xE2BF, 0xFE13,
0xF737, 0xF9AF, 0x1261, 0xF002, 0x1F10, 0xF734, 0x2178, 0x0502,
0x1F92, 0x044D, 0x117A, 0x0334, 0xFD0C, 0x051E, 0xF25D, 0x05F8,
0xE734, 0xFD11, 0xE1F9, 0xF2D3, 0xFAD3, 0xF2B2, 0x0FC1, 0xFCDF,
0x0B2C, 0x036F, 0x0506, 0x035B, 0x0151, 0x0C48, 0xF6A1, 0x1239,
0xF37D, 0x0CA9, 0xF35F, 0xFBE6, 0xF08D, 0xF032, 0x0AD5, 0xF120,
0x23D4, 0xF355, 0x17D6, 0xF571, 0x1001, 0xFED3, 0x1644, 0x118B,
0x05FB, 0x14A1, 0xECF1, 0x0922, 0xE457, 0xFE71, 0xE256, 0xF89D,
0xF423, 0xF412, 0x0945, 0xF246, 0x0661, 0xFC3E, 0x0722, 0x0AF8,
0x12E9, 0x18ED, 0x0CE3, 0x1165, 0xFBA4, 0xFD8B, 0xF7BD, 0xF7FA,
0xF403, 0xF271, 0xF96E, 0xE56C, 0x0EBE, 0xE8FA, 0x1718, 0xFF6E,
0x1423, 0x0E22, 0x0FE1, 0x1709, 0x01C1, 0x1489, 0xEF12, 0x0719,
0xE659, 0xFCF3, 0xDD75, 0xF2A7, 0xE3CC, 0xEC80, 0x0362, 0xF40D,
0x145D, 0x0896, 0x1644, 0x1013, 0x1BFA, 0x0B91, 0x193B, 0x0BD5,
0x0986, 0x057F, 0xF51A, 0xF41A, 0xE145, 0xE79F, 0xEBCF, 0xEB1E,
0x0CAF, 0xF6FD, 0x127B, 0x05BD, 0x0D25, 0x0CDE, 0x1019, 0x1048,
0x07FA, 0x10DF, 0xF424, 0x03DA, 0xE28E, 0xF79F, 0xD8A7, 0xF41E,
0xE5C1, 0xF7AB, 0x072D, 0xFB59, 0x17A5, 0xF968, 0x1BBC, 0xFE18,
0x25E9, 0x0BE5, 0x1AEF, 0x0AA2, 0xF9D5, 0xFB4E, 0xED30, 0xF847,
0xE81E, 0xFA33, 0xE28E, 0xF9D7, 0xFB26, 0xFC06, 0x0DC5, 0xFE42,
0x098F, 0x017B, 0x0E53, 0x05F3, 0x0838, 0x07D0, 0xF0B8, 0x0357,
0xEC5C, 0x0383, 0xE9D9, 0x04DB, 0xE547, 0xF5EC, 0x02EC, 0xEBEF,
0x2452, 0xF886, 0x22A4, 0x009B, 0x1193, 0xFE54, 0x0E0B, 0x03F0,
0x05D5, 0x074A, 0xF0C6, 0x063B, 0xE229, 0x03F3, 0xDCD5, 0xF8E3,
0xEEBC, 0xF4B7, 0x0A29, 0xF8CA, 0x0CAF, 0xF869, 0x04BF, 0xFE34,
0x0B24, 0x0C5B, 0x057B, 0x10C9, 0xF332, 0x0322, 0xEB24, 0xF2E8,
0xEE43, 0xF0FF, 0x0518, 0xF516, 0x0FCF, 0xF444, 0x0AE5, 0xF8CC,
0x136D, 0x044A, 0x172E, 0x10C0, 0x061E, 0x13F4, 0xF2BF, 0x063E,
0xE421, 0xFC29, 0xD97F, 0xF6BA, 0xE92A, 0xECE0, 0xFCF0, 0xECC3,
0x0662, 0xFA74, 0x125D, 0x0D43, 0x187E, 0x12DB, 0x0EF1, 0x0386,
0x01E6, 0xFAAC, 0x0112, 0xFF88, 0xEBE4, 0xF70A, 0xDFD5, 0xEC04,
0xFEAB, 0xF169, 0x11F5, 0xFFD9, 0x0D35, 0x0B5F, 0x0FE5, 0x0B05,
0x0C41, 0x0ACA, 0xF6DD, 0x08D0, 0xEBC6, 0xFC48, 0xDB33, 0xEFB5,
0xD9F1, 0xEED1, 0xFCAE, 0xFC0E, 0x1264, 0x04ED, 0x153B, 0xFCE1,
0x1A25, 0xF9BE, 0x23B4, 0x081D, 0x13FA, 0x0BE5, 0xF011, 0x0095,
0xDCF9, 0xF92C, 0xE428, 0xFB8F, 0xF9B6, 0x019D, 0x0884, 0xFEEA,
0x0CB8, 0xFDC1, 0x0DD3, 0x02EA, 0x109B, 0x04D4, 0xFE37, 0xFE06,
0xE766, 0xF6ED, 0xE1FA, 0xFF18, 0xE504, 0x0772, 0xFCFE, 0xF995,
0x12E8, 0xEC3E, 0x1F37, 0xF8FB, 0x2954, 0x0634, 0x1B99, 0x08D5,
0xFEA4, 0x0793, 0xF323, 0x0671, 0xEA52, 0x0ADE, 0xDB7D, 0x0393,
0xEB4B, 0xF5E0, 0x054F, 0xF766, 0x0D42, 0xFE90, 0x0BAF, 0xF7B1,
0x09E8, 0xF50B, 0x04E7, 0x0605, 0xF8FF, 0x1289, 0xF0FA, 0x0897,
0xE975, 0xF31A, 0xF70D, 0xED1C, 0x1AD5, 0xF853, 0x1F66, 0x03F2,
0x0BC9, 0x00B0, 0x10F5, 0x031C, 0x1374, 0x1A17, 0xFA6B, 0x18CE,
0xE81C, 0x0203, 0xE001, 0xFBE1, 0xE66F, 0xFA82, 0xFA3B, 0xEE8B,
0x017F, 0xE993, 0x05BF, 0xF0C6, 0x1352, 0x0480, 0x17C8, 0x17DF,
0x09A4, 0x0B19, 0xFB40, 0xF9A9, 0xF759, 0xFD9C, 0xF828, 0x0149,
0xFA1B, 0xF73C, 0x02A2, 0xF474, 0x0E93, 0x0461, 0x1390, 0x0D9B,
0x0FAF, 0x0FE5, 0x0379, 0x1100, 0xF6A2, 0x0B27, 0xE625, 0xFFC2,
0xD944, 0xF08F, 0xE99E, 0xE4E7, 0x064E, 0xF057, 0x1295, 0x02B8,
0x1A79, 0xFD21, 0x2075, 0xFEB1, 0x1AEA, 0x0D28, 0x0EA3, 0x1262,
0xF0BA, 0x0C41, 0xD97F, 0xFCCE, 0xEE53, 0xF93A, 0x0802, 0x0195,
0x06DB, 0xFED2, 0x0B8B, 0xF890, 0x1A5E, 0x0847, 0x0EA8, 0x13B6,
0xF247, 0x0470, 0xDE73, 0xF519, 0xD937, 0xF48C, 0xEE8F, 0xF9E0,
0x0BCD, 0xF84B, 0x162D, 0xF2C2, 0x1EB1, 0xF0EE, 0x2F5C, 0x0812,
0x2084, 0x210D, 0xF8A6, 0x1286, 0xE830, 0x05A3, 0xE339, 0x09E1,
0xE1D5, 0xFF01, 0xF716, 0xF2E4, 0x0FB1, 0xF76F, 0x13E3, 0xF944,
0x1263, 0xFFA3, 0x09DD, 0x0B78, 0xF7D4, 0x05D2, 0xF1A8, 0x024C,
0xEAB9, 0x0305, 0xEAC3, 0xF494, 0x0502, 0xE76F, 0x208A, 0xF4CF,
0x22A7, 0x05D0, 0x14C7, 0x08D8, 0x10D8, 0x1701, 0x0AA6, 0x2018,
0xF263, 0x11F1, 0xD880, 0x0155, 0xDE43, 0xF76A, 0xF96A, 0xEE47,
0x035D, 0xEC39, 0x00AF, 0xED70, 0x0534, 0xF221, 0x152E, 0x0AFE,
0x14B4, 0x19CD, 0x00CE, 0x0CBF, 0xEE95, 0xFAF3, 0xEF18, 0xF4CC,
0x062C, 0xFB48, 0x0A7F, 0xFBAB, 0x022B, 0xF636, 0x1304, 0x0115,
0x200E, 0x1A39, 0x07B2, 0x1FF7, 0xF673, 0x0FE0, 0xF2C3, 0x01EE,
0xDCCF, 0xF7F0, 0xDCD2, 0xECAB, 0xF170, 0xE3D5, 0x00A9, 0xE54F,
0x13AF, 0xF344, 0x22C3, 0x0D82, 0x1CA0, 0x1740, 0x0DB3, 0x09BD,
0x035B, 0x0B60, 0xE9F6, 0x0CD1, 0xDBD8, 0xF930, 0xF706, 0xF162,
0x11AF, 0xF90E, 0x0AB5, 0xFC02, 0x0F38, 0x0BA8, 0x2124, 0x1C67,
0x0A62, 0x0FD4, 0xE586, 0xFE7F, 0xCDFA, 0xF68E, 0xD178, 0xEA8A,
0xF849, 0xE3F7, 0x1364, 0xEDF6, 0x165E, 0xF505, 0x235E, 0xFEDD,
0x308D, 0x1DB4, 0x1D63, 0x286C, 0xF167, 0x0F9C, 0xD0BA, 0xFE8A,
0xDE21, 0xFC15, 0xF6A8, 0xF427, 0xFBCA, 0xEF6D, 0x0F0F, 0xF345,
0x2480, 0x0221, 0x1CA0, 0x17C5, 0x0024, 0x147E, 0xE7ED, 0xFD9A,
0xDA70, 0xF29D, 0xDCBC, 0xF3BE, 0xF5C1, 0xED72, 0x0F4F, 0xE3CE,
0x1C52, 0xEF98, 0x2C64, 0x1181, 0x2C5A, 0x2A58, 0x0958, 0x2164,
0xF5CD, 0x0E12, 0xE811, 0x05C9, 0xCB3A, 0xFC55, 0xDF7E, 0xEBCA,
0x0B5A, 0xE355, 0x0C85, 0xE952, 0x0889, 0xF831, 0x14E8, 0x0F7D,
0x1175, 0x1504, 0x0375, 0x087B, 0xEF74, 0x0428, 0xDE72, 0xF945,
0xEE74, 0xE892, 0x11A3, 0xF07C, 0x1D51, 0x00A3, 0x0F49, 0x0206,
0x16EB, 0x12FD, 0x2310, 0x2734, 0x03B9, 0x1A41, 0xDDD0, 0x02B2,
0xD6A8, 0xF846, 0xE257, 0xEEBC, 0xF223, 0xE108, 0xFBF8, 0xE069,
0x0765, 0xEA66, 0x2100, 0x042A, 0x2765, 0x2088, 0x1042, 0x15B6,
0xF5E1, 0xFC3A, 0xE196, 0x0086, 0xEB1A, 0x0930, 0xFE28, 0xF5F2,
0xFF9C, 0xE997, 0x10FF, 0xF9A7, 0x26A7, 0x14BD, 0x1BEE, 0x21FA,
0x08C5, 0x1263, 0xF462, 0x0168, 0xCEE4, 0xFA75, 0xC3E6, 0xEE0A,
0xE557, 0xDA19, 0x0751, 0xD79D, 0x1827, 0xF18C, 0x27E6, 0x0EA5,
0x30A8, 0x1BA2, 0x1DE5, 0x190D, 0x0420, 0x190E, 0xE422, 0x12FB,
0xC729, 0xF97D, 0xE2AD, 0xE590, 0x0ED0, 0xEB50, 0x101A, 0xF6A8,
0x15C1, 0xFFD2, 0x2D34, 0x1915, 0x1A76, 0x20BD, 0xEA89, 0x0892,
0xC9F4, 0xF3D6, 0xC6B8, 0xE89B, 0xE97A, 0xE1D4, 0x0C85, 0xE411,
0x18C1, 0xEB7D, 0x2535, 0xFADB, 0x37B1, 0x2460, 0x31EB, 0x3CBA,
0xFF0A, 0x1C8F, 0xCF30, 0xFF71, 0xCE4B, 0x01DF, 0xE55F, 0xF491,
0xF816, 0xD9C3, 0x0C52, 0xE05C, 0x1E94, 0xFD1E, 0x2074, 0x1566,
0x12B0, 0x1AB4, 0xF8FF, 0x0599, 0xE025, 0xFAA4, 0xD362, 0x02E1,
0xE320, 0xF436, 0x0500, 0xD758, 0x1AF6, 0xE5EA, 0x2D69, 0x1172,
0x312F, 0x250F, 0x1980, 0x230D, 0x01D9, 0x1C31, 0xE877, 0x1194,
0xC633, 0xFECF, 0xCD8D, 0xE765, 0xFC83, 0xD9A9, 0x0BB6, 0xE1C0,
0x097E, 0xF162, 0x1B28, 0xFD81, 0x23CE, 0x11F9, 0x1022, 0x1DB3,
0xEC4F, 0x125E, 0xD135, 0xFDFB, 0xDB39, 0xEE4D, 0x077A, 0xED21,
0x20CE, 0xF525, 0x15A2, 0xFA67, 0x1B73, 0x0B5E, 0x2EE6, 0x2A2B,
0x1255, 0x271D, 0xDD1B, 0x0552, 0xCB2E, 0xF819, 0xD068, 0xF3CA,
0xE25F, 0xDC47, 0x0008, 0xCD42, 0x1216, 0xDDC7, 0x239E, 0x0031,
0x3120, 0x25BC, 0x1AA4, 0x29B3, 0xF1D4, 0x0AE7, 0xDD35, 0x055F,
0xE118, 0x0BE0, 0xEE45, 0xEC26, 0xFF29, 0xD67A, 0x15F3, 0xF1F3,
0x24FB, 0x0C09, 0x1FB4, 0x1849, 0x1378, 0x204D, 0xF825, 0x1425,
0xCBE6, 0x01C7, 0xBF98, 0xEF23, 0xDCAA, 0xD068, 0x01B6, 0xC6C4,
0x1A45, 0xE935, 0x21E9, 0x0820, 0x27BC, 0x1563, 0x2779, 0x27E0,
0x0E97, 0x2CB1, 0xE52C, 0x1843, 0xC7CA, 0xFE1A, 0xD9A6, 0xE70B,
0x0579, 0xD8C5, 0x0D49, 0xE241, 0x0D02, 0xF4F2, 0x26A6, 0x0C6A,
0x1FC7, 0x2799, 0xF3EA, 0x1EF3, 0xD356, 0xFC65, 0xC84A, 0xEB75,
0xDE21, 0xE50B, 0x023C, 0xDAE9, 0x11F0, 0xE020, 0x1E97, 0xF59F,
0x33DD, 0x165A, 0x3468, 0x370A, 0x07EB, 0x2F5C, 0xD558, 0x1028,
0xCD74, 0x008B, 0xD6D1, 0xEE1B, 0xE7D8, 0xD1D0, 0x0C6A, 0xD26E,
0x1DD7, 0xF10B, 0x1B3E, 0x0B99, 0x1D57, 0x1CDE, 0x065E, 0x1B3E,
0xE106, 0x09D4, 0xD469, 0x00FE, 0xD84C, 0xF3A7, 0xF2DF, 0xD7B2,
0x1B6F, 0xD91F, 0x30D9, 0xFE1C, 0x2EC8, 0x1740, 0x1EE5, 0x271F,
0x09DD, 0x2EBB, 0xE781, 0x1A7F, 0xC40C, 0xFF1C, 0xC79D, 0xE72F,
0xEC61, 0xD097, 0x07CB, 0xD1E1, 0x14D9, 0xE78B, 0x1CF5, 0xF99E,
0x1F6B, 0x1440, 0x184B, 0x2DCE, 0xF3DA, 0x2452, 0xD369, 0x0829,
0xDC00, 0xF2FA, 0xFACD, 0xE1A8, 0x1B4B, 0xDDB5, 0x1FC8, 0xEFCD,
0x172B, 0x04C8, 0x1EF9, 0x1CE5, 0x10B1, 0x3272, 0xE6B0, 0x2196,
0xD269, 0xFE33, 0xD3D2, 0xEEDF, 0xE149, 0xDD3B, 0x0018, 0xC718,
0x1322, 0xD2B9, 0x1BD4, 0xF7BB, 0x2525, 0x1B9D, 0x1B8B, 0x359B,
0xFE84, 0x2EA3, 0xE6CC, 0x1027, 0xEB19, 0xFF6E, 0xF499, 0xEE08,
0xFA12, 0xD33B, 0x0D90, 0xD8AA, 0x17FA, 0xFBEF, 0x103A, 0x14F1,
0x0BE9, 0x243E, 0xFE88, 0x28F7, 0xE129, 0x133E, 0xD554, 0xF195,
0xDCF2, 0xD621, 0xF432, 0xC893, 0x17EE, 0xD567, 0x2393, 0xF8BF,
0x1DE0, 0x1972, 0x1C88, 0x2EED, 0x1586, 0x392A, 0xFEB1, 0x2844,
0xDEB9, 0x019C, 0xD418, 0xE0C9, 0xEEEF, 0xD2F5, 0x0CC7, 0xD714,
0x1063, 0xE8D6, 0x1488, 0x0707, 0x1B50, 0x2C64, 0x0993, 0x35D0,
0xE73E, 0x11E1, 0xD1BD, 0xEE56, 0xDCD0, 0xE032, 0xF992, 0xD53F,
0x1337, 0xD76A, 0x1F40, 0xEF20, 0x259C, 0x1045, 0x307C, 0x365D,
0x1D93, 0x44BF, 0xE7AE, 0x2107, 0xCE08, 0xF973, 0xD93B, 0xE8D4,
0xE236, 0xD13B, 0xFB91, 0xC3F0, 0x1C6E, 0xE434, 0x1E6D, 0x0E6C,
0x149C, 0x1FED, 0x05D6, 0x2AEE, 0xEECF, 0x2275, 0xE609, 0xFF99,
0xE917, 0xEABC, 0xEE99, 0xDF64, 0x07F2, 0xD0D8, 0x2DC9, 0xE85B,
0x33F7, 0x16B6, 0x13CB, 0x2728, 0xFBEA, 0x3074, 0xF555, 0x30A4,
0xE0BB, 0x07A9, 0xD12A, 0xDD4C, 0xE4F6, 0xD457, 0x06CE, 0xD632,
0x1777, 0xD8E1, 0x1037, 0xF0E7, 0x036E, 0x177C, 0x095E, 0x308E,
0x09FA, 0x304C, 0xEF2C, 0x14AA, 0xE2CF, 0xEF19, 0xF7F1, 0xE078,
0x17BB, 0xE211, 0x1E6E, 0xE0CF, 0x0634, 0xF3C7, 0xFFFA, 0x1B3F,
0x093C, 0x349D, 0xF700, 0x2984, 0xE271, 0x0786, 0xE8AA, 0xF290,
0xEEE3, 0xE188, 0xF4EA, 0xC804, 0x02AE, 0xCA3C, 0x0E63, 0xEDDF,
0x17BE, 0x143C, 0x14DF, 0x3650, 0x0712, 0x3BB6, 0xFACE, 0x18C5,
0xFEE4, 0xFCFC, 0xFF0F, 0xED49, 0xEB5B, 0xD22D, 0xF495, 0xCD26,
0x1122, 0xF0FA, 0x083E, 0x0FC5, 0xFAE7, 0x2189, 0x0933, 0x3751,
0x00ED, 0x24DB, 0xE6F8, 0xECCF, 0xDC58, 0xD19F, 0xE18D, 0xCF0E,
0x057A, 0xCB4E, 0x1FDD, 0xE7B2, 0x12D6, 0x170E, 0x0C1A, 0x2FE8,
0x1CB8, 0x404A, 0x18ED, 0x33B8, 0xEEDC, 0xFD82, 0xD298, 0xD96D,
0xE303, 0xD710, 0xFD34, 0xD085, 0x0489, 0xD763, 0x0A1C, 0x06C6,
0x1079, 0x3389, 0x0E27, 0x3756, 0xFC0E, 0x1A0B, 0xDFD8, 0xF532,
0xE3C3, 0xDB23, 0xF920, 0xD358, 0x038E, 0xD68A, 0x1151, 0xE25D,
0x1C1C, 0x090C, 0x2029, 0x370D, 0x16D5, 0x435F, 0xF582, 0x2694,
0xDF91, 0xFF35, 0xE6EA, 0xE484, 0xE61D, 0xD05D, 0xF009, 0xCA0C,
0x0FFB, 0xE04C, 0x1347, 0x029A, 0x0390, 0x196F, 0xFD12, 0x2D31,
0xFD43, 0x293E, 0xFD04, 0x021B, 0xF8D6, 0xE7FE, 0xF650, 0xE0CD,
0x0165, 0xD874, 0x1C7C, 0xE3AD, 0x208F, 0x07E7, 0xFFE4, 0x2241,
0xF25A, 0x3273, 0x01A1, 0x3154, 0xF706, 0x078F, 0xE59C, 0xE0DB,
0xF071, 0xDC74, 0xFBC4, 0xDA42, 0x03D6, 0xD092, 0x02F5, 0xE817,
0xF939, 0x163C, 0x0717, 0x2F74, 0x1778, 0x30B5, 0x0936, 0x167B,
0xFBEE, 0xF177, 0x011B, 0xE344, 0x0517, 0xE37B, 0x0157, 0xDDC1,
0xF67A, 0xEDCB, 0xF77D, 0x167F, 0x047B, 0x30A3, 0x0600, 0x2E37,
0xFFCA, 0x1283, 0xF9BA, 0xF2AE, 0xF0E5, 0xD81E, 0xE933, 0xC904,
0xEE86, 0xCF7D, 0xFED4, 0xE87C, 0x0D9B, 0x0E00, 0x1666, 0x3429,
0x1BE5, 0x40E7, 0x16CF, 0x21AA, 0x0AC9, 0xFC8B, 0xFB75, 0xE88B,
0xE16D, 0xD869, 0xE2D9, 0xD2EA, 0xFD11, 0xE5AF, 0xFFD9, 0x087F,
0x0211, 0x28EB, 0x13D0, 0x390A, 0x0CFB, 0x1B4C, 0xF53F, 0xE87C,
0xE993, 0xD4A0, 0xE3ED, 0xD4FF, 0xF3DC, 0xD302, 0x0CA4, 0xE2C8,
0x11EB, 0x0D6B, 0x1608, 0x31EA, 0x213B, 0x41AD, 0x19E3, 0x2C54,
0xF73A, 0xFE41, 0xE0B9, 0xE248, 0xE4ED, 0xD8CB, 0xF05D, 0xD663,
0xF999, 0xE218, 0x02C3, 0x0209, 0x0A57, 0x22AE, 0x0C59, 0x2D4C,
0x066A, 0x174C, 0xF597, 0xF7B6, 0xF280, 0xE4ED, 0xFAE3, 0xDA83,
0x004D, 0xDDA0, 0x097C, 0xECA3, 0x11A5, 0x071B, 0x1763, 0x2877,
0x112E, 0x3D0B, 0xFD14, 0x2999, 0xF1C9, 0xFE36, 0xF5FC, 0xE713,
0xEDFB, 0xDEA0, 0xEA9D, 0xD8DC, 0xFB4A, 0xDF90, 0xFD0E, 0xF19B,
0xFEE4, 0x0A55, 0x09DE, 0x2C70, 0x0B86, 0x2D7F, 0x0BC5, 0x0351,
0x0D3A, 0xEA8F, 0x0275, 0xE915, 0xFA32, 0xE737, 0x03A5, 0xE9BD,
0x0250, 0xFCDC, 0xF70A, 0x18EC, 0xFEE3, 0x31C0, 0x0FA3, 0x3017,
0x07BE, 0x0BC6, 0xF8DA, 0xEC6B, 0xF43D, 0xDE59, 0xE985, 0xD335,
0xE9A2, 0xCE9A, 0xF10E, 0xE502, 0xFA13, 0x0F15, 0x1488, 0x311E,
0x278B, 0x32D7, 0x1B71, 0x136D, 0x0B97, 0xF971, 0x0386, 0xEBE7,
0xF234, 0xE2F7, 0xE2A4, 0xE224, 0xE186, 0xED75, 0xF74C, 0x0A40,
0x11C8, 0x2D2D, 0x136D, 0x334A, 0x086E, 0x102F, 0xFD53, 0xE98F,
0xEFB5, 0xD1C8, 0xE1A2, 0xCCD8, 0xE02A, 0xDA09, 0xF2BD, 0xEDDD,
0x0FEE, 0x0770, 0x24E9, 0x2A46, 0x2646, 0x3E01, 0x1B3B, 0x2213,
0x0B6D, 0xFAE6, 0xF16C, 0xE925, 0xD62B, 0xDFCD, 0xDB84, 0xDFE4,
0xF290, 0xEE7F, 0xFE0D, 0x03EF, 0x0EDF, 0x1FB0, 0x177E, 0x2C1C,
0x07D8, 0x08A3, 0xF8C0, 0xE05B, 0xED04, 0xDAAE, 0xE5B9, 0xE202,
0xF40B, 0xE4ED, 0x05FA, 0xEBA2, 0x0E7C, 0x06DB, 0x1EFA, 0x2BF3,
0x2693, 0x3B6C, 0x0D4F, 0x2263, 0xED6B, 0xF90C, 0xE517, 0xE53D,
0xE7E1, 0xE64B, 0xE6DA, 0xE566, 0xED74, 0xE88F, 0xFB6B, 0xFA1E,
0x0B01, 0x0BFA, 0x1503, 0x1939, 0x0854, 0x133C, 0xFA49, 0xFAF8,
0x010D, 0xEAF3, 0x028E, 0xE52B, 0xF8BF, 0xE77E, 0xFB9E, 0xF43D,
0x07EB, 0x0539, 0x1057, 0x1D14, 0x0C72, 0x2FBA, 0xFF98, 0x2309,
0xFD3F, 0x05E5, 0xFA46, 0xECFA, 0xEE5E, 0xE05F, 0xE64C, 0xE1A4,
0xE50D, 0xDD30, 0xF0D6, 0xDE6E, 0x048C, 0xFF93, 0x1284, 0x27C9,
0x18CB, 0x2C01, 0x1976, 0x0AF9, 0x1085, 0xECF4, 0x031E, 0xEDF9,
0xF7B9, 0xF38B, 0xED9F, 0xEF6F, 0xE9C9, 0xF66D, 0xF5E3, 0x0DCC,
0x0E07, 0x2C01, 0x117B, 0x2D1D, 0x0517, 0x094E, 0xFCF4, 0xEB12,
0xEEF9, 0xDB93, 0xE36C, 0xCFA1, 0xE15D, 0xD3B5, 0xEB28, 0xE9A2,
0x0A86, 0x0CCA, 0x2B63, 0x2C8A, 0x2B3D, 0x2A27, 0x1B73, 0x13F0,
0x0F89, 0xFD21, 0xFB4C, 0xEE45, 0xE31E, 0xEC51, 0xD6E2, 0xEA7A,
0xE65A, 0xF4B7, 0x02AA, 0x0EE3, 0x167C, 0x21BE, 0x179B, 0x23FF,
0x06D5, 0x0BA9, 0xF7F7, 0xDD0F, 0xED18, 0xCB83, 0xE28F, 0xDCD6,
0xE536, 0xECBF, 0xFEB6, 0xF9EC, 0x1B71, 0x0A0A, 0x2D33, 0x23FF,
0x2CF0, 0x3431, 0x16B6, 0x2065, 0xF8E2, 0xF9BA, 0xE32F, 0xE514,
0xDFC2, 0xECB2, 0xDF92, 0xF50E, 0xE930, 0xF367, 0x0556, 0x0189,
0x16CD, 0x19D9, 0x12DD, 0x146F, 0x0701, 0xFDCC, 0xF824, 0xE831,
0xF029, 0xDF7A, 0xF9D1, 0xF0D6, 0xFBC3, 0xF6C0, 0xFFAE, 0xF354,
0x1A1D, 0x0AB9, 0x27AF, 0x2841, 0x1643, 0x2BBC, 0xFF0D, 0x1AE6,
0xF50E, 0x017D, 0xED56, 0xEF4E, 0xE899, 0xEC11, 0xE763, 0xED40,
0xE9C9, 0xF025, 0xFC49, 0xF05D, 0x1055, 0xFD9D, 0x1050, 0x1221,
0x0974, 0x12E8, 0x0C02, 0x0638, 0x08C1, 0xF3FA, 0x0313, 0xEBE9,
0x01A6, 0xF745, 0xFE31, 0x000B, 0x003F, 0x02E7, 0x06FE, 0x137D,
0x0B59, 0x254B, 0x062B, 0x2460, 0xF9B4, 0x094B, 0xF30D, 0xEA07,
0xF27F, 0xE844, 0xE93E, 0xE737, 0xE49E, 0xDCC1, 0xF856, 0xE776,
0x0FF3, 0x04C7, 0x1D9F, 0x2106, 0x2090, 0x2649, 0x14EC, 0x0B13,
0x09B6, 0xF0F7, 0x07E8, 0xF50E, 0xF599, 0xFCB0, 0xDE8E, 0xF739,
0xF05D, 0xFC3B, 0x0D72, 0x1659, 0x0D52, 0x2416, 0x090E, 0x18E9,
0x04A4, 0x0886, 0xF242, 0xEA08, 0xE9E0, 0xD2C3, 0xE835, 0xDD88,
0xE4E0, 0xEB8C, 0xFEF7, 0xF7F4, 0x24E1, 0x148F, 0x2A32, 0x251C,
0x219E, 0x1E84, 0x1B56, 0x12C0, 0x0082, 0xFD91, 0xE564, 0xEA8C,
0xE295, 0xEF6F, 0xE3BB, 0xFF2F, 0xECE0, 0x0116, 0x0832, 0x04CD,
0x15CA, 0x17C2, 0x0CBA, 0x1617, 0xFF3E, 0xF81D, 0xEFB1, 0xE060,
0xEC0D, 0xDBB6, 0xF470, 0xE9C5, 0xFB28, 0xFDC5, 0x0978, 0x023F,
0x1F8C, 0x0914, 0x2A45, 0x1D6B, 0x1D3C, 0x259B, 0xFDF1, 0x12DA,
0xE873, 0xF775, 0xEC13, 0xF1F6, 0xEB0E, 0xF91A, 0xE3C2, 0xF6FE,
0xF439, 0xF659, 0x0D7C, 0xFE87, 0x0F98, 0x02A6, 0x0455, 0x02C9,
0xFE1C, 0xFF5A, 0xF93A, 0xF5AC, 0x0066, 0xF275, 0x0918, 0xF976,
0x024E, 0xFFDB, 0x0AE8, 0xFEB1, 0x1E4D, 0x07AA, 0x1073, 0x176A,
0xFBA5, 0x16E9, 0xFC8D, 0x11D3, 0xEFD6, 0x07B4, 0xE510, 0xF1A4,
0xEFD6, 0xECCE, 0xF237, 0xF80C, 0xF4E8, 0xEE6C, 0x0490, 0xE902,
0x0BC4, 0xFEBE, 0x0BD4, 0x0EB4, 0x1007, 0x1002, 0x09BB, 0x0759,
0x0211, 0xF911, 0x0753, 0xF500, 0x056C, 0xFF4B, 0xF73C, 0x0390,
0xF96B, 0x0048, 0x0AB0, 0x0E0B, 0x0938, 0x1EB1, 0xF97E, 0x12F9,
0xEE5A, 0xFCF5, 0xEFD0, 0xF139, 0xF5B4, 0xE46B, 0xEF34, 0xE268,
0xEDED, 0xEBDA, 0x05A7, 0xF5A5, 0x1DE4, 0x0ABE, 0x2030, 0x1B9C,
0x16A8, 0x1798, 0x098D, 0x0896, 0x03AD, 0xF8A0, 0xF9CA, 0xF46A,
0xE5A7, 0xFB0F, 0xEA3A, 0xFCB6, 0x01B1, 0x02B6, 0x0767, 0x0BC0,
0x018D, 0x0E28, 0x00A2, 0x0E59, 0xF8E8, 0xFBBC, 0xF05A, 0xE1EA,
0xEF3C, 0xDED0, 0xF15A, 0xED0E, 0x00AB, 0xFC3E, 0x18D0, 0x045A,
0x22D4, 0x0B78, 0x1CAC, 0x165E, 0x15FE, 0x1572, 0xFF98, 0x0836,
0xE5DA, 0xFD42, 0xEA86, 0xF5FA, 0xF4BE, 0xFDB0, 0xF3CB, 0x02DD,
0xFBFE, 0xF9BF, 0x08D5, 0xFFD9, 0x08EC, 0x06C1, 0x018B, 0xFB91,
0xF0DC, 0xF041, 0xE94B, 0xEDF1, 0xFBF9, 0xF4DC, 0x0C9C, 0x0046,
0x1188, 0x03C8, 0x198D, 0x0611, 0x2331, 0x0840, 0x15DF, 0x0947,
0xF7F0, 0x1060, 0xE71D, 0x09DD, 0xE86A, 0xFF5E, 0xF092, 0xFDF6,
0xF32F, 0xF972, 0xF6C8, 0xFAB0, 0x0356, 0xFB4E, 0x0F87, 0xF1F0,
0x09D3, 0xF118, 0xFAD6, 0xFC2C, 0xF70D, 0x0306, 0xFF6A, 0x02DC,
0x0A7D, 0xFF73, 0x0D8F, 0x0391, 0x118B, 0x0704, 0x131B, 0xFF47,
0x064C, 0xFFEF, 0xFB7C, 0x080F, 0xF897, 0x0F7F, 0xEFD1, 0x0E05,
0xE9C8, 0xFDF9, 0xF020, 0xF688, 0xF677, 0xF9C1, 0xFD8F, 0xF18C,
0x061F, 0xE9C2, 0x0723, 0xEEA0, 0x0762, 0xFB1D, 0x0CF9, 0x0DBE,
0x0A5E, 0x0F34, 0x0420, 0x0758, 0x0BD7, 0x08A6, 0x0D62, 0x00C2,
0xFCBE, 0xF9BE, 0xF761, 0xFFE0, 0xFFD1, 0x0276, 0xFEB4, 0x025D,
0xF829, 0x0757, 0xEF55, 0x0695, 0xE91D, 0xFEB3, 0xF1FD, 0xF59C,
0xFDBF, 0xEEF5, 0x0129, 0xEC9D, 0x0687, 0xF328, 0x12B6, 0xFFD6,
0x1756, 0x00E9, 0x1174, 0x07AC, 0x082D, 0x155B, 0xFEC5, 0x09D9,
0xF4A6, 0xFC38, 0xF024, 0x03B0, 0xF85A, 0x057C, 0xFF87, 0xFFD7,
0x01E6, 0xFC33, 0x00F6, 0xF609, 0xF95B, 0xFBD9, 0xED95, 0x005D,
0xE9DC, 0xF55B, 0xF3E3, 0xF21E, 0xFFC8, 0xFB94, 0x0CBC, 0x02EA,
0x181C, 0x00F7, 0x1BB0, 0xFF48, 0x1B95, 0x04DB, 0x12DC, 0x08BA,
0xF4C5, 0x04BF, 0xDE84, 0x036C, 0xE803, 0x09E6, 0xF2C6, 0x0B7C,
0xFA4A, 0x0142, 0x04E9, 0xF841, 0x0625, 0xF71D, 0xFFE5, 0xF02B,
0xFA8E, 0xECFC, 0xF275, 0xF651, 0xEE76, 0xFD93, 0xFB78, 0x05C5,
0x0A72, 0x0A65, 0x135C, 0x0227, 0x1D56, 0x0366, 0x1FB2, 0x073C,
0x0B0C, 0xF626, 0xF300, 0xF3CA, 0xE8B0, 0x0B27, 0xE236, 0x1184,
0xE811, 0x06EC, 0xF6D9, 0x04B3, 0x0131, 0x0021, 0x0584, 0xF276,
0x038A, 0xEA99, 0xFF64, 0xE6FE, 0xFF11, 0xEC78, 0xFD88, 0x039A,
0xFA27, 0x1045, 0x005C, 0x08D3, 0x0ECF, 0x0ECC, 0x1C93, 0x12CD,
0x1552, 0xFCC8, 0xFEB8, 0xEE42, 0xF53F, 0xF4C2, 0xF1C2, 0xFEF4,
0xE662, 0x0349, 0xE106, 0x059D, 0xED1B, 0x08EB, 0xF93A, 0x05AB,
0x00A2, 0xF8AD, 0x09B3, 0xECD2, 0x0CDD, 0xEACD, 0x0B35, 0xF180,
0x0AB5, 0xF983, 0x019F, 0xFD2B, 0xF733, 0x0B38, 0x0232, 0x19DA,
0x092B, 0x13E4, 0xFE96, 0x02D7, 0xFF9D, 0xFA7C, 0x02F5, 0xFE43,
0xF66F, 0xF5F6, 0xF10E, 0xEC90, 0xF0E3, 0xF8DD, 0xE5AF, 0x03F4,
0xE6A3, 0x013A, 0xF549, 0x00E6, 0x0581, 0xFF36, 0x16FA, 0xFC36,
0x1CC9, 0xFE71, 0x12CD, 0xF4B8, 0x0B0B, 0xF1B6, 0x09B9, 0x0405,
0xFAA9, 0x10DF, 0xE950, 0x0C98, 0xEDD9, 0x0B0A, 0xFBB9, 0x1283,
0x0055, 0x05B6, 0xFF68, 0xEF4B, 0xFBA3, 0xEB5F, 0xF651, 0xECF9,
0xF0AC, 0xEB7C, 0xE6C9, 0xF728, 0xEC51, 0x06AB, 0x0332, 0x0E78,
0x1521, 0x1310, 0x1ED5, 0x061B, 0x1DE8, 0xF5FF, 0x13B6, 0xF57A,
0x088B, 0xF84E, 0xF698, 0xF6D4, 0xE363, 0x000E, 0xE3FA, 0x17FE,
0xEF75, 0x1E68, 0xF9F4, 0x0C86, 0x06E3, 0xFC39, 0x0A3C, 0xF19F,
0xFBE3, 0xE190, 0xF0CB, 0xDC9F, 0xF499, 0xE893, 0xF700, 0xFD5D,
0xFBDB, 0x1909, 0x0BE0, 0x214C, 0x1A0E, 0x1484, 0x21CB, 0x09C7,
0x1EAA, 0xFFB6, 0x056E, 0xEDA8, 0xEEB3, 0xE4D6, 0xED6C, 0xF467,
0xE6DE, 0x0ABD, 0xE07A, 0x1397, 0xEF79, 0x152E, 0x01B5, 0x140B,
0x0830, 0xFF63, 0x08B5, 0xE857, 0x026B, 0xE04D, 0xFDBE, 0xE30A,
0x0439, 0xF447, 0x0476, 0x0761, 0x01DC, 0x1694, 0x0C51, 0x234A,
0x1597, 0x20D7, 0x103A, 0x0BF6, 0x08CA, 0xF4A1, 0x00C4, 0xEA8F,
0xF175, 0xF107, 0xEAB0, 0xF447, 0xEB90, 0xF786, 0xEB10, 0x0EAC,
0xEFD8, 0x1960, 0xFAF8, 0x0C17, 0x0889, 0xFC97, 0x1471, 0xF047,
0x139B, 0xEC83, 0x0A4A, 0xEF5F, 0x0B49, 0xF47C, 0x0D22, 0x033D,
0x0543, 0x1B23, 0xFBBC, 0x25C2, 0xFAB8, 0x183E, 0x0475, 0x063E,
0x08BC, 0xFF61, 0xFC19, 0xEFF6, 0xEEEE, 0xE068, 0xF17C, 0xEB45,
0xF253, 0xF8DA, 0xEBBF, 0x05E1, 0xF27D, 0x16AC, 0x059E, 0x14DF,
0x1595, 0x0A26, 0x1F89, 0x01CF, 0x1C21, 0xEFFB, 0x0E9F, 0xE88B,
0x0A9A, 0xF847, 0x0018, 0x03E5, 0xED85, 0x0CBF, 0xF008, 0x1D11,
0xFC79, 0x2495, 0x0063, 0x13E5, 0x0482, 0xF7DC, 0x02BB, 0xE568,
0xF2E1, 0xDDF4, 0xE9D3, 0xE386, 0xEF87, 0xF0B7, 0xF7F2, 0x0250,
0xFF9D, 0x1CA6, 0x0D0E, 0x284E, 0x1B3F, 0x14F9, 0x2257, 0x0141,
0x2052, 0xF837, 0x0877, 0xED35, 0xEEAE, 0xEB5F, 0xEE6C, 0xF56D,
0xF3E7, 0x0B4D, 0xF087, 0x243F, 0xF41B, 0x23F8, 0xFFD2, 0x0C84,
0x064E, 0xF73E, 0xFFF3, 0xE6FC, 0xF2FC, 0xDC0B, 0xF517, 0xE091,
0xFF42, 0xF1C7, 0x05A7, 0x0BB5, 0x0B94, 0x21B4, 0x100B, 0x2641,
0x18F2, 0x1C04, 0x1AB6, 0x0A9F, 0x07A2, 0xF335, 0xF31C, 0xDF8D,
0xF0F8, 0xE753, 0xF333, 0xFBA3, 0xF351, 0x076D, 0xF54C, 0x1662,
0xF5B2, 0x1E0D, 0xF87B, 0x0CB0, 0xFE45, 0xF974, 0x0688, 0xEB76,
0x049E, 0xDCA7, 0x0124, 0xE70A, 0x0A6D, 0xFB06, 0x0F30, 0x062D,
0x1085, 0x1F5D, 0x0ECA, 0x30E0, 0x01E4, 0x1CC3, 0xFC5F, 0xFF9C,
0x0267, 0xF049, 0xFA39, 0xE537, 0xEFC6, 0xE57C, 0xF2B4, 0xF255,
0xF5A9, 0xFDE9, 0xF626, 0x0DAC, 0xF279, 0x1F8F, 0xF8B3, 0x1649,
0x092D, 0xFD0E, 0x1116, 0xF45C, 0x1045, 0xE94F, 0x0B21, 0xE1E4,
0x09CD, 0xF64C, 0x0D62, 0x0E8A, 0x06AE, 0x1C8C, 0xF634, 0x24F6,
0xF573, 0x1B45, 0xFECB, 0x05AE, 0x0128, 0xF471, 0xFBF5, 0xE2D8,
0xF198, 0xDC4A, 0xEF11, 0xE6BC, 0xF0D0, 0xF96B, 0xF7BB, 0x103C,
0x00C6, 0x1F4B, 0x03E1, 0x1D97, 0x10F5, 0x0C85, 0x1DC4, 0xF7AE,
0x15F3, 0xE9A2, 0x0A3A, 0xEC48, 0x01C9, 0xF955, 0xF5D4, 0x02CD,
0xF8E7, 0x11FB, 0xFBC3, 0x234B, 0xF346, 0x1CAF, 0xFA95, 0x056B,
0x018E, 0xF420, 0xFA06, 0xDF6F, 0xF0DC, 0xD7A8, 0xF13C, 0xEAE8,
0xFB9E, 0xFCFB, 0x06F1, 0x0FE3, 0x0FAA, 0x25EA, 0x10D3, 0x1FDB,
0x0FB3, 0x0865, 0x1387, 0x0243, 0x0DAB, 0xF6B5, 0xF90D, 0xE3D7,
0xF3C4, 0xEE0D, 0xF9A5, 0x0342, 0xFAF4, 0x0D71, 0x0054, 0x1A47,
0xF80A, 0x1BA6, 0xEEA6, 0x00AC, 0xF647, 0xED0B, 0xF9C4, 0xE696,
0xF91C, 0xDDD3, 0xFEBF, 0xEAF8, 0x0933, 0x0598, 0x18B2, 0x10EA,
0x1F2A, 0x1A3D, 0x0FA7, 0x261E, 0x0150, 0x18DF, 0xFDD8, 0xFCB0,
0xFC79, 0xEC5D, 0xF97D, 0xE7F7, 0xF53C, 0xEBD9, 0xF9B8, 0xF73E,
0x006B, 0x086E, 0xFE6D, 0x1401, 0xF144, 0x12C8, 0xE918, 0x04B0,
0xF634, 0xF4A9, 0x033A, 0xED92, 0x05BD, 0xEB3F, 0x1009, 0xED80,
0x19BF, 0xF8EC, 0x1785, 0x101D, 0x135A, 0x25A0, 0xFEBB, 0x2361,
0xEA2F, 0x0C1D, 0xF408, 0xFE4C, 0xFCDC, 0xF572, 0xFA9E, 0xE273,
0xFE36, 0xE359, 0xFB86, 0xF5C9, 0xF5E9, 0x0188, 0xFBBC, 0x0DD0,
0xF95E, 0x1501, 0xEEAB, 0x0B80, 0xF835, 0x02BE, 0x104D, 0xF8F3,
0x1BB3, 0xE7C6, 0x19D8, 0xECC2, 0x1439, 0x063A, 0x05EB, 0x142C,
0xFF2A, 0x1435, 0xFC9F, 0x198B, 0xEAC9, 0x1480, 0xEA27, 0xF904,
0xFF1A, 0xE940, 0xFFC9, 0xE6D5, 0xF6AB, 0xE358, 0xFA50, 0xEECA,
0xFD01, 0x02E7, 0x0231, 0x0F96, 0x02DA, 0x1D0C, 0xF9F4, 0x1741,
0x03C0, 0xFC3A, 0x190C, 0xF396, 0x1A5E, 0xF82E, 0x0B4A, 0xF90E,
0x02AD, 0xFAF9, 0x0136, 0x0867, 0x015B, 0x1AA4, 0xFC33, 0x18AE,
0xEE9A, 0x0668, 0xE805, 0xF743, 0xEED6, 0xECBB, 0xF7CE, 0xE5B9,
0xFC93, 0xE4D2, 0x04E9, 0xEE1D, 0x071F, 0x0A7F, 0x099C, 0x1D94,
0x13D9, 0x1602, 0x0BBB, 0x0E7E, 0x0011, 0x086B, 0x01DC, 0x012D,
0xFF73, 0xF5BC, 0xFEDC, 0xEC8C, 0x0599, 0xFA33, 0x0128, 0x0AB7,
0x00BB, 0x0AF3, 0x02FF, 0x0B2E, 0xE99A, 0x0821, 0xD873, 0xF829,
0xEA09, 0xEC47, 0xFF63, 0xE82E, 0x05E6, 0xEF95, 0x0C35, 0xFEEC,
0x15AA, 0x073F, 0x19A2, 0x1088, 0x1B28, 0x192F, 0x0509, 0x190C,
0xE45B, 0x08E0, 0xE9B6, 0xF30F, 0x008C, 0xF379, 0x03D7, 0xF936,
0x08BC, 0xF199, 0x0CA8, 0xF8D9, 0xFC71, 0x0BB6, 0xF17E, 0x0B28,
0xE837, 0x00C2, 0xDCFD, 0xF452, 0xE9D9, 0xEF5C, 0x0300, 0xFA33,
0x1316, 0xF8BD, 0x1F70, 0xF47A, 0x26CC, 0x07B6, 0x1A4B, 0x1D81,
0x0201, 0x1C66, 0xECCD, 0x097F, 0xDEB0, 0xFD54, 0xE24C, 0xF9A0,
0xF995, 0xEF53, 0x0BBD, 0xE8F8, 0x0AD4, 0xF10B, 0x0384, 0xFD4B,
0xFA61, 0x0867, 0xF672, 0x084B, 0xF2D3, 0x0181, 0xE59A, 0x047C,
0xEB75, 0xFC5A, 0x0A40, 0xEF51, 0x2077, 0xF771, 0x25CB, 0x03F0,
0x1ACD, 0x0D92, 0x03A7, 0x12F0, 0xF799, 0x0F41, 0xEF9F, 0x0B01,
0xDF31, 0xFE1A, 0xE19B, 0xE917, 0xF76E, 0xE689, 0x0075, 0xF0B8,
0x0207, 0xF299, 0x0885, 0xF5CF, 0x06C4, 0x0446, 0xFE93, 0x1495,
0xF942, 0x102E, 0xF32C, 0xFCD5, 0xF510, 0xF594, 0x0B57, 0xFB1D,
0x192B, 0x04BA, 0x1030, 0x0478, 0x0CF3, 0x002D, 0x0865, 0x0DE7,
0xF907, 0x141D, 0xF13B, 0xFD64, 0xE70D, 0xEDD1, 0xD934, 0xEED2,
0xE4AA, 0xEC32, 0xFCD9, 0xEDA5, 0x0B73, 0xF480, 0x1567, 0x0218,
0x1346, 0x14C1, 0x0975, 0x154C, 0x03AA, 0x060F, 0xFE2B, 0xFFD1,
0xF4F6, 0x0300, 0xF2CF, 0xFE43, 0x0112, 0xF962, 0x0EF3, 0x00D4,
0x126B, 0x0770, 0x0D12, 0x05F5, 0xFF1B, 0x048E, 0xEDC0, 0xFF27,
0xDD46, 0xF2E4, 0xD3B0, 0xE9DF, 0xE2B9, 0xE732, 0x053E, 0xF3E4,
0x190A, 0x0837, 0x20A7, 0x0C3D, 0x2361, 0x0B88, 0x1791, 0x14D2,
0x0769, 0x1588, 0xF24F, 0x063D, 0xDC82, 0xF83A, 0xE301, 0xF33A,
0x0090, 0xF9D0, 0x1120, 0xFF5E, 0x15BE, 0xFB56, 0x1403, 0x013B,
0xFF01, 0x0BC3, 0xE648, 0x00F6, 0xDB5B, 0xEC5F, 0xDC77, 0xEBD5,
0xE9CA, 0xF642, 0x06C3, 0xFEB8, 0x21A8, 0x0537, 0x2B36, 0x082E,
0x2D3D, 0x1421, 0x1965, 0x1ED9, 0xF2A8, 0x1094, 0xE02C, 0xF8AA,
0xE01E, 0xF2CB, 0xE34A, 0xF1EE, 0xF726, 0xEEB0, 0x10F1, 0xF8E0,
0x1614, 0x036A, 0x0F63, 0x0395, 0x00E3, 0x0367, 0xEE48, 0x01C0,
0xE8A7, 0xF8E6, 0xEA97, 0xF722, 0xF2BD, 0xF8B3, 0x09FD, 0xF831,
0x281A, 0x0B60, 0x3146, 0x1CCE, 0x1F99, 0x16A8, 0x0766, 0x1123,
0xF1E1, 0x0B9F, 0xE3A2, 0xF688, 0xDC7B, 0xE7D8, 0xDFA0, 0xE805,
0xF266, 0xEECD, 0x0A27, 0xFE95, 0x1303, 0x038F, 0x1227, 0x0258,
0x0FA4, 0x0BA0, 0xFE18, 0x0F9C, 0xEF4D, 0x009F, 0xEEC0, 0xEED7,
0xF549, 0xF3E4, 0x09CE, 0x0588, 0x1C6B, 0x1250, 0x1AF7, 0x15A3,
0x1837, 0x1193, 0x14F2, 0x0DA6, 0xF6F0, 0x052F, 0xDCB0, 0xEFF2,
0xDC3D, 0xE30C, 0xDD33, 0xE9DB, 0xE769, 0xECA4, 0x0360, 0xF7E5,
0x1B28, 0x0B0F, 0x2334, 0x1066, 0x213E, 0x1511, 0x0B33, 0x0F5D,
0xF2A7, 0xFAE9, 0xF484, 0xF800, 0xF58B, 0x006F, 0xEE77, 0xFDC3,
0x02BF, 0x0643, 0x20C9, 0x1425, 0x1E0C, 0x0E8D, 0x0F6A, 0x05BF,
0xFD2E, 0x0111, 0xDF74, 0xF527, 0xD38F, 0xE4C1, 0xD81F, 0xE2F8,
0xE506, 0xED1B, 0x06F4, 0xFE79, 0x27FC, 0x1760, 0x2C0A, 0x1A75,
0x2432, 0x0C9A, 0x1791, 0x103F, 0xFCE2, 0x0F5B, 0xE2F1, 0xF77F,
0xDAB7, 0xEFE4, 0xEAFD, 0xF838, 0x04FA, 0x0035, 0x16CC, 0x0D16,
0x1C9F, 0x0D6A, 0x16C3, 0x070A, 0xFF41, 0x0266, 0xDE94, 0xF356,
0xD38E, 0xE382, 0xE065, 0xE4BE, 0xF395, 0xF606, 0x0BDE, 0x098D,
0x25F9, 0x139C, 0x31AE, 0x1987, 0x314B, 0x20BA, 0x170B, 0x17DB,
0xE39A, 0x010E, 0xD446, 0xEE9E, 0xE2B3, 0xE943, 0xE507, 0xEDE9,
0xF6D5, 0xF789, 0x19DB, 0x0B8B, 0x1E96, 0x1491, 0x113F, 0x0804,
0x04E5, 0xFEB3, 0xE908, 0xF727, 0xDC85, 0xEB80, 0xE963, 0xEDAB,
0xF366, 0xF4D9, 0x065F, 0xFE1C, 0x2D52, 0x1D96, 0x3AD8, 0x2E70,
0x1E07, 0x1A00, 0x061C, 0x0859, 0xF152, 0xFFA4, 0xD5C9, 0xEC90,
0xD406, 0xDDD8, 0xE671, 0xE61C, 0xF3D5, 0xF7FD, 0x0931, 0x07AD,
0x1E52, 0x1175, 0x1B31, 0x0C9A, 0x120C, 0x035B, 0xFE1E, 0x0287,
0xE38B, 0xF77D, 0xE469, 0xE64D, 0xF98F, 0xF56D, 0x0C97, 0x114F,
0x1672, 0x18F6, 0x1B2A, 0x1A4F, 0x1D01, 0x16E8, 0x11AB, 0x08BF,
0xF005, 0xF764, 0xD68D, 0xE882, 0xD84D, 0xE16C, 0xDCB9, 0xE62F,
0xE9E6, 0xF288, 0x0884, 0x03F1, 0x2323, 0x1407, 0x2970, 0x16F6,
0x1E6F, 0x0F36, 0x04C9, 0x011E, 0xEB86, 0xF710, 0xEFD4, 0xF87A,
0xF68B, 0xFA5B, 0xED3A, 0xFC7F, 0x005B, 0x0A31, 0x22FB, 0x1BF3,
0x1FF3, 0x171F, 0x0F2D, 0x01EA, 0xFF6A, 0xF88C, 0xD970, 0xF150,
0xCA73, 0xDF6A, 0xDF6A, 0xDC51, 0xEFE7, 0xF0F3, 0x09C0, 0x06D2,
0x2AA9, 0x1BB9, 0x2F51, 0x21C9, 0x22ED, 0x10FF, 0x17D5, 0x0CA8,
0xF8CF, 0x0AB0, 0xD5E8, 0xEEC2, 0xD7A7, 0xE10F, 0xECA7, 0xF681,
0xFEE4, 0x068D, 0x1675, 0x0D8C, 0x2774, 0x1774, 0x1A66, 0x0FAF,
0xFCE4, 0xFB70, 0xE037, 0xEE6B, 0xD0F4, 0xE2EA, 0xE221, 0xDDA3,
0xF9AB, 0xF2CA, 0x07C2, 0x0D17, 0x2178, 0x1826, 0x3892, 0x26E4,
0x350B, 0x28FB, 0x1477, 0x0D7B, 0xE235, 0xF635, 0xCA7F, 0xEC38,
0xDC22, 0xE17A, 0xE930, 0xE868, 0xF6D7, 0xFEF1, 0x177B, 0x108D,
0x23AF, 0x1A7D, 0x17A2, 0x0E37, 0x07C2, 0xF846, 0xEF1E, 0xF163,
0xDD61, 0xEBA0, 0xE5A1, 0xE5CA, 0xF6BF, 0xF375, 0x088D, 0x0E04,
0x26D0, 0x252B, 0x3761, 0x2D81, 0x1F12, 0x1ACC, 0x0116, 0x0174,
0xEDB7, 0xF556, 0xD375, 0xE801, 0xD27B, 0xDA94, 0xEE4A, 0xE675,
0xF94D, 0x02F1, 0x0514, 0x0DB6, 0x1F0B, 0x10FB, 0x219A, 0x1200,
0x144F, 0x00D9, 0x00C0, 0xF706, 0xE334, 0xF76A, 0xE22F, 0xEBDE,
0xFDC5, 0xF5AA, 0x0E35, 0x15AD, 0x0F24, 0x1AD8, 0x12F3, 0x179E,
0x1B0D, 0x1785, 0x11B4, 0x017F, 0xF2E3, 0xEF36, 0xD906, 0xECA0,
0xD72D, 0xE4E6, 0xE476, 0xE40B, 0xF1EC, 0xF618, 0x00BC, 0x06D6,
0x1B42, 0x0ECD, 0x2E14, 0x157B, 0x20D2, 0x10DF, 0x0756, 0x027F,
0xF049, 0xFDD8, 0xE81D, 0xFAAA, 0xF245, 0xF235, 0xF06B, 0xFD03,
0xF3C8, 0x0D86, 0x130E, 0x0CF6, 0x2246, 0x0DB8, 0x143B, 0x08A3,
0x0221, 0xF967, 0xE500, 0xF247, 0xD046, 0xE672, 0xDD37, 0xDBC8,
0xF00B, 0xECB3, 0x029B, 0x0631, 0x1CD4, 0x1540, 0x2DAF, 0x1EE1,
0x2827, 0x1996, 0x13C1, 0x0C30, 0xF999, 0x0433, 0xD771, 0xF54D,
0xCD8B, 0xE49A, 0xEA20, 0xEA44, 0xFE02, 0xFFFB, 0x06F9, 0x0BB5,
0x1E24, 0x0F55, 0x2262, 0x0EEB, 0x070C, 0xFFBF, 0xE972, 0xEDF3,
0xD176, 0xE3E6, 0xD89C, 0xDD57, 0xFAF0, 0xECAD, 0x0AF9, 0x0F92,
0x14CF, 0x1CF2, 0x28CD, 0x1C42, 0x30D0, 0x1FA9, 0x162E, 0x10E1,
0xE490, 0xF955, 0xCADE, 0xE88A, 0xD729, 0xDB33, 0xEB11, 0xE49E,
0xF7D8, 0x0163, 0x07DF, 0x0EFA, 0x1A42, 0x0FC6, 0x2085, 0x0DF8,
0x0AA3, 0xFE72, 0xEBAB, 0xED49, 0xE1DE, 0xEA58, 0xE7A1, 0xEEB7,
0xF810, 0xF6BA, 0x0682, 0x0A89, 0x119C, 0x1DA3, 0x2280, 0x1F66,
0x1D03, 0x18AC, 0x011B, 0x05D4, 0xF051, 0xECB5, 0xE004, 0xE5EB,
0xD1D2, 0xE527, 0xE605, 0xE3C0, 0xFE9C, 0xFA05, 0x0550, 0x0F48,
0x1090, 0x0823, 0x17C6, 0x03A8, 0x1425, 0x0564, 0x0A30, 0xFFAE,
0xF59B, 0xFD44, 0xE31F, 0xF7D1, 0xED48, 0xF298, 0x0729, 0x0639,
0x0736, 0x1B46, 0xFE72, 0x107B, 0x113C, 0x01CD, 0x19FA, 0x0233,
0xFDA6, 0xFBEF, 0xE3DD, 0xED8C, 0xDAAA, 0xE8E6, 0xE2D4, 0xEB40,
0xF80C, 0xF248, 0xFADB, 0xFF5C, 0x014C, 0x04CE, 0x2398, 0x0B43,
0x2F45, 0x1798, 0x1259, 0x0FCD, 0xF400, 0xFC14, 0xE644, 0xF908,
0xE756, 0xF9C5, 0xEA92, 0xF86B, 0xEF55, 0xFFE3, 0x041E, 0x0306,
0x1942, 0x05D1, 0x19C2, 0x0A2C, 0x092C, 0x0053, 0xF468, 0xF591,
0xE36F, 0xEFFC, 0xDBF5, 0xE3C4, 0xE755, 0xE671, 0x021C, 0x039F,
0x19CA, 0x1851, 0x26CA, 0x19F0, 0x25F5, 0x180F, 0x13DF, 0x11DD,
0xFE59, 0x06C3, 0xE194, 0xF9C4, 0xCBFE, 0xE87B, 0xE311, 0xE315,
0x016A, 0xFB7E, 0x04F5, 0x0CD5, 0x0F6C, 0x04D3, 0x1F74, 0x0A69,
0x162A, 0x0F9C, 0xFB2D, 0xF5C2, 0xDD91, 0xE26E, 0xD6DC, 0xE860,
0xF748, 0xF52A, 0x1168, 0x0BE2, 0x1051, 0x19E6, 0x13C2, 0x14A1,
0x231C, 0x1954, 0x1A83, 0x1A10, 0xF231, 0xFE85, 0xD932, 0xE53D,
0xDBC7, 0xE528, 0xE850, 0xED28, 0xF7C7, 0xF571, 0x0325, 0x0436,
0x117F, 0x0EBC, 0x20A5, 0x0B29, 0x1502, 0x021C, 0xFB4C, 0xFA0B,
0xF5E8, 0xF640, 0xF388, 0xFA76, 0xF1AE, 0xFDBC, 0xFC52, 0x031A,
0x0691, 0x13C9, 0x1165, 0x19DC, 0x1477, 0x0F20, 0x09AF, 0x0514,
0xFFED, 0xFAA9, 0xF543, 0xF229, 0xE177, 0xEB41, 0xDD22, 0xE747,
0xF4E9, 0xF78E, 0x086A, 0x08D2, 0x0B05, 0x0146, 0x1006, 0xFF1B,
0x1D05, 0x0ED1, 0x1B55, 0x1087, 0x05BC, 0x0407, 0xED2B, 0xFB93,
0xE236, 0xFBCA, 0xF2F3, 0x0490, 0x015E, 0x0BC4, 0xFCAD, 0x05E4,
0x0878, 0xFFC4, 0x1D21, 0x0A3A, 0x1188, 0x07C4, 0xF4FB, 0xEFCD,
0xE601, 0xEC7B, 0xE48D, 0xF642, 0xF01C, 0xF0F7, 0xFB86, 0xF4F6,
0x07EA, 0x0850, 0x1F52, 0x122A, 0x2BA3, 0x1A1E, 0x1C62, 0x18CC,
0xFF1B, 0x05EC, 0xEBBB, 0xFDD0, 0xE2F0, 0xFCEA, 0xE138, 0xF370,
0xEEC9, 0xF406, 0x0611, 0x041E, 0x15C7, 0x0893, 0x177E, 0x0352,
0x1075, 0x05CE, 0x0338, 0x018B, 0xF253, 0xEFD2, 0xE04C, 0xE57D,
0xE3FE, 0xEF45, 0x024A, 0x021B, 0x1663, 0x121B, 0x1A7C, 0x1628,
0x1BBF, 0x1675, 0x15F0, 0x1AF5, 0x062B, 0x0F6F, 0xED56, 0xF62D,
0xD5F3, 0xE8E6, 0xDCC0, 0xEEB5, 0xF9DF, 0xFA75, 0x0559, 0xFED9,
0x08A7, 0xFF08, 0x1764, 0x0A7B, 0x1C83, 0x1098, 0x09A6, 0xFB6B,
0xF412, 0xEC8C, 0xEC97, 0xF586, 0xF0D5, 0xFFDA, 0xFD8D, 0x0593,
0x06F5, 0x0DB6, 0x0C19, 0x1372, 0x171A, 0x175D, 0x1728, 0x162B,
0xFEC0, 0x0055, 0xECCC, 0xEDEC, 0xEA10, 0xF0F3, 0xE3FB, 0xF0D1,
0xE94E, 0xED8D, 0xFD65, 0xFBDA, 0x0DB3, 0x06C3, 0x162B, 0x01B8,
0x17DC, 0x0646, 0x117E, 0x09FD, 0x072E, 0x01F8, 0xF7E5, 0xFE02,
0xE6F5, 0xFFA7, 0xE9B8, 0x020B, 0xFEDD, 0x0B55, 0x0C1C, 0x107C,
0x0A11, 0x057C, 0x0AD8, 0x04BA, 0x0D12, 0x08AD, 0x0061, 0xF96E,
0xE9FF, 0xE94D, 0xDCF1, 0xEBEC, 0xE992, 0xF50B, 0xFF32, 0xF7FA,
0x0A81, 0xFB89, 0x155D, 0x0507, 0x21CC, 0x1568, 0x1E33, 0x17F8,
0x0760, 0x075E, 0xEE6A, 0xFCBD, 0xE16F, 0xFE5F, 0xE8C3, 0x0074,
0xF3AC, 0xFB89, 0xFA4F, 0xFA35, 0x0B90, 0x02BC, 0x1B18, 0x0CB6,
0x124E, 0x0697, 0xFC52, 0xF650, 0xF0F4, 0xF068, 0xE803, 0xED6A,
0xE6EC, 0xEB78, 0xF98E, 0xF580, 0x0DFE, 0x0726, 0x1CBA, 0x1177,
0x21F4, 0x1859, 0x139B, 0x187D, 0x0025, 0x0B92, 0xF849, 0x01FF,
0xE665, 0xF7A0, 0xD7A8, 0xEC40, 0xEA9D, 0xF329, 0x04DC, 0x0157,
0x1066, 0x0019, 0x12CA, 0x032A, 0x11B4, 0x0BFD, 0x08E0, 0xFE35,
0xFB21, 0xECF0, 0xECF2, 0xED76, 0xE98D, 0xF6FB, 0xFB20, 0x02D9,
0x0BFC, 0x0C38, 0x0F7A, 0x0DA1, 0x1135, 0x1416, 0x15AF, 0x1C28,
0x0A4A, 0x0C05, 0xF29B, 0xF399, 0xE227, 0xEDD8, 0xE08B, 0xF293,
0xF05E, 0xF417, 0xFD23, 0xF99A, 0x074A, 0x0124, 0x1801, 0x0540,
0x1BC7, 0x07DE, 0x0E13, 0x00DC, 0x042C, 0xFA06, 0xFAF5, 0xFE58,
0xEEFD, 0x01CF, 0xF17A, 0x00A6, 0xF918, 0x07C4, 0x084F, 0x1048,
0x19DF, 0x11E6, 0x137D, 0x0EA4, 0xFFE9, 0x021D, 0xF7D5, 0xF8A6,
0xF32A, 0xF2F6, 0xE3E1, 0xECB3, 0xE449, 0xF060, 0xFA65, 0xF91A,
0x0DAA, 0xF9CF, 0x1A0F, 0xFE8D, 0x1F99, 0x0F06, 0x16D9, 0x1312,
0x0A79, 0x0A55, 0xFBC9, 0x0184, 0xE1E1, 0xFC24, 0xE1E1, 0xFFDF,
0xFB26, 0x0724, 0x0715, 0x047C, 0x0CA2, 0x0187, 0x1204, 0x0C78,
0x0D99, 0x0AF5, 0x016D, 0xF9FF, 0xF17E, 0xF301, 0xE352, 0xF12B,
0xE8CD, 0xEBC6, 0xFA2D, 0xF0D0, 0x0B1D, 0xFFB2, 0x1E61, 0x0C3D,
0x26A1, 0x1C35, 0x1975, 0x1AF2, 0x0109, 0x06FF, 0xF238, 0x010D,
0xE862, 0x004A, 0xE3A3, 0xF5A5, 0xECFA, 0xF30F, 0xFA5C, 0xFD5A,
0x0DB9, 0x0387, 0x1B63, 0x0853, 0x0EC8, 0x082C, 0xFE06, 0xFDBA,
0xFB49, 0xF19C, 0xEF6D, 0xE98A, 0xE8DE, 0xECA1, 0xFAEC, 0xFA86,
0x0DF1, 0x0CBA, 0x1B8B, 0x1456, 0x1C8B, 0x14C6, 0x0E41, 0x1740,
0x01F4, 0x106E, 0xF8F5, 0x008E, 0xE82D, 0xF28F, 0xDD29, 0xED66,
0xE9E5, 0xF378, 0xFEDB, 0xFD00, 0x0DC7, 0xFEF4, 0x16D4, 0x0544,
0x150A, 0x09CA, 0x06DF, 0xFB39, 0xFC77, 0xF1A9, 0xF636, 0xF601,
0xF0BF, 0xFCCC, 0xF935, 0x042F, 0x0229, 0x06F9, 0x0A53, 0x0A03,
0x1966, 0x15E1, 0x146C, 0x16F2, 0xFE20, 0x039F, 0xF28E, 0xF605,
0xE8CB, 0xF427, 0xE120, 0xF09C, 0xE9B0, 0xEE12, 0xF788, 0xF57C,
0x0B53, 0xFE85, 0x1E1D, 0x0216, 0x1998, 0x052C, 0x0A51, 0x0427,
0x04AB, 0x03F9, 0xFE3D, 0x07E7, 0xED3D, 0xFF3D, 0xE7C7, 0xF668,
0xF94B, 0x03D4, 0x0A7D, 0x0DED, 0x129E, 0x0A5B, 0x1146, 0x0901,
0x0144, 0x03C9, 0xF4DD, 0xFC38, 0xEE16, 0xF503, 0xE39B, 0xEA2A,
0xE79F, 0xE7D8, 0xF94A, 0xF14E, 0x08E7, 0xF8D1, 0x19D2, 0x026C,
0x21C3, 0x12A2, 0x15EC, 0x1954, 0x0383, 0x0D18, 0xF1CC, 0xFCC9,
0xE943, 0xF99B, 0xEB0E, 0xFA5E, 0xEF9D, 0xFA4F, 0xFD81, 0xFE13,
0x0FBF, 0x0439, 0x1477, 0x0C23, 0x0622, 0x0945, 0xF6AE, 0xF975,
0xF187, 0xEEAA, 0xEDD0, 0xEBB6, 0xEB13, 0xE8D4, 0xF38B, 0xEE46,
0x09CC, 0x010C, 0x212C, 0x17CB, 0x246A, 0x2034, 0x0D12, 0x1213,
0xFB18, 0x0505, 0xF64B, 0x0232, 0xE933, 0xFA19, 0xE1BB, 0xEE3A,
0xEC20, 0xEEBF, 0xFE3D, 0xFD52, 0x0E94, 0x0A5C, 0x1563, 0x0A37,
0x0C90, 0xFFF8, 0xFF15, 0xF781, 0xF4ED, 0xF2BB, 0xEBCB, 0xED32,
0xEDE7, 0xEDC5, 0xFCEC, 0xFE5C, 0x0D8B, 0x0FFF, 0x15A7, 0x1306,
0x1958, 0x1237, 0x1513, 0x1180, 0xFEC6, 0x09C6, 0xE8B4, 0xFBA4,
0xE452, 0xF01D, 0xE7F0, 0xEDF6, 0xEACA, 0xF40F, 0xF7C1, 0xFADF,
0x0DA8, 0xFF6C, 0x1CDC, 0x02E9, 0x1659, 0x028D, 0xFF3B, 0xFD43,
0xF2E4, 0xF774, 0xF7BC, 0xFCBB, 0xFB65, 0x0476, 0xF550, 0x014E,
0xFC49, 0x0030, 0x1495, 0x0BC8, 0x1E6F, 0x1621, 0x0D81, 0x0F05,
0xF852, 0x00FC, 0xEF27, 0xF94A, 0xEB4E, 0xF6AC, 0xE97F, 0xF0E2,
0xEAD1, 0xEA6C, 0xFA51, 0xED70, 0x11EE, 0xFBA1, 0x1938, 0x0902,
0x1220, 0x07A1, 0x0ABE, 0x080F, 0x031B, 0x0D8C, 0xF780, 0x0748,
0xF127, 0xFA13, 0xF459, 0xF3C4, 0xFEB5, 0xFB6A, 0x084D, 0x0966,
0x0D70, 0x0E6D, 0x0F18, 0x09D2, 0x033B, 0x07F5, 0xF04A, 0xFFFA,
0xE9B5, 0xF183, 0xF16E, 0xE90F, 0xF617, 0xE64C, 0xF8BC, 0xEE4E,
0x06FA, 0xFF01, 0x1B81, 0x1144, 0x2406, 0x1B03, 0x1276, 0x1798,
0xF917, 0x0B49, 0xF249, 0xFC6F, 0xF844, 0xF558, 0xF31F, 0xF505,
0xEDA4, 0xF529, 0xFF50, 0xFEBB, 0x12C5, 0x1059, 0x116A, 0x0E49,
0x0337, 0x00FC, 0xF574, 0xF8C0, 0xF14A, 0xEDA6, 0xF3F4, 0xEA25,
0xF034, 0xED77, 0xF6BA, 0xF471, 0x128A, 0x0A50, 0x223E, 0x1F66,
0x1C12, 0x1D75, 0x0F72, 0x0EBF, 0xFEEB, 0x025B, 0xEFD5, 0xFBAA,
0xEAA6, 0xF557, 0xEB71, 0xEF6C, 0xF0B6, 0xF53B, 0xFE39, 0xFFD2,
0x0CA7, 0x06D4, 0x1343, 0x06F3, 0x0EDE, 0xFDE6, 0xFD49, 0xF66A,
0xEA8D, 0xF435, 0xEFD4, 0xF45F, 0x0009, 0xF97C, 0x01A5, 0x00F8,
0x076D, 0x0BE0, 0x1622, 0x1666, 0x19FC, 0x1163, 0x1048, 0x09DA,
0xF91D, 0x04D8, 0xE560, 0xF954, 0xEA6E, 0xF601, 0xF294, 0xF4FD,
0xEF37, 0xED81, 0xF8AC, 0xF31A, 0x0EC1, 0x01C3, 0x15FC, 0x055B,
0x0966, 0x04E3, 0xFA5A, 0x044C, 0xF78F, 0x01F6, 0xFE04, 0x0165,
0x00FF, 0x0094, 0xFEC8, 0xFE11, 0x028E, 0xFC82, 0x0E3E, 0x0763,
0x111A, 0x11EC, 0x0664, 0x0BCD, 0xF74B, 0x0535, 0xEBB8, 0x0080,
0xEBAB, 0xF30A, 0xF1E3, 0xE83D, 0xF705, 0xE704, 0x006C, 0xED19,
0x0959, 0x0034, 0x0CC1, 0x1123, 0x13EB, 0x12A8, 0x0DB5, 0x0D83,
0xF996, 0x0A8E, 0xF945, 0x0663, 0xFFFE, 0xF75C, 0xFAE2, 0xEE2A,
0xFB75, 0xF8A0, 0x045F, 0x0713, 0x082E, 0x0FD0, 0x0868, 0x11E1,
0xFEB0, 0x0625, 0xEBE4, 0xF619, 0xEC80, 0xED90, 0xFAA9, 0xE699,
0xF9A6, 0xE81C, 0xF7BB, 0xF8E9, 0x0BA5, 0x0BE4, 0x1A77, 0x1513,
0x168C, 0x18F7, 0x0E49, 0x16E1, 0xFDDF, 0x065E, 0xF1DA, 0xF48D,
0xF5FA, 0xEFFE, 0xF93C, 0xF273, 0xF58D, 0xF8F7, 0xFBEA, 0x05C5,
0x075C, 0x0DED, 0x0764, 0x0A56, 0xFED2, 0xFDE2, 0xF4CE, 0xF119,
0xF153, 0xEE1E, 0xF558, 0xF30C, 0xFF6D, 0xF7E5, 0x07DB, 0xFB86,
0x0BA7, 0x08D9, 0x1335, 0x1C39, 0x1756, 0x1C8A, 0x0900, 0x0833,
0xF3D9, 0xFADA, 0xF06F, 0xFA6B, 0xF529, 0xF684, 0xF678, 0xF250,
0xFA59, 0xF6AE, 0xFE1F, 0xFD54, 0xFFCF, 0x0171, 0x05A2, 0x030A,
0x05AF, 0xFE63, 0xF733, 0xFD83, 0xF4EE, 0x0332, 0x0318, 0xFB19,
0x0901, 0xF307, 0x093D, 0x012A, 0x0CED, 0x0D31, 0x0A70, 0x09C6,
0x04FE, 0x09AA, 0x029D, 0x0C1D, 0xF73D, 0x06F3, 0xECAD, 0xFDA5,
0xF355, 0xF425, 0xFD34, 0xEDD8, 0xFAC9, 0xECE4, 0xF8F0, 0xF0DA,
0x002F, 0xFAAD, 0x06B6, 0x0A91, 0x0893, 0x157E, 0x0492, 0x0CB5,
0xFF28, 0xFEDB, 0x02B6, 0xFF2F, 0x0BDF, 0xFEF0, 0x081D, 0xF6BF,
0xFCAF, 0xF519, 0xFDBB, 0x0335, 0x0519, 0x159A, 0x014C, 0x13D8,
0xF793, 0x042A, 0xF5B0, 0xFB06, 0xF519, 0xF00A, 0xF67C, 0xE2FF,
0xFB2F, 0xE52B, 0xFBD0, 0xF3E9, 0x00FE, 0x0A7D, 0x0D69, 0x19B1,
0x10A5, 0x136B, 0x0946, 0x0D62, 0x04E5, 0x0BA7, 0x0124, 0xFC6F,
0xFD60, 0xE89C, 0xFDA5, 0xEB1B, 0xFB9C, 0xFF9D, 0xF74B, 0x0B60,
0xFCEA, 0x0DBD, 0x0606, 0x0EF4, 0xFF63, 0x064D, 0xF2F8, 0xF4BE,
0xF19D, 0xE9E4, 0xFB20, 0xE791, 0x0568, 0xF367, 0x0694, 0x03D1,
0x0555, 0x0993, 0x0C34, 0x1367, 0x115D, 0x1D79, 0x0A0F, 0x14C4,
0xFCF9, 0xFBD6, 0xF703, 0xECF8, 0xFCF6, 0xF39B, 0xFEC7, 0xFA20,
0xF7F0, 0xF6F6, 0xF948, 0xFDD1, 0x00FC, 0x0B14, 0xFE9B, 0x088F,
0xF793, 0x0032, 0xF771, 0xF938, 0xFB60, 0xF652, 0x057A, 0xF849,
0x0F50, 0xF85B, 0x0CA6, 0xFBED, 0x0602, 0x09BB, 0x07CA, 0x1774,
0x0688, 0x1130, 0xFF97, 0x04A3, 0xFCB1, 0x0424, 0xF710, 0x027D,
0xF734, 0xF438, 0x02F5, 0xEC90, 0x045D, 0xF364, 0xF603, 0xF8BC,
0xF348, 0xFF97, 0xFDC3, 0x0895, 0x0272, 0x0E67, 0x04A9, 0x0A72,
0x062D, 0x0025, 0x0BB0, 0xF893, 0x118A, 0xF758, 0x09DB, 0xFDDF,
0xFC06, 0xFFFA, 0xFAE9, 0x0081, 0x00ED, 0x0CA8, 0xFE58, 0x19EF,
0xF974, 0x0CBA, 0xF941, 0xF505, 0x001C, 0xEE9D, 0x0257, 0xEAB9,
0xF7EC, 0xE82C, 0xF0EF, 0xF414, 0xF892, 0x07FE, 0x0472, 0x1319,
0x0A3D, 0x17C7, 0x0F6E, 0x120B, 0x0D55, 0x00CE, 0x0662, 0xF9DB,
0x06D0, 0xF582, 0x039F, 0xEB91, 0xF7D7, 0xF401, 0xF3EC, 0x0EAC,
0xF902, 0x1736, 0xFD0A, 0x0F95, 0x02BE, 0x0739, 0xFF59, 0xF6E7,
0xF66C, 0xE981, 0xFC57, 0xE83E, 0x033E, 0xF02E, 0xFC5A, 0xFBAC,
0xFBDB, 0x0A2D, 0x0AC3, 0x16D3, 0x11CB, 0x18C8, 0x0A1F, 0x11F1,
0x00FE, 0x02F8, 0xFFEE, 0xF0C9, 0x03AE, 0xE9DB, 0xFFE0, 0xF3E7,
0xF3D3, 0xFF15, 0xEF62, 0x0401, 0xFA11, 0x08DD, 0x00D5, 0x0BD2,
0xFA18, 0x0487, 0xF65A, 0xF602, 0xFD9D, 0xF285, 0x057A, 0xF3BD,
0x0795, 0xF2BC, 0x06BD, 0xFD8F, 0x0687, 0x0A45, 0x04E3, 0x1052,
0x011F, 0x15F3, 0x01A2, 0x0D3B, 0x0118, 0xF9AE, 0xFB64, 0xF59B,
0xFA5D, 0xF838, 0xFCD5, 0xF179, 0xF961, 0xF062, 0xF3D8, 0xFAE7,
0xF181, 0x02B3, 0xF596, 0x0702, 0x005E, 0x0BE5, 0x0448, 0x0500,
0x026C, 0xF769, 0x0A37, 0xF73A, 0x13E4, 0xF7CC, 0x09A7, 0xF5C2,
0xF655, 0x0179, 0xF5A8, 0x0AB9, 0x001C, 0x0AF8, 0x0105, 0x0DF1,
0xFB7E, 0x091F, 0xFA91, 0xFAF5, 0xFE9C, 0xF005, 0x0165, 0xE964,
0xF6D0, 0xE99B, 0xE996, 0xF39F, 0xF1BE, 0x04B4, 0x01CD, 0x1188,
0x069E, 0x0FCE, 0x0A13, 0x0AA7, 0x1232, 0x0361, 0x116A, 0xF727,
0x0673, 0xF191, 0xFC47, 0xF1E7, 0xF53C, 0xF76D, 0xF27C, 0x0594,
0xF7DF, 0x1231, 0xFEA3, 0x1277, 0x0043, 0x0644, 0x01A6, 0xF6E2,
0xFD66, 0xEE7E, 0xF794, 0xE94E, 0xF9A8, 0xECEA, 0xF8EA, 0xFC13,
0xF6E1, 0x06FE, 0x02F5, 0x1181, 0x138B, 0x1813, 0x13E4, 0x0E0B,
0x0A1A, 0xFFC4, 0x033C, 0xF77A, 0x012E, 0xF0C8, 0xFCF3, 0xEFA2,
0xF3D4, 0xF9F1, 0xEFDF, 0x07FE, 0xF881, 0x0E24, 0x03AA, 0x09AE,
0xFFEB, 0x0319, 0xF938, 0xF9DA, 0xFD6E, 0xF49B, 0x028E, 0xF5D0,
0x0014, 0xF159, 0xFD34, 0xF7BF, 0x02E4, 0x0B33, 0x0ADF, 0x1308,
0x0CCF, 0x0EF1, 0x07DA, 0x0A32, 0x0496, 0x02D3, 0x00CD, 0xFA4B,
0xFB66, 0xF518, 0xF992, 0xF269, 0xF5FF, 0xF47C, 0xF3DE, 0xFBC4,
0xF626, 0x05C6, 0xFB99, 0x07A9, 0x0245, 0x06B6, 0x06EE, 0x0728,
0x04CE, 0xFD67, 0x02E7, 0xF6D7, 0x0A55, 0xF893, 0x0A9A, 0xF9BC,
0xFEBB, 0xFFCD, 0xFCD8, 0x09B3, 0x072D, 0x0D07, 0x0608, 0x0BF6,
0x00A1, 0x084B, 0x01A7, 0x00B9, 0xFE0F, 0xF7CF, 0xFB82, 0xECD8,
0xF5B5, 0xEB71, 0xEB7A, 0xF671, 0xF26A, 0x053F, 0x0526, 0x0ED8,
0x08FD, 0x0CBE, 0x0709, 0x0A10, 0x0EC2, 0x089F, 0x102F, 0x0045,
0x0637, 0xF4BC, 0xFE1F, 0xF0B8, 0xF9E3, 0xF9D9, 0xF5B1, 0x08AE,
0xFC3B, 0x0DCB, 0x05A1, 0x0C2E, 0x03F5, 0x0A4F, 0x02DB, 0xFF53,
0xFD0B, 0xF3C9, 0xF208, 0xED92, 0xF3CE, 0xEC2C, 0xF9A6, 0xF9B3,
0xF937, 0x0934, 0x0201, 0x0C6D, 0x1200, 0x0FD1, 0x1643, 0x117F,
0x0E75, 0x0798, 0x0491, 0xFBD5, 0x0002, 0xF3E5, 0xFACC, 0xF1BE,
0xF2D9, 0xF89A, 0xF3BC, 0x0597, 0xFEB7, 0x0C44, 0x086C, 0x072B,
0x0556, 0x03B8, 0xFB1C, 0x01A1, 0xF866, 0xFA32, 0xFB82, 0xF533,
0xFAF7, 0xF374, 0xF83C, 0xF6D5, 0xFE2B, 0x0768, 0x0DD9, 0x1138,
0x13E7, 0x0BEE, 0x0D08, 0x0AE9, 0x0A16, 0x094F, 0x0227, 0x015C,
0xF340, 0xF755, 0xF34A, 0xF0E3, 0xF86B, 0xF4D7, 0xF739, 0xFCCA,
0xFC63, 0x01FC, 0x014F, 0x04C6, 0x01CE, 0x065D, 0x072B, 0x0876,
0x057C, 0x05D4, 0xF95B, 0xFADB, 0xFB19, 0xF5B3, 0x06AE, 0xFA2B,
0x055D, 0x0127, 0x0397, 0x0775, 0x0DD6, 0x0A2F, 0x0F64, 0x0D37,
0x0230, 0x0CB6, 0xFB96, 0x057C, 0xF945, 0xFB63, 0xF5E7, 0xEF02,
0xF67E, 0xEAF9, 0xF204, 0xF710, 0xF39F, 0x029B, 0x063F, 0x068C,
0x1069, 0x0B4E, 0x07B3, 0x0DB1, 0x029D, 0x0C02, 0x03B9, 0x0363,
0x01BA, 0xF5D6, 0xFEC0, 0xF095, 0xFE1F, 0xF9B8, 0x00C5, 0x0712,
0x01BE, 0x09A6, 0x05CC, 0x0920, 0x083A, 0x0D96, 0x0106, 0x0708,
0xF6F5, 0xF687, 0xEEBF, 0xEEEB, 0xEF1E, 0xEE3E, 0xF804, 0xF560,
0x01F1, 0x0200, 0x0811, 0x08FC, 0x0DC6, 0x0EF5, 0x1168, 0x1316,
0x0CD6, 0x0F03, 0xFFFF, 0x0025, 0xF7FA, 0xF35E, 0xFC0D, 0xF48B,
0xF982, 0xF95F, 0xF861, 0xFF21, 0x04E2, 0x0795, 0x0E04, 0x0766,
0x093F, 0x036D, 0xFC7D, 0x0723, 0xF0EC, 0x00E6, 0xEEAE, 0xF30C,
0xF91A, 0xEEBD, 0xFEF9, 0xF45F, 0x0024, 0x0215, 0x0A12, 0x0BA8,
0x1621, 0x0D4B, 0x144F, 0x0C03, 0x0794, 0x0BCF, 0xFD59, 0x0828,
0xF14E, 0xF9F4, 0xEFA8, 0xEEE1, 0xFAD6, 0xF449, 0x00DC, 0xFB1D,
0x02BB, 0xFAB9, 0x064C, 0x0197, 0x05E8, 0x0AC6, 0x003F, 0x0E60,
0xFC8C, 0x0601, 0xF710, 0xF59D, 0xF6E2, 0xF301, 0xFF8B, 0xF904,
0x07C0, 0xFD87, 0x0BCD, 0x026B, 0x0EF5, 0x06AB, 0x112C, 0x0DCA,
0x05FF, 0x1403, 0xF713, 0x093F, 0xF1D0, 0xF930, 0xF631, 0xF0D9,
0xFC1C, 0xE98A, 0xFB80, 0xEEC6, 0xFC1E, 0xFE03, 0x0461, 0x075D,
0x0DE2, 0x092B, 0x0AFE, 0x0B50, 0xFEE0, 0x0CCB, 0xF5D4, 0x02B3,
0xF973, 0xF543, 0x0243, 0xF1D2, 0x04BE, 0xF5C0, 0x06A5, 0xFFB3,
0x07E3, 0x0C18, 0x0967, 0x0C20, 0x079A, 0x0DE6, 0xFEC3, 0x0F68,
0xF37B, 0xF8CD, 0xEE5B, 0xE737, 0xF341, 0xEE1F, 0xFA78, 0xF847,
0x02A8, 0xFCFA, 0x0C83, 0x0221, 0x1237, 0x09D9, 0x0D27, 0x14EE,
0x03C3, 0x1562, 0xFA3C, 0x02F9, 0xF5C5, 0xF258, 0xFB94, 0xF15B,
0xFF11, 0xFA60, 0x00B5, 0xFDDA, 0x07BD, 0x02CB, 0x0F76, 0x0B91,
0x0C4E, 0x0A2A, 0xFD24, 0x0566, 0xEE03, 0xFE72, 0xE9AB, 0xF522,
0xF36F, 0xF1AA, 0x0195, 0xF20C, 0x0AAD, 0xF69A, 0x0E02, 0x06E0,
0x11D9, 0x10B9, 0x10F5, 0x0FD9, 0x0501, 0x11D8, 0xF719, 0x07C1,
0xEEA5, 0xF939, 0xF0CF, 0xF2F7, 0xFD0A, 0xF1E6, 0x0886, 0xF838,
0x0A6C, 0xFDF7, 0x09A1, 0xFE94, 0x079D, 0x0657, 0xFD15, 0x12D6,
0xF053, 0x0B56, 0xEE97, 0xF552, 0xF939, 0xEB0A, 0x0417, 0xF2CA,
0x0BF8, 0xFBAC, 0x0EF1, 0x00E5, 0x0DD9, 0x0877, 0x0D41, 0x0E4D,
0x02B3, 0x1684, 0xEFE0, 0x1038, 0xEC06, 0xF8AB, 0xF70E, 0xEE99,
0xFF06, 0xEEAF, 0x04B3, 0xEBF6, 0x06AD, 0xF408, 0x04F3, 0x04C7,
0x0543, 0x0EBE, 0x0192, 0x130B, 0xF8DE, 0x0A9F, 0xF526, 0xFA3F,
0xFA94, 0xF403, 0x0185, 0xF3A8, 0x0898, 0xF43B, 0x0D27, 0xFC56,
0x08D8, 0x0904, 0x01C4, 0x0F7B, 0xFF4F, 0x12BC, 0xFAD6, 0x0EFB,
0xF1B5, 0xFB9A, 0xF153, 0xE8C2, 0xF8AC, 0xE71A, 0x01E1, 0xEFC7,
0x0865, 0xFBB5, 0x067D, 0x0605, 0x06FA, 0x078C, 0x0A00, 0x0D9A,
0x01EB, 0x137E, 0xF5BF, 0x0434, 0xF3BC, 0xF18F, 0xFA84, 0xF04B,
0x04E6, 0xF67B, 0x06FB, 0xFCB7, 0x02D0, 0x03F2, 0x0721, 0x08EE,
0x08AA, 0x0EEF, 0xFCAE, 0x0D5B, 0xEF98, 0xFA9A, 0xEF4B, 0xEBB7,
0xF72E, 0xEFB6, 0x011D, 0xF606, 0x0B0B, 0xF640, 0x0E66, 0xFD62,
0x0E2F, 0x09AC, 0x0C22, 0x13C2, 0x0060, 0x15A8, 0xF215, 0x07CA,
0xF1F2, 0xF7A6, 0xF514, 0xF313, 0xFA9F, 0xF375, 0x0AE6, 0xF5D6,
0x0D6E, 0xFD21, 0x0315, 0x020C, 0x0152, 0x06F9, 0xFD57, 0x0D67,
0xF26F, 0x0861, 0xF158, 0xFA13, 0xF73D, 0xEE4C, 0x036F, 0xEAF5,
0x154A, 0xF26B, 0x15A6, 0x0025, 0x0709, 0x0809, 0xFF3D, 0x0DCD,
0xFDEB, 0x17FC, 0xF448, 0x1284, 0xECC2, 0xFC29, 0xF655, 0xEF86,
0x037E, 0xEEB5, 0x0B6C, 0xEF4D, 0x0A36, 0xF4B0, 0x0026, 0xFC25,
0xFCD4, 0x082E, 0x0008, 0x1932, 0xF7C0, 0x12BE, 0xF329, 0xF692,
0x0011, 0xEB98, 0x0BBF, 0xF2CC, 0x10FC, 0xF704, 0x0A67, 0xFBE1,
0xFE33, 0x0684, 0xFC3C, 0x111D, 0xFB75, 0x1858, 0xF6D4, 0x12BB,
0xF681, 0xFD21, 0xF8EA, 0xEC23, 0xFCF7, 0xEA17, 0x0729, 0xEAF6,
0x09A5, 0xF1A7, 0x0142, 0x03A5, 0xFD05, 0x0FAE, 0x0012, 0x1052,
0x0303, 0x0D4D, 0x02AC, 0x0293, 0x0278, 0xF550, 0xFDD4, 0xF099,
0x00A7, 0xF41F, 0x09F3, 0xFE38, 0x011B, 0x06A7, 0xF8DA, 0x0A2E,
0x0275, 0x1169, 0x0187, 0x1274, 0xF6CA, 0x0096, 0xF967, 0xEB85,
0xFC98, 0xE654, 0x02F3, 0xF090, 0x0C9B, 0xFCFA, 0x04EE, 0xFF28,
0xFF27, 0x00E2, 0x0AAB, 0x10FD, 0x0E9F, 0x1BAC, 0xFE40, 0x0B92,
0xF37F, 0xF6E7, 0xF961, 0xF4E7, 0x01ED, 0xF853, 0x080F, 0xF821,
0x05B9, 0xFC4B, 0xFBA8, 0x0318, 0xFB99, 0x0C30, 0x036C, 0x11B8,
0xFC46, 0x0340, 0xF73F, 0xF300, 0xFEED, 0xF683, 0x03FB, 0xF55F,
0x0D1E, 0xED28, 0x1052, 0xF88B, 0x074A, 0x0A41, 0x01A1, 0x12B0,
0xFDB8, 0x1945, 0xF80F, 0x155C, 0xFA01, 0x0463, 0xFDF8, 0xF65B,
0x0259, 0xF078, 0x0A89, 0xF0B5, 0x0506, 0xF7F0, 0xF9FC, 0xFF47,
0xF9B5, 0x0380, 0xFEE7, 0x0F0D, 0x0027, 0x16AE, 0xFEFA, 0x04CA,
0x03AB, 0xED79, 0x0ACF, 0xEC7F, 0x1533, 0xF6F0, 0x11A6, 0xFF22,
0xF79F, 0x0569, 0xEE6B, 0x0EEA, 0xFFEB, 0x1EB3, 0x04D0, 0x1C63,
0xFF5E, 0x0195, 0x026A, 0xF003, 0x002F, 0xEF7B, 0x03BB, 0xEF31,
0x0655, 0xEEAC, 0xF6D6, 0xF621, 0xF325, 0x097D, 0x03B1, 0x1CFA,
0x0B4C, 0x14D0, 0x08BF, 0xFC7E, 0x0E95, 0xF629, 0x0EF7, 0xF85D,
0x0386, 0xF47F, 0xF9E7, 0xF80A, 0xF4B0, 0x077A, 0xF5B9, 0x118F,
0x015C, 0x149C, 0x0AB6, 0x142E, 0x044F, 0x06E0, 0x01A9, 0xF4B1,
0x01BF, 0xE9A6, 0xFC49, 0xE581, 0xFD2B, 0xEFEA, 0xFBBA, 0x0499,
0xF90D, 0x089E, 0x0561, 0x09A0, 0x160C, 0x1776, 0x15C0, 0x12D5,
0x07CC, 0xFE2C, 0xF71A, 0xF44A, 0xF4C2, 0xF678, 0xFEF7, 0xFD1A,
0xFAF0, 0x0099, 0xF2E4, 0x0197, 0xFC51, 0x0D8B, 0x0ADF, 0x183E,
0x08CE, 0x079C, 0xFEC5, 0xEEAA, 0xFA20, 0xEB18, 0xFADB, 0xF5E1,
0x029F, 0xF63A, 0x02C5, 0xF372, 0xFD6D, 0x0099, 0x099B, 0x1431,
0x14FC, 0x1E1D, 0x0445, 0x1333, 0xF80E, 0x0237, 0xFF33, 0xFD2D,
0xFDFF, 0xF74C, 0xFAF2, 0xEDF2, 0xF9B7, 0xF522, 0xF51B, 0x032A,
0xFB8D, 0x067F, 0x07AF, 0x0973, 0x04A9, 0x07DF, 0xFF52, 0x012B,
0x055B, 0xF9AA, 0x053F, 0xED2F, 0x02CB, 0xEB25, 0x0753, 0xFB14,
0x0219, 0x094B, 0xF615, 0x0E14, 0xFD6B, 0x1793, 0x0AE6, 0x1CBB,
0x0812, 0x0C05, 0x0160, 0xF40B, 0xF9FA, 0xED2D, 0xF7C2, 0xF13D,
0xFB14, 0xF158, 0xF2FB, 0xF373, 0xEEDC, 0xFC6A, 0x00D2, 0x0F7D,
0x11CF, 0x1852, 0x10ED, 0x02B9, 0x0BFD, 0xEF33, 0x07E2, 0xF3AB,
0x032D, 0xF886, 0xF900, 0xF801, 0xE9DD, 0x0132, 0xEE28, 0x0F3F,
0x0774, 0x19B2, 0x1399, 0x1589, 0x0930, 0x045B, 0x0455, 0xF8C7,
0x01D5, 0xF07C, 0xF377, 0xE651, 0xEC1F, 0xE53D, 0xEC64, 0xF6AB,
0xF280, 0x0A47, 0x0B32, 0x0F12, 0x1DFC, 0x0DDA, 0x16FD, 0x0B6A,
0x11A8, 0x0372, 0x0666, 0xF95B, 0xEADF, 0xF3D1, 0xE6D9, 0xF79D,
0xF366, 0x043F, 0xF685, 0x08A3, 0x00C4, 0x094F, 0x139C, 0x1403,
0x15B4, 0x0E53, 0x07BA, 0xF552, 0xF884, 0xE7A9, 0xEA03, 0xE9C1,
0xEA2B, 0xF197, 0xF802, 0xF9C7, 0x0084, 0xFE75, 0x0BBA, 0x08DB,
0x1FDD, 0x190B, 0x1D67, 0x16C1, 0x039A, 0x0451, 0xF49F, 0xFB57,
0xEE35, 0xFB75, 0xED66, 0xF5C8, 0xF08C, 0xF3D2, 0xF43D, 0x0042,
0x06ED, 0x0A8C, 0x193A, 0x0B1D, 0x10DD, 0x03CE, 0x0070, 0xF814,
0xFABB, 0xF58F, 0xF3B0, 0xF505, 0xF38C, 0xEC75, 0xFBA6, 0xF1ED,
0xFFA7, 0x05DC, 0x09D8, 0x0FA4, 0x144E, 0x142B, 0x0D98, 0x15FE,
0x0379, 0x0CFA, 0x00DC, 0xFED4, 0xF091, 0xF1BA, 0xE3DD, 0xED6F,
0xF228, 0xF42E, 0xFC5A, 0xFAF6, 0xFCFC, 0xFCA8, 0x09EF, 0x03CA,
0x12AB, 0x0DD6, 0x0B98, 0x08AF, 0x096A, 0xF893, 0xFFCB, 0xF0F0,
0xEF79, 0xF2B9, 0xF3EC, 0xF906, 0xF955, 0x03EF, 0xF854, 0x0BA5,
0x08A2, 0x14B4, 0x17D8, 0x1A29, 0x0C17, 0x0B1C, 0xFDF4, 0xFA9A,
0xF5F7, 0xF565, 0xEAB5, 0xED9A, 0xE80B, 0xE88E, 0xECA2, 0xF09E,
0xF7C2, 0xFDF9, 0x0CE5, 0x0BD6, 0x1E75, 0x1175, 0x1BE1, 0x08F4,
0x0F06, 0x00BA, 0xFF27, 0xFCB6, 0xE9CA, 0xF6AF, 0xE29B, 0xF57C,
0xECA9, 0x0171, 0xFB92, 0x0B14, 0x0C3D, 0x0BA1, 0x1659, 0x0F81,
0x12A2, 0x0C4B, 0x0A9C, 0xFDC8, 0xF838, 0xF11C, 0xDCC9, 0xE744,
0xDCE7, 0xE63B, 0xF144, 0xF616, 0x0128, 0x0236, 0x155A, 0x062E,
0x26BF, 0x1108, 0x2030, 0x133A, 0x0CC7, 0x089D, 0xF78E, 0xFEAA,
0xDEF4, 0xF8D8, 0xDDE9, 0xF755, 0xF04E, 0xFB0A, 0xFB8F, 0x0148,
0x0B53, 0x06C9, 0x1F52, 0x0C3F, 0x1AE3, 0x08D6, 0x0284, 0xFB99,
0xF032, 0xF072, 0xE212, 0xEE9D, 0xE119, 0xEFCE, 0xF465, 0xF3CA,
0x086F, 0xFF8F, 0x16E5, 0x09D7, 0x21AD, 0x135F, 0x1B86, 0x15E1,
0x061A, 0x0CCD, 0xF665, 0x03CD, 0xE52A, 0xF9AC, 0xD9CC, 0xF14C,
0xE987, 0xF4A5, 0x000E, 0xFAB2, 0x0CD2, 0xFDAD, 0x141B, 0x0542,
0x1193, 0x05E7, 0x0773, 0x00A4, 0xFE0A, 0xFE79, 0xECF9, 0xF6E4,
0xE404, 0xF106, 0xF42C, 0xF622, 0x04A0, 0x011F, 0x0BFE, 0x0923,
0x1478, 0x1165, 0x1809, 0x182E, 0x0D76, 0x1011, 0xFB5A, 0x0206,
0xE759, 0xFA41, 0xDCCE, 0xF05C, 0xE8D3, 0xEABE, 0xF8EC, 0xF347,
0x0009, 0xF848, 0x0DB9, 0xFFC4, 0x1BD2, 0x0DA7, 0x14CD, 0x0B82,
0x0643, 0x0284, 0xF602, 0xFD0C, 0xE403, 0xF6F5, 0xE82D, 0xF69C,
0xF8C2, 0xFDD6, 0x0486, 0x06F7, 0x13A3, 0x0EC8, 0x1B51, 0x1109,
0x10DC, 0x0DA6, 0x0329, 0x03CD, 0xEF61, 0xF4DC, 0xD80B, 0xEC30,
0xD896, 0xE852, 0xEE36, 0xEC52, 0x04F7, 0xFA7E, 0x169E, 0x070D,
0x213F, 0x0EED, 0x1D97, 0x0EB7, 0x0D65, 0x0868, 0xF494, 0x0148,
0xDA20, 0xF845, 0xD9D0, 0xF580, 0xF2BA, 0xFC6C, 0x0566, 0x0037,
0x1039, 0x0642, 0x1D64, 0x0ECD, 0x1A0F, 0x080B, 0x04B8, 0xFD89,
0xEB07, 0xF567, 0xD2A6, 0xEAEF, 0xD758, 0xE9DB, 0xF4C8, 0xF2E5,
0x08B3, 0xFCA4, 0x1708, 0x068A, 0x2598, 0x112E, 0x2037, 0x130B,
0x09F4, 0x0B73, 0xF158, 0x0463, 0xDB42, 0xFEC7, 0xDABE, 0xF619,
0xEEAF, 0xF3A0, 0x03CE, 0xFB34, 0x135E, 0x0049, 0x1B5B, 0x049C,
0x157A, 0x052C, 0x02B6, 0xFD87, 0xF0DC, 0xF988, 0xE19B, 0xF84C,
0xDD82, 0xF2FE, 0xF22E, 0xF2B7, 0x0C42, 0xFBF1, 0x174D, 0x05FA,
0x1C8A, 0x0EB4, 0x194D, 0x11E2, 0x0A35, 0x0F7F, 0xFA15, 0x09B1,
0xE281, 0xFDB8, 0xD844, 0xF488, 0xED49, 0xF0A6, 0x02A8, 0xF13F,
0x0B95, 0xF7A5, 0x1209, 0xFFA6, 0x1483, 0x0665, 0x0FBF, 0x08D6,
0x002D, 0x05D3, 0xE833, 0xFF51, 0xE08E, 0xF863, 0xF13D, 0xF58C,
0x03FC, 0xFADE, 0x0CF9, 0x02FA, 0x1538, 0x0DA6, 0x1C05, 0x15EE,
0x1261, 0x0F4B, 0xFDAB, 0x060C, 0xE6C2, 0xFEDA, 0xD997, 0xF2A0,
0xE4C2, 0xE909, 0xF756, 0xE9A1, 0x0448, 0xF4C2, 0x158A, 0x04FC,
0x201B, 0x0ED0, 0x16FB, 0x0D20, 0x07FC, 0x083C, 0xF29D, 0x02C1,
0xDE81, 0xFAE3, 0xE463, 0xF438, 0xF964, 0xF79A, 0x0A58, 0x03A7,
0x1777, 0x0BC9, 0x1C9E, 0x0E94, 0x1438, 0x0BC3, 0x04B8, 0x03D1,
0xECDD, 0xF96F, 0xD590, 0xEDD4, 0xD9EB, 0xE7A9, 0xF5AC, 0xEE90,
0x0C0F, 0xFD20, 0x171B, 0x08C2, 0x207B, 0x1038, 0x1E60, 0x1011,
0x0C97, 0x0AC8, 0xF20D, 0x0485, 0xDA63, 0xFD5D, 0xDF24, 0xF881,
0xF80A, 0xF838, 0x0867, 0xFCF8, 0x1174, 0x0404, 0x1A4D, 0x0A6F,
0x16E9, 0x073A, 0x0445, 0xFCFE, 0xEBB8, 0xF858, 0xDA26, 0xF718,
0xE129, 0xF363, 0xF6D8, 0xF302, 0x09B2, 0xFBB8, 0x18D9, 0x05AC,
0x214B, 0x0CE3, 0x1AC6, 0x0E3A, 0x08A0, 0x0AA4, 0xF4BC, 0x0954,
0xE233, 0x05E8, 0xE05B, 0xFA83, 0xF131, 0xF1F5, 0x033D, 0xF77E,
0x10E0, 0xFDCA, 0x178A, 0xFF83, 0x1188, 0x0198, 0x0654, 0x027E,
0xFA16, 0x03E6, 0xE4FC, 0x0274, 0xE02C, 0xFAC8, 0xF570, 0xF447,
0x08B2, 0xF817, 0x13DA, 0x0131, 0x1919, 0x09F0, 0x162C, 0x0F82,
0x0D4F, 0x0F6E, 0xFDD1, 0x0A67, 0xE58E, 0x0117, 0xDAC4, 0xF79D,
0xEBA4, 0xEE5F, 0xFEF4, 0xEB17, 0x0743, 0xF341, 0x10CB, 0x00FE,
0x182B, 0x0970, 0x0ECA, 0x09D1, 0xFF70, 0x09A2, 0xEE12, 0x064C,
0xE2F3, 0xFAD1, 0xEF75, 0xF11F, 0x0056, 0xF47F, 0x0B0A, 0x009F,
0x1653, 0x0E19, 0x199C, 0x1231, 0x0E6F, 0x0A81, 0xFD34, 0x06C4,
0xEAE8, 0x02F8, 0xDFAD, 0xF297, 0xE4BE, 0xE514, 0xF482, 0xEB54,
0x0864, 0xF9B1, 0x14AE, 0x05DB, 0x1732, 0x0DEA, 0x1315, 0x0DAF,
0x06E2, 0x0973, 0xF4A5, 0x03EC, 0xE5E6, 0xFB46, 0xEA14, 0xF470,
0xFA10, 0xF816, 0x0963, 0x00F3, 0x1425, 0x0720, 0x13C9, 0x0A7E,
0x0C10, 0x0932, 0x04B8, 0x0134, 0xF1A7, 0xF8B0, 0xDD40, 0xF5BB,
0xE58E, 0xF23B, 0xF7A4, 0xF131, 0x0549, 0xFA16, 0x151B, 0x0895,
0x1A1E, 0x0D7A, 0x12F1, 0x06C9, 0x09DF, 0x04EB, 0xF9C0, 0x0717,
0xE784, 0x04BB, 0xE843, 0xFD9D, 0xF58E, 0xF706, 0x01DF, 0xF8B9,
0x0E1D, 0x04A8, 0x1632, 0x06EB, 0x0FC5, 0xFAB2, 0x0190, 0xFBD2,
0xF652, 0x0535, 0xE77D, 0x0016, 0xE344, 0xF514, 0xF2C4, 0xF5EE,
0x03EF, 0xFC33, 0x10E0, 0x015B, 0x18CA, 0x061C, 0x1436, 0x060F,
0x0A3C, 0x0980, 0xFE6B, 0x0F30, 0xEB9B, 0x07F5, 0xE3D5, 0xF84F,
0xEC31, 0xF42E, 0xFDA0, 0xF5E1, 0x10BE, 0xF5B3, 0x1381, 0xFD85,
0x0CD1, 0x054E, 0x086D, 0x061D, 0xFD77, 0x057A, 0xEDAF, 0x04D8,
0xE8DE, 0xFD6F, 0xEF8A, 0xF24B, 0xFE79, 0xEFFF, 0x111B, 0xFB45,
0x18B0, 0x09CD, 0x1250, 0x0DF4, 0x08A1, 0x0D2B, 0xFEBE, 0x0B2E,
0xEE32, 0x06EF, 0xE6AF, 0xFC63, 0xF096, 0xEADA, 0xFC23, 0xE650,
0x0A38, 0xF9B1, 0x1518, 0x09EE, 0x0F52, 0x04DB, 0x06C0, 0x04AE,
0x0249, 0x0E37, 0xF4A6, 0x099C, 0xEAE1, 0xF870, 0xF150, 0xEFAD,
0xFE91, 0xF301, 0x0E03, 0xFF4F, 0x14AD, 0x0DAE, 0x0CB2, 0x0B31,
0x032A, 0x0574, 0xFF68, 0x0A2A, 0xF82B, 0x0382, 0xEDD9, 0xF196,
0xEC4E, 0xEEB2, 0xF6BD, 0xF4E1, 0x07AE, 0xF8AB, 0x11FE, 0x02C5,
0x0F16, 0x0A62, 0x07DF, 0x0895, 0x038F, 0x03C4, 0xFDA4, 0x028F,
0xF50E, 0xFEF1, 0xF19B, 0xF7FF, 0xF78B, 0xF89A, 0x039B, 0xFE97,
0x0BDD, 0x065C, 0x0ADD, 0x09C5, 0x086B, 0x032C, 0x0731, 0xFB20,
0xFEEF, 0x0060, 0xF28F, 0x03D4, 0xEC25, 0xF5FE, 0xF136, 0xED11,
0x01A3, 0xF949, 0x0E58, 0x0A5B, 0x0C73, 0x073D, 0x09AC, 0xFEDF,
0x0B69, 0x045D, 0x0646, 0x0B3E, 0xF965, 0x08CB, 0xEB83, 0xFDC8,
0xEA4F, 0xF336, 0xFC52, 0xF7A7, 0x0DAB, 0x0418, 0x0E5B, 0x0010,
0x0904, 0xFC8E, 0x0698, 0x0850, 0x00D3, 0x0BFE, 0xF620, 0x006F,
0xEBC7, 0xF642, 0xEBCD, 0xF4EF, 0xFAED, 0xF584, 0x0C68, 0xFB48,
0x11DB, 0x0378, 0x0E4A, 0x06E5, 0x0A60, 0x0B49, 0x0216, 0x10FE,
0xF452, 0x0A83, 0xEAD3, 0xFAF0, 0xEE04, 0xF159, 0xFD5D, 0xED26,
0x0D53, 0xF62A, 0x1046, 0x0782, 0x08E6, 0x0A73, 0x036D, 0x03B6,
0x0039, 0x06C7, 0xFA52, 0x0AE5, 0xEF40, 0xFE06, 0xEC11, 0xEC24,
0xFE0E, 0xEBCB, 0x11FD, 0xFD23, 0x1389, 0x0A97, 0x0885, 0x0CDE,
0xFD9F, 0x0AB3, 0xFCA4, 0x0B4F, 0xFFB6, 0x0A09, 0xF5C3, 0xF913,
0xEE38, 0xE80B, 0xFC76, 0xEE3D, 0x0C48, 0x0082, 0x0BDD, 0x05F3,
0x047B, 0x0318, 0x006A, 0x0647, 0xFF3F, 0x0BCD, 0xFF14, 0x066F,
0xF9C3, 0xF75B, 0xF4CE, 0xEE85, 0xFEAE, 0xF1B9, 0x0A47, 0xFFFF,
0x060A, 0x0B0C, 0xFFA6, 0x0A89, 0x02E4, 0x07D3, 0x05D8, 0x071C,
0x0520, 0x02BC, 0xFD90, 0xFA4D, 0xF243, 0xF3F8, 0xF46B, 0xEF9E,
0x005F, 0xF54D, 0x055D, 0x0437, 0x01A8, 0x0BD2, 0xFE3E, 0x06AF,
0x0315, 0x0312, 0x0BED, 0x0501, 0x05E4, 0xFF70, 0xF3E6, 0xF5C5,
0xEEF0, 0xF17D, 0xF8BC, 0xF884, 0x0398, 0x04B7, 0x0710, 0x084C,
0x03A1, 0x02DC, 0x04B0, 0x0462, 0x0B0C, 0x0BE8, 0x0249, 0x0227,
0xEE21, 0xEE7E, 0xED46, 0xE925, 0xFB10, 0xF51C, 0x0119, 0x0199,
0x02CE, 0x0513, 0x06B7, 0x0421, 0x0B58, 0x07EE, 0x0D81, 0x0EA9,
0x00EC, 0x0749, 0xEB68, 0xF651, 0xEB95, 0xED45, 0xFECF, 0xF277,
0x0787, 0xFD98, 0x05D8, 0x061A, 0x05B7, 0x09F0, 0x054A, 0x0ABE,
0x04C2, 0x095B, 0xFF11, 0x0001, 0xF041, 0xF3E8, 0xEA8D, 0xEC43,
0xF720, 0xEEE9, 0x0598, 0xFAA1, 0x0C45, 0x068C, 0x09FB, 0x0CE2,
0x024E, 0x0DFF, 0x00AB, 0x0D68, 0xFFBD, 0x0421, 0xF775, 0xF472,
0xF417, 0xEA8B, 0xFBD8, 0xEFAD, 0x059E, 0xFF96, 0x0940, 0x0B8E,
0x020E, 0x0B10, 0xFBA6, 0x064C, 0x02B2, 0x0826, 0x0366, 0x02BE,
0xF4E6, 0xF30A, 0xF025, 0xE78B, 0xFE27, 0xEBAD, 0x096E, 0xFE68,
0x0609, 0x0EF3, 0xFD9D, 0x119B, 0xFAF3, 0x0BF9, 0x0580, 0x08E0,
0x0E16, 0x01E7, 0x0159, 0xF56E, 0xF485, 0xEC93, 0xFC0D, 0xEFD1,
0x025C, 0xFC59, 0xFE7D, 0x071F, 0xFD51, 0x0C35, 0xFCB8, 0x0A3E,
0x01F2, 0x0858, 0x09CB, 0x028F, 0x050C, 0xF4D1, 0xFBCF, 0xEC02,
0xF9C4, 0xF138, 0xFB5C, 0xFE84, 0xFC16, 0x0A07, 0xFDC9, 0x0E5D,
0x02B0, 0x0A3F, 0x0B17, 0x09DF, 0x0E40, 0x0790, 0x05B3, 0xFA0E,
0xF81E, 0xED48, 0xF1FE, 0xEB5A, 0xF730, 0xF5FB, 0xFCA0, 0x0423,
0xFCCB, 0x0C3F, 0xFD5F, 0x0A98, 0x08CA, 0x073C, 0x1413, 0x0547,
0x094B, 0xFDE8, 0xF6A4, 0xF317, 0xF293, 0xF04B, 0xF873, 0xF8EE,
0x0146, 0x03DA, 0x0826, 0x0E24, 0x056D, 0x107C, 0x0813, 0x0B81,
0x100C, 0x0648, 0x0524, 0xFAA3, 0xF2FC, 0xEC3F, 0xF0A5, 0xE9DB,
0xF662, 0xF4B0, 0xFBCB, 0x02D5, 0x03F2, 0x0CC6, 0x0816, 0x0CE7,
0x098D, 0x0C19, 0x0C10, 0x0B7F, 0x0654, 0xFFDF, 0xF88D, 0xF0C9,
0xF403, 0xEBC5, 0xFD9E, 0xF60D, 0x03A1, 0x0775, 0x04AD, 0x1286,
0x04E0, 0x1174, 0x03EA, 0x0AA1, 0x06D6, 0x042A, 0x054E, 0xF9D4,
0xF959, 0xED17, 0xF25F, 0xEABB, 0xF8CA, 0xF4A4, 0x01C8, 0x00A0,
0x05CA, 0x0F32, 0x01FA, 0x16BB, 0x0284, 0x10DF, 0x0A4E, 0x093F,
0x096E, 0xFD7D, 0x0317, 0xF0B6, 0xFE0C, 0xEF7E, 0xFBF8, 0xF773,
0xFE8D, 0x02FA, 0x00AE, 0x0E80, 0xFC94, 0x1061, 0xFD36, 0x0984,
0x0670, 0x036A, 0x0811, 0xFCBD, 0x0169, 0xF228, 0xFD07, 0xEA95,
0xFBA0, 0xF120, 0xFA12, 0x0277, 0xFE44, 0x11A5, 0x00CD, 0x14FA,
0x007E, 0x0D58, 0x0B72, 0x07E7, 0x1245, 0x0358, 0x082B, 0xF6F4,
0xFC7A, 0xEED2, 0xF7FD, 0xF348, 0xF5AE, 0xFD8A, 0xF908, 0x08FE,
0xFD41, 0x0D60, 0xFECD, 0x0A12, 0x08B5, 0x082B, 0x1097, 0x0089,
0x08E8, 0xF174, 0xFB43, 0xED6C, 0xF5D9, 0xF647, 0xF6DF, 0x009B,
0xFBA0, 0x0ABA, 0x0220, 0x12D8, 0x07D6, 0x12C5, 0x0EEF, 0x0B81,
0x0F58, 0x0298, 0x0629, 0xF607, 0xF9B6, 0xEC8C, 0xF12B, 0xEECB,
0xF03F, 0xF7B0, 0xF737, 0x05B6, 0x0075, 0x1350, 0x0759, 0x1252,
0x0D64, 0x063F, 0x0CA0, 0xFE27, 0x05B1, 0xF744, 0xFD48, 0xF005,
0xF59C, 0xF011, 0xF474, 0xFB50, 0xFDAD, 0x0DD3, 0x063E, 0x16FF,
0x064A, 0x12CB, 0x08EB, 0x09EE, 0x0AB7, 0x0033, 0x02AE, 0xF345,
0xF833, 0xE75C, 0xF2CE, 0xE8FE, 0xF279, 0xF99E, 0xFB2E, 0x0C32,
0x054E, 0x1253, 0x05A9, 0x0E6A, 0x07A5, 0x09E5, 0x0B6B, 0x0422,
0x0741, 0xF5C1, 0xFFE0, 0xEBC8, 0xFB4A, 0xF3EB, 0xF8DE, 0xFF5E,
0xFAD0, 0x099D, 0x0042, 0x1297, 0x037F, 0x1190, 0x047C, 0x081C,
0x0465, 0xFCAA, 0x03BD, 0xF037, 0xFFB3, 0xEB6B, 0xFA82, 0xF369,
0xF7D5, 0xFC09, 0xF8F5, 0x0402, 0xFF35, 0x0EAF, 0x0515, 0x13EE,
0x07B0, 0x0A9B, 0x09F4, 0xFEA0, 0x0B90, 0xFAB0, 0x0751, 0xF594,
0xFD3B, 0xF2F3, 0xF48D, 0xFA8B, 0xF695, 0x066C, 0xFC67, 0x0DA9,
0xFE21, 0x0D1E, 0x03CD, 0x0474, 0x0978, 0xFDB5, 0x0A49, 0xFB41,
0x0659, 0xF432, 0xFC6D, 0xEFD1, 0xF4AA, 0xF6BB, 0xF6D5, 0x064E,
0xFD3C, 0x0F91, 0x0459, 0x0EF2, 0x0C8B, 0x0D31, 0x0F6A, 0x07CC,
0x0C1A, 0xFC86, 0x040E, 0xF331, 0xFB20, 0xF231, 0xF264, 0xF771,
0xEE16, 0x00F3, 0xF5F5, 0x0823, 0x02F7, 0x0C2E, 0x0C2F, 0x0D50,
0x0DD0, 0x072D, 0x0A66, 0xFB06, 0x063E, 0xEF24, 0xFED3, 0xEF99,
0xF3D3, 0xF847, 0xF28B, 0x00FE, 0xFD9A, 0x0DC4, 0x0838, 0x16EA,
0x0D32, 0x1019, 0x0AFD, 0x041E, 0x0853, 0xFB27, 0x0509, 0xF07B,
0xF8DA, 0xEC1A, 0xED9F, 0xF0DE, 0xF0B8, 0xFC25, 0xFBE8, 0x0B32,
0x05D7, 0x147E, 0x0B37, 0x0F91, 0x0BA3, 0x0253, 0x0B65, 0xF910,
0x05E4, 0xF209, 0xFC94, 0xEDCC, 0xF72A, 0xF5DD, 0xF77E, 0x05CB,
0xFBD5, 0x0E95, 0x01B1, 0x1191, 0x094D, 0x0E50, 0x0B42, 0x026F,
0x04BD, 0xF769, 0xFE13, 0xEE69, 0xFADD, 0xEB91, 0xF6BE, 0xF4E2,
0xF562, 0x03DA, 0xF8CC, 0x0D89, 0x00E5, 0x0F78, 0x0CD3, 0x0B80,
0x0D50, 0x02F2, 0x06B9, 0xF8D0, 0x0617, 0xF307, 0x03B9, 0xF5F4,
0xF97F, 0xFAF9, 0xF224, 0x01EE, 0xF543, 0x0B17, 0xFF41, 0x0E83,
0x079D, 0x08A2, 0x0634, 0xFDFC, 0x03FD, 0xF5F6, 0x0569, 0xF28A,
0x02DD, 0xF46F, 0xF838, 0xF9E5, 0xF110, 0x01AA, 0xF786, 0x099E,
0x0187, 0x0E59, 0x0928, 0x0A90, 0x0C9F, 0x026E, 0x0CC5, 0xFF41,
0x091B, 0xFA15, 0x0024, 0xF441, 0xF5CF, 0xF744, 0xF171, 0x0056,
0xF2AC, 0x06DF, 0xF7BD, 0x0990, 0x0416, 0x07F8, 0x0B95, 0x0206,
0x0BA0, 0xFDAF, 0x07B7, 0xF8E7, 0xFF0E, 0xF3EE, 0xF837, 0xF544,
0xF4E9, 0xFD91, 0xF414, 0x05A0, 0xFAF1, 0x0B5C, 0x0ABF, 0x0EA7,
0x10D9, 0x08C9, 0x098C, 0xFDB1, 0x032A, 0xF6DB, 0xFF8A, 0xF4B7,
0xF7A1, 0xF3D8, 0xEF04, 0xF857, 0xEF42, 0x020A, 0xF7F5, 0x0A6F,
0x07CC, 0x0CCA, 0x0F87, 0x0666, 0x09A8, 0xFD28, 0x04D4, 0xF6AC,
0x01B3, 0xF3C0, 0xF9D8, 0xF2F3, 0xF35B, 0xF94D, 0xF5DA, 0x07EB,
0xFD26, 0x106D, 0x0645, 0x0BDC, 0x0A25, 0x02AB, 0x07F5, 0xFBE3,
0x0338, 0xF5AA, 0xFBA3, 0xEFF0, 0xF4FE, 0xEF73, 0xF0ED, 0xF955,
0xF2F7, 0x07C0, 0xFA85, 0x0F21, 0x0575, 0x0C43, 0x0CD2, 0x040E,
0x0BCA, 0xFC31, 0x0613, 0xF4C8, 0xFFCD, 0xF24A, 0xFB18, 0xF705,
0xF694, 0xFFAC, 0xF3AA, 0x080B, 0xF4AA, 0x0BCC, 0x0030, 0x0A79,
0x0ACD, 0x03C5, 0x07F3, 0xF86C, 0x02C5, 0xF0C8, 0xFE97, 0xF31E,
0xF951, 0xF733, 0xF552, 0xFD69, 0xF3CC, 0x0775, 0xF6C7, 0x0CB5,
0x029C, 0x0B59, 0x0C64, 0x02DB, 0x0BA2, 0xF85C, 0x084A, 0xF66D,
0x03EB, 0xFACD, 0xFC52, 0xF9E5, 0xF2FA, 0xF9A0, 0xF075, 0x0370,
0xF471, 0x0C5D, 0xFC6F, 0x08E2, 0x07B0, 0xFF0D, 0x0ACC, 0xF8D9,
0x05F6, 0xF704, 0x01AF, 0xF9F7, 0xFC29, 0xF9A6, 0xF65B, 0xF93F,
0xF599, 0x044E, 0xF678, 0x0B7F, 0xFE5A, 0x06DB, 0x0BF0, 0x037D,
0x0FE6, 0x0082, 0x0A10, 0xF953, 0x0000, 0xF720, 0xF855, 0xF723,
0xF4D1, 0xF859, 0xF1AF, 0x0101, 0xF312, 0x075E, 0xFD68, 0x06B0,
0x0996, 0x0467, 0x0DE2, 0x0020, 0x0910, 0xF91C, 0x021B, 0xF7E8,
0xFDDA, 0xFA20, 0xF80A, 0xF987, 0xF3EF, 0xFE83, 0xF620, 0x096C,
0xFFC4, 0x0E49, 0x0C36, 0x080D, 0x0D02, 0xFCA8, 0x057E, 0xF4B9,
0x007C, 0xF779, 0xF9D3, 0xF952, 0xF32E, 0xF582, 0xF3B2, 0xFCB4,
0xF5E7, 0x0A11, 0xFC28, 0x0E73, 0x0844, 0x095A, 0x0E31, 0xFED5,
0x0C81, 0xF6A3, 0x05E6, 0xF8FC, 0xFC63, 0xF8F0, 0xF667, 0xF655,
0xF6BA, 0x020D, 0xF87E, 0x0DCC, 0xFAB0, 0x0B97, 0x0286, 0x043D,
0x0B1F, 0xFD33, 0x0915, 0xF5B3, 0x0025, 0xF57B, 0xFB9A, 0xF851,
0xF833, 0xF791, 0xF590, 0x001E, 0xF63A, 0x0CB7, 0xFA7D, 0x0D4E,
0x06A8, 0x070C, 0x106F, 0x0160, 0x0D24, 0xF703, 0x046B, 0xF47D,
0xFE94, 0xFCF2, 0xFB03, 0xFD4C, 0xF73E, 0xFDC5, 0xF37E, 0x057E,
0xF725, 0x09BC, 0x0244, 0x0693, 0x096A, 0xFE41, 0x0A8B, 0xF53D,
0x063A, 0xF65C, 0xFE64, 0xFD3A, 0xF8F7, 0xFD23, 0xF6C1, 0xFEDB,
0xF7C1, 0x0694, 0xFD3E, 0x0D4B, 0x05C3, 0x0A0A, 0x0D14, 0xFE9B,
0x0E14, 0xF822, 0x084E, 0xFB68, 0xFF6A, 0xFE0D, 0xF601, 0xF89E,
0xF2E9, 0xF9BB, 0xF538, 0x03F5, 0xF73F, 0x0980, 0xFFCE, 0x0739,
0x0C87, 0x00F5, 0x0F65, 0xF971, 0x083A, 0xF9B4, 0xFEED, 0xFE57,
0xF879, 0xFADB, 0xF825, 0xFCD3, 0xF899, 0x06A1, 0xF9E1, 0x0A3D,
0x01AD, 0x08FA, 0x0B58, 0x05B2, 0x0F3E, 0xFC8C, 0x081E, 0xF600,
0xFCAC, 0xF974, 0xF6AA, 0xFA6C, 0xF432, 0xFA0F, 0xF3D2, 0x0179,
0xF915, 0x0B09, 0x01C0, 0x0C71, 0x0A57, 0x0673, 0x0F5F, 0xFD47,
0x0BA8, 0xF783, 0x0333, 0xFC35, 0xFB9E, 0xFEF1, 0xF901, 0xFC4D,
0xF8D8, 0x00B6, 0xF90A, 0x0C24, 0xFEDB, 0x0EFB, 0x0607, 0x04CD,
0x0A2B, 0xF88D, 0x0947, 0xF497, 0xFFDB, 0xF974, 0xF633, 0xFA12,
0xF7B4, 0xFA3F, 0xFAD0, 0x01FA, 0xFA04, 0x0B7C, 0xFF09, 0x0E4C,
0x07BD, 0x0713, 0x0EA4, 0xFD2F, 0x0DDD, 0xF9F9, 0x0486, 0xFCD5,
0xFB23, 0xFB83, 0xF801, 0xFB81, 0xF80D, 0x023A, 0xF71F, 0x08C0,
0xFA5F, 0x08E8, 0x0306, 0x02B4, 0x09B1, 0xFB1C, 0x08B2, 0xF596,
0x033C, 0xF8D5, 0xFBE9, 0xFCE3, 0xF80B, 0xFC16, 0xF8E6, 0xFF6F,
0xF927, 0x0738, 0xFDD3, 0x0B50, 0x05D8, 0x0824, 0x0C80, 0x0010,
0x0EA5, 0xF780, 0x06C4, 0xF90C, 0xF93E, 0xFE4E, 0xF336, 0xFCC7,
0xF435, 0xFBCC, 0xF563, 0x012C, 0xF997, 0x075E, 0xFF37, 0x0529,
0x0848, 0xFD57, 0x0FE4, 0xF873, 0x09C5, 0xFA85, 0xFC2C, 0xFD4B,
0xF681, 0xFC02, 0xF8C2, 0xFD62, 0xF90C, 0x05D3, 0xFAF9, 0x0C7B,
0x027C, 0x07F1, 0x0AEA, 0xFF48, 0x0D45, 0xFA3B, 0x0632, 0xFB01,
0xF87C, 0xFBA0, 0xF1BB, 0xF725, 0xF59F, 0xF816, 0xF522, 0x01A0,
0xF765, 0x0875, 0x0261, 0x081D, 0x0B81, 0x030D, 0x0F53, 0xFB31,
0x0ADA, 0xF90F, 0xFEA5, 0xFC18, 0xF773, 0xFC48, 0xF8F6, 0xFD89,
0xF94C, 0x03CD, 0xFB8A, 0x091E, 0x00BF, 0x093A, 0x0571, 0x0593,
0x0860, 0xFD37, 0x0624, 0xF673, 0xFD26, 0xF6FD, 0xF31C, 0xF82B,
0xF48A, 0xF8E4, 0xFB87, 0x0066, 0xFFDA, 0x09B2, 0x040B, 0x0A43,
0x08F8, 0x045E, 0x0D5A, 0xFD9A, 0x0D12, 0xFB81, 0x02E9, 0xFD42,
0xF6E8, 0xFBD1, 0xF7E9, 0xF9CB, 0xFB90, 0xFF9E, 0xFB6E, 0x095D,
0xFD2E, 0x0AA7, 0x015C, 0x02D1, 0x0841, 0xF997, 0x08FB, 0xF70C,
0xFF66, 0xF9FD, 0xF754, 0xFA5A, 0xFA5A, 0xFAEF, 0xFEF6, 0x0147,
0xFF81, 0x07F2, 0x00E9, 0x0A5C, 0x062F, 0x08D1, 0x0C97, 0x01B1,
0x0C85, 0xFBE4, 0x0487, 0xFB47, 0xF96A, 0xF994, 0xF650, 0xFA7F,
0xF802, 0x01C5, 0xF7E7, 0x05FE, 0xFB61, 0x0477, 0x00C9, 0x02BB,
0x0608, 0xFE5F, 0x0ACC, 0xF956, 0x08BC, 0xFA36, 0xFF25, 0xFB21,
0xFAB7, 0xF8C7, 0xFBBC, 0xFE40, 0xFCF5, 0x0965, 0x0038, 0x0C8D,
0x03CE, 0x0866, 0x07D6, 0x012C, 0x0AFB, 0xFA18, 0x07EC, 0xF9E1,
0xFB96, 0xFC21, 0xF2CE, 0xF8C4, 0xF557, 0xF924, 0xF949, 0x016E,
0xFB92, 0x0700, 0x002B, 0x05E1, 0x077F, 0x0112, 0x0DDE, 0xFCDE,
0x0D07, 0xF9DE, 0x0070, 0xF8AE, 0xF6E9, 0xFB03, 0xFA60, 0x00B2,
0xFEBC, 0x06E3, 0xFED9, 0x09A9, 0x0011, 0x0778, 0x04E8, 0x025B,
0x0878, 0xFFD9, 0x056E, 0xFCD9, 0xFA5A, 0xF662, 0xF257, 0xF3B6,
0xF525, 0xF991, 0xFB43, 0x01B5, 0x0001, 0x06A8, 0x0475, 0x08F0,
0x09FC, 0x03C0, 0x0C74, 0xFC8C, 0x09AC, 0xFD91, 0x010B, 0xFEEE,
0xF8FF, 0xFB11, 0xF93F, 0xFC09, 0xFC2E, 0x01F7, 0xFEEC, 0x066D,
0x017E, 0x0A81, 0x0221, 0x077B, 0x02CE, 0xFDB6, 0x03E2, 0xF849,
0xFDA2, 0xF80D, 0xF585, 0xF768, 0xF71C, 0xF922, 0xFDF2, 0x01ED,
0x056E, 0x08D3, 0x07FD, 0x080B, 0x052E, 0x05BE, 0x05B1, 0x0502,
0x09D7, 0x0175, 0x05BD, 0xFBEE, 0xF953, 0xF834, 0xF558, 0xF8BE,
0xFB1E, 0x015B, 0xFF4C, 0x0A76, 0xFE40, 0x09D3, 0xFC82, 0x01A8,
0xFF06, 0xFCCC, 0x0589, 0xFB63, 0x0521, 0xF710, 0xFC7B, 0xF579,
0xFBF6, 0xF8F8, 0x022C, 0xFE55, 0x0402, 0x06D1, 0x01E5, 0x0E01,
0x00C3, 0x0A7D, 0x042C, 0x02C5, 0x0794, 0xFDC4, 0x039E, 0xF770,
0xFBFB, 0xF4D0, 0xF8B8, 0xF968, 0xF91B, 0xFFBD, 0xFA97, 0x0392,
0xFB98, 0x05E3, 0xFBA0, 0x0489, 0xFEC4, 0xFEEC, 0x053B, 0xFB87,
0x07BF, 0xF866, 0x0367, 0xF481, 0xFDC3, 0xF73E, 0xFB62, 0x0115,
0xFE3C, 0x09A0, 0x02EC, 0x0BFC, 0x0067, 0x0750, 0xFC15, 0xFF75,
0x0178, 0xFB91, 0x0521, 0xFA1B, 0xFCEA, 0xF81D, 0xF43B, 0xF64E,
0xF3B5, 0xF918, 0xF9ED, 0x01C1, 0x00FC, 0x0705, 0x008C, 0x0490,
0xFE97, 0xFF70, 0x06AD, 0xFBD9, 0x0BDC, 0xF9EC, 0x02A3, 0xFA2A,
0xF877, 0xFC4E, 0xF8AE, 0x0046, 0xFE64, 0x0603, 0x0078, 0x084D,
0xFD6C, 0x04B3, 0xFBA1, 0x00C4, 0xFF9A, 0xFFBE, 0x0151, 0xFAD4,
0xFB75, 0xF3B4, 0xF5CA, 0xF42C, 0xF739, 0xFA5D, 0xFE54, 0x0211,
0x03AC, 0x0740, 0x03A0, 0x054A, 0x0231, 0x01A6, 0x0426, 0x01FF,
0x0538, 0x0014, 0x01CD, 0xFB50, 0xFD74, 0xFA57, 0xFA00, 0xFBDC,
0xFBB7, 0x0026, 0x022B, 0x072B, 0x00E1, 0x0A37, 0xF7FD, 0x0574,
0xF860, 0xFDD9, 0xFE85, 0xF877, 0xFEB1, 0xF546, 0xFD9B, 0xF5CC,
0xFDBD, 0xF932, 0x01C6, 0xFE7E, 0x0A42, 0x06A1, 0x0921, 0x0BF7,
0xFD8D, 0x08D9, 0xFBB4, 0x03C4, 0x0292, 0x003F, 0x0294, 0xF997,
0xFD79, 0xF4C2, 0xFB83, 0xF722, 0xFEA0, 0xFFFD, 0x018C, 0x08E9,
0xFE6E, 0x0884, 0xF70F, 0x01D1, 0xF6AD, 0xFDA1, 0xFF9D, 0xFBA3,
0x05AC, 0xF780, 0x0460, 0xF40A, 0x0328, 0xF75C, 0x0667, 0x022C,
0x08DC, 0x0BF8, 0x04BF, 0x0D6D, 0xFBFC, 0x098E, 0xF9AF, 0x048F,
0xFE91, 0xFDC2, 0x01D7, 0xF6AC, 0x0243, 0xF6D9, 0xFD7A, 0xFC21,
0xFA27, 0xFFF2, 0xFF5B, 0x03C4, 0xFF94, 0x05B5, 0xF810, 0x037C,
0xF977, 0x005C, 0x0168, 0xFBC8, 0x06A9, 0xF637, 0x09AB, 0xF8D6,
0x0579, 0xFFF2, 0x00BE, 0x0378, 0x03AC, 0x0926, 0x0351, 0x0D41,
0xFA37, 0x07A2, 0xF61A, 0xFFC6, 0xFD05, 0xFD8A, 0x01D8, 0xFC25,
0xFFC6, 0xF9FA, 0xFD27, 0xF97A, 0xFCA6, 0xFB06, 0xFFF2, 0x0167,
0x040D, 0x074C, 0xFF53, 0x0427, 0xFAC4, 0xFD98, 0x022D, 0xFE57,
0x087A, 0x0028, 0x0776, 0xFD60, 0x03D7, 0xFE10, 0x00FD, 0x0215,
0x030A, 0x058E, 0x030C, 0x06A5, 0xFB70, 0x051F, 0xF5BF, 0x03D4,
0xF6C4, 0x0202, 0xFBB7, 0xFCB9, 0x0121, 0xF6EE, 0x014D, 0xF75D,
0x01AE, 0xFC43, 0x070F, 0x00B6, 0x08B3, 0x02EF, 0x02D1, 0x0476,
0xFCA0, 0x069C, 0xFC1D, 0x05A2, 0x0021, 0x00B6, 0x0482, 0xFD52,
0x052D, 0xFDA4, 0x0325, 0xFCCA, 0x0421, 0xFF08, 0x0575, 0x06CF,
0xFC2D, 0x0938, 0xF08E, 0x0505, 0xF23F, 0xFF73, 0xFAAD, 0xFA39,
0x025B, 0xF86B, 0x07FA, 0xFA18, 0x08FA, 0xFAEE, 0x0AE7, 0xFEA7,
0x0D06, 0x0771, 0x0398, 0x0B21, 0xF68A, 0x0825, 0xF4FA, 0x04E5,
0xFBA3, 0x014A, 0x02E7, 0xFBE7, 0x059D, 0xF9EF, 0x05AE, 0xFDC9,
0x05FB, 0x02FE, 0x0228, 0x06FF, 0xF93C, 0x05F1, 0xF15B, 0x00DA,
0xF1D7, 0xFE0C, 0xFB94, 0xFCB3, 0x05F7, 0xF9FD, 0x0B54, 0xF9CB,
0x0ED8, 0xFED7, 0x0E5D, 0x04EB, 0x0836, 0x08B1, 0xFEC8, 0x095A,
0xF50C, 0x07D4, 0xF2C3, 0x033A, 0xF8EE, 0xFCD7, 0x015C, 0xFBB5,
0x0753, 0xFE62, 0x080E, 0xFFEF, 0x05AB, 0x00B7, 0x0344, 0x00B6,
0xFD2A, 0x00E0, 0xF5BF, 0x01D7, 0xF4DC, 0x003F, 0xFBC0, 0xFCC8,
0x07F7, 0xFD01, 0x0F24, 0x0020, 0x0D84, 0x020C, 0x0B08, 0x02F8,
0x078F, 0x04FF, 0xFF73, 0x050B, 0xF579, 0x0213, 0xEF80, 0x0166,
0xF449, 0x0130, 0xFF10, 0xFFB6, 0x03DE, 0xFE8B, 0x0624, 0xFC13,
0x08E7, 0xFAFC, 0x07AA, 0xFD5D, 0x00DF, 0xFF69, 0xF77A, 0x006F,
0xF4B0, 0x018D, 0xFAEF, 0x021D, 0x027A, 0x02D6, 0x0671, 0x020A,
0x09EC, 0x009A, 0x0CA1, 0x004A, 0x09D8, 0xFEC2, 0xFF38, 0xFF3A,
0xF2F1, 0x02FB, 0xEE22, 0x043D, 0xF0EB, 0x01AA, 0xF923, 0xFE9F,
0x0222, 0xFBBB, 0x0A14, 0xFA68, 0x0F9D, 0xFC2C, 0x0D1E, 0xFDD5,
0x0491, 0xFEDF, 0xFB9C, 0x0248, 0xF3B7, 0x0616, 0xF210, 0x04E5,
0xFA87, 0x0249, 0x0389, 0x00D2, 0x0AD0, 0xFD57, 0x0F08, 0xFCA9,
0x0950, 0xFFB7, 0xFF53, 0x0128, 0xF4A8, 0x01CF, 0xEB11, 0x0224,
0xEC1F, 0xFEF9, 0xF8CE, 0xFC4D, 0x050B, 0xFCA8, 0x0DB0, 0xFD0C,
0x144C, 0xFE98, 0x1354, 0xFFF8, 0x0818, 0x01E5, 0xF8E0, 0x054D,
0xEF57, 0x064F, 0xEF79, 0x040F, 0xF9ED, 0x0098, 0x0490, 0xFE10,
0x093C, 0xFE0C, 0x0EAA, 0xFF98, 0x0EA4, 0xFE91, 0x01A6, 0xFD04,
0xF311, 0xFE1F, 0xED0B, 0xFF5C, 0xEEF5, 0xFF2C, 0xF978, 0xFFAF,
0x0628, 0x0113, 0x1077, 0x003A, 0x16E7, 0x00F4, 0x12C2, 0x02D1,
0x061E, 0x0202, 0xF861, 0x024E, 0xF07F, 0x02E5, 0xF006, 0x0193,
0xF549, 0x0251, 0xFECF, 0x03E6, 0x09A3, 0x00F1, 0x1028, 0xFDCC,
0x0D3A, 0xFC1F, 0x0310, 0xF9D4, 0xF7A6, 0xFAE1, 0xF0D3, 0xFEE2,
0xF14A, 0x025B, 0xFAB5, 0x0427, 0x058A, 0x0495, 0x0C1D, 0x0413,
0x1256, 0x037E, 0x1281, 0x0156, 0x08AB, 0xFD41, 0xFAD0, 0xFC81,
0xEF0E, 0x00A8, 0xEB01, 0x04DF, 0xF310, 0x0536, 0xFE25, 0x0302,
0x04D4, 0xFF96, 0x0D08, 0xFC6F, 0x1198, 0xFA02, 0x095E, 0xF7E3,
0xFBF9, 0xFAB8, 0xF5B4, 0x00F2, 0xF43D, 0x0442, 0xF68A, 0x0670,
0xFF51, 0x082F, 0x0912, 0x0567, 0x1209, 0xFFA3, 0x1585, 0xFAE0,
0x0A4F, 0xF949, 0xF7D0, 0xFC12, 0xEEE6, 0x0016, 0xEDF5, 0x023A,
0xEFA1, 0x02AD, 0xF826, 0x0204, 0x04D4, 0xFF8A, 0x0F3A, 0xFBA0,
0x13DC, 0xF96A, 0x0F7C, 0xF9CD, 0x01BB, 0xFBD7, 0xF4BC, 0x003A,
0xF061, 0x0621, 0xF320, 0x09B7, 0xFCDE, 0x07DC, 0x09E7, 0x022F,
0x112C, 0xFDD8, 0x10B6, 0xFC11, 0x0A4B, 0xFA5E, 0xFC59, 0xF9A6,
0xEEB1, 0xFBE7, 0xEA7E, 0xFFF0, 0xEF34, 0x03A4, 0xF9DC, 0x0424,
0x064D, 0x01AF, 0x1206, 0xFFA0, 0x1891, 0xFC97, 0x11A7, 0xF989,
0x0029, 0xFBC7, 0xF23C, 0x0185, 0xEEAF, 0x0519, 0xF3E0, 0x0601,
0xFBC4, 0x0631, 0x0313, 0x0566, 0x0C31, 0x016F, 0x1208, 0xFB24,
0x0B75, 0xF68E, 0xFA5F, 0xF5B1, 0xEDDD, 0xF981, 0xECAE, 0xFF07,
0xEFCE, 0x0347, 0xF84D, 0x070B, 0x0738, 0x071A, 0x11BF, 0x01D5,
0x1486, 0xFCFF, 0x0F40, 0xFBCC, 0xFFEF, 0xFB5D, 0xF49D, 0xFBCD,
0xF25B, 0xFF5B, 0xF072, 0x0587, 0xF520, 0x08F4, 0x025B, 0x061D,
0x0BC2, 0xFFC3, 0x0E22, 0xF826, 0x0A8D, 0xF3D9, 0xFEA9, 0xF41D,
0xF208, 0xF7A9, 0xEF25, 0xFEB1, 0xF410, 0x059E, 0xFA98, 0x08C8,
0x043C, 0x081F, 0x0DD7, 0x04FE, 0x111B, 0xFEC8, 0x0F99, 0xF86B,
0x0559, 0xF610, 0xF42B, 0xF9BC, 0xED14, 0x004A, 0xF181, 0x04D9,
0xF5D2, 0x0785, 0xFD53, 0x05F6, 0x07DC, 0xFFAA, 0x0DC0, 0xF800,
0x0CCA, 0xF3A7, 0x01F7, 0xF497, 0xF58C, 0xF919, 0xF213, 0xFEB7,
0xF4AE, 0x04CF, 0xF8BD, 0x0BC5, 0x0022, 0x0CCC, 0x0B0D, 0x0513,
0x1324, 0xFADA, 0x103E, 0xF619, 0x01B3, 0xF68F, 0xF412, 0xF809,
0xEECA, 0xFC85, 0xEF7B, 0x0246, 0xF362, 0x0679, 0xFC18, 0x06F3,
0x0809, 0x019D, 0x0F62, 0xFA71, 0x0F53, 0xF71F, 0x05BC, 0xF5F6,
0xF8AE, 0xF7EE, 0xF2EA, 0x001E, 0xF386, 0x0825, 0xF683, 0x0C7B,
0xFFB0, 0x0B39, 0x0B08, 0x0502, 0x0E71, 0xFD91, 0x0D04, 0xF6CF,
0x041C, 0xF3BD, 0xF4A6, 0xF521, 0xED3E, 0xFA43, 0xEFA4, 0x0067,
0xF48E, 0x05A5, 0xFD39, 0x08DE, 0x0922, 0x06F2, 0x0F68, 0xFDE1,
0x0F79, 0xF5AD, 0x0894, 0xF64C, 0xFA97, 0xFAA9, 0xF124, 0xFF11,
0xF38F, 0x03C4, 0xF9E3, 0x0909, 0xFDED, 0x0BF4, 0x05E8, 0x0736,
0x0CC6, 0xFC6E, 0x0ADD, 0xF431, 0x02AB, 0xF280, 0xF642, 0xF41C,
0xEE4F, 0xF806, 0xF21D, 0xFEFF, 0xF9CA, 0x086D, 0xFF9A, 0x0CCE,
0x086E, 0x07D1, 0x1033, 0xFFF5, 0x10B1, 0xFA58, 0x0825, 0xF827,
0xF9E3, 0xF845, 0xF281, 0xFB19, 0xF433, 0x0197, 0xF940, 0x08F7,
0xFF5D, 0x0BAB, 0x056C, 0x07C6, 0x0AD4, 0xFF47, 0x0BCC, 0xF665,
0x03F6, 0xF236, 0xF7EC, 0xF37A, 0xF21F, 0xFA1E, 0xF4BA, 0x01E7,
0xFAD5, 0x0785, 0x01F3, 0x0CA9, 0x0A90, 0x0CEE, 0x100A, 0x050A,
0x0E64, 0xFB25, 0x0702, 0xF5AB, 0xFA41, 0xF5DA, 0xF12C, 0xF9E9,
0xF320, 0xFF30, 0xF8C3, 0x0637, 0xFE55, 0x0C5B, 0x0640, 0x0B34,
0x0BE2, 0x0289, 0x0B55, 0xF856, 0x0691, 0xF4EC, 0xFCA2, 0xF79E,
0xF3E4, 0xFA66, 0xF61C, 0x0006, 0xFEBE, 0x099F, 0x05AD, 0x1019,
0x0A8D, 0x0F12, 0x0E0A, 0x06E0, 0x0CB5, 0xFC1A, 0x0510, 0xF59F,
0xF9F6, 0xF486, 0xF146, 0xF731, 0xF11A, 0xFD4A, 0xF8B0, 0x0546,
0x00CF, 0x0AC2, 0x0655, 0x0A2E, 0x0B75, 0x0570, 0x0C8F, 0xFE2E,
0x06E1, 0xF6AD, 0xFD65, 0xF5F0, 0xF657, 0xFB7D, 0xF7B6, 0x010A,
0xFE27, 0x07CE, 0x0501, 0x0E6F, 0x0A13, 0x0E7C, 0x0C08, 0x0796,
0x0ADE, 0xFD58, 0x048A, 0xF536, 0xF923, 0xF436, 0xF0C5, 0xF892,
0xF24A, 0xFCFB, 0xF9D0, 0x020E, 0x02B8, 0x09D5, 0x099A, 0x0DB4,
0x0D07, 0x082C, 0x0CFB, 0xFED4, 0x082C, 0xF8E8, 0xFF83, 0xF7F7,
0xF6DE, 0xFA8D, 0xF648, 0xFF7A, 0xFD47, 0x065B, 0x04B9, 0x0BC3,
0x098A, 0x0B70, 0x0A6D, 0x05BD, 0x07C6, 0xFD8E, 0x01FC, 0xF713,
0xF94A, 0xF55A, 0xF1DE, 0xF6FA, 0xF314, 0xFBA9, 0xFB62, 0x0427,
0x052E, 0x0B84, 0x0C4F, 0x0CEA, 0x0E82, 0x0989, 0x0D5A, 0x02F4,
0x071A, 0xFAA7, 0xFD12, 0xF71A, 0xF52C, 0xFADD, 0xF54E, 0xFF33,
0xFC10, 0x028B, 0x0338, 0x0775, 0x083A, 0x09E7, 0x08CB, 0x0763,
0x058F, 0x0123, 0x0053, 0xF7D9, 0xF91C, 0xF2C9, 0xF2AC, 0xF743,
0xF4A3, 0xFDDF, 0xFDAC, 0x0318, 0x0744, 0x09B5, 0x0EF6, 0x0DAF,
0x0F3E, 0x0A8F, 0x0A0B, 0x0346, 0x034E, 0xFCB3, 0xFB01, 0xF897,
0xF4E3, 0xF801, 0xF4EA, 0xFA91, 0xFA64, 0xFF0F, 0x02A0, 0x05C5,
0x094E, 0x0A42, 0x095E, 0x076A, 0x05AA, 0xFFF7, 0xFFDE, 0xF92B,
0xF8F0, 0xF675, 0xF54E, 0xF949, 0xF7B7, 0xFE67, 0x001D, 0x031F,
0x0914, 0x085A, 0x0E80, 0x0AD0, 0x0D77, 0x08E4, 0x0781, 0x04E7,
0x0124, 0xFD05, 0xF924, 0xF4AD, 0xF15B, 0xF4AE, 0xF1BB, 0xFAD9,
0xF8C0, 0x0098, 0x00D1, 0x0559, 0x0994, 0x06EC, 0x0B0C, 0x04DA,
0x0562, 0x01D2, 0x0073, 0xFD76, 0xFB59, 0xF8DE, 0xF7C7, 0xF8CD,
0xF8CC, 0xFE38, 0xFE1E, 0x028D, 0x0615, 0x0593, 0x0D0B, 0x09F4,
0x0DF7, 0x08C0, 0x084E, 0x0195, 0xFEF7, 0xFAEE, 0xF5FE, 0xF5EB,
0xF058, 0xF644, 0xEFD9, 0xFC24, 0xF745, 0xFF25, 0x0200, 0x014B,
0x0A37, 0x0610, 0x0C91, 0x077D, 0x097C, 0x04F8, 0x0422, 0x0011,
0xFC35, 0xFA83, 0xF53E, 0xF8DC, 0xF48F, 0xFB71, 0xFA58, 0x0010,
0x0376, 0x04A6, 0x0C67, 0x05C0, 0x0DBC, 0x033C, 0x06B2, 0x0046,
0xFE37, 0xFD7C, 0xF52D, 0xFA0E, 0xEF3D, 0xF77E, 0xF17F, 0xF934,
0xF95A, 0xFD65, 0x0334, 0x02C7, 0x0E40, 0x08CB, 0x13F7, 0x0885,
0x0F9A, 0x0523, 0x0548, 0x037F, 0xF9A8, 0xFD37, 0xF28A, 0xF7C1,
0xF329, 0xFBA2, 0xF97D, 0xFFB2, 0x01D9, 0x0055, 0x0A5A, 0x0259,
0x0DA8, 0x030A, 0x07E0, 0x0315, 0xFE68, 0x01C8, 0xF4D4, 0xFA9D,
0xEF49, 0xF4F7, 0xF14A, 0xF990, 0xF948, 0x01A1, 0x0617, 0x04A1,
0x121F, 0x06F1, 0x1580, 0x09AF, 0x0F85, 0x06C5, 0x039A, 0x0110,
0xF77D, 0xFC50, 0xF0B1, 0xF814, 0xF0C9, 0xF89A, 0xF75D, 0xFC99,
0x0069, 0xFF51, 0x0AC2, 0x0417, 0x10DD, 0x07DA, 0x0ABB, 0x0403,
0xFFEA, 0xFD57, 0xF5A1, 0xF992, 0xEF24, 0xFA6B, 0xF450, 0xFD78,
0xFE11, 0x0051, 0x0795, 0x06CF, 0x1252, 0x0B34, 0x14F8, 0x0748,
0x0E70, 0x02DE, 0x01A2, 0xFFDE, 0xF2F2, 0xFB4F, 0xED29, 0xF6F2,
0xEE01, 0xF6CB, 0xF47D, 0xFDAD, 0x014A, 0x0569, 0x0B9A, 0x0772,
0x0F5B, 0x0339, 0x0A56, 0xFDC3, 0xFF9E, 0xFFAA, 0xF7A3, 0x0057,
0xF2E6, 0xFAD2, 0xF510, 0xFEC5, 0xFEE5, 0x05B5, 0x075C, 0x0514,
0x0EC6, 0x0514, 0x1026, 0x02EB, 0x0951, 0xFFB0, 0x01F0, 0xFF11,
0xF4C9, 0xFAE0, 0xEAC7, 0xF987, 0xF028, 0xFE50, 0xF8C7, 0x01B4,
0xFF5F, 0x0133, 0x075A, 0xFEA3, 0x0CC0, 0x01B8, 0x0D64, 0x04C8,
0x0768, 0x0121, 0xFC1D, 0x02E2, 0xF51F, 0x04A4, 0xF5E7, 0xFFC4,
0xFAF1, 0xFE72, 0xFFC3, 0xFFA1, 0x0570, 0x01C7, 0x0C8D, 0x00E0,
0x0B25, 0xFBC9, 0x00F7, 0xFE82, 0xF76D, 0x0212, 0xF080, 0xFF6A,
0xED69, 0xFC67, 0xF13A, 0xF837, 0xFA92, 0xFCDB, 0x06B3, 0x04DD,
0x0FB8, 0x015B, 0x113D, 0x033A, 0x0D45, 0x09EA, 0x01DF, 0x0580,
0xF39E, 0xFDAC, 0xEDE2, 0xF94B, 0xF123, 0xFB21, 0xFA15, 0xFE01,
0x045D, 0xFB72, 0x0A06, 0xFE36, 0x0DAE, 0x0466, 0x0B4E, 0x0523,
0xFB39, 0x00AE, 0xEA5F, 0xF74A, 0xE761, 0xF772, 0xF0AD, 0xFE21,
0xFC8F, 0xFC98, 0x08FB, 0x0224, 0x15D1, 0x0C66, 0x1848, 0x0A83,
0x0E14, 0x0325, 0xFCF6, 0xFCC5, 0xEBC1, 0xFC1D, 0xE768, 0xFBED,
0xEE7A, 0xF483, 0xF6F6, 0xF864, 0x0549, 0x0585, 0x1311, 0x080D,
0x10FE, 0x03A7, 0x0389, 0xFBD4, 0xF64B, 0xFAC6, 0xED58, 0xFF87,
0xE95B, 0xF9D2, 0xF14B, 0xFA9B, 0x03B6, 0x07ED, 0x1142, 0x0C5F,
0x14B9, 0x0613, 0x0F6C, 0xFDD2, 0x048A, 0xFE24, 0xF8FF, 0x004F,
0xEB9F, 0xF638, 0xE513, 0xF4AF, 0xF050, 0xFFF7, 0x01C1, 0x04D5,
0x0A15, 0x0473, 0x07A5, 0xFD7E, 0x0593, 0xFBB3, 0x05FF, 0x01B3,
0xFB65, 0xFB3C, 0xF028, 0xFA68, 0xF306, 0x0666, 0xFC76, 0x086B,
0x04C9, 0x0371, 0x06E1, 0xFE50, 0x080E, 0xFFB9, 0x0A3E, 0x034D,
0x02E2, 0xF920, 0xF900, 0xF5A5, 0xF3E7, 0x0067, 0xF202, 0x047C,
0xF552, 0x00F1, 0xF6D7, 0xF8F4, 0xFCFE, 0xFBF6, 0x0A06, 0x056B,
0x0A9A, 0xFCE1, 0x06FB, 0xFB39, 0x0810, 0x0805, 0x01E2, 0x0AB2,
0xF63D, 0x04F3, 0xEF47, 0xF9D2, 0xF629, 0xF9BC, 0x020D, 0x043F,
0x039D, 0xFCA1, 0x0665, 0xF6DF, 0x0C32, 0x00EC, 0x0880, 0x0658,
0xFBC3, 0x03E5, 0xE907, 0xF947, 0xE5AD, 0xF80A, 0xF6AF, 0x007E,
0x0078, 0xFB8B, 0x076B, 0xFCD5, 0x15A2, 0x0943, 0x1A60, 0x0DBD,
0x0D4C, 0x0913, 0xF758, 0xFB93, 0xEABE, 0xFA0C, 0xEBC6, 0x0114,
0xF00F, 0xF776, 0xFC48, 0xF578, 0x0ED1, 0x0148, 0x17AC, 0x072A,
0x10ED, 0x0636, 0xFDF2, 0xFADD, 0xEF7D, 0xF92C, 0xEA9E, 0x011C,
0xE6F1, 0xF840, 0xF15A, 0xF661, 0x0B71, 0x0578, 0x1CFA, 0x0EF2,
0x1980, 0x0B75, 0x09A9, 0xFD14, 0xFF3B, 0xFBE3, 0xF7E4, 0x0304,
0xE778, 0xF944, 0xE3BB, 0xF48A, 0xF98A, 0xFC0E, 0x0F1A, 0x03A4,
0x127F, 0x0727, 0x0827, 0xFCB0, 0x01A4, 0xFAF2, 0xFFEE, 0x035C,
0xF3D4, 0xFAB1, 0xEA8A, 0xF81B, 0xF4D7, 0x03F4, 0x0755, 0x0A7F,
0x0EB4, 0x08BF, 0x0871, 0xFDEF, 0x0898, 0xFD54, 0x0A5D, 0x03F5,
0xFAF7, 0xFBA6, 0xF03E, 0xF7FC, 0xF5B6, 0xFE23, 0xFB5E, 0x0284,
0xFC42, 0x02CC, 0xFA63, 0xF97F, 0x00C9, 0xFC4B, 0x09E5, 0x05B2,
0x0341, 0xFC69, 0xFC94, 0xFA9F, 0x02D5, 0x0576, 0x0653, 0x0BA8,
0xFC39, 0x0971, 0xF028, 0xFAD0, 0xFAC7, 0xF9ED, 0x0B21, 0x03BD,
0x04C2, 0xFCF6, 0x0018, 0xFB53, 0x088D, 0x0170, 0x0B65, 0x0346,
0xFE2C, 0x02A7, 0xE791, 0xF8C9, 0xE854, 0xF935, 0xFC13, 0x0049,
0x018E, 0xFA37, 0x05DF, 0xFD06, 0x12AB, 0x0712, 0x186C, 0x0D33,
0x0CA5, 0x0BF1, 0xF1BD, 0xFCBC, 0xE87C, 0xFBA9, 0xF2C6, 0x00AE,
0xF58B, 0xF6A5, 0xFEAF, 0xFA65, 0x1173, 0x03CB, 0x1AD8, 0x0590,
0x0FDE, 0x04F0, 0xF58F, 0xFA35, 0xEBF9, 0xFC14, 0xEDCE, 0x0257,
0xE8A9, 0xF831, 0xF4FB, 0xF957, 0x0FD1, 0x03CD, 0x2101, 0x0C89,
0x1B25, 0x0D6D, 0x0115, 0xFEEC, 0xF70C, 0xFF24, 0xF794, 0x02FF,
0xE89D, 0xF778, 0xE784, 0xFA02, 0x003D, 0x0088, 0x17D6, 0x02F7,
0x16BC, 0x03CE, 0x020D, 0xF9BF, 0xFB98, 0xFEE9, 0xFAB7, 0x042F,
0xEC9D, 0xF818, 0xEA3B, 0xFBD6, 0xF96F, 0x040C, 0x0D8F, 0x0734,
0x148B, 0x078C, 0x0775, 0xFD86, 0x0487, 0x0256, 0x054A, 0x0558,
0xF4DC, 0xF839, 0xEE2E, 0xFC8E, 0xF8D4, 0x03EB, 0x0282, 0x0320,
0x0175, 0xFD27, 0xFA8E, 0xF27C, 0x01BF, 0xFD89, 0x076E, 0x041E,
0xFAAC, 0xF924, 0xF6DC, 0x001E, 0x019F, 0x0800, 0x083E, 0x0911,
0xFE9C, 0x05F4, 0xF1FF, 0xF8A4, 0xFD32, 0xFCC7, 0x08CC, 0x0060,
0x0034, 0xF664, 0xFD92, 0xFE77, 0x06D1, 0x07E9, 0x0B8D, 0x07A5,
0xFD50, 0xFFD3, 0xE7A8, 0xF34A, 0xED50, 0xFABB, 0xFE27, 0xFCE7,
0xFE4E, 0xF31F, 0x0207, 0xFE9E, 0x0FCA, 0x0AA2, 0x1494, 0x0CE1,
0x048F, 0x0795, 0xEFDE, 0xFBB6, 0xEEB8, 0x011D, 0xF396, 0xFE81,
0xF597, 0xEFCB, 0x0217, 0xF9C0, 0x13AE, 0x073D, 0x19FE, 0x0960,
0x0853, 0x01A7, 0xEF97, 0xF6BD, 0xED86, 0xFF67, 0xEF23, 0xFF50,
0xEA54, 0xF0EE, 0xF980, 0xF8B1, 0x1477, 0x064A, 0x203D, 0x0A98,
0x1195, 0x0602, 0xFB66, 0xFE9F, 0xF7B1, 0x066A, 0xF41F, 0x017C,
0xE7FD, 0xF1D6, 0xEF59, 0xF99E, 0x0A84, 0x02DE, 0x1BFC, 0x03ED,
0x112E, 0xFDC7, 0xFD31, 0xF66E, 0xF9C0, 0x0303, 0xF528, 0x03EC,
0xE9BE, 0xF59E, 0xEF70, 0xFD65, 0x03CE, 0x087F, 0x13F9, 0x0707,
0x0F50, 0xFE13, 0x0353, 0xF9DB, 0x0660, 0x07CC, 0x004B, 0x05BD,
0xED9C, 0xF70D, 0xF0D5, 0xFF80, 0x0401, 0x091A, 0x0B91, 0x0621,
0x0264, 0xF8CE, 0xFBC0, 0xEF77, 0x03DA, 0xFE2B, 0x018C, 0x01A6,
0xF34C, 0xF7BB, 0xF68A, 0x0377, 0x072A, 0x0F62, 0x0C92, 0x0C37,
0xFD46, 0xFEB2, 0xF5A5, 0xF59E, 0x0681, 0x015B, 0x08D8, 0xFF0E,
0xF91D, 0xF364, 0xFC83, 0x01B8, 0x0CA2, 0x0F79, 0x0DD5, 0x0C7D,
0xFA59, 0xFDB2, 0xED71, 0xF25D, 0xF94C, 0xFBA5, 0xFEC5, 0xF986,
0xF882, 0xF008, 0x02FE, 0x00A4, 0x1565, 0x1255, 0x14FE, 0x1321,
0xFDEA, 0x050C, 0xEFC6, 0xFB1E, 0xFACF, 0x0578, 0xFCEE, 0xFD3C,
0xF4F8, 0xEC34, 0x027F, 0xFA39, 0x199F, 0x0C1D, 0x1A15, 0x0E28,
0xFFB9, 0x0350, 0xEE6B, 0xFA92, 0xF675, 0x0298, 0xF3FD, 0xFC1A,
0xEAE5, 0xEE23, 0xFDB6, 0xFA92, 0x1B0B, 0x0A0F, 0x1F61, 0x0CC8,
0x069F, 0x0379, 0xF4AD, 0xFF92, 0xFC45, 0x0CEC, 0xF979, 0x0362,
0xEB3A, 0xF06B, 0xF708, 0xFA20, 0x1496, 0x05E2, 0x1E45, 0x049B,
0x07E6, 0xFB1D, 0xF62E, 0xF89A, 0xFDAF, 0x0722, 0xF768, 0x030F,
0xE6CF, 0xF521, 0xF432, 0xFFBB, 0x10BE, 0x0A97, 0x1990, 0x076B,
0x0881, 0xF9AA, 0xFC5F, 0xF660, 0x05A7, 0x095D, 0x0080, 0x0708,
0xED6F, 0xF91D, 0xF3C1, 0x028D, 0x0C34, 0x0AC4, 0x1395, 0x052F,
0xFFE2, 0xF62F, 0xF5F8, 0xEF2D, 0x04F0, 0xFD25, 0x001F, 0xFD64,
0xEC8D, 0xF7F3, 0xF508, 0x088A, 0x0C9F, 0x1282, 0x115C, 0x0C50,
0xFD15, 0xFB6C, 0xF289, 0xF226, 0x03A1, 0xFDCF, 0x0672, 0xFAD8,
0xF6A3, 0xF4C3, 0xFB38, 0x0644, 0x0E8E, 0x1317, 0x1109, 0x0E6F,
0xFA68, 0xFCAE, 0xED42, 0xF21A, 0xFB8C, 0xF99C, 0xFEC2, 0xF1ED,
0xF458, 0xEBF5, 0xFD50, 0x0222, 0x1211, 0x13BF, 0x1444, 0x14D1,
0xFBC5, 0x05F6, 0xED5C, 0xFA0E, 0xFAAD, 0xFFEB, 0xFC67, 0xF68C,
0xF3F7, 0xEBD9, 0x00FB, 0xFAF9, 0x14DF, 0x0B05, 0x1512, 0x0DF4,
0xFD1D, 0x0405, 0xEC4B, 0xFE16, 0xF5EA, 0x01EF, 0xF762, 0xF3DF,
0xEDC1, 0xEA6D, 0xFAA3, 0xFA18, 0x1523, 0x06C9, 0x1941, 0x0B90,
0x005D, 0x056C, 0xF0D8, 0x026C, 0xF91C, 0x0A35, 0xF6DB, 0xFCA1,
0xEE9A, 0xEFA8, 0xFB90, 0xFB5D, 0x1130, 0x0313, 0x1635, 0x0072,
0x02FA, 0xFA1A, 0xF3D9, 0xFDAE, 0xF998, 0x0974, 0xF67D, 0xFE48,
0xEBE2, 0xF354, 0xF7AE, 0xFE60, 0x0F2A, 0x0599, 0x13A7, 0x0327,
0x01CE, 0xF794, 0xF85F, 0xF893, 0xFFAE, 0x0869, 0xF9A5, 0x016C,
0xEEDD, 0xFAC4, 0xFAFE, 0x064B, 0x0ED7, 0x089B, 0x0F0B, 0x00EA,
0xFC13, 0xF27C, 0xF557, 0xF04D, 0xFF68, 0xFDAC, 0xFA57, 0xF929,
0xEFCC, 0xF8DD, 0xFB2F, 0x0B61, 0x0DDD, 0x1111, 0x0EDD, 0x090F,
0xFC9B, 0xF9A4, 0xF3E6, 0xF45E, 0xFF3A, 0xFB27, 0xFDEB, 0xF3B1,
0xF4E8, 0xF639, 0x00EA, 0x0B7C, 0x121A, 0x145B, 0x0DE9, 0x0D28,
0xF88F, 0xFA9B, 0xF16C, 0xF480, 0xFB03, 0xF9AE, 0xF847, 0xEC32,
0xF470, 0xECAD, 0x02C9, 0x05DA, 0x120B, 0x1371, 0x0FAF, 0x133D,
0xFB52, 0x060E, 0xF1E3, 0xFD3E, 0xFC1D, 0xFE58, 0xF870, 0xEF81,
0xF21C, 0xEB0C, 0x0479, 0xFE63, 0x1825, 0x0C69, 0x11DA, 0x0EB8,
0xFA72, 0x0506, 0xF2D4, 0x018D, 0xFA6D, 0x01D3, 0xF4A1, 0xEF15,
0xEFB4, 0xEAEA, 0x007A, 0xFBD7, 0x1448, 0x04A4, 0x13F0, 0x0938,
0xFF50, 0x0724, 0xF5D7, 0x08A8, 0xFD52, 0x0AD1, 0xF669, 0xF697,
0xEFB8, 0xEF6D, 0x00D9, 0xFDFC, 0x147B, 0x01F0, 0x122C, 0xFF86,
0xFE44, 0xFB66, 0xF79A, 0x025A, 0xFE6C, 0x0B09, 0xF6A1, 0xFAE1,
0xF059, 0xF4C6, 0x00A4, 0x0247, 0x11C6, 0x044D, 0x0E21, 0xFE99,
0xFDA3, 0xF7CB, 0xFBBF, 0xFE43, 0x02F2, 0x08CE, 0xF9C5, 0xFD2F,
0xF2F8, 0xFC44, 0x0181, 0x0976, 0x1311, 0x0817, 0x0E04, 0x0058,
0xF7F5, 0xF4A4, 0xF6A1, 0xF59A, 0x0324, 0xFF3B, 0xFB4E, 0xF770,
0xF4ED, 0xFD0D, 0x0508, 0x1049, 0x12B2, 0x0FA5, 0x0A57, 0x059F,
0xF787, 0xFAC6, 0xF655, 0xFA37, 0x005C, 0xFC77, 0xFBED, 0xF07F,
0xF82C, 0xF8BF, 0x0705, 0x0FD5, 0x1684, 0x13B8, 0x0CBF, 0x0AA5,
0xF49A, 0xFB7C, 0xF29F, 0xF90B, 0xFC19, 0xFA3E, 0xF627, 0xEA81,
0xF6F2, 0xF00D, 0x0B3F, 0x0ADA, 0x197C, 0x14A1, 0x0D57, 0x0F8E,
0xF658, 0x046E, 0xF5CC, 0x0297, 0xFD4C, 0x0029, 0xF44E, 0xEBDF,
0xF44C, 0xEC89, 0x0A2C, 0x023A, 0x1BEB, 0x0D28, 0x11F1, 0x0DE0,
0xF885, 0x05F0, 0xF3C7, 0x04C7, 0xFAC7, 0x01B4, 0xF2B8, 0xEDA7,
0xF183, 0xED13, 0x0736, 0xFF73, 0x1AF4, 0x0634, 0x120C, 0x06A1,
0xFB1F, 0x05CD, 0xF9D7, 0x0BAE, 0xFE98, 0x0A6A, 0xF318, 0xF425,
0xF163, 0xF157, 0x0501, 0x007D, 0x16E9, 0x02BE, 0x10CF, 0xFEEF,
0xFC8E, 0xFD38, 0xFB34, 0x06BD, 0x0062, 0x09D1, 0xF410, 0xF840,
0xF13C, 0xF6C1, 0x0544, 0x0576, 0x15B6, 0x06AD, 0x0C37, 0xFDDE,
0xF941, 0xF73C, 0xFD3B, 0x0166, 0x0505, 0x0945, 0xF89F, 0xFB5D,
0xF37B, 0xFC41, 0x04F5, 0x0A0B, 0x1412, 0x0907, 0x0941, 0xFFBC,
0xF567, 0xF669, 0xF95F, 0xF9A0, 0x025C, 0xFDD0, 0xF8F9, 0xF5E7,
0xF6B6, 0xFDA9, 0x0750, 0x0FA4, 0x1491, 0x0FE8, 0x0833, 0x0499,
0xF23A, 0xFA42, 0xF5DC, 0xFB81, 0x0101, 0xFA86, 0xFA97, 0xEF23,
0xFAF0, 0xF9BA, 0x0CC8, 0x0F4E, 0x1701, 0x1186, 0x07AF, 0x0825,
0xF20C, 0xFEC2, 0xF3B9, 0xFE38, 0xFB3D, 0xF805, 0xF581, 0xE86F,
0xF97B, 0xF244, 0x0F44, 0x0BAC, 0x1C3B, 0x132C, 0x0A89, 0x0BD3,
0xF27A, 0x020A, 0xF3DC, 0x022A, 0xF9FA, 0xFD72, 0xF3EF, 0xEB0D,
0xF8FF, 0xEE54, 0x0FF7, 0x033D, 0x1E83, 0x0C3E, 0x0EAF, 0x0A05,
0xF59B, 0x05A2, 0xF451, 0x0718, 0xF85E, 0xFF81, 0xEF74, 0xECE6,
0xF37A, 0xF05F, 0x0CE1, 0x01DE, 0x1CD9, 0x07D6, 0x0EEE, 0x0690,
0xFABF, 0x049A, 0xF8BE, 0x08D6, 0xF8B1, 0x049D, 0xEFA5, 0xF296,
0xF335, 0xF45F, 0x0AB0, 0x02E8, 0x1ADB, 0x031A, 0x0E17, 0xFE31,
0xFB4D, 0x0013, 0xFCB0, 0x0895, 0xFBEB, 0x04FE, 0xEE29, 0xF48B,
0xF0EC, 0xF858, 0x08C2, 0x0878, 0x1745, 0x08FB, 0x0BC7, 0xFF7A,
0xFC1A, 0xFA13, 0xFF09, 0x016F, 0x012F, 0x03A9, 0xF365, 0xF79C,
0xF2AD, 0xFB64, 0x08E2, 0x09EE, 0x154D, 0x09F8, 0x076D, 0x0126,
0xF83D, 0xFA5D, 0xFD16, 0xFD0A, 0x007F, 0xFCD9, 0xF615, 0xF3B1,
0xF695, 0xFBA1, 0x08F3, 0x0D65, 0x1396, 0x0F71, 0x0571, 0x0712,
0xF53E, 0xFE2A, 0xFB77, 0xFBA3, 0x010D, 0xF7A4, 0xF726, 0xEF40,
0xFAF5, 0xF985, 0x0FB7, 0x0B9F, 0x159F, 0x0CD9, 0x03B4, 0x065A,
0xF309, 0x01D0, 0xF711, 0x00A5, 0xFC60, 0xF807, 0xF480, 0xE9E7,
0xF963, 0xF389, 0x1187, 0x0A2A, 0x19A0, 0x102A, 0x053A, 0x0B06,
0xF361, 0x04DB, 0xF739, 0x020A, 0xFA8D, 0xFAB4, 0xF2EA, 0xEC7F,
0xFA16, 0xF0E4, 0x128E, 0x030C, 0x1C7C, 0x0975, 0x09DA, 0x06CF,
0xF44A, 0x04B9, 0xF440, 0x0604, 0xF6B9, 0xFE14, 0xED8B, 0xEF38,
0xF474, 0xF422, 0x0FD1, 0x02BB, 0x1AB4, 0x0741, 0x0A35, 0x08E0,
0xF98B, 0x07B0, 0xF8CE, 0x04F5, 0xF7EA, 0xFEC2, 0xEE84, 0xF30C,
0xF460, 0xF76F, 0x0E93, 0x03E7, 0x1BA8, 0x01E7, 0x0C17, 0xFE11,
0xFB98, 0x0096, 0xFC71, 0x04CF, 0xF9AD, 0xFEFD, 0xEC5F, 0xF2A0,
0xF0BC, 0xF9BE, 0x0A95, 0x0886, 0x16A1, 0x0857, 0x087C, 0x0320,
0xFB99, 0xFFFF, 0xFFA3, 0x0090, 0xFFCB, 0xFD32, 0xF1F2, 0xF38E,
0xF2A5, 0xFAD7, 0x09C4, 0x0931, 0x1486, 0x0898, 0x061C, 0x0306,
0xFAA8, 0xFD24, 0xFE9F, 0xFC6F, 0xFE0B, 0xFB0A, 0xF366, 0xF214,
0xF4F2, 0xF9A1, 0x0861, 0x0A23, 0x110E, 0x0BA5, 0x0168, 0x0921,
0xF524, 0x0552, 0xFCE9, 0xFDE7, 0x003C, 0xF59E, 0xF604, 0xEEF8,
0xF9C8, 0xF961, 0x0D71, 0x07C8, 0x11D7, 0x0891, 0x009F, 0x068A,
0xF3FB, 0x018A, 0xF83E, 0xFE3A, 0xFB0C, 0xF84A, 0xF3E1, 0xEBB3,
0xF909, 0xF48F, 0x0ED8, 0x0784, 0x147A, 0x09E2, 0x0027, 0x0994,
0xF1D1, 0x081D, 0xF781, 0x0273, 0xFA06, 0xFA49, 0xF3DF, 0xEEAE,
0xFC4A, 0xF398, 0x1190, 0x022B, 0x1638, 0x0559, 0x0417, 0x0521,
0xF560, 0x0253, 0xF703, 0x0056, 0xF656, 0xFC7E, 0xEE79, 0xF1BF,
0xF7B0, 0xF6B6, 0x0FA3, 0x02D0, 0x150E, 0x03B6, 0x034C, 0x06AC,
0xF548, 0x0655, 0xF6C9, 0x0177, 0xF6A7, 0xFBBB, 0xEF02, 0xF20A,
0xF728, 0xF970, 0x0F6A, 0x05BD, 0x1587, 0x020C, 0x0426, 0x0150,
0xF895, 0xFFD0, 0xFACA, 0xFBBA, 0xF6AE, 0xF9DC, 0xEB7F, 0xF29F,
0xF3A3, 0xF9BD, 0x0B13, 0x0899, 0x115D, 0x07EF, 0x0362, 0x0552,
0xF806, 0x01EC, 0xFAAE, 0xFE12, 0xFAC6, 0xF97C, 0xF059, 0xF016,
0xF667, 0xF9AA, 0x0DE8, 0x084B, 0x1177, 0x06A4, 0x0097, 0x06E3,
0xF9D2, 0x0119, 0xFEC0, 0xF892, 0xFAD3, 0xF672, 0xEF9B, 0xEF35,
0xF6F5, 0xF7AB, 0x0BF6, 0x088D, 0x0E2F, 0x090C, 0xFDBA, 0x09B5,
0xF468, 0x06F7, 0xFA7E, 0xFF08, 0xFC26, 0xF7C4, 0xF2B7, 0xECF6,
0xFA54, 0xF5B2, 0x1178, 0x05E8, 0x11DD, 0x0643, 0xFDA5, 0x0838,
0xF4D9, 0x055A, 0xFB3F, 0xFEBD, 0xFB98, 0xF9EF, 0xF24A, 0xEE0C,
0xF9F2, 0xF4C5, 0x0FCA, 0x054B, 0x103C, 0x0644, 0xFD2E, 0x094A,
0xF304, 0x0786, 0xF70E, 0x01C9, 0xF875, 0xFED7, 0xF33E, 0xF256,
0xFDB8, 0xF586, 0x14BB, 0x02D2, 0x154E, 0x0183, 0x007A, 0x044A,
0xF56F, 0x0446, 0xFA4D, 0xFF69, 0xF961, 0xFD17, 0xEFE6, 0xF41A,
0xFB03, 0xFAB7, 0x14C5, 0x0748, 0x1515, 0x041B, 0x006C, 0x05BC,
0xF690, 0x038B, 0xF9DD, 0xFF1E, 0xF85B, 0xFF6B, 0xF089, 0xF5BC,
0xFA81, 0xFBD5, 0x1499, 0x09DC, 0x1945, 0x04FB, 0x03FD, 0x02E5,
0xF60A, 0xFEF3, 0xFB34, 0xF9A3, 0xFB3E, 0xFA57, 0xEFA3, 0xF347,
0xF762, 0xFBB2, 0x10A5, 0x0C0B, 0x13F9, 0x0B1F, 0x021E, 0x0A94,
0xF7ED, 0x02B9, 0xF984, 0xF94D, 0xF8D3, 0xF8D4, 0xF206, 0xF1F3,
0xFA16, 0xFA23, 0x11B9, 0x0963, 0x1600, 0x0959, 0x03A1, 0x0BEC,
0xF88D, 0x05AB, 0xFC73, 0xFAA3, 0xFBB5, 0xF6D3, 0xF251, 0xED6C,
0xFA42, 0xF77C, 0x118F, 0x0A15, 0x131B, 0x0AE0, 0xFFD6, 0x0F2D,
0xF6A6, 0x0B55, 0xFB97, 0x00C6, 0xFB38, 0xFB6E, 0xF230, 0xEF5E,
0xFB26, 0xF577, 0x1391, 0x04EF, 0x1624, 0x0655, 0x02B1, 0x0BCB,
0xF61A, 0x08D0, 0xFA22, 0x01C8, 0xFD3E, 0xFF87, 0xF563, 0xF132,
0xFAEA, 0xF416, 0x119D, 0x0298, 0x1557, 0x04B3, 0x0263, 0x0CC7,
0xF5B6, 0x0AC5, 0xF7AA, 0x036B, 0xF885, 0x02A6, 0xF2FC, 0xF81B,
0xFD12, 0xFAB0, 0x131D, 0x0192, 0x157C, 0xFD8F, 0x048B, 0x04F7,
0xF761, 0x04BC, 0xF8D6, 0x00A2, 0xFA68, 0x028F, 0xF32E, 0xF8B8,
0xFC1E, 0xFEB9, 0x13DF, 0x08BB, 0x15C9, 0x01AF, 0x02F0, 0x03EA,
0xF684, 0x0190, 0xF851, 0xFE68, 0xF824, 0xFFD4, 0xF012, 0xF78D,
0xFA76, 0x0128, 0x1313, 0x0BA3, 0x172B, 0x0436, 0x05B6, 0x034E,
0xF683, 0xFB96, 0xF7A9, 0xF7D4, 0xFA16, 0xFC5A, 0xF339, 0xF4ED,
0xFA85, 0xFFAB, 0x103B, 0x0D72, 0x1592, 0x0A96, 0x06A8, 0x0D3A,
0xF824, 0x024D, 0xF7C1, 0xF772, 0xF83A, 0xF751, 0xF0F5, 0xF08D,
0xFB1B, 0xFDB5, 0x1168, 0x0BCB, 0x1409, 0x084D, 0x05CA, 0x0BC0,
0xF998, 0x0459, 0xF8C9, 0xFA0A, 0xF909, 0xF595, 0xF2FD, 0xEBA4,
0xFBA3, 0xF96A, 0x113E, 0x09EB, 0x14BC, 0x0AAC, 0x04A1, 0x10FE,
0xF7DB, 0x0A70, 0xF8F6, 0x0257, 0xF88F, 0xFA6C, 0xF031, 0xE8D7,
0xF9BA, 0xF3DC, 0x10FD, 0x04C3, 0x1549, 0x0509, 0x0605, 0x0BD8,
0xF756, 0x0829, 0xF629, 0x03C3, 0xF79B, 0x00A6, 0xF1FA, 0xEF04,
0xFA93, 0xF2D2, 0x1005, 0xFF24, 0x13EB, 0x0196, 0x05D4, 0x0BA2,
0xF907, 0x0A91, 0xF6CA, 0x0809, 0xF5FF, 0x040A, 0xF030, 0xF432,
0xF9EC, 0xF945, 0x1048, 0xFF18, 0x1434, 0xFA6E, 0x05C6, 0x01EC,
0xF9B2, 0x01CE, 0xF86C, 0x048C, 0xF60B, 0x060C, 0xEF74, 0xF7CC,
0xFB40, 0xFFCB, 0x117B, 0x0701, 0x13AC, 0xFC53, 0x056C, 0xFEC3,
0xF913, 0xFEBA, 0xF7FC, 0x0132, 0xF703, 0x02D0, 0xEE1C, 0xF72C,
0xF77C, 0x00AD, 0x1005, 0x0A92, 0x1510, 0x0269, 0x078B, 0xFE81,
0xFA53, 0xF5E1, 0xF772, 0xF8F7, 0xF630, 0xFF6D, 0xEFA0, 0xF70C,
0xF941, 0x0376, 0x0EAE, 0x0E32, 0x1292, 0x0819, 0x0671, 0x0753,
0xFAF5, 0xFB51, 0xF95E, 0xF6CA, 0xF69C, 0xF7FF, 0xEE11, 0xEF92,
0xF8E6, 0xFF5D, 0x0EBF, 0x0CEB, 0x1213, 0x08CC, 0x067A, 0x0A0F,
0xFB4F, 0xFDAE, 0xFA55, 0xF677, 0xF751, 0xF5A0, 0xEE2C, 0xEBBC,
0xF9EA, 0xFBF7, 0x1128, 0x0D08, 0x137E, 0x0C98, 0x051F, 0x0EF4,
0xF9F0, 0x0545, 0xFAEE, 0x00C5, 0xF8FB, 0xF94A, 0xEF0F, 0xE711,
0xF899, 0xF508, 0x0F90, 0x0583, 0x1502, 0x088A, 0x083A, 0x0FC6,
0xFB60, 0x0534, 0xFAA7, 0x01CF, 0xF7CB, 0x00A3, 0xEF33, 0xEDA9,
0xFA2B, 0xF417, 0x0FA2, 0x00E5, 0x1337, 0x04D5, 0x0774, 0x0EDA,
0xFC92, 0x08D5, 0xFBA1, 0x0792, 0xF805, 0x0458, 0xEE41, 0xF184,
0xF959, 0xF719, 0x109C, 0xFD2D, 0x13AF, 0xFC43, 0x070A, 0x06E7,
0xFE0D, 0x0360, 0xFE45, 0x0501, 0xF87A, 0x0645, 0xEDBA, 0xF817,
0xF99F, 0xFEEC, 0x1188, 0x02C3, 0x1545, 0xFDCE, 0x070A, 0x037A,
0xFBEC, 0xFECE, 0xFDD5, 0x04F1, 0xFAD6, 0x07DB, 0xEDF0, 0xF854,
0xF634, 0x012E, 0x0EBE, 0x0675, 0x1517, 0xFE97, 0x0890, 0x0071,
0xFD44, 0xF81D, 0xFD79, 0xFB70, 0xFA2B, 0x02BD, 0xEF91, 0xFB85,
0xF8C1, 0x0655, 0x0EA9, 0x0B5A, 0x12CB, 0x0636, 0x0727, 0x067F,
0xFD45, 0xF8B2, 0xFD13, 0xF8AF, 0xF94B, 0xFC40, 0xEF00, 0xF490,
0xF810, 0x04A2, 0x0DEF, 0x0C82, 0x11CA, 0x078C, 0x058D, 0x0955,
0xFD23, 0xFAD3, 0xFF17, 0xF5CD, 0xFA4B, 0xF69F, 0xEE46, 0xF11D,
0xF938, 0x03F3, 0x1129, 0x0F2A, 0x1436, 0x0E17, 0x0630, 0x10F4,
0xFBA0, 0x017E, 0xFDCB, 0xFAA0, 0xFB8A, 0xF63D, 0xEEB0, 0xEA02,
0xF578, 0xF9A9, 0x0CD9, 0x0753, 0x13E8, 0x0BA1, 0x07F5, 0x11FE,
0xFBB3, 0x0411, 0xFB7C, 0xFD90, 0xF9B3, 0xF81C, 0xEF81, 0xEB42,
0xF706, 0xF8C3, 0x0C28, 0x0261, 0x1194, 0x0835, 0x07A2, 0x1495,
0xFD92, 0x09E5, 0xFC8D, 0x04CE, 0xF867, 0xFE4D, 0xEE88, 0xEBF2,
0xF7AE, 0xF449, 0x0B5C, 0xFBCE, 0x0F83, 0xFFF6, 0x067B, 0x0C43,
0xFE3D, 0x0635, 0xFEAC, 0x05E9, 0xF9B4, 0x0181, 0xED92, 0xF262,
0xF739, 0xFB66, 0x0D66, 0xFDFE, 0x108B, 0xFE2F, 0x04D1, 0x0924,
0xFBD5, 0x0397, 0xFDA5, 0x0783, 0xFB0D, 0x065C, 0xEF18, 0xF566,
0xF58C, 0xFBE0, 0x09F2, 0xFD2B, 0x1006, 0xFAEB, 0x069D, 0x02E2,
0xFC0F, 0xFB6A, 0xFBF1, 0xFF41, 0xFA28, 0x02A2, 0xF0A6, 0xFA71,
0xF81A, 0x05D8, 0x0A90, 0x059A, 0x0E1A, 0xFFBB, 0x0571, 0x03B7,
0xFCC8, 0xF9F9, 0xFB8B, 0xFD58, 0xF7C5, 0xFF4D, 0xEFDB, 0xF6D8,
0xF9D5, 0x0517, 0x0B1D, 0x073F, 0x0CF3, 0x023B, 0x056B, 0x0477,
0xFE74, 0xF5CE, 0xFD7A, 0xF590, 0xF84F, 0xF791, 0xEDD0, 0xF28F,
0xF881, 0x0683, 0x0E15, 0x0EB5, 0x1041, 0x0C0B, 0x045C, 0x0C49,
0xFBC4, 0xFB41, 0xFCCD, 0xF7AF, 0xF876, 0xF4D9, 0xEDBC, 0xEC13,
0xF6C5, 0xFE0A, 0x0A1F, 0x0753, 0x0E85, 0x0B15, 0x06A3, 0x114D,
0xFDB2, 0x004B, 0xFD27, 0xF8E4, 0xF9DC, 0xF1CD, 0xEF7A, 0xE86B,
0xF75C, 0xFC7B, 0x09C5, 0x07B1, 0x0D9A, 0x0D12, 0x0672, 0x1610,
0xFF22, 0x08E0, 0xFDCA, 0x02CF, 0xF8B1, 0xF798, 0xF03F, 0xE677,
0xF9F1, 0xF47C, 0x0A18, 0xFD30, 0x0AF1, 0x03A4, 0x0415, 0x101E,
0x0018, 0x0874, 0x00A2, 0x0684, 0xF9C8, 0xFB77, 0xEF67, 0xE9F7,
0xF99F, 0xF5E3, 0x0B77, 0xFC6E, 0x0D4C, 0x02BE, 0x0387, 0x0EA3,
0xFC3D, 0x0778, 0xFF5F, 0x0AFB, 0xFBC8, 0x057C, 0xF052, 0xF1C9,
0xF986, 0xF6AA, 0x0C09, 0xF6F8, 0x0D29, 0xFA40, 0x033A, 0x05C0,
0xFCB1, 0x0154, 0xFE8A, 0x06DB, 0xFB95, 0x038B, 0xF3B2, 0xF82F,
0xFC15, 0x01A2, 0x0BE3, 0xFEB5, 0x0EBE, 0xFD46, 0x054C, 0x03E6,
0xFC59, 0xFC66, 0xFD6E, 0x0430, 0xF9D1, 0x04C4, 0xF1B6, 0xFA26,
0xFD50, 0x0551, 0x0E0B, 0x0407, 0x0D94, 0xFED5, 0x045A, 0xFF66,
0xFD85, 0xF5FD, 0xFE10, 0xFC8E, 0xF918, 0xFC62, 0xF05A, 0xF726,
0xFC60, 0x08BE, 0x0EEA, 0x0CF5, 0x0FE3, 0x0C2A, 0x0581, 0x097B,
0xFDD3, 0xF6EA, 0xFEC9, 0xF8FB, 0xF92B, 0xF8D8, 0xEF67, 0xF2C5,
0xFAC5, 0x03EA, 0x0D96, 0x09C0, 0x1084, 0x0DAB, 0x0610, 0x0EC2,
0xFD0C, 0xFB5B, 0x0074, 0xF7F3, 0xFC5E, 0xF1AE, 0xF12E, 0xEB72,
0xFBB7, 0x01AA, 0x0D48, 0x0BFB, 0x0F4B, 0x11D1, 0x06F0, 0x164C,
0xFF09, 0x05A7, 0xFF35, 0xFF22, 0xFA5D, 0xF2EE, 0xF123, 0xE731,
0xFB04, 0xF78F, 0x0CA2, 0x00FB, 0x0ECE, 0x0BEB, 0x03CD, 0x131A,
0xFD40, 0x06CF, 0x014F, 0x06B0, 0xFB5E, 0xF823, 0xF1F3, 0xE594,
0xFD48, 0xF482, 0x0D3E, 0xFEAC, 0x0EEE, 0x0A85, 0x04E0, 0x15B3,
0xFCF8, 0x0BAE, 0x00BC, 0x0CBF, 0xFC33, 0x02D8, 0xF0D6, 0xEFB5,
0xFB1F, 0xF388, 0x0DB5, 0xF4D5, 0x0E9B, 0xFF80, 0x020E, 0x0B3B,
0xFB2A, 0x05B3, 0xFF9E, 0x0BF9, 0xFC1B, 0x0436, 0xF3C9, 0xF5A3,
0xFD09, 0xFCFB, 0x0DEE, 0xFA31, 0x1123, 0xFDE5, 0x041D, 0x0646,
0xFAA3, 0x01B3, 0xFF78, 0x0AF7, 0xFB55, 0x05F1, 0xF19C, 0xFA39,
0xFC0E, 0x03B6, 0x0D03, 0xFF95, 0x0FD1, 0xFCDD, 0x0451, 0xFDD3,
0xFA3F, 0xF6E7, 0xFCF7, 0x0297, 0xFA89, 0x01F2, 0xF30F, 0xF968,
0xFD1C, 0x0680, 0x0E98, 0x0991, 0x112A, 0x09E2, 0x04CF, 0x040A,
0xFC74, 0xF4C8, 0xFF6E, 0xFC32, 0xFA2F, 0xFB96, 0xF1FC, 0xF7AA,
0xFBDA, 0x0751, 0x0C46, 0x0995, 0x1037, 0x0C9F, 0x03E8, 0x09BC,
0xFA47, 0xF5CC, 0xFEC9, 0xF5A2, 0xFB20, 0xF242, 0xF290, 0xEF6D,
0xFD64, 0x0335, 0x0E5C, 0x0C01, 0x10B2, 0x12E4, 0x052B, 0x1200,
0xFBA0, 0x00EB, 0xFDE1, 0xFC09, 0xFAD9, 0xEE70, 0xF334, 0xE80A,
0xFB43, 0xFC8A, 0x0B2B, 0x06DD, 0x0EFB, 0x1061, 0x0337, 0x1134,
0xFA43, 0x033F, 0xFC8E, 0x02B0, 0xF89E, 0xF36A, 0xF378, 0xE488,
0xFDFA, 0xF31D, 0x0BC3, 0x0071, 0x0E89, 0x108B, 0x0563, 0x1505,
0xFC6F, 0x08A1, 0xFDB0, 0x095E, 0xF933, 0xFBC0, 0xF25F, 0xEB16,
0xFD02, 0xF203, 0x0B43, 0xF7A4, 0x0BD9, 0x05AF, 0x01BB, 0x0E81,
0xFAC8, 0x0723, 0xFC53, 0x097E, 0xF75A, 0xFEA8, 0xF19E, 0xF22E,
0xFD4E, 0xF772, 0x0CF8, 0xF64A, 0x0F15, 0xFFBF, 0x0410, 0x0908,
0xFB7B, 0x05D5, 0xFE1C, 0x0C14, 0xF9A4, 0x01B6, 0xF2D4, 0xF5CD,
0xFDF1, 0xFEFF, 0x0C5B, 0xFD8F, 0x0D83, 0xFE0A, 0x0381, 0xFE73,
0xFB66, 0xFA6B, 0xFC51, 0x05A7, 0xF86D, 0x00E4, 0xF46F, 0xF8D7,
0xFF82, 0x0338, 0x0CC7, 0x03EE, 0x0E81, 0x0670, 0x057D, 0x0217,
0xFEAF, 0xF642, 0xFF1D, 0xFF42, 0xF802, 0xFDD4, 0xF3C6, 0xF8CC,
0x0140, 0x04A0, 0x0DC6, 0x0754, 0x0C28, 0x0BC9, 0x01BD, 0x070D,
0xFCD2, 0xF695, 0xFF6E, 0xF7D9, 0xF83C, 0xF41F, 0xF277, 0xF57B,
0x0060, 0x064E, 0x0F6F, 0x0956, 0x0ED0, 0x0EEB, 0x034F, 0x0DC0,
0xFD21, 0xFEE7, 0xFF50, 0xFB69, 0xF944, 0xEF9B, 0xF3EF, 0xECAA,
0xFFC9, 0x00C7, 0x0EC8, 0x0A0C, 0x0F3F, 0x119A, 0x022C, 0x0F50,
0xFAF3, 0x0212, 0xFD63, 0x006D, 0xF822, 0xF14F, 0xF4F0, 0xE89C,
0x01A5, 0xFA53, 0x0E4E, 0x0693, 0x0EBB, 0x12D6, 0x0679, 0x1391,
0x0009, 0x0771, 0xFEB2, 0x06C9, 0xF7D5, 0xF89D, 0xF49C, 0xEBEE,
0x02CE, 0xF4A1, 0x1022, 0xFC1E, 0x0D07, 0x0C33, 0x0252, 0x1267,
0xFEAA, 0x0841, 0xFEF9, 0x07C2, 0xF58E, 0xFB06, 0xF180, 0xF15E,
0x0185, 0xFA67, 0x10D7, 0xFB93, 0x0F85, 0x04CA, 0x04A4, 0x0CF0,
0x003D, 0x0917, 0x02E0, 0x0AD6, 0xFA6E, 0xFEAD, 0xF2D3, 0xF678,
0x003C, 0xFECD, 0x1018, 0xFD17, 0x1024, 0x0174, 0x0483, 0x046F,
0xFCEE, 0x0133, 0xFE1A, 0x083C, 0xF8CB, 0xFEB6, 0xF433, 0xF67A,
0x000B, 0x01F9, 0x0CDB, 0x0443, 0x0C99, 0x06FF, 0x05BB, 0x0325,
0x0214, 0xFA0C, 0x0051, 0x01BB, 0xF7D9, 0xFDF4, 0xF583, 0xFA60,
0x0349, 0x04A8, 0x0E77, 0x04A8, 0x0C30, 0x09D1, 0x0299, 0x077F,
0xFEDC, 0xF975, 0xFFC4, 0xFB17, 0xF5CA, 0xF6A3, 0xF1BE, 0xF6A6,
0x0319, 0x0678, 0x0FFA, 0x09C0, 0x0B00, 0x0DAE, 0x0137, 0x0A9C,
0xFF17, 0xFD54, 0x0224, 0xFAB2, 0xFA0A, 0xEFB2, 0xF2D3, 0xF0AA,
0x001B, 0x04C2, 0x0F64, 0x08ED, 0x0E49, 0x0CEA, 0x01EF, 0x0B9F,
0xFB5D, 0x0080, 0xFCA5, 0xFEE5, 0xF683, 0xF0AE, 0xF35E, 0xE99A,
0xFFE1, 0xFC22, 0x0BD0, 0x0865, 0x0BA1, 0x11F4, 0x037D, 0x0F81,
0xFF27, 0x02B2, 0xFEF8, 0x0116, 0xF6AF, 0xF3E1, 0xF4AB, 0xEC7C,
0x02D9, 0xF91B, 0x0C7B, 0xFFEE, 0x09F5, 0x0BB5, 0x025C, 0x0F25,
0xFF49, 0x055B, 0xFDC3, 0x03C5, 0xF263, 0xF6F1, 0xEEFA, 0xEF0F,
0x006E, 0xF918, 0x0F1B, 0xFD81, 0x0A73, 0x0830, 0xFF2F, 0x0C62,
0x0009, 0x05F8, 0x0391, 0x0607, 0xF875, 0xF7D8, 0xF222, 0xF144,
0xFF43, 0xFE03, 0x0D7E, 0xFF65, 0x0D3D, 0x027B, 0x018E, 0x042C,
0xFCBB, 0x011E, 0xFE6B, 0x05A2, 0xF619, 0xFB44, 0xF10D, 0xF3A7,
0xFD34, 0xFD68, 0x0A2B, 0x021F, 0x09E1, 0x0894, 0x0191, 0x04A5,
0xFEBB, 0xFBEE, 0xFF23, 0x01DE, 0xF83D, 0xFAD3, 0xF6C7, 0xF631,
0x02AF, 0x01A3, 0x0BEA, 0x0448, 0x089A, 0x08CD, 0x0076, 0x056D,
0xFFD1, 0xF9E9, 0xFE62, 0xFC0F, 0xF25D, 0xF72C, 0xF006, 0xF68D,
0x0075, 0x028E, 0x0D24, 0x0542, 0x0858, 0x0B7B, 0xFD9C, 0x098E,
0xFE43, 0xFDFA, 0x028F, 0xFC13, 0xF97A, 0xF191, 0xF342, 0xF125,
0x003F, 0x02D6, 0x0E86, 0x0885, 0x0C39, 0x0C51, 0x0084, 0x080B,
0xFCA4, 0xFD76, 0xFDE1, 0xFDA7, 0xF6F0, 0xF211, 0xF27A, 0xEDC6,
0xFD0A, 0xFD37, 0x0A17, 0x0581, 0x0B27, 0x0F4D, 0x0251, 0x0D6E,
0xFDE2, 0x0019, 0xFE6D, 0xFF4C, 0xF8DB, 0xF4A4, 0xF815, 0xEDB7,
0x03AD, 0xFA36, 0x0C5E, 0x01F9, 0x09F4, 0x0C8C, 0x0313, 0x0D50,
0x0174, 0x0159, 0xFF67, 0xFF74, 0xF3E1, 0xF5AD, 0xF08B, 0xF1BA,
0xFFC2, 0xFC34, 0x0CA3, 0xFE64, 0x094B, 0x08A7, 0xFF20, 0x0D6B,
0xFED1, 0x04BF, 0x027F, 0x038B, 0xF98B, 0xF6D4, 0xF3B2, 0xF0B0,
0x002C, 0xFDE1, 0x0DF6, 0x00AE, 0x0CB8, 0x0623, 0x01D3, 0x076E,
0xFDE2, 0xFFF1, 0x0002, 0x02CE, 0xF92F, 0xF936, 0xF287, 0xF26C,
0xFB76, 0xFD79, 0x0883, 0x0103, 0x0AA5, 0x07EC, 0x0374, 0x0810,
0xFF09, 0xFEC1, 0xFE85, 0x01AB, 0xF986, 0xFA6F, 0xF953, 0xF552,
0x03E4, 0xFF5D, 0x0B74, 0x0133, 0x096D, 0x088C, 0x03CC, 0x09BF,
0x01F6, 0xFE4C, 0x0071, 0xFE12, 0xF673, 0xF7F8, 0xF21C, 0xF732,
0xFFB9, 0x02F3, 0x0B58, 0x0284, 0x07BC, 0x07C3, 0x0001, 0x0A91,
0xFF91, 0x018C, 0x017F, 0x0019, 0xFA90, 0xF642, 0xF5A1, 0xF3F7,
0x018E, 0x032A, 0x0FD4, 0x0618, 0x0D84, 0x097F, 0x0212, 0x0917,
0xFE67, 0xFFD2, 0x0073, 0x000E, 0xFB31, 0xF720, 0xF56C, 0xF2D2,
0xFCD3, 0xFFFB, 0x0874, 0x0550, 0x0B19, 0x0C23, 0x050B, 0x0B80,
0xFEFC, 0x00A5, 0xFD33, 0x013C, 0xF994, 0xF8C7, 0xF8E8, 0xF329,
0x03B7, 0xFE81, 0x0D57, 0x026D, 0x0B2F, 0x09FA, 0x0592, 0x0CCB,
0x031C, 0x0259, 0xFFB9, 0xFF7D, 0xF77B, 0xF7AD, 0xF3DD, 0xF5AF,
0xFE77, 0x0107, 0x0A7A, 0x01EA, 0x0987, 0x0769, 0x023B, 0x0B2F,
0x009D, 0x0403, 0x0110, 0x035D, 0xF950, 0xF84A, 0xF416, 0xF293,
0xFF94, 0x0068, 0x0E0C, 0x03D0, 0x0E17, 0x06B8, 0x0455, 0x0830,
0xFEF3, 0x01D2, 0x000D, 0x027F, 0xFC21, 0xF911, 0xF582, 0xF39C,
0xFAE5, 0xFF8D, 0x06A8, 0x0371, 0x0A2C, 0x08DB, 0x0596, 0x08D5,
0x0032, 0xFFCF, 0xFD4C, 0x0323, 0xF9CF, 0xFC5C, 0xF8CA, 0xF4DA,
0x0116, 0xFE77, 0x0ACD, 0x01EC, 0x0B48, 0x07C4, 0x05A1, 0x09CC,
0x01B4, 0x0053, 0xFEDD, 0xFE9E, 0xF7CF, 0xF7AF, 0xF39F, 0xF62B,
0xFC9B, 0x0221, 0x07DC, 0x025D, 0x07B2, 0x05D6, 0x0198, 0x08C2,
0xFF60, 0x0205, 0xFFDF, 0x02C5, 0xFA68, 0xF96B, 0xF527, 0xF2B6,
0xFE3F, 0xFEF6, 0x0D24, 0x0392, 0x0FC8, 0x069F, 0x0692, 0x06DE,
0xFF4A, 0x00E2, 0xFDF9, 0x0296, 0xFADC, 0xF947, 0xF639, 0xF23F,
0xFA16, 0xFDA0, 0x04D8, 0x02EF, 0x0988, 0x081E, 0x0555, 0x072C,
0xFF83, 0xFE00, 0xFBBF, 0x0239, 0xF819, 0xFE06, 0xF719, 0xF4F2,
0xFE7E, 0xFA9F, 0x093E, 0xFF31, 0x0C5B, 0x0653, 0x0853, 0x07C2,
0x039B, 0xFF3D, 0xFDA5, 0xFF84, 0xF62A, 0xFA20, 0xF320, 0xF649,
0xFB24, 0xFF40, 0x06B2, 0x0129, 0x07BA, 0x054D, 0x023A, 0x0693,
0xFFAC, 0xFF17, 0xFE24, 0x00DF, 0xF8A7, 0xFC46, 0xF36D, 0xF626,
0xFA4E, 0xFDEB, 0x09A3, 0x0281, 0x0E53, 0x05EF, 0x079A, 0x04B9,
0x016E, 0xFE91, 0xFD51, 0x0160, 0xF923, 0xFB64, 0xF4E6, 0xF462,
0xF84F, 0xFDA3, 0x03CB, 0x04CE, 0x08B0, 0x09E3, 0x0533, 0x06E6,
0x005C, 0xFB96, 0xFB3A, 0xFDB2, 0xF730, 0xFDE6, 0xF662, 0xF7A1,
0xFCC6, 0xFA6D, 0x0816, 0x004C, 0x0C26, 0x0917, 0x094C, 0x0911,
0x0568, 0xFEA7, 0xFEBB, 0xFDC0, 0xF76A, 0xFA8E, 0xF352, 0xF635,
0xF9CD, 0xFC9D, 0x06D4, 0x0216, 0x095E, 0x0997, 0x0490, 0x0B38,
0x018A, 0x018A, 0xFDA1, 0xFEDE, 0xF85B, 0xFB98, 0xF484, 0xF69B,
0xF9F3, 0xFAC8, 0x0926, 0x0049, 0x10B7, 0x0787, 0x0BE0, 0x08BB,
0x04A7, 0x024A, 0xFEC5, 0x02B0, 0xF9C7, 0xFD3D, 0xF473, 0xF41A,
0xF6CE, 0xF7AA, 0x0354, 0xFFA8, 0x0AB9, 0x093F, 0x08D1, 0x0A96,
0x036F, 0x0122, 0xFBC0, 0x009B, 0xF617, 0x0084, 0xF4E7, 0xF9B0,
0xF9F6, 0xF7AD, 0x063E, 0xFB20, 0x0DF6, 0x054A, 0x0CEF, 0x089E,
0x08FC, 0x00D3, 0x0127, 0x00FF, 0xF820, 0x00BA, 0xF26E, 0xFAFB,
0xF674, 0xFA32, 0x0352, 0xFC53, 0x08F3, 0x0426, 0x06DB, 0x0846,
0x04DE, 0x0193, 0xFFB8, 0xFF18, 0xF8EC, 0xFEEE, 0xF3A6, 0xFD1B,
0xF711, 0xFD2D, 0x05BF, 0xFDD2, 0x0E23, 0x0323, 0x0C4D, 0x03B7,
0x0782, 0xFDA4, 0xFFDE, 0xFF07, 0xFA7C, 0xFF6B, 0xF5D1, 0xFB16,
0xF553, 0xFB56, 0xFFC4, 0x0042, 0x07D7, 0x081D, 0x07F0, 0x076D,
0x042F, 0xFD9E, 0xFC27, 0xFB0D, 0xF5E7, 0xFCF0, 0xF41F, 0xFC9E,
0xF8E4, 0xFBD7, 0x0445, 0xFF1E, 0x0B0E, 0x08E6, 0x0C7A, 0x08F2,
0x09CB, 0xFE39, 0x0055, 0xFAD0, 0xF814, 0xFBBB, 0xF383, 0xFA61,
0xF646, 0xF998, 0x0281, 0xFE8E, 0x0897, 0x0A45, 0x0723, 0x0D86,
0x0548, 0x044D, 0xFE44, 0xFC95, 0xF5FC, 0xF904, 0xF158, 0xF806,
0xF4FC, 0xF828, 0x0360, 0xFC61, 0x0D75, 0x07C9, 0x0E01, 0x0B1C,
0x0962, 0x0436, 0xFFB7, 0xFFCC, 0xF831, 0xFC82, 0xF34A, 0xF7E3,
0xF3C2, 0xF429, 0xFEF1, 0xF93A, 0x07EC, 0x078A, 0x0A28, 0x0CA6,
0x0832, 0x070F, 0xFE58, 0x0299, 0xF4EB, 0xFE79, 0xF176, 0xFA61,
0xF504, 0xF55B, 0x0188, 0xF6B0, 0x0B6E, 0x0366, 0x0EB2, 0x091F,
0x0D79, 0x04E3, 0x0391, 0x023B, 0xF83A, 0x00BE, 0xF14A, 0xFD7D,
0xF21D, 0xF5ED, 0xFDA5, 0xF481, 0x06E3, 0x005C, 0x08A8, 0x07DB,
0x079E, 0x0648, 0x0226, 0x0411, 0xF977, 0x01EB, 0xF01C, 0x006F,
0xF001, 0xFA17, 0xFDB2, 0xF6E4, 0x0A1A, 0x000B, 0x0F73, 0x04A0,
0x0D7F, 0x019C, 0x04F0, 0x004D, 0xFDBF, 0x016D, 0xF49A, 0x0277,
0xEFD8, 0xFBC9, 0xF918, 0xF7CC, 0x02EC, 0x00B3, 0x07B7, 0x05E2,
0x07DC, 0x026F, 0x0212, 0xFEA9, 0xFC6A, 0xFEBA, 0xF316, 0x0218,
0xEEE3, 0xFD79, 0xFAF6, 0xF9F8, 0x0589, 0x0306, 0x0AB6, 0x061C,
0x0CCF, 0x019D, 0x071B, 0xFD27, 0x022C, 0xFB18, 0xFABF, 0x002A,
0xF1CA, 0xFD46, 0xF6F6, 0xF944, 0x01C5, 0x0490, 0x05C8, 0x0AFC,
0x0539, 0x065C, 0xFFF6, 0xFEBF, 0xFD43, 0xF88E, 0xF9F6, 0xFB9B,
0xF2DD, 0xFA5E, 0xF755, 0xF6D8, 0x0130, 0x02DE, 0x0947, 0x0BD2,
0x0B71, 0x082E, 0x023C, 0x005B, 0xFD20, 0xF7E4, 0xFB3F, 0xFA5E,
0xF868, 0xFA6F, 0xFB1E, 0xF4CE, 0xFF21, 0xFF1F, 0x02AA, 0x0B16,
0x040B, 0x0E5F, 0xFF8D, 0x08CE, 0xFAD6, 0xFB89, 0xF928, 0xFA0F,
0xF6E8, 0xF85D, 0xFCD5, 0xF3D8, 0x06A7, 0xFCEB, 0x09B0, 0x054F,
0x0A26, 0x0A60, 0x010E, 0x09B5, 0xFA2D, 0x0026, 0xFC2F, 0xFD0A,
0xFA7E, 0xF92F, 0xFE1A, 0xF2B1, 0x0210, 0xF898, 0x0510, 0x0246,
0x0900, 0x09E7, 0xFEE7, 0x0C3F, 0xF3B7, 0x01CF, 0xF2AD, 0xFEA5,
0xF65F, 0xFFD9, 0x0115, 0xF780, 0x0929, 0xF8B5, 0x0991, 0xFE01,
0x0C4A, 0x02B5, 0x0780, 0x08E1, 0xF9CE, 0x0451, 0xF47A, 0x0059,
0xF420, 0xFE82, 0xFB74, 0xFC1E, 0x062E, 0xFCF4, 0x0864, 0xFBDF,
0x09E6, 0x011A, 0x04C5, 0x04E1, 0xFAAB, 0x0118, 0xF310, 0x036F,
0xF060, 0x01ED, 0xF9D0, 0xFBF8, 0x034E, 0xFE93, 0x094D, 0xFF20,
0x1053, 0xFDB8, 0x0D35, 0x00C1, 0x0182, 0xFEAE, 0xFA85, 0xFE9A,
0xF639, 0x02D1, 0xF7AA, 0x02A7, 0xFF72, 0x0221, 0xFFE6, 0xFEE0,
0x042E, 0x0063, 0x0A16, 0x031D, 0x0421, 0xFD31, 0xFC4B, 0xFEEC,
0xF92E, 0x00EB, 0xFE8C, 0x0238, 0x002C, 0x0982, 0xFE13, 0x04FB,
0x02C1, 0xFEB4, 0x03F8, 0xFD64, 0x0557, 0xF94C, 0x054E, 0xFB34,
0xFF57, 0xFE1D, 0x0264, 0x00E2, 0x087E, 0x0961, 0x000B, 0x0AB0,
0xF6E3, 0x061E, 0xF6FE, 0x00D6, 0xF74E, 0xF759, 0xFAEB, 0xF5A0,
0x0114, 0xF855, 0x08CE, 0xFCC5, 0x0D27, 0x082E, 0x0B8F, 0x0D7A,
0x08A6, 0x0F22, 0xFAD9, 0x08FE, 0xF145, 0xF94B, 0xF325, 0xF307,
0xF684, 0xF0A7, 0x0839, 0xF626, 0x15F2, 0x0527, 0x0DF8, 0x09E6,
0x064D, 0x0E74, 0x0240, 0x12AE, 0xF57B, 0x07B3, 0xEA0B, 0xF96D,
0xEA37, 0xEDE2, 0xF7AD, 0xEC90, 0x0E37, 0xFA12, 0x190D, 0x0510,
0x1562, 0x0CDF, 0x0A0D, 0x1055, 0x008A, 0x0CA4, 0xF93B, 0x0873,
0xE9C2, 0xF874, 0xED70, 0xEBF0, 0xFE98, 0xF32A, 0x0653, 0xF967,
0x0FDB, 0x0280, 0x0E22, 0x0D5B, 0x02FF, 0x0D84, 0xFC81, 0x0C12,
0xF557, 0x04D4, 0xF137, 0xF980, 0xF541, 0xF465, 0xFE3B, 0xF32C,
0x063A, 0xF914, 0x0B69, 0x0025, 0x0E32, 0x052A, 0x090C, 0x0D33,
0xFC55, 0x09DA, 0xFC7B, 0x04B4, 0xFF69, 0x0632, 0xF49B, 0xF9A1,
0xF40D, 0xF1E3, 0xF759, 0xF6C5, 0xFB88, 0xF97A, 0x07A9, 0x020C,
0x060D, 0x066D, 0x01AF, 0x075D, 0x069F, 0x0C74, 0x069A, 0x0959,
0xFC4E, 0xFF78, 0xF23A, 0xF2F0, 0xF45F, 0xEE0C, 0xFBEC, 0xF5B5,
0x036A, 0xFA9D, 0x0D49, 0x035B, 0x0EFC, 0x11BB, 0x07B8, 0x1198,
0x04B2, 0x0B4F, 0xF6C4, 0x0259, 0xE695, 0xF2E7, 0xEDC0, 0xEE43,
0xF530, 0xEDED, 0x0036, 0xF45E, 0x1315, 0x0838, 0x149E, 0x12F3,
0x0B96, 0x13E8, 0x0241, 0x0B6A, 0xF970, 0xFE0A, 0xEEA8, 0xF619,
0xEC2A, 0xE99F, 0xF971, 0xEA13, 0x052F, 0xFC84, 0x0E35, 0x092E,
0x1205, 0x12FD, 0x04C7, 0x145B, 0xF763, 0x08B8, 0xF7BA, 0xFFEA,
0xF0B7, 0xF326, 0xED69, 0xE88A, 0xFEF1, 0xF0DD, 0x07DC, 0xFC54,
0x0B30, 0x07C9, 0x0E6E, 0x10EA, 0x0656, 0x0FDC, 0xFDFB, 0x0A6D,
0xFAC8, 0xFA70, 0xFBB0, 0xF164, 0xF860, 0xF60A, 0xFBEB, 0xF56D,
0x050B, 0xFC67, 0xFE6D, 0x05A9, 0xFDE9, 0x096E, 0x03EA, 0x0FF3,
0xFDBE, 0x06B5, 0xFE4C, 0xF79F, 0x0607, 0xF9E8, 0x007D, 0xFA98,
0xFB75, 0xF77F, 0xFF87, 0xFBBB, 0xFC5C, 0x0090, 0xFCED, 0x0819,
0x0587, 0x090C, 0x08AC, 0x0447, 0x0759, 0x0464, 0x07BE, 0xFEE0,
0x041A, 0xFC36, 0xF339, 0xFA0E, 0xEF74, 0xF6BB, 0xF825, 0x002C,
0xF83F, 0x015D, 0x057B, 0x00D9, 0x1230, 0x0C16, 0x0C6B, 0x0896,
0x0A35, 0xFF0B, 0x0539, 0xFDAC, 0xF5BD, 0xF9D4, 0xF162, 0xF889,
0xF920, 0xF8ED, 0xFFC4, 0xFC8A, 0x08D7, 0x0A35, 0x111D, 0x1022,
0x0D65, 0x0A48, 0x0008, 0x013B, 0xFAD4, 0xFAAD, 0xF7A5, 0xFD0C,
0xEEC8, 0xF63A, 0xF9B0, 0xF198, 0x063F, 0x0295, 0x0660, 0x0BCE,
0x0EF2, 0x0B49, 0x0C74, 0x09A4, 0xFEE7, 0x0044, 0xFDB7, 0xFBD4,
0xFF26, 0xF8B5, 0xFC31, 0xF49D, 0xFEE3, 0xFC01, 0x039D, 0x0575,
0x00D3, 0x090D, 0xFEB8, 0x08B8, 0x022C, 0x06B0, 0xFEE3, 0x0479,
0xF949, 0xF853, 0x042D, 0xF268, 0x093F, 0xFF4E, 0x0026, 0x0271,
0x0271, 0x012A, 0xFD1C, 0x05E9, 0xF684, 0x0485, 0x0308, 0x0595,
0x05E8, 0x006C, 0x03AB, 0xF543, 0x0C57, 0xFB6A, 0x0E17, 0x0627,
0x0050, 0x048D, 0xF396, 0x000D, 0xF1F3, 0x0220, 0xF185, 0x0530,
0xF917, 0xFE45, 0x09D0, 0xF87F, 0x0E0D, 0xFDF4, 0x0D05, 0x00EE,
0x1091, 0x0300, 0x01A9, 0x0496, 0xF011, 0x0031, 0xF3D3, 0x026D,
0xF437, 0xFFF6, 0xFBD5, 0xF7C4, 0x0FCD, 0xFF28, 0x1225, 0x05B0,
0x0A6C, 0x00A8, 0x03B9, 0xFEBE, 0xFC5F, 0x048D, 0xF0CB, 0x06C8,
0xED68, 0xFDCA, 0xF90E, 0xF8A1, 0xFFCA, 0xFD22, 0x0B0F, 0x01DE,
0x1504, 0x02FC, 0x07D9, 0xFE9E, 0xFF64, 0xFD15, 0x03A3, 0x05B6,
0xFA33, 0x05EB, 0xF4EC, 0xFC10, 0xFF51, 0xFFC6, 0x00A5, 0x04B2,
0x0231, 0xFFC6, 0x0634, 0xFD53, 0x0084, 0xFE19, 0xFC09, 0x0159,
0xFF64, 0x0104, 0x040D, 0x0119, 0xFCF0, 0x0525, 0xFC20, 0x0439,
0x02AB, 0x0127, 0xF9FE, 0xFAA1, 0xFCC3, 0xF793, 0x0725, 0xFDE5,
0x02CB, 0xFD9B, 0x08ED, 0xFBF6, 0x10DA, 0x07FF, 0x0345, 0x0FE3,
0xF839, 0x0672, 0xF5C0, 0xFC60, 0xEF15, 0xF8B0, 0xF280, 0xF802,
0x014D, 0xF769, 0x0BD7, 0xF7F4, 0x0DC9, 0x014B, 0x0FD1, 0x0C68,
0x0A87, 0x0F76, 0xF3B1, 0x05FB, 0xED3E, 0xFA14, 0xF375, 0xF8FA,
0xF266, 0xF4C3, 0x0651, 0xF112, 0x176B, 0xFD06, 0x103F, 0x09FC,
0x0CCF, 0x0CB3, 0x029B, 0x0B70, 0xEC1F, 0x07A3, 0xE46F, 0xFE6E,
0xECE1, 0xF4CA, 0xF6EB, 0xEF5F, 0x04BE, 0xF32C, 0x1338, 0xFF5A,
0x13B1, 0x072E, 0x07F5, 0x077B, 0xFF68, 0x0820, 0xF467, 0x091F,
0xE837, 0xFE9F, 0xF558, 0xF201, 0x02D9, 0xF454, 0x01EB, 0xFA52,
0x0D62, 0xFD86, 0x0DE4, 0x01C2, 0xFEF8, 0x0658, 0xF851, 0x08F2,
0xF426, 0x05F9, 0xF2C0, 0xFDFA, 0xF856, 0xF792, 0xFEEC, 0xF8A7,
0x009E, 0xF88E, 0x0419, 0xF650, 0x0A88, 0xFCB6, 0x04BF, 0x0596,
0xFB57, 0x063F, 0x0187, 0x0359, 0x02A1, 0x0533, 0xF888, 0x03EB,
0xFAD3, 0xFC0B, 0xF9D5, 0xF5EF, 0xF648, 0xF4DD, 0xFF30, 0xFB20,
0x0271, 0x01E2, 0x042C, 0x039E, 0x079D, 0x05FC, 0x0287, 0x0954,
0xF902, 0x04D9, 0xF516, 0xF8E2, 0xF95F, 0xF3D0, 0xF798, 0xF432,
0xFBA4, 0xF522, 0x1044, 0xFCC1, 0x149F, 0x07F5, 0x087D, 0x0EA6,
0x02E4, 0x0C43, 0xF76D, 0x04B7, 0xED03, 0xFC6D, 0xF104, 0xF645,
0xF28C, 0xF332, 0xFE18, 0xF282, 0x1390, 0xFC75, 0x140D, 0x0B1E,
0x066E, 0x0E3C, 0xFDAB, 0x07DD, 0xFA54, 0x0320, 0xF05B, 0xFDED,
0xEE51, 0xF4B4, 0x0059, 0xF188, 0x0971, 0xF625, 0x0EC3, 0x00E4,
0x133A, 0x0B53, 0x036D, 0x0BE1, 0xF7AB, 0x08DE, 0xF6D8, 0x0583,
0xEDA0, 0xFF91, 0xF298, 0xF719, 0x0721, 0xF425, 0x0898, 0xF9F2,
0x0565, 0xFE85, 0x0A65, 0x0318, 0x066B, 0x0842, 0xFB1F, 0x06E2,
0xF650, 0x019E, 0xFD68, 0xFF3B, 0x010A, 0xFCD0, 0x055C, 0xFA6E,
0x0822, 0xFB3B, 0xFC93, 0xFBA7, 0xFF0B, 0x0048, 0x03E3, 0x0611,
0xF715, 0x05B9, 0xF9C5, 0x0364, 0x06CB, 0x0245, 0x03AA, 0x0290,
0xFEC5, 0xFD59, 0xFFE6, 0xF774, 0xFBEF, 0xF951, 0xFBE7, 0xFB48,
0x0253, 0xFEEC, 0x04DE, 0x05AB, 0x05C7, 0x07B5, 0x08DE, 0x0775,
0x05CF, 0x0658, 0xF85B, 0xFF3B, 0xF778, 0xF8CC, 0xFAA8, 0xF7D2,
0xF451, 0xF84B, 0x00E2, 0xFE25, 0x0E83, 0x06D1, 0x08CE, 0x0ADA,
0x042D, 0x0838, 0x006B, 0x0355, 0xF941, 0x00C5, 0xF71E, 0xF7F7,
0xFB6C, 0xF1B3, 0xFE81, 0xF871, 0x05A4, 0x004B, 0x0FCA, 0x07CC,
0x0ACF, 0x0C14, 0xFD59, 0x08BD, 0xFB46, 0x0559, 0xF9FE, 0x00E0,
0xF290, 0xF73E, 0xFBFA, 0xF432, 0x069A, 0xFC4A, 0x0410, 0x021E,
0x0868, 0x03FE, 0x0609, 0x06FF, 0xFBF0, 0x09A0, 0xFB31, 0x043F,
0xFDC8, 0xFA88, 0xFE2C, 0xF910, 0x028B, 0xFA49, 0x0A40, 0xFDED,
0x0411, 0x01ED, 0xFBC6, 0x014A, 0xFFCB, 0x0616, 0xFC7A, 0x08A5,
0xF78F, 0x011E, 0x01EE, 0xFD80, 0x07B4, 0x00CF, 0x0329, 0xFF3A,
0x0581, 0xFABB, 0xFF57, 0xFCD3, 0xF509, 0x0111, 0xFC62, 0x0164,
0x016D, 0xFFF2, 0x0081, 0x0144, 0x07D0, 0x0415, 0x0E4D, 0x0504,
0x0587, 0x0079, 0xFB0D, 0xF9B4, 0xFAD9, 0xFD1B, 0xF3E7, 0x0039,
0xF562, 0xFB4F, 0x0516, 0xFF6A, 0x07A7, 0x08DB, 0x087C, 0x09FB,
0x0E2F, 0x03FE, 0x0331, 0xFE6A, 0xF539, 0xFD74, 0xF8FF, 0xFB0F,
0xFA67, 0xF739, 0xFA90, 0xF94B, 0x075C, 0x0275, 0x0E2B, 0x0C22,
0x09A9, 0x0A78, 0x04BF, 0x0181, 0xFFAE, 0x013D, 0xF404, 0xFFEA,
0xF2FE, 0xF5D0, 0xFE49, 0xF5E9, 0xFCFF, 0xFF79, 0x0311, 0x06B7,
0x0E25, 0x092A, 0x047C, 0x062C, 0xFD58, 0x0477, 0x00BF, 0x00DA,
0xFCF6, 0xF87A, 0xF9D4, 0xF466, 0x00FA, 0xF940, 0x0317, 0x02BB,
0x0117, 0x0596, 0x049B, 0x03E0, 0x0117, 0x0819, 0xF964, 0x079D,
0xFE7B, 0xFBFC, 0x05B5, 0xF85A, 0xFEA8, 0xFD68, 0xFECB, 0xFF2E,
0x04AA, 0x004B, 0xFAA7, 0x0022, 0xF906, 0x02D3, 0xFFFF, 0x0642,
0xFFAD, 0xFFEC, 0x0465, 0xF917, 0x0A38, 0xFCA7, 0x06A7, 0x0356,
0x002C, 0x0055, 0xFE46, 0xFAB5, 0xF5F8, 0x000C, 0xEF26, 0x0493,
0xFCF5, 0x0049, 0x0781, 0xFEA7, 0x0440, 0x00AA, 0x09F7, 0x0323,
0x0C40, 0x04BB, 0xFC89, 0xFE33, 0xF612, 0xF97E, 0xF54A, 0xFDF0,
0xF156, 0xFC64, 0xFFF7, 0xF9B1, 0x0C30, 0x008C, 0x0989, 0x0635,
0x0B1E, 0x048D, 0x09CC, 0x0127, 0xFBA8, 0x00F8, 0xEF6C, 0xFE75,
0xF481, 0xF984, 0xF80E, 0xFACD, 0xF9F5, 0xFFDB, 0x0A73, 0x05B1,
0x0EF0, 0x080B, 0x0489, 0x02AA, 0x034E, 0x00A3, 0xFE8B, 0x0288,
0xF58A, 0xFA2F, 0xFBC4, 0xF397, 0xFE0B, 0xFC18, 0xFB21, 0x0438,
0x07C7, 0x054F, 0x0C47, 0x040D, 0x0103, 0x0390, 0xFC7A, 0x03C3,
0x01D7, 0x000B, 0x00A7, 0xFB3B, 0xFA0F, 0xFA9E, 0xFF1D, 0x0093,
0xFE8A, 0x0539, 0xFB9E, 0x01B4, 0x03D6, 0x00C0, 0x0062, 0x0338,
0xFEED, 0xFE50, 0x0AD9, 0xF9FB, 0x0897, 0xFE61, 0xFEDC, 0x00F1,
0x0088, 0x004B, 0xFCD5, 0x00E2, 0xF382, 0x008A, 0xF8A6, 0x00F2,
0x0334, 0x000E, 0x0664, 0xFDB5, 0x0824, 0x0062, 0x0DCB, 0x064E,
0x07BF, 0x05B5, 0xF9B0, 0xFE80, 0xF6C6, 0xFD69, 0xF078, 0xFFC5,
0xF52B, 0xFA67, 0x0A18, 0xF749, 0x0B5C, 0xFDE8, 0x0908, 0x04D0,
0x1101, 0x0767, 0x08C3, 0x053E, 0xF605, 0xFF1C, 0xF027, 0xFD0D,
0xF251, 0xFCFA, 0xF700, 0xF863, 0x033E, 0xFA4F, 0x0E31, 0x03D7,
0x0D8B, 0x07DE, 0x090B, 0x05D9, 0x0546, 0x043C, 0xF6B9, 0x0226,
0xF10E, 0xFAED, 0xFB49, 0xF5C4, 0xF8AE, 0xF7B9, 0xFF04, 0xFC50,
0x1040, 0x02E0, 0x0AD4, 0x0650, 0x00A4, 0x0445, 0xFFCA, 0x03FE,
0xFC42, 0x032A, 0xF7B9, 0xFC11, 0xF980, 0xF994, 0xFBEA, 0xFE0B,
0xFDC3, 0xFE86, 0x0622, 0xFED6, 0x06C0, 0x0222, 0xFC8D, 0x0337,
0x00EF, 0x00DB, 0x095C, 0xFEEA, 0xFDCD, 0xFEDE, 0xFA52, 0xFDCF,
0x0128, 0xFE03, 0xF905, 0xFD22, 0xF942, 0xFABD, 0x00A9, 0xFE9A,
0xFF5A, 0x01A5, 0x03E4, 0xFF74, 0x086D, 0x0324, 0x03A8, 0x08C1,
0xFD8E, 0x0554, 0xFCB8, 0xFE11, 0xF5D5, 0xF982, 0xEEAE, 0xF7E6,
0xFE50, 0xF971, 0x0B1D, 0xFBFE, 0x059C, 0xFF48, 0x093F, 0x059F,
0x0C27, 0x0B67, 0xFDD2, 0x07D9, 0xF549, 0xFC95, 0xF1AB, 0xF698,
0xEE07, 0xF511, 0xFD59, 0xF4B5, 0x0B40, 0xFC44, 0x08F2, 0x05DD,
0x0991, 0x0AD5, 0x0B65, 0x0C87, 0xFF5F, 0x0787, 0xEEB1, 0xFCD3,
0xF201, 0xF4AD, 0xF919, 0xF0E1, 0xFA8E, 0xF20C, 0x095E, 0xFB83,
0x0F31, 0x0673, 0x05AC, 0x0AC9, 0x03A4, 0x09AC, 0xFD37, 0x06B2,
0xF135, 0xFEFF, 0xF491, 0xF4E9, 0xFA31, 0xF362, 0xF982, 0xF816,
0x0433, 0xFF90, 0x0D41, 0x07AE, 0x039E, 0x08B5, 0xF9D7, 0x063A,
0xFEF3, 0x04B0, 0xFFDB, 0xFF3B, 0xF830, 0xF6A2, 0xFCB8, 0xF463,
0xFE75, 0xF8F0, 0xFC6B, 0xFD18, 0x0595, 0x011A, 0x0152, 0x04CF,
0xF7FA, 0x047A, 0x01F1, 0x0364, 0x0645, 0x035B, 0xFC70, 0xFEAB,
0xFB86, 0xFAD0, 0xFD3E, 0xFC92, 0xF76B, 0xFB92, 0xF964, 0xFAF4,
0x014C, 0xFFFD, 0x0195, 0x0393, 0x0358, 0x03DD, 0x0BD0, 0x049A,
0x05E0, 0x02E0, 0xF8CA, 0xFC6B, 0xF8BB, 0xF883, 0xF2F2, 0xF7B8,
0xF237, 0xF6C2, 0x035D, 0xFD12, 0x078D, 0x062F, 0x0430, 0x083B,
0x0A85, 0x098F, 0x07CE, 0x08AB, 0xF7E3, 0xFEE9, 0xF08E, 0xF554,
0xF2A4, 0xF2AA, 0xF5B3, 0xF4A9, 0x0248, 0xFB35, 0x0E32, 0x0423,
0x0A99, 0x0967, 0x06C1, 0x0814, 0x0639, 0x046E, 0xF7F0, 0xFDEF,
0xEDCD, 0xF3A7, 0xF6A9, 0xF2E2, 0xFAA3, 0xF961, 0x00D8, 0xFD8C,
0x0E6D, 0x0718, 0x0B01, 0x0E97, 0x0167, 0x0A7B, 0x0074, 0x0335,
0xFBC6, 0xFBDA, 0xF39B, 0xF63E, 0xF838, 0xF689, 0x0148, 0xFA58,
0x024F, 0xFF01, 0x079D, 0x043F, 0x0843, 0x08DC, 0xFCD0, 0x0765,
0xFBC2, 0xFF21, 0x00F1, 0xFC66, 0xFAFD, 0xFD9F, 0xFAFF, 0xFB41,
0x03D7, 0xFEC9, 0xFFC9, 0x0390, 0xFD11, 0x03AE, 0x02CE, 0x0576,
0xFF26, 0x02DE, 0xFCDA, 0xFE15, 0x04B0, 0xFF19, 0x0640, 0xFFE4,
0x0088, 0xFE65, 0x015A, 0xFE2B, 0xFCF9, 0xFE9F, 0xF432, 0xFE54,
0xFCBF, 0xFEB9, 0x044C, 0x0271, 0x008A, 0x0435, 0x06B5, 0x027B,
0x0CE9, 0x055D, 0x0239, 0x0599, 0xF9ED, 0x006B, 0xF942, 0xFE1F,
0xF3FB, 0xF971, 0xF96F, 0xFA13, 0x0701, 0x03B2, 0x08C1, 0x05EA,
0x08F2, 0x0464, 0x0CFB, 0x0553, 0x0445, 0x034E, 0xF5D4, 0xFDB9,
0xF65A, 0xF7FE, 0xF767, 0xF8D5, 0xF759, 0xFE31, 0x070F, 0x03A5,
0x0F09, 0x09C2, 0x0642, 0x0993, 0x038C, 0x058D, 0x023A, 0x0400,
0xF8C6, 0xFC78, 0xF693, 0xF6DF, 0xFB60, 0xFBCC, 0xFBE7, 0xFE85,
0x0542, 0x0223, 0x0FC8, 0x0809, 0x0592, 0x061E, 0xFB43, 0x0106,
0x0080, 0xFD9F, 0xFF97, 0xFDC3, 0xF928, 0xFE9D, 0xFEAC, 0xFDEA,
0x00F5, 0x01DC, 0xFED8, 0x0549, 0x0555, 0x0619, 0x021D, 0x069D,
0xF8EA, 0xFF70, 0xFEEC, 0xFBE8, 0x062E, 0x02BE, 0x0217, 0x01E3,
0x01BE, 0xFEEE, 0x03AD, 0x027F, 0xFB8A, 0x0119, 0xFAE2, 0xFE1C,
0x017C, 0xFDC2, 0xFD68, 0xFEBE, 0xFF16, 0x0247, 0x0BD1, 0x0528,
0x0B3D, 0x0707, 0x0093, 0x052F, 0xFD03, 0x02EF, 0xF6CF, 0x01BB,
0xF3A1, 0xFA88, 0xFE6F, 0xFA7D, 0x02AF, 0x0394, 0x0307, 0x0433,
0x0E0D, 0x0470, 0x10C3, 0x089F, 0x0210, 0x042E, 0xF833, 0xFD40,
0xF698, 0xF954, 0xF34D, 0xF82D, 0xFBDC, 0xFE75, 0x0937, 0x04A8,
0x0918, 0x069A, 0x09E5, 0x0840, 0x0CF6, 0x09C6, 0x01E0, 0x06EE,
0xF4E5, 0xFC20, 0xF512, 0xF807, 0xF5DA, 0xFDBE, 0xFACB, 0xFEF2,
0x09C3, 0x01E4, 0x0BBF, 0x0734, 0x055F, 0x05B9, 0x086D, 0x02DC,
0x051B, 0xFEC0, 0xF7C8, 0xFA7C, 0xF691, 0xFE1B, 0xFC98, 0x016B,
0xFD2B, 0xFF9A, 0x03DA, 0x022B, 0x075B, 0x0724, 0x0034, 0x05AF,
0x01F3, 0xFEE1, 0x05CE, 0xFD70, 0xFE0D, 0x01B6, 0xFAD2, 0x017D,
0x006F, 0x009B, 0xFD77, 0x00CD, 0xFA78, 0xFEF5, 0x013D, 0xFF0D,
0x00BA, 0xFC64, 0xFEC9, 0xFAA1, 0x0708, 0x0258, 0x08FD, 0x0799,
0x01CE, 0x0465, 0xFEF4, 0x02B7, 0xF9E8, 0x036C, 0xF2D3, 0xFF2A,
0xF966, 0xF8FC, 0x0008, 0xF9CF, 0xFF3C, 0xFFC9, 0x084A, 0x0439,
0x104F, 0x06D9, 0x0766, 0x0660, 0xFBA4, 0x02F7, 0xF763, 0xFF68,
0xF2CF, 0xF706, 0xF45A, 0xF232, 0x0095, 0xFB67, 0x06EF, 0x0403,
0x0AC4, 0x0524, 0x0FF6, 0x070A, 0x0661, 0x09BC, 0xF6FA, 0x0610,
0xF405, 0xFC9C, 0xF292, 0xF75C, 0xF157, 0xF7DA, 0xFF85, 0xFBD5,
0x0C92, 0x01CC, 0x0BD6, 0x0477, 0x0B04, 0x05A4, 0x071D, 0x064F,
0xFB40, 0x0030, 0xF487, 0xF97E, 0xF651, 0xFBA6, 0xF776, 0xFDC6,
0xFF4A, 0xFC33, 0x0BA0, 0xFF31, 0x08E4, 0x04B2, 0x02C5, 0x05A4,
0x04E2, 0x0270, 0x002C, 0x01A7, 0xF7DA, 0x0263, 0xF9D0, 0x0134,
0xFC41, 0xFFBD, 0xFCE6, 0xFC49, 0x058E, 0xFCAA, 0x072E, 0x0058,
0x0103, 0xFD80, 0x0457, 0xFD4D, 0x071D, 0x0528, 0x0137, 0x0975,
0xFDF5, 0x05E0, 0xFD55, 0x005D, 0xF7DA, 0xFD32, 0xF91D, 0xFB55,
0x0202, 0xF9DC, 0x0204, 0xFB99, 0x0292, 0x0237, 0x09FE, 0x08EB,
0x0928, 0x0B16, 0x0174, 0x0748, 0xFC8F, 0x0209, 0xF642, 0xFCE2,
0xF3F6, 0xF39D, 0xFF42, 0xF1E8, 0x074B, 0xFC74, 0x07A1, 0x0634,
0x0D49, 0x0ACD, 0x0E7D, 0x0BA9, 0x030B, 0x0A60, 0xF760, 0x04C7,
0xF2B5, 0xFA73, 0xF196, 0xF343, 0xFA35, 0xF556, 0x07BF, 0xFE1E,
0x0A0D, 0x04CD, 0x0AAC, 0x0800, 0x0D5D, 0x0B7E, 0x045F, 0x0A92,
0xF720, 0x006F, 0xF4B2, 0xF6CD, 0xF72F, 0xF5F8, 0xFC09, 0xF8E4,
0x080C, 0xFCFE, 0x0BF7, 0x01D7, 0x06E5, 0x07D3, 0x06B6, 0x0B93,
0x0304, 0x0797, 0xF8C0, 0x01E3, 0xF513, 0xFDEC, 0xF8F1, 0xFB88,
0xFB5B, 0xF95F, 0x01A3, 0xF7DE, 0x0927, 0xFE95, 0x0495, 0x05AF,
0x00D9, 0x04B1, 0x04F9, 0x03C3, 0x0319, 0x057B, 0xFD66, 0x04CA,
0xFD00, 0xFF62, 0xFC15, 0xF8CD, 0xFBC7, 0xF708, 0x01DE, 0xFA80,
0x0106, 0xFEC5, 0xFD72, 0x035A, 0x055D, 0x0892, 0x09DC, 0x0BBA,
0x029E, 0x0882, 0xFC86, 0xFF06, 0xFB67, 0xF9A1, 0xF8E7, 0xF67F,
0xF9B9, 0xF206, 0xFFB6, 0xF773, 0x03E9, 0x03AD, 0x0ADE, 0x0CB6,
0x0FB1, 0x0F47, 0x0779, 0x0A63, 0xFC73, 0x0319, 0xF750, 0xFB0F,
0xF23F, 0xF282, 0xF22B, 0xF05B, 0xFDAF, 0xF901, 0x06F5, 0x0662,
0x09BB, 0x0DCD, 0x0D17, 0x0D03, 0x0A7F, 0x0B17, 0xFEED, 0x0535,
0xF476, 0xF7F4, 0xF1D1, 0xEFFF, 0xF5CA, 0xF14D, 0x011B, 0xF97E,
0x0A9D, 0x057C, 0x09F6, 0x0C61, 0x0A54, 0x0F4C, 0x0993, 0x0C1D,
0xFE56, 0x0198, 0xF2F2, 0xF8EB, 0xF2AE, 0xF530, 0xF81C, 0xF65A,
0xFD89, 0xF95F, 0x05A5, 0xFF04, 0x0953, 0x09E6, 0x078F, 0x0EA7,
0x0674, 0x079A, 0x0184, 0x0068, 0xFB0F, 0xFD4C, 0xFADC, 0xFA50,
0xFCC9, 0xF8D3, 0xFBC5, 0xF8E5, 0x0021, 0xFE72, 0x059C, 0x074A,
0x029F, 0x08D7, 0x01B7, 0x06AA, 0x03DC, 0x0539, 0x0133, 0x039F,
0xFCA0, 0xFE14, 0xFAF1, 0xF6B3, 0xFA2F, 0xF7D5, 0xFA57, 0xFB91,
0xFEE9, 0xFE27, 0x01AD, 0x03E9, 0x0464, 0x0846, 0x0A9E, 0x0890,
0x08F6, 0x0521, 0xFF98, 0xFF69, 0xFA2E, 0xFAC5, 0xF72F, 0xF824,
0xF354, 0xF565, 0xF86F, 0xF818, 0x0272, 0x037E, 0x0632, 0x0BDB,
0x08D3, 0x09BD, 0x08D4, 0x033A, 0x021C, 0x0134, 0xFA52, 0xFD67,
0xF514, 0xF52E, 0xF314, 0xF3F0, 0xF9D2, 0xF9A8, 0x073C, 0x03C2,
0x0ABD, 0x0AF4, 0x0787, 0x0990, 0x0788, 0x0743, 0x0244, 0x03B3,
0xF7C7, 0xFBF9, 0xF231, 0xF50D, 0xF535, 0xF64F, 0xFB6E, 0xFD8B,
0x029B, 0x01A2, 0x0787, 0x0444, 0x05FD, 0x085A, 0x0461, 0x06DB,
0x0102, 0xFF95, 0xFA74, 0xFBC5, 0xF975, 0xFA43, 0xFE30, 0xFB0A,
0x0012, 0xFE58, 0x0103, 0xFF13, 0x060A, 0x03C8, 0x0470, 0x0797,
0xFE13, 0x028D, 0xFDCC, 0xFE09, 0x004C, 0xFEBF, 0x0086, 0x011E,
0xFE63, 0xFEE6, 0xFD62, 0xFC85, 0xFDBE, 0xFF60, 0x0073, 0x008E,
0x0083, 0xFF84, 0xFC4F, 0xFF43, 0x0129, 0xFFAB, 0x0A8C, 0x020D,
0x09BC, 0x03FE, 0x020E, 0x0130, 0xFDBC, 0x004B, 0xFB60, 0x0165,
0xF871, 0xFC1A, 0xF941, 0xF978, 0xFCF4, 0xFD73, 0x0372, 0x01DB,
0x09BF, 0x0399, 0x0953, 0x031C, 0x02F4, 0x0498, 0xFCE9, 0x0329,
0xF911, 0xFEE1, 0xF59A, 0xFB70, 0xFA73, 0xF95E, 0x03C6, 0xFCC2,
0x074C, 0x0160, 0x09B9, 0x035B, 0x09FA, 0x05E7, 0x04D1, 0x0794,
0xFBE8, 0x03A7, 0xF570, 0xFF6D, 0xF6A1, 0xFDA1, 0xFC37, 0xFA3A,
0x01D2, 0xF9C9, 0x0333, 0xFD6F, 0x04D3, 0x0327, 0x07FC, 0x05E4,
0x0509, 0x043D, 0xFDAB, 0x0467, 0xFB16, 0x035C, 0x0000, 0x0038,
0x02A9, 0xFB11, 0x019D, 0xF6D6, 0x00DE, 0xFB9E, 0x0109, 0x0299,
0x033B, 0x03B5, 0x01FC, 0x0405, 0xFFC0, 0x0744, 0xFFF6, 0x0778,
0x0090, 0x0280, 0xFF75, 0xFBCB, 0xFBB2, 0xF6B7, 0xFB97, 0xF7C3,
0xFD80, 0xFC52, 0x0061, 0x01BE, 0x0610, 0x06F6, 0x0A0B, 0x09E4,
0x0992, 0x09B9, 0x047E, 0x050B, 0xFEB1, 0xFF62, 0xF935, 0xF817,
0xF60D, 0xF2E5, 0xF7EB, 0xF810, 0xFEE1, 0x016E, 0x07D5, 0x07BF,
0x0B96, 0x08F6, 0x0986, 0x0963, 0x02A7, 0x0947, 0xFC91, 0x0174,
0xF7A7, 0xF5EF, 0xF2C4, 0xF070, 0xF844, 0xF5EE, 0x03BA, 0xFFB8,
0x0C22, 0x0583, 0x0EC1, 0x0880, 0x0AA7, 0x0C08, 0x0395, 0x0BFD,
0xFB3A, 0x025E, 0xF523, 0xF7A7, 0xF387, 0xF333, 0xF7BD, 0xF48B,
0x003D, 0xFA42, 0x0711, 0x0242, 0x0982, 0x09D6, 0x08BE, 0x0B07,
0x0459, 0x08A2, 0xFBF4, 0x041F, 0xF916, 0xFCAC, 0xFAC3, 0xF674,
0xFBBF, 0xF20D, 0x0020, 0xF615, 0x0374, 0x0285, 0x0552, 0x09D3,
0x0550, 0x08AE, 0x01B9, 0x0848, 0xFEFE, 0x0899, 0xFC9E, 0x016E,
0xFB00, 0xF6A1, 0xF928, 0xF17F, 0xF89C, 0xF603, 0xFD8A, 0xFE7F,
0x0274, 0x0427, 0x0324, 0x0763, 0x058B, 0x0A07, 0x08D8, 0x0B0D,
0x0581, 0x02AB, 0xFF80, 0xF80D, 0xF943, 0xF619, 0xF599, 0xF607,
0xF881, 0xF8C5, 0xFC71, 0x008E, 0x0226, 0x087D, 0x0847, 0x0C0E,
0x0A77, 0x092D, 0x05C7, 0x03A8, 0xFBA3, 0xFDB3, 0xF6FA, 0xF7C1,
0xF511, 0xF34E, 0xF43C, 0xF519, 0xFC41, 0xFE23, 0x07A9, 0x078E,
0x0E26, 0x0A29, 0x0ED4, 0x0820, 0x0896, 0x0813, 0xFD5D, 0x0273,
0xF677, 0xF83D, 0xF3B9, 0xF406, 0xF3B8, 0xF57D, 0xFB49, 0xFC25,
0x0594, 0x02CF, 0x0A5A, 0x074C, 0x0831, 0x0A65, 0x05A9, 0x083C,
0xFF9D, 0x0185, 0xF690, 0xF99D, 0xF6FE, 0xF61E, 0xFB22, 0xF66A,
0xFF95, 0xF773, 0x062C, 0xFD57, 0x086E, 0x07B1, 0x06B7, 0x0C21,
0x03D9, 0x073F, 0xFEBA, 0x02C7, 0xF8BC, 0xFF22, 0xF98E, 0xFA38,
0xFD89, 0xF69C, 0xFC21, 0xF569, 0xFBD2, 0xFB8F, 0x00E5, 0x04E3,
0x03F8, 0x096F, 0x027B, 0x0741, 0x020F, 0x0371, 0x0105, 0x01C0,
0x005E, 0xFB9F, 0x017E, 0xF6B6, 0xFD19, 0xF839, 0xF91C, 0xFA60,
0xFBE0, 0xFF81, 0xFF6A, 0x070A, 0x0161, 0x0930, 0x0498, 0x0523,
0x05A0, 0x0113, 0x008A, 0xFD7F, 0xFC9F, 0xFA6B, 0xFB5F, 0xF95F,
0xF8E1, 0xF88C, 0xF88B, 0xFB93, 0xFE88, 0x0368, 0x0606, 0x08A7,
0x0994, 0x045B, 0x0987, 0xFEFE, 0x038F, 0x0166, 0xFE6B, 0xFF0D,
0xFC16, 0xF9CF, 0xF785, 0xFA78, 0xF807, 0xFBF3, 0xFE8D, 0x00E8,
0x04A8, 0x0637, 0x0564, 0x0534, 0x034B, 0x01EF, 0x0245, 0x00FE,
0xFEE7, 0x002C, 0xFC46, 0xFCE9, 0xFCA3, 0xFBB5, 0xFE37, 0xFC1C,
0x01F4, 0xFC01, 0x03F7, 0x003E, 0x024F, 0x065D, 0x0356, 0x04A2,
0x02FE, 0x00A3, 0xFCDE, 0x01EE, 0xFCB4, 0x0119, 0x01AD, 0xFE72,
0x01D2, 0xFBDB, 0xFD7D, 0xF9A8, 0xFA4E, 0xFDFB, 0xFC7B, 0x0440,
0xFF9C, 0x0437, 0x0148, 0x0156, 0x0162, 0x029E, 0x02E1, 0x0385,
0x0909, 0xFEFD, 0x06F3, 0xFAD7, 0xFCE8, 0xFA77, 0xFB28, 0xFCE8,
0xFC90, 0x01E7, 0xFB55, 0x0523, 0xFF93, 0x03B5, 0x058C, 0x0405,
0x06C4, 0x04DC, 0x0652, 0x0128, 0x0269, 0xFE24, 0xFBED, 0xFBEE,
0xF9C4, 0xFA74, 0xFA71, 0xFF1A, 0xFC02, 0x04D9, 0x029A, 0x04B5,
0x0B67, 0x02D8, 0x0972, 0x0306, 0x0328, 0x02E5, 0x0576, 0x0076,
0x0219, 0xFD21, 0xF860, 0xFAA4, 0xF63B, 0xFB8C, 0xFAE4, 0x0220,
0x0356, 0x05D9, 0x071A, 0x0388, 0x0207, 0x03F3, 0xFFFB, 0x04DC,
0x04A9, 0x01E5, 0x042A, 0xFEB4, 0xFD45, 0xFB5F, 0xFA8C, 0xFA49,
0xFF56, 0xFEF8, 0x0329, 0x0351, 0x02B5, 0x0471, 0x04AE, 0x0547,
0x0494, 0x05D1, 0x032F, 0x0397, 0x03BE, 0xFE69, 0x0089, 0xFAFE,
0xFDAD, 0xF9F4, 0xFA50, 0xFB7D, 0xF791, 0x0159, 0xFCB9, 0x05AE,
0x02D9, 0x05E5, 0x0434, 0x0693, 0x04A8, 0x0514, 0x07DF, 0xFF63,
0x0977, 0xFA8B, 0x00EB, 0xF7E4, 0xF5A6, 0xF956, 0xF67E, 0xFEBC,
0xFE2C, 0x0418, 0x01BC, 0x06D1, 0x026F, 0x0541, 0x04A4, 0x03A0,
0x0A85, 0x016F, 0x08D7, 0xFB4D, 0xFABF, 0xF78D, 0xF17D, 0xF968,
0xF27D, 0xFDB0, 0xF946, 0x02EE, 0x0113, 0x06B3, 0x0602, 0x0605,
0x0BAC, 0x0390, 0x0BFF, 0x010B, 0x05A9, 0xFC12, 0xFF67, 0xF7DF,
0xF715, 0xF95B, 0xF1C4, 0xFD3F, 0xF4F3, 0xFFA6, 0xFD1F, 0x03AF,
0x0678, 0x0664, 0x089F, 0x038A, 0x027E, 0x00E3, 0x0080, 0xFDFE,
0x0003, 0xFA40, 0xF927, 0xFB3B, 0xF3CC, 0xFD6A, 0xF64F, 0xFE78,
0x00A3, 0x0270, 0x06C6, 0x05F8, 0x046B, 0x041E, 0x04B6, 0x00CD,
0x04CD, 0xFF86, 0x02B7, 0xFD5A, 0xFE3F, 0xFB5E, 0xF728, 0xFC09,
0xF798, 0xFCE2, 0xFBDF, 0xFF6C, 0xFC44, 0x0498, 0xFF0C, 0x0583,
0x02DB, 0x0218, 0x034F, 0x006C, 0x0436, 0xFE8A, 0x042F, 0xFCF5,
0x0188, 0xFD29, 0xFA99, 0xFC11, 0xF592, 0xFD22, 0xFAEB, 0x01A2,
0x00B6, 0x055E, 0x04FB, 0x0429, 0x05D0, 0xFF7C, 0x02F5, 0xFDC0,
0x063C, 0xFDAA, 0x020E, 0xFCFB, 0xF49D, 0xFC12, 0xEFEC, 0xFC04,
0xF44E, 0xFF81, 0xFC03, 0x0573, 0x0487, 0x0671, 0x0925, 0x005E,
0x08C2, 0xFD16, 0x0656, 0xFE08, 0x009D, 0xFEB8, 0xFA21, 0xFDB7,
0xF5A6, 0xFC7E, 0xF637, 0xFF75, 0xFCF2, 0x03CD, 0x03EE, 0x05B3,
0x0A1B, 0x01DD, 0x07B0, 0xFCBF, 0xFF72, 0xFF05, 0xFD56, 0x00AC,
0xFA1C, 0xFDC6, 0xF5FE, 0xFE1B, 0xF799, 0xFF96, 0xFEEC, 0x0204,
0x0A1E, 0x0608, 0x0C00, 0x01EE, 0x0481, 0xFBF1, 0x015B, 0xFD99,
0xFF12, 0xFF3B, 0xFD26, 0xFDE0, 0xFC1C, 0xFDB8, 0xF8FC, 0xFEF5,
0xFD8E, 0xFF69, 0x04AD, 0x01F7, 0x045F, 0x02CD, 0x01A1, 0xFE23,
0xFD6A, 0xFD88, 0xFBD1, 0x0177, 0x0085, 0x00CC, 0x0224, 0xFE4B,
0xFF01, 0xFF05, 0xFD6F, 0xFE37, 0x02AB, 0x00D6, 0x08C5, 0x0422,
0x03EA, 0xFF08, 0x0006, 0xFD93, 0xFFF3, 0x01C5, 0x01A0, 0x01C9,
0x05D1, 0xFED1, 0xFD58, 0xFD74, 0xF630, 0xFDD3, 0xFE98, 0x018D,
0x0438, 0x0494, 0xFFFE, 0x0108, 0xFF54, 0xFE1D, 0x023B, 0x0181,
0x03F1, 0x0420, 0x04B6, 0xFED4, 0xFDE5, 0xFBBD, 0xF93E, 0xFD56,
0xFD36, 0xFE67, 0x02E6, 0x00EE, 0x02DC, 0x00C7, 0x0129, 0xFFE4,
0x02B6, 0x0166, 0xFDB7, 0x01D3, 0xFD23, 0xFFA5, 0xFF7A, 0xFF09,
0xF86A, 0xFF6C, 0xFA11, 0xFFBF, 0x053A, 0x0164, 0x06DA, 0x01D6,
0x04D5, 0x0243, 0x0308, 0x01CD, 0xFEC8, 0x02D4, 0x01EF, 0x024D,
0x02F2, 0xFF53, 0xFD71, 0xFE11, 0xFE4B, 0xFD54, 0x0621, 0xFF24,
0x07C9, 0xFF5E, 0xFDD8, 0xFEDD, 0xF84E, 0x0065, 0xFB7B, 0x036D,
0xFE28, 0x04CD, 0xFF40, 0x01E5, 0x005C, 0xFE4F, 0x0298, 0xFDC9,
0x0863, 0xFFB8, 0x0468, 0xFC90, 0xFA79, 0xFBC5, 0xFAF5, 0x0155,
0xFC3D, 0x0525, 0x00D4, 0x0486, 0x04FB, 0x01E2, 0x0545, 0x009C,
0x0883, 0xFF38, 0x05FD, 0xFDEB, 0xFC92, 0xFB03, 0xF6E1, 0xFBD7,
0xF507, 0x024E, 0xF620, 0x06DA, 0x02BF, 0x0689, 0x0A70, 0x05C5,
0x0AC0, 0x0431, 0x0BDD, 0xFFB6, 0x0831, 0xFEE7, 0x011B, 0xFBE3,
0xF6EC, 0xF98C, 0xF448, 0xFED7, 0xF75C, 0x04EE, 0x026E, 0x0614,
0x0C76, 0x04C9, 0x064D, 0x024B, 0x0549, 0xFDD8, 0x08B8, 0xFE8F,
0xFCA4, 0xFCA3, 0xF019, 0xF8AB, 0xF288, 0xFC5C, 0xF6BF, 0x0588,
0x02DD, 0x08A9, 0x0BC5, 0x036E, 0x0617, 0x01CD, 0x0A1E, 0x00E6,
0x0F1B, 0x00BA, 0x0462, 0xFCF4, 0xF5C4, 0xF6A3, 0xF35D, 0xF9A6,
0xF5ED, 0x0399, 0xFB69, 0x06DA, 0x05E2, 0x0288, 0x0759, 0x0340,
0x05AE, 0x03F8, 0x0C86, 0x0307, 0x0953, 0xFE36, 0xF824, 0xF858,
0xF397, 0xF967, 0xF16A, 0xFFBF, 0xF54F, 0x0591, 0x066F, 0x03FF,
0x09C9, 0x03C1, 0x09E9, 0x0521, 0x1318, 0x0346, 0x0FE4, 0xFDB6,
0xFAF0, 0xF7E1, 0xEB8A, 0xF4C7, 0xE80A, 0xF965, 0xF041, 0x0389,
0xFD27, 0x04F2, 0x0494, 0x0437, 0x0C72, 0x0598, 0x1691, 0x0691,
0x1695, 0x0181, 0xFD7D, 0xF807, 0xE9CB, 0xF36D, 0xE928, 0xF851,
0xEEF3, 0x02F0, 0xFCE4, 0x05EA, 0x090D, 0x050C, 0x1399, 0x065F,
0x1B19, 0x090E, 0x12CE, 0x020F, 0xFBEB, 0xF717, 0xEA9B, 0xF3B4,
0xE172, 0xF6B5, 0xE71C, 0x0166, 0xFA2F, 0x062D, 0x086B, 0x05B9,
0x1784, 0x0801, 0x1C49, 0x0A4F, 0x118B, 0x034A, 0x00CB, 0xF841,
0xEDAE, 0xF378, 0xE1BC, 0xF551, 0xE958, 0xFE4C, 0xFC98, 0x030F,
0x086E, 0x037B, 0x1196, 0x0553, 0x1AD6, 0x09F9, 0x1476, 0x05A6,
0xFD92, 0xFA5D, 0xECC4, 0xF52E, 0xE28C, 0xF5B0, 0xE905, 0xFDB6,
0xFE6F, 0x02AC, 0x0519, 0x026D, 0x0ED1, 0x057E, 0x2068, 0x0C0D,
0x193D, 0x0855, 0x01A2, 0xFD87, 0xF505, 0xF5D0, 0xE95B, 0xF37E,
0xE912, 0xFA6C, 0xF667, 0xFDB8, 0xFD02, 0xFEEE, 0x0AEF, 0x03AE,
0x1AC3, 0x0A0D, 0x17E3, 0x09D3, 0x0386, 0x0214, 0xF5EC, 0xF8C9,
0xEE1C, 0xF376, 0xE753, 0xF893, 0xF0D9, 0xFC85, 0xFD47, 0xFD8B,
0x0888, 0x018C, 0x1A8F, 0x0A68, 0x1FAF, 0x0BA0, 0x0BC3, 0x0441,
0xF9BC, 0xFA43, 0xEB4F, 0xF137, 0xE325, 0xF763, 0xED65, 0xFD12,
0xF614, 0xFB2B, 0x03C7, 0x0054, 0x1957, 0x0C5E, 0x1FB4, 0x0E7A,
0x1109, 0x07B4, 0xFA7D, 0xFD4F, 0xE92A, 0xF3B3, 0xE7A6, 0xF86C,
0xED4E, 0xFB8E, 0xF51E, 0xF941, 0x0968, 0xFF0F, 0x1CD5, 0x0AC3,
0x1FB6, 0x0C52, 0x0E88, 0x0621, 0xF865, 0xFFD6, 0xE741, 0xF71C,
0xE321, 0xF5EE, 0xEAF5, 0xF8A5, 0xF367, 0xF99C, 0x0879, 0xFE4C,
0x1EB4, 0x08B5, 0x1CA0, 0x0ACF, 0x0C4F, 0x0808, 0xFD58, 0x0432,
0xE79F, 0xF99B, 0xE463, 0xF717, 0xF3C5, 0xF977, 0xF7B2, 0xF87A,
0x0802, 0xF9D2, 0x1BF6, 0x0365, 0x17F0, 0x09DB, 0x088F, 0x0A0F,
0xF9A5, 0x045B, 0xE715, 0xFAF0, 0xE53D, 0xFAFD, 0xF5B7, 0xFAEA,
0xFB72, 0xF6AE, 0x05EB, 0xF6D8, 0x1A42, 0x025B, 0x1972, 0x0A82,
0x04BD, 0x08C2, 0xFA2F, 0x041F, 0xF034, 0xFE67, 0xEAAC, 0xFE41,
0xF65D, 0xF936, 0xF9F5, 0xF186, 0x02BA, 0xF60E, 0x163D, 0x03B7,
0x121A, 0x07EB, 0xFECD, 0x069A, 0xF8B7, 0x0584, 0xF14A, 0x0207,
0xED8F, 0x0166, 0xF628, 0xF9A5, 0xFC50, 0xF2B2, 0x0780, 0xF87A,
0x132A, 0x021A, 0x11EF, 0x05B4, 0x0606, 0x0929, 0xFBE1, 0x07C5,
0xF11D, 0x0072, 0xECE6, 0xFEF1, 0xF3CD, 0xFA75, 0xF964, 0xF46B,
0x03F1, 0xF66A, 0x1049, 0xFEB4, 0x1143, 0x03F8, 0x05DE, 0x09F7,
0xFA51, 0x06D7, 0xEE45, 0xFCE6, 0xEF45, 0x013D, 0xF81E, 0x006E,
0xF68E, 0xF49E, 0x065F, 0xF363, 0x1A1A, 0xFF04, 0x14A3, 0x04BC,
0x04CF, 0x0701, 0xF695, 0x02BB, 0xE896, 0xFBC1, 0xEB60, 0x0344,
0xF38C, 0x0234, 0xF393, 0xF4B8, 0x0894, 0xF36B, 0x1D6F, 0xFFC5,
0x1384, 0x03B4, 0x01B1, 0x03B5, 0xF7BF, 0x0377, 0xE8C0, 0xFFA5,
0xE700, 0x02DB, 0xF55E, 0x00F1, 0xFB8E, 0xF759, 0x0E24, 0xF62C,
0x2162, 0xFEE6, 0x12D8, 0xFFE0, 0xFCDF, 0x014A, 0xF30F, 0x0465,
0xE0D3, 0x004E, 0xE1A1, 0x0138, 0xF77E, 0x00B5, 0xFE3C, 0xFA3F,
0x0D70, 0xF74A, 0x20A5, 0xFC1A, 0x16DB, 0x0006, 0xFEF0, 0x0462,
0xEE9E, 0x02A4, 0xE103, 0xFDBD, 0xE720, 0x016C, 0xFACA, 0x0062,
0x0105, 0xF9DE, 0x0DB4, 0xF661, 0x1E7B, 0xFBA2, 0x15A0, 0x015A,
0xF8FA, 0x0478, 0xE86E, 0x00F4, 0xE2D4, 0xFDC8, 0xE8EA, 0x032A,
0xF832, 0xFF02, 0xFF97, 0xF6CF, 0x11B7, 0xF977, 0x2250, 0x0193,
0x142F, 0x024D, 0xFBDB, 0x0371, 0xEEEA, 0x003F, 0xE5D3, 0xFD29,
0xEAAA, 0x02EF, 0xF64D, 0xFBF8, 0xFDBF, 0xF405, 0x127E, 0xFB8B,
0x1CC1, 0x03BD, 0x0F52, 0x022C, 0x00A5, 0x0473, 0xF17C, 0x02A1,
0xE235, 0xFD01, 0xE890, 0x007E, 0xF801, 0xFD3D, 0x001F, 0xF73B,
0x116D, 0xFBD1, 0x1D74, 0x041D, 0x14B2, 0x043B, 0x0697, 0x05CB,
0xF497, 0x022A, 0xDEBE, 0xFA77, 0xE565, 0xFF0A, 0xF697, 0xFE5A,
0xF8BA, 0xF5F3, 0x0D7F, 0xF9D2, 0x226B, 0x065E, 0x1732, 0x0850,
0x0524, 0x06B7, 0xF489, 0x0031, 0xE025, 0xFC16, 0xE710, 0x021C,
0xF639, 0xFD9F, 0xF926, 0xF504, 0x13E4, 0xF928, 0x2A22, 0x0593,
0x19FE, 0x08B3, 0x0368, 0x0566, 0xF38B, 0xFF7A, 0xDF8C, 0xFE2A,
0xDFA7, 0x0119, 0xEFB5, 0xFA6C, 0xFB16, 0xF425, 0x155A, 0xF94A,
0x2981, 0x0463, 0x198B, 0x077A, 0x02D4, 0x08A1, 0xF54A, 0x041B,
0xE148, 0xFFAC, 0xE028, 0x014E, 0xF2D2, 0xF8C4, 0x000D, 0xF2D4,
0x1750, 0xF88D, 0x27CF, 0x007B, 0x1852, 0x077E, 0x00D5, 0x0D95,
0xEDB2, 0x050F, 0xDC25, 0xFF85, 0xE266, 0x03D5, 0xF2C0, 0xF9F7,
0xFE39, 0xF116, 0x16B7, 0xF638, 0x268A, 0x013B, 0x19A2, 0x0AE8,
0x0241, 0x0F97, 0xEE0E, 0x0655, 0xE176, 0x00B4, 0xEA0D, 0x0377,
0xF4DB, 0xF79E, 0xFC77, 0xEC32, 0x173D, 0xF5E6, 0x255C, 0x04FB,
0x12BD, 0x0904, 0xFE0B, 0x0D6E, 0xEECA, 0x0823, 0xE0E4, 0x0219,
0xEA1D, 0x037A, 0xF52C, 0xF59C, 0xFA1C, 0xEACD, 0x16BD, 0xF6C8,
0x2522, 0x054F, 0x1270, 0x0851, 0x045A, 0x0C7D, 0xF639, 0x085D,
0xE2F6, 0x01EB, 0xEB39, 0x0028, 0xF75C, 0xF53F, 0xF865, 0xED72,
0x0F8A, 0xF4C3, 0x2083, 0x0398, 0x12BB, 0x0A01, 0x0459, 0x0C28,
0xF59D, 0x07A6, 0xE1CE, 0x02A6, 0xE9E5, 0x0281, 0xF7D4, 0xF8E5,
0xF798, 0xEEC1, 0x0E37, 0xF404, 0x249B, 0x0368, 0x173E, 0x0BE4,
0x044E, 0x0BED, 0xF668, 0x03D5, 0xE3F1, 0x04BE, 0xE7FA, 0x07D4,
0xF29D, 0xF8C1, 0xF5A0, 0xEE37, 0x0ED8, 0xF45E, 0x235F, 0x0117,
0x155D, 0x09E4, 0x022D, 0x0A9D, 0xF57F, 0x0381, 0xE533, 0x0792,
0xE742, 0x09E6, 0xF3AA, 0xF83B, 0xFDB3, 0xEE0F, 0x1604, 0xF4D3,
0x24A8, 0xFEAD, 0x160E, 0x05BF, 0x030C, 0x0B8C, 0xF363, 0x0663,
0xE16B, 0x06DA, 0xE4D6, 0x0AE5, 0xF3FB, 0xFAD8, 0xFFD8, 0xEDB7,
0x161F, 0xF3F9, 0x20C8, 0xFD65, 0x1286, 0x0527, 0x0107, 0x0D72,
0xEF91, 0x0624, 0xE1C0, 0x0567, 0xEC6E, 0x0BD4, 0xF958, 0xFBD5,
0x0147, 0xEC3E, 0x18D7, 0xF1A1, 0x223E, 0xFECD, 0x0EAF, 0x06C9,
0xFA19, 0x0ADD, 0xEA5B, 0x0592, 0xE258, 0x0609, 0xF0A5, 0x0A18,
0xFA67, 0xFB83, 0x005D, 0xEC93, 0x1A25, 0xF334, 0x22BA, 0x0216,
0x0B00, 0x0622, 0xF7D3, 0x0783, 0xEECB, 0x04E0, 0xE79F, 0x0585,
0xF2B6, 0x0674, 0xFC74, 0xF936, 0x011B, 0xEF50, 0x1775, 0xF5F7,
0x1EE4, 0x01EB, 0x068C, 0x0750, 0xF4D6, 0x07D1, 0xEE6F, 0x024A,
0xE557, 0x0410, 0xF065, 0x04F6, 0xFE29, 0xFAD1, 0x0210, 0xF4B8,
0x1520, 0xF6E5, 0x2064, 0x0123, 0x0E54, 0x0944, 0xF97C, 0x06DE,
0xEDC2, 0xFCCD, 0xE61E, 0x007C, 0xF18D, 0x0656, 0xFC7B, 0xFBC9,
0xFECC, 0xF3A1, 0x1196, 0xF820, 0x2084, 0x037F, 0x1272, 0x0987,
0xF900, 0x04C8, 0xE877, 0xF961, 0xE377, 0x00D9, 0xEF2D, 0x0965,
0xF97C, 0xFA6D, 0x017C, 0xF2AE, 0x189F, 0xFBB3, 0x263B, 0x0494,
0x15CF, 0x067F, 0xFAD5, 0x02AC, 0xE78D, 0xFA8E, 0xDF50, 0x0181,
0xE9D1, 0x0724, 0xF542, 0xFA1D, 0x028A, 0xF564, 0x1C60, 0xFE06,
0x2566, 0x0503, 0x1467, 0x0590, 0xFC0D, 0x04F4, 0xE509, 0xFDE8,
0xD9D8, 0xFE51, 0xE995, 0x0362, 0xFB11, 0xFAFD, 0x0946, 0xF474,
0x2176, 0xFAF7, 0x2804, 0x0495, 0x1520, 0x0889, 0xFB24, 0x06BD,
0xE09E, 0xFBCD, 0xD41F, 0xFC4C, 0xE88E, 0x0241, 0xFD49, 0xFA33,
0x0885, 0xF2DB, 0x2037, 0xF90C, 0x2888, 0x0959, 0x1207, 0x0F27,
0xF69F, 0x05BE, 0xE18B, 0xF9DB, 0xD8E3, 0xFD1E, 0xECDD, 0xFF9D,
0x0034, 0xF559, 0x0AB3, 0xF154, 0x2198, 0xFBBD, 0x27B0, 0x0DA7,
0x0DC8, 0x113B, 0xF204, 0x05FF, 0xE301, 0xFB0B, 0xDC13, 0xFDF4,
0xE98A, 0xFC94, 0xFD3D, 0xF122, 0x0ABC, 0xF450, 0x1DB5, 0x00CD,
0x23EE, 0x0C94, 0x0EDF, 0x1162, 0xF69B, 0x0854, 0xE996, 0xF90E,
0xDFD2, 0xF96E, 0xE92E, 0xF984, 0xFC4E, 0xF146, 0x0992, 0xF550,
0x19B2, 0x0076, 0x1FC2, 0x0D81, 0x117F, 0x1450, 0xFA20, 0x0AB2,
0xE769, 0xF7A2, 0xDF36, 0xF6E2, 0xE97B, 0xFC9E, 0xF78B, 0xF4CB,
0x0505, 0xF41E, 0x19E6, 0x00CF, 0x244E, 0x0FA3, 0x1922, 0x1412,
0xFED7, 0x087A, 0xE791, 0xF53D, 0xDF6E, 0xF6B4, 0xE893, 0xFD04,
0xF254, 0xF272, 0x000D, 0xF1E7, 0x1BA9, 0x0190, 0x27E1, 0x112E,
0x1840, 0x12E4, 0xFE8D, 0x07A1, 0xE7CF, 0xF98D, 0xDB28, 0xF8EB,
0xE4F7, 0xF9ED, 0xF306, 0xF20B, 0x0383, 0xF2AC, 0x21F1, 0xFEF6,
0x2CB9, 0x0EB8, 0x1947, 0x11EB, 0xFE76, 0x093C, 0xE584, 0xFD07,
0xD55A, 0xF863, 0xE140, 0xF7D2, 0xF5A4, 0xF346, 0x05CC, 0xF41B,
0x1FD5, 0xFCC9, 0x2BCC, 0x0CBE, 0x1842, 0x15E0, 0xF989, 0x0CBF,
0xE16F, 0xFB9E, 0xD429, 0xF851, 0xE3E0, 0xF7D4, 0xFC67, 0xF06D,
0x0951, 0xF0D6, 0x1F3E, 0xF9C5, 0x2C3A, 0x0D59, 0x163E, 0x1854,
0xF2BC, 0x0B6A, 0xDD6E, 0xFAAF, 0xD5CF, 0xF991, 0xE53C, 0xF78D,
0xFCA9, 0xEE6E, 0x0AD6, 0xF0A6, 0x1E41, 0xFE2B, 0x2805, 0x1058,
0x13B6, 0x16D0, 0xF2A0, 0x0B7B, 0xE17C, 0xFB3F, 0xDC46, 0xF7B4,
0xE7A3, 0xF495, 0xFE17, 0xEB39, 0x0D88, 0xF24A, 0x1C27, 0x01D1,
0x2138, 0x0FBC, 0x10D3, 0x16AA, 0xF51A, 0x0CD8, 0xE278, 0xFB10,
0xDB21, 0xF5D8, 0xE6A9, 0xF395, 0xFB8C, 0xEDE5, 0x0982, 0xF4AA,
0x184F, 0x01D9, 0x1FDF, 0x103D, 0x15F1, 0x1602, 0xFBFD, 0x0AC2,
0xE4A7, 0xF7B5, 0xDC38, 0xF191, 0xE813, 0xF479, 0xF929, 0xF092,
0x0426, 0xF3D9, 0x16BC, 0x0330, 0x2354, 0x136A, 0x187D, 0x1680,
0xFCE9, 0x0975, 0xE5FB, 0xF7ED, 0xDAB2, 0xF47E, 0xE3B5, 0xF62C,
0xF4D7, 0xF031, 0x0303, 0xF428, 0x1D6D, 0x02C8, 0x2B24, 0x123B,
0x1AB4, 0x137B, 0xFEC7, 0x0571, 0xE7EE, 0xF894, 0xD6FE, 0xF4CC,
0xDC5D, 0xF3A3, 0xF237, 0xF1AC, 0x051F, 0xF723, 0x1ED7, 0x02A0,
0x2C4F, 0x1134, 0x1C30, 0x1493, 0xFD52, 0x0868, 0xE455, 0xF95F,
0xD1FD, 0xF32B, 0xD85F, 0xF323, 0xF76E, 0xF151, 0x0D3A, 0xF6B7,
0x20EC, 0x013F, 0x2F49, 0x0F76, 0x1F03, 0x1698, 0xF8E1, 0x08FD,
0xDE81, 0xF6F4, 0xD0B4, 0xF408, 0xDA45, 0xF4B0, 0xF9C1, 0xF0CB,
0x0DAD, 0xF6E3, 0x20A4, 0x036E, 0x2EE6, 0x138B, 0x1D11, 0x18AD,
0xF37C, 0x088C, 0xDA88, 0xF779, 0xD6A1, 0xF2DB, 0xE215, 0xF1C7,
0xFB44, 0xECFD, 0x104B, 0xF46F, 0x2358, 0x06AF, 0x2B58, 0x1479,
0x1955, 0x15CC, 0xF31C, 0x0A7B, 0xDC45, 0xF93B, 0xD97F, 0xF041,
0xE29F, 0xEF5C, 0xFB56, 0xED5E, 0x0FBF, 0xF90D, 0x1F26, 0x0A6F,
0x2573, 0x151F, 0x17EC, 0x1727, 0xF9FD, 0x0A90, 0xE23B, 0xF7B5,
0xD98E, 0xEC9C, 0xE511, 0xEC46, 0xFE53, 0xEF6C, 0x0BBD, 0xF92F,
0x1929, 0x0892, 0x237E, 0x1814, 0x1B44, 0x1946, 0xFF91, 0x097D,
0xE3CF, 0xF707, 0xD95F, 0xEC99, 0xE517, 0xEFDC, 0xFB41, 0xF207,
0x061C, 0xF802, 0x16E7, 0x0A44, 0x2909, 0x1A02, 0x21DA, 0x1773,
0x021F, 0x052C, 0xE759, 0xF4A3, 0xDAE9, 0xEE7E, 0xDF8D, 0xEED1,
0xF526, 0xEEBC, 0x03E8, 0xF9E9, 0x18CF, 0x0D4F, 0x2BEC, 0x1A76,
0x2116, 0x16E6, 0x01F3, 0x056A, 0xE856, 0xF962, 0xD5DB, 0xF223,
0xD699, 0xEDC8, 0xF2D4, 0xEF95, 0x09FF, 0xFAEB, 0x1DCF, 0x0B9E,
0x2D28, 0x179A, 0x24DF, 0x15B2, 0x059F, 0x07F7, 0xE641, 0xF8F0,
0xD080, 0xEEBA, 0xD29F, 0xEED8, 0xF5C1, 0xF127, 0x0F94, 0xFA2C,
0x1D10, 0x09DA, 0x2B2F, 0x16B0, 0x2577, 0x1AD0, 0x0228, 0x0C33,
0xDFC4, 0xF6DA, 0xCEB8, 0xEDB8, 0xD5CC, 0xEEE3, 0xF91D, 0xEEC6,
0x1134, 0xF69C, 0x1F5C, 0x07DB, 0x2C2E, 0x1847, 0x21E1, 0x1B1E,
0xFD3E, 0x0A67, 0xDD25, 0xF7C3, 0xD2E9, 0xEE3D, 0xDADF, 0xEEAA,
0xF6EC, 0xEDAD, 0x1092, 0xF525, 0x21D7, 0x0CEC, 0x28F1, 0x1D21,
0x1B81, 0x1A9D, 0xFB96, 0x0BB4, 0xE207, 0xF8C3, 0xD950, 0xEA75,
0xDE23, 0xE879, 0xF93A, 0xE9C2, 0x11DA, 0xF601, 0x1F86, 0x0CFA,
0x23EF, 0x19F0, 0x176C, 0x19BC, 0xFEE6, 0x0CAE, 0xE7B9, 0xF9D7,
0xD887, 0xE8B3, 0xDD50, 0xE4EC, 0xF9D1, 0xEDCB, 0x0D31, 0xFB51,
0x1970, 0x0D67, 0x225B, 0x1BF5, 0x1B76, 0x1B79, 0x041E, 0x0C24,
0xE99C, 0xF79F, 0xDB19, 0xE653, 0xE034, 0xE6A9, 0xF851, 0xEEEB,
0x06E9, 0xF8E8, 0x13B8, 0x0C62, 0x24F6, 0x1CB0, 0x1FDB, 0x1C8E,
0x0258, 0x0AC2, 0xE8B4, 0xF5D2, 0xDB26, 0xEAC1, 0xDB34, 0xEA9C,
0xF2A6, 0xEE0B, 0x04CA, 0xFA6C, 0x167A, 0x0DA9, 0x29A7, 0x1ACF,
0x2183, 0x19DE, 0x0476, 0x079B, 0xEB35, 0xF6E3, 0xDA2A, 0xED1B,
0xD67F, 0xE8FC, 0xEEE2, 0xEB87, 0x07CF, 0xF894, 0x19A0, 0x0E77,
0x27C6, 0x1A53, 0x20F3, 0x17D8, 0x04D5, 0x0C2E, 0xE78B, 0xFC78,
0xD5E1, 0xEF40, 0xD5E3, 0xEC0F, 0xF2EE, 0xEBDF, 0x0DC3, 0xF5DB,
0x1BE9, 0x0BF5, 0x28C4, 0x16C2, 0x2392, 0x1845, 0x054A, 0x0FD2,
0xE413, 0xFC10, 0xD39D, 0xED73, 0xDA4C, 0xEB0A, 0xF7D3, 0xEB8E,
0x0D67, 0xF30E, 0x1B78, 0x0719, 0x2768, 0x1824, 0x1EC5, 0x1B39,
0x01C1, 0x110C, 0xE359, 0xFFA0, 0xD746, 0xEE1B, 0xE086, 0xEA3A,
0xFAD2, 0xEB0F, 0x0EC8, 0xEE05, 0x1C89, 0x049D, 0x2527, 0x19E8,
0x1964, 0x1A91, 0xFEEF, 0x1035, 0xE6A1, 0xFF4D, 0xDB13, 0xEEE1,
0xE0FF, 0xEB34, 0xFBA6, 0xEA48, 0x0D7B, 0xF097, 0x16EB, 0x068E,
0x1F2B, 0x193D, 0x14B7, 0x1CC1, 0x0137, 0x1007, 0xED71, 0xFE8B,
0xDE15, 0xEF45, 0xE2CE, 0xE812, 0xFDBB, 0xEB44, 0x0CF6, 0xF411,
0x12B1, 0x0470, 0x1B5B, 0x15F2, 0x15E1, 0x1A62, 0x03C1, 0x0E78,
0xEECB, 0xFDD7, 0xDFC5, 0xEEDC, 0xE1C0, 0xEBDD, 0xFA7C, 0xF057,
0x0A8C, 0xF72B, 0x0FF7, 0x0744, 0x1C7F, 0x1367, 0x19A2, 0x1745,
0x0483, 0x0E19, 0xF019, 0xF9DC, 0xE1E7, 0xEF17, 0xE1F2, 0xF02B,
0xF96C, 0xF1E3, 0x099D, 0xF910, 0x11FC, 0x067C, 0x1F3C, 0x0F58,
0x19F2, 0x13CF, 0x042D, 0x0C5E, 0xEDA7, 0xFC82, 0xDF40, 0xF376,
0xE0F6, 0xF3F4, 0xF8C0, 0xF638, 0x0E0A, 0xF9EA, 0x1843, 0x0597,
0x20C4, 0x0D2C, 0x1A51, 0x0CF4, 0x03B5, 0x0A08, 0xEAE6, 0xFE71,
0xDDD3, 0xF307, 0xE1D9, 0xF5D9, 0xFB9E, 0xF724, 0x1122, 0xF7F2,
0x199A, 0x04A0, 0x20D3, 0x0AD4, 0x1675, 0x0B8F, 0xFDDE, 0x0B77,
0xE5C4, 0x014B, 0xDAC4, 0xF677, 0xE5BB, 0xF700, 0x014A, 0xF8E2,
0x13A8, 0xF942, 0x1C48, 0x0221, 0x20BB, 0x0AE6, 0x124D, 0x0C28,
0xFB61, 0x08B2, 0xE4B5, 0x0180, 0xDADA, 0xF692, 0xE7F0, 0xF4B1,
0x032E, 0xF95F, 0x147C, 0xF96E, 0x189E, 0x02D8, 0x1A59, 0x0DFA,
0x0D6B, 0x0DFD, 0xF8B2, 0x08F9, 0xE78E, 0xFFEB, 0xDE80, 0xF5BE,
0xE8DC, 0xF3A5, 0x0633, 0xF6FF, 0x15C3, 0xFB3D, 0x15A3, 0x04ED,
0x18C6, 0x0CF7, 0x0D99, 0x0EAD, 0xFA13, 0x06C4, 0xE980, 0xFA35,
0xDF9C, 0xF37E, 0xE95E, 0xF18D, 0x032C, 0xF70D, 0x10A8, 0x007B,
0x11F7, 0x08E8, 0x1717, 0x0E9E, 0x1040, 0x0F1A, 0xFE11, 0x0633,
0xEB82, 0xF701, 0xE239, 0xEF81, 0xE870, 0xF2FA, 0xFE8F, 0xF92A,
0x0F53, 0x00C2, 0x1212, 0x0BCA, 0x1816, 0x0E62, 0x1231, 0x0B51,
0xFF72, 0x0494, 0xECB5, 0xF396, 0xE03E, 0xECC6, 0xE300, 0xF530,
0xF8D0, 0xFBCC, 0x0E44, 0x02F0, 0x16A6, 0x0D39, 0x1BBB, 0x0DA5,
0x1430, 0x089C, 0x03C5, 0x0208, 0xEE4D, 0xF499, 0xDDB7, 0xED11,
0xE22D, 0xF42E, 0xF885, 0xFF29, 0x0FB6, 0x03B9, 0x190D, 0x0A76,
0x1C07, 0x0CA5, 0x14AD, 0x0583, 0x028D, 0x0190, 0xE9CF, 0xF843,
0xD8F5, 0xEE14, 0xE16E, 0xF40F, 0xFB3A, 0x0012, 0x1174, 0x03BD,
0x1AD9, 0x0850, 0x1EA3, 0x0B07, 0x13B5, 0x0725, 0xFFD7, 0x0382,
0xE980, 0xFA03, 0xD9FD, 0xF0DE, 0xE47F, 0xF29C, 0xFC7D, 0xFDA2,
0x0F29, 0x0332, 0x19FA, 0x04C0, 0x1CAF, 0x0B05, 0x0D6D, 0x0A3D,
0xF99C, 0x03D6, 0xE8E7, 0xFBF3, 0xDE63, 0xF35A, 0xE7E5, 0xF0F8,
0xFD9D, 0xF8FF, 0x108A, 0x0092, 0x18AC, 0x05F5, 0x198F, 0x0C40,
0x0C5B, 0x0B39, 0xFA77, 0x05EF, 0xED1B, 0xFC3E, 0xE2CC, 0xF3CF,
0xE9BB, 0xF003, 0xFE87, 0xF39A, 0x0E97, 0xFFE7, 0x1246, 0x08E6,
0x12BB, 0x0BE6, 0x0A6E, 0x0C08, 0xFDC7, 0x07A5, 0xF116, 0xFB12,
0xE53A, 0xF156, 0xEC23, 0xEDE4, 0xFD8B, 0xF35E, 0x0B01, 0x00E4,
0x0FAD, 0x0944, 0x110D, 0x0BDE, 0x0CBF, 0x0A98, 0x017F, 0x07AB,
0xF3C1, 0xFB3A, 0xE7DD, 0xEECB, 0xEC5E, 0xF037, 0xF9A8, 0xF846,
0x0526, 0x0144, 0x0D69, 0x09C2, 0x131F, 0x0D9C, 0x0FA7, 0x094B,
0x04B5, 0x044E, 0xF749, 0xF889, 0xE8CB, 0xEF87, 0xEB99, 0xF362,
0xF881, 0xFA0E, 0x041B, 0x019E, 0x0F84, 0x0832, 0x1498, 0x0CFA,
0x0EDE, 0x079F, 0x051F, 0xFFAE, 0xF7FD, 0xF9EB, 0xE68B, 0xF3E0,
0xE69D, 0xF48B, 0xF5F4, 0xFC8E, 0x0591, 0x03C5, 0x1143, 0x0617,
0x14E7, 0x0980, 0x0E87, 0x03C0, 0x0436, 0xFDC9, 0xF85B, 0xFD47,
0xE73F, 0xF7ED, 0xE793, 0xF635, 0xF9F0, 0xFD8C, 0x08CD, 0x0604,
0x121B, 0x052B, 0x1422, 0x050E, 0x0BF5, 0x050B, 0x0131, 0x0101,
0xF67E, 0xFE45, 0xE8A7, 0xFBFD, 0xEBBA, 0xF8E4, 0xFE04, 0xFD1F,
0x0B92, 0x063D, 0x12CC, 0x0196, 0x11DD, 0x00B6, 0x089A, 0x05E5,
0xFD96, 0x021A, 0xF730, 0xFD83, 0xEF6F, 0xFC30, 0xF0A2, 0xFA7E,
0xFFE9, 0xFBF8, 0x0B44, 0x049A, 0x1035, 0x0456, 0x0E73, 0x01AC,
0x0349, 0x04F4, 0xF935, 0x0416, 0xF8D8, 0xFE35, 0xF56D, 0xFBB0,
0xF57B, 0xFB65, 0x0182, 0xF999, 0x09D8, 0x03B7, 0x0EF6, 0x08BE,
0x0C89, 0x0332, 0x0134, 0x0357, 0xFA0D, 0x0264, 0xFA58, 0xFD1D,
0xF8DF, 0xFA09, 0xF7D5, 0xFA27, 0x0077, 0xFC61, 0x07DF, 0x06F3,
0x0AD8, 0x0B31, 0x09E0, 0x0556, 0x023A, 0x0188, 0xFAB3, 0xFF0B,
0xFAFF, 0xFB25, 0xFB1F, 0xF6E8, 0xF922, 0xFA05, 0x015A, 0x0051,
0x06D4, 0x09D4, 0x093F, 0x0DC8, 0x0BD3, 0x059C, 0x0321, 0xFEFC,
0xF9DA, 0xFABD, 0xF945, 0xF731, 0xF96E, 0xF834, 0xF8FA, 0xFD0D,
0xFF6A, 0x0344, 0x0567, 0x0E42, 0x0B06, 0x1060, 0x0E1C, 0x0602,
0x0518, 0xFCC9, 0xF8A8, 0xF414, 0xF5A2, 0xF2C1, 0xF92B, 0xF885,
0xF90C, 0xFE0C, 0x010E, 0x0581, 0x09E3, 0x0FCA, 0x0BDF, 0x10A9,
0x0E9D, 0x04B7, 0x0515, 0xF9D6, 0xF503, 0xF2C4, 0xF1A2, 0xF1B7,
0xF578, 0xF8E7, 0xF728, 0x0087, 0x0347, 0x063B, 0x0DEB, 0x1152,
0x0EF2, 0x1213, 0x0F06, 0x01B2, 0x0314, 0xF8F2, 0xF3B7, 0xF385,
0xEF30, 0xEF1F, 0xF573, 0xF83F, 0xFACB, 0x014F, 0x03A6, 0x056B,
0x0F8E, 0x1032, 0x0FFA, 0x1310, 0x0C22, 0x045D, 0x019A, 0xFA0F,
0xF07D, 0xF47E, 0xEB53, 0xEEA5, 0xF640, 0xF598, 0xFCD5, 0x01AB,
0x05AC, 0x05C7, 0x10C6, 0x0DC9, 0x0E21, 0x15D6, 0x0BFB, 0x08E4,
0x01E6, 0xFA31, 0xF036, 0xF53C, 0xEC47, 0xECF5, 0xF65D, 0xF0A6,
0xFF4E, 0xFECB, 0x05DA, 0x04A9, 0x0D58, 0x0E24, 0x0D5A, 0x192F,
0x0A78, 0x0E66, 0x00AD, 0xFC3E, 0xF128, 0xF3CA, 0xEC42, 0xEC86,
0xF8E9, 0xED30, 0x0225, 0xF8F5, 0x03CD, 0x0515, 0x0D2D, 0x1080,
0x0EEF, 0x1ADE, 0x0CCB, 0x13C2, 0x0582, 0xFDDF, 0xF23F, 0xF0AE,
0xEB2F, 0xE973, 0xF6B2, 0xE905, 0xFEF8, 0xF6A4, 0x030F, 0x06AE,
0x0AF3, 0x138A, 0x0D0F, 0x1CE0, 0x0E8F, 0x15D5, 0x06E4, 0x00D4,
0xF455, 0xEF38, 0xEB3F, 0xE4E9, 0xF25F, 0xE8B0, 0xFE9B, 0xF66C,
0x039E, 0x05BC, 0x0B66, 0x15B6, 0x10F7, 0x1DA8, 0x10D9, 0x169E,
0x0A44, 0x01CF, 0xF53D, 0xED12, 0xE5BD, 0xE435, 0xEE88, 0xEA23,
0xFDA0, 0xF716, 0x042F, 0x057E, 0x0CE1, 0x1499, 0x109B, 0x1DEA,
0x133E, 0x173E, 0x0EE9, 0x004F, 0xF4E3, 0xECFC, 0xE40F, 0xE390,
0xECE7, 0xE8D6, 0xFED0, 0xF7E7, 0x08FE, 0x0365, 0x0DE3, 0x11FD,
0x11B1, 0x1D09, 0x12AC, 0x1665, 0x0AF9, 0x02CB, 0xF432, 0xF11D,
0xE203, 0xE59E, 0xE979, 0xE850, 0xFEFF, 0xF614, 0x091A, 0x02F6,
0x0F0C, 0x103B, 0x131F, 0x1964, 0x1038, 0x180D, 0x0A38, 0x05F3,
0xF4F0, 0xF23B, 0xE402, 0xE7E8, 0xECB8, 0xE72C, 0xFFF9, 0xF45B,
0x0BDA, 0x0260, 0x0F09, 0x0C8B, 0x0E2D, 0x1894, 0x0CA8, 0x1C63,
0x07C6, 0x0AE3, 0xF4C3, 0xF4E0, 0xE4D0, 0xE798, 0xEA0A, 0xE69C,
0xFF23, 0xF33F, 0x0E65, 0x00AE, 0x0EC4, 0x0CDB, 0x0D74, 0x17F6,
0x0C7C, 0x1D50, 0x09B7, 0x0EBF, 0xF9A2, 0xF458, 0xE78B, 0xE6D0,
0xEC8A, 0xE6DF, 0x000B, 0xEFAB, 0x0C0C, 0x00AC, 0x0DB1, 0x107B,
0x0D71, 0x1878, 0x0CD9, 0x1D93, 0x0ABA, 0x0F4C, 0xF993, 0xF486,
0xE80C, 0xE5C8, 0xEBD5, 0xE3CF, 0xFCAA, 0xEF4E, 0x0B9B, 0x0187,
0x0E3B, 0x1206, 0x0FA2, 0x1971, 0x11A9, 0x1AC6, 0x0CB6, 0x0F89,
0xFB62, 0xF462, 0xE7F8, 0xE183, 0xE6E6, 0xE42E, 0xF88A, 0xF1F3,
0x09DC, 0x0282, 0x0E37, 0x141B, 0x10E4, 0x18B1, 0x119B, 0x183C,
0x0DDC, 0x0EEA, 0xFB98, 0xF332, 0xE38F, 0xE18D, 0xE3AE, 0xE489,
0xF73B, 0xF29E, 0x0BF6, 0x0385, 0x12B9, 0x127A, 0x12C5, 0x1856,
0x14A1, 0x16B4, 0x0F4D, 0x0BE0, 0xF7E7, 0xF4C2, 0xDF64, 0xE3A6,
0xDFE5, 0xE598, 0xF53E, 0xF46D, 0x0CFC, 0x030C, 0x1314, 0x11FC,
0x13FC, 0x1865, 0x1556, 0x1495, 0x0C61, 0x0BE2, 0xF62B, 0xF665,
0xDE05, 0xE476, 0xDF4C, 0xE568, 0xF726, 0xF23F, 0x0F89, 0x02CF,
0x16F3, 0x113C, 0x158C, 0x1586, 0x1389, 0x15CF, 0x0AA3, 0x0E75,
0xF51A, 0xF802, 0xDDE8, 0xE6C7, 0xDDBE, 0xE48F, 0xF38C, 0xF014,
0x103B, 0x0223, 0x1958, 0x10DC, 0x13CF, 0x16DE, 0x1258, 0x171C,
0x0B64, 0x0F65, 0xF72E, 0xF7AB, 0xDFC1, 0xE303, 0xDD7D, 0xE1AC,
0xF40B, 0xEDD2, 0x1065, 0x0022, 0x185E, 0x1352, 0x12B3, 0x192C,
0x1202, 0x1855, 0x0EA8, 0x1390, 0xF9E5, 0xF892, 0xDEB3, 0xE13B,
0xDD83, 0xE111, 0xF27D, 0xEC60, 0x0C6E, 0x00FC, 0x18AE, 0x16A7,
0x159F, 0x1BE6, 0x151D, 0x1783, 0x117B, 0x1093, 0xFC03, 0xF7FB,
0xE0FC, 0xDEEF, 0xDC01, 0xDCD1, 0xEC22, 0xEB96, 0x05EC, 0x00AE,
0x15EF, 0x16E4, 0x1852, 0x1EE3, 0x176C, 0x16C8, 0x10A7, 0x0E65,
0xFE3B, 0xF7DB, 0xE134, 0xDD82, 0xD6F3, 0xDCF9, 0xE899, 0xECA5,
0x0527, 0x01FB, 0x18C5, 0x1813, 0x1BC0, 0x1DDD, 0x1A38, 0x1636,
0x159F, 0x0D9E, 0x00E3, 0xF7C1, 0xDE14, 0xDF1B, 0xD002, 0xDCCF,
0xE2B4, 0xECF9, 0x0482, 0x035A, 0x19BD, 0x1691, 0x1BA5, 0x1DC8,
0x1D03, 0x1745, 0x171E, 0x0C8F, 0xFF27, 0xFA46, 0xDCF3, 0xE30A,
0xCDB6, 0xDD8A, 0xE1EB, 0xEB14, 0x046A, 0x001B, 0x1992, 0x1511,
0x2031, 0x1C6A, 0x21A1, 0x1699, 0x16D3, 0x0F39, 0xFCAD, 0xFC63,
0xDBB7, 0xE536, 0xCD99, 0xDF08, 0xDF01, 0xE7C1, 0x007B, 0xFD93,
0x1AC7, 0x13A6, 0x2254, 0x1AEE, 0x21C9, 0x1897, 0x1803, 0x11BB,
0xFF28, 0xFFB5, 0xE0F5, 0xE7F6, 0xD00F, 0xDDA3, 0xDCFC, 0xE494,
0x01EF, 0xF9B7, 0x1D1F, 0x1144, 0x2112, 0x1BDC, 0x2008, 0x1A85,
0x1855, 0x15AA, 0x0283, 0x0329, 0xE32C, 0xE6DC, 0xCE26, 0xDDB7,
0xDB36, 0xE391, 0xFF70, 0xF5D5, 0x19C5, 0x1130, 0x1F7B, 0x1D26,
0x204A, 0x1BE7, 0x1D0F, 0x16DD, 0x07AF, 0x0350, 0xE556, 0xE684,
0xD14B, 0xDB23, 0xDBBC, 0xE187, 0xFA84, 0xF5EE, 0x1534, 0x11A3,
0x1DAF, 0x1F41, 0x2166, 0x1D34, 0x1DB6, 0x1595, 0x073F, 0x058C,
0xE882, 0xE8D5, 0xD157, 0xDB23, 0xD69A, 0xE3A7, 0xF4EC, 0xF5CD,
0x1227, 0x116D, 0x224A, 0x2061, 0x25B5, 0x1A9E, 0x1E37, 0x1242,
0x0C40, 0x04CC, 0xEEAD, 0xEA23, 0xD173, 0xDCCD, 0xD22A, 0xE50F,
0xF0DD, 0xF78B, 0x11A0, 0x10CA, 0x2272, 0x1CD5, 0x24F1, 0x18EF,
0x202C, 0x10D0, 0x0D0F, 0x0480, 0xEE22, 0xEE6F, 0xD01C, 0xDEE8,
0xCE25, 0xE58E, 0xF14D, 0xF789, 0x128B, 0x0D1E, 0x2242, 0x1A49,
0x2A14, 0x1665, 0x2423, 0x0D70, 0x0CFA, 0x05EF, 0xEF6E, 0xF41E,
0xD2FF, 0xE432, 0xCE87, 0xE6F0, 0xEE24, 0xF581, 0x0D7D, 0x09B5,
0x221A, 0x17EC, 0x2E58, 0x174D, 0x22A0, 0x0EDE, 0x0999, 0x0833,
0xEF01, 0xF8E5, 0xD6BA, 0xE67B, 0xD19D, 0xE40C, 0xE866, 0xF1E4,
0x0CCC, 0x0899, 0x262D, 0x16F2, 0x2F30, 0x1883, 0x28DE, 0x12BD,
0x0A23, 0x08EE, 0xEB04, 0xFA7F, 0xD758, 0xEB76, 0xCC94, 0xE382,
0xE4E0, 0xE990, 0x08EA, 0x029D, 0x1C7D, 0x176E, 0x2A20, 0x1977,
0x2A7D, 0x1427, 0x17DE, 0x0E45, 0xF4E3, 0xFCC4, 0xD20F, 0xE659,
0xCE6D, 0xE53C, 0xE472, 0xEC5C, 0xFF2A, 0xF877, 0x1A34, 0x0FCA,
0x28BE, 0x198C, 0x2867, 0x1660, 0x1980, 0x1081, 0xFE4F, 0x0087,
0xE03E, 0xEEB4, 0xCCDA, 0xE52F, 0xD96F, 0xEABF, 0xF708, 0xFFAC,
0x112F, 0x0D95, 0x2508, 0x0DA1, 0x29A2, 0x0B1F, 0x19F4, 0x0CF0,
0xFFBE, 0x04E3, 0xE84E, 0xF02D, 0xDC53, 0xEB94, 0xDFF2, 0xF327,
0xEE56, 0xFBE2, 0x0A0F, 0x0D5C, 0x22EA, 0x145F, 0x222F, 0x0533,
0x1320, 0xFD63, 0x0203, 0xFF70, 0xE80F, 0xFB4B, 0xD57E, 0xF3F6,
0xE6A4, 0xF388, 0x0057, 0x032F, 0x0C72, 0x0DFF, 0x1A9A, 0x0938,
0x229B, 0x02F1, 0x1751, 0x012A, 0xFBFB, 0xF9DF, 0xDFDD, 0xF026,
0xDB54, 0xF66A, 0xEBA9, 0x00D3, 0xFA1A, 0x023A, 0x0DD4, 0x06F0,
0x23A3, 0x0CBD, 0x2038, 0x01E1, 0x0D64, 0xFA24, 0xF9E5, 0x0198,
0xE292, 0xFD5B, 0xD655, 0xEF17, 0xE8F1, 0xF478, 0x04EF, 0x0978,
0x1037, 0x0D7B, 0x1CDF, 0x0230, 0x25E0, 0xFDA6, 0x1343, 0x00AC,
0xF735, 0xFF83, 0xE4B0, 0xFBAF, 0xDC66, 0xFC32, 0xE545, 0xFA23,
0xF8D0, 0xF895, 0x111F, 0x0566, 0x2434, 0x10EF, 0x1CA6, 0x04AD,
0x0BDC, 0xF75D, 0x0034, 0xFD0A, 0xEAE7, 0x01BB, 0xDB2D, 0xF862,
0xE931, 0xF4BA, 0x005C, 0x0443, 0x0D82, 0x0A74, 0x1799, 0x0071,
0x1DE5, 0x01A0, 0x1654, 0x06D3, 0xFAD2, 0xFDA6, 0xE18A, 0xF55B,
0xE166, 0xF9CF, 0xED94, 0xFBA0, 0xFAA8, 0xFBAE, 0x0CEB, 0x09AC,
0x1B2C, 0x13A5, 0x1A29, 0x00A8, 0x0FDF, 0xF427, 0x0371, 0x015A,
0xEDD8, 0x0315, 0xDB49, 0xF67E, 0xE708, 0xF28A, 0xFE4D, 0xFF10,
0x0C11, 0x0B1E, 0x1B8C, 0x087D, 0x1FDB, 0x0342, 0x0EED, 0x0263,
0xFB8B, 0xFA51, 0xEB43, 0xF7CE, 0xE446, 0x03C6, 0xE8FD, 0x02E7,
0xF26B, 0xFBB0, 0x0A90, 0x0290, 0x2318, 0x0B2A, 0x1F40, 0xFFCC,
0x0FA1, 0xF299, 0x02AF, 0xFDC4, 0xECB6, 0x06F3, 0xDC87, 0xFD95,
0xE76C, 0xFBBE, 0x000F, 0x06A8, 0x0E42, 0x08E7, 0x15C7, 0x0150,
0x1DC9, 0xF977, 0x155E, 0xF7CF, 0xFCE1, 0xF8CD, 0xE835, 0xFE16,
0xE0DF, 0x0B62, 0xEA65, 0x09D4, 0xFAD9, 0xFC04, 0x0DF1, 0xFF3E,
0x2134, 0x0823, 0x201C, 0xFE63, 0x0EFA, 0xF16D, 0xFDBA, 0xF72A,
0xEC47, 0x048F, 0xDFF4, 0x03F6, 0xE6F0, 0x002C, 0xFB28, 0x0831,
0x0BC5, 0x068D, 0x19B3, 0xFA43, 0x203D, 0xFA67, 0x1563, 0xFFAA,
0xFCE3, 0xFEA7, 0xE958, 0xFF5F, 0xE6EB, 0x04C4, 0xEAF1, 0x02B3,
0xF32A, 0xF9F0, 0x0A81, 0xFD74, 0x1F11, 0x0782, 0x1CF0, 0xFEA1,
0x11AB, 0xF39B, 0x042A, 0xFDFB, 0xF13C, 0x0A3C, 0xE345, 0x08F3,
0xE6AF, 0xFDDD, 0xF6BF, 0xFAC8, 0x04B5, 0xFF7A, 0x0FF2, 0xFBF1,
0x1B8A, 0xFCC0, 0x1AEC, 0x0330, 0x0691, 0xFE55, 0xEEA8, 0xFD1D,
0xE95E, 0x08FB, 0xF0EE, 0x09D6, 0xF2E7, 0xFDCE, 0xFD5F, 0xF8EC,
0x13DE, 0xFEE0, 0x199E, 0xFC02, 0x1226, 0xF4A3, 0x0938, 0x0099,
0xF61F, 0x0C24, 0xE629, 0x05EB, 0xE764, 0x0131, 0xF234, 0x04BB,
0x0047, 0x0598, 0x0E41, 0xFDDD, 0x1846, 0xF4E8, 0x185A, 0xF720,
0x0829, 0xFBF2, 0xF51B, 0x002E, 0xEDF2, 0x0CAB, 0xEB95, 0x0E7D,
0xEDA2, 0xFEF8, 0xFE21, 0xFA2C, 0x12BB, 0x00F7, 0x165B, 0xFBB1,
0x109C, 0xF0F4, 0x0BF1, 0xF7A7, 0xFBAA, 0x0960, 0xE65C, 0x0C38,
0xE612, 0x075B, 0xF549, 0x092B, 0xFFA9, 0x00AE, 0x0903, 0xF294,
0x14F8, 0xF198, 0x19BB, 0xF744, 0x0B66, 0xFD9C, 0xF5D5, 0x068B,
0xF15B, 0x1072, 0xF1C3, 0x0FFF, 0xED59, 0x010F, 0xF90F, 0xF7DE,
0x0C34, 0xFAA8, 0x1002, 0xF412, 0x0DA7, 0xED76, 0x08F1, 0xFD05,
0xFCDC, 0x11EE, 0xF2D1, 0x1800, 0xF231, 0x0DFB, 0xF694, 0x0389,
0xFB49, 0xFADF, 0x0480, 0xECB1, 0x0E47, 0xED88, 0x0E9C, 0xFA40,
0x067C, 0xFCA1, 0xFD2E, 0x0582, 0xFB02, 0x1834, 0xF96F, 0x1884,
0xF1C6, 0x057A, 0xF7FF, 0xF410, 0x0758, 0xF0CD, 0x0482, 0xF045,
0x018A, 0xEE0B, 0x08C1, 0xFCBE, 0x03A1, 0x1052, 0xF915, 0x123C,
0xFA8F, 0x0E00, 0xFEB1, 0x08F4, 0xFB9D, 0xFDEB, 0xFBA4, 0xF13A,
0x04E1, 0xEB36, 0x0C1C, 0xF37E, 0x04C2, 0xFB2C, 0xFB21, 0x0242,
0xFD6B, 0x1596, 0x00AE, 0x191F, 0xFA6D, 0x049A, 0xF5ED, 0xF917,
0xFFBD, 0xF896, 0x04B4, 0xF34C, 0x0274, 0xEF1B, 0x06C9, 0xF623,
0x0281, 0x0618, 0xFA1F, 0x0EA3, 0xFD96, 0x0F25, 0xFEC6, 0x0FAA,
0xFA94, 0x01A5, 0xFD16, 0xED7F, 0x02F8, 0xEC39, 0x0696, 0xF54A,
0x0140, 0xFAEC, 0xFB00, 0xFFA9, 0xFF7D, 0x0CFB, 0xFDA4, 0x17BD,
0xF679, 0x0B2B, 0xFC28, 0xFB7E, 0x0546, 0xF862, 0x034D, 0xEE8A,
0x003D, 0xE89D, 0x0533, 0xF76B, 0x02AA, 0x0953, 0xF84D, 0x13FA,
0xFBEE, 0x14BF, 0x0550, 0x0D43, 0x0061, 0x0049, 0xFB74, 0xEDE5,
0x0123, 0xEA53, 0x066B, 0xF5A3, 0x00E9, 0xF70C, 0xF6D2, 0xFF8F,
0xFBF7, 0x1863, 0x05BC, 0x1F68, 0x01A0, 0x0EC9, 0x0083, 0xFB3F,
0x06F1, 0xF06D, 0x007C, 0xE9CF, 0xFAF2, 0xEA0B, 0xFFE7, 0xFC8B,
0xFE1D, 0x0E15, 0xFCAF, 0x103D, 0x0428, 0x14EA, 0x09FC, 0x14F9,
0x0555, 0x02A3, 0x0172, 0xEEB5, 0x027E, 0xE61F, 0xFBC4, 0xEF74,
0xF323, 0xFCAE, 0xF798, 0x0494, 0x040A, 0x1756, 0x0947, 0x1D4B,
0x0612, 0x094C, 0x06DC, 0xFC8A, 0x0BE5, 0xF74A, 0x021E, 0xEEC9,
0xF56E, 0xEF75, 0xFAF2, 0xFB6E, 0xFCFD, 0x0888, 0xF81A, 0x1005,
0x0307, 0x1542, 0x0F2F, 0x1543, 0x090D, 0xFFF6, 0x0018, 0xE9FE,
0x0147, 0xEF3E, 0x018E, 0xF9EB, 0xF8CE, 0xFDEA, 0xF5EA, 0x0348,
0x0025, 0x0EF4, 0x05CA, 0x181F, 0x031D, 0x0C31, 0x043F, 0xFDDC,
0x07EF, 0xF8B6, 0x053C, 0xEBC3, 0xFE41, 0xEB54, 0xFC6D, 0x013C,
0xFBD3, 0x0CAD, 0xFA17, 0x0E68, 0x0117, 0x1303, 0x0790, 0x11A7,
0xFFC7, 0x0271, 0xFD5E, 0xEC57, 0x0727, 0xEA98, 0x0694, 0xF761,
0xFB8D, 0xF8D5, 0xF89C, 0x00D7, 0x00BD, 0x1563, 0x03C2, 0x1B6A,
0x00C5, 0x1042, 0x0536, 0xFF94, 0x08EC, 0xF10F, 0x001C, 0xE6E0,
0xFB9B, 0xE96D, 0x0090, 0xFFD7, 0xFCC8, 0x0CC5, 0xF60A, 0x0AE5,
0xFD5E, 0x1648, 0x0B05, 0x1B37, 0x09A5, 0x0501, 0x0156, 0xEB8F,
0x058B, 0xE4B0, 0x071B, 0xEF17, 0xF856, 0xF93A, 0xF0EA, 0x033B,
0xFB18, 0x184D, 0x037E, 0x1D74, 0x0472, 0x0BF8, 0x0680, 0x019B,
0x09C8, 0xF5FB, 0x059E, 0xE6A3, 0xFE5B, 0xE91B, 0xFC60, 0xFD08,
0xF64D, 0x0C39, 0xEFC2, 0x0DC8, 0xFB88, 0x15D8, 0x09EA, 0x1B71,
0x0927, 0x02EF, 0x06C5, 0xE66D, 0x08B1, 0xE744, 0x05B6, 0xF2BC,
0xFB5A, 0xFC36, 0xF830, 0x0762, 0xFDDE, 0x1236, 0xFC07, 0x16CC,
0xFAAC, 0x0CBD, 0x059E, 0x02D3, 0x0AEB, 0xF850, 0x02AB, 0xE34E,
0xFE18, 0xE4BE, 0x0298, 0x01B3, 0x0286, 0x10DE, 0xF970, 0x0F5B,
0xFB11, 0x1239, 0x0753, 0x142D, 0x018F, 0x035D, 0xF788, 0xEACC,
0x0134, 0xEADF, 0x08C3, 0xF553, 0x019E, 0xF5F9, 0xFD07, 0x042E,
0x0209, 0x1874, 0x02ED, 0x198E, 0xFD1B, 0x0F9B, 0xFE36, 0x036C,
0x0161, 0xF4F4, 0xFBAA, 0xE4E8, 0xFC8F, 0xE543, 0x0465, 0x0009,
0x0463, 0x0DCA, 0x0220, 0x083A, 0x01B0, 0x128A, 0x0263, 0x1AF7,
0x0024, 0x09A7, 0xFC44, 0xEF6C, 0x01E9, 0xE4B0, 0x0521, 0xEC05,
0xFADD, 0xF4E3, 0xFC49, 0x0392, 0x0639, 0x1824, 0x012D, 0x17A1,
0xFA4D, 0x0B15, 0xFF93, 0x08C0, 0x0611, 0xFC7A, 0x0076, 0xE70D,
0xFE01, 0xE432, 0x0715, 0xF8AA, 0x040F, 0x09E7, 0xF714, 0x09BE,
0xFAE5, 0x1305, 0x0440, 0x1BBF, 0xFF83, 0x04CB, 0xFA8A, 0xEBFF,
0x018B, 0xEC16, 0x0A4C, 0xF1D1, 0x030B, 0xF82E, 0xFB3B, 0x0467,
0x0270, 0x1207, 0x010B, 0x140D, 0xF825, 0x0997, 0xFA5B, 0x05F8,
0xFF28, 0xFAB2, 0xFFAC, 0xE280, 0x027F, 0xE4CE, 0x06C4, 0x00E3,
0x05D4, 0x1005, 0x018D, 0x0D03, 0x0282, 0x0D7E, 0x03A7, 0x11DC,
0xF8E1, 0x02C8, 0xF407, 0xEC03, 0xFD10, 0xEC1D, 0xFFED, 0xF174,
0xFE1A, 0xF47F, 0x0469, 0x07A7, 0x0CC7, 0x1876, 0x080F, 0x149B,
0xFE8F, 0x09D2, 0xFF99, 0x0305, 0xFDAB, 0xF7DB, 0xF16D, 0xE56C,
0xF484, 0xE5D9, 0x0416, 0x00FB, 0x0756, 0x0CBD, 0x04AA, 0x0716,
0x08C6, 0x1041, 0x0E32, 0x1749, 0x0379, 0x0901, 0xF2AE, 0xF1DC,
0xF4D0, 0xE9B3, 0xFC99, 0xEEBD, 0xF9FF, 0xF2BE, 0xFE01, 0x0307,
0x0948, 0x1597, 0x0B1D, 0x0F26, 0x075D, 0x0603, 0x0517, 0x0BA2,
0x004F, 0x0252, 0xF6BE, 0xEB8C, 0xF6EE, 0xE5F8, 0x00DA, 0xF8EE,
0x0186, 0x0885, 0x0108, 0x06CC, 0x0812, 0x0E55, 0x0819, 0x1584,
0x00E5, 0x05C0, 0xFEE6, 0xF4A2, 0x0040, 0xF176, 0xFD3F, 0xF159,
0xF925, 0xF541, 0x006C, 0x0294, 0x0B7F, 0x10C1, 0x04A9, 0x0FC0,
0xFC4B, 0x0611, 0x02B3, 0x08F2, 0x0452, 0x0103, 0xFB43, 0xE615,
0xF879, 0xE47E, 0x01B7, 0xFF4E, 0x0452, 0x0EEB, 0xFE59, 0x0D0C,
0x0326, 0x0E0D, 0x08CB, 0x1048, 0xFF19, 0x039E, 0xF9D0, 0xF2D4,
0xFF6B, 0xF056, 0xFEDB, 0xECC2, 0xFAB4, 0xEE74, 0xFDDB, 0x07F7,
0x06B8, 0x1AAD, 0x07A3, 0x13A7, 0x0256, 0x069F, 0x0229, 0x0336,
0x0172, 0xFCD4, 0xFC09, 0xE9E3, 0xF9B1, 0xE5EA, 0xFA1D, 0xFC8B,
0xFAB7, 0x098D, 0xFFDE, 0x07B2, 0x0818, 0x1012, 0x0A72, 0x1315,
0x01B3, 0x0640, 0xFDF5, 0xF6FA, 0x042B, 0xF0DA, 0xFEB0, 0xEFF1,
0xF38A, 0xF130, 0xF85A, 0x0479, 0x02A1, 0x14D9, 0x0300, 0x0954,
0x0262, 0x0045, 0x0716, 0x090C, 0x05F5, 0x059B, 0xFCD6, 0xF363,
0xFA49, 0xEC8B, 0xFEF0, 0xF874, 0xFAE9, 0x03E6, 0xF64E, 0x0430,
0xFF7F, 0x0A25, 0x0742, 0x0BF8, 0x01E0, 0xFC9E, 0xFD16, 0xF750,
0x0357, 0xFE2F, 0x04C2, 0xF892, 0xFBB8, 0xF2D3, 0xF9B8, 0xFF70,
0xFF09, 0x0D47, 0xFEA4, 0x07F5, 0xFC42, 0xFE96, 0xFDD5, 0x05C7,
0xFE56, 0x032C, 0xFE5A, 0xEE06, 0x012F, 0xEC23, 0x0472, 0xFD91,
0xFFD3, 0x06FB, 0xF9BD, 0x06BC, 0xFEAC, 0x08B5, 0x00BA, 0x09AB,
0xF75C, 0xFF69, 0xF7B6, 0xF788, 0x025C, 0xFA12, 0x0178, 0xF0B1,
0xFDCD, 0xEA68, 0x0364, 0x01EE, 0x045B, 0x150A, 0xFB92, 0x0F44,
0xF7F7, 0x04FB, 0xFD07, 0x02C0, 0xFD21, 0xFE4B, 0xF8E0, 0xEDAC,
0xFC80, 0xEA4E, 0x054A, 0xFA6D, 0x04E6, 0xFFA7, 0xFCCF, 0x01D3,
0xFE28, 0x10B9, 0x040B, 0x12CD, 0xFBEC, 0x0139, 0xF594, 0xF542,
0x00D6, 0xF69E, 0x0383, 0xF169, 0xFB54, 0xEAEA, 0xFF2B, 0x00CE,
0x0377, 0x143D, 0xFE20, 0x06C6, 0xFC31, 0xFFA2, 0xFE6D, 0x0679,
0xFC84, 0x0186, 0xFCC4, 0xF4B6, 0x016C, 0xEEA8, 0x0218, 0xF830,
0xFE39, 0x018B, 0xFDB4, 0x0323, 0x01A6, 0x0D09, 0xFFB1, 0x0B93,
0xF8A8, 0xF789, 0xF9F0, 0xF631, 0x03ED, 0x01DE, 0x032B, 0xFD3F,
0xFB72, 0xF43E, 0x01F9, 0xFE72, 0x0740, 0x0DD8, 0xFCF9, 0x04DA,
0xF83A, 0xFC88, 0xFD61, 0x05AA, 0xFB31, 0xFCEB, 0xF864, 0xEFD0,
0x00A2, 0xF8C5, 0x092E, 0x030E, 0x0652, 0x0394, 0x0135, 0x0142,
0x0505, 0x06E9, 0x0344, 0x09C2, 0xF564, 0xF9E4, 0xF137, 0xF766,
0xFBC0, 0x0517, 0x01A7, 0xF9AD, 0x01FF, 0xEDEE, 0x07F1, 0x0025,
0x0B85, 0x0F49, 0x0639, 0x0891, 0x00AA, 0xFF7E, 0xFACF, 0x0385,
0xF202, 0x01D3, 0xF3DC, 0xF4A6, 0xFFD8, 0xF7ED, 0x0582, 0xFECA,
0x0550, 0xF71D, 0x08AB, 0xFC3E, 0x0EEA, 0x0E10, 0x08B7, 0x11A6,
0xF697, 0x0398, 0xF2C1, 0xFB11, 0xFCC3, 0x0225, 0xFB0F, 0xF93B,
0xFACD, 0xECB7, 0x0A18, 0xFEF6, 0x0E1C, 0x083A, 0x04CB, 0xFCAF,
0x0469, 0x0420, 0x0549, 0x0E3E, 0xF88B, 0x054B, 0xF1B9, 0xFA49,
0xFD9C, 0xF8C7, 0x05EE, 0xFD9F, 0x0343, 0xF9F8, 0x04D8, 0xFB99,
0x0A40, 0x0D54, 0x08AD, 0x0A5E, 0xFECB, 0xF8B6, 0xF7BE, 0xFC7B,
0xFBF5, 0x0942, 0xFE20, 0x03BE, 0xFE30, 0xF569, 0x06D1, 0xFE34,
0x08C2, 0x0A81, 0x02FD, 0xFF24, 0x0568, 0xFFEC, 0x0384, 0x086A,
0xF73F, 0xF735, 0xF5AC, 0xF35A, 0x003E, 0x05BD, 0x0421, 0x093E,
0x00BB, 0x0329, 0x0719, 0x013C, 0x0F4F, 0x07CE, 0x04D8, 0x0554,
0xF90A, 0xF58A, 0xFB3E, 0xF9F2, 0xFBAE, 0x02ED, 0xF6B4, 0xF88F,
0xFA9E, 0xF8F6, 0x0876, 0x09BB, 0x0DAE, 0x0E71, 0x0721, 0x0179,
0x06E8, 0xFCB2, 0x067C, 0x04A3, 0xF774, 0xFABE, 0xF0A1, 0xF348,
0xF8DC, 0x0643, 0xFE25, 0x0593, 0x0140, 0xF44E, 0x07DA, 0xFDF9,
0x1116, 0x0E28, 0x0F1C, 0x0AB5, 0x00EC, 0xFBDE, 0xFAB0, 0xFA30,
0xF974, 0x0503, 0xF302, 0xFE80, 0xF7CE, 0xF969, 0x047B, 0x04B5,
0x076A, 0xFDFD, 0x0ABB, 0xF553, 0x1065, 0x053A, 0x09CB, 0x0F8C,
0xF8FC, 0x0533, 0xF48F, 0xFADB, 0xFBFB, 0x01EE, 0xF917, 0x0479,
0xF6FC, 0xF58D, 0x0631, 0xFA94, 0x10CE, 0x0859, 0x0B08, 0xFC9A,
0x0339, 0xF90A, 0xFFDE, 0x08D1, 0xFF0C, 0x0D3C, 0xF84C, 0x01FA,
0xF6F8, 0xF923, 0x0383, 0x02AE, 0x0554, 0x02F4, 0x028A, 0xF731,
0x0B2B, 0x066C, 0x092E, 0x0BD9, 0xFA9B, 0xF4B5, 0xF7F9, 0xF75F,
0xFFBB, 0x0C47, 0x0167, 0x0B39, 0xFD28, 0xFB80, 0x024C, 0xFB30,
0x0C9D, 0x0958, 0x0772, 0x04AF, 0x0081, 0xFB39, 0xFF7F, 0x0548,
0xF9D8, 0x0083, 0xFA85, 0xF421, 0x01CA, 0x00B1, 0x04B0, 0x0CB2,
0x0372, 0x074A, 0x05BE, 0xFC89, 0x0C05, 0x0166, 0x057C, 0x0937,
0xF43C, 0xF8AE, 0xF5C6, 0xF758, 0xFFFE, 0x0A64, 0xFD3A, 0xFFCF,
0xFE42, 0xF2FB, 0x0760, 0x0417, 0x0DC8, 0x0EB5, 0x0986, 0x0341,
0x0080, 0xF975, 0xFF7D, 0x021A, 0xF904, 0x05B9, 0xF054, 0xFA9D,
0xFCC4, 0x0405, 0x07F4, 0x0A5D, 0x026A, 0xF401, 0x05CD, 0xF23D,
0x0F4A, 0x07C4, 0x0AD7, 0x0C22, 0xFB88, 0xFE6A, 0xF42A, 0xFA95,
0xF913, 0x0ABC, 0xFA90, 0x0960, 0xFD0D, 0xF6AB, 0x063F, 0xFC7F,
0x092F, 0x00D8, 0x08D0, 0xF330, 0x0805, 0xFB74, 0x004E, 0x0E69,
0xF8C5, 0x0C4C, 0xF5BF, 0x0055, 0xFABF, 0x01AA, 0x02DD, 0x0627,
0xFF15, 0xF45D, 0x0329, 0xEEC1, 0x0F21, 0x06DF, 0x051E, 0x053D,
0xF7BB, 0xF5F0, 0xFAD7, 0x0478, 0xFDC1, 0x12F9, 0xFAA1, 0x093A,
0xFCCE, 0xF72F, 0x0794, 0xF65A, 0x0B2A, 0xFDCE, 0x0131, 0xF899,
0x002B, 0x0151, 0x01FC, 0x0FA3, 0xF656, 0xFF96, 0xF39E, 0xF65C,
0xFF91, 0x0878, 0x0856, 0x0B69, 0x073A, 0xF6A0, 0x0617, 0xEE9C,
0x0A2C, 0x029D, 0x02FD, 0x0A10, 0xF54C, 0xFB7E, 0xF55D, 0x038D,
0xF8F8, 0x0CC6, 0xFBDA, 0xFB5E, 0x055C, 0xF719, 0x0C76, 0x02E0,
0x0F0B, 0x034B, 0x0B23, 0xFB2C, 0x0170, 0xFE7B, 0xFAA5, 0x0ABE,
0xF0D6, 0x021C, 0xEF35, 0xF99C, 0xFEDE, 0x0B6E, 0x0596, 0x08A5,
0x0589, 0xEF4E, 0x10BB, 0xF373, 0x1462, 0x085D, 0x04E8, 0x09ED,
0xF526, 0xFE6B, 0xF3D2, 0x0061, 0xF5DF, 0x0A5B, 0xF425, 0x0327,
0xFF19, 0xFF8A, 0x0D6D, 0x0596, 0x0EF5, 0xF5F8, 0x0D4A, 0xEBB7,
0x0892, 0x016B, 0x0048, 0x1340, 0xF695, 0x0954, 0xEEC9, 0xFCD3,
0xF783, 0x09AF, 0x0363, 0x0C7A, 0x0254, 0xF1F1, 0x0A44, 0xF00E,
0x11FB, 0x01A1, 0x0725, 0xFA45, 0xFD47, 0xF99B, 0xF8D1, 0x1000,
0xF668, 0x16A5, 0xF879, 0x07F2, 0xFF2F, 0xFD01, 0x0756, 0xFC3A,
0x079B, 0xF371, 0x07B2, 0xEDCC, 0x097A, 0x0246, 0xFE1A, 0x0E24,
0xF28A, 0x0204, 0xF686, 0x0436, 0xFE9F, 0x126F, 0x0259, 0x0C74,
0x0413, 0xF382, 0x0B58, 0xEB70, 0x0ED7, 0xFAFB, 0x006E, 0xFDCF,
0xF723, 0xFFA8, 0xF91E, 0x1229, 0xF500, 0x0C5E, 0xF75C, 0xF82A,
0x0383, 0xFF2E, 0x0C93, 0x068C, 0x0FA0, 0xF74D, 0x09D2, 0xEDB2,
0x0406, 0xFEB1, 0xFDC6, 0x0D5E, 0xED80, 0x01CA, 0xEB38, 0x0113,
0xF9F2, 0x0E68, 0x01A7, 0xFFB9, 0x08E4, 0xECC9, 0x1291, 0xF73F,
0x1205, 0x05FD, 0x080C, 0x021C, 0xFCB1, 0xFBF4, 0xF329, 0x05E4,
0xEA85, 0x07F9, 0xECF0, 0xFC74, 0xFEB0, 0x0235, 0x08A8, 0x03CC,
0x0CC6, 0xEEE2, 0x1436, 0xEF14, 0x0D33, 0x06C6, 0xFF8D, 0x0E0E,
0xF526, 0x014C, 0xEEB0, 0xFD4D, 0xF420, 0x091E, 0xF788, 0x039B,
0xFC80, 0xF501, 0x0FC5, 0xFCA1, 0x1422, 0xFCAC, 0x0666, 0xEF50,
0x0158, 0xFBC5, 0xFC80, 0x11E0, 0xF36B, 0x0DA8, 0xF1CE, 0xFECD,
0xF942, 0x02C1, 0x02B5, 0x0554, 0x0483, 0xF152, 0x07B7, 0xEECA,
0x09BE, 0x03DF, 0xFFB5, 0x0265, 0xF86F, 0xF8BD, 0xF80E, 0x06E3,
0xF8CD, 0x1599, 0xFCFA, 0x0B08, 0x01BE, 0xF4B1, 0x07F2, 0xF2BB,
0x08E9, 0xF8E2, 0xFEC7, 0xF388, 0xFC78, 0xFFE1, 0xFB44, 0x1108,
0xF322, 0x0497, 0xF9FB, 0xFBDF, 0x03F7, 0x0902, 0x03CB, 0x0917,
0x07D3, 0xF2FA, 0x0B69, 0xEC49, 0x064D, 0x0015, 0xFA10, 0x04DE,
0xEF12, 0xFEEE, 0xF4D9, 0x0CA1, 0xFC59, 0x0BFB, 0xFB02, 0xF56F,
0x04BA, 0xF2D2, 0x110D, 0xFEC7, 0x0E15, 0x00D0, 0x04F7, 0xFA19,
0xFFEF, 0x00B2, 0xF90B, 0x0EC1, 0xED9A, 0x037D, 0xEFCD, 0xFA2D,
0xFE75, 0x0608, 0x03B3, 0xFD9D, 0x0946, 0xEB0A, 0x1225, 0xF6C2,
0x0C4B, 0x0E90, 0x0272, 0x0F52, 0xFA76, 0xFF6F, 0xF28D, 0x00E2,
0xF3AA, 0x061F, 0xF566, 0xF5E8, 0xFC8C, 0xF4E0, 0x0AB7, 0x01DE,
0x0B6E, 0xF989, 0x08CD, 0xF6D2, 0x099D, 0x09BD, 0xFDE3, 0x133B,
0xF26B, 0x05D6, 0xF752, 0xF880, 0xFE96, 0xFEF6, 0xFC99, 0xFD15,
0xFE49, 0xF04D, 0x0993, 0xFDBB, 0x091D, 0x07E5, 0xFFD5, 0xFB2C,
0x0057, 0xFE3B, 0xFF6D, 0x0CD3, 0xFA6F, 0x0D95, 0xFC43, 0xFDC5,
0x032C, 0xF462, 0x080E, 0xFD1B, 0x00D4, 0xF8BC, 0xF8F3, 0xF3EB,
0xFF0D, 0x08D6, 0xFE71, 0x0C62, 0xF80A, 0xFB05, 0xFF5D, 0x00FC,
0x0663, 0x0F00, 0x0628, 0x0645, 0x08BD, 0xF057, 0x07B3, 0xF185,
0xFE76, 0x023C, 0xF661, 0xFCEC, 0xF6CC, 0x000F, 0xFB00, 0x1157,
0xFAD6, 0x0610, 0x0039, 0xF6C8, 0x0D18, 0xFD72, 0x0E6A, 0x029F,
0x050C, 0xFC0F, 0x008B, 0xF63A, 0x004A, 0x02C1, 0xF7C5, 0x0C92,
0xEFC0, 0x018A, 0xF96B, 0x056E, 0x01AC, 0x08BF, 0x0192, 0xF1F0,
0x0C95, 0xECCF, 0x11F4, 0xFFE4, 0x0485, 0x0B21, 0xFCBF, 0x0654,
0xFE7E, 0x020F, 0xFBF1, 0x0BA9, 0xF504, 0x051B, 0xF432, 0xF28C,
0x01E7, 0xFB6D, 0x0BDD, 0xFE53, 0x0765, 0xEF28, 0x06B2, 0xFBED,
0x0874, 0x15DA, 0x0050, 0x1650, 0xF9C8, 0x0170, 0xFCB9, 0xF9AD,
0xFCEC, 0x00BD, 0xFA42, 0xF3F0, 0x02AE, 0xEE84, 0x0A8B, 0x03B9,
0x027C, 0x0571, 0xFFD1, 0xFE8F, 0x058A, 0x0A82, 0x003E, 0x107B,
0xFAAC, 0x06F8, 0xFF29, 0xF658, 0x057C, 0xF42A, 0x060A, 0xFDC9,
0xFFBD, 0xF86E, 0xFE87, 0x002A, 0x0096, 0x11D8, 0xFA99, 0x04B9,
0xFC23, 0xF93C, 0x0606, 0x066B, 0x040F, 0x09F8, 0x01A6, 0xF9A3,
0x0AA0, 0xF170, 0x0A7F, 0x005D, 0xFA00, 0x04CD, 0xF211, 0xFB5D,
0xF9A2, 0x0A87, 0xFBD9, 0x1016, 0xFAFD, 0xF8E7, 0x042B, 0xF779,
0x0DD8, 0x0616, 0x0C91, 0x050F, 0x04CF, 0xF816, 0x004D, 0xF745,
0xFC67, 0x098E, 0xF3F2, 0x090B, 0xF339, 0xFD46, 0xFD09, 0x08AD,
0x004C, 0x058B, 0x044C, 0xEF87, 0x0F74, 0xF3D2, 0x0B80, 0x03C5,
0xFD94, 0x0554, 0xFCB5, 0x0008, 0xFF24, 0x05A9, 0xF838, 0x0E12,
0xF43C, 0x0187, 0xFB31, 0xF9F6, 0x036A, 0x00B4, 0x0550, 0xF432,
0x059A, 0xEBAD, 0x071D, 0x009B, 0x03CE, 0x122D, 0xFD49, 0x0D4D,
0xFDA6, 0x027E, 0xFFF3, 0x0588, 0xF805, 0x020C, 0xF54A, 0xED58,
0x0311, 0xF424, 0x0641, 0x04D2, 0xFD15, 0xF9D1, 0x0189, 0xFDDA,
0x0913, 0x14CA, 0x02C7, 0x1491, 0xFBE3, 0x00E6, 0xFCEF, 0xF33A,
0xFE6C, 0xF78F, 0xFE4E, 0xF936, 0xFE44, 0xF317, 0xFE9D, 0x03B8,
0xFEC9, 0x1168, 0x005E, 0x03B8, 0x03D0, 0xFFA3, 0x02CB, 0x07F5,
0xFC96, 0x0305, 0xFDCF, 0xF320, 0x06F0, 0xF2A4, 0x02D6, 0x02DF,
0xF704, 0x02DC, 0xFA02, 0x0268, 0xFE8E, 0x10FE, 0xF9C8, 0x0567,
0xFCF3, 0xF14B, 0x04C7, 0xFA0F, 0x0466, 0x0193, 0x042B, 0xFC4D,
0x06F0, 0xFA3D, 0x03B2, 0x0283, 0xF857, 0x0A6F, 0xF2D6, 0x00A9,
0xF9B3, 0xFEE8, 0xFD59, 0x07E3, 0xFB62, 0xF9D9, 0x01E9, 0xEE69,
0x0D7F, 0xFECA, 0x0A9A, 0x0ADB, 0xFEDA, 0x030C, 0xFD91, 0xFCED,
0xFDC2, 0x061D, 0xF6E8, 0x0674, 0xF6F7, 0xF777, 0xFD3D, 0xFC6C,
0xFEED, 0x0372, 0x03EB, 0xF543, 0x08CB, 0xF603, 0x0404, 0x07A4,
0xFD9C, 0x0D1D, 0xFD27, 0x0412, 0x00D2, 0xFE53, 0xFE0D, 0x034F,
0xF744, 0xFD9A, 0xFB06, 0xF3E9, 0x024B, 0xFECE, 0xFF15, 0x01D5,
0xFDDC, 0xF909, 0x051A, 0x046E, 0x0633, 0x1029, 0x01C5, 0x08D8,
0x0384, 0xFC66, 0x055E, 0xF837, 0xFB23, 0xF951, 0xF59A, 0xF44F,
0xFD4B, 0xF9EA, 0xFE6D, 0x0BE4, 0xFD0D, 0x0B39, 0x058F, 0x0240,
0x0C4B, 0x0794, 0x08C6, 0x08E0, 0x0191, 0xF9FE, 0xFED7, 0xECE4,
0xFEEF, 0xF5BC, 0xF80E, 0x032B, 0xF5C6, 0x0141, 0x001F, 0x0B06,
0x0580, 0x162B, 0x06BE, 0x03D8, 0x09BE, 0xF4C5, 0x06AC, 0xF966,
0xFEAD, 0xF99E, 0xFCAE, 0xF5AF, 0x0006, 0xFBFA, 0xFC52, 0x0AD5,
0xF793, 0x101B, 0x002E, 0x090C, 0x0835, 0x0759, 0x030B, 0xFFD9,
0x00EC, 0xEF05, 0x03C7, 0xEF99, 0x0277, 0xFDF1, 0xFE03, 0x0776,
0xFE10, 0x085B, 0x049B, 0x0A0C, 0x0204, 0x0D54, 0xFC34, 0x01FA,
0x0241, 0xF654, 0x04B1, 0xFABA, 0xFE11, 0xF740, 0xFF37, 0xF34A,
0x038D, 0x054A, 0x00E1, 0x1380, 0xFE2A, 0x0E78, 0x02A4, 0x041C,
0x0800, 0x0178, 0x00E7, 0xFE1C, 0xFB0D, 0xF0BC, 0x0002, 0xF30C,
0xFFB8, 0x0296, 0xFC86, 0x035A, 0xFF59, 0x03BD, 0x026A, 0x0EBB,
0x0320, 0x1027, 0x05CB, 0x0396, 0x09CA, 0xF721, 0x0660, 0xF55D,
0xF9C0, 0xF6E2, 0xF667, 0xF59D, 0xFB78, 0x0104, 0xF887, 0x0D4C,
0xFA26, 0x0A58, 0x05DC, 0x08C5, 0x0D67, 0x0907, 0x0BF6, 0x01C7,
0x0803, 0xF515, 0x05AC, 0xEE61, 0xFC22, 0xF618, 0xEE99, 0xFE0B,
0xF0F7, 0x046C, 0xFBF0, 0x12C7, 0x014B, 0x1259, 0x0AC1, 0x029D,
0x12B6, 0xFF6C, 0x0E1B, 0xFC4B, 0x0225, 0xF09D, 0xF929, 0xEE79,
0xF615, 0xFB7B, 0xEF9A, 0x0A37, 0xEF0E, 0x0CDF, 0xFEBC, 0x0DDE,
0x0C3D, 0x0F2B, 0x0EF9, 0xFFF3, 0x0F6D, 0xEE66, 0x0963, 0xEE8D,
0xFD15, 0xF67D, 0xF3FB, 0xFDCA, 0xF373, 0x0495, 0xF8CB, 0x0F08,
0xF9BD, 0x141F, 0xFFBE, 0x0654, 0x0BCA, 0xFA74, 0x0C25, 0xF6E9,
0x05C2, 0xED58, 0x00B5, 0xEE52, 0xFA41, 0x0016, 0xF56F, 0x0DB9,
0xF781, 0x1052, 0x002D, 0x0CAA, 0x05C1, 0x0621, 0x0252, 0xFA71,
0x0366, 0xEE7E, 0x061B, 0xF13A, 0xFEB6, 0xF895, 0xFAE9, 0xFC86,
0xFC08, 0x0A21, 0xFAC3, 0x1544, 0xFC01, 0x0F2C, 0x020F, 0x01D4,
0x0914, 0xF7E7, 0x05D8, 0xF223, 0xFC6F, 0xEDF5, 0xFB76, 0xF394,
0xFBEC, 0x04FB, 0xF9D1, 0x0D8B, 0xFCE8, 0x09E7, 0x0226, 0x0A18,
0x055D, 0x0932, 0x06C0, 0xFDE6, 0x0955, 0xEF12, 0x0839, 0xECAD,
0xFAB1, 0xF82A, 0xEF61, 0xFF82, 0xF24D, 0x0629, 0xF8DF, 0x11E4,
0xFEE0, 0x0E1B, 0x06BF, 0x00D3, 0x0BB4, 0xFE8A, 0x0BF5, 0xF9F1,
0x08AC, 0xF03C, 0x0108, 0xF116, 0xF5DE, 0xFBDD, 0xEBBE, 0x0765,
0xEE3F, 0x0CF3, 0xFBC8, 0x0F03, 0x0558, 0x0B57, 0x0C44, 0xFD98,
0x11E1, 0xF404, 0x0BA4, 0xF200, 0xFEA6, 0xF31E, 0xF659, 0xFAB7,
0xF307, 0x0319, 0xF186, 0x0D54, 0xF225, 0x1170, 0xFE84, 0x07F7,
0x0E2F, 0x02FB, 0x0F42, 0xF9EF, 0x0C0B, 0xE8FA, 0x05B6, 0xEC9B,
0xF86A, 0xFE1F, 0xF354, 0x08EF, 0xF5F5, 0x0C47, 0xFB80, 0x0D40,
0xFF1E, 0x0CA8, 0xFF0D, 0xFFD4, 0x078B, 0xF150, 0x0AF9, 0xEFA4,
0x007B, 0xEF86, 0xFA56, 0xF6B9, 0xF81B, 0x08D5, 0xF916, 0x1378,
0x0034, 0x1300, 0x0477, 0x069A, 0x05DD, 0xF941, 0x0319, 0xF4CE,
0x000D, 0xED98, 0x01DB, 0xEFAA, 0xFBA6, 0xFEF2, 0xF76C, 0x0A1A,
0xFEEC, 0x1198, 0x02CB, 0x115E, 0x03C1, 0x0804, 0x0651, 0xFB5D,
0x095B, 0xEF62, 0x0520, 0xEECE, 0xF816, 0xF4F1, 0xF663, 0xFDE1,
0xFC33, 0x0E48, 0xFC0B, 0x1565, 0x0119, 0x0D29, 0x070C, 0x03C4,
0x0662, 0xFB9E, 0x0881, 0xF3B0, 0x089A, 0xECA7, 0x02DA, 0xF06A,
0xF890, 0x01F7, 0xEF29, 0x0C18, 0xF5DD, 0x0F21, 0x00D9, 0x1226,
0x0289, 0x08E1, 0x06B3, 0xFA28, 0x0CDF, 0xF288, 0x0C07, 0xF0D1,
0x055D, 0xF524, 0xFE77, 0xFC08, 0xF9B3, 0x0743, 0xF4A1, 0x14AB,
0xF792, 0x1498, 0x034D, 0x09BE, 0x0737, 0xFEDE, 0x08ED, 0xF5B8,
0x0D77, 0xEFFA, 0x06D2, 0xF08C, 0xF9F8, 0xF985, 0xF5DE, 0x055B,
0xFADA, 0x0F5A, 0xFEEC, 0x1520, 0xFD5E, 0x0E72, 0x0215, 0x0047,
0x0C30, 0xF7C0, 0x08D5, 0xEFC7, 0x0081, 0xEBD6, 0xFDA8, 0xF830,
0xF832, 0x0785, 0xF752, 0x0F72, 0x0219, 0x1288, 0x0C8B, 0x0EB0,
0x0995, 0x04DD, 0x0280, 0xF71E, 0x035B, 0xEB8C, 0x0104, 0xECB6,
0xF658, 0xF9D2, 0xF3AC, 0x07E5, 0xFCEE, 0x1144, 0x04AC, 0x14C4,
0x0969, 0x104F, 0x0E60, 0x0147, 0x0F3B, 0xF1D9, 0x043D, 0xEE69,
0xF647, 0xF0C1, 0xF4C1, 0xF8F3, 0xF4A9, 0x0818, 0xF6F3, 0x138F,
0x0549, 0x1723, 0x0D77, 0x0F4A, 0x0A7C, 0xFCA4, 0x0AA9, 0xEE8B,
0x0AC5, 0xEBE2, 0x0117, 0xF02D, 0xF192, 0xFB72, 0xEC91, 0x0A88,
0xF7A7, 0x160B, 0x00C5, 0x157C, 0x05BF, 0x0ABF, 0x0D92, 0xFF89,
0x0DDB, 0xF368, 0x067D, 0xEA20, 0x0151, 0xED0B, 0xFFB3, 0xFB9A,
0xF733, 0x0C6D, 0xED3C, 0x14AD, 0xF812, 0x1336, 0x07DE, 0x0C81,
0x075B, 0x00A2, 0x08AE, 0xF430, 0x0C23, 0xEE16, 0x03B0, 0xEF16,
0xFA42, 0xF85E, 0xF7CD, 0x05D4, 0xFA82, 0x0F95, 0xFBB7, 0x13BC,
0xFB67, 0x0F7B, 0x0381, 0x02B7, 0x0B10, 0xF4E1, 0x0822, 0xECC6,
0x034F, 0xF040, 0xFE33, 0xFA30, 0xF611, 0x0078, 0xF682, 0x0AAF,
0x014C, 0x1485, 0x0688, 0x10FC, 0x0324, 0x0531, 0x03E2, 0xF983,
0x09FA, 0xF349, 0x0493, 0xEEA2, 0xF809, 0xF263, 0xF651, 0x02C0,
0xF8B3, 0x0E33, 0xFC81, 0x11A0, 0x066B, 0x0F08, 0x0DF7, 0x04E4,
0x0C33, 0xF8F9, 0x008F, 0xEED8, 0xF7DA, 0xEB5A, 0xF7AC, 0xF42E,
0xF377, 0x02E0, 0xF49B, 0x0E29, 0xFF17, 0x1563, 0x06B7, 0x130A,
0x0E1E, 0x0532, 0x103D, 0xF736, 0x0B72, 0xEEF2, 0x0270, 0xEDE9,
0xF386, 0xF6F4, 0xEC4A, 0x05DD, 0xF1A1, 0x0F42, 0xFBF9, 0x1047,
0x0607, 0x1080, 0x08BC, 0x069C, 0x0723, 0xF03F, 0x0794, 0xE5F1,
0x055F, 0xED14, 0xFBC4, 0xF8E5, 0xEED0, 0x043D, 0xEEA2, 0x1169,
0xFDB5, 0x1868, 0x0505, 0x0F76, 0x069F, 0x03E4, 0x0FB6, 0xF98B,
0x0F91, 0xEF43, 0x03E4, 0xEDDD, 0xFD57, 0xF5F3, 0xFA01, 0x032A,
0xF4C5, 0x0BC4, 0xF18B, 0x0E80, 0xF561, 0x0C0E, 0xFEAB, 0x0102,
0x06CC, 0xF5E8, 0x0A84, 0xEF3E, 0x06C3, 0xEF8D, 0xFFBD, 0xF8FC,
0xFC62, 0x02DC, 0xFC4D, 0x0B29, 0xFE79, 0x0FEE, 0x0233, 0x0C76,
0x040B, 0x06A3, 0x01BE, 0xFEA2, 0x0529, 0xF45C, 0x0AF5, 0xF0BF,
0x01E6, 0xF59F, 0xF38B, 0xFEF9, 0xEECF, 0x038C, 0xF4EB, 0x01F5,
0x00C7, 0x05A9, 0x060C, 0x0582, 0x0432, 0xFB38, 0x0315, 0xF5B2,
0x0488, 0xF455, 0x02F5, 0xF860, 0xFAB2, 0x0373, 0xFD25, 0x0C28,
0x04FB, 0x113E, 0x010D, 0x0C06, 0x081C, 0x0497, 0x116D, 0xFFCA,
0x064D, 0xEF77, 0xF9F3, 0xE8E4, 0xF0CD, 0xF462, 0xEB99, 0xFC4B,
0xF117, 0x037F, 0xF970, 0x0AE4, 0x03E3, 0x0DBD, 0x0958, 0x088B,
0x0AA5, 0xFACF, 0x0EE2, 0xF304, 0x07E4, 0xF138, 0x00AA, 0xF5BD,
0xFCF4, 0x0685, 0xF41B, 0x12AE, 0xFD98, 0x15A8, 0x0B2B, 0x128E,
0x07AF, 0x01A4, 0x012F, 0xF41F, 0xFABB, 0xEDCA, 0xFA4E, 0xE5D7,
0xFBBD, 0xECDB, 0xF64A, 0xFDEF, 0xF740, 0x0BA8, 0xFCE2, 0x11B7,
0x023F, 0x0F33, 0x08FD, 0x0867, 0x085B, 0xFAE2, 0x0A23, 0xF3EB,
0x0AEC, 0xF816, 0x0150, 0xFB7F, 0x01EF, 0x0639, 0x0822, 0x12D6,
0x03E0, 0x0CC5, 0xF9F8, 0x028F, 0xF42B, 0x007C, 0xF6EF, 0xF71F,
0xF950, 0xEA15, 0xF897, 0xEA2D, 0xFD34, 0xF95F, 0x0146, 0x0761,
0x0202, 0x0CB4, 0x0826, 0x0EDB, 0x0B9C, 0x0B1E, 0x09A7, 0x0451,
0x058B, 0xFED8, 0x0085, 0xFAE2, 0x0229, 0xFB3A, 0x044F, 0xFE9D,
0xFE5A, 0xFF23, 0xF5E0, 0x035E, 0xF6A4, 0x0ABF, 0xFEAA, 0x0406,
0x01F7, 0xF7F9, 0xFF44, 0xF57A, 0xFEDD, 0xF55C, 0x0132, 0xF563,
0xFDB1, 0xFC82, 0xFAEC, 0x0508, 0xFEFB, 0x0A34, 0x0570, 0x0E76,
0x0BA4, 0x0F92, 0x0BFD, 0x0BA6, 0x0B83, 0x0383, 0x0F9D, 0xFC24,
0x0610, 0xF0CB, 0xEF5D, 0xEC50, 0xE5B3, 0xFBA6, 0xE9E1, 0x04EF,
0xF34C, 0x00BA, 0xFBB7, 0x007C, 0x0441, 0x047D, 0x0DD9, 0x033A,
0x0ADA, 0xF8B7, 0x05BC, 0xEFC0, 0x03DC, 0xF5EA, 0xFCF4, 0x0235,
0xFA40, 0x0BFD, 0xFDA7, 0x1484, 0x06B3, 0x142D, 0x103E, 0x0A9B,
0x08A0, 0xF6EC, 0xF941, 0xEA3B, 0xF2C1, 0xEE9B, 0xEF0A, 0xEBF0,
0xEFEB, 0xEF54, 0xF3BD, 0x02FD, 0xFC87, 0x0E31, 0x0ABC, 0x0F91,
0x0B93, 0x0AC9, 0x06B6, 0xFDBA, 0x05BC, 0xF323, 0x01FE, 0xEFAA,
0xFEFB, 0xF71F, 0xFC1A, 0x060B, 0x0053, 0x107D, 0x0EC6, 0x153A,
0x0E31, 0x0822, 0xFCD8, 0xF897, 0xF1AA, 0xF7C1, 0xEDC5, 0xECE3,
0xED16, 0xE1BF, 0xEC78, 0xE8C5, 0xF37C, 0xFB6A, 0x0244, 0x10F7,
0x086D, 0x1475, 0x0F8D, 0x0A4E, 0x13FB, 0x071D, 0x0C95, 0x0164,
0x0462, 0xF875, 0xFADC, 0xF84A, 0xF710, 0xFD80, 0xFCAA, 0x0205,
0xFA5A, 0xFE47, 0xF356, 0x0014, 0xF737, 0x0807, 0xFAFD, 0xFA31,
0xFA91, 0xEBBD, 0xFBEE, 0xF002, 0xFE8F, 0xF48E, 0xFEE6, 0xFA9E,
0xF89F, 0x03BF, 0xF9C4, 0x0A32, 0x02C1, 0x0DC9, 0x0A5D, 0x0B6F,
0x0E74, 0x09B4, 0x0972, 0x071F, 0x08C3, 0xFEF7, 0x0E11, 0xFA23,
0x01D1, 0xF051, 0xEA43, 0xEE56, 0xE13D, 0xFEC7, 0xE583, 0x00F6,
0xEF1D, 0xF99D, 0xF9E8, 0xFA3C, 0x04A8, 0xFC89, 0x0E25, 0x00E8,
0x0BCB, 0xFD5F, 0x0726, 0xF5E7, 0x054C, 0xFEDE, 0x0160, 0x0BAD,
0x01CF, 0x0FFC, 0x03A5, 0x12D2, 0x0778, 0x11AA, 0x0E1D, 0x06AB,
0x0707, 0xEF71, 0xF379, 0xE57B, 0xEA66, 0xF05D, 0xE885, 0xEF0F,
0xEA64, 0xF06F, 0xF5A1, 0x02EC, 0x05ED, 0x0D92, 0x108E, 0x0E79,
0x0B2D, 0x07D1, 0x077C, 0xFCBC, 0x0805, 0xF966, 0x0365, 0xF8B5,
0x0079, 0xFF44, 0xFE0D, 0x0FEC, 0x0621, 0x1635, 0x1712, 0x11F1,
0x0FC7, 0x020F, 0xF64B, 0xF0EB, 0xEC5A, 0xF0CB, 0xE836, 0xEA8B,
0xE438, 0xE364, 0xEAF0, 0xEF4C, 0xFA69, 0x02B7, 0x0B01, 0x1477,
0x113E, 0x1564, 0x1484, 0x096E, 0x143F, 0x05A0, 0x0CEA, 0x007B,
0x057A, 0xFB0C, 0xFC10, 0x009E, 0xFB7B, 0x0810, 0x05C6, 0x0D9A,
0x03C8, 0x03AE, 0xF710, 0xF9BE, 0xF35F, 0x0135, 0xF0C9, 0xF507,
0xEF90, 0xE446, 0xF485, 0xECF6, 0xFCBD, 0xF869, 0x05DF, 0x02D0,
0x04D1, 0x0B9F, 0x073B, 0x0D86, 0x100C, 0x109F, 0x10EF, 0x0BD0,
0x0ABD, 0x0400, 0x02F9, 0x06B7, 0x0601, 0x05C7, 0x0E90, 0x00A4,
0x0423, 0xF72B, 0xEF99, 0xF390, 0xEC18, 0x00B9, 0xEEEF, 0xFE05,
0xEDB0, 0xF239, 0xF0EE, 0xF489, 0xFDDE, 0xFA19, 0x08B9, 0x031C,
0x05A9, 0x044A, 0x0840, 0xFF76, 0x0FE1, 0x0969, 0x10CF, 0x0FC9,
0x1065, 0x0DEF, 0x0B3B, 0x114E, 0x06B5, 0x0D90, 0x07AE, 0x045B,
0xFDC0, 0xF3C2, 0xEA52, 0xE889, 0xE471, 0xF627, 0xE8B1, 0xF959,
0xF0FA, 0xF1E8, 0xFF0A, 0xFD31, 0x0C5A, 0x0924, 0x1078, 0x07FE,
0x06A4, 0x00CB, 0x006B, 0xFC4C, 0x00EC, 0xFF46, 0x014B, 0x009E,
0x053A, 0x0717, 0x090C, 0x1668, 0x142A, 0x18A5, 0x1F81, 0x1055,
0x0F71, 0xFCAC, 0xF100, 0xE8CA, 0xE2A1, 0xEEE4, 0xDD67, 0xEE19,
0xDBDC, 0xE60E, 0xE793, 0xF69A, 0x01FF, 0x08A9, 0x1896, 0x1228,
0x18AE, 0x1309, 0x137A, 0x0585, 0x1090, 0xFEC4, 0x0831, 0xFE36,
0xFDE4, 0xFDA3, 0xF787, 0x07D7, 0x0007, 0x1044, 0x0EAE, 0x1001,
0x0CA7, 0x02F8, 0xFDA4, 0xF4E8, 0xF1A5, 0xF9A0, 0xE81D, 0xF103,
0xE3DD, 0xE10F, 0xE90B, 0xEDD0, 0xF7F6, 0x0192, 0x095E, 0x0B94,
0x0E5C, 0x0E5A, 0x11D7, 0x0B61, 0x15CE, 0x0AE4, 0x1132, 0x0417,
0x068B, 0xFC93, 0xFB18, 0x05BF, 0xFE92, 0x0BE4, 0x09AA, 0x09E7,
0x050F, 0x00F5, 0xF7AE, 0xF527, 0xF3A8, 0xFD4D, 0xF0C9, 0xFA59,
0xE9C8, 0xE6A6, 0xE97F, 0xEAE4, 0xF592, 0xF926, 0x02DE, 0x0382,
0x0273, 0x0BD6, 0x07D1, 0x0AEC, 0x171C, 0x0CA6, 0x1CBA, 0x0E7A,
0x1746, 0x09BE, 0x0ABF, 0x09DD, 0x046A, 0x078C, 0x0335, 0x00E2,
0xF55D, 0xF415, 0xE413, 0xEB93, 0xE2CC, 0xFD4F, 0xE976, 0xFF8D,
0xF2C9, 0xEED1, 0xFF7F, 0xF8A4, 0x0BF2, 0x03B0, 0x119D, 0x01E4,
0x0561, 0x016D, 0xFC13, 0xFC66, 0xFF0C, 0x01D6, 0x0355, 0x09E6,
0x08DA, 0x08F9, 0x0B1E, 0x13CB, 0x12BE, 0x186A, 0x1C16, 0x0CC1,
0x0C39, 0xF723, 0xEDA7, 0xE4EE, 0xDFCF, 0xEFDB, 0xD9F3, 0xF372,
0xDA1A, 0xEA0B, 0xEA29, 0xF765, 0x0489, 0x0621, 0x197D, 0x0E17,
0x1537, 0x1038, 0x0F82, 0x0201, 0x11D0, 0xFDB6, 0x0AE9, 0x02C0,
0x0329, 0x02AE, 0xFE23, 0x0DDF, 0x04B5, 0x159F, 0x1340, 0x106F,
0x0AFB, 0xFE8E, 0xF30E, 0xEAF2, 0xE768, 0xF341, 0xE086, 0xF13C,
0xDE7C, 0xE163, 0xE8B7, 0xF1D2, 0xFF3A, 0x0753, 0x1728, 0x0F28,
0x1725, 0x1012, 0x12B7, 0x0755, 0x1472, 0x051B, 0x0DDE, 0x022C,
0x0550, 0xFBD8, 0xFB13, 0x0766, 0xFCCC, 0x133E, 0x0E4E, 0x11DE,
0x0E1F, 0x01CE, 0xFB83, 0xF19A, 0xF2B0, 0xF987, 0xE9EE, 0xF3DB,
0xDF6B, 0xE101, 0xE13C, 0xE979, 0xF221, 0xF975, 0x05AB, 0x07EA,
0x06DF, 0x1304, 0x0FC5, 0x0D06, 0x212F, 0x0AB3, 0x1F7B, 0x0B34,
0x16AB, 0x04C0, 0x089C, 0x06D1, 0xFEB9, 0x0970, 0x01D2, 0x06C2,
0xF7D7, 0xF93E, 0xE576, 0xED25, 0xE52D, 0xFB97, 0xEBAC, 0xFC15,
0xEE8F, 0xE929, 0xF5BD, 0xEFD5, 0x061B, 0xFF06, 0x119D, 0x03E1,
0x0785, 0x0527, 0x0221, 0x0340, 0x0A17, 0x08C7, 0x0F63, 0x0B7A,
0x1383, 0x0689, 0x0F0A, 0x0EA5, 0x0BB2, 0x1451, 0x124C, 0x0ABB,
0x0833, 0xF60F, 0xED6D, 0xE7AA, 0xE0D9, 0xF50A, 0xDE5B, 0xF6D4,
0xDEC6, 0xE808, 0xEC36, 0xF14D, 0x032A, 0x00C4, 0x1269, 0x084D,
0x0B52, 0x0BB2, 0x077E, 0x0325, 0x10CA, 0x0345, 0x1260, 0x0B5C,
0x10B9, 0x08E2, 0x0DED, 0x0DE2, 0x0D5B, 0x13CF, 0x12CC, 0x0C70,
0x05A0, 0xF7D1, 0xE750, 0xE498, 0xDA76, 0xF045, 0xD927, 0xF5D6,
0xDA96, 0xE8AA, 0xEAD5, 0xF466, 0x0785, 0x06D2, 0x1E38, 0x0C19,
0x17C1, 0x095B, 0x0BFB, 0x00C0, 0x0B7A, 0x034C, 0x0627, 0x0373,
0x02E6, 0xFE75, 0xFF72, 0x1009, 0x0302, 0x1D03, 0x15CF, 0x1340,
0x15A8, 0xFDDE, 0xFC87, 0xE92C, 0xEBFB, 0xEF09, 0xDEFE, 0xEE66,
0xD286, 0xDEB8, 0xDA95, 0xEBDE, 0xF438, 0x024B, 0x0B6E, 0x0FEC,
0x0E05, 0x1560, 0x1324, 0x09FF, 0x1F77, 0x054C, 0x1BA6, 0x056D,
0x1169, 0xFEAC, 0x0369, 0x0422, 0xFC6C, 0x0CCC, 0x059F, 0x0F83,
0x019B, 0x01E5, 0xEDB3, 0xED56, 0xE7A4, 0xF5A4, 0xE691, 0xF4FB,
0xE18D, 0xE0A6, 0xE895, 0xE807, 0xFCD8, 0xFB49, 0x0CE8, 0x0770,
0x071C, 0x0DBF, 0x0689, 0x0A87, 0x1358, 0x0ED5, 0x156F, 0x0C81,
0x114D, 0xFE3F, 0x0675, 0x0655, 0x00A0, 0x0F59, 0x0959, 0x0702,
0x033D, 0xF7AE, 0xECF2, 0xECBE, 0xE702, 0xF8F8, 0xE7F2, 0xF81E,
0xE354, 0xE602, 0xEA25, 0xEA5A, 0xFD5D, 0xF6DB, 0x0937, 0x023F,
0x0001, 0x09E8, 0xFEC3, 0x061C, 0x0D66, 0x0BF5, 0x1675, 0x11D0,
0x1A70, 0x0BAB, 0x1404, 0x0E23, 0x0D24, 0x0C31, 0x0F6C, 0x0395,
0x0047, 0xF3A8, 0xE167, 0xDFED, 0xD675, 0xEE23, 0xD70E, 0xFA3F,
0xDAA3, 0xEDCB, 0xEFA7, 0xF4BE, 0x0EA7, 0x035A, 0x2014, 0x07D3,
0x1150, 0x0482, 0x032B, 0xFBEE, 0x05B9, 0x025A, 0x04A3, 0x08A5,
0x02D3, 0x06C9, 0xFF3E, 0x1524, 0x067B, 0x1DA5, 0x19E3, 0x124C,
0x1415, 0xF875, 0xF717, 0xE0A4, 0xE65D, 0xE8D0, 0xDB41, 0xE8FC,
0xD0F9, 0xDCFD, 0xDA51, 0xEFD6, 0xF84A, 0x056E, 0x11BA, 0x1086,
0x0F3B, 0x14A0, 0x0E1F, 0x07C6, 0x16A6, 0x030E, 0x151F, 0x0343,
0x0F32, 0xFE44, 0x0299, 0x0825, 0xFEA1, 0x1221, 0x0A2F, 0x12B8,
0x05AC, 0x02A4, 0xF0C7, 0xEB68, 0xE83D, 0xF01B, 0xE2A6, 0xED9E,
0xD9EE, 0xDC1D, 0xE35C, 0xE54C, 0xFED1, 0xFAFD, 0x12AD, 0x0D8A,
0x0C95, 0x13D7, 0x0880, 0x0BB8, 0x1209, 0x0E66, 0x160B, 0x0BEA,
0x10E7, 0xFE4D, 0x0215, 0x0516, 0xFE80, 0x0E49, 0x0BAA, 0x0B28,
0x0608, 0xFD64, 0xF0ED, 0xF043, 0xECBF, 0xFAD1, 0xE9A4, 0xF551,
0xDF7C, 0xDE5F, 0xE5BE, 0xE617, 0xFD8C, 0xF7AB, 0x0D4B, 0x0227,
0x02ED, 0x0BE9, 0xFFB1, 0x0E04, 0x0FF2, 0x13A5, 0x1A6E, 0x157E,
0x1A6C, 0x0CA1, 0x0FE6, 0x0B97, 0x0A2E, 0x0962, 0x0E59, 0x027E,
0x012F, 0xF2E6, 0xE73C, 0xE41A, 0xDDB4, 0xF479, 0xDC0A, 0xFC08,
0xDC4C, 0xECBF, 0xEBF5, 0xF277, 0x0A18, 0xFFC1, 0x1CE6, 0x04F5,
0x0EF8, 0x0482, 0x0331, 0xFD07, 0x0903, 0x05AE, 0x0D89, 0x1167,
0x0DB2, 0x0EB8, 0x055C, 0x15CD, 0x058B, 0x1B4A, 0x13E2, 0x0F55,
0x0E72, 0xF41B, 0xF465, 0xDEF4, 0xE8BF, 0xEA18, 0xE317, 0xEBCB,
0xD8D8, 0xE0C6, 0xE216, 0xF434, 0x01A2, 0x0A5A, 0x1606, 0x107D,
0x092A, 0x10C9, 0x0292, 0x07A0, 0x1061, 0x048E, 0x16F6, 0x04E2,
0x151A, 0x0366, 0x0C75, 0x0FAB, 0x0A3F, 0x178C, 0x1285, 0x1302,
0x0865, 0x0081, 0xEEF7, 0xE929, 0xE37E, 0xED17, 0xDCCE, 0xEC0F,
0xD7DE, 0xDD5B, 0xE6B4, 0xEA90, 0x06E5, 0x034F, 0x1C9A, 0x141F,
0x11CF, 0x17C4, 0x0878, 0x0BE9, 0x0E39, 0x0ADD, 0x0ED2, 0x0A85,
0x0C5A, 0x0040, 0x0470, 0x059B, 0x03D0, 0x10F6, 0x1160, 0x134D,
0x0F3E, 0x030A, 0xFA11, 0xF058, 0xEE8D, 0xF72E, 0xE76A, 0xEF34,
0xDAB8, 0xD9BE, 0xDE59, 0xE46C, 0xFD8D, 0xF9E6, 0x1536, 0x0937,
0x08F6, 0x14B0, 0x03DA, 0x1741, 0x1333, 0x19E0, 0x1845, 0x135D,
0x1524, 0x073C, 0x0C96, 0x0858, 0x07AB, 0x05CE, 0x0E05, 0xFF0D,
0x0764, 0xF452, 0xF12E, 0xEAAE, 0xE7E8, 0xFA10, 0xE36C, 0xFD92,
0xD9AE, 0xECA5, 0xE28D, 0xEF9B, 0x03B5, 0xFC36, 0x18AB, 0x04A2,
0x0BE1, 0x04F0, 0x0573, 0x00A3, 0x0F5C, 0x0CBC, 0x1223, 0x1607,
0x10BE, 0x10F5, 0x08CA, 0x13C7, 0x01C5, 0x153D, 0x094B, 0x0BC9,
0x08B0, 0xF188, 0xF597, 0xDBD0, 0xED41, 0xE9A4, 0xEA63, 0xEEF0,
0xE0A8, 0xE609, 0xE536, 0xF633, 0xFF9A, 0x0914, 0x11C0, 0x0F40,
0x0274, 0x0E2D, 0xFA4D, 0x0663, 0x0B0A, 0x06CC, 0x1650, 0x078E,
0x1909, 0x0651, 0x1490, 0x1377, 0x0EEF, 0x186F, 0x0F5E, 0x0DE1,
0x0258, 0xF8ED, 0xE813, 0xE268, 0xDEFE, 0xE575, 0xDDE0, 0xE53B,
0xD8E5, 0xDD38, 0xE70B, 0xEF9F, 0x0CB1, 0x0929, 0x236E, 0x19DC,
0x103C, 0x19E4, 0xFF90, 0x09B5, 0x042E, 0x078A, 0x0686, 0x0576,
0x09FE, 0xF8EE, 0x09BA, 0x0111, 0x0882, 0x11C7, 0x1399, 0x180E,
0x1433, 0x0817, 0xFBE7, 0xEF13, 0xE84F, 0xF183, 0xDED5, 0xEBC5,
0xD508, 0xD616, 0xDC9A, 0xDD45, 0xFE47, 0xF4D5, 0x17C0, 0x0AE2,
0x0DEF, 0x1A49, 0x066C, 0x1CB7, 0x0FA2, 0x1DC8, 0x1187, 0x13F6,
0x0DB0, 0x03AD, 0x07A7, 0x035B, 0x065B, 0x0087, 0x0EE1, 0xFA9C,
0x0A9F, 0xF295, 0xF47B, 0xEAB1, 0xEAAB, 0xF99A, 0xE542, 0xFB1D,
0xD5A6, 0xEADD, 0xDAA1, 0xF05E, 0xFF95, 0xFBA8, 0x1AE2, 0x02D0,
0x110F, 0x0710, 0x0889, 0x0576, 0x103B, 0x10B1, 0x12CD, 0x1916,
0x1090, 0x1071, 0x06B2, 0x0FBC, 0xFD15, 0x1006, 0x045D, 0x07A0,
0x0A8E, 0xF15E, 0xFDA7, 0xDA76, 0xF2D0, 0xE6FB, 0xED5C, 0xF334,
0xE1DE, 0xEC35, 0xE36D, 0xF5E6, 0xFC5A, 0x061E, 0x0BCF, 0x0F0B,
0xFF7A, 0x0FA0, 0xFD8E, 0x06FC, 0x0E4E, 0x0791, 0x1A16, 0x0A46,
0x1D92, 0x09CF, 0x16B1, 0x15C6, 0x0F16, 0x1962, 0x0D05, 0x0D95,
0x00AC, 0xF7FA, 0xE8F9, 0xE05D, 0xE0A8, 0xE2BC, 0xE3FE, 0xE4D5,
0xDEDD, 0xDEA3, 0xE82F, 0xF226, 0x0C54, 0x0CB8, 0x2174, 0x1BD2,
0x0E96, 0x1CCF, 0xFDD4, 0x0F13, 0x02BF, 0x0860, 0x0949, 0x03C5,
0x0F08, 0xFB08, 0x0F6C, 0x0318, 0x0D17, 0x1002, 0x110C, 0x14CF,
0x0F55, 0x087C, 0xFBA6, 0xEF00, 0xE789, 0xED0B, 0xDE43, 0xEAAF,
0xD754, 0xD834, 0xE175, 0xDE37, 0x04C7, 0xF775, 0x1A19, 0x104A,
0x0BEF, 0x1EAE, 0x019B, 0x1BEF, 0x07A5, 0x1A49, 0x0B9F, 0x1307,
0x0E53, 0x022F, 0x0E51, 0x0090, 0x0FE1, 0x0190, 0x1580, 0xFEB8,
0x105B, 0xF981, 0xFA04, 0xEF08, 0xE627, 0xF704, 0xDAEF, 0xF969,
0xCE5C, 0xE912, 0xD704, 0xEBF6, 0x0146, 0xF92C, 0x20BE, 0x039F,
0x1871, 0x0DAF, 0x0D36, 0x0F01, 0x1050, 0x146A, 0x0E75, 0x1770,
0x06F0, 0x0D6D, 0xFD7F, 0x0C2B, 0xFA9D, 0x0B03, 0x0584, 0x01D0,
0x0F65, 0xF2F5, 0x085D, 0xE0F9, 0xFAA1, 0xEAF7, 0xEDD3, 0xF738,
0xDE5C, 0xEC43, 0xDABC, 0xF11D, 0xEFB7, 0x0160, 0x05DE, 0x0BBC,
0x0211, 0x0F85, 0x015B, 0x07A5, 0x134B, 0x09EC, 0x1D80, 0x1094,
0x1CF7, 0x0C19, 0x1510, 0x10BC, 0x092B, 0x1147, 0x0202, 0x06E6,
0xFC08, 0xF8C8, 0xF030, 0xE16D, 0xE9DB, 0xE05E, 0xE970, 0xEA90,
0xE2FF, 0xE752, 0xE814, 0xF4B7, 0x04F4, 0x08F9, 0x1835, 0x1367,
0x0595, 0x179E, 0xF658, 0x0CE6, 0x02C6, 0x0503, 0x0EAF, 0x024C,
0x14D9, 0xFC3D, 0x12C1, 0x06B5, 0x0AFE, 0x1152, 0x0AD6, 0x0FEF,
0x0820, 0x05CA, 0xF4DC, 0xEBAB, 0xE33E, 0xE68B, 0xDF81, 0xEAC0,
0xDEC2, 0xDADE, 0xEAC8, 0xE2BA, 0x068C, 0xFD7F, 0x1643, 0x10FB,
0x07F9, 0x1F38, 0xF915, 0x19E9, 0xFC75, 0x113D, 0x0198, 0x0C62,
0x0A0E, 0xFF69, 0x1286, 0xFE2A, 0x1577, 0x0070, 0x1845, 0x012F,
0x113B, 0x01C7, 0xF910, 0xF10D, 0xE291, 0xEEB1, 0xD42B, 0xF3B2,
0xC93C, 0xE4DD, 0xD612, 0xE75F, 0xFF8A, 0xF710, 0x2281, 0x0498,
0x1D9B, 0x151B, 0x0C6F, 0x1586, 0x0B08, 0x12AB, 0x0692, 0x1125,
0xFEEC, 0x0356, 0xF8A1, 0x0047, 0xF6DE, 0x00B5, 0x04DD, 0xFC6D,
0x13E7, 0xF904, 0x0CFD, 0xEA86, 0xFB20, 0xEF96, 0xEB9C, 0xFB5C,
0xDA7B, 0xEC82, 0xD6BF, 0xEB4E, 0xEC64, 0xF8CA, 0x04C3, 0x0230,
0x0507, 0x0C9E, 0x0478, 0x0C36, 0x135D, 0x0DB1, 0x181E, 0x135D,
0x1549, 0x0DB1, 0x0ED9, 0x0C44, 0x0185, 0x0811, 0xFE1E, 0xFD95,
0x00C6, 0xF41F, 0xF693, 0xE05C, 0xEE5E, 0xE0BA, 0xECB5, 0xF0EA,
0xE236, 0xEEBE, 0xE32D, 0xF64C, 0xFB59, 0x06EA, 0x0EBB, 0x0ECE,
0x0505, 0x1431, 0xFADF, 0x0B26, 0x06EA, 0x0133, 0x110E, 0x023B,
0x15BB, 0x0168, 0x120C, 0x0866, 0x0467, 0x0EB7, 0x010C, 0x0B4B,
0x00EA, 0x027B, 0xF207, 0xEBEB, 0xE753, 0xE40A, 0xE83A, 0xEA41,
0xE6FB, 0xE1ED, 0xEF44, 0xE8E5, 0x0591, 0x00EB, 0x1525, 0x124F,
0x0716, 0x1C7E, 0xF20D, 0x164B, 0xF5B2, 0x0C97, 0x01A5, 0x0767,
0x0F0F, 0xFD2A, 0x194B, 0xFD40, 0x17D9, 0x0407, 0x17B1, 0x06EB,
0x12FA, 0x049D, 0xF991, 0xF1CC, 0xDF30, 0xEA14, 0xD1B6, 0xF0E6,
0xCA5F, 0xE67D, 0xD9B7, 0xE574, 0x02BF, 0xF795, 0x24B0, 0x09DD,
0x2168, 0x1BE9, 0x0E51, 0x1D0E, 0x0A60, 0x1298, 0x052C, 0x0B56,
0xFC67, 0x00C1, 0xF9BA, 0xFD37, 0xFA16, 0xFDF9, 0x0705, 0xFC52,
0x16B5, 0xFD0A, 0x0CB4, 0xF397, 0xF95A, 0xF288, 0xED50, 0xFAB0,
0xDBC7, 0xEE05, 0xD717, 0xEA09, 0xEDC3, 0xF808, 0x0952, 0x043E,
0x0E98, 0x1138, 0x0853, 0x12E0, 0x0DAB, 0x119C, 0x11F0, 0x13C4,
0x1199, 0x0AC8, 0x0DE0, 0x05B0, 0x0143, 0x04D1, 0x006B, 0xFEB6,
0x0AA4, 0xF8DF, 0x01CC, 0xE943, 0xF33D, 0xE649, 0xEB9D, 0xF570,
0xDC0E, 0xF2BB, 0xDB47, 0xF290, 0xF53D, 0xFF74, 0x0D4C, 0x0A14,
0x0D41, 0x14E9, 0x055F, 0x12D1, 0x0E73, 0x0AF0, 0x17F5, 0x07FA,
0x155B, 0x041C, 0x0A2E, 0x076C, 0xFBDA, 0x08FA, 0xFAE1, 0x036F,
0x00BB, 0xFE84, 0xF89F, 0xED95, 0xF0CE, 0xE7AB, 0xF30A, 0xF32E,
0xEE3D, 0xED76, 0xEE6D, 0xEECA, 0xFE2F, 0x00DE, 0x0A55, 0x0E1C,
0x02A7, 0x1678, 0xF4A1, 0x12AD, 0xF85B, 0x0B0F, 0x069A, 0x086D,
0x1552, 0x031C, 0x1CD0, 0x02F9, 0x1635, 0x079D, 0x10A1, 0x074F,
0x0D30, 0x01EE, 0xF868, 0xEF75, 0xDF89, 0xE5EC, 0xD7C2, 0xEF59,
0xD553, 0xEC6B, 0xE017, 0xEE2B, 0x02E7, 0xFF91, 0x209A, 0x0FE3,
0x1DF8, 0x1D48, 0x09D9, 0x1A79, 0x016E, 0x0E57, 0x025E, 0x05D0,
0x0333, 0xFD25, 0x0255, 0xFDC4, 0x016C, 0x035B, 0x0A41, 0x04A7,
0x157C, 0x051D, 0x09FB, 0xF7A1, 0xF2F0, 0xED99, 0xE6EC, 0xF3B5,
0xDA4F, 0xEBF4, 0xDAA4, 0xE835, 0xF607, 0xF8B3, 0x10C7, 0x0B3B,
0x1458, 0x18FA, 0x0AA5, 0x1A56, 0x0781, 0x152F, 0x0752, 0x0D36,
0x065A, 0x0040, 0x04CC, 0xFCAB, 0x0072, 0xFEC4, 0x0593, 0xFED0,
0x12E9, 0x0063, 0x0C07, 0xF45D, 0xF52C, 0xEDC8, 0xE70C, 0xF819,
0xD894, 0xF090, 0xD402, 0xEA37, 0xEAE7, 0xF6D3, 0x0872, 0x05A9,
0x13F9, 0x154C, 0x119B, 0x19AE, 0x1498, 0x13D5, 0x17ED, 0x0E10,
0x122A, 0x0517, 0x04FF, 0xFF8A, 0xF618, 0xFC76, 0xF416, 0xF9FB,
0xFEFD, 0xFAD6, 0xFE52, 0xF07D, 0xF67A, 0xED3C, 0xF8B0, 0xFB1C,
0xF1A0, 0xF866, 0xEA72, 0xF363, 0xF847, 0xFBC9, 0x0779, 0x04D5,
0x0345, 0x0D86, 0xF812, 0x0E98, 0xFD99, 0x0D69, 0x0C22, 0x0D54,
0x174E, 0x07C0, 0x1A37, 0x06EC, 0x1105, 0x08F8, 0x0950, 0x0469,
0x095C, 0xFBA0, 0xFB86, 0xE850, 0xE449, 0xE0B3, 0xDE1D, 0xF095,
0xDDBF, 0xF38C, 0xE477, 0xF459, 0xFF5A, 0x0457, 0x183F, 0x12A9,
0x1762, 0x19E6, 0x08A5, 0x1472, 0x045C, 0x08B9, 0x0680, 0x0085,
0x0944, 0xFBFF, 0x09AA, 0x0038, 0x04D1, 0x069E, 0x07C1, 0x08D8,
0x0F2D, 0x0842, 0x0200, 0xF685, 0xEB4E, 0xE6FF, 0xE5D5, 0xEDDD,
0xE159, 0xEB79, 0xE09D, 0xEB2A, 0xF94C, 0xFECE, 0x1690, 0x10EB,
0x194F, 0x1C58, 0x09C4, 0x1C21, 0x02B4, 0x11BB, 0x02F6, 0x04F8,
0x0489, 0xF81D, 0x0681, 0xF5C0, 0x0625, 0xFE3B, 0x0C21, 0x0754,
0x168B, 0x0A0E, 0x0E44, 0xFB3C, 0xF609, 0xEEE8, 0xE4C9, 0xF40F,
0xD66E, 0xEBBB, 0xD35B, 0xE471, 0xECA9, 0xF36E, 0x0D9F, 0x07CC,
0x1A26, 0x1ADD, 0x1753, 0x2148, 0x1717, 0x1ADB, 0x15F2, 0x0F43,
0x0F3C, 0xFFAF, 0x0330, 0xF619, 0xF4F3, 0xF485, 0xF540, 0xF6E2,
0x049B, 0xFCAA, 0x057C, 0xF8BE, 0xF77D, 0xF4B3, 0xF505, 0xFE8C,
0xF12D, 0xFB67, 0xE870, 0xF21C, 0xF3AC, 0xF68D, 0x08DC, 0x0038,
0x0B7F, 0x0B3C, 0x01EA, 0x1048, 0x04A7, 0x1223, 0x0E71, 0x10E2,
0x1383, 0x08B0, 0x11F0, 0x03F4, 0x095C, 0x028A, 0x0742, 0xFFAD,
0x0B8D, 0xFA8B, 0xFFD8, 0xEBDB, 0xEDC2, 0xE65A, 0xE8F0, 0xF606,
0xE27E, 0xFA24, 0xE14C, 0xF7A2, 0xF7C9, 0x0226, 0x11F0, 0x0E11,
0x169A, 0x13D8, 0x0D7D, 0x0FF9, 0x0BE7, 0x09A7, 0x0F64, 0x0535,
0x117A, 0x0182, 0x0DBC, 0x0275, 0x00C0, 0x0529, 0xFD9A, 0x061E,
0x06EB, 0x021D, 0x0049, 0xF1A0, 0xEE2F, 0xE512, 0xE96D, 0xEB85,
0xE956, 0xF031, 0xEBE1, 0xF5EF, 0xFDF2, 0x052F, 0x144D, 0x12A9,
0x15C1, 0x1AE4, 0x0589, 0x169C, 0xFFB8, 0x0A6D, 0x0510, 0xFEEA,
0x0A03, 0xF684, 0x0A61, 0xF821, 0x083C, 0x02C2, 0x0F81, 0x0E04,
0x167C, 0x0EE2, 0x07A5, 0xFD7E, 0xEFAD, 0xED43, 0xE3CE, 0xED4C,
0xDA71, 0xE8E0, 0xD853, 0xE5A6, 0xF130, 0xF576, 0x135F, 0x0E4E,
0x1E71, 0x2158, 0x1687, 0x224A, 0x121F, 0x183B, 0x0F8E, 0x0A3E,
0x0B15, 0xF8C0, 0x03F1, 0xF017, 0xF855, 0xF266, 0xF962, 0xFAB6,
0x089F, 0x0409, 0x085D, 0x00C3, 0xF736, 0xF954, 0xEE7D, 0xFB32,
0xE933, 0xF53C, 0xE54E, 0xED5C, 0xF50B, 0xF39F, 0x0E3F, 0xFFF8,
0x1481, 0x0E15, 0x09A9, 0x164E, 0x0633, 0x159B, 0x0ABC, 0x0EF0,
0x0BE0, 0x03B0, 0x0637, 0xFB88, 0xFDD3, 0xF835, 0x0201, 0xF97B,
0x0E2D, 0xFC03, 0x0852, 0xF419, 0xF58D, 0xEF39, 0xEC2D, 0xFA1F,
0xE2D7, 0xFB67, 0xDB2A, 0xF456, 0xECEC, 0xF897, 0x0B0C, 0x0329,
0x1472, 0x0CD0, 0x0E1C, 0x0D51, 0x1042, 0x0A89, 0x151A, 0x09A5,
0x11C9, 0x04B7, 0x0842, 0x0127, 0xF929, 0xFF9A, 0xF307, 0xFDE3,
0xFC35, 0xFA0E, 0xFC4F, 0xEDF4, 0xF11B, 0xE634, 0xEFE3, 0xEF01,
0xF088, 0xF6CF, 0xEE41, 0xFB29, 0xFB20, 0x05FB, 0x0FD4, 0x0F69,
0x1076, 0x12AA, 0x001C, 0x0C9B, 0xFB62, 0x024C, 0x0403, 0xF93D,
0x0B34, 0xF46F, 0x0C4D, 0xFB17, 0x071D, 0x0561, 0x0764, 0x0BF4,
0x0D2B, 0x0BDF, 0x0213, 0xFC61, 0xECD9, 0xE9DA, 0xE425, 0xE7E8,
0xDFAC, 0xE8B2, 0xDF39, 0xE92D, 0xF5ED, 0xF9E2, 0x1689, 0x1175,
0x1E15, 0x1F1C, 0x0EDB, 0x1CB5, 0x0802, 0x1132, 0x0A11, 0x017C,
0x0665, 0xF1C6, 0x0126, 0xED5E, 0xFCC1, 0xF345, 0xFEE9, 0xFF90,
0x098E, 0x09DA, 0x0621, 0x045A, 0xF39E, 0xF8C2, 0xEA54, 0xF671,
0xE71D, 0xF0D6, 0xE404, 0xEACF, 0xF454, 0xF3DE, 0x13A8, 0x0412,
0x1E45, 0x1446, 0x0FE3, 0x1C49, 0x060D, 0x18A6, 0x0554, 0x0AE0,
0x01A8, 0xFA62, 0xFD62, 0xF304, 0xF9B9, 0xF23A, 0xFF9F, 0xF787,
0x0FD6, 0xFE6F, 0x0EF0, 0xFD4D, 0xFD6E, 0xFB13, 0xF27B, 0xFEE4,
0xE6BD, 0xFBA1, 0xD9F1, 0xF2E4, 0xE82B, 0xF4EE, 0x0930, 0xFF7E,
0x1675, 0x0A43, 0x1179, 0x0E72, 0x12FC, 0x0F9B, 0x1743, 0x0D78,
0x1140, 0x05F2, 0x03F8, 0xFFF2, 0xF572, 0xFB52, 0xF175, 0xFA22,
0xFAE1, 0xF8CF, 0xFCFB, 0xF0AA, 0xF5DF, 0xEBA5, 0xF704, 0xF494,
0xF800, 0xFD04, 0xF183, 0xFF12, 0xFA22, 0x06F9, 0x0FC6, 0x0F1D,
0x130E, 0x10A7, 0x0418, 0x0C00, 0xFCFE, 0x0520, 0x03CB, 0xFBFE,
0x0A4E, 0xF6C1, 0x0988, 0xFCE9, 0x044D, 0x04C2, 0x03EB, 0x09B1,
0x0953, 0x07C2, 0x031A, 0xFB15, 0xF1BC, 0xEE58, 0xEAAB, 0xEC9D,
0xE96D, 0xED3A, 0xE4ED, 0xF0AC, 0xF579, 0x00A8, 0x153C, 0x1252,
0x1BBA, 0x1C55, 0x0D03, 0x1A65, 0x0691, 0x0E1D, 0x0821, 0xFE30,
0x05AD, 0xF2F8, 0x0276, 0xF117, 0xFFF4, 0xF6EF, 0xFFE8, 0x0381,
0x0653, 0x0A8C, 0x0375, 0x0431, 0xF393, 0xF97C, 0xED2B, 0xF4DF,
0xEC94, 0xEFFC, 0xE8AD, 0xEC9A, 0xFA4A, 0xF77D, 0x1A2A, 0x0938,
0x20AF, 0x1772, 0x10AE, 0x1B3A, 0x02B2, 0x1593, 0xFD3A, 0x07C5,
0xFBE7, 0xF688, 0xF9F3, 0xEF2E, 0xF880, 0xF288, 0x012B, 0xFA79,
0x11A4, 0x0117, 0x120E, 0x02BA, 0x0083, 0xFFAB, 0xF384, 0xFE35,
0xE856, 0xF978, 0xDC60, 0xF2E8, 0xEA21, 0xF7A9, 0x0A46, 0x0248,
0x1835, 0x0D2F, 0x140B, 0x13E7, 0x115E, 0x13CF, 0x11C7, 0x0C71,
0x09DF, 0x019B, 0xFBAE, 0xFB30, 0xF328, 0xF7C8, 0xF43A, 0xF8A6,
0xFC63, 0xFB26, 0x0097, 0xF7E0, 0xFC1F, 0xF468, 0xF99C, 0xFA4A,
0xF75D, 0xFDDC, 0xEFAC, 0xFD1A, 0xF762, 0x038F, 0x0F32, 0x0A4F,
0x15FD, 0x0DE8, 0x092E, 0x0C19, 0x017A, 0x0764, 0x0448, 0x01AF,
0x0431, 0xFA23, 0xFF95, 0xF9E3, 0xFB5D, 0x0026, 0xFBB6, 0x04F0,
0x0552, 0x028E, 0x07FE, 0xFAE9, 0xFB95, 0xF3CE, 0xF3F9, 0xF19A,
0xF135, 0xF250, 0xE9B4, 0xF75F, 0xF343, 0x0305, 0x0D38, 0x0E36,
0x143F, 0x1609, 0x09EF, 0x1432, 0x06B4, 0x0B02, 0x09F1, 0xFF06,
0x07C7, 0xF3EB, 0x0138, 0xF381, 0xFBE4, 0xF9E3, 0xFBEB, 0x015E,
0x0014, 0x06C3, 0xFC11, 0x0305, 0xF23B, 0xF766, 0xF09A, 0xF22B,
0xF105, 0xF217, 0xEFAC, 0xF274, 0xFF11, 0xFBC7, 0x17BB, 0x0AB0,
0x1BB7, 0x15FA, 0x0C92, 0x164F, 0xFDEB, 0x0F8A, 0xF847, 0x0334,
0xF795, 0xF354, 0xF6CC, 0xEDFB, 0xF8D3, 0xF3CA, 0x01B0, 0xFD4E,
0x0CD6, 0x03BE, 0x0DA8, 0x035F, 0xFFC7, 0xFF95, 0xF06C, 0xFC48,
0xE7AC, 0xF53E, 0xE293, 0xF13E, 0xEE36, 0xF80B, 0x0A99, 0x01A5,
0x1A34, 0x0D4F, 0x1407, 0x13FF, 0x0B3C, 0x1185, 0x0976, 0x0884,
0x01F5, 0xFC95, 0xF523, 0xF6E9, 0xF27A, 0xF50E, 0xF87E, 0xF553,
0x00F3, 0xFACB, 0x0527, 0xFE53, 0xFE63, 0xFAD4, 0xF79B, 0xFA98,
0xF32F, 0xFCD0, 0xEB09, 0xFD0F, 0xF362, 0xFF57, 0x0D00, 0x03ED,
0x17B7, 0x0B61, 0x0F55, 0x0B50, 0x07A6, 0x0716, 0x04FE, 0x03EC,
0xFE11, 0xFBAB, 0xF5DA, 0xF8ED, 0xF343, 0xFCB3, 0xF695, 0xFEDF,
0x0260, 0xFF85, 0x0AED, 0xFB7A, 0x04C1, 0xF5FE, 0xFCDC, 0xF82F,
0xF712, 0xF8B5, 0xECF7, 0xF9EE, 0xEFE0, 0x0414, 0x0353, 0x0B55,
0x0D11, 0x0FF6, 0x08C7, 0x0EA5, 0x05D8, 0x0663, 0x087E, 0xFCC1,
0x080A, 0xF403, 0x0169, 0xF747, 0xFB70, 0xFE15, 0xF8E0, 0xFF60,
0xFAEF, 0x0452, 0xFB78, 0x03F7, 0xF5D7, 0xF889, 0xF4AA, 0xF1C8,
0xF72E, 0xF0F5, 0xF5E1, 0xF62C, 0xFEB8, 0x0070, 0x13DE, 0x098C,
0x19D8, 0x159E, 0x0988, 0x168B, 0xFA03, 0x0B48, 0xF808, 0x0032,
0xF8F8, 0xF221, 0xF6A5, 0xEC4D, 0xF912, 0xF297, 0x0177, 0xFBCE,
0x0A60, 0x0598, 0x0C3A, 0x087D, 0x0193, 0x036F, 0xF458, 0xFF8D,
0xEE3A, 0xF8BD, 0xEAC0, 0xF315, 0xF3CA, 0xF859, 0x0BED, 0x00D1,
0x1756, 0x0A2C, 0x1107, 0x102A, 0x0785, 0x10AD, 0x002A, 0x09E2,
0xFA35, 0xFB7F, 0xF4E3, 0xF5D0, 0xF640, 0xF656, 0xFC01, 0xF3DD,
0x02B7, 0xF907, 0x0914, 0x0140, 0x0416, 0xFEE7, 0xF980, 0xFD86,
0xF381, 0xFF31, 0xEBDB, 0x000D, 0xF2C2, 0x035F, 0x0D61, 0x01FC,
0x1B28, 0x05CA, 0x13A5, 0x0BCC, 0x066C, 0x05C9, 0x002B, 0x001F,
0xFBE4, 0xFDF4, 0xF0A0, 0xFA8F, 0xEC14, 0xFB26, 0xF42C, 0xFD7D,
0x02BD, 0xFE54, 0x0EFA, 0xFC8C, 0x0CCD, 0xF75A, 0x0363, 0xF8EE,
0xFB74, 0xFA7F, 0xF103, 0xFC22, 0xF14D, 0x0843, 0x0073, 0x0C1E,
0x0947, 0x0B66, 0x0943, 0x0BC3, 0x0837, 0x03B7, 0x062D, 0xFC82,
0x0263, 0xF4D0, 0xFD6F, 0xF2ED, 0xF8B1, 0xFD91, 0xF5E0, 0x01B5,
0xF9D5, 0x03BE, 0xFEA0, 0x0812, 0xFD20, 0xFDA4, 0xFC28, 0xF351,
0xFB32, 0xF214, 0xF70F, 0xF667, 0xFD22, 0x0195, 0x0EEE, 0x062D,
0x1540, 0x0E10, 0x08D9, 0x162B, 0xFBD4, 0x0C51, 0xF93C, 0xFE66,
0xFA29, 0xF3CF, 0xF736, 0xEECB, 0xF38B, 0xF1FD, 0xF9AF, 0xF7DD,
0x06D3, 0x0369, 0x0A19, 0x093B, 0x03B8, 0x0215, 0xFBA3, 0x0007,
0xF3B8, 0xFA9F, 0xF239, 0xF458, 0xFA7F, 0xFC60, 0x08C6, 0x005B,
0x10AA, 0x04E1, 0x09E9, 0x0E55, 0x019A, 0x0E4C, 0xFD73, 0x06C7,
0xF729, 0xFAF8, 0xF4DB, 0xF42C, 0xF5AC, 0xF4C0, 0xF8A1, 0xF533,
0x0365, 0xFA6C, 0x0898, 0x00CA, 0x01D9, 0x00CD, 0xF8AF, 0xFF97,
0xF0AE, 0xFD23, 0xED82, 0xFFBF, 0xF6CE, 0x0379, 0x0C3D, 0xFE6E,
0x17A0, 0x01C3, 0x0D55, 0x07D4, 0x0332, 0x0528, 0xFFDF, 0x01AB,
0xF66A, 0xFB87, 0xED21, 0xF9C8, 0xEA47, 0xFB5E, 0xF096, 0xF9D4,
0x0432, 0xFD99, 0x1097, 0xFF9F, 0x0C27, 0xFA92, 0x03B2, 0xFA84,
0xF9B9, 0xFC95, 0xF1D6, 0xFF2E, 0xF3E8, 0x044F, 0xFE6A, 0x0531,
0x0642, 0x06A3, 0x079F, 0x0732, 0x0573, 0x0481, 0x021D, 0xFDCB,
0xFF97, 0xF3AC, 0xFA00, 0xF4DF, 0xF2FE, 0xFC54, 0xF2D0, 0xFE77,
0xFBA4, 0x017F, 0x0518, 0x046F, 0x0473, 0xFED9, 0xFD71, 0xF803,
0xFA01, 0xF6EB, 0xF83C, 0xFB6E, 0xFCB8, 0x0359, 0x0B22, 0x06BB,
0x1243, 0x0AF5, 0x0957, 0x0CFE, 0xFC53, 0x04E5, 0xFBB7, 0xFA74,
0xFC31, 0xF357, 0xF1A7, 0xF239, 0xF1C9, 0xF75F, 0xFB49, 0xFDAC,
0x0309, 0x020E, 0x0B7C, 0x074F, 0x08DB, 0x05E1, 0x014D, 0xFEB5,
0xFCE0, 0xFA6D, 0xF55C, 0xF9AD, 0xF8E1, 0xFDF7, 0x03CD, 0x00DC,
0x094E, 0x07C7, 0x0D16, 0x111F, 0x0520, 0x0C62, 0xFB7E, 0x011B,
0xFBE7, 0xF994, 0xF989, 0xF486, 0xF857, 0xF5B1, 0xF9A8, 0xF7D5,
0xFD72, 0xFAAF, 0x051D, 0x04A8, 0x0373, 0x05DB, 0xFDC7, 0x012E,
0xFB62, 0x00C7, 0xF66B, 0xFF74, 0xFC22, 0x0070, 0x0D66, 0x018D,
0x14BF, 0x0636, 0x0DE1, 0x0B9C, 0x005D, 0x0736, 0xF9F6, 0x00D2,
0xF7F0, 0xFB33, 0xEE73, 0xF5AA, 0xEEB0, 0xF72A, 0xFD1B, 0xFA85,
0x0760, 0xFC50, 0x0C1C, 0x015F, 0x0F34, 0x0470, 0x08AA, 0x052E,
0xFBC0, 0x032A, 0xF5CA, 0x00E2, 0xF7E0, 0x02CC, 0xFF09, 0x000A,
0x0788, 0x01D9, 0x0C28, 0x08C4, 0x07CA, 0x0688, 0xFE46, 0xFEFE,
0xFA29, 0xFA0E, 0xFB65, 0xFC43, 0xFA01, 0xFDAC, 0xF76C, 0xFAE2,
0xFE4C, 0xFD32, 0x08CF, 0x029D, 0x07AF, 0xFF9F, 0xFFCB, 0xFAF9,
0xFD97, 0xFE0D, 0xFAD1, 0x04BB, 0xFAB4, 0x084C, 0x0886, 0x064C,
0x1416, 0x0981, 0x0F19, 0x0BB4, 0x03C8, 0x04F1, 0xFFD2, 0xFC66,
0xFD1F, 0xF606, 0xF16D, 0xF4EF, 0xEB1A, 0xF80C, 0xF5AA, 0xFD59,
0x03B5, 0x03A7, 0x0C03, 0x064C, 0x0EA5, 0x02AA, 0x0CB2, 0x0052,
0x0566, 0xFD8B, 0xFBDD, 0xFE1F, 0xFE3E, 0x0621, 0x04F8, 0x08CF,
0x03ED, 0x0A82, 0x03AD, 0x0D0A, 0x0216, 0x090E, 0xFDEF, 0xFFA6,
0xFD46, 0xF588, 0xFC0F, 0xF381, 0xFCEC, 0xF885, 0xFE06, 0xFB70,
0xFE95, 0x0274, 0x08F4, 0x0D3D, 0x0A99, 0x09D1, 0xFB9F, 0xFE74,
0xF607, 0xFAB1, 0xF932, 0xFE26, 0xFED0, 0x0111, 0x0B4E, 0xFED5,
0x12BA, 0x04DD, 0x0F95, 0x0FD4, 0x03E2, 0x0E7D, 0xFC0D, 0x0553,
0xFE69, 0xFC06, 0xF5E9, 0xF676, 0xEBA6, 0xF478, 0xF36A, 0xF4AB,
0x00DC, 0xFB57, 0x0C4C, 0x0523, 0x0E79, 0x0579, 0x0744, 0x03BC,
0x04C4, 0x06E8, 0xFE81, 0x05C8, 0xFC13, 0x0457, 0x0928, 0x031A,
0x0BC3, 0x0409, 0x02EE, 0x06B7, 0xFD10, 0x0441, 0xF9BE, 0x009F,
0xFB22, 0xFD97, 0xFA90, 0xF860, 0xF9D7, 0xF7AA, 0xFF18, 0xFDF5,
0x022A, 0x0120, 0x0897, 0x04BB, 0x0ED3, 0x048F, 0x04CC, 0x00E8,
0xF691, 0x01B1, 0xF32D, 0x0304, 0xFBB0, 0x06AA, 0x095A, 0x0464,
0x0F61, 0x012B, 0x0E12, 0x0958, 0x0937, 0x0BA8, 0xFE32, 0xFED6,
0xF7CD, 0xF606, 0xF700, 0xF747, 0xF23F, 0xFB79, 0xF2D1, 0xFD98,
0xFC79, 0xFD21, 0x073F, 0x0333, 0x0C82, 0x03D8, 0x0870, 0xFC7D,
0x0388, 0x0011, 0x0165, 0x072F, 0xFCCA, 0x069A, 0x029E, 0x039E,
0x0E9B, 0x072C, 0x09BE, 0x0C4F, 0xFD41, 0x058D, 0xF75D, 0xF9BB,
0xF6ED, 0xF6E3, 0xFA2A, 0xF5D1, 0xFB0E, 0xF2A4, 0xFC83, 0xFC7B,
0x04AF, 0x07FE, 0x093B, 0x070B, 0x0928, 0x019C, 0x069F, 0xFEB1,
0xFBF2, 0x00B5, 0xF3C0, 0x00A8, 0xF948, 0x0025, 0x06C0, 0x0371,
0x0F1C, 0x05DE, 0x0D3A, 0x0707, 0x0953, 0x0C25, 0x0395, 0x051D,
0xF71D, 0xF2F3, 0xF22F, 0xEF61, 0xF5BE, 0xF505, 0xF5CD, 0xFC02,
0xFB4A, 0x0005, 0x065E, 0x0457, 0x0B3A, 0x09ED, 0x09E6, 0x02F9,
0x04AA, 0xFB29, 0x01AA, 0x03EE, 0x0138, 0x07AC, 0xFE96, 0xFDA7,
0x05AA, 0x003E, 0x0D13, 0x0AC4, 0x0143, 0x0B35, 0xF67A, 0xFFF7,
0xF843, 0xF7D6, 0xFA47, 0xF7B9, 0xFBF9, 0xF032, 0xFC13, 0xF254,
0x01A6, 0x05D2, 0x0AD8, 0x0D09, 0x06A9, 0x0447, 0x013E, 0xFFC1,
0xFF70, 0x0464, 0xF917, 0x0674, 0xFAF0, 0x004E, 0x06B8, 0xFF15,
0x0E9D, 0x0758, 0x0C81, 0x05BF, 0x042F, 0x03C2, 0x01FC, 0x0A0A,
0xFD49, 0xFFFE, 0xF093, 0xEFBE, 0xF380, 0xEFDB, 0xFCA5, 0xFA95,
0xFDF4, 0xFF9E, 0x0578, 0x01B7, 0x0C14, 0x08B6, 0x0802, 0x08D7,
0x0165, 0xFFF8, 0xFEEC, 0x03E7, 0x0521, 0x0F71, 0x08DB, 0x057A,
0x0675, 0xF9F7, 0x0A71, 0x0031, 0x050E, 0x073D, 0xF55F, 0x0177,
0xF484, 0xF8F0, 0xFAD7, 0xFB21, 0xFB4C, 0xF9ED, 0xFBEC, 0xF48D,
0x0383, 0xFF36, 0x112B, 0x0D84, 0x0FBC, 0x038B, 0xFF5F, 0xF60A,
0xF939, 0xFD8B, 0xF7EC, 0x0A1A, 0xF862, 0x0ABC, 0x04D0, 0x06C2,
0x115C, 0x0C34, 0x117F, 0x09A2, 0x073A, 0xFC23, 0x0163, 0xFE02,
0x0217, 0xFFDC, 0xF4E6, 0xEFED, 0xEA21, 0xEA6B, 0xF4F1, 0xFCDE,
0xFCCB, 0x0B22, 0x01EB, 0x099F, 0x0FAF, 0x088A, 0x10D4, 0x06BD,
0x0455, 0xFA43, 0xFE60, 0xF752, 0x023E, 0x08A4, 0x0761, 0x0C83,
0x03FD, 0x0270, 0x01C2, 0x0355, 0x036D, 0x0B6E, 0xF9D4, 0x0723,
0xF508, 0xF54E, 0xFF61, 0xF103, 0x00B9, 0xF477, 0xF8C5, 0xF029,
0xFB8C, 0xFB40, 0x093D, 0x13F0, 0x0D92, 0x1343, 0xFF75, 0xFF4B,
0xF818, 0xFAEB, 0xFE35, 0x04FA, 0xFE52, 0x042F, 0x0389, 0xFB0A,
0x11D1, 0x05AB, 0x1055, 0x0D58, 0x00D0, 0x0195, 0xF902, 0x0381,
0xFBEB, 0x07BD, 0xF828, 0xF5EF, 0xEEE3, 0xE42C, 0xF67F, 0xEC7F,
0x0318, 0x00D0, 0x0256, 0x0522, 0x067A, 0x05D9, 0x0C3F, 0x0F11,
0x00BE, 0x08D7, 0xF7ED, 0xFDB8, 0xFFCF, 0x0779, 0x0A12, 0x0936,
0x0B99, 0xFB8A, 0x0708, 0xF597, 0x0344, 0xFEBF, 0xF92E, 0x081E,
0xED1B, 0xFBC3, 0xF31B, 0xF655, 0xFD47, 0xFEE2, 0xF8A0, 0xF5E5,
0xF9BD, 0xF2F9, 0x0B1B, 0x06F0, 0x1328, 0x0A0E, 0x0427, 0xFA34,
0xF6EA, 0xF77A, 0xFA68, 0x074F, 0xF94A, 0x1042, 0xF9A8, 0x0306,
0x0D8D, 0x05A4, 0x1581, 0x0D9A, 0x046B, 0xFA23, 0xFB8D, 0xF47F,
0xFF12, 0xFE60, 0xF7C7, 0xF6BB, 0xEA85, 0xEAC4, 0xEDFE, 0xF033,
0xFC64, 0x052F, 0xFFB1, 0x0BDB, 0x03DB, 0x00FC, 0x109B, 0x05AF,
0x0BFB, 0x061D, 0xFCB5, 0xF6AA, 0xFD05, 0x0235, 0x06E9, 0x1079,
0x06BB, 0x0648, 0xFFA1, 0xFC3A, 0xFFFA, 0xFCEC, 0xFCDB, 0x043C,
0xF204, 0xF861, 0xF792, 0xEAB0, 0x0553, 0xF7A4, 0xFE84, 0xFA82,
0xF51D, 0xF5DB, 0x0004, 0x0C0A, 0x0C17, 0x13F4, 0x01BB, 0xFE5F,
0xF4CD, 0xF316, 0xFE5E, 0xFB42, 0x039A, 0x07EE, 0xFF12, 0x012E,
0x0ECF, 0x02DC, 0x185C, 0x144F, 0x017E, 0x06FA, 0xF0F7, 0xF832,
0xF7A4, 0xFFF4, 0xF82C, 0xF5DB, 0xED47, 0xE2C9, 0xF14E, 0xE5FD,
0x0339, 0xFBE1, 0x0477, 0x0E77, 0x0006, 0x0A05, 0x0A6F, 0x0B42,
0x08A7, 0x10B4, 0xF8F5, 0xFAE6, 0xF7E8, 0xF8EA, 0x05DC, 0x0AD1,
0x0D9E, 0x0178, 0x05F5, 0xF560, 0x0225, 0xFBF3, 0x00AA, 0x098D,
0xF045, 0x04C0, 0xEE70, 0xF26D, 0x01AA, 0xF6C3, 0xFFCF, 0xF94A,
0xF601, 0xECEA, 0x0205, 0x0009, 0x0F4B, 0x125B, 0x05CD, 0x0167,
0xF505, 0xF80E, 0xFA50, 0x0294, 0x0121, 0x0FC4, 0xFA8C, 0x068B,
0x0A1E, 0xFD39, 0x1D5A, 0x0B59, 0x0B31, 0x0164, 0xF596, 0xF0D7,
0xF7F9, 0x0156, 0xF98F, 0x01AA, 0xEB7C, 0xEAFD, 0xE88C, 0xEA02,
0xFEB8, 0xFCE1, 0x0686, 0x0A73, 0x0094, 0x01D4, 0x0FD3, 0x0142,
0x1470, 0x0DA9, 0xFE71, 0xFF45, 0xF5CD, 0xFE0E, 0x0140, 0x1569,
0x0911, 0x0D76, 0x011A, 0xF65E, 0xFDBA, 0xF4AF, 0x04EE, 0x0211,
0xFAB8, 0xFEF9, 0xF3C6, 0xED73, 0x0594, 0xF87B, 0x0588, 0x0517,
0xF40C, 0xF6CF, 0xF919, 0x0323, 0x0A0D, 0x16C6, 0x05C2, 0x006C,
0xF4E6, 0xEBAC, 0xFDFC, 0xF6B3, 0x0B0C, 0x0C49, 0xFFD7, 0x0B20,
0x07DA, 0x05FA, 0x1C27, 0x17B2, 0x0AC2, 0x0D6F, 0xF14A, 0xF0FC,
0xF3E1, 0xF9BD, 0xFCEE, 0xFCAE, 0xF4CA, 0xE30D, 0xED3F, 0xDFEC,
0xFF1F, 0xFE20, 0x07A1, 0x178B, 0xFBCC, 0x0F25, 0x0804, 0x091C,
0x1441, 0x1328, 0x014A, 0xFCEE, 0xF671, 0xEE44, 0x04B1, 0x07FB,
0x109D, 0x0B4F, 0x0578, 0xF7ED, 0xF9FF, 0xF9CB, 0xFEF7, 0x0E4E,
0xF629, 0x0D7E, 0xED01, 0xF187, 0x02A8, 0xF1EA, 0x0C1D, 0x0008,
0xFC14, 0xED1E, 0xFCA2, 0xF3AD, 0x0A5E, 0x1776, 0x0649, 0x0EB7,
0xEFA7, 0xF65F, 0xF19C, 0xFDC4, 0x06AF, 0x110A, 0x0079, 0x09C0,
0x04C8, 0xF963, 0x22BD, 0x0A77, 0x1986, 0x0BED, 0xF723, 0xEFE5,
0xEFE6, 0xFB99, 0xF50A, 0x0C84, 0xEDC4, 0xF172, 0xE579, 0xE1E3,
0xF8D9, 0xF68F, 0x0BC0, 0x0CF9, 0x01CB, 0x05B9, 0x0A7D, 0xFDA6,
0x1B99, 0x131C, 0x0821, 0x0B9D, 0xF2D0, 0xF632, 0xF817, 0x0D8F,
0x06BA, 0x14FC, 0x0559, 0xF5AF, 0xFB33, 0xEAE3, 0x0455, 0xFF12,
0x0263, 0x0753, 0xF007, 0xF27A, 0xFE07, 0xF5CE, 0x0AE7, 0x0EF4,
0xF7E0, 0xFCEC, 0xF219, 0xF2F5, 0x015F, 0x1181, 0x07F6, 0x0929,
0xFA10, 0xE970, 0xF8BE, 0xEF57, 0x0BDA, 0x0D12, 0x039F, 0x12EB,
0xFAB5, 0x0411, 0x14DE, 0x126E, 0x15F1, 0x1685, 0xF75A, 0xEFAA,
0xEFBF, 0xEB27, 0xF9FB, 0x002D, 0xF8E4, 0xED29, 0xED8B, 0xDD8B,
0xF75E, 0xF792, 0x07BE, 0x18C1, 0xFBC3, 0x1444, 0xFDA7, 0x024A,
0x1407, 0x10EF, 0x0DDF, 0x08FF, 0xFCD1, 0xE972, 0xFFE7, 0xFD79,
0x0B5D, 0x1517, 0x0801, 0xFF67, 0xF7BE, 0xF1C3, 0xF961, 0x05A7,
0xFBD8, 0x1110, 0xED3C, 0xF4A2, 0xF98F, 0xE9A0, 0x1125, 0x04AA,
0x0722, 0xF9EC, 0xFA65, 0xED41, 0x017D, 0x12EF, 0x04A5, 0x1807,
0xF4D4, 0xF68A, 0xF0CF, 0xF20A, 0x05F7, 0x09E1, 0x06E8, 0x0F55,
0x012B, 0xF90A, 0x1A41, 0x0334, 0x1F0F, 0x1747, 0xFE39, 0xF9C6,
0xED2E, 0xF135, 0xF1D7, 0x0B0C, 0xF1E3, 0xF969, 0xEA22, 0xDE03,
0xF4BB, 0xEB84, 0x0BE4, 0x0BE6, 0x07E7, 0x0FA0, 0x0363, 0xFC75,
0x1428, 0x0F56, 0x0F66, 0x18D7, 0xF9CB, 0xF795, 0xF755, 0x0047,
0x04E0, 0x1771, 0x0854, 0xFB9E, 0xFB98, 0xE44F, 0xFE4D, 0xF6E6,
0x0430, 0x0D7F, 0xF297, 0xFD1E, 0xF493, 0xEEB8, 0x0942, 0x0BE3,
0x029A, 0x0733, 0xF715, 0xEBED, 0xFF51, 0x086E, 0x085D, 0x12C4,
0xFEBC, 0xEFD1, 0xF688, 0xEA74, 0x071A, 0x0777, 0x07F3, 0x1A26,
0xFAD6, 0x07FF, 0x104E, 0x0353, 0x1C73, 0x1695, 0x00E5, 0xFA87,
0xF202, 0xE3B9, 0xF76D, 0x0099, 0xF851, 0xFB44, 0xEEC6, 0xE0C8,
0xEFF8, 0xEE1C, 0x0379, 0x1005, 0x01E0, 0x1868, 0xFCC7, 0xFE89,
0x1300, 0x0449, 0x1694, 0x1215, 0x024E, 0xF131, 0xFCE7, 0xF6F1,
0x0598, 0x1C05, 0x077B, 0x088D, 0xF7D8, 0xED30, 0xF544, 0xF85C,
0x00D8, 0x0B80, 0xF4C9, 0xFCC5, 0xF613, 0xE513, 0x0F65, 0x006D,
0x094B, 0x09DC, 0xF861, 0xED90, 0xFC7A, 0x08AC, 0x02CA, 0x1FF1,
0xFC23, 0xFBB6, 0xF471, 0xE87B, 0x04A0, 0xFDBF, 0x0D1B, 0x1278,
0xFF4A, 0x03C6, 0x0E74, 0xFD92, 0x1E70, 0x1818, 0x01CE, 0x05D8,
0xEC34, 0xE90C, 0xF25B, 0x02DD, 0xF74D, 0x0305, 0xF119, 0xE0E2,
0xF0E7, 0xE1DB, 0x04FC, 0x0460, 0x065B, 0x1771, 0xFA9A, 0x0270,
0x0DAC, 0x066E, 0x1644, 0x1B26, 0x00C6, 0xF9C0, 0xFAB0, 0xF053,
0x06F4, 0x15A8, 0x0C2A, 0x090B, 0xFD33, 0xE759, 0xF49B, 0xF0AF,
0xFE20, 0x0CCF, 0xF350, 0x0673, 0xEFBA, 0xEB6F, 0x0B0F, 0xFF5F,
0x0BFB, 0x0BB1, 0xFA53, 0xE9B0, 0xFE2A, 0xF901, 0x05DD, 0x19BB,
0xFF35, 0x00C1, 0xF445, 0xEA89, 0xFE32, 0xFEEB, 0x08C5, 0x1A34,
0xFDA3, 0x0B60, 0x09CC, 0xF832, 0x2021, 0x0F6C, 0x0A46, 0x0328,
0xEF22, 0xE032, 0xF0FB, 0xFAA4, 0xF693, 0x0A29, 0xEF3B, 0xECC6,
0xEBB3, 0xE70D, 0xFFDD, 0x0335, 0x07CC, 0x16AB, 0xFCDB, 0xFF49,
0x0DD2, 0xF9E0, 0x1C04, 0x14D4, 0x04B3, 0xFCEF, 0xF583, 0xEE23,
0xFE62, 0x1897, 0x05CD, 0x16DF, 0xFD41, 0xEE5A, 0xF5D4, 0xE95D,
0x0000, 0x01E2, 0xFA6A, 0x0318, 0xF089, 0xE639, 0x05D7, 0xF6B8,
0x0B91, 0x10DD, 0xF6CE, 0xF26D, 0xF581, 0xF8E1, 0x01FF, 0x1D32,
0x022C, 0x0532, 0xF9DA, 0xE5D3, 0x0254, 0xF218, 0x0C37, 0x10EC,
0xFD1D, 0x0E3E, 0x009E, 0xF984, 0x180D, 0x11B2, 0x0819, 0x11F9,
0xED3E, 0xE5EB, 0xF0CD, 0xF2AF, 0xFA68, 0x07C9, 0xF5E4, 0xEB38,
0xEE21, 0xDF5F, 0xFC44, 0xF9CE, 0x0544, 0x16ED, 0xF6CE, 0x099B,
0x0390, 0xFD23, 0x1A9F, 0x1800, 0x0B0A, 0x042E, 0xFAB3, 0xE60A,
0x013E, 0x0B09, 0x05EE, 0x153B, 0xFA74, 0xF0D7, 0xEE73, 0xE904,
0xF723, 0x00FB, 0xF70F, 0x0BEB, 0xEEF0, 0xF04E, 0x058B, 0xF289,
0x1382, 0x0DCC, 0x0020, 0xF178, 0xF6D3, 0xEDCB, 0xFD05, 0x18C3,
0xFE08, 0x0D28, 0xF5A1, 0xEDAD, 0xFA52, 0xF53E, 0x0AFA, 0x10D5,
0x02E8, 0x11C4, 0x0227, 0xF77E, 0x1B04, 0x05CC, 0x0DE1, 0x0E63,
0xEA7C, 0xE533, 0xE845, 0xED98, 0xF3DA, 0x0DF2, 0xF37B, 0xF80B,
0xEDFB, 0xE458, 0xFC7E, 0xF577, 0x0C41, 0x1114, 0xFFC0, 0x0828,
0x02A2, 0xF5FB, 0x17CC, 0x1190, 0x0AE1, 0x0BD9, 0xF4C5, 0xEA79,
0xF939, 0x0AEB, 0x04A9, 0x1E5D, 0x006F, 0xF79B, 0xF3FA, 0xE5E3,
0xFA39, 0xF893, 0xFB45, 0x06B0, 0xEBED, 0xF0CC, 0xFB6E, 0xEF78,
0x0F3F, 0x10D7, 0xFFCF, 0xFCC4, 0xF6B7, 0xECF3, 0x0042, 0x1612,
0x05C1, 0x1365, 0x003E, 0xEEA4, 0xFCBE, 0xEEE8, 0x055B, 0x0A30,
0xFF86, 0x13DB, 0xFA60, 0xFC57, 0x12C6, 0x04F7, 0x13E7, 0x14D0,
0xF4BD, 0xEAC6, 0xEDC0, 0xE5DC, 0xF901, 0x0B7B, 0xF8AA, 0xFCA7,
0xEE44, 0xE312, 0xF37E, 0xF116, 0x0543, 0x11EA, 0xFF81, 0x105A,
0x0036, 0xF767, 0x1CFA, 0x0D5A, 0x1A48, 0x1157, 0xFE1C, 0xEAAF,
0xF9C5, 0x01C6, 0x0034, 0x1FA9, 0xFC72, 0xFF70, 0xF0CF, 0xE931,
0xF38D, 0xF7BD, 0xFE92, 0x0AF8, 0xF583, 0xF588, 0xFD7D, 0xE8AA,
0x1A23, 0x0E70, 0x0AAC, 0x01B2, 0xF235, 0xEA86, 0xF960, 0x13E3,
0xFE86, 0x1A55, 0x013E, 0xF6D1, 0x0004, 0xEE20, 0x0589, 0x085A,
0x0B68, 0x1873, 0xFE7A, 0xFC32, 0x1471, 0x05DB, 0x1BE2, 0x18AE,
0xEAF2, 0xEC53, 0xE508, 0xEB2C, 0xF3D6, 0x0E20, 0xF675, 0xFB3A,
0xF7E8, 0xDE22, 0xF56B, 0xED29, 0x089C, 0x134A, 0x03C1, 0x137F,
0x0D30, 0x041E, 0x2E97, 0x1745, 0x0CD5, 0x0D77, 0xF2C5, 0xF291,
0xFC19, 0x0985, 0xF90D, 0x0C64, 0xF9BC, 0xEE4C, 0xEF49, 0xE520,
0xECC4, 0xF35A, 0xF5EF, 0x115D, 0x0A9E, 0x0BB9, 0x2710, 0xFCA6,
0x11EA, 0x07CA, 0xF488, 0xFD62, 0xFA0E, 0xF8E0, 0xF613, 0xFA82,
0xEC15, 0xF78F, 0xEFFF, 0xF3CA, 0xF59F, 0xEB2D, 0x05F5, 0x18CD,
0x24FF, 0x34B6, 0x32BD, 0x0F5D, 0x20C7, 0x06B3, 0xFF76, 0x0D9E,
0xE6C2, 0xF6C6, 0xDF84, 0xD969, 0xDB5A, 0xE682, 0xD9AB, 0xF117,
0xE340, 0xDD22, 0x092F, 0x0685, 0x336E, 0x35B4, 0x3106, 0x1B5F,
0x1CF6, 0xFF8D, 0x0EE6, 0x0CC8, 0xF845, 0x08DA, 0xE107, 0xE22D,
0xDF94, 0xEA96, 0xE3D7, 0xFEB2, 0xE420, 0xF2C7, 0x0DBA, 0x0659,
0x33A2, 0x235B, 0x1CAA, 0x15F4, 0x0966, 0xF67F, 0x0433, 0xF81F,
0xE9D4, 0xF83A, 0xD558, 0xE439, 0xE10C, 0xE88D, 0xF127, 0xF3BC,
0xF060, 0x02A8, 0x149B, 0x12EE, 0x46BE, 0x205F, 0x2DFE, 0x21FF,
0x0234, 0x0DDE, 0xFBF1, 0x027B, 0xEA7D, 0xF02D, 0xD561, 0xEE2C,
0xDE95, 0xEEC1, 0xF23B, 0xDEDE, 0xFD4D, 0xFCBC, 0x0CAC, 0x1038,
0x2853, 0x0A48, 0x275A, 0x11AB, 0xFF9E, 0x13AF, 0xE63B, 0x0002,
0xDE56, 0xDE36, 0xE4C4, 0xEF13, 0xFF2B, 0x018C, 0x0EB9, 0xF163,
0x1AC8, 0x0AA8, 0x1FD3, 0x27CE, 0x18CF, 0x177A, 0x1234, 0x07B1,
0xF558, 0x1057, 0xD19F, 0xF584, 0xC949, 0xCDBE, 0xE369, 0xDC6B,
0x04A6, 0xF2CF, 0x138A, 0xFCBB, 0x299F, 0x0B11, 0x2F37, 0x22FE,
0x0BE2, 0x1DE9, 0xFA15, 0x0604, 0xFF24, 0x1211, 0xEA46, 0x0022,
0xD1B5, 0xE4F0, 0xE7B5, 0xE985, 0x0FB3, 0xF318, 0x1AB1, 0x0BBE,
0x1D4B, 0x0E7F, 0x214C, 0x0BA0, 0x02FA, 0x0A73, 0xDCCB, 0xFE5F,
0xE414, 0xFA1C, 0xF2F3, 0xF06D, 0xE779, 0xF063, 0xE9CB, 0xEB85,
0x09E8, 0xF140, 0x277C, 0x1089, 0x2CEF, 0x1D69, 0x2301, 0x1284,
0x09DB, 0x087C, 0xE50F, 0x12AD, 0xDD89, 0x00CC, 0xF046, 0xEC6C,
0xF140, 0xF600, 0xEA26, 0xEC91, 0xFC79, 0xF0C1, 0x1C0F, 0x0033,
0x21AD, 0x0BA2, 0x11AD, 0x089A, 0x04C8, 0xFBD8, 0xF3CA, 0x089C,
0xE229, 0xFFCD, 0xEC3B, 0xF5D2, 0x0921, 0xFDC8, 0x0D8E, 0x01CF,
0x022F, 0x0D0A, 0x10CF, 0x0C83, 0x1FD7, 0x0CFE, 0x0A75, 0x0594,
0xEF41, 0xF75E, 0xE86E, 0xEEE5, 0xE765, 0xEB7F, 0xE374, 0xF599,
0xF5C1, 0xF158, 0x1605, 0xFE60, 0x11B5, 0x1354, 0x071A, 0x0E78,
0x1576, 0x0931, 0x143E, 0x02F0, 0x02CD, 0x017D, 0xF384, 0xF11A,
0xF18A, 0xF2BD, 0xF3F6, 0x0961, 0xF599, 0x01EC, 0x0C5D, 0x04D8,
0x105B, 0x0D5F, 0xFE34, 0x0998, 0x02B7, 0xFD55, 0x0860, 0xF400,
0xFC37, 0xF072, 0xEBFC, 0xE570, 0xF025, 0xF25C, 0xFCF0, 0x0085,
0xFBFA, 0x08B2, 0x0B0A, 0x10E2, 0x21F4, 0x11C4, 0x1B0E, 0x16BA,
0x0661, 0x0CD9, 0x011B, 0x0698, 0xFD82, 0xF4BF, 0xEA79, 0xE93C,
0xDEE0, 0xF471, 0xEA46, 0xECB9, 0xFFA8, 0xFD08, 0x08D6, 0x0973,
0x1109, 0x04A1, 0x1DF9, 0x0B03, 0x0EE8, 0x099A, 0xF6EF, 0x083C,
0xEEC3, 0xF230, 0xEFC0, 0xEF41, 0xF3DE, 0xFE30, 0xFA46, 0xFA9F,
0x11F3, 0x0A41, 0x1DB5, 0x179C, 0x1522, 0x12D6, 0x13AD, 0x08C3,
0x03AB, 0x08A4, 0xE58A, 0xFD2F, 0xD5F9, 0xE2D9, 0xDFE7, 0xE3F6,
0xF160, 0xE807, 0x00BF, 0xF791, 0x1C41, 0x0927, 0x2AEA, 0x0F1C,
0x1BC7, 0x163C, 0x0A35, 0x0AE3, 0x06B3, 0x0D30, 0xF647, 0x049E,
0xD6C1, 0xF2C0, 0xD80C, 0xF228, 0xF7D7, 0xEEFF, 0x1309, 0x03CA,
0x1B4E, 0x0CCF, 0x1C5F, 0x0332, 0x19E8, 0x0414, 0xFF5B, 0x030A,
0xE8DF, 0xF89C, 0xE658, 0xEE62, 0xDEA2, 0xF668, 0xDB20, 0xF07A,
0xF368, 0xF5D2, 0x23FA, 0x0F31, 0x37AC, 0x15A3, 0x270C, 0x148A,
0x1BBC, 0x0C3F, 0x03BB, 0x0EC0, 0xE0AC, 0xFBE1, 0xD476, 0xE777,
0xD91E, 0xF5EA, 0xDF34, 0xED0F, 0xF351, 0xF189, 0x1B14, 0x04B5,
0x2F91, 0x068B, 0x2223, 0x0857, 0x0E93, 0x05C9, 0xFC31, 0x018E,
0xDEAA, 0xF34B, 0xCFB6, 0xEECB, 0xE99A, 0xF7C5, 0x0432, 0x04DD,
0x0DEB, 0x0F50, 0x18F9, 0x103E, 0x247F, 0x1421, 0x1D91, 0x09A2,
0xF86F, 0x00FA, 0xDFA1, 0xED75, 0xDC4F, 0xDC9D, 0xD5D0, 0xEB53,
0xE5F6, 0xE8AE, 0x0D38, 0xFF63, 0x2298, 0x1AEE, 0x18A9, 0x10CF,
0x0D94, 0x0EDC, 0x0FC8, 0x0A61, 0x02D0, 0x0297, 0xE73D, 0xEE60,
0xE206, 0xEA91, 0xEF64, 0xFA53, 0xF895, 0xF93F, 0x0E1F, 0x0A20,
0x1EF9, 0x1BCF, 0x0DD5, 0x1136, 0xF96C, 0xFA00, 0xF304, 0xF64E,
0xF21C, 0xEE49, 0xE9C3, 0xDB13, 0xE3AC, 0xE9F8, 0xF83F, 0xF3FD,
0x09B4, 0x042F, 0x14C6, 0x19D8, 0x27AB, 0x1F97, 0x1E1B, 0x21CB,
0xFBCB, 0x0856, 0xE65E, 0xFC8A, 0xE946, 0xF118, 0xED86, 0xE385,
0xE3F3, 0xEC0C, 0xEC72, 0xEB2E, 0x0D46, 0x0116, 0x1DD9, 0x1384,
0x1A16, 0x0F9F, 0x14E1, 0x0C7E, 0xFF13, 0x052B, 0xE366, 0xF924,
0xDDDD, 0xE660, 0xEAF5, 0xEDC6, 0xFCF3, 0xF598, 0x040D, 0xFB8C,
0x139E, 0x1419, 0x267F, 0x1DF9, 0x1AFA, 0x1977, 0x06F4, 0x0748,
0xF227, 0x019C, 0xDC28, 0xF063, 0xD449, 0xD80A, 0xDD8A, 0xE33F,
0xF979, 0xE992, 0x0FB0, 0xFB2A, 0x166B, 0x0D6D, 0x1DF1, 0x1549,
0x19AF, 0x181B, 0x03A3, 0x08C5, 0xF920, 0x05BF, 0xF54D, 0xF8E3,
0xE377, 0xF153, 0xDFE0, 0xF298, 0xF991, 0xF55A, 0x16D8, 0x0A93,
0x155C, 0x0AAB, 0x0520, 0x0859, 0x0A89, 0x05C0, 0x02B4, 0xFFB0,
0xF0CF, 0xF40F, 0xF2B3, 0xE5D0, 0xECE6, 0xF44B, 0xE63A, 0xF3EF,
0xF45A, 0xFBFE, 0x13A2, 0x0EBC, 0x2576, 0x10D8, 0x1678, 0x1542,
0x08E9, 0x0D23, 0x0254, 0x0ADF, 0xF528, 0xF74E, 0xE9B7, 0xE920,
0xE35D, 0xF478, 0xE2EE, 0xF096, 0xF175, 0xF96E, 0x0BA6, 0x0050,
0x1B52, 0x0568, 0x1CA8, 0x07AB, 0x0A1B, 0x0370, 0xF655, 0x0246,
0xF394, 0xF2BB, 0xE9AB, 0xF4DA, 0xEE70, 0xF829, 0x009F, 0x0513,
0x08B7, 0x1571, 0x119C, 0x0D2A, 0x1653, 0x10C4, 0x197B, 0x0789,
0x01DA, 0xFD39, 0xDE1E, 0xEF23, 0xE071, 0xE278, 0xE71B, 0xEC1A,
0xEA32, 0xE77C, 0x0482, 0xFF76, 0x1C97, 0x188D, 0x1863, 0x1309,
0x0CCE, 0x109D, 0x0D6C, 0x08C6, 0x0703, 0x0088, 0xF062, 0xF2B0,
0xE09E, 0xF4B7, 0xE971, 0xF573, 0xF523, 0xF562, 0x0690, 0x0CF4,
0x1F39, 0x1712, 0x1397, 0x1562, 0x0026, 0x021E, 0xFBD3, 0xF5F0,
0xF570, 0xECA9, 0xF26F, 0xE10A, 0xE50C, 0xEF34, 0xE571, 0xED2A,
0xFBE2, 0xFE9C, 0x12AC, 0x1971, 0x2AB2, 0x1EBE, 0x2832, 0x2735,
0x0CAC, 0x14C5, 0xF3AD, 0xFD55, 0xE9AF, 0xEA40, 0xEADE, 0xE6FD,
0xE3F5, 0xE9DD, 0xDF05, 0xE426, 0xF5D5, 0xFCF7, 0x1B93, 0x1045,
0x250D, 0x143C, 0x1F3A, 0x15DB, 0x1103, 0x1172, 0xECEE, 0xF9F8,
0xDADC, 0xE1B0, 0xDFFC, 0xEF06, 0xF267, 0xEEB8, 0x014E, 0xF853,
0x09EA, 0x13C0, 0x2378, 0x1A36, 0x24E5, 0x1D2A, 0x11F8, 0x1228,
0x0194, 0x0A77, 0xE0EA, 0xEEF4, 0xCBF3, 0xD7BD, 0xD5B1, 0xE2E7,
0xF3E3, 0xE351, 0x109A, 0xF8E7, 0x1DB0, 0x0F4F, 0x2034, 0x15F0,
0x1849, 0x19A5, 0x08BE, 0x1286, 0xF922, 0x07F8, 0xEDBA, 0xF683,
0xDC85, 0xF600, 0xDCCC, 0xEDD5, 0xFAA9, 0xF05C, 0x16DD, 0x09B2,
0x23BF, 0x0C25, 0x1260, 0x0B5B, 0x00A9, 0x04D2, 0xFC8D, 0x01E5,
0xEACE, 0xF095, 0xE60D, 0xE52F, 0xE962, 0xF914, 0xEA7F, 0xF087,
0xFB75, 0xFADA, 0x1763, 0x12F1, 0x2CEA, 0x1563, 0x1FAE, 0x14C0,
0x028B, 0x0C7C, 0xF320, 0x0741, 0xE802, 0xF107, 0xE0A6, 0xEB2C,
0xE780, 0xF33D, 0xF1A8, 0xF16B, 0xFB5C, 0xFDBE, 0x16B2, 0x0722,
0x261E, 0x0F03, 0x1ACE, 0x062C, 0x04FB, 0x0090, 0xE87B, 0xFBB0,
0xDE9E, 0xEDC8, 0xE062, 0xF742, 0xEF40, 0xF387, 0x0A6D, 0x02D1,
0x1450, 0x1A17, 0x1D19, 0x15B4, 0x1D9B, 0x151D, 0x0E85, 0x0777,
0xFA61, 0xFB2D, 0xDC39, 0xE849, 0xD037, 0xE2E2, 0xE169, 0xED2E,
0xF811, 0xE82E, 0x0EC8, 0xFBEB, 0x24D6, 0x1535, 0x220A, 0x1E56,
0x0EF7, 0x1575, 0x02AE, 0x0D0D, 0xF63B, 0x024F, 0xEAA3, 0xED49,
0xDCE0, 0xF5F1, 0xE520, 0xF1BC, 0x01DC, 0xF272, 0x12E4, 0x0316,
0x228B, 0x0C04, 0x16EF, 0x1D05, 0xFC2C, 0x0C1D, 0xF855, 0xFEA2,
0xF0C2, 0xF28B, 0xE857, 0xE38A, 0xE60C, 0xEC64, 0xEC36, 0xE857,
0x0193, 0xFB16, 0x17D6, 0x0E2E, 0x2681, 0x15FE, 0x1F9F, 0x24BE,
0x05FF, 0x1DCC, 0xF3C6, 0x0950, 0xEF06, 0xEF77, 0xE6BD, 0xEBC7,
0xE423, 0xE419, 0xED74, 0xE06B, 0xFB28, 0xF7C7, 0x19CB, 0x0727,
0x25C5, 0x1796, 0x1606, 0x1370, 0x082F, 0x1003, 0xF2C8, 0x05A8,
0xE6C5, 0xEE43, 0xE522, 0xF1BA, 0xEC66, 0xE8DB, 0x014D, 0xF4E6,
0x0FC0, 0x0CCC, 0x1FB3, 0x1704, 0x2065, 0x22EF, 0x0C18, 0x123F,
0xFD07, 0x01FB, 0xE9D3, 0xF213, 0xD8FE, 0xE6C5, 0xE32F, 0xE0B2,
0xF6B6, 0xE027, 0x045F, 0xF9F1, 0x1ABA, 0x0A65, 0x230F, 0x1BEF,
0x1210, 0x225B, 0x004B, 0x16DB, 0xF75A, 0x0207, 0xF52C, 0xF0B5,
0xE8AD, 0xF853, 0xE870, 0xE70E, 0xFE81, 0xEC94, 0x0C46, 0x0885,
0x1877, 0x0E93, 0x1610, 0x1A24, 0x007E, 0x10B0, 0xF4BC, 0x05DE,
0xF42D, 0xF1D8, 0xF43E, 0xE319, 0xF105, 0xE9B4, 0xF316, 0xE4FD,
0xFEA8, 0xFBFE, 0x1100, 0x1333, 0x1C7C, 0x1F4A, 0x1796, 0x26A7,
0x06EF, 0x1920, 0xF23A, 0x0555, 0xF033, 0xEDFE, 0xF2BB, 0xE941,
0xF0E1, 0xDEB5, 0xF4D8, 0xE47D, 0xF8C1, 0xFEB6, 0x1021, 0x0956,
0x1E4D, 0x1E16, 0x0DF0, 0x1C2B, 0xFE2A, 0x0B14, 0xF118, 0xF616,
0xEB7A, 0xED56, 0xEE00, 0xF4BA, 0xF964, 0xE527, 0x08BA, 0xF97C,
0x0FCF, 0x13C0, 0x1667, 0x1702, 0x16EA, 0x1FDF, 0x085E, 0x1713,
0xF2B9, 0x0278, 0xE537, 0xE56F, 0xE0D3, 0xE52A, 0xECE3, 0xE847,
0x02A3, 0xE5C0, 0x0C98, 0xFCE7, 0x1A5B, 0x09C6, 0x1934, 0x1981,
0x0693, 0x1B99, 0xFC12, 0x13C9, 0xEF0D, 0x02D4, 0xECBE, 0xEF9E,
0xF141, 0xF999, 0xF69C, 0xED74, 0x0397, 0xF4D9, 0x10EB, 0x0873,
0x1D12, 0x0520, 0x0F9B, 0x10F8, 0xF41E, 0x0BE7, 0xEDFE, 0x0040,
0xF04A, 0xF35C, 0xEDEE, 0xF2B5, 0xF387, 0xF3B1, 0xFDE5, 0xE803,
0x0045, 0x0209, 0x10C4, 0x1446, 0x20A5, 0x1120, 0x147E, 0x114B,
0x002E, 0x134F, 0xEE17, 0x05BC, 0xED29, 0xEF75, 0xF180, 0xF9E5,
0xF230, 0xEE51, 0xF63C, 0xE656, 0xF7B6, 0xFC03, 0x0EC7, 0x066F,
0x1F03, 0x107C, 0x0E33, 0x04AB, 0xFDED, 0x0162, 0xF00F, 0xFEB1,
0xE6FE, 0xF880, 0xECDA, 0x0122, 0xF814, 0xF3FC, 0xFD57, 0xFBCA,
0x097E, 0x0B29, 0x1A4B, 0x0EC4, 0x158A, 0x1167, 0x0760, 0x04B2,
0xFA8B, 0xF7C5, 0xEB0C, 0xEE91, 0xDD5A, 0xF84B, 0xE863, 0xF20A,
0xFF93, 0xEC16, 0xFF19, 0xFF13, 0x0BBC, 0x04B3, 0x1B11, 0x0DB5,
0x0AA8, 0x0DF8, 0xFC8C, 0x0E00, 0xFA31, 0x00D6, 0xF84C, 0xF489,
0xF160, 0x06CF, 0xF23C, 0xF84C, 0xFCC4, 0xF23E, 0x044A, 0xFFBD,
0x0E14, 0x057D, 0x0947, 0x08A9, 0xF875, 0xFB75, 0xF264, 0xFF2B,
0xF79E, 0xFC25, 0xFAD0, 0xF509, 0xF943, 0xF4EF, 0xFDBE, 0xF4AD,
0xFA38, 0x030D, 0x0394, 0x0728, 0x1674, 0x121C, 0x0AD2, 0x13D8,
0xFCB7, 0x05D9, 0xF600, 0x0026, 0xF2A1, 0xFB72, 0xF6A9, 0xFA99,
0x022C, 0xEB35, 0x052F, 0xED57, 0xF052, 0xFBC0, 0xFD36, 0xFFDD,
0x178F, 0x1017, 0x0687, 0x09C1, 0xF066, 0xFA7B, 0xEE06, 0xFA56,
0xEEB9, 0x008A, 0xF23C, 0x024B, 0x0FB6, 0xF7F8, 0x19BC, 0xFB6D,
0x0873, 0x04F4, 0x0C55, 0x117D, 0x0BA7, 0x129D, 0xFCC7, 0xFBBE,
0xE9BF, 0xF272, 0xDC8B, 0xF32D, 0xDB79, 0xF397, 0xF6EC, 0xF5D7,
0x1D69, 0xFC09, 0x19F9, 0xFC2C, 0x13FF, 0xFC57, 0x1304, 0x1648,
0xFBF6, 0x13E6, 0xE910, 0xF936, 0xE616, 0xF8D5, 0xE502, 0xFFF1,
0xEC5D, 0x0387, 0x1227, 0x0074, 0x212B, 0x018C, 0x1569, 0xFFB4,
0x1A86, 0x02AB, 0x0D61, 0x0BD8, 0xE707, 0xFA07, 0xD201, 0xE9F0,
0xE147, 0xEE89, 0xEE4E, 0xFDEB, 0xFC0F, 0x0376, 0x19BF, 0x0247,
0x1C95, 0x0B4B, 0x1242, 0x0FA3, 0x1490, 0x14F8, 0x0F26, 0x09DD,
0xEFDF, 0xF566, 0xD4E4, 0xEB50, 0xE0AA, 0xEF80, 0xFDCB, 0x009F,
0x12BC, 0x00D3, 0x1059, 0x022F, 0x05BC, 0x0709, 0x0C06, 0x0B11,
0x0F52, 0x0FDB, 0xFC41, 0xFADA, 0xE2AA, 0xDE95, 0xDF91, 0xE53D,
0xF160, 0x05C9, 0x09DA, 0x0BDE, 0x1DE9, 0x0706, 0x16B0, 0x14C0,
0x0AB6, 0x19EC, 0x1010, 0x101D, 0x0356, 0x0480, 0xE215, 0xECC6,
0xDC1A, 0xD5A3, 0xF4E6, 0xE94F, 0x010E, 0x0266, 0x0D71, 0x002E,
0x1DD3, 0x06BC, 0x1077, 0x13D8, 0x0420, 0x1094, 0x00A3, 0x0B79,
0xE8A8, 0x0166, 0xD24B, 0xE740, 0xEABA, 0xECD6, 0x17F4, 0x0733,
0x27D6, 0x0AE6, 0x2415, 0x09DD, 0x0CCC, 0x0C1A, 0xFF75, 0x06D1,
0x0280, 0x0267, 0xDFE8, 0x0239, 0xBD77, 0xE8D3, 0xDB21, 0xDCB8,
0x0E6A, 0xFEA4, 0x25B6, 0x104D, 0x3520, 0x06B7, 0x26BC, 0x0D78,
0xFAF6, 0x11ED, 0xF26D, 0x01E7, 0xEEC2, 0x027D, 0xCC1A, 0xFE41,
0xCFEA, 0xEF11, 0x064F, 0xF67D, 0x249F, 0x061D, 0x2EC2, 0x1130,
0x34C4, 0x120E, 0x1128, 0x0512, 0xEA44, 0xF331, 0xE1DF, 0xF27F,
0xCC49, 0xF318, 0xCB37, 0xEA14, 0xF98E, 0xF400, 0x1918, 0x074E,
0x2CB8, 0x1409, 0x3612, 0x21CB, 0x1EFB, 0x2382, 0x053B, 0x02FD,
0xF86C, 0xEF60, 0xD87E, 0xF2AD, 0xB9C4, 0xE4CA, 0xE4DE, 0xE692,
0x1A7A, 0xFE58, 0x1E4E, 0x0B27, 0x1FCE, 0x14A9, 0x22BF, 0x1E37,
0x108B, 0x0DFB, 0xF796, 0xF43A, 0xE53F, 0xE758, 0xCF17, 0xE630,
0xDC96, 0xF16A, 0x0476, 0xFDB8, 0x2017, 0x0CC2, 0x30F0, 0x1FF1,
0x2398, 0x2E53, 0x1108, 0x1713, 0xFE27, 0xF095, 0xDE5C, 0xE993,
0xCF80, 0xE5B0, 0xE251, 0xE22E, 0xFF7F, 0xEDDD, 0x137E, 0xFE2E,
0x254E, 0x10A3, 0x2806, 0x2833, 0x167A, 0x21A0, 0xFA21, 0xFD24,
0xDDC8, 0xED02, 0xCBCF, 0xEDF1, 0xDD6E, 0xF80B, 0x0BF1, 0xFE3F,
0x2AB9, 0xFBBB, 0x2F9A, 0x06F0, 0x1CEE, 0x1D6B, 0x0DB2, 0x204E,
0x0353, 0x0303, 0xD9C5, 0xE4EF, 0xB113, 0xDC0F, 0xD10B, 0xE921,
0x0C9A, 0x0149, 0x2808, 0x089B, 0x3A66, 0xFC1B, 0x2F23, 0x1087,
0x14F0, 0x2CA6, 0xFEA3, 0x1521, 0xDD59, 0xF2B4, 0xC119, 0xE427,
0xCBF2, 0xEC17, 0xFE77, 0xFF6D, 0x24A7, 0x06EF, 0x3817, 0x0509,
0x317B, 0x0B0D, 0x17D6, 0x127B, 0x02ED, 0x0B98, 0xE364, 0xF544,
0xBF3D, 0xDD33, 0xC3AE, 0xDF5A, 0xF66F, 0xF596, 0x19BF, 0x0FE2,
0x31DF, 0x172E, 0x375F, 0x175F, 0x17B0, 0x22BC, 0x0C64, 0x15C3,
0x021D, 0xFB9C, 0xD326, 0xE3AC, 0xBD01, 0xD4F7, 0xE352, 0xE629,
0x1475, 0x0559, 0x2A9B, 0x118D, 0x234B, 0x1555, 0x1510, 0x1A86,
0x0C6B, 0x1425, 0xFF33, 0x0316, 0xE4C5, 0xE21B, 0xD10A, 0xD3DC,
0xE49C, 0xE922, 0x057F, 0x048E, 0x23F3, 0x190B, 0x317E, 0x2283,
0x1FAF, 0x264A, 0x07C3, 0x19C0, 0xF6BC, 0xFD41, 0xE2E1, 0xE761,
0xD70E, 0xD9EB, 0xEA6E, 0xD3E6, 0xFF51, 0xEB4B, 0x1A06, 0x0939,
0x3003, 0x1CB8, 0x1F42, 0x2674, 0x08CE, 0x15B6, 0xF44A, 0x090B,
0xDBD2, 0xF9A8, 0xD517, 0xE645, 0xEB37, 0xE97A, 0x083A, 0xF471,
0x2955, 0xFF5B, 0x3983, 0x13F5, 0x1F64, 0x229A, 0x03FF, 0x12FE,
0xF1A7, 0xFFE4, 0xD667, 0xF184, 0xC67A, 0xE5F0, 0xE412, 0xE5E6,
0x0DB6, 0xF211, 0x2307, 0x00CF, 0x37D6, 0x086C, 0x3410, 0x1D8E,
0x0E23, 0x2272, 0xEB47, 0x07A7, 0xD048, 0xF55C, 0xC945, 0xF22D,
0xED48, 0xF270, 0x0E8C, 0xFA03, 0x1E75, 0xFAFA, 0x2E27, 0xFD0B,
0x2FFA, 0x18C6, 0x1B54, 0x1980, 0xEEAE, 0xF8CA, 0xC96C, 0xE5A3,
0xC5C1, 0xE7BF, 0xE576, 0xEFB2, 0x0B65, 0xF909, 0x2195, 0x088D,
0x297B, 0x0E7D, 0x26D7, 0x1965, 0x1B2F, 0x2903, 0xFD07, 0x161D,
0xDE5E, 0xE669, 0xCB75, 0xD8C3, 0xD9F5, 0xE959, 0x0415, 0xF401,
0x21ED, 0x0199, 0x24F0, 0x0790, 0x156A, 0x110A, 0x1371, 0x1E59,
0x0976, 0x15A9, 0xE182, 0xF279, 0xCB2D, 0xD55C, 0xE181, 0xDD4D,
0x020D, 0xFC4A, 0x1AFF, 0x1169, 0x2450, 0x10F7, 0x1615, 0x17C7,
0x128B, 0x22AD, 0x0CBB, 0x1C3F, 0xE6D9, 0xF4CD, 0xC8A4, 0xCF97,
0xDB26, 0xD89D, 0x000C, 0xEC32, 0x1A37, 0xFD03, 0x260D, 0x0DC8,
0x1BA0, 0x1648, 0x0D31, 0x15FF, 0x02B4, 0x154B, 0xECA9, 0x06E3,
0xCE19, 0xE6C9, 0xD4B9, 0xDCCD, 0xF59F, 0xF3E5, 0x181F, 0x0DFA,
0x38EE, 0x0FE1, 0x2C95, 0x10A0, 0x0AA2, 0x1083, 0xF99A, 0x0797,
0xEAE6, 0xFB35, 0xCF8A, 0xE333, 0xCABE, 0xD8C1, 0xECC7, 0xE891,
0x1860, 0x02CA, 0x3828, 0x1599, 0x32B2, 0x198C, 0x1B9F, 0x102B,
0xFEFA, 0x0BC4, 0xE004, 0x051D, 0xCB39, 0xEFA3, 0xCBF5, 0xE1DC,
0xEC39, 0xED18, 0x12B5, 0x03FA, 0x2E47, 0x0A9C, 0x33AD, 0x1677,
0x2369, 0x1907, 0x05F7, 0xFE56, 0xE14A, 0xEB7E, 0xC946, 0xE546,
0xD170, 0xE07E, 0xEA03, 0xE6D0, 0x07ED, 0xFD12, 0x2948, 0x12B1,
0x30C6, 0x298D, 0x2512, 0x2D43, 0x0993, 0x1678, 0xE4A5, 0xFA8E,
0xD61B, 0xE10C, 0xDD7B, 0xD926, 0xE654, 0xDC07, 0xFBDA, 0xEE9C,
0x1FD2, 0x04C7, 0x296C, 0x1874, 0x1E17, 0x2B99, 0x0B5B, 0x1D03,
0xF082, 0xFA7B, 0xD87C, 0xE336, 0xDBE0, 0xD7B7, 0xF3A3, 0xDD3D,
0x00DC, 0xF3C6, 0x0FE4, 0x069A, 0x198C, 0x1C42, 0x1C0E, 0x31C1,
0x15FB, 0x2CE7, 0xF9DB, 0x0970, 0xD7A0, 0xE06C, 0xD82F, 0xD0E5,
0xF541, 0xD9BF, 0x046D, 0xE705, 0x0F3D, 0xF06C, 0x1227, 0x080D,
0x16FC, 0x23EA, 0x1793, 0x2B84, 0xFC1C, 0x11B6, 0xE0D0, 0xF203,
0xDA5B, 0xE923, 0xEB9A, 0xEA20, 0x033D, 0xF929, 0x1109, 0xFD28,
0x1895, 0x01D2, 0x1EBF, 0x1568, 0x12DC, 0x1963, 0xF8DF, 0x0A4A,
0xE48A, 0xEE07, 0xDB9C, 0xDE77, 0xE3EB, 0xE550, 0xF909, 0xF98D,
0x14D0, 0x02AE, 0x1D3A, 0x01DA, 0x1A10, 0x0D4B, 0x1976, 0x186E,
0x049A, 0x1384, 0xE48E, 0xFBEC, 0xD714, 0xE958, 0xDFAC, 0xECC3,
0xF9E0, 0x000E, 0x163B, 0x0B48, 0x163A, 0x0478, 0x1661, 0x02B9,
0x1A4E, 0x0BAF, 0x06F1, 0x043D, 0xED52, 0xEE7A, 0xE034, 0xE0E6,
0xE46C, 0xE3BB, 0xF470, 0xFA2F, 0x0A93, 0x0A28, 0x12A4, 0x15B7,
0x1612, 0x1DC7, 0x11F6, 0x1B52, 0xFE51, 0x1104, 0xF2F7, 0xFA8D,
0xF38A, 0xE660, 0xF7A2, 0xDCE7, 0xF487, 0xEA02, 0xFEC5, 0xF975,
0x0AB8, 0x0812, 0x0CAB, 0x168E, 0x0B99, 0x1556, 0xF84C, 0x0C3B,
0xF0C1, 0xF97A, 0xFDD1, 0xE9E1, 0x0217, 0xE07E, 0x00FF, 0xEC5C,
0x061D, 0x0540, 0x00AA, 0x1293, 0xFD49, 0x1F1B, 0x054F, 0x2160,
0xFBE7, 0x1169, 0xF1EB, 0xFB11, 0xFB0C, 0xE68F, 0x063C, 0xDAF2,
0x0E77, 0xE5E2, 0x0EEE, 0xF6D2, 0x00C8, 0x0258, 0xFBD4, 0x12DD,
0x0285, 0x1E05, 0xFC2A, 0x103A, 0xE80F, 0xF63F, 0xF065, 0xEF47,
0x0D83, 0xF410, 0x0CED, 0xF90D, 0x0B4A, 0x00BD, 0x0696, 0x1080,
0x017E, 0x1707, 0x0C66, 0x17C5, 0xFEDE, 0x0D1F, 0xE50D, 0xEB04,
0xE839, 0xDDAE, 0x024A, 0xE39B, 0x0E36, 0xF32F, 0x0CC7, 0xFE02,
0x073D, 0x0669, 0x05ED, 0x177A, 0x0987, 0x1BF2, 0x0331, 0x1739,
0xF519, 0x0120, 0xE4BB, 0xEB1F, 0xEEFA, 0xE94F, 0x07AF, 0xF862,
0x1111, 0x042F, 0x0E72, 0x0645, 0x05A7, 0x0AE6, 0x0362, 0x0F44,
0x04BA, 0x1399, 0xFBD6, 0x004F, 0xED01, 0xE234, 0xEE31, 0xDD66,
0x0441, 0xF197, 0x13A2, 0x01A1, 0x0601, 0x037D, 0xFD67, 0x0E52,
0x0596, 0x1E3B, 0xFE7E, 0x2246, 0xF296, 0x13D4, 0xF37B, 0xF8F1,
0xFC9D, 0xE489, 0x0CC9, 0xE91A, 0x1719, 0xF59E, 0x06D0, 0xFB2B,
0xF9BA, 0xFE1F, 0xF922, 0x0752, 0xF31D, 0x14C0, 0xF234, 0x1022,
0xF656, 0xFE59, 0x012C, 0xEA53, 0x0DD0, 0xEB00, 0x1B7D, 0xFB98,
0x16E5, 0x09B3, 0xFEEF, 0x1236, 0xEF87, 0x0FAB, 0xE5DC, 0x1244,
0xEAC4, 0x10E4, 0xFBDB, 0x01A9, 0x05A3, 0xE9FB, 0x0AE6, 0xE27B,
0x19BF, 0xF0ED, 0x1AFE, 0xFEFD, 0x08C6, 0x06C8, 0xFABD, 0x088C,
0xE822, 0x0D6F, 0xE089, 0x0B8B, 0xEDD7, 0x002A, 0xFD2D, 0xF620,
0x0EDD, 0xF7FD, 0x1977, 0x0292, 0x1060, 0x0A27, 0x0A7A, 0x107F,
0x0B34, 0x0F73, 0xFFFF, 0x04C7, 0xE8DB, 0xFBB8, 0xE220, 0xF7F6,
0xF61D, 0xEE4F, 0x03CD, 0xEA2D, 0x0CF6, 0xF614, 0x0E1C, 0x05DA,
0x0B16, 0x0C13, 0x0D88, 0x0ED7, 0x03DC, 0x0E1F, 0xF518, 0x004B,
0xEED3, 0xFE92, 0xF404, 0x043A, 0xF7DF, 0xFEF0, 0x0159, 0xFA7C,
0x07C1, 0x0412, 0x0A52, 0x0983, 0x1196, 0x0306, 0x0592, 0x042E,
0xFA1C, 0xFC7A, 0xF4A6, 0xF069, 0xF355, 0xF131, 0xFEFC, 0xFB71,
0x04BD, 0x005F, 0xFF8E, 0x0131, 0xFC96, 0x05DE, 0x04F8, 0x0822,
0x09A9, 0x1283, 0x0064, 0x131D, 0xF568, 0x01E3, 0xF365, 0xF866,
0x00F0, 0xFC5F, 0x1583, 0xFCFB, 0x0DA3, 0xF9D6, 0xF6EE, 0xF9C0,
0xFA8B, 0xF9C7, 0x02B1, 0x00CD, 0xF8EC, 0x08E6, 0xF3E2, 0x049B,
0xFA6F, 0xF85E, 0x006A, 0xF9A3, 0x0D98, 0x013C, 0x10DD, 0x0525,
0x07C4, 0x0683, 0xFE2C, 0x083E, 0xF61D, 0x0DD1, 0xF908, 0x0CEF,
0xF7EF, 0x08EC, 0xFB9C, 0xFBA9, 0x0350, 0xEFE9, 0x090C, 0xF2AF,
0x0E7A, 0xFDDB, 0x08C6, 0xFF2A, 0x004A, 0xF61C, 0xF9FC, 0xFFBF,
0xFD1A, 0x0D51, 0xFF5E, 0x0C58, 0xF893, 0xFF92, 0xF8F4, 0xFC3D,
0x0320, 0x054C, 0x079C, 0x0DF0, 0x0349, 0x0FB1, 0x005C, 0x020B,
0xFFFA, 0xFC1B, 0x0910, 0xFF49, 0x103A, 0x0150, 0x01C9, 0xFABA,
0xF732, 0xF05A, 0xFB67, 0xF62D, 0xF4AD, 0x0572, 0xF661, 0x0B18,
0x0272, 0x032F, 0x00B3, 0xFD8D, 0x0344, 0xFE59, 0x121E, 0x04C8,
0x1749, 0x0ABC, 0x04A8, 0x0898, 0xF4DA, 0x028F, 0xEDAB, 0x082B,
0xED9B, 0x0E32, 0xFC24, 0x01A6, 0x048B, 0xF3DC, 0x0619, 0xF0E9,
0x0E94, 0xF85C, 0x1A27, 0xFDD5, 0x0EE7, 0xFEFA, 0xFBE4, 0xFD69,
0xF1EA, 0x0673, 0xE9E7, 0x0DFC, 0xEEE1, 0x0216, 0xF71A, 0xFFA1,
0x0488, 0x0363, 0x13B3, 0x07E2, 0x1501, 0x0A7D, 0x1029, 0x08C9,
0x0869, 0x01C9, 0xFBA2, 0xFC05, 0xF236, 0xFF7F, 0xEE3E, 0xF73D,
0xF252, 0xF033, 0xFEC1, 0xF7A5, 0x07C3, 0x01D8, 0x1183, 0x039D,
0x16AA, 0x057E, 0x0B95, 0x08AF, 0xF6ED, 0x0380, 0xEDE9, 0x02A4,
0xF173, 0x03C2, 0xF493, 0x01EE, 0xFC05, 0x0330, 0x061C, 0x098E,
0x10EF, 0x0891, 0x188E, 0xFFCF, 0x151F, 0xF9AB, 0xFAF5, 0xF9BC,
0xE7BA, 0xF8FB, 0xEAA4, 0xF28A, 0xEAC8, 0xF2F3, 0xFAAF, 0xFBE3,
0x0FD5, 0x0CB6, 0x15E0, 0x1103, 0x1565, 0x04BA, 0x0FA4, 0x0202,
0xFCE6, 0x0A85, 0xEB3C, 0x0915, 0xE403, 0xFEB6, 0xDDDD, 0xFA15,
0xF647, 0xF735, 0x1A0A, 0x022A, 0x21B9, 0x0AE0, 0x1BBA, 0xFF0A,
0x1416, 0xF433, 0xFF39, 0xFB19, 0xE232, 0xFFC5, 0xDAE0, 0xF3CF,
0xDF24, 0xF3F2, 0xEC71, 0xFBA3, 0x0DAA, 0x03AF, 0x23B3, 0x110E,
0x246D, 0x1582, 0x1D6D, 0x0C7C, 0x0336, 0x092E, 0xE710, 0x07F4,
0xDE84, 0xF4E2, 0xDC26, 0xE74F, 0xE998, 0xE915, 0x07BD, 0xF619,
0x1E4A, 0x0845, 0x23C8, 0x0A51, 0x1BD8, 0x018D, 0x04DF, 0x0636,
0xF0B4, 0x0C13, 0xE7AC, 0xFCAB, 0xDC6C, 0xE9D7, 0xE14E, 0xEB8B,
0xFC51, 0x00EE, 0x197F, 0x15B5, 0x222B, 0x1D09, 0x1927, 0x0E72,
0x08AF, 0x02E7, 0xF765, 0x0508, 0xF0F2, 0xF668, 0xE542, 0xE2E7,
0xE2E1, 0xDD5E, 0xF8E9, 0xEDA5, 0x0A04, 0x0815, 0x149C, 0x145C,
0x1C22, 0x0F56, 0x0AD8, 0x0A5B, 0xF49E, 0x0814, 0xEE24, 0xFD5A,
0xEA2E, 0xF571, 0xF01A, 0xF35F, 0xFD41, 0xFB96, 0x07D5, 0x0AE4,
0x1264, 0x1336, 0x1B25, 0x099E, 0x0E50, 0xFB63, 0xF3CE, 0xFA0B,
0xEB02, 0xF47F, 0xE7F9, 0xE8D6, 0xEB93, 0xE6D5, 0xFEF4, 0xF74F,
0x0F88, 0x0E43, 0x14C7, 0x18B8, 0x15C2, 0x0ED8, 0x0A59, 0x05D6,
0xF3A5, 0x0669, 0xE88E, 0xFF11, 0xE493, 0xF720, 0xE9AA, 0xF1A2,
0x0281, 0xF46E, 0x1887, 0x0406, 0x1D00, 0x0F37, 0x1A67, 0x07C6,
0x0AD6, 0xFE8E, 0xF340, 0xFC36, 0xE1D7, 0xF46A, 0xD821, 0xECD7,
0xE5D2, 0xEDEA, 0x0328, 0xFBFE, 0x17CB, 0x0A8D, 0x1C8D, 0x13F9,
0x1A69, 0x15BC, 0x12F2, 0x1261, 0xFD39, 0x0E27, 0xE1C4, 0xFD07,
0xD7D1, 0xEB43, 0xE8A1, 0xE430, 0x00BA, 0xE9BF, 0x146E, 0xFA8E,
0x1C2C, 0x0A0D, 0x17CA, 0x09B3, 0x0BE9, 0x05FF, 0xFE7D, 0x093C,
0xF1B0, 0x037E, 0xDF3A, 0xF6AD, 0xE326, 0xEAED, 0xFD7E, 0xF12F,
0x101D, 0x0773, 0x1A1B, 0x1629, 0x1577, 0x1424, 0x02BB, 0x0D68,
0xFD78, 0x074F, 0xFD20, 0xFA60, 0xED2E, 0xEE36, 0xEB73, 0xE49C,
0xFD9D, 0xE84C, 0x0C16, 0xFBF8, 0x1267, 0x0BD2, 0x0D61, 0x0AF9,
0xFC08, 0x0932, 0xF54C, 0x0CFF, 0xFAED, 0x02DD, 0xF2C8, 0xF52B,
0xF1D4, 0xF4CB, 0x098D, 0xFFA2, 0x17FB, 0x0C64, 0x1034, 0x129E,
0x0A6B, 0x0797, 0xFEF3, 0xFBF7, 0xED07, 0xF9AC, 0xEBEE, 0xF123,
0xF03D, 0xEC98, 0xF757, 0xEBB2, 0x0883, 0xF577, 0x1AD7, 0x0DBD,
0x1E60, 0x1C0A, 0x120A, 0x1296, 0xFAC8, 0x01B1, 0xE411, 0xFDC0,
0xDFFE, 0xFBA2, 0xE610, 0xF7AB, 0xF421, 0xF760, 0x0945, 0xFDB8,
0x208F, 0x0B9D, 0x2D60, 0x15E4, 0x1F7A, 0x0C89, 0x0407, 0xF7EC,
0xE8BA, 0xEECC, 0xD454, 0xEBFA, 0xD43F, 0xEA93, 0xEA9A, 0xEE58,
0x04E4, 0xFD1B, 0x1E40, 0x157E, 0x3300, 0x21A2, 0x2A1F, 0x17CC,
0x0931, 0x0A69, 0xF2C7, 0x01BE, 0xDF46, 0xF748, 0xCA02, 0xEDAA,
0xDBFC, 0xE99E, 0x06F5, 0xF0D8, 0x1F27, 0x036F, 0x29B2, 0x1450,
0x2B25, 0x1187, 0x1475, 0x03D8, 0xF680, 0xF8C9, 0xE1C1, 0xF264,
0xD08A, 0xF2AE, 0xDB21, 0xF226, 0xFCFB, 0xF881, 0x16D0, 0x0C02,
0x267D, 0x1D78, 0x2776, 0x1DB4, 0x1246, 0x1357, 0xF9A7, 0x01E3,
0xEBF5, 0xECD6, 0xDC39, 0xE6C2, 0xDD37, 0xE954, 0xFAA0, 0xEE93,
0x1455, 0x0061, 0x2081, 0x14CE, 0x20DF, 0x14BC, 0x0DA1, 0x09E5,
0xF6DD, 0x0345, 0xEC86, 0xF6AE, 0xE495, 0xEBC0, 0xE1C2, 0xEF3A,
0xF432, 0xFEB4, 0x151E, 0x14D9, 0x266E, 0x242F, 0x1D37, 0x1C49,
0x091E, 0x08CC, 0xFB9E, 0xF6B9, 0xF03D, 0xE504, 0xE19F, 0xDC75,
0xE2F4, 0xE103, 0xF5C4, 0xF280, 0x0ED8, 0x0CD8, 0x22D0, 0x2444,
0x23A5, 0x264F, 0x0F4E, 0x1590, 0xF928, 0xFFCB, 0xEC29, 0xECBD,
0xE06E, 0xE4F2, 0xE3A9, 0xE7BF, 0xF410, 0xFA9F, 0x07E7, 0x11BA,
0x2289, 0x1DCE, 0x2C71, 0x1D6B, 0x1751, 0x1054, 0xFCC6, 0xF9D5,
0xEC69, 0xE245, 0xE11C, 0xD9C6, 0xE240, 0xDD6F, 0xEE7C, 0xEE69,
0x0181, 0x1057, 0x1C2E, 0x27C1, 0x2A82, 0x24BE, 0x1B1E, 0x1851,
0xFFAE, 0x09E1, 0xEED3, 0xF750, 0xE58E, 0xE82C, 0xE4AA, 0xE161,
0xEFB7, 0xE80D, 0x0240, 0x0086, 0x179F, 0x17E9, 0x2197, 0x171B,
0x1785, 0x0D15, 0x05DA, 0x0023, 0xF279, 0xEEB1, 0xE582, 0xE8B8,
0xEB46, 0xE9E1, 0xF686, 0xF14D, 0x0194, 0x077C, 0x0FBF, 0x2017,
0x16BB, 0x234C, 0x0FB0, 0x191C, 0x0453, 0x0B55, 0xF4A2, 0xF31C,
0xE76A, 0xE05F, 0xF547, 0xDE29, 0x041E, 0xE820, 0x03A1, 0xFAC3,
0x0C7A, 0x1372, 0x12A1, 0x1E13, 0x080F, 0x141A, 0xFB99, 0x06DF,
0xF080, 0xF811, 0xEABC, 0xE9EA, 0xF75F, 0xE443, 0x0517, 0xEDAB,
0x0808, 0x0502, 0x0F02, 0x1F43, 0x131F, 0x29FE, 0x051E, 0x1DB0,
0xF828, 0x04A5, 0xF50D, 0xEDCF, 0xEC03, 0xDFF4, 0xF2D6, 0xD879,
0x09DC, 0xE109, 0x0E87, 0xFA60, 0x0E86, 0x14D5, 0x11B4, 0x24EC,
0x0558, 0x25C9, 0xFA73, 0x1340, 0xF5C0, 0xFAC7, 0xEB8E, 0xEBF1,
0xEF09, 0xE4A3, 0x0339, 0xECB3, 0x124F, 0x025E, 0x12A6, 0x152F,
0x0E41, 0x1B9D, 0x086B, 0x19A6, 0xFFF2, 0x093E, 0xF735, 0xEFCB,
0xEDB0, 0xE57D, 0xF3B6, 0xE281, 0x04EA, 0xE768, 0x0C82, 0xFD05,
0x1051, 0x1699, 0x12DD, 0x229D, 0x0815, 0x206E, 0xF903, 0x1246,
0xF32A, 0xFA26, 0xF286, 0xF02A, 0xFB17, 0xEFD7, 0x06C9, 0xEF16,
0x0F1C, 0xF8FE, 0x1548, 0x07AF, 0x1045, 0x10D1, 0x0345, 0x1213,
0xF650, 0x07C3, 0xEE46, 0xF48B, 0xEF88, 0xE9DA, 0xFCC9, 0xED66,
0x0F2C, 0xF7CC, 0x16BC, 0x057F, 0x183A, 0x12F3, 0x0FF7, 0x18A3,
0xF8F2, 0x1764, 0xEECF, 0x0FB5, 0xEC9F, 0xFF6E, 0xE800, 0xEE2A,
0xF946, 0xE6FD, 0x1676, 0xEFBD, 0x22EF, 0xFB00, 0x1FB1, 0x0566,
0x11BB, 0x0FEE, 0xFC1E, 0x11DC, 0xEDB2, 0x0707, 0xE2D7, 0xF73C,
0xDF71, 0xF3C3, 0xF601, 0xF32F, 0x141E, 0xF7E0, 0x2246, 0x07D6,
0x2105, 0x10D0, 0x17AB, 0x1708, 0x0255, 0x1B30, 0xEC60, 0x0B62,
0xE46D, 0xEFE0, 0xE035, 0xE396, 0xED6E, 0xE4A8, 0x0CD4, 0xEE1E,
0x2049, 0xFFF5, 0x259D, 0x0B65, 0x1E92, 0x12C8, 0x06B2, 0x1936,
0xF1B4, 0x117A, 0xE98F, 0xFC18, 0xE44A, 0xED33, 0xEA17, 0xEB1F,
0xFF40, 0xF24D, 0x158B, 0x074C, 0x23B4, 0x17BC, 0x1E6C, 0x1441,
0x08C0, 0x1035, 0xF9F9, 0x07AA, 0xF03D, 0xF036, 0xE733, 0xE29A,
0xEAB8, 0xE522, 0xFE35, 0xEE3F, 0x14A4, 0xFE10, 0x1A72, 0x0FC9,
0x13EF, 0x1AEB, 0x0858, 0x1B73, 0xFC11, 0x0E93, 0xF04D, 0xF84E,
0xE56D, 0xEC28, 0xED5B, 0xEFDF, 0x0174, 0xFB74, 0x106B, 0x0598,
0x1C97, 0x07B8, 0x19D7, 0x0964, 0x01CA, 0x0B18, 0xF3AD, 0x0400,
0xF028, 0xF099, 0xE818, 0xE27D, 0xF13E, 0xEA7A, 0x051B, 0xFDB2,
0x11E1, 0x10BE, 0x1D0E, 0x17E0, 0x1E26, 0x1426, 0x0584, 0x0F2C,
0xE7BA, 0x0476, 0xE370, 0xF6E8, 0xE93F, 0xEAE3, 0xEDDA, 0xE676,
0x0280, 0xF47B, 0x1C64, 0x0AF5, 0x263C, 0x116E, 0x20A4, 0x0D62,
0x099A, 0x0C83, 0xEF42, 0xFF26, 0xE3A6, 0xEAD2, 0xE0EC, 0xE4BC,
0xE894, 0xEB21, 0xFDB1, 0xFA0C, 0x1569, 0x0EB3, 0x227B, 0x1B7D,
0x2000, 0x1A56, 0x0F02, 0x17C0, 0xF846, 0x0C9A, 0xE463, 0xF0BF,
0xDFCC, 0xDB54, 0xEE19, 0xD999, 0xFDDB, 0xEA19, 0x0D22, 0x036A,
0x19A4, 0x1153, 0x1C8F, 0x1356, 0x1476, 0x166A, 0x016B, 0x10DB,
0xEBC8, 0xFB00, 0xE1BD, 0xE893, 0xED64, 0xE520, 0xFDB0, 0xEC73,
0x0543, 0x0137, 0x0E2D, 0x1827, 0x14AB, 0x1C61, 0x0BBD, 0x13AB,
0x0143, 0x08F8, 0xFB1A, 0xF8BE, 0xEF88, 0xE38A, 0xF053, 0xDC29,
0xFEFB, 0xEA56, 0x0A59, 0xFD50, 0x11E1, 0x0C85, 0x0DE5, 0x17A0,
0xFEBB, 0x1C51, 0xF9C4, 0x107C, 0xF8E0, 0xFB19, 0xF075, 0xED98,
0xF099, 0xE806, 0xFF00, 0xF28A, 0x0E61, 0x0523, 0x129A, 0x0D7E,
0x0F58, 0x1086, 0x03CE, 0x1007, 0xF617, 0x04A1, 0xF24A, 0xF29E,
0xEFC6, 0xE576, 0xF330, 0xE26D, 0x0588, 0xF1B7, 0x1406, 0x07DE,
0x1498, 0x10FB, 0x1213, 0x1530, 0x04B1, 0x19FF, 0xF429, 0x0F71,
0xEBB8, 0xF620, 0xE7C1, 0xEACE, 0xF39D, 0xEC41, 0x0366, 0xF071,
0x1040, 0x0080, 0x1D23, 0x0B75, 0x1C16, 0x0A9A, 0x0862, 0x0C38,
0xF30E, 0x09DA, 0xEE12, 0xFA49, 0xF0D3, 0xE8B7, 0xF3E9, 0xE71F,
0xFCA1, 0xF71D, 0x0C20, 0x09DC, 0x1647, 0x0F3E, 0x135E, 0x0E75,
0x0510, 0x1347, 0xF2BC, 0x1042, 0xEDB2, 0xFFD2, 0xF0F9, 0xEDFA,
0xF8B3, 0xE6B8, 0x09D3, 0xEDC0, 0x1237, 0xFCD0, 0x10C8, 0x0832,
0x0E6B, 0x081B, 0x02E8, 0x0951, 0xF790, 0x0DAB, 0xF079, 0x058C,
0xEEA3, 0xF577, 0xFC55, 0xED9F, 0x0DF9, 0xF7D9, 0x15F4, 0x0609,
0x0E24, 0x08D0, 0x026A, 0x0A3A, 0xFCC9, 0x0DC9, 0xF455, 0x0973,
0xEB72, 0xFE92, 0xF0E2, 0xF58D, 0x04D9, 0xEB7C, 0x1478, 0xEDAE,
0x1B18, 0x0093, 0x176F, 0x08A0, 0x0ACA, 0x06A3, 0xF79F, 0x06B2,
0xE926, 0x08DA, 0xE9E8, 0x0720, 0xEAD6, 0xFC8C, 0xF732, 0xF551,
0x0F48, 0xFA02, 0x1DCB, 0x0927, 0x1F2F, 0x0DFA, 0x0E40, 0x04FB,
0xF7D1, 0x01D3, 0xED18, 0xFBC9, 0xEB77, 0xF4A8, 0xEB3D, 0xF5BE,
0xF345, 0xF5E4, 0x0C19, 0xF98F, 0x2421, 0x0984, 0x2725, 0x13BF,
0x12DC, 0x0C06, 0xF871, 0x04E9, 0xEA15, 0x0129, 0xE471, 0xF7EF,
0xE3AE, 0xF1B8, 0xEB77, 0xF84A, 0x052A, 0x0452, 0x235C, 0x0C53,
0x2A53, 0x0FE0, 0x1DDF, 0x0A61, 0x03E9, 0xFFDA, 0xEDD6, 0xF713,
0xE41C, 0xF0DD, 0xE27F, 0xF025, 0xF268, 0xF368, 0x039B, 0xFE71,
0x1653, 0x1160, 0x29CE, 0x19C5, 0x21A8, 0x1199, 0xFFEB, 0x05E2,
0xE502, 0xFD21, 0xDFDF, 0xF7BE, 0xE3EB, 0xF311, 0xF0E3, 0xF1CD,
0x0485, 0xFB81, 0x1A33, 0x08B0, 0x2CC9, 0x0CC8, 0x28A8, 0x0A73,
0x09C5, 0x049C, 0xE826, 0xF8D8, 0xDF90, 0xF4E4, 0xE54A, 0xF883,
0xECBE, 0xF8B3, 0x02D1, 0x00B5, 0x18DA, 0x106F, 0x2221, 0x140E,
0x1F03, 0x09AD, 0x08EF, 0x0450, 0xF032, 0xFEA0, 0xDE2C, 0xF321,
0xDCF8, 0xF037, 0xF1FA, 0xF4D2, 0x0905, 0xFE3C, 0x1C4B, 0x0B20,
0x2569, 0x1112, 0x1F89, 0x0ABB, 0x0ECC, 0x029B, 0xF8EC, 0xF937,
0xDF5C, 0xF317, 0xD613, 0xF8A0, 0xEA66, 0xF81E, 0xFE2E, 0xFD79,
0x1010, 0x12D6, 0x2015, 0x1B40, 0x2092, 0x1129, 0x10B9, 0x01A5,
0xFC60, 0xF52C, 0xEECB, 0xEBEB, 0xDFDD, 0xE9F5, 0xE726, 0xF308,
0xFF33, 0xFC53, 0x0E35, 0x09A5, 0x1F51, 0x18ED, 0x225C, 0x1982,
0x0CEC, 0x0CB5, 0xFB69, 0xFAC0, 0xF386, 0xEFC8, 0xE23F, 0xEFCE,
0xDB84, 0xF294, 0xF274, 0xFBE8, 0x0D34, 0x0D6B, 0x1B6A, 0x1404,
0x1B11, 0x0E14, 0x0F0D, 0x0AF4, 0x0410, 0xFBAE, 0xFA5B, 0xEA8E,
0xEECB, 0xEC8C, 0xE7E9, 0xF225, 0xF58F, 0xFD55, 0x0E5C, 0x0AD2,
0x1641, 0x1322, 0x1471, 0x14F7, 0x072F, 0x0BC7, 0xF63C, 0xFCE6,
0xF025, 0xF0C7, 0xEBE1, 0xF3FE, 0xF10E, 0xF7DB, 0xFBDB, 0xF89D,
0x0C5D, 0x0805, 0x1D3F, 0x0F56, 0x1B52, 0x07FD, 0x0751, 0x0606,
0xF3D7, 0xFD26, 0xEE2E, 0xEC72, 0xEF2B, 0xF064, 0xF89F, 0xFF15,
0x00B0, 0x0266, 0x0BA4, 0x0BB7, 0x1CDB, 0x1427, 0x1633, 0x0C89,
0xFBFC, 0x0623, 0xE83C, 0xFE7D, 0xE7B8, 0xF330, 0xECCE, 0xEE69,
0xF3FF, 0xF456, 0x0A8C, 0x011F, 0x1DC1, 0x0AF2, 0x2442, 0x0FDD,
0x1E3D, 0x0970, 0x059C, 0x02CC, 0xEFF7, 0xFEF7, 0xE750, 0xF29B,
0xE46F, 0xF25F, 0xEE87, 0xFCC2, 0x0335, 0x01DA, 0x1538, 0x0AF5,
0x1D3C, 0x1478, 0x19AE, 0x10A6, 0x06CE, 0x052C, 0xF308, 0xF926,
0xE8AD, 0xEFBE, 0xE613, 0xF07E, 0xF3C3, 0xF5C9, 0x0783, 0xFE67,
0x186F, 0x0A52, 0x1FED, 0x0F3C, 0x1E6A, 0x0E6E, 0x0FD1, 0x08F3,
0xF2D8, 0xFCEE, 0xE518, 0xF3A0, 0xE514, 0xF4D6, 0xE934, 0xFBF5,
0xF80D, 0x01B7, 0x0FD1, 0x0BC5, 0x21C5, 0x14C5, 0x1D46, 0x0CC2,
0x0921, 0x010E, 0xF94E, 0xF79D, 0xF24E, 0xED99, 0xE964, 0xF020,
0xEB9D, 0xFA0E, 0xFE94, 0x0247, 0x1649, 0x0D27, 0x26E5, 0x1320,
0x1D05, 0x0E68, 0x0519, 0x098C, 0xF31E, 0xFB01, 0xE446, 0xE9D2,
0xDD09, 0xF103, 0xE322, 0xFFAA, 0xF6DE, 0x062F, 0x163A, 0x0B15,
0x2B33, 0x0E87, 0x25F2, 0x0AF7, 0x0F45, 0x0308, 0xFA38, 0xF937,
0xEC4F, 0xEBBA, 0xDFD9, 0xEC4D, 0xE4B5, 0xFD92, 0xFABD, 0x0AAB,
0x0FD2, 0x0F3E, 0x23A7, 0x11B4, 0x2B5E, 0x0BE7, 0x0E0D, 0x02B6,
0xE9F5, 0xFC97, 0xE182, 0xEF9D, 0xE0E4, 0xED95, 0xE522, 0xFB92,
0xF009, 0x04E5, 0x0C56, 0x0C02, 0x2E21, 0x0D5D, 0x302C, 0x04EE,
0x1893, 0xFE2B, 0xFBA9, 0xF818, 0xEBA5, 0xF300, 0xE4A3, 0xF2F7,
0xE3B7, 0xFB50, 0xEEB4, 0x0E55, 0x032F, 0x15EB, 0x1AD2, 0x0C9F,
0x21D1, 0x05C5, 0x11F3, 0x0018, 0xF994, 0xF5F9, 0xEE68, 0xECC4,
0xEBA0, 0xEE0B, 0xE9E5, 0xFABB, 0xF40D, 0x0871, 0x06C8, 0x1272,
0x1B0C, 0x126F, 0x2102, 0x044E, 0x12CF, 0xFA09, 0x0198, 0xF5A6,
0xEFC3, 0xECCF, 0xE407, 0xF047, 0xED3B, 0xFD9A, 0xF5B5, 0x0A6B,
0xF6FA, 0x1A53, 0x0855, 0x196B, 0x1D71, 0x099E, 0x15F2, 0xFC4A,
0xFBB2, 0xEC8D, 0xF1F7, 0xE4DA, 0xF2C2, 0xEB14, 0xF1C7, 0xF6FE,
0xF840, 0x0658, 0x075C, 0x16B7, 0x137D, 0x1E6C, 0x18E8, 0x116F,
0x11EC, 0xFE36, 0xFC0A, 0xF277, 0xEDE7, 0xE881, 0xE49B, 0xE666,
0xE1E9, 0xF45B, 0xEEC4, 0x0822, 0x006B, 0x15FF, 0x1359, 0x19D1,
0x1B39, 0x0FF3, 0x1543, 0x0294, 0x061B, 0xF278, 0xF72D, 0xE2A7,
0xEE3E, 0xE67E, 0xE6E3, 0xF429, 0xEEBB, 0x0177, 0x04DE, 0x12FA,
0x10AE, 0x1B60, 0x0FE2, 0x13AD, 0x0F27, 0x0630, 0x04DB, 0xF653,
0xEE85, 0xEA6E, 0xE46B, 0xE999, 0xEAA9, 0xF3C3, 0xF1E2, 0x0311,
0xFDAD, 0x0BDA, 0x117D, 0x0F75, 0x1BDC, 0x0F21, 0x0FAF, 0x05C0,
0x0040, 0xF5A2, 0xFB6D, 0xE94B, 0xF675, 0xEC28, 0xF427, 0xF8F9,
0xF318, 0x03D4, 0xFC2A, 0x1086, 0x0D3C, 0x1664, 0x0CBC, 0x09DC,
0xFF15, 0x0175, 0xF158, 0xFBA7, 0xEE4D, 0xED62, 0xF3B2, 0xE873,
0xFC20, 0xF1E1, 0x02AF, 0x03BD, 0x0869, 0x112F, 0x16C7, 0x11E9,
0x17C9, 0x0C24, 0x03A8, 0x03B4, 0xF2A8, 0xF642, 0xEF69, 0xEC4A,
0xECCA, 0xED10, 0xEF3B, 0xF49D, 0x01EE, 0x031A, 0x0CF5, 0x1100,
0x0D69, 0x17A0, 0x100B, 0x110A, 0x0792, 0x0437, 0xF459, 0xFA5A,
0xE745, 0xEAB6, 0xE989, 0xE476, 0xF85F, 0xF13A, 0x0483, 0x004C,
0x0C3D, 0x0D8B, 0x1786, 0x1460, 0x217B, 0x11CA, 0x166B, 0x0AB6,
0xF7E7, 0xFB85, 0xE4DB, 0xF15F, 0xE0D7, 0xF08A, 0xE59E, 0xEF45,
0xF2D1, 0xFA76, 0x0210, 0x0E31, 0x0CB1, 0x14A0, 0x176C, 0x0C0D,
0x1F20, 0x0327, 0x0DAC, 0xFB53, 0xF64A, 0xF314, 0xEBEE, 0xF101,
0xE96A, 0xF796, 0xF318, 0x00A3, 0x0628, 0x0702, 0x1429, 0x0FA5,
0x1118, 0x0D8F, 0x0BC3, 0x0304, 0x0A3E, 0xF9C6, 0xFDEB, 0xF138,
0xE793, 0xF682, 0xDE61, 0x002D, 0xED97, 0x06FF, 0x0403, 0x0CCE,
0x1216, 0x0A87, 0x13E5, 0x035F, 0x117F, 0xFD34, 0x0B49, 0xF47E,
0xFE5E, 0xEBBF, 0xF41F, 0xF131, 0xF243, 0x0120, 0xF647, 0x0FE5,
0x00A7, 0x1538, 0x0FB4, 0x1210, 0x135D, 0x0BF5, 0x0400, 0xFCB6,
0xF4BD, 0xEE64, 0xF0EE, 0xEC59, 0xEB6D, 0xEE21, 0xEAF4, 0xF81C,
0xFA05, 0x0A5B, 0x0D56, 0x167A, 0x1B84, 0x15EB, 0x2107, 0x0B43,
0x147E, 0x02C6, 0xF9D4, 0xF528, 0xEF88, 0xE666, 0xEF17, 0xE971,
0xE6AA, 0xF5D3, 0xE8F9, 0x07BC, 0x009E, 0x181D, 0x195B, 0x18F0,
0x1C44, 0x0FC5, 0x0EF7, 0x094A, 0xFE55, 0xFB92, 0xF4DA, 0xEAC8,
0xEC79, 0xE7B1, 0xE60F, 0xEB88, 0xF03F, 0xFDE3, 0x005C, 0x126B,
0x10A9, 0x157C, 0x2129, 0x0FAC, 0x2545, 0x0871, 0x0FF1, 0x0045,
0xF5E1, 0xF1D0, 0xEE3D, 0xECE0, 0xE7F0, 0xF488, 0xE147, 0xFC23,
0xE99D, 0x0BA2, 0xFB79, 0x177A, 0x0EB1, 0x0F54, 0x1DAE, 0x02D5,
0x19E0, 0xFAF0, 0x0932, 0xF120, 0xFCE4, 0xECF7, 0xF6B1, 0xF326,
0xF3A5, 0xFF30, 0xF1F8, 0x0E9E, 0xF87C, 0x1541, 0x093E, 0x0D9A,
0x12E4, 0x0477, 0x0CA3, 0xFB6E, 0x04AA, 0xF3AF, 0xFC9F, 0xF035,
0xF0F5, 0xF422, 0xEBDD, 0x0356, 0xF3FD, 0x0EC3, 0xFEE0, 0x1479,
0x02EA, 0x0EDF, 0x0B6D, 0xFE5D, 0x12EA, 0xF5AC, 0x0CB9, 0xF114,
0xFE8B, 0xEE8F, 0xF580, 0xF3B6, 0xFAA2, 0x02AB, 0x0147, 0x0F8D,
0xFF04, 0x13E6, 0xFF70, 0x13B0, 0x06AC, 0x0AA0, 0x03DF, 0xF95D,
0xFA3F, 0xEC8C, 0xF45C, 0xF1DB, 0xED58, 0xF7D5, 0xF25F, 0xFDBB,
0x052F, 0x0C3E, 0x0E1A, 0x0EB3, 0x0C64, 0x0C1F, 0x0F30, 0x0868,
0x107C, 0xFD9E, 0x0591, 0xF55F, 0xF926, 0xF003, 0xF3BB, 0xF398,
0xF038, 0x0018, 0xF548, 0x0BF1, 0x027C, 0x1119, 0x080C, 0x0CD9,
0x043B, 0x07C5, 0x004C, 0x002F, 0x028C, 0xF6AD, 0x02A8, 0xF2D0,
0xF9A2, 0xF215, 0xF1B2, 0xF74D, 0xFC76, 0x0622, 0x0C4F, 0x1059,
0x08F3, 0x09FE, 0x0490, 0x06ED, 0x0834, 0x04BF, 0x09B9, 0xF8C2,
0x01FA, 0xF4FA, 0xF9A5, 0xF87C, 0xF927, 0x002A, 0xF2E5, 0x0572,
0xF408, 0x06D3, 0xFD8A, 0x0B00, 0xFC4B, 0x06ED, 0xFCDC, 0x00BE,
0x0683, 0xFBA8, 0x0C6C, 0xF47D, 0x0A2A, 0xF4E0, 0x07F5, 0xFCA1,
0x0637, 0x07AD, 0xFF33, 0x0D26, 0xFC02, 0x0703, 0xFE34, 0xFF20,
0xFA26, 0x0074, 0xF5F5, 0xFFE2, 0xF9A8, 0xF94C, 0x01A1, 0xFB26,
0x042D, 0xFF7A, 0xFFB8, 0x061F, 0xFEFE, 0x0D0D, 0x030E, 0x0990,
0xFF8D, 0xFE6C, 0xF6BC, 0xF24F, 0xFD18, 0xF7AC, 0x04C5, 0xFEB3,
0xFFC3, 0xF818, 0x0392, 0xFF3E, 0x129F, 0x0C4E, 0x1278, 0x0F4F,
0x02A8, 0x0BCA, 0xFDE5, 0x03E9, 0xFA0A, 0xFC68, 0xEEDB, 0xF766,
0xEAB0, 0xF629, 0xEF0C, 0xF9A8, 0xFB18, 0x0053, 0x09A3, 0x01D2,
0x14C7, 0x0747, 0x15D4, 0x0D64, 0x0D9D, 0x059D, 0x077B, 0xFD3A,
0x027F, 0xFC69, 0xF4CE, 0x0140, 0xEB00, 0xFCEF, 0xF56A, 0xF66F,
0x04F9, 0x0144, 0x0969, 0x058D, 0x076D, 0x041E, 0x07B8, 0x0A3D,
0x042F, 0x055C, 0xF8D3, 0xFEEC, 0xF1EF, 0x0170, 0xF4C4, 0x040F,
0xF6B9, 0xFF0D, 0xFC9B, 0xF424, 0x0F4A, 0xF5F4, 0x17E9, 0x010A,
0x0ABE, 0x0121, 0x00E9, 0xFECC, 0x0AB5, 0x09DF, 0x07B3, 0x0DFF,
0xF2F9, 0x093D, 0xF37A, 0x08D3, 0xFF23, 0x038B, 0x00AC, 0xFA3A,
0x001E, 0xF1F8, 0xFFEB, 0xF89F, 0xFA29, 0x019C, 0xFD6F, 0xFC21,
0x06D7, 0x035E, 0x035F, 0x113E, 0x02B9, 0x0F54, 0x09E4, 0x051C,
0x0EB4, 0xFC1A, 0x0B7C, 0xFA05, 0x010E, 0xF657, 0xF9E4, 0xF1F5,
0xFA8A, 0xFDB4, 0xFB3D, 0x0771, 0xF5E4, 0x0637, 0xF81D, 0x12B9,
0x02D3, 0x167F, 0x02E4, 0x0212, 0x0170, 0xF47E, 0x0B52, 0xF402,
0x070E, 0xF6B7, 0xF8E5, 0xF63F, 0x000A, 0xFB7F, 0x0A0B, 0x0B81,
0xFFB5, 0x0F5C, 0xF964, 0x0B44, 0x0873, 0x0C9B, 0x103B, 0x01A3,
0x044B, 0xF034, 0xFDEB, 0xED6E, 0x01CF, 0xFBB4, 0xFAAC, 0x0783,
0xF0FD, 0x0478, 0xF46C, 0x0A3D, 0xF71D, 0x127D, 0xF9EE, 0x0227,
0x0216, 0xF386, 0x0AA9, 0xF7A0, 0x0E54, 0xF1D4, 0x0C96, 0xF092,
0x0907, 0x01F4, 0x0358, 0x107C, 0x004B, 0x14E0, 0xFC78, 0x0AFB,
0xF958, 0x05AD, 0xF803, 0x00D6, 0xF411, 0xEDEC, 0xF770, 0xEB3B,
0x04A8, 0xFA32, 0x0382, 0x04B2, 0xF6BB, 0x078E, 0x0537, 0x0CE5,
0x1266, 0x134C, 0xFFC2, 0x0615, 0xF87A, 0xF481, 0x017B, 0xF4BC,
0xFB32, 0xEFAA, 0xF65D, 0xE975, 0x05EE, 0x00E3, 0x0C39, 0x14A1,
0x01E4, 0x0DD5, 0x04A5, 0x0946, 0x0CBF, 0x07A2, 0xFEAB, 0x022F,
0xE8E8, 0xF47E, 0xE638, 0xE9DC, 0xF23A, 0xF3A7, 0xFB2F, 0xF96E,
0xFE96, 0xFEBA, 0x0925, 0x1260, 0x1A6F, 0x15EB, 0x1BE6, 0x05D3,
0x0BD6, 0xF829, 0xFFC0, 0xF952, 0xF194, 0xFB40, 0xE9A6, 0xEE9F,
0xF631, 0xF55E, 0xFAE3, 0x0CB5, 0xF7BC, 0x0C2A, 0x0109, 0x0801,
0x10DE, 0x0EF1, 0x0DEF, 0x04F5, 0xF6AA, 0xF1FE, 0xF143, 0xEABF,
0xFA14, 0xF254, 0xF5DC, 0xFC40, 0xF718, 0xFD55, 0x08DB, 0x0C05,
0x0D5C, 0x150F, 0x05F8, 0x0201, 0x0AD3, 0xFE1A, 0x0D65, 0x0298,
0xFBB4, 0xF594, 0xEB8A, 0xECFE, 0xF680, 0xF49B, 0xFDF7, 0x0829,
0xF0E1, 0x0D62, 0xF4A7, 0x06C8, 0x04E6, 0x0AC6, 0x07C0, 0x014A,
0x028D, 0xEDC3, 0xFE52, 0xF20E, 0x038E, 0xFDB2, 0x0687, 0xFB57,
0x0107, 0xFAE6, 0x045F, 0x06D0, 0x03DD, 0x13CA, 0xFA92, 0x075C,
0xFD4E, 0xF772, 0x027A, 0xFF4E, 0xF863, 0xF5E8, 0xF019, 0xEC18,
0xF965, 0x02AF, 0x021A, 0x0E51, 0xFE06, 0x04AD, 0x008C, 0xFCC9,
0x0A94, 0xFF5D, 0x0090, 0x0067, 0xF7B6, 0xF483, 0x05CA, 0xF5BA,
0x05DB, 0x01AB, 0xF7DF, 0xFD94, 0xFBAA, 0x021A, 0x0CD2, 0x1367,
0x0E5B, 0x0C0A, 0xFD0B, 0xF774, 0xFB18, 0xEFB5, 0x0012, 0xF9A2,
0xEFD7, 0xFFED, 0xE8D6, 0xF58A, 0xF9D6, 0x01BB, 0x0278, 0x1177,
0x0398, 0x00D0, 0x0CF0, 0xFF71, 0x14F2, 0x0839, 0x0DC8, 0xF84B,
0xFD42, 0xEBEF, 0xFB8C, 0xF456, 0xFD30, 0x077B, 0xF1F0, 0x0865,
0xF51B, 0x0403, 0x0736, 0x13CC, 0x0A98, 0x0ABE, 0x01D2, 0xEEA8,
0xFD07, 0xF3B1, 0xFBAB, 0xFF10, 0xF409, 0xF5F9, 0xF35B, 0xF29D,
0x0335, 0x009A, 0x03B7, 0x12E5, 0xFF09, 0x0E43, 0x14E4, 0x03E3,
0x1C3B, 0x0734, 0x01A9, 0xF2A0, 0xF30F, 0xE4C1, 0xF8AB, 0xFE4D,
0xFB8D, 0x0A5C, 0xF5A5, 0x01AD, 0xF8AF, 0x01EE, 0x09D4, 0x1070,
0x0776, 0x13D4, 0xFCBC, 0xF9A4, 0x0313, 0xEF64, 0xFFA5, 0xF4BF,
0xF0EC, 0xE791, 0xF1B4, 0xF3F4, 0x04A3, 0x16C5, 0x1033, 0x193A,
0x09DD, 0x096C, 0x0F79, 0x04FC, 0x1750, 0x087D, 0x0157, 0xF8B9,
0xEFCC, 0xE2B1, 0xF63E, 0xF208, 0xF2B4, 0x03A3, 0xED79, 0xFDA3,
0xF99C, 0x11A6, 0x0779, 0x266F, 0x0B03, 0x0F18, 0x0839, 0xF118,
0x0CCC, 0xE7C1, 0x0643, 0xF008, 0xF13A, 0xEDF4, 0xF76C, 0xF1C6,
0x07A8, 0x1491, 0x00EF, 0x1C5B, 0xFE9C, 0x0D7D, 0x0CF4, 0x15CC,
0x143B, 0x1067, 0x02C4, 0xEC69, 0xF3BD, 0xD6A6, 0xFCF2, 0xE762,
0xF5E3, 0x0213, 0xE5CC, 0x060E, 0xF8FD, 0x1304, 0x107D, 0x26DA,
0x0BDC, 0x0C78, 0x0684, 0xF359, 0x0E9B, 0xFD63, 0x0E74, 0xF218,
0xFBEA, 0xDCA3, 0xF535, 0xE925, 0x030F, 0x0D5D, 0xFDC0, 0x208F,
0xF890, 0x1658, 0x0EE5, 0x1754, 0x1106, 0x11BE, 0xFB6E, 0xE912,
0xF1AB, 0xDFCF, 0xF400, 0xF678, 0xF5D5, 0xF61E, 0xF22F, 0xF1A6,
0x0048, 0x0418, 0x12BC, 0x227F, 0x0C5D, 0x1DDA, 0x0EF2, 0x0150,
0x182E, 0x0224, 0x02CC, 0xF6C4, 0xEAEE, 0xD958, 0xEF3C, 0xEF88,
0xFBEC, 0x10DF, 0xFB55, 0x0A62, 0xFB84, 0x033A, 0x11C0, 0x1004,
0x160E, 0x1917, 0xF762, 0xFD0F, 0xF479, 0xE8F7, 0x0213, 0xF8AD,
0xF3F8, 0xEE01, 0xEDEA, 0xE964, 0xFE6F, 0x1218, 0x1313, 0x21E4,
0x1684, 0x0A48, 0x0D7E, 0xFB3C, 0x1235, 0x02E4, 0x0187, 0x01D3,
0xE534, 0xE818, 0xF172, 0xF0AE, 0xFEE8, 0x0E48, 0xF3C6, 0xFF34,
0xF37D, 0xFF33, 0x064D, 0x1DFB, 0x12D7, 0x12B1, 0x0699, 0xECC4,
0xFF06, 0xE158, 0x04C9, 0xF718, 0xF4F9, 0xFEBE, 0xF237, 0xF7A9,
0x0FEE, 0x1591, 0x0E8E, 0x1FF1, 0xFD40, 0xFC22, 0x0515, 0xFF9A,
0x0A1E, 0x0F47, 0xFF84, 0xF2AD, 0xEED9, 0xDA71, 0xF4EE, 0xEBF7,
0xFF17, 0x0F96, 0xED68, 0x1146, 0xF79C, 0x09B2, 0x1724, 0x19C4,
0x1015, 0x04E5, 0xFCE6, 0xE262, 0xFD95, 0xF375, 0x06E8, 0x0198,
0x0106, 0xF189, 0xF456, 0xF0B1, 0x03CD, 0x0EEC, 0x0BA1, 0x2432,
0xFA17, 0x0960, 0x0654, 0xFC87, 0x13E5, 0x0A1B, 0xFA04, 0xEAF7,
0xE83B, 0xDA61, 0xF021, 0x026F, 0xFB55, 0x1161, 0xFA78, 0xFE07,
0xFFBC, 0xFBBE, 0x1707, 0x11A1, 0x10BA, 0x0F04, 0x0154, 0xEFC1,
0x12C1, 0xF9D6, 0x0B98, 0x06C7, 0xEE37, 0xEA06, 0xEED3, 0xF7F9,
0xFBF7, 0x207A, 0x016E, 0x1535, 0xFFE8, 0xF579, 0x0A0B, 0xF1C4,
0x10CC, 0x04EB, 0xF5D6, 0xFC30, 0xEE0D, 0xEBA0, 0x08C3, 0x0768,
0x055B, 0x0D60, 0xF107, 0xF673, 0xFA70, 0x0D29, 0x1328, 0x1F36,
0x181B, 0xFE5E, 0x0429, 0xE1B3, 0x0409, 0xEF28, 0x0686, 0x08C8,
0xECAD, 0xFCDE, 0xF558, 0xFDDB, 0x0D8D, 0x212D, 0xFD67, 0x0E7B,
0xF37F, 0xF03A, 0x0196, 0x07E3, 0x09B0, 0x0739, 0xFDEF, 0xE216,
0xF57F, 0xD994, 0x0546, 0xFDC1, 0x05EB, 0x1A13, 0xFC3B, 0x0BEF,
0x0FD4, 0x1528, 0x17AC, 0x22A7, 0x0220, 0xF5E5, 0xFABF, 0xE3BC,
0xFE86, 0xFE5B, 0xFB8F, 0xF857, 0xF0DC, 0xE40F, 0xF644, 0xF2C1,
0x0C7D, 0x1EE7, 0xFD99, 0x23A0, 0xF213, 0x037D, 0x140B, 0x0B0B,
0x1551, 0x0380, 0xF6E3, 0xD6D9, 0xF4A9, 0xE585, 0x048B, 0x0C13,
0x07BF, 0x0651, 0xFBDF, 0xFBE2, 0x06D6, 0x0D88, 0x10EA, 0x21F7,
0xF79D, 0x0707, 0xFA20, 0xEBCF, 0x12A5, 0xFF8E, 0x00AB, 0xF28D,
0xEAF2, 0xDBAC, 0xF36D, 0x0619, 0x0002, 0x2549, 0x0158, 0x0C03,
0xFDE5, 0xF12C, 0x0B7D, 0xFD80, 0x0D8A, 0x0C35, 0xFCB1, 0xEE11,
0x0BEA, 0xEE49, 0x14AB, 0x116B, 0xFB70, 0xFED9, 0xF5A3, 0xFA10,
0xFDCC, 0x2360, 0x0088, 0x1A3E, 0xFA00, 0xE9AF, 0xF715, 0xDABD,
0x083C, 0xF848, 0xFE9C, 0x03A4, 0xEE6C, 0xF01F, 0x0A8F, 0x0B23,
0x14B1, 0x2289, 0xFCCF, 0x0089, 0xFA41, 0x00DF, 0x07F1, 0x1530,
0x07BD, 0xF8A5, 0xF70A, 0xD65C, 0xFCD4, 0xE108, 0x0F21, 0x0A42,
0xF987, 0x0E70, 0xF4FC, 0x0538, 0x14CB, 0x257D, 0x0B34, 0x19D7,
0xF285, 0xE7B1, 0xF175, 0xF349, 0xF533, 0x040F, 0xF8F9, 0xE6ED,
0xF97F, 0xD4D9, 0x0972, 0xF79E, 0x12E9, 0x2542, 0x02E3, 0x17DC,
0x0CD5, 0x0CF2, 0x1932, 0x200D, 0xFE35, 0xF8C9, 0xEB38, 0xD3C5,
0xEEDA, 0xF551, 0xF6DC, 0x014D, 0xF9F1, 0xE6B1, 0xFCB2, 0xEA59,
0x0EBD, 0x1744, 0x0793, 0x2802, 0xF073, 0x021F, 0x0479, 0xFFA6,
0x0D28, 0x0785, 0xF13F, 0xDC03, 0xEFF4, 0xDE05, 0x03C5, 0x0CA0,
0x0D85, 0x0E89, 0x042D, 0xF9E6, 0x02DA, 0xFD77, 0x0EED, 0x17B1,
0xF72F, 0x0C49, 0xE896, 0xE85A, 0x0417, 0xFADA, 0x050B, 0x0005,
0xF2A9, 0xDF10, 0xF5CF, 0xFB5F, 0xFFF9, 0x24DF, 0x02BB, 0x0D78,
0xFC67, 0xE760, 0xFF00, 0xEFE0, 0x0455, 0x0D32, 0xF6CA, 0xF797,
0xFF7E, 0xEA7D, 0x1841, 0x135B, 0x0A12, 0x09C2, 0xF7C2, 0xEE11,
0xF808, 0x1134, 0xF85D, 0x1932, 0xF348, 0xEBD5, 0xEDA7, 0xD5BA,
0xFD08, 0xF425, 0xFF72, 0x0D46, 0xF226, 0xF609, 0x0D3F, 0x0214,
0x1FC5, 0x2167, 0x0363, 0xFE38, 0xF35C, 0xECFD, 0xF83F, 0x0C9B,
0xFAC2, 0x0520, 0xF4F4, 0xE258, 0xF893, 0xE348, 0x0B81, 0x095D,
0x044F, 0x112C, 0xFBB9, 0xF8AF, 0x1350, 0x0E80, 0x0EEB, 0x1693,
0xED2E, 0xE409, 0xE1EE, 0xE7D3, 0xE964, 0x102E, 0xF951, 0x00C2,
0xFF45, 0xE1EC, 0x076B, 0xF123, 0x17A7, 0x18F5, 0x0BF6, 0x0CC5,
0x08C9, 0xF4C2, 0x1191, 0x11E8, 0xF906, 0x03A9, 0xE2E5, 0xD9B1,
0xE730, 0xFBAF, 0xF7E0, 0x199B, 0x0284, 0xFA13, 0x01B0, 0xE369,
0x0E0D, 0xFF8A, 0x0D28, 0x1700, 0xF254, 0xF7C5, 0xF72F, 0xF0D7,
0x0803, 0x0E43, 0xF8B4, 0xF77B, 0xF2C6, 0xE765, 0x028D, 0x12E9,
0x10C7, 0x1A89, 0x0D1E, 0xF4B1, 0x0268, 0xE891, 0x068E, 0x0091,
0xF4FD, 0x057E, 0xE29F, 0xE946, 0xFEB9, 0xFD11, 0x0CC7, 0x19AF,
0xFC50, 0xF659, 0xF784, 0xF428, 0xFE4C, 0x1CBD, 0x0807, 0x0D66,
0xFE9B, 0xDF1E, 0xF406, 0xDDA4, 0xFAE4, 0x0296, 0xF8F3, 0x048D,
0x0257, 0xF6AB, 0x192B, 0x1A0A, 0x11E2, 0x1B10, 0xFC3E, 0xEAC3,
0xF620, 0xF912, 0xF6BB, 0x133C, 0xF3CB, 0xEDBF, 0xE98D, 0xD0CE,
0xF323, 0xEF49, 0x047A, 0x1870, 0xFCF1, 0x0F30, 0x0984, 0x037C,
0x1DA5, 0x1AA9, 0x0B64, 0x03FD, 0xF863, 0xDEFC, 0xF56B, 0xF84B,
0xF829, 0x072F, 0xF81C, 0xEE5F, 0xF787, 0xE9CE, 0x0718, 0x0DA7,
0x082A, 0x20B1, 0xFAA3, 0xFF89, 0x09C7, 0xFCFC, 0x1328, 0x120F,
0xFA48, 0xEA6C, 0xE66D, 0xD83D, 0xE87B, 0x09E4, 0xFBC8, 0x152E,
0x04E4, 0xF655, 0x01E7, 0xF702, 0x0D43, 0x12BB, 0x0B84, 0x0E52,
0x0498, 0xF043, 0x1229, 0xFEFC, 0x08FE, 0x0774, 0xF0BE, 0xE2B2,
0xED31, 0xF2E0, 0xF4DF, 0x1FAC, 0xFFBE, 0x105B, 0xFD6A, 0xEDB3,
0xFE1D, 0xF295, 0x062A, 0x0D18, 0xF9FB, 0xFEC9, 0xFBE8, 0xE935,
0x11B9, 0x07EE, 0x0C94, 0x0CA5, 0xFCEA, 0xF0DB, 0xFB08, 0x0896,
0x004C, 0x1F92, 0x03EB, 0x0034, 0xFA30, 0xE444, 0xFB99, 0xF17B,
0xFF12, 0x0284, 0xF33C, 0xF2E8, 0x053C, 0xFA26, 0x19CC, 0x2008,
0x06CC, 0x0BE4, 0xEFB6, 0xEF03, 0xE833, 0x0D41, 0xF63D, 0x11F4,
0x005B, 0xE915, 0xF8F0, 0xD9D5, 0x03AA, 0xF723, 0x0F0A, 0x0D91,
0x0EFF, 0x0435, 0x1935, 0x142E, 0x11B2, 0x21F5, 0xF3BF, 0xF807,
0xE26A, 0xE943, 0xE4F3, 0x042E, 0xF5AF, 0xF964, 0xFD73, 0xDD30,
0x0151, 0xE9AE, 0x1091, 0x1438, 0x0A3D, 0x1C3F, 0x0098, 0x04A8,
0x0AB6, 0x110B, 0x0005, 0x100F, 0xEE12, 0xE123, 0xEDA6, 0xE28B,
0xFB02, 0x043D, 0x0F24, 0xFEA4, 0x0F09, 0xF320, 0x0C7A, 0x05F2,
0x084D, 0x1B8E, 0xF048, 0x0898, 0xEEFF, 0xF90B, 0x0086, 0x0AD9,
0xFA5D, 0xF453, 0xEE8B, 0xD695, 0xF1E8, 0xFA47, 0x084C, 0x18F7,
0x1AAF, 0x086A, 0x09A8, 0xF8D2, 0xFB44, 0x043A, 0xF90F, 0x0EFF,
0xF20E, 0xFA29, 0xFF04, 0xF484, 0x0ADE, 0x04C5, 0x03EB, 0xF0B6,
0xFC5F, 0xEBF0, 0xFBAD, 0x1415, 0x0929, 0x1AEE, 0x0332, 0xFC26,
0xEAE9, 0xF0AC, 0xEC5A, 0x02FB, 0xEFD8, 0x0420, 0xF5B2, 0xECE5,
0x12B3, 0xFB4F, 0x1CC5, 0x0F86, 0x0F12, 0xF91F, 0x047D, 0xFC29,
0xFECF, 0x18E2, 0xFCF3, 0x0ED8, 0xEF81, 0xF1B6, 0xE727, 0xEC87,
0xF4C7, 0xFBD6, 0xFCAB, 0xFA82, 0x0AC2, 0xF5B2, 0x20B1, 0x0F84,
0x17C6, 0x118F, 0xFDAF, 0xF640, 0xE6CC, 0x03A2, 0xE2C9, 0x14A6,
0xF404, 0xFB6F, 0xF568, 0xE42D, 0xFBEE, 0xEDEA, 0x13AA, 0x05C3,
0x1AF6, 0x054A, 0x1CA9, 0x0531, 0x17D0, 0x18BE, 0xFE9A, 0x071C,
0xE1E9, 0xEE3D, 0xD3FC, 0x0017, 0xE776, 0x04BD, 0x0217, 0xEF25,
0x0486, 0xEB22, 0x0E14, 0x0259, 0x1561, 0x12C6, 0x0AF4, 0x0583,
0x0BDB, 0x0759, 0x02D9, 0x115F, 0xEB5E, 0xF54C, 0xE5D4, 0xE889,
0xF12A, 0x00C9, 0x09A7, 0x0717, 0x161B, 0xFC19, 0x0DA1, 0xFABA,
0x0925, 0x0912, 0xFFD9, 0x0D28, 0xF653, 0xFC90, 0xF8CA, 0x02F1,
0xF740, 0x055A, 0xF30D, 0xEB39, 0xF0D0, 0xF467, 0xFDAD, 0x11A7,
0x18E8, 0x0D14, 0x1533, 0xFB14, 0x01E1, 0xFCF2, 0x016E, 0x0905,
0xFCDD, 0x00A9, 0xFACF, 0xF8CC, 0x0509, 0x070A, 0x058C, 0xFFFA,
0xFD26, 0xEF3F, 0xF5EA, 0x03E8, 0xFF17, 0x1354, 0x0DD7, 0x04A0,
0x005D, 0xF77E, 0xF120, 0xFAC6, 0xF44E, 0x04B8, 0xFB3F, 0xFC66,
0x0B51, 0xFACA, 0x156E, 0x0B1D, 0x0EF0, 0x005D, 0x035B, 0xF5E8,
0xFAB4, 0x0B3A, 0x02A0, 0x1130, 0x059B, 0xFDC7, 0xF4A8, 0xF237,
0xF053, 0xF9F5, 0xFB67, 0x0113, 0x06CE, 0xFB56, 0x11F5, 0x056F,
0x1199, 0x0F67, 0x048D, 0xFDE2, 0xF14D, 0xFD14, 0xEB2A, 0x0C53,
0x0111, 0x0400, 0x06D1, 0xF4E9, 0xFA3D, 0xF318, 0x054E, 0xFE51,
0x1310, 0x05A2, 0x124C, 0x038D, 0x0FAA, 0x0FD2, 0x072D, 0x0DA7,
0xF4F8, 0xF4F2, 0xE459, 0xF7EA, 0xEC81, 0x050D, 0x05B1, 0xFF0E,
0x0782, 0xF5C4, 0xFDE5, 0xFA12, 0x0292, 0x096D, 0x08D2, 0x09FF,
0x0B8D, 0x0479, 0x091D, 0x0B85, 0x0542, 0xFEED, 0xFE3D, 0xEC23,
0xF48A, 0xFC1F, 0x01F6, 0x0AFB, 0x1125, 0x03F6, 0x01D5, 0xFBFB,
0xF5E8, 0xFFCD, 0xFB28, 0x087D, 0xFF27, 0x013C, 0x0668, 0xFEDE,
0x0C33, 0x0444, 0x079E, 0xF766, 0xF8B4, 0xF6E6, 0xF13B, 0x0A6F,
0x03ED, 0x0CA9, 0x0AF9, 0x0227, 0xF932, 0xF97B, 0xF856, 0xFBAE,
0x090F, 0x022E, 0x117F, 0xFC08, 0x1061, 0x0038, 0x0CCA, 0x0694,
0x00EC, 0xFC45, 0xEAFE, 0x0072, 0xE84F, 0x0CB5, 0xFE06, 0x068C,
0xFE2F, 0xF936, 0xF44B, 0xF446, 0x0063, 0xFC0A, 0x0DBD, 0xFE79,
0x13B7, 0xF9FE, 0x1001, 0x0724, 0x071B, 0x0AFD, 0xFEC2, 0xFE9A,
0xEEDC, 0x02A3, 0xF071, 0x058B, 0x057A, 0xFE5C, 0x0400, 0xF470,
0xFA5A, 0xEFBB, 0x0414, 0xFA0C, 0x0B06, 0xFFAC, 0x064C, 0x0539,
0x0279, 0x122F, 0xFF6F, 0x09B7, 0xF000, 0xFA70, 0xE6B8, 0xFD30,
0xFFE2, 0xFD8B, 0x131C, 0xF710, 0x07F1, 0xEF86, 0x033C, 0xF479,
0x08EA, 0x0774, 0x0837, 0x0C94, 0x0258, 0x0E09, 0xFABA, 0x0CAE,
0xF72D, 0xF8EE, 0xF055, 0xF0CE, 0xF030, 0xF87F, 0x09F8, 0xF9B7,
0x1230, 0xF832, 0xFA1D, 0xFA50, 0xF2B4, 0x0816, 0xFD5A, 0x0F6D,
0x00F7, 0x039A, 0x001C, 0x00E7, 0x0559, 0xFC49, 0x0A21, 0xEDC3,
0x0211, 0xF214, 0x0192, 0xFF3E, 0x0C0C, 0x05AA, 0xFDDB, 0x0764,
0xE5F3, 0x0315, 0xE830, 0x0396, 0xF9E6, 0x00AD, 0x055B, 0xF5E8,
0x09A9, 0xF954, 0x109C, 0xF951, 0x0BAF, 0xF528, 0xF893, 0x01FA,
0xFA01, 0x0C90, 0x013C, 0x0D4A, 0xEF59, 0x0183, 0xEA18, 0xF617,
0x018E, 0xF9C0, 0x124B, 0xF645, 0x1451, 0xF4AD, 0x10DC, 0xFF42,
0x0A60, 0xFF81, 0xF8CB, 0x02A0, 0xE479, 0x0E93, 0xEA89, 0x0AFF,
0xF75D, 0x002E, 0xF1F8, 0xF59E, 0xF5FB, 0xF100, 0x0E75, 0xF61E,
0x1D1F, 0xF523, 0x1469, 0xFE57, 0x0C6D, 0x0CF7, 0x0645, 0x089C,
0xEDB4, 0x07CE, 0xE3C5, 0x08E0, 0xFA2D, 0x0019, 0x00C2, 0xF720,
0xF69C, 0xEB9A, 0x0043, 0xEFEB, 0x10A2, 0xFD96, 0x11E2, 0x026D,
0x07A6, 0x0E66, 0xFBED, 0x0FAF, 0xF18B, 0x0356, 0xE812, 0xFFDD,
0xF350, 0xFB14, 0x0BD9, 0xF50F, 0x0A37, 0xF0FA, 0x007F, 0xF139,
0x0C32, 0x0237, 0x1458, 0x0D81, 0x0536, 0x0A2D, 0xF3B4, 0x0B8E,
0xF1DF, 0x028E, 0xF03F, 0xF644, 0xEF06, 0xF666, 0x0119, 0xF578,
0x0F65, 0xF9FA, 0x0498, 0xFF14, 0xFAFE, 0x0407, 0x0041, 0x0B79,
0x039F, 0x0322, 0xFC76, 0xFE79, 0xF92F, 0x0157, 0x04C2, 0xF4FE,
0x072B, 0xF24B, 0x0082, 0xFDCA, 0x0C06, 0x042F, 0x0BF5, 0x0925,
0xF114, 0x041C, 0xE892, 0xFEB1, 0xF69A, 0xFF16, 0xFCEB, 0xF883,
0xFE2B, 0xF932, 0x07E1, 0xFBB3, 0x0C9B, 0xFA85, 0x0441, 0x03D9,
0x045F, 0x0902, 0x098D, 0x0889, 0xFBB5, 0x0539, 0xEAFD, 0xF826,
0xF22F, 0xF7CC, 0x04A3, 0xFAD1, 0x09BF, 0xF597, 0x04B3, 0xFEDD,
0x071B, 0x0605, 0x06F7, 0x057B, 0xF86C, 0x0831, 0xF6FF, 0x0425,
0xFEF7, 0x0147, 0xF175, 0xFC12, 0xE85C, 0xF3DA, 0xFBAA, 0xF63F,
0x0E9A, 0xF72E, 0x0E84, 0xFE0B, 0x0B11, 0x0CF2, 0x0C01, 0x091B,
0x0514, 0x02D4, 0xFA3A, 0x03FB, 0xFC80, 0x0016, 0xFB30, 0xFDCE,
0xEA18, 0xF51F, 0xEA11, 0xF21E, 0x00DF, 0xFE0E, 0x0DA1, 0x0263,
0x07E1, 0x0777, 0x0459, 0x0AFE, 0x0635, 0x02E1, 0xFEBB, 0x00F1,
0xFBA1, 0xFD9C, 0x0285, 0xFACD, 0xFC1A, 0xFE12, 0xF345, 0xF8EF,
0xFD9F, 0xFE20, 0x0B4E, 0x0717, 0x0AA2, 0x01D3, 0x0008, 0x02E3,
0xFC92, 0x034D, 0xFFDD, 0xFCE9, 0xF91C, 0xFDCD, 0xF624, 0xFF79,
0x0140, 0x0327, 0xFE92, 0x0584, 0xF0B5, 0xFF36, 0xFA4D, 0xFE53,
0x0CBD, 0xFB27, 0x09DB, 0xF8E2, 0x03E5, 0x009D, 0x089E, 0xFE71,
0x05F4, 0x0191, 0xFD57, 0x0B2A, 0x01B1, 0x08CE, 0x0095, 0x07EF,
0xED82, 0xFF19, 0xE9A5, 0xF35E, 0xFB7D, 0xF6C1, 0x0A11, 0xF649,
0x08E9, 0xF711, 0x0211, 0x0371, 0x02E6, 0x0A66, 0x0269, 0x0CDC,
0xFEB3, 0x0947, 0x002B, 0x016D, 0xFC9A, 0xFEF8, 0xF42C, 0xF559,
0xFCAB, 0xF287, 0x0EDC, 0xF987, 0x0DE9, 0xF95F, 0xFE4E, 0x04FC,
0xF871, 0x0EF3, 0xFA86, 0x09CC, 0xF52C, 0x070F, 0xF3E6, 0xFEC8,
0xFF4C, 0xFAE9, 0x0268, 0xFC76, 0xFCF5, 0xF4CB, 0x020C, 0xF684,
0x0C33, 0xFC7C, 0x0833, 0x0147, 0xFB28, 0x0B9C, 0xFB6F, 0x0877,
0xFE35, 0x024C, 0xFA15, 0x0420, 0x03AC, 0xFEFA, 0x0C33, 0xFE14,
0xFE96, 0xFD51, 0xF2B9, 0xF739, 0xF7EC, 0xFE0B, 0xFE40, 0x014B,
0xFADA, 0xFF0B, 0xF596, 0x0380, 0xF8A9, 0x0234, 0x0208, 0x0252,
0x0C97, 0x00B5, 0x1569, 0xFE6B, 0x0F83, 0x058F, 0xFB98, 0x0057,
0xF37C, 0xFC00, 0xFB38, 0x00F9, 0xFC20, 0xFA4D, 0xF236, 0xFB51,
0xF3A8, 0x01AE, 0x025B, 0x007E, 0x08FF, 0x058B, 0x0CF0, 0x05FE,
0x0FD7, 0x0422, 0xFF58, 0x06E5, 0xEC32, 0xFE10, 0xEC02, 0xF655,
0xF643, 0xF5E1, 0xFF88, 0xF51E, 0x044C, 0xFDEA, 0x0BCB, 0x0594,
0x15E7, 0x09C2, 0x14D3, 0x0F82, 0x0BB1, 0x086B, 0xFF5A, 0x0317,
0xE89C, 0xFF90, 0xDA9A, 0xF38E, 0xE765, 0xF3AF, 0xFE43, 0xF5E1,
0x0CB0, 0xF9DE, 0x10CF, 0x0905, 0x13DA, 0x0E29, 0x1180, 0x0C8A,
0x0882, 0x0669, 0x0168, 0xFCEE, 0xF337, 0xFEED, 0xE695, 0xFAE5,
0xEEEF, 0xF373, 0x037C, 0xFB7E, 0x12C2, 0x00FA, 0x12FF, 0x0613,
0x0915, 0x0C6D, 0x02A9, 0x064B, 0xFA81, 0x039C, 0xF13B, 0x0091,
0xF479, 0xFAF3, 0xF649, 0xFEEB, 0xF4A5, 0xFBF9, 0x0138, 0xFB40,
0x124F, 0x019B, 0x17B3, 0x00BB, 0x0FD6, 0x03D1, 0x02A9, 0x045C,
0xF960, 0x02F1, 0xF612, 0x06F0, 0xFA3C, 0x0065, 0x0025, 0xFD32,
0xFCC4, 0x027E, 0xF977, 0xFF1B, 0x001C, 0xFF7C, 0x0A26, 0xFEE5,
0x0A6E, 0xFA36, 0xFC27, 0x02BF, 0xF36B, 0x0698, 0xF7E5, 0x03DB,
0x020D, 0x046B, 0x104F, 0xFE7C, 0x1290, 0x023B, 0x04BB, 0x0649,
0x009C, 0xFD81, 0x059C, 0xFDDB, 0xFF57, 0xFEAB, 0xF537, 0xFF6D,
0xEF44, 0x05E1, 0xF2C0, 0x04C3, 0x010C, 0x048B, 0x0CE5, 0x0217,
0x1247, 0xFD55, 0x0BED, 0x0287, 0xFD63, 0xFF6E, 0xF58A, 0xFA36,
0xF4D0, 0xFF23, 0xF8BE, 0xFF2F, 0xFE79, 0x0479, 0x053B, 0x08CE,
0x0F2C, 0x0388, 0x1370, 0x0667, 0x1204, 0x0252, 0x0BC1, 0xFB41,
0xF60F, 0x007B, 0xE2F2, 0xFD8D, 0xE32B, 0xFD8C, 0xEF34, 0x02B9,
0x034B, 0x0002, 0x10A3, 0x0303, 0x10F7, 0x025C, 0x118E, 0xFE5F,
0x11E0, 0x00C8, 0x0D34, 0xFF45, 0xFFA3, 0x019A, 0xE9AD, 0x0526,
0xE5BD, 0x02F4, 0xF8E7, 0x0643, 0x0953, 0x03AB, 0x0EBB, 0xFAAB,
0x0B66, 0xFA68, 0x057A, 0xFA32, 0xFFF8, 0x0080, 0xFC1F, 0x0835,
0xF9B0, 0x0253, 0xF0C4, 0x05D7, 0xED22, 0x07FB, 0xFABB, 0xFEF2,
0x0A57, 0xFD29, 0x12CB, 0xF54F, 0x12F8, 0xF23A, 0x085B, 0xFD8C,
0x009E, 0x061B, 0xFCB0, 0x0F6B, 0xF7FF, 0x0F80, 0xFA63, 0x06AA,
0xF75F, 0x0503, 0xF393, 0xFDC4, 0xFDC4, 0xF5B9, 0x05C5, 0xF312,
0x066D, 0xF05C, 0x0309, 0xFC7D, 0xF92A, 0x09A1, 0xF4AA, 0x0B60,
0xFD2E, 0x0E67, 0x0A77, 0x07A0, 0x0E0B, 0xFE0D, 0x03E7, 0xFBC5,
0x003E, 0xF434, 0x04CD, 0xF642, 0x017C, 0xFCF3, 0xF82B, 0xFD93,
0xECE7, 0x0762, 0xEC4C, 0x0972, 0xF8F8, 0x0668, 0x0596, 0x0626,
0x113F, 0xF88C, 0x0D73, 0xF3CC, 0xFB5B, 0xF8A3, 0xFA62, 0xF8DB,
0xFE02, 0x007A, 0xF5AA, 0x051C, 0xF578, 0x0449, 0xFB86, 0x0493,
0x01B5, 0x004B, 0x0CE3, 0xFFD1, 0x140E, 0xFCA4, 0x0D77, 0xF382,
0xFABD, 0xFA1A, 0xEB90, 0x037D, 0xE9E1, 0x06EE, 0xEDC8, 0x0977,
0xF590, 0xFE8A, 0xFF50, 0xF846, 0x044D, 0xF923, 0x0977, 0xF400,
0x0DDE, 0xF8BA, 0x0F87, 0xFCA1, 0x09C9, 0xFEC0, 0xF497, 0x0D6A,
0xEB96, 0x1161, 0xF8A9, 0x0995, 0xFE60, 0xFFAC, 0xFE53, 0xF13B,
0xFF52, 0xEE2A, 0xFC2C, 0xF2C7, 0xFC87, 0xF846, 0x0117, 0x030C,
0x03C8, 0x082B, 0xFDC2, 0x0DC3, 0xF2BF, 0x1163, 0xF714, 0x02CF,
0x050F, 0xF6B6, 0x06B9, 0xF0C9, 0x0267, 0xEC43, 0x004E, 0xF66A,
0xFDEF, 0xFFD5, 0xFEFE, 0x0A49, 0x0408, 0x1422, 0x0556, 0x0A50,
0xFA35, 0x035A, 0xF116, 0xFE5D, 0xF916, 0xF2AB, 0xFC98, 0xF0DC,
0xF8B9, 0xF09E, 0xFBB0, 0xF67C, 0xFAC8, 0x04D7, 0xFC18, 0x0A68,
0x07A0, 0x0D64, 0x0F8F, 0x07C0, 0x0E41, 0xF976, 0x0288, 0xF9C9,
0xF8B5, 0xFADF, 0xFC76, 0xF897, 0xFB07, 0xFD78, 0xF2B5, 0xFECC,
0xF47E, 0x04B7, 0xFB4F, 0x09FA, 0x00F0, 0x04A4, 0x06FD, 0xFFC2,
0x0D2A, 0xF4C4, 0x093D, 0xF1FF, 0xF86A, 0xFE7A, 0xF286, 0xFEF3,
0xF84A, 0x011C, 0xF8D5, 0x080D, 0xFEAE, 0x04A5, 0x07E6, 0x0359,
0x09EC, 0xFF1E, 0x0AD5, 0xFA52, 0x0A7C, 0xFA6B, 0x0710, 0xF6D8,
0xF8FE, 0xFC64, 0xE682, 0x083D, 0xE967, 0x0A8B, 0xF7F4, 0x0878,
0xFE8E, 0x0070, 0x067B, 0xF78F, 0x0BD8, 0xF806, 0x07D9, 0xF623,
0x06ED, 0xF910, 0x0987, 0x01D1, 0x05F9, 0x033B, 0xF71B, 0x0D03,
0xF03B, 0x120F, 0xFED9, 0x067D, 0x0561, 0xFCB8, 0xFF77, 0xF31E,
0xFEBD, 0xF0B8, 0xFDA2, 0xF723, 0xFA2E, 0xFEC6, 0xFA3A, 0x09A5,
0x021F, 0x0AE1, 0x067C, 0x072E, 0xFD54, 0x0930, 0xFBBB, 0xFF0D,
0x052B, 0xF251, 0x033B, 0xF3F4, 0xFEC3, 0xF5E0, 0x0032, 0xFC07,
0xFCF9, 0x096D, 0xFD91, 0x11B4, 0x067F, 0x11CE, 0x0E6C, 0x0414,
0x092B, 0xF7B1, 0xF6BE, 0xF6FE, 0xF13F, 0xF401, 0xF89C, 0xF6D5,
0xF692, 0xFC69, 0xF544, 0x0112, 0xFB7A, 0x0DBD, 0x026C, 0x106E,
0x0CA1, 0x0976, 0x180A, 0x0063, 0x1A17, 0xF27A, 0x0673, 0xF225,
0xF1E7, 0xFC6F, 0xF4AA, 0x00F0, 0xF700, 0x05B7, 0xEEF3, 0x0AE4,
0xF33C, 0x0B01, 0x0057, 0x07D9, 0x07F7, 0x0028, 0x0D48, 0xF837,
0x10D4, 0xF17B, 0x0D7D, 0xEF6B, 0xFAAA, 0xFD63, 0xEA01, 0x0817,
0xF28B, 0x0A92, 0xFB64, 0x103C, 0xFD3D, 0x097C, 0x0747, 0xFE99,
0x0DB4, 0xFA17, 0x0C3B, 0xF76D, 0x0C71, 0xF91F, 0x0CE4, 0xF882,
0xFF1D, 0xFD4A, 0xE75A, 0x0BF3, 0xE547, 0x1107, 0xF7C5, 0x0AFF,
0xFF31, 0x00FD, 0x0038, 0xF53F, 0x0668, 0xF1BA, 0x08CE, 0xF55A,
0x09CB, 0xFC33, 0x0B8E, 0x05A2, 0x0A86, 0x085C, 0xFF3E, 0x0BED,
0xF0D3, 0x1083, 0xF888, 0x067F, 0x0409, 0xF940, 0xFA95, 0xF12E,
0xF78B, 0xEEB6, 0x0048, 0xF77F, 0xFFFB, 0x03DB, 0xFDEE, 0x0E60,
0x0609, 0x0F33, 0x0E0A, 0x0628, 0x0286, 0x0230, 0xF41F, 0xFBEF,
0xFACA, 0xF21E, 0x015B, 0xF344, 0xFD73, 0xF91A, 0xFFEF, 0x0149,
0x041B, 0x0E8D, 0x03C9, 0x1489, 0x087B, 0x0F57, 0x0F6D, 0x00E0,
0x098F, 0xF180, 0xF287, 0xEFE2, 0xE796, 0xF349, 0xF68C, 0xF75A,
0xFC8F, 0x0149, 0xF8A1, 0x0AFF, 0x0052, 0x1100, 0x088E, 0x0CCA,
0x0BF5, 0x045C, 0x0F3C, 0xFDD7, 0x101C, 0xF128, 0x04C2, 0xED4F,
0xF1D8, 0xF999, 0xF343, 0x04CD, 0xFEE2, 0x0D14, 0xFAA2, 0x10F9,
0xF933, 0x0ADE, 0x02CF, 0x02A2, 0x0464, 0xFC02, 0xFF35, 0xF6AB,
0x030A, 0xF2B7, 0x0A9E, 0xF134, 0x013B, 0xFB63, 0xF1D7, 0x0B61,
0xF961, 0x1333, 0x07D9, 0x120C, 0x0499, 0x0855, 0x01C0, 0xFD0E,
0x0314, 0xF6FF, 0xFF70, 0xF4CA, 0x00B0, 0xF817, 0x07A1, 0xFA92,
0x087B, 0xFE3C, 0xF899, 0x0B5D, 0xEF3B, 0x11EA, 0xFD8F, 0x0A96,
0x02B1, 0xFFFB, 0xFA69, 0xF879, 0xFA43, 0xF425, 0xFD6B, 0xF338,
0x0248, 0xFC22, 0x0AF2, 0x08C2, 0x12E9, 0x0B99, 0x0FE1, 0x099A,
0xFE66, 0x0AF6, 0xF811, 0x05DD, 0xFF88, 0xFB7A, 0xFAB7, 0xF5F0,
0xF04C, 0xF27D, 0xF431, 0xF6A5, 0xFF6C, 0x03A6, 0x0549, 0x0F17,
0x0D71, 0x0DC8, 0x16A7, 0x02EA, 0x0B52, 0xFEC6, 0xF4E0, 0xFBD2,
0xF617, 0xF866, 0x0157, 0xFAA9, 0xF92D, 0xFC0D, 0xF4CB, 0x011F,
0x02B7, 0x0C8F, 0x0CE1, 0x1119, 0x0EE1, 0x08F2, 0x1091, 0xFC76,
0x0AF4, 0xF340, 0xF881, 0xF1C2, 0xEB46, 0xF8EE, 0xF29C, 0x0037,
0xF810, 0x03E9, 0xF480, 0x09E0, 0xFF1D, 0x0EA8, 0x0CEC, 0x090C,
0x0F70, 0xFE31, 0x0E22, 0xFC3F, 0x0F11, 0xF964, 0x0D0E, 0xF412,
0xFCFE, 0xFF69, 0xF201, 0x0AEB, 0xF76F, 0x0B16, 0xF970, 0x09E8,
0xF874, 0x0646, 0xFEBD, 0xFE30, 0x0431, 0xF6C1, 0x0376, 0xF9C1,
0x06D7, 0xFB40, 0x10C2, 0xF95E, 0x0D00, 0x0396, 0xF687, 0x0B51,
0xF021, 0x08BC, 0xFDE5, 0x0754, 0xFE09, 0x045D, 0xF86D, 0xFACC,
0x009D, 0xF824, 0x0A66, 0xFEE0, 0x0DEA, 0x0070, 0x112E, 0x0210,
0x1101, 0x04E5, 0xFEEE, 0x02EC, 0xE8BC, 0x0109, 0xEC13, 0xFFE4,
0xF55E, 0xFD4C, 0xF34D, 0xF943, 0xFB3D, 0xFBAE, 0x0B9A, 0x0264,
0x1472, 0x05F7, 0x161F, 0x0E18, 0x169F, 0x0C76, 0x0D1B, 0xFCCA,
0xF429, 0xF8B2, 0xE5CD, 0xFC72, 0xEFB2, 0xFAB6, 0xF818, 0xF89E,
0xF8DF, 0xFE89, 0x056F, 0x074C, 0x11A8, 0x0D33, 0x102D, 0x0F16,
0x0A94, 0x0574, 0x0537, 0xF576, 0xF9C9, 0xEED6, 0xE8D8, 0xF559,
0xEAA8, 0xF9F3, 0xFE3D, 0xFFE8, 0x080B, 0x0DD5, 0x0BCD, 0x1318,
0x1203, 0x1288, 0x112A, 0x0C00, 0x06E0, 0xFBE1, 0xFAD5, 0xEEC8,
0xF6B8, 0xE92B, 0xF467, 0xEEC7, 0xECA0, 0xFAC0, 0xF490, 0x0868,
0x08BA, 0x1453, 0x0C70, 0x1607, 0x0798, 0x0F4C, 0x05BF, 0x016A,
0xFE17, 0xF2EC, 0xF5DC, 0xEEB4, 0xFD78, 0xF1CF, 0x0969, 0xF443,
0x027C, 0x007F, 0xFC9D, 0x143F, 0x09CA, 0x1785, 0x0C58, 0x0F55,
0xFCA4, 0x037B, 0xF1F1, 0xF4CF, 0xEE1B, 0xED9D, 0xF049, 0xEDA4,
0xFC9E, 0xF5A7, 0x0C43, 0xFDFE, 0x12DF, 0x062E, 0x09D9, 0x11AD,
0x00B7, 0x11E1, 0x020C, 0x099B, 0xFB43, 0xFDE6, 0xEBC3, 0xF373,
0xEBCF, 0xF124, 0xFB7C, 0xF548, 0x0874, 0xFDF8, 0x111E, 0x0593,
0x1A40, 0x0920, 0x13F8, 0x07E2, 0xFA8A, 0x071A, 0xEB06, 0x00D7,
0xE954, 0xF43D, 0xE5BB, 0xF248, 0xEBC1, 0xF660, 0xFEF0, 0xFC8C,
0x0E86, 0x04D5, 0x1855, 0x0D7A, 0x1E7C, 0x1079, 0x192C, 0x0507,
0x01C4, 0xFDFF, 0xE5AE, 0xFA95, 0xDFEC, 0xF144, 0xE908, 0xEFD1,
0xF003, 0xF8CB, 0xFE67, 0x0329, 0x0DDF, 0x07DC, 0x13EB, 0x0B41,
0x12D8, 0x09E9, 0x0D19, 0x0170, 0x01C1, 0xF799, 0xEB09, 0xEF1E,
0xDD60, 0xF093, 0xE9ED, 0xFA7E, 0xFDD4, 0x05FC, 0x0961, 0x0B7C,
0x0F12, 0x0CBB, 0x134A, 0x0D34, 0x0FC5, 0x044F, 0x0517, 0xFC52,
0xFCD4, 0xF19B, 0xF2CD, 0xE611, 0xE466, 0xF0D6, 0xE62D, 0x01CF,
0xFB1A, 0x06F5, 0x065E, 0x0857, 0x0741, 0x0D80, 0x08B0, 0x0A02,
0x0655, 0xFEEA, 0x038E, 0xFC04, 0x0117, 0xF5CD, 0xFF1C, 0xEF23,
0xFB5E, 0xF7E8, 0xF613, 0x069D, 0xFA4B, 0x0652, 0x0171, 0x0127,
0xFFE5, 0x0734, 0xFC11, 0x04B5, 0xFC9E, 0xFD4A, 0xFE67, 0xF792,
0xFC9C, 0xF341, 0xFFBC, 0xFA6C, 0x0926, 0xFF11, 0x044C, 0x0068,
0xF6B3, 0x018A, 0xF7E4, 0x05E7, 0xFE68, 0x0B62, 0xFE93, 0x0706,
0xFFE6, 0x0267, 0x0141, 0xFAB0, 0x0293, 0xF610, 0x0650, 0xFBA3,
0x0AE2, 0xFC57, 0x08AF, 0xF6BD, 0xF6E3, 0xF9CB, 0xEAB7, 0x0698,
0xF251, 0x0769, 0xFBC2, 0x0448, 0xFDCC, 0x0460, 0xFDA2, 0xFC5C,
0x026B, 0xF95E, 0x099B, 0xFD28, 0x0C31, 0xFED8, 0x0A80, 0xF917,
0x0281, 0xFBDA, 0xF5B0, 0x0A8B, 0xF4C5, 0x09E2, 0xFDDB, 0x0383,
0xFE98, 0xFED8, 0xFB38, 0xFA8D, 0xFB1E, 0xFA7C, 0xFF37, 0xF80F,
0x01FE, 0xF6ED, 0x0207, 0xFAA9, 0x0787, 0x03A6, 0x0571, 0x0847,
0xFC09, 0x0A52, 0xFE26, 0x0A94, 0x02D3, 0x00EA, 0xFE53, 0xFC2D,
0xF92C, 0xFC20, 0xFA5B, 0xF9EE, 0xFEF9, 0xF56E, 0x04D3, 0xFA81,
0x0BF7, 0x06AD, 0x0FF2, 0x0572, 0x0810, 0x07D1, 0xFA84, 0x05BF,
0xF553, 0xF9A4, 0xF1CC, 0xF774, 0xEE63, 0xF9E9, 0xF16C, 0xFABC,
0xFA41, 0xFA17, 0x0A6A, 0x0582, 0x15F8, 0x104B, 0x1C7C, 0x0DD4,
0x1A31, 0x08B4, 0x034B, 0xFE1F, 0xEF2F, 0xF680, 0xE78D, 0xF2A5,
0xE72C, 0xF3CA, 0xEEA4, 0xF93D, 0xFA0A, 0x022A, 0x0919, 0x0E8B,
0x16C2, 0x0FA1, 0x1EB8, 0x1004, 0x1A7B, 0x0434, 0x04AF, 0xF060,
0xE799, 0xF0FE, 0xDBE7, 0xF626, 0xE784, 0xFA3B, 0xF6C8, 0xFFF6,
0x03FB, 0x0F00, 0x1077, 0x192C, 0x1E42, 0x10A4, 0x21C5, 0x070D,
0x1185, 0xF481, 0xFCCF, 0xE6B5, 0xE364, 0xEA06, 0xD57F, 0xF1D7,
0xE2A5, 0xFA26, 0xF58C, 0x05A2, 0x0753, 0x186A, 0x1611, 0x1BF7,
0x1E05, 0x121D, 0x1B6D, 0x0192, 0x0A8B, 0xEF8A, 0xF747, 0xEC39,
0xEAD9, 0xEBB5, 0xE68B, 0xF358, 0xEB97, 0xFDF7, 0xFB5B, 0x0B64,
0x0C6B, 0x1884, 0x171D, 0x141F, 0x1702, 0x0CD7, 0x07FF, 0xF93F,
0xF884, 0xE8FA, 0xECFE, 0xED4D, 0xEC75, 0xF0C4, 0xF4A6, 0xF51D,
0xF6B3, 0x01A3, 0x0090, 0x175F, 0x1049, 0x1BCB, 0x186E, 0x115E,
0x10D5, 0x07A8, 0xFCF2, 0xF60A, 0xF1E3, 0xEC91, 0xEF84, 0xEB2E,
0xF33F, 0xF107, 0xFF71, 0xF765, 0x062F, 0x03C0, 0x0337, 0x151D,
0x0683, 0x10F4, 0x0A58, 0x0B4D, 0xFF75, 0x0065, 0xF252, 0xF372,
0xEBF0, 0xF48C, 0xF147, 0xF51B, 0x0111, 0xFAC4, 0x0F5D, 0x01FF,
0x1808, 0x0CC4, 0x11E7, 0x1063, 0x076B, 0x09EE, 0x0083, 0x0354,
0xF2AB, 0xF308, 0xE964, 0xF036, 0xE7B9, 0xF7D5, 0xEF5F, 0xFA9E,
0x03AC, 0xFC27, 0x1360, 0x050B, 0x1957, 0x11BD, 0x15F9, 0x0A02,
0x076C, 0x0634, 0xF606, 0x00E5, 0xEB3F, 0xF398, 0xE767, 0xF745,
0xEBB1, 0xFC7B, 0xFA38, 0x0158, 0x0D7A, 0x0043, 0x1C7A, 0x036B,
0x1B78, 0x0AF2, 0x1649, 0x05EA, 0x0AB8, 0x01EC, 0xEEC8, 0xF6A2,
0xDDC1, 0xF1D3, 0xDCEF, 0xF92D, 0xE968, 0xFE9B, 0xFF82, 0x01E2,
0x0EF6, 0x03F4, 0x1985, 0x0CD8, 0x1F1E, 0x0C7A, 0x1C69, 0x0BBA,
0x0F4B, 0x0411, 0xF66A, 0xF283, 0xDF8B, 0xF486, 0xDC2E, 0xF6C3,
0xEB8C, 0xF763, 0xFF9C, 0xFA7E, 0x0CE5, 0x05D5, 0x11CD, 0x1082,
0x17D9, 0x0856, 0x173D, 0x0993, 0x08D3, 0x0264, 0xF845, 0xF3DA,
0xE3ED, 0xF69B, 0xDDC6, 0xF9A1, 0xF0E2, 0xF92B, 0x01E2, 0xFCF7,
0x0D68, 0x0E0B, 0x174E, 0x12B7, 0x19EA, 0x0B67, 0x15DC, 0x04E8,
0x08A6, 0xF6A4, 0xF751, 0xF459, 0xE8ED, 0xF3EE, 0xE3C9, 0xF2DB,
0xEB6C, 0xF59E, 0xF90A, 0x018A, 0x0991, 0x13B9, 0x16D9, 0x1129,
0x150D, 0x10BC, 0x0E20, 0x081C, 0x0876, 0xF70A, 0xF856, 0xF7F8,
0xEFD6, 0xF45D, 0xF405, 0xF190, 0xF429, 0xF746, 0xFC78, 0x0730,
0x0A55, 0x0F4E, 0x1056, 0x0CFD, 0x0EDD, 0x112F, 0x0556, 0x02E6,
0xF930, 0xF207, 0xEF5A, 0xEF59, 0xF07E, 0xF42E, 0xFCD6, 0xF6A3,
0x01A8, 0xFCA7, 0x03AC, 0x11A9, 0x0BDC, 0x130D, 0x0DD0, 0x11C7,
0x0B92, 0x0F9D, 0x03F1, 0xFAF4, 0xF307, 0xEF2B, 0xEDCB, 0xE881,
0xF79F, 0xED95, 0x0537, 0xF7F0, 0x0FFF, 0x0570, 0x0C67, 0x128B,
0x0452, 0x103E, 0x0232, 0x13DE, 0xFFD0, 0x079B, 0xF734, 0xF209,
0xE816, 0xEED5, 0xE943, 0xF0F5, 0x025E, 0xF55B, 0x1466, 0xFF02,
0x1878, 0x1238, 0x189E, 0x13A2, 0x0B90, 0x0FA8, 0xFE17, 0x0DEA,
0xF727, 0xF4B9, 0xE66F, 0xE868, 0xDD9C, 0xED7E, 0xEBFB, 0xF5FB,
0x03FE, 0xFA16, 0x13BC, 0x031D, 0x19CF, 0x1992, 0x1D17, 0x1810,
0x1098, 0x10A3, 0xFCEB, 0x0563, 0xEC67, 0xEF9E, 0xDA35, 0xEA6D,
0xDE10, 0xF05B, 0xFA6F, 0xFBEF, 0x0C87, 0x00D3, 0x14DB, 0x0963,
0x20E3, 0x131B, 0x1E7A, 0x1256, 0x1232, 0x0C8D, 0xFDF9, 0xF518,
0xDA39, 0xE7AC, 0xCB7F, 0xEB71, 0xE01B, 0xF409, 0xFBF9, 0xFE5B,
0x0A10, 0x0663, 0x1472, 0x1778, 0x24B4, 0x1566, 0x2185, 0x0CC8,
0x131C, 0x076A, 0x00B1, 0xEF6D, 0xDCA8, 0xE4E1, 0xD1AF, 0xEA00,
0xE82F, 0xF350, 0xF91A, 0xFB5F, 0x0620, 0x0994, 0x1694, 0x1B03,
0x1D0D, 0x11A3, 0x1716, 0x06FE, 0x0D65, 0xFF8C, 0xF934, 0xF050,
0xE0D0, 0xE842, 0xDAE8, 0xEE17, 0xE965, 0xFBEE, 0xF885, 0x0033,
0x0520, 0x0DBB, 0x1AE8, 0x1859, 0x1D1B, 0x10C6, 0x117C, 0x064B,
0x0DA0, 0xF298, 0xF7BB, 0xEA8D, 0xE522, 0xEC04, 0xE503, 0xF127,
0xE754, 0xFA6E, 0xEF84, 0x004B, 0x01C2, 0x0FFB, 0x1549, 0x143C,
0x1339, 0x1148, 0x0DE6, 0x0BEF, 0x0C9E, 0xF539, 0xF683, 0xE8D8,
0xE6B2, 0xEF35, 0xF046, 0xF92D, 0xF5B0, 0xF7D8, 0xF5BC, 0xFBBE,
0x075F, 0x0AF0, 0x1082, 0x0D71, 0x0B8F, 0x0F6D, 0x10E5, 0x0850,
0x01BD, 0xF2A5, 0xE64B, 0xE6F6, 0xE47F, 0xF02C, 0xF3B7, 0xFD71,
0xFD9F, 0xF878, 0xFEBE, 0x0007, 0x0A1F, 0x114E, 0x0D4E, 0x124A,
0x0BED, 0x0FED, 0x1154, 0x031E, 0xF84B, 0xF1EA, 0xDF08, 0xE996,
0xE91D, 0xEC73, 0xFB03, 0xF40D, 0x0475, 0xF815, 0x0B42, 0x05CF,
0x0B93, 0x1124, 0x053D, 0x1227, 0x09E6, 0x0D61, 0x01D6, 0xFC55,
0xE43D, 0xEF02, 0xD989, 0xEFD8, 0xECE0, 0xF37F, 0x037A, 0xF0AA,
0x0B4A, 0xFBE6, 0x191D, 0x139C, 0x1C94, 0x1485, 0x0E1F, 0x0D11,
0x0A02, 0x0430, 0xF23C, 0xF13D, 0xD474, 0xE826, 0xD9DB, 0xEE2C,
0xEE68, 0xF4EE, 0xFF0D, 0xF24C, 0x0D3F, 0x0310, 0x2010, 0x1D46,
0x22B6, 0x17EF, 0x1232, 0x0E3E, 0x00E4, 0x02BA, 0xE284, 0xEBE3,
0xCC26, 0xE4B5, 0xDB5F, 0xEECE, 0xF6CD, 0xF76B, 0x05F5, 0xFA4D,
0x1AC4, 0x0A50, 0x2D0C, 0x19D6, 0x24FA, 0x16FA, 0x145B, 0x0C12,
0xF5AF, 0xF536, 0xCF7D, 0xE238, 0xC5A5, 0xE459, 0xD863, 0xF1AC,
0xF582, 0xFBC5, 0x0C51, 0x0747, 0x24CF, 0x1A1D, 0x312F, 0x1A74,
0x2174, 0x1306, 0x127E, 0x0977, 0xF710, 0xEB3C, 0xCEF2, 0xD9EC,
0xC8BA, 0xE289, 0xDF2E, 0xF3DA, 0xF839, 0xFF09, 0x138A, 0x0B72,
0x2858, 0x1FA5, 0x25FD, 0x1ACC, 0x1848, 0x0D81, 0x0BC5, 0x00DF,
0xF081, 0xE697, 0xCEA6, 0xDE51, 0xCD2B, 0xEE16, 0xE7FD, 0xFDF7,
0xFD5F, 0x0185, 0x1592, 0x1168, 0x2B45, 0x2311, 0x22F3, 0x1672,
0x16E6, 0x0461, 0x0D5D, 0xEFBC, 0xEDB4, 0xE10C, 0xD330, 0xE608,
0xD778, 0xF4C8, 0xEB61, 0xFF8B, 0xFEAD, 0x0136, 0x0FF1, 0x15ED,
0x1DD8, 0x1FFD, 0x1D71, 0x1196, 0x164F, 0x0592, 0x0ABF, 0xEB9A,
0xEAEC, 0xE263, 0xD9C5, 0xF29E, 0xEA5D, 0xFD7E, 0xF77A, 0xFC72,
0x017A, 0xFDCC, 0x1033, 0x13A6, 0x16C1, 0x1662, 0x1662, 0x09E9,
0x1245, 0x007B, 0x0030, 0xED04, 0xE2EC, 0xEB01, 0xDDC3, 0xF9BD,
0xF15E, 0x038B, 0xFBDA, 0xFCDC, 0x01B9, 0x02DB, 0x10FF, 0x15A8,
0x14F9, 0x0D30, 0x0DEE, 0x073F, 0x1185, 0x0018, 0x017F, 0xF21D,
0xE349, 0xF0FA, 0xE7D8, 0xF78D, 0xF98F, 0x009C, 0x008C, 0xF910,
0x0739, 0x0272, 0x1148, 0x11A2, 0x0FF7, 0x07D7, 0x02D2, 0x082A,
0x052E, 0x01F8, 0xF9A7, 0xF8BD, 0xE0FE, 0xFAE2, 0xEB08, 0xFCA9,
0xFCBC, 0xF9EA, 0x07B7, 0xF63D, 0x16EF, 0x0799, 0x1CCD, 0x0C82,
0x0FD7, 0x0370, 0x0264, 0x05B2, 0xFFA1, 0xFE45, 0xEB83, 0xF813,
0xDB2C, 0xF9AC, 0xE6C4, 0xFD5F, 0xFA25, 0xF4B6, 0x0E0B, 0xF64D,
0x1F5E, 0x0FF4, 0x2302, 0x1078, 0x0CFC, 0x0BA9, 0x0151, 0x07DA,
0xFA03, 0xFA54, 0xD8AE, 0xF6BB, 0xD4F2, 0xF713, 0xEE12, 0xF8FC,
0x0471, 0xEDB3, 0x1B3D, 0xF662, 0x2B72, 0x139E, 0x2823, 0x13A4,
0x0A69, 0x0DAE, 0xFC03, 0x03C3, 0xEA9D, 0xF549, 0xC210, 0xF0DA,
0xC7A9, 0xF443, 0xF107, 0xF735, 0x0FA8, 0xF39B, 0x24A8, 0x07B2,
0x338E, 0x1B9A, 0x28FA, 0x178E, 0x0DAC, 0x0FC3, 0x01A9, 0xFD78,
0xDF4B, 0xEAD0, 0xBA6F, 0xE3F3, 0xCB81, 0xED44, 0xF564, 0xF1F1,
0x16B6, 0xF7AC, 0x2914, 0x17DD, 0x32FD, 0x22CD, 0x1F5E, 0x1862,
0x078F, 0x0D74, 0xFECA, 0xF959, 0xD2A4, 0xE955, 0xB920, 0xE152,
0xD6B4, 0xEA26, 0xFC00, 0xF4BC, 0x1C77, 0x064C, 0x3419, 0x22FC,
0x3640, 0x225B, 0x1987, 0x11C3, 0x0991, 0x029D, 0xFC18, 0xF0F3,
0xCC4C, 0xE18C, 0xBF26, 0xDE36, 0xDF2C, 0xEC25, 0xFCB2, 0xFAE5,
0x1544, 0x1331, 0x3007, 0x2973, 0x2E4F, 0x233F, 0x0EB0, 0x106F,
0x09E8, 0xFD27, 0xF8C2, 0xED6C, 0xD0DC, 0xDF6F, 0xD41E, 0xE1B7,
0xEE3E, 0xF0CE, 0x04DA, 0xFC02, 0x180E, 0x1727, 0x27E0, 0x260B,
0x1D94, 0x1771, 0x05EE, 0x0918, 0x079A, 0xFBE3, 0xF05B, 0xEC32,
0xD298, 0xE179, 0xE1A3, 0xEDAE, 0xF88E, 0xFD72, 0x0947, 0x045F,
0x17D9, 0x1845, 0x1C8E, 0x1E3A, 0x0CFC, 0x0EB5, 0x07FB, 0x02A2,
0x0D67, 0xF7EE, 0xEEAD, 0xE851, 0xDB7B, 0xE491, 0xEE69, 0xF67A,
0x011C, 0x016E, 0x0A8C, 0x08CB, 0x10A1, 0x15DC, 0x0CC8, 0x1428,
0xFAC3, 0x09ED, 0x043F, 0x012E, 0x0BAD, 0xFA5A, 0xE901, 0xEEFA,
0xE04F, 0xEDAA, 0xF98E, 0xFF91, 0x0D06, 0x0545, 0x1431, 0x0913,
0x14F7, 0x0E6C, 0x0ADB, 0x05A4, 0xFBCB, 0x0083, 0x05E4, 0xFD9E,
0xFF67, 0xF66C, 0xDF72, 0xEF00, 0xE16B, 0xF804, 0xF9E2, 0x06A4,
0x0DE9, 0x0407, 0x1895, 0x0A25, 0x18ED, 0x1153, 0x0AD0, 0x05C2,
0xFFC4, 0xFCC9, 0x03D8, 0xFDFF, 0xEEF3, 0xF67E, 0xD98B, 0xEE21,
0xE8DD, 0xFC83, 0x00B4, 0x02D5, 0x1601, 0xFF89, 0x22E7, 0x0AAF,
0x20A5, 0x0E55, 0x0E5E, 0x069F, 0xFF83, 0xFE05, 0xF51B, 0xFABA,
0xD56F, 0xF368, 0xCB48, 0xF03C, 0xE7CA, 0xFFD6, 0x0538, 0x021E,
0x1C84, 0x02FA, 0x2D0C, 0x0FD2, 0x2E72, 0x1100, 0x1929, 0x0988,
0x0462, 0xFC67, 0xEC3D, 0xF0B0, 0xC659, 0xE888, 0xC3C6, 0xED1B,
0xE5A2, 0xF9F1, 0x09AB, 0xFEBC, 0x23AD, 0x0C4C, 0x31AC, 0x186F,
0x3043, 0x1766, 0x19B4, 0x0C76, 0x00B3, 0xFEDD, 0xDD37, 0xF0A4,
0xB98E, 0xE165, 0xC365, 0xECF9, 0xEA11, 0xFAE6, 0x13F8, 0x0148,
0x336E, 0x13E4, 0x3BD1, 0x1B82, 0x3036, 0x1752, 0x172E, 0x0734,
0xF981, 0xF7AB, 0xCD7A, 0xE9A7, 0xB0DE, 0xDCC2, 0xC3E2, 0xEC85,
0xEB78, 0xFCE7, 0x17C8, 0x0A22, 0x37CD, 0x1C9F, 0x3D59, 0x2155,
0x2A1D, 0x1819, 0x0DE9, 0x01F7, 0xF2DA, 0xF140, 0xCB85, 0xE290,
0xBC65, 0xDD73, 0xD634, 0xEB93, 0xFB1C, 0xFC3B, 0x201C, 0x1204,
0x3470, 0x1BD5, 0x338A, 0x1E38, 0x1B2F, 0x1496, 0xFB3D, 0xFA45,
0xE295, 0xEAE8, 0xC91C, 0xDEA7, 0xCB04, 0xE675, 0xE93F, 0xF724,
0x0A06, 0x02C0, 0x247E, 0x16E1, 0x2DD8, 0x1C21, 0x26A5, 0x1B0D,
0x0E84, 0x080E, 0xF4CC, 0xEDBB, 0xDE27, 0xE575, 0xCF85, 0xDF49,
0xE017, 0xEDB3, 0xFB57, 0x0029, 0x12F6, 0x0BA3, 0x1FCD, 0x169D,
0x1B05, 0x19FB, 0x0E52, 0x1502, 0xF9BE, 0xF9EC, 0xEAD9, 0xEA07,
0xDB62, 0xE6D4, 0xD967, 0xE719, 0xF6EB, 0xF915, 0x1143, 0x06D5,
0x21DD, 0x1162, 0x2171, 0x1014, 0x10D4, 0x10D4, 0xFF33, 0x0A16,
0xEA99, 0xEB64, 0xE012, 0xE766, 0xD922, 0xEC88, 0xE0A8, 0xF421,
0xFF90, 0x0384, 0x1B3F, 0x0BC2, 0x276B, 0x15E5, 0x1C15, 0x0FCD,
0x08D4, 0x0AD9, 0xF4B6, 0xFC68, 0xE1CB, 0xE5BE, 0xDBDE, 0xE99E,
0xDDFD, 0xEEF1, 0xF30B, 0xFA49, 0x0E92, 0x0608, 0x236D, 0x0CBC,
0x2A14, 0x0FD9, 0x1839, 0x0B70, 0x037B, 0x08B8, 0xE899, 0xEF47,
0xD4DE, 0xE574, 0xD20A, 0xF07B, 0xD9C5, 0xF2BA, 0xF9C3, 0x031F,
0x1576, 0x0C09, 0x267C, 0x0FA7, 0x2C80, 0x0D03, 0x1DD0, 0x0AE8,
0x09E4, 0x057E, 0xEAF1, 0xE3EB, 0xD361, 0xE247, 0xCEC6, 0xF059,
0xDC56, 0xF439, 0xFB1D, 0x04EE, 0x1388, 0x0F2E, 0x2586, 0x13F0,
0x27AA, 0x0DD9, 0x1D6A, 0x0DC2, 0x0A2B, 0x018A, 0xE6C4, 0xE40A,
0xCF25, 0xE473, 0xCC3F, 0xEC6F, 0xE06A, 0xF95B, 0xFC0E, 0x068A,
0x16A5, 0x0E4E, 0x30C7, 0x1386, 0x2D95, 0x0F2F, 0x205D, 0x10F2,
0x08E9, 0xF681, 0xE10C, 0xDFEA, 0xC9C1, 0xE786, 0xC665, 0xE947,
0xDA8E, 0xFAD5, 0xF7D2, 0x0986, 0x17F0, 0x1221, 0x3137, 0x187E,
0x2EE0, 0x191D, 0x20B5, 0x1293, 0x0113, 0xEBBE, 0xDEBE, 0xDECF,
0xCF71, 0xE80E, 0xCFDB, 0xE65F, 0xE327, 0xF75B, 0x00A3, 0x0A43,
0x22AE, 0x15EF, 0x2FF4, 0x19C7, 0x2936, 0x2011, 0x1660, 0x0D05,
0xED81, 0xE2D8, 0xD43A, 0xE063, 0xCF78, 0xE6C7, 0xD7C8, 0xECE6,
0xEE9B, 0xFCC3, 0x0D3F, 0x0DC4, 0x2D24, 0x1D11, 0x2D80, 0x1CEE,
0x220A, 0x1B1E, 0x0D5B, 0xFAAF, 0xE3CB, 0xDA3B, 0xD024, 0xE094,
0xD51C, 0xE3B9, 0xE7BB, 0xF29A, 0xFE4D, 0x0805, 0x17C6, 0x1660,
0x2923, 0x1F5F, 0x2005, 0x1E40, 0x1091, 0x10B4, 0xF341, 0xEA49,
0xD54A, 0xDB02, 0xD125, 0xE417, 0xE13A, 0xE973, 0xFDA1, 0xFDE5,
0x17C0, 0x142B, 0x2D90, 0x1C33, 0x28C5, 0x16E2, 0x156F, 0x15B1,
0x018D, 0xFE8A, 0xD856, 0xD70D, 0xC64D, 0xDC0F, 0xD466, 0xEB0B,
0xEB89, 0xF5B1, 0x0BBC, 0x0DAD, 0x2834, 0x201D, 0x3434, 0x20EE,
0x20E9, 0x13CE, 0x0961, 0x0B4E, 0xEC62, 0xED22, 0xC555, 0xCEDA,
0xC5BB, 0xDCE8, 0xE464, 0xF0F2, 0x037E, 0x037E, 0x1E32, 0x1A56,
0x356D, 0x21F6, 0x3428, 0x1A2B, 0x1678, 0x1130, 0xF7D4, 0xFECD,
0xCEC7, 0xDB37, 0xB76C, 0xD022, 0xC870, 0xE45B, 0xEBD3, 0xFCA5,
0x1282, 0x14AE, 0x2B28, 0x23F2, 0x39D1, 0x2179, 0x2F84, 0x13FA,
0x12E5, 0x0975, 0xF0F0, 0xEE03, 0xC3CE, 0xCAFB, 0xBAF8, 0xD2D3,
0xD803, 0xF000, 0xF808, 0x0480, 0x16DB, 0x1B89, 0x2EE1, 0x2911,
0x32C3, 0x1EFC, 0x1F14, 0x0E56, 0x0806, 0x0028, 0xE35E, 0xE45D,
0xBEE3, 0xCB68, 0xC5BD, 0xDC25, 0xE719, 0xFEB6, 0x0473, 0x0C48,
0x1C32, 0x191A, 0x345B, 0x23BE, 0x3092, 0x1770, 0x1671, 0x06B0,
0x01C3, 0xF426, 0xDBCD, 0xDA90, 0xC270, 0xD351, 0xD0E9, 0xEC70,
0xEB53, 0x0599, 0x0560, 0x0FAF, 0x1B27, 0x1C99, 0x2938, 0x1EE8,
0x22F7, 0x12D0, 0x115E, 0x04DA, 0xF84E, 0xEFB8, 0xD756, 0xD84C,
0xD1FD, 0xDC5E, 0xE59F, 0xF78C, 0xF801, 0x00DE, 0x0B8A, 0x0DDA,
0x1F0F, 0x1E89, 0x1FBA, 0x1436, 0x13F2, 0x0A86, 0x0732, 0x0306,
0xE82A, 0xEF1A, 0xD0D4, 0xDB1C, 0xDAC5, 0xE605, 0xEEE3, 0x0060,
0x019B, 0x02C9, 0x11EA, 0x0F97, 0x1EB3, 0x1E70, 0x1C44, 0x12B7,
0x0F83, 0x04B6, 0x0280, 0xFB9D, 0xE63F, 0xECF2, 0xD5AC, 0xDD70,
0xE702, 0xEA97, 0xFC18, 0xFDED, 0x09E2, 0x05E6, 0x1391, 0x14CE,
0x1684, 0x19CB, 0x1309, 0x12E5, 0x0538, 0x03CD, 0xEE3E, 0xF889,
0xDAE3, 0xEAB9, 0xDAB0, 0xE0AE, 0xEF13, 0xF347, 0x0799, 0xFDDF,
0x192E, 0x09B4, 0x2273, 0x19B2, 0x1EC6, 0x153F, 0x1140, 0x0DFA,
0xFE5C, 0x02CE, 0xE12D, 0xF32C, 0xCE80, 0xDEE9, 0xDB8D, 0xE44C,
0xF2D5, 0xFC54, 0x0B76, 0x00FD, 0x217C, 0x0FAD, 0x25D4, 0x2058,
0x1ED4, 0x1A5A, 0x0B91, 0x0805, 0xF0C4, 0xFE71, 0xD585, 0xEDEB,
0xCB06, 0xD450, 0xE50D, 0xE53E, 0x0389, 0xFEB1, 0x1AB3, 0x08C9,
0x2E10, 0x17DD, 0x2E88, 0x211A, 0x1D96, 0x1C7C, 0xFE0F, 0x03D4,
0xDCCB, 0xF429, 0xC6F3, 0xE3D4, 0xC8D6, 0xD54A, 0xE542, 0xEB82,
0x0C9C, 0x059A, 0x2B30, 0x171E, 0x339E, 0x22D9, 0x3085, 0x24B2,
0x1AC9, 0x14FE, 0xF7AD, 0xFAAB, 0xD984, 0xE7AD, 0xC55B, 0xD43A,
0xD255, 0xDA4F, 0xF1F5, 0xF448, 0x1488, 0x0BB2, 0x2E9B, 0x223D,
0x2EA4, 0x2CD7, 0x24A7, 0x252E, 0x09C3, 0x0542, 0xE94F, 0xF26F,
0xD3A1, 0xE3DC, 0xCA52, 0xCCA6, 0xDEE6, 0xE135, 0x0294, 0x051D,
0x2152, 0x1724, 0x31B1, 0x23DA, 0x3231, 0x2D6F, 0x1CE3, 0x1CA5,
0xFCEF, 0xF660, 0xE750, 0xE88F, 0xD337, 0xDD2B, 0xD3B5, 0xD310,
0xECAC, 0xEC40, 0x0D44, 0x12F6, 0x223D, 0x236C, 0x2313, 0x24E6,
0x23E3, 0x2824, 0x0E42, 0x0E03, 0xF048, 0xEE20, 0xE33A, 0xE2B6,
0xDC3E, 0xD738, 0xEAD3, 0xDE83, 0x059E, 0xF9D9, 0x1B03, 0x1929,
0x205C, 0x2669, 0x1B29, 0x23C5, 0x0FF8, 0x1956, 0xF87E, 0xFD64,
0xE62F, 0xECE7, 0xDDE9, 0xE231, 0xE603, 0xD91D, 0xFAE1, 0xEDC5,
0x141A, 0x1076, 0x2125, 0x1EB7, 0x189B, 0x1E97, 0x1277, 0x21AF,
0xFF7D, 0x0949, 0xEDB2, 0xEB06, 0xEB79, 0xE89B, 0xE7E3, 0xE371,
0xF779, 0xE198, 0x0F53, 0xFA8A, 0x1DBA, 0x1D53, 0x1911, 0x1F16,
0x0C80, 0x15EF, 0x0321, 0x17C5, 0xED2A, 0xFE3F, 0xE242, 0xE773,
0xE834, 0xE87C, 0xF511, 0xE92F, 0x0500, 0xF107, 0x1797, 0x0A1F,
0x22C9, 0x1EA5, 0x18D1, 0x1890, 0x0F32, 0x0F04, 0xFB1F, 0x04AB,
0xE8DB, 0xF4A8, 0xE5E1, 0xEAAD, 0xE6ED, 0xE683, 0xF98E, 0xEE4C,
0x0838, 0x006D, 0x14BF, 0x1620, 0x1A20, 0x1900, 0x118B, 0x1229,
0x091F, 0x0F09, 0xF650, 0xFAAA, 0xEC24, 0xF020, 0xE8B0, 0xF138,
0xEDBB, 0xEA98, 0x00CD, 0xEEE8, 0x0F93, 0x0533, 0x1735, 0x18A4,
0x1563, 0x113B, 0x1460, 0x0925, 0x0568, 0x08AD, 0xF31C, 0xFBD2,
0xEC9C, 0xF13F, 0xE74E, 0xF1F1, 0xF109, 0xF32C, 0xFA05, 0xF535,
0x07BB, 0x0945, 0x138E, 0x1722, 0x1193, 0x0EAC, 0x116B, 0x07C6,
0x062F, 0x0246, 0xFD8E, 0xFE22, 0xF330, 0xF3A3, 0xEDAB, 0xEB0B,
0xF91C, 0xF299, 0xFBDE, 0xFC03, 0xFF60, 0x06D7, 0x0738, 0x0E78,
0x0CFA, 0x0F64, 0x07FF, 0x08CB, 0x0335, 0x006C, 0xFF6F, 0x00CA,
0xF00A, 0xF8D7, 0xF3DA, 0xEAEF, 0xFD4F, 0xF02A, 0xFCEB, 0x0273,
0xFE3F, 0x0742, 0x06F1, 0x066B, 0x1000, 0x0B39, 0x0815, 0x07B6,
0x07D9, 0x02DB, 0x01E1, 0xFC26, 0xF24B, 0xF1EB, 0xF6B7, 0xEF15,
0xFB28, 0xF386, 0xFA23, 0x00EF, 0xFC44, 0x0B01, 0x0245, 0x0AFF,
0x04D0, 0x0887, 0x078B, 0x0901, 0x0646, 0x0871, 0xF876, 0xF88D,
0xFAB3, 0xEA4C, 0x0519, 0xF0E4, 0x0356, 0xF8D8, 0xFF32, 0xFC69,
0x059B, 0x0A92, 0x0721, 0x0F24, 0xFB73, 0x03EB, 0xFEDA, 0x065E,
0xF9CB, 0x06BB, 0xEE0A, 0xF340, 0xFC95, 0xE7F7, 0x09D2, 0xF53C,
0x04C6, 0x0175, 0x033F, 0x017B, 0x0BA8, 0x0B01, 0x023A, 0x104C,
0xF801, 0x05F3, 0xFAFD, 0xFF66, 0xF3C3, 0xF951, 0xF4FB, 0xED98,
0x078D, 0xED86, 0x1460, 0xF974, 0x0BC4, 0x01A6, 0x076C, 0x0BBB,
0x05A8, 0x0F03, 0xF675, 0x0810, 0xF41C, 0x05D7, 0xEBD7, 0xFD4A,
0xE858, 0xEF3B, 0xFE02, 0xED1D, 0x0F2C, 0xF946, 0x12E8, 0xFFF8,
0x129C, 0x01B8, 0x1368, 0x0F48, 0xFFB2, 0x0D0F, 0xF335, 0xFDDF,
0xF6CD, 0xFDCC, 0xE89E, 0xF7F5, 0xEA94, 0xE9A4, 0x027F, 0xF0FE,
0x11EA, 0x04C2, 0x0E9D, 0x06A5, 0x105A, 0x0841, 0x0C7F, 0x10BB,
0xF381, 0x09ED, 0xF4DF, 0xFD8D, 0xF36C, 0xF6C1, 0xE88C, 0xF429,
0xF7E7, 0xF204, 0x0CFC, 0xF874, 0x1818, 0x0484, 0x12AE, 0x081E,
0x0FAD, 0x0CC3, 0x01FD, 0x07DE, 0xF411, 0xFF48, 0xF60C, 0xFF05,
0xE992, 0xF4F1, 0xEFFB, 0xF139, 0x0493, 0xFE62, 0x0C03, 0x05F3,
0x0F54, 0x02A4, 0x109E, 0x076E, 0x0565, 0x0C90, 0xEF08, 0x0083,
0xFA7C, 0xF897, 0xFFFF, 0xF8D6, 0xF010, 0xF54C, 0x01EF, 0xF7CC,
0x1614, 0x064E, 0x12AD, 0x0A18, 0x06D8, 0xFFCF, 0x017D, 0x02BE,
0xEFF7, 0x043E, 0xE474, 0xFB8B, 0xFB53, 0xF8E3, 0xFCBE, 0xF7D6,
0xFBE6, 0xFD8F, 0x13ED, 0x0A09, 0x1B3E, 0x0C44, 0x0D9F, 0x04F5,
0xFF6B, 0x002A, 0xF379, 0xFA62, 0xE365, 0xF3E3, 0xEF3C, 0xF7AE,
0x0186, 0xFAA8, 0x0123, 0xF6F4, 0x14D7, 0x0470, 0x1FB0, 0x198D,
0x109B, 0x0E10, 0x04D6, 0xFAA2, 0xF6F9, 0xFD27, 0xDB94, 0xF5F0,
0xD792, 0xEC7E, 0xFA0F, 0xF78E, 0x0254, 0xFDD5, 0x042B, 0xFF5E,
0x2652, 0x1163, 0x29C5, 0x19FF, 0x0CF1, 0x0584, 0xFFAC, 0xF5D5,
0xF141, 0xF37A, 0xD747, 0xEE1D, 0xDDBA, 0xEFC3, 0xF849, 0xF96F,
0xFD3B, 0xFF28, 0x0E54, 0x0B08, 0x2761, 0x1CBD, 0x1CF2, 0x1218,
0x085A, 0xFC18, 0xFB8B, 0xF7C2, 0xE573, 0xED94, 0xDA6D, 0xEBF8,
0xEB80, 0xFAED, 0xF8AD, 0xFBFE, 0x0227, 0xFD44, 0x1D0C, 0x1496,
0x2356, 0x1D76, 0x1171, 0x011E, 0x0B22, 0xF1B5, 0xF67F, 0xF6DC,
0xD9D2, 0xEFD4, 0xE2FC, 0xF119, 0xF5CC, 0x01AC, 0xF32E, 0x038F,
0x00EF, 0x030A, 0x2098, 0x1768, 0x1913, 0x141E, 0x0472, 0xF549,
0x0811, 0xEE64, 0xF904, 0xF280, 0xE607, 0xF52D, 0xF18C, 0xFDB4,
0xFE84, 0x01E8, 0xFDD9, 0x0269, 0x087B, 0x0B46, 0x1540, 0x14A0,
0x0706, 0x01F9, 0xFF3F, 0xED0A, 0xFDBE, 0xF045, 0xF06F, 0xF4E3,
0xF45C, 0xFED2, 0xFC54, 0x0A96, 0xFCFE, 0x0363, 0x0371, 0x0186,
0x0F15, 0x144F, 0x0B2D, 0x0CB3, 0xFEEA, 0xECE4, 0x02BE, 0xEA03,
0xF7D0, 0xF472, 0xF1DA, 0xF962, 0x01BF, 0x053E, 0xFF75, 0x0D39,
0xF904, 0x055C, 0x04BD, 0x0451, 0x1063, 0x1211, 0xFFC9, 0x030C,
0xF671, 0xE619, 0xFF53, 0xE983, 0xF47D, 0xF973, 0xF3B0, 0x03C4,
0xFFB7, 0x0973, 0x0541, 0x05A6, 0x0627, 0x043C, 0x0AD1, 0x0E16,
0x136F, 0x0AB8, 0x0741, 0xF554, 0xFA3F, 0xE88A, 0xF28D, 0xED7C,
0xEE9D, 0xFF38, 0xF359, 0x0A6D, 0xF250, 0x069F, 0xFEC7, 0x00D9,
0x0DC0, 0x081A, 0x130C, 0x13C6, 0x1249, 0x0494, 0x084B, 0xEE2E,
0xFD17, 0xED93, 0xEE67, 0xF634, 0xEE8E, 0x0038, 0xF161, 0x0530,
0xF140, 0xFF85, 0x0436, 0xFCDF, 0x178C, 0x0A63, 0x1DB6, 0x1274,
0x113B, 0x033B, 0x04B4, 0xEFAD, 0xFB12, 0xF0B0, 0xEA18, 0x0279,
0xE46F, 0x0308, 0xE6D3, 0xF95F, 0xF522, 0xFA84, 0x075D, 0x0372,
0x197A, 0x1071, 0x2895, 0x0D2F, 0x1AA8, 0x001E, 0x03F5, 0xF65A,
0xF881, 0xF645, 0xF186, 0x02D1, 0xE141, 0xFEF1, 0xDBC6, 0xF179,
0xF711, 0xF6A1, 0x0C7D, 0x09D4, 0x1841, 0x1236, 0x22A1, 0x0AD8,
0x19E1, 0x0163, 0x033C, 0xF9B1, 0xF421, 0xFE41, 0xEDDE, 0x0134,
0xDF75, 0xF84C, 0xE3D0, 0xF008, 0x00B1, 0xF69B, 0x1488, 0x0EC3,
0x1F96, 0x12E3, 0x21B7, 0x07E0, 0x147C, 0xFF4A, 0xFFB5, 0xFA6C,
0xF0D3, 0x04CC, 0xE48E, 0xFEF1, 0xDF2B, 0xEFE7, 0xEF78, 0xF49E,
0x03F0, 0x0395, 0x15C8, 0x0FC9, 0x2272, 0x0FB3, 0x16DC, 0x089A,
0x025C, 0xFAC0, 0xFEFA, 0xFA21, 0xF819, 0x04D9, 0xE2B3, 0xFB38,
0xE928, 0xEE19, 0x0535, 0xF75E, 0x0E50, 0x0DAB, 0x12FE, 0x1063,
0x18F9, 0x0A6B, 0x0761, 0x035F, 0xF11E, 0xF46B, 0xF48B, 0xFDB3,
0xF531, 0x0442, 0xEBDD, 0xF6CD, 0xF88F, 0xF478, 0x0EF1, 0x033A,
0x1750, 0x157F, 0x166F, 0x1047, 0x0D82, 0x0222, 0xF802, 0xF6E0,
0xEDF5, 0xF1E2, 0xF32D, 0xFD28, 0xF318, 0xFD46, 0xF8F9, 0xF558,
0x0582, 0xFDEB, 0x1201, 0x1164, 0x1A04, 0x170E, 0x11DC, 0x0D40,
0xFAA0, 0xFD2F, 0xE9B4, 0xEB47, 0xEF0F, 0xF2C8, 0xEF0F, 0xFEF0,
0xEFB1, 0xF8C6, 0x06C7, 0xF897, 0x1828, 0x08ED, 0x1B0B, 0x1CD4,
0x1A39, 0x1599, 0x1011, 0x02AA, 0xF284, 0xF444, 0xE06F, 0xE73A,
0xE959, 0xF178, 0xEBF9, 0xFB18, 0xF0FE, 0xF5BD, 0x04D1, 0xFF26,
0x1C8C, 0x171B, 0x24ED, 0x1FCA, 0x169A, 0x1091, 0x0391, 0xFE02,
0xEE3C, 0xEF05, 0xE6BB, 0xE9DF, 0xEA2D, 0xEF27, 0xED2E, 0xF4CC,
0xF9F7, 0xF885, 0x09D9, 0x04B2, 0x1EE2, 0x1B73, 0x2487, 0x1CCE,
0x0FD3, 0x0BD6, 0xF7EE, 0xFB4D, 0xEBB6, 0xED52, 0xEB3C, 0xEF14,
0xE733, 0xF1E1, 0xEF28, 0xF0A0, 0xFF78, 0xFB8F, 0x0A88, 0x0F99,
0x19F1, 0x1BED, 0x1D9B, 0x151B, 0x1024, 0x0672, 0xF8F9, 0xF9E6,
0xF0BC, 0xF025, 0xF56C, 0xED44, 0xF00F, 0xF1D2, 0xF127, 0xF383,
0xF9F7, 0xFCB9, 0x0A7B, 0x134F, 0x1357, 0x171E, 0x0B95, 0x0D3A,
0x074A, 0x0526, 0xFF6A, 0xF996, 0xF7D6, 0xF1FC, 0xF598, 0xF060,
0xF858, 0xF4EB, 0xF8E5, 0xF71B, 0xFA4C, 0xFEFD, 0x0B68, 0x10D6,
0x0EB4, 0x1172, 0x050F, 0x0570, 0x01AE, 0xFE3C, 0xFED7, 0xF9A9,
0xFB12, 0xF3A7, 0xF7C1, 0xF39A, 0xFBEE, 0xF7AB, 0xF8DE, 0xFC1F,
0xFAE3, 0x0886, 0x0926, 0x0CD6, 0x0792, 0x0A65, 0xFF99, 0x0592,
0xF946, 0xFB9F, 0xFAEC, 0xF858, 0x01BC, 0xF54E, 0x00FE, 0xF849,
0xFE63, 0xFA6C, 0xFF8A, 0xFD48, 0x07A9, 0x0AFC, 0x051D, 0x09B8,
0xFD38, 0x032E, 0xFA77, 0x0000, 0xF125, 0xF956, 0xF123, 0xF5BF,
0xFF58, 0xF76A, 0x090D, 0xFC15, 0x02CF, 0xFC0D, 0x02AA, 0x05AF,
0x0E5C, 0x0F5B, 0x0811, 0x097A, 0xFCBE, 0x0083, 0xF5A6, 0xFA95,
0xEE53, 0xF8A0, 0xF294, 0xEFD1, 0xFF8A, 0xF2EE, 0x07D5, 0xFE15,
0x0576, 0x004E, 0x0967, 0x0C08, 0x0EEB, 0x0E45, 0x063C, 0x0902,
0xFA1A, 0x02A6, 0xEF13, 0xF680, 0xEB53, 0xF25E, 0xF1A6, 0xEEB7,
0xFBDD, 0xF3AF, 0x052B, 0xFD28, 0x0E83, 0x082F, 0x15F4, 0x12ED,
0x1134, 0x0DD1, 0x0AB0, 0x0870, 0xFF66, 0x0149, 0xE9A1, 0xF4EE,
0xE4BB, 0xE9D1, 0xF10A, 0xEA9E, 0xF86A, 0xF5B5, 0xFDE9, 0xFE80,
0x0F09, 0x10F6, 0x1BB7, 0x1560, 0x1390, 0x0CB1, 0x08E3, 0x0BA6,
0xFC38, 0x01CD, 0xE9FC, 0xF292, 0xE817, 0xE419, 0xF2D1, 0xE9BA,
0xF9E0, 0xF9A6, 0x03EE, 0x01CF, 0x11BF, 0x1044, 0x169A, 0x13DB,
0x1261, 0x10C4, 0x07D6, 0x0CD9, 0xF45D, 0xFF20, 0xE7D5, 0xEFB8,
0xEBF9, 0xE61C, 0xF387, 0xECB2, 0xFC95, 0xFA48, 0x073F, 0x0A6D,
0x0C5C, 0x1125, 0x1068, 0x0EEE, 0x14C3, 0x157D, 0x0973, 0x0DB2,
0xF2B8, 0xF9E2, 0xEF76, 0xEA25, 0xF802, 0xE7B0, 0xF815, 0xF102,
0xFD40, 0xFA7B, 0x04AE, 0x0C25, 0x0545, 0x0E11, 0x07C4, 0x0C9C,
0x0C13, 0x17F0, 0x0503, 0x0AFE, 0xF51B, 0xF2EB, 0xF419, 0xEAB9,
0xFD95, 0xF13F, 0x0254, 0xF757, 0x02A7, 0xFF2E, 0x0017, 0x0AED,
0x03A0, 0x0AF9, 0x0835, 0x0ED8, 0x05C4, 0x1073, 0xFCB6, 0x0151,
0xF607, 0xF0C9, 0xFBA1, 0xEE01, 0x02D2, 0xF708, 0x07A7, 0xFD26,
0x0249, 0x071F, 0xFC37, 0x0878, 0x036C, 0x0605, 0x03A6, 0x1351,
0xFCFE, 0x0C61, 0xF696, 0xF6CC, 0xFAFB, 0xF299, 0x0789, 0xF8D2,
0x0BD2, 0xFBE2, 0x0DB2, 0xFEF9, 0x045C, 0x07B4, 0xFB9E, 0x04B2,
0xFDE6, 0x04F4, 0xFBE1, 0x0F74, 0xF72D, 0x049F, 0xF1B3, 0xF213,
0xF9A5, 0xF42E, 0x09EE, 0xFF95, 0x11F0, 0xFFF0, 0x0BC0, 0x0265,
0xFE1B, 0x07AD, 0x00F7, 0x03CB, 0xFE63, 0x0781, 0xF704, 0x0A34,
0xFBE6, 0x00A7, 0xFAAC, 0xF3C4, 0xFCD8, 0xF46F, 0x0A1C, 0x029E,
0x145E, 0x03AE, 0x05D1, 0x037D, 0xF823, 0x036F, 0xFFB3, 0x00EC,
0xFAE4, 0x092F, 0xF88D, 0x0725, 0xFD61, 0xFAB9, 0xFB0F, 0xF7D1,
0x00F2, 0xFFBA, 0x0EC2, 0x0363, 0x0FEF, 0x0546, 0xFF71, 0x07D4,
0xFD49, 0xFEB7, 0x0080, 0x0110, 0xF984, 0x0947, 0xFB81, 0xFEB8,
0xFB25, 0xF392, 0xF965, 0xF793, 0x004E, 0x034E, 0x09DB, 0x062A,
0x076D, 0x082C, 0x004B, 0x08BE, 0x0660, 0x03E0, 0xFF3C, 0x0797,
0xF911, 0x04B2, 0x027F, 0xFFBE, 0xFDB4, 0xFA6A, 0xF8F4, 0xF1AF,
0x03A2, 0xFB9C, 0x0A02, 0x041F, 0xFC3A, 0x02DB, 0xFCC8, 0x06CF,
0x0DEE, 0x0B59, 0x03F0, 0x0989, 0xFC6B, 0x05B7, 0x029B, 0x032A,
0xFD0B, 0xF704, 0xFAD3, 0xF376, 0x0273, 0xFB75, 0xFCFA, 0xF9A8,
0xECC2, 0xF6F7, 0xFA09, 0xFFFC, 0x0B1F, 0x1223, 0x079D, 0x15BA,
0x0FA3, 0x0CA4, 0x0F4D, 0x04FE, 0x0499, 0xFE6D, 0x064F, 0xFD83,
0xFEF4, 0xF21F, 0xE7BB, 0xED19, 0xE4CB, 0xF90B, 0xF99B, 0xFF93,
0xFEA3, 0x084B, 0x050E, 0x0E90, 0x1571, 0x12E9, 0x13BE, 0x1191,
0x13CB, 0x04E2, 0x1329, 0xFDFE, 0xFB89, 0xF774, 0xE504, 0xEF7A,
0xE574, 0xEE9B, 0xEC18, 0xFB88, 0xF448, 0x079D, 0x099A, 0x07DC,
0x1348, 0x0C44, 0x11D4, 0x0805, 0x1818, 0x04B9, 0x15E3, 0x0C40,
0x0530, 0x010D, 0xEE70, 0xEFB3, 0xE5B5, 0xF69E, 0xEC0C, 0x06CF,
0xF19C, 0xFE1D, 0xF854, 0xFBC5, 0x0850, 0x0E3D, 0x1EAF, 0x0842,
0x20BD, 0xFF45, 0x1067, 0xFFEB, 0x02C7, 0xFD66, 0xF9D2, 0x04DC,
0xF69C, 0x0843, 0xF236, 0x00FC, 0xEFD4, 0xFF9C, 0xF76D, 0x06E7,
0x0284, 0xFEC0, 0x0BE0, 0xF776, 0x14C9, 0x05FE, 0x1491, 0x00C4,
0x0544, 0xF7D3, 0xF99E, 0x0513, 0xF7F2, 0x0D18, 0xFCDA, 0x0BCC,
0x0309, 0x08AC, 0x0131, 0x0419, 0x0195, 0xFA9A, 0x086A, 0xFAED,
0x07F7, 0xFA18, 0xFC51, 0xF11A, 0xFAD5, 0x002A, 0x0443, 0x0DD4,
0x03BE, 0x0842, 0x0004, 0x015A, 0xFF8D, 0x0424, 0x076A, 0x105B,
0x10B0, 0x07B3, 0x0606, 0xF66E, 0xF85A, 0xF803, 0xFAFB, 0x00E0,
0xFBB5, 0xFF1A, 0xF4AB, 0xFC11, 0x011E, 0x0758, 0x114C, 0x05A1,
0x09E8, 0xFEE4, 0x0588, 0x01BC, 0x065E, 0x0294, 0x03BC, 0x098A,
0x0126, 0x0491, 0xFA47, 0xFED4, 0xF5C1, 0x07FE, 0xFB8F, 0x0793,
0x056A, 0xF7D9, 0xFD39, 0xF19E, 0xFE93, 0x04A2, 0x1390, 0x0400,
0x0E90, 0xF95F, 0xFE26, 0x021F, 0xF7E8, 0x02A8, 0xFAC5, 0x0D2A,
0x0122, 0x1363, 0x0443, 0xFFF3, 0x067E, 0xF714, 0x01FF, 0xFE9D,
0x0219, 0xFC47, 0xFE84, 0xF17E, 0xFAD7, 0xFE66, 0x05A4, 0x0877,
0x0312, 0x02D1, 0xF4EC, 0x07EB, 0xF55C, 0x08E7, 0x0D99, 0x0BA5,
0x18D9, 0x079B, 0x090D, 0xFAA5, 0x0718, 0xFD4F, 0x035B, 0x00F0,
0xF3B4, 0xF78C, 0xEB99, 0xEF9C, 0xEF16, 0x0495, 0xFA6B, 0x0DB6,
0x01EE, 0xFB1C, 0x0ABF, 0x0056, 0x0BC9, 0x08F1, 0x1123, 0x0CB1,
0x1847, 0x0A44, 0x0287, 0xFC74, 0xF610, 0xFD81, 0xF84D, 0xFE75,
0xEA87, 0xF6A7, 0xE180, 0xEF91, 0xF7DE, 0xF92F, 0x12FF, 0x05B5,
0x118B, 0x0384, 0x105B, 0x09CE, 0x0DA5, 0x0A9D, 0x067B, 0x08D7,
0x0A81, 0x08A5, 0xFB22, 0xFC3C, 0xE7BE, 0xF5BF, 0xEB61, 0xF70A,
0xF4C2, 0xF706, 0xF2EF, 0xF2AB, 0xFB68, 0x04C6, 0x1802, 0x186D,
0x1720, 0x05A3, 0x08CF, 0xFCA0, 0x0926, 0x02D6, 0x0155, 0x0463,
0xF781, 0xFE0B, 0xF0B7, 0xF097, 0xF41E, 0xF975, 0xFABC, 0x062B,
0xFA51, 0x044C, 0xF9CD, 0xFE61, 0xFF6C, 0x03D7, 0x1484, 0x0980,
0x1547, 0xF7DE, 0xFC8B, 0xF57D, 0xF29D, 0xFF3C, 0xFBE5, 0x00CC,
0x0416, 0x0500, 0xFA2A, 0x054C, 0xFB49, 0x0803, 0x0226, 0x0589,
0xFA0C, 0xFBC2, 0xFA9F, 0xEFDD, 0xFD80, 0xF219, 0x0243, 0x0047,
0x0631, 0xFA8A, 0x0386, 0xFDE4, 0xFFC8, 0x0BBD, 0xFF79, 0x11D4,
0x07F3, 0x1249, 0xFBE4, 0xFDB9, 0xF331, 0xF504, 0x01C9, 0xFDA4,
0xF95F, 0xF5DD, 0xEB30, 0xE827, 0xF868, 0xF4A5, 0x10B9, 0x0ECC,
0x11F3, 0x0AB3, 0x0509, 0x0379, 0xFFEA, 0x08EF, 0xFAFF, 0x047F,
0x00F4, 0xFECE, 0xFB9A, 0xF735, 0xED72, 0xF6A9, 0xF6FB, 0xFEB2,
0x000C, 0xFF64, 0xFE6B, 0xFA1B, 0x0067, 0x02B0, 0x0FA8, 0x0F6E,
0x0F13, 0xFCB2, 0xFA83, 0xF1CC, 0xF90D, 0xFE1D, 0xF846, 0xFF7E,
0xF400, 0x0314, 0xF6BA, 0x0494, 0x01C2, 0x032B, 0x113B, 0x0985,
0x0B18, 0x070C, 0xFD23, 0xF48D, 0xF5C2, 0xEBB5, 0xFCE5, 0xFBBA,
0x0449, 0xFD64, 0xF07D, 0xF387, 0xE634, 0x0124, 0xFAD8, 0x12E2,
0x15FE, 0x154C, 0x1820, 0x089D, 0x0CF3, 0xFC45, 0x0A3C, 0xFA27,
0xFA28, 0xF45C, 0xEBDA, 0xE8E1, 0xE7D0, 0xECC9, 0xEB69, 0x0242,
0xF994, 0x0692, 0x017A, 0x0478, 0x0E81, 0x110B, 0x197D, 0x1293,
0x18BB, 0x07BF, 0x08E9, 0xF88B, 0xF501, 0xF0B1, 0xF6D8, 0xF766,
0xEC7F, 0xF6B9, 0xDB2D, 0xF027, 0xE87C, 0xF8DD, 0x0AA4, 0x0C13,
0x2087, 0x0BA9, 0x163C, 0x00CA, 0x0BC8, 0x0403, 0x08DA, 0x035B,
0x03D4, 0x0051, 0xF9A0, 0xFE42, 0xE88C, 0xF635, 0xE9CA, 0xFCA6,
0xF610, 0x077B, 0xFFBA, 0xFB1A, 0x036B, 0xF3C5, 0x08A4, 0x0759,
0x12D9, 0x07F3, 0x0926, 0xF598, 0xFF6A, 0xFBE0, 0xFD83, 0x06AC,
0xF7FD, 0x0693, 0xF8CD, 0x0305, 0xFEB2, 0xFF2F, 0x0CAB, 0x02F5,
0x08D3, 0x007F, 0xF308, 0xF48D, 0xED69, 0xF296, 0xFAFC, 0x00E3,
0x0B13, 0x0366, 0x00A6, 0xF7E9, 0xF4F8, 0x0037, 0x0414, 0x0CD9,
0x1647, 0x0D23, 0x155E, 0x05A3, 0x028E, 0xFB7D, 0xF8F7, 0xFD15,
0xF19F, 0xFDBB, 0xE85E, 0xF2D4, 0xEC56, 0xF157, 0xFA29, 0x0073,
0x0CD1, 0x02B9, 0x1231, 0xFE6D, 0x1412, 0x091D, 0x13FC, 0x0B28,
0x05C2, 0x0AA6, 0xF7E9, 0x06D0, 0xEB06, 0xF629, 0xEC2E, 0xF8E0,
0xF34F, 0x0171, 0xF0FB, 0xF1C4, 0xF9F7, 0xEA32, 0x123B, 0x0580,
0x2655, 0x0FB3, 0x17FC, 0xFC6D, 0xFB4D, 0x039A, 0xF4C4, 0x0E1B,
0xF7F6, 0x05B9, 0xF506, 0x00D9, 0xEC4A, 0xF91B, 0xF570, 0xF6B1,
0x085B, 0x006A, 0x0CB5, 0xFECF, 0x08EB, 0xF44F, 0x04AF, 0x0347,
0x0779, 0x0DC6, 0xFF30, 0xFACF, 0xF41C, 0xFADC, 0xF71B, 0x050E,
0xF7A8, 0x025B, 0xFCE9, 0xFFF4, 0x07BF, 0x0351, 0x17B1, 0x0743,
0x15F3, 0x0118, 0xF7BE, 0xFB59, 0xEA4F, 0xF634, 0xF416, 0xFA09,
0x00C2, 0x019B, 0xFC2B, 0xF652, 0xF055, 0xF5AD, 0xFB43, 0x08CE,
0x1274, 0x18E1, 0x1F0E, 0x1092, 0x1020, 0xFB20, 0xFFAB, 0xFDFF,
0xFCFD, 0x01EA, 0xF1AF, 0xEF4E, 0xE75F, 0xE417, 0xEB74, 0xF654,
0xFF19, 0x0502, 0x09F1, 0x0288, 0x0B7A, 0x0D85, 0x1434, 0x1293,
0x0FBA, 0x0F0B, 0x0655, 0x09EF, 0xFC8F, 0xF691, 0xF7C4, 0xF09F,
0xF7BC, 0xF4EB, 0xE877, 0xEFCD, 0xE688, 0xF039, 0xFDFC, 0x0789,
0x189D, 0x1527, 0x17AD, 0x0483, 0x0399, 0x06BF, 0x041C, 0x0BC1,
0x07F3, 0xFE43, 0x01EF, 0xF9E4, 0xF5B4, 0xF4C1, 0xF17C, 0xF559,
0xFA49, 0x03D2, 0xFBD1, 0x06F5, 0xFC8C, 0xF94F, 0xFD93, 0x0196,
0x06B8, 0x116C, 0x0DD9, 0xFCE3, 0x053A, 0xF047, 0x00EF, 0xFA7A,
0xFDF2, 0x0301, 0xFFEB, 0x07B3, 0x0181, 0x044C, 0x0521, 0x066F,
0x0B4F, 0x092A, 0xF863, 0x0163, 0xE909, 0xF31C, 0xF1D1, 0xF4DC,
0x0472, 0x0144, 0x09C3, 0xF4B4, 0xFD09, 0xF588, 0x012D, 0x0CC6,
0x0E82, 0x133C, 0x13A8, 0x0E48, 0x08F4, 0x054C, 0xFBF5, 0x008D,
0xFACD, 0xFD66, 0xED36, 0xF526, 0xE5F1, 0xEB93, 0xF26C, 0xF126,
0x07A0, 0x0434, 0x1574, 0x0507, 0x1293, 0x0501, 0x12F6, 0x0BA0,
0x0AFD, 0x0CAD, 0xFF86, 0x0BEE, 0xF612, 0xFF1F, 0xEF44, 0xF7FD,
0xF683, 0xFABD, 0xF31A, 0xF7D0, 0xF506, 0xF16C, 0x0843, 0xF8EC,
0x1AD3, 0x0C84, 0x1E7B, 0x05A1, 0x09F0, 0xFCAD, 0xFB85, 0x087F,
0xF7D8, 0x0D6E, 0xF7AC, 0x08C3, 0xF4E9, 0xFC27, 0xF474, 0xFB38,
0x08D0, 0x0509, 0x0DFD, 0xFEA1, 0x0219, 0xF0FF, 0x0137, 0xF774,
0x0957, 0x09FC, 0x0882, 0x0496, 0xF83E, 0xFF43, 0xF99A, 0x06BC,
0x002F, 0x06AF, 0x01B1, 0x0B49, 0x0AC2, 0x088B, 0x10B1, 0xFF1A,
0x1509, 0xFCCC, 0x05CB, 0xFC3B, 0xEF79, 0xF7D1, 0xEB13, 0xF748,
0xF74A, 0x0508, 0x0738, 0x01B9, 0x02E3, 0xFB5F, 0x05F4, 0x095B,
0x124D, 0x0D48, 0x1398, 0x0AF5, 0x117B, 0x0392, 0x0940, 0xFCB4,
0x0149, 0x0303, 0xF26E, 0x01A0, 0xE9D0, 0xF035, 0xF132, 0xEE6D,
0x0106, 0x08B3, 0x16C2, 0x0918, 0x138C, 0xFA35, 0x0A48, 0x0738,
0x0DAF, 0x11C3, 0x0A6B, 0x0F32, 0xFDE6, 0x05EB, 0xF3F9, 0xFDEB,
0xFFE9, 0xFA9E, 0xFF50, 0xF76D, 0xF331, 0xF566, 0xFD8C, 0xF44D,
0x0A85, 0x03A6, 0x11A1, 0x0964, 0x0C19, 0x04BC, 0x05BF, 0x112C,
0x02BC, 0x0F12, 0xFFA0, 0x040E, 0x04E6, 0xFF79, 0x01A0, 0xFA97,
0x0448, 0xFB72, 0x02A5, 0xFD79, 0xF31A, 0xF982, 0xF349, 0xF833,
0xFF79, 0x0D37, 0x0AA5, 0x136D, 0x075C, 0xFDA5, 0x09D4, 0xFA9D,
0x0F16, 0x0337, 0x071F, 0x05AF, 0x0813, 0xFE79, 0x0153, 0xFB4A,
0xFCB3, 0x0658, 0xFE8E, 0x0A52, 0xF229, 0x018B, 0xEA9F, 0xF828,
0xF968, 0x01EB, 0x1600, 0x0242, 0x1463, 0xF1BD, 0x07A4, 0xFBEB,
0x0B7F, 0x07C1, 0x02EE, 0x07BA, 0xFDC5, 0x0AF5, 0x0105, 0x0CD3,
0x0173, 0x0B7E, 0xF855, 0x0055, 0xF09D, 0xF31C, 0xFAFA, 0xECBB,
0x0524, 0xF656, 0x1075, 0xFDCE, 0x0CA1, 0xF905, 0x002E, 0x03CC,
0x0394, 0x1118, 0x02AF, 0x16F9, 0xFECC, 0x110D, 0xFAC7, 0xFE6A,
0x00E6, 0xF88C, 0x057F, 0xF9C8, 0xFA94, 0xF051, 0xF7B5, 0xE59F,
0xFA6E, 0xF838, 0x07B5, 0x0D52, 0x0F56, 0x06AD, 0x0773, 0x0BD6,
0x0295, 0x13A8, 0xFF91, 0x0AD1, 0x0442, 0xFFDD, 0x0161, 0xF8A0,
0xFE95, 0xFADC, 0xFF07, 0xF849, 0xF114, 0xEFBC, 0xEF04, 0xF35C,
0xFF0A, 0x0887, 0x0FA7, 0x103F, 0x0BC3, 0xFEDA, 0x0540, 0xFFDB,
0x0B15, 0x08C0, 0x0171, 0x0455, 0xFAC7, 0x0036, 0xFAE3, 0xFA4C,
0xFC33, 0xF9A8, 0x0212, 0x006D, 0xFD68, 0x0223, 0xF796, 0xF72C,
0xF888, 0xF6F5, 0x070C, 0x0519, 0x0E7A, 0x0173, 0x0389, 0xFEDC,
0xFB95, 0x0435, 0xF61C, 0x02EF, 0xFF3A, 0x0439, 0x0B76, 0x03F1,
0x0C81, 0x041D, 0x0846, 0x01BC, 0xFB8E, 0xF54B, 0xF3E5, 0xED28,
0xF5A4, 0xFBAE, 0xFF96, 0x094A, 0xFFEA, 0xF982, 0xF7F7, 0xF766,
0x00BE, 0x0D22, 0x0A42, 0x11A7, 0x0EBA, 0x074A, 0x0C76, 0xFF68,
0x07BE, 0xFEA5, 0x068D, 0xFC76, 0xF712, 0xF6B7, 0xE6C8, 0xEF69,
0xE7EF, 0xF0E4, 0xF9C3, 0x016A, 0x0968, 0x060C, 0x0EFB, 0x075A,
0x142F, 0x0CB5, 0x0DAD, 0x0673, 0x08F3, 0x046F, 0x095E, 0x026D,
0xFE91, 0xFA66, 0xF012, 0xF5BD, 0xE58D, 0xF37D, 0xE81E, 0xF30B,
0xF542, 0xFC94, 0x0B88, 0x0D89, 0x1BB9, 0x074C, 0x16FA, 0xFBA6,
0x10D9, 0x050E, 0x090B, 0x0958, 0xFD8F, 0xFF2C, 0xF1A1, 0xF2EF,
0xEE80, 0xF894, 0xFAA7, 0x067D, 0xFBCE, 0x0366, 0xF7C9, 0xF914,
0xFEE2, 0xFBB5, 0x0C03, 0x0743, 0x1530, 0xFF0D, 0x0C4A, 0xF6C1,
0xFB65, 0xFD83, 0xF059, 0xFA4B, 0xF575, 0xFEFA, 0x024D, 0x0AB9,
0x08B3, 0x0B88, 0x0D9D, 0x0876, 0x0410, 0x0164, 0xF7DE, 0xF568,
0xFB7F, 0xF11E, 0xFEC2, 0xF9E2, 0xFAC9, 0xF32D, 0xF7DE, 0xEEAE,
0xFEA0, 0x0447, 0x0240, 0x113B, 0x0995, 0x1515, 0x154E, 0x123E,
0x0C56, 0x0591, 0x04D6, 0xFF11, 0xFE03, 0xF91B, 0xE848, 0xE5AF,
0xDE0D, 0xDACD, 0xEFAA, 0xF56D, 0x099D, 0x05A9, 0x0FB2, 0x0217,
0x125E, 0x1461, 0x1477, 0x1BA9, 0x0C1A, 0x0D9D, 0x079D, 0x0469,
0xFDB3, 0xFE3C, 0xEEC8, 0xF0A0, 0xE3C8, 0xE4E9, 0xE4AC, 0xE85B,
0xF292, 0xF3DB, 0x0733, 0x0997, 0x1F15, 0x11A0, 0x1E5C, 0x07F9,
0x0FB7, 0x0BEF, 0x05C1, 0x0C07, 0xF6FD, 0x01A1, 0xEE93, 0xF7A5,
0xEF46, 0xF314, 0xF8C0, 0xF785, 0xFCE6, 0xFCED, 0xFDFC, 0xFF0B,
0x0699, 0xFB85, 0x062B, 0x046B, 0x0B94, 0x0AF8, 0x0C27, 0xFF0E,
0xF81E, 0xFCFB, 0xEA26, 0xFDB7, 0xF250, 0x0079, 0x059D, 0x0550,
0x0C0F, 0x0373, 0x146D, 0x0723, 0x11FF, 0x0494, 0xF73C, 0xF56D,
0xEC94, 0xEE6B, 0xF213, 0xFD3C, 0xF74A, 0x0033, 0xF597, 0xF2C7,
0xFB07, 0x014B, 0x071B, 0x0F48, 0x0DF2, 0x0C41, 0x1D66, 0x0E24,
0x1810, 0x07A9, 0x03AD, 0xFBBB, 0xF786, 0xF62F, 0xE522, 0xF1B4,
0xDB0F, 0xEA4E, 0xE4D7, 0xF58D, 0x020A, 0x079A, 0x15B1, 0x0435,
0x19FB, 0x0A82, 0x1C02, 0x117E, 0x0D36, 0x0835, 0x04DE, 0x0424,
0x0004, 0xFD72, 0xEF50, 0xF6E9, 0xE2BE, 0xF76A, 0xE3E0, 0xF5FD,
0xF034, 0xF162, 0xFE20, 0xFE8F, 0x1C7A, 0x1147, 0x2898, 0x04E3,
0x0FF0, 0xFC6C, 0x0250, 0x036C, 0xFBC6, 0x0416, 0xF41F, 0x03A1,
0xEF8D, 0xFEED, 0xF740, 0x0018, 0x001E, 0x0263, 0xF9FA, 0xFCD6,
0x0125, 0xF774, 0x05FA, 0xFBD1, 0x05C7, 0x01B5, 0x0C1F, 0xF7DE,
0x03E3, 0xFD38, 0xF583, 0x0913, 0xF1E0, 0x04EF, 0x01E1, 0x0AF5,
0x0B9E, 0x0D1E, 0x0BCD, 0x0646, 0x0D36, 0x023E, 0xFA23, 0xF764,
0xEB6C, 0xE7EB, 0xEECD, 0xEE46, 0xF9E9, 0x04AD, 0x01D7, 0xFED1,
0x0111, 0xFBB4, 0x0252, 0x0D13, 0x01F6, 0x1246, 0x127F, 0x1347,
0x181F, 0x0A88, 0xFFFC, 0xFB81, 0xF7FD, 0xF514, 0xF1F8, 0xF32A,
0xE388, 0xEC79, 0xE475, 0xEDA5, 0xFE40, 0x0408, 0x13CF, 0x07C1,
0x109C, 0x0607, 0x12E2, 0x13EB, 0x0D4D, 0x1091, 0x016E, 0x0655,
0x01E3, 0x008E, 0xFB4D, 0xFD11, 0xEFA5, 0xF7EE, 0xE6E0, 0xF0C4,
0xEA88, 0xEF03, 0xF5FC, 0xF7FE, 0x0BEC, 0x0C21, 0x21E3, 0x0CD6,
0x162C, 0x0488, 0x0457, 0x0761, 0xFD9D, 0x0743, 0xFCB7, 0x083C,
0xFB6E, 0xFFFF, 0xF424, 0xF6A7, 0xF8FE, 0xFB74, 0xFAF8, 0xFD89,
0xFAE8, 0xF605, 0xFE37, 0xF819, 0x01E5, 0x099D, 0x10F9, 0x066A,
0x0F0C, 0xFE64, 0xFBFB, 0x0763, 0xF2BB, 0x059C, 0xFC40, 0x04EB,
0x08C5, 0x0631, 0x085A, 0xFFE8, 0x0DDF, 0x0049, 0x0583, 0xFFB5,
0xEE40, 0xF0FE, 0xEDCC, 0xEEC5, 0xFD3F, 0x06B1, 0x050B, 0x0727,
0xFF37, 0xFB31, 0xFF8A, 0x064A, 0x035C, 0x0BCB, 0x0C58, 0x0B8A,
0x1A8E, 0x0C87, 0x0EAC, 0x032D, 0xFED3, 0xF7F1, 0xF619, 0xF934,
0xE80E, 0xF634, 0xE39F, 0xEF85, 0xF075, 0x02A3, 0x0B53, 0x0ACB,
0x184B, 0xFF9B, 0x1654, 0x08C0, 0x1171, 0x110E, 0x0923, 0x0943,
0x0690, 0x0071, 0xFC3B, 0xFDA0, 0xF0E8, 0xFEAF, 0xEAFC, 0xFE79,
0xE564, 0xF6E2, 0xEE9E, 0xF3C0, 0x083A, 0x0663, 0x23F4, 0x0DFE,
0x20A2, 0x0101, 0x082B, 0xFE98, 0xFD74, 0x045E, 0xFD52, 0x08D8,
0xFB81, 0x087F, 0xF2B7, 0x04CF, 0xF8DD, 0x0306, 0x0180, 0x0251,
0xFB04, 0xFA74, 0xFE7A, 0xF334, 0x03CE, 0xFDB8, 0x07BD, 0xFEB5,
0x0C05, 0xF715, 0x047C, 0x0383, 0xF777, 0x0DD1, 0xF866, 0x100E,
0x0B61, 0x116C, 0x10E0, 0x0867, 0x0D05, 0x01F3, 0x086C, 0x012C,
0xF1F7, 0xEE52, 0xE38F, 0xE058, 0xF0BC, 0xF998, 0x0625, 0x0A91,
0x092D, 0x024B, 0x0336, 0x0AC4, 0x06B4, 0x1639, 0x0EB6, 0x1311,
0x1825, 0x0D94, 0x0BDF, 0x02D6, 0xF787, 0xF49A, 0xF36D, 0xF2A4,
0xEA4F, 0xF147, 0xE36E, 0xEC23, 0xF137, 0x0089, 0x0E3A, 0x104C,
0x1BF5, 0x04CD, 0x13A3, 0x081D, 0x0D18, 0x0F89, 0x03F2, 0x0826,
0xFBE6, 0x02D9, 0xFA44, 0xFD98, 0xF849, 0xF98A, 0xF243, 0xFE8F,
0xEC79, 0xFC20, 0xF2F9, 0xF15E, 0xFFF7, 0xFE22, 0x1189, 0x0C3A,
0x196E, 0x0084, 0x08F8, 0xFDF1, 0xF7CF, 0x0773, 0xFB26, 0x0B31,
0x0718, 0x0A95, 0x006B, 0x05B3, 0xF9FF, 0x00C8, 0xFFD9, 0xFDD2,
0xF6B8, 0xF548, 0xEC72, 0xE8EF, 0xF19D, 0xF676, 0x0054, 0x0899,
0x0CA2, 0xFEF6, 0x0BF6, 0x04C3, 0x0508, 0x15CA, 0x038C, 0x12A3,
0x0A46, 0x08FD, 0x06E9, 0xFE7A, 0xFF79, 0xF7CE, 0xFC3F, 0xF5FF,
0xEB8E, 0xF00E, 0xDFFC, 0xE969, 0xF113, 0xF96B, 0x0BD5, 0x110B,
0x1204, 0x0DF5, 0x0BE9, 0x0832, 0x0692, 0x0902, 0x001E, 0x0729,
0x04F7, 0x038E, 0x0410, 0xF914, 0xF75B, 0xF577, 0xF402, 0xFA86,
0xF3C1, 0xFACE, 0xF092, 0xF497, 0xF230, 0x0054, 0x0443, 0x0F50,
0x14F8, 0xFEC4, 0x0DCF, 0xFA6D, 0xFF81, 0x052F, 0xFC60, 0x03D8,
0x0258, 0x0415, 0x0021, 0xFE9F, 0xFBCF, 0xFE92, 0xFB47, 0x0838,
0xF03C, 0x0043, 0xE7F7, 0xEC91, 0xF188, 0xF55D, 0x0621, 0x07E7,
0x0F44, 0xF8D2, 0x09E6, 0xF5CF, 0x0562, 0x0715, 0x0395, 0x0854,
0x060B, 0x09AD, 0xFF4C, 0x0B6C, 0xF75E, 0x026B, 0xF885, 0xFC52,
0xEE27, 0xFD15, 0xE61B, 0xEC59, 0xF03B, 0xE79C, 0x03BB, 0x01C2,
0x130D, 0xFF2A, 0x1440, 0xF8E7, 0x08A3, 0x0DF8, 0xFC43, 0x14E4,
0x0046, 0x0CA7, 0x01C9, 0x0563, 0xF8BF, 0x0098, 0xF775, 0xF8AB,
0xF544, 0xF078, 0xEF0E, 0xE611, 0xF0D1, 0xE797, 0x0397, 0x01B5,
0x1205, 0x0A01, 0x092E, 0x03AE, 0xFE52, 0x0DA0, 0xFD6F, 0x1776,
0x0454, 0x0D04, 0x0218, 0xFA13, 0xFD8C, 0xF818, 0x0425, 0xF676,
0xF8EF, 0xEBE6, 0xE7D1, 0xE7D6, 0xECC0, 0xF4CC, 0xFF90, 0x0B67,
0x0D76, 0x0CC2, 0x0D26, 0x097F, 0x0751, 0x0ADE, 0x006B, 0x05E4,
0x0474, 0x065A, 0x06B3, 0xFB8A, 0xFCB1, 0xF00B, 0xF90B, 0xFAF0,
0xF142, 0x00BA, 0xE997, 0xF395, 0xF07C, 0xF98B, 0x03B4, 0x0EDC,
0x1287, 0x0303, 0x1039, 0xF6BF, 0x0ADB, 0x01B7, 0x01E8, 0x0409,
0x0221, 0x039D, 0x041C, 0x055E, 0xF6E2, 0x0246, 0xF8A3, 0x031C,
0xFC83, 0x0630, 0xEF44, 0xF151, 0xE88A, 0xE442, 0xFC96, 0xFF24,
0x15F1, 0x0158, 0x10AC, 0xF4D6, 0x0577, 0x0AC8, 0x046E, 0x1901,
0x04BC, 0x0F6A, 0x0412, 0x0868, 0x00D7, 0x0224, 0x0002, 0xF43B,
0xF32D, 0xED84, 0xE913, 0xE84D, 0xEEE6, 0xE64F, 0xFB18, 0xFF81,
0x0C36, 0x12DC, 0x10DE, 0x0F03, 0x0DC9, 0x0FEB, 0x077E, 0x13FB,
0x03E8, 0x07FA, 0x0378, 0xF348, 0xFB9D, 0xEFA6, 0xFDDF, 0xF284,
0xF748, 0xF33E, 0xE71B, 0xF469, 0xEBD5, 0xFAC5, 0xFF5D, 0x1147,
0x153C, 0x1475, 0x191D, 0x02E4, 0x0A93, 0xFDBD, 0xFCA1, 0xFE3F,
0x0013, 0xFD36, 0x0405, 0xF7F6, 0xF3D2, 0xF93D, 0xF3F1, 0x05CD,
0xFB60, 0x0A89, 0xF154, 0xFED5, 0xF13C, 0xF868, 0x03A0, 0x0222,
0x1107, 0xFB27, 0x0CC3, 0xF032, 0x0C70, 0xFB39, 0x06C3, 0x0599,
0xF987, 0x09F3, 0xFBC7, 0x0C67, 0xFCF7, 0x0C3E, 0xFEE4, 0x07F5,
0xFB76, 0x0075, 0xEC6A, 0xEF93, 0xEB1E, 0xE145, 0xFBAE, 0xF404,
0x10D5, 0x0267, 0x14C1, 0xFE7C, 0x0D54, 0x0B95, 0x05EE, 0x170B,
0x0121, 0x13F1, 0x01F6, 0x0989, 0xFAEB, 0xFB6E, 0xF813, 0xF45F,
0xF87E, 0xF344, 0xF257, 0xEBE5, 0xF156, 0xEA5B, 0xFAE1, 0x0286,
0x0F1A, 0x1032, 0x14FD, 0x0948, 0x0A47, 0x0DC0, 0x0199, 0x0F0F,
0xFCD5, 0x0346, 0xFB3F, 0xFA4C, 0xF8D5, 0xFA78, 0x03F9, 0xFB20,
0x0743, 0xFB48, 0xF131, 0xF7AC, 0xEDC5, 0xF0C3, 0x0016, 0x02BB,
0x0CC9, 0x0E28, 0x0C42, 0xFDEC, 0x0687, 0x0125, 0x013B, 0x0B69,
0xFDCA, 0x06AF, 0x020A, 0x0392, 0x013B, 0x0202, 0xFF65, 0xFD18,
0xFE11, 0xFD46, 0xF393, 0xFA1A, 0xEFAF, 0xED35, 0xF7D0, 0xF697,
0x0569, 0x08AA, 0x0DD5, 0x04A8, 0x0FBA, 0x041B, 0x0AA2, 0x0DE8,
0x00BC, 0x0B84, 0xFEEB, 0xFF1A, 0xF968, 0xFD26, 0xF804, 0xFDBD,
0xFDE3, 0xF73B, 0xF06A, 0xF1EE, 0xE3E0, 0xF14D, 0xF74A, 0xFE14,
0x133B, 0x0844, 0x1601, 0x0682, 0x0D56, 0x0A4E, 0x0801, 0x0C97,
0x01F7, 0x0696, 0xFD4C, 0xFD0C, 0xF40E, 0xF411, 0xF261, 0xF7EE,
0xFC8E, 0xFEAE, 0xF755, 0xF52E, 0xED6B, 0xF17A, 0xFB9D, 0xFD1B,
0x0B09, 0x02E1, 0x08BF, 0x08EB, 0x0A03, 0x0E99, 0x0939, 0x06D0,
0xFDEA, 0x02B6, 0xFB73, 0x0293, 0xFAF9, 0xF9A1, 0xFB60, 0xF51E,
0x011B, 0xF90D, 0xF43C, 0xF985, 0xE8F1, 0xF30D, 0xF8EF, 0xF94E,
0x09A0, 0x0910, 0x0A61, 0x0A6E, 0x0707, 0x0A31, 0x0CD5, 0x0F0C,
0x0EAF, 0x0640, 0xFF5E, 0xF6AB, 0xEF5B, 0xF5C6, 0xF100, 0xF80C,
0xF82D, 0xFAD0, 0xF116, 0xFEBA, 0xF009, 0xF980, 0x018D, 0xFB79,
0x0BF0, 0x05F1, 0x0D28, 0x0862, 0x16E3, 0x030A, 0x1A71, 0x07F3,
0x04D3, 0x0692, 0xED81, 0xF5EF, 0xE8B5, 0xFCA7, 0xEE23, 0x044B,
0xF55A, 0xF8B1, 0xF312, 0xF8B2, 0xFAA5, 0xFBE9, 0x0F8D, 0xF894,
0x0E56, 0xFB70, 0x0E6E, 0x051A, 0x1D4F, 0x0FEA, 0x1279, 0x14D5,
0xF4E7, 0x0CCB, 0xEA94, 0xFD9E, 0xE8E6, 0xF74F, 0xEADC, 0xF568,
0x0049, 0xF43E, 0x094C, 0xF3AD, 0x013D, 0xF38E, 0x06C5, 0xFDF1,
0x0E5B, 0x07E4, 0x0ACF, 0x136D, 0x081E, 0x1A10, 0x03C7, 0x0FFB,
0xF504, 0x0127, 0xEE18, 0xEFE3, 0xF12D, 0xEE8D, 0xFA66, 0xF675,
0x0F11, 0xF5ED, 0x09C7, 0xF9E5, 0xF7F3, 0x0225, 0x0714, 0x0BC4,
0x0C6C, 0x0F92, 0xFC7C, 0x0A43, 0x00DF, 0x0755, 0x0C93, 0x0735,
0x01A6, 0xFB62, 0xEDF1, 0xEBE6, 0xEF9A, 0xF711, 0x02E9, 0x04B2,
0x07B9, 0xFEBC, 0xF822, 0xFC88, 0xF9FE, 0x007E, 0x0AD4, 0x0488,
0x0AB6, 0x02FE, 0x07C9, 0x0520, 0x0B0C, 0x07EE, 0x0B5E, 0x032D,
0x0071, 0x0399, 0xF022, 0x0056, 0xF0A5, 0xFFED, 0xF677, 0xFDD9,
0xF8AF, 0xEFE5, 0xFBD0, 0xEE2C, 0x00E4, 0xFDDF, 0x102F, 0x0B5B,
0x10E3, 0x074E, 0x0276, 0x0AB0, 0x0747, 0x13F6, 0x0CE3, 0x0CBF,
0xFC49, 0x030B, 0xEAC8, 0xF226, 0xE95E, 0xEA37, 0xF914, 0xF10B,
0x0D38, 0xF46D, 0x0AF0, 0xFF1F, 0x0613, 0x0DC8, 0x13D7, 0x1782,
0x0C8F, 0x1489, 0xF604, 0x0A57, 0xF68A, 0xFF7E, 0xFDAC, 0xF406,
0xF52D, 0xEEB4, 0xEA95, 0xE5CD, 0xF27B, 0xEC50, 0x0427, 0x02F0,
0x0E4F, 0x059A, 0x0E17, 0x0A07, 0x0B61, 0x18E1, 0x0952, 0x0F43,
0xFC51, 0xFCFD, 0xF244, 0xFC5D, 0xFDCE, 0xFA0F, 0x0CA9, 0xFAA1,
0x0386, 0x00F9, 0xEDA5, 0xF5DE, 0xF38C, 0xFB80, 0x0988, 0x111C,
0x0FCA, 0x0A8D, 0x06BB, 0xFF1E, 0xF881, 0x01BB, 0xFDEA, 0x011C,
0x0825, 0xF76C, 0xFE74, 0xFBD0, 0xFEE4, 0x084B, 0x0813, 0x01CD,
0xFEAC, 0xFB36, 0xEF20, 0xF84C, 0xF243, 0xF97D, 0x01B5, 0x0265,
0x04D9, 0xFF10, 0x01D3, 0xFBDE, 0x04CC, 0x033D, 0x09D0, 0x05EB,
0x067B, 0x049A, 0xFBCC, 0x0533, 0x02CF, 0x0478, 0x0C9B, 0xFE1C,
0xF960, 0xF330, 0xE4BA, 0xEE66, 0xF273, 0xF7BA, 0x0DB4, 0x03C5,
0x113C, 0x09A6, 0x07A5, 0x0B5A, 0x05C2, 0x0800, 0x0774, 0x0634,
0x055F, 0x05DE, 0xFB8F, 0xFFBC, 0xF329, 0xF633, 0xF54E, 0xF1A6,
0xFA8F, 0xF547, 0xF80B, 0xF50A, 0xFAAA, 0xFC9A, 0x0B45, 0x1078,
0x0F75, 0x0BD6, 0x07EB, 0xFD84, 0x054E, 0x033C, 0x020C, 0x00EB,
0xF852, 0xF6AE, 0xEBE7, 0xF714, 0xF539, 0xF901, 0x07B8, 0xFDDF,
0x0171, 0x00D8, 0xF5BA, 0xFEC2, 0xFC5E, 0x0251, 0x0E6C, 0x0992,
0x10F4, 0x07BC, 0x01D2, 0xFCEC, 0xFBA0, 0xFCF1, 0x01A3, 0xFFD7,
0x015C, 0xF8B9, 0xF278, 0xFAD8, 0xF500, 0x038B, 0x0817, 0x00A8,
0x0683, 0xFEDE, 0xFE29, 0x0431, 0xFF50, 0x0069, 0x0067, 0xFF3C,
0xFF7F, 0x0357, 0x0519, 0xFB6D, 0x0222, 0xF90C, 0xF312, 0xFDBA,
0xF583, 0xFB0A, 0xFA3C, 0xFD71, 0xFEC5, 0x05EE, 0x1288, 0x06B9,
0x108B, 0xFD93, 0xF436, 0xF75A, 0xEF7A, 0xF685, 0x0794, 0xFC52,
0x0C89, 0x0750, 0x01E5, 0x069B, 0x0275, 0x05E3, 0x0331, 0x08E9,
0x05FD, 0x05C4, 0x0197, 0xFFBE, 0xF66A, 0xF726, 0xFBB3, 0xF57B,
0xFF9C, 0xF31E, 0xF0ED, 0xEE2D, 0xEE0C, 0xF768, 0x0960, 0x0A7C,
0x15DC, 0x1079, 0x08DA, 0x0948, 0x09A4, 0x08B5, 0x0A1D, 0x04E1,
0xF9EA, 0xFA62, 0xECDC, 0xF2EF, 0xF58A, 0xF3FE, 0x0705, 0xF92E,
0x00D3, 0xFACB, 0xF54B, 0x00E1, 0xFD6A, 0x03AE, 0x1035, 0x0D67,
0x18AA, 0x195C, 0x08AA, 0x02B4, 0xF767, 0xEDE2, 0xF5F3, 0xF641,
0xF889, 0xF724, 0xF010, 0xF0AE, 0xF173, 0xFA47, 0x0C96, 0x0B99,
0x1362, 0x0AE4, 0x0384, 0x03B4, 0x04A6, 0x0597, 0x0B3D, 0x075B,
0x068A, 0x027B, 0xFF25, 0xF3D9, 0xF617, 0xF129, 0xEEB2, 0xF9C8,
0xF7F9, 0xFE7B, 0x0022, 0x01B0, 0xFCF6, 0x020B, 0x0B1C, 0x0603,
0x135D, 0x06B4, 0xFD37, 0xFB76, 0xF3A7, 0xF0D2, 0x0452, 0xF848,
0x057B, 0x06F4, 0xFD2A, 0x08AF, 0x038B, 0x0625, 0x01E0, 0x0259,
0x0352, 0xFF71, 0xFF02, 0xFE1F, 0xE936, 0xF810, 0xF6D0, 0xF472,
0x0FD5, 0xF6BA, 0x043F, 0xFDAF, 0xF5CB, 0xFBFA, 0x0214, 0x03F1,
0x1718, 0x1CB9, 0x16B3, 0x126F, 0x0668, 0xFB37, 0xFA5D, 0xF8A7,
0xF2C8, 0xF45F, 0xEB0C, 0xEE7D, 0xED03, 0xF4CB, 0x03FF, 0x0468,
0x10F4, 0x0ACF, 0x06AD, 0x09D3, 0x04F9, 0x0685, 0x0E33, 0x06BA,
0x09BD, 0x05D9, 0xF7E3, 0xF504, 0xF468, 0xED07, 0xF37A, 0xF301,
0xEBEC, 0xF33D, 0xF283, 0xF78A, 0xFE82, 0x0A9D, 0x10FF, 0x1646,
0x1E94, 0x09C0, 0x10C8, 0x07A9, 0x00F4, 0x06F3, 0xFD81, 0xF51C,
0xFC1C, 0xF978, 0xFAC5, 0xFB2E, 0xF407, 0xF4AE, 0xEB59, 0x005F,
0xF294, 0x001B, 0x02A6, 0xFF6A, 0x08CF, 0x0C75, 0x13B0, 0x0B94,
0x1ACA, 0x0291, 0x0A61, 0xFF10, 0xF713, 0xF5F6, 0xF3FC, 0xF39A,
0xFF6A, 0x019A, 0xF9F1, 0x087F, 0xEAA6, 0x00EA, 0xF5A3, 0xFC8B,
0x03FF, 0xFF38, 0xFE5B, 0xF960, 0xFA2E, 0xF64A, 0x0E02, 0x0482,
0x1A89, 0x06AF, 0x03DB, 0xFCF3, 0xF392, 0xFC94, 0x00B0, 0x0084,
0x042D, 0x0D89, 0xF3D2, 0x091A, 0xF416, 0xF6C9, 0xFE6E, 0xFA76,
0x012D, 0xFB12, 0x037D, 0xF33D, 0xFFBD, 0xFD6B, 0x0AB7, 0x0E80,
0x125E, 0x0B28, 0xFD33, 0x01BE, 0xFAC9, 0x00EA, 0xFC94, 0x0111,
0xEF2D, 0x01AC, 0xF3A1, 0xF8FE, 0x005A, 0xF2D0, 0x02CD, 0xF8EF,
0x03F4, 0xF82F, 0x05FA, 0xFC73, 0x0150, 0x0A2D, 0x0189, 0x0DB5,
0x0A0F, 0x0755, 0x0733, 0x014E, 0xF1AC, 0x0040, 0xEAB2, 0xF829,
0xFB35, 0xF31C, 0xFA6B, 0xF69F, 0xF6B6, 0xF68D, 0x02FA, 0xFB27,
0x0780, 0x060E, 0x0704, 0x0B2F, 0xFDFD, 0x0629, 0x011C, 0x066A,
0x1691, 0x09F1, 0x075C, 0x056C, 0xEBD7, 0xF5A8, 0xF07A, 0xE7FE,
0xF7BA, 0xF75A, 0xF39F, 0x020A, 0xFA71, 0xFB57, 0x08DE, 0x0CCB,
0x0CC8, 0x10D5, 0x0110, 0xF9C5, 0xFA15, 0xF9DD, 0x0CAB, 0x069E,
0x0C75, 0x0383, 0xF59C, 0xF5D9, 0xF062, 0xF1C5, 0xF00A, 0xF8A7,
0xF8E5, 0x0385, 0x03CE, 0x07CC, 0x01C2, 0x09DD, 0x0778, 0x0ACE,
0x0719, 0xF88F, 0x00E8, 0xED43, 0xFDCD, 0xFB64, 0xF5AB, 0x0A3C,
0xFB22, 0x0229, 0x009B, 0xF9D0, 0xF43E, 0x04EE, 0xF536, 0xFFFE,
0x0788, 0xFD21, 0x0DC0, 0x10E7, 0x0DF2, 0x065E, 0x0664, 0xEB66,
0xFFE3, 0xEFC3, 0x0486, 0x055D, 0xF52C, 0x0FF8, 0xF3A2, 0x0C33,
0x08BF, 0x08F1, 0x0058, 0x04E9, 0xF47C, 0xF8C7, 0x0088, 0xF38F,
0x0D3C, 0xFF9C, 0x053A, 0xFA1E, 0xF3E0, 0xE9E3, 0xFE02, 0xF8C8,
0x095C, 0x125C, 0xFD88, 0x169A, 0xF96F, 0x06F8, 0xFE00, 0x0646,
0x0394, 0x0AA9, 0x0A7B, 0xF2DA, 0x04B7, 0xEBE1, 0xFC2F, 0xFC1E,
0xFD36, 0xFA98, 0xF6DC, 0xF9C4, 0xFDDF, 0x0913, 0x0B43, 0x19B7,
0xFE7B, 0x1196, 0xF909, 0xFC41, 0xFC63, 0xFE65, 0xFE6E, 0xFED8,
0x0CFA, 0xEDF4, 0x0B05, 0xF55B, 0xFD66, 0x0B53, 0xFE72, 0x0316,
0x01A2, 0xFE11, 0x04BC, 0x0F55, 0xFFB3, 0x12D2, 0xF9A0, 0x04FF,
0x0272, 0xF7F0, 0x0315, 0xF70F, 0xF8FA, 0xF61E, 0xFE41, 0xF671,
0x0A2C, 0x0B36, 0x0B5F, 0x16BD, 0xFFF2, 0x022C, 0xF603, 0xF0C1,
0x0154, 0xFFB8, 0xFFA8, 0x10E5, 0xF93B, 0xFED1, 0x0B0C, 0xF30F,
0x0494, 0x0284, 0xF81C, 0x00BE, 0x03C2, 0xFDA3, 0x0505, 0x15B7,
0x082C, 0x1749, 0x03E4, 0xF625, 0xF3C8, 0xEA9D, 0xFD85, 0xFB2E,
0x0527, 0x0299, 0xFF37, 0xFB44, 0x01A7, 0x01B2, 0xFF8D, 0x0C71,
0xFF3A, 0x02EA, 0x0750, 0x02E4, 0x04ED, 0x11D3, 0x01F7, 0x0A14,
0x03B6, 0xF28C, 0x05C5, 0xE9C0, 0x060A, 0xF9DD, 0xF701, 0x0443,
0xF825, 0xFB9F, 0x0578, 0x07EE, 0xF9A1, 0x118A, 0xF8FA, 0xFEB5,
0x042C, 0xFE15, 0x0219, 0x09A5, 0x0071, 0xFB80, 0xFC64, 0xEC11,
0x07D4, 0xF730, 0x10E1, 0x0AE4, 0xF9D6, 0x088C, 0xF74F, 0xFE57,
0x0677, 0x0A40, 0xFAC2, 0x0AA7, 0xF57E, 0xF7AE, 0x0386, 0x0132,
0x0856, 0x0BDB, 0x0694, 0xF5F3, 0xFF1A, 0xEC2E, 0xFDD0, 0x01A1,
0x059D, 0x13C8, 0xFFC1, 0x052C, 0xFB17, 0xF860, 0xF836, 0x023B,
0xF314, 0xF94F, 0xFF19, 0xF332, 0x0749, 0x09D7, 0x0B8F, 0x0E67,
0x0C3D, 0xFB4B, 0xFD7E, 0xF1B4, 0xFBB7, 0xFDEE, 0xF9C2, 0x1030,
0xF5D2, 0x0365, 0x0071, 0xF49E, 0xFA03, 0xFFF5, 0xF111, 0xF7EA,
0x02B4, 0xF442, 0x0D2D, 0x1363, 0x0636, 0x1218, 0x0373, 0xF61C,
0x0616, 0xF5F0, 0x04C2, 0x02A8, 0xF3C4, 0x035B, 0xECA5, 0xF75A,
0x035C, 0xFE8B, 0x08CC, 0x052B, 0xFAEA, 0xF104, 0xFE44, 0xFC12,
0x0406, 0x17D1, 0x05F6, 0x0965, 0x018E, 0xF422, 0x0119, 0xF7D6,
0x049E, 0x04CF, 0xF35D, 0x0035, 0xF2F7, 0xEFFA, 0x03B8, 0x0024,
0xFEE9, 0x0CE6, 0xFD8E, 0xF5EB, 0x02CC, 0xFCB2, 0x01C6, 0x141F,
0x0425, 0x0208, 0xFF86, 0xEDC5, 0xFCCE, 0xF56E, 0x00F6, 0x070F,
0xFA37, 0x0215, 0xFC2E, 0xF3C3, 0x02E3, 0x04D0, 0xF3C8, 0x0632,
0xF72D, 0xF418, 0x0A89, 0x0405, 0x0490, 0x0EEC, 0xFD33, 0xF9E8,
0xFFC7, 0xEE92, 0x0AA3, 0xF87B, 0x0815, 0x07AB, 0xF723, 0x05ED,
0x0108, 0xFD8C, 0x035A, 0x0325, 0xF024, 0xF84B, 0xEF55, 0xF0E7,
0xF802, 0x0EBC, 0x02F5, 0x104D, 0x08D5, 0xEFAD, 0x06B1, 0xED0F,
0x0C27, 0x00E4, 0x052F, 0x0A1A, 0xF45C, 0xFC96, 0xFCB3, 0xFC83,
0x032F, 0x08F6, 0xF02A, 0xF26D, 0xEC03, 0xEF66, 0xF765, 0x1362,
0x055B, 0x0DC7, 0x112B, 0xEFD2, 0x106D, 0xF3F1, 0x0D0C, 0x05C3,
0xFD30, 0x03E1, 0xF592, 0xF5F9, 0xFD48, 0xFE92, 0xF2FE, 0x08E7,
0xF064, 0xF45B, 0xFC5A, 0xF248, 0x00E8, 0x0A6C, 0x03E2, 0x067C,
0x081C, 0xF96A, 0x15C6, 0xFC2F, 0x1559, 0x044B, 0xFC91, 0x03CB,
0xF43A, 0xF739, 0xF7B2, 0xFFEB, 0xED5C, 0x02FD, 0xF0EE, 0xEEAD,
0x0502, 0xFDE9, 0x06B0, 0x1339, 0x011D, 0xFDC4, 0xFEE4, 0xF03E,
0x0947, 0x03C9, 0x11B6, 0x0BFB, 0xFC95, 0xF694, 0xF5A7, 0xF2F8,
0xFC78, 0x0341, 0xF4A9, 0xF5D4, 0xF887, 0xEE31, 0x0440, 0x0F8B,
0x0C23, 0x1961, 0x0451, 0xF85C, 0xFA46, 0xEED7, 0x06F8, 0x059D,
0x0166, 0x0DC4, 0xF730, 0xFB0A, 0x08C3, 0xF30C, 0x07F5, 0xFE57,
0xF513, 0xF6CE, 0xF84F, 0xF328, 0xFC1F, 0x0C5C, 0xFD46, 0x11B3,
0x063C, 0xFAE1, 0x02DC, 0xF330, 0x0126, 0x041E, 0xFD52, 0x0791,
0xFCBA, 0xF4E1, 0x10B9, 0xFD9B, 0x0B28, 0x07BB, 0xF4D1, 0xF1D2,
0xF46C, 0xF7A9, 0xF6CA, 0x1398, 0xF9A3, 0x0716, 0xFAC8, 0xF04E,
0x03D6, 0xFD92, 0x0DA2, 0x06F1, 0xFFB1, 0xF3D9, 0xFDF3, 0xF302,
0x08E2, 0x0D64, 0x0064, 0x07B9, 0xF9B0, 0xED88, 0xFC57, 0x0059,
0xF84D, 0x14D0, 0xF9CE, 0xFA87, 0xFED5, 0xEA07, 0x0895, 0xFCE0,
0x111F, 0x0EA8, 0x0250, 0x0085, 0xFD63, 0xF41B, 0x02AB, 0x098E,
0xF39D, 0x0623, 0xF539, 0xEF1D, 0x01C7, 0xFE87, 0xFD1B, 0x0F78,
0xFE05, 0xF649, 0x0553, 0xE1AF, 0x0BF2, 0x01B8, 0x0531, 0x1C08,
0xFCE8, 0x03A9, 0x062F, 0xFB14, 0xFE97, 0x0A51, 0xE8CC, 0xF872,
0xEEBA, 0xED12, 0x0243, 0x0990, 0x0AF1, 0x0B06, 0x095C, 0xEE11,
0x067F, 0xF175, 0x0A96, 0x0B17, 0xFE83, 0x0D77, 0xF5E6, 0xFBCE,
0x05D1, 0x037D, 0xFB86, 0x08C3, 0xE95D, 0xEA09, 0xF85F, 0xEDC8,
0x0095, 0x1149, 0x04F0, 0x0EA2, 0x0E26, 0xF653, 0x0C53, 0xF958,
0x099B, 0x1016, 0xF8FB, 0x0583, 0xEFB8, 0xED7D, 0xFEAC, 0x0111,
0xFC96, 0x089E, 0xF343, 0xE825, 0xFD0F, 0xEF48, 0x0483, 0x172B,
0x045E, 0x1357, 0x0719, 0xF844, 0x111B, 0xFE32, 0x0C75, 0x11B3,
0xF434, 0x002C, 0xF5CB, 0xE7C5, 0xFED0, 0xFC87, 0xEEF0, 0x018F,
0xF26A, 0xEF06, 0x04A8, 0x08B6, 0x03EA, 0x1A5F, 0x047F, 0x002B,
0x04DF, 0xF368, 0x05C5, 0x03E1, 0x05C4, 0x0D2C, 0xFCA3, 0xF3C0,
0x01D0, 0xE9BA, 0x0032, 0x02F9, 0xEC83, 0x00AB, 0xF462, 0xF981,
0x08A9, 0x14D7, 0x0818, 0x194F, 0xFECA, 0xF4D0, 0xF9A3, 0xEA05,
0xFF0C, 0x07D6, 0xFDBB, 0x0D13, 0xFD5E, 0xEE04, 0x0C44, 0xF254,
0x06BC, 0x0E48, 0xF1D7, 0xFB13, 0xF56D, 0xEF71, 0x00BE, 0x115E,
0xFFC7, 0x125F, 0xFBCD, 0xF01F, 0x00CF, 0xEC59, 0x0658, 0x095B,
0xF8C5, 0x0ED5, 0xFED4, 0xF974, 0x19D9, 0x05A9, 0x0C07, 0x0FD1,
0xF11C, 0xF1C4, 0xF356, 0xEF06, 0xF3AA, 0x09D0, 0xF352, 0x0493,
0xFF0F, 0xEB60, 0x0B25, 0xF2F9, 0x0A8A, 0x0F8D, 0xFE07, 0x0C27,
0x05C7, 0xFCF0, 0x1423, 0x0B1A, 0x05C1, 0x0851, 0xF141, 0xEC21,
0xEE6C, 0xF863, 0xF589, 0x0DED, 0xFA80, 0xF71D, 0xFD37, 0xEA49,
0x0C97, 0x09BE, 0x1016, 0x2150, 0x0147, 0x0651, 0x0923, 0xF14E,
0x0ABE, 0x0799, 0xF1C9, 0x0024, 0xEF83, 0xE7D3, 0xFD0F, 0xFC6F,
0x004E, 0x0BD5, 0x0138, 0xF4FA, 0x03BA, 0xF020, 0x109F, 0x1621,
0x0BC1, 0x25F7, 0xFD86, 0x01B6, 0x0773, 0xF1E6, 0xFED4, 0x047F,
0xE868, 0xF8E5, 0xF078, 0xEA16, 0x039A, 0x045A, 0x0A8E, 0x0C9E,
0x06BE, 0xF364, 0x09C4, 0xF4BB, 0x1094, 0x1447, 0xFD3F, 0x19FD,
0xF5B9, 0xFCD9, 0x0ACB, 0xFCE1, 0x02FE, 0x099E, 0xEFA9, 0xF14C,
0xF761, 0xF027, 0x01DF, 0x119E, 0x0A11, 0x0D81, 0x0B03, 0xF13C,
0x087F, 0xF8A3, 0x07B8, 0x13C8, 0xF43C, 0x0AD2, 0xF7D1, 0xF563,
0x10C6, 0x0636, 0x0709, 0x09B1, 0xF733, 0xECB7, 0xF99A, 0xF71E,
0xFEF2, 0x1553, 0x0481, 0x066D, 0x05B6, 0xEDD4, 0x0C0C, 0xFD25,
0x0885, 0x16B1, 0xF7FB, 0x075D, 0x049D, 0xF296, 0x0FB1, 0x07EE,
0xFAF8, 0x0C1B, 0xF554, 0xF4C3, 0xFC2F, 0x00A9, 0xFB79, 0x0F4D,
0xFE83, 0xF57D, 0x0030, 0xE5DE, 0x0D6F, 0x0294, 0x0DE6, 0x1788,
0xFC72, 0xFEFB, 0x0A80, 0xF6E8, 0x0DCC, 0x12A3, 0xF35B, 0x0B1E,
0xF151, 0xF95C, 0xFCEC, 0x0DCF, 0x00DC, 0x0BBA, 0xFF63, 0xE6D8,
0x01B6, 0xE356, 0x0D66, 0x081B, 0x051F, 0x1421, 0xFF24, 0xF960,
0x11DB, 0xFF9F, 0x0A19, 0x158D, 0xF0B1, 0xFE48, 0xF234, 0xF5E4,
0xFB22, 0x1006, 0x0273, 0x04E7, 0x05E4, 0xE157, 0x0383, 0xE802,
0x0601, 0x0ED6, 0xFAA7, 0x1467, 0xFF99, 0xFC56, 0x18B0, 0x08EC,
0x09EA, 0x1826, 0xF356, 0xF989, 0xF86B, 0xF2E6, 0xFCCD, 0x0BD4,
0x0081, 0xFCDA, 0x02F6, 0xDF8C, 0x05B0, 0xF043, 0x03F2, 0x153A,
0xF56A, 0x1049, 0xFFA2, 0xFEAD, 0x1658, 0x13AD, 0x0B01, 0x129D,
0xFB66, 0xF071, 0xFD57, 0xF681, 0xFA43, 0x0A18, 0xF80E, 0xF39D,
0xFDCA, 0xE15C, 0x09AC, 0xFF94, 0x0356, 0x1ABF, 0xF120, 0x053F,
0x0504, 0xF8CB, 0x159D, 0x0F98, 0x0151, 0x03D3, 0xF877, 0xE9F8,
0xFAB0, 0xFFC5, 0xF9C2, 0x0BF6, 0xFC62, 0xEE59, 0x015B, 0xE933,
0x0D53, 0x1018, 0x0657, 0x2233, 0xF974, 0x00B0, 0x087F, 0xF376,
0x09C3, 0x09E9, 0xF3A3, 0xFE38, 0xF000, 0xEEB4, 0xFBDB, 0x05DF,
0x030B, 0x0995, 0x0169, 0xEBFE, 0x0540, 0xED9A, 0x0DB3, 0x1542,
0xFC9B, 0x1874, 0xF81C, 0xF439, 0x0C78, 0xF9BE, 0xFF08, 0x0D8A,
0xED0E, 0xF6F1, 0xF716, 0xF4AA, 0xFFDE, 0x122C, 0x06BB, 0x07DA,
0x07B8, 0xE80B, 0x0A1F, 0xF090, 0x0A04, 0x0E35, 0xF281, 0x04BE,
0xF2F5, 0xEC38, 0x0827, 0x020E, 0xFFA5, 0x0FA3, 0xF28C, 0xF4C2,
0xF5A2, 0xFC61, 0xFDD2, 0x17C5, 0x0529, 0x032E, 0x05FA, 0xE5BC,
0x0E5B, 0xF537, 0x0A9A, 0x0E62, 0xF020, 0xFE34, 0xF785, 0xF03D,
0x0C54, 0x0D7F, 0xFFDC, 0x113D, 0xF58E, 0xF76F, 0xF66F, 0x013E,
0xFAA0, 0x0BE9, 0x0212, 0xEE4E, 0x02EF, 0xDC10, 0x0D23, 0xFA34,
0x060D, 0x13BA, 0xF4E2, 0xFDCA, 0x0702, 0xF91F, 0x0939, 0x186E,
0xF454, 0x0EEE, 0xF62E, 0xF735, 0xF9ED, 0x072F, 0xFB98, 0x0375,
0x0058, 0xDC9F, 0x023E, 0xDC8A, 0x0B04, 0x0A58, 0x04B4, 0x197B,
0xFDDD, 0xFC6A, 0x0AE9, 0xFEF5, 0x0362, 0x15DC, 0xF21F, 0x04A9,
0xF48C, 0xF703, 0xFAF3, 0x073E, 0x01AC, 0xFDC4, 0xFFA2, 0xDDBE,
0x04F5, 0xE832, 0x10E2, 0x15D0, 0xF97D, 0x19E6, 0xF439, 0xFBF0,
0x0C88, 0x0527, 0x028C, 0x0FAB, 0xF584, 0xF23A, 0xF975, 0xF082,
0xFA36, 0x0924, 0x01DC, 0xFB5E, 0x056D, 0xE1AC, 0x07D2, 0xF5C7,
0x0406, 0x1C77, 0xEEEE, 0x0FC3, 0xF775, 0xF567, 0x10CA, 0x0B0D,
0x0B10, 0x0B59, 0xFFCD, 0xEB9C, 0xFB3D, 0xF794, 0xFA27, 0x101D,
0x000E, 0xFBEC, 0xFB63, 0xE50D, 0xFE23, 0xFE6B, 0xFD79, 0x178E,
0xF0FB, 0xFCC7, 0x05B2, 0xEF63, 0x14DE, 0x0B72, 0x0431, 0x0837,
0xFFA7, 0xF5BD, 0xFDB8, 0x0673, 0xF85F, 0x1051, 0xF6E2, 0xF8F7,
0xF70B, 0xE7AC, 0x0673, 0xFE92, 0x066B, 0x1334, 0xFE4E, 0xF728,
0x105D, 0xF11B, 0x0DD7, 0x0E1C, 0xF901, 0x0532, 0xF7F8, 0xFC32,
0xF359, 0x129D, 0xF352, 0x0C25, 0xFB8E, 0xE679, 0x00D0, 0xE265,
0x0EE3, 0x06B2, 0x097A, 0x0E6D, 0x0258, 0xF575, 0x0E9D, 0x01AA,
0x0386, 0x14C9, 0xF1E8, 0x00FC, 0xEDCB, 0x0026, 0xEBDC, 0x12FA,
0xFB0E, 0xFF72, 0x08B7, 0xDE2C, 0x118E, 0xE6BA, 0x156C, 0x0BB7,
0xFDFD, 0x09D7, 0xFC0A, 0xF4E9, 0x0AE3, 0x1010, 0xF5AB, 0x199B,
0xE8A3, 0xF890, 0xF1BA, 0xFC3E, 0xF544, 0x0D13, 0x05E2, 0xF817,
0x1436, 0xE15C, 0x1746, 0xF25A, 0x0D44, 0x1108, 0xF421, 0x0529,
0xF71C, 0xF816, 0xFEBF, 0x15F6, 0xF066, 0x11EE, 0xF1D7, 0xEFC2,
0xFA04, 0xFA57, 0x029E, 0x0938, 0x0DB2, 0xF399, 0x092D, 0xE74C,
0x0D22, 0x005E, 0x081D, 0x154F, 0xF15A, 0xFF3E, 0xF944, 0xFA8C,
0x00F2, 0x1615, 0xF573, 0x0608, 0xFE4F, 0xF2DF, 0x03EE, 0x0877,
0xFE88, 0x07DB, 0x011E, 0xEC19, 0x015C, 0xE7AB, 0x0403, 0x03FC,
0xF85A, 0x1101, 0xF216, 0xF59C, 0x0670, 0xF7FE, 0x05C4, 0x12A0,
0xFD9D, 0x007F, 0x026E, 0xF8BF, 0xFC49, 0x1319, 0xFD61, 0x0867,
0x01AA, 0xE51C, 0x017C, 0xEA00, 0x0322, 0x0D4D, 0xF173, 0x0B9F,
0xF2CC, 0xEED5, 0x0E8A, 0xFEE6, 0x09DB, 0x123E, 0xFA63, 0xFD92,
0xF92A, 0xFF25, 0xF74F, 0x0F2A, 0x0038, 0xFDB2, 0x011B, 0xE934,
0xFE43, 0xF2FD, 0x0187, 0x0BE4, 0xF396, 0x03C1, 0xFD73, 0xF0B0,
0x1203, 0x0C1D, 0x02F6, 0x140F, 0xFB1F, 0xF681, 0xFBEA, 0xFDAB,
0xF3E5, 0x0C0C, 0xF961, 0xF863, 0xFFC5, 0xE9B4, 0x02FB, 0xFB26,
0x0067, 0x0BEF, 0xF9A3, 0xF824, 0x067A, 0xF3A5, 0x091B, 0x129D,
0xFACD, 0x09FA, 0xFF74, 0xF2E5, 0xFD90, 0x0666, 0xF412, 0x0C60,
0xFA03, 0xF21D, 0xFEA5, 0xEBFB, 0x0DDB, 0x0526, 0x0CA8, 0x11B8,
0xF75A, 0xF5B5, 0x0604, 0xF3B0, 0x0BF6, 0x1164, 0xF52B, 0x02E9,
0xF205, 0xF68D, 0xF348, 0x0B49, 0xF511, 0x0570, 0xFECD, 0xEDB7,
0x0939, 0xEFFB, 0x159E, 0x0B63, 0x0B2F, 0x107A, 0xFF16, 0xF559,
0x0A8F, 0xF9C7, 0x0099, 0x0E49, 0xEA58, 0xFE61, 0xE7C9, 0xFBFD,
0xE864, 0x1094, 0xFAFF, 0xFECC, 0x1075, 0xE3F9, 0x1108, 0xF328,
0x13D7, 0x0EB2, 0x0B18, 0x05B0, 0x02D5, 0xF0C5, 0x03A1, 0x0601,
0xEF5D, 0x0F95, 0xE4E7, 0xF8D2, 0xED49, 0x037C, 0xF3C2, 0x0F70,
0x0672, 0xF7F3, 0x1585, 0xEB47, 0x195F, 0xFDCF, 0x130A, 0x100B,
0xFD21, 0xFEF4, 0xF752, 0xF2AD, 0xF8F2, 0x0D81, 0xE944, 0x0D87,
0xEAFF, 0xF389, 0xFB45, 0xFEAC, 0x0039, 0x0ACF, 0x0881, 0xF4CC,
0x1125, 0xEC54, 0x16AA, 0x0429, 0x0B0A, 0x10BC, 0xF1A5, 0xF95D,
0xF6B0, 0xF644, 0x00C9, 0x116F, 0xF7EA, 0x05F7, 0xFC57, 0xF66A,
0xFDB8, 0x0A6D, 0xFC4B, 0x08E8, 0x068D, 0xEFEB, 0x059B, 0xEEE4,
0x0288, 0x0848, 0xFCCB, 0x0CC1, 0xF813, 0xEF5C, 0x07DE, 0xF572,
0x0CCA, 0x0F4B, 0x0167, 0x00A8, 0x0199, 0x01DA, 0xFD4F, 0x1939,
0xF850, 0x075B, 0xFE13, 0xEA50, 0xFFF6, 0xF25A, 0xFD85, 0x0AFB,
0xF7EF, 0x065C, 0x043F, 0xEEBC, 0x19C8, 0xFC83, 0x0E64, 0x0E1F,
0xFCCF, 0xFFC8, 0xFB71, 0x0714, 0xF5B4, 0x1685, 0xF490, 0xFF3B,
0xF6AD, 0xE4CA, 0x0047, 0xF066, 0x0D4C, 0x0CF3, 0x0518, 0x0428,
0x0898, 0xF1B2, 0x18F0, 0x0C46, 0x0A7F, 0x141A, 0xF6C3, 0xFED4,
0xF102, 0x09EC, 0xEBEE, 0x0D01, 0xF3A3, 0xF0FA, 0x0094, 0xE6DA,
0x0BD0, 0xFA76, 0x110E, 0x0B60, 0x0A53, 0xFE71, 0x07B6, 0xFD67,
0x043B, 0x1A70, 0xFC25, 0x113D, 0xF961, 0xF77A, 0xF06B, 0x03A1,
0xEC81, 0x02C7, 0xFD89, 0xEC2C, 0x1055, 0xEF93, 0x17A7, 0x07AA,
0x0A53, 0x1005, 0xFDC1, 0xFF6D, 0x059B, 0x05E3, 0xFE92, 0x1609,
0xEC28, 0xFA93, 0xEEEC, 0xECCD, 0xF631, 0x0184, 0xFBF1, 0xFD37,
0x04A6, 0xEB1F, 0x106C, 0xF45C, 0x18B8, 0x1629, 0x06BE, 0x1D6F,
0xFB5A, 0xFEE3, 0x04F1, 0x0010, 0xFA7E, 0x0B41, 0xEAA5, 0xEF83,
0xED32, 0xEF38, 0xF488, 0x09AD, 0x01FD, 0xFC5D, 0x0CCB, 0xEA9E,
0x1067, 0xFFD6, 0x0FC1, 0x1AA6, 0x04DA, 0x0D37, 0x02F8, 0xF193,
0x001B, 0xFC85, 0xEF6D, 0x0142, 0xEFD2, 0xF06D, 0xF4D2, 0xFF3C,
0xF2D0, 0x0E35, 0x0166, 0xFE1E, 0x0EE3, 0xF66D, 0x1748, 0x07B3,
0x1267, 0x1355, 0xFC28, 0xFAFC, 0xFFAD, 0xEA6C, 0x0350, 0x0379,
0xECEC, 0x03A8, 0xEA7E, 0xEF5C, 0xF5CD, 0x01D3, 0xF66C, 0x0FCF,
0xFB62, 0xFD84, 0x0B73, 0xF663, 0x1C91, 0x05CE, 0x0EEE, 0x0A3F,
0xF8D9, 0xF1C2, 0x0332, 0xF138, 0x0487, 0x0FC0, 0xF413, 0x08D4,
0xF129, 0xF9D8, 0xEF46, 0x0B18, 0xF57A, 0x0B5B, 0x0130, 0xF3F7,
0x032E, 0xEEAC, 0x0C5F, 0xFF1A, 0x095B, 0xFFD0, 0xFFA1, 0xEEB0,
0x0707, 0xFC0D, 0x02C1, 0x1137, 0xFA51, 0x05B2, 0xFAD7, 0x07EC,
0xF1AC, 0x1588, 0xF25E, 0xFE49, 0xFE1D, 0xE531, 0x0510, 0xEEE1,
0x0702, 0x0495, 0xFE8E, 0x01B6, 0x063C, 0xF0EE, 0x13F3, 0x02BE,
0x01AA, 0x1398, 0xF47E, 0x0382, 0xFA89, 0x06A1, 0xF1E7, 0x0E76,
0xEA07, 0xF2E9, 0xF36F, 0xDEF1, 0x0A26, 0xF55A, 0x1160, 0x0F2F,
0xFF16, 0x00B2, 0x093C, 0xF46C, 0x1A9B, 0x0FFF, 0x0427, 0x15EC,
0xF0D6, 0xFE86, 0xED56, 0xFFEB, 0xEA87, 0x01AC, 0xEECD, 0xED63,
0xF6C8, 0xE787, 0x0B5C, 0xFA9D, 0x1449, 0x09FE, 0x0788, 0xFF3D,
0x0A5B, 0xFE84, 0x0B5F, 0x1518, 0xFBDF, 0x0B7E, 0xF3E6, 0xF6E5,
0xEB4C, 0xFF3D, 0xE8DB, 0xFCE1, 0xFB02, 0xEC95, 0x0CCB, 0xF1B4,
0x12F6, 0x08A6, 0x0A05, 0x0EDD, 0x055F, 0xFDDE, 0x0A7E, 0x015C,
0xF975, 0x0B76, 0xE86D, 0xF672, 0xF099, 0xEF01, 0xF3FE, 0x00E1,
0xF4DE, 0xFC1D, 0xFEF0, 0xED7F, 0x10FA, 0xFCC0, 0x1E5F, 0x19CD,
0x0A00, 0x1508, 0xFB68, 0xF77C, 0x068B, 0xFB23, 0xF98A, 0x038F,
0xE53A, 0xEEF4, 0xEC5D, 0xF42B, 0xF89C, 0x06B0, 0xFEA6, 0xFA95,
0x033C, 0xF2B6, 0x100A, 0x057A, 0x175E, 0x1781, 0x0761, 0x07AA,
0x0072, 0xF0D3, 0x0018, 0xF952, 0xF318, 0xFC44, 0xF1FA, 0xF6B8,
0xF24C, 0x0529, 0xEF58, 0x0BC9, 0x008B, 0xFEBC, 0x0EB9, 0xFB58,
0x1213, 0x09F4, 0x0C43, 0x0E20, 0x00D1, 0xF529, 0x0701, 0xEA84,
0x01AD, 0xFFD4, 0xEBC3, 0xFD17, 0xEDD9, 0xF4FE, 0xF4D2, 0x0DD8,
0xF340, 0x112E, 0xFAB8, 0xF967, 0x0A14, 0xF69F, 0x1A69, 0x07EB,
0x0F67, 0x0912, 0xFF19, 0xEEE6, 0x0D99, 0xF1B2, 0x081C, 0x0B7B,
0xEC70, 0x03AB, 0xEBCC, 0xFEEA, 0xF17E, 0x0E33, 0xF29E, 0x080F,
0xF98D, 0xF0C8, 0x05D1, 0xEC45, 0x1622, 0xFEFC, 0x0FA8, 0x0319,
0x058D, 0xF581, 0x0A8C, 0x00E2, 0x00AB, 0x10FB, 0xF70F, 0x0737,
0xF4D9, 0x0954, 0xEBD5, 0x0E86, 0xF318, 0xF7BB, 0xFFC0, 0xE6D9,
0x063B, 0xEFAA, 0x0D47, 0x038C, 0x0645, 0x036B, 0x07CE, 0xF876,
0x0E9E, 0x0AF1, 0xFCF2, 0x0FB2, 0xF43F, 0xFC16, 0xF976, 0x0317,
0xF27C, 0x08F4, 0xF064, 0xF12D, 0xF920, 0xE391, 0x0A32, 0xFBAD,
0x0BFC, 0x1235, 0xFD64, 0x0243, 0x0E01, 0xFC18, 0x1724, 0x1163,
0xFA91, 0x0A0F, 0xF177, 0xF74D, 0xF50B, 0xFF01, 0xF017, 0xFDAF,
0xF394, 0xECF9, 0xF7E6, 0xED7B, 0x04B9, 0x034C, 0x0C70, 0x1280,
0x0595, 0x02F3, 0x0DCE, 0xFF3E, 0x0CA4, 0x0E85, 0xFA25, 0x0038,
0xF4E8, 0xF55E, 0xEE5B, 0xFF89, 0xEEB1, 0xFB2D, 0xFB15, 0xF342,
0x009D, 0xF985, 0x0A1E, 0x0B7E, 0x0837, 0x0F3A, 0x05F0, 0xFBE9,
0x10E8, 0xFC94, 0x00AE, 0x041D, 0xEE89, 0xF5B5, 0xF587, 0xF54E,
0xF1BE, 0x0335, 0xEF7A, 0x0032, 0xFD79, 0xF6D6, 0x0EAD, 0x00B0,
0x1543, 0x160C, 0x01E5, 0x09C5, 0xFE37, 0xEE14, 0x0DDF, 0xFC4C,
0xFC12, 0x03C0, 0xE797, 0xF180, 0xEDA5, 0xFC86, 0xF2EF, 0x098C,
0xFC1A, 0xFFE0, 0x04D2, 0xF9ED, 0x0C53, 0x019A, 0x1474, 0x0F2C,
0x0671, 0x0209, 0xFFE5, 0xEFBF, 0x061C, 0xFDB5, 0xF558, 0x0169,
0xEA44, 0xFD09, 0xEFAE, 0x0799, 0xF4FF, 0x068E, 0x02BA, 0xFCFD,
0x0710, 0xF911, 0x0778, 0x002B, 0x0A4C, 0x06E4, 0x03D8, 0xF7B8,
0x088A, 0xF3A3, 0x033F, 0x024B, 0xEDB6, 0x0099, 0xF217, 0x02FA,
0xF82A, 0x0BA5, 0xF434, 0x02A6, 0xFF7F, 0xF7E5, 0x085E, 0xF79E,
0x0DBF, 0x0499, 0x0D91, 0x08BA, 0x077C, 0xF6B5, 0x0F37, 0xFBDF,
0x0704, 0x0BE6, 0xEE74, 0x056D, 0xECDB, 0x0436, 0xEF9F, 0x03A9,
0xF18C, 0xF759, 0xFAD5, 0xEDE0, 0x0408, 0xF211, 0x114E, 0x04E0,
0x10CD, 0x08DB, 0x0B59, 0xFEC6, 0x0F44, 0x073B, 0x0455, 0x0E96,
0xF4AD, 0x08E1, 0xF04D, 0x0558, 0xEB2E, 0xFB7E, 0xF2C3, 0xF0EC,
0x0361, 0xF1CB, 0x0779, 0xF9C8, 0x0A41, 0x084C, 0x0E3B, 0x0A0E,
0x1098, 0x01D1, 0x0C06, 0x096C, 0xF8FC, 0x0828, 0xF3DE, 0xFE78,
0xF96D, 0xFDF4, 0xEF3D, 0xF6F9, 0xF232, 0xF44D, 0x048B, 0xFA74,
0x0DE0, 0x0446, 0x0DB7, 0x1027, 0x0B02, 0x097D, 0x0F10, 0x01F3,
0x0ABD, 0x0761, 0xF6EB, 0x0135, 0xEFC3, 0xFAC7, 0xF699, 0xFBF3,
0xF546, 0xF79F, 0xF5B0, 0xF769, 0xFFED, 0xFD52, 0x0BCF, 0x0748,
0x110D, 0x11EC, 0x0BEA, 0x07BC, 0x0AC9, 0xFCFC, 0x0818, 0x00D9,
0xFB0B, 0x0149, 0xF784, 0x0595, 0xF43F, 0x000A, 0xF3BA, 0xF649,
0x025F, 0x0081, 0x071C, 0x044C, 0x0708, 0x0508, 0x09F6, 0x0957,
0x0BCE, 0xFC12, 0x0E46, 0xF81D, 0x0490, 0x0012, 0xF72D, 0x026D,
0xF564, 0x06F1, 0xF1E7, 0x023D, 0xF38D, 0xFF94, 0x0654, 0x0716,
0x11BD, 0x04D7, 0x0E23, 0x0436, 0x083C, 0x026D, 0x09B9, 0xF9C6,
0x0CF2, 0x011E, 0xFB87, 0x0329, 0xEA6C, 0xFD57, 0xEE43, 0x0502,
0xF0FA, 0x047D, 0xFAB0, 0x0284, 0x0C89, 0x03AC, 0x1810, 0xFCC1,
0x1A78, 0x0258, 0x0C3D, 0x0478, 0x00D6, 0xFC4D, 0xFF8E, 0x0016,
0xF696, 0x0228, 0xEF8A, 0x0649, 0xF1B4, 0x07F9, 0xF5FD, 0xFF09,
0x041A, 0x0207, 0x133F, 0x01CA, 0x15E1, 0xFB3D, 0x1132, 0x0400,
0x0790, 0x02B3, 0xFFCB, 0xF72F, 0xF9D0, 0xFB84, 0xF3DC, 0x056D,
0xF7C7, 0x0C9E, 0xF7E4, 0x06A3, 0xF6AF, 0xFAF4, 0x0751, 0x00DD,
0x12CA, 0x0417, 0x0D58, 0x01D1, 0x0322, 0x049F, 0x017C, 0xFB28,
0x08DF, 0xFA20, 0x024D, 0x054A, 0xF3B5, 0x060F, 0xF4B3, 0x06B0,
0xF9E5, 0x0105, 0xFC7D, 0xFA36, 0x040B, 0xFE5F, 0x07BC, 0xFD9E,
0x061D, 0xFEBC, 0x02D3, 0x0397, 0x049F, 0x00CA, 0x0EA9, 0x02CE,
0x0AC3, 0x082F, 0xF9BF, 0x0874, 0xF3E5, 0x03E4, 0xF402, 0xFA54,
0xF69F, 0xFAC7, 0xFC5D, 0xFD83, 0x0069, 0xF595, 0x052B, 0xFE85,
0x08AD, 0x0A3D, 0x0D5B, 0x01D9, 0x0E49, 0x01AC, 0x07C1, 0x0596,
0x02FC, 0x06CE, 0xF752, 0x04A0, 0xE592, 0xF7B4, 0xEC90, 0xF76D,
0x0278, 0xFCFB, 0x09D5, 0xFD64, 0x0AA9, 0x0758, 0x0C38, 0x0A78,
0x0D9C, 0x02BF, 0x09EC, 0x013F, 0xFD04, 0x0348, 0xF762, 0x044F,
0xF498, 0xFDBE, 0xEB87, 0xF2E4, 0xF1A2, 0xF516, 0x0573, 0xFF91,
0x13C9, 0x091C, 0x0EFE, 0x0DC9, 0x02CE, 0x01BA, 0x069E, 0xFB75,
0x0585, 0x050C, 0xF5E4, 0x06C1, 0xF0B6, 0x029C, 0xF4F7, 0xF843,
0xFD42, 0xF6F4, 0x05C2, 0x03F4, 0x0418, 0x00D3, 0x054B, 0xFFAB,
0x0A53, 0x0888, 0x075C, 0xFDEC, 0x0044, 0xF44A, 0xF402, 0xFD04,
0xEFFD, 0x06C5, 0xFC22, 0x08E6, 0xFBC6, 0x013D, 0xFA34, 0xFD90,
0x0935, 0x038F, 0x0E04, 0x0165, 0x0887, 0xFE10, 0x033A, 0xFEB1,
0x00B9, 0xF905, 0x0031, 0xF9D3, 0xF60D, 0xFE19, 0xF272, 0x056E,
0xF966, 0x0DA3, 0xF8A6, 0x037B, 0xFCA8, 0xFC32, 0x0707, 0xFB02,
0x0EF2, 0xF777, 0x0FD7, 0x0008, 0x003F, 0xFFAB, 0xF5BA, 0xF70B,
0xFD60, 0xFDC4, 0xFC6F, 0x075C, 0xF6A0, 0x0C5E, 0xF6AA, 0x0716,
0xF257, 0xF96E, 0xFDFD, 0xF791, 0x0EF6, 0xFA06, 0x0E2C, 0xF89A,
0x0989, 0xFDBB, 0x00BA, 0xFE3A, 0xFD75, 0xFB85, 0xFDF2, 0x0407,
0xF56C, 0x0AFF, 0xF4E1, 0x0991, 0xF5CB, 0xFF1D, 0xF7D6, 0xF7D7,
0x05B0, 0xFB2A, 0x0BA3, 0xF69E, 0x08D8, 0xF8A1, 0x08DD, 0x0455,
0x09B6, 0x02FE, 0x033A, 0x00AA, 0xF312, 0x015D, 0xEB77, 0x037B,
0xF7EF, 0x0747, 0xFCE4, 0xFDA7, 0xF674, 0xF501, 0x008B, 0xFA10,
0x0B0C, 0xFC6F, 0x0A5E, 0x0065, 0x0638, 0x060A, 0xFFBA, 0xFF78,
0x01F0, 0xFE75, 0xFFBC, 0x0302, 0xF4FA, 0x009F, 0xF53A, 0x02E4,
0xF8AF, 0x0084, 0xF916, 0xFB78, 0xFB60, 0xFA0C, 0x02A0, 0xF72E,
0x08BE, 0x01B2, 0x04C3, 0x04E2, 0x00CC, 0xF7B3, 0x03EC, 0xFA02,
0x0673, 0x0553, 0x02B1, 0x0BCC, 0xF824, 0x06E3, 0xEAAF, 0xFCAB,
0xF1BE, 0x003B, 0x0819, 0xFFD0, 0x0A16, 0xF70D, 0x0108, 0xFA83,
0x0036, 0xFCEE, 0x0877, 0xFC15, 0x0D5E, 0x0282, 0xFDE7, 0x0401,
0xF474, 0x06AB, 0xF747, 0x07FE, 0xF17C, 0xFFD2, 0xF3BF, 0xFD55,
0xFF07, 0xF671, 0x08DA, 0xF4F0, 0x0E59, 0x02D1, 0x087D, 0xFF42,
0x02FE, 0xFAFD, 0x023B, 0x04A3, 0xFB3D, 0x093D, 0xF5AD, 0x0A18,
0xF4FE, 0x0123, 0xF3DF, 0xFA7A, 0xF92A, 0xFC17, 0x028D, 0xF7EE,
0x0C4B, 0xFC34, 0x101B, 0x0336, 0x06DC, 0xFC18, 0xFF38, 0xFABA,
0xF8F0, 0x04AF, 0xF296, 0x0848, 0xF7ED, 0x05F3, 0xF7E9, 0x0072,
0xF73A, 0xFD18, 0x0535, 0xFE5E, 0x0C65, 0xF9B7, 0x0A4C, 0xFE63,
0x0838, 0x04F9, 0x0116, 0xF801, 0xF8E6, 0xF56C, 0xF446, 0x0044,
0xF3B6, 0x0600, 0xF6C8, 0x05DE, 0xF7FA, 0xFFBF, 0xFFCB, 0x029E,
0x1069, 0x0494, 0x1272, 0xFC1E, 0x0110, 0xFBB8, 0xF465, 0xFBE0,
0xFA69, 0xF86F, 0x02DD, 0xFB98, 0xF6BB, 0xFD5A, 0xEC30, 0x00ED,
0xFB9A, 0x08BA, 0x060F, 0x09A7, 0x0380, 0x07B6, 0x05B4, 0xFE4E,
0x099A, 0xF66D, 0x09FE, 0xFD56, 0xFDE8, 0xF76A, 0xF1A7, 0xED74,
0xF52C, 0xF80F, 0xFAFC, 0x06DC, 0xFE00, 0x0EE2, 0xFAC1, 0x080A,
0xF897, 0x01F0, 0x04EE, 0x07A5, 0x0B41, 0x0075, 0x052E, 0xF9B3,
0x0464, 0xFD17, 0x05EF, 0xF7CD, 0xFD2F, 0xF2B3, 0xF066, 0xF817,
0xF161, 0x038A, 0xFE86, 0x0CCC, 0x01A3, 0x080D, 0xF832, 0xFC25,
0xF987, 0xFAC2, 0x074C, 0xFD97, 0x0D8D, 0x0341, 0x05E2, 0x05BF,
0xFDA3, 0xF960, 0x0380, 0xFAB6, 0x0533, 0x04A7, 0xF5CB, 0x01A2,
0xEE81, 0xFED9, 0xF498, 0xFA19, 0xFC9E, 0xFE92, 0x0198, 0x024F,
0x0135, 0xF6C7, 0x035B, 0xFE52, 0x0826, 0x0807, 0x0950, 0x0248,
0x0710, 0x0253, 0xFFC2, 0xFF3E, 0xF744, 0x0023, 0xF2C5, 0x01B4,
0xED8C, 0xF9B7, 0xF39F, 0xFC96, 0x0590, 0xFDA6, 0x0B10, 0xFD25,
0x0A69, 0x0807, 0x0A3A, 0x049F, 0x070E, 0xFE1D, 0x0276, 0x0072,
0xF87C, 0x012C, 0xF726, 0x088F, 0xF65F, 0x043F, 0xEDED, 0xF950,
0xF5C8, 0xF8C2, 0x04DC, 0xF328, 0x0CD9, 0xFA5D, 0x0F9B, 0x0BD7,
0x0ACD, 0x086C, 0x02D2, 0xFBA5, 0xFA5E, 0xFAEE, 0xF59F, 0x0700,
0xF6BB, 0x0CD3, 0xF938, 0x0471, 0xF919, 0xFC25, 0xFA98, 0xF75A,
0x07F6, 0xF398, 0x132C, 0xF946, 0x0B58, 0x01C1, 0xFDF1, 0xFF7B,
0xFBC0, 0x039A, 0xFAF2, 0x09A4, 0xF128, 0x04D2, 0xF13B, 0x05B6,
0xFDFD, 0x0359, 0x071C, 0x00F6, 0x0E1F, 0x022D, 0x0F2A, 0xF6EA,
0x081C, 0xF7AE, 0x056B, 0xFFBA, 0xFE2E, 0xFDB3, 0xEFAE, 0xFFB0,
0xEC0E, 0xFE47, 0xF499, 0x04FD, 0xFFC3, 0x0AF3, 0x01CA, 0xFFEF,
0x064B, 0x042C, 0x152C, 0x0559, 0x1299, 0xFCD5, 0x04F1, 0x045C,
0xFB39, 0x01A9, 0xF3EC, 0xFA07, 0xF70D, 0xF82F, 0xF36B, 0xF427,
0xF1C2, 0xFFDA, 0x0263, 0x0D0D, 0x09FE, 0x0FE6, 0x05BC, 0x095B,
0x0566, 0xF889, 0x0CF7, 0xFC69, 0x0C4A, 0x084B, 0xF97A, 0xFB63,
0xF1BC, 0xEEF3, 0xFA2C, 0xF3BE, 0xFD35, 0xFE4C, 0xFCA6, 0x08F3,
0xFE5E, 0x0C48, 0x01B4, 0x0D37, 0x0835, 0x11B1, 0x0B48, 0x04A9,
0x053C, 0xF2B7, 0x0516, 0xF588, 0x0860, 0xF5FD, 0xFC87, 0xF63F,
0xF21D, 0xFF0A, 0xF8EB, 0x0634, 0x02A3, 0x1040, 0x01FA, 0x0B32,
0xFAE6, 0x0437, 0xFD66, 0x0733, 0x0870, 0xFB2F, 0x0C7E, 0xFA0E,
0x0AAD, 0xFA44, 0x066B, 0xF075, 0x0269, 0x00E7, 0xFCBF, 0x09DE,
0xF2F1, 0x084E, 0xF890, 0x0FEC, 0x020E, 0x0893, 0xFB0E, 0x03B6,
0xFC33, 0xF8D3, 0x06BF, 0xEAE3, 0x0CB5, 0xFBD2, 0x0E4D, 0x076D,
0x088D, 0x04BC, 0x0201, 0x02D0, 0xF8EA, 0xFEDB, 0xF4EB, 0x0987,
0xF92B, 0x0DAD, 0xF850, 0x0539, 0xFFC0, 0x02B5, 0x0AAA, 0xF777,
0x0B58, 0xF37E, 0x0BBC, 0x01DC, 0x08DA, 0x0492, 0x0205, 0x0185,
0xFA70, 0x05A4, 0xF428, 0x0231, 0xF5A7, 0xFED7, 0xF83A, 0x0113,
0xFA27, 0xFFE5, 0x01C0, 0x045E, 0x0C28, 0x06B5, 0x0F6F, 0x03B9,
0x0B24, 0x0640, 0x07DD, 0xFCC0, 0xFF9B, 0xF631, 0xF299, 0xFDAF,
0xEE1F, 0x000A, 0xF71A, 0x0765, 0x0300, 0x01FF, 0xFFB4, 0xF9E1,
0xFD88, 0x07F0, 0x0B4E, 0x05F4, 0x1094, 0x05B7, 0x0BC1, 0x07C2,
0x03C4, 0xF094, 0xFA43, 0xF20F, 0xF21B, 0xFDFC, 0xE95C, 0xFBD7,
0xF565, 0x04CF, 0x09E9, 0x0C79, 0x0BE6, 0x11FC, 0x079C, 0x054F,
0x0477, 0xF2AD, 0x0AB0, 0x0146, 0x0E29, 0x0536, 0xFDC4, 0xF846,
0xF012, 0xF6BB, 0xEC6E, 0xF3FA, 0xF2E5, 0xFE8D, 0xFF00, 0x0B62,
0xFFE7, 0x0658, 0x0676, 0x074D, 0x143C, 0x0AB0, 0x101D, 0xFFD5,
0x00E0, 0xF79A, 0xFB56, 0xFB1E, 0xFEF8, 0xFCFF, 0xFB12, 0xFC19,
0xEFCA, 0xFD0D, 0xF1C8, 0x03DE, 0xFEFF, 0x08E8, 0x0575, 0x0305,
0x0439, 0x022C, 0x0522, 0xFE58, 0x0BE3, 0xFE20, 0x0AEF, 0x0BBB,
0xFE70, 0xF778, 0xF76F, 0xE684, 0xFA87, 0x01E5, 0xFA71, 0x0A22,
0xF742, 0x0599, 0xFCCF, 0x08B7, 0x0161, 0x049E, 0x02C8, 0x0262,
0x05E5, 0xF85F, 0x01C8, 0xF89B, 0x04E9, 0x0058, 0x0A7B, 0xF9C4,
0x007C, 0xFCAB, 0xF4C0, 0xF7D7, 0xF11C, 0xF915, 0xFCFE, 0x10E8,
0x02FF, 0x0C70, 0xF8FB, 0x04A2, 0xFD01, 0x0698, 0x0529, 0xF98E,
0x0ABF, 0xFA0E, 0x0E32, 0xFD4E, 0x05E2, 0xF790, 0x01F6, 0xFB0E,
0xFA2B, 0x0131, 0xEE54, 0x0456, 0xF2E5, 0x01C8, 0xFA3A, 0x03BF,
0xFCC5, 0x08A9, 0xFFCB, 0xFE69, 0x0601, 0xF926, 0x0DDC, 0x023D,
0x0D6C, 0xFE96, 0x0980, 0xF505, 0x0004, 0xFE52, 0xF02E, 0x03A0,
0xEEF0, 0x0074, 0xF834, 0x0945, 0xFC82, 0x0496, 0x0114, 0xF877,
0x0AA2, 0xF962, 0x0F2B, 0xFDF8, 0x09B7, 0x0A22, 0x033F, 0x06A5,
0xFB97, 0xFA32, 0xF7E9, 0xFD92, 0xF803, 0xFC71, 0xF104, 0xFDE1,
0xF3BE, 0xFBB7, 0x0269, 0xFBE2, 0x0D87, 0x09C7, 0x0F1C, 0xFC43,
0x066A, 0xF7FF, 0x0572, 0x0DCA, 0x02BE, 0x0916, 0xF964, 0x0281,
0xF5DA, 0xFE66, 0xEE23, 0xF63F, 0xF896, 0xFCD9, 0x08C4, 0xFBDD,
0xFFC0, 0xFA2B, 0x0135, 0x0032, 0x0CE7, 0x06CF, 0x0C11, 0x0CBB,
0x0387, 0xFCA7, 0xFB76, 0xF2B2, 0xFC48, 0x026E, 0xF5FB, 0x0417,
0xF0B6, 0xFDD0, 0xFD17, 0xFFDB, 0x0706, 0x01CA, 0x0B83, 0x0386,
0x05D8, 0xFC96, 0xF9F6, 0xF94A, 0x02A5, 0x09AA, 0x0B6D, 0x0B7D,
0xFD3A, 0xF0CE, 0xF15D, 0xEC18, 0xF5AB, 0x03EE, 0xFCA5, 0x0E0E,
0xFEB3, 0x0A37, 0x028D, 0x0682, 0x07EA, 0x0731, 0x0AE8, 0x018B,
0x094A, 0xF5AA, 0xFE7F, 0xFB2C, 0xFA5B, 0xFC8F, 0x016E, 0xFB2B,
0xFFA7, 0x012B, 0xF29A, 0xF62C, 0xF019, 0x01E5, 0x00C9, 0x1607,
0x05CF, 0x0B1F, 0x028A, 0x07E8, 0x0C35, 0xFEEA, 0x0B06, 0xF5CE,
0x0529, 0xF96E, 0xFF94, 0xEF9B, 0xF4C1, 0xF518, 0xF8B2, 0x0343,
0xFA77, 0x095C, 0xF779, 0x0C01, 0xFCE6, 0x01F2, 0x04E3, 0x0987,
0x0FCD, 0x0D72, 0x0A04, 0xFB66, 0x0195, 0x00F8, 0x07A4, 0x0236,
0x00B3, 0xED41, 0xF74C, 0xEC52, 0xF212, 0xFBD3, 0xEEA0, 0x06D5,
0xFBDD, 0x0C50, 0x0679, 0x0AD9, 0x05B8, 0x0250, 0x0632, 0xFEA2,
0x0981, 0x0499, 0x0B1F, 0x07FA, 0x07FF, 0x021F, 0x04A7, 0xF7B2,
0xFA48, 0xF484, 0xEDBC, 0xF781, 0xEF14, 0xFF8A, 0xF705, 0x082F,
0xFC97, 0x0244, 0x0178, 0x0555, 0x09D0, 0x088C, 0x0CC1, 0xF639,
0x09B9, 0xFB89, 0x0BA5, 0x056D, 0x04F7, 0xFCFF, 0xFA39, 0x0342,
0xF3E6, 0xFFD2, 0xEB27, 0xFAC2, 0xF23A, 0x024D, 0xFFCF, 0x0031,
0x03A5, 0xFE59, 0x0B7C, 0xF91C, 0x0EB7, 0x04F6, 0x0AE3, 0x0F54,
0x0480, 0xF4EF, 0xFC0D, 0xF7C5, 0xFAE5, 0x0A51, 0xF38F, 0x030D,
0xEDB6, 0x0270, 0xF735, 0xFC2A, 0x008B, 0xF8DD, 0x0E29, 0xFE8A,
0x1062, 0xFA7F, 0x03DE, 0x03FC, 0x0688, 0x125F, 0x060C, 0x0AC9,
0xFA7C, 0xF3D8, 0xF13E, 0xECF1, 0xEFF8, 0x015B, 0xFC4F, 0x09AC,
0x01B3, 0xFD90, 0x0283, 0xF9B2, 0x08D9, 0xFF15, 0x0BAF, 0x0221,
0x085D, 0x066A, 0xFC3D, 0x0499, 0xF803, 0xF932, 0xFB9C, 0x000F,
0xF8B9, 0x0084, 0xF700, 0xED92, 0xFF90, 0xFBC0, 0x0E21, 0x0FDC,
0x0A75, 0x0A97, 0x002B, 0x04A2, 0xFE60, 0x008B, 0xF922, 0x0507,
0xFBE5, 0xFBCD, 0xF92E, 0xE91F, 0xF362, 0xF197, 0xFE29, 0xFB39,
0x03B2, 0x0600, 0x0494, 0x0A77, 0x050C, 0x0233, 0x06D3, 0x11CD,
0x09DA, 0x0E35, 0xFD0A, 0xFB22, 0xF79E, 0x0225, 0xFE70, 0xF695,
0xFE56, 0xE714, 0x006F, 0xECD0, 0xFA3B, 0xF758, 0xF39C, 0x09D4,
0xFDC3, 0x1565, 0x02BA, 0x15CF, 0x0397, 0x03AC, 0x0A59, 0xF042,
0x0A6A, 0xFF6C, 0x0232, 0x0437, 0xFD7B, 0xF36C, 0x013C, 0xF5BB,
0xFD67, 0xFCF1, 0xF368, 0x0005, 0xF544, 0x0914, 0xF9E0, 0x0CA2,
0x009F, 0x0718, 0x0C5D, 0x048C, 0x1023, 0xFB84, 0x0CD5, 0xF094,
0x0885, 0xFB02, 0x019B, 0x01A9, 0xF467, 0xFFE2, 0xEF58, 0x0761,
0xF457, 0x0636, 0xF52E, 0x00AD, 0x0008, 0xFDDF, 0x0A41, 0xFF73,
0x0B88, 0xFD26, 0x1338, 0xF67A, 0x10DD, 0x0A99, 0x05AA, 0x0B53,
0xF94A, 0xF229, 0xEFE4, 0xFEF9, 0xEFF8, 0x07E8, 0xEE4E, 0x01D8,
0xF9ED, 0x039E, 0x09CC, 0xFB81, 0x0E70, 0xFC3D, 0x176D, 0xFA7D,
0x100D, 0xFA16, 0xFF0C, 0x0AAC, 0xFBBD, 0x0F10, 0xF9F0, 0x0BEC,
0xF57C, 0xF9F1, 0xEF49, 0xEAA7, 0xF6E8, 0x0098, 0x0682, 0x0AEB,
0x0B31, 0x025F, 0x103E, 0x001E, 0x0DA2, 0xF9F7, 0x041E, 0x012D,
0xFDDE, 0x0C2A, 0xF28E, 0x024D, 0xF11B, 0xFAC4, 0xFBBA, 0x02A3,
0x0039, 0x00C3, 0xFF14, 0xF1F8, 0x0404, 0xF9B3, 0x0F2A, 0x0EEA,
0x0CEA, 0x0D69, 0x055B, 0x020A, 0x0515, 0x0367, 0xFEA2, 0x0669,
0xFAA8, 0xF9CE, 0xF7D8, 0xF2F9, 0xF3B0, 0xF8F9, 0xFD09, 0xFEAC,
0x041E, 0x0C0A, 0x0314, 0x03E6, 0x0363, 0xF71C, 0x09C1, 0x09FC,
0x0FF6, 0x0A9C, 0x047C, 0x035F, 0xFCDC, 0x042E, 0xFE36, 0xF7CA,
0xFA38, 0xF7AC, 0xFA67, 0xF723, 0xF577, 0xFA6E, 0xF9F2, 0x0965,
0x08D7, 0x0D5F, 0x07E3, 0x0FE0, 0x0851, 0xFBFB, 0x09F1, 0xF136,
0x0970, 0x0C55, 0x05F5, 0x086D, 0xF9F7, 0xF8C6, 0xFA67, 0xFC89,
0xF937, 0xF918, 0xF51C, 0xFEAC, 0xFC07, 0x06D9, 0x006D, 0x07A3,
0x0B78, 0x08F2, 0x1002, 0x0434, 0x077A, 0xFEAB, 0x06A2, 0xF831,
0x056F, 0xF7D5, 0x008A, 0xFFCA, 0xF428, 0x009C, 0xEC69, 0x0402,
0xF538, 0x08FB, 0xFB41, 0x03ED, 0x0362, 0x01B7, 0x0AA9, 0x023E,
0x0A67, 0xF976, 0x0CD7, 0xF92F, 0x06D3, 0x0691, 0xFCA7, 0xFB6E,
0xF8C4, 0xEFCA, 0xF774, 0x0493, 0xF7B1, 0x0E70, 0xF6C7, 0x0F3F,
0xFDC9, 0x0CC8, 0x04A8, 0xFE2C, 0x08A7, 0xF9F6, 0x1327, 0xF3DD,
0x0B3E, 0xF542, 0xFBBE, 0xFB11, 0xF987, 0xFB8F, 0xF70E, 0x0B39,
0xF767, 0x014C, 0xF809, 0xF85F, 0xFC69, 0x1185, 0x0347, 0x1059,
0x061B, 0x05C3, 0x0E25, 0xFB86, 0x0A95, 0xECBF, 0x06B0, 0xF94D,
0x06B3, 0xFDA4, 0xF33D, 0xF63D, 0xED26, 0xFFC5, 0xF4D4, 0x0AD5,
0xF772, 0x0B21, 0x00CB, 0xFC94, 0x096A, 0xFC76, 0x1135, 0x0B52,
0x0DE2, 0x00F9, 0x0466, 0xF847, 0x040A, 0x013A, 0xFD90, 0xFD70,
0xFA63, 0xF812, 0xF444, 0xFAD6, 0xEB49, 0xFA03, 0xFAC5, 0x0346,
0x0A11, 0x0F8E, 0x0B0F, 0xFFED, 0x0A70, 0xF203, 0x0B40, 0x0205,
0x0992, 0x0CE5, 0xFBAF, 0x080A, 0xF396, 0xFC91, 0xF584, 0xF4F3,
0xF95E, 0xF7C1, 0x005D, 0xF47A, 0xFB6A, 0xFA27, 0xFBC8, 0x05F7,
0x0A7D, 0x0CB1, 0x0E19, 0x114D, 0x0830, 0xF99D, 0x01C7, 0xF614,
0xFFAB, 0x0DCC, 0xF8DF, 0xFD9C, 0xF0E9, 0xF406, 0xFAA7, 0xFAE6,
0x00B8, 0xF5C8, 0x010D, 0xFF38, 0x044A, 0x059C, 0x006D, 0x0803,
0x05E7, 0x09A3, 0x097C, 0x044A, 0x0108, 0x033C, 0xFDE5, 0xF3D9,
0xFD10, 0xEF51, 0xFE94, 0xFF23, 0xF8E4, 0xFF11, 0xF7D6, 0x02D1,
0x0534, 0x0A0B, 0x0373, 0x05A8, 0x01FF, 0x02A1, 0x03DB, 0xFBE2,
0xFD08, 0xF6BA, 0x03A6, 0xFE8A, 0x060A, 0x0220, 0xFE92, 0xF51A,
0xFC71, 0xF1A6, 0xFCA5, 0x036C, 0xFE37, 0x0F7C, 0xFBBA, 0x124F,
0x025F, 0x0D50, 0x072F, 0xFD91, 0x01FA, 0xF167, 0x08A9, 0xEFFE,
0x0638, 0xF8D9, 0xFBA3, 0xF9EB, 0xFA48, 0xFD99, 0xF898, 0x0CD3,
0xFB71, 0x00F3, 0xFD38, 0xFB23, 0xFF10, 0x0FC4, 0x0366, 0x0DE7,
0x08E7, 0x01FC, 0x113E, 0xF46A, 0x0892, 0xEDC3, 0xFF1F, 0xFBB9,
0xFD47, 0xFC2D, 0xF17B, 0xFB75, 0xF1FE, 0x041A, 0xFBCD, 0x0A7A,
0x000C, 0x0AA4, 0x03E0, 0xF7C5, 0x0775, 0xFB28, 0x1287, 0x0BBB,
0x126A, 0x007D, 0x0534, 0xFEB2, 0xFD35, 0xFE50, 0xF2D7, 0xF738,
0xF518, 0xFE5A, 0xF8DE, 0xFC13, 0xF238, 0xF80B, 0xFDE8, 0x042D,
0x0CF1, 0x1054, 0x1170, 0x04C5, 0x0FF8, 0xF16E, 0x0A86, 0xFF2D,
0x0919, 0x1061, 0xFC4B, 0x064D, 0xEE25, 0xF949, 0xEC63, 0xF5D6,
0xF297, 0xF8FC, 0x031A, 0xFADC, 0x05F4, 0xFB63, 0x0456, 0x00D6,
0x0E79, 0x0CEC, 0x0EF4, 0x0CDF, 0x0860, 0xF693, 0x0044, 0xF96C,
0xFB8F, 0x0B40, 0xF411, 0x01EA, 0xEA23, 0xFBE1, 0xF6D1, 0xFA9F,
0x0524, 0xF95B, 0x09FC, 0x0093, 0x0ACE, 0xFF6F, 0x00FE, 0xFFAA,
0x045F, 0x0213, 0x08A2, 0x0745, 0xFDE4, 0x0782, 0xF6D0, 0xF102,
0xF705, 0xF687, 0xFF87, 0x0D9B, 0xFF00, 0x0512, 0xFB19, 0x020C,
0x0366, 0x0318, 0x0496, 0xFD5F, 0x095B, 0xFCEE, 0x089E, 0xF554,
0xF874, 0xF877, 0xF936, 0x03FB, 0xFD5A, 0x0443, 0xFC04, 0xFDED,
0x003D, 0xFA1D, 0x0286, 0x094B, 0x0220, 0x1003, 0xFCEA, 0x03A9,
0xFFE1, 0x01DB, 0x066B, 0xFA7A, 0x025E, 0xEF69, 0x0218, 0xF420,
0xFB73, 0xFA15, 0xF5A1, 0xFC1A, 0xFD2D, 0x0642, 0xFDDE, 0x0E75,
0x016C, 0x01BB, 0x06FF, 0xFD63, 0x0370, 0x0AFC, 0xFCBC, 0x06BF,
0xFA7B, 0xFAA2, 0x04A9, 0xF55A, 0x050A, 0xF40E, 0xFCDD, 0xF5E2,
0xFAC8, 0xF804, 0xF22A, 0xFFD3, 0xF58A, 0x0413, 0x00C4, 0x0E4A,
0x043A, 0x1364, 0x07DC, 0xFBFE, 0x0180, 0xF705, 0x01AA, 0x003F,
0x073D, 0xFAD2, 0x0171, 0xFDCD, 0xFADE, 0xF776, 0xF1C6, 0xF14C,
0xF6EE, 0x0012, 0xFF1B, 0x0652, 0xF5FA, 0x0420, 0xFBBD, 0x0544,
0x082C, 0x0CB4, 0x0C05, 0x05FD, 0x0C2C, 0xEE32, 0x045F, 0xF627,
0xFD88, 0x070A, 0xF4CA, 0xFF19, 0xF4A0, 0xFE55, 0xF85F, 0xFE6A,
0xF57E, 0xFBF5, 0xFFE4, 0x01AC, 0x0215, 0xFEDE, 0xFD55, 0xFDE8,
0x093B, 0x06E6, 0x0E23, 0x0780, 0x07E6, 0xF902, 0xFD5E, 0xF1B3,
0xF753, 0x016A, 0xF7D7, 0x0B03, 0xF3CF, 0x02D4, 0xF804, 0xFBCA,
0xFE0B, 0xFC2E, 0x062A, 0x014A, 0x0DBC, 0xFEC4, 0xFF17, 0xF7C5,
0xFE22, 0xFBF8, 0x0C5B, 0x0AC4, 0x01A2, 0x0999, 0xF30E, 0xF077,
0xF297, 0xF2BF, 0xFA5B, 0x08DD, 0xFF18, 0x06CE, 0xFE91, 0x0293,
0x04E4, 0x011B, 0x05FC, 0xFDF9, 0x07C7, 0xFBDB, 0x07B2, 0xF9C3,
0xF84D, 0x01CD, 0xF669, 0x02D9, 0xF920, 0xFF07, 0xF597, 0xFA9E,
0xFD9A, 0xF291, 0x0381, 0x043D, 0x04ED, 0x124F, 0x027B, 0x05EC,
0x0194, 0x03AB, 0x05BB, 0x01CD, 0x00AA, 0xFA31, 0xFE50, 0xF8DA,
0xF78E, 0xF620, 0xF141, 0xF9C9, 0xFDC2, 0x03A2, 0x01B0, 0x080F,
0x0289, 0x0273, 0x0A98, 0x009C, 0x0B75, 0x0E7B, 0x05B2, 0x0C02,
0xFC37, 0xFBE4, 0xFDCB, 0xFB50, 0xFC43, 0xF737, 0xF553, 0xF35D,
0xFE5B, 0xFC59, 0xFEF2, 0x00D0, 0xFE4C, 0x03F4, 0x066D, 0x0D23,
0x0705, 0x0FF8, 0x09BF, 0x0348, 0x05AF, 0xFA24, 0xFE75, 0xFF7B,
0xFD36, 0x01A4, 0xFA14, 0x007B, 0xFAEB, 0xFC3A, 0xF8E7, 0xF7C6,
0x01E9, 0xFE32, 0x0E7D, 0x0517, 0xFFCF, 0x0692, 0xF99A, 0x05E2,
0x0287, 0x075E, 0x0581, 0x0194, 0x0990, 0xF4E8, 0x056A, 0xFE6C,
0xFD95, 0x098F, 0xFA7D, 0x0391, 0xFD7B, 0x02BF, 0x0260, 0xFF42,
0x006C, 0xFDE0, 0x073C, 0x029F, 0x0634, 0xFE0E, 0xF7FE, 0xFB2B,
0x00EE, 0xFFFA, 0x0BB3, 0x0910, 0x07EB, 0x0427, 0x0268, 0xF4BA,
0xFB90, 0x03A3, 0xFCC1, 0x118B, 0xFE8A, 0x02B1, 0xFEB5, 0xFCA9,
0x0171, 0xFD8C, 0x077C, 0x0031, 0x10D2, 0x02E5, 0x03DE, 0xFA2F,
0xF776, 0xFD6C, 0x034F, 0x0A1F, 0x0253, 0x0701, 0xFAF3, 0xFAA2,
0xFA84, 0xFA3F, 0xFD49, 0x08BE, 0x035E, 0x09D8, 0x038D, 0x00B5,
0x07A8, 0x036E, 0x0981, 0x01F3, 0x0A55, 0xFB8C, 0x0851, 0xFC7A,
0xF225, 0xFBF0, 0xED66, 0xFD28, 0xFA86, 0x06AC, 0xFF04, 0x04A0,
0x0816, 0xFA40, 0x0BA7, 0x05DB, 0x0AC5, 0x108E, 0x07CA, 0x0403,
0x0423, 0xFC79, 0x0645, 0xFCEF, 0xFC0C, 0xFD65, 0xF3D6, 0xFB84,
0xF117, 0xF5F5, 0xEF69, 0xFD70, 0x0286, 0x08EC, 0x0F9F, 0x0B9B,
0x0EAE, 0x06FC, 0x1094, 0xFE1D, 0x0AB7, 0x0371, 0x015C, 0x040D,
0xF894, 0xF94A, 0xF732, 0xFF24, 0xF8AF, 0xFDBC, 0xF520, 0xF79E,
0xFF4B, 0x00CD, 0x05CB, 0x021A, 0x038E, 0x02E9, 0x0ADE, 0x08C8,
0x091B, 0x08CF, 0x05B5, 0x012B, 0x0573, 0xF515, 0xFBDF, 0xFBA6,
0xF6AF, 0x060B, 0xF98A, 0x01BA, 0x0160, 0x0286, 0xFF0C, 0x0074,
0xFDAC, 0xFCE5, 0x0D28, 0x029E, 0x06EB, 0x0297, 0xFAEF, 0x0038,
0x0199, 0x0137, 0x0510, 0xFE39, 0x08B2, 0xFA15, 0x00C5, 0xFDD8,
0xF6C2, 0x06A4, 0xFCF5, 0x07E7, 0x024D, 0x0493, 0x03A6, 0x01CB,
0xFCD3, 0xFF35, 0x011D, 0x0041, 0x0A71, 0xFE29, 0xFD96, 0xF7F7,
0xFEC1, 0xF99B, 0x0688, 0x0502, 0x0080, 0x062C, 0x00D1, 0xF7EE,
0xFCE1, 0xFEEB, 0xFC1F, 0x1072, 0x02D2, 0x08E9, 0x02D3, 0x0124,
0xFF17, 0xFEE3, 0xFD8B, 0xFB77, 0x0AC3, 0xFBF6, 0x0A92, 0xF572,
0xF5FD, 0xF7D2, 0xF596, 0x01FD, 0xFD2D, 0x0464, 0x02EF, 0x050F,
0x0655, 0x0058, 0x027D, 0x06A2, 0x070A, 0x0E51, 0x05A1, 0x0209,
0xFF51, 0xFCED, 0xFE0B, 0xF7B5, 0xFBF9, 0xF16B, 0x0155, 0xF9DA,
0xFB18, 0xFA98, 0xF572, 0xFE3D, 0x018E, 0x0871, 0x05D1, 0x0584,
0x0CE1, 0x0382, 0x0DE1, 0x0809, 0x00FD, 0x0AEB, 0xFB87, 0x01BF,
0xF7CA, 0xF2F1, 0xFA29, 0xF480, 0xF960, 0xFAA2, 0xF961, 0xF94E,
0x054D, 0xF889, 0x00AE, 0xFD5A, 0xFEB2, 0x0676, 0x06C2, 0x0A3A,
0x0445, 0x091D, 0x06BC, 0x04C1, 0x043C, 0xFEA4, 0xFCC5, 0xFBD3,
0xF9CA, 0xF918, 0xF703, 0xFA73, 0xFBE7, 0xF96A, 0xFDC2, 0xF6F9,
0x03CB, 0xFFE8, 0x09C2, 0x0301, 0x000D, 0x0270, 0xFF4A, 0x05B8,
0x000E, 0x0334, 0x0408, 0x0279, 0x0E00, 0xFBBB, 0xFCA3, 0xF843,
0xEDA1, 0xFEC4, 0xF7F9, 0xFB54, 0x002C, 0xFEDB, 0xFE5E, 0x0206,
0xFEF2, 0xFB79, 0x0E35, 0x012C, 0x0D9E, 0x0318, 0xFBCE, 0xFFB8,
0xFBDD, 0xFE77, 0xFF61, 0xFCB7, 0x03F9, 0x01C7, 0x0051, 0xFED9,
0xF04D, 0xFCA9, 0xF5C8, 0x0164, 0x02E1, 0xFE39, 0x0773, 0xFEE1,
0x0647, 0xFF41, 0x055A, 0xFFDF, 0x0B81, 0x02CB, 0x010A, 0xF8F0,
0xF311, 0xF853, 0xF2BD, 0x058D, 0xF8FE, 0x074C, 0x0905, 0x000E,
0x0593, 0xFB12, 0xFBC9, 0xFF07, 0x0898, 0x020C, 0x0BFC, 0x0021,
0x0176, 0x0097, 0xF901, 0xFD27, 0xFD7A, 0xFBF7, 0x00E1, 0xFCF3,
0xEF12, 0xFBB4, 0xF070, 0xFF93, 0x050C, 0x0224, 0x0CA5, 0x03E6,
0x0F41, 0x027F, 0x05FA, 0xFEF5, 0xFD15, 0x03DA, 0xFFD2, 0x02AB,
0xFE15, 0xFE71, 0xFB34, 0xFBFD, 0xF780, 0xF7CD, 0xFB26, 0xFAC6,
0x00C5, 0xF9CA, 0xFB66, 0xFE9F, 0xFFA4, 0x080B, 0x0639, 0x034F,
0x07EE, 0x047C, 0x081F, 0x04ED, 0xFAE6, 0x008E, 0xF919, 0xFE77,
0x0296, 0xF3CE, 0xFC8B, 0xF774, 0xF301, 0x001C, 0xF7EF, 0xFCBE,
0x06A8, 0x01CB, 0x0426, 0x058B, 0xFDBD, 0x058E, 0x05FF, 0x057F,
0x0331, 0x0257, 0x02F0, 0x0094, 0x0684, 0xF639, 0xF951, 0xF260,
0xF248, 0xFC46, 0xF599, 0x008F, 0xFA97, 0x05B0, 0xFBFC, 0x068E,
0x00F9, 0x02AD, 0x10E5, 0x05F8, 0x0C7F, 0x045B, 0xFE48, 0xFD49,
0xFC19, 0xF69C, 0xFDD6, 0xF63F, 0x0372, 0xFCDC, 0xF56A, 0xFE82,
0xE834, 0x00B2, 0xF9A8, 0x03DC, 0x04C5, 0x060D, 0x03F9, 0x05BD,
0x04F1, 0xFC5D, 0x0A55, 0xFC33, 0x0D88, 0xFFF1, 0xFF1B, 0xF9B2,
0xF3B4, 0xF746, 0xF14E, 0xFB0E, 0xF3E9, 0x069D, 0xFFD6, 0x08F8,
0xFF4A, 0xFEC3, 0xFC69, 0xFF85, 0x0743, 0xFE90, 0x0C0B, 0xFD0E,
0x02E8, 0x006C, 0xF83A, 0xFE80, 0x000C, 0xFFB0, 0x0621, 0xFD66,
0xF232, 0xFCB3, 0xE750, 0x0066, 0xF71A, 0xFE4D, 0x0A4C, 0x03B6,
0x0BCB, 0x0235, 0x0177, 0xF99F, 0x03B8, 0xFFFF, 0x06E2, 0x02F2,
0xFE44, 0x01C6, 0xF8F9, 0x00A6, 0xFB4D, 0xFB03, 0x0115, 0xFC72,
0xF8A1, 0xFBE3, 0xED96, 0xF9A8, 0xF7E9, 0xFB8B, 0x035F, 0xFF99,
0x0DA9, 0x08CC, 0x0E28, 0x0751, 0xFE0F, 0x0325, 0xFDF9, 0x0301,
0x0236, 0xF94E, 0xF9EB, 0xF982, 0xF20A, 0xFF46, 0xF431, 0xFA70,
0x00DD, 0xFA6C, 0xFD5B, 0xFF8B, 0xF6EF, 0x0333, 0x03F2, 0x0443,
0x0DEE, 0x089F, 0x0F46, 0x0BAC, 0x04DA, 0xFF50, 0xFA3F, 0xF3AF,
0xFA18, 0xF197, 0xF25C, 0xF72C, 0xF065, 0x0273, 0xFC3E, 0x0319,
0x04D7, 0x00F2, 0x0922, 0x054E, 0x07B5, 0x07E0, 0x0292, 0x05B0,
0x023C, 0xFF88, 0x08AB, 0xFF70, 0x0891, 0xFBEC, 0xF69E, 0xF179,
0xEAD7, 0xF52D, 0xF317, 0xFE44, 0xFDE2, 0x065A, 0x037D, 0x0AE2,
0x0509, 0x0488, 0x0B33, 0x0408, 0x0F0D, 0x058A, 0x00D8, 0x00A0,
0xF7EE, 0xF847, 0xFD37, 0xF2D1, 0x00FB, 0x00FF, 0xFCC9, 0x05D2,
0xF2F1, 0xF9C6, 0xF8B2, 0x0120, 0x04C5, 0x093D, 0x088C, 0x077A,
0x0888, 0x0603, 0x0012, 0xFF1A, 0x03B4, 0xFC86, 0x0847, 0xFB3B,
0xF74B, 0xF70F, 0xF056, 0xF85D, 0xFADB, 0x017C, 0x08DB, 0x0DA2,
0x093C, 0x0819, 0xFC7F, 0xFD7B, 0x02B1, 0x02C3, 0x0C82, 0x02F4,
0x03A2, 0x0041, 0xFA42, 0x00A8, 0xFBCC, 0xF8E5, 0x0128, 0xF763,
0xF928, 0xFFC8, 0xEEFE, 0x02B1, 0xFA92, 0x0270, 0x0C56, 0x08F2,
0x1107, 0x0AA7, 0x0944, 0xFE79, 0x0172, 0xFC6A, 0x047C, 0x02FF,
0x0314, 0xFFDD, 0xF7D2, 0xFF4B, 0xF2E6, 0x00E6, 0xF7A6, 0x012A,
0x0103, 0x02E2, 0x0258, 0x017A, 0xFF66, 0xFFA6, 0x09D4, 0xFD1C,
0x1556, 0x014B, 0x0F4E, 0x075A, 0xFE61, 0x0133, 0xFA9A, 0xFF2D,
0xFD6E, 0xFFC5, 0xF26B, 0x0019, 0xF049, 0x0691, 0xFCD4, 0x0115,
0x0967, 0xFB92, 0x118D, 0xFFE9, 0x0A0E, 0x0085, 0x0569, 0x006E,
0x0BC7, 0x00E9, 0x08FC, 0x09B5, 0x0099, 0x0C5C, 0xF735, 0xFBEE,
0xF1D4, 0xF932, 0xF3F9, 0xFDF6, 0xFB43, 0xFCC5, 0x0674, 0x020C,
0x0A2E, 0x00D0, 0x0EDD, 0x0100, 0x1242, 0x081C, 0x0299, 0x06D1,
0xFC46, 0x02F1, 0x0535, 0x010A, 0x0121, 0x03D2, 0xF8A5, 0xFFC8,
0xF5D8, 0xF2B9, 0xFA98, 0xF76E, 0x041D, 0x0256, 0x06FF, 0x05BD,
0x0823, 0x07BF, 0x0892, 0x03DF, 0x09BD, 0x05AE, 0x0882, 0x0614,
0xFBC3, 0xF7AC, 0xF603, 0xF220, 0xFACB, 0xFF2B, 0xFFD0, 0x0877,
0x02F6, 0x0211, 0xFE42, 0xFF6E, 0x00A6, 0x060E, 0x0980, 0x0620,
0x075E, 0x05C3, 0x00CB, 0x0128, 0x018E, 0xF79C, 0x08F1, 0xF864,
0xFE00, 0xF884, 0xEAD8, 0xF95B, 0xF64C, 0x03A0, 0x09AF, 0x0EF0,
0x0BC1, 0x1276, 0x05C0, 0x0567, 0x024B, 0xFC47, 0x04C1, 0xFCE0,
0x0139, 0xF8DA, 0xFEDC, 0xFA93, 0xFF7D, 0xF6BF, 0xFBA7, 0xF83C,
0xFD70, 0x0814, 0xF9DA, 0x05AC, 0xF8CB, 0x04A1, 0x09FE, 0x0D75,
0x1228, 0x0BC8, 0x0AE9, 0x0454, 0x0017, 0xF5EE, 0xFA04, 0xF24C,
0xFE97, 0xF690, 0xFC13, 0xF6DA, 0xF353, 0x0300, 0xF531, 0x072C,
0x02D3, 0x05C2, 0x0BED, 0x0C1B, 0x0181, 0x05DF, 0x0252, 0x006D,
0x119E, 0x014F, 0x0963, 0xFF1F, 0xFDBC, 0xFB8B, 0xFBB6, 0xF1A9,
0xF448, 0xF203, 0xF1C0, 0xFE1B, 0xF5B2, 0x07B0, 0xFEDC, 0x0BDE,
0x06CB, 0x0424, 0x0C08, 0x0367, 0x0DD6, 0x0758, 0x0293, 0xFCCF,
0x01C4, 0xFAC9, 0x060D, 0x0145, 0xFD4A, 0xFE1F, 0xF7AB, 0xF69C,
0xEF65, 0xF66E, 0xF006, 0xFD5C, 0xFEEF, 0xFFB1, 0x04EC, 0x05D1,
0x074D, 0x066B, 0x0A63, 0xFD0C, 0x0B9C, 0x045A, 0x02E3, 0x0758,
0xF755, 0xFB8C, 0xFBEE, 0xF951, 0xFA8B, 0xFF6D, 0xF345, 0x03D9,
0xF8F1, 0xFBC9, 0xFC1E, 0xF640, 0x00F2, 0xFD78, 0x0C89, 0x02E4,
0x0C4B, 0x075D, 0x0183, 0x0161, 0xFDEE, 0xFE6C, 0x034A, 0x0834,
0xFC70, 0xFD37, 0xECFD, 0xF3B1, 0xF140, 0xFFC1, 0xFFE1, 0x02AB,
0x0728, 0xFE8B, 0x0822, 0xFB2E, 0x049A, 0xFC16, 0x05EC, 0x0200,
0x0549, 0x03BE, 0xFCDF, 0x06A6, 0xF946, 0xFF24, 0xFBBC, 0xF793,
0xFCD6, 0x0024, 0xF51D, 0xFBC0, 0xF6D5, 0xF70F, 0x0777, 0x0192,
0x0BAE, 0x0656, 0x0A50, 0x0440, 0x04FB, 0xFC52, 0xF9BE, 0xFC5C,
0xFBD2, 0x0253, 0xFCF2, 0xFB85, 0xF4B6, 0xF679, 0xF366, 0xF890,
0xFF6F, 0xFF82, 0x06C5, 0x0510, 0xFD5A, 0x00F7, 0x02CF, 0x0466,
0x116C, 0x0B1B, 0x0A00, 0x0575, 0xFF9E, 0xFD89, 0xFBAF, 0xF812,
0xF742, 0xF1AC, 0xF5F2, 0xF16A, 0xF33B, 0xFBF8, 0xF518, 0x0310,
0x02CC, 0x02F7, 0x0ADA, 0x0A5F, 0x066A, 0x0E36, 0x04C7, 0x042D,
0x0717, 0xFEC7, 0x060F, 0xFFC7, 0x025B, 0xFA1C, 0xFBA2, 0xEFFB,
0xF202, 0xEE2D, 0xF026, 0xF917, 0xF9C9, 0x031D, 0xFE55, 0x0779,
0x017B, 0x0A4E, 0x0DE9, 0x0A86, 0x0FD1, 0x0992, 0x0463, 0x0035,
0xFEE2, 0xF83E, 0x0088, 0xFA4D, 0xFD86, 0xF5AC, 0xF477, 0xF7A2,
0xF342, 0x012E, 0xF97B, 0xFE14, 0xFD82, 0x0008, 0x0427, 0x0994,
0x0CA4, 0x07B1, 0x0DF1, 0xFEFE, 0x0734, 0xFE17, 0xFFD0, 0x0385,
0xFA7E, 0xFBF6, 0xF37F, 0xF3FF, 0xF13E, 0xFF31, 0xF9AF, 0x05B5,
0x01F2, 0x02B5, 0x0279, 0x00EF, 0x025A, 0xFC43, 0x07FE, 0xFF35,
0x0B6E, 0x0242, 0x0263, 0xFCC4, 0xFBF6, 0xFF8D, 0xFD9E, 0x0002,
0xF407, 0xFC76, 0xEDB3, 0x00EF, 0xFA37, 0x0301, 0x06CD, 0x0480,
0x0A56, 0x0323, 0x07D5, 0xFF3F, 0x058A, 0xFD55, 0x01A8, 0xF6EB,
0xFC7F, 0xFC1C, 0xFAFA, 0x0292, 0xF3D3, 0xF968, 0xF314, 0xFD3B,
0xF9ED, 0x07CA, 0xFB69, 0x0582, 0x037C, 0x02C3, 0x0967, 0x042A,
0x0D9B, 0x0543, 0x1076, 0xFDEA, 0xFFE7, 0xF734, 0xF41C, 0xFAE1,
0xF611, 0xF9E6, 0xF4D5, 0xF7A2, 0xEFA4, 0xFD5F, 0xF10B, 0x02C5,
0x0252, 0x0575, 0x0646, 0x0556, 0x00A0, 0x0446, 0x0CE3, 0x0444,
0x0EF7, 0x0141, 0x0505, 0xFCF1, 0xFFF2, 0xFD13, 0xF966, 0xFB62,
0xF647, 0xF282, 0xF238, 0xF58D, 0xF21B, 0x023E, 0xFBE8, 0x017F,
0x020A, 0x00D9, 0x0864, 0x074E, 0x09D0, 0x063A, 0x0413, 0x01E4,
0x0468, 0x0347, 0x045D, 0x04B6, 0x02C5, 0xFA58, 0xF935, 0xF481,
0xEC08, 0xFC1C, 0xF408, 0xF95B, 0xFE85, 0xF9AB, 0xFEA5, 0x0457,
0x0381, 0x05A3, 0x0BEA, 0x07CD, 0x0E07, 0x079E, 0x0199, 0x02F3,
0xFB8F, 0x027A, 0xFE61, 0xFA2F, 0xF592, 0xF446, 0xF1B7, 0xF887,
0xF780, 0xFB8A, 0xFC6D, 0xFB6A, 0xFF58, 0xFCBD, 0x046B, 0x085C,
0x0D58, 0x0BA5, 0x08FE, 0x01DD, 0x026F, 0x043C, 0x0252, 0x01A0,
0xF7F5, 0xF329, 0xF06B, 0xF348, 0xF204, 0xFDE8, 0xFA6B, 0x012B,
0x02CB, 0x014F, 0x00DB, 0x0844, 0x0668, 0x0792, 0x0BAB, 0xFF10,
0x008F, 0xFF73, 0xF893, 0xFD95, 0xFBBC, 0xF651, 0xFEBE, 0xF317,
0xF59A, 0xF85A, 0xEE1B, 0x0351, 0xFAA5, 0x07EF, 0x0684, 0x0B91,
0x0C28, 0x0B9D, 0x0FA0, 0x0461, 0x03BF, 0xFEF7, 0xF8DE, 0xF56A,
0xF94A, 0xF244, 0xF66B, 0xF2FA, 0xF138, 0xEE7C, 0xF1BD, 0xFCD6,
0xFBF8, 0x0CE8, 0x0459, 0x0AA6, 0x021F, 0x09E4, 0x04AB, 0x0BB2,
0x0E7C, 0x0854, 0x0E25, 0xFB48, 0xFE0D, 0xF3D9, 0xF3DD, 0xF719,
0xF6D0, 0xEEAD, 0xF317, 0xF022, 0xEE4B, 0x004E, 0xF72F, 0x0550,
0x0576, 0x0A10, 0x08A3, 0x0C00, 0x0447, 0x08C3, 0x0765, 0x05AB,
0x06FA, 0xFDB1, 0x01AF, 0xFBEA, 0xFFC3, 0xFB1B, 0xF5FA, 0xF7C1,
0xF004, 0xF7DC, 0xF693, 0xF8CA, 0xFBA1, 0xFF0C, 0xFBFA, 0x010B,
0xFEB0, 0x014B, 0x0B33, 0x062A, 0x0E07, 0x02C7, 0xFCDC, 0x0156,
0xF58C, 0x078E, 0xFFA5, 0x0682, 0x050A, 0xFBBA, 0xFBEE, 0xF7E3,
0xF472, 0xFE95, 0xFCE8, 0xFAE2, 0x03EF, 0xF7EB, 0x0080, 0x0068,
0x03FB, 0x0300, 0x0BA6, 0x0531, 0x05B9, 0x0777, 0xFAD8, 0x061D,
0xF7C5, 0x037B, 0xF69A, 0xFBA2, 0xF79E, 0xF948, 0xFCBF, 0xFACF,
0xFE6B, 0xFAA5, 0xFC0E, 0xFCA4, 0x01A4, 0xFCAE, 0x0E0A, 0x0319,
0x0D5B, 0x086F, 0x0297, 0x068E, 0x0225, 0x0A50, 0x02E0, 0x0375,
0xF7A9, 0xFB54, 0xF165, 0x00CD, 0xF93C, 0xFF89, 0x0384, 0xFE27,
0x063D, 0xFFD2, 0x026F, 0x0189, 0x04EF, 0x02A9, 0x08F3, 0xFDBE,
0x031B, 0x0225, 0xFD06, 0x0402, 0xF954, 0xFB44, 0xF8EB, 0xFCFD,
0xFB43, 0x0234, 0xFDFB, 0x0564, 0x0253, 0x079B, 0x044D, 0x06B6,
0x0E33, 0x07AC, 0x12FD, 0x04D5, 0x0110, 0x002A, 0xF801, 0xFD7F,
0xFF85, 0xF764, 0xFB33, 0xF2C6, 0xEDBA, 0xF264, 0xF074, 0xFA2C,
0x0101, 0x06BA, 0x07E1, 0x0BC2, 0x071D, 0x1061, 0x0C78, 0x135F,
0x14ED, 0x0AD5, 0x119C, 0xFF7D, 0xFEDC, 0xFD7B, 0xF43C, 0xF893,
0xF7F9, 0xECA2, 0xF755, 0xF3D4, 0xF53B, 0x0078, 0xFB96, 0x02E1,
0x0585, 0x0B3B, 0x0D75, 0x0EC9, 0x0F98, 0x0B3F, 0x07F2, 0x0826,
0xFD08, 0x0301, 0xFDDC, 0xFCB9, 0xFF08, 0xF2F0, 0xF32D, 0xF32E,
0xF184, 0xFB2E, 0xFE5D, 0xFFC5, 0x0758, 0x0668, 0x07E4, 0x0589,
0x076D, 0x06EA, 0x0E51, 0x0BBA, 0x0B25, 0x034A, 0xFD5A, 0x01BB,
0xFC9B, 0x0712, 0xFE9E, 0xFF80, 0xFA8A, 0xF7CB, 0xF70C, 0xFC9A,
0xF81E, 0x01FF, 0xFFC5, 0xFDB0, 0x0520, 0xFB68, 0x0936, 0xFF87,
0x0B6E, 0xFE8E, 0x0637, 0xFF8A, 0x02CD, 0x06F2, 0x0296, 0x0819,
0xFE27, 0x0692, 0xF5DD, 0x0759, 0xF57A, 0x03D3, 0x00A8, 0xFBE1,
0x0229, 0xF717, 0xFAAE, 0xFB4A, 0x03E9, 0xFD32, 0x110B, 0xF919,
0x0B25, 0xFC81, 0x01EF, 0x0650, 0x005D, 0x0B31, 0xFDAD, 0x04AD,
0xFAB2, 0x01C3, 0xF892, 0x0768, 0xF6F8, 0x022E, 0xFB71, 0xF81A,
0x0483, 0xF6E6, 0x09BB, 0xFF68, 0x07DE, 0x0245, 0x03D2, 0xFAC9,
0x023A, 0xFF4E, 0x0020, 0x0265, 0xF770, 0xFCB0, 0xF204, 0xFF3A,
0xFAB8, 0x01E7, 0xFF5E, 0x03F9, 0xFA9C, 0x0487, 0x00DA, 0x03EB,
0x114A, 0x013F, 0x11C9, 0xFC62, 0xFE34, 0x041D, 0xF74A, 0xFF3C,
0xFB55, 0xECD9, 0xF729, 0xF149, 0xF3AB, 0xFE68, 0xF79D, 0x04D2,
0x085F, 0x06A0, 0x10BE, 0x09EF, 0x0821, 0x1096, 0x0775, 0x0B48,
0x05CB, 0xFD94, 0xFF95, 0xF71F, 0xFACA, 0xFB2A, 0xF266, 0xF655,
0xF089, 0xE8F8, 0xF7E4, 0xF26C, 0x0203, 0x0375, 0x0437, 0x0595,
0x055F, 0x0919, 0x118C, 0x1013, 0x112F, 0x0C3D, 0xFE2F, 0xFF82,
0xF2B1, 0xF971, 0xF71F, 0xF7B9, 0xFBCA, 0xF682, 0xFAD6, 0xFB79,
0xFBA3, 0xFBED, 0x004F, 0xFB40, 0x0739, 0x0437, 0x0914, 0x0A8E,
0x0CAD, 0x0929, 0x1392, 0x06E8, 0x09B0, 0x056B, 0xF725, 0x01B9,
0xEFBD, 0xF84E, 0xF242, 0xF2BB, 0xF8D2, 0xFA8C, 0xFFAB, 0x01D5,
0x00F2, 0xFF4E, 0xFE20, 0xFA04, 0x0576, 0xFF13, 0x0FF7, 0x09A2,
0x0E3B, 0x02DC, 0x0746, 0x0035, 0x0354, 0x0A11, 0xFD2E, 0x01B5,
0xF0BA, 0xF639, 0xEDD3, 0xF7C1, 0xF77D, 0x00E6, 0x0205, 0x03A1,
0x06A2, 0xFB8F, 0x02AF, 0xFFAE, 0x09AA, 0x01C7, 0x1151, 0xFEED,
0x07C8, 0x0368, 0x03BF, 0x02F2, 0xFF79, 0x0408, 0xF54C, 0xFFF6,
0xF15F, 0xF88F, 0xF17D, 0xF99F, 0xF6F8, 0xFDDF, 0x0137, 0x0340,
0x114D, 0x0073, 0x16E3, 0xFEBE, 0x0B64, 0x0091, 0x053A, 0x0103,
0x02A8, 0x03CB, 0xFDEF, 0xFF7A, 0xF76D, 0x005B, 0xF18A, 0x031A,
0xF65E, 0xFA5F, 0xFB07, 0xF3A7, 0xFA53, 0xF9BB, 0x0720, 0x0756,
0x17C2, 0x02C3, 0x1184, 0xFD02, 0x02B5, 0x09A4, 0xFD18, 0x07CF,
0xF9A9, 0xFC88, 0xF85D, 0xFCC5, 0xF8C1, 0xFF63, 0xF868, 0xFDFC,
0xFA37, 0xF787, 0x017D, 0xF553, 0x075B, 0x0095, 0x07E6, 0x0901,
0x0C31, 0x065E, 0x09EE, 0x055E, 0xFF4A, 0x04C5, 0xF725, 0x0236,
0xF340, 0xFB00, 0xFD40, 0xF65D, 0x0527, 0xFCB5, 0xFD14, 0xFBC0,
0xFC17, 0xFB84, 0x078A, 0xFDA4, 0x0927, 0xFD9C, 0xFE04, 0x09E3,
0xFC8C, 0x08BF, 0xFF21, 0xFCBE, 0xFAE3, 0xFC60, 0xFAB8, 0x0070,
0xFEAD, 0x01F8, 0x05AD, 0xFABE, 0x0810, 0xFEB6, 0x03AE, 0x06D3,
0x015B, 0xFD0C, 0xFDEA, 0xF430, 0xF9CB, 0xF84D, 0xF8BD, 0x01B1,
0xFB40, 0xFDD9, 0xFCA4, 0xF9A0, 0xFE77, 0x02EA, 0x051B, 0x0A5A,
0x060D, 0x0E1A, 0x0661, 0x06DE, 0x0CE5, 0x020B, 0x0716, 0x0147,
0xF60A, 0xF1E4, 0xF219, 0xEA8B, 0xF6CB, 0xEFE4, 0xF8C2, 0xF956,
0xFD26, 0x02C7, 0xFDA3, 0x070E, 0x0258, 0x0CC4, 0x098D, 0x0BD3,
0x05B3, 0x0B56, 0x0841, 0x08FA, 0x0A51, 0xF6A9, 0x00EA, 0xF02D,
0xF78D, 0xF540, 0xF11F, 0xEDB2, 0xF09A, 0xF209, 0xF620, 0x06D1,
0x0325, 0x0BB6, 0x079A, 0x0755, 0xFFB2, 0x0677, 0x05F5, 0x05F7,
0x1042, 0x03FA, 0x0DD2, 0xFD00, 0x0592, 0xFB6F, 0xFD3F, 0xFBE8,
0xF58A, 0xF7F9, 0xECF6, 0xF256, 0xEA05, 0xF391, 0xF3DB, 0x050A,
0x0445, 0x05BB, 0x0739, 0xFA6A, 0x06BC, 0x0438, 0x1246, 0x0BD0,
0x13A8, 0x082B, 0x0C6E, 0x078D, 0x0459, 0x0905, 0xF4B6, 0xFEE6,
0xE930, 0xF09E, 0xE700, 0xEDED, 0xE934, 0xEE9A, 0xF3B8, 0xF71E,
0x0852, 0xFDFE, 0x1494, 0x0150, 0x1391, 0x0C33, 0x0EA0, 0x10F3,
0x07D9, 0x1227, 0x07AC, 0x0967, 0xFF2E, 0xFDB4, 0xEBA1, 0xFBA2,
0xE6A3, 0xEFE8, 0xEFC3, 0xE6E8, 0xF528, 0xEBE0, 0xF7E6, 0xFB05,
0x0D20, 0x0A2E, 0x190D, 0x0756, 0x0AE0, 0x081D, 0x068C, 0x122A,
0x0341, 0x0CEC, 0xFED5, 0xFEF7, 0xFDFC, 0xF843, 0xF31B, 0xFB06,
0xEE6D, 0xFAA7, 0xF199, 0xED19, 0xF77E, 0xF037, 0x0383, 0x058E,
0x0E09, 0x03F6, 0x0D91, 0xFEBB, 0x05A7, 0x05F6, 0x02C4, 0x063B,
0xFE9A, 0x04EC, 0xFC2C, 0x018D, 0xFFAA, 0x0076, 0xF9D6, 0x011F,
0xF053, 0xFCE5, 0xF44E, 0xF679, 0xFFD8, 0xF1AD, 0x03B9, 0xFB6C,
0x06C0, 0x007A, 0x07D5, 0xFB3F, 0x022C, 0xFEAF, 0x01DC, 0x04AD,
0x0109, 0x0C7F, 0x0181, 0x0C7B, 0x02D7, 0x0525, 0xFBFF, 0xFFE9,
0xF933, 0xFC67, 0xFAF2, 0xF7F8, 0xF918, 0xEE3D, 0xF9FB, 0xF696,
0x05AC, 0xFF0B, 0x0593, 0xF72F, 0xF91B, 0x0181, 0x0106, 0x0E25,
0x09B2, 0x1028, 0x060B, 0x0D39, 0x03C4, 0x0551, 0x0255, 0x0456,
0x0092, 0xFADB, 0xF645, 0xEBB3, 0xF040, 0xEE84, 0xF6EC, 0xF926,
0xFFB1, 0xFCE2, 0x0263, 0xFDA0, 0xFCC5, 0x04FE, 0x037E, 0x10C4,
0x0C15, 0x10C7, 0x0A68, 0x099A, 0x0BFA, 0x072C, 0x0346, 0xFDA5,
0xF580, 0xF564, 0xF14F, 0xF24D, 0xF0C2, 0xF163, 0xF594, 0xFF3E,
0x01BD, 0x029D, 0x09EA, 0xFE6D, 0x0480, 0x0543, 0x0074, 0x0937,
0x0A02, 0x0D55, 0x13A5, 0x0724, 0x0B88, 0xFFD0, 0xF9DC, 0x033A,
0xF591, 0xFE6E, 0xF75E, 0xF427, 0xF143, 0xF1C2, 0xF170, 0x01F0,
0x0370, 0x087E, 0x0B47, 0xFB0B, 0x0030, 0xFBA6, 0x04D2, 0x0665,
0x1073, 0x0DD8, 0x10B8, 0x0848, 0x0A96, 0x02C5, 0xFD89, 0x06D2,
0xF36D, 0xFE91, 0xED33, 0xF396, 0xED01, 0xF2CD, 0xF70D, 0xFD7D,
0x0415, 0x015A, 0x0AE4, 0xF94B, 0x09BD, 0x021F, 0x0E7D, 0x0B91,
0x0F96, 0x0B5E, 0x09E2, 0x0DC2, 0x088D, 0x0838, 0xFBB5, 0x009E,
0xEB4A, 0xFB9C, 0xEA5E, 0xEF85, 0xF309, 0xEC89, 0xFB89, 0xFC6E,
0x06E8, 0x0538, 0x148E, 0x0493, 0x10D5, 0x05E9, 0x0649, 0x09EE,
0x0704, 0x0F7A, 0x07C3, 0x08B1, 0x026E, 0x0062, 0xF78D, 0xFCFD,
0xEEBB, 0xF93B, 0xEEAB, 0xF609, 0xF39A, 0xF1DD, 0x0094, 0x0260,
0x12D0, 0x0CC6, 0x133B, 0xFECF, 0x043F, 0x029B, 0x0141, 0x0C58,
0x044F, 0x0783, 0x021B, 0xFEBF, 0xFD7E, 0x0057, 0xFA57, 0x07E6,
0xF948, 0xFFF0, 0xF257, 0xF37A, 0xF3F2, 0xF493, 0x03D3, 0x028B,
0x1033, 0x05FF, 0x0DD3, 0xFDF9, 0x0135, 0x01BE, 0x00A2, 0x07D9,
0x046C, 0x09A3, 0x01D3, 0x0562, 0x018B, 0x030D, 0xFAB5, 0x0438,
0xF274, 0xFAAC, 0xF3A9, 0xF3C9, 0xF805, 0xF397, 0xFDBC, 0xFC8E,
0x0AAD, 0x06FD, 0x119A, 0x0353, 0x050E, 0x03BB, 0xFF0E, 0x0A47,
0x05CF, 0x0D99, 0x062A, 0x082C, 0x0075, 0xFD05, 0xFB20, 0xFD87,
0xFB48, 0xFF0A, 0xF913, 0xF0AA, 0xF197, 0xEB08, 0xF412, 0x00FE,
0x0586, 0x0B3C, 0x0E04, 0x014D, 0x00CC, 0x0260, 0xFBF4, 0x0ABB,
0x0704, 0x0EFA, 0x0B6E, 0x05B9, 0x0616, 0xFDE4, 0x01B6, 0xFF76,
0xFC54, 0xF806, 0xEFF6, 0xF049, 0xEBE6, 0xF1D3, 0xF3AB, 0xFF0F,
0x0155, 0x0564, 0x0B92, 0xFE6D, 0x05CD, 0x0532, 0x0305, 0x0D80,
0x06CE, 0x0AB7, 0x087C, 0x0680, 0x0897, 0x02DD, 0xFE6F, 0xFBB0,
0xF25D, 0xF3B5, 0xEAE0, 0xF132, 0xEB0F, 0xEF33, 0xF5B5, 0xFB1E,
0x045C, 0x0808, 0x0E54, 0x0428, 0x0858, 0x040C, 0x0302, 0x07B0,
0x0A48, 0x0CC7, 0x0D68, 0x06C6, 0x0487, 0xF9DF, 0xF676, 0xFC2D,
0xEF22, 0xF876, 0xEC26, 0xEEA7, 0xEBB9, 0xF112, 0xF44C, 0x000E,
0x0287, 0x0AC7, 0x0915, 0xFFFD, 0x0465, 0xFBD5, 0x0797, 0x09EA,
0x0F41, 0x0BFF, 0x0B8A, 0x00E4, 0x033B, 0x0053, 0xFD72, 0x0517,
0xF7D8, 0xFC77, 0xECD5, 0xECE1, 0xE836, 0xED92, 0xF28C, 0x00B2,
0x018D, 0x0380, 0x0960, 0xFBB9, 0x059F, 0x02E5, 0x0816, 0x0952,
0x0FEC, 0x0E04, 0x0D1A, 0x0C39, 0x04E7, 0x03BD, 0xFBFA, 0x015A,
0xF460, 0xF8A4, 0xEC8C, 0xEB32, 0xE9E1, 0xE805, 0xF52C, 0xF78D,
0x08DB, 0x06BE, 0x13D3, 0x0491, 0x09B2, 0x0423, 0x01DE, 0x0B44,
0x0805, 0x123F, 0x081B, 0x0C34, 0xFFAC, 0xFF5C, 0xF968, 0xFCFF,
0xF840, 0xF9E3, 0xF0E9, 0xEEBA, 0xEA51, 0xE7C2, 0xF750, 0xFB40,
0x0C43, 0x0D94, 0x0FD7, 0x00CE, 0xFF3C, 0x0122, 0xF9A4, 0x0EAB,
0x069B, 0x0AC6, 0x0CEE, 0x01BE, 0x06B2, 0xFF49, 0xFDEF, 0x0239,
0xF9AA, 0xFBB9, 0xF370, 0xEFAB, 0xEE84, 0xF084, 0xF4C2, 0xFB77,
0x0231, 0x0477, 0x0A6F, 0x03F1, 0x039C, 0x024E, 0x0027, 0x094A,
0x07D2, 0x0CA7, 0x0C97, 0x041E, 0x0941, 0x022C, 0xFDFB, 0x0264,
0xF7C8, 0xF882, 0xF3E0, 0xF133, 0xECDC, 0xED0B, 0xF051, 0xF5CB,
0xFEC9, 0x0429, 0x09B2, 0x02C7, 0x0429, 0x028B, 0xFE8E, 0x0ACD,
0x0647, 0x11E2, 0x0B82, 0x09AD, 0x0578, 0xFC2B, 0xFCBE, 0x0300,
0xFB8C, 0x01F3, 0xF77F, 0xEBAB, 0xEF21, 0xE820, 0xF266, 0xFE5C,
0x000F, 0x065A, 0x0830, 0xFC47, 0x026B, 0x0062, 0x006C, 0x0CD7,
0x058A, 0x0FE3, 0x066D, 0x059C, 0x0741, 0xFCBF, 0x04F0, 0x008E,
0xFEBB, 0xFB4B, 0xF4B7, 0xEE5F, 0xEBEF, 0xED95, 0xF1C0, 0xFD79,
0x00A8, 0x087A, 0x0705, 0xFEDD, 0x002A, 0x018B, 0x0143, 0x0E0D,
0x0D08, 0x0BA7, 0x0FCD, 0x050A, 0x085B, 0xFCB7, 0xFE4A, 0xFA3A,
0xF725, 0xFF25, 0xED8C, 0xF850, 0xE73C, 0xEDB9, 0xF08B, 0xFA65,
0x02FC, 0x0CCF, 0x0E0B, 0x047E, 0x0512, 0xF827, 0x022D, 0x0208,
0x0F87, 0x0DC4, 0x0E80, 0x03E3, 0xFFE2, 0xFA20, 0xF771, 0x02C4,
0xF7F5, 0x041B, 0xF1F0, 0xF813, 0xE989, 0xF039, 0xF378, 0xF9C5,
0x06B3, 0x0740, 0x0DF3, 0xFEBD, 0x0502, 0xF7AC, 0x0113, 0x035A,
0x08B7, 0x0B3D, 0x0B03, 0x0707, 0x032E, 0x04D0, 0xF987, 0x085D,
0xF8E3, 0x0195, 0xF52B, 0xF286, 0xEC7A, 0xEC3B, 0xF2CB, 0xF53C,
0x0619, 0xFF67, 0x1252, 0x009D, 0x092C, 0x021A, 0xFF54, 0x0414,
0x0276, 0x0D0E, 0x05D6, 0x1254, 0x0545, 0x0629, 0xFD87, 0xFF45,
0xF8E8, 0xFB99, 0xF5F0, 0xF05A, 0xED03, 0xE94D, 0xF28E, 0xF460,
0x0901, 0x072E, 0x14EA, 0x03F3, 0x0772, 0xFE42, 0xFBBD, 0x08F7,
0x01E5, 0x0DC5, 0x064F, 0x0773, 0x05FD, 0xFE54, 0x0268, 0xFE34,
0xFA46, 0x015B, 0xF161, 0xF534, 0xED7C, 0xEC37, 0xF6D5, 0xFCB7,
0x0831, 0x08E5, 0x0E5A, 0xFD2D, 0x02B7, 0xFB01, 0xFEAD, 0x0780,
0x06EA, 0x0AB1, 0x080B, 0x03BA, 0x04FE, 0x0110, 0x01E2, 0x0682,
0xFD08, 0x02BD, 0xF3AB, 0xF5E6, 0xED6B, 0xED2A, 0xF45E, 0xF2AA,
0x0304, 0x01A5, 0x0BC1, 0x0100, 0x0438, 0xFC74, 0x01B4, 0x082E,
0x0AE0, 0x1218, 0x0BE1, 0x0B73, 0x0456, 0x01CF, 0xFAF6, 0x0103,
0xFB63, 0xFF12, 0xF803, 0xF26D, 0xEA58, 0xE21E, 0xEFBF, 0xEC85,
0x05F9, 0x0862, 0x128E, 0x09CE, 0x07C1, 0x02F7, 0xFFCF, 0x0B32,
0x0AAA, 0x1523, 0x09A5, 0x0E18, 0xFEC1, 0xFAB2, 0xFC24, 0xFB05,
0x002A, 0xFDAF, 0xFE80, 0xEE0F, 0xEECE, 0xE7FF, 0xECA3, 0xF7F5,
0x045F, 0x0B3A, 0x11FE, 0x0B07, 0x05B5, 0x02BB, 0xFE72, 0x0551,
0x0796, 0x0A69, 0x0E42, 0x0765, 0x0CA8, 0xFEA2, 0x0588, 0xFA8F,
0xFDF8, 0xFCDF, 0xF591, 0xFB7D, 0xEC42, 0xF384, 0xEC34, 0xF8C8,
0xFE6C, 0x06FE, 0x1253, 0x052C, 0x0BEB, 0x0183, 0x031F, 0x02D4,
0x0C90, 0x06B5, 0x134E, 0x0B5F, 0x0E64, 0x021A, 0xFEC3, 0xFC91,
0xF315, 0x0204, 0xEEC6, 0xFCF5, 0xEAB2, 0xF10E, 0xEF00, 0xF53E,
0x00C7, 0x040B, 0x14E1, 0x0335, 0x107C, 0xFF3A, 0x06CB, 0x07B8,
0x0DEF, 0x0D48, 0x0D13, 0x079D, 0x04F8, 0x03D3, 0xFC08, 0x05B8,
0xF56A, 0xFF74, 0xF244, 0xF68A, 0xEDF5, 0xF019, 0xF7DB, 0xF5E5,
0x0904, 0x04F8, 0x0FC3, 0x0048, 0x09D8, 0xFE72, 0x03CC, 0x0A81,
0x0861, 0x0C0D, 0x0624, 0x07A1, 0x008A, 0x02B2, 0x02BA, 0x02EA,
0x0285, 0x01E0, 0xFC5E, 0xF715, 0xF170, 0xEF88, 0xEEE0, 0xF611,
0xFF81, 0x0520, 0x0DA3, 0x062B, 0x04E8, 0xFDEF, 0xFE29, 0x02F4,
0x0935, 0x0FC5, 0x0ED1, 0x0D2C, 0x09FC, 0xFDA9, 0x0656, 0xFEF2,
0x05FE, 0x05DB, 0xFB7A, 0xFBAA, 0xE654, 0xEDF8, 0xE3D7, 0xF3F9,
0xFE87, 0x067E, 0x1584, 0x02FF, 0x09CF, 0xF9F2, 0xFFA4, 0x043B,
0x0EA9, 0x0E4C, 0x1287, 0x0D23, 0x08BE, 0x0306, 0x006B, 0x000B,
0xFF50, 0x0706, 0xFA4C, 0xFEC0, 0xE9F5, 0xEC4A, 0xEA4F, 0xF031,
0xFF14, 0x015A, 0x142A, 0x02D4, 0x0F7E, 0x0127, 0xFF6C, 0x0526,
0x07E4, 0x0B86, 0x0D5E, 0x0FE3, 0x07A4, 0x07B9, 0x014E, 0x005F,
0xFA50, 0xFE87, 0xFD28, 0xFA98, 0xF6F2, 0xEF18, 0xEE0B, 0xEB35,
0xF9E1, 0x0179, 0x0CE7, 0x0C84, 0x0CC7, 0x061F, 0xFDF2, 0x0947,
0x02F1, 0x0C2A, 0x0D8C, 0x0A82, 0x07D4, 0x031F, 0x0191, 0xFC53,
0x010A, 0xFC2B, 0x023F, 0xF725, 0xF7A3, 0xEF1A, 0xEA0D, 0xF51D,
0xF334, 0x0955, 0x0552, 0x0E5D, 0x0686, 0x05A9, 0x0238, 0x04A1,
0x0865, 0x0589, 0x0B68, 0x0283, 0x0834, 0xFD96, 0x073A, 0xFF9B,
0x04AC, 0x0041, 0xF9F7, 0xF81B, 0xECC2, 0xF6BC, 0xEB0C, 0xFD1D,
0xF5D4, 0x059E, 0x06D0, 0x05FB, 0x09B6, 0xFE9D, 0x0352, 0xFFAF,
0x09BA, 0x04A2, 0x09FC, 0x0479, 0x06BE, 0x00A4, 0x05F2, 0x0088,
0xFEEF, 0x03F7, 0xF993, 0xFF14, 0xEE61, 0xF261, 0xEB2B, 0xF1E9,
0xFAC2, 0xFFC5, 0x0A77, 0x0185, 0x0805, 0xFD7A, 0xFB1F, 0x025F,
0x0781, 0x0848, 0x1146, 0x0A02, 0x0184, 0xFF73, 0xFAF8, 0xFC0E,
0xFD5F, 0x0543, 0xFC83, 0xFF04, 0xF0E5, 0xF057, 0xEBCB, 0xEF89,
0x00DA, 0x004B, 0x10DD, 0x07B9, 0x0763, 0xFFFB, 0xFA6B, 0x0496,
0x0437, 0x0A4E, 0x0D23, 0x0529, 0xFF40, 0xFDD7, 0xF90A, 0xFB5F,
0xFDFF, 0x012D, 0xFD91, 0x0064, 0xF688, 0xF468, 0xEF37, 0xF0FA,
0xF8D3, 0xFEC1, 0x0B8C, 0x06A1, 0x0911, 0xFF68, 0xFA98, 0xFC94,
0xFE37, 0x0246, 0x08B5, 0x07FC, 0x07E7, 0x04D7, 0x0078, 0x0092,
0xFFAB, 0x0396, 0x0431, 0x00F3, 0xF917, 0xF6E1, 0xE99D, 0xEF24,
0xF082, 0xF692, 0x0A12, 0x016C, 0x103E, 0xFC43, 0xFB16, 0xFC4D,
0xFC0C, 0x08F3, 0x09EB, 0x0F91, 0x0862, 0x0A1F, 0x06D3, 0x02A6,
0x0431, 0x00EE, 0xFED2, 0xFAA2, 0xF27C, 0xEFD9, 0xEA35, 0xED37,
0xF641, 0xF75E, 0x0823, 0x01D1, 0x0DC6, 0x0214, 0x0316, 0x05AC,
0x024C, 0x0DC7, 0x071E, 0x0F22, 0x01D9, 0x06E9, 0x0383, 0xFCE0,
0x00AE, 0xFAEA, 0xF7E2, 0xF709, 0xF272, 0xF0F4, 0xF1D2, 0xF312,
0xFCA0, 0xFC1A, 0x0951, 0x064D, 0x0FEC, 0x084F, 0x07F5, 0x0670,
0x0046, 0x0876, 0x0327, 0x0805, 0xFDC0, 0x0116, 0xFC69, 0xFB86,
0x0239, 0xFE1C, 0x00D5, 0xFDA4, 0xF8F0, 0xF460, 0xF0D2, 0xF260,
0xF74B, 0xFF31, 0x0610, 0x0865, 0x0659, 0x03FC, 0xFF96, 0x00D9,
0x071F, 0x027F, 0x0AE0, 0x04DD, 0xFDFA, 0x0325, 0xFC3A, 0xFF64,
0x07FD, 0x049B, 0x08FF, 0x0270, 0xF5EA, 0xF635, 0xE728, 0xF296,
0xF1F5, 0xF978, 0x042C, 0x0331, 0x0A48, 0x0094, 0x0441, 0xFECE,
0x070B, 0x0790, 0x0D13, 0x0876, 0x033B, 0x05CC, 0xFF1B, 0x03FA,
0x0382, 0x03D4, 0x0111, 0x022E, 0xF4A5, 0xF61C, 0xE917, 0xEE73,
0xF0AE, 0xF5FC, 0x0566, 0x02F9, 0x108C, 0x055A, 0x04F5, 0x011C,
0x0218, 0x057D, 0x0E84, 0x092B, 0x056F, 0x0404, 0xF7B8, 0xFE38,
0xF82D, 0x00D7, 0xFE16, 0x0291, 0xFB37, 0xF855, 0xEED8, 0xF140,
0xF6C3, 0xF651, 0x0A06, 0x02AA, 0x0EA1, 0x07DE, 0x0455, 0xFFEB,
0xFED0, 0xFFB6, 0x0743, 0x0602, 0x0306, 0x0291, 0xF9B8, 0xFF04,
0xFCCC, 0x055B, 0xFFFB, 0x076A, 0xFD6D, 0xFC0F, 0xF695, 0xF2FC,
0xF683, 0xF705, 0xFD24, 0xFE9A, 0x0251, 0xFED2, 0x0282, 0xFCB4,
0x00D1, 0xFD9A, 0x0545, 0x0519, 0x0681, 0x0D1C, 0x0428, 0x065D,
0x0421, 0x040C, 0x0200, 0x07D4, 0xFB06, 0xFBE2, 0xEF9E, 0xF10B,
0xEDC2, 0xEFB8, 0xFA4C, 0xF5DE, 0x0518, 0xFE9D, 0x03F1, 0xFFFE,
0x0309, 0x0480, 0x095E, 0x0AC9, 0x0908, 0x0D87, 0x0549, 0x08C6,
0x0664, 0xFE50, 0x02E7, 0xFCD9, 0xF365, 0xF905, 0xE6F9, 0xEF60,
0xF014, 0xF03A, 0x0085, 0xFB90, 0x0759, 0x05C1, 0x04D1, 0x0825,
0x068A, 0x0A1E, 0x0CBA, 0x09A4, 0x04C9, 0x04F4, 0x004C, 0x00C9,
0x05C1, 0xFBEF, 0x00BB, 0xFB86, 0xF3E1, 0xFAC6, 0xEAE5, 0xF821,
0xF3A5, 0xF842, 0x0359, 0xFB2F, 0x091F, 0x05B9, 0x063E, 0x0A5A,
0x0002, 0x0374, 0x0463, 0xFFEE, 0x053A, 0xFEB8, 0xFC8E, 0xFF65,
0x0116, 0x028F, 0x07F6, 0x005C, 0x0021, 0xFC60, 0xEF75, 0xFB6F,
0xEB75, 0xFA51, 0xFB23, 0xFC2F, 0x0557, 0x0179, 0x015C, 0x0260,
0xFF2E, 0xFF4A, 0x086C, 0xFEE8, 0x0C21, 0x0434, 0x014B, 0x048D,
0x03AA, 0x00B3, 0x0EA9, 0x03E0, 0x02A7, 0xFF7E, 0xEAE6, 0xF7B6,
0xE48A, 0xF994, 0xF346, 0xFAB0, 0x021A, 0xFEB5, 0x04C2, 0x0248,
0x060F, 0x0175, 0x08D9, 0x03B6, 0x0795, 0x0398, 0x0452, 0x0218,
0x034D, 0x008A, 0x047D, 0xFF41, 0xFE79, 0xFD42, 0xF044, 0xF827,
0xE924, 0xFA0F, 0xF29B, 0xFE98, 0x05D9, 0x0007, 0x0E78, 0x02BE,
0x08CC, 0x038B, 0x0624, 0x0310, 0x05AB, 0x0253, 0xFFA0, 0xFFD4,
0xFBB7, 0xFC58, 0xFFAE, 0xFF32, 0x00CD, 0x0512, 0xF804, 0xFF60,
0xF396, 0xF7FF, 0xFAE2, 0xF9B6, 0x04B1, 0x0100, 0x0776, 0x0545,
0x0372, 0xFF1C, 0x03D1, 0xFD4D, 0x0286, 0x02FB, 0xFA1B, 0x046A,
0xFDF1, 0x03D7, 0x0931, 0x044D, 0x06AF, 0x0476, 0xFD6A, 0xFEC4,
0xFA09, 0xF761, 0xF959, 0xF77A, 0xF704, 0xFBD3, 0xFB27, 0x0030,
0x04FD, 0x0135, 0x0731, 0x0191, 0x046C, 0x0544, 0x0237, 0x0980,
0x03FA, 0x0998, 0x0AEF, 0x032C, 0x08F4, 0xFD8D, 0xFD08, 0xF9D3,
0xF3CD, 0xF531, 0xF367, 0xF29D, 0xF84F, 0xF8AE, 0xFB22, 0x06B1,
0x016C, 0x0972, 0x094A, 0x055B, 0x0A17, 0x0822, 0x0523, 0x09B6,
0x01CC, 0x061B, 0x0830, 0xFC1E, 0x0786, 0xF5EE, 0xF734, 0xF837,
0xEE32, 0xF88C, 0xF56B, 0xF866, 0x000C, 0xFD16, 0xFF37, 0x0899,
0xFFA7, 0x0CF4, 0x0C89, 0x069F, 0x0E3B, 0x03F1, 0x02B9, 0x002B,
0xFDA1, 0xFD32, 0x0277, 0xFD5B, 0x0377, 0xFBD0, 0xF854, 0xFBF8,
0xF405, 0xFD92, 0xFC23, 0xFECB, 0x027B, 0xFE6F, 0x0406, 0x04B0,
0x01FF, 0x0A98, 0x0309, 0x038D, 0x06A8, 0xFDEA, 0x0321, 0xFF33,
0xFE2B, 0x02FB, 0x00D3, 0x02BB, 0x0513, 0xFF62, 0x003B, 0xFF37,
0xF771, 0xFC91, 0xF8B1, 0xFAE5, 0xFECB, 0xFBFB, 0xFF31, 0x0284,
0xFF75, 0x08AD, 0x0386, 0x0454, 0x07CE, 0x02BF, 0x0824, 0x0489,
0x04E8, 0x0466, 0x0678, 0x010F, 0x080D, 0xFDF9, 0xFDD2, 0xFDB8,
0xF1D1, 0xF770, 0xF36D, 0xF784, 0xFB12, 0xFF19, 0xFE27, 0x0477,
0x0550, 0x07CE, 0x0CAC, 0x05FC, 0x0A24, 0x058B, 0x0734, 0x01A6,
0x075E, 0xFDDC, 0x0617, 0xFE5D, 0xFE6A, 0xFC14, 0xF427, 0x0046,
0xF1B4, 0x01DA, 0xF4A2, 0xFDAC, 0xFD34, 0xFD08, 0x0787, 0x0044,
0x0D1F, 0x061E, 0x0FA2, 0x03D9, 0x0912, 0xFFF1, 0xFFBF, 0xFF4B,
0xFC73, 0x00C7, 0xFC0F, 0x0428, 0xFD93, 0x03CB, 0xF9C6, 0x06DE,
0xF664, 0x051D, 0xFD94, 0xF9A5, 0x0560, 0xF272, 0x07AF, 0xF8E5,
0x06BA, 0x0285, 0x0534, 0xFFBB, 0x022C, 0x0178, 0xFA3C, 0x0764,
0xF823, 0x076A, 0x0229, 0x07C7, 0x080D, 0x054D, 0x0148, 0x0307,
0xFA71, 0xFBA4, 0xFD35, 0xF2F4, 0xFE6B, 0xF23D, 0xF9B1, 0xF834,
0xFF48, 0x03F9, 0x088A, 0x05CE, 0x053B, 0x054C, 0xFE5F, 0x0A4B,
0xFF64, 0x09E9, 0x0661, 0x05E8, 0x0867, 0xFDC6, 0x01E3, 0xF9A6,
0xF77C, 0xF98B, 0xF2A1, 0xF801, 0xF714, 0xF755, 0xFA41, 0xFABE,
0x01DF, 0x0514, 0x0AD8, 0x0747, 0x0835, 0x0483, 0x0489, 0x0671,
0x0184, 0x0738, 0x00BB, 0x02C6, 0x0258, 0xF7C6, 0xFD90, 0xF84D,
0xF6EB, 0xFE4E, 0xF4B4, 0xF9F4, 0xFA7E, 0xF87C, 0xFE6F, 0xFD34,
0x01A1, 0x02A9, 0x0D32, 0x02F6, 0x0CDD, 0x03C5, 0x0038, 0x0761,
0xFB32, 0x0733, 0xFF66, 0x0470, 0x02E7, 0xFD6F, 0xFE22, 0xFBB4,
0xFA71, 0xFD46, 0xFD8F, 0xF9CB, 0xFE4F, 0xF792, 0xFA1A, 0xF9A4,
0xFD76, 0x0046, 0x06C9, 0x02C2, 0x05F9, 0x0348, 0x00F3, 0x03ED,
0x0120, 0x0333, 0x04C5, 0x078B, 0x0536, 0x032C, 0x005A, 0xFACE,
0xFCA3, 0xFAA1, 0xF8EB, 0xF8C5, 0xF590, 0xF839, 0xF4F7, 0xFC39,
0xFBA8, 0x02BB, 0x070D, 0x04E8, 0x0B19, 0x0202, 0x0B24, 0x030A,
0x07C8, 0x05EC, 0x0401, 0x0629, 0x0521, 0x0083, 0xFFC7, 0xFC2A,
0xF408, 0xFBD8, 0xF093, 0xF920, 0xF79A, 0xF9A0, 0xF9BD, 0x0033,
0xFEA1, 0x064A, 0x0D53, 0x03D1, 0x0F5B, 0x0037, 0x0A12, 0x0220,
0x05F0, 0x0280, 0x0336, 0x0291, 0x0350, 0x0188, 0xF96B, 0x0117,
0xF25E, 0x00AE, 0xF6EE, 0xFC51, 0xFC11, 0xFC3B, 0xFF00, 0xFFB5,
0x03EA, 0x00E6, 0x0E64, 0xFF4F, 0x0C3A, 0xFD6C, 0x0116, 0xFDC2,
0xFFFB, 0x0127, 0x002C, 0x051D, 0xFE3C, 0x0333, 0xFB91, 0x0509,
0xF938, 0x074D, 0xFA3D, 0xFD0F, 0xFEDF, 0xF4B8, 0x034D, 0xF5A9,
0x042C, 0xFDA9, 0x065B, 0x02ED, 0x0530, 0xFF0E, 0x013B, 0x0087,
0xFFEB, 0x073A, 0x0065, 0x0AC2, 0x0441, 0x0650, 0x011C, 0x0191,
0xF89F, 0x038F, 0xF8DE, 0xF8CE, 0xFCEA, 0xEC01, 0xFB76, 0xF4DC,
0xFB84, 0x00D1, 0x063B, 0x0576, 0x0C0F, 0x0760, 0x03B5, 0x051E,
0xFD57, 0x05B5, 0x0195, 0x05E4, 0x0597, 0xFE5C, 0xFE91, 0xF99D,
0xF6B1, 0xFD02, 0xF79A, 0xFC08, 0xFA7E, 0xF63A, 0xFA61, 0xF9F7,
0xFF6D, 0x038B, 0x0AAA, 0x0882, 0x0AA6, 0x068C, 0x024E, 0xFEED,
0xFFC0, 0xFDD4, 0x00D8, 0x03CB, 0x0207, 0x0007, 0xFFEF, 0xFA2D,
0xFC44, 0xFFCA, 0xF8E4, 0x03CF, 0xF822, 0xFD14, 0xFBCA, 0xF82B,
0xFED7, 0xFF32, 0x04AE, 0x0626, 0x093E, 0x0720, 0x066B, 0x0402,
0x00A0, 0xFF9F, 0xFC54, 0x030F, 0xFEFE, 0xFEE3, 0x00A5, 0xF744,
0xFB6F, 0xFE52, 0xF836, 0xFEF8, 0xFB9F, 0xFAEB, 0xFDDF, 0xFCAB,
0xFD55, 0xFDCD, 0x0510, 0x06AA, 0x08E1, 0x0B40, 0x00CE, 0x03DE,
0xFC86, 0xFFD8, 0xFF92, 0xFFCA, 0x02D4, 0xFFC9, 0xFF71, 0xF98E,
0xFDDD, 0xF6DF, 0x006E, 0xFDD7, 0xFC73, 0xFD26, 0xF6FF, 0xFE12,
0xF696, 0x02B7, 0xFE5B, 0x0405, 0x06C6, 0x0A70, 0x06BE, 0x057F,
0x0617, 0xFAF0, 0x0550, 0xFEDC, 0x0069, 0xFC81, 0xFCF9, 0xF3E2,
0xFBA5, 0xF77C, 0xF725, 0xFF53, 0xF535, 0x0394, 0xF90F, 0x05AF,
0xFE7D, 0x0676, 0x059A, 0x0427, 0x0912, 0xFFF9, 0x087A, 0xFC80,
0x0281, 0xF86C, 0xFCB6, 0xF956, 0xFF9E, 0xFD71, 0xFB5E, 0xFC37,
0xF59D, 0xFD7B, 0xF9EC, 0x03D7, 0xFF68, 0x048B, 0x00C5, 0xFFFE,
0xFB3F, 0xFDE2, 0xFFB0, 0xFD78, 0x09CA, 0xFF1D, 0x0617, 0x0262,
0x0110, 0x0038, 0x004C, 0x0070, 0xFFD6, 0x03AE, 0xFAC3, 0xFCE0,
0xF4B0, 0xF7EA, 0xF8D3, 0xFCBC, 0xFF8F, 0x0005, 0x0131, 0xFEB6,
0x0185, 0xFD38, 0x053D, 0x02D1, 0x04AD, 0x07FD, 0xFF35, 0x0221,
0xFE0C, 0xFD33, 0xFC87, 0xFE62, 0xFCA0, 0x0126, 0xFC9E, 0x001A,
0xFA8D, 0xF8B0, 0xFDB5, 0xF9B5, 0x01B5, 0xFE8F, 0x02DB, 0xFC24,
0xFCC9, 0xFC20, 0xF7B0, 0x00CC, 0xFF2F, 0x08FF, 0x0423, 0x08DE,
0x0106, 0xFF16, 0x016E, 0xFF1A, 0x0569, 0x02AC, 0x03FB, 0xFD1B,
0xFAB7, 0xF42E, 0xF405, 0xF460, 0xF8CF, 0xFE85, 0xFDE1, 0x03F6,
0xFE6E, 0x0233, 0x06E2, 0x03A9, 0x0B51, 0x0A6B, 0x0405, 0x08D8,
0xFD0B, 0xFAD0, 0xF9F0, 0xF5BB, 0xFE66, 0xFEEB, 0xFED1, 0x02ED,
0xF90A, 0xFB87, 0xFC29, 0xF867, 0x02C3, 0x0266, 0x0648, 0x05E0,
0x0487, 0xFDAF, 0x018B, 0xFCAA, 0x0041, 0x0232, 0xFB4D, 0x06E4,
0xF8EE, 0x04BD, 0xF9E4, 0xFBF6, 0xFD46, 0xFEBB, 0x04C8, 0x047A,
0x05AF, 0xFB33, 0xFEAD, 0xF511, 0xFDF1, 0xF9B3, 0x03F9, 0x00ED,
0x02EF, 0x0381, 0x0258, 0x00F7, 0x06A9, 0x09F6, 0x0142, 0x0E72,
0xF990, 0x022E, 0xF903, 0xF9B6, 0xFE7B, 0xF78A, 0x04AE, 0xFF5A,
0x0211, 0x00D7, 0x011F, 0xF5F1, 0x0562, 0xFC4A, 0x0219, 0x04B3,
0xFAEA, 0x02A0, 0xF934, 0x01A9, 0xFE5F, 0x013C, 0x026E, 0x0560,
0xFEE8, 0x03A0, 0xFF78, 0xFB6E, 0x050A, 0xFCF9, 0x04D9, 0x0160,
0x0494, 0xFEB7, 0x0000, 0xFB32, 0xF976, 0xFDFE, 0xFBDD, 0x042C,
0xFD0D, 0x049C, 0x0357, 0x0118, 0x0BF9, 0x035E, 0x0923, 0x035F,
0x0506, 0xFE82, 0xFCC2, 0xFD62, 0xF742, 0xFCC5, 0xFD2F, 0x0267,
0xFE2C, 0x05FA, 0xFECB, 0xFE20, 0x067A, 0xFFF3, 0x09FF, 0x0586,
0x0360, 0xFECE, 0xFBF3, 0xF90E, 0xFED8, 0xFC65, 0x0293, 0x042E,
0xFE11, 0x0799, 0xFD00, 0x03C2, 0x03BC, 0x0398, 0x0651, 0x0722,
0x03A1, 0x026A, 0xFFA4, 0xFA7F, 0xFD96, 0xF9F1, 0x00EA, 0xFF1E,
0xFE96, 0x0141, 0xFD42, 0xFC84, 0x0618, 0x01E4, 0x074E, 0x0C85,
0x0407, 0x0562, 0x02E8, 0xFC40, 0xFE49, 0xFD09, 0xFDE8, 0x03AE,
0xFF3C, 0x07DD, 0xFDEB, 0xFE98, 0x0199, 0xFC73, 0x070B, 0x03E9,
0x062A, 0x011A, 0x0003, 0xFB1B, 0xFCFC, 0xFAE4, 0x02BA, 0x01F4,
0x04BF, 0x0713, 0xFF75, 0x0164, 0x01E0, 0x00CC, 0x0591, 0x0AD7,
0x0354, 0x0A7E, 0xFC92, 0xFDA9, 0xF5B0, 0xF643, 0xFD61, 0xF986,
0x037B, 0x0090, 0x0085, 0xFEE6, 0x0621, 0xFCAD, 0x08F8, 0x0573,
0x0481, 0x08EB, 0x0001, 0x0330, 0xFD5E, 0xFE77, 0xFF1E, 0x016C,
0xFD4F, 0x063F, 0xFA4B, 0xFD7F, 0xFDA1, 0xF6C2, 0x0343, 0xFF1D,
0x07AB, 0x01EE, 0x063C, 0xFD15, 0xFFD8, 0xFD3E, 0xFDF4, 0x0198,
0xFF46, 0x077F, 0xFEA1, 0x063F, 0x00EA, 0xFE81, 0x0509, 0xFF42,
0x05B5, 0x0050, 0xFFF0, 0xFB7D, 0xF5D3, 0xFA9A, 0xF829, 0xFC10,
0x01EB, 0x00FF, 0x01AE, 0x02CD, 0x02C2, 0x0264, 0x07DA, 0x07E0,
0x05D5, 0x04BB, 0xFE02, 0xFE50, 0xF902, 0xFADA, 0xFD75, 0xF9A0,
0x01BA, 0x02B0, 0xFD6A, 0x03CF, 0xFD12, 0xFF74, 0x0295, 0x0339,
0x017B, 0x01C1, 0xFDF8, 0xFE19, 0xFE2D, 0xFE1A, 0x00D2, 0x0039,
0x0205, 0x045E, 0xFD79, 0x00D3, 0x0024, 0xFAEC, 0x091A, 0x0174,
0x08AD, 0x0591, 0x02DA, 0xFD88, 0xF9E3, 0xFA70, 0xF4A6, 0xFEA6,
0xF888, 0x02E9, 0xFC2A, 0x01C1, 0x0315, 0xFF57, 0x0A67, 0x0548,
0x0A03, 0x0580, 0x051B, 0xFC43, 0xFB60, 0xF7A2, 0xFA58, 0xFB69,
0x03F4, 0x03B0, 0x00E8, 0x0103, 0xF9DA, 0xFC6E, 0xFF6A, 0x05CA,
0x040B, 0x0727, 0xFFD3, 0xFE0E, 0xFBBD, 0xFB81, 0x00F3, 0xFDAC,
0x06B2, 0x03A5, 0x00CE, 0x0496, 0xFDDE, 0xFA93, 0x0395, 0xFBB0,
0x0717, 0x04BB, 0x04B7, 0x0001, 0xFB2E, 0xF9EA, 0xF9A9, 0xFCC5,
0xFE79, 0x0444, 0xFAB1, 0x0580, 0xFE77, 0xFE7A, 0x0891, 0x018D,
0x0A44, 0x060E, 0x0765, 0xFFEA, 0x00C4, 0xF7E1, 0xFBE5, 0xF599,
0xFD6D, 0x0118, 0x0034, 0x06B8, 0xFFE7, 0xFE4F, 0xFDD6, 0x01A6,
0x00C8, 0x074A, 0x0212, 0x009D, 0xFA8C, 0xFC50, 0xF954, 0xFCCE,
0x0369, 0xFFF7, 0x08C1, 0x03FC, 0x05A7, 0x005C, 0x030E, 0xFFE8,
0x0414, 0x04F3, 0x036D, 0x016D, 0xFB98, 0xFD25, 0xF6C2, 0xFC93,
0xFB85, 0xFE40, 0xFE13, 0x01DE, 0xFF2C, 0xFFC7, 0x05BF, 0x0136,
0x0A05, 0x05AC, 0x070C, 0x02CD, 0xFFD3, 0xFF45, 0xFB08, 0xFB42,
0xFBA4, 0xFCA8, 0xFA57, 0x0136, 0xFBBE, 0xFB9A, 0x04A9, 0xFBE0,
0x0745, 0x0265, 0x0422, 0xFF10, 0x01C1, 0xFD2E, 0xFCFD, 0xFFB8,
0xFB50, 0x0562, 0xFE45, 0x0A69, 0x036A, 0xFFAD, 0x051A, 0xFA2D,
0x007D, 0x012A, 0xFFF2, 0xFA83, 0xFD57, 0xF3FE, 0xF91F, 0xF95E,
0xFF05, 0x000B, 0x0163, 0x043B, 0x00BC, 0x02D1, 0x0558, 0x07BB,
0x050B, 0x0C67, 0x017F, 0x0180, 0xFCC1, 0xF6B2, 0xF9CF, 0xF3CE,
0xFF14, 0xFA34, 0xFFE0, 0x01BF, 0xFB8A, 0xFC5E, 0x001C, 0xFDD7,
0x07F2, 0x06F2, 0x070E, 0x0254, 0xFD5E, 0xFD5A, 0xF87F, 0xFE68,
0xFBC7, 0x0058, 0xFA0D, 0x0486, 0xFBA3, 0xFEF0, 0x05A1, 0xF9D6,
0x087C, 0x034A, 0x064F, 0x04C2, 0x00D3, 0xF995, 0xF876, 0xF54B,
0xF963, 0xFC12, 0xFDC8, 0x033C, 0xFF0D, 0x0014, 0x0246, 0xFF67,
0x03C6, 0x08A5, 0x0185, 0x07CE, 0xFDB3, 0xFD2B, 0xFA2E, 0xF7DC,
0xFD26, 0xFB75, 0x0276, 0x01CD, 0x00BF, 0xFC34, 0xFE35, 0xF874,
0x0175, 0x043F, 0x0761, 0x0575, 0x04BA, 0xFE36, 0xF999, 0x0021,
0xFA3E, 0x03DB, 0xFEE9, 0x06DC, 0xFB7A, 0x00A7, 0xFE94, 0xF764,
0x03D7, 0xFB51, 0x0458, 0xFD0C, 0x0211, 0xFA85, 0xFBD1, 0xFCA0,
0xFA61, 0xFF73, 0xFC31, 0x065C, 0xFE68, 0x0783, 0x04B7, 0x01CF,
0x066E, 0x058F, 0x034C, 0x04CC, 0xFFFA, 0xF81E, 0xF97D, 0xF26F,
0xF75A, 0xF7B1, 0xFCAC, 0x017F, 0x0156, 0x02F8, 0x042A, 0xFF6A,
0x0103, 0x05A2, 0xFCB0, 0x04DE, 0xFF9D, 0xFB48, 0xFE71, 0xF929,
0xFC2E, 0xFB9A, 0xFF53, 0x02CB, 0x011D, 0x0273, 0x02C4, 0xFA5C,
0x00DB, 0x02CD, 0x0083, 0x08C6, 0x0269, 0xFD64, 0xFAEF, 0xFA42,
0xF774, 0xFDBD, 0xF9F6, 0xFD8C, 0xFA48, 0xFDDF, 0x043D, 0xFDD4,
0x0DC6, 0x028B, 0x075D, 0x05B9, 0xFE01, 0xFF8F, 0xF9C6, 0xFACC,
0xF6CC, 0xFAEF, 0xF620, 0x00B7, 0xF8E2, 0x0200, 0x008B, 0xFA92,
0x078A, 0xFFC5, 0x0695, 0x058B, 0x02D8, 0xFDD4, 0xFE9F, 0xFBEE,
0xFCED, 0xFFBE, 0xFBE0, 0x0577, 0xF884, 0x060F, 0xFE54, 0xFA02,
0x014F, 0xF9DC, 0xFADC, 0x0314, 0xFD3E, 0xFDA9, 0xFF1C, 0xF787,
0xFD26, 0xFC6D, 0x01AC, 0x0457, 0x01B4, 0x0603, 0xFE09, 0x00A0,
0x0276, 0x030C, 0x07C4, 0x0700, 0x0427, 0xFD2F, 0xFABB, 0xF5AD,
0xF5BC, 0xF9C6, 0xF910, 0x00F4, 0xFB08, 0x038C, 0xFCA6, 0xFE35,
0x045D, 0xFF77, 0x0812, 0x0490, 0x041A, 0xFEDA, 0xFB75, 0xFA71,
0xF697, 0xFB42, 0xFD86, 0x009D, 0x0129, 0x067E, 0x0087, 0x005B,
0x04C6, 0xFE6E, 0x045D, 0x053B, 0x012B, 0x00AE, 0xFE35, 0xF846,
0xFA48, 0xF839, 0xFC12, 0xFDB2, 0xFECA, 0x053A, 0x009D, 0x0406,
0x0289, 0x004B, 0x00B6, 0x0632, 0x0301, 0x0480, 0x02B0, 0xF933,
0xF886, 0xF6AC, 0xF8CB, 0xFDF5, 0x0189, 0x01C5, 0x01EC, 0xFC23,
0x0131, 0xFDDE, 0x0409, 0x0755, 0x063A, 0x052B, 0x01D2, 0xFF6C,
0xF85C, 0x001C, 0xF77D, 0x0307, 0xFCF9, 0x05BD, 0x0313, 0xFE84,
0x07A0, 0xF62E, 0x054B, 0xFCC8, 0x030B, 0x00FA, 0xFE19, 0xFC59,
0xF66C, 0xFBFF, 0xF8BC, 0x007B, 0xFC23, 0x0829, 0xFE25, 0x09FB,
0x072C, 0x0404, 0x0AD1, 0x0432, 0x057F, 0x02A7, 0x04B3, 0xF7D4,
0x0377, 0xF3DE, 0xFBFD, 0xFB63, 0xFA04, 0x05CF, 0xFD60, 0x0643,
0xFF77, 0xFFF6, 0xFF75, 0x033A, 0xFEE9, 0x05E8, 0x00D0, 0x00F6,
0x006D, 0xFD5A, 0xFF8D, 0xFE36, 0x0120, 0x02FC, 0x023C, 0x0136,
0x075A, 0xFBFF, 0x0912, 0x0379, 0x03AE, 0x0895, 0x0018, 0xFFE2,
0xF9EC, 0xFC8C, 0xF713, 0xFF6B, 0xFBC4, 0x0262, 0xFD9A, 0x04FD,
0x0411, 0x0138, 0x0D74, 0xFFC9, 0x0AD1, 0x0024, 0x0106, 0xFC4B,
0xF98E, 0xFBA3, 0xFA0D, 0xFD91, 0xFE11, 0x040D, 0xFD11, 0x08D9,
0xFFDE, 0x044B, 0x05B2, 0x03D5, 0x0528, 0x04B5, 0x02AD, 0xFEC3,
0x0070, 0xFB0A, 0xFFAF, 0xFD7B, 0x002D, 0x0451, 0xFEFC, 0x053C,
0xFF0C, 0xFD4E, 0x0060, 0xFD5C, 0x023F, 0x027B, 0x015E, 0xFFD1,
0xFBE1, 0xFDCA, 0xFB4F, 0xFF9C, 0xFE97, 0x032A, 0xFEEE, 0x0651,
0x01C3, 0x0316, 0x0848, 0x045B, 0x0B37, 0x0726, 0x0714, 0xFD97,
0xFC20, 0xF713, 0xF2FF, 0xFB7E, 0xF93F, 0x01D7, 0x025B, 0x04D0,
0x00FD, 0x029B, 0x038E, 0x01A8, 0x0688, 0x0190, 0xFFF5, 0xFE74,
0xFA36, 0xFC2C, 0xFAB0, 0xFBD8, 0xFFFD, 0x011D, 0x0343, 0x07E8,
0x021D, 0x0360, 0x0106, 0xFEED, 0x01AC, 0x0588, 0x05DC, 0x0464,
0x0456, 0xF98B, 0xFBC0, 0xF768, 0xFABF, 0xFE94, 0xFBFF, 0x0582,
0xFBE2, 0x035E, 0x03D4, 0x0009, 0x0829, 0x056F, 0x0463, 0x04B2,
0xFF4E, 0xFC6A, 0xF708, 0xF903, 0xF66E, 0xFD57, 0xFEC0, 0x03CB,
0x0491, 0xFED7, 0x06B7, 0xFB51, 0x06C1, 0x0560, 0x06AF, 0x0678,
0x0080, 0xFF28, 0xF80F, 0xFF20, 0xFA86, 0x01F9, 0x0044, 0x0332,
0x00BB, 0x00FF, 0x0041, 0xFC9A, 0x00FB, 0xFB07, 0x0090, 0xFD66,
0x0072, 0xFEBE, 0xFF91, 0xFBC8, 0xFBE7, 0xFCE3, 0xFA88, 0x08D7,
0xFC25, 0x0DAD, 0x01F5, 0x02F9, 0x0A28, 0x011A, 0x0D43, 0x0508,
0x09BB, 0xFCFB, 0xFD88, 0xF4E8, 0xF482, 0xF755, 0xF8FC, 0xFFBC,
0xFAE6, 0x0304, 0xFB56, 0x0028, 0x00F1, 0x00AE, 0x0094, 0x048C,
0x001B, 0x060D, 0x00F1, 0x019C, 0xFFBF, 0xFBE7, 0x04B0, 0xFE09,
0x05EA, 0x0185, 0x000F, 0xFC12, 0xFE9B, 0xFC15, 0x014B, 0x04FC,
0x0231, 0x03D3, 0xFCD1, 0xFEEB, 0xFB06, 0xFFE3, 0x011B, 0x02D2,
0x00FA, 0x0629, 0xFEBF, 0x03BA, 0x023D, 0xFDC2, 0x0237, 0xF80E,
0xFED4, 0xF8A9, 0xFB17, 0x000B, 0xF833, 0xFCA7, 0xFC52, 0xFD2D,
0x0196, 0x09F2, 0x050E, 0x0813, 0x09F5, 0x0023, 0x0B1D, 0x0331,
0x0783, 0x061E, 0x011B, 0xFF02, 0xFA07, 0xF883, 0xFA1D, 0xFE8A,
0xFF8C, 0x0091, 0xFD13, 0xFAB5, 0xF90C, 0xFD4B, 0xFC8F, 0xFFDE,
0xFEE4, 0xFC59, 0xFFE9, 0xFE2A, 0x00D2, 0x00C6, 0x01F1, 0x0029,
0x03EE, 0x041C, 0x04A8, 0x0672, 0x0974, 0x03D4, 0x0CA0, 0x03AC,
0x08F5, 0x0401, 0x00CF, 0xFE07, 0xF5DA, 0xF8F8, 0xF764, 0xFD1F,
0xFEBF, 0x010A, 0xFC4C, 0x0089, 0xFD07, 0xFE74, 0xFE91, 0xFD11,
0xFDDF, 0xFC84, 0x020D, 0xFEB2, 0x0319, 0x03E2, 0x0387, 0x0277,
0x0275, 0x01EA, 0xFE5F, 0x0240, 0x012D, 0xFD6C, 0x05F7, 0x026C,
0x08C3, 0x08AB, 0x08A4, 0x048E, 0x01CF, 0xFF5F, 0xFC07, 0xFD5D,
0xFD0F, 0x0158, 0xFEC2, 0x0043, 0xFCA7, 0xF91D, 0xF9F1, 0xFD4B,
0xF8D9, 0xFD45, 0xF864, 0xF8AD, 0xFA6D, 0xFEC8, 0x021C, 0x025E,
0x0B46, 0x072C, 0x0DFB, 0x0700, 0x0AEB, 0xFEA6, 0x0693, 0x00F2,
0x026B, 0x0469, 0xFFC9, 0x0529, 0xFBEF, 0x064B, 0xF9FA, 0x0297,
0x000F, 0x0343, 0x00C9, 0x0134, 0xFAAC, 0xF5BF, 0xFC48, 0xF49D,
0xFDC5, 0xF5DA, 0xFB83, 0xF561, 0xFB91, 0xFCC4, 0xF996, 0x00FB,
0xFA7B, 0x0AAC, 0x02C3, 0x10C6, 0x0CE6, 0x076D, 0x13B2, 0x04C1,
0x10DC, 0x05D5, 0x097A, 0x00A0, 0xFF77, 0xFAE3, 0xF6F3, 0xF845,
0xFC6B, 0xFD07, 0xFF68, 0x020E, 0xFBA8, 0xFE61, 0xF844, 0xFF6F,
0xF1DB, 0xFFE0, 0xF78A, 0xF8EC, 0xFEA5, 0xFB3C, 0xFEF0, 0xFCED,
0x0647, 0x000C, 0x0837, 0x04C3, 0x0522, 0xFE4D, 0x0582, 0x013C,
0x0742, 0x06D7, 0x090E, 0x04B7, 0x01D3, 0x07D1, 0xF91C, 0x0595,
0xF868, 0x0314, 0xF8AE, 0x0390, 0xFB2B, 0xFACB, 0xFEFD, 0xF801,
0xFFAA, 0xF7B9, 0xFE6D, 0xF3CE, 0xF84A, 0xF778, 0xF4F7, 0xFA99,
0xFDA7, 0x047B, 0x0705, 0x0CD4, 0x09CD, 0x045F, 0x0878, 0x0459,
0x04B7, 0x0A31, 0x03BC, 0x0416, 0x0279, 0xFDEB, 0xFECC, 0xFD2E,
0x00D9, 0xFF6C, 0x01AE, 0x00B8, 0xFBCA, 0xFA33, 0xF725, 0xF991,
0xF653, 0xFE80, 0xFBAC, 0xF9F9, 0xFD06, 0xF81D, 0xF63B, 0xFBFB,
0xF8F9, 0x0361, 0x032C, 0x0843, 0x09B0, 0x012B, 0x0C2A, 0x0094,
0x0C59, 0x075A, 0x0BB8, 0x0468, 0x020F, 0xFEA0, 0xF5EF, 0xFFEF,
0xF9BC, 0x030A, 0xFF0A, 0x038C, 0xFB1B, 0xFD0B, 0xF94F, 0xF5F6,
0xF687, 0xF9E4, 0xF89F, 0xF979, 0xFDD0, 0xF715, 0xF90B, 0xF9EA,
0xFAB5, 0xFD1F, 0x0355, 0x05F2, 0x06AD, 0x0358, 0x0787, 0xFEB8,
0x067D, 0x0855, 0x0829, 0x0822, 0x04D1, 0x0013, 0xFACD, 0xFBE9,
0xF99B, 0xFCE7, 0xFC9A, 0x0246, 0xFCCB, 0xFC82, 0xF962, 0xF680,
0xF3B4, 0xFBBF, 0xF71E, 0xFA15, 0xFB8A, 0xF7FD, 0xF7AE, 0xFCB5,
0xFBE0, 0x02BD, 0x07EC, 0x08CC, 0x0C27, 0x02A0, 0x08BB, 0xFBF2,
0x0542, 0x02FC, 0x0512, 0x046D, 0x0182, 0xFF0E, 0xF652, 0x0049,
0xF4C8, 0x029B, 0xFEBE, 0x03C9, 0xFEF9, 0xFF11, 0xFD22, 0xF757,
0xFFF2, 0xF91E, 0xFF51, 0xF770, 0xFE35, 0xF5BB, 0xF7CE, 0xFA65,
0xF39E, 0xFDCA, 0xFACE, 0x0844, 0x05BE, 0x0BC2, 0x0E99, 0x068A,
0x0E49, 0x0A03, 0x0BD8, 0x077D, 0x08B9, 0xFBA3, 0xFBE8, 0xF60B,
0xF6BA, 0xF77F, 0xFCE2, 0xFEC8, 0xFADD, 0x0169, 0xF5CC, 0xFB00,
0xF3C8, 0xFF0B, 0xF661, 0x01E3, 0x0188, 0xFBDC, 0x036E, 0xFCC6,
0xFFDF, 0xFF22, 0x05EE, 0x0418, 0x087B, 0x0189, 0x07C7, 0xFA06,
0x0924, 0x041D, 0x0A51, 0x0A72, 0x07A8, 0x04BE, 0xF932, 0x02EA,
0xF179, 0xFFAF, 0xF95A, 0xFE53, 0xFDCB, 0xFC79, 0xFFE3, 0xF6B7,
0x004F, 0xF9A0, 0xFD4A, 0xFA83, 0xFBB8, 0xF8B0, 0xF8B1, 0xFD25,
0xFB24, 0x0098, 0x01BB, 0x0816, 0x04F2, 0x0A74, 0x096E, 0x044F,
0x098A, 0x0613, 0x0652, 0x0717, 0x0895, 0x00CD, 0x048C, 0xFD24,
0xFB31, 0xFC19, 0xFC9A, 0xFF76, 0xFCA3, 0x0171, 0xF6C7, 0xF7F4,
0xF6FB, 0xF7FC, 0xF942, 0xFE55, 0xFC44, 0xFBD6, 0xFB63, 0xFF4B,
0xF894, 0x02FA, 0xFFF9, 0x06E9, 0x0B47, 0x07FC, 0x12DB, 0xFEEF,
0x1342, 0x0366, 0x0EE0, 0x09F8, 0x0898, 0x00DA, 0xF8B6, 0xFDCC,
0xEE93, 0xFF77, 0xF65B, 0xFFAE, 0xFA7F, 0x01FA, 0xF8E8, 0xFD5C,
0xFC7B, 0xFD23, 0x00BC, 0xFE2A, 0x0433, 0xF7D9, 0x032A, 0xF9DA,
0xFFFC, 0xFD94, 0x0309, 0x04B0, 0x04FE, 0x0B48, 0x03F6, 0x03DF,
0x06E0, 0x05B2, 0x0B24, 0x0CE9, 0x0C6B, 0x0585, 0x049D, 0xFE24,
0xF8BE, 0xF9D2, 0xF885, 0xFA63, 0xFD65, 0x0028, 0xFD21, 0xF933,
0xFA79, 0xF6EE, 0xFA49, 0xFFD8, 0xFEAF, 0xFEAF, 0xFC4B, 0xFD8F,
0xF8D5, 0x01ED, 0x0376, 0x08EB, 0x0DD2, 0x091E, 0x0DFA, 0xFDAD,
0x0B1A, 0xFEEE, 0x09D4, 0x090F, 0x0913, 0x06CE, 0x000E, 0x001D,
0xF437, 0xFE45, 0xF683, 0xFFF2, 0xFC8D, 0x0265, 0xFA5C, 0xFCFE,
0xFC44, 0xF87E, 0x0305, 0xFC13, 0x04E3, 0xF8B6, 0xFDF5, 0xF84F,
0xF57E, 0xFEF7, 0xF865, 0x03AF, 0x0213, 0x0B3E, 0x09E2, 0x0952,
0x0CFA, 0x0409, 0x0D22, 0x08B1, 0x0D51, 0x05C9, 0x05D1, 0xFE00,
0xFBB2, 0xFAEB, 0xFA49, 0xFA74, 0xF963, 0x001B, 0xF4FA, 0xFEB2,
0xF216, 0xF96C, 0xF3B3, 0xFD2B, 0xFC49, 0xFD89, 0x02A7, 0xFE4B,
0xFFC3, 0x011A, 0x01A8, 0x0327, 0x0B74, 0x0610, 0x0D9F, 0xFF0D,
0x0B9A, 0xFDB1, 0x0E54, 0x08EB, 0x0BFC, 0x0857, 0xFDA7, 0x01D2,
0xEFBA, 0x01AD, 0xF183, 0xFF2E, 0xF827, 0xFE6B, 0xF941, 0xFE7C,
0xFCE2, 0xFB86, 0x009D, 0xFA3C, 0x0389, 0xF510, 0x01EC, 0xF5A8,
0xFAFE, 0xFF2C, 0xFF29, 0x05D0, 0x073B, 0x0AA4, 0x0697, 0x08CD,
0x0592, 0x0555, 0x0699, 0x06FB, 0x06A1, 0x01F2, 0x0268, 0xFAA1,
0xFB4F, 0xFABB, 0xF9FC, 0xFBA1, 0xFBB9, 0xFE7A, 0xF917, 0xFF35,
0xF73F, 0xFB97, 0xFA94, 0xFE60, 0x0040, 0xFD60, 0xFF9F, 0xFA7E,
0xF562, 0xFE2A, 0xF460, 0x008B, 0x0283, 0x0428, 0x0D4B, 0x018F,
0x0F0E, 0xFE53, 0x0F0D, 0x07F3, 0x0ED9, 0x0849, 0x045C, 0xFDC9,
0xF295, 0xFC47, 0xEFA3, 0xFD6D, 0xF79C, 0x0002, 0xF876, 0x0277,
0xF660, 0xFFB5, 0xF8C6, 0xFD82, 0xFF6C, 0xF724, 0x044F, 0xF4A9,
0x0062, 0xFA8B, 0xFBF6, 0xFF9A, 0x0138, 0x0631, 0x06C4, 0x0589,
0x069F, 0x0300, 0x0881, 0x099F, 0x0BAA, 0x089E, 0x079F, 0x01BA,
0xFB42, 0xFEA7, 0xF4DB, 0xF7F6, 0xF806, 0xF7FE, 0xF958, 0xFE69,
0xF9D3, 0xFB7F, 0xF872, 0xF9C9, 0xF982, 0xFC48, 0xFFCA, 0xFDD5,
0xFDAA, 0x00F6, 0xFCC5, 0x03B3, 0x05FA, 0x0661, 0x0D9C, 0x02BA,
0x1044, 0xFED7, 0x0CD8, 0x058E, 0x0856, 0x05C9, 0x02F5, 0xFDE5,
0xF651, 0xFDB9, 0xEEE3, 0xFD60, 0xF288, 0xFD66, 0xF786, 0x02A1,
0xFBD5, 0x01C6, 0x0047, 0xFE25, 0x04A4, 0xF829, 0x042F, 0xF3FA,
0xFEA0, 0xFA9E, 0xFCDF, 0x00D1, 0xFD5F, 0x055A, 0x002F, 0x0614,
0x0798, 0x03A7, 0x0B1E, 0x09BE, 0x0B9E, 0x07E2, 0x0978, 0xFC5E,
0xFEAC, 0xFBF0, 0xF745, 0xFAF3, 0xF9AF, 0xF772, 0xF9BB, 0xFC7D,
0xF5FD, 0x001A, 0xF573, 0x005A, 0xFA89, 0xFD55, 0xFFCC, 0xFA66,
0xFFA6, 0xFCED, 0xFFF0, 0x0045, 0x045F, 0x048E, 0x089B, 0x00F7,
0x0A44, 0xFB88, 0x0B94, 0x066F, 0x0C70, 0x0C54, 0x063F, 0x015A,
0xF8D3, 0xFD75, 0xF0E9, 0xFF99, 0xF4F8, 0xFE39, 0xFA6F, 0x0036,
0xFBE7, 0x0139, 0xFD55, 0xFF9F, 0xFFE2, 0xFAD5, 0x01D8, 0xF2CC,
0xFDD2, 0xF4D5, 0xFC8A, 0x006E, 0x0410, 0x0919, 0x0700, 0x07B3,
0x0765, 0x026D, 0x08D7, 0x06DF, 0x08EC, 0x0B06, 0x07E4, 0x01E5,
0xFD82, 0xFA34, 0xF37D, 0xF92F, 0xF4A4, 0xF998, 0xF974, 0xFCFE,
0xFD41, 0xFCDA, 0xFB36, 0xFE5A, 0xFB56, 0x020A, 0xFFBE, 0xFD73,
0xFC2D, 0xFA43, 0xF94E, 0xFE3E, 0xFE5F, 0x04EF, 0x0719, 0x0610,
0x0F01, 0xFF56, 0x1087, 0x0232, 0x0FC3, 0x0B96, 0x0AD3, 0x0610,
0xFB7A, 0xFA27, 0xEE28, 0xF7C3, 0xED17, 0xFC20, 0xF059, 0x0120,
0xF45F, 0x00C4, 0xF9BC, 0xFEC6, 0xFE6F, 0xFD14, 0x048C, 0xF7FD,
0x0727, 0xF6EA, 0x03C2, 0xFC73, 0x007F, 0x0513, 0x00A5, 0x080D,
0x0453, 0x0110, 0x05A1, 0xFFB9, 0x059E, 0x0767, 0x05DA, 0x076A,
0xFF7E, 0xFE99, 0xF807, 0xF77B, 0xF542, 0xF586, 0xF4CA, 0xFAAB,
0xF8D7, 0xFF88, 0xFBA7, 0xFEDF, 0xF7A9, 0xFE63, 0xF887, 0xFD0A,
0xFD47, 0xFBA5, 0xFD1C, 0xFD2D, 0x0131, 0x0227, 0x087B, 0x05D5,
0x0B4B, 0x00B5, 0x0BF7, 0xFEBB, 0x0B1F, 0x056A, 0x0786, 0x03C7,
0xFB82, 0xFBF5, 0xF103, 0xF939, 0xF201, 0xFBBD, 0xF2E0, 0x0100,
0xF7F4, 0x01C0, 0xFEAE, 0x002C, 0xFE25, 0xFBE2, 0xFF1F, 0xF518,
0xFD0A, 0xF675, 0xFA94, 0xFBB6, 0xFD69, 0x02D0, 0x00A5, 0x07CE,
0x0730, 0x035F, 0x0C40, 0x029A, 0x0EC3, 0x0888, 0x0DAB, 0x0759,
0x02BB, 0xFE49, 0xF882, 0xF7AB, 0xF4B4, 0xF727, 0xF200, 0xF96B,
0xF291, 0xFC92, 0xF628, 0x0122, 0xF81B, 0x024B, 0xFB7C, 0xFDA6,
0xFDDA, 0xFA45, 0xFC5E, 0xFB3F, 0xFFD2, 0x02A3, 0x079C, 0x0814,
0x0E27, 0x0185, 0x0EDC, 0xFE73, 0x0CB6, 0x05DB, 0x0C49, 0x0729,
0xFFD0, 0xFD91, 0xEF77, 0xF6DD, 0xEDF0, 0xF9D3, 0xEFFE, 0xFE72,
0xF2E9, 0xFEE6, 0xFA2E, 0xFE7E, 0xFE20, 0xFEB5, 0x020D, 0xFAF6,
0x04F4, 0xF791, 0x0219, 0xFB5F, 0x0137, 0x0453, 0x01BD, 0x0A71,
0x027A, 0x054D, 0x05A9, 0x000B, 0x0734, 0x0540, 0x08F3, 0x0689,
0x03B5, 0xFEC6, 0xF8C0, 0xF63C, 0xF796, 0xF376, 0xF833, 0xFA7C,
0xFAAD, 0xFF5C, 0xFEC3, 0x0062, 0xFAA1, 0x0319, 0xFB36, 0x00BF,
0xFAEA, 0xFE4B, 0xF691, 0xFC2A, 0xFB11, 0xFE34, 0xFF6F, 0x067C,
0x0627, 0x0353, 0x0EA0, 0xFE7C, 0x0FF3, 0x03A5, 0x1046, 0x0520,
0x0962, 0x0143, 0xFBC4, 0xFCB7, 0xF48C, 0xFC00, 0xF1D0, 0x0062,
0xF22A, 0x01D6, 0xF6DB, 0x0066, 0xFAC3, 0xFC9E, 0xFDDB, 0xF6FA,
0xFE51, 0xF78C, 0xFDE4, 0xFC11, 0x03E8, 0x0293, 0x05E6, 0x09D7,
0x05F4, 0x08D3, 0x0C36, 0x05FF, 0x0C83, 0x08A3, 0x0AB1, 0x07D9,
0x0648, 0x01B7, 0xFB58, 0xFAD9, 0xF7CA, 0xF464, 0xF79E, 0xF4A3,
0xF6E5, 0xFC14, 0xFB1E, 0x02BA, 0xFC66, 0x0370, 0xFBB5, 0xFD1C,
0xFD4F, 0xFB06, 0xFC80, 0x0003, 0xFFF5, 0x0500, 0x0607, 0x0B00,
0x081E, 0x092D, 0x0E1A, 0x023E, 0x114F, 0x0449, 0x0D91, 0x02C8,
0x04D8, 0xFAAF, 0xF5EF, 0xF9D1, 0xF28E, 0xFB5B, 0xF5E3, 0xFDE0,
0xF640, 0x0273, 0xFF1E, 0x0607, 0x046A, 0x06C0, 0x04CE, 0xFD19,
0x04CB, 0xF6F5, 0xFE31, 0xFBAC, 0xFEE1, 0x0064, 0x0131, 0x0728,
0xFE52, 0x05E7, 0x0489, 0x02F9, 0x0C9C, 0x0BC6, 0x0F4B, 0x0B85,
0x0C6E, 0x0197, 0x027C, 0xFB76, 0xFD90, 0xF79B, 0xFCF1, 0xF886,
0xF8AF, 0xFD4E, 0xFA63, 0x0415, 0xFDE0, 0x073E, 0xFB88, 0xFFD2,
0xF992, 0xF996, 0xF746, 0xFA93, 0xFC14, 0x005B, 0x0414, 0x0955,
0x057B, 0x08BF, 0x0C47, 0x02D9, 0x1311, 0x0575, 0x1441, 0x07D4,
0x0E17, 0x02A3, 0xFC8E, 0xFDE9, 0xF58A, 0xFD23, 0xF692, 0xFD16,
0xF0C9, 0xFD25, 0xF404, 0x004F, 0xFDB9, 0x04D0, 0x0049, 0xFFFD,
0x0048, 0xF8CE, 0xFFB1, 0xFB63, 0x0280, 0x0098, 0x0786, 0x0744,
0x0548, 0x08FA, 0x04B0, 0x02FA, 0x09DC, 0x065E, 0x0BD7, 0x0A2B,
0x06F2, 0x0140, 0xFAB4, 0xFA55, 0xF769, 0xF8AA, 0xFC15, 0xF873,
0xF8F1, 0xFC31, 0xFCE3, 0x02A7, 0x034B, 0x07B4, 0xFEE6, 0x010C,
0xFB3D, 0xF8F3, 0xF6E4, 0xFC9C, 0xF779, 0x00E3, 0xFF9D, 0x067F,
0x0253, 0x07A0, 0x067E, 0x0028, 0x0F1C, 0x01F8, 0x1422, 0x0450,
0x10FB, 0xFE08, 0x0291, 0xFBE6, 0xF77B, 0xFD11, 0xF6FF, 0xFEA0,
0xF210, 0xFF66, 0xF125, 0x016A, 0xFC4F, 0x0782, 0x0180, 0x02C5,
0x000B, 0xF79E, 0xFC83, 0xF6E7, 0xFE70, 0xFC00, 0x0827, 0x03A0,
0x06E0, 0x0568, 0x0424, 0x019A, 0x08B5, 0x067A, 0x0AE9, 0x096E,
0x0961, 0x010E, 0xFE00, 0xF9F1, 0xF80F, 0xF922, 0xFC01, 0xF984,
0xF6D3, 0xFA59, 0xF623, 0xFFEA, 0xFECE, 0x0891, 0x0098, 0x05D8,
0xFD83, 0xFA2B, 0xF816, 0xF8C0, 0xF5F5, 0xFFE7, 0xFE6B, 0x0783,
0x0448, 0x07F9, 0x04F8, 0xFFD8, 0x0B2D, 0xFFD3, 0x10F8, 0x03B9,
0x0D7C, 0xFE3A, 0xFF57, 0xFA37, 0xF5FB, 0xFB19, 0xF8DE, 0xFC53,
0xF5AA, 0xFDBF, 0xF2F5, 0xFFDC, 0xF9AA, 0x0693, 0xFDC1, 0x06B9,
0xFFA6, 0xFCA7, 0xFBE2, 0xF6BB, 0xF960, 0xF90B, 0x0313, 0x01ED,
0x05D8, 0x04D9, 0x0239, 0xFF63, 0x08D7, 0x03E5, 0x0F90, 0x0ACF,
0x0BDD, 0x0485, 0x004F, 0xFC7C, 0xF874, 0xF9DD, 0xF9A5, 0xF9A4,
0xF720, 0xF9EF, 0xF4EF, 0xFA91, 0xFC00, 0x0158, 0xFE38, 0x042C,
0xFBFC, 0xFCB4, 0xF9C4, 0xF959, 0xF703, 0xFDAA, 0xFF96, 0x07A1,
0x0747, 0x0CFE, 0x07A8, 0x0429, 0x0CBE, 0xFE7F, 0x0F6E, 0x00CE,
0x0E3D, 0xFD6A, 0x0450, 0xF9E7, 0xF7C1, 0xFA6A, 0xF672, 0xFA36,
0xF1A0, 0xFA65, 0xEFD7, 0xFDD4, 0xF9B4, 0x060A, 0xFF6D, 0x0883,
0x0331, 0x01C4, 0x0385, 0xFD1F, 0xFDA0, 0xFABE, 0x010C, 0xFE73,
0x0742, 0x0685, 0x038F, 0x0299, 0x03B9, 0xFFAA, 0x0914, 0x0465,
0x07A5, 0xFEE2, 0xFF31, 0xF9A5, 0xF8B5, 0xFBDF, 0xFC16, 0xFE2F,
0xFE13, 0x00EF, 0xFCEB, 0x0227, 0x008E, 0x05EA, 0xFEA1, 0x0450,
0xFC7B, 0xF9B9, 0xFBF6, 0xF77B, 0xF6D1, 0xFB57, 0xFCB1, 0x0162,
0x03F6, 0x06B8, 0x01EE, 0x02C5, 0x083D, 0x03C6, 0x1268, 0x0856,
0x131C, 0x0202, 0x0943, 0xFCB7, 0xFC0B, 0xFC9B, 0xF7E2, 0xFAD0,
0xF7AA, 0xF880, 0xF44A, 0xF9F9, 0xF74C, 0x042C, 0xFC2F, 0x0A28,
0xFB13, 0x00BB, 0xFAE5, 0xF8BB, 0xFB4F, 0xFAC4, 0x0355, 0x0191,
0x0DA1, 0x08A3, 0x0AFB, 0x06EF, 0x0B47, 0x0520, 0x0EC7, 0x097F,
0x0B24, 0x03AC, 0x0200, 0xF92A, 0xF600, 0xF8C0, 0xF556, 0xFBDD,
0xF5F0, 0xFB0C, 0xF168, 0xF899, 0xFA56, 0xFEB2, 0x0586, 0x09B0,
0x0734, 0x0729, 0x03E1, 0xFF4F, 0xFDBD, 0x0030, 0xFFE4, 0x0466,
0x0591, 0x078D, 0x0275, 0x00B7, 0x01FE, 0xF9E9, 0x08A7, 0x01CD,
0x0AA2, 0x00E9, 0x0338, 0xF793, 0xF9F7, 0xFA0D, 0xFAD3, 0xFDB1,
0xFD36, 0xFEF2, 0xF787, 0xFF30, 0xF807, 0x027D, 0xFF24, 0x0A0C,
0x0217, 0x054C, 0x0071, 0xFD4C, 0xFE10, 0xFAB9, 0x02E6, 0xFCE2,
0x07A3, 0x0685, 0x0161, 0x03DB, 0xFDC7, 0xFD3C, 0x04EF, 0x03BA,
0x09C7, 0x03CD, 0x046A, 0xFEA9, 0xFB0C, 0xFE0C, 0xF9DD, 0xFD25,
0xFF11, 0xFD91, 0xFB9D, 0xFA9D, 0xF750, 0xFC82, 0xFD63, 0x0559,
0xFEEE, 0x0186, 0xF889, 0xFAFE, 0xF52B, 0xFB4E, 0xFBD6, 0xFF46,
0x08F4, 0x0906, 0x0A17, 0x09EB, 0x0625, 0x02EC, 0x0A92, 0x0188,
0x0BB6, 0xFF0A, 0x060B, 0xFA36, 0xFA42, 0xF84B, 0xF291, 0xF8FB,
0xF495, 0xFB31, 0xF12A, 0xFB12, 0xF2AC, 0xFFA3, 0xFF93, 0x0A49,
0x05B1, 0x0941, 0x045A, 0x0142, 0x0145, 0xFDEF, 0x02E7, 0xFCC2,
0x0955, 0x0100, 0x062A, 0x0331, 0x002D, 0x004F, 0x01D1, 0x0039,
0x0217, 0xFD6C, 0xFDEF, 0xF93D, 0xF714, 0xF983, 0xF6C5, 0xFDBD,
0xFD5A, 0x015A, 0xFC6E, 0xFDCC, 0xFB58, 0xFE96, 0x0074, 0x06E3,
0x0346, 0x05C4, 0x019F, 0xFECA, 0xFD92, 0xFCA5, 0xFDEB, 0xFF10,
0x01B8, 0x0310, 0xFFAF, 0x0258, 0xFCBF, 0xFFF9, 0x01BB, 0x0106,
0x06EB, 0xFF97, 0x02D1, 0xFC0A, 0xFAE9, 0xFBC2, 0xFAEF, 0xFB84,
0xFF3A, 0xFB05, 0xFC57, 0xFC38, 0xF8E0, 0xFF2D, 0xFCB4, 0x06BF,
0xFFDB, 0x095A, 0xFBEC, 0xFFF4, 0xF832, 0xFA50, 0xFD52, 0xFF03,
0x0738, 0x035C, 0x0AAB, 0x048D, 0x0640, 0x023D, 0x0460, 0xFDEA,
0x055E, 0xFACF, 0xFFF3, 0xF742, 0xF7AB, 0xFAF5, 0xF6DA, 0x0278,
0xFBB0, 0x018F, 0xFC22, 0xFEC1, 0xF8F4, 0xFDAD, 0xFDE8, 0x005E,
0x0630, 0x04C1, 0x05A4, 0x0216, 0x001E, 0xFFE4, 0xFC5E, 0xFF3F,
0x002B, 0x001E, 0x03DD, 0x04C0, 0xFF22, 0x0088, 0xFE2A, 0xFE77,
0x02FF, 0x0010, 0x032E, 0xF6B8, 0xFCA9, 0xF6DB, 0xFA90, 0xFEC9,
0x0030, 0xFDD1, 0x0065, 0xFD93, 0xFB60, 0x014E, 0xFBEF, 0x07CC,
0x01FD, 0x08A9, 0x0386, 0x0184, 0x00B2, 0xFE04, 0xFFEB, 0xFC5A,
0x00C3, 0xFDE6, 0x0203, 0x02EB, 0xFF5F, 0x020B, 0xFFF9, 0x0203,
0x0512, 0x02B5, 0x01B5, 0xFA78, 0xFC97, 0xF6F9, 0xFC2C, 0xFE1E,
0xFE6F, 0x00E9, 0x0152, 0xFD87, 0xFFD3, 0xFC28, 0xFEA1, 0x01D9,
0xFE1E, 0x065C, 0xFB5A, 0x007D, 0xFA40, 0xFEAA, 0xFCDE, 0x02DF,
0x050B, 0x02FE, 0x09D3, 0x0448, 0x04E1, 0x018E, 0x0208, 0xFE3F,
0x04BE, 0x017B, 0x0342, 0xFC7A, 0xFE81, 0xF847, 0xFF87, 0x00B4,
0x0168, 0x042C, 0xFE0F, 0xFF37, 0xFB20, 0xFD46, 0xFEB0, 0x03ED,
0x03FF, 0x09C2, 0x01C2, 0x035E, 0xFE0C, 0xFD88, 0xFD55, 0xFCA5,
0xFED1, 0xFB07, 0x01A1, 0xFF4E, 0x0115, 0x0161, 0x03E9, 0x0199,
0x084D, 0x05BF, 0x068D, 0x001D, 0x01D2, 0xFC5F, 0x0045, 0x03AE,
0x048B, 0x07BE, 0x0426, 0x063E, 0xFFC9, 0x0080, 0xFFF1, 0xFFB5,
0x01D2, 0x02CC, 0x005D, 0xFF20, 0xFA53, 0xFD79, 0xF9EB, 0xFE64,
0xFFA0, 0xFEC4, 0xFFBC, 0xFE5D, 0xFA31, 0xFA86, 0xFA19, 0xFEC5,
0x035B, 0x0587, 0x08CA, 0x01DA, 0x06AB, 0xFE9C, 0x0628, 0x02E2,
0x0951, 0x0827, 0x09DF, 0x067D, 0x0488, 0x022E, 0x00CE, 0x03F9,
0xFE19, 0x0640, 0xF8CF, 0x00DE, 0xF6A5, 0xFBBB, 0xFA6A, 0x0066,
0x0258, 0x048E, 0x05C7, 0x01E2, 0x012D, 0xFF4F, 0xFE0B, 0xFBA7,
0x00ED, 0xF8F1, 0x0172, 0xF785, 0xFA02, 0xF4CE, 0xF71F, 0xFC22,
0xFD65, 0x07C0, 0x01D0, 0x07F5, 0x038E, 0x03A0, 0x0488, 0x0559,
0x0660, 0x0CC3, 0x0993, 0x0CFE, 0x08D9, 0x026A, 0x03A4, 0xFDFB,
0xFF33, 0xFFD0, 0xFEBA, 0xFDBF, 0xFC18, 0xFCDF, 0xF95D, 0xFF1D,
0xFF9F, 0x023A, 0x03DE, 0xFFB7, 0xFD71, 0xF57D, 0xFB51, 0xF6B9,
0x01A0, 0x0323, 0x0223, 0x0576, 0xFDC7, 0x0121, 0xFB83, 0x00C0,
0xFBE6, 0x03EB, 0xFDC3, 0x0439, 0xFD40, 0xFF1E, 0x0019, 0xFF86,
0x064C, 0x0492, 0x0858, 0x0432, 0x0540, 0xFECC, 0xFD7C, 0xFBF7,
0xFB08, 0x0088, 0xFCD7, 0x033A, 0xFB46, 0xFF42, 0x00B3, 0xFFA5,
0x08BB, 0x047C, 0x06C9, 0x028B, 0x01ED, 0xFD09, 0x0004, 0xFBB2,
0xFE45, 0xFF50, 0xF8EC, 0x01ED, 0xF291, 0xFCB5, 0xF36F, 0xFB36,
0xF9F3, 0x00EA, 0x020F, 0x03E2, 0x05CA, 0x0502, 0x0418, 0x01BF,
0x0B63, 0x025E, 0x10B6, 0x057D, 0x03B5, 0xFBFD, 0xFA74, 0xF803,
0xFCE4, 0xFE5B, 0xFB56, 0x0104, 0xF76C, 0xFEF0, 0xF94C, 0xFBBF,
0x0062, 0x0194, 0x017F, 0x05F8, 0xFCA9, 0x0188, 0xFFBB, 0xFF57,
0x04B4, 0xFFAD, 0x01B5, 0x01B1, 0xFA68, 0xFE24, 0xF85D, 0xF792,
0xFF03, 0xFAE5, 0x017F, 0xFFB1, 0xFDEE, 0xFCDA, 0x01B5, 0xFDF2,
0x0A20, 0x08CF, 0x08B1, 0x0B8D, 0x00CD, 0x03BF, 0xFE05, 0xFF59,
0xFF00, 0xFF00, 0xFF32, 0xFED3, 0xFD79, 0xFDC8, 0xFDF3, 0xFBDB,
0x0047, 0xFA36, 0xFF28, 0xFE05, 0xFB38, 0xFFD0, 0xF6C0, 0xFD2D,
0xF880, 0x017D, 0xFEEC, 0x03F6, 0x01D9, 0xFF11, 0x05A6, 0xFC4F,
0x0BEB, 0x0190, 0x0F41, 0x069B, 0x0CBA, 0x036D, 0x054B, 0x00CA,
0xFE1A, 0xFFAD, 0xF7BB, 0xFF64, 0xF13F, 0xFDF5, 0xF1D5, 0xFA63,
0xFC4E, 0xFEBD, 0x03F3, 0x0468, 0x02DF, 0x024F, 0x0220, 0xFD14,
0x03F2, 0xFB5D, 0x0471, 0xFDFA, 0xFE80, 0xFCFB, 0xF8D3, 0xFC41,
0xFEF0, 0x0196, 0x0327, 0x03D4, 0x0090, 0x004E, 0x01C6, 0x0003,
0x062F, 0x060D, 0x0A74, 0x0A5F, 0x06EC, 0x07BE, 0x00F0, 0x0248,
0x000B, 0xFDD3, 0xFC3A, 0xFB5E, 0xF784, 0xFD44, 0xF702, 0xFEB1,
0xFAEA, 0xFCF1, 0x0249, 0xFEF5, 0x0337, 0xFC73, 0xFD14, 0xF599,
0x0024, 0xFB80, 0x04D1, 0x0580, 0xFE6F, 0x0540, 0xFCB7, 0xFEC4,
0x019C, 0xFD24, 0x04EA, 0x039F, 0x03E6, 0x07BC, 0x0371, 0x06CF,
0x0DB1, 0x0717, 0x0F15, 0x0590, 0xFFFD, 0xFF24, 0xF553, 0xF981,
0xF329, 0xF929, 0xF7F0, 0xFF88, 0xFBD8, 0x00D3, 0xFCC6, 0xFACF,
0x0607, 0xFED6, 0x0AD0, 0x0382, 0x0493, 0x0000, 0x0135, 0xFCB7,
0xFE67, 0xFC46, 0xFB13, 0x01B6, 0xF9C7, 0x020A, 0xFC9D, 0xFD8D,
0x053A, 0x022E, 0x06EE, 0x08F5, 0x0494, 0x0A34, 0x0781, 0x06AE,
0x06D9, 0x018A, 0x0367, 0xFF25, 0xFEEF, 0xFD00, 0xF761, 0xF918,
0xF955, 0xFAC1, 0x01FF, 0x0054, 0x011C, 0xFFC8, 0xFB98, 0xFAF4,
0xFAB2, 0xFB1F, 0xFD27, 0x01EB, 0xFCD6, 0x0313, 0xFBE4, 0x0120,
0x00FB, 0x040A, 0x04DF, 0x01FF, 0x0378, 0xFF67, 0xFF85, 0x0082,
0xFE90, 0x0192, 0x049B, 0x04FB, 0x05ED, 0x03C1, 0x0051, 0xFCBF,
0xFF68, 0xFD07, 0x0158, 0x044A, 0xFE7F, 0x03B6, 0xFC22, 0xFD99,
0x0020, 0xFC7A, 0x020B, 0xFE51, 0xFD20, 0xFE11, 0xF826, 0xFBC0,
0xFA2E, 0xFC92, 0xFFB2, 0xFE71, 0xFB97, 0xFECE, 0xF3E1, 0xFE51,
0xF730, 0xFD5F, 0x0091, 0x0216, 0x082E, 0x05B8, 0x0950, 0x022D,
0x0AA3, 0x02F4, 0x1053, 0x06C1, 0x0A58, 0x018D, 0xFD68, 0xFA5A,
0xF694, 0xFBB8, 0xF4AF, 0x005E, 0xF7D5, 0x01DC, 0xFA1E, 0xFE45,
0xFD2C, 0xFDE5, 0x0358, 0x0293, 0x012D, 0xFFA8, 0xF98A, 0xF84D,
0xF852, 0xF70B, 0xFB93, 0xFD7E, 0xFC25, 0x00A8, 0xF924, 0xFB19,
0xFCB4, 0xFDC5, 0x07A5, 0x0880, 0x0A06, 0x0B36, 0x0876, 0x04D2,
0x0B12, 0x00B4, 0x0783, 0x0329, 0xFF8C, 0x02AC, 0xFA50, 0xFE7C,
0xF9ED, 0xFD25, 0xFC09, 0xFF65, 0xF953, 0xFD5A, 0xF448, 0xF90D,
0xF242, 0xFA7B, 0xF3D3, 0xFB87, 0xF8F0, 0xFB5C, 0xFDB1, 0xF77C,
0x0085, 0xF84B, 0x0373, 0x03A9, 0x043F, 0x0409, 0x03BE, 0xFE5F,
0x04C6, 0xFFDB, 0x044B, 0x03FE, 0x033D, 0x07A5, 0x049D, 0x0649,
0x03FF, 0x0275, 0x014D, 0x00DF, 0xFC9A, 0x0036, 0xF45C, 0xFC40,
0xF327, 0xF831, 0xF899, 0xFA0F, 0xFB20, 0xFED9, 0xFB09, 0xFC4A,
0xFCCC, 0xF7B9, 0x0486, 0xFE23, 0x04E3, 0x0052, 0xFCBE, 0xFC7B,
0xFBEF, 0xFBE7, 0xFE4B, 0xFB59, 0x00DE, 0x00E5, 0x01B7, 0x045A,
0x0319, 0x04F2, 0x0A28, 0x0A0B, 0x09B3, 0x093A, 0x00CE, 0x022E,
0xFAD7, 0xFC6F, 0xFA0F, 0xFD67, 0xFA24, 0xFF4E, 0xF775, 0xF9B5,
0xFA1A, 0xF737, 0x02A5, 0xFD68, 0x038E, 0x001A, 0xFD4B, 0xFBC2,
0xFACD, 0xF951, 0xFCFE, 0xFC48, 0xFDAE, 0x035E, 0xFB8A, 0x04ED,
0xFF31, 0xFFA4, 0x08AA, 0x025D, 0x0A48, 0x072F, 0x0453, 0x0457,
0x00B4, 0x00CA, 0x01C6, 0x008A, 0x02E9, 0xFFF4, 0xFE3A, 0xFC26,
0xFAC8, 0xFC01, 0xFE7A, 0x0206, 0x0245, 0x0503, 0x0200, 0x0046,
0xFF71, 0xFC2D, 0xFF6C, 0xFD0A, 0xFEAF, 0xFD67, 0xFCA0, 0xFB39,
0xFE20, 0xF849, 0xFCDF, 0xFBB5, 0xFB0A, 0xFF2F, 0xFABA, 0xFBF0,
0xFB42, 0xFD90, 0x004E, 0x060D, 0x04F9, 0x0DAB, 0x0BBE, 0x09CE,
0x10AE, 0x0177, 0x0E1D, 0x01B1, 0x0A5A, 0x0154, 0x0490, 0xFD90,
0xFC5C, 0xFABE, 0xF5A0, 0xF9A8, 0xF6BE, 0xFBD4, 0xFAD7, 0x00C7,
0xFB8A, 0x01F0, 0xFF4B, 0xFF72, 0x01E4, 0xFF1A, 0xFEBA, 0xFBD1,
0xFBD8, 0xF8A6, 0xFCC6, 0xFB2A, 0x0005, 0x00AD, 0x0386, 0x033E,
0x05B3, 0x034D, 0x08F3, 0x0A28, 0x0E9A, 0x0DB0, 0x0E9D, 0x0525,
0x08A0, 0xFBC9, 0x024A, 0xFB5A, 0xFCEE, 0x0082, 0xF92D, 0x0130,
0xF9C3, 0xFE51, 0x0076, 0xFEE8, 0x023D, 0x0248, 0xFA9A, 0xFFDC,
0xF563, 0xF9E8, 0xF7AF, 0xF74D, 0xFA6B, 0xF96A, 0xF9C1, 0xFEA8,
0xFE18, 0xFCAB, 0x0799, 0xFDAF, 0x0B99, 0x0A77, 0x0AAB, 0x0ECB,
0x0AAB, 0x0801, 0x0B8A, 0x0404, 0x099E, 0x049A, 0x0410, 0x0202,
0xFFF6, 0xFE76, 0xFF2B, 0x0187, 0xFED6, 0x02A0, 0xFA8D, 0xFC61,
0xF5C1, 0xF83D, 0xF8B7, 0xFA44, 0xFAFC, 0xFEE8, 0xF9D6, 0x0104,
0xFD9E, 0xFBAA, 0x0229, 0xFAF8, 0x0366, 0x044A, 0x0297, 0x04A5,
0x0435, 0x0018, 0x06AF, 0x03E6, 0x059A, 0x08C2, 0x087A, 0x0905,
0x0CDA, 0x0588, 0x0A74, 0x01DA, 0x0340, 0xFF90, 0xFB28, 0xFE96,
0xF7A0, 0xFF04, 0xF798, 0xFF23, 0xF8A7, 0xFF0E, 0xFCE6, 0xFFE9,
0x0086, 0x0024, 0x0153, 0xFF58, 0x02B1, 0xFEC9, 0x0406, 0xFA24,
0x00F5, 0xF6A1, 0xF996, 0xFAED, 0xF719, 0xFEE5, 0xFF18, 0x02FB,
0x07B5, 0x0943, 0x0B73, 0x0E3E, 0x1064, 0x0E15, 0x11B6, 0x05D0,
0x07F6, 0xFC1A, 0xFBDF, 0xF5F6, 0xF7BE, 0xF7A3, 0xF833, 0xFE0A,
0xF961, 0xFF79, 0xFE18, 0x0077, 0x00A5, 0x0501, 0xFF71, 0x057B,
0xFFC9, 0x00B5, 0xFF50, 0xFCA0, 0xFE20, 0xF86B, 0xFB9B, 0xF7C0,
0xFA7B, 0xFB18, 0xFE84, 0xFD5F, 0x0338, 0x0356, 0x04C4, 0x0851,
0x0435, 0x0890, 0x08CD, 0x07CF, 0x0B16, 0x06A3, 0x038C, 0x03F6,
0xFFF8, 0xFB2B, 0x0146, 0xF9AF, 0x002D, 0x0346, 0xFE9E, 0x0245,
0xFE50, 0xFA36, 0xFD92, 0xFA86, 0xF9C3, 0xFE67, 0xF773, 0xFF61,
0xFBBF, 0xFD49, 0xFF90, 0xFB21, 0xFD58, 0xFE4F, 0xFB42, 0x0006,
0xFC4C, 0xFB63, 0x00AA, 0xFAE6, 0x0566, 0x03C4, 0x07F4, 0x0C0A,
0x0BDE, 0x0929, 0x0C07, 0x0537, 0x0768, 0x04E6, 0x0253, 0xFF67,
0xFD71, 0xFB68, 0xFB2B, 0xFD27, 0xFA61, 0xFD9B, 0xFA3E, 0xFB5C,
0xFC28, 0xF9DF, 0x0003, 0xFBFB, 0xFFB2, 0xFFB3, 0xFA86, 0xFD9A,
0xF57E, 0xF838, 0xEFC6, 0xF808, 0xF0EC, 0xFB9B, 0xFBD3, 0xFFFB,
0x0759, 0x0330, 0x0EEC, 0x08AA, 0x1288, 0x0ECB, 0x14A4, 0x0CAB,
0x107E, 0x050C, 0x04A8, 0xFB31, 0xFB7B, 0xF565, 0xF83E, 0xF8E3,
0xF8AD, 0xFE10, 0xFA22, 0xFFA1, 0xFADF, 0xFFA1, 0xFC37, 0xFF63,
0xFAF4, 0xFD53, 0xF7E7, 0xFB36, 0xF77C, 0xF99E, 0xF798, 0xF9FF,
0xF85D, 0xFB1D, 0xFBA9, 0xFAEC, 0x03AF, 0x000E, 0x0CB6, 0x06DE,
0x0E5B, 0x0AFC, 0x0D9E, 0x0DA2, 0x0E0B, 0x0AAC, 0x076B, 0x01B7,
0xFDE3, 0xF81D, 0xFD80, 0xF67A, 0xFF7F, 0xFCC2, 0xFB5C, 0x0062,
0xF80B, 0xFD75, 0xF829, 0xFBA3, 0xF784, 0xFD8F, 0xF62A, 0xFFC7,
0xF919, 0x006C, 0xFDAA, 0xFE61, 0xFBE7, 0xFED3, 0xFA09, 0xFC56,
0xFF34, 0xF610, 0x0761, 0xF9EC, 0x0AF4, 0x02EC, 0x098A, 0x0A00,
0x0E03, 0x0C88, 0x1431, 0x0AA1, 0x0C97, 0x08CC, 0xFF9F, 0x0048,
0xF98D, 0xF79D, 0xF4A4, 0xF89E, 0xF324, 0xFBCC, 0xF862, 0xFCA1,
0xFBE2, 0xFA9B, 0xFD6B, 0xFBFD, 0xFEFB, 0x05A6, 0x0016, 0x08B0,
0xFFD8, 0xFF7F, 0xFC06, 0xFAF1, 0xF9E6, 0xFBAE, 0xFCB3, 0xF8B7,
0x03FA, 0xF7C2, 0x096E, 0x00E3, 0x0B38, 0x0F48, 0x10D2, 0x118A,
0x0E04, 0x08C5, 0x003F, 0x02F2, 0xF8B4, 0xFF5E, 0xF828, 0xFE63,
0xF9ED, 0x0056, 0xFFC2, 0x0003, 0x0655, 0x0060, 0x04D8, 0xFFB4,
0xFF5C, 0xF9FC, 0xFBFF, 0xF970, 0xF8F7, 0xFAAA, 0xF634, 0xF8BB,
0xF323, 0xFB2C, 0xF64B, 0xFA78, 0xFF8F, 0xFB45, 0x06A0, 0x0534,
0x0A9C, 0x0D57, 0x0C74, 0x0FE6, 0x0E8F, 0x0CFE, 0x0BFA, 0x082D,
0x016A, 0x0062, 0xF88A, 0xF6CA, 0xF7CB, 0xF983, 0xFBAE, 0x0217,
0xFEEC, 0xFF79, 0x01B2, 0xF947, 0x01B6, 0xF907, 0xFB9D, 0xFA7A,
0xF7E9, 0xFC5E, 0xFD71, 0xFC33, 0xFEDE, 0xFD37, 0xF666, 0xFE69,
0xF28E, 0xF9F7, 0xF7DB, 0xFC00, 0x00D7, 0x03E5, 0x071D, 0x0BF0,
0x0C70, 0x115B, 0x15C0, 0x0D24, 0x14BC, 0x081A, 0x059C, 0x0086,
0xFA4B, 0xF5E9, 0xF95C, 0xF55F, 0xFD11, 0xFAC5, 0xFC84, 0xFBBB,
0xF9AF, 0xF973, 0xFB4D, 0xFC0B, 0xF9AA, 0x021C, 0xF608, 0x018B,
0xF6EA, 0xFAF8, 0xF5F7, 0xF96B, 0xF276, 0xFAEE, 0xF33F, 0xFA0E,
0xFCF8, 0xFCB3, 0x08E7, 0x0420, 0x102C, 0x10D9, 0x174B, 0x1728,
0x17E0, 0x0C43, 0x0B45, 0x00A4, 0xFE18, 0xFB5E, 0xF8D2, 0xF47F,
0xF512, 0xF124, 0xF648, 0xF897, 0xFFA1, 0x018F, 0x01AE, 0x0190,
0xFA06, 0xFD32, 0xF286, 0xFF50, 0xF353, 0x02ED, 0xFACA, 0xFF64,
0xF8BD, 0xFDEC, 0xF306, 0xFC42, 0xFA2D, 0xFAB1, 0x0762, 0x0036,
0x0C4D, 0x0223, 0x0C71, 0x03DB, 0x137C, 0x0807, 0x13E4, 0x0539,
0x0390, 0xFDE7, 0xF77A, 0xF9B1, 0xF71C, 0xFE3D, 0xF79D, 0x04D5,
0xF9CE, 0x0352, 0xFB46, 0xFE00, 0xF9E0, 0xFB7B, 0xFAA5, 0xFBB3,
0xF8DF, 0xFBDB, 0xFA99, 0xF6E9, 0xFF1A, 0xF7A9, 0xF992, 0x0297,
0xF648, 0x0071, 0xFC4A, 0xF8CB, 0x04C0, 0xFF6E, 0x0994, 0x0917,
0x0CD7, 0x0B13, 0x146F, 0x06B4, 0x1168, 0x0419, 0x0383, 0x012F,
0xF8E8, 0xFA46, 0xF211, 0xF7AA, 0xF18B, 0xFCC5, 0xF5BC, 0x04C9,
0xFA36, 0x05AF, 0xFEE0, 0xFF2B, 0x0153, 0xFDB1, 0xFEFB, 0xFFD0,
0xFE31, 0xF6A1, 0xFF37, 0xEFED, 0xF89A, 0xF7D9, 0xF277, 0xF93D,
0xF6A3, 0xF8B1, 0x0166, 0x01B4, 0x0A21, 0x0E72, 0x0E19, 0x179B,
0x11F0, 0x10C2, 0x0E9E, 0x034F, 0x01E3, 0xFA35, 0xF7D7, 0xF60B,
0xF52A, 0xFA28, 0xF823, 0xFDAB, 0xFEC9, 0x00BB, 0x0200, 0x0565,
0xFFD6, 0xFF5A, 0xFCDE, 0xF800, 0xFA86, 0xF8F2, 0xFBF1, 0xF663,
0xF90D, 0xF6A4, 0xF2D9, 0xFC1B, 0xF893, 0xFF2F, 0x0298, 0x031C,
0x07D6, 0x0662, 0x0856, 0x0E13, 0x0D76, 0x1354, 0x17E4, 0x0C41,
0x0EEB, 0x0238, 0xFC0A, 0xF892, 0xF93E, 0xF7FF, 0xFBC2, 0xFF11,
0xF9D6, 0xFD44, 0xFB79, 0xF8B7, 0x010B, 0xFA99, 0x015C, 0xFA96,
0xF906, 0xF971, 0xF42B, 0xFAAC, 0xF9A0, 0xFBC5, 0xFC05, 0x0278,
0xF6C2, 0x059F, 0xF658, 0xFFD3, 0x0171, 0xFF35, 0x0C65, 0x0758,
0x0E6F, 0x1180, 0x147F, 0x1088, 0x1ADD, 0x08B6, 0x0F0F, 0x0355,
0xFEAD, 0xFA31, 0xF8D4, 0xF333, 0xF56D, 0xF6BC, 0xF71D, 0xFD90,
0xFD2D, 0xFE14, 0xFD62, 0xFB8B, 0xFD97, 0xFBE6, 0xFDF6, 0x029A,
0xFB41, 0x0353, 0xF8DD, 0xF7DA, 0xF51A, 0xFB4F, 0xF4B4, 0x0452,
0xFB15, 0x00E9, 0x0426, 0x0241, 0x0B5E, 0x0AF0, 0x1026, 0x1574,
0x189C, 0x129A, 0x1B86, 0x00CB, 0x0CB2, 0xF4F5, 0xFC27, 0xF134,
0xF338, 0xF41A, 0xEF44, 0xFC09, 0xF6C8, 0x0233, 0xFDAE, 0x06B6,
0xFDED, 0x0684, 0xFE9F, 0x023B, 0xFA25, 0x0241, 0xF906, 0xFD0F,
0xFB11, 0xF551, 0xF7AF, 0xFAB3, 0xF794, 0xFCDB, 0xFC0F, 0xFD31,
0x04F7, 0x0635, 0x0CF6, 0x0C01, 0x1309, 0x1180, 0x1C17, 0x10EC,
0x17D2, 0x0438, 0x04E7, 0xF791, 0xF71B, 0xF295, 0xF3BF, 0xF87C,
0xF44A, 0xFE23, 0xF6A2, 0xFCA5, 0xFB05, 0xFF3A, 0xFDC1, 0x02AA,
0xFD40, 0x02F3, 0xFA00, 0x04C0, 0xFBEC, 0xFF85, 0xFF5F, 0xFA91,
0xF821, 0xFB9F, 0xF41A, 0xF522, 0xFCF2, 0xF4BB, 0x08F1, 0xFFA9,
0x0CB8, 0x0967, 0x0C67, 0x1280, 0x16EA, 0x1446, 0x193B, 0x0C0F,
0x04E3, 0xFE7F, 0xF566, 0xF535, 0xF52F, 0xF9C0, 0xF84E, 0xFE8E,
0xFBE1, 0xFBCF, 0xFCA5, 0xFCD4, 0xFD02, 0xFF5C, 0xFE4C, 0x0248,
0xF9F9, 0x049E, 0xF80C, 0xF910, 0xF877, 0xF1A2, 0xF54E, 0xF927,
0xF66F, 0xF930, 0xFC56, 0xF7C3, 0x0706, 0x031D, 0x106F, 0x1477,
0x1517, 0x1A54, 0x18C7, 0x0FA8, 0x0E94, 0x033F, 0xFEB8, 0xF991,
0xF8CA, 0xF582, 0xF3CB, 0xFA0A, 0xF381, 0xFEA3, 0xFAF2, 0xFFE7,
0xFF32, 0x0119, 0xFEC2, 0xFD1E, 0xFCCE, 0xF9E7, 0xFCB6, 0xFE4E,
0xFC30, 0xF814, 0xF38A, 0xF2BF, 0xEC2D, 0xFB60, 0xF32C, 0xFE6D,
0x0072, 0x0015, 0x095B, 0x07C4, 0x0E62, 0x11B6, 0x1493, 0x16D7,
0x19FD, 0x0EFA, 0x10E7, 0x00A4, 0xFFB1, 0xF550, 0xF8BE, 0xF551,
0xF60D, 0xFD1B, 0xF640, 0xFD41, 0xF975, 0xF848, 0xFA17, 0xFB74,
0xFDC8, 0xFEB9, 0xFC2D, 0xFD87, 0xF6EB, 0xFCDD, 0xF882, 0xF76A,
0xF7AC, 0xF8CB, 0xF4A3, 0xFD03, 0xF66E, 0xF7DD, 0x012F, 0xFCED,
0x0DB6, 0x0BEF, 0x0F23, 0x1709, 0x10EE, 0x18A4, 0x1679, 0x0FD0,
0x0E4B, 0x01D0, 0xFEF6, 0xF073, 0xF8A8, 0xE9F8, 0xF876, 0xF3ED,
0xF92A, 0xF9F1, 0xF6B7, 0xF831, 0xF6A3, 0xFDA3, 0xFDB4, 0x063F
 };
 
/**
  * @}
  */ 

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
