// Generated by scripts/protocol-gen-swift.ts — do not edit by hand
import Foundation

public let GATEWAY_PROTOCOL_VERSION = 3

public enum ErrorCode: String, Codable, Sendable {
    case notLinked = "NOT_LINKED"
    case notPaired = "NOT_PAIRED"
    case agentTimeout = "AGENT_TIMEOUT"
    case invalidRequest = "INVALID_REQUEST"
    case unavailable = "UNAVAILABLE"
}

public struct ConnectParams: Codable, Sendable {
    public let minprotocol: Int
    public let maxprotocol: Int
    public let client: [String: AnyCodable]
    public let caps: [String]?
    public let commands: [String]?
    public let permissions: [String: AnyCodable]?
    public let pathenv: String?
    public let role: String?
    public let scopes: [String]?
    public let device: [String: AnyCodable]?
    public let auth: [String: AnyCodable]?
    public let locale: String?
    public let useragent: String?

    public init(
        minprotocol: Int,
        maxprotocol: Int,
        client: [String: AnyCodable],
        caps: [String]?,
        commands: [String]?,
        permissions: [String: AnyCodable]?,
        pathenv: String?,
        role: String?,
        scopes: [String]?,
        device: [String: AnyCodable]?,
        auth: [String: AnyCodable]?,
        locale: String?,
        useragent: String?
    ) {
        self.minprotocol = minprotocol
        self.maxprotocol = maxprotocol
        self.client = client
        self.caps = caps
        self.commands = commands
        self.permissions = permissions
        self.pathenv = pathenv
        self.role = role
        self.scopes = scopes
        self.device = device
        self.auth = auth
        self.locale = locale
        self.useragent = useragent
    }
    private enum CodingKeys: String, CodingKey {
        case minprotocol = "minProtocol"
        case maxprotocol = "maxProtocol"
        case client
        case caps
        case commands
        case permissions
        case pathenv = "pathEnv"
        case role
        case scopes
        case device
        case auth
        case locale
        case useragent = "userAgent"
    }
}

public struct HelloOk: Codable, Sendable {
    public let type: String
    public let _protocol: Int
    public let server: [String: AnyCodable]
    public let features: [String: AnyCodable]
    public let snapshot: Snapshot
    public let canvashosturl: String?
    public let auth: [String: AnyCodable]?
    public let policy: [String: AnyCodable]

    public init(
        type: String,
        _protocol: Int,
        server: [String: AnyCodable],
        features: [String: AnyCodable],
        snapshot: Snapshot,
        canvashosturl: String?,
        auth: [String: AnyCodable]?,
        policy: [String: AnyCodable]
    ) {
        self.type = type
        self._protocol = _protocol
        self.server = server
        self.features = features
        self.snapshot = snapshot
        self.canvashosturl = canvashosturl
        self.auth = auth
        self.policy = policy
    }
    private enum CodingKeys: String, CodingKey {
        case type
        case _protocol = "protocol"
        case server
        case features
        case snapshot
        case canvashosturl = "canvasHostUrl"
        case auth
        case policy
    }
}

public struct RequestFrame: Codable, Sendable {
    public let type: String
    public let id: String
    public let method: String
    public let params: AnyCodable?

    public init(
        type: String,
        id: String,
        method: String,
        params: AnyCodable?
    ) {
        self.type = type
        self.id = id
        self.method = method
        self.params = params
    }
    private enum CodingKeys: String, CodingKey {
        case type
        case id
        case method
        case params
    }
}

public struct ResponseFrame: Codable, Sendable {
    public let type: String
    public let id: String
    public let ok: Bool
    public let payload: AnyCodable?
    public let error: [String: AnyCodable]?

    public init(
        type: String,
        id: String,
        ok: Bool,
        payload: AnyCodable?,
        error: [String: AnyCodable]?
    ) {
        self.type = type
        self.id = id
        self.ok = ok
        self.payload = payload
        self.error = error
    }
    private enum CodingKeys: String, CodingKey {
        case type
        case id
        case ok
        case payload
        case error
    }
}

public struct EventFrame: Codable, Sendable {
    public let type: String
    public let event: String
    public let payload: AnyCodable?
    public let seq: Int?
    public let stateversion: [String: AnyCodable]?

    public init(
        type: String,
        event: String,
        payload: AnyCodable?,
        seq: Int?,
        stateversion: [String: AnyCodable]?
    ) {
        self.type = type
        self.event = event
        self.payload = payload
        self.seq = seq
        self.stateversion = stateversion
    }
    private enum CodingKeys: String, CodingKey {
        case type
        case event
        case payload
        case seq
        case stateversion = "stateVersion"
    }
}

public struct PresenceEntry: Codable, Sendable {
    public let host: String?
    public let ip: String?
    public let version: String?
    public let platform: String?
    public let devicefamily: String?
    public let modelidentifier: String?
    public let mode: String?
    public let lastinputseconds: Int?
    public let reason: String?
    public let tags: [String]?
    public let text: String?
    public let ts: Int
    public let deviceid: String?
    public let roles: [String]?
    public let scopes: [String]?
    public let instanceid: String?

    public init(
        host: String?,
        ip: String?,
        version: String?,
        platform: String?,
        devicefamily: String?,
        modelidentifier: String?,
        mode: String?,
        lastinputseconds: Int?,
        reason: String?,
        tags: [String]?,
        text: String?,
        ts: Int,
        deviceid: String?,
        roles: [String]?,
        scopes: [String]?,
        instanceid: String?
    ) {
        self.host = host
        self.ip = ip
        self.version = version
        self.platform = platform
        self.devicefamily = devicefamily
        self.modelidentifier = modelidentifier
        self.mode = mode
        self.lastinputseconds = lastinputseconds
        self.reason = reason
        self.tags = tags
        self.text = text
        self.ts = ts
        self.deviceid = deviceid
        self.roles = roles
        self.scopes = scopes
        self.instanceid = instanceid
    }
    private enum CodingKeys: String, CodingKey {
        case host
        case ip
        case version
        case platform
        case devicefamily = "deviceFamily"
        case modelidentifier = "modelIdentifier"
        case mode
        case lastinputseconds = "lastInputSeconds"
        case reason
        case tags
        case text
        case ts
        case deviceid = "deviceId"
        case roles
        case scopes
        case instanceid = "instanceId"
    }
}

public struct StateVersion: Codable, Sendable {
    public let presence: Int
    public let health: Int

    public init(
        presence: Int,
        health: Int
    ) {
        self.presence = presence
        self.health = health
    }
    private enum CodingKeys: String, CodingKey {
        case presence
        case health
    }
}

public struct Snapshot: Codable, Sendable {
    public let presence: [PresenceEntry]
    public let health: AnyCodable
    public let stateversion: StateVersion
    public let uptimems: Int
    public let configpath: String?
    public let statedir: String?
    public let sessiondefaults: [String: AnyCodable]?

    public init(
        presence: [PresenceEntry],
        health: AnyCodable,
        stateversion: StateVersion,
        uptimems: Int,
        configpath: String?,
        statedir: String?,
        sessiondefaults: [String: AnyCodable]?
    ) {
        self.presence = presence
        self.health = health
        self.stateversion = stateversion
        self.uptimems = uptimems
        self.configpath = configpath
        self.statedir = statedir
        self.sessiondefaults = sessiondefaults
    }
    private enum CodingKeys: String, CodingKey {
        case presence
        case health
        case stateversion = "stateVersion"
        case uptimems = "uptimeMs"
        case configpath = "configPath"
        case statedir = "stateDir"
        case sessiondefaults = "sessionDefaults"
    }
}

public struct ErrorShape: Codable, Sendable {
    public let code: String
    public let message: String
    public let details: AnyCodable?
    public let retryable: Bool?
    public let retryafterms: Int?

    public init(
        code: String,
        message: String,
        details: AnyCodable?,
        retryable: Bool?,
        retryafterms: Int?
    ) {
        self.code = code
        self.message = message
        self.details = details
        self.retryable = retryable
        self.retryafterms = retryafterms
    }
    private enum CodingKeys: String, CodingKey {
        case code
        case message
        case details
        case retryable
        case retryafterms = "retryAfterMs"
    }
}

public struct AgentEvent: Codable, Sendable {
    public let runid: String
    public let seq: Int
    public let stream: String
    public let ts: Int
    public let data: [String: AnyCodable]

    public init(
        runid: String,
        seq: Int,
        stream: String,
        ts: Int,
        data: [String: AnyCodable]
    ) {
        self.runid = runid
        self.seq = seq
        self.stream = stream
        self.ts = ts
        self.data = data
    }
    private enum CodingKeys: String, CodingKey {
        case runid = "runId"
        case seq
        case stream
        case ts
        case data
    }
}

public struct SendParams: Codable, Sendable {
    public let to: String
    public let message: String
    public let mediaurl: String?
    public let mediaurls: [String]?
    public let gifplayback: Bool?
    public let channel: String?
    public let accountid: String?
    public let sessionkey: String?
    public let idempotencykey: String

    public init(
        to: String,
        message: String,
        mediaurl: String?,
        mediaurls: [String]?,
        gifplayback: Bool?,
        channel: String?,
        accountid: String?,
        sessionkey: String?,
        idempotencykey: String
    ) {
        self.to = to
        self.message = message
        self.mediaurl = mediaurl
        self.mediaurls = mediaurls
        self.gifplayback = gifplayback
        self.channel = channel
        self.accountid = accountid
        self.sessionkey = sessionkey
        self.idempotencykey = idempotencykey
    }
    private enum CodingKeys: String, CodingKey {
        case to
        case message
        case mediaurl = "mediaUrl"
        case mediaurls = "mediaUrls"
        case gifplayback = "gifPlayback"
        case channel
        case accountid = "accountId"
        case sessionkey = "sessionKey"
        case idempotencykey = "idempotencyKey"
    }
}

public struct PollParams: Codable, Sendable {
    public let to: String
    public let question: String
    public let options: [String]
    public let maxselections: Int?
    public let durationhours: Int?
    public let channel: String?
    public let accountid: String?
    public let idempotencykey: String

    public init(
        to: String,
        question: String,
        options: [String],
        maxselections: Int?,
        durationhours: Int?,
        channel: String?,
        accountid: String?,
        idempotencykey: String
    ) {
        self.to = to
        self.question = question
        self.options = options
        self.maxselections = maxselections
        self.durationhours = durationhours
        self.channel = channel
        self.accountid = accountid
        self.idempotencykey = idempotencykey
    }
    private enum CodingKeys: String, CodingKey {
        case to
        case question
        case options
        case maxselections = "maxSelections"
        case durationhours = "durationHours"
        case channel
        case accountid = "accountId"
        case idempotencykey = "idempotencyKey"
    }
}

public struct AgentParams: Codable, Sendable {
    public let message: String
    public let agentid: String?
    public let to: String?
    public let replyto: String?
    public let sessionid: String?
    public let sessionkey: String?
    public let thinking: String?
    public let deliver: Bool?
    public let attachments: [AnyCodable]?
    public let channel: String?
    public let replychannel: String?
    public let accountid: String?
    public let replyaccountid: String?
    public let threadid: String?
    public let groupid: String?
    public let groupchannel: String?
    public let groupspace: String?
    public let timeout: Int?
    public let lane: String?
    public let extrasystemprompt: String?
    public let idempotencykey: String
    public let label: String?
    public let spawnedby: String?

    public init(
        message: String,
        agentid: String?,
        to: String?,
        replyto: String?,
        sessionid: String?,
        sessionkey: String?,
        thinking: String?,
        deliver: Bool?,
        attachments: [AnyCodable]?,
        channel: String?,
        replychannel: String?,
        accountid: String?,
        replyaccountid: String?,
        threadid: String?,
        groupid: String?,
        groupchannel: String?,
        groupspace: String?,
        timeout: Int?,
        lane: String?,
        extrasystemprompt: String?,
        idempotencykey: String,
        label: String?,
        spawnedby: String?
    ) {
        self.message = message
        self.agentid = agentid
        self.to = to
        self.replyto = replyto
        self.sessionid = sessionid
        self.sessionkey = sessionkey
        self.thinking = thinking
        self.deliver = deliver
        self.attachments = attachments
        self.channel = channel
        self.replychannel = replychannel
        self.accountid = accountid
        self.replyaccountid = replyaccountid
        self.threadid = threadid
        self.groupid = groupid
        self.groupchannel = groupchannel
        self.groupspace = groupspace
        self.timeout = timeout
        self.lane = lane
        self.extrasystemprompt = extrasystemprompt
        self.idempotencykey = idempotencykey
        self.label = label
        self.spawnedby = spawnedby
    }
    private enum CodingKeys: String, CodingKey {
        case message
        case agentid = "agentId"
        case to
        case replyto = "replyTo"
        case sessionid = "sessionId"
        case sessionkey = "sessionKey"
        case thinking
        case deliver
        case attachments
        case channel
        case replychannel = "replyChannel"
        case accountid = "accountId"
        case replyaccountid = "replyAccountId"
        case threadid = "threadId"
        case groupid = "groupId"
        case groupchannel = "groupChannel"
        case groupspace = "groupSpace"
        case timeout
        case lane
        case extrasystemprompt = "extraSystemPrompt"
        case idempotencykey = "idempotencyKey"
        case label
        case spawnedby = "spawnedBy"
    }
}

public struct AgentIdentityParams: Codable, Sendable {
    public let agentid: String?
    public let sessionkey: String?

    public init(
        agentid: String?,
        sessionkey: String?
    ) {
        self.agentid = agentid
        self.sessionkey = sessionkey
    }
    private enum CodingKeys: String, CodingKey {
        case agentid = "agentId"
        case sessionkey = "sessionKey"
    }
}

public struct AgentIdentityResult: Codable, Sendable {
    public let agentid: String
    public let name: String?
    public let avatar: String?

    public init(
        agentid: String,
        name: String?,
        avatar: String?
    ) {
        self.agentid = agentid
        self.name = name
        self.avatar = avatar
    }
    private enum CodingKeys: String, CodingKey {
        case agentid = "agentId"
        case name
        case avatar
    }
}

public struct AgentWaitParams: Codable, Sendable {
    public let runid: String
    public let timeoutms: Int?

    public init(
        runid: String,
        timeoutms: Int?
    ) {
        self.runid = runid
        self.timeoutms = timeoutms
    }
    private enum CodingKeys: String, CodingKey {
        case runid = "runId"
        case timeoutms = "timeoutMs"
    }
}

public struct WakeParams: Codable, Sendable {
    public let mode: AnyCodable
    public let text: String

    public init(
        mode: AnyCodable,
        text: String
    ) {
        self.mode = mode
        self.text = text
    }
    private enum CodingKeys: String, CodingKey {
        case mode
        case text
    }
}

public struct NodePairRequestParams: Codable, Sendable {
    public let nodeid: String
    public let displayname: String?
    public let platform: String?
    public let version: String?
    public let coreversion: String?
    public let uiversion: String?
    public let devicefamily: String?
    public let modelidentifier: String?
    public let caps: [String]?
    public let commands: [String]?
    public let remoteip: String?
    public let silent: Bool?

    public init(
        nodeid: String,
        displayname: String?,
        platform: String?,
        version: String?,
        coreversion: String?,
        uiversion: String?,
        devicefamily: String?,
        modelidentifier: String?,
        caps: [String]?,
        commands: [String]?,
        remoteip: String?,
        silent: Bool?
    ) {
        self.nodeid = nodeid
        self.displayname = displayname
        self.platform = platform
        self.version = version
        self.coreversion = coreversion
        self.uiversion = uiversion
        self.devicefamily = devicefamily
        self.modelidentifier = modelidentifier
        self.caps = caps
        self.commands = commands
        self.remoteip = remoteip
        self.silent = silent
    }
    private enum CodingKeys: String, CodingKey {
        case nodeid = "nodeId"
        case displayname = "displayName"
        case platform
        case version
        case coreversion = "coreVersion"
        case uiversion = "uiVersion"
        case devicefamily = "deviceFamily"
        case modelidentifier = "modelIdentifier"
        case caps
        case commands
        case remoteip = "remoteIp"
        case silent
    }
}

public struct NodePairListParams: Codable, Sendable {
}

public struct NodePairApproveParams: Codable, Sendable {
    public let requestid: String

    public init(
        requestid: String
    ) {
        self.requestid = requestid
    }
    private enum CodingKeys: String, CodingKey {
        case requestid = "requestId"
    }
}

public struct NodePairRejectParams: Codable, Sendable {
    public let requestid: String

    public init(
        requestid: String
    ) {
        self.requestid = requestid
    }
    private enum CodingKeys: String, CodingKey {
        case requestid = "requestId"
    }
}

public struct NodePairVerifyParams: Codable, Sendable {
    public let nodeid: String
    public let token: String

    public init(
        nodeid: String,
        token: String
    ) {
        self.nodeid = nodeid
        self.token = token
    }
    private enum CodingKeys: String, CodingKey {
        case nodeid = "nodeId"
        case token
    }
}

public struct NodeRenameParams: Codable, Sendable {
    public let nodeid: String
    public let displayname: String

    public init(
        nodeid: String,
        displayname: String
    ) {
        self.nodeid = nodeid
        self.displayname = displayname
    }
    private enum CodingKeys: String, CodingKey {
        case nodeid = "nodeId"
        case displayname = "displayName"
    }
}

public struct NodeListParams: Codable, Sendable {
}

public struct NodeDescribeParams: Codable, Sendable {
    public let nodeid: String

    public init(
        nodeid: String
    ) {
        self.nodeid = nodeid
    }
    private enum CodingKeys: String, CodingKey {
        case nodeid = "nodeId"
    }
}

public struct NodeInvokeParams: Codable, Sendable {
    public let nodeid: String
    public let command: String
    public let params: AnyCodable?
    public let timeoutms: Int?
    public let idempotencykey: String

    public init(
        nodeid: String,
        command: String,
        params: AnyCodable?,
        timeoutms: Int?,
        idempotencykey: String
    ) {
        self.nodeid = nodeid
        self.command = command
        self.params = params
        self.timeoutms = timeoutms
        self.idempotencykey = idempotencykey
    }
    private enum CodingKeys: String, CodingKey {
        case nodeid = "nodeId"
        case command
        case params
        case timeoutms = "timeoutMs"
        case idempotencykey = "idempotencyKey"
    }
}

public struct NodeInvokeResultParams: Codable, Sendable {
    public let id: String
    public let nodeid: String
    public let ok: Bool
    public let payload: AnyCodable?
    public let payloadjson: String?
    public let error: [String: AnyCodable]?

    public init(
        id: String,
        nodeid: String,
        ok: Bool,
        payload: AnyCodable?,
        payloadjson: String?,
        error: [String: AnyCodable]?
    ) {
        self.id = id
        self.nodeid = nodeid
        self.ok = ok
        self.payload = payload
        self.payloadjson = payloadjson
        self.error = error
    }
    private enum CodingKeys: String, CodingKey {
        case id
        case nodeid = "nodeId"
        case ok
        case payload
        case payloadjson = "payloadJSON"
        case error
    }
}

public struct NodeEventParams: Codable, Sendable {
    public let event: String
    public let payload: AnyCodable?
    public let payloadjson: String?

    public init(
        event: String,
        payload: AnyCodable?,
        payloadjson: String?
    ) {
        self.event = event
        self.payload = payload
        self.payloadjson = payloadjson
    }
    private enum CodingKeys: String, CodingKey {
        case event
        case payload
        case payloadjson = "payloadJSON"
    }
}

public struct NodeInvokeRequestEvent: Codable, Sendable {
    public let id: String
    public let nodeid: String
    public let command: String
    public let paramsjson: String?
    public let timeoutms: Int?
    public let idempotencykey: String?

    public init(
        id: String,
        nodeid: String,
        command: String,
        paramsjson: String?,
        timeoutms: Int?,
        idempotencykey: String?
    ) {
        self.id = id
        self.nodeid = nodeid
        self.command = command
        self.paramsjson = paramsjson
        self.timeoutms = timeoutms
        self.idempotencykey = idempotencykey
    }
    private enum CodingKeys: String, CodingKey {
        case id
        case nodeid = "nodeId"
        case command
        case paramsjson = "paramsJSON"
        case timeoutms = "timeoutMs"
        case idempotencykey = "idempotencyKey"
    }
}

public struct SessionsListParams: Codable, Sendable {
    public let limit: Int?
    public let activeminutes: Int?
    public let includeglobal: Bool?
    public let includeunknown: Bool?
    public let includederivedtitles: Bool?
    public let includelastmessage: Bool?
    public let label: String?
    public let spawnedby: String?
    public let agentid: String?
    public let search: String?

    public init(
        limit: Int?,
        activeminutes: Int?,
        includeglobal: Bool?,
        includeunknown: Bool?,
        includederivedtitles: Bool?,
        includelastmessage: Bool?,
        label: String?,
        spawnedby: String?,
        agentid: String?,
        search: String?
    ) {
        self.limit = limit
        self.activeminutes = activeminutes
        self.includeglobal = includeglobal
        self.includeunknown = includeunknown
        self.includederivedtitles = includederivedtitles
        self.includelastmessage = includelastmessage
        self.label = label
        self.spawnedby = spawnedby
        self.agentid = agentid
        self.search = search
    }
    private enum CodingKeys: String, CodingKey {
        case limit
        case activeminutes = "activeMinutes"
        case includeglobal = "includeGlobal"
        case includeunknown = "includeUnknown"
        case includederivedtitles = "includeDerivedTitles"
        case includelastmessage = "includeLastMessage"
        case label
        case spawnedby = "spawnedBy"
        case agentid = "agentId"
        case search
    }
}

public struct SessionsPreviewParams: Codable, Sendable {
    public let keys: [String]
    public let limit: Int?
    public let maxchars: Int?

    public init(
        keys: [String],
        limit: Int?,
        maxchars: Int?
    ) {
        self.keys = keys
        self.limit = limit
        self.maxchars = maxchars
    }
    private enum CodingKeys: String, CodingKey {
        case keys
        case limit
        case maxchars = "maxChars"
    }
}

public struct SessionsResolveParams: Codable, Sendable {
    public let key: String?
    public let sessionid: String?
    public let label: String?
    public let agentid: String?
    public let spawnedby: String?
    public let includeglobal: Bool?
    public let includeunknown: Bool?

    public init(
        key: String?,
        sessionid: String?,
        label: String?,
        agentid: String?,
        spawnedby: String?,
        includeglobal: Bool?,
        includeunknown: Bool?
    ) {
        self.key = key
        self.sessionid = sessionid
        self.label = label
        self.agentid = agentid
        self.spawnedby = spawnedby
        self.includeglobal = includeglobal
        self.includeunknown = includeunknown
    }
    private enum CodingKeys: String, CodingKey {
        case key
        case sessionid = "sessionId"
        case label
        case agentid = "agentId"
        case spawnedby = "spawnedBy"
        case includeglobal = "includeGlobal"
        case includeunknown = "includeUnknown"
    }
}

public struct SessionsPatchParams: Codable, Sendable {
    public let key: String
    public let label: AnyCodable?
    public let thinkinglevel: AnyCodable?
    public let verboselevel: AnyCodable?
    public let reasoninglevel: AnyCodable?
    public let responseusage: AnyCodable?
    public let elevatedlevel: AnyCodable?
    public let exechost: AnyCodable?
    public let execsecurity: AnyCodable?
    public let execask: AnyCodable?
    public let execnode: AnyCodable?
    public let model: AnyCodable?
    public let spawnedby: AnyCodable?
    public let sendpolicy: AnyCodable?
    public let groupactivation: AnyCodable?

    public init(
        key: String,
        label: AnyCodable?,
        thinkinglevel: AnyCodable?,
        verboselevel: AnyCodable?,
        reasoninglevel: AnyCodable?,
        responseusage: AnyCodable?,
        elevatedlevel: AnyCodable?,
        exechost: AnyCodable?,
        execsecurity: AnyCodable?,
        execask: AnyCodable?,
        execnode: AnyCodable?,
        model: AnyCodable?,
        spawnedby: AnyCodable?,
        sendpolicy: AnyCodable?,
        groupactivation: AnyCodable?
    ) {
        self.key = key
        self.label = label
        self.thinkinglevel = thinkinglevel
        self.verboselevel = verboselevel
        self.reasoninglevel = reasoninglevel
        self.responseusage = responseusage
        self.elevatedlevel = elevatedlevel
        self.exechost = exechost
        self.execsecurity = execsecurity
        self.execask = execask
        self.execnode = execnode
        self.model = model
        self.spawnedby = spawnedby
        self.sendpolicy = sendpolicy
        self.groupactivation = groupactivation
    }
    private enum CodingKeys: String, CodingKey {
        case key
        case label
        case thinkinglevel = "thinkingLevel"
        case verboselevel = "verboseLevel"
        case reasoninglevel = "reasoningLevel"
        case responseusage = "responseUsage"
        case elevatedlevel = "elevatedLevel"
        case exechost = "execHost"
        case execsecurity = "execSecurity"
        case execask = "execAsk"
        case execnode = "execNode"
        case model
        case spawnedby = "spawnedBy"
        case sendpolicy = "sendPolicy"
        case groupactivation = "groupActivation"
    }
}

public struct SessionsResetParams: Codable, Sendable {
    public let key: String

    public init(
        key: String
    ) {
        self.key = key
    }
    private enum CodingKeys: String, CodingKey {
        case key
    }
}

public struct SessionsDeleteParams: Codable, Sendable {
    public let key: String
    public let deletetranscript: Bool?

    public init(
        key: String,
        deletetranscript: Bool?
    ) {
        self.key = key
        self.deletetranscript = deletetranscript
    }
    private enum CodingKeys: String, CodingKey {
        case key
        case deletetranscript = "deleteTranscript"
    }
}

public struct SessionsCompactParams: Codable, Sendable {
    public let key: String
    public let maxlines: Int?

    public init(
        key: String,
        maxlines: Int?
    ) {
        self.key = key
        self.maxlines = maxlines
    }
    private enum CodingKeys: String, CodingKey {
        case key
        case maxlines = "maxLines"
    }
}

public struct ConfigGetParams: Codable, Sendable {
}

public struct ConfigSetParams: Codable, Sendable {
    public let raw: String
    public let basehash: String?

    public init(
        raw: String,
        basehash: String?
    ) {
        self.raw = raw
        self.basehash = basehash
    }
    private enum CodingKeys: String, CodingKey {
        case raw
        case basehash = "baseHash"
    }
}

public struct ConfigApplyParams: Codable, Sendable {
    public let raw: String
    public let basehash: String?
    public let sessionkey: String?
    public let note: String?
    public let restartdelayms: Int?

    public init(
        raw: String,
        basehash: String?,
        sessionkey: String?,
        note: String?,
        restartdelayms: Int?
    ) {
        self.raw = raw
        self.basehash = basehash
        self.sessionkey = sessionkey
        self.note = note
        self.restartdelayms = restartdelayms
    }
    private enum CodingKeys: String, CodingKey {
        case raw
        case basehash = "baseHash"
        case sessionkey = "sessionKey"
        case note
        case restartdelayms = "restartDelayMs"
    }
}

public struct ConfigPatchParams: Codable, Sendable {
    public let raw: String
    public let basehash: String?
    public let sessionkey: String?
    public let note: String?
    public let restartdelayms: Int?

    public init(
        raw: String,
        basehash: String?,
        sessionkey: String?,
        note: String?,
        restartdelayms: Int?
    ) {
        self.raw = raw
        self.basehash = basehash
        self.sessionkey = sessionkey
        self.note = note
        self.restartdelayms = restartdelayms
    }
    private enum CodingKeys: String, CodingKey {
        case raw
        case basehash = "baseHash"
        case sessionkey = "sessionKey"
        case note
        case restartdelayms = "restartDelayMs"
    }
}

public struct ConfigSchemaParams: Codable, Sendable {
}

public struct ConfigSchemaResponse: Codable, Sendable {
    public let schema: AnyCodable
    public let uihints: [String: AnyCodable]
    public let version: String
    public let generatedat: String

    public init(
        schema: AnyCodable,
        uihints: [String: AnyCodable],
        version: String,
        generatedat: String
    ) {
        self.schema = schema
        self.uihints = uihints
        self.version = version
        self.generatedat = generatedat
    }
    private enum CodingKeys: String, CodingKey {
        case schema
        case uihints = "uiHints"
        case version
        case generatedat = "generatedAt"
    }
}

public struct WizardStartParams: Codable, Sendable {
    public let mode: AnyCodable?
    public let workspace: String?

    public init(
        mode: AnyCodable?,
        workspace: String?
    ) {
        self.mode = mode
        self.workspace = workspace
    }
    private enum CodingKeys: String, CodingKey {
        case mode
        case workspace
    }
}

public struct WizardNextParams: Codable, Sendable {
    public let sessionid: String
    public let answer: [String: AnyCodable]?

    public init(
        sessionid: String,
        answer: [String: AnyCodable]?
    ) {
        self.sessionid = sessionid
        self.answer = answer
    }
    private enum CodingKeys: String, CodingKey {
        case sessionid = "sessionId"
        case answer
    }
}

public struct WizardCancelParams: Codable, Sendable {
    public let sessionid: String

    public init(
        sessionid: String
    ) {
        self.sessionid = sessionid
    }
    private enum CodingKeys: String, CodingKey {
        case sessionid = "sessionId"
    }
}

public struct WizardStatusParams: Codable, Sendable {
    public let sessionid: String

    public init(
        sessionid: String
    ) {
        self.sessionid = sessionid
    }
    private enum CodingKeys: String, CodingKey {
        case sessionid = "sessionId"
    }
}

public struct WizardStep: Codable, Sendable {
    public let id: String
    public let type: AnyCodable
    public let title: String?
    public let message: String?
    public let options: [[String: AnyCodable]]?
    public let initialvalue: AnyCodable?
    public let placeholder: String?
    public let sensitive: Bool?
    public let executor: AnyCodable?

    public init(
        id: String,
        type: AnyCodable,
        title: String?,
        message: String?,
        options: [[String: AnyCodable]]?,
        initialvalue: AnyCodable?,
        placeholder: String?,
        sensitive: Bool?,
        executor: AnyCodable?
    ) {
        self.id = id
        self.type = type
        self.title = title
        self.message = message
        self.options = options
        self.initialvalue = initialvalue
        self.placeholder = placeholder
        self.sensitive = sensitive
        self.executor = executor
    }
    private enum CodingKeys: String, CodingKey {
        case id
        case type
        case title
        case message
        case options
        case initialvalue = "initialValue"
        case placeholder
        case sensitive
        case executor
    }
}

public struct WizardNextResult: Codable, Sendable {
    public let done: Bool
    public let step: [String: AnyCodable]?
    public let status: AnyCodable?
    public let error: String?

    public init(
        done: Bool,
        step: [String: AnyCodable]?,
        status: AnyCodable?,
        error: String?
    ) {
        self.done = done
        self.step = step
        self.status = status
        self.error = error
    }
    private enum CodingKeys: String, CodingKey {
        case done
        case step
        case status
        case error
    }
}

public struct WizardStartResult: Codable, Sendable {
    public let sessionid: String
    public let done: Bool
    public let step: [String: AnyCodable]?
    public let status: AnyCodable?
    public let error: String?

    public init(
        sessionid: String,
        done: Bool,
        step: [String: AnyCodable]?,
        status: AnyCodable?,
        error: String?
    ) {
        self.sessionid = sessionid
        self.done = done
        self.step = step
        self.status = status
        self.error = error
    }
    private enum CodingKeys: String, CodingKey {
        case sessionid = "sessionId"
        case done
        case step
        case status
        case error
    }
}

public struct WizardStatusResult: Codable, Sendable {
    public let status: AnyCodable
    public let error: String?

    public init(
        status: AnyCodable,
        error: String?
    ) {
        self.status = status
        self.error = error
    }
    private enum CodingKeys: String, CodingKey {
        case status
        case error
    }
}

public struct TalkModeParams: Codable, Sendable {
    public let enabled: Bool
    public let phase: String?

    public init(
        enabled: Bool,
        phase: String?
    ) {
        self.enabled = enabled
        self.phase = phase
    }
    private enum CodingKeys: String, CodingKey {
        case enabled
        case phase
    }
}

public struct ChannelsStatusParams: Codable, Sendable {
    public let probe: Bool?
    public let timeoutms: Int?

    public init(
        probe: Bool?,
        timeoutms: Int?
    ) {
        self.probe = probe
        self.timeoutms = timeoutms
    }
    private enum CodingKeys: String, CodingKey {
        case probe
        case timeoutms = "timeoutMs"
    }
}

public struct ChannelsStatusResult: Codable, Sendable {
    public let ts: Int
    public let channelorder: [String]
    public let channellabels: [String: AnyCodable]
    public let channeldetaillabels: [String: AnyCodable]?
    public let channelsystemimages: [String: AnyCodable]?
    public let channelmeta: [[String: AnyCodable]]?
    public let channels: [String: AnyCodable]
    public let channelaccounts: [String: AnyCodable]
    public let channeldefaultaccountid: [String: AnyCodable]

    public init(
        ts: Int,
        channelorder: [String],
        channellabels: [String: AnyCodable],
        channeldetaillabels: [String: AnyCodable]?,
        channelsystemimages: [String: AnyCodable]?,
        channelmeta: [[String: AnyCodable]]?,
        channels: [String: AnyCodable],
        channelaccounts: [String: AnyCodable],
        channeldefaultaccountid: [String: AnyCodable]
    ) {
        self.ts = ts
        self.channelorder = channelorder
        self.channellabels = channellabels
        self.channeldetaillabels = channeldetaillabels
        self.channelsystemimages = channelsystemimages
        self.channelmeta = channelmeta
        self.channels = channels
        self.channelaccounts = channelaccounts
        self.channeldefaultaccountid = channeldefaultaccountid
    }
    private enum CodingKeys: String, CodingKey {
        case ts
        case channelorder = "channelOrder"
        case channellabels = "channelLabels"
        case channeldetaillabels = "channelDetailLabels"
        case channelsystemimages = "channelSystemImages"
        case channelmeta = "channelMeta"
        case channels
        case channelaccounts = "channelAccounts"
        case channeldefaultaccountid = "channelDefaultAccountId"
    }
}

public struct ChannelsLogoutParams: Codable, Sendable {
    public let channel: String
    public let accountid: String?

    public init(
        channel: String,
        accountid: String?
    ) {
        self.channel = channel
        self.accountid = accountid
    }
    private enum CodingKeys: String, CodingKey {
        case channel
        case accountid = "accountId"
    }
}

public struct WebLoginStartParams: Codable, Sendable {
    public let force: Bool?
    public let timeoutms: Int?
    public let verbose: Bool?
    public let accountid: String?

    public init(
        force: Bool?,
        timeoutms: Int?,
        verbose: Bool?,
        accountid: String?
    ) {
        self.force = force
        self.timeoutms = timeoutms
        self.verbose = verbose
        self.accountid = accountid
    }
    private enum CodingKeys: String, CodingKey {
        case force
        case timeoutms = "timeoutMs"
        case verbose
        case accountid = "accountId"
    }
}

public struct WebLoginWaitParams: Codable, Sendable {
    public let timeoutms: Int?
    public let accountid: String?

    public init(
        timeoutms: Int?,
        accountid: String?
    ) {
        self.timeoutms = timeoutms
        self.accountid = accountid
    }
    private enum CodingKeys: String, CodingKey {
        case timeoutms = "timeoutMs"
        case accountid = "accountId"
    }
}

public struct AgentSummary: Codable, Sendable {
    public let id: String
    public let name: String?
    public let identity: [String: AnyCodable]?

    public init(
        id: String,
        name: String?,
        identity: [String: AnyCodable]?
    ) {
        self.id = id
        self.name = name
        self.identity = identity
    }
    private enum CodingKeys: String, CodingKey {
        case id
        case name
        case identity
    }
}

public struct AgentsListParams: Codable, Sendable {
}

public struct AgentsListResult: Codable, Sendable {
    public let defaultid: String
    public let mainkey: String
    public let scope: AnyCodable
    public let agents: [AgentSummary]

    public init(
        defaultid: String,
        mainkey: String,
        scope: AnyCodable,
        agents: [AgentSummary]
    ) {
        self.defaultid = defaultid
        self.mainkey = mainkey
        self.scope = scope
        self.agents = agents
    }
    private enum CodingKeys: String, CodingKey {
        case defaultid = "defaultId"
        case mainkey = "mainKey"
        case scope
        case agents
    }
}

public struct ModelChoice: Codable, Sendable {
    public let id: String
    public let name: String
    public let provider: String
    public let contextwindow: Int?
    public let reasoning: Bool?

    public init(
        id: String,
        name: String,
        provider: String,
        contextwindow: Int?,
        reasoning: Bool?
    ) {
        self.id = id
        self.name = name
        self.provider = provider
        self.contextwindow = contextwindow
        self.reasoning = reasoning
    }
    private enum CodingKeys: String, CodingKey {
        case id
        case name
        case provider
        case contextwindow = "contextWindow"
        case reasoning
    }
}

public struct ModelsListParams: Codable, Sendable {
}

public struct ModelsListResult: Codable, Sendable {
    public let models: [ModelChoice]

    public init(
        models: [ModelChoice]
    ) {
        self.models = models
    }
    private enum CodingKeys: String, CodingKey {
        case models
    }
}

public struct SkillsStatusParams: Codable, Sendable {
}

public struct SkillsBinsParams: Codable, Sendable {
}

public struct SkillsBinsResult: Codable, Sendable {
    public let bins: [String]

    public init(
        bins: [String]
    ) {
        self.bins = bins
    }
    private enum CodingKeys: String, CodingKey {
        case bins
    }
}

public struct SkillsInstallParams: Codable, Sendable {
    public let name: String
    public let installid: String
    public let timeoutms: Int?

    public init(
        name: String,
        installid: String,
        timeoutms: Int?
    ) {
        self.name = name
        self.installid = installid
        self.timeoutms = timeoutms
    }
    private enum CodingKeys: String, CodingKey {
        case name
        case installid = "installId"
        case timeoutms = "timeoutMs"
    }
}

public struct SkillsUpdateParams: Codable, Sendable {
    public let skillkey: String
    public let enabled: Bool?
    public let apikey: String?
    public let env: [String: AnyCodable]?

    public init(
        skillkey: String,
        enabled: Bool?,
        apikey: String?,
        env: [String: AnyCodable]?
    ) {
        self.skillkey = skillkey
        self.enabled = enabled
        self.apikey = apikey
        self.env = env
    }
    private enum CodingKeys: String, CodingKey {
        case skillkey = "skillKey"
        case enabled
        case apikey = "apiKey"
        case env
    }
}

public struct CronJob: Codable, Sendable {
    public let id: String
    public let agentid: String?
    public let name: String
    public let description: String?
    public let enabled: Bool
    public let deleteafterrun: Bool?
    public let createdatms: Int
    public let updatedatms: Int
    public let schedule: AnyCodable
    public let sessiontarget: AnyCodable
    public let wakemode: AnyCodable
    public let payload: AnyCodable
    public let isolation: [String: AnyCodable]?
    public let state: [String: AnyCodable]

    public init(
        id: String,
        agentid: String?,
        name: String,
        description: String?,
        enabled: Bool,
        deleteafterrun: Bool?,
        createdatms: Int,
        updatedatms: Int,
        schedule: AnyCodable,
        sessiontarget: AnyCodable,
        wakemode: AnyCodable,
        payload: AnyCodable,
        isolation: [String: AnyCodable]?,
        state: [String: AnyCodable]
    ) {
        self.id = id
        self.agentid = agentid
        self.name = name
        self.description = description
        self.enabled = enabled
        self.deleteafterrun = deleteafterrun
        self.createdatms = createdatms
        self.updatedatms = updatedatms
        self.schedule = schedule
        self.sessiontarget = sessiontarget
        self.wakemode = wakemode
        self.payload = payload
        self.isolation = isolation
        self.state = state
    }
    private enum CodingKeys: String, CodingKey {
        case id
        case agentid = "agentId"
        case name
        case description
        case enabled
        case deleteafterrun = "deleteAfterRun"
        case createdatms = "createdAtMs"
        case updatedatms = "updatedAtMs"
        case schedule
        case sessiontarget = "sessionTarget"
        case wakemode = "wakeMode"
        case payload
        case isolation
        case state
    }
}

public struct CronListParams: Codable, Sendable {
    public let includedisabled: Bool?

    public init(
        includedisabled: Bool?
    ) {
        self.includedisabled = includedisabled
    }
    private enum CodingKeys: String, CodingKey {
        case includedisabled = "includeDisabled"
    }
}

public struct CronStatusParams: Codable, Sendable {
}

public struct CronAddParams: Codable, Sendable {
    public let name: String
    public let agentid: AnyCodable?
    public let description: String?
    public let enabled: Bool?
    public let deleteafterrun: Bool?
    public let schedule: AnyCodable
    public let sessiontarget: AnyCodable
    public let wakemode: AnyCodable
    public let payload: AnyCodable
    public let isolation: [String: AnyCodable]?

    public init(
        name: String,
        agentid: AnyCodable?,
        description: String?,
        enabled: Bool?,
        deleteafterrun: Bool?,
        schedule: AnyCodable,
        sessiontarget: AnyCodable,
        wakemode: AnyCodable,
        payload: AnyCodable,
        isolation: [String: AnyCodable]?
    ) {
        self.name = name
        self.agentid = agentid
        self.description = description
        self.enabled = enabled
        self.deleteafterrun = deleteafterrun
        self.schedule = schedule
        self.sessiontarget = sessiontarget
        self.wakemode = wakemode
        self.payload = payload
        self.isolation = isolation
    }
    private enum CodingKeys: String, CodingKey {
        case name
        case agentid = "agentId"
        case description
        case enabled
        case deleteafterrun = "deleteAfterRun"
        case schedule
        case sessiontarget = "sessionTarget"
        case wakemode = "wakeMode"
        case payload
        case isolation
    }
}

public struct CronRunLogEntry: Codable, Sendable {
    public let ts: Int
    public let jobid: String
    public let action: String
    public let status: AnyCodable?
    public let error: String?
    public let summary: String?
    public let runatms: Int?
    public let durationms: Int?
    public let nextrunatms: Int?

    public init(
        ts: Int,
        jobid: String,
        action: String,
        status: AnyCodable?,
        error: String?,
        summary: String?,
        runatms: Int?,
        durationms: Int?,
        nextrunatms: Int?
    ) {
        self.ts = ts
        self.jobid = jobid
        self.action = action
        self.status = status
        self.error = error
        self.summary = summary
        self.runatms = runatms
        self.durationms = durationms
        self.nextrunatms = nextrunatms
    }
    private enum CodingKeys: String, CodingKey {
        case ts
        case jobid = "jobId"
        case action
        case status
        case error
        case summary
        case runatms = "runAtMs"
        case durationms = "durationMs"
        case nextrunatms = "nextRunAtMs"
    }
}

public struct LogsTailParams: Codable, Sendable {
    public let cursor: Int?
    public let limit: Int?
    public let maxbytes: Int?

    public init(
        cursor: Int?,
        limit: Int?,
        maxbytes: Int?
    ) {
        self.cursor = cursor
        self.limit = limit
        self.maxbytes = maxbytes
    }
    private enum CodingKeys: String, CodingKey {
        case cursor
        case limit
        case maxbytes = "maxBytes"
    }
}

public struct LogsTailResult: Codable, Sendable {
    public let file: String
    public let cursor: Int
    public let size: Int
    public let lines: [String]
    public let truncated: Bool?
    public let reset: Bool?

    public init(
        file: String,
        cursor: Int,
        size: Int,
        lines: [String],
        truncated: Bool?,
        reset: Bool?
    ) {
        self.file = file
        self.cursor = cursor
        self.size = size
        self.lines = lines
        self.truncated = truncated
        self.reset = reset
    }
    private enum CodingKeys: String, CodingKey {
        case file
        case cursor
        case size
        case lines
        case truncated
        case reset
    }
}

public struct ExecApprovalsGetParams: Codable, Sendable {
}

public struct ExecApprovalsSetParams: Codable, Sendable {
    public let file: [String: AnyCodable]
    public let basehash: String?

    public init(
        file: [String: AnyCodable],
        basehash: String?
    ) {
        self.file = file
        self.basehash = basehash
    }
    private enum CodingKeys: String, CodingKey {
        case file
        case basehash = "baseHash"
    }
}

public struct ExecApprovalsNodeGetParams: Codable, Sendable {
    public let nodeid: String

    public init(
        nodeid: String
    ) {
        self.nodeid = nodeid
    }
    private enum CodingKeys: String, CodingKey {
        case nodeid = "nodeId"
    }
}

public struct ExecApprovalsNodeSetParams: Codable, Sendable {
    public let nodeid: String
    public let file: [String: AnyCodable]
    public let basehash: String?

    public init(
        nodeid: String,
        file: [String: AnyCodable],
        basehash: String?
    ) {
        self.nodeid = nodeid
        self.file = file
        self.basehash = basehash
    }
    private enum CodingKeys: String, CodingKey {
        case nodeid = "nodeId"
        case file
        case basehash = "baseHash"
    }
}

public struct ExecApprovalsSnapshot: Codable, Sendable {
    public let path: String
    public let exists: Bool
    public let hash: String
    public let file: [String: AnyCodable]

    public init(
        path: String,
        exists: Bool,
        hash: String,
        file: [String: AnyCodable]
    ) {
        self.path = path
        self.exists = exists
        self.hash = hash
        self.file = file
    }
    private enum CodingKeys: String, CodingKey {
        case path
        case exists
        case hash
        case file
    }
}

public struct ExecApprovalRequestParams: Codable, Sendable {
    public let id: String?
    public let command: String
    public let cwd: AnyCodable?
    public let host: AnyCodable?
    public let security: AnyCodable?
    public let ask: AnyCodable?
    public let agentid: AnyCodable?
    public let resolvedpath: AnyCodable?
    public let sessionkey: AnyCodable?
    public let timeoutms: Int?

    public init(
        id: String?,
        command: String,
        cwd: AnyCodable?,
        host: AnyCodable?,
        security: AnyCodable?,
        ask: AnyCodable?,
        agentid: AnyCodable?,
        resolvedpath: AnyCodable?,
        sessionkey: AnyCodable?,
        timeoutms: Int?
    ) {
        self.id = id
        self.command = command
        self.cwd = cwd
        self.host = host
        self.security = security
        self.ask = ask
        self.agentid = agentid
        self.resolvedpath = resolvedpath
        self.sessionkey = sessionkey
        self.timeoutms = timeoutms
    }
    private enum CodingKeys: String, CodingKey {
        case id
        case command
        case cwd
        case host
        case security
        case ask
        case agentid = "agentId"
        case resolvedpath = "resolvedPath"
        case sessionkey = "sessionKey"
        case timeoutms = "timeoutMs"
    }
}

public struct ExecApprovalResolveParams: Codable, Sendable {
    public let id: String
    public let decision: String

    public init(
        id: String,
        decision: String
    ) {
        self.id = id
        self.decision = decision
    }
    private enum CodingKeys: String, CodingKey {
        case id
        case decision
    }
}

public struct DevicePairListParams: Codable, Sendable {
}

public struct DevicePairApproveParams: Codable, Sendable {
    public let requestid: String

    public init(
        requestid: String
    ) {
        self.requestid = requestid
    }
    private enum CodingKeys: String, CodingKey {
        case requestid = "requestId"
    }
}

public struct DevicePairRejectParams: Codable, Sendable {
    public let requestid: String

    public init(
        requestid: String
    ) {
        self.requestid = requestid
    }
    private enum CodingKeys: String, CodingKey {
        case requestid = "requestId"
    }
}

public struct DeviceTokenRotateParams: Codable, Sendable {
    public let deviceid: String
    public let role: String
    public let scopes: [String]?

    public init(
        deviceid: String,
        role: String,
        scopes: [String]?
    ) {
        self.deviceid = deviceid
        self.role = role
        self.scopes = scopes
    }
    private enum CodingKeys: String, CodingKey {
        case deviceid = "deviceId"
        case role
        case scopes
    }
}

public struct DeviceTokenRevokeParams: Codable, Sendable {
    public let deviceid: String
    public let role: String

    public init(
        deviceid: String,
        role: String
    ) {
        self.deviceid = deviceid
        self.role = role
    }
    private enum CodingKeys: String, CodingKey {
        case deviceid = "deviceId"
        case role
    }
}

public struct DevicePairRequestedEvent: Codable, Sendable {
    public let requestid: String
    public let deviceid: String
    public let publickey: String
    public let displayname: String?
    public let platform: String?
    public let clientid: String?
    public let clientmode: String?
    public let role: String?
    public let roles: [String]?
    public let scopes: [String]?
    public let remoteip: String?
    public let silent: Bool?
    public let isrepair: Bool?
    public let ts: Int

    public init(
        requestid: String,
        deviceid: String,
        publickey: String,
        displayname: String?,
        platform: String?,
        clientid: String?,
        clientmode: String?,
        role: String?,
        roles: [String]?,
        scopes: [String]?,
        remoteip: String?,
        silent: Bool?,
        isrepair: Bool?,
        ts: Int
    ) {
        self.requestid = requestid
        self.deviceid = deviceid
        self.publickey = publickey
        self.displayname = displayname
        self.platform = platform
        self.clientid = clientid
        self.clientmode = clientmode
        self.role = role
        self.roles = roles
        self.scopes = scopes
        self.remoteip = remoteip
        self.silent = silent
        self.isrepair = isrepair
        self.ts = ts
    }
    private enum CodingKeys: String, CodingKey {
        case requestid = "requestId"
        case deviceid = "deviceId"
        case publickey = "publicKey"
        case displayname = "displayName"
        case platform
        case clientid = "clientId"
        case clientmode = "clientMode"
        case role
        case roles
        case scopes
        case remoteip = "remoteIp"
        case silent
        case isrepair = "isRepair"
        case ts
    }
}

public struct DevicePairResolvedEvent: Codable, Sendable {
    public let requestid: String
    public let deviceid: String
    public let decision: String
    public let ts: Int

    public init(
        requestid: String,
        deviceid: String,
        decision: String,
        ts: Int
    ) {
        self.requestid = requestid
        self.deviceid = deviceid
        self.decision = decision
        self.ts = ts
    }
    private enum CodingKeys: String, CodingKey {
        case requestid = "requestId"
        case deviceid = "deviceId"
        case decision
        case ts
    }
}

public struct ChatHistoryParams: Codable, Sendable {
    public let sessionkey: String
    public let limit: Int?

    public init(
        sessionkey: String,
        limit: Int?
    ) {
        self.sessionkey = sessionkey
        self.limit = limit
    }
    private enum CodingKeys: String, CodingKey {
        case sessionkey = "sessionKey"
        case limit
    }
}

public struct ChatSendParams: Codable, Sendable {
    public let sessionkey: String
    public let message: String
    public let thinking: String?
    public let deliver: Bool?
    public let attachments: [AnyCodable]?
    public let timeoutms: Int?
    public let idempotencykey: String

    public init(
        sessionkey: String,
        message: String,
        thinking: String?,
        deliver: Bool?,
        attachments: [AnyCodable]?,
        timeoutms: Int?,
        idempotencykey: String
    ) {
        self.sessionkey = sessionkey
        self.message = message
        self.thinking = thinking
        self.deliver = deliver
        self.attachments = attachments
        self.timeoutms = timeoutms
        self.idempotencykey = idempotencykey
    }
    private enum CodingKeys: String, CodingKey {
        case sessionkey = "sessionKey"
        case message
        case thinking
        case deliver
        case attachments
        case timeoutms = "timeoutMs"
        case idempotencykey = "idempotencyKey"
    }
}

public struct ChatAbortParams: Codable, Sendable {
    public let sessionkey: String
    public let runid: String?

    public init(
        sessionkey: String,
        runid: String?
    ) {
        self.sessionkey = sessionkey
        self.runid = runid
    }
    private enum CodingKeys: String, CodingKey {
        case sessionkey = "sessionKey"
        case runid = "runId"
    }
}

public struct ChatInjectParams: Codable, Sendable {
    public let sessionkey: String
    public let message: String
    public let label: String?

    public init(
        sessionkey: String,
        message: String,
        label: String?
    ) {
        self.sessionkey = sessionkey
        self.message = message
        self.label = label
    }
    private enum CodingKeys: String, CodingKey {
        case sessionkey = "sessionKey"
        case message
        case label
    }
}

public struct ChatEvent: Codable, Sendable {
    public let runid: String
    public let sessionkey: String
    public let seq: Int
    public let state: AnyCodable
    public let message: AnyCodable?
    public let errormessage: String?
    public let usage: AnyCodable?
    public let stopreason: String?

    public init(
        runid: String,
        sessionkey: String,
        seq: Int,
        state: AnyCodable,
        message: AnyCodable?,
        errormessage: String?,
        usage: AnyCodable?,
        stopreason: String?
    ) {
        self.runid = runid
        self.sessionkey = sessionkey
        self.seq = seq
        self.state = state
        self.message = message
        self.errormessage = errormessage
        self.usage = usage
        self.stopreason = stopreason
    }
    private enum CodingKeys: String, CodingKey {
        case runid = "runId"
        case sessionkey = "sessionKey"
        case seq
        case state
        case message
        case errormessage = "errorMessage"
        case usage
        case stopreason = "stopReason"
    }
}

public struct UpdateRunParams: Codable, Sendable {
    public let sessionkey: String?
    public let note: String?
    public let restartdelayms: Int?
    public let timeoutms: Int?

    public init(
        sessionkey: String?,
        note: String?,
        restartdelayms: Int?,
        timeoutms: Int?
    ) {
        self.sessionkey = sessionkey
        self.note = note
        self.restartdelayms = restartdelayms
        self.timeoutms = timeoutms
    }
    private enum CodingKeys: String, CodingKey {
        case sessionkey = "sessionKey"
        case note
        case restartdelayms = "restartDelayMs"
        case timeoutms = "timeoutMs"
    }
}

public struct TickEvent: Codable, Sendable {
    public let ts: Int

    public init(
        ts: Int
    ) {
        self.ts = ts
    }
    private enum CodingKeys: String, CodingKey {
        case ts
    }
}

public struct ShutdownEvent: Codable, Sendable {
    public let reason: String
    public let restartexpectedms: Int?

    public init(
        reason: String,
        restartexpectedms: Int?
    ) {
        self.reason = reason
        self.restartexpectedms = restartexpectedms
    }
    private enum CodingKeys: String, CodingKey {
        case reason
        case restartexpectedms = "restartExpectedMs"
    }
}

public enum GatewayFrame: Codable, Sendable {
    case req(RequestFrame)
    case res(ResponseFrame)
    case event(EventFrame)
    case unknown(type: String, raw: [String: AnyCodable])

    private enum CodingKeys: String, CodingKey {
        case type
    }

    public init(from decoder: Decoder) throws {
        let typeContainer = try decoder.container(keyedBy: CodingKeys.self)
        let type = try typeContainer.decode(String.self, forKey: .type)
        switch type {
        case "req":
            self = .req(try RequestFrame(from: decoder))
        case "res":
            self = .res(try ResponseFrame(from: decoder))
        case "event":
            self = .event(try EventFrame(from: decoder))
        default:
            let container = try decoder.singleValueContainer()
            let raw = try container.decode([String: AnyCodable].self)
            self = .unknown(type: type, raw: raw)
        }
    }

    public func encode(to encoder: Encoder) throws {
        switch self {
        case .req(let v): try v.encode(to: encoder)
        case .res(let v): try v.encode(to: encoder)
        case .event(let v): try v.encode(to: encoder)
        case .unknown(_, let raw):
            var container = encoder.singleValueContainer()
            try container.encode(raw)
        }
    }

}
