/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.gtm.renderer;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconSet;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconType;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.client.renderer.item.TagPrefixItemRenderer;
import com.gregtechceu.gtceu.data.pack.GTDynamicResourcePack;
import com.gtocore.common.data.GTOMaterials;
import com.gtolib.GTOCore;
import java.util.function.Supplier;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TagPrefixItemRenderer.class})
public class TagPrefixItemRendererMixin {
    @Inject(method={"create"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void create(Item item, MaterialIconType type, MaterialIconSet iconSet, CallbackInfo ci) {
        if (iconSet == GTOMaterials.Cosmic.getMaterialIconSet()) {
            ci.cancel();
        }
    }

    @Inject(method={"reinitModels"}, at={@At(value="TAIL")}, remap=false)
    private static void reinitModels(CallbackInfo ci) {
        for (TagPrefix tagPrefix : TagPrefix.values()) {
            MaterialIconType iconType = tagPrefix.materialIconType();
            if (iconType == null || !tagPrefix.doGenerateItem() && !tagPrefix.doGenerateBlock()) continue;
            if (tagPrefix.doGenerateBlock()) {
                GTDynamicResourcePack.addItemModel((ResourceLocation)GTOCore.id((String)tagPrefix.getLowerCaseName()), (Supplier)new DelegatedModel(GTCEu.id((String)String.format("block/material_sets/dull/%s", iconType))));
                continue;
            }
            GTDynamicResourcePack.addItemModel((ResourceLocation)GTOCore.id((String)tagPrefix.getLowerCaseName()), (Supplier)new DelegatedModel(GTCEu.id((String)String.format("item/material_sets/dull/%s", iconType))));
        }
    }
}

