/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.gtm.registry;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.registry.MaterialRegistry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.registry.registrate.GTRegistrate;
import com.gregtechceu.gtceu.common.data.GTCreativeModeTabs;
import com.gregtechceu.gtceu.common.data.GTMaterialItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.api.data.tag.GTOTagPrefix;
import com.gtocore.common.data.GTOCreativeModeTabs;
import com.gtolib.api.registries.GTORegistration;
import com.gtolib.utils.register.ItemRegisterUtils;
import com.tterrag.registrate.util.entry.ItemEntry;
import net.minecraft.world.item.Item;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GTMaterialItems.class})
public final class GTMaterialItemsMixin {
    @Shadow(remap=false)
    static ImmutableTable.Builder<TagPrefix, Material, ItemEntry<Item>> MATERIAL_ITEMS_BUILDER;
    @Shadow(remap=false)
    public static Table<TagPrefix, Material, ItemEntry<Item>> MATERIAL_ITEMS;

    @Inject(method={"generateTools"}, at={@At(value="INVOKE", target="Lcom/gregtechceu/gtceu/api/registry/registrate/GTRegistrate;creativeModeTab(Ljava/util/function/Supplier;)V")}, remap=false)
    private static void setToolCreativeModeTab(CallbackInfo ci) {
        GTORegistration.GTO.creativeModeTab(() -> GTOCreativeModeTabs.GTO_ITEM);
    }

    @Overwrite(remap=false)
    public static void generateMaterialItems() {
        GTORegistration.GTM.creativeModeTab(() -> GTCreativeModeTabs.MATERIAL_ITEM);
        GTORegistration.GTO.creativeModeTab(() -> GTOCreativeModeTabs.GTO_MATERIAL_ITEM);
        for (TagPrefix tagPrefix : TagPrefix.values()) {
            if (!tagPrefix.doGenerateItem()) continue;
            for (MaterialRegistry registry : GTCEuAPI.materialManager.getRegistries()) {
                Object registrate = tagPrefix instanceof GTOTagPrefix ? GTORegistration.GTO : registry.getRegistrate();
                for (Material material : registry.getAllMaterials()) {
                    if (!tagPrefix.doGenerateItem(material)) continue;
                    ItemRegisterUtils.generateMaterialItem((GTRegistrate)registrate, (TagPrefix)tagPrefix, (Material)material, MATERIAL_ITEMS_BUILDER);
                }
            }
        }
        MATERIAL_ITEMS = MATERIAL_ITEMS_BUILDER.build();
    }

    @Inject(method={"generateTool"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void generateTool(Material material, GTToolType toolType, GTRegistrate registrate, CallbackInfo ci) {
        if (toolType == GTToolType.KNIFE && material == GTMaterials.Flint) {
            ci.cancel();
        }
    }
}

