/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.gtm.recipe;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.ItemMaterialData;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IngotProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.ItemMaterialInfo;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.common.data.GTRecipeCategories;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.misc.RecyclingRecipes;
import com.gtolib.utils.ItemUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={RecyclingRecipes.class})
public abstract class RecyclingRecipesMixin {
    @Shadow(remap=false)
    private static int calculateVoltageMultiplier(List<MaterialStack> materials) {
        return 0;
    }

    @Shadow(remap=false)
    private static List<ItemStack> finalizeOutputs(List<MaterialStack> materials, int maxOutputs, Function<MaterialStack, ItemStack> toItemStackMapper) {
        return null;
    }

    @Shadow(remap=false)
    private static int calculateDuration(List<ItemStack> materials) {
        return 0;
    }

    @Shadow(remap=false)
    private static List<MaterialStack> combineStacks(List<MaterialStack> rawList) {
        return null;
    }

    @Shadow(remap=false)
    private static boolean needsRecyclingCategory(@Nullable TagPrefix prefix, @Nullable MaterialStack inputStack, @NotNull List<ItemStack> outputs) {
        return false;
    }

    @Shadow(remap=false)
    private static MaterialStack getArcSmeltingResult(MaterialStack materialStack) {
        return null;
    }

    @Shadow(remap=false)
    private static ItemStack getArcIngotOrDust(@NotNull MaterialStack stack) {
        return null;
    }

    @Overwrite(remap=false)
    public static void init() {
        if (GTCEu.isDev()) {
            return;
        }
        for (Map.Entry entry : ItemMaterialData.ITEM_MATERIAL_INFO.entrySet()) {
            Item item = (Item)entry.getKey();
            if (item instanceof IGTTool) continue;
            RecyclingRecipesMixin.registerRecyclingRecipes(((Item)entry.getKey()).m_7968_(), ((ItemMaterialInfo)entry.getValue()).getMaterials(), false, null);
        }
    }

    @Overwrite(remap=false)
    public static void registerRecyclingRecipes(ItemStack input, List<MaterialStack> components, boolean ignoreArcSmelting, @Nullable TagPrefix prefix) {
        if (GTCEu.isDev()) {
            return;
        }
        List<MaterialStack> materials = components.stream().filter(stack -> stack.material().hasProperty(PropertyKey.DUST)).filter(stack -> stack.amount() >= 403200L).sorted(Comparator.comparingLong(ms -> -ms.amount())).toList();
        if (materials.isEmpty()) {
            return;
        }
        int voltageMultiplier = RecyclingRecipesMixin.calculateVoltageMultiplier(materials);
        if (prefix != TagPrefix.dust) {
            RecyclingRecipesMixin.registerMaceratorRecycling(input, materials, voltageMultiplier);
        }
        if (ignoreArcSmelting) {
            return;
        }
        if (materials.size() == 1) {
            Material m = materials.getFirst().material();
            if (!m.hasProperty(PropertyKey.INGOT)) {
                return;
            }
            if (ChemicalHelper.getPrefix((ItemLike)input.m_41720_()) == TagPrefix.ingot && ((IngotProperty)m.getProperty(PropertyKey.INGOT)).getArcSmeltingInto() == m) {
                return;
            }
            if (prefix == TagPrefix.dust && m.hasFlag(MaterialFlags.IS_MAGNETIC)) {
                return;
            }
        }
        RecyclingRecipesMixin.registerArcRecycling(input, materials, prefix);
    }

    @Overwrite(remap=false)
    private static void registerMaceratorRecycling(ItemStack input, List<MaterialStack> materials, int multiplier) {
        List<ItemStack> outputs = RecyclingRecipesMixin.finalizeOutputs(materials, GTRecipeTypes.MACERATOR_RECIPES.getMaxOutputs((RecipeCapability)ItemRecipeCapability.CAP), ChemicalHelper::getDust);
        if (outputs != null && !outputs.isEmpty()) {
            ResourceLocation itemPath = ItemUtils.getIdLocation((Item)input.m_41720_());
            GTRecipeBuilder builder = GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_" + itemPath.m_135815_()).outputItems((ItemStack[])outputs.toArray(ItemStack[]::new)).duration(RecyclingRecipesMixin.calculateDuration(outputs)).EUt(2L * (long)multiplier);
            builder.inputItems(input);
            builder.category(GTRecipeCategories.MACERATOR_RECYCLING);
            builder.save();
        }
    }

    @Overwrite(remap=false)
    private static void registerArcRecycling(ItemStack input, List<MaterialStack> materials, @Nullable TagPrefix prefix) {
        MaterialStack ms = ChemicalHelper.getMaterialStack((ItemStack)input);
        if (prefix != TagPrefix.dust || ms.isEmpty() || !ms.material().hasProperty(PropertyKey.BLAST)) {
            if (prefix != TagPrefix.block) {
                List<ItemStack> outputs = RecyclingRecipesMixin.finalizeOutputs(materials = RecyclingRecipesMixin.combineStacks(materials.stream().map(RecyclingRecipesMixin::getArcSmeltingResult).filter(Objects::nonNull).collect(Collectors.toList())), GTRecipeTypes.ARC_FURNACE_RECIPES.getMaxOutputs((RecipeCapability)ItemRecipeCapability.CAP), RecyclingRecipesMixin::getArcIngotOrDust);
                if (outputs != null && !outputs.isEmpty()) {
                    ResourceLocation itemPath = ItemUtils.getIdLocation((Item)input.m_41720_());
                    GTRecipeBuilder builder = GTRecipeTypes.ARC_FURNACE_RECIPES.recipeBuilder("arc_" + itemPath.m_135815_()).outputItems((ItemStack[])outputs.toArray(ItemStack[]::new)).duration(RecyclingRecipesMixin.calculateDuration(outputs)).EUt((long)GTValues.VA[1]);
                    builder.inputItems(input.m_41777_());
                    if (RecyclingRecipesMixin.needsRecyclingCategory(prefix, ms, outputs)) {
                        builder.category(GTRecipeCategories.ARC_FURNACE_RECYCLING);
                    }
                    builder.save();
                }
            } else if (!ms.isEmpty() && !ms.material().hasProperty(PropertyKey.GEM)) {
                ItemStack output = ChemicalHelper.get((TagPrefix)TagPrefix.ingot, (Material)((IngotProperty)ms.material().getProperty(PropertyKey.INGOT)).getArcSmeltingInto(), (int)((int)(TagPrefix.block.getMaterialAmount(ms.material()) / 3628800L)));
                ResourceLocation itemPath = ItemUtils.getIdLocation((Item)input.m_41720_());
                GTRecipeBuilder builder = GTRecipeTypes.ARC_FURNACE_RECIPES.recipeBuilder("arc_" + itemPath.m_135815_()).outputItems(output).duration(RecyclingRecipesMixin.calculateDuration(Collections.singletonList(output))).EUt((long)GTValues.VA[1]);
                builder.inputItems(input.m_41777_());
                if (ms.material().hasFlag(MaterialFlags.IS_MAGNETIC) || ms.material() == ((IngotProperty)ms.material().getProperty(PropertyKey.INGOT)).getArcSmeltingInto()) {
                    builder.category(GTRecipeCategories.ARC_FURNACE_RECYCLING);
                }
                builder.save();
            }
        }
    }
}

