/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.gtm.machine;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IWorkableMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.WorkableTieredPartMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.machine.multiblock.part.MaintenanceHatchPartMachine;
import com.gtolib.GTOCore;
import com.gtolib.api.machine.feature.IDroneInteractionMachine;
import com.gtolib.api.machine.feature.multiblock.IDroneControlCenterMachine;
import com.gtolib.api.machine.trait.IEnhancedRecipeLogic;
import com.gtolib.api.misc.Drone;
import com.gtolib.api.recipe.IdleReason;
import com.gtolib.utils.MathUtil;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MaintenanceHatchPartMachine.class})
public abstract class MaintenanceHatchPartMachineMixin
extends WorkableTieredPartMachine
implements IMaintenanceMachine,
IDroneInteractionMachine {
    @Shadow(remap=false)
    protected int timeActive;
    @Unique
    private IDroneControlCenterMachine gtolib$cache;

    protected MaintenanceHatchPartMachineMixin(MetaMachineBlockEntity holder, int tier) {
        super(holder, tier);
    }

    @Shadow(remap=false)
    public abstract void fixAllMaintenanceProblems();

    @Unique
    public IDroneControlCenterMachine getNetMachineCache() {
        return this.gtolib$cache;
    }

    @Unique
    public void setNetMachineCache(IDroneControlCenterMachine cache) {
        this.gtolib$cache = cache;
    }

    public void calculateMaintenance(IMaintenanceMachine maintenanceMachine, int duration) {
        if (maintenanceMachine.isFullAuto()) {
            return;
        }
        int pa = this.getController().getParts().length;
        this.timeActive = MathUtil.saturatedCast((long)((long)((float)this.timeActive + (float)duration * this.getDurationMultiplier() * (float)GTOCore.difficulty * (float)pa)));
        double value = (double)((float)this.timeActive / 3456000.0f) - 0.7;
        if ((double)GTValues.RNG.m_188501_() <= value && !GTOCore.isEasy()) {
            this.timeActive = 0;
            this.causeRandomMaintenanceProblems();
            maintenanceMachine.setTaped(false);
        }
    }

    @Inject(method={"fixMaintenanceProblems"}, at={@At(value="HEAD")}, remap=false)
    private void fixMaintenanceProblems(Player entityPlayer, CallbackInfo ci) {
        this.timeActive = 0;
    }

    @Overwrite(remap=false)
    @Nullable
    public GTRecipe modifyRecipe(IWorkableMultiController controller, @NotNull GTRecipe recipe) {
        if (this.hasMaintenanceProblems()) {
            ((IEnhancedRecipeLogic)controller.getRecipeLogic()).gtolib$setIdleReason(IdleReason.MAINTENANCE_BROKEN.reason());
            return null;
        }
        float durationMultiplier = this.getDurationMultiplier();
        if (durationMultiplier != 1.0f) {
            recipe.duration = Math.max(1, (int)((float)recipe.duration * durationMultiplier));
        }
        return recipe;
    }

    @Inject(method={"update"}, at={@At(value="INVOKE", target="Lcom/gregtechceu/gtceu/common/machine/multiblock/part/MaintenanceHatchPartMachine;consumeDuctTape(Lnet/minecraftforge/items/IItemHandler;I)Z")}, remap=false, cancellable=true)
    private void update(CallbackInfo ci) {
        int eu;
        Drone drone;
        IDroneControlCenterMachine centerMachine = (IDroneControlCenterMachine)this.getNetMachine();
        if (centerMachine != null && (drone = this.getFirstUsableDrone(arg_0 -> MaintenanceHatchPartMachineMixin.lambda$update$0(eu = this.getNumMaintenanceProblems() << 6, arg_0))) != null && drone.start(10, eu, "gtocore.drone.maintaining")) {
            this.fixAllMaintenanceProblems();
            ci.cancel();
        }
    }

    public void onUnload() {
        super.onUnload();
        this.removeNetMachineCache();
    }

    private static /* synthetic */ boolean lambda$update$0(int eu, Drone d) {
        return d.getCharge() >= (long)eu;
    }
}

