/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.gtm.machine;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.machine.multiblock.steam.LargeBoilerMachine;
import com.gtolib.api.machine.feature.multiblock.IEnhancedMultiblockMachine;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={LargeBoilerMachine.class})
public abstract class LargeBoilerMachineMixin
extends WorkableMultiblockMachine
implements IExplosionMachine,
IEnhancedMultiblockMachine {
    @Unique
    private static final Fluid gtolib$STEAM = GTMaterials.Steam.getFluid();
    @Shadow(remap=false)
    private int currentTemperature;
    @Shadow(remap=false)
    @Final
    public int maxTemperature;
    @Shadow(remap=false)
    @Final
    public int heatSpeed;
    @Shadow(remap=false)
    private int throttle;
    @Unique
    private boolean gtolib$hasNoWater;
    @Shadow(remap=false)
    private int steamGenerated;

    protected LargeBoilerMachineMixin(MetaMachineBlockEntity holder, Object ... args) {
        super(holder, args);
    }

    public boolean alwaysSearchRecipe() {
        return true;
    }

    @Overwrite(remap=false)
    protected void updateCurrentTemperature() {
        int water;
        if (this.recipeLogic.isWorking()) {
            if (this.getOffsetTimer() % 5 == 0 && this.currentTemperature < this.maxTemperature) {
                this.currentTemperature = Mth.m_14045_((int)(this.currentTemperature + this.heatSpeed), (int)0, (int)this.maxTemperature);
            }
        } else if (this.currentTemperature > 0) {
            --this.currentTemperature;
        }
        if (this.currentTemperature > 100 && this.isFormed() && this.getOffsetTimer() % 5 == 0 && (water = this.currentTemperature * this.throttle * 5 / 16000) > 0) {
            if (this.inputFluid((Fluid)Fluids.f_76193_, water)) {
                this.steamGenerated = this.currentTemperature * this.throttle * 5 / 100;
                if (this.steamGenerated > 0) {
                    this.outputFluid(gtolib$STEAM, this.steamGenerated);
                }
                if (this.gtolib$hasNoWater) {
                    this.doExplosion(2.0f);
                }
            } else {
                this.gtolib$hasNoWater = true;
            }
        }
    }
}

