/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.gtm.api.recipe;

import com.google.gson.JsonElement;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gtolib.api.recipe.ingredient.FastFluidIngredient;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FluidIngredient.class})
public class FluidIngredientMixin {
    @Overwrite(remap=false)
    public static FluidIngredient of() {
        return FastFluidIngredient.EMPTY;
    }

    @Inject(method={"of(I[Lnet/minecraft/world/level/material/Fluid;)Lcom/gregtechceu/gtceu/api/recipe/ingredient/FluidIngredient;"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void items(int amount, Fluid[] items, CallbackInfoReturnable<FluidIngredient> cir) {
        cir.setReturnValue((Object)FastFluidIngredient.of((int)amount, (Fluid[])items));
    }

    @Inject(method={"of([Lnet/minecraftforge/fluids/FluidStack;)Lcom/gregtechceu/gtceu/api/recipe/ingredient/FluidIngredient;"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void stacks(FluidStack[] stacks, CallbackInfoReturnable<FluidIngredient> cir) {
        cir.setReturnValue((Object)FastFluidIngredient.of((FluidStack[])stacks));
    }

    @Overwrite(remap=false)
    public static FluidIngredient of(Stream<Fluid> stacks, int amount, CompoundTag nbt) {
        return FastFluidIngredient.of(stacks, (int)amount, (CompoundTag)nbt);
    }

    @Overwrite(remap=false)
    public static FluidIngredient of(TagKey<Fluid> tag, int amount) {
        throw new UnsupportedOperationException("TagKey is not supported");
    }

    @Overwrite(remap=false)
    public static FluidIngredient of(TagKey<Fluid> tag, int amount, CompoundTag nbt) {
        throw new UnsupportedOperationException("TagKey is not supported");
    }

    @Overwrite(remap=false)
    public static FluidIngredient fromNetwork(FriendlyByteBuf buf) {
        return FastFluidIngredient.fromNetwork((FriendlyByteBuf)buf);
    }

    @Overwrite(remap=false)
    public static FluidIngredient fromJson(@Nullable JsonElement json) {
        return FastFluidIngredient.fromJson((JsonElement)json);
    }

    @Overwrite(remap=false)
    public static FluidIngredient fromJson(@Nullable JsonElement json, boolean allowAir) {
        return FastFluidIngredient.fromJson((JsonElement)json);
    }
}

