/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.gtm.api.machine;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfiguratorButton;
import com.gregtechceu.gtceu.api.machine.feature.IVoidable;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.gtolib.api.gui.OverclockConfigurator;
import com.gtolib.api.machine.feature.IElectricMachine;
import com.gtolib.api.machine.feature.IOverclockConfigMachine;
import com.gtolib.api.machine.feature.IPowerAmplifierMachine;
import com.gtolib.api.machine.feature.IUpgradeMachine;
import com.gtolib.utils.MachineUtils;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorkableElectricMultiblockMachine.class})
public abstract class WorkableElectricMultiblockMachineMixin
extends WorkableMultiblockMachine
implements IDisplayUIMachine,
IOverclockConfigMachine,
IUpgradeMachine,
IPowerAmplifierMachine,
IElectricMachine {
    @Unique
    private double gtolib$powerAmplifier;
    @Unique
    private boolean gtolib$hasPowerAmplifier;
    @Unique
    private double gtolib$speed;
    @Unique
    private double gtolib$energy;
    @Unique
    private int gtolib$ocLimit;
    @Unique
    @Persisted
    private IVoidable.VoidingMode voidingMode = IVoidable.VoidingMode.VOID_NONE;
    @Shadow(remap=false)
    protected EnergyContainerList energyContainer;
    @Shadow(remap=false)
    protected boolean batchEnabled;

    @Shadow(remap=false)
    public abstract boolean isGenerator();

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    private void init(MetaMachineBlockEntity holder, Object[] args, CallbackInfo ci) {
        this.gtolib$powerAmplifier = 1.0;
        this.gtolib$speed = 1.0;
        this.gtolib$energy = 1.0;
        this.gtolib$ocLimit = 20;
    }

    protected WorkableElectricMultiblockMachineMixin(MetaMachineBlockEntity holder, Object ... args) {
        super(holder, args);
    }

    public GTRecipe fullModifyRecipe(GTRecipe recipe) {
        return this.doModifyRecipe(recipe);
    }

    public boolean hasCheckButton() {
        return true;
    }

    public void gtolib$setOCLimit(int number) {
        this.gtolib$ocLimit = number;
    }

    public int gtolib$getOCLimit() {
        return this.gtolib$ocLimit;
    }

    public void saveCustomPersistedData(@NotNull CompoundTag tag, boolean forDrop) {
        super.saveCustomPersistedData(tag, forDrop);
        if (this.gtolib$canUpgraded()) {
            tag.m_128347_("speed", this.gtolib$speed);
            tag.m_128347_("energy", this.gtolib$energy);
        }
        if (this.isGenerator()) {
            return;
        }
        tag.m_128405_("ocLimit", this.gtolib$ocLimit);
    }

    public void loadCustomPersistedData(@NotNull CompoundTag tag) {
        super.loadCustomPersistedData(tag);
        if (this.gtolib$canUpgraded()) {
            double energy;
            double speed = tag.m_128459_("speed");
            if (speed != 0.0) {
                this.gtolib$speed = speed;
            }
            if ((energy = tag.m_128459_("energy")) != 0.0) {
                this.gtolib$energy = energy;
            }
        }
        if (this.isGenerator()) {
            return;
        }
        this.gtolib$ocLimit = tag.m_128451_("ocLimit");
    }

    @Overwrite(remap=false)
    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        configuratorPanel.attachConfigurators(new IFancyConfigurator[]{new IFancyConfiguratorButton.Toggle((IGuiTexture)GuiTextures.BUTTON_POWER.getSubTexture(0.0, 0.0, 1.0, 0.5), (IGuiTexture)GuiTextures.BUTTON_POWER.getSubTexture(0.0, 0.5, 1.0, 0.5), () -> ((WorkableElectricMultiblockMachineMixin)this).isWorkingEnabled(), (clickData, pressed) -> this.setWorkingEnabled((boolean)pressed)).setTooltipsSupplier(pressed -> List.of(Component.m_237115_((String)(pressed != false ? "behaviour.soft_hammer.enabled" : "behaviour.soft_hammer.disabled"))))});
        if (!this.isGenerator()) {
            if (this.hasOverclockConfig()) {
                configuratorPanel.attachConfigurators(new IFancyConfigurator[]{new OverclockConfigurator((IOverclockConfigMachine)this)});
            }
            if (this.hasBatchConfig()) {
                MachineUtils.attachBatchConfigurators((ConfiguratorPanel)configuratorPanel, () -> ((WorkableElectricMultiblockMachineMixin)this).isBatchEnabled(), (clickData, pressed) -> {
                    this.batchEnabled = pressed;
                });
            }
        }
        MachineUtils.attachStructureCheckConfigurators((ConfiguratorPanel)configuratorPanel, (IMultiController)this);
        for (Direction direction : Direction.values()) {
            IFancyConfigurator configurator;
            if (!this.getCoverContainer().hasCover(direction) || (configurator = this.getCoverContainer().getCoverAtSide(direction).getConfigurator()) == null) continue;
            configuratorPanel.attachConfigurators(new IFancyConfigurator[]{configurator});
        }
    }

    @Overwrite(remap=false)
    public void addDisplayText(List<Component> textList) {
        MachineUtils.addMachineText(textList, (WorkableMultiblockMachine)this, t -> textList.add((Component)Component.m_237115_((String)"gtceu.gui.multiblock_no_voiding.0").m_130946_(": ").m_7220_(ComponentPanelWidget.withButton((Component)LangHandler.getFromMultiLang((String)this.voidingMode.m_7912_(), (int)1), (String)"voidingMode"))));
        for (IMultiPart part : this.getParts()) {
            part.addMultiText(textList);
        }
    }

    public void handleDisplayClick(String componentData, ClickData clickData) {
        if (!clickData.isRemote && componentData.equals("voidingMode")) {
            this.voidingMode = this.voidingMode.ordinal() + 1 < IVoidable.VoidingMode.VALUES.length ? IVoidable.VoidingMode.VALUES[this.voidingMode.ordinal() + 1] : IVoidable.VoidingMode.VALUES[0];
        }
    }

    @NotNull
    public IEnergyContainer gtolib$getEnergyContainer() {
        return this.energyContainer;
    }

    public void gtolib$setSpeed(double speed) {
        this.gtolib$speed = speed;
    }

    public void gtolib$setEnergy(double energy) {
        this.gtolib$energy = energy;
    }

    public double gtolib$getSpeed() {
        return this.gtolib$speed;
    }

    public double gtolib$getEnergy() {
        return this.gtolib$energy;
    }

    public boolean gtolib$canUpgraded() {
        return false;
    }

    public double gtolib$getPowerAmplifier() {
        return this.gtolib$powerAmplifier;
    }

    public void gtolib$setPowerAmplifier(double powerAmplifier) {
        this.gtolib$powerAmplifier = powerAmplifier;
    }

    public boolean gtolib$noPowerAmplifier() {
        return !this.gtolib$hasPowerAmplifier;
    }

    public void gtolib$setHasPowerAmplifier(boolean hasPowerAmplifier) {
        this.gtolib$hasPowerAmplifier = hasPowerAmplifier;
    }

    public void setVoidingMode(IVoidable.VoidingMode mode) {
        this.voidingMode = mode;
    }

    public IVoidable.VoidingMode getVoidingMode() {
        return this.voidingMode;
    }
}

