/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.gtm;

import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.common.recipe.condition.RockBreakerCondition;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.utils.FluidUtils;
import net.minecraft.core.Direction;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={RockBreakerCondition.class})
public abstract class RockBreakerConditionMixin
extends RecipeCondition {
    @Shadow(remap=false)
    private Fluid A;
    @Shadow(remap=false)
    private Fluid B;

    @Overwrite(remap=false)
    public boolean testCondition(@NotNull GTRecipe recipe, @NotNull RecipeLogic recipeLogic) {
        if (this.A == null || this.B == null) {
            this.A = FluidUtils.getFluid((String)recipe.data.m_128461_("fluidA"));
            this.B = FluidUtils.getFluid((String)recipe.data.m_128461_("fluidB"));
        }
        boolean hasFluidA = false;
        boolean hasFluidB = false;
        Direction[] directionArray = recipeLogic.machine;
        if (directionArray instanceof ElectricMultiblockMachine) {
            ElectricMultiblockMachine MMachine = (ElectricMultiblockMachine)directionArray;
            long[] as = MMachine.getFluidAmount(new Fluid[]{this.A, this.B});
            if (as[0] > 0L) {
                hasFluidA = true;
            }
            if (as[1] > 0L) {
                hasFluidB = true;
            }
        } else {
            for (Direction side : GTUtil.DIRECTIONS) {
                if (side.m_122434_() == Direction.Axis.Y) continue;
                Fluid fluid = recipeLogic.machine.self().getNeighborFluidState(side).m_76152_();
                if (fluid == this.A) {
                    hasFluidA = true;
                } else if (fluid == this.B) {
                    hasFluidB = true;
                }
                if (!hasFluidA || !hasFluidB) continue;
                return true;
            }
        }
        return hasFluidA && hasFluidB;
    }
}

