/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.ae2.stacks;

import appeng.api.stacks.AEItemKey;
import appeng.core.AELog;
import com.fast.recipesearch.IntLongMap;
import com.gtolib.IItem;
import com.gtolib.api.ae2.stacks.IAEItemKey;
import com.gtolib.api.misc.IMapValueCache;
import com.gtolib.api.recipe.lookup.MapIngredient;
import com.gtolib.utils.RLUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={AEItemKey.class})
public abstract class AEItemKeyMixin
implements IAEItemKey {
    @Shadow(remap=false)
    private int maxStackSize;
    @Shadow(remap=false)
    @Final
    private Item item;
    @Shadow(remap=false)
    @Nullable
    private ItemStack readOnlyStack;
    @Unique
    private int[] gtocore$is;

    @Shadow(remap=false)
    public abstract ItemStack getReadOnlyStack();

    @Shadow(remap=false)
    @Nullable
    public abstract CompoundTag getTag();

    @Overwrite(remap=false)
    public ResourceLocation getId() {
        return ((IItem)this.item).gtolib$getIdLocation();
    }

    @Overwrite(remap=false)
    @Nullable
    public static AEItemKey of(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item == Items.f_41852_) {
            return null;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null || tag.m_128456_()) {
            return ((IItem)item.m_5456_()).gtolib$getAEKey();
        }
        return (AEItemKey)IMapValueCache.ITEM_KEY_CACHE.get((Object)stack);
    }

    @Overwrite(remap=false)
    public static AEItemKey of(ItemLike itemLike) {
        Item item = itemLike.m_5456_();
        return ((IItem)item).gtolib$getAEKey();
    }

    @Overwrite(remap=false)
    public static AEItemKey of(ItemLike itemLike, @Nullable CompoundTag tag) {
        Item item = itemLike.m_5456_();
        if (tag == null || tag.m_128456_()) {
            return ((IItem)item).gtolib$getAEKey();
        }
        ItemStack stack = new ItemStack((ItemLike)item, 1);
        stack.m_41751_(tag);
        return (AEItemKey)IMapValueCache.ITEM_KEY_CACHE.get((Object)stack);
    }

    @Overwrite(remap=false)
    @Nullable
    public static AEItemKey fromTag(CompoundTag tag) {
        try {
            CompoundTag extraTag;
            Item item = (Item)BuiltInRegistries.f_257033_.m_6612_(RLUtils.parse((String)tag.m_128461_("id"))).orElseThrow(() -> new IllegalArgumentException("Unknown item id."));
            if (item == Items.f_41852_) {
                return null;
            }
            CompoundTag compoundTag = extraTag = tag.m_128441_("tag") ? tag.m_128469_("tag") : null;
            if (extraTag == null || extraTag.m_128456_()) {
                return ((IItem)item).gtolib$getAEKey();
            }
            ItemStack stack = new ItemStack((ItemLike)item, 1);
            stack.m_41751_(extraTag);
            return (AEItemKey)IMapValueCache.ITEM_KEY_CACHE.get((Object)stack);
        }
        catch (Exception e) {
            AELog.debug((String)"Tried to load an invalid item key from NBT: %s", (Object[])new Object[]{tag, e});
            return null;
        }
    }

    @Overwrite(remap=false)
    public void writeToPacket(FriendlyByteBuf data) {
        data.m_130130_(Item.m_41393_((Item)this.item));
        CompoundTag compoundTag = null;
        if (this.item.m_41465_() || this.item.m_41468_()) {
            compoundTag = this.item.getShareTag(this.getReadOnlyStack());
        }
        data.m_130079_(compoundTag);
    }

    @Overwrite(remap=false)
    public static AEItemKey fromPacket(FriendlyByteBuf data) {
        Item item = Item.m_41445_((int)data.m_130242_());
        CompoundTag shareTag = data.m_130260_();
        if (shareTag == null || shareTag.m_128456_()) {
            return ((IItem)item).gtolib$getAEKey();
        }
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.readShareTag(shareTag);
        return (AEItemKey)IMapValueCache.ITEM_KEY_CACHE.get((Object)stack);
    }

    @Overwrite(remap=false)
    public String toString() {
        String idString = ((IItem)this.item).gtolib$getIdString();
        return this.getTag() == null ? idString : idString + " (+tag)";
    }

    public void gtolib$setMaxStackSize(int max) {
        this.maxStackSize = max;
    }

    public void gtolib$setReadOnlyStack(ItemStack stack) {
        this.readOnlyStack = stack;
    }

    public void gtolib$convert(long amount, IntLongMap map) {
        if (this.gtocore$is == null) {
            IntLongMap m = new IntLongMap();
            MapIngredient.ITEM_CONVERTER.convert((Object)this.getReadOnlyStack(), 1L, m);
            this.gtocore$is = m.toIntArray();
        }
        for (int i : this.gtocore$is) {
            map.add(i, amount);
        }
    }
}

