/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.ae2.network;

import appeng.core.sync.packets.GuiDataSyncPacket;
import com.gtocore.config.GTOConfig;
import com.gtolib.GTOCore;
import com.gtolib.api.ae2.gui.hooks.IGuiDataSyncPacketExt;
import com.gtolib.api.ae2.me2in1.Me2in1Menu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiDataSyncPacket.class})
public class GuiDataSyncPacketMixin
implements IGuiDataSyncPacketExt {
    @Final
    @Shadow(remap=false)
    private int containerId;
    @Unique
    private boolean gtolib$isInnerMenuPacket = false;

    @Inject(remap=false, at={@At(value="HEAD")}, method={"clientPacketData"}, cancellable=true)
    private void clientPacketData(Player player, CallbackInfo ci) {
        AbstractContainerMenu c = player.f_36096_;
        if (c instanceof Me2in1Menu) {
            Me2in1Menu baseMenu = (Me2in1Menu)c;
            if (c.f_38840_ == this.containerId && this.gtolib$isInnerMenuPacket()) {
                baseMenu.getEncoding().receiveServerSyncData((GuiDataSyncPacket)this);
                ci.cancel();
            }
        }
    }

    @Inject(remap=false, at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/network/FriendlyByteBuf;)V"})
    private void hookReceive(FriendlyByteBuf buf, CallbackInfo ci) {
        try {
            int lastBooleanIndex = buf.writerIndex() - 1;
            this.gtolib$isInnerMenuPacket = buf.getBoolean(lastBooleanIndex);
        }
        catch (Exception e) {
            if (GTOConfig.INSTANCE.aeLog) {
                GTOCore.LOGGER.warn("Failed to read gtolib$isInnerMenuPacket from GuiDataSyncPacket, assuming false", (Throwable)e);
            }
            this.gtolib$isInnerMenuPacket = false;
        }
    }

    public boolean gtolib$isInnerMenuPacket() {
        return this.gtolib$isInnerMenuPacket;
    }

    public void gtolib$setInnerMenuPacket(boolean innerMenuPacket) {
        this.gtolib$isInnerMenuPacket = innerMenuPacket;
    }
}

