/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.ae2.gui;

import appeng.client.Point;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.WidgetContainer;
import com.fast.fastcollection.O2OOpenCacheHashMap;
import com.google.common.base.Preconditions;
import com.gtolib.api.ae2.gui.hooks.IStylelessCompositeWidget;
import com.gtolib.api.ae2.gui.hooks.IWidgetsGetter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.Rect2i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={WidgetContainer.class})
public class WidgetContainerMixin
implements IWidgetsGetter {
    @Final
    @Shadow(remap=false)
    private Map<String, AbstractWidget> widgets;
    @Final
    @Shadow(remap=false)
    private Map<String, ICompositeWidget> compositeWidgets;
    @Unique
    private final Map<String, IStylelessCompositeWidget> gtolib$compositeStylelessWidgets = new O2OOpenCacheHashMap();

    public Map<String, IStylelessCompositeWidget> gtolib$getCompositeStylelessWidgets() {
        return this.gtolib$compositeStylelessWidgets;
    }

    public Map<String, ICompositeWidget> gtolib$getCompositeWidgets() {
        return this.compositeWidgets;
    }

    public Map<String, AbstractWidget> gtolib$getWidgets() {
        return this.widgets;
    }

    @Inject(method={"add(Ljava/lang/String;Lappeng/client/gui/ICompositeWidget;)V"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void gtolib$addCompositeWidget(String id, ICompositeWidget widget2, CallbackInfo ci) {
        if (widget2 instanceof IStylelessCompositeWidget) {
            IStylelessCompositeWidget styleless = (IStylelessCompositeWidget)widget2;
            Preconditions.checkState((!this.widgets.containsKey(id) ? 1 : 0) != 0, (String)"%s already used for widget", (Object)id);
            Preconditions.checkState((!this.compositeWidgets.containsKey(id) ? 1 : 0) != 0, (String)"%s already used for widget", (Object)id);
            styleless.initialize(id, (WidgetContainer)this);
            if (this.gtolib$compositeStylelessWidgets.put(id, styleless) == null) {
                ci.cancel();
            } else {
                throw new IllegalStateException("Duplicate id: " + id);
            }
        }
    }

    @Inject(method={"populateScreen"}, at={@At(value="HEAD")}, remap=false)
    private void gtolib$populateScreen(Consumer<AbstractWidget> addWidget, Rect2i bounds, AEBaseScreen<?> screen, CallbackInfo ci) {
        Rect2i relativeBounds = new Rect2i(0, 0, bounds.m_110090_(), bounds.m_110091_());
        for (Map.Entry<String, IStylelessCompositeWidget> entry : this.gtolib$compositeStylelessWidgets.entrySet()) {
            IStylelessCompositeWidget widget2 = entry.getValue();
            widget2.adjustPosition(relativeBounds);
            widget2.populateScreen(addWidget, bounds, screen);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, remap=false)
    public void tick(CallbackInfo ci) {
        for (IStylelessCompositeWidget widget2 : this.gtolib$compositeStylelessWidgets.values()) {
            if (!widget2.isVisible()) continue;
            widget2.tick();
        }
    }

    @Inject(method={"updateBeforeRender"}, at={@At(value="HEAD")}, remap=false)
    public void updateBeforeRender(CallbackInfo ci) {
        for (IStylelessCompositeWidget widget2 : this.gtolib$compositeStylelessWidgets.values()) {
            if (!widget2.isVisible()) continue;
            widget2.updateBeforeRender();
        }
    }

    @Inject(method={"drawBackgroundLayer"}, at={@At(value="HEAD")}, remap=false)
    public void drawBackgroundLayer(GuiGraphics guiGraphics, Rect2i bounds, Point mouse, CallbackInfo ci) {
        for (IStylelessCompositeWidget widget2 : this.gtolib$compositeStylelessWidgets.values()) {
            if (!widget2.isVisible()) continue;
            widget2.drawBackgroundLayer(guiGraphics, bounds, mouse);
        }
    }

    @Inject(method={"drawForegroundLayer"}, at={@At(value="HEAD")}, remap=false)
    public void drawForegroundLayer(GuiGraphics poseStack, Rect2i bounds, Point mouse, CallbackInfo ci) {
        for (IStylelessCompositeWidget widget2 : this.gtolib$compositeStylelessWidgets.values()) {
            if (!widget2.isVisible()) continue;
            widget2.drawForegroundLayer(poseStack, bounds, mouse);
        }
    }

    @Inject(method={"onMouseDown"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    public void onMouseDown(Point mousePos, int btn, CallbackInfoReturnable<Boolean> cir) {
        for (IStylelessCompositeWidget widget2 : this.gtolib$compositeStylelessWidgets.values()) {
            if (!widget2.isVisible() || !widget2.wantsAllMouseDownEvents() && !mousePos.isIn(widget2.getBounds()) || !widget2.onMouseDown(mousePos, btn)) continue;
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"onMouseUp"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    public void onMouseUp(Point mousePos, int btn, CallbackInfoReturnable<Boolean> cir) {
        for (IStylelessCompositeWidget widget2 : this.gtolib$compositeStylelessWidgets.values()) {
            if (!widget2.isVisible() || !widget2.wantsAllMouseUpEvents() && !mousePos.isIn(widget2.getBounds()) || !widget2.onMouseUp(mousePos, btn)) continue;
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"onMouseDrag"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    public void onMouseDrag(Point mousePos, int btn, CallbackInfoReturnable<Boolean> cir) {
        for (IStylelessCompositeWidget widget2 : this.gtolib$compositeStylelessWidgets.values()) {
            if (!widget2.isVisible() || !widget2.onMouseDrag(mousePos, btn)) continue;
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"onMouseWheel"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    void onMouseWheel(Point mousePos, double wheelDelta, CallbackInfoReturnable<Boolean> cir) {
        for (IStylelessCompositeWidget widget2 : this.gtolib$compositeStylelessWidgets.values()) {
            if (!widget2.isVisible() || !mousePos.isIn(widget2.getBounds()) || !widget2.onMouseWheel(mousePos, wheelDelta)) continue;
            cir.setReturnValue((Object)true);
        }
        for (IStylelessCompositeWidget widget2 : this.gtolib$compositeStylelessWidgets.values()) {
            if (!widget2.isVisible() || !widget2.wantsAllMouseWheelEvents() || !widget2.onMouseWheel(mousePos, wheelDelta)) continue;
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"addExclusionZones"}, at={@At(value="HEAD")}, remap=false)
    public void addExclusionZones(List<Rect2i> exclusionZones, Rect2i bounds, CallbackInfo ci) {
        for (IStylelessCompositeWidget widget2 : this.gtolib$compositeStylelessWidgets.values()) {
            if (!widget2.isVisible()) continue;
            widget2.addExclusionZones(exclusionZones, bounds);
        }
    }

    @Redirect(method={"getTooltip"}, at=@At(value="INVOKE", target="Ljava/util/Map;values()Ljava/util/Collection;"), remap=false)
    private <V> Collection<V> gtolib$getTooltip(Map<?, V> instance) {
        if (instance == this.compositeWidgets) {
            return this.gtolib$getMixedCompositeWidgets().map(Map::values).orElseGet(() -> this.compositeWidgets.values());
        }
        return instance.values();
    }

    @Redirect(method={"hitTest"}, at=@At(value="INVOKE", target="Ljava/util/Map;values()Ljava/util/Collection;"), remap=false)
    private <V> Collection<V> gtolib$hitTest(Map<?, V> instance, Point mousePos) {
        if (instance == this.compositeWidgets) {
            return this.gtolib$getMixedCompositeWidgets().map(Map::values).orElseGet(() -> this.compositeWidgets.values());
        }
        return instance.values();
    }

    @Unique
    @NotNull
    private Optional<Map<String, ICompositeWidget>> gtolib$getMixedCompositeWidgets() {
        if (this.compositeWidgets.isEmpty() && this.gtolib$compositeStylelessWidgets.isEmpty()) {
            return Optional.empty();
        }
        O2OOpenCacheHashMap mixed = new O2OOpenCacheHashMap(this.compositeWidgets);
        mixed.putAll(this.gtolib$compositeStylelessWidgets);
        return Optional.of(mixed);
    }
}

