/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.ae2.crafting;

import appeng.api.config.Actionable;
import appeng.api.config.LockCraftingMode;
import appeng.api.crafting.IPatternDetails;
import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.networking.IGrid;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.helpers.patternprovider.PatternProviderTarget;
import appeng.util.ConfigManager;
import appeng.util.inv.AppEngInternalInventory;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.utils.cache.BlockEntityDirectionCache;
import com.gtolib.api.ae2.BlockingType;
import com.gtolib.api.ae2.GTOSettings;
import com.gtolib.api.ae2.IPatternProviderLogic;
import com.gtolib.api.ae2.MyPatternDetailsHelper;
import com.gtolib.api.ae2.PatternProviderTargetCache;
import com.gtolib.api.ae2.machine.ICustomCraftingMachine;
import com.gtolib.api.blockentity.IDirectionCacheBlockEntity;
import com.gtolib.utils.holder.BooleanHolder;
import com.gtolib.utils.holder.ObjectHolder;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PatternProviderLogic.class}, remap=false)
public abstract class PatternProviderLogicMixin
implements IPatternProviderLogic {
    @Unique
    private final Long2ObjectOpenHashMap<IPatternDetails> gtolib$cachePatternPos = new Long2ObjectOpenHashMap();
    @Unique
    private final Int2ObjectOpenHashMap<IPatternDetails> gtolib$cachePatternDir = new Int2ObjectOpenHashMap();
    @Final
    @Shadow
    private PatternProviderLogicHost host;
    @Final
    @Shadow
    private IManagedGridNode mainNode;
    @Final
    @Shadow
    private IActionSource actionSource;
    @Final
    @Shadow
    private ConfigManager configManager;
    @Final
    @Shadow
    private List<IPatternDetails> patterns;
    @Final
    @Shadow
    private Set<AEKey> patternInputs;
    @Shadow
    @Final
    private AppEngInternalInventory patternInventory;
    @Shadow
    @Final
    private List<GenericStack> sendList;
    @Unique
    private int gtocore$pushedCount = 1024;
    @Shadow
    private Direction sendDirection;
    @Unique
    private PatternProviderTargetCache[] gtolib$targetCaches;
    @Unique
    private IPatternDetails gtolib$currentPattern;
    @Unique
    private GlobalPos gto$pos;

    @Shadow
    public abstract LockCraftingMode getCraftingLockedReason();

    @Shadow
    protected abstract Set<Direction> getActiveSides();

    @Shadow
    protected abstract void onPushPatternSuccess(IPatternDetails var1);

    @Shadow
    protected abstract boolean adapterAcceptsAll(PatternProviderTarget var1, KeyCounter[] var2);

    @Shadow
    protected abstract void addToSendList(AEKey var1, long var2);

    @Inject(method={"<init>(Lappeng/api/networking/IManagedGridNode;Lappeng/helpers/patternprovider/PatternProviderLogicHost;I)V"}, at={@At(value="TAIL")}, remap=false)
    private void init(IManagedGridNode mainNode, PatternProviderLogicHost host, int patternInventorySize, CallbackInfo ci) {
        this.configManager.registerSetting(GTOSettings.BLOCKING_TYPE, (Enum)BlockingType.NONE);
        this.gtolib$targetCaches = new PatternProviderTargetCache[6];
    }

    public IPatternProviderLogic.PushResult gtolib$pushPattern(IPatternDetails patternDetails, ObjectHolder<KeyCounter[]> inputHolder, Supplier<IPatternProviderLogic.PushResult> pushPatternSuccess) {
        if (!this.mainNode.isActive()) {
            return IPatternProviderLogic.PushResult.GRID_NODE_MISSING;
        }
        if (!this.patterns.contains(patternDetails)) {
            return IPatternProviderLogic.PushResult.PATTERN_DOES_NOT_EXIST;
        }
        BlockEntity be = this.host.getBlockEntity();
        BlockEntityDirectionCache cache = IDirectionCacheBlockEntity.getBlockEntityDirectionCache((BlockEntity)be);
        if (cache == null) {
            return IPatternProviderLogic.PushResult.REJECTED;
        }
        BlockingType setting = (BlockingType)this.configManager.getSetting(GTOSettings.BLOCKING_TYPE);
        this.gtocore$pushedCount = setting == BlockingType.ALL || setting == BlockingType.CONTAIN ? 1 : 1024;
        BooleanSupplier canPush = () -> this.getCraftingLockedReason() == LockCraftingMode.NONE && this.sendList.isEmpty();
        if (!canPush.getAsBoolean()) {
            return IPatternProviderLogic.PushResult.PATTERN_PROVIDER_LOCKED;
        }
        this.gtolib$currentPattern = patternDetails;
        Level level = be.m_58904_();
        BlockPos pos = be.m_58899_();
        BooleanHolder success = new BooleanHolder(false);
        boolean molecular = !patternDetails.supportsPushInputsToExternalInventory();
        for (Direction direction : this.getActiveSides()) {
            IPatternProviderLogic.PushResult result;
            BlockEntity adjBe = cache.getAdjacentBlockEntity(level, pos, direction);
            if (adjBe == null) continue;
            Direction adjBeSide = direction.m_122424_();
            if (molecular) {
                ICraftingMachine craftingMachine = ICraftingMachine.of((Level)level, (BlockPos)pos.m_121945_(direction), (Direction)adjBeSide, (BlockEntity)adjBe);
                if (craftingMachine == null) continue;
                IPatternProviderLogic.PushResult result2 = this.gtolib$pushCraftingMachine(craftingMachine, patternDetails, inputHolder, pushPatternSuccess, adjBeSide);
                if (result2.success()) {
                    success.value = true;
                }
                if (!result2.needBreak()) continue;
                return result2;
            }
            if (adjBe instanceof MetaMachineBlockEntity) {
                ICustomCraftingMachine craftingMachine;
                MetaMachineBlockEntity machineBlockEntity = (MetaMachineBlockEntity)adjBe;
                MetaMachine metaMachine = machineBlockEntity.metaMachine;
                if (metaMachine instanceof ICustomCraftingMachine && (craftingMachine = (ICustomCraftingMachine)metaMachine).customPush()) {
                    result = craftingMachine.pushPattern((IPatternProviderLogic)this, this.actionSource, success, this::gtolib$pushTarget, this.patternInputs, patternDetails, inputHolder, pushPatternSuccess, canPush, direction, adjBeSide);
                    if (!result.needBreak()) continue;
                    return result;
                }
                PatternProviderTarget target = PatternProviderTargetCache.find((BlockEntity)adjBe, (IPatternProviderLogic)this, (Direction)adjBeSide, (IActionSource)this.actionSource, (long)0L);
                if (target == null || target.containsPatternInput(this.patternInputs)) continue;
                IPatternProviderLogic.PushResult result3 = this.gtolib$pushTarget(patternDetails, inputHolder, pushPatternSuccess, canPush, direction, target, true);
                if (result3.success()) {
                    success.value = true;
                }
                if (!result3.needBreak()) continue;
                return result3;
            }
            PatternProviderTarget target = this.findAdapter(direction);
            if (target == null || target.containsPatternInput(this.patternInputs)) continue;
            result = this.gtolib$pushTarget(patternDetails, inputHolder, pushPatternSuccess, canPush, direction, target, true);
            if (result.success()) {
                success.value = true;
            }
            if (!result.needBreak()) continue;
            return result;
        }
        return success.value ? IPatternProviderLogic.PushResult.SUCCESS : IPatternProviderLogic.PushResult.NOWHERE_TO_PUSH;
    }

    @Overwrite
    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        return false;
    }

    @Unique
    private IPatternProviderLogic.PushResult gtolib$pushCraftingMachine(ICraftingMachine craftingMachine, IPatternDetails patternDetails, ObjectHolder<KeyCounter[]> inputHolder, Supplier<IPatternProviderLogic.PushResult> pushPatternSuccess, Direction adjBeSide) {
        boolean success = false;
        while (inputHolder.value != null && craftingMachine.acceptsPlans() && craftingMachine.pushPattern(patternDetails, (KeyCounter[])inputHolder.value, adjBeSide)) {
            this.onPushPatternSuccess(patternDetails);
            success = true;
            IPatternProviderLogic.PushResult result = pushPatternSuccess.get();
            if (!result.needBreak()) continue;
            return result;
        }
        return success ? IPatternProviderLogic.PushResult.SUCCESS : IPatternProviderLogic.PushResult.REJECTED;
    }

    @Unique
    private IPatternProviderLogic.PushResult gtolib$pushTarget(IPatternDetails patternDetails, ObjectHolder<KeyCounter[]> inputHolder, Supplier<IPatternProviderLogic.PushResult> pushPatternSuccess, BooleanSupplier canPush, Direction direction, PatternProviderTarget adapter, boolean continuous) {
        int count = this.gtocore$pushedCount;
        boolean success = false;
        while (count > 0) {
            --count;
            if (inputHolder.value == null || !this.adapterAcceptsAll(adapter, (KeyCounter[])inputHolder.value)) break;
            patternDetails.pushInputsToExternalInventory((KeyCounter[])inputHolder.value, (what, amount) -> {
                long inserted = adapter.insert(what, amount, Actionable.MODULATE);
                if (inserted < amount) {
                    this.addToSendList(what, amount - inserted);
                }
            });
            if (adapter instanceof PatternProviderTargetCache.WrapMeStorage) {
                PatternProviderTargetCache.WrapMeStorage storage = (PatternProviderTargetCache.WrapMeStorage)adapter;
                if (storage.pos() != 0L) {
                    this.gtolib$cachePatternPos.put(storage.pos(), (Object)patternDetails);
                } else {
                    this.gtolib$cachePatternDir.put(storage.dir(), (Object)patternDetails);
                }
            }
            this.onPushPatternSuccess(patternDetails);
            success = true;
            this.sendDirection = direction;
            IPatternProviderLogic.PushResult result = pushPatternSuccess.get();
            if (result.needBreak()) {
                return result;
            }
            if (!canPush.getAsBoolean()) break;
            if (continuous) continue;
            return IPatternProviderLogic.PushResult.SUCCESS;
        }
        return success ? IPatternProviderLogic.PushResult.SUCCESS : IPatternProviderLogic.PushResult.REJECTED;
    }

    @Overwrite
    @Nullable
    private PatternProviderTarget findAdapter(Direction side) {
        if (this.gtolib$targetCaches[side.m_122411_()] == null) {
            this.gtolib$targetCaches[side.m_122411_()] = new PatternProviderTargetCache(this.host.getBlockEntity(), (IPatternProviderLogic)this, side, this.actionSource);
        }
        @Nullable PatternProviderTarget ret = this.gtolib$targetCaches[side.m_122411_()].find(side.m_122411_());
        return ret;
    }

    public BlockingType gtolib$getBlocking() {
        return (BlockingType)this.configManager.getSetting(GTOSettings.BLOCKING_TYPE);
    }

    public IPatternDetails gtolib$getCurrentPattern() {
        return this.gtolib$currentPattern;
    }

    public IPatternDetails gtolib$getCachePattern(long pos, int dir) {
        if (pos != 0L) {
            return (IPatternDetails)this.gtolib$cachePatternPos.get(pos);
        }
        return (IPatternDetails)this.gtolib$cachePatternDir.get(dir);
    }

    @Overwrite
    public void updatePatterns() {
        this.patterns.clear();
        this.patternInputs.clear();
        for (ItemStack stack : this.patternInventory) {
            IPatternDetails details = MyPatternDetailsHelper.decodePattern((ItemStack)stack, (BlockEntity)this.host.getBlockEntity(), (IGrid)this.mainNode.getGrid());
            if (details == null) continue;
            this.patterns.add(details);
            for (IPatternDetails.IInput iinput : details.getInputs()) {
                for (GenericStack inputCandidate : iinput.getPossibleInputs()) {
                    this.patternInputs.add(inputCandidate.what().dropSecondary());
                }
            }
        }
        ICraftingProvider.requestUpdate((IManagedGridNode)this.mainNode);
    }

    public GlobalPos gto$getPos() {
        if (this.gto$pos != null) {
            return this.gto$pos;
        }
        this.gto$pos = GlobalPos.m_122643_((ResourceKey)this.host.getBlockEntity().m_58904_().m_46472_(), (BlockPos)this.host.getBlockEntity().m_58899_());
        return this.gto$pos;
    }
}

