/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.mixin.adastra;

import com.gregtechceu.gtceu.GTCEu;
import com.gtolib.api.adastra.IAdDisplayTagName;
import com.gtolib.api.misc.PlanetManagement;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.client.components.LabeledImageButton;
import earth.terrarium.adastra.client.screens.PlanetsScreen;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.menus.PlanetsMenu;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlanetsScreen.class})
public abstract class PlanetsScreenMixin
extends AbstractContainerScreen<PlanetsMenu> {
    @Shadow(remap=false)
    @Nullable
    private ResourceLocation selectedSolarSystem;
    @Shadow(remap=false)
    @Final
    private List<Button> buttons;
    @Shadow(remap=false)
    private int pageIndex;
    @Shadow(remap=false)
    @Nullable
    private Planet selectedPlanet;
    @Shadow(remap=false)
    @Final
    public static ResourceLocation BUTTON;

    @Shadow(remap=false)
    protected abstract void close();

    protected PlanetsScreenMixin(PlanetsMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    @Inject(method={"land"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void land(ResourceKey<Level> dimension, CallbackInfo ci) {
        if (GTCEu.isDev()) {
            return;
        }
        boolean close = false;
        Player player = ((PlanetsMenu)this.m_6262_()).player();
        ResourceLocation planet = dimension.m_135782_();
        PlanetManagement.checkPlanetIsUnlocked((ResourceLocation)planet);
        if (!PlanetManagement.isClientUnlocked((ResourceLocation)planet)) {
            close = true;
            player.m_5661_((Component)Component.m_237115_((String)"gtocore.ununlocked"), false);
        }
        if (close) {
            this.close();
            ci.cancel();
        }
    }

    @Overwrite(remap=false)
    private void createPlanetButtons() {
        for (Planet planet : ((PlanetsMenu)this.f_97732_).getSortedPlanets()) {
            if (planet.isSpace() || !planet.solarSystem().equals((Object)this.selectedSolarSystem)) continue;
            ResourceLocation resourceLocation = planet.dimension().m_135782_();
            int tier = PlanetManagement.calculateTier((Planet)planet, (ResourceLocation)((PlanetsMenu)this.m_6262_()).player().m_9236_().m_46472_().m_135782_());
            if (((PlanetsMenu)this.f_97732_).tier() < tier) continue;
            PlanetManagement.checkPlanetIsUnlocked((ResourceLocation)resourceLocation);
            Button widget2 = (Button)this.m_7787_((GuiEventListener)new LabeledImageButton(10, 0, 99, 20, 0, 0, 20, BUTTON, 99, 40, b2 -> {
                this.pageIndex = 2;
                this.selectedPlanet = planet;
                this.m_232761_();
            }, ((PlanetsMenu)this.f_97732_).getPlanetName(planet.dimension())));
            widget2.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"ars_nouveau.tier", (Object[])new Object[]{tier}).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)(PlanetManagement.isClientUnlocked((ResourceLocation)resourceLocation) ? "gtocore.unlocked" : "gtocore.ununlocked")))));
            this.buttons.add(widget2);
        }
    }

    @Overwrite(remap=false)
    public Tooltip getSpaceStationRecipeTooltip(ResourceKey<Level> planet) {
        ArrayList<Object> tooltip = new ArrayList<Object>();
        BlockPos pos = ((PlanetsMenu)this.f_97732_).getLandingPos(planet, false);
        tooltip.add(Component.m_237110_((String)"tooltip.ad_astra.construct_space_station_at", (Object[])new Object[]{((PlanetsMenu)this.f_97732_).getPlanetName(planet), pos.m_123341_(), pos.m_123343_()}).m_130940_(ChatFormatting.AQUA));
        if (!((PlanetsMenu)this.f_97732_).isInSpaceStation(planet) && !((PlanetsMenu)this.f_97732_).isClaimed(planet)) {
            tooltip.add(ConstantComponents.CONSTRUCTION_COST.m_6881_().m_130940_(ChatFormatting.AQUA));
            List ingredients = (List)((IAdDisplayTagName)this.f_97732_).gtocore$getAdastraDisplayTagNames().get(planet);
            if (ingredients != null) {
                long gameTime = ((PlanetsMenu)this.f_97732_).player().m_9236_().m_46467_();
                for (IAdDisplayTagName.CountIngredient ingredient : ingredients) {
                    MutableComponent need = Component.m_237119_();
                    Ingredient.Value[] values = ingredient.ingredient().f_43902_;
                    int displayWhich = Math.toIntExact(gameTime / 100L % (long)values.length);
                    Ingredient.Value value = values[displayWhich];
                    if (value instanceof Ingredient.TagValue) {
                        Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                        tagTranslationKey = PlanetsScreenMixin.gtocore$getTagTranslationKey(ResourceLocation.parse((String)tagValue.m_6544_().get("tag").getAsString()));
                        if (tagTranslationKey != null) {
                            need.m_7220_((Component)Component.m_237115_((String)tagTranslationKey).m_130940_(ChatFormatting.DARK_AQUA));
                        } else {
                            need.m_7220_((Component)Component.m_237110_((String)"tooltip.ad_astra.unknown_tag", (Object[])new Object[]{tagValue.m_6544_().get("tag")}).m_130940_(ChatFormatting.RED));
                        }
                    } else {
                        tagTranslationKey = values[displayWhich];
                        if (tagTranslationKey instanceof Ingredient.ItemValue) {
                            Ingredient.ItemValue itemValue = (Ingredient.ItemValue)tagTranslationKey;
                            need.m_7220_((Component)((ItemStack)itemValue.m_6223_().stream().toList().get(0)).m_41786_().m_6881_().m_130940_(ChatFormatting.DARK_AQUA));
                        } else {
                            need.m_7220_((Component)Component.m_237115_((String)"tooltip.ad_astra.unknown_ingredient").m_130940_(ChatFormatting.RED));
                        }
                    }
                    int howMuch = ingredient.holderCount();
                    int amountOwned = ingredient.count();
                    boolean hasEnough = ((PlanetsMenu)this.f_97732_).player().m_7500_() || ((PlanetsMenu)this.f_97732_).player().m_5833_() || amountOwned >= howMuch;
                    tooltip.add(Component.m_237110_((String)"tooltip.ad_astra.requirement", (Object[])new Object[]{amountOwned, howMuch, need.m_130940_(ChatFormatting.DARK_AQUA)}).m_6881_().m_130940_(hasEnough ? ChatFormatting.GREEN : ChatFormatting.RED));
                }
            }
        } else {
            tooltip.add(ConstantComponents.SPACE_STATION_ALREADY_EXISTS);
        }
        return Tooltip.m_257550_((Component)CommonComponents.m_178391_(tooltip));
    }

    @Unique
    @Nullable
    private static String gtocore$getTagTranslationKey(ResourceLocation location) {
        String s = PlanetsScreenMixin.gtocore$translatePrefix("tag.item.", location);
        if (s != null) {
            return s;
        }
        return PlanetsScreenMixin.gtocore$translatePrefix("tag.", location);
    }

    @Unique
    @Nullable
    private static String gtocore$translatePrefix(String prefix, ResourceLocation id) {
        String s = EmiUtil.translateId((String)prefix, (ResourceLocation)id);
        if (I18n.m_118936_((String)s)) {
            return s;
        }
        if (id.m_135827_().equals("forge") && I18n.m_118936_((String)(s = EmiUtil.translateId((String)prefix, (ResourceLocation)EmiPort.id((String)"c", (String)id.m_135815_()))))) {
            return s;
        }
        return null;
    }
}

