/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.integration.jade.provider;

import com.fast.fastcollection.O2LOpenCustomCacheHashMap;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.integration.jade.GTElementHelper;
import com.gregtechceu.gtceu.integration.jade.provider.CapabilityBlockProvider;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtolib.api.machine.feature.multiblock.ICrossRecipeMachine;
import com.gtolib.api.recipe.ContentBuilder;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.SeparateContent;
import com.gtolib.api.recipe.ingredient.FastFluidIngredient;
import com.gtolib.utils.FluidUtils;
import com.gtolib.utils.GTOUtils;
import com.gtolib.utils.ItemUtils;
import it.unimi.dsi.fastutil.objects.Object2LongOpenCustomHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.IElementHelper;

public final class RecipeOutputProvider
extends CapabilityBlockProvider<RecipeLogic> {
    public RecipeOutputProvider() {
        super(GTCEu.id((String)"recipe_output_info"));
    }

    @Nullable
    protected RecipeLogic getCapability(Level level, BlockPos pos, BlockEntity blockEntity, @Nullable Direction side) {
        return GTCapabilityHelper.getRecipeLogic((BlockEntity)blockEntity);
    }

    protected void write(CompoundTag data, RecipeLogic recipeLogic) {
        if (recipeLogic.isWorking()) {
            ICrossRecipeMachine recipeMachine;
            data.m_128379_("Working", recipeLogic.isWorking());
            if (recipeLogic.machine.getRecipeType() == GTORecipeTypes.RANDOM_ORE_RECIPES) {
                return;
            }
            O2LOpenCustomCacheHashMap items = new O2LOpenCustomCacheHashMap(ContentBuilder.HASH_STRATEGY);
            O2LOpenCustomCacheHashMap fluids = new O2LOpenCustomCacheHashMap(ContentBuilder.HASH_STRATEGY);
            IRecipeLogicMachine iRecipeLogicMachine = recipeLogic.machine;
            if (iRecipeLogicMachine instanceof ICrossRecipeMachine && !(recipeMachine = (ICrossRecipeMachine)iRecipeLogicMachine).getThreads().isEmpty()) {
                recipeMachine.getThreads().forEach(arg_0 -> RecipeOutputProvider.lambda$write$0((Object2LongOpenCustomHashMap)items, (Object2LongOpenCustomHashMap)fluids, arg_0));
            } else {
                GTRecipe recipe = recipeLogic.getLastRecipe();
                if (recipe == null) {
                    return;
                }
                for (Content content : recipe.outputs.getOrDefault(ItemRecipeCapability.CAP, Collections.emptyList())) {
                    items.addTo((Object)new SeparateContent(content.content, content.chance, content.tierChanceBoost, recipe.parallels), ItemUtils.getSizedAmount((Ingredient)((Ingredient)ItemRecipeCapability.CAP.of(content.content))));
                }
                for (Content content : recipe.outputs.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList())) {
                    fluids.addTo((Object)new SeparateContent(content.content, content.chance, content.tierChanceBoost, recipe.parallels), FastFluidIngredient.getAmount((FluidIngredient)((FluidIngredient)FluidRecipeCapability.CAP.of(content.content))));
                }
            }
            if (!items.isEmpty()) {
                ListTag itemTags = new ListTag();
                items.object2LongEntrySet().forEach(entry -> {
                    CompoundTag nbt = new CompoundTag();
                    Ingredient ingredient = (Ingredient)ItemRecipeCapability.CAP.of(((SeparateContent)entry.getKey()).content);
                    ItemStack stack = ItemUtils.getFirstSized((Ingredient)ingredient);
                    if (stack.m_41619_()) {
                        return;
                    }
                    nbt.m_128356_("p", ((SeparateContent)entry.getKey()).parallel);
                    nbt.m_128405_("c", ((SeparateContent)entry.getKey()).chance);
                    nbt.m_128359_("id", ItemUtils.getId((ItemStack)stack));
                    nbt.m_128356_("a", entry.getLongValue());
                    if (stack.m_41782_()) {
                        nbt.m_128365_("tag", (Tag)stack.m_41783_());
                    }
                    itemTags.add((Object)nbt);
                });
                data.m_128365_("OutputItems", (Tag)itemTags);
            }
            if (!fluids.isEmpty()) {
                ListTag fluidTags = new ListTag();
                fluids.object2LongEntrySet().forEach(entry -> {
                    CompoundTag nbt = new CompoundTag();
                    FluidIngredient ingredient = (FluidIngredient)FluidRecipeCapability.CAP.of(((SeparateContent)entry.getKey()).content);
                    FluidStack[] stacks = FastFluidIngredient.getFluidStack((Object)ingredient);
                    if (stacks.length == 0 || stacks[0].isEmpty()) {
                        return;
                    }
                    nbt.m_128356_("p", ((SeparateContent)entry.getKey()).parallel);
                    nbt.m_128405_("c", ((SeparateContent)entry.getKey()).chance);
                    nbt.m_128359_("FluidName", FluidUtils.getId((Fluid)stacks[0].getFluid()));
                    nbt.m_128356_("a", entry.getLongValue());
                    if (stacks[0].getTag() != null) {
                        nbt.m_128365_("tag", (Tag)stacks[0].getTag());
                    }
                    fluidTags.add((Object)nbt);
                });
                data.m_128365_("OutputFluids", (Tag)fluidTags);
            }
        }
    }

    protected void addTooltip(CompoundTag capData, ITooltip tooltip, Player player, BlockAccessor block, BlockEntity blockEntity, IPluginConfig config) {
        if (capData.m_128471_("Working")) {
            ListTag itemTags;
            ArrayList<CompoundTag> outputItems = new ArrayList<CompoundTag>();
            if (capData.m_128425_("OutputItems", 9) && !(itemTags = capData.m_128437_("OutputItems", 10)).isEmpty()) {
                for (Tag tag : itemTags) {
                    if (!(tag instanceof CompoundTag)) continue;
                    CompoundTag tCompoundTag = (CompoundTag)tag;
                    outputItems.add(tCompoundTag);
                }
            }
            ArrayList<CompoundTag> outputFluids = new ArrayList<CompoundTag>();
            if (capData.m_128425_("OutputFluids", 9)) {
                ListTag fluidTags = capData.m_128437_("OutputFluids", 10);
                for (Tag tag : fluidTags) {
                    if (!(tag instanceof CompoundTag)) continue;
                    CompoundTag tCompoundTag = (CompoundTag)tag;
                    outputFluids.add(tCompoundTag);
                }
            }
            if (!outputItems.isEmpty() || !outputFluids.isEmpty()) {
                tooltip.add((Component)Component.m_237115_((String)"gtceu.top.recipe_output"));
            }
            RecipeOutputProvider.addItemTooltips(tooltip, outputItems);
            RecipeOutputProvider.addFluidTooltips(tooltip, outputFluids);
        }
    }

    private static void addItemTooltips(ITooltip iTooltip, List<CompoundTag> outputItems) {
        IElementHelper helper = iTooltip.getElementHelper();
        for (CompoundTag tag : outputItems) {
            if (tag == null || tag.m_128456_()) continue;
            ItemStack stack = GTOUtils.loadItemStack((CompoundTag)tag);
            int chance = tag.m_128451_("c");
            boolean estimated = chance < ContentBuilder.maxChance;
            long count = tag.m_128454_("a");
            if (estimated) {
                count = Math.max(1L, count * tag.m_128454_("p") * (long)chance / (long)ContentBuilder.maxChance);
            }
            iTooltip.add(helper.smallItem(stack));
            MutableComponent text = Component.m_237113_((String)" ").m_130946_((estimated ? "~" : "") + count).m_130946_("\u00d7 ").m_7220_(RecipeOutputProvider.getItemName(stack)).m_130940_(ChatFormatting.WHITE);
            iTooltip.append((Component)text);
        }
    }

    private static void addFluidTooltips(ITooltip iTooltip, List<CompoundTag> outputFluids) {
        for (CompoundTag tag : outputFluids) {
            if (tag == null || tag.m_128456_()) continue;
            FluidStack stack = GTOUtils.loadFluidStack((CompoundTag)tag);
            int chance = tag.m_128451_("c");
            boolean estimated = chance < ContentBuilder.maxChance;
            long count = tag.m_128454_("a");
            if (estimated) {
                count = Math.max(1L, count * tag.m_128454_("p") * (long)chance / (long)ContentBuilder.maxChance);
            }
            iTooltip.add(GTElementHelper.smallFluid((JadeFluidObject)RecipeOutputProvider.getFluid(stack)));
            MutableComponent text = Component.m_237113_((String)" ").m_130946_((estimated ? "~" : "") + FluidUtils.getUnicodeMillibuckets((long)count)).m_130946_(" ").m_7220_(RecipeOutputProvider.getFluidName(stack)).m_130940_(ChatFormatting.WHITE);
            iTooltip.append((Component)text);
        }
    }

    private static Component getItemName(ItemStack stack) {
        return stack.m_41611_().m_6881_().m_130940_(ChatFormatting.WHITE);
    }

    private static Component getFluidName(FluidStack stack) {
        return ComponentUtils.m_130748_((Component)stack.getDisplayName()).m_130940_(ChatFormatting.WHITE);
    }

    private static JadeFluidObject getFluid(FluidStack stack) {
        return JadeFluidObject.of((Fluid)stack.getFluid(), (long)stack.getAmount());
    }

    private static /* synthetic */ void lambda$write$0(Object2LongOpenCustomHashMap items, Object2LongOpenCustomHashMap fluids, ICrossRecipeMachine.Thread t) {
        Recipe recipe = t.getRecipe();
        for (Content content : recipe.outputs.getOrDefault(ItemRecipeCapability.CAP, Collections.emptyList())) {
            items.addTo((Object)new SeparateContent(content.content, content.chance, content.tierChanceBoost, recipe.parallels), ItemUtils.getSizedAmount((Ingredient)((Ingredient)ItemRecipeCapability.CAP.of(content.content))));
        }
        for (Content content : recipe.outputs.getOrDefault(FluidRecipeCapability.CAP, Collections.emptyList())) {
            fluids.addTo((Object)new SeparateContent(content.content, content.chance, content.tierChanceBoost, recipe.parallels), FastFluidIngredient.getAmount((FluidIngredient)((FluidIngredient)FluidRecipeCapability.CAP.of(content.content))));
        }
    }
}

